# Что такое Vuex?

<VideoPreview />

Vuex — **паттерн управления состоянием + библиотека** для приложений на Vue.js. Он служит централизованным хранилищем данных для всех компонентов приложения с правилами, гарантирующими, что состояние может быть изменено только предсказуемым образом. Vuex интегрируется с официальным расширением [vue-devtools](https://github.com/vuejs/vue-devtools), предоставляя «из коробки» такие продвинутые возможности, как «машину времени» для отладки и экспорт/импорт слепков состояния данных.

## Что такое «паттерн управления состоянием»?

Давайте начнём с простого приложения Vue, реализующего счётчик:

```js
new Vue({
  // состояние
  data() {
    return {
      count: 0
    };
  },
  // представление
  template: `
    <div>{{ count }}</div>
  `,
  // действия
  methods: {
    increment() {
      this.count++;
    }
  }
});
```

Это самостоятельное приложение состоит из следующих частей:

* **Состояние** — «источник истины», управляющий приложением;
* **Представление** — отображение **состояния** заданное декларативно;
* **Действия** — возможные пути изменения состояния приложения в ответ на взаимодействие пользователя с **представлением**.

Вот простейшее представление концепции «однонаправленного потока данных»:

<p style="text-align: center; margin: 2em">
  <img style="width:100%;max-width:450px;" src="/ru/flow.png">
</p>

Однако простота быстро исчезает, когда у нас появляется **нескольких компонентов, основывающихся на одном и том же состоянии**:

* Несколько представлений могут зависеть от одной и той же части состояния приложения.
* Действия из разных представлений могут оказывать влияние на одни и те же части состояния приложения.

Решая первую проблему, придётся передавать одни и те же данные входными параметрами в глубоко вложенные компоненты. Это часто сложно и утомительно, а для соседних компонентов такое и вовсе не сработает. Решая вторую проблему, можно прийти к таким решениям, как обращение по ссылкам к родительским/дочерним экземплярам или попыткам изменять и синхронизировать несколько копий состояния через события. Оба подхода хрупки и быстро приводят к появлению кода, который невозможно поддерживать.

Так почему бы не вынести всё общее состояние приложения из компонентов и управлять им в глобальном синглтоне? При этом наше дерево компонентов становится одним большим «представлением», и любой компонент может получить доступ к состоянию приложения или вызывать действия для изменения состояния, независимо от того, где они находятся в дереве!

Чётко определяя и разделяя концепции, возникающие при управлении состоянием, и требуя соблюдения определённых правил, которые поддерживают независимость между представлениями и состояниями, мы лучше структурируем код и облегчаем его поддержку.

Это основная идея Vuex, вдохновлённого [Flux](https://facebook.github.io/flux/docs/overview), [Redux](http://redux.js.org/) и [Архитектурой Elm](https://guide.elm-lang.org/architecture/). В отличие от других паттернов, Vuex реализован в виде библиотеки, специально предназначенной для Vue.js, чтобы использовать его систему реактивности для эффективного обновления.

Если хотите изучить Vuex в интерактивном режиме, попробуйте этот [курс по Vuex на Scrimba.](https://scrimba.com/g/gvuex)

![vuex](/ru/vuex.png)

## Когда следует использовать Vuex?

Vuex помогает управлять совместно используемым состоянием ценой привнесения новых концепций и вспомогательного кода. Компромисс, когда кратковременная продуктивность страдает на благо долгосрочной.

Если ещё не приходилось создавать крупные SPA и вы лишь знакомитесь с Vuex, это может показаться многословным и сложным. Всё в порядке — простые приложения могут легко обходиться и без Vuex. Возможно, будет достаточно простого паттерна [глобальной шины событий](https://ru.vuejs.org/v2/guide/state-management.html#Простой-контейнер-состояния-с-нуля). Но если вы создаёте SPA среднего или крупного размера, то, скорее всего, уже сталкивались с ситуациями, которые заставляли задуматься о том, как лучше управлять состоянием вне компонентов Vue, а Vuex в таком случае может стать вполне естественным следующим шагом. Есть хорошая цитата от Дэна Абрамова, автора Redux:

> Flux-библиотеки похожи на очки: вы будете точно знать, когда они вам понадобятся.
