"""Convert AMI data in CSV to an CEUS GLM object
"""
import pandas

def convert(input_file, output_file, options={}):
    optdata = ""
    for opt, arg in options.items():
        optdata += f"\t{opt} \"{arg}\";\n"
    with open(output_file,"w") as glm:
        glm.write("""
// generated by csv-ceus2glm-ceus.py
object ceus {
    filename "%s";
    total_real_power "0.0";
    total_reactive_power "0.0";
    total_power_A "0+0i";
    total_power_B "0+0i";
    total_power_C "0+0i";
%s}
""" % (input_file,optdata))