"""Convert SCADA data in CSV to an CEUS GLM object
"""
import pandas

def convert(input_file, output_file, options={}):
    with open(output_file,"w") as glm:
        glm.write("""
// generated by csv-scada2glm-ceus.py
object ceus {
    floor_area "0.0";
    filename "%s";
    total_real_power "0.0";
    total_reactive_power "0.0";
    total_power_A "0+0i";
    total_power_B "0+0i";
    total_power_C "0+0i";
    weather "";
    tariff "";
}
""" % input_file)