import { Component, OnInit } from '@angular/core';

import { UserService } from '../../models/user/user.service';

@Component({
    selector: 'app-home',
    styleUrls: ['./home.component.scss'],
    templateUrl: './home.component.html',
})
export class HomeComponent implements OnInit {

    public isLoggedIn = false;

    constructor(private userService: UserService) { }

    public ngOnInit() {
        this.isLoggedIn = !!UserService.user;
        UserService.userChangeEvent.subscribe((user) => {
            this.isLoggedIn = !!user;
        });
    }

    public authCharacter() {
        this.userService.ssoLogin();
    }
}
