'use strict';
//convert 'cute' to 'cuteness'
const irregulars = {
  clean: 'cleanliness',
  naivety: 'naivety',
  hurt: 'hurt'
};

const transforms = [
  {
    reg: /y$/,
    repl: 'iness'
  },
  {
    reg: /le$/,
    repl: 'ility'
  },
  {
    reg: /ial$/,
    repl: 'y'
  },
  {
    reg: /al$/,
    repl: 'ality'
  },
  {
    reg: /ting$/,
    repl: 'ting'
  },
  {
    reg: /ring$/,
    repl: 'ring'
  },
  {
    reg: /bing$/,
    repl: 'bingness'
  },
  {
    reg: /sing$/,
    repl: 'se'
  },
  {
    reg: /ing$/,
    repl: 'ment'
  },
  {
    reg: /ess$/,
    repl: 'essness'
  },
  {
    reg: /ous$/,
    repl: 'ousness'
  }
];

const to_noun = function(w) {
  if (irregulars.hasOwnProperty(w)) {
    return irregulars[w];
  }
  const lastChar = w.charAt(w.length - 1);
  if (lastChar === 'w' || lastChar === 's') {
    return null;
  }
  for (let i = 0; i < transforms.length; i++) {
    if (transforms[i].reg.test(w) === true) {
      return w.replace(transforms[i].reg, transforms[i].repl);
    }
  }
  return w + 'ness';
};

module.exports = to_noun;
// console.log(to_noun("great"))
