'use strict';
const Text = require('../../text');
const getGrams = require('./getGrams');

const sort = function(r) {
  r.list = r.list.sort((a, b) => {
    if (a.count > b.count) {
      return -1;
    }
    //(tie-braker)
    if (a.count === b.count && (a.size > b.size || a.key.length > b.key.length)) {
      return -1;
    }
    return 1;
  });
  return r;
};

//the Ngrams() subset class
const methods = {
  data: function() {
    return this.list.map(ts => {
      return {
        normal: ts.out('normal'),
        count: ts.count,
        size: ts.size
      };
    });
  },
  unigrams: function() {
    this.list = this.list.filter(g => g.size === 1);
    return this;
  },
  bigrams: function() {
    this.list = this.list.filter(g => g.size === 2);
    return this;
  },
  trigrams: function() {
    this.list = this.list.filter(g => g.size === 3);
    return this;
  },
  //default sort the ngrams
  sort: function() {
    return sort(this);
  }
};

const find = function(r, obj) {
  let sizes = [];
  //support .ngrams(3), for compat
  if (typeof obj === 'number') {
    obj = {
      n: obj
    };
  }
  obj = obj || {};
  let max = obj.max || 4;
  for (let i = 1; i <= max; i++) {
    sizes.push(i);
  }
  //only look for bigrams, for example
  if (obj.size) {
    sizes = [obj.size];
  }
  let opts = {
    size: sizes
  };
  //fetch them
  let arr = getGrams(r, opts);
  r = new Text(arr);
  //default sort
  r = sort(r);
  //grab top one, or something
  if (obj.n !== undefined) {
    r = r.get(obj.n);
  }
  return r;
};

module.exports = Text.makeSubset(methods, find);
