const numOrdinal = require('./numOrdinal');
const textOrdinal = require('./textOrdinal');
const textCardinal = require('./textCardinal');
const niceNumber = require('./niceNumber');

//make all the number formats
const fmt = {
  nice: function(num) {
    return niceNumber(num);
  },
  ordinal: function(num) {
    return numOrdinal(num);
  },
  cardinal: function(num) {
    return String(num);
  },
  niceOrdinal: function(num) {
    num = numOrdinal(num);
    num = niceNumber(num);
    return num;
  },
  text: function(num) {
    return textCardinal(num).join(' ');
  },
  textOrdinal: function(num) {
    return textOrdinal(num);
  }
};
module.exports = fmt;
