'use strict';
const Text = require('../../text');
const Value = require('./value');
const parse = require('./parse');

//the Values() subset class
const methods = {
  noDates: function() {
    return this.not('#Date');
  },
  noUnits: function() {
    return this.not('#Unit');
  },
  units: function() {
    return this.match('#Unit+');
  },
  /** five -> 5 */
  numbers: function() {
    return this.list.map(ts => {
      return ts.number();
    });
  },
  /** five -> '5' */
  toNumber: function() {
    this.list = this.list.map(ts => {
      return ts.toNumber();
    });
    return this;
  },
  /**5 -> 'five' */
  toText: function() {
    this.list = this.list.map(ts => {
      return ts.toText();
    });
    return this;
  },
  /**5th -> 5 */
  toCardinal: function() {
    this.list = this.list.map(ts => {
      return ts.toCardinal();
    });
    return this;
  },
  /**5 -> 5th */
  toOrdinal: function() {
    this.list = this.list.map(ts => {
      return ts.toOrdinal();
    });
    return this;
  },
  /**5900 -> 5,900 */
  toNice: function() {
    this.list = this.list.map(ts => {
      return ts.toNice();
    });
    return this;
  },
  /**seven === 7th */
  isEqual: function(num) {
    num = parse(num);
    this.list = this.list.filter(ts => {
      return num !== null && ts.number() === num;
    });
    return this;
  },
  /**eight > 7th */
  greaterThan: function(num) {
    num = parse(num);
    this.list = this.list.filter(ts => {
      return num !== null && ts.number() > num;
    });
    return this;
  },
  /**five < 7th */
  lessThan: function(num) {
    num = parse(num);
    this.list = this.list.filter(ts => {
      return num !== null && ts.number() < num;
    });
    return this;
  },
  between: function(min, max) {
    if (min === undefined || max === undefined) {
      return this;
    }
    min = parse(min);
    max = parse(max);
    this.list = this.list.filter(ts => {
      let n = ts.number();
      return n > min && n < max;
    });
    return this;
  },
  /**seven + 2 = 'nine' */
  add: function(n) {
    this.list = this.list.map(ts => {
      return ts.add(n);
    });
    return this;
  },
  /**seven - 2 = 'five' */
  subtract: function(n) {
    this.list = this.list.map(ts => {
      return ts.subtract(n);
    });
    return this;
  },
  /**seven -> 'eight' */
  increment: function() {
    this.list = this.list.map(ts => {
      return ts.add(1);
    });
    return this;
  },
  /**seven -> 'eight' */
  decrement: function() {
    this.list = this.list.map(ts => {
      return ts.subtract(1);
    });
    return this;
  }
};

const find = function(r, n) {
  const tens = 'twenty|thirty|forty|fifty|sixty|seventy|eighty|ninety|fourty';
  const teens = 'eleven|twelve|thirteen|fourteen|fifteen|sixteen|seventeen|eighteen|nineteen';
  r = r.match('#Value+ #Unit?');
  // r = r.match('#Value+ #Unit?');

  //"50 83"
  if (r.has('#NumericValue #NumericValue')) {
    //a comma may mean two numbers
    if (r.has('#Value #Comma #Value')) {
      r.splitAfter('#Comma');
    } else {
      r.splitAfter('#NumericValue');
    }
  }
  //three-length
  if (r.has('#Value #Value #Value') && !r.has('#Multiple')) {
    //twenty-five-twenty
    if (r.has('(' + tens + ') #Cardinal #Cardinal')) {
      r.splitAfter('(' + tens + ') #Cardinal');
    }
  }

  //two-length ones
  if (r.has('#Value #Value')) {
    //june 21st 1992 is two seperate values
    if (r.has('#NumericValue #NumericValue')) {
      r.splitOn('#Year');
    }
    //sixty fifteen
    if (r.has('(' + tens + ') (' + teens + ')')) {
      r.splitAfter('(' + tens + ')');
    }
    //"72 82"
    let double = r.match('#Cardinal #Cardinal');
    if (double.found && !r.has('(point|decimal)')) {
      //not 'two hundred'
      if (!double.has('#Cardinal (#Multiple|point|decimal)')) {
        //one proper way, 'twenty one', or 'hundred one'
        if (!double.has('(' + tens + ') #Cardinal') && !double.has('#Multiple #Value')) {
          r.splitAfter(double.terms(0).out('normal'));
        }
      }
    }
    //seventh fifth
    if (r.match('#Ordinal #Ordinal').match('#TextValue').found && !r.has('#Multiple')) {
      //the one proper way, 'twenty first'
      if (!r.has('(' + tens + ') #Ordinal')) {
        r.splitAfter('#Ordinal');
      }
    }
    //fifth five
    if (r.has('#Ordinal #Cardinal')) {
      r.splitBefore('#Cardinal+');
    }
    //five 2017 (support '5 hundred', and 'twenty 5'
    if (
      r.has('#TextValue #NumericValue') &&
      !r.has('(' + tens + '|#Multiple)')
    ) {
      r.splitBefore('#NumericValue+');
    }
  }
  //5-8
  if (r.has('#NumberRange')) {
    r.splitAfter('#NumberRange');
  }
  if (typeof n === 'number') {
    r = r.get(n);
  }
  let world = r.world();
  r.list = r.list.map(ts => {
    return new Value(ts.terms, world, ts.refText, ts.refTerms);
  });
  return r;
};

module.exports = Text.makeSubset(methods, find);
