'use strict';
const rules = require('./data/rules');
const mapping = {
  pr: 'PresentTense',
  pa: 'PastTense',
  gr: 'Gerund',
  prt: 'Participle',
  ar: 'Actor',
};
const keys = Object.keys(mapping);

//check suffix rules
const suffixPass = function(inf) {
  let found = {};
  for(let i = 0; i < rules.length; i++) {
    if (rules[i].reg.test(inf) === true) {
      let obj = rules[i].repl;
      for(let o = 0; o < keys.length; o++) {
        if (obj.hasOwnProperty(keys[o]) === true) {
          let key = mapping[keys[o]];
          // console.log(rules[i]);
          found[key] = inf.replace(rules[i].reg, obj[keys[o]]);
        }
      }
      return found;
    }
  }
  return found;
};

module.exports = suffixPass;
