'use strict';
const normalize = require('../term/methods/normalize/normalize').normalize;
const inflect = require('../subset/nouns/methods/pluralize');
const conjugate = require('../subset/verbs/methods/conjugate/faster.js');
const adjFns = require('../subset/adjectives/methods');
const wordReg = / /;


const cleanUp = function(str) {
  str = normalize(str);
  //extra whitespace
  str = str.replace(/\s+/, ' ');
  //remove sentence-punctuaion too
  str = str.replace(/[.\?,;\!]/g, '');
  return str;
};

//
const addWords = function(words) {
  //go through each word
  Object.keys(words).forEach((word) => {
    let tag = words[word];
    word = cleanUp(word);
    this.words[word] = tag;
    //add it to multi-word cache,
    if (wordReg.test(word) === true) {
      let arr = word.split(wordReg);
      this.cache.firstWords[arr[0]] = true;
    }

    //turn singulars into plurals
    if (tag === 'Singular') {
      let plural = inflect(word, {});
      if (plural && plural !== word) {
        this.words[plural] = 'Plural';
      }
      return;
    }
    //turn infinitives into all conjugations
    if (tag === 'Infinitive') {
      let conj = conjugate(word, this);
      Object.keys(conj).forEach((k) => {
        this.words[conj[k]] = k;
      });
      return;
    }
    //phrasals like 'pull out' get conjugated too
    if (tag === 'PhrasalVerb') {
      let arr = word.split(/ /);
      let conj = conjugate(arr[0], this);
      Object.keys(conj).forEach((k) => {
        let form = conj[k] + ' ' + arr[1];
        this.words[form] = 'PhrasalVerb';
        //add it to cache, too
        this.cache.firstWords[conj[k]] = true;
      });
      return;
    }
    //turn some adjectives into superlatives
    if (tag === 'Comparable') {
      let comp = adjFns.toComparative(word);
      if (comp && word !== comp) {
        this.words[comp] = 'Comparative';
      }
      let supr = adjFns.toSuperlative(word);
      if (supr && word !== supr) {
        this.words[supr] = 'Superlative';
      }
    }
  });

  return words;
};
module.exports = addWords;
