package nsq

import (
	"testing"

	"github.com/influxdb/telegraf/testutil"
	"github.com/stretchr/testify/require"
)

func TestConnectAndWrite(t *testing.T) {
	if testing.Short() {
		t.Skip("Skipping integration test in short mode")
	}

	server := []string{testutil.GetLocalHost() + ":4150"}
	n := &NSQ{
		Server: server[0],
		Topic:  "telegraf",
	}

	// Verify that we can connect to the NSQ daemon
	err := n.Connect()
	require.NoError(t, err)

	// Verify that we can successfully write data to the NSQ daemon
	err = n.Write(testutil.MockBatchPoints().Points())
	require.NoError(t, err)
}
