package knf.kuma.directory.viewholders;

import android.view.View;

import com.google.android.material.tabs.TabLayout;

import androidx.fragment.app.FragmentManager;
import androidx.viewpager.widget.ViewPager;
import butterknife.BindView;
import butterknife.ButterKnife;
import knf.kuma.BottomFragment;
import knf.kuma.R;
import knf.kuma.directory.DirPagerAdapter;

public class DirMainFragmentHolder {
    @BindView(R.id.tabs)
    TabLayout tabLayout;
    @BindView(R.id.pager)
    ViewPager pager;
    private DirPagerAdapter adapter;

    public DirMainFragmentHolder(View view, FragmentManager manager) {
        ButterKnife.bind(this,view);
        pager.setOffscreenPageLimit(3);
        adapter=new DirPagerAdapter(manager);
        pager.setAdapter(adapter);
        tabLayout.setupWithViewPager(pager);
    }

    public void onChangeOrder(){
        adapter.onChangeOrder();
    }

    public void onReselect(){
        ((BottomFragment)adapter.getItem(pager.getCurrentItem())).onReselect();
    }
}
