## Version 2.3.0-M2

_2020 November 6_ 🍂

Added support for Scala/Dotty 3.0.0-M1.

### Other improvements

* #3661 fix typo in Scaladoc by @fixxer 
* #3666, #3667 add `simulacrum-scalafix-annotations` to the classpath, build for 3.0.0-M1 by @djspiewak

## Version 2.3.0-M1

_2020 October 31_ 🎃

The purpose of this milestone is that adventurous users can try out first-class Dotty support before we cut a final 2.3.0 release. Note that for the Dotty builds, binary compatibility between this milestone release and 2.3.0 may break in some situations. Also, if you are using the laws, sbt may complain about conflicting Scala version suffixes. This will be fixed in time for the final release.

### Changes & additions

* #3603 `distinct` for `TraverseFilter` by @takayahilton
* #3620, #3624 instances for `immutable.Seq` by @JosephMoniz
* #3630 methods to narrow input/widen output types on `FunctionK` by @bplommer
* #3636 Dotty support by @LukaJCB and @larsrh
* #3647 `traverseTap` by @majk-p
* #3648 add a law relating `defer` and `fix` in `Defer` by @johnynek

### Other improvements

* #3373 test for `zipWithIndex` stack safety by @dantb
* #3595 migrate from tut to mdoc by @keynmol
* #3608 document `scalafixAll` to migrate test code as well by @bjaglin
* #3609 Cats ecosystem website by @benkio
* #3616 documentation on `ApplicativeError` by @dhinojosa
* #3616 documentation on `Writer` and `WriterT` by @benkio

## Version 2.2.0

_2020 September 3_

### 3 API / feature enhancements

* [#3566](https://github.com/typelevel/cats/pull/3566) Scalafix rule to remove instance imports when upgrading to 2.2.0  by @cb372
* [#3579](https://github.com/typelevel/cats/pull/3579) Add `toValidated` to TrySyntax  by @gagandeepkalra
* [#3576](https://github.com/typelevel/cats/pull/3576) Remove unused private method  by @takayahilton

### 3 documentation improvements

* [#3586](https://github.com/typelevel/cats/pull/3586) Fix typo in FoldableTests (constistency -> consistency)  by @tmccarthy
* [#3581](https://github.com/typelevel/cats/pull/3581) Add monix-bio to related projects  by @Avasil
* [#3580](https://github.com/typelevel/cats/pull/3580) Add Parallel typeclass diagram to docs.  by @izeigerman

### 5 build improvements

* [#3591](https://github.com/typelevel/cats/pull/3591) Update sbt-scalafix to 0.9.20  by @scala-steward
* [#3589](https://github.com/typelevel/cats/pull/3589) Update discipline-munit to 0.2.4  by @scala-steward
* [#3588](https://github.com/typelevel/cats/pull/3588) Update munit-scalacheck to 0.7.12  by @scala-steward
* [#3585](https://github.com/typelevel/cats/pull/3585) Update sbt-dotty to 0.4.2  by @scala-steward
* [#3578](https://github.com/typelevel/cats/pull/3578) Update discipline-scalatest to 2.0.1  by @scala-steward

## Version 2.2.0-RC4

_2020 August 21_

### 2 API / feature enhancements

* [#3572](https://github.com/typelevel/cats/pull/3572) Add Future instances to implicit scope  by @travisbrown
* [#3573](https://github.com/typelevel/cats/pull/3573) Avoid all evaluation of NonEmptyLazyList#reduceRightTo  by @takayahilton

### 2 documentation improvements

* [#3575](https://github.com/typelevel/cats/pull/3575) Missing a "]" in CONTRIBUTING.md  by @benkio
* [#3574](https://github.com/typelevel/cats/pull/3574) Update README.md  by @diesalbla


## Version 2.2.0-RC3

_2020 August 15_

### 1 bug fix

* [#3565](https://github.com/typelevel/cats/pull/3565) Fix ReducibleLaws causing stack overflow by calling `Eval.now` early  by @bastewart


### 15 API / feature enhancements

* [#3569](https://github.com/typelevel/cats/pull/3569) Change AndThen to directly check isRightAssociated  by @johnynek
* [#3567](https://github.com/typelevel/cats/pull/3567) Avoid all evaluation of LazyList#foldRightDefer  by @takayahilton
* [#3560](https://github.com/typelevel/cats/pull/3560) Improve AndThen use of Single  by @johnynek
* [#3553](https://github.com/typelevel/cats/pull/3553) add ifElseM  by @mtomko
* [#3556](https://github.com/typelevel/cats/pull/3556) Order for writert  by @TimWSpence
* [#3527](https://github.com/typelevel/cats/pull/3527) Add toRightAssociated to AndThen  by @johnynek
* [#3555](https://github.com/typelevel/cats/pull/3555) Order for IorT  by @TimWSpence
* [#3554](https://github.com/typelevel/cats/pull/3554) Order for Ior  by @TimWSpence
* [#3540](https://github.com/typelevel/cats/pull/3540) Remove traverseForEither in Traverse companion object  by @LukaJCB
* [#3549](https://github.com/typelevel/cats/pull/3549) Enable breakout in Reducible[NonEmptyVector].reduceMapA  by @takayahilton
* [#3545](https://github.com/typelevel/cats/pull/3545) Enable breakout in functions nonEmptyTraverse_ and nonEmptySequence_  by @takayahilton
* [#3533](https://github.com/typelevel/cats/pull/3533) Improve invariants and performance in Chain  by @johnynek
* [#3535](https://github.com/typelevel/cats/pull/3535) Improve traverseViaChain API  by @johnynek
* [#3538](https://github.com/typelevel/cats/pull/3538) Preliminary Munit port  by @LukaJCB
* [#3528](https://github.com/typelevel/cats/pull/3528) Optimize toNonEmptyList of Reducible[NonEmptyChain]  by @takayahilton


### 4 documentation improvements

* [#3562](https://github.com/typelevel/cats/pull/3562) Comments on NonEmptyReducible not being a typeclass  by @akopich
* [#3537](https://github.com/typelevel/cats/pull/3537) add coulomb-cats to ecosystem list  by @erikerlandson
* [#3531](https://github.com/typelevel/cats/pull/3531) adding Hootsuite Inc. to the list of Adopters  by @jyoo980
* [#3526](https://github.com/typelevel/cats/pull/3526) Update README.md  by @Immozentral


### 11 build improvements

* [#3564](https://github.com/typelevel/cats/pull/3564) Remove redundant parentheses  by @barambani
* [#3561](https://github.com/typelevel/cats/pull/3561) Update munit-scalacheck to 0.7.11  by @scala-steward
* [#3558](https://github.com/typelevel/cats/pull/3558) Update sbt-doctest to 0.9.7  by @scala-steward
* [#3557](https://github.com/typelevel/cats/pull/3557) Update sbt-buildinfo to 0.10.0  by @scala-steward
* [#3546](https://github.com/typelevel/cats/pull/3546) Fix alleycats-tests on Scala.js  by @joroKr21
* [#3548](https://github.com/typelevel/cats/pull/3548) Test freeJS with FastOptStage to save some CO2  by @joroKr21
* [#3544](https://github.com/typelevel/cats/pull/3544) Scala 2.12.3 and 2.12.12  by @barambani
* [#3543](https://github.com/typelevel/cats/pull/3543) Update discipline-munit to 0.2.3  by @scala-steward
* [#3542](https://github.com/typelevel/cats/pull/3542) Update sbt-scalafmt to 2.4.2  by @scala-steward
* [#3539](https://github.com/typelevel/cats/pull/3539) Update discipline-core to 1.0.3  by @scala-steward
* [#3530](https://github.com/typelevel/cats/pull/3530) Update discipline-scalatest to 2.0.0  by @scala-steward


## Version 2.2.0-RC2

_2020 July 21

### 7 API / feature enhancements

* [#3524](https://github.com/typelevel/cats/pull/3524) A method `StateT.fromState` turning `State[A, F[B]]` into `StateT[F,A, B]` is added.  by @akopich
* [#3498](https://github.com/typelevel/cats/pull/3498) Enable breakout in functions reduceRightToOption and reduceRightTo.  by @takayahilton
* [#3519](https://github.com/typelevel/cats/pull/3519) remove casts from Eval, fix stack overflow in Eval  by @johnynek
* [#3521](https://github.com/typelevel/cats/pull/3521) make collection traversals stack safe  by @johnynek
* [#3516](https://github.com/typelevel/cats/pull/3516) Override some Option Apply/Applicative methods  by @johnynek
* [#3518](https://github.com/typelevel/cats/pull/3518) remove some casts in AndThen  by @johnynek
* [#3515](https://github.com/typelevel/cats/pull/3515) Add some more implementations to Function0 and Function1 Monads  by @johnynek


### 3 build improvements

* [#3525](https://github.com/typelevel/cats/pull/3525) Update scalafmt-core to 2.6.4  by @scala-steward
* [#3520](https://github.com/typelevel/cats/pull/3520) Update sbt-scalafix to 0.9.19  by @scala-steward
* [#3514](https://github.com/typelevel/cats/pull/3514) Scalafmt-core 2.6.3  by @barambani


## Version 2.2.0-RC1

_2020 July 6_

### 10 API / feature enhancements

* [#3458](https://github.com/typelevel/cats/pull/3458) Enum typeclass  by @yilinwei
* [#3508](https://github.com/typelevel/cats/pull/3508) Put implicit support for evidence from predef types  by @johnynek
* [#3459](https://github.com/typelevel/cats/pull/3459) attemptTap  by @RaasAhsan
* [#3502](https://github.com/typelevel/cats/pull/3502) Add Tuple2K Semigroupal  by @rmehri01
* [#3495](https://github.com/typelevel/cats/pull/3495) Add implicit variance support for Profunctor typeclass  by @gagandeepkalra
* [#3358](https://github.com/typelevel/cats/pull/3358) ApplicativeError: add raiseOption operation.  by @diesalbla
* [#3493](https://github.com/typelevel/cats/pull/3493) Don't skip PartialOrder antisymmetry and transitivity  by @rossabaker
* [#3336](https://github.com/typelevel/cats/pull/3336) some convenient for IndexedReaderWriterStateT  by @enzief
* [#3486](https://github.com/typelevel/cats/pull/3486) Another attempt at Dotty cross-building  by @travisbrown
* [#3485](https://github.com/typelevel/cats/pull/3485) Remove unnecessary type parameter  by @travisbrown


### 7 documentation improvements

* [#3501](https://github.com/typelevel/cats/pull/3501) improved MonoidK docs  by @kazchimo
* [#3492](https://github.com/typelevel/cats/pull/3492) Add invariant docs  by @kazchimo
* [#3497](https://github.com/typelevel/cats/pull/3497) Modify document expressions  by @yu-croco
* [#3390](https://github.com/typelevel/cats/pull/3390) Add document about Arrow Choice  by @jcouyang
* [#3481](https://github.com/typelevel/cats/pull/3481) Improve documentation for typeclasses  by @kkalavantavanich
* [#3478](https://github.com/typelevel/cats/pull/3478) Add ior docs  by @kazchimo
* [#3479](https://github.com/typelevel/cats/pull/3479) Clean up Community Announcements a little  by @travisbrown


### 14 build improvements

* [#3496](https://github.com/typelevel/cats/pull/3510) Fix cross-versioning for docs  by @travisbrown
* [#3506](https://github.com/typelevel/cats/pull/3509) Update scalafmt-core to 2.6.2  by @scala-steward
* [#3506](https://github.com/typelevel/cats/pull/3506) Update sbt-scalafix to 0.9.18  by @scala-steward
* [#3507](https://github.com/typelevel/cats/pull/3507) Update sbt-sonatype to 3.9.4  by @scala-steward
* [#3496](https://github.com/typelevel/cats/pull/3496) Review Simulacrum Scalafix annotation practices  by @travisbrown
* [#3504](https://github.com/typelevel/cats/pull/3504) Update sbt-scalajs, scalajs-compiler to 1.1.1  by @scala-steward
* [#3500](https://github.com/typelevel/cats/pull/3500) Update sbt to 1.3.13  by @scala-steward
* [#3491](https://github.com/typelevel/cats/pull/3491) Update sbt-sonatype to 3.9.3  by @scala-steward
* [#3490](https://github.com/typelevel/cats/pull/3490) Fixed formatting on master  by @barambani
* [#3488](https://github.com/typelevel/cats/pull/3488) Scalafmt core 2.6.1  by @barambani
* [#3484](https://github.com/typelevel/cats/pull/3484) Add ScalaTest 3.2.0 dependencies  by @travisbrown
* [#3482](https://github.com/typelevel/cats/pull/3482) Rerun Simulacrum after rearrangement for Scala.js  by @travisbrown
* [#3476](https://github.com/typelevel/cats/pull/3476) Update to Scalafmt 2.6.0  by @travisbrown
* [#3475](https://github.com/typelevel/cats/pull/3475) Merge 2.2.x after 2.2.0-M3 release  by @travisbrown


## Version 2.2.0-M3

_2020 June 17

### 1 source breaking change

* [#3462](https://github.com/typelevel/cats/pull/3462) Reverse argument order for Kleisli ap method  by @justinhj


### 15 API / feature enhancements

* [#3467](https://github.com/typelevel/cats/pull/3467) Add Parallel traverseFilter functions  by @LukaJCB
* [#3464](https://github.com/typelevel/cats/pull/3464) Add BinCompat extensions to syntax.apply import  by @gagandeepkalra
* [#3463](https://github.com/typelevel/cats/pull/3463) Added CommutativeMonoid for Option to scope  by @barambani
* [#3457](https://github.com/typelevel/cats/pull/3457) Add EitherT and IorT constructors from Option with monad left value  by @ivan-klass
* [#3456](https://github.com/typelevel/cats/pull/3456) Override map2Eval and combineKEval for monad transformers  by @LukaJCB
* [#3451](https://github.com/typelevel/cats/pull/3451) Issue 3447: Add more foldMapK shortcircuiting  by @barambani
* [#3446](https://github.com/typelevel/cats/pull/3446) Add combineKEval and add short-circuiting for foldMapK  by @LukaJCB
* [#3440](https://github.com/typelevel/cats/pull/3440) Mark Ops traits as Serializable  by @travisbrown
* [#3439](https://github.com/typelevel/cats/pull/3439) Make boilerplate syntax classes extend Serializable  by @ceedubs
* [#3436](https://github.com/typelevel/cats/pull/3436) Add auto variance as additional import  by @LukaJCB
* [#3432](https://github.com/typelevel/cats/pull/3432) NonEmptyList.groupByNelA  by @pk044
* [#3397](https://github.com/typelevel/cats/pull/3397) Remove Order constraints from SortedMap and NonEmptyMap instances  by @joroKr21
* [#3396](https://github.com/typelevel/cats/pull/3396) Syntax for function1 kleisli-composition  by @valenterry
* [#3392](https://github.com/typelevel/cats/pull/3392) Add PartialFunction instance for Profunctor typeclass  by @gagandeepkalra
* [#3382](https://github.com/typelevel/cats/pull/3382) Optimise NonEmptyTraverse implementation  by @gagandeepkalra


### 3 documentation improvements

* [#3469](https://github.com/typelevel/cats/pull/3469) Move nomenclature questions below introductory paragraph  by @rmehri01
* [#3468](https://github.com/typelevel/cats/pull/3468) Add Filippo Mariotti as a maintainer  by @LukaJCB
* [#3455](https://github.com/typelevel/cats/pull/3455) Update faq for ammonite  by @psilospore


### 14 build improvements

* [#3471](https://github.com/typelevel/cats/pull/3471) Some travis ci updates  by @barambani
* [#3466](https://github.com/typelevel/cats/pull/3466) Adding travis job names  by @barambani
* [#3461](https://github.com/typelevel/cats/pull/3461) Update sbt-scalafix to 0.9.17  by @scala-steward
* [#3448](https://github.com/typelevel/cats/pull/3448) Update simulacrum-scalafix-annotations to 0.3.0  by @scala-steward
* [#3445](https://github.com/typelevel/cats/pull/3445) Update sbt to 1.3.12  by @scala-steward
* [#3444](https://github.com/typelevel/cats/pull/3444) Scalafmt 2.5.3  by @travisbrown
* [#3442](https://github.com/typelevel/cats/pull/3442) Deprecate Simulacrum ops objects  by @travisbrown
* [#3441](https://github.com/typelevel/cats/pull/3441) Update sbt to 1.3.11  by @scala-steward
* [#3438](https://github.com/typelevel/cats/pull/3438) Change value-level kind-projector syntax  by @travisbrown
* [#3437](https://github.com/typelevel/cats/pull/3437) Update sbt-scalafix to 0.9.16  by @scala-steward
* [#3435](https://github.com/typelevel/cats/pull/3435) Use FullOptStage  by @travisbrown
* [#3428](https://github.com/typelevel/cats/pull/3428) Configure codecov to simplify PR comments  by @travisbrown
* [#3425](https://github.com/typelevel/cats/pull/3425) Update Scalafmt to 2.5.2  by @travisbrown
* [#3357](https://github.com/typelevel/cats/pull/3357) Update Scala.js to 1.0, disable Scala.js coverage reporting  by @travisbrown


## Version 2.2.0-M2

_2020 May 25_

### 2 bug fixes

* [#3394](https://github.com/typelevel/cats/pull/3394) WriterTInstances: insufficient prioritization  by @barambani
* [#3380](https://github.com/typelevel/cats/pull/3380) First two missing instances  by @travisbrown


### 7 API / feature enhancements

* [#3423](https://github.com/typelevel/cats/pull/3423) Add toNev to NonEmptyList variants  by @saraiva132
* [#3421](https://github.com/typelevel/cats/pull/3421) Functor - fproductLeft  by @pk044
* [#3415](https://github.com/typelevel/cats/pull/3415) Add partialComparison syntax  by @joroKr21
* [#3412](https://github.com/typelevel/cats/pull/3412) Update sbt-microsites to 1.2.1  by @scala-steward
* [#3408](https://github.com/typelevel/cats/pull/3408) Tweak EitherT.pure and rightT to avoid a map call  by @joroKr21
* [#3403](https://github.com/typelevel/cats/pull/3403) Add Cont alias to ContT  by @RaasAhsan
* [#3335](https://github.com/typelevel/cats/pull/3335) Add foldF, cataF and emptyflatTap to OptionT  by @ybasket


### 3 documentation improvements

* [#3419](https://github.com/typelevel/cats/pull/3419) fix scalaz source url. s/As.scala/Liskov.scala/  by @xuwei-k
* [#3393](https://github.com/typelevel/cats/pull/3393) Remove TODO from guidelines  by @DieBauer
* [#3383](https://github.com/typelevel/cats/pull/3383) Fix a link in the documentation for Traverse  by @justinhj


### 2 test improvements

* [#3378](https://github.com/typelevel/cats/pull/3378) Remove cats.instances from tests  by @travisbrown
* [#3375](https://github.com/typelevel/cats/pull/3375) Add laws to check Short-Circuiting behaviour  by @gagandeepkalra


### 11 build improvements

* [#3430](https://github.com/typelevel/cats/pull/3430) Fix Simulacrum exclusion in POM  by @travisbrown
* [#3424](https://github.com/typelevel/cats/pull/3424) Use Simulacrum Scalafix  by @travisbrown
* [#3417](https://github.com/typelevel/cats/pull/3417) Update sbt-scalafmt to 2.4.0  by @scala-steward
* [#3416](https://github.com/typelevel/cats/pull/3416) Update scalacheck-1-14 to 3.1.2.0  by @scala-steward
* [#3413](https://github.com/typelevel/cats/pull/3413) Update sbt-scalajs, scalajs-compiler to 0.6.33  by @scala-steward
* [#3399](https://github.com/typelevel/cats/pull/3399) Update sbt-microsites to 1.2.0  by @scala-steward
* [#3395](https://github.com/typelevel/cats/pull/3395) Update sbt to 1.3.10  by @scala-steward
* [#3389](https://github.com/typelevel/cats/pull/3389) Update sbt-scalafmt to 2.3.4  by @scala-steward
* [#3388](https://github.com/typelevel/cats/pull/3388) Update sbt-scalafmt to 2.3.3  by @scala-steward
* [#3379](https://github.com/typelevel/cats/pull/3379) Merge 2.2.x after 2.2.0-M1 release  by @travisbrown
* [#3376](https://github.com/typelevel/cats/pull/3376) Update sbt to 1.3.9  by @scala-steward


## Version 2.2.0-M1

_2020 March 31_

### 3 source breaking changes

* [#3043](https://github.com/typelevel/cats/pull/3043) Move standard library type class instances into implicit scope  by @travisbrown
* [#3241](https://github.com/typelevel/cats/pull/3241) Reimplemented MonadError[FreeT[...]] to be correct  by @djspiewak
* [#3361](https://github.com/typelevel/cats/pull/3361) Restrict attemptNarrow to subtypes of Throwable  by @travisbrown


### 2 bug fixes

* [#3306](https://github.com/typelevel/cats/pull/3306) Make cats.syntax.flatMap include untilDefinedM  by @travisbrown
* [#3305](https://github.com/typelevel/cats/pull/3305) Add cats.syntax.hash  by @travisbrown


### 31 API/feature enhancements

* [#3321](https://github.com/typelevel/cats/pull/3321) Reinstate @johnynek's intercalate optimization from #3279  by @travisbrown
* [#3374](https://github.com/typelevel/cats/pull/3374) Add EitherT.liftAttemptK  by @kubukoz
* [#3168](https://github.com/typelevel/cats/pull/3168) Use `getOrElse` in `NonEmptyList#last`  by @PeterPerhac
* [#2689](https://github.com/typelevel/cats/pull/2689) Add `orElseRaise` syntax for `ApplicativeError`  by @kubukoz
* [#3372](https://github.com/typelevel/cats/pull/3372) Add zipAll to Align typeclass  by @dantb
* [#3328](https://github.com/typelevel/cats/pull/3328) Fix short circuiting behaviour in `traverse` and `traverseFilter`  by @gagandeepkalra
* [#3362](https://github.com/typelevel/cats/pull/3362) Prepend a Vector to a NonEmptyVector  by @ssanj 
* [#3361](https://github.com/typelevel/cats/pull/3361) Restrict attemptNarrow to subtypes of Throwable  by @travisbrown
* [#3346](https://github.com/typelevel/cats/pull/3346) Add Either.unit, use in Applicative[Either[A, ?]]  by @rossabaker
* [#3323](https://github.com/typelevel/cats/pull/3323) Re-encode relationships to avoid implicit conversion functions  by @travisbrown
* [#3316](https://github.com/typelevel/cats/pull/3316) Add semiflatTap and leftSemiflatTap functions to EitherT  by @matwojcik
* [#3324](https://github.com/typelevel/cats/pull/3324) Use ArraySeq.untagged instead of ClassTag[Nothing]  by @travisbrown
* [#3235](https://github.com/typelevel/cats/pull/3235) Added flatMapK to FreeT  by @djspiewak
* [#3279](https://github.com/typelevel/cats/pull/3279) Add Semigroup and Monoid combinators reverse and intercalate  by @johnynek
* [#3303](https://github.com/typelevel/cats/pull/3303) Use unlimited MathContext for BigDecimal arithmetic  by @travisbrown
* [#3307](https://github.com/typelevel/cats/pull/3307) Clean up some NonEmpty stuff  by @travisbrown
* [#3283](https://github.com/typelevel/cats/pull/3283) Optimize traverse  by @travisbrown
* [#3294](https://github.com/typelevel/cats/pull/3294) Add traverseEither  by @LukaJCB
* [#3302](https://github.com/typelevel/cats/pull/3302) ArraySeq instance follow-up  by @travisbrown
* [#3278](https://github.com/typelevel/cats/pull/3278) Issue 2304: Missing functions for RWST  by @barambani
* [#3273](https://github.com/typelevel/cats/pull/3273) Adding instances for ArraySeq  by @BalmungSan
* [#3274](https://github.com/typelevel/cats/pull/3274) Add ContT.liftF and ContT.liftK  by @lavrov
* [#3263](https://github.com/typelevel/cats/pull/3263) Avoid syntax methods in implementations in cats-core  by @travisbrown
* [#3261](https://github.com/typelevel/cats/pull/3261) Fix compiler warnings in tests  by @travisbrown
* [#3255](https://github.com/typelevel/cats/pull/3255) More Dotty compat stuff in tests  by @travisbrown
* [#3254](https://github.com/typelevel/cats/pull/3254) Use dotty-friendly kind-projector placeholder  by @travisbrown
* [#3253](https://github.com/typelevel/cats/pull/3253) Some Dotty compat for tests  by @travisbrown
* [#3239](https://github.com/typelevel/cats/pull/3239) add List#scanLeftNel and List#scanRightNel  by @enzief
* [#3237](https://github.com/typelevel/cats/pull/3237) Follow up to #3233  by @strong-zero
* [#3233](https://github.com/typelevel/cats/pull/3233) Add when and unless to OptionT  by @strong-zero
* [#3230](https://github.com/typelevel/cats/pull/3230) Add two casts to satisfy Dotty  by @travisbrown
* [#3225](https://github.com/typelevel/cats/pull/3225) Publicize Free#foldStep  by @djspiewak


### 11 documentation improvements

* [#3301](https://github.com/typelevel/cats/pull/3301) Cats package: add comprehensive scaladoc.  by @diesalbla
* [#3364](https://github.com/typelevel/cats/pull/3364) Fix typo  by @MaT1g3R
* [#3314](https://github.com/typelevel/cats/pull/3314) Fix doc examples for Ior.map  by @ybasket
* [#3290](https://github.com/typelevel/cats/pull/3290) Update readme with latest cats-core version  by @leusgalvan
* [#3285](https://github.com/typelevel/cats/pull/3285) Remove machinist from colophon microsite page  by @markusa380
* [#3272](https://github.com/typelevel/cats/pull/3272) Fix typo on Chain docs  by @LLCampos
* [#3265](https://github.com/typelevel/cats/pull/3265) Copyright and license  by @travisbrown
* [#3229](https://github.com/typelevel/cats/pull/3229) fixes #3206 remove references to waffle.io  by @ssikdar1
* [#3226](https://github.com/typelevel/cats/pull/3226) Update kind-projector and simulacrum url  by @xuwei-k
* [#3224](https://github.com/typelevel/cats/pull/3224) Add a Developer-Comment regarding an unused parameter.  by @diesalbla
* [#3221](https://github.com/typelevel/cats/pull/3221) Fix typos  by @bwignall


### 38 build improvements

* [#3193](https://github.com/typelevel/cats/pull/3193) Expand kind-projector's syntax for polymorphic function values  by @travisbrown
* [#3365](https://github.com/typelevel/cats/pull/3365) Update sbt-microsites to 1.1.5  by @scala-steward
* [#3371](https://github.com/typelevel/cats/pull/3371) Update sbt-sonatype to 3.9.2  by @scala-steward
* [#3325](https://github.com/typelevel/cats/pull/3325) Specific commutativity and associativity tests for BigDecimal  by @travisbrown
* [#3342](https://github.com/typelevel/cats/pull/3342) Fix `Foldable` doctest to use `separateFoldable` instead of `separate`  by @gagandeepkalra
* [#3352](https://github.com/typelevel/cats/pull/3352) Update sbt-microsites to 1.1.3  by @scala-steward
* [#3354](https://github.com/typelevel/cats/pull/3354) Change review policy for PRs that don't target master  by @travisbrown
* [#3319](https://github.com/typelevel/cats/pull/3319) Update changelog  by @travisbrown
* [#3337](https://github.com/typelevel/cats/pull/3337) Update Scalafmt to 2.4.2  by @travisbrown
* [#3331](https://github.com/typelevel/cats/pull/3331) Update sbt-mima-plugin to 0.7.0  by @scala-steward
* [#3326](https://github.com/typelevel/cats/pull/3326) Update snakeyaml to 1.26  by @scala-steward
* [#3344](https://github.com/typelevel/cats/pull/3344) Update sbt-scalafmt to 2.3.2  by @scala-steward
* [#3350](https://github.com/typelevel/cats/pull/3350) Add Align lawful tests for Option instance  by @gagandeepkalra
* [#3304](https://github.com/typelevel/cats/pull/3304) Replace instance trait inheritance with imports in tests  by @travisbrown
* [#3322](https://github.com/typelevel/cats/pull/3322) Add parentheses for Dotty  by @travisbrown
* [#3311](https://github.com/typelevel/cats/pull/3311) Update sbt-microsites to 1.1.2  by @scala-steward
* [#3310](https://github.com/typelevel/cats/pull/3310) Update discipline-scalatest  by @travisbrown
* [#3308](https://github.com/typelevel/cats/pull/3308) Update scalacheck-1-14 to 3.1.1.0  by @scala-steward
* [#3291](https://github.com/typelevel/cats/pull/3291) Update sbt-scalajs-crossproject to 1.0.0  by @scala-steward
* [#3284](https://github.com/typelevel/cats/pull/3284) Update sbt to 1.3.8  by @scala-steward
* [#3288](https://github.com/typelevel/cats/pull/3288) Update sbt-mima-plugin to 0.6.4  by @scala-steward
* [#3282](https://github.com/typelevel/cats/pull/3282) Update sbt-mima-plugin to 0.6.3  by @scala-steward
* [#3276](https://github.com/typelevel/cats/pull/3276) Update sbt-unidoc to 0.4.3  by @scala-steward
* [#3267](https://github.com/typelevel/cats/pull/3267) Update sbt-scalajs to 0.6.32  by @scala-steward
* [#3268](https://github.com/typelevel/cats/pull/3268) Update sbt-doctest with ScalaTest 3.1.0 and Dotty fixes  by @travisbrown
* [#3266](https://github.com/typelevel/cats/pull/3266) Update discipline-scalatest to 1.0.0  by @scala-steward
* [#3277](https://github.com/typelevel/cats/pull/3277) Update sbt-scalafmt to 2.3.1  by @scala-steward
* [#3246](https://github.com/typelevel/cats/pull/3246) Minor changes for Scala.js 1.0 compatibility  by @travisbrown
* [#3259](https://github.com/typelevel/cats/pull/3259) Update discipline-scalatest  by @travisbrown
* [#3258](https://github.com/typelevel/cats/pull/3258) Update sbt-release to 1.0.13  by @scala-steward
* [#3257](https://github.com/typelevel/cats/pull/3257) Update sbt to 1.3.7  by @scala-steward
* [#3251](https://github.com/typelevel/cats/pull/3251) Update sbt-microsites to 1.1.0  by @scala-steward
* [#3250](https://github.com/typelevel/cats/pull/3250) Avoid ScalaTest 3.1.0 deprecations  by @travisbrown
* [#3244](https://github.com/typelevel/cats/pull/3244) Update discipline-scalatest and scalatestplus dependency  by @travisbrown
* [#3243](https://github.com/typelevel/cats/pull/3243) Remove unused Scala Native sbt plugin  by @travisbrown
* [#3232](https://github.com/typelevel/cats/pull/3232) Update Scalafmt to 2.3.2  by @travisbrown
* [#3231](https://github.com/typelevel/cats/pull/3231) Drop cats-macros project  by @travisbrown
* [#3227](https://github.com/typelevel/cats/pull/3227) Update sbt to 1.3.6  by @scala-steward


## Version 2.1.1

_2020 February 25_

This release introduces support for Scala.js 1.0.0. There are no changes since 2.1.0 for the
Scala.js 0.6 or JVM artifacts. This is likely to be the last Cats release supporting Scala.js 0.6,
and we encourage Scala.js users to upgrade to 1.0.0 as soon as possible.

## Version 2.1.0

_2019 December 18_

This release currently only supports Scala 2.12 and 2.13. It provides the same binary compatibility
guarantees as Cats 2.0 (note that it is not guaranteed to be binary-compatible with the 2.1.0
release candidates).

### 3 API / feature enhancements

* [#3208](https://github.com/typelevel/cats/pull/3208) Add Defer.fix  by @johnynek
* [#3215](https://github.com/typelevel/cats/pull/3215) Replace kind-projector placeholders in infix types  by @travisbrown
* [#3207](https://github.com/typelevel/cats/pull/3207) Avoid kind-projector syntax with variance annotations  by @travisbrown


### 1 documentation improvement

* [#3218](https://github.com/typelevel/cats/pull/3218) Update sbt-microsites  by @travisbrown


### 4 build improvements

* [#3217](https://github.com/typelevel/cats/pull/3217) Remove sbt-partial-unification  by @travisbrown
* [#3216](https://github.com/typelevel/cats/pull/3216) Update sbt-pgp to 2.0.1  by @scala-steward
* [#3213](https://github.com/typelevel/cats/pull/3213) Update discipline-core to 1.0.2  by @scala-steward
* [#3212](https://github.com/typelevel/cats/pull/3212) Update sbt-scalafix and sbt versions  by @travisbrown


## Version 2.1.0-RC3

_2019 December 11_

This release candidate provides the same binary compatibility guarantees as Cats 2.0.

### 1 bug fix

* [#3203](https://github.com/typelevel/cats/pull/3203) Fix more bincompat breakage  by @travisbrown


### 14 API / feature enhancements

* [#3199](https://github.com/typelevel/cats/pull/3199) Fix foldA, reduceA, and reduceMapA short-circuiting  by @travisbrown
* [#3198](https://github.com/typelevel/cats/pull/3198) Rename rangeE for clarity  by @travisbrown
* [#3150](https://github.com/typelevel/cats/pull/3150) Add foldA, reduceA, and reduceMapA  by @Twizty
* [#3174](https://github.com/typelevel/cats/pull/3174) Optimize Iterable instances implementation.  by @takayahilton
* [#3186](https://github.com/typelevel/cats/pull/3186) Avoid unusual kind-projector syntax  by @travisbrown
* [#3187](https://github.com/typelevel/cats/pull/3187) Helping out Dotty's type inference  by @travisbrown
* [#3190](https://github.com/typelevel/cats/pull/3190) Mark match that is unchecked by Scala 2 as unchecked  by @travisbrown
* [#3191](https://github.com/typelevel/cats/pull/3191) Add type for implicit val  by @travisbrown
* [#3158](https://github.com/typelevel/cats/pull/3158) add `filterNot` to FunctorFilter  by @gagandeepkalra
* [#3188](https://github.com/typelevel/cats/pull/3188) Add explicit type annotations for implicit Ordering vals  by @travisbrown
* [#3189](https://github.com/typelevel/cats/pull/3189) Replace do-while  by @travisbrown
* [#3185](https://github.com/typelevel/cats/pull/3185) Update Function0 syntax  by @travisbrown
* [#3183](https://github.com/typelevel/cats/pull/3183) Remove redundant final modifiers on objects  by @travisbrown
* [#3182](https://github.com/typelevel/cats/pull/3182) Parenthesize lambda parameters with type annotations  by @travisbrown


### 4 documentation improvements

* [#3155](https://github.com/typelevel/cats/pull/3155) Enable and fix doctests on 2.13  by @travisbrown
* [#3178](https://github.com/typelevel/cats/pull/3178) Add ApplicativeError for EitherT documentation  by @tg44
* [#3181](https://github.com/typelevel/cats/pull/3181) Fix typo  by @msinton
* [#3173](https://github.com/typelevel/cats/pull/3173) Fix typo in Alternative docs  by @SimY4


### 1 build improvement

* [#3197](https://github.com/typelevel/cats/pull/3197) Update sbt-scalafmt to 2.3.0  by @scala-steward


## Version 2.1.0-RC2

_2019 November 26

This release candidate provides the same binary compatibility guarantees as Cats 2.0.

### 2 bug fixes

* [#3163](https://github.com/typelevel/cats/pull/3163) Fix broken binary compatibility  by @travisbrown
* [#3162](https://github.com/typelevel/cats/pull/3162) Add adaptError override to MonadError  by @travisbrown


### 3 API / feature enhancements

* [#3165](https://github.com/typelevel/cats/pull/3165) Add catchOnly to ApplicativeError by @takayahilton
* [#3159](https://github.com/typelevel/cats/pull/3159) Some minor optimizations  by @travisbrown
* [#3167](https://github.com/typelevel/cats/pull/3167) Make default reduceMapM lazy if reduceRightTo is lazy  by @travisbrown


### 3 documentation improvements

* [#3172](https://github.com/typelevel/cats/pull/3172) Fix typo  by @bwignall
* [#3153](https://github.com/typelevel/cats/pull/3153) Activating Open Collective  by @monkeywithacupcake
* [#3160](https://github.com/typelevel/cats/pull/3160) update links to sustainability program  by @kailuowang


### 4 build improvements

* [#3166](https://github.com/typelevel/cats/pull/3166) Update Scala to 2.13.1  by @travisbrown
* [#3171](https://github.com/typelevel/cats/pull/3171) Update sbt to 1.3.4  by @scala-steward
* [#3169](https://github.com/typelevel/cats/pull/3169) Update sbt-sonatype to 3.8.1  by @scala-steward
* [#3170](https://github.com/typelevel/cats/pull/3170) Update sbt-scalajs, scalajs-compiler to 0.6.31  by @scala-steward


## Version 2.1.0-RC1

_2019 November 15_

This release is currently only available for Scala 2.11 and Scala 2.12. It provides the same binary compatibility guarantees as Cats 2.0 (and is verified by MiMa to be fully binary-compatible with 2.0 itself).

### 2 source breaking changes

* [#3154](https://github.com/typelevel/cats/pull/3154) Make 1.x deprecation targets package-private  by @travisbrown
* [#3099](https://github.com/typelevel/cats/pull/3099) Issue 3059: Move Parallel instances into instance packages for the type constructors they characterize  by @barambani


### 3 bug fixes

* [#3126](https://github.com/typelevel/cats/pull/3126) Remove Order constraint from Hash instance for Map  by @vasiliybondarenko
* [#3105](https://github.com/typelevel/cats/pull/3105) Issue 2701 - Ambiguous Eq instances for tuples  by @barambani
* [#3100](https://github.com/typelevel/cats/pull/3100) Issue 2891 - Ambiguous Vector instances  by @barambani


### 25 API / feature enhancements

* [#3152](https://github.com/typelevel/cats/pull/3152) "Move" type class syntax methods onto type classes  by @travisbrown
* [#3149](https://github.com/typelevel/cats/pull/3149) Deprecate and make private syntax methods that are now on Either  by @travisbrown
* [#3148](https://github.com/typelevel/cats/pull/3148) Move adaptError  by @travisbrown
* [#3147](https://github.com/typelevel/cats/pull/3147) Add Parallel.parFoldMapA  by @nigredo-tori
* [#3146](https://github.com/typelevel/cats/pull/3146) Add redeem and redeemWith  by @travisbrown
* [#3144](https://github.com/typelevel/cats/pull/3144) Add Align for Stream  by @travisbrown
* [#3136](https://github.com/typelevel/cats/pull/3136) Add benchmark for foldMapA  by @travisbrown
* [#3135](https://github.com/typelevel/cats/pull/3135) Minor clean up. Removed duplication.  by @barambani
* [#3133](https://github.com/typelevel/cats/pull/3133) Fix NonEmptyChain.fromSeq signature on 2.12  by @travisbrown
* [#3130](https://github.com/typelevel/cats/pull/3130) add foldMapA as an alternative to foldMapM that only requires an Applicative rather than a monad  by @mberndt123
* [#3124](https://github.com/typelevel/cats/pull/3124) SemigroupK sum: F[A], F[B] => F[A Either B]  by @pk044
* [#3122](https://github.com/typelevel/cats/pull/3122) Fix constraints and names for new Foldable methods  by @travisbrown
* [#3103](https://github.com/typelevel/cats/pull/3103) Add TraverseFilter instance for Queue.  by @takayahilton
* [#3088](https://github.com/typelevel/cats/pull/3088) #2947 Added bifold to Bifoldable typeclass  by @Twizty
* [#3084](https://github.com/typelevel/cats/pull/3084) Add minimumBy/maximumBy/Option to Foldable  by @joroKr21
* [#3076](https://github.com/typelevel/cats/pull/3076) Add Align typeclass  by @LukaJCB
* [#3062](https://github.com/typelevel/cats/pull/3062) add unzip to Functor  by @gagandeepkalra
* [#3058](https://github.com/typelevel/cats/pull/3058) Add `ifF` on Functor #3040  by @vasiliybondarenko
* [#3041](https://github.com/typelevel/cats/pull/3041) Add scala.util.control.TailCalls.TailRec instances  by @johnynek
* [#3015](https://github.com/typelevel/cats/pull/3015) Use Foldable foldRight for Traverse and TraverseFilter.  by @takayahilton
* [#2863](https://github.com/typelevel/cats/pull/2863) add attemptNarrow to ApplicativeErrorOps  by @marcodippy
* [#2834](https://github.com/typelevel/cats/pull/2834) CommutativeMonoid[Option[A]] from CommutativeSemigroup  by @valydia
* [#2772](https://github.com/typelevel/cats/pull/2772) Add foldRightDefer to Foldable  by @denisrosca
* [#2742](https://github.com/typelevel/cats/pull/2742) Added separateFoldable  by @tkroman
* [#2380](https://github.com/typelevel/cats/pull/2380) Add combineAllOption to Foldable  by @barambani


### 12 documentation improvements

* [#3156](https://github.com/typelevel/cats/pull/3156) Fix link to Monad and Comonad  by @XeeD
* [#3151](https://github.com/typelevel/cats/pull/3151) fix link to moniodK and Applicative  by @stsatlantis
* [#3104](https://github.com/typelevel/cats/pull/3104) Update faq.md repl documentation  by @psilospore
* [#3081](https://github.com/typelevel/cats/pull/3081) Correct some mistakes in Comonad documentatoin  by @justinhj
* [#3073](https://github.com/typelevel/cats/pull/3073) add more doctest to WriterT  by @hamednourhani
* [#3072](https://github.com/typelevel/cats/pull/3072) Mention additional dependencies in lawtesting docs  by @miklos-martin
* [#3071](https://github.com/typelevel/cats/pull/3071) Update Semigroup docs for Map  by @codingismy11to7
* [#3065](https://github.com/typelevel/cats/pull/3065) Link to relevant Const doc from doc of Traverse  by @LPTK
* [#3063](https://github.com/typelevel/cats/pull/3063) add more doctest to Ior  by @hamednourhani
* [#3061](https://github.com/typelevel/cats/pull/3061) Validated doctest  by @hamednourhani
* [#3054](https://github.com/typelevel/cats/pull/3054) add more doctest to EitherT  by @hamednourhani
* [#3049](https://github.com/typelevel/cats/pull/3049) minor update to the doc to include cats-testkit-scalatest  by @kailuowang


### 29 build improvements

* [#3142](https://github.com/typelevel/cats/pull/3142) Backport MiMa config and dependency updates for 2.11  by @travisbrown
* [#3139](https://github.com/typelevel/cats/pull/3139) Update 2.11 branch build  by @travisbrown
* [#3129](https://github.com/typelevel/cats/pull/3129) Check bincompat on stuff we should be checking bincompat for  by @travisbrown
* [#3125](https://github.com/typelevel/cats/pull/3125) Fix order of @deprecated arguments  by @travisbrown
* [#3120](https://github.com/typelevel/cats/pull/3120) Update sbt-scalafmt to 2.2.1  by @scala-steward
* [#3118](https://github.com/typelevel/cats/pull/3118) Update sbt-scalafmt to 2.2.0  by @scala-steward
* [#3115](https://github.com/typelevel/cats/pull/3115) Update sbt-release to 1.0.12  by @scala-steward
* [#3114](https://github.com/typelevel/cats/pull/3114) Update sbt to 1.3.3  by @scala-steward
* [#3110](https://github.com/typelevel/cats/pull/3110) Update sbt-scalafmt to 2.0.7  by @scala-steward
* [#3106](https://github.com/typelevel/cats/pull/3106) ci: Enable 2.13 build for scalajs and linting in travis  by @DieBauer
* [#3102](https://github.com/typelevel/cats/pull/3102) Use new group ID for simulacrum  by @travisbrown
* [#3101](https://github.com/typelevel/cats/pull/3101) update ScalaTest  by @larsrh
* [#3096](https://github.com/typelevel/cats/pull/3096) Enable coverage and docs  by @DieBauer
* [#3095](https://github.com/typelevel/cats/pull/3095) Update sbt-microsites to 0.9.7  by @scala-steward
* [#3094](https://github.com/typelevel/cats/pull/3094) Update tut-plugin to 0.6.13  by @scala-steward
* [#3092](https://github.com/typelevel/cats/pull/3092) Update scalafmt-core to 2.1.0  by @scala-steward
* [#3091](https://github.com/typelevel/cats/pull/3091) Update sbt-sonatype to 3.8  by @scala-steward
* [#3090](https://github.com/typelevel/cats/pull/3090) Update sbt-scalafmt to 2.0.6  by @scala-steward
* [#3089](https://github.com/typelevel/cats/pull/3089) Update scalacheck to 1.14.2  by @scala-steward
* [#3086](https://github.com/typelevel/cats/pull/3086) Update simulacrum to 1.0.0  by @scala-steward
* [#3085](https://github.com/typelevel/cats/pull/3085) Update sbt-microsites to 0.9.6  by @scala-steward
* [#3079](https://github.com/typelevel/cats/pull/3079) update to sbt 1.3.x, uses coursier by default  by @larsrh
* [#3070](https://github.com/typelevel/cats/pull/3070) Update sbt-scalajs, scalajs-compiler to 0.6.29  by @scala-steward
* [#3066](https://github.com/typelevel/cats/pull/3066) Update sbt-scalafmt to 2.0.5  by @scala-steward
* [#3064](https://github.com/typelevel/cats/pull/3064) Update sbt-pgp to 2.0.1-M3  by @scala-steward
* [#3056](https://github.com/typelevel/cats/pull/3056) Update sbt-sonatype to 3.7  by @scala-steward
* [#3052](https://github.com/typelevel/cats/pull/3052) Create a Scala 2.11 branch  by @kailuowang
* [#3051](https://github.com/typelevel/cats/pull/3051) Drops Scala 2.11 support on master  by @kailuowang
* [#3030](https://github.com/typelevel/cats/pull/3030) Update sbt-sonatype to 3.6  by @scala-steward


## Version 2.0.0

> 2019 September 9

Cats 2.0.0 is available for Scala 2.11, 2.12, 2.13, and Scala.js 0.6. This release maintains binary compatibility with Cats 1.x.x in the cats-kernel, cats-core and cats-free modules, but not cats-laws, cats-kernel-laws, cats-testkit, or alleycats.


### 2 source breaking changes

* [#3046](https://github.com/typelevel/cats/pull/3046) Infer dependent parameter in NonEmpty/ParallelTests/Laws  by @djspiewak
* [#3042](https://github.com/typelevel/cats/pull/3042) Remove unused type parameter for Parallel instances  by @travisbrown
        

### 1 bug fix

* [#3037](https://github.com/typelevel/cats/pull/3037) Add cats.kernel.instances.finiteDuration package  by @travisbrown
        

### 1 documentation improvement

* [#3034](https://github.com/typelevel/cats/pull/3034) minor typo fixed  by @ikr0m



## Version 2.0.0-RC3

> 2019 September 7

Cats 2.0.0-RC3 is the third release candidate for Cats 2.0, and is available for Scala 2.11, 2.12, 2.13, and Scala.js 0.6. This release (like the upcoming 2.0.0) maintains binary compatibility with Cats 1.x.x in the cats-kernel, cats-core and cats-free modules, but not cats-laws, cats-kernel-laws, cats-testkit, or alleycats.

### 2 source breaking changes

* [#3033](https://github.com/typelevel/cats/pull/3033) Move Parallel instances for EitherT and OptionT into implicit scope  by @travisbrown
* [#3031](https://github.com/typelevel/cats/pull/3031) Add Parallel.apply overload with one type parameter  by @travisbrown


### 3 documentation improvements

* [#3028](https://github.com/typelevel/cats/pull/3028) Doc fixes  by @mebubo
* [#3020](https://github.com/typelevel/cats/pull/3020) [DOC] Fix optionT link in monad documentation  by @CucumisSativus
* [#3019](https://github.com/typelevel/cats/pull/3019) Fix typo in Comonad documentation  by @chiller


### 4 build improvements

* [#3027](https://github.com/typelevel/cats/pull/3027) Update sbt-sonatype to 2.6  by @scala-steward
* [#3021](https://github.com/typelevel/cats/pull/3021) Update sbt-microsites to 0.9.4  by @scala-steward
* [#3017](https://github.com/typelevel/cats/pull/3017) Update sbt-microsites to 0.9.3  by @scala-steward
* [#3014](https://github.com/typelevel/cats/pull/3014) Update sbt-scalafmt to 2.0.4  by @scala-steward


## Version 2.0.0-RC2

> 2019 August 26

Cats 2.0.0-RC2 is the second release candidate for Cats 2.0, and is available for Scala 2.11, 2.12, 2.13, and Scala.js 0.6. This release (like the upcoming 2.0.0) maintains binary compatibility with Cats 1.x.x in the cats-kernel, cats-core and cats-free modules, but not cats-laws, cats-kernel-laws, cats-testkit, or alleycats.

### 4 source breaking changes

* [#3012](https://github.com/typelevel/cats/pull/3012) Make Parallel's F a type member  by @travisbrown
* [#3003](https://github.com/typelevel/cats/pull/3003) Make bincompat and prioritization traits package-private  by @travisbrown
* [#3001](https://github.com/typelevel/cats/pull/3001) Move appropriate SortedSet and SortedMap instances to kernel  by @travisbrown
* [#2983](https://github.com/typelevel/cats/pull/2983) Treat Stream and LazyList as different types  by @travisbrown

### 2 bug fixes

* [#3010](https://github.com/typelevel/cats/pull/3010) Fix a few issues related to bin-compat traits  by @travisbrown
* [#3004](https://github.com/typelevel/cats/pull/3004) Fix argument order in deprecations  by @travisbrown

### 9 API/feature enhancements

* [#3002](https://github.com/typelevel/cats/pull/3002) Fix easy typos  by @travisbrown
* [#2999](https://github.com/typelevel/cats/pull/2999) optimize chain's get.  by @takayahilton
* [#2996](https://github.com/typelevel/cats/pull/2996) Add :== unapply to Chain.  by @takayahilton
* [#2995](https://github.com/typelevel/cats/pull/2995) Chain optimize map method  by @gagandeepkalra
* [#2990](https://github.com/typelevel/cats/pull/2990) unapplySeq in Chain (issue #2960)  by @vasiliybondarenko
* [#2989](https://github.com/typelevel/cats/pull/2989) Add Hash instance for NonEmptyMap.  by @takayahilton
* [#2984](https://github.com/typelevel/cats/pull/2984) improve liftTo/rethrowT/raiseOrPure syntax to be more flexible  by @bpholt
* [#2981](https://github.com/typelevel/cats/pull/2981) Add Hash instance for NonEmptySet.  by @takayahilton
* [#2980](https://github.com/typelevel/cats/pull/2980) Remove redundant type annotation.  by @takayahilton

### 2 documentation improvements

* [#2993](https://github.com/typelevel/cats/pull/2993) add missing parenthese in faq.md  by @xuwei-k
* [#2985](https://github.com/typelevel/cats/pull/2985) fix a typo in `comonad.md`  by @pismute

### 4 build improvements

* [#2987](https://github.com/typelevel/cats/pull/2987) Update snakeyaml to 1.25  by @scala-steward
* [#2986](https://github.com/typelevel/cats/pull/2986) Update scalafmt to 2.0.1  by @scala-steward
* [#2979](https://github.com/typelevel/cats/pull/2979) Update sbt-scalafmt to 2.0.3  by @scala-steward
* [#2978](https://github.com/typelevel/cats/pull/2978) Update Scala 2.12 to 2.12.9  by @jhnsmth


## Version 2.0.0-RC1

> 2019 August 5

Cats 2.0.0-RC1 is the first release candidate for Cats 2.0, It's available on Scala 2.11, 2.12, 2.13 and Scala.js 0.6.
Cats 2.0.0-RC1 (like the upcoming 2.0.0 release) maintains binary compatibility with Cats 1.x.x in the cats-kernel, cats-core and cats-free modules, but not cats-laws, cats-kernel-laws, cats-testkit, or alleycats. 

### 2 breaking changes

* [#2970](https://github.com/typelevel/cats/pull/2970) Decouple published modules from scalatest  by @rossabaker
* [#2896](https://github.com/typelevel/cats/pull/2896) replace `Stream` in ExhaustiveCheck with `List`  by @kailuowang


### 1 bug fix

* [#2942](https://github.com/typelevel/cats/pull/2942) fix Cofree.cata stack-safety #2940  by @road21

### 21 API/feature enhancements

* [#2969](https://github.com/typelevel/cats/pull/2969) Add syntax to option.  by @takayahilton
* [#2964](https://github.com/typelevel/cats/pull/2964) Implement LazyList tailRecM using Iterator.unfold  by @andyscott
* [#2956](https://github.com/typelevel/cats/pull/2956) added Chain#takeWhile and Chain#dropWhile  by @kailuowang
* [#2953](https://github.com/typelevel/cats/pull/2953) Add method init and last to NonEmptyChain like NonEmptyList.  by @takayahilton
* [#2946](https://github.com/typelevel/cats/pull/2946) add unordered parallel variants of (flat)traverse and (flat)sequence  by @mberndt123
* [#2941](https://github.com/typelevel/cats/pull/2941) Added `NonEmptyLazyList` to replace `NonEmptyStream`  by @kailuowang
* [#2939](https://github.com/typelevel/cats/pull/2939) add map to NonEmptyChain.  by @takayahilton
* [#2929](https://github.com/typelevel/cats/pull/2929) Migrate to new kind-projector symbol  by @LukaJCB
* [#2925](https://github.com/typelevel/cats/pull/2925) Replace machinist macros by plain forwarders  by @smarter
* [#2924](https://github.com/typelevel/cats/pull/2924) More stack safety for IndexedReaderWriterStateT & IndexedStateT  by @ybasket
* [#2922](https://github.com/typelevel/cats/pull/2922) Reader contravariant on input type A  by @kklorenzotesta
* [#2917](https://github.com/typelevel/cats/pull/2917) Implement local for Reader  by @jooohn
* [#2916](https://github.com/typelevel/cats/pull/2916) Add listen for Writer and WriterT  by @jooohn
* [#2914](https://github.com/typelevel/cats/pull/2914) Fixed all 2.13 warnings, reenabled fatalWarning on 2.13  by @kailuowang
* [#2913](https://github.com/typelevel/cats/pull/2913) Add LowerBounded and UpperBounded typeclasses  by @izeigerman
* [#2911](https://github.com/typelevel/cats/pull/2911) fixed more warnings on 2.13  by @kailuowang
* [#2904](https://github.com/typelevel/cats/pull/2904) Cross compile replace Stream with LazyList on Scala 2.13  by @kailuowang
* [#2895](https://github.com/typelevel/cats/pull/2895) Replace ⇒ with => to avoid Scala 2.13 warnings  by @travisbrown
* [#2889](https://github.com/typelevel/cats/pull/2889) Add missing factories similar to existing factories  by @morgen-peschke
* [#2880](https://github.com/typelevel/cats/pull/2880) Improve MonadError rethrow syntax to be more flexible  by @bpholt
* [#2787](https://github.com/typelevel/cats/pull/2787) Add Order instance for NonEmptySet (#2779)  by @jatcwang

### 7 documentation improvements

* [#2967](https://github.com/typelevel/cats/pull/2967) Fix FunctorFilter mapFilter doc example  by @regadas
* [#2966](https://github.com/typelevel/cats/pull/2966) add ContT to Data Types menu  by @Jasper-M
* [#2949](https://github.com/typelevel/cats/pull/2949) Update "README.md" for Scala 2.13.0 compiler specification changing(a… by @SeanDaru
* [#2921](https://github.com/typelevel/cats/pull/2921) Fix typo in show.md  by @ollyw
* [#2888](https://github.com/typelevel/cats/pull/2888) Comonad documentation  by @justinhj
* [#2881](https://github.com/typelevel/cats/pull/2881) improve process document and release notes script  by @kailuowang
* [#2876](https://github.com/typelevel/cats/pull/2876) Fix typo  by @asakaev
        

### 1 test improvement

* [#2915](https://github.com/typelevel/cats/pull/2915) Add OrderTests for SortedSet  by @jooohn
        

### 14 build improvements

* [#2923](https://github.com/typelevel/cats/pull/2923) Update sbt-scalafmt to 2.0.2  by @scala-steward
* [#2918](https://github.com/typelevel/cats/pull/2918) Update sbt-scala-native-crossproject, ... to 0.6.1  by @scala-steward
* [#2912](https://github.com/typelevel/cats/pull/2912) Update sbt-microsites to 0.9.2  by @scala-steward
* [#2908](https://github.com/typelevel/cats/pull/2908) Update sbt-scalafmt to 2.0.1  by @fthomas
* [#2907](https://github.com/typelevel/cats/pull/2907) Update sbt-scalafix to 0.9.5  by @fthomas
* [#2906](https://github.com/typelevel/cats/pull/2906) Update sbt-microsites to 0.9.1  by @scala-steward
* [#2902](https://github.com/typelevel/cats/pull/2902) Update sbt-sonatype to 2.5  by @scala-steward
* [#2901](https://github.com/typelevel/cats/pull/2901) Update sbt-scoverage to 1.6.0  by @scala-steward
* [#2900](https://github.com/typelevel/cats/pull/2900) Update sbt-doctest to 0.9.5  by @scala-steward
* [#2899](https://github.com/typelevel/cats/pull/2899) Update sbt-microsites to 0.7.27  by @scala-steward
* [#2897](https://github.com/typelevel/cats/pull/2897) Update sbt-jmh to 0.3.7  by @scala-steward
* [#2882](https://github.com/typelevel/cats/pull/2882) Update tut-plugin to 0.6.12  by @scala-steward
* [#2828](https://github.com/typelevel/cats/pull/2828) make stage more explicit  by @kailuowang


## Version 2.0.0-M4

> 2019 June 11

Cats 2.0.0-M4 is a milestone release for Cats 2.0 that's available on Scala 2.11, 2.12, 2.13 and Scala.js 0.6.
Cats 2.0.0-M4 (like the upcoming 2.0.0 release) maintains binary compatibility with Cats 1.x.x in the cats-kernel, cats-core and cats-free modules, but not cats-laws, cats-kernel-laws, cats-testkit, or alleycats.

### 2 documentation additions/fixes

* [#2868](https://github.com/typelevel/cats/pull/2868) mention cats by example  by @TomTriple
* [#2860](https://github.com/typelevel/cats/pull/2860) Remove index.md from post-release process  by @rossabaker


### 1 build improvements

* [#2884](https://github.com/typelevel/cats/pull/2884) Upgrade Scala to 2.13.0  by @kailuowang


## Version 1.6.1

> 2019 June 3

Cats 1.6.1 is binary compatible with all previous 1.x Cats releases.

### 2 API/Feature enhancements

* [#2784](https://github.com/typelevel/cats/pull/2784) Make WrappedMutableMapBase extend Serializable  by @ceedubs
* [#2728](https://github.com/typelevel/cats/pull/2728) Optimize productR in Apply  by @maphi

### 1 documentation addition/fix

* [#2842](https://github.com/typelevel/cats/pull/2842) Fix Order.max and Oder.min description comments  by @orvi

### 1 bug fix

* [#2810](https://github.com/typelevel/cats/pull/2810) Change MonadErrorOps#reject so it no longer runs effects twice  by @bplommer


## Version 2.0.0-M3

> 2019 June 1

Cats 2.0.0-M3 is a milestone release for Cats 2.0 that's available on Scala 2.11, 2.12, 2.13.0-RC3 and Scala.js 0.6.
Cats 2.0.0-M3 (like the upcoming 2.0.0 release) maintains binary compatibility with Cats 1.x.x in the cats-kernel, cats-core and cats-free modules, but not cats-laws, cats-kernel-laws, cats-testkit, or alleycats.

### 1 breaking change

* [#2830](https://github.com/typelevel/cats/pull/2830) Remove deprecated `cats.laws.discipline.eq` methods (by @kailuowang).

### 1 source-breaking change

* [#2843](https://github.com/typelevel/cats/pull/2843) `Kleisli` is now covariant in the input type (by @jcouyang).

### 1 documentation fix

* [#2842](https://github.com/typelevel/cats/pull/2842) Fixes for API docs for `Order` methods (by @orvi).

### 3 build improvements

* [#2869](https://github.com/typelevel/cats/pull/2869) Updates for 2.13.0-RC3 (by @travisbrown).
* [#2865](https://github.com/typelevel/cats/pull/2865) Update sbt-hydra plugin (by @scala-steward).
* [#2871](https://github.com/typelevel/cats/pull/2871) Remove closed-source sbt-hydra plugin (by @travisbrown).

## Version 2.0.0-M2

> 2019 May 25

Cats 2.0.0-M2 is a milestone release for Cats 2.0. It's available on Scala 2.11, Scala 2.12, Scala 2.13.0-RC2 and Scala.js 0.6.
Cats 2.0.0-M2 maintains binary compatibility on cats-kernel, cats-core and cats-free with Cats 1.x.x.
Their 2.0.0-M2 jars are drop-in replacements for 1.0.1, 1.1.0, 1.2.0, 1.3.1, 1.4.0, 1.5.0, 1.6.0, and 2.0.0-M1 jars.
cats-kernel, cats-core and cats-free 2.0.0 will remain binary compatible with 1.x.
Cats 2.0.0-M2 breaks binary compatibility on cats-laws, cats-kernel-laws, cats-testkit and alleycats.

### 1 breaking change in cats-laws

* [#2817](https://github.com/typelevel/cats/pull/2817) Added a new foldRight lazy law, move forallLazy and existLazy laws  by @kailuowang


### 6 documentation additions/fixes

* [#2855](https://github.com/typelevel/cats/pull/2855) Edit example in Parallel docs  by @Jasper-M
* [#2850](https://github.com/typelevel/cats/pull/2850) Small Readme fix  by @dispalt
* [#2819](https://github.com/typelevel/cats/pull/2819) added FreeT basic example  by @mtsokol
* [#2815](https://github.com/typelevel/cats/pull/2815) added navigation links to readme  by @kailuowang
* [#2813](https://github.com/typelevel/cats/pull/2813) Remove 'cats experimental' clause from README.md.  by @kamilkloch
* [#2811](https://github.com/typelevel/cats/pull/2811) added availability information  by @kailuowang
        

### 3 API/Feature enhancements

* [#2840](https://github.com/typelevel/cats/pull/2840) 2708 sorted set semigroupal  by @vladislavGutov
* [#2837](https://github.com/typelevel/cats/pull/2837) Delete unnecessary restriction on biFlatMap  by @AdrianRaFo
* [#2796](https://github.com/typelevel/cats/pull/2796) Added collectFirst to Chain and NonEmptyChain  by @LMnet
        

### 5 build improvements

* [#2858](https://github.com/typelevel/cats/pull/2858) Don't create the hydra.license if $HydraLicense is empty  by @dotta
* [#2857](https://github.com/typelevel/cats/pull/2857) Updates for 2.13.0-RC2  by @travisbrown
* [#2856](https://github.com/typelevel/cats/pull/2856) Update sbt-scalajs to 0.6.28  by @scala-steward
* [#2848](https://github.com/typelevel/cats/pull/2848) Enables Hydra on cats build  by @kailuowang
* [#2821](https://github.com/typelevel/cats/pull/2821) removing unused resolver  by @kailuowang
        

### 2 test improvements

* [#2831](https://github.com/typelevel/cats/pull/2831) fixed applicative monoid test  by @kailuowang
* [#2827](https://github.com/typelevel/cats/pull/2827) In Apply.semigroup test replace ` ListWrapper` with `Option`  by @kailuowang
        
### 1 bug fix

* [#2810](https://github.com/typelevel/cats/pull/2810) Change MonadErrorOps#reject so it no longer runs effects twice  by @bplommer

## Version 2.0.0-M1

> 2019 April 24

Cats 2.0.0-M1 is a milestone release for Cats 2.0. It's available on Scala 2.11, Scala 2.12, Scala 2.13.0-RC1 and Scala.js 0.6.
Cats 2.0.0-M1 maintains binary compatibility on cats-kernel, cats-core and cats-free with Cats 1.x.x.
Their 2.0.0-M1 jars are drop-in replacements for 1.0.1, 1.1.0, 1.2.0, 1.3.1, 1.4.0, 1.5.0 and 1.6.0 jars.
cats-kernel, cats-core and cats-free 2.0.0 will remain binary compatible with 1.x.
Cats 2.0.0-M1 breaks binary compatibility on cats-laws, cats-kernel-laws, cats-testkit and alleycats.

### Breaking changes 

* cats-laws and cats-kernel-laws now depend on ScalaCheck 1.14.0 which is not binary compatible with ScalaCheck 1.13.
* cats-testkit now depends on Scalatest 3.1.0-SNAP9 whics is not backward compatible with Scalatest 3.0.x.
* alleycats no longer supports export-hook.
* [#2672](https://github.com/typelevel/cats/pull/2672) Alter from Reflexitivity to Reflexivity   by @mattkohl
* [#2640](https://github.com/typelevel/cats/pull/2640) Strong profunctor laws based on category theory  by @lemastero


### 4 documentation additions/fixes

* [#2803](https://github.com/typelevel/cats/pull/2803) Fix repetition in NonEmptyChain scala docs  by @Obarros
* [#2753](https://github.com/typelevel/cats/pull/2753) fix typo in faq.md  by @xuwei-k
* [#2736](https://github.com/typelevel/cats/pull/2736) Fix minor typo in parse-test-durations.awk example  by @ceedubs
* [#2722](https://github.com/typelevel/cats/pull/2722) Add more doctests to Kleisli  by @nasadorian
        

### 18 API/Feature enhancements

* [#2794](https://github.com/typelevel/cats/pull/2794) removed export hook  by @kailuowang
* [#2791](https://github.com/typelevel/cats/pull/2791) Remove catalysts dependency  by @travisbrown
* [#2785](https://github.com/typelevel/cats/pull/2785) Fix unconventional package objects in kernel  by @denisrosca
* [#2780](https://github.com/typelevel/cats/pull/2780) added `foldF` to `EitherT`  by @kailuowang
* [#2775](https://github.com/typelevel/cats/pull/2775) Distributive instance for Representable Functor  by @catostrophe
* [#2765](https://github.com/typelevel/cats/pull/2765) Define OptionT.mapFilter in terms of OptionT.subflatMap  by @morgen-peschke
* [#2760](https://github.com/typelevel/cats/pull/2760) Make MonoidK[Endo] stack safe on combineK  by @denisrosca
* [#2759](https://github.com/typelevel/cats/pull/2759) Category[Is] and related tests  by @ctongfei
* [#2750](https://github.com/typelevel/cats/pull/2750) Par functions for Bitraverse  by @catostrophe
* [#2747](https://github.com/typelevel/cats/pull/2747) add method on `object CommutativeApplicative` to get `CommutativeMonoid`  by @alexeygorobets
* [#2744](https://github.com/typelevel/cats/pull/2744) MonoidK instances for Map and SortedMap  by @alexeygorobets
* [#2728](https://github.com/typelevel/cats/pull/2728) Optimize productR in Apply  by @maphi
* [#2726](https://github.com/typelevel/cats/pull/2726) Add `TraverseFilter` instance for `Set` to alleycats  by @dcastro
* [#2724](https://github.com/typelevel/cats/pull/2724) adding helper method `toFreeT` to `Free`  by @jcouyang
* [#2711](https://github.com/typelevel/cats/pull/2711) Fixes #2631 Fix InvariantMonoidal Laws  by @wojciechUrbanski
* [#2709](https://github.com/typelevel/cats/pull/2709) Adds version of mkString_ with no prefix/suffix, matching the std lib.  by @matthughes
* [#2698](https://github.com/typelevel/cats/pull/2698) Add `adaptErr` to `ApplicativeErrorOps`  by @bplommer
* [#2696](https://github.com/typelevel/cats/pull/2696) Add a `defer` factory method to `ContT`  by @cb372
        

### 15 build improvements

* [#2806](https://github.com/typelevel/cats/pull/2806) update scalatest and discipline.  by @kailuowang
* [#2804](https://github.com/typelevel/cats/pull/2804) Update sbt-scala-native to 0.3.9  by @scala-steward
* [#2797](https://github.com/typelevel/cats/pull/2797) Tuning JVM options for throughput  by @DavidGregory084
* [#2793](https://github.com/typelevel/cats/pull/2793) Update sbt-jmh to 0.3.6  by @scala-steward
* [#2792](https://github.com/typelevel/cats/pull/2792) 2.13.0-RC1  by @travisbrown
* [#2786](https://github.com/typelevel/cats/pull/2786) Update tut-plugin to 0.6.11  by @scala-steward
* [#2773](https://github.com/typelevel/cats/pull/2773) Update sbt-scalajs, scalajs-compiler to 0.6.27  by @scala-steward
* [#2771](https://github.com/typelevel/cats/pull/2771) Fix our crossScalaVersions since the last change to travis.yml  by @kailuowang
* [#2764](https://github.com/typelevel/cats/pull/2764) Update sbt-jmh to 0.3.5  by @scala-steward
* [#2762](https://github.com/typelevel/cats/pull/2762) Update sbt-travisci to 1.2.0  by @scala-steward
* [#2752](https://github.com/typelevel/cats/pull/2752) added a styling stage to check the styles first  by @kailuowang
* [#2740](https://github.com/typelevel/cats/pull/2740) Update paradise to 2.1.1  by @scala-steward
* [#2737](https://github.com/typelevel/cats/pull/2737) Experiment with modularizing Travis jobs  by @ceedubs
* [#2734](https://github.com/typelevel/cats/pull/2734) upgrade to scalacheck 1.14  by @kailuowang
* [#2732](https://github.com/typelevel/cats/pull/2732) new better release settings  by @kailuowang
        

### 3 test improvments

* [#2672](https://github.com/typelevel/cats/pull/2672) Alter from Reflexitivity to Reflexivity   by @mattkohl
* [#2640](https://github.com/typelevel/cats/pull/2640) Strong profunctor laws based on category theory  by @lemastero
* [#2577](https://github.com/typelevel/cats/pull/2577) Don't depend on random sampling to determine function equivalence  by @ceedubs
        

### 2 bug fixes

* [#2784](https://github.com/typelevel/cats/pull/2784) Make WrappedMutableMapBase extend Serializable  by @ceedubs
* [#2735](https://github.com/typelevel/cats/pull/2735) Fix failing doctests  by @ceedubs



## Version 1.6.0

> 2019 Jan 31

Cats 1.6.0 is binary compatible with all previous 1.x Cats releases, i.e. its jar is a drop-in replacement for 1.0.1, 1.1.0, 1.2.0, 1.3.1, 1.4.0 and 1.5.0 jars. 
1.6.0 is mostly identical to 1.6.0-RC1 except one additional feature enhancement.

* [#2709](https://github.com/typelevel/cats/pull/2709) Adds version of mkString_ with no prefix/suffix, matching the std lib.  by @matthughes

## Version 1.6.0-RC1

> 2019 Jan 22

Cats 1.6.0-RC1 is binary compatible with all previous 1.x Cats releases, i.e. its jar is a drop-in replacement for 1.0.1, 1.1.0, 1.2.0, 1.3.1, 1.4.0 and 1.5.0 jars.

It brought you:

### 12 API/Feature enhancements

* [#2641](https://github.com/typelevel/cats/pull/2641) Adding partitionEitherM  by @blast-hardcheese
* [#2609](https://github.com/typelevel/cats/pull/2609) Add an If-Then-Else operation to the Apply.  by @diesalbla
* [#2606](https://github.com/typelevel/cats/pull/2606) Add syntax for Bitraverse to allow traversal and sequencing of the left side  by @andimiller
* [#2600](https://github.com/typelevel/cats/pull/2600) Add `sequenceFilter` syntax  by @kubukoz
* [#2563](https://github.com/typelevel/cats/pull/2563) Add an `applyK` function to `Kleisli`.  by @diesalbla
* [#2450](https://github.com/typelevel/cats/pull/2450) Add Kleisli#mapK equivalent returning FunctionK  by @kubukoz
* [#2292](https://github.com/typelevel/cats/pull/2292) Add foldMapK, reduceMapK  by @kubukoz
* [#2693](https://github.com/typelevel/cats/pull/2693) Add IndexedState alias (#2686)  by @valydia
* [#2690](https://github.com/typelevel/cats/pull/2690) Override equals and hashCode on Chain  by @ceedubs
* [#2671](https://github.com/typelevel/cats/pull/2671) add syntax <&> for parallel  by @jcouyang
* [#2655](https://github.com/typelevel/cats/pull/2655) Add `rethrowT` method to EitherT  by @bplommer
* [#2647](https://github.com/typelevel/cats/pull/2647) Move cats.tests.ListWrapper to cats-testkit  by @ArturGajowy
        

### 3 bug fixes

* [#2702](https://github.com/typelevel/cats/pull/2702) Reverted binary incompatible changes to generated parallel syntax  by @barambani
* [#2692](https://github.com/typelevel/cats/pull/2692) Private val in value classes (Resolve TODO since 2.10 is dropped)  by @barambani
* [#2670](https://github.com/typelevel/cats/pull/2670) Issue 2657 - Ambiguous duration instances  by @barambani
        

### 17 documentation additions/fixes

* [#2642](https://github.com/typelevel/cats/pull/2642) Update table headers and clarify method signature for `flatTap`  by @mtomko
* [#2636](https://github.com/typelevel/cats/pull/2636) Some changes to glossary.  by @diesalbla
* [#2630](https://github.com/typelevel/cats/pull/2630) Fix a typo in Chain's doc  by @satansk
* [#2627](https://github.com/typelevel/cats/pull/2627) A bit clarification on PULL Request template  by @kailuowang
* [#2625](https://github.com/typelevel/cats/pull/2625) Fix type signature of `productL` in cats glossary  by @mtomko
* [#2622](https://github.com/typelevel/cats/pull/2622) Fix documented constraint on B param in foldMapM  by @ksonj
* [#2574](https://github.com/typelevel/cats/pull/2574) Remove duplicate menu item in docs  by @petern-sc
* [#2277](https://github.com/typelevel/cats/pull/2277) Add an explanation for the missing Applicative instances for monad transformers  by @kubukoz
* [#2700](https://github.com/typelevel/cats/pull/2700) update the copyright  by @RafalSladek
* [#2699](https://github.com/typelevel/cats/pull/2699) typo in Comanad[Try]  by @philipschwarz
* [#2684](https://github.com/typelevel/cats/pull/2684) Fix FAQ formatting error  by @ceedubs
* [#2677](https://github.com/typelevel/cats/pull/2677) Write documentation for ContT  by @cb372
* [#2668](https://github.com/typelevel/cats/pull/2668) Fix broken link to Arrow.scala  by @DieBauer
* [#2665](https://github.com/typelevel/cats/pull/2665) minor fix  by @kailuowang
* [#2664](https://github.com/typelevel/cats/pull/2664) Cleaning up docs to no longer use fine grained imports  by @calvinbrown085
* [#2659](https://github.com/typelevel/cats/pull/2659) change prePR to run BC test on Scala 2.11  build by @kailuowang
* [#2656](https://github.com/typelevel/cats/pull/2656) Fix instructions for checking binary compatibility  by @bplommer
        

### 10 build improvements

* [#2637](https://github.com/typelevel/cats/pull/2637) Update kind-projector to 0.9.9  by @scala-steward
* [#2619](https://github.com/typelevel/cats/pull/2619) Use composite projects  by @Alistair-Johnson
* [#2703](https://github.com/typelevel/cats/pull/2703) Update simulacrum to 0.15.0  by @scala-steward
* [#2691](https://github.com/typelevel/cats/pull/2691) Don't send Gitter notifications for fork builds  by @ceedubs
* [#2681](https://github.com/typelevel/cats/pull/2681) Update sbt-release to 1.0.11  by @scala-steward
* [#2674](https://github.com/typelevel/cats/pull/2674) minor fix to build  by @kailuowang
* [#2660](https://github.com/typelevel/cats/pull/2660) Update tut-plugin to 0.6.10  by @scala-steward
* [#2654](https://github.com/typelevel/cats/pull/2654) Add a shell.nix and instructions for using it  by @ceedubs
* [#2652](https://github.com/typelevel/cats/pull/2652) Update SBT 1.2.7  by @ChristopherDavenport
* [#2643](https://github.com/typelevel/cats/pull/2643) Update sbt-scalajs, scalajs-compiler, scalajs-library... to 0.6.26  by @scala-steward


## Version 1.5.0

> 2018 Nov 30

Cats 1.5.0 is binary compatible with all previous 1.x Cats releases, i.e. its jar is a drop-in replacement for 1.0.1, 1.1.0, 1.2.0, 1.3.1 and 1.4.0 jars.

The artifacts are identical to Cats 1.5.0-RC1. For changes since 1.4.0 please check release notes of [Cats 1.5.0-RC0](https://github.com/typelevel/cats/releases/tag/v1.5.0-RC0) and [Cats 1.5.0-RC1](https://github.com/typelevel/cats/releases/tag/v1.5.0-RC1). 


## Version 1.5.0-RC1

> 2018 Nov 19

Cats 1.5.0-RC1 is binary compatible with all previous 1.x Cats releases, i.e. its jar is a drop-in replacement for 1.0.1, 1.1.0, 1.2.0, 1.3.1 and 1.4.0 jars.

It brought you:

### 5 API/Feature enhancements

* [#2610](https://github.com/typelevel/cats/pull/2610) Expose headOption for Chain  by @ChristopherDavenport
* [#2596](https://github.com/typelevel/cats/pull/2596) Add standalone Try syntax import  by @kubukoz
* [#2594](https://github.com/typelevel/cats/pull/2594) Get FunctorFilter on par with the other MTL typeclasses  by @barambani
* [#2588](https://github.com/typelevel/cats/pull/2588) Add flap function to Apply  by @ssanj
* [#2506](https://github.com/typelevel/cats/pull/2506) Add ContT monad  by @johnynek
        

### 1 test improvment

* [#2578](https://github.com/typelevel/cats/pull/2578) Add awk script to parse test durations  by @ceedubs
        

### 5 bug fixes

* [#2618](https://github.com/typelevel/cats/pull/2618) Issue 2608 - Ambiguous implicit values for Functor[Kleisli[F, A, ?]]  by @barambani
* [#2617](https://github.com/typelevel/cats/pull/2617) Make the vals inside all 'Ops' style classes private  by @coltfred
* [#2615](https://github.com/typelevel/cats/pull/2615) 2611 - MonadError syntax for OptionT uses incorrect instance  by @barambani
* [#2614](https://github.com/typelevel/cats/pull/2614) Make the value of the class private  by @coltfred
* [#2603](https://github.com/typelevel/cats/pull/2603) Rename EitherT.biflatMap  by @ochrons
        

### 1 build improvement

* [#2605](https://github.com/typelevel/cats/pull/2605) Reduce Xmx in .jvmopts and build.sbt  by @Alistair-Johnson



## Version 1.5.0-RC0

> 2018 Nov 8

Cats 1.5.0-RC0 is binary compatible with all previous 1.x Cats releases, i.e. its jar is a drop-in replacement for 1.0.1, 1.1.0, 1.2.0, 1.3.1 and 1.4.0 jars. 
 

1.5.0-RC0 brought


### 23 API/Feature enhancements

* [#2597](https://github.com/typelevel/cats/pull/2597) Optimize `Apply` methods in `FlatMap`  by @kailuowang
* [#2592](https://github.com/typelevel/cats/pull/2592) Add `updateWith` method to NonEmptyMap  by @nasadorian
* [#2579](https://github.com/typelevel/cats/pull/2579) Added `Chain#distinct` and `NonEmptyChain#distinct` to match `List#distinct` and `NonEmptyList#distinct`  by @fmsbeekmans
* [#2573](https://github.com/typelevel/cats/pull/2573) Add biFlatMap to EitherT  by @agajek
* [#2557](https://github.com/typelevel/cats/pull/2557) Add NonEmptyList#toNes (issue #2346)  by @CucumisSativus
* [#2555](https://github.com/typelevel/cats/pull/2555) Add OptionOps.toInvalidNec and OptionOps.toValidNec  by @ybasket
* [#2552](https://github.com/typelevel/cats/pull/2552) Optimize the foldM implementation for Vector  by @ceedubs
* [#2548](https://github.com/typelevel/cats/pull/2548) Missing Contravariant instance for OptionT  by @barambani
* [#2544](https://github.com/typelevel/cats/pull/2544) Adding FiniteDuration instances  by @calvinbrown085
* [#2543](https://github.com/typelevel/cats/pull/2543) Adding Nes and Nec equivalents of Nel functions  by @calvinbrown085
* [#2541](https://github.com/typelevel/cats/pull/2541) Add NonEmptyList#toNem (issue #2346)  by @CucumisSativus
* [#2535](https://github.com/typelevel/cats/pull/2535) Add NonEmptyMap#toNonEmptyList (issue #2346)  by @CucumisSativus
* [#2534](https://github.com/typelevel/cats/pull/2534) avoid deprecated macro APIs post 2.10  by @larsrh
* [#2533](https://github.com/typelevel/cats/pull/2533) Add empty to State and StateT objects  by @larsrh
* [#2527](https://github.com/typelevel/cats/pull/2527) align type parameter of smart constructor with Validated (#2525)  by @thoefer
* [#2522](https://github.com/typelevel/cats/pull/2522) added Convenience functions for Ior NonEmptyChain  by @binkabir
* [#2521](https://github.com/typelevel/cats/pull/2521) fixed eqv alias issue #2513:  by @binkabir
* [#2520](https://github.com/typelevel/cats/pull/2520) Add count as syntax to UnorderedFoldable  by @leusgalvan
* [#2515](https://github.com/typelevel/cats/pull/2515) Add Duration Instances to cats.instances.all and cats.implicits  by @LukaJCB
* [#2511](https://github.com/typelevel/cats/pull/2511) .raiseError syntax allows an error subtype  by @guersam
* [#2510](https://github.com/typelevel/cats/pull/2510) Add Pure instance for Future  by @danslapman
* [#2487](https://github.com/typelevel/cats/pull/2487) Add toValidatedNec to Validated  by @satansk
* [#2475](https://github.com/typelevel/cats/pull/2475) Add Either#toEitherNel extension and friends  by @kubukoz
        
        
### 1 bug fix

* [#2586](https://github.com/typelevel/cats/pull/2586) UnorderedFoldable#isEmpty default implementation is incorrect  by @barambani


### 16 documentation additions/fixes

* [#2576](https://github.com/typelevel/cats/pull/2576) Contributing guidelines link  by @fmsbeekmans
* [#2572](https://github.com/typelevel/cats/pull/2572) Add Alternative docs  by @stephen-lazaro
* [#2566](https://github.com/typelevel/cats/pull/2566) Add Tuple2 Example for Bifunctor  by @stephen-lazaro
* [#2564](https://github.com/typelevel/cats/pull/2564) Fixed typo in the docs  by @barambani
* [#2558](https://github.com/typelevel/cats/pull/2558) Add Nomenclature / Cheatsheet page  by @diesalbla
* [#2554](https://github.com/typelevel/cats/pull/2554) Adding the cats friendly badge link to README  by @calvinbrown085
* [#2550](https://github.com/typelevel/cats/pull/2550) Proposal: add `cats-collections` as an external cats module  by @kailuowang
* [#2549](https://github.com/typelevel/cats/pull/2549) Add FAQ for monad transformer variance  by @ceedubs
* [#2547](https://github.com/typelevel/cats/pull/2547) Fix link for contributing documentation  by @ceedubs
* [#2537](https://github.com/typelevel/cats/pull/2537) Updating Year.  by @shankarshastri
* [#2528](https://github.com/typelevel/cats/pull/2528) fix typo in validated documentation  by @ssanj
* [#2524](https://github.com/typelevel/cats/pull/2524) cats logo as svg and new "cats friendly" badge  by @thoefer
* [#2512](https://github.com/typelevel/cats/pull/2512) Add definition of point-wise to README  by @AaronDelaplane
* [#2505](https://github.com/typelevel/cats/pull/2505) Add Chain docs  by @LukaJCB
* [#2472](https://github.com/typelevel/cats/pull/2472) Replace List with Chain in Validated's docs  by @satansk
* [#2459](https://github.com/typelevel/cats/pull/2459) Add documentation for FlatMap and Bifunctor  by @asoltysik
        

### 20 build improvements

* [#2591](https://github.com/typelevel/cats/pull/2591) Update tut-plugin to 0.6.9  by @scala-steward
* [#2590](https://github.com/typelevel/cats/pull/2590) Update sbt-release to 1.0.10  by @scala-steward
* [#2589](https://github.com/typelevel/cats/pull/2589) updated to 2.13-M5 by @kailuowang
* [#2583](https://github.com/typelevel/cats/pull/2583) added a prePR command and PR template to remind people to run it  by @kailuowang
* [#2581](https://github.com/typelevel/cats/pull/2581) Fix test fork settings I think  by @ceedubs
* [#2568](https://github.com/typelevel/cats/pull/2568) give test more memory  by @kailuowang
* [#2565](https://github.com/typelevel/cats/pull/2565) Disable Scala Native build for kernel  by @agajek
* [#2562](https://github.com/typelevel/cats/pull/2562) Introduce Scalafmt  by @joan38
* [#2507](https://github.com/typelevel/cats/pull/2507) Update sbt to 1.2.3  by @fthomas
* [#2503](https://github.com/typelevel/cats/pull/2503) Update sbt-jmh to 0.3.4  by @scala-steward
* [#2502](https://github.com/typelevel/cats/pull/2502) Update tut-core to 0.6.7  by @scala-steward
* [#2501](https://github.com/typelevel/cats/pull/2501) Update sbt-scala-native to 0.3.8  by @scala-steward
* [#2499](https://github.com/typelevel/cats/pull/2499) Update sbt-crossproject to 0.6.0  by @scala-steward
* [#2497](https://github.com/typelevel/cats/pull/2497) Update partial-unification to 1.1.2  by @scala-steward
* [#2496](https://github.com/typelevel/cats/pull/2496) Update sbt-git to 1.0.0  by @scala-steward
* [#2495](https://github.com/typelevel/cats/pull/2495) Update sbt-pgp to 1.1.2  by @scala-steward
* [#2494](https://github.com/typelevel/cats/pull/2494) Update sbt-release to 1.0.9  by @scala-steward
* [#2493](https://github.com/typelevel/cats/pull/2493) Update sbt-unidoc to 0.4.2  by @scala-steward
* [#2492](https://github.com/typelevel/cats/pull/2492) Update sbt-travisci to 1.1.3  by @scala-steward
* [#2382](https://github.com/typelevel/cats/pull/2382) Removed not used sbt-scala-native plugin and fixed importing the project into intellij by @LukaszMarchewka
        

### 2 test improvments

* [#2523](https://github.com/typelevel/cats/pull/2523) Add doctests for Semigroup, Group, and Monoid  enhancement by @DennisVDB
* [#2509](https://github.com/typelevel/cats/pull/2509) Adding tests for binary compat that can't be tested by Mima  by @kailuowang
        



## Version 1.4.0

> 2018 Sep 12

Cats 1.4.0 is binary compatible with all previous 1.x Cats releases, i.e. its jar is a drop-in replacement for 1.0.1, 1.1.0, 1.2.0, and 1.3.1 jars. 
Cats 1.3.1 introduced an unnecessary runtime dependency (scala-collection-compat), this 1.4.0 release removes it. 


1.4.0 also brought you:
 
### 2 Bug fixes 

* [#2488](https://github.com/typelevel/cats/pull/2488) Kill scala-collection-compat  by @travisbrown 
* [#2423](https://github.com/typelevel/cats/pull/2423) Fix NestedIdOps.value leaking to types of shapes `F[G[A]]`  by @zarthross 


### 4 API Enhancements
* [#2480](https://github.com/typelevel/cats/pull/2480) improve interaction with subtyping in OptionOps#liftTo  by @mberndt123 
* [#2452](https://github.com/typelevel/cats/pull/2452) Add filterFold and collectFold to Foldable  by @satansk 
* [#2426](https://github.com/typelevel/cats/pull/2426) Enrich return type for Representable.apply and add doctests  by @ceedubs 
* [#2477](https://github.com/typelevel/cats/pull/2477) Add Order#fromLessThan by @vlovgr 


### 7 Documentation Additions/Fixes

* [#2485](https://github.com/typelevel/cats/pull/2485) Proposal - add cats-tagless as an external module  by @kailuowang 
* [#2483](https://github.com/typelevel/cats/pull/2483) Add examples to Functor and verify with docstyle  by @YuvalItzchakov 
* [#2481](https://github.com/typelevel/cats/pull/2481) moved a couple of ecosystem project to more accurate section  by @kailuowang 
* [#2478](https://github.com/typelevel/cats/pull/2478) Made it slightly easier to add a Cats ecosystem project  by @kailuowang 
* [#2476](https://github.com/typelevel/cats/pull/2476) add nezasa to adopters list  by @rethab 
* [#2461](https://github.com/typelevel/cats/pull/2461) Fix typo in CHANGES  by @asakaev 
* [#2234](https://github.com/typelevel/cats/pull/2234) Fix CONTRIBUTING docs  by @asakaev 



## Version 1.3.1

> 2018 Sep 5

Cats 1.3.1 is binary compatible with all previous 1.x Cats releases, i.e. its jar is a drop-in replacement for 1.0.1, 1.1.0 and 1.2.0 jars. 
Cats 1.3.1 does not support Scala 2.10.

This is a bug fix release that fixed the binary compatibility breakage when summoning `Monad[OptionT[F, ?]]` in 1.3.0

## Version 1.3.0

> 2018 Sep 4

~Cats 1.3.0 is binary compatible with all previous 1.x Cats releases, i.e. its jar is a drop-in replacement for 1.0.1, 1.1.0 and 1.2.0 jars.~ There is a bug in this release that breaks binary compatibility when summoning `Monad[OptionT[F, ?]]`.
Cats 1.3.0 does not support Scala 2.10.


1.3.0 brought you:


### 12 API Enhancements

* [#2431](https://github.com/typelevel/cats/pull/2431) Give NonEmptyChain more presence by @LukaJCB
* [#2421](https://github.com/typelevel/cats/pull/2421) Add/fix Foldable extensions: findM and collectFirstSomeM by @catostrophe
* [#2416](https://github.com/typelevel/cats/pull/2416) add append method to NEL by @julien-truffaut
* [#2406](https://github.com/typelevel/cats/pull/2406) Add NonEmptyChain by @LukaJCB
* [#2405](https://github.com/typelevel/cats/pull/2405) Add FunctorFilter and TraverseFilter by @LukaJCB
* [#2402](https://github.com/typelevel/cats/pull/2402) Add Compose instance for Map by @denisrosca
* [#2371](https://github.com/typelevel/cats/pull/2371) Add Chain by @LukaJCB
* [#2367](https://github.com/typelevel/cats/pull/2367) add Tuple2K#swap by @aoiroaoino
* [#2366](https://github.com/typelevel/cats/pull/2366) Add Foldable extension collectFirstSomeM by @catostrophe
* [#2351](https://github.com/typelevel/cats/pull/2351) Add parTraverse_ and parSequence_ syntax by @denisrosca
* [#2345](https://github.com/typelevel/cats/pull/2345) Add one off object for importing lawless Map instances by @andyscott
* [#2314](https://github.com/typelevel/cats/pull/2314) Adding on flatTransform to OptionT as suggested.  by @abhishek7

### 1 Bug fix:

* [#2383](https://github.com/typelevel/cats/pull/2383) Monad[Free[Id, ?]] cannot be found by @barambani


### 3 Code Cleanups

* [#2451](https://github.com/typelevel/cats/pull/2451) Remove unnecessary semicolons by @satansk
* [#2425](https://github.com/typelevel/cats/pull/2425) Override size in Chain instance by @ceedubs
* [#2403](https://github.com/typelevel/cats/pull/2403) use as and void instead of map(_ => ) by @julien-truffaut

### 13 Documentation Additions/Fixes

* [#2427](https://github.com/typelevel/cats/pull/2427) Add scaladoc example for Semigroupal.product by @ceedubs
* [#2378](https://github.com/typelevel/cats/pull/2378) Fix typos detected by github.com/client9/misspell by @seratch
* [#2377](https://github.com/typelevel/cats/pull/2377) Fix minor typos in typeclasses docs by @ksonj
* [#2374](https://github.com/typelevel/cats/pull/2374) proofread: remove extra word by @jarrodu
* [#2373](https://github.com/typelevel/cats/pull/2373) add new nested to menu by @kailuowang
* [#2372](https://github.com/typelevel/cats/pull/2372) Add initial adopters list by @kubukoz
* [#2369](https://github.com/typelevel/cats/pull/2369) Add a documentation page for Nested by @cb372
* [#2368](https://github.com/typelevel/cats/pull/2368) fix typo by @letusfly85
* [#2361](https://github.com/typelevel/cats/pull/2361) Make kittens officially a Cats module (still separate repo) by @kailuowang
* [#2337](https://github.com/typelevel/cats/pull/2337) Update the outdated FAQ on IO/Task by @ceedubs
* [#2344](https://github.com/typelevel/cats/pull/2344) Use sbt-doctest for Defer example by @ceedubs
* [#2429](https://github.com/typelevel/cats/pull/2429) Replace all usage of the list Monoid in the docs with the chain Monoid by @jan0sch
* [#2465](https://github.com/typelevel/cats/pull/2465) fix laws link in CONTRIBUTING by @melrief


### 7 Build and Tests Improvements:

* [#2430](https://github.com/typelevel/cats/pull/2430) Make Chain Arbitraries recursively build concatenations by @johnynek
* [#2420](https://github.com/typelevel/cats/pull/2420) Better Chain Arbitrary by @LukaJCB
* [#2359](https://github.com/typelevel/cats/pull/2359) tweak a test to compile on latest Scala 2.13 nightlies by @SethTisue
* [#2354](https://github.com/typelevel/cats/pull/2354) temporarily disable scaladoc on 2.13 by @kailuowang
* [#2335](https://github.com/typelevel/cats/pull/2335) Updating to scala 2.13-M4 by @kailuowang
* [#2306](https://github.com/typelevel/cats/pull/2306) Drop 2.10 support / update to 2.13-M4 by @larsrh
* [##2466](https://github.com/typelevel/cats/pull/#2466) remove bench from release by @kailuowang



## Version 1.2.0

Cats 1.2.0 is binary compatible with all previous 1.x Cats releases, i.e. its jar is a drop-in replacement for 1.0.1 and 1.1.0 jars.

Cats 1.2.0 is also the last non-patch release that supports Scala 2.10. Farewell Scala 2.10. 
 
1.2.0 brought you:

### 24 API Enhancements

* [#2329](https://github.com/typelevel/cats/pull/2329) Add Representable instance for Eval. by @denisrosca
* [#2325](https://github.com/typelevel/cats/pull/2325) Add Cofree.ana and Cofree.anaEval. by @andyscott
* [#2315](https://github.com/typelevel/cats/pull/2315) Add choice syntax. by @catostrophe
* [#2299](https://github.com/typelevel/cats/pull/2299) 2228-add MonadError instance for optionT where F is a Monad. by @heyrutvik
* [#2297](https://github.com/typelevel/cats/pull/2297) Make cats.data.AndThen public. by @alexandru
* [#2293](https://github.com/typelevel/cats/pull/2293) added `liftTo` syntax to `Validated`. by @kailuowang
* [#2285](https://github.com/typelevel/cats/pull/2285) Add groupBy for NonEmptySet. by @Obarros
* [#2284](https://github.com/typelevel/cats/pull/2284) Add Representable Functor  enhancemen. by @eli
* [#2279](https://github.com/typelevel/cats/pull/2279) Add Defer typeclass, laws and implementations. by @johnynek
* [#2274](https://github.com/typelevel/cats/pull/2274) Adding biSemiflatMap to EitherT (#2269). by @ericaovo
* [#2262](https://github.com/typelevel/cats/pull/2262) Add `.nested` syntax.. by @danielkarch
* [#2259](https://github.com/typelevel/cats/pull/2259) Add a Binested data type. by @iravid
* [#2258](https://github.com/typelevel/cats/pull/2258) updated trait ComposedFoldable in Composed.scala. by @Zhen
* [#2256](https://github.com/typelevel/cats/pull/2256) Add .parFlatTraverse and .parFlatSequence syntax. by @Avasil
* [#2253](https://github.com/typelevel/cats/pull/2253) Add .toOptionT to option syntax. by @marcodippy
* [#2252](https://github.com/typelevel/cats/pull/2252) Add tapWithF to Kleisli. by @marcodippy
* [#2249](https://github.com/typelevel/cats/pull/2249) Add some FlatMap loops useful for State and Effects. by @johnynek
* [#2246](https://github.com/typelevel/cats/pull/2246) Use unit from Applicative. by @johnynek
* [#2243](https://github.com/typelevel/cats/pull/2243) Add `orElse` to ApplicativeError. by @barambani
* [#2232](https://github.com/typelevel/cats/pull/2232) Change override of neqv in Order. by @ceedubs
* [#2219](https://github.com/typelevel/cats/pull/2219) Add Bimonad instance to NEL and NEV. by @LukaJCB
* [#2217](https://github.com/typelevel/cats/pull/2217) Add dual categories.. by @sellout
* [#2204](https://github.com/typelevel/cats/pull/2204) Added commutative apply and applicative to Const. by @barambani
* [#2191](https://github.com/typelevel/cats/pull/2191) Extend Functor implementation in the Traverse instance of EitherT, OptionT and Tuple2K. by @barambani


### 22 Documentation Additions/Fixes

* [#2330](https://github.com/typelevel/cats/pull/2330) Add droste to project list. by @andyscott
* [#2311](https://github.com/typelevel/cats/pull/2311) Add Rainier to the cats library list. by @andyscott
* [#2307](https://github.com/typelevel/cats/pull/2307) Specify the source of the autogenerated boilerplate. by @dadepo
* [#2303](https://github.com/typelevel/cats/pull/2303) Change scaladoc link title to "API Documentation". by @Obarros
* [#2291](https://github.com/typelevel/cats/pull/2291) Update Bitraverse docs. by @Zelenya
* [#2280](https://github.com/typelevel/cats/pull/2280) add editor setup tips to contrib guide. by @eli
* [#2278](https://github.com/typelevel/cats/pull/2278) Elaborate on Foldable#collectFirst comment. by @kubukoz
* [#2270](https://github.com/typelevel/cats/pull/2270) markdown improvements. by @martijnhoekstra
* [#2266](https://github.com/typelevel/cats/pull/2266) Update 'Scala with Cats' reference in docs. by @guersam
* [#2251](https://github.com/typelevel/cats/pull/2251) Be more precise about left vs right in Foldable doc. by @ceedubs
* [#2248](https://github.com/typelevel/cats/pull/2248) Update state.md. by @rsekulski
* [#2247](https://github.com/typelevel/cats/pull/2247) Add fastparse-cats to the list of projects. by @johnynek
* [#2245](https://github.com/typelevel/cats/pull/2245) clarify law testing's dependency on cats-testkit and scalates. by @kailuowang
* [#2241](https://github.com/typelevel/cats/pull/2241) Added shims to the ecosystem list. by @djspiewak
* [#2226](https://github.com/typelevel/cats/pull/2226) Slight clean up of State docs. by @ceedubs
* [#2225](https://github.com/typelevel/cats/pull/2225) Add doctest example for groupByNel. by @ceedubs
* [#2223](https://github.com/typelevel/cats/pull/2223) replace cats with Cats for consistency in README.md. by @satansk
* [#2222](https://github.com/typelevel/cats/pull/2222) Port alleycats README.md from the defunct repo. by @longcao
* [#2221](https://github.com/typelevel/cats/pull/2221) Update contributors guide. by @AlejandroME
* [#2218](https://github.com/typelevel/cats/pull/2218) Remove extra 'a' in eithert.md. by @donaldosalas
* [#2211](https://github.com/typelevel/cats/pull/2211) 2.12.x no longer needs future-tense. by @mattkohl
* [#2178](https://github.com/typelevel/cats/pull/2178) Add jump start guide. by @PawelLipski

### 12 Build and Tests Improvements:

* [#2302](https://github.com/typelevel/cats/pull/2302) Update sbt-partial-unification with support for 2.13.0-M4. by @kailuowang
* [#2301](https://github.com/typelevel/cats/pull/2301) sbt 1.1.6. by @sullis
* [#2298](https://github.com/typelevel/cats/pull/2298) Replace to new jvm flag. by @jiminhsieh
* [#2265](https://github.com/typelevel/cats/pull/2265) Add Function To Check All Relevant MiMa Versions. by @ChristopherDavenport
* [#2264](https://github.com/typelevel/cats/pull/2264) update bin compat versions to 1.0.0 and 1.1.0. by @kailuowang
* [#2260](https://github.com/typelevel/cats/pull/2260) Update Scala, sbt, and sbt plugins. by @fthomas
* [#2206](https://github.com/typelevel/cats/pull/2206) upgraded scala 2.12.5. by @kailuowang
* [#2205](https://github.com/typelevel/cats/pull/2205) Use helper addSbtCoursier in project/plugins.sbt. by @BennyHill
* [#2203](https://github.com/typelevel/cats/pull/2203) Add support for 2.13.0-M3. by @BennyHill
* [#2215](https://github.com/typelevel/cats/pull/2215) Test Show instance for Duration. by @ceedubs
* [#2214](https://github.com/typelevel/cats/pull/2214) Check MonadTests for Vector and List. by @ceedubs
* [#2213](https://github.com/typelevel/cats/pull/2213) Use poly lambda syntax in FreeApplicative test. @ceedubs


## Version 1.1.0

Cats 1.1.0 is binary compatible with 1.0.1, i.e. its jar is a drop-in replacement for the 1.0.1 jar.

1.1.0 brought you:

### 15 API Enhancements

* [#2194](https://github.com/typelevel/cats/pull/2194) Add `reject` (partial function) method to MonadError  by @Wogan
* [#2192](https://github.com/typelevel/cats/pull/2192) Add valueOrF to EitherT  by @denisrosca
* [#2183](https://github.com/typelevel/cats/pull/2183) Add parTuple  by @barambani
* [#2182](https://github.com/typelevel/cats/pull/2182) Add `Foldable`, `Traverse` and `Comonad` instances to `WriterT`  by @barambani
* [#2179](https://github.com/typelevel/cats/pull/2179) added `liftTo` to `Try`, `Either` and `Option`  by @kailuowang
* [#2169](https://github.com/typelevel/cats/pull/2169) Add FreeT.inject helper function (#1534)  by @valydia
* [#2159](https://github.com/typelevel/cats/pull/2159) Added Bitraverse for Ior (#2144)  by @V-Lamp
* [#2150](https://github.com/typelevel/cats/pull/2150) contravariant coyoneda  by @tpolecat
* [#2149](https://github.com/typelevel/cats/pull/2149) Add leftFlatMap to Either  by @rohanshah
* [#2146](https://github.com/typelevel/cats/pull/2146) added `leftNel` and `rightNel` syntax  by @kailuowang
* [#2143](https://github.com/typelevel/cats/pull/2143) Add NonEmptySet  by @LukaJCB
* [#2141](https://github.com/typelevel/cats/pull/2141) Add NonEmptyMap  by @LukaJCB
* [#2123](https://github.com/typelevel/cats/pull/2123) Add `contains_`, `foldSmash` and `mkString_` to `FoldableOps`  by @rsoeldner
* [#2119](https://github.com/typelevel/cats/pull/2119) Fixes type params for OptionT.getOrElse(F)  by @fcanedo
* [#2076](https://github.com/typelevel/cats/pull/2076) Add `Endo` type alias for (`A => A`)  by @kailuowang

### 4 Bug Fixes

* [#2188](https://github.com/typelevel/cats/pull/2188) Remove calls to PartialFunction.apply, deprecated in 2.12.5  by @BennyHill
* [#2187](https://github.com/typelevel/cats/pull/2187) Fix #2186: make IndexedStateT stack safe  by @alexandru
* [#2185](https://github.com/typelevel/cats/pull/2185) Fix #1733: make Kleisli.flatMap stack safe  by @alexandru
* [#2148](https://github.com/typelevel/cats/pull/2148) Add missing UnorderedTraverse syntax  by @andyscott

### 16 Documentation Additions/Fixes

* [#2196](https://github.com/typelevel/cats/pull/2196) Add "Law Testing" to side menu to increase visiblity.  by @wjlow
* [#2190](https://github.com/typelevel/cats/pull/2190) Add Ciris to list of projects in readme  by @vlovgr
* [#2184](https://github.com/typelevel/cats/pull/2184) Add Dsl.scala in the cats ecosystem  by @Atry
* [#2177](https://github.com/typelevel/cats/pull/2177) Docs: Updated typeclass instances table  by @battermann
* [#2171](https://github.com/typelevel/cats/pull/2171) adding validation video  by @Andrea
* [#2165](https://github.com/typelevel/cats/pull/2165) Add types in the Kleisli code sample for composition  by @jcranky
* [#2156](https://github.com/typelevel/cats/pull/2156) Fix Spooky scaladoc typo  by @jcranky
* [#2155](https://github.com/typelevel/cats/pull/2155) Fix broken link in parallel documentation  by @allantl
* [#2154](https://github.com/typelevel/cats/pull/2154) contravariant.md [reversing roles of A and B in commentary to match the code] by @phderome
* [#2153](https://github.com/typelevel/cats/pull/2153) added ammonite instructions to faq  by @kailuowang
* [#2145](https://github.com/typelevel/cats/pull/2145) Update version in lawtesting docs  by @LukaJCB
* [#2140](https://github.com/typelevel/cats/pull/2140) Set micrositeDocumentationUrl as root-relative  by @calvellido
* [#2134](https://github.com/typelevel/cats/pull/2134) Minor scaladoc fix for :::  by @jcranky
* [#2125](https://github.com/typelevel/cats/pull/2125) Wrong link in Eval doc  by @gruggiero
* [#2122](https://github.com/typelevel/cats/pull/2122) Add doctest example for ApplicativeError.raiseError  by @ceedubs
* [#1720](https://github.com/typelevel/cats/pull/1720) type classes with only defined laws to guideline  by @kailuowang


### 4 Build Improvements:

* [#2189](https://github.com/typelevel/cats/pull/2189) split build jvm,add workers to kernel  by @BennyHill
* [#2164](https://github.com/typelevel/cats/pull/2164) remove java 7 build  by @xuwe
* [#2158](https://github.com/typelevel/cats/pull/2158) update travis cache settings  by @kailuowang
* [#1919](https://github.com/typelevel/cats/pull/1919) update to sbt 1.0  by @kailuowang


## Version 1.0.1

> 2017 Dec 31

There is zero code change since 1.0.0. This is a release to fix the 1.0.0-MF issue that on Maven 1.0.0-MF is deemed later than 1.0.0. 
For details see [#2131](https://github.com/typelevel/cats/issues/2131)


## Version 1.0.0

> 2017 Dec 25

### Documentation Improvements/Additions:

* [#2121](https://github.com/typelevel/cats/pull/2121) Update deprecations to `product{L,R}` instead of `ap{L,R}`  by @rossabaker
* [#2086](https://github.com/typelevel/cats/pull/2086) Add doctest examples for `Apply` by @ceedubs
* [#2080](https://github.com/typelevel/cats/pull/2080) Add grouping to scaladoc for arity methods by @ceedubs  



## Version 1.0.0-RC2

> 2017 Dec 18


### Breaking changes and migration

* [#2039](https://github.com/typelevel/cats/pull/2039) Remove `Applicative#traverse` and `Applicative#sequence` by @kubukoz
* [#2033](https://github.com/typelevel/cats/pull/2033) standardise on `liftF` and add `liftK` to transformers by @SystemFw
* [#2083](https://github.com/typelevel/cats/pull/2083) Change forEffect/followedBy to productL/productR by @Jacoby6000
* [#2088](https://github.com/typelevel/cats/pull/2088) Add `InvariantSemigroupal` and `ability` to turn `Monoidal`s to `Monoid`s by @LukaJCB

### New features / enhancements (API, instances, data types, etc.):

* [#1949](https://github.com/typelevel/cats/pull/1949) Add ::: to NonEmptyList by @jcranky
* [#2020](https://github.com/typelevel/cats/pull/2020) Add `foldl` and `foldr` aliases to `Foldable` by @felixmulder
* [#2024](https://github.com/typelevel/cats/pull/2024) Optimize foldMap implementations with combineAll by @carymrobbins
* [#1938](https://github.com/typelevel/cats/pull/1938) Add more Parallel instances by @LukaJCB
* [#2030](https://github.com/typelevel/cats/pull/2030) added `collectFirst` and `collectFirstSome` to `Foldable` by @kailuowang
* [#1977](https://github.com/typelevel/cats/pull/1977) Add Ior Monad Transformer by @frroliveira
* [#2038](https://github.com/typelevel/cats/pull/2038) Add &> and <& as syntax for Parallel by @LukaJCB
* [#1981](https://github.com/typelevel/cats/pull/1981) Add UnorderedFoldable and UnorderedTraverse by @LukaJCB
* [#2047](https://github.com/typelevel/cats/pull/2047) CommutativeMonoid instance for SortedMap by @alonsodomin
* [#2043](https://github.com/typelevel/cats/pull/2043) Removed deprecation of >> and changed its param to be a by-name by @mpilquist
* [#2034](https://github.com/typelevel/cats/pull/2034) Add ContravariantMonoidal by @stephen-lazaro
* [#2057](https://github.com/typelevel/cats/pull/2057) Add `Ior.fromEither` by @markus1189
* [#2056](https://github.com/typelevel/cats/pull/2056) Functor.fmap by @fosskers
* [#2059](https://github.com/typelevel/cats/pull/2059) Add Parallel instance for Ior by @andyscott
* [#2061](https://github.com/typelevel/cats/pull/2061) Add `MonadError.rethrow` by @SystemFw
* [#2072](https://github.com/typelevel/cats/pull/2072) added a default id for Arrow by @kailuowang
* [#2063](https://github.com/typelevel/cats/pull/2063) Added `merge` (product) to `Arrow` for arrows composition by @marcobattaglia
* [#2060](https://github.com/typelevel/cats/pull/2060) Add parallel instance for IorT by @andyscott
* [#2046](https://github.com/typelevel/cats/pull/2046) Add distributive typeclass and some instances by @coltfred
* [#2099](https://github.com/typelevel/cats/pull/2099) CommutativeMonad and CommutativeFlatMap instances for Tuple2 by @ceedubs
* [#2096](https://github.com/typelevel/cats/pull/2096) Add Arrow Choice by @stephen-lazaro
* [#2098](https://github.com/typelevel/cats/pull/2098) Add a CommutativeMonoid for Map by @ceedubs
* [#2101](https://github.com/typelevel/cats/pull/2101) Add Semigroup.instance method by @jozic
* [#2103](https://github.com/typelevel/cats/pull/2103) CommutativeMonad for Eval by @ceedubs
* [#2104](https://github.com/typelevel/cats/pull/2104) Add Commutative{Monad, FlatMap} instances for IdT by @ceedubs
* [#2105](https://github.com/typelevel/cats/pull/2105) Some Kleisli instance cleanup by @ceedubs
* [#2110](https://github.com/typelevel/cats/pull/2110) add `Comparison` to `cats` package by @kailuowang
* [#2112](https://github.com/typelevel/cats/pull/2112) CoflatMap Instance for Applicative by @ChristopherDavenport
* [#2116](https://github.com/typelevel/cats/pull/2116) conversion `PartialOrder` to `PartialOrdering` and `Hash` to `Hashing`  by @kailuowang
* [#2100](https://github.com/typelevel/cats/pull/2100) Add `comparison` method in `Order` companion object by @ceedubs


### Bug fixes:

* [#2011](https://github.com/typelevel/cats/pull/2011) Rename ContravariantCartesian.scala to ContravariantSemigroupal.scala by @iravid
* [#2016](https://github.com/typelevel/cats/pull/2016) Removed redundant Eq instance by @denisrosset
* [#2029](https://github.com/typelevel/cats/pull/2029) make sure that EitherT MonadError syntax works the old way by @kailuowang


### Documentation Improvements/Additions:

* [#2007](https://github.com/typelevel/cats/pull/2007) move alleycats in readme by @kailuowang
* [#2008](https://github.com/typelevel/cats/pull/2008) Upgrade Scalafix instructions by @gabro
* [#2009](https://github.com/typelevel/cats/pull/2009) Correct it's -> its documentation errors by @kellen
* [#2017](https://github.com/typelevel/cats/pull/2017) Fix alleycats module name by @benhutchison
* [#2023](https://github.com/typelevel/cats/pull/2023) Fixes in Arrow docs by @Jasper-M
* [#2026](https://github.com/typelevel/cats/pull/2026) Correctly close a tut:silent block in faq by @vendethiel
* [#2027](https://github.com/typelevel/cats/pull/2027) Rename Validation to Validated in Validated docs by @Ttcao
* [#2036](https://github.com/typelevel/cats/pull/2036) Clean up applicative syntax doc by @bkirwi
* [#2035](https://github.com/typelevel/cats/pull/2035) Do not redirect to cats-mtl for MonadCombine by @vendethiel
* [#2048](https://github.com/typelevel/cats/pull/2048) Add direct link to the scaladoc by @fagossa
* [#2050](https://github.com/typelevel/cats/pull/2050) Link Directly to Cats Package in ScalaDoc by @stephen-lazaro
* [#2031](https://github.com/typelevel/cats/pull/2031) Add parallel docs by @LukaJCB
* [#2045](https://github.com/typelevel/cats/pull/2045) Fix scalafix testing instructions by @kubukoz
* [#2068](https://github.com/typelevel/cats/pull/2068) Update symbols table by @stephen-lazaro
* [#2070](https://github.com/typelevel/cats/pull/2070) Add some doctest examples for Alternative methods by @ceedubs
* [#2065](https://github.com/typelevel/cats/pull/2065) added entry for sbt-catalysts by @kailuowang
* [#2071](https://github.com/typelevel/cats/pull/2071) Add doc example for imap by @ceedubs
* [#2073](https://github.com/typelevel/cats/pull/2073) Add doctests for `Ior.fromOptions` by @markus1189
* [#2077](https://github.com/typelevel/cats/pull/2077) Add some doctest examples for SemigroupK/MonoidK by @ceedubs
* [#2079](https://github.com/typelevel/cats/pull/2079) Add doctest examples for Applicative by @ceedubs
* [#2095](https://github.com/typelevel/cats/pull/2095) Update guidelines.md by @kailuowang
* [#2108](https://github.com/typelevel/cats/pull/2108) Update version of deprecation to 1.0.0-RC2 by @rossabaker


### Build improvements/dependency updates

* [#2028](https://github.com/typelevel/cats/pull/2028) Lawtesting: Update scalacheck-shapeless and cats by @vendethiel
* [#2065](https://github.com/typelevel/cats/pull/2065) improve build by not displaying each success test by @kailuowang
* [#2106](https://github.com/typelevel/cats/pull/2106) Update to latest patch versions of scala by @ceedubs
* [#2114](https://github.com/typelevel/cats/pull/2114) sbt-coursier 1.0.0 by @sullis

### Testing improvements

* [#2037](https://github.com/typelevel/cats/pull/2037) Tests: MonadCombine->Alternative, add missing ones by @vendethiel 
* [#2052](https://github.com/typelevel/cats/pull/2052) Add labels to prop produced from IsEq by @nigredo-tori
* [#2053](https://github.com/typelevel/cats/pull/2053) Fix #2051, Remove superfluous implicit by @rsoeldner
* [#2081](https://github.com/typelevel/cats/pull/2081) Reduce redundancy in Semigroup and Eq test names by @ceedubs
* [#2097](https://github.com/typelevel/cats/pull/2097) added distributeIdentityLaw by @kailuowang



## Version 1.0.0-RC1

> 2017 Oct 21 

This is the only planned release candidate release prior to 1.0.0. 

### Breaking changes and migration 

* [#1964](https://github.com/typelevel/cats/pull/1964) Require an `Order` instance for `NonEmptyList`'s groupBy function  by @igstan
* [#1961](https://github.com/typelevel/cats/pull/1961) rename `Cartesian` to `Semigroupal`  by @kailuowang
* [#1955](https://github.com/typelevel/cats/pull/1955) Deprecate `FlatMap`'s `>>` and `<<`  by @LukaJCB
* [#1947](https://github.com/typelevel/cats/pull/1947) Rename `EitherT.liftT` to `EitherT.liftF`  by @aeons
* [#1934](https://github.com/typelevel/cats/pull/1934) Restruct `functor`  by @kailuowang
* [#1803](https://github.com/typelevel/cats/pull/1803) Convert `ReaderWriterStateT` to `IndexedReaderWriterStateT`  by @iravid
* [#1775](https://github.com/typelevel/cats/pull/1775) Convert `StateT` to `IndexedStateT`  by @iravid
* [#1098](https://github.com/typelevel/cats/pull/1098) Add a different `MonoidK` and `SemigroupK` instance for `Kleisli`  by @peterneyens
* [#1922](https://github.com/typelevel/cats/pull/1922) Make kernel laws consistent with core laws  by @LukaJCB
* [#1838](https://github.com/typelevel/cats/pull/1838) Sync `NonEmptyList` and `NonEmptyVector` methods by @durban
* [#1914](https://github.com/typelevel/cats/pull/1914) Add `Invariant` instances for kernel type classes by @LukaJCB 
* [#1980](https://github.com/typelevel/cats/pull/1980) Make `iterateRight` in `Foldable` sound  by @LukaJCB 
* [#1972](https://github.com/typelevel/cats/pull/1972) Add `SortedMap` and `SortedSet` instances/Move `Set` and `Map` instances to Alleycats by @LukaJCB/@kailuowang 
* [#1997](https://github.com/typelevel/cats/pull/1997) Minimizing typeclass surface in cats-kernel  by @denisrosset  
* [#1987](https://github.com/typelevel/cats/pull/1987) Add `mapK` to `transformers`  by @andyscott / @LukaJCB  

To migrate from 1.0.0-MF.

* The rename of `Cartesian` to `Semigroupal` and `EitherT.liftT` to `EitherT.liftF` can be done automatically through Scalafix we provide. See instructions [here](https://github.com/typelevel/cats/blob/master/scalafix/README.md).
* For `FlatMap`'s `>>` and `<<`, use `Apply`'s `*>` and `<*` instead.
* `Profunctor` and `Strong` were moved to the `cats.arrow` package,  `Bifunctor`, `Invariant` and `Contravariant` were moved to the `cats` root package.
* `SemigroupK[λ[α => Kleisli[F, α, α]]]` and `MonoidK[λ[α => Kleisli[F, α, α]]]` are no longer implicitly available, Use `Kleisli.endoSemigroupK` and `Kleisli.endoMonoidK` to get them explicitly.
* law testing for type classes in `cats.kernel` was made consistent with the law testing in `cats.core`. Check [here](https://typelevel.org/cats/typeclasses/lawtesting.html) for a guide on how to test cats type class instances. 
* `NonEmptyList.concat` that takes `NonEmptlyList` was deprecated, use `NonEmptyList.concatNel` instead.
* `Monoid` no longer has a `InvariantMonoidal` instance, we discovered that it's not lawful. It has have an `Invariant` and a `Semigroupal` (new name for `Cartesian`) instance. 
* `Foldable.iterateRight` now takes an `Iterable` instead of `Iterator`, see #1973 for rationale. 
* `Foldable` for `Set` and `Traversable` for `Map` were moved to Alleycats, see #1831 for rationale.
* `cats.data.Kleisli#transform` and `cats.free.Coyoneda#transform` were deprecated and replaced by `mapK`

### New features / enhancements (API, instances, data types, etc.):

* [#1958](https://github.com/typelevel/cats/pull/1958) Add `FlatMap#flatTap`, a more principled version of the kestrel combinator.  by @hrhino
* [#1950](https://github.com/typelevel/cats/pull/1950) more instances for `Hash` (#1712): `Queue`/`Duration`  by @ctongfei
* [#1942](https://github.com/typelevel/cats/pull/1942) add `traverseN` to cartesian syntax by @julien-truffaut
* [#1939](https://github.com/typelevel/cats/pull/1939) Add `guard` to `Alternative`  by @SystemFw
* [#1933](https://github.com/typelevel/cats/pull/1933) Add syntax for `ApplicativeError`.fromEither  by @tpolecat
* [#1921](https://github.com/typelevel/cats/pull/1921) Optimize `FreeApplicative.product`  by @peterneyens
* [#1910](https://github.com/typelevel/cats/pull/1910) Add `NonEmptyList.ofInitLast`  by @eddsteel
* [#1888](https://github.com/typelevel/cats/pull/1888) Enhances stack safety for `Eval`.  by @non
* [#1885](https://github.com/typelevel/cats/pull/1885) Add `zipWith` to `NonEmptyList` and `NonEmptyVector`  by @LukaJCB
* [#1882](https://github.com/typelevel/cats/pull/1882) convert trait into abstract class for better bin compact  by @kailuowang
* [#1878](https://github.com/typelevel/cats/pull/1878) Add some instances we were missing.  by @non
* [#1858](https://github.com/typelevel/cats/pull/1858) Add `NonEmptyList#partitionE`  by @LukaJCB
* [#1847](https://github.com/typelevel/cats/pull/1847) Add right and left functor to `BiFunctor`  by @LukaJCB
* [#1840](https://github.com/typelevel/cats/pull/1840) Add `Foldable` and `Traversable` instances for `Free`  by @aaronlevin
* [#1819](https://github.com/typelevel/cats/pull/1819) Added more implementations of `map2Eval` in progress  by @johnynek
* [#1811](https://github.com/typelevel/cats/pull/1811) Move tuple `Cartesian` syntax implicit parameter  by @DavidGregory084
* [#1809](https://github.com/typelevel/cats/pull/1809) Add iterateWhileM and iterateUntilM  by @drbild
* [#1790](https://github.com/typelevel/cats/pull/1790) Implement EitherT#leftFlatMap and EitherT#leftSemiflatMap  by @vendethiel
* [#1784](https://github.com/typelevel/cats/pull/1784) Add `existsM` and `forallM` to Foldable  by @refried
* [#1712](https://github.com/typelevel/cats/pull/1712) Hash typeclass  by @ctongfei
* [#1976](https://github.com/typelevel/cats/pull/1976) Reduced usage of `fold` in `Validated` for better performance by @kailuowang
* [#1967](https://github.com/typelevel/cats/pull/1967) Add a few type classes to generated tuple instances by @edmundnoble/@kailuowang
* [#1984](https://github.com/typelevel/cats/pull/1984) Welcome, Alleycats  by @kailuowang
* [#1927](https://github.com/typelevel/cats/pull/1927) Add `CommutativeApply` and `CommutativeApplicative`  by @LukaJCB
* [#1837](https://github.com/typelevel/cats/pull/1837) Add `Parallel` type class  by @LukaJCB
* [#1998](https://github.com/typelevel/cats/pull/1998) Add `Validated.cond` and `Validated.condNel`  by @andyscott


### Bug fixes:

* [#1917](https://github.com/typelevel/cats/pull/1917) Don't use package object convention for object source path  by @travisbrown
* [#1804](https://github.com/typelevel/cats/pull/1804) workaround for a possible scala bug in show for value class  by @kailuowang
* [#1980](https://github.com/typelevel/cats/pull/1980) Make `iterateRight` in `Foldable` sound  by @LukaJCB 

### Documentation Improvements/Additions:

* [#1970](https://github.com/typelevel/cats/pull/1970) Add docs for `StateT` and `IndexedStateT`  by @iravid
* [#1956](https://github.com/typelevel/cats/pull/1956) Mention the right issue number of doom.  by @hrhino
* [#1952](https://github.com/typelevel/cats/pull/1952) Added examples of `Arrow` composition  by @raymondtay
* [#1946](https://github.com/typelevel/cats/pull/1946) Give higher priority to partial-unification fix  by @LukaJCB
* [#1944](https://github.com/typelevel/cats/pull/1944) Fix typo.  by @jooohn
* [#1924](https://github.com/typelevel/cats/pull/1924) Add docs for Arrow  by @zliu41
* [#1923](https://github.com/typelevel/cats/pull/1923) Update footer  by @kailuowang
* [#1920](https://github.com/typelevel/cats/pull/1920) Document naming implicits according to @non s comment in #1061  by @tbje
* [#1916](https://github.com/typelevel/cats/pull/1916) Fix tiny extra vowel typo  by @andyscott
* [#1915](https://github.com/typelevel/cats/pull/1915) Consolidate readme.md and index.md  by @kailuowang
* [#1913](https://github.com/typelevel/cats/pull/1913) updated footer  by @kailuowang
* [#1905](https://github.com/typelevel/cats/pull/1905) s/rewrites/rules and update scalafix version in the README  by @gabro
* [#1903](https://github.com/typelevel/cats/pull/1903) `Validated` beginners doc  by @AlejandroME
* [#1901](https://github.com/typelevel/cats/pull/1901) added FAQ item diff between cats and scalaz  by @kailuowang
* [#1900](https://github.com/typelevel/cats/pull/1900) add newts to related projects  by @kailuowang
* [#1899](https://github.com/typelevel/cats/pull/1899) Fix symbol signature for right and left apply in faq.md  by @suhasgaddam
* [#1897](https://github.com/typelevel/cats/pull/1897) add bin compat goal  by @kailuowang
* [#1895](https://github.com/typelevel/cats/pull/1895) trying to fix contributing page  by @kailuowang
* [#1894](https://github.com/typelevel/cats/pull/1894) Fix typo in background image of homepage.  by @Ttcao
* [#1890](https://github.com/typelevel/cats/pull/1890) Doc: Correct the URL of cats-mtl to the typelevel repository  by @richardimaoka
* [#1884](https://github.com/typelevel/cats/pull/1884) Rename typeclass => type class in Readme.md  by @LukaJCB
* [#1880](https://github.com/typelevel/cats/pull/1880) Add law testing guide  by @LukaJCB
* [#1875](https://github.com/typelevel/cats/pull/1875) Fix typo in `SemigroupK` scaladoc  by @LukaJCB
* [#1874](https://github.com/typelevel/cats/pull/1874) Fix typo in `WriterT` tests  by @LukaJCB
* [#1873](https://github.com/typelevel/cats/pull/1873) Add pureconfig and finch to ecosystem project list  by @kailuowang
* [#1872](https://github.com/typelevel/cats/pull/1872) Fix couple of typos in CHANGES.md  by @LukaJCB
* [#1871](https://github.com/typelevel/cats/pull/1871) Fix typo in `Traverse#traverseWithIndexM`  by @LukaJCB
* [#1857](https://github.com/typelevel/cats/pull/1857) Fix typo (Foldabale => Foldable)  by @LukaJCB
* [#1856](https://github.com/typelevel/cats/pull/1856) Remove mtl classes from menu  by @LukaJCB
* [#1854](https://github.com/typelevel/cats/pull/1854) Add EitherT docs  by @Technius
* [#1846](https://github.com/typelevel/cats/pull/1846) Add `grafter` to the list of Typelevel projects using cats  by @etorreborre
* [#1845](https://github.com/typelevel/cats/pull/1845) Adding the origami project to the list of Typelevel projects using cats  by @etorreborre
* [#1827](https://github.com/typelevel/cats/pull/1827) add trailing slashes to URLs  by @larsrh
* [#1822](https://github.com/typelevel/cats/pull/1822) Add docs for `Ior`  by @LukaJCB
* [#1820](https://github.com/typelevel/cats/pull/1820) Fix links  by @n4to4
* [#1817](https://github.com/typelevel/cats/pull/1817) Add seals to related projects  by @durban
* [#1816](https://github.com/typelevel/cats/pull/1816) Add `Eval` documentation  by @LukaJCB
* [#1814](https://github.com/typelevel/cats/pull/1814) remove outdated TODOs  by @kailuowang
* [#1808](https://github.com/typelevel/cats/pull/1808) minor link change  by @kailuowang
* [#1806](https://github.com/typelevel/cats/pull/1806) add notes to cartesian migration  by @kailuowang
* [#1799](https://github.com/typelevel/cats/pull/1799) add decline to project list  by @kailuowang
* [#1796](https://github.com/typelevel/cats/pull/1796) add `Foldable.existsM/forallM` to docs  by @refried
* [#1792](https://github.com/typelevel/cats/pull/1792) Add size control for typeclass diagram  by @LukaJCB
* [#1789](https://github.com/typelevel/cats/pull/1789) Add documentation for `Show`  by @LukaJCB
* [#1788](https://github.com/typelevel/cats/pull/1788) Add `Eq` docs  by @LukaJCB
* [#1787](https://github.com/typelevel/cats/pull/1787) Add `NonEmptyTraverse` docs  by @LukaJCB
* [#1781](https://github.com/typelevel/cats/pull/1781) promoting the ecosystem in readme a bit and fixed a typo  by @kailuowang
* [#1779](https://github.com/typelevel/cats/pull/1779) quick date fix  by @kailuowang
* [#1756](https://github.com/typelevel/cats/pull/1756) Add piecemeal import guide  by @LukaJCB
* [#1777](https://github.com/typelevel/cats/pull/1777) Add `Reducible` docs  by @LukaJCB
* [#1985](https://github.com/typelevel/cats/pull/1985) Links "LawTesting.md" in FAQ and TypeClasses pages  by @AlejandroME 
* [#1993](https://github.com/typelevel/cats/pull/1993) Added examples for `Cokleisli`  by @raymondtay  

### Build improvements/dependency updates
 
* [#1948](https://github.com/typelevel/cats/pull/1948) Update scalafix project dependencies  by @aeons
* [#1926](https://github.com/typelevel/cats/pull/1926) Update coursier to version 1.0.0-RC12  by @mxl
* [#1925](https://github.com/typelevel/cats/pull/1925) temporarily disable MiMa check on kernel  by @kailuowang
* [#1918](https://github.com/typelevel/cats/pull/1918) Update sbt-microsites to 0.7.0  by @LukaJCB
* [#1902](https://github.com/typelevel/cats/pull/1902) Upgrade Scalafix to 0.5.0-RC2  by @gabro
* [#1898](https://github.com/typelevel/cats/pull/1898) Update various sbt plugins  by @fthomas
* [#1892](https://github.com/typelevel/cats/pull/1892) Remove deprecated requiresDOM setting  by @fthomas
* [#1889](https://github.com/typelevel/cats/pull/1889) Add val for "compile-time" sbt Configuration  by @fthomas
* [#1887](https://github.com/typelevel/cats/pull/1887) Update sbt-pgp to 1.1.0  by @fthomas
* [#1886](https://github.com/typelevel/cats/pull/1886) Update Scala.js to 0.6.20  by @fthomas
* [#1876](https://github.com/typelevel/cats/pull/1876) build: use curly braces for disabling tasks  by @fthomas
* [#1868](https://github.com/typelevel/cats/pull/1868) Update sbt-microsites to 0.6.1  by @BennyHill
* [#1866](https://github.com/typelevel/cats/pull/1866) Revert scalatest to 3.0.3  by @BennyHill
* [#1865](https://github.com/typelevel/cats/pull/1865) Set simulacrum version to 0.11.0  by @BennyHill
* [#1864](https://github.com/typelevel/cats/pull/1864) Set scalaz version to 7.2.15  by @BennyHill
* [#1862](https://github.com/typelevel/cats/pull/1862) Bump kind-projector version to 0.9.4  by @shokohara
* [#1861](https://github.com/typelevel/cats/pull/1861) Update sbt-scoverage to 1.5.1  by @fthomas
* [#1860](https://github.com/typelevel/cats/pull/1860) Update sbt-pgp to 1.1.0-M1  by @LukaJCB
* [#1859](https://github.com/typelevel/cats/pull/1859) Update sbt-sonatype  by @LukaJCB
* [#1852](https://github.com/typelevel/cats/pull/1852) Remove sbt-ghpages because it is pulled in by sbt-microsites  by @fthomas
* [#1849](https://github.com/typelevel/cats/pull/1849) Update sbt-git to 0.9.3  by @fthomas
* [#1844](https://github.com/typelevel/cats/pull/1844) Replace botBuild with sbt-travisci's isTravisBuild  by @fthomas
* [#1843](https://github.com/typelevel/cats/pull/1843) Update sbt-unidoc to 0.4.1  by @fthomas
* [#1842](https://github.com/typelevel/cats/pull/1842) Update partial-unification plugin to 1.1.0  by @fthomas
* [#1839](https://github.com/typelevel/cats/pull/1839) Update scalastyle-sbt-plugin to 1.0.0  by @fthomas
* [#1829](https://github.com/typelevel/cats/pull/1829) Update sbt-release to 1.0.6  by @fthomas
* [#1828](https://github.com/typelevel/cats/pull/1828) Update sbt-jmh to 0.2.27  by @fthomas
* [#1826](https://github.com/typelevel/cats/pull/1826) Pass sbt settings without varargs expansion  by @fthomas
* [#1825](https://github.com/typelevel/cats/pull/1825) Update sbt-coursier to 1.0.0-RC10  by @fthomas
* [#1824](https://github.com/typelevel/cats/pull/1824) Update sbt-mima-plugin to 0.1.17  by @fthomas
* [#1821](https://github.com/typelevel/cats/pull/1821) Update sbt-doctest to 0.7.0  by @fthomas
* [#1795](https://github.com/typelevel/cats/pull/1795) Bump discipline version to 0.8  by @shokohara
* [#1793](https://github.com/typelevel/cats/pull/1793) Add Scalafix rewrites for 1.0.0  by @gabro
* [#1782](https://github.com/typelevel/cats/pull/1782) Bump scalacheck version to 1.13.5  by @shokohara
* [#1780](https://github.com/typelevel/cats/pull/1780) Bump machinist version to 0.6.2  by @shokohara
* [#1778](https://github.com/typelevel/cats/pull/1778) Bump sbt version to 0.13.16  by @shokohara

### Testing improvements

* [#1963](https://github.com/typelevel/cats/pull/1963) Move `followedBy`/`forEffect` tests to `ApplyTests`  by @peterneyens 
* [#1960](https://github.com/typelevel/cats/pull/1960) Harmonize naming of discipline test classes in cats-kernel-laws.  by @denisrosset 
* [#1953](https://github.com/typelevel/cats/pull/1953) Add a more direct tailRecM law.  by @johnynek 
* [#1906](https://github.com/typelevel/cats/pull/1906) Fix `Alternative` law checking for `IndexedStateT`.  by @iravid 
* [#1975](https://github.com/typelevel/cats/pull/1975) Unifies test naming standard.  by @AlejandroME  
* [#1999](https://github.com/typelevel/cats/pull/1999) Fix order of comparison for `EitherT.cond`.  by @andyscott  

### Scalafix for migration

* [#1813](https://github.com/typelevel/cats/pull/1813) Add `RenameInjectProdAndCoproduct`, `RenameTupleApplySyntax` and `RemoveSplit` Scalafix rewrites by @gabro
* [#1937](https://github.com/typelevel/cats/pull/1937) Add scalafix for `contramap`  by @LukaJCB



## Version 1.0.0-MF

> 2017 Aug 3

`MF` stands for milestone final. This is the last non-RC release before 1.0.0.
 The main purpose/focus of this release is to offer a relatively stable API to
 work with prior to 1.0.0. It can be deemed as a proposal for the final API
 we are going to maintain binary compatibility after 1.0.
 We will give community some time to validate it before we release 1.0.0-RC1.
 
### To migrate from 0.9.0

We apologize for the number of breaking changes in this release. We are trying to include
as many breaking changes as possible in this release before we lock down the API. 
  
 * `cats` no longer publishes the all-inclusive bundle package `"org.typelevel" % "cats"`, use `cats-core`, `cats-free`, or `cats-law` 
   accordingly instead. If you need `cats.free`, use `"org.typelevel" % "cats-free"`, if you need `cats-laws` use 
   `"org.typelevel" % "cats-laws"`, if neither, use `"org.typelevel" % "cats-core"`.
 * `cats.free.Inject` is moved from `cats-free` to `cats-core` and renamed to `cats.InjectK`;
   `cats.data.Prod` is renamed to `cats.data.Tuple2K`; `cats.data.Coproduct` is renamed to
   `cats.data.EitherK`
 * All `Unapply` enabled methods, e.g. `sequenceU`, `traverseU`, etc. are removed. `Unapply`
   enabled syntax ops are also removed. Please use the partial unification SI-2712 fix
   instead. The easiest way might be this [sbt-plugin](https://github.com/fiadliel/sbt-partial-unification).
 *  `FunctorFilter`, `MonadFilter`, `MonadReader`, `MonadState`, `MonadTrans`, `MonadWriter` and `TraverseFilter` are no longer in `cats`, the functionalities they provided are inherited by the new [cats-mtl](https://github.com/typelevel/cats-mtl) project. Please check [here](https://github.com/typelevel/cats-mtl#migration-guide) for migration guide.
 *  `MonadCombine` is no longer in cats. Use `Alternative` or `Monad` + `MonoidK` instead.
 * `CartesianBuilder` (i.e. `|@|`) syntax is deprecated, use the apply syntax on tuples instead. E.g. `(x |@| y |@| z).map(...)` should be replaced by `(x, y, z).mapN(...)`. If you are getting "`mapN` not found" error message, it could be due to SI-2712, see the 3rd migration item above. 
 * Apply syntax on tuple (e.g. `(x, y, z).map3(...)`)  was moved from `cats.syntax.tuple._` to `cats.syntax.apply._` and renamed to `mapN`, `contramapN` and `imapN` respectively.
 * The creation methods (`left`, `right`, `apply`, `pure`, etc.) in `EitherT` were improved to take less
   type arguments.
 * Several `cats-core` type class instances for `cats.kernel` were moved from their companion objects to separate traits
   and thus require imports from `cats.instances.xxx._` (or the recommended `import cats.implicits._`) now. See #1659 for more details. 
 * `Free.suspend` is renamed to `Free.defer` for consistency. 
 * `traverse1_`, `intercalate1` and `sequence1_` in `Reducible` were renamed to `nonEmptyTraverse_`, `nonEmptyIntercalate` and `nonEmptySequence_` respectively. 
 * `foldLeftM` is removed from `Free`, use `foldM` on `Foldable` instead, see #1117 for detail. 
 * `iteratorFoldM` was removed from `Foldable` due to #1716
 * `Split` is removed, and the method `split` is moved to `Arrow`. Note that only under `CommutativeArrow` does it guarantee the non-interference between the effects. see #1567

If you feel adventurous you can try the experimental Scalafix rewrites.
See all the available rewrites and the instructions [here](/scalafix/README.md).
### Breaking Changes:

 * [#1614](https://github.com/typelevel/cats/pull/1614): added `leftT` and improved existing lift API for `EitherT`. by @kailuowang
 * [#1596](https://github.com/typelevel/cats/pull/1596): Rename `Inject` to `InjectK`. by @andyscott
 * [#1589](https://github.com/typelevel/cats/pull/1589): Rename `Prod`, `Coproduct` to `Tuple2K` and `EitherK`. by @kailuowang
 * [#1583](https://github.com/typelevel/cats/pull/1583): Enable SI-2712 fix in cats / Remove unapply machinery. by @kailuowang
 * [#1679](https://github.com/typelevel/cats/pull/1679): remove `Unapply` class. by @kailuowang
 * [#1557](https://github.com/typelevel/cats/pull/1557): Improvements to `Inject`. @sellout
 * [#1659](https://github.com/typelevel/cats/pull/1659): move instances into separate trait. by @yilinwei
 * [#1709](https://github.com/typelevel/cats/pull/1709): Rename `suspend` to `defer`. by @peterneyens
 * [#1611](https://github.com/typelevel/cats/pull/1611): Renamed `traverse1_`, `intercalate1` and `sequence1_` in `Reducible`. by @LukaJCB
 * [#1117](https://github.com/typelevel/cats/pull/1117): `foldLeftM` without `Free`. by @TomasMikula 
 * [#1487](https://github.com/typelevel/cats/pull/1487): `Apply` syntax for tuples. by @DavidGregory084
 * [#1745](https://github.com/typelevel/cats/pull/1745): Deprecate `CartesianBuilder`. by @kailuowang
 * [#1758](https://github.com/typelevel/cats/pull/1758): stop publishing cats all bundle , start to publish cats-testkit. by @kailuowang
 * [#1766](https://github.com/typelevel/cats/pull/1766): Replace `Split` with `CommutativeArrow`, introduces `CommutativeMonad`. by @diesalbla
 * [#1751](https://github.com/typelevel/cats/pull/1751): Removed `FunctorFilter`, `MonadCombine`, `MonadFilter`, `MonadReader`, `MonadState`, `MonadTrans`, `MonadWriter`, `TraverseFilter`. by @edmundnoble
 
### New Features (API, instances, data types, etc):

 * [#1707](https://github.com/typelevel/cats/pull/1707): Add NEL/NEV one. by @peterneyens 
 * [#1680](https://github.com/typelevel/cats/pull/1680): ~~`MonadTrans` instance for RWST and make `MonadTrans` serializable.~~ by @wedens
 * [#1658](https://github.com/typelevel/cats/pull/1658): Add `Validated.validNel`. by @edmundnoble
 * [#1651](https://github.com/typelevel/cats/pull/1651): ~~Add state method to `MonadState`.~~ by @oskoi
 * [#1628](https://github.com/typelevel/cats/pull/1628): add init and size methods to `NonEmptyList`. by @jtjeferreira
 * [#1612](https://github.com/typelevel/cats/pull/1612): Add ensureWith to `Validated` and `Either` (#1550). by @LukaJCB
 * [#1598](https://github.com/typelevel/cats/pull/1598): Implement a `ReaderWriterStateT` data type . by @iravid
 * [#1706](https://github.com/typelevel/cats/pull/1706): Clean up `ReaderWriterStateT`. by @peterneyens
 * [#1594](https://github.com/typelevel/cats/pull/1594): Add `NonEmptyList#fromFoldable`. by @markus1189
 * [#1611](https://github.com/typelevel/cats/pull/1611): Added `NonEmptyTraverse`. by @LukaJCB
 * [#1592](https://github.com/typelevel/cats/pull/1592): added instances of `BitSet` to `allInstances`. by @kailuowang
 * [#1586](https://github.com/typelevel/cats/pull/1586): Add `Applicative.unit`. by @alexandru
 * [#1584](https://github.com/typelevel/cats/pull/1584): Move arbitrary instance of `StateT` to laws. by @kailuowang
 * [#1580](https://github.com/typelevel/cats/pull/1580): add `groupBy` to `NonEmptyList` and `groupByNel` to `List` syntax @julien-truffaut
 * [#1578](https://github.com/typelevel/cats/pull/1578): add `last`, `sortBy` and `sorted` to `NonEmptyList`. by @julien-truffaut
 * [#1571](https://github.com/typelevel/cats/pull/1571): added `whileM`, `untilM`, `iterateWhile`, etc to `Monad` . by @tpolecat & @kailuowang
 * [#1548](https://github.com/typelevel/cats/pull/1548): `MonadError` instance for `Ior`. by @leandrob13
 * [#1543](https://github.com/typelevel/cats/pull/1543): `MonadError` instance for `Kleisli`. by @durban
 * [#1540](https://github.com/typelevel/cats/pull/1540): `Ior` syntax. by @leandrob13
 * [#1537](https://github.com/typelevel/cats/pull/1537): Add `FlatMap.forEffect`. by @cranst0n
 * [#1531](https://github.com/typelevel/cats/pull/1531): Add piecemeal import for `MonadError`. by @peterneyens
 * [#1526](https://github.com/typelevel/cats/pull/1526): `Inject` for free programs. by @tpolecat
 * [#1464](https://github.com/typelevel/cats/pull/1464): Adding `get` for `Foldable`. by @yilinwei
 * [#1602](https://github.com/typelevel/cats/pull/1602): Stack-safe `Coyoneda`. by @edmundnoble
 * [#1725](https://github.com/typelevel/cats/pull/1725): Add `InjectK` laws. by @andyscott
 * [#1728](https://github.com/typelevel/cats/pull/1728): Adds an `As` class which represents subtyping relationships (`Liskov`). by @stew
 * [#1178](https://github.com/typelevel/cats/pull/1178): Add `Is` constructor for Leibniz equality. by @tel
 * [#1611](https://github.com/typelevel/cats/pull/1611): Add `NonEmptyTraverse` typeclass. by @LukaJCB
 * [#1736](https://github.com/typelevel/cats/pull/1736): Added `StackSafeMonad` mixin. by @djspiewak
 * [#1600](https://github.com/typelevel/cats/pull/1600): `Inject` for `Either`. by @andyscott
 * [#1746](https://github.com/typelevel/cats/pull/1746): Add `EitherNel` type alias for `Either[NonEmptyList[E], A]`. by @andyscott
 * [#1670](https://github.com/typelevel/cats/pull/1670): Add `Order`-> `Ordering` implicit conversion to implicits, instances. by @edmundnoble
 * [#1649](https://github.com/typelevel/cats/pull/1649): Make `Show` inherit from a contravariant base trait for `show` string interpolator to be covariant. by @edmundnoble
  * [#1761](https://github.com/typelevel/cats/pull/1761): Add index related helpers to `Traverse`. by @andyscott 
  * [#1769](https://github.com/typelevel/cats/pull/1769): Add `Kleisli` `tap`, `tapWith`. by @tpolecat
  * [#1739](https://github.com/typelevel/cats/pull/1739): Add `onError` and `adaptError` to `ApplicativeError`/`MonadError`. by @SystemFw
  * [#1644](https://github.com/typelevel/cats/pull/1644): Add `MonadError` instance for `EitherT` that recovers from `F[_]` errors. by @leandrob13 
  * [#1748](https://github.com/typelevel/cats/pull/1748): Stack-safe `FreeAppplicative`. by @edmundnoble
  * [#1516](https://github.com/typelevel/cats/pull/1516): Implement `NonEmptyList#Collect` . by @xavier-fernandez
 
  
### Code improvements:

 * [#1660](https://github.com/typelevel/cats/pull/1660): Override `fromTry` and `fromEither` for `Try` and `Either`. by @peterneyens
 * [#1642](https://github.com/typelevel/cats/pull/1642): Unseal `InjectK` to allow for extension by other libraries. by @andyscott
 * [#1641](https://github.com/typelevel/cats/pull/1641): Make `InjectK` use `FunctionK.id` for reflexive injection. by @andyscott
 * [#1618](https://github.com/typelevel/cats/pull/1618): Override some methods in `Kleisli` instances. by @peterneyens
 * [#1532](https://github.com/typelevel/cats/pull/1532): Override `Foldable` methods. by @peterneyens
 * [#1456](https://github.com/typelevel/cats/pull/1456): Consistency for ops classes. by @edmundnoble
 * [#1631](https://github.com/typelevel/cats/pull/1631): make all `PartialApplied` class value class to achieve zero cost. by @kailuowang
 * [#1696](https://github.com/typelevel/cats/pull/1696): Make `syntax.show` extend `ShowSyntax` instead of `Show.ToShowOps`. by @edmundnoble
 
### Bug fixes: 

* [#1735](https://github.com/typelevel/cats/pull/1735): `StateT` no longer violates laws. by @djspiewak
* [#1740](https://github.com/typelevel/cats/pull/1740):  removed `iteratorFoldM`. by @kailuowang

### Other miscellaneous improvements (documentation, tests, build):

 * [#1699](https://github.com/typelevel/cats/pull/1699): Link to sbt-partial-unification plugin . by @Blaisorblade   
 * [#1698](https://github.com/typelevel/cats/pull/1698): Update gitter chat room name to cats-dev. . by @kailuowang 
 * [#1695](https://github.com/typelevel/cats/pull/1695): update ETA for 1.0.0 . by @kailuowang   
 * [#1604](https://github.com/typelevel/cats/pull/1604): Add tut doc for `FunctionK` . by @ceedubs
 * [#1691](https://github.com/typelevel/cats/pull/1691): Build JVM before JS on travis. by @peterneyens
 * [#1677](https://github.com/typelevel/cats/pull/1677): Update readme with the new dev channel.. by @kailuowang
 * [#1673](https://github.com/typelevel/cats/pull/1673): Use 2 workers in JVM build. by @ceedubs
 * [#1671](https://github.com/typelevel/cats/pull/1671): Fixing `Eq[Function1]` in testsJS; break JS build to separate matrix build. by @kailuowang
 * [#1666](https://github.com/typelevel/cats/pull/1666): Use `Cogen` for arbitrary instances. by @ceedubs
 * [#1654](https://github.com/typelevel/cats/pull/1654): Update Circe URL. by @n4to4
 * [#1653](https://github.com/typelevel/cats/pull/1653): Fix typo in `FreeApplicative` doc.. by @takayuky
 * [#1647](https://github.com/typelevel/cats/pull/1647): Adds Freestyle to `Related Projects` list. by @raulraja
 * [#1638](https://github.com/typelevel/cats/pull/1638): Make simulacrum a compile time only dependency. by @peterneyens
 * [#1637](https://github.com/typelevel/cats/pull/1637): show(f:T) to show(t:T). by @PeterPerhac
 * [#1636](https://github.com/typelevel/cats/pull/1636): added some category theory into `FunctionK` document. by @kailuowang
 * [#1632](https://github.com/typelevel/cats/pull/1632): upgraded to scala 2.12.2 and 2.11.11 and scalaJs. by @kailuowang
 * [#1629](https://github.com/typelevel/cats/pull/1629): add unit test for variance on methods in `EitherT`. by @jtjeferreira
 * [#1622](https://github.com/typelevel/cats/pull/1622): Update `Discipline` and `ScalaTest`. by @peterneyens
 * [#1615](https://github.com/typelevel/cats/pull/1615): Fix doc for `InvariantMonoidal`. by @BenFradet
 * [#1609](https://github.com/typelevel/cats/pull/1609): Include `Id` docs in the menu. by @ceedubs
 * [#1591](https://github.com/typelevel/cats/pull/1591): Improve test coverage. by @peterneyens
 * [#1590](https://github.com/typelevel/cats/pull/1590): Check monad laws for `Cokleisli`. by @peterneyens
 * [#1588](https://github.com/typelevel/cats/pull/1588): Docs/Tutorial -- Simplify `Kleisli` example. by @RawToast
 * [#1581](https://github.com/typelevel/cats/pull/1581): restore the alphabetical order of maintainers list. by @kailuowang
 * [#1575](https://github.com/typelevel/cats/pull/1575): minor improvements to `tailRecM` doc. by @kailuowang
 * [#1570](https://github.com/typelevel/cats/pull/1570): fixed a paragraph order. by @kailuowang
 * [#1566](https://github.com/typelevel/cats/pull/1566): Fix mistake in documentation of `Group.remove`. by @LukaJCB
 * [#1563](https://github.com/typelevel/cats/pull/1563): Remove references of the NEL `OneAnd` alias. by @peterneyens
 * [#1561](https://github.com/typelevel/cats/pull/1561): Fix incorrect numbering in `FreeMonads` doc. by @cb372
 * [#1555](https://github.com/typelevel/cats/pull/1555): fix scala.js badge version. by @xuwei-k
 * [#1551](https://github.com/typelevel/cats/pull/1551): added `MonadError` and `ApplicativeError` to hierarchy diagram. by @kailuowang
 * [#1547](https://github.com/typelevel/cats/pull/1547): fix ref to non-existent dir in contributing. by @sullivan-
 * [#1546](https://github.com/typelevel/cats/pull/1546): add to `Monad` `ifM` example. by @sullivan-
 * [#1545](https://github.com/typelevel/cats/pull/1545): fix scaladoc for `Eval` methods `Unit`, `True`, `False`, `Zero`, `One`. by @sullivan-
 * [#1541](https://github.com/typelevel/cats/pull/1541): Switch from CrossVersion.full to CrossVersion.patch for TLS compatibi…. by @milessabin
 * [#1530](https://github.com/typelevel/cats/pull/1530): add a favicon for sbt-microsite. by @larsrh
 * [#1529](https://github.com/typelevel/cats/pull/1529): Fix typo in `Applicative` doc.. by @cranst0n
 * [#1525](https://github.com/typelevel/cats/pull/1525): Remove link to apply.html from menu. by @Leammas
 * [#1693](https://github.com/typelevel/cats/pull/1693): Clean up EitherT doctests. by @peterneyens
 * [#1697](https://github.com/typelevel/cats/pull/1697): Added two links to the learner page. by @kailuowang
 * [#1726](https://github.com/typelevel/cats/pull/1726): Add underscore.io Advanced Scala with Cats. by @DieBauer
 * [#1718](https://github.com/typelevel/cats/pull/1718): Fixed some things in the build. by @djspiewak
 * [#1734](https://github.com/typelevel/cats/pull/1734): update sbt. by @jyane
 * [#1737](https://github.com/typelevel/cats/pull/1737): Rewrote documentation on the IO monad to reference cats-effect. by @djspiewak
 * [#1744](https://github.com/typelevel/cats/pull/1744): Make links link to the `.html` files instead of `.md`. by @LukaJCB
 * [#1759](https://github.com/typelevel/cats/pull/1759): Faster tests by reducing the size of lists. @peterneyens
 * [#1760](https://github.com/typelevel/cats/pull/1760): Decrease stack-safety test size. by @edmundnoble
 * [#1752](https://github.com/typelevel/cats/pull/1752): More coverage. by @edmundnoble
 * [#1472](https://github.com/typelevel/cats/pull/1472): Using regular syntax in the FreeApplicative tutorial. by @denisftw
 * [#1565](https://github.com/typelevel/cats/pull/1565): added instance table to docs, enhanced typeclass diagram. by @kailuowang
 * [#1573](https://github.com/typelevel/cats/pull/1573): Add symbols to FAQ. by @zainab-ali 
 
 
## Version 0.9.0

> 2017 January 15

The biggest user-facing change in this release is to the behavior of the `flatMap` (and related methods) provided by `EitherOps` for the standard library's `Either` for Scala 2.10 and 2.11. These methods now match the behavior of the `flatMap` on `Either` in Scala 2.12 in that they don't require the left-hand side types to match.

For example, the following would previously compile on 2.12, but not 2.10 or 2.11:

```scala
import cats.syntax.either._

sealed abstract class AppError
case object Error1 extends AppError
case object Error2 extends AppError

val either1: Either[Error1.type, String] = Right("hi")
val either2: Either[Error2.type, String] = Right("bye")

val result: Either[AppError, String] = for {
  v1 <- either1
  v2 <- either2
} yield v1 + v2
```

This code now works equivalently on all supported Scala versions.

Changes:

 * [#1424](https://github.com/typelevel/cats/pull/1424): `NonEmptyList` and `NonEmptyVector` are now covariant
 * [#1506](https://github.com/typelevel/cats/pull/1506): `flatMap` provided by `Either` syntax matches 2.12's `Either#flatMap`
 * [#1466](https://github.com/typelevel/cats/pull/1466): Improved stack safety for `StateT`
 * [#1510](https://github.com/typelevel/cats/pull/1510): `catchNonFatal` for `Future` is now asynchronous

Bug fixes:

 * [#1465](https://github.com/typelevel/cats/pull/1465) and [#1507](https://github.com/typelevel/cats/pull/1507): Stack safety law for `Monad#tailRecM` is less eager and doesn't throw exceptions

New type class instances:

 * [#1475](https://github.com/typelevel/cats/pull/1475): `Reducible` instances for `Eval` and `Id`
 * [#1484](https://github.com/typelevel/cats/pull/1484): `Show` instance for `Symbol`

Other additions:

 * [#1446](https://github.com/typelevel/cats/pull/1446): `Cofree` comonad
 * [#1520](https://github.com/typelevel/cats/pull/1520) and [#1522](https://github.com/typelevel/cats/pull/1522): `intercalate` for `Foldable` (and `intercalate1` for `Reducible`)
 * [#1454](https://github.com/typelevel/cats/pull/1454): `asLeft` and `asRight` syntax methods for creating `Either` values
 * [#1468](https://github.com/typelevel/cats/pull/1468): `tupleLeft` and `tupleRight` for `Functor`
 * [#1500](https://github.com/typelevel/cats/pull/1500): `putLeft`, `putRight`, `mergeLeft`, and `mergeRight` methods for `Ior`
 * [#1495](https://github.com/typelevel/cats/pull/1495): `show` string interpolator
 * [#1448](https://github.com/typelevel/cats/pull/1448): `Validated#findValid` (like `orElse` but error accumulating)
 * [#1455](https://github.com/typelevel/cats/pull/1455): `reverse` for `NonEmptyList`
 * [#1517](https://github.com/typelevel/cats/pull/1517): `zipWithIndex` for `NonEmptyList`
 * [#1512](https://github.com/typelevel/cats/pull/1512) and [#1514](https://github.com/typelevel/cats/pull/1514): `filterNot` for `NonEmptyList` and `NonEmptyVector`
 * [#1480](https://github.com/typelevel/cats/pull/1480): `FunctionK#and`
 * [#1481](https://github.com/typelevel/cats/pull/1481): `EitherT.cond`

Miscellaneous improvements (syntax, documentation, tests):

 * [#1513](https://github.com/typelevel/cats/pull/1513): Improved documentation for `Functor`, `Applicative`, and `Traverse`
 * [#1440](https://github.com/typelevel/cats/pull/1440): Improved type class documentation
 * [#1442](https://github.com/typelevel/cats/pull/1442): Improved documentation for `Semigroup` and `Monoid`
 * [#1479](https://github.com/typelevel/cats/pull/1479): Some instance traits are now package-private
 * [#1445](https://github.com/typelevel/cats/pull/1445): Workaround for Tut issue
 * [#1477](https://github.com/typelevel/cats/pull/1477): Use new kind-projector syntax for polymorphic lambdas
 * [#1483](https://github.com/typelevel/cats/pull/1483): Binary compatibility checking is now part of the build for cats-kernel
 * [#1469](https://github.com/typelevel/cats/pull/1469): More consistent instance names
 * [#1496](https://github.com/typelevel/cats/pull/1496): Simpler creation of some `SemigroupK` and `MonoidK` instances
 * [#1490](https://github.com/typelevel/cats/pull/1490): Avoid some duplication in build via sbt-travisci
 * [#1497](https://github.com/typelevel/cats/pull/1497): Site list clean-up

And version updates:

 * [#1499](https://github.com/typelevel/cats/pull/1499): 2.12 version is now 2.12.1
 * [#1509](https://github.com/typelevel/cats/pull/1509): Scala.js version is 0.6.14

As always thanks to everyone who filed issues, participated in the Cats Gitter
channel, submitted code, or helped review pull requests.

## Version 0.8.1

> 2016 November 9

Version 0.8.1 is a release to support Scala 2.12.0 with no changes to published code (only tests and documentation).

Build:

* [#1457](https://github.com/typelevel/cats/pull/1457): Update to Scala 2.12.0

Miscellaneous improvements (syntax, documentation, tests):

* [#1444](https://github.com/typelevel/cats/pull/1444): Remove `defaultTailRecM` from monad doc
* [#1441](https://github.com/typelevel/cats/pull/1441): Fixes #1438 by replacing quoted entry name
* [#1432](https://github.com/typelevel/cats/pull/1432): Type class organization in documentation
* [#1439](https://github.com/typelevel/cats/pull/1439): Update version on index
* [#1451](https://github.com/typelevel/cats/pull/1451): Fix `Arbitrary` instances for ScalaCheck 1.13.3+

## Version 0.8.0

> 2016 October 25

Version 0.8.0 is the eighth Cats release, and the first release with support for Scala 2.12 (specifically the 2.12.0-RC2 release candidate).

Apart from the introduction of Scala 2.12 support, the biggest change in this release is the removal
of `Xor` and `XorT`. See the [FAQ](http://typelevel.org/cats/faq.html#either) for information about
the motivations for this change and recommendations for migration.

Removals and deprecations:

 * [#1310](https://github.com/typelevel/cats/pull/1310): `Xor` and `XorT` are gone
 * [#1370](https://github.com/typelevel/cats/pull/1370): `RecursiveTailRecM` and `Free#foldMapUnsafe` are gone and stack safety is checked in the laws for `Monad`
 * [#1411](https://github.com/typelevel/cats/pull/1411): `FreeT#interpret` is deprecated in favor of the (equivalent) `compile`

Additions:

 * [#1382](https://github.com/typelevel/cats/pull/1382), [#1415](https://github.com/typelevel/cats/pull/1415): Support for Scala 2.12.0-RC2
 * [#1414](https://github.com/typelevel/cats/pull/1414): `Foldable#iteratorFoldM` and lazy `foldM` implementations for many standard library instances
 * [#1356](https://github.com/typelevel/cats/pull/1356): `append` and `prepend` (and operator aliases) for `NonEmptyVector`
 * [#1327](https://github.com/typelevel/cats/pull/1327): `EitherT.fromOption`
 * [#1388](https://github.com/typelevel/cats/pull/1388): `StateT.set` and `StateT.setF`
 * [#1392](https://github.com/typelevel/cats/pull/1392): `StateT.get`
 * [#1325](https://github.com/typelevel/cats/pull/1325): `WriterT.lift`
 * [#1391](https://github.com/typelevel/cats/pull/1391): `MonadReader#reader`
 * [#1352](https://github.com/typelevel/cats/pull/1352): Macro-powered `FunctionK.lift`
 * [#1398](https://github.com/typelevel/cats/pull/1398): `<<<` and `>>>` aliases for `Compose`'s `compose` and `andThen`
 * [#1408](https://github.com/typelevel/cats/pull/1408): `toNestedValidated` and `toNestedValidatedNel` for `EitherT`
 * [#1399](https://github.com/typelevel/cats/pull/1399): `Order.fromComparable`
 * [#1394](https://github.com/typelevel/cats/pull/1394): `Traverse#flatSequence`
 * [#1417](https://github.com/typelevel/cats/pull/1417): `MonadTests#stackUnsafeMonad` laws for instances where `tailRecM` is known to be unsafe
 * [#1411](https://github.com/typelevel/cats/pull/1411): `compile` and `foldMap` for the `Free` and `FreeT` companion objects

New instances:

 * [#1319](https://github.com/typelevel/cats/pull/1319): `Order` and `Group` for `BigDecimal`
 * [#1354](https://github.com/typelevel/cats/pull/1354): `Semigroup` for `Ior`
 * [#1395](https://github.com/typelevel/cats/pull/1395): `Order` for `Symbol`
 * [#1324](https://github.com/typelevel/cats/pull/1324): `PartialOrder` and other instances for `BitSet`
 * [#1324](https://github.com/typelevel/cats/pull/1324): `Eq` and `PartialOrder` for `Either`
 * [#1324](https://github.com/typelevel/cats/pull/1324): `PartialOrder`, `Monoid`, and other instances for `Function0`
 * [#1324](https://github.com/typelevel/cats/pull/1324): `Monoid` and other instances for `Function1`
 * [#1402](https://github.com/typelevel/cats/pull/1402): `Monad`, `MonadCombine`, `Traverse`, `Order`, etc. for `Prod`
 * [#1413](https://github.com/typelevel/cats/pull/1413): `MonadError` for `StateT`
 * [#1399](https://github.com/typelevel/cats/pull/1399): Instances for `java.util.UUID`

Renaming and rearrangements:

 * [#1385](https://github.com/typelevel/cats/pull/1385): The `cats.js.std` package is now `cats.js.instances`
 * [#1324](https://github.com/typelevel/cats/pull/1324): Many instances moved from cats-core to cats-kernel
 * [#1394](https://github.com/typelevel/cats/pull/1394): `Traverse#traverseM` is now `flatTraverse`

Miscellaneous improvements (syntax, documentation, tests):

 * [#1347](https://github.com/typelevel/cats/pull/1347): Consistency laws for `combineAll` and `combineAllOption`
 * [#1324](https://github.com/typelevel/cats/pull/1324): Performance improvements for `Either` instances
 * [#1386](https://github.com/typelevel/cats/pull/1386): `FunctionK` tests and examples now use kind-projector 0.9's polymorphic lambdas
 * [#1410](https://github.com/typelevel/cats/pull/1410): Replace `Coproduct#run` with `Coproduct#fold`
 * [#1331](https://github.com/typelevel/cats/pull/1331): Less expensive `tailRecM`-`flatMap` consistency checking
 * [#1330](https://github.com/typelevel/cats/pull/1330): More consistent parameter-less method definitions and usage, other syntactic improvements
 * [#1340](https://github.com/typelevel/cats/pull/1340): New [Scaladex](https://index.scala-lang.org) badge
 * [#1416](https://github.com/typelevel/cats/pull/1416): New diagram of type classes
 * [#1352](https://github.com/typelevel/cats/pull/1352): API docs for `FunctionK`
 * [#1369](https://github.com/typelevel/cats/pull/1369), [#1418](https://github.com/typelevel/cats/pull/1418): New project site based on [sbt-microsites](https://github.com/47deg/sbt-microsites)
 * [#1259](https://github.com/typelevel/cats/pull/1259): 0.6-to-0.7 migration guide
 * [#1304](https://github.com/typelevel/cats/pull/1304), [#1317](https://github.com/typelevel/cats/pull/1317), [#1323](https://github.com/typelevel/cats/pull/1323), [#1350](https://github.com/typelevel/cats/pull/1350), [#1366](https://github.com/typelevel/cats/pull/1366), [#1376](https://github.com/typelevel/cats/pull/1376), [#1380](https://github.com/typelevel/cats/pull/1380), [#1390](https://github.com/typelevel/cats/pull/1390), [#1403](https://github.com/typelevel/cats/pull/1403), [#1407](https://github.com/typelevel/cats/pull/1407), [#1421](https://github.com/typelevel/cats/pull/1421): Other miscellaneous documentation improvements

Build:

 * [#1345](https://github.com/typelevel/cats/pull/1345): Update ScalaCheck (to 1.13.2) and Discipline (to 0.6)
 * [#1353](https://github.com/typelevel/cats/pull/1353): Generated sources are included in source jars
 * [#1322](https://github.com/typelevel/cats/pull/1322): Scala.js test clean-up
 * [#1426](https://github.com/typelevel/cats/pull/1426): Human-friendly names in metadata for published artifacts
 * [#1389](https://github.com/typelevel/cats/pull/1389): More memory for Travis CI

## Version 0.7.2

> 2016 September 1

Version 0.7.2 is a patch release that was released to fix a major bug
([#1346](https://github.com/typelevel/cats/issues/1346)) that appeared
in 0.7.0. It also contains several other improvements.

It should be safe to upgrade from 0.7.0 to 0.7.2 -- there are no major
API changes between these releases.

### Changes

Fixes:

 * [#1347](https://github.com/typelevel/cats/pull/1347): fixes broken `Monoid[Map[K, V]].combineAll` implementation.
 * [#1304](https://github.com/typelevel/cats/pull/1304): fix `CoflatMap` documentation.
 * [#1322](https://github.com/typelevel/cats/pull/1322): fix SBT commands (`release`, `validate`, etc.).
 * [#1311](https://github.com/typelevel/cats/pull/1311): rename some implicit instances for consistency.

Additions:

 * [#1319](https://github.com/typelevel/cats/pull/1347): add missing `BigDecimal` instances.
 * [#1324](https://github.com/typelevel/cats/pull/1324): add missing function and `BitSet` instances.

Note that 0.7.2 was preceded by a botched 0.7.1. release. Please
avoid using this version of Cats -- it has major incompatibilities
with 0.7.0 and is not documented here.

## Version 0.7.0

> 2016 August 21

Version 0.7.0 is the seventh Cats release, and includes several major rearrangements and changes to names.

### Migration notes

If you're updating from Cats 0.6.0, it's likely that you'll need to make extensive (but mostly mechanical) changes. The following list includes some of the changes that are likely to be necessary for most projects; see the complete list of changes below for more detail.

* All references to `cats.std` will need to be changed to `cats.instances` ([#1140](https://github.com/typelevel/cats/pull/1140)). If you're using `cats.std.all` or the other `cats.std` objects with wildcard imports, this is likely to be the only change you need to make. If you are importing or referring to instance definitions by name, you'll need to be aware that the naming convention has changed (see [#1066](https://github.com/typelevel/cats/pull/1066), [#1068](https://github.com/typelevel/cats/pull/1068), [#1110](https://github.com/typelevel/cats/pull/1110), and [#1122](https://github.com/typelevel/cats/pull/1122)).
* `NonEmptyList` and `NonEmptyVector` are no longer type aliases for `OneAnd`, so any code using `OneAnd` to construct or pattern match on these types will need to be changed to use `NonEmptyList` or `NonEmptyVector` directly. There are also some API changes; for example, `unwrap` calls will need to be replaced by `toList` or `toVector`, and `NonEmptyList(1, 2, 3)` is now `NonEmptyList.of(1, 2, 3)`.
* `pureEval` has been removed from `Applicative` ([#1234](https://github.com/typelevel/cats/pull/1234)), and has not been replaced, so if you are relying on it for laziness or effect capturing (which wasn't enforced or guaranteed), you'll need to find another approach.
* All references to `NaturalTransformation` will need to be replaced by either `FunctionK` or `~>`.
* The `FlatMap` type class now has a `tailRecM` method that is designed to support stack-safe recursive monadic binding. If your monad's `flatMap` is stack safe, you can implement a stack-safe `tailRecM` by calling `Monad#defaultTailRecM`. The stack safety of `tailRecM` is not enforced, but if your implementation is stack safe, you should also provide an instance of the `RecursiveTailRecM` marker type class.
* If you are interpreting a free algebra into a context `F` with `foldMap`, you'll now need `F` to have an instance of the `RecursiveTailRecM` marker type class (in addition to the `Monad` instance).

If you run into any issues while updating, please get in touch on [Gitter](https://gitter.im/typelevel/cats).

### Changes

This release includes a fix for a bug in 0.6.0 (also fixed in 0.6.1):

* [#1062](https://github.com/typelevel/cats/pull/1062): `Order` instances for tuples are now lexicographic (instead of only comparing first elements)

And other bug fixes:

* [#1096](https://github.com/typelevel/cats/pull/1096): `inj` and `prj` on `Inject` now work consistently with respect to `null`

And some additions:

* [#1289](https://github.com/typelevel/cats/pull/1289) and [#1306](https://github.com/typelevel/cats/pull/1306): `EitherT` and improved `Either` syntax
* [#1280](https://github.com/typelevel/cats/pull/1280): `FlatMap` now has a `tailRecM` method
* [#1280](https://github.com/typelevel/cats/pull/1280): `RecursiveTailRecM` marker type class indicating that `tailRecM` is stack safe
* [#1266](https://github.com/typelevel/cats/pull/1266): `FreeT` monad transformer
* [#1225](https://github.com/typelevel/cats/pull/1225): `FunctorFilter` and `TraverseFilter`
* [#1121](https://github.com/typelevel/cats/pull/1121): `valueOr` and `merge` for `Validated`
* [#1188](https://github.com/typelevel/cats/pull/1188): `toValidatedNel` for `XorT`
* [#1127](https://github.com/typelevel/cats/pull/1127): `toTry` for `Xor`
* [#1269](https://github.com/typelevel/cats/pull/1269): `catchNonFatal` for `ApplicativeError`
* [#1130](https://github.com/typelevel/cats/pull/1130): `isEmpty` syntax method for `Monoid`
* [#1167](https://github.com/typelevel/cats/pull/1167): `minimum`, `maximum`, and related helper methods for `Foldable` and `Reducible`
* [#1243](https://github.com/typelevel/cats/pull/1243): `distinct` on `NonEmptyList` and `NonEmptyVector`
* [#1134](https://github.com/typelevel/cats/pull/1134): `cats.syntax.list` for à la carte list syntax imports
* [#1191](https://github.com/typelevel/cats/pull/1191): `cats.syntax.monoid` for à la carte `Monoid` syntax imports
* [#588](https://github.com/typelevel/cats/pull/588) and [#1063](https://github.com/typelevel/cats/pull/1063): `IdT`, the identity monad transformer
* [#1021](https://github.com/typelevel/cats/pull/1021) and [#1221](https://github.com/typelevel/cats/pull/1221): `Nested` (represents nested composition of type constructors)
* [#1172](https://github.com/typelevel/cats/pull/1172): `toNested` for `OptionT` and `XorT`
* [#1102](https://github.com/typelevel/cats/pull/1102) and [#1170](https://github.com/typelevel/cats/pull/1170): `Comparison` (represents the result of an `Order` comparison)
* [#1090](https://github.com/typelevel/cats/pull/1090): `Kleisli.lift`
* [#1169](https://github.com/typelevel/cats/pull/1169): `lift`, `inspect`, and related methods for `StateT`
* [#1114](https://github.com/typelevel/cats/pull/1114): `size` for `Foldable`
* [#1193](https://github.com/typelevel/cats/pull/1193): `reduceLeftM` for `Reducible`
* [#1097](https://github.com/typelevel/cats/pull/1097): Functor variance helpers (`widen` for `Functor` and `narrow` for `Contravariant`)
* [#1207](https://github.com/typelevel/cats/pull/1207): `tell` for `Writer` and `WriterT`, `value` for `Writer`
* [#1155](https://github.com/typelevel/cats/pull/1155): Convenience methods for constructing `XorT` values
* [#1085](https://github.com/typelevel/cats/pull/1085): `runTailRec` and `foldLeftM` for `Free`
* [#1299](https://github.com/typelevel/cats/pull/1299): `ContravariantCartesian` type class

And some name changes:

* [#1140](https://github.com/typelevel/cats/pull/1140): `cats.std` is now `cats.instances`
* [#1066](https://github.com/typelevel/cats/pull/1066), [#1068](https://github.com/typelevel/cats/pull/1068), [#1110](https://github.com/typelevel/cats/pull/1110), and [#1122](https://github.com/typelevel/cats/pull/1122): More unique type class instance names
* [#1072](https://github.com/typelevel/cats/pull/1072): `NaturalTransformation` is now `FunctionK`
* [#1085](https://github.com/typelevel/cats/pull/1085): `mapSuspension` on `Free` is now `compile`
* [#1111](https://github.com/typelevel/cats/pull/1111): `Free.Gosub` is now `Free.FlatMapped`
* [#1133](https://github.com/typelevel/cats/pull/1133): `Composite*` traits for binary type classes are renamed to `Composed*` for consistency (and are now private)

And other API changes:

* [#1231](https://github.com/typelevel/cats/pull/1231): `NonEmptyList` is now a case class instead of a type alias for a `OneAnd`
* [#1137](https://github.com/typelevel/cats/pull/1137): `NonEmptyVector` is now a value class instead of a type alias for a `OneAnd`
* [#1267](https://github.com/typelevel/cats/pull/1267): Overloaded variadic `apply` on `NonEmptyList` and `NonEmptyVector` is now `of`
* [#1234](https://github.com/typelevel/cats/pull/1234): `Applicative#pureEval` has been removed
* [#1202](https://github.com/typelevel/cats/pull/1202): `MonadFilter` no longer has a `filterM` method (see [#1225](https://github.com/typelevel/cats/pull/1225))
* [#1075](https://github.com/typelevel/cats/pull/1075): `foldMap` on `Free` now requires a `MonadRec` instance (instead of simply `Monad`)
* [#1085](https://github.com/typelevel/cats/pull/1085): `Free.suspend` no longer requires an `Applicative` instance
* [#1084](https://github.com/typelevel/cats/pull/1084): Safer `toString` for `Free` and `FreeApplicative`
* [#1100](https://github.com/typelevel/cats/pull/1100): Simplified constraints for methods on `Xor` and related types
* [#1171](https://github.com/typelevel/cats/pull/1171): Prioritization traits are now private

And many new instances:

* [#1059](https://github.com/typelevel/cats/pull/1059) and [#1147](https://github.com/typelevel/cats/pull/1147): `Monoid`, `MonadError`, and other instances for `scala.util.Try`
* [#1299](https://github.com/typelevel/cats/pull/1299): `Monad` for `Tuple2`
* [#1211](https://github.com/typelevel/cats/pull/1211): `Contravariant` for `Eq`
* [#1220](https://github.com/typelevel/cats/pull/1220): `Traverse` and `Comonad` for `Tuple2`
* [#1103](https://github.com/typelevel/cats/pull/1103): `Order`, `MonadError`, and other instances for `OptionT`
* [#1106](https://github.com/typelevel/cats/pull/1106): `Semigroup` and `Monoid` for `XorT`
* [#1138](https://github.com/typelevel/cats/pull/1138): `SemigroupK` and `MonadCombine` for `StateT`
* [#1128](https://github.com/typelevel/cats/pull/1128) `Semigroup` and `Monoid` for `Applicative`
* [#1049](https://github.com/typelevel/cats/pull/1049): `CoflatMap` for `WriterT`
* [#1076](https://github.com/typelevel/cats/pull/1076) and [#1261](https://github.com/typelevel/cats/pull/1261): `MonadRec` instances for `Eval`, `StateT`, and `Future`
* [#1105](https://github.com/typelevel/cats/pull/1105): `Unapply` instances for `Nested` shapes

And miscellaneous improvements to style and performance:

* [#1079](https://github.com/typelevel/cats/pull/1079): More consistent type lambdas
* [#1300](https://github.com/typelevel/cats/pull/1300): Much faster `Monoid` instances for `Map`

And improvements to the documentation:

* [#1145](https://github.com/typelevel/cats/pull/1145): Major rearrangements and additions
* [#1136](https://github.com/typelevel/cats/pull/1136): New chart for symbols
* [#1052](https://github.com/typelevel/cats/pull/1052): New "Why?" section
* [#1095](https://github.com/typelevel/cats/pull/1095), [#1226](https://github.com/typelevel/cats/pull/1226), and [#1227](https://github.com/typelevel/cats/pull/1227): New FAQ section
* [#1163](https://github.com/typelevel/cats/pull/1163): New import guide section
* [#1217](https://github.com/typelevel/cats/pull/1217), [#1223](https://github.com/typelevel/cats/pull/1223), and [#1239](https://github.com/typelevel/cats/pull/1239): New related projects
* [#1057](https://github.com/typelevel/cats/pull/1057) and [#1157](https://github.com/typelevel/cats/pull/1157): Copy-paste-friendly code blocks
* [#1104](https://github.com/typelevel/cats/pull/1104) and [#1115](https://github.com/typelevel/cats/pull/1115): Kitchen-sink imports in example code
* [#1050](https://github.com/typelevel/cats/pull/1050): Switch to [rouge](https://github.com/jneen/rouge) for syntax highlighting in the GitHub Pages site
* [#1119](https://github.com/typelevel/cats/pull/1119): Fix for `contramap` signature
* [#1141](https://github.com/typelevel/cats/pull/1141) and [#1162](https://github.com/typelevel/cats/pull/1162): Fixes for cats-kernel documentation
* [#1149](https://github.com/typelevel/cats/pull/1149): Spelling consistency for "type class"
* [#1183](https://github.com/typelevel/cats/pull/1183): More documentation about use of Machinist, Simulacrum, and kind-projector
* [#1056](https://github.com/typelevel/cats/pull/1056): Clarification about forgetful functors and the free monad
* [#1131](https://github.com/typelevel/cats/pull/1131) and [#1241](https://github.com/typelevel/cats/pull/1241): Simplified project structure listings
* [#1185](https://github.com/typelevel/cats/pull/1185), [#1186](https://github.com/typelevel/cats/pull/1186), and [#1189](https://github.com/typelevel/cats/pull/1189): Miscellaneous improvements for `Traverse` documentation

And the build:

* [#1159](https://github.com/typelevel/cats/pull/1159): Binary compatibility checking for cats-kernel via MiMa
* [#1256](https://github.com/typelevel/cats/pull/1256): More reliable Scala.js testing in Travis CI
* [#1123](https://github.com/typelevel/cats/pull/1123): cats-kernel is now included in the API documentation
* [#1051](https://github.com/typelevel/cats/pull/1051): Empty Scaladocs for 2.10 to avoid issues macros cause for API documentation generation on 2.10
* [#1154](https://github.com/typelevel/cats/pull/1154): Better POM hygiene: no Scoverage dependency
* [#1153](https://github.com/typelevel/cats/pull/1153) and [#1218](https://github.com/typelevel/cats/pull/1218): More consistent use of Simulacrum for syntax
* [#1093](https://github.com/typelevel/cats/pull/1093): Scalastyle is now aware of shared and Scala.js-specific source files
* [#1142](https://github.com/typelevel/cats/pull/1142): Additional formatting rules for Scalastyle
* [#1099](https://github.com/typelevel/cats/pull/1099): Type lambda style is now enforced by Scalastyle
* [#1258](https://github.com/typelevel/cats/pull/1258): Version updates for SBT and SBT plugins

We also welcome [Kailuo Wang](https://github.com/typelevel/cats/pull/1129), [Peter Neyens](https://github.com/typelevel/cats/pull/1179), and [Oscar Boykin](https://github.com/typelevel/cats/pull/1180) as new Cats maintainers!

## Version 0.6.1

> 2016 July 14

Version 0.6.1 is a patch release compatible with 0.6.0.

It contains one bug fix:

* [#1062](https://github.com/typelevel/cats/pull/1173/commits/8dd682771557274a61f1e773df0f999b44a9819d): Fixed a bug in the Order and PartialOrder instances for Tuple2+ where only the first element was used in comparisons

It also contains a change to the build:

* [#1173](https://github.com/typelevel/cats/pull/1173/commits/5531d1ac7a6807c1842cd4b5b599173b14b652a9): Add binary compatibility check to all published modules

## Version 0.6.0

> 2016 May 19

Version 0.6.0 is the sixth release.

Highlights of this release:

* [#990](https://github.com/typelevel/cats/pull/990):  Separate free package into its own module
* [#1001](https://github.com/typelevel/cats/pull/1001):  Introduce cats-kernel and remove algebra dependency

This release also includes some API changes:

* [#1046](https://github.com/typelevel/cats/pull/1046):  summon `ApplicativeErrorSyntax` for `F[_]` instead of `F[_, _]`
* [#1034](https://github.com/typelevel/cats/pull/1034):  Don't combine lefts on `Xor` and `XorT` `combine`
* [#1018](https://github.com/typelevel/cats/pull/1018):  Remove blocking (JVM-only) Future instances
* [#877](https://github.com/typelevel/cats/pull/877):  Remove required laziness in Prod, fixes #615


And additions:

* [#1032](https://github.com/typelevel/cats/pull/1032):  Added `Coproduct` `fold`
* [#1028](https://github.com/typelevel/cats/pull/1028):  Added `withFilter` for `OptionT`
* [#1014](https://github.com/typelevel/cats/pull/1014):  Added `Monoid` instance for `WriterT`
* [#1029](https://github.com/typelevel/cats/pull/1029):  Added an `ApplicativeError` instance for `Kleisli` and a `MonadError[Option, Unit]` to `std.option`
* [#1023](https://github.com/typelevel/cats/pull/1023):  Add `XorT#fromEither`
* [#984](https://github.com/typelevel/cats/pull/984):  Add `Validated.ensure`
* [#1020](https://github.com/typelevel/cats/pull/1020):  Add `Traverse.traverseM`


And some code improvements:

* [#1015](https://github.com/typelevel/cats/pull/1015):  Add `Apply.map2Eval` and allow traverse laziness
* [#1024](https://github.com/typelevel/cats/pull/1024):  Override reverse on reversed `PartialOrder` to return original instance
* [#880](https://github.com/typelevel/cats/pull/880):  Optimize `Eq[Vector[A]]` instance
* [#1019](https://github.com/typelevel/cats/pull/1019):  Use `Future#successful` in `pureEval` when possible

And bug fixes:

* [#1011](https://github.com/typelevel/cats/pull/1011):  Add missing type parameters.

And some other improvements to the organization documentation, tutorials, laws and tests, including:

* [#1045](https://github.com/typelevel/cats/pull/1045):  Add a link to the `OptionT` documentation from the monad docs.
* [#1043](https://github.com/typelevel/cats/pull/1043):  Add notes about kind-projector usage in docs
* [#1042](https://github.com/typelevel/cats/pull/1042):  Cats 0.5.0 no longer pre-release
* [#1036](https://github.com/typelevel/cats/pull/1036):  Add FPiS to the "Resources for Learners" section
* [#1035](https://github.com/typelevel/cats/pull/1035):  Run kernel-law tests for JS as part of build
* [#991](https://github.com/typelevel/cats/pull/991):  Replace `~>` with `NaturalTransformation`
* [#1027](https://github.com/typelevel/cats/pull/1027):  Remove unnecessary `nelSemigroup` from `traverse` doc
* [#1022](https://github.com/typelevel/cats/pull/1022):  Add law-checking for `asMeetPartialOrder` and `asJoinPartialOrder`
* [#990](https://github.com/typelevel/cats/pull/990):  Separate free package into its own module


## Version 0.5.0

> 2016 April 28

Version 0.5.0 is the fifth release.

This release includes some API changes:

`cats.laws.discipline.eq` no longer provides `Eq` instances for `Tuple2` and `Tuple3`, these instances and together with some other new instances for `Tuple`s are now provided by `cats.std.tuple` (through inheriting the instance trait defined in algebra 0.4.2).

* [#910](https://github.com/typelevel/cats/pull/910): Remove `Streaming` and `StreamingT`
* [#967](https://github.com/typelevel/cats/pull/967): `product` and `map` can be implemented in terms of `ap`
* [#970](https://github.com/typelevel/cats/pull/970): Renamed `Kleisli#apply`to `ap`
* [#994](https://github.com/typelevel/cats/pull/994): updated to latest algebra (brought in all the new goodies)

And additions:

* [#853](https://github.com/typelevel/cats/pull/853): Adds a new `LiftTrans` type class
* [#864](https://github.com/typelevel/cats/pull/864): Add `Bifoldable`
* [#875](https://github.com/typelevel/cats/pull/875): Add `.get` method to `StateT`
* [#884](https://github.com/typelevel/cats/pull/884): Add `Applicative` syntax
* [#886](https://github.com/typelevel/cats/pull/886): Add `map` method to `OneAnd`
* [#927](https://github.com/typelevel/cats/pull/927): `XorT.ensure` method
* [#925](https://github.com/typelevel/cats/pull/925): Stack-safe `foldM`
* [#922](https://github.com/typelevel/cats/pull/922): Add `tell` and `writer` syntax for creating `Writers`.
* [#903](https://github.com/typelevel/cats/pull/903): Add `Bitraverse`
* [#928](https://github.com/typelevel/cats/pull/928): Add missing `Show` instances
* [#940](https://github.com/typelevel/cats/pull/940): More flexible `TransLift`
* [#946](https://github.com/typelevel/cats/pull/946): Added `OptionT.none`
* [#947](https://github.com/typelevel/cats/pull/947): Syntax for `ApplicativeError`
* [#971](https://github.com/typelevel/cats/pull/971): Add `toValidatedNel` to `Xor`
* [#973](https://github.com/typelevel/cats/pull/973): Add `flatMapF` for `StateT`
* [#985](https://github.com/typelevel/cats/pull/985): Add object `reducible` for reducible syntax
* [#996](https://github.com/typelevel/cats/pull/996): Add `SemigroupK` instance for `Xor`
* [#998](https://github.com/typelevel/cats/pull/998): Add `SemigroupK` instance for `Validated`
* [#986](https://github.com/typelevel/cats/pull/986): Add `Bitraverse` instances for `Validated` and `XorT`


And bug fixes:

* [#873](https://github.com/typelevel/cats/pull/873): Fix `OptionIdOps.some` to always return `Some`
* [#958](https://github.com/typelevel/cats/pull/958): Switch off scaladoc generation for Scala 2.10 due to macro problems
* [#955](https://github.com/typelevel/cats/pull/955): Rename `Id` instances to `idInstances` to make selective import easier


And removals:

* [#910](https://github.com/typelevel/cats/pull/910): Remove `Streaming` and `StreamingT`


And some other improvements to the documentation, tutorials, laws and tests, including:

* [#880](https://github.com/typelevel/cats/pull/880): Optimize `Eq[Vector[A]]` instance
* [#878](https://github.com/typelevel/cats/pull/878): Fix bug in freemonad doc
* [#870](https://github.com/typelevel/cats/pull/870): Fixed doc string for `StateT`'s `runEmptyA()`
* [#866](https://github.com/typelevel/cats/pull/866): Add some tests for `Coproduct` and `WriterT`
* [#883](https://github.com/typelevel/cats/pull/883): Delegate to `Traverse.sequence` in `Applicative.sequence`
* [#893](https://github.com/typelevel/cats/pull/893): Add `Reducible` laws
* [#923](https://github.com/typelevel/cats/pull/923): Make `Call.loop` `@tailrec` optimized
* [#916](https://github.com/typelevel/cats/pull/916): add `-P:scalajs:mapSourceURI` option
* [#909](https://github.com/typelevel/cats/pull/909): Make `Bifunctor` universal
* [#905](https://github.com/typelevel/cats/pull/905): make `Unapply` serializable
* [#902](https://github.com/typelevel/cats/pull/902): Make table in `Kleisli` readable
* [#897](https://github.com/typelevel/cats/pull/897): Add `Prod` tests
* [#938](https://github.com/typelevel/cats/pull/938): Onward to scala 2.11.8
* [#941](https://github.com/typelevel/cats/pull/941): Type class composition and `MonadState` tests
* [#949](https://github.com/typelevel/cats/pull/949): Add .ensime_cache to gitignore
* [#954](https://github.com/typelevel/cats/pull/954): Switch to use nodeJsEnv as default jsEnv to build scala.js
* [#956](https://github.com/typelevel/cats/pull/956): Upgrade scala.js from 0.6.7 -> 0.6.8
* [#960](https://github.com/typelevel/cats/pull/960): More `Reducible` tests
* [#962](https://github.com/typelevel/cats/pull/962): Improving test coverage
* [#964](https://github.com/typelevel/cats/pull/964): Clarify stabilty guarantees; drop 'proof of concept' and 'experimental'
* [#972](https://github.com/typelevel/cats/pull/972): Fix swapped f and g in `invariant` docs
* [#979](https://github.com/typelevel/cats/pull/979): Fix outdated import for `cats.syntax.apply._`
* [#995](https://github.com/typelevel/cats/pull/995): Move coverage away from bash
* [#1002](https://github.com/typelevel/cats/pull/1002): Correct the URL for *Data types à la carte*
* [#1005](https://github.com/typelevel/cats/pull/1005): fix broken link in foldable docs


As always thanks to everyone who filed issues, participated in the Cats Gitter
channel, submitted code, or helped review pull requests.



## Version 0.4.1

> 2016 February 4

Version 0.4.1 is a patch release in the 0.4 series and is binary compatible with
version 0.4.0.

This patch fixes bugs with the `dropWhile` methods on `Streaming` and
`StreamingT`.

This release corrects outdated build/POM metadata, which should fix API doc URLS.

Bug fixes:

* [#856](https://github.com/typelevel/cats/pull/856): Fix `Streaming` and `StreamingT` `dropWhile` functions

Build/publishing changes:

* [#852](https://github.com/typelevel/cats/pull/852) Update build with org change

Documentation and site improvements:

* [#859](https://github.com/typelevel/cats/pull/859) Add Contravariant documentation page
* [#861](https://github.com/typelevel/cats/pull/861) Docs: Revive useful links section. Update URLs

## Version 0.4.0

> 2016 February 1

Version 0.4.0 is the fourth release of the Cats library, and the first release
published under the `org.typelevel` group from the
[Typelevel](https://github.com/typelevel) organization on GitHub (previous
releases had been published to `org.spire-math` from `non/cats`). This means
that users will need to change the `groupId` for their Cats dependencies when
updating. If you have a line like this in your `sbt` build configuration, for
example:

```scala
libraryDependencies += "org.spire-math" %% "cats" % "0.3.0"
```

You will need to change it to the following:

```scala
libraryDependencies += "org.typelevel" %% "cats" % "0.4.0"
```

This release no longer includes `cats-state` or `cats-free` artifacts, since
the `cats.state` and `cats.free` packages have been moved into `cats-core`.

If you've checked out the GitHub repository locally, it would be a good idea to
update your remote to point to the new organization, which will typically look
like this (note that you should confirm that `origin` is the appropriate
remote name):

```bash
git remote set-url origin git@github.com:typelevel/cats.git
```

This release includes a large number of breaking changes, including most
prominently the introduction of a new `Cartesian` type class that is a supertype
of `Monad` (and many other types). If you use the `|@|` syntax that had
previously been provided by `Apply`, you'll need to change your imports from
`cats.syntax.apply._` to `cats.syntax.cartesian._`. For example:

```scala
scala> import cats.Eval, cats.syntax.cartesian._
import cats.Eval
import cats.syntax.cartesian._

scala> (Eval.now("v") |@| Eval.now(0.4)).tupled
res0: cats.Eval[(String, Double)] = cats.Eval$$anon$5@104f8bbd
```

Other changes in this release are described below.

This version includes API changes:

* [#555](https://github.com/typelevel/cats/pull/555): `|@|` syntax is now
  provided by `cats.syntax.cartesian`
* [#835](https://github.com/typelevel/cats/pull/835): `State` and `StateT` are
  now in the `cats.data` package
* [#781](https://github.com/typelevel/cats/pull/781): `combine` on `SemigroupK`
  is now `combineK`
* [#821](https://github.com/typelevel/cats/pull/821) and
  [#833](https://github.com/typelevel/cats/pull/833): The order of arguments for
  `ap` has been reversed (now function first)
* [#833](https://github.com/typelevel/cats/pull/833): `ap` on
  `CartesianBuilderN` is now `apWith`
* [#782](https://github.com/typelevel/cats/pull/782): `State` now uses `Eval`
  instead of `Trampoline` for stack safety
* [#697](https://github.com/typelevel/cats/pull/697): `or` for natural
  transformations is now an instance method
* [#725](https://github.com/typelevel/cats/pull/725): `orElse` on `XorT` and
  does not unnecessarily constrain the type of the left side of the result
* [#648](https://github.com/typelevel/cats/pull/648): Some types now extend
  `Product` and `Serializable` to improve type inference
* [#647](https://github.com/typelevel/cats/pull/647): `ProdInstancesN` names
  changed for consistency
* [#636](https://github.com/typelevel/cats/pull/636): `Eval` is now
  `Serializable`
* [#685](https://github.com/typelevel/cats/pull/685): Fixes for copy-paste
  errors in method names for instances for `Validated`
* [#778](https://github.com/typelevel/cats/pull/778): Unnecessary type parameter
  on `Foldable`'s `sequence_` has been removed

And additions:

* [#555](https://github.com/typelevel/cats/pull/555) and
  [#795](https://github.com/typelevel/cats/pull/795): `Cartesian`
* [#671](https://github.com/typelevel/cats/pull/671): `Coproduct` and `Inject`
* [#812](https://github.com/typelevel/cats/pull/812): `ApplicativeError`
* [#765](https://github.com/typelevel/cats/pull/765): `State` and `Free` (and
  related types) are now in the core module
* [#611](https://github.com/typelevel/cats/pull/611): `Validated` now has an
  `andThen` method that provides binding (but without the `for`-comprehension
  syntactic sugar that the name `flatMap` would bring)
* [#796](https://github.com/typelevel/cats/pull/796): `sequenceU_` and
  `traverseU_` on `Foldable`
* [#780](https://github.com/typelevel/cats/pull/780): `transformS` for `StateT`
* [#807](https://github.com/typelevel/cats/pull/807): `valueOr` for `XorT`
* [#714](https://github.com/typelevel/cats/pull/714): `orElse` for `XorT`
* [#705](https://github.com/typelevel/cats/pull/705): `getOrElseF` for `XorT`
* [#731](https://github.com/typelevel/cats/pull/731): `swap` for `Validated`
* [#571](https://github.com/typelevel/cats/pull/571): `transform` and
  `subflatMap` on `OptionT` and `XorT`
* [#757](https://github.com/typelevel/cats/pull/757) and
  [#843](https://github.com/typelevel/cats/pull/843): `compose` for
  `Alternative` and `composeK` for `MonoidK`
* [#667](https://github.com/typelevel/cats/pull/667): `OptionT.liftF`

And removals:

* [#613](https://github.com/typelevel/cats/pull/613): `Free` and
  `FreeApplicative` constructors are now private
* [#605](https://github.com/typelevel/cats/pull/605): `filter` on `Validated`
* [#698](https://github.com/typelevel/cats/pull/698): `MonadCombine` instances
  for `OptionT`
* [#635](https://github.com/typelevel/cats/pull/635): `Kleisli`'s redundant
  `lmap`, which was equivalent to `local`
* [#752](https://github.com/typelevel/cats/pull/752): `Cokleisli.cokleisli`,
  which was equivalent to `Cokleisli.apply`
* [#687](https://github.com/typelevel/cats/pull/687): Unused `XorTMonadCombine`
* [#622](https://github.com/typelevel/cats/pull/622): Many prioritization types
  are now private

And new type class instances:

* [#644](https://github.com/typelevel/cats/pull/644): `Traverse` and `Foldable`
  instances for `XorT`
* [#691](https://github.com/typelevel/cats/pull/691): Various instances for
  `Function1`
* [#628](https://github.com/typelevel/cats/pull/628) and
  [#696](https://github.com/typelevel/cats/pull/696): Various instances for
  `WriterT`
* [#673](https://github.com/typelevel/cats/pull/673): `Bifunctor` instances for
  `WriterT`
* [#715](https://github.com/typelevel/cats/pull/715) and
  [#716](https://github.com/typelevel/cats/pull/716): `Semigroup` and `Monoid`
  instances for `Validated`
* [#717](https://github.com/typelevel/cats/pull/717) and
  [#718](https://github.com/typelevel/cats/pull/718): `Semigroup` instances for
  `Xor` and `Const`
* [#818](https://github.com/typelevel/cats/pull/818): `CoflatMap` instance for
  `Vector`
* [#626](https://github.com/typelevel/cats/pull/626): `Contravariant` instances
  for `Const` and `Kleisli`
* [#621](https://github.com/typelevel/cats/pull/621): `Id` instances for
  `Kleisli`
* [#772](https://github.com/typelevel/cats/pull/772): `Reducible` instances for
  `OneAnd`
* [#816](https://github.com/typelevel/cats/pull/816): `Traverse` instances for
  `OneAnd`
* [#639](https://github.com/typelevel/cats/issues/639): `Traverse` instance
  for `Id`
* [#774](https://github.com/typelevel/cats/pull/774) and
  [#775](https://github.com/typelevel/cats/pull/775): `Show` instances for
  `Vector` and `Stream`

And bug fixes:

* [#623](https://github.com/typelevel/cats/pull/623) fixes
  [#563](https://github.com/typelevel/cats/issues/563), a bug in the behavior of
  `dropWhile_` on `Foldable`
* [#665](https://github.com/typelevel/cats/pull/665) fixes
  [#662](https://github.com/typelevel/cats/pull/662), a bug that resulted in
  re-evaluation after memoization in `Streaming`
* [#683](https://github.com/typelevel/cats/pull/683) fixes
  [#677](https://github.com/typelevel/cats/issues/677), a bug in
  `Streaming.thunk`
* [#801](https://github.com/typelevel/cats/pull/801): Fixes order effect bug in
  `foldMap` on `FreeApplicative`
* [#798](https://github.com/typelevel/cats/pull/798): Fixes bug in `filter` on
  `StreamingT`
* [#656](https://github.com/typelevel/cats/pull/656): Fixes bug in `drop` on
  `StreamingT`
* [#769](https://github.com/typelevel/cats/pull/769): Improved stack consumption
  for `Eval.Call`

And some dependency updates:

* [#833](https://github.com/typelevel/cats/pull/833): Update to Simulacrum
  0.7.0
* [#764](https://github.com/typelevel/cats/pull/764): 2.10 version is now
  2.10.6
* [#643](https://github.com/typelevel/cats/pull/643): Update to Catalysts 0.2.0
* [#727](https://github.com/typelevel/cats/pull/727): Update to Scalastyle 0.8.0

There are also many improvements to the documentation, tutorials, laws, tests,
and benchmarks, including the following:

* [#724](https://github.com/typelevel/cats/pull/724): sbt-doctest is now used to
  validate Scaladoc examples
* [#806](https://github.com/typelevel/cats/pull/806): Various improvements to
  use of Simulacrum, which is now a compile-time-only dependency
* [#734](https://github.com/typelevel/cats/pull/734): Documentation on testing
  conventions
* [#710](https://github.com/typelevel/cats/pull/710): Documentation for
  `Invariant`
* [#832](https://github.com/typelevel/cats/pull/832): Updated `Free`
  documentation
* [#824](https://github.com/typelevel/cats/pull/824): New examples for
  `Foldable`
* [#797](https://github.com/typelevel/cats/pull/797): Scaladoc examples for
  methods on `Arrow`
* [#783](https://github.com/typelevel/cats/pull/783) and others: Scaladoc
  examples for syntax methods
* [#720](https://github.com/typelevel/cats/pull/720): Expanded documentation for
  `FreeApplicative`
* [#636](https://github.com/typelevel/cats/pull/636): Law checking for `Eval`
* [#649](https://github.com/typelevel/cats/pull/649) and
  [#660](https://github.com/typelevel/cats/pull/660): Better `Arbitrary`
  instances for `Streaming` and `StreamingT`
* [#722](https://github.com/typelevel/cats/pull/722): More consistent `toString`
  for `StreamingT`
* [#672](https://github.com/typelevel/cats/pull/672): Additional laws for
  `Profunctor`
* [#668](https://github.com/typelevel/cats/pull/668),
  [#669](https://github.com/typelevel/cats/pull/669),
  [#679](https://github.com/typelevel/cats/pull/679),
  [#680](https://github.com/typelevel/cats/pull/680), and
  [#681](https://github.com/typelevel/cats/pull/681): Additional law checking
  for `Xor`, `XorT`, and `Either`
* [#707](https://github.com/typelevel/cats/pull/707): Additional testing for
  `State` and `StateT`
* [#736](https://github.com/typelevel/cats/pull/736): `map` / `flatMap`
  coherence
* [#748](https://github.com/typelevel/cats/pull/748): Left and right identity
  laws for `Kleisli`
* [#753](https://github.com/typelevel/cats/pull/753): Consistency tests for
  `Cokleisli`
* [#733](https://github.com/typelevel/cats/pull/733): Associativity laws for
  `Kleisli` and `Cokleisli` composition
* [#741](https://github.com/typelevel/cats/pull/741): Tests for
  `Unapply`-supported syntax
* [#690](https://github.com/typelevel/cats/pull/690): Error reporting
  improvements for serializability tests
* [#701](https://github.com/typelevel/cats/pull/701): Better documentation for
  the Travis CI script
* [#787](https://github.com/typelevel/cats/pull/787): Support for cross-module
  Scaladoc links

Known issues:

* [#702](https://github.com/typelevel/cats/pull/702): This change identified and
  fixed a stack safety bug in `foldMap` on `Free`, but raised other issues (see
  [#712](https://github.com/typelevel/cats/issues/712)) and was reverted in
  [#713](https://github.com/typelevel/cats/pull/713);
  [#721](https://github.com/typelevel/cats/issues/721) now tracks the non-stack
  safety of `Free`'s `foldMap`

As always thanks to everyone who filed issues, participated in the Cats Gitter
channel, submitted code, or helped review pull requests.

## Version 0.3.0

> 2015 November 8

Version 0.3.0 is the third release of the Cats library.

This version includes new type class instances:

* [#545](https://github.com/typelevel/cats/pull/545): `Semigroup` instances for
  `OneAnd`
* [#521](https://github.com/typelevel/cats/pull/521): `Monoid` instances for `Xor`
  when the left side has a `Semigroup` instance and the right side has a
  `Monoid`
* [#497](https://github.com/typelevel/cats/pull/497): `Monoid` instances for `Set`
* [#559](https://github.com/typelevel/cats/pull/559): `Bifunctor` instances for
  `Validated`, `Ior`, `Xor`, and `XorT`
* [#569](https://github.com/typelevel/cats/pull/569): `Functor` instances for
  `OptionT` when `F` has a `Functor` instance but not a `Monad`
* [#600](https://github.com/typelevel/cats/pull/600): `Show` instances for `Option`
  and `OptionT`
* [#601](https://github.com/typelevel/cats/pull/601): `Show` instances for `List`
* [#602](https://github.com/typelevel/cats/pull/602): `Show` instances for `Set`
* [#568](https://github.com/typelevel/cats/pull/568): Several new `Unapply` shapes

And API changes:

* [#592](https://github.com/typelevel/cats/pull/592): `fromTryCatch` on `Xor` and
  `Validated` is now `catchOnly`
* [#553](https://github.com/typelevel/cats/pull/553): `MonadError` now characterizes
  type constructors of kind `* -> *` instead of `(*, *) -> *`
* [#598](https://github.com/typelevel/cats/pull/598): `OneAnd`'s type constructor type
  parameter is now before the element type
* [#610](https://github.com/typelevel/cats/pull/610): `XorT`'s `toOption` returns an
  `OptionT[F, B]` instead of an `F[Option[B]]`
* [#518](https://github.com/typelevel/cats/pull/518): `Free`'s `resume` method now
  returns an `Xor` instead of an `Either`
* [#575](https://github.com/typelevel/cats/pull/575) and
  [#606](https://github.com/typelevel/cats/pull/606): `orElse` on `Xor` and
  `Validated` does not unnecessarily constrain the type of the left side of the
  result
* [#577](https://github.com/typelevel/cats/pull/577): `*Aux` helper classes have been
  renamed `*PartiallyApplied`

And additions:

* [#542](https://github.com/typelevel/cats/pull/542): `WriterT`
* [#567](https://github.com/typelevel/cats/pull/567): `Ior.fromOptions`
* [#528](https://github.com/typelevel/cats/pull/528): `OptionT.fromOption`
* [#562](https://github.com/typelevel/cats/pull/562): `handleErrorWith` and related
  helper methods on `MonadError`
* [#520](https://github.com/typelevel/cats/pull/520): `toNel` and `fromList`
  conversions from `List` to `NonEmptyList`
* [#533](https://github.com/typelevel/cats/pull/533): Conversions between types with
  `Foldable` instances and `Streaming`
* [#507](https://github.com/typelevel/cats/pull/507): `isJvm` and `isJs` macros in the
  new `cats.macros.Platform`
* [#572](https://github.com/typelevel/cats/pull/572): `analyze` on `FreeApplicative`
  for compilation into a `Monoid`
* [#587](https://github.com/typelevel/cats/pull/587): Syntax for lifting values (and
  optional values) into `Validated`

And several aliases:

* [#492](https://github.com/typelevel/cats/pull/492): `FlatMapSyntax` now includes
  `followedBy`, which is an alias for `>>`, together with a new
  `followedByEval`, which allows the caller to choose the evaluation strategy of
  the second action
* [#523](https://github.com/typelevel/cats/pull/523): `Foldable` now has a
  `combineAll` method that aliases `fold` and allows postfix usage via
  `FoldableSyntax`

And a few removals:

* [#524](https://github.com/typelevel/cats/pull/524): `FreeApplicative`'s redundant
  `hoist`, which was equivalent to `compile`
* [#531](https://github.com/typelevel/cats/pull/531): `Coyoneda`'s `by`
* [#612](https://github.com/typelevel/cats/pull/612): Many prioritization and instance
  traits are now private

And bug fixes:

* [#547](https://github.com/typelevel/cats/pull/547): The `empty` values for
  `Monoid[Double]` and `Monoid[Float]` are now `0` instead of `1`
* [#530](https://github.com/typelevel/cats/pull/530): `Streaming.take(n).toList` no
  longer evaluates the `n + 1`-st element
* [#538](https://github.com/typelevel/cats/pull/538): `OneAnd`'s instances are
  properly prioritized

There are also many improvements to the documentation, tutorials, laws, tests,
and benchmarks:

* [#522](https://github.com/typelevel/cats/pull/522): ScalaTest's `===` now uses `Eq`
  instances
* [#502](https://github.com/typelevel/cats/pull/502): `Traverse`'s laws verify the
  consistency of `foldMap` and `traverse`
* [#519](https://github.com/typelevel/cats/pull/519): Benchmarks (and performance
  improvements) for `Eval`
* …and many others

Thanks to everyone who filed issues, participated in the Cats Gitter channel,
submitted code, or helped review pull requests.

## Version 0.2.0

> 2015 August 31

Version 0.2.0 is the second release of the Cats library.

The most exciting feature of this release is Scala.js support, which
comes courtesy of much hard work by the Scala.js community (especially
Alistair Johnson). The `sbt` build configuration and project layout were
updated to support building for both the JVM and JS platforms.

Since the 0.1.2 release there was wide agreement that the split
between `cats-core` and `cats-std` was awkward. The two projects have
been combined into `cats-core`, meaning that type class instances for
common types like `List` are now available in `cats-core`.

There was also a concerted effort to improve and add documentation to
the project. Many people helped find typos, broken links, and places
where the docs could be improved. In particular, the following
tutorials were added or overhauled:

 * `Applicative`
 * `Const`
 * `Foldable`
 * `Free`
 * `FreeApplicative`
 * `Kleisli`
 * `Monad`
 * `Monoid`
 * `Semigroup`
 * `SemigroupK`
 * `Traverse`
 * `Validated`
 * `Xor`

Several new type classes and data types were introduced:

 * `Choice[F[_, _]]`
 * `Group[A]`
 * `MonadReader[F[_, _], R]`
 * `Streaming[A]` and `StreamingT[F[_], A]`
 * `Prod[F[_], G[_], A]` and `Func[F[_], A, B]`

Syntax tests were added to ensure that existing syntax worked, and
there has been some movement to enrich existing types with syntax to
make converting them to Cats types easier.

The previous `Fold[A]` type, which was used to support lazy folds, has
been replaced with `Eval[A]`. This type supports both strict and lazy
evaluation, supports lazy `map` and `flatMap`, and is trampolined for
stack safety. The definition of `Foldable#foldRight` has been updated
to something much more idiomatic and easier to reason about. The goal
is to support laziness in Cats via the `Eval[A]` type wherever
possible.

In addition to these specific changes there were numerous small bug
fixes, additions, improvements, and updates. Thanks to everyone who
filed issues, participated in the Cats Gitter channel, submitted code,
or helped review pull requests.

## Version 0.1.2

> 2015 July 17

(Due to problems with publishing 0.1.0 and 0.1.1 are incomplete.)

Version 0.1.2 is the first non-snapshot version of the Cats library!
It is intended to assist the creation of dependent libraries and to be
an early look at Cats' design.

Much of the library is quite mature, but there are no source- or
binary-compatibility guarantees at this time. The overarching design
of the library is still somewhat in flux, although mostly we expect
there will be new type classes, instances, and syntax. Some package
and module boundaries may also shift.

For complete credits, see [AUTHORS.md](AUTHORS.md) for a list of
people whose work has made this release possible.
