---
layout: page
title:  "Typelevel Ecosystem"
section: ""
position: <!-- 40 -->
---

# Typelevel Ecosystem #

By sharing the same set of type classes, instances and data types provided by Cats, projects can speak the same “Cats language”, and integrate with each other with ease.


## Libraries ##

Here you can find a comprehensive list of libraries and projects related to Typelevel:

| Project                                                                                  | Description                                                                                                                                                                                                                                                                                                                                                                                              |
|:----------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
| [Mules](https://github.com/ChristopherDavenport/mules)                                   | In memory caching.                                                                                                                                                                                                                                                                                                                                                                                       |
| [agitation](https://christopherdavenport.github.io/agitation/)                           | Cooperative Cancelation for [cats effect](https://typelevel.org/cats-effect/).                                                                                                                                                                                                                                                                                                                           |
| [ancient-concurrent](https://christopherdavenport.github.io/ancient-concurrent/)         | [cats effect](https://typelevel.org/cats-effect/) concurrent for cats-effect 0.10.                                                                                                                                                                                                                                                                                                                       |
| [atto](https://tpolecat.github.io/atto/)                                                 | Friendly little text parsers.                                                                                                                                                                                                                                                                                                                                                                            |
| [bank](https://github.com/ChristopherDavenport/bank)                                     | Concurrent Vault Management.                                                                                                                                                                                                                                                                                                                                                                             |
| [canoe](https://github.com/augustjune/canoe)                                             | A purely functional library for building [Telegram](https://telegram.org/) chatbots.                                                                                                                                                                                                                                                                                                                     |
| [cats effect](https://typelevel.org/cats-effect/)                                        | High-performance, asynchronous, composable framework for building real-world applications in a purely functional style.                                                                                                                                                                                                                                                                                  |
| [cats-effect-testing](https://github.com/djspiewak/cats-effect-testing)                  | Experimental integration between [cats effect](https://typelevel.org/cats-effect/) and testing frameworks.                                                                                                                                                                                                                                                                                               |
| [cats-effect-time](https://christopherdavenport.github.io/cats-effect-time/)             | Java Time from [cats effect](https://typelevel.org/cats-effect/).                                                                                                                                                                                                                                                                                                                                        |
| [cats-retry](https://cb372.github.io/cats-retry/)                                        | Composable retry logic for [Cats](Https://Typelevel.Org/Cats/) and [cats effect](https://typelevel.org/cats-effect/).                                                                                                                                                                                                                                                                                    |
| [cats-scalacheck](https://christopherdavenport.github.io/cats-scalacheck/)               | [Cats](Https://Typelevel.Org/Cats/) typeclass instances for [ScalaCheck](https://www.scalacheck.org/).                                                                                                                                                                                                                                                                                                   |
| [cats-stm](https://timwspence.github.io/cats-stm/)                                       | Software Transactional Memory for [cats effect](https://typelevel.org/cats-effect/).                                                                                                                                                                                                                                                                                                                     |
| [cats-time](https://christopherdavenport.github.io/cats-time/)                           | [Cats](Https://Typelevel.Org/Cats/) typeclass instances for [java.time](https://docs.oracle.com/javase/8/docs/api/java/time/package-summary.html).                                                                                                                                                                                                                                                       |
| [chromaprint](https://github.com/mgdigital/Chromaprint.scala)                            | A Scala implementation of the Chromaprint/AcoustID audio fingerprinting algorithm, built with [fs2](https://fs2.io/index.html) streams / [cats effect](https://typelevel.org/cats-effect/).                                                                                                                                                                                                              |
| [circe-fs2](https://github.com/circe/circe-fs2)                                          | Streaming JSON manipulation with [circe](https://circe.github.io/circe/).                                                                                                                                                                                                                                                                                                                                                                  |
| [circe](https://circe.github.io/circe/)                                                  | Pure functional JSON library.                                                                                                                                                                                                                                                                                                                                                                            |
| [circuit](https://christopherdavenport.github.io/circuit/)                               | Functional Circuit Breaker implementation.                                                                                                                                                                                                                                                                                                                                                               |
| [ciris](https://cir.is/)                                                                 | Lightweight, extensible, and validated configuration loading in Scala.                                                                                                                                                                                                                                                                                                                                   |
| [console4cats](https://console4cats.profunktor.dev/)                                     | Console I/O for [cats effect](https://typelevel.org/cats-effect/).                                                                                                                                                                                                                                                                                                                                       |
| [cormorant](https://christopherdavenport.github.io/cormorant/)                           | CSV handling library for FP.                                                                                                                                                                                                                                                                                                                                                                             |
| [coulomb-cats](https://github.com/erikerlandson/coulomb)                                 | [Cats](Https://Typelevel.Org/Cats/) typeclass instances for coulomb Quantity.                                                                                                                                                                                                                                                                                                                            |
| [decline](http://ben.kirw.in/decline/)                                                   | A composable command-line parser.                                                                                                                                                                                                                                                                                                                                                                        |
| [doobie-pool](https://christopherdavenport.github.io/doobie-pool/)                       | Doobie Pooling Mechanism in Pure FP.                                                                                                                                                                                                                                                                                                                                                                     |
| [doobie](https://tpolecat.github.io/doobie/)                                             | Pure functional JDBC built on [fs2](https://fs2.io/index.html).                                                                                                                                                                                                                                                                                                                                          |
| [droste](https://github.com/higherkindness/droste)                                       | Recursion schemes for [Cats](Https://Typelevel.Org/Cats/).                                                                                                                                                                                                                                                                                                                                               |
| [dsl-domains-cats](https://github.com/ThoughtWorksInc/dsl-domains-cats)                  | The !-notation for creating [Cats](Https://Typelevel.Org/Cats/) monadic expressions.                                                                                                                                                                                                                                                                                                                     |
| [dynamapath](https://christopherdavenport.github.io/dynamapath/)                         | Dynamic Path Parsing.                                                                                                                                                                                                                                                                                                                                                                                    |
| [eff](https://atnos-org.github.io/eff/)                                                  | Functional effects and effect handlers (alternative to monad transformers).                                                                                                                                                                                                                                                                                                                              |
| [epimetheus-circuit](https://github.com/ChristopherDavenport/epimetheus-circuit/)        | Prometeus Rejected Execution Metrics.                                                                                                                                                                                                                                                                                                                                                                    |
| [epimetheus-http4s](https://github.com/ChristopherDavenport/epimetheus-http4s)           | Prometeus Http4s Metrics Middleware and Push Gateway Support.                                                                                                                                                                                                                                                                                                                                            |
| [epimetheus-log4cats](https://github.com/ChristopherDavenport/epimetheus-log4cats)       | Prometeus Logging Metrics.                                                                                                                                                                                                                                                                                                                                                                               |
| [epimetheus-redis4cats](https://github.com/ChristopherDavenport/epimetheus-redis4cats)   | Prometeus Redis4cats Metrics.                                                                                                                                                                                                                                                                                                                                                                            |
| [epimetheus](https://christopherdavenport.github.io/epimetheus/)                         | Prometeus Core Reperesentations.                                                                                                                                                                                                                                                                                                                                                                         |
| [extruder](https://janstenpickle.github.io/extruder/)                                    | Populate case classes from any data source.                                                                                                                                                                                                                                                                                                                                                              |
| [fastparse-cats](https://github.com/johnynek/fastparse-cats)                             | [Cats](Https://Typelevel.Org/Cats/) Monad and Alternative instances for [fastparse](https://www.lihaoyi.com/fastparse/).                                                                                                                                                                                                                                                                                 |
| [fd4s/fs2-kafka](https://fd4s.github.io/fs2-kafka/)                                      | Functional [Kafka](Https://Kafka.Apache.Org/) Streams for Scala.                                                                                                                                                                                                                                                                                                                                         |
| [fetch](https://47degrees.github.io/fetch/)                                              | Efficient data access to heterogeneous data sources.                                                                                                                                                                                                                                                                                                                                                     |
| [finch](https://finagle.github.io/finch/)                                                | Scala combinator api for building [finagle](https://twitter.github.io/finagle/) http services.                                                                                                                                                                                                                                                                                                           |
| [frameless](https://github.com/typelevel/frameless)                                      | Expressive types for [Spark](https://spark.apache.org/).                                                                                                                                                                                                                                                                                                                                                 |
| [freestyle](http://frees.io/)                                                            | Pure functional framework for free and tagless final applications and libraries.                                                                                                                                                                                                                                                                                                                         |
| [fs2-aws](https://github.com/laserdisc-io/fs2-aws)                                       | [Fs2](https://fs2.io/index.html) streams to interact with AWS utilities.                                                                                                                                                                                                                                                                                                                                 |
| [fs2-blobstore](https://github.com/lendup/fs2-blobstore)                                 | Minimal, idiomatic, stream-based Scala interface for S3, GCS, SFTP and other key/value store implementations.                                                                                                                                                                                                                                                                                            |
| [fs2-cassandra](https://spinoco.github.io/fs2-cassandra/)                                | [Cassandra](https://cassandra.apache.org/) bindings for [fs2](https://fs2.io/index.html).                                                                                                                                                                                                                                                                                                                |
| [fs2-columns](https://gitlab.com/lJoublanc/fs2-columns)                                  | A Chunk that uses [Shapeless](https://github.com/milessabin/shapeless) to store case class data column-wise.                                                                                                                                                                                                                                                                                             |
| [fs2-cron](https://gitlab.com/lJoublanc/fs2-columns)                                     | [Fs2](https://fs2.io/index.html) streams based on cron expressions.                                                                                                                                                                                                                                                                                                                                      |
| [fs2-crypto](https://github.com/Spinoco/fs2-crypto)                                      | TLS support for [fs2](https://fs2.io/index.html).                                                                                                                                                                                                                                                                                                                                                        |
| [fs2-data](https://fs2-data.gnieh.org/)                                                  | A set of data parsers and manipulation libraries for various formats for [fs2](https://fs2.io/index.html).                                                                                                                                                                                                                                                                                               |
| [fs2-elastic](https://github.com/amarrella/fs2-elastic)                                  | Simple client for Elasticsearch.                                                                                                                                                                                                                                                                                                                                                                         |
| [fs2-ftp](https://github.com/regis-leray/fs2-ftp)                                        | Simple client for Ftp/Ftps/Sftp using [fs2](https://fs2.io/index.html) and [cats effect](https://typelevel.org/cats-effect/).                                                                                                                                                                                                                                                                            |
| [fs2-google-pubsub](https://github.com/permutive/fs2-google-pubsub)                      | A Google Cloud Pub/Sub implementation using [fs2](https://fs2.io/index.html) and [cats effect](https://typelevel.org/cats-effect/).                                                                                                                                                                                                                                                                      |
| [fs2-grpc](https://github.com/fiadliel/fs2-grpc)                                         | GRPC implementation for [Fs2](https://fs2.io/index.html) / [cats effect](https://typelevel.org/cats-effect/).                                                                                                                                                                                                                                                                                            |
| [fs2-http](https://github.com/Spinoco/fs2-http)                                          | Http server and client library implemented in [fs2](https://fs2.io/index.html).                                                                                                                                                                                                                                                                                                                          |
| [fs2-jms](https://github.com/kiambogo/fs2-jms)                                           | Java Messaging Service (JMS) connectors for [Fs2](https://fs2.io/index.html) streams.                                                                                                                                                                                                                                                                                                                    |
| [fs2-log](https://github.com/Spinoco/fs2-log)                                            | Simple logging facade for [fs2](https://fs2.io/index.html).                                                                                                                                                                                                                                                                                                                                              |
| [fs2-mail](https://github.com/Spinoco/fs2-mail)                                          | Fully asynchronous Java non-blocking email client using [fs2](https://fs2.io/index.html).                                                                                                                                                                                                                                                                                                                |
| [fs2-mqtt](https://github.com/user-signal/fs2-mqtt/)                                     | A purely functional MQTT client library based on [fs2](https://fs2.io/index.html) and [cats effect](https://typelevel.org/cats-effect/).                                                                                                                                                                                                                                                                 |
| [fs2-rabbit](https://fs2-rabbit.profunktor.dev/)                                         | [RabbitMQ](https://www.rabbitmq.com/) stream-based client built on top of [fs2](https://fs2.io/index.html) and [cats effect](https://typelevel.org/cats-effect/).                                                                                                                                                                                                                                        |
| [fs2-reactive-streams](https://github.com/zainab-ali/fs2-reactive-streams)               | A reactive streams implementation for [fs2](https://fs2.io/index.html).                                                                                                                                                                                                                                                                                                                                  |
| [fs2-ssh](https://github.com/precog/fs2-ssh)                                             | A wrapper around Apache SSHD targeting [cats effect](https://typelevel.org/cats-effect/) and [fs2](https://fs2.io/index.html).                                                                                                                                                                                                                                                                           |
| [fs2-zk](https://github.com/Spinoco/fs2-zk)                                              | Simple Apache [Zookeeper](https://zookeeper.apache.org/) bindings for [fs2](https://fs2.io/index.html).                                                                                                                                                                                                                                                                                                  |
| [fs2](https://fs2.io/index.html)                                                         | Functional streams for Scala (streaming I/O library).                                                                                                                                                                                                                                                                                                                                                    |
| [fuuid-annotation](https://christopherdavenport.github.io/fuuid-annotation/)             | Automatically create an inner Id tagged FUUID type with convenient methods for its creation.                                                                                                                                                                                                                                                                                                             |
| [fuuid](https://christopherdavenport.github.io/fuuid/)                                   | Functional UUID's.                                                                                                                                                                                                                                                                                                                                                                                       |
| [gato-parsec](https://christopherdavenport.github.io/gato-parsec/)                       | Generalized attoparsec with [Cats](Https://Typelevel.Org/Cats/).                                                                                                                                                                                                                                                                                                                                         |
| [github4s](http://47degrees.github.io/github4s/)                                         | Wrapper around the GitHub API.                                                                                                                                                                                                                                                                                                                                                                           |
| [github](https://christopherdavenport.github.io/github/)                                 | Github Integration for Scala.                                                                                                                                                                                                                                                                                                                                                                            |
| [grafter](https://opensource.zalando.com/grafter/)                                       | Dependency-injection library using the Reader pattern.                                                                                                                                                                                                                                                                                                                                                   |
| [graphite4s](https://github.com/YannMoisan/graphite4s)                                   | Lightweight graphite client.                                                                                                                                                                                                                                                                                                                                                                             |
| [gsheets4s](https://github.com/BenFradet/gsheets4s)                                      | Wrapper around the Google Sheets API.                                                                                                                                                                                                                                                                                                                                                                    |
| [hammock](https://pepegar.com/hammock)                                                   | Purely functional HTTP client.                                                                                                                                                                                                                                                                                                                                                                           |
| [henkan](https://github.com/kailuowang/henkan)                                           | Type safe conversion between case class instances with similar fields.                                                                                                                                                                                                                                                                                                                                   |
| [http4s](https://http4s.org/)                                                            | Minimal, idiomatic Scala interface for HTTP services using [fs2](https://fs2.io/index.html).                                                                                                                                                                                                                                                                                                             |
| [iota](https://github.com/frees-io/iota)                                                 | Fast [co]product types with a clean syntax.                                                                                                                                                                                                                                                                                                                                                              |
| [itto-csv](https://github.com/gekomad/itto-csv)                                          | Pure functional library for working with CSV.                                                                                                                                                                                                                                                                                                                                                            |
| [kafka4s](https://banno.github.io/kafka4s/)                                              | Functional programming with [Kafka](Https://Kafka.Apache.Org/) and Scala.                                                                                                                                                                                                                                                                                                                                |
| [kamon-monix](https://github.com/bogdanromanx/kamon-monix)                               | [Kamon](https://github.com/kamon-io/Kamon) Integration for [Monix](Https://Monix.Io/).                                                                                                                                                                                                                                                                                                                   |
| [keysemaphore](https://christopherdavenport.github.io/keysemaphore/)                     | Keyed Semaphore implementation.                                                                                                                                                                                                                                                                                                                                                                          |
| [library.g8](https://github.com/ChristopherDavenport/library.g8)                         | Library Starter Template.                                                                                                                                                                                                                                                                                                                                                                                |
| [linebacker](https://christopherdavenport.github.io/linebacker/)                         | Thread pool management for Scala: Enabling functional blocking where needed.                                                                                                                                                                                                                                                                                                                             |
| [log4cats-log4s](https://christopherdavenport.github.io/log4cats-log4s)                  | Log4s support for [log4cats](https://christopherdavenport.github.io/log4cats/).                                                                                                                                                                                                                                                                                                                          |
| [log4cats-mtl](https://christopherdavenport.github.io/log4cats-mtl/)                     | Provide MTL support for [log4cats](https://christopherdavenport.github.io/log4cats/).                                                                                                                                                                                                                                                                                                                    |
| [log4cats-scribe](https://christopherdavenport.github.io/log4cats-scribe)                | Scribe support for [log4cats](https://christopherdavenport.github.io/log4cats/).                                                                                                                                                                                                                                                                                                                         |
| [log4cats](https://christopherdavenport.github.io/log4cats/)                             | Functional logging.                                                                                                                                                                                                                                                                                                                                                                                      |
| [mapref](https://christopherdavenport.github.io/mapref/)                                 | Refs optimized around maps.                                                                                                                                                                                                                                                                                                                                                                              |
| [mau](https://github.com/kailuowang/mau)                                                 | A tiny library for an auto polling ref.                                                                                                                                                                                                                                                                                                                                                                  |
| [monadic-html](https://olivierblanvillain.github.io/monadic-html/)                       | Tiny DOM binding library for Scala.js.                                                                                                                                                                                                                                                                                                                                                                   |
| [mongosaur](https://gitlab.com/lJoublanc/mongosaur)                                      | [Fs2](Https://Fs2.Io/Index.Html)-based MongoDB driver.                                                                                                                                                                                                                                                                                                                                                   |
| [monix bio](https://bio.monix.io/)                                                       | Io alternative with typed errors.                                                                                                                                                                                                                                                                                                                                                                        |
| [monix-connect](https://connect.monix.io/)                                               | stream integrations for [Monix](Https://Monix.Io/).                                                                                                                                                                                                                                                                                                                                                      |
| [monix-kafka](https://github.com/monix/monix-kafka)                                      | [Monix](Https://Monix.Io/) integration with [Kafka](Https://Kafka.Apache.Org/).                                                                                                                                                                                                                                                                                                                          |
| [monix-nio](https://github.com/monix/monix-nio)                                          | Java NIO utilities for usage with [Monix](Https://Monix.Io/).                                                                                                                                                                                                                                                                                                                                            |
| [monix](https://monix.io/)                                                               | High-performance library for composing asynchronous and event-based programs.                                                                                                                                                                                                                                                                                                                            |
| [monocle](https://www.optics.dev/Monocle/)                                               | An optics library for Scala (and Scala.js) strongly inspired by [Haskell Lens](https://hackage.haskell.org/package/lens).                                                                                                                                                                                                                                                                                |
| [monoids](https://christopherdavenport.github.io/monoids/)                               | Generic Monoids in Scala.                                                                                                                                                                                                                                                                                                                                                                                |
| [morphling](https://github.com/danslapman/morphling)                                     | Free applicative schemas & instance derivation.                                                                                                                                                                                                                                                                                                                                                          |
| [mules-http4s-redis](https://christopherdavenport.github.io/mules-http4s-redis)          | [Mules](https://github.com/ChristopherDavenport/mules) Distributed Http Caching Support.                                                                                                                                                                                                                                                                                                                 |
| [mules-http4s](https://christopherdavenport.github.io/mules-http4s/)                     | [Mules](https://github.com/ChristopherDavenport/mules) Http4s Caching Implementation for Caching Servers and Client Http Interactions According to the Http Spec.                                                                                                                                                                                                                                        |
| [mules-redis](https://christopherdavenport.github.io/mules-redis/)                       | [Mules](https://github.com/ChristopherDavenport/mules) Redis Support.                                                                                                                                                                                                                                                                                                                                    |
| [mysql-binlog-stream](https://github.com/allwefantasy/spark-binlog)                      | Stream MySQL binlog events with [Fs2](https://fs2.io/index.html).                                                                                                                                                                                                                                                                                                                                        |
| [natchez](https://github.com/tpolecat/natchez)                                           | An opentracing library, to use with Jaegger, Honeycomb, OpenCensus, and Lightstep.                                                                                                                                                                                                                                                                                                                       |
| [neotypes](https://neotypes.github.io/neotypes/)                                         | A Scala lightweight, type-safe & asynchronous driver for neo4j. Support streaming queries using [fs2](https://fs2.io/index.html).                                                                                                                                                                                                                                                                        |
| [neutron](https://cr-org.github.io/neutron/)                                             | Apache Pulsar bindings for [fs2](https://fs2.io/index.html).                                                                                                                                                                                                                                                                                                                                             |
| [newts](https://julien-truffaut.github.io/newts/)                                        | Defines newtypes compatible with [Cats](Https://Typelevel.Org/Cats/) type classes.                                                                                                                                                                                                                                                                                                                       |
| [odin](https://github.com/valskalla/odin)                                                | Fast & functional logger with own logging backend.                                                                                                                                                                                                                                                                                                                                                       |
| [origami](https://github.com/atnos-org/origami)                                          | Monadic folds.                                                                                                                                                                                                                                                                                                                                                                                           |
| [phony](https://github.com/alirezameskin/phony)                                          | Fake data generator.                                                                                                                                                                                                                                                                                                                                                                                     |
| [pulsar4s](https://github.com/sksamuel/pulsar4s)                                         | concise, idiomatic, reactive, type safe Scala client for [Apache Pulsar](https://pulsar.apache.org/).                                                                                                                                                                                                                                                                                                    |
| [pureconfig](https://pureconfig.github.io/)                                              | A boilerplate-free library for loading configuration files.                                                                                                                                                                                                                                                                                                                                              |
| [rainier](https://rainier.fit/)                                                          | Bayesian inference in Scala.                                                                                                                                                                                                                                                                                                                                                                             |
| [random](https://christopherdavenport.github.io/random/)                                 | Pure randomness in Scala.                                                                                                                                                                                                                                                                                                                                                                                |
| [read](https://github.com/ChristopherDavenport/read)                                     | Read Typeclass.                                                                                                                                                                                                                                                                                                                                                                                          |
| [rediculous](https://christopherdavenport.github.io/rediculous/)                         | Pure FP [Redis](https://redis.io/) client.                                                                                                                                                                                                                                                                                                                                                               |
| [redis4cats](https://redis4cats.profunktor.dev/)                                         | [Redis](https://redis.io/) client built on top of [fs2](https://fs2.io/index.html) and [cats effect](https://typelevel.org/cats-effect/).                                                                                                                                                                                                                                                                |
| [refined](https://github.com/fthomas/refined)                                            | Simple refinement types for Scala.                                                                                                                                                                                                                                                                                                                                                                       |
| [sangria-monix](https://github.com/sangria-graphql/sangria-monix)                        | Sangria integration for [Monix](Https://Monix.Io/).                                                                                                                                                                                                                                                                                                                                                      |
| [sbt-mima-version-check](https://christopherdavenport.github.io/sbt-mima-version-check/) | Plugin to automate which mima versions to check.                                                                                                                                                                                                                                                                                                                                                         |
| [scala cache](https://cb372.github.io/scalacache/)                                       | A facade for the most popular cache implementations for Scala.                                                                                                                                                                                                                                                                                                                                           |
| [scala-forex](https://github.com/snowplow/scala-forex)                                   | Exchange rate lookups.                                                                                                                                                                                                                                                                                                                                                                                   |
| [scala-maxmind-ip-lookups](https://github.com/snowplow/scala-maxmind-iplookups)          | IP geolocation through the Maxmind database.                                                                                                                                                                                                                                                                                                                                                             |
| [scala-referer-parser](https://github.com/snowplow-referer-parser/scala-referer-parser)  | Referer parsing.                                                                                                                                                                                                                                                                                                                                                                                         |
| [scala-rl](https://www.scalarl.com/)                                                     | Functional, monadic reinforcement learning in Scala.                                                                                                                                                                                                                                                                                                                                                     |
| [scala-weather](https://github.com/snowplow/scala-weather)                               | Weather lookups.                                                                                                                                                                                                                                                                                                                                                                                         |
| [scanamo](https://www.scanamo.org/)                                                      | Simpler [DynamoDB](https://aws.amazon.com/dynamodb/) access for Scala.                                                                                                                                                                                                                                                                                                                                   |
| [scarctic](https://gitlab.com/lJoublanc/scarctic)                                        | [Fs2](Https://Fs2.Io/Index.Html)-based driver for MAN/AHL’s Arctic data store.                                                                                                                                                                                                                                                                                                                           |
| [scodec-protocols](https://github.com/scodec/scodec-protocols)                           | A library for working with libpcap files. Contains many interesting pipes (e.g., working with time series and playing back streams at various rates).                                                                                                                                                                                                                                                    |
| [scodec-stream](https://github.com/scodec/scodec-stream)                                 | A library for streaming binary decoding and encoding, built using [fs2](https://fs2.io/index.html) and scodec.                                                                                                                                                                                                                                                                                           |
| [seals](https://github.com/durban/seals)                                                 | Tools for schema evolution and language-integrated schemata.                                                                                                                                                                                                                                                                                                                                             |
| [semigroups](https://github.com/ChristopherDavenport/semigroups)                         | Set of generic semigroup types and accompanying instances very useful for abstract programming.                                                                                                                                                                                                                                                                                                          |
| [shims](https://github.com/djspiewak/shims)                                              | Seamless interoperability for [Cats](Https://Typelevel.Org/Cats/) and [Scalaz](https://scalaz.github.io/7/) typeclasses and datatypes.                                                                                                                                                                                                                                                                   |
| [skunk](https://tpolecat.github.io/skunk/)                                               | A data access library for Scala + [Postgres](https://www.postgresql.org/).                                                                                                                                                                                                                                                                                                                               |
| [spata](https://github.com/fingo/spata)                                                  | CSV parser build on [Fs2](https://fs2.io/index.html).                                                                                                                                                                                                                                                                                                                                                    |
| [spinoco/fs2-kafka](https://github.com/Spinoco/fs2-kafka)                                | Simple client for Apache [Kafka](Https://Kafka.Apache.Org/).                                                                                                                                                                                                                                                                                                                                             |
| [sqs4s](https://d2a4u.github.io/sqs4s/)                                                  | A pure Scala client for [AWS SQS](https://www.postgresql.org/) using [fs2](https://fs2.io/index.html).                                                                                                                                                                                                                                                                                                   |
| [streamz](https://github.com/krasserm/streamz)                                           | A library that supports the conversion of [Akka Stream](https://doc.akka.io/docs/akka/current/stream/index.html) Sources, Flows and Sinks to and from [Fs2](https://fs2.io/index.html) Streams, Pipes and Sinks, respectively. It also supports the usage of [Apache Camel](https://camel.apache.org/) endpoints in [Fs2](https://fs2.io/index.html) Streams and Akka Stream Sources, Flows and SubFlows. |
| [sttp](https://github.com/softwaremill/sttp)                                             | The Scala HTTP client you always wanted.                                                                                                                                                                                                                                                                                                                                                                 |
| [sup](https://sup.kubukoz.com/)                                                          | Composable, purely functional healthchecks in Scala.                                                                                                                                                                                                                                                                                                                                                     |
| [synchronized](https://christopherdavenport.github.io/synchronized/)                     | Synchronous resource access.                                                                                                                                                                                                                                                                                                                                                                             |
| [system-effect](https://github.com/ChristopherDavenport/system-effect)                   | Console and Environment Simple Tools.                                                                                                                                                                                                                                                                                                                                                                    |
| [testcontainers-specs2](https://github.com/ChristopherDavenport/testcontainers-specs2)   | Test Containers Support for Specs2.                                                                                                                                                                                                                                                                                                                                                                      |
| [tsec](https://jmcardon.github.io/tsec/)                                                 | Typesafe, functional, general purpose cryptography and security library.                                                                                                                                                                                                                                                                                                                                 |
| [unique](https://christopherdavenport.github.io/unique/)                                 | Unique functional values for Scala.                                                                                                                                                                                                                                                                                                                                                                      |
| [upperbound](https://github.com/SystemFw/upperbound)                                     | A purely functional, interval-based rate limiter with support for backpressure.                                                                                                                                                                                                                                                                                                                          |
| [vault](https://christopherdavenport.github.io/vault/)                                   | Type-safe, persistent storage for values of arbitrary types.                                                                                                                                                                                                                                                                                                                                             |
| [vinyldns](https://www.vinyldns.io/)                                                     | A DNS governance system using [fs2](https://fs2.io/index.html) for throttling updates to DNS backends.                                                                                                                                                                                                                                                                                                   |
| [whale-tail](https://christopherdavenport.github.io/whale-tail)                          | Docker Daemon Integration.                                                                                                                                                                                                                                                                                                                                                                               |
|                                                                                          |                                                                                                                                                                                                                                                                                                                                                                                                          |

Your project talks Cats too? [Submit a PR to add it here!](https://github.com/typelevel/cats/edit/master/docs/src/main/mdoc/typelevelEcosystem.md)

*The full-size [Cats logo](https://typelevel.org/cats/img/cats-logo.png) is available for use for Cats related projects, contents, souvenirs, etc.*

*We offer a [Cats Friendly Badge](https://typelevel.org/cats/img/cats-badge.svg) to let others know your project works with Cats!*

![Cats Friendly Badge](https://typelevel.org/cats/img/cats-badge-normal.png)

Below are quick html and markdown snippets to use the badge in your own project.
```html
<a href="https://typelevel.org/cats/"><img src="https://typelevel.org/cats/img/cats-badge-tiny.png" alt="Cats friendly" /></a>
```
```markdown
![Cats Friendly Badge](https://typelevel.org/cats/img/cats-badge-tiny.png)
```
