/**
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This file is generated by generate_channels.js, do not edit manually.

import type { Validator } from './validatorPrimitives';
import { ValidationError, tOptional, tObject, tBoolean, tNumber, tString, tAny, tEnum, tArray, tBinary } from './validatorPrimitives';
export type { Validator } from './validatorPrimitives';
export { ValidationError } from './validatorPrimitives';

type Scheme = { [key: string]: Validator };

export function createScheme(tChannel: (name: string) => Validator): Scheme {
  const scheme: Scheme = {};

  const tType = (name: string): Validator => {
    return (arg: any, path: string) => {
      const v = scheme[name];
      if (!v)
        throw new ValidationError(path + ': unknown type "' + name + '"');
      return v(arg, path);
    };
  };

  scheme.StackFrame = tObject({
    file: tString,
    line: tOptional(tNumber),
    column: tOptional(tNumber),
    function: tOptional(tString),
  });
  scheme.Metadata = tObject({
    stack: tOptional(tArray(tType('StackFrame'))),
    apiName: tOptional(tString),
    internal: tOptional(tBoolean),
  });
  scheme.Point = tObject({
    x: tNumber,
    y: tNumber,
  });
  scheme.Rect = tObject({
    x: tNumber,
    y: tNumber,
    width: tNumber,
    height: tNumber,
  });
  scheme.SerializedValue = tObject({
    n: tOptional(tNumber),
    b: tOptional(tBoolean),
    s: tOptional(tString),
    v: tOptional(tEnum(['null', 'undefined', 'NaN', 'Infinity', '-Infinity', '-0'])),
    d: tOptional(tString),
    r: tOptional(tObject({
      p: tString,
      f: tString,
    })),
    a: tOptional(tArray(tType('SerializedValue'))),
    o: tOptional(tArray(tObject({
      k: tString,
      v: tType('SerializedValue'),
    }))),
    h: tOptional(tNumber),
    id: tOptional(tNumber),
    ref: tOptional(tNumber),
  });
  scheme.SerializedArgument = tObject({
    value: tType('SerializedValue'),
    handles: tArray(tChannel('*')),
  });
  scheme.ExpectedTextValue = tObject({
    string: tOptional(tString),
    regexSource: tOptional(tString),
    regexFlags: tOptional(tString),
    matchSubstring: tOptional(tBoolean),
    normalizeWhiteSpace: tOptional(tBoolean),
  });
  scheme.AXNode = tObject({
    role: tString,
    name: tString,
    valueString: tOptional(tString),
    valueNumber: tOptional(tNumber),
    description: tOptional(tString),
    keyshortcuts: tOptional(tString),
    roledescription: tOptional(tString),
    valuetext: tOptional(tString),
    disabled: tOptional(tBoolean),
    expanded: tOptional(tBoolean),
    focused: tOptional(tBoolean),
    modal: tOptional(tBoolean),
    multiline: tOptional(tBoolean),
    multiselectable: tOptional(tBoolean),
    readonly: tOptional(tBoolean),
    required: tOptional(tBoolean),
    selected: tOptional(tBoolean),
    checked: tOptional(tEnum(['checked', 'unchecked', 'mixed'])),
    pressed: tOptional(tEnum(['pressed', 'released', 'mixed'])),
    level: tOptional(tNumber),
    valuemin: tOptional(tNumber),
    valuemax: tOptional(tNumber),
    autocomplete: tOptional(tString),
    haspopup: tOptional(tString),
    invalid: tOptional(tString),
    orientation: tOptional(tString),
    children: tOptional(tArray(tType('AXNode'))),
  });
  scheme.SetNetworkCookie = tObject({
    name: tString,
    value: tString,
    url: tOptional(tString),
    domain: tOptional(tString),
    path: tOptional(tString),
    expires: tOptional(tNumber),
    httpOnly: tOptional(tBoolean),
    secure: tOptional(tBoolean),
    sameSite: tOptional(tEnum(['Strict', 'Lax', 'None'])),
  });
  scheme.NetworkCookie = tObject({
    name: tString,
    value: tString,
    domain: tString,
    path: tString,
    expires: tNumber,
    httpOnly: tBoolean,
    secure: tBoolean,
    sameSite: tEnum(['Strict', 'Lax', 'None']),
  });
  scheme.NameValue = tObject({
    name: tString,
    value: tString,
  });
  scheme.OriginStorage = tObject({
    origin: tString,
    localStorage: tArray(tType('NameValue')),
  });
  scheme.SerializedError = tObject({
    error: tOptional(tObject({
      message: tString,
      name: tString,
      stack: tOptional(tString),
    })),
    value: tOptional(tType('SerializedValue')),
  });
  scheme.FormField = tObject({
    name: tString,
    value: tOptional(tString),
    file: tOptional(tObject({
      name: tString,
      mimeType: tOptional(tString),
      buffer: tBinary,
    })),
  });
  scheme.APIRequestContextFetchParams = tObject({
    url: tString,
    params: tOptional(tArray(tType('NameValue'))),
    method: tOptional(tString),
    headers: tOptional(tArray(tType('NameValue'))),
    postData: tOptional(tBinary),
    jsonData: tOptional(tAny),
    formData: tOptional(tArray(tType('NameValue'))),
    multipartData: tOptional(tArray(tType('FormField'))),
    timeout: tOptional(tNumber),
    failOnStatusCode: tOptional(tBoolean),
    ignoreHTTPSErrors: tOptional(tBoolean),
  });
  scheme.APIRequestContextFetchResponseBodyParams = tObject({
    fetchUid: tString,
  });
  scheme.APIRequestContextFetchLogParams = tObject({
    fetchUid: tString,
  });
  scheme.APIRequestContextStorageStateParams = tOptional(tObject({}));
  scheme.APIRequestContextDisposeAPIResponseParams = tObject({
    fetchUid: tString,
  });
  scheme.APIRequestContextDisposeParams = tOptional(tObject({}));
  scheme.APIResponse = tObject({
    fetchUid: tString,
    url: tString,
    status: tNumber,
    statusText: tString,
    headers: tArray(tType('NameValue')),
  });
  scheme.LifecycleEvent = tEnum(['load', 'domcontentloaded', 'networkidle', 'commit']);
  scheme.LocalUtilsZipParams = tObject({
    zipFile: tString,
    entries: tArray(tType('NameValue')),
  });
  scheme.RootInitializeParams = tObject({
    sdkLanguage: tString,
  });
  scheme.PlaywrightNewRequestParams = tObject({
    baseURL: tOptional(tString),
    userAgent: tOptional(tString),
    ignoreHTTPSErrors: tOptional(tBoolean),
    extraHTTPHeaders: tOptional(tArray(tType('NameValue'))),
    httpCredentials: tOptional(tObject({
      username: tString,
      password: tString,
    })),
    proxy: tOptional(tObject({
      server: tString,
      bypass: tOptional(tString),
      username: tOptional(tString),
      password: tOptional(tString),
    })),
    timeout: tOptional(tNumber),
    storageState: tOptional(tObject({
      cookies: tArray(tType('NetworkCookie')),
      origins: tArray(tType('OriginStorage')),
    })),
    tracesDir: tOptional(tString),
  });
  scheme.PlaywrightHideHighlightParams = tOptional(tObject({}));
  scheme.SocksSupportSocksConnectedParams = tObject({
    uid: tString,
    host: tString,
    port: tNumber,
  });
  scheme.SocksSupportSocksFailedParams = tObject({
    uid: tString,
    errorCode: tString,
  });
  scheme.SocksSupportSocksDataParams = tObject({
    uid: tString,
    data: tBinary,
  });
  scheme.SocksSupportSocksErrorParams = tObject({
    uid: tString,
    error: tString,
  });
  scheme.SocksSupportSocksEndParams = tObject({
    uid: tString,
  });
  scheme.SelectorsRegisterParams = tObject({
    name: tString,
    source: tString,
    contentScript: tOptional(tBoolean),
  });
  scheme.BrowserTypeConnectParams = tObject({
    wsEndpoint: tString,
    headers: tOptional(tAny),
    slowMo: tOptional(tNumber),
    timeout: tOptional(tNumber),
    socksProxyRedirectPortForTest: tOptional(tNumber),
  });
  scheme.BrowserTypeLaunchParams = tObject({
    channel: tOptional(tString),
    executablePath: tOptional(tString),
    args: tOptional(tArray(tString)),
    ignoreAllDefaultArgs: tOptional(tBoolean),
    ignoreDefaultArgs: tOptional(tArray(tString)),
    handleSIGINT: tOptional(tBoolean),
    handleSIGTERM: tOptional(tBoolean),
    handleSIGHUP: tOptional(tBoolean),
    timeout: tOptional(tNumber),
    env: tOptional(tArray(tType('NameValue'))),
    headless: tOptional(tBoolean),
    devtools: tOptional(tBoolean),
    proxy: tOptional(tObject({
      server: tString,
      bypass: tOptional(tString),
      username: tOptional(tString),
      password: tOptional(tString),
    })),
    downloadsPath: tOptional(tString),
    tracesDir: tOptional(tString),
    chromiumSandbox: tOptional(tBoolean),
    firefoxUserPrefs: tOptional(tAny),
    slowMo: tOptional(tNumber),
  });
  scheme.BrowserTypeLaunchPersistentContextParams = tObject({
    channel: tOptional(tString),
    executablePath: tOptional(tString),
    args: tOptional(tArray(tString)),
    ignoreAllDefaultArgs: tOptional(tBoolean),
    ignoreDefaultArgs: tOptional(tArray(tString)),
    handleSIGINT: tOptional(tBoolean),
    handleSIGTERM: tOptional(tBoolean),
    handleSIGHUP: tOptional(tBoolean),
    timeout: tOptional(tNumber),
    env: tOptional(tArray(tType('NameValue'))),
    headless: tOptional(tBoolean),
    devtools: tOptional(tBoolean),
    proxy: tOptional(tObject({
      server: tString,
      bypass: tOptional(tString),
      username: tOptional(tString),
      password: tOptional(tString),
    })),
    downloadsPath: tOptional(tString),
    tracesDir: tOptional(tString),
    chromiumSandbox: tOptional(tBoolean),
    noDefaultViewport: tOptional(tBoolean),
    viewport: tOptional(tObject({
      width: tNumber,
      height: tNumber,
    })),
    screen: tOptional(tObject({
      width: tNumber,
      height: tNumber,
    })),
    ignoreHTTPSErrors: tOptional(tBoolean),
    javaScriptEnabled: tOptional(tBoolean),
    bypassCSP: tOptional(tBoolean),
    userAgent: tOptional(tString),
    locale: tOptional(tString),
    timezoneId: tOptional(tString),
    geolocation: tOptional(tObject({
      longitude: tNumber,
      latitude: tNumber,
      accuracy: tOptional(tNumber),
    })),
    permissions: tOptional(tArray(tString)),
    extraHTTPHeaders: tOptional(tArray(tType('NameValue'))),
    offline: tOptional(tBoolean),
    httpCredentials: tOptional(tObject({
      username: tString,
      password: tString,
    })),
    deviceScaleFactor: tOptional(tNumber),
    isMobile: tOptional(tBoolean),
    hasTouch: tOptional(tBoolean),
    colorScheme: tOptional(tEnum(['dark', 'light', 'no-preference'])),
    reducedMotion: tOptional(tEnum(['reduce', 'no-preference'])),
    forcedColors: tOptional(tEnum(['active', 'none'])),
    acceptDownloads: tOptional(tBoolean),
    baseURL: tOptional(tString),
    recordVideo: tOptional(tObject({
      dir: tString,
      size: tOptional(tObject({
        width: tNumber,
        height: tNumber,
      })),
    })),
    recordHar: tOptional(tObject({
      omitContent: tOptional(tBoolean),
      path: tString,
    })),
    strictSelectors: tOptional(tBoolean),
    userDataDir: tString,
    slowMo: tOptional(tNumber),
  });
  scheme.BrowserTypeConnectOverCDPParams = tObject({
    endpointURL: tString,
    headers: tOptional(tArray(tType('NameValue'))),
    slowMo: tOptional(tNumber),
    timeout: tOptional(tNumber),
  });
  scheme.BrowserCloseParams = tOptional(tObject({}));
  scheme.BrowserKillForTestsParams = tOptional(tObject({}));
  scheme.BrowserNewContextParams = tObject({
    noDefaultViewport: tOptional(tBoolean),
    viewport: tOptional(tObject({
      width: tNumber,
      height: tNumber,
    })),
    screen: tOptional(tObject({
      width: tNumber,
      height: tNumber,
    })),
    ignoreHTTPSErrors: tOptional(tBoolean),
    javaScriptEnabled: tOptional(tBoolean),
    bypassCSP: tOptional(tBoolean),
    userAgent: tOptional(tString),
    locale: tOptional(tString),
    timezoneId: tOptional(tString),
    geolocation: tOptional(tObject({
      longitude: tNumber,
      latitude: tNumber,
      accuracy: tOptional(tNumber),
    })),
    permissions: tOptional(tArray(tString)),
    extraHTTPHeaders: tOptional(tArray(tType('NameValue'))),
    offline: tOptional(tBoolean),
    httpCredentials: tOptional(tObject({
      username: tString,
      password: tString,
    })),
    deviceScaleFactor: tOptional(tNumber),
    isMobile: tOptional(tBoolean),
    hasTouch: tOptional(tBoolean),
    colorScheme: tOptional(tEnum(['dark', 'light', 'no-preference'])),
    reducedMotion: tOptional(tEnum(['reduce', 'no-preference'])),
    forcedColors: tOptional(tEnum(['active', 'none'])),
    acceptDownloads: tOptional(tBoolean),
    baseURL: tOptional(tString),
    recordVideo: tOptional(tObject({
      dir: tString,
      size: tOptional(tObject({
        width: tNumber,
        height: tNumber,
      })),
    })),
    recordHar: tOptional(tObject({
      omitContent: tOptional(tBoolean),
      path: tString,
    })),
    strictSelectors: tOptional(tBoolean),
    proxy: tOptional(tObject({
      server: tString,
      bypass: tOptional(tString),
      username: tOptional(tString),
      password: tOptional(tString),
    })),
    storageState: tOptional(tObject({
      cookies: tOptional(tArray(tType('SetNetworkCookie'))),
      origins: tOptional(tArray(tType('OriginStorage'))),
    })),
  });
  scheme.BrowserNewBrowserCDPSessionParams = tOptional(tObject({}));
  scheme.BrowserStartTracingParams = tObject({
    page: tOptional(tChannel('Page')),
    path: tOptional(tString),
    screenshots: tOptional(tBoolean),
    categories: tOptional(tArray(tString)),
  });
  scheme.BrowserStopTracingParams = tOptional(tObject({}));
  scheme.EventTargetWaitForEventInfoParams = tObject({
    info: tObject({
      waitId: tString,
      phase: tEnum(['before', 'after', 'log']),
      event: tOptional(tString),
      message: tOptional(tString),
      error: tOptional(tString),
    }),
  });
  scheme.BrowserContextWaitForEventInfoParams = tType('EventTargetWaitForEventInfoParams');
  scheme.PageWaitForEventInfoParams = tType('EventTargetWaitForEventInfoParams');
  scheme.WebSocketWaitForEventInfoParams = tType('EventTargetWaitForEventInfoParams');
  scheme.ElectronApplicationWaitForEventInfoParams = tType('EventTargetWaitForEventInfoParams');
  scheme.AndroidDeviceWaitForEventInfoParams = tType('EventTargetWaitForEventInfoParams');
  scheme.BrowserContextAddCookiesParams = tObject({
    cookies: tArray(tType('SetNetworkCookie')),
  });
  scheme.BrowserContextAddInitScriptParams = tObject({
    source: tString,
  });
  scheme.BrowserContextRemoveInitScriptsParams = tOptional(tObject({}));
  scheme.BrowserContextClearCookiesParams = tOptional(tObject({}));
  scheme.BrowserContextClearPermissionsParams = tOptional(tObject({}));
  scheme.BrowserContextCloseParams = tOptional(tObject({}));
  scheme.BrowserContextCookiesParams = tObject({
    urls: tArray(tString),
  });
  scheme.BrowserContextExposeBindingParams = tObject({
    name: tString,
    needsHandle: tOptional(tBoolean),
  });
  scheme.BrowserContextRemoveExposedBindingsParams = tOptional(tObject({}));
  scheme.BrowserContextGrantPermissionsParams = tObject({
    permissions: tArray(tString),
    origin: tOptional(tString),
  });
  scheme.BrowserContextNewPageParams = tOptional(tObject({}));
  scheme.BrowserContextSetDefaultNavigationTimeoutNoReplyParams = tObject({
    timeout: tOptional(tNumber),
  });
  scheme.BrowserContextSetDefaultTimeoutNoReplyParams = tObject({
    timeout: tOptional(tNumber),
  });
  scheme.BrowserContextSetExtraHTTPHeadersParams = tObject({
    headers: tArray(tType('NameValue')),
  });
  scheme.BrowserContextSetGeolocationParams = tObject({
    geolocation: tOptional(tObject({
      longitude: tNumber,
      latitude: tNumber,
      accuracy: tOptional(tNumber),
    })),
  });
  scheme.BrowserContextSetHTTPCredentialsParams = tObject({
    httpCredentials: tOptional(tObject({
      username: tString,
      password: tString,
    })),
  });
  scheme.BrowserContextSetNetworkInterceptionEnabledParams = tObject({
    enabled: tBoolean,
  });
  scheme.BrowserContextSetOfflineParams = tObject({
    offline: tBoolean,
  });
  scheme.BrowserContextStorageStateParams = tOptional(tObject({}));
  scheme.BrowserContextPauseParams = tOptional(tObject({}));
  scheme.BrowserContextRecorderSupplementEnableParams = tObject({
    language: tOptional(tString),
    startRecording: tOptional(tBoolean),
    pauseOnNextStatement: tOptional(tBoolean),
    launchOptions: tOptional(tAny),
    contextOptions: tOptional(tAny),
    device: tOptional(tString),
    saveStorage: tOptional(tString),
    outputFile: tOptional(tString),
  });
  scheme.BrowserContextNewCDPSessionParams = tObject({
    page: tOptional(tChannel('Page')),
    frame: tOptional(tChannel('Frame')),
  });
  scheme.BrowserContextHarExportParams = tOptional(tObject({}));
  scheme.BrowserContextCreateTempFileParams = tObject({
    name: tString,
  });
  scheme.PageSetDefaultNavigationTimeoutNoReplyParams = tObject({
    timeout: tOptional(tNumber),
  });
  scheme.PageSetDefaultTimeoutNoReplyParams = tObject({
    timeout: tOptional(tNumber),
  });
  scheme.PageSetFileChooserInterceptedNoReplyParams = tObject({
    intercepted: tBoolean,
  });
  scheme.PageAddInitScriptParams = tObject({
    source: tString,
  });
  scheme.PageRemoveInitScriptsParams = tOptional(tObject({}));
  scheme.PageCloseParams = tObject({
    runBeforeUnload: tOptional(tBoolean),
  });
  scheme.PageEmulateMediaParams = tObject({
    media: tOptional(tEnum(['screen', 'print', 'null'])),
    colorScheme: tOptional(tEnum(['dark', 'light', 'no-preference', 'null'])),
    reducedMotion: tOptional(tEnum(['reduce', 'no-preference', 'null'])),
    forcedColors: tOptional(tEnum(['active', 'none', 'null'])),
  });
  scheme.PageExposeBindingParams = tObject({
    name: tString,
    needsHandle: tOptional(tBoolean),
  });
  scheme.PageRemoveExposedBindingsParams = tOptional(tObject({}));
  scheme.PageGoBackParams = tObject({
    timeout: tOptional(tNumber),
    waitUntil: tOptional(tType('LifecycleEvent')),
  });
  scheme.PageGoForwardParams = tObject({
    timeout: tOptional(tNumber),
    waitUntil: tOptional(tType('LifecycleEvent')),
  });
  scheme.PageReloadParams = tObject({
    timeout: tOptional(tNumber),
    waitUntil: tOptional(tType('LifecycleEvent')),
  });
  scheme.PageExpectScreenshotParams = tObject({
    expected: tOptional(tBinary),
    timeout: tOptional(tNumber),
    isNot: tBoolean,
    locator: tOptional(tObject({
      frame: tChannel('Frame'),
      selector: tString,
    })),
    comparatorOptions: tOptional(tObject({
      maxDiffPixels: tOptional(tNumber),
      maxDiffPixelRatio: tOptional(tNumber),
      threshold: tOptional(tNumber),
    })),
    screenshotOptions: tOptional(tObject({
      fullPage: tOptional(tBoolean),
      clip: tOptional(tType('Rect')),
      omitBackground: tOptional(tBoolean),
      caret: tOptional(tEnum(['hide', 'initial'])),
      animations: tOptional(tEnum(['disabled', 'allow'])),
      scale: tOptional(tEnum(['css', 'device'])),
      mask: tOptional(tArray(tObject({
        frame: tChannel('Frame'),
        selector: tString,
      }))),
    })),
  });
  scheme.PageScreenshotParams = tObject({
    timeout: tOptional(tNumber),
    type: tOptional(tEnum(['png', 'jpeg'])),
    quality: tOptional(tNumber),
    fullPage: tOptional(tBoolean),
    clip: tOptional(tType('Rect')),
    omitBackground: tOptional(tBoolean),
    caret: tOptional(tEnum(['hide', 'initial'])),
    animations: tOptional(tEnum(['disabled', 'allow'])),
    scale: tOptional(tEnum(['css', 'device'])),
    mask: tOptional(tArray(tObject({
      frame: tChannel('Frame'),
      selector: tString,
    }))),
  });
  scheme.PageSetExtraHTTPHeadersParams = tObject({
    headers: tArray(tType('NameValue')),
  });
  scheme.PageSetNetworkInterceptionEnabledParams = tObject({
    enabled: tBoolean,
  });
  scheme.PageSetViewportSizeParams = tObject({
    viewportSize: tObject({
      width: tNumber,
      height: tNumber,
    }),
  });
  scheme.PageKeyboardDownParams = tObject({
    key: tString,
  });
  scheme.PageKeyboardUpParams = tObject({
    key: tString,
  });
  scheme.PageKeyboardInsertTextParams = tObject({
    text: tString,
  });
  scheme.PageKeyboardTypeParams = tObject({
    text: tString,
    delay: tOptional(tNumber),
  });
  scheme.PageKeyboardImeSetCompositionParams = tObject({
    text: tString,
    selectionStart: tNumber,
    selectionEnd: tNumber,
    replacementStart: tOptional(tNumber),
    replacementEnd: tOptional(tNumber),
  });
  scheme.PageKeyboardPressParams = tObject({
    key: tString,
    delay: tOptional(tNumber),
  });
  scheme.PageMouseMoveParams = tObject({
    x: tNumber,
    y: tNumber,
    steps: tOptional(tNumber),
  });
  scheme.PageMouseDownParams = tObject({
    button: tOptional(tEnum(['left', 'right', 'middle'])),
    clickCount: tOptional(tNumber),
  });
  scheme.PageMouseUpParams = tObject({
    button: tOptional(tEnum(['left', 'right', 'middle'])),
    clickCount: tOptional(tNumber),
  });
  scheme.PageMouseClickParams = tObject({
    x: tNumber,
    y: tNumber,
    delay: tOptional(tNumber),
    button: tOptional(tEnum(['left', 'right', 'middle'])),
    clickCount: tOptional(tNumber),
  });
  scheme.PageMouseWheelParams = tObject({
    deltaX: tNumber,
    deltaY: tNumber,
  });
  scheme.PageTouchscreenTapParams = tObject({
    x: tNumber,
    y: tNumber,
  });
  scheme.PageAccessibilitySnapshotParams = tObject({
    interestingOnly: tOptional(tBoolean),
    root: tOptional(tChannel('ElementHandle')),
  });
  scheme.PagePdfParams = tObject({
    scale: tOptional(tNumber),
    displayHeaderFooter: tOptional(tBoolean),
    headerTemplate: tOptional(tString),
    footerTemplate: tOptional(tString),
    printBackground: tOptional(tBoolean),
    landscape: tOptional(tBoolean),
    pageRanges: tOptional(tString),
    format: tOptional(tString),
    width: tOptional(tString),
    height: tOptional(tString),
    preferCSSPageSize: tOptional(tBoolean),
    margin: tOptional(tObject({
      top: tOptional(tString),
      bottom: tOptional(tString),
      left: tOptional(tString),
      right: tOptional(tString),
    })),
  });
  scheme.PageStartJSCoverageParams = tObject({
    resetOnNavigation: tOptional(tBoolean),
    reportAnonymousScripts: tOptional(tBoolean),
  });
  scheme.PageStopJSCoverageParams = tOptional(tObject({}));
  scheme.PageStartCSSCoverageParams = tObject({
    resetOnNavigation: tOptional(tBoolean),
  });
  scheme.PageStopCSSCoverageParams = tOptional(tObject({}));
  scheme.PageBringToFrontParams = tOptional(tObject({}));
  scheme.FrameEvalOnSelectorParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    expression: tString,
    isFunction: tOptional(tBoolean),
    arg: tType('SerializedArgument'),
  });
  scheme.FrameEvalOnSelectorAllParams = tObject({
    selector: tString,
    expression: tString,
    isFunction: tOptional(tBoolean),
    arg: tType('SerializedArgument'),
  });
  scheme.FrameAddScriptTagParams = tObject({
    url: tOptional(tString),
    content: tOptional(tString),
    type: tOptional(tString),
  });
  scheme.FrameAddStyleTagParams = tObject({
    url: tOptional(tString),
    content: tOptional(tString),
  });
  scheme.FrameCheckParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    force: tOptional(tBoolean),
    noWaitAfter: tOptional(tBoolean),
    position: tOptional(tType('Point')),
    timeout: tOptional(tNumber),
    trial: tOptional(tBoolean),
  });
  scheme.FrameClickParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    force: tOptional(tBoolean),
    noWaitAfter: tOptional(tBoolean),
    modifiers: tOptional(tArray(tEnum(['Alt', 'Control', 'Meta', 'Shift']))),
    position: tOptional(tType('Point')),
    delay: tOptional(tNumber),
    button: tOptional(tEnum(['left', 'right', 'middle'])),
    clickCount: tOptional(tNumber),
    timeout: tOptional(tNumber),
    trial: tOptional(tBoolean),
  });
  scheme.FrameContentParams = tOptional(tObject({}));
  scheme.FrameDragAndDropParams = tObject({
    source: tString,
    target: tString,
    force: tOptional(tBoolean),
    noWaitAfter: tOptional(tBoolean),
    timeout: tOptional(tNumber),
    trial: tOptional(tBoolean),
    sourcePosition: tOptional(tType('Point')),
    targetPosition: tOptional(tType('Point')),
    strict: tOptional(tBoolean),
  });
  scheme.FrameDblclickParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    force: tOptional(tBoolean),
    noWaitAfter: tOptional(tBoolean),
    modifiers: tOptional(tArray(tEnum(['Alt', 'Control', 'Meta', 'Shift']))),
    position: tOptional(tType('Point')),
    delay: tOptional(tNumber),
    button: tOptional(tEnum(['left', 'right', 'middle'])),
    timeout: tOptional(tNumber),
    trial: tOptional(tBoolean),
  });
  scheme.FrameDispatchEventParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    type: tString,
    eventInit: tType('SerializedArgument'),
    timeout: tOptional(tNumber),
  });
  scheme.FrameEvaluateExpressionParams = tObject({
    expression: tString,
    isFunction: tOptional(tBoolean),
    arg: tType('SerializedArgument'),
  });
  scheme.FrameEvaluateExpressionHandleParams = tObject({
    expression: tString,
    isFunction: tOptional(tBoolean),
    arg: tType('SerializedArgument'),
  });
  scheme.FrameFillParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    value: tString,
    force: tOptional(tBoolean),
    timeout: tOptional(tNumber),
    noWaitAfter: tOptional(tBoolean),
  });
  scheme.FrameFocusParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    timeout: tOptional(tNumber),
  });
  scheme.FrameFrameElementParams = tOptional(tObject({}));
  scheme.FrameHighlightParams = tObject({
    selector: tString,
  });
  scheme.FrameGetAttributeParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    name: tString,
    timeout: tOptional(tNumber),
  });
  scheme.FrameGotoParams = tObject({
    url: tString,
    timeout: tOptional(tNumber),
    waitUntil: tOptional(tType('LifecycleEvent')),
    referer: tOptional(tString),
  });
  scheme.FrameHoverParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    force: tOptional(tBoolean),
    modifiers: tOptional(tArray(tEnum(['Alt', 'Control', 'Meta', 'Shift']))),
    position: tOptional(tType('Point')),
    timeout: tOptional(tNumber),
    trial: tOptional(tBoolean),
  });
  scheme.FrameInnerHTMLParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    timeout: tOptional(tNumber),
  });
  scheme.FrameInnerTextParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    timeout: tOptional(tNumber),
  });
  scheme.FrameInputValueParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    timeout: tOptional(tNumber),
  });
  scheme.FrameIsCheckedParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    timeout: tOptional(tNumber),
  });
  scheme.FrameIsDisabledParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    timeout: tOptional(tNumber),
  });
  scheme.FrameIsEnabledParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    timeout: tOptional(tNumber),
  });
  scheme.FrameIsHiddenParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
  });
  scheme.FrameIsVisibleParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
  });
  scheme.FrameIsEditableParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    timeout: tOptional(tNumber),
  });
  scheme.FramePressParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    key: tString,
    delay: tOptional(tNumber),
    noWaitAfter: tOptional(tBoolean),
    timeout: tOptional(tNumber),
  });
  scheme.FrameQuerySelectorParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
  });
  scheme.FrameQuerySelectorAllParams = tObject({
    selector: tString,
  });
  scheme.FrameQueryCountParams = tObject({
    selector: tString,
  });
  scheme.FrameSelectOptionParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    elements: tOptional(tArray(tChannel('ElementHandle'))),
    options: tOptional(tArray(tObject({
      value: tOptional(tString),
      label: tOptional(tString),
      index: tOptional(tNumber),
    }))),
    force: tOptional(tBoolean),
    timeout: tOptional(tNumber),
    noWaitAfter: tOptional(tBoolean),
  });
  scheme.FrameSetContentParams = tObject({
    html: tString,
    timeout: tOptional(tNumber),
    waitUntil: tOptional(tType('LifecycleEvent')),
  });
  scheme.FrameSetInputFilesParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    files: tArray(tObject({
      name: tString,
      mimeType: tOptional(tString),
      buffer: tBinary,
    })),
    timeout: tOptional(tNumber),
    noWaitAfter: tOptional(tBoolean),
  });
  scheme.FrameSetInputFilePathsParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    localPaths: tOptional(tArray(tString)),
    streams: tOptional(tArray(tChannel('WritableStream'))),
    timeout: tOptional(tNumber),
    noWaitAfter: tOptional(tBoolean),
  });
  scheme.FrameTapParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    force: tOptional(tBoolean),
    noWaitAfter: tOptional(tBoolean),
    modifiers: tOptional(tArray(tEnum(['Alt', 'Control', 'Meta', 'Shift']))),
    position: tOptional(tType('Point')),
    timeout: tOptional(tNumber),
    trial: tOptional(tBoolean),
  });
  scheme.FrameTextContentParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    timeout: tOptional(tNumber),
  });
  scheme.FrameTitleParams = tOptional(tObject({}));
  scheme.FrameTypeParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    text: tString,
    delay: tOptional(tNumber),
    noWaitAfter: tOptional(tBoolean),
    timeout: tOptional(tNumber),
  });
  scheme.FrameUncheckParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    force: tOptional(tBoolean),
    noWaitAfter: tOptional(tBoolean),
    position: tOptional(tType('Point')),
    timeout: tOptional(tNumber),
    trial: tOptional(tBoolean),
  });
  scheme.FrameWaitForTimeoutParams = tObject({
    timeout: tNumber,
  });
  scheme.FrameWaitForFunctionParams = tObject({
    expression: tString,
    isFunction: tOptional(tBoolean),
    arg: tType('SerializedArgument'),
    timeout: tOptional(tNumber),
    pollingInterval: tOptional(tNumber),
  });
  scheme.FrameWaitForSelectorParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    timeout: tOptional(tNumber),
    state: tOptional(tEnum(['attached', 'detached', 'visible', 'hidden'])),
    omitReturnValue: tOptional(tBoolean),
  });
  scheme.FrameExpectParams = tObject({
    selector: tString,
    expression: tString,
    expressionArg: tOptional(tAny),
    expectedText: tOptional(tArray(tType('ExpectedTextValue'))),
    expectedNumber: tOptional(tNumber),
    expectedValue: tOptional(tType('SerializedArgument')),
    useInnerText: tOptional(tBoolean),
    isNot: tBoolean,
    timeout: tOptional(tNumber),
  });
  scheme.WorkerEvaluateExpressionParams = tObject({
    expression: tString,
    isFunction: tOptional(tBoolean),
    arg: tType('SerializedArgument'),
  });
  scheme.WorkerEvaluateExpressionHandleParams = tObject({
    expression: tString,
    isFunction: tOptional(tBoolean),
    arg: tType('SerializedArgument'),
  });
  scheme.JSHandleDisposeParams = tOptional(tObject({}));
  scheme.ElementHandleDisposeParams = tType('JSHandleDisposeParams');
  scheme.JSHandleEvaluateExpressionParams = tObject({
    expression: tString,
    isFunction: tOptional(tBoolean),
    arg: tType('SerializedArgument'),
  });
  scheme.ElementHandleEvaluateExpressionParams = tType('JSHandleEvaluateExpressionParams');
  scheme.JSHandleEvaluateExpressionHandleParams = tObject({
    expression: tString,
    isFunction: tOptional(tBoolean),
    arg: tType('SerializedArgument'),
  });
  scheme.ElementHandleEvaluateExpressionHandleParams = tType('JSHandleEvaluateExpressionHandleParams');
  scheme.JSHandleGetPropertyListParams = tOptional(tObject({}));
  scheme.ElementHandleGetPropertyListParams = tType('JSHandleGetPropertyListParams');
  scheme.JSHandleGetPropertyParams = tObject({
    name: tString,
  });
  scheme.ElementHandleGetPropertyParams = tType('JSHandleGetPropertyParams');
  scheme.JSHandleJsonValueParams = tOptional(tObject({}));
  scheme.ElementHandleJsonValueParams = tType('JSHandleJsonValueParams');
  scheme.ElementHandleEvalOnSelectorParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    expression: tString,
    isFunction: tOptional(tBoolean),
    arg: tType('SerializedArgument'),
  });
  scheme.ElementHandleEvalOnSelectorAllParams = tObject({
    selector: tString,
    expression: tString,
    isFunction: tOptional(tBoolean),
    arg: tType('SerializedArgument'),
  });
  scheme.ElementHandleBoundingBoxParams = tOptional(tObject({}));
  scheme.ElementHandleCheckParams = tObject({
    force: tOptional(tBoolean),
    noWaitAfter: tOptional(tBoolean),
    position: tOptional(tType('Point')),
    timeout: tOptional(tNumber),
    trial: tOptional(tBoolean),
  });
  scheme.ElementHandleClickParams = tObject({
    force: tOptional(tBoolean),
    noWaitAfter: tOptional(tBoolean),
    modifiers: tOptional(tArray(tEnum(['Alt', 'Control', 'Meta', 'Shift']))),
    position: tOptional(tType('Point')),
    delay: tOptional(tNumber),
    button: tOptional(tEnum(['left', 'right', 'middle'])),
    clickCount: tOptional(tNumber),
    timeout: tOptional(tNumber),
    trial: tOptional(tBoolean),
  });
  scheme.ElementHandleContentFrameParams = tOptional(tObject({}));
  scheme.ElementHandleDblclickParams = tObject({
    force: tOptional(tBoolean),
    noWaitAfter: tOptional(tBoolean),
    modifiers: tOptional(tArray(tEnum(['Alt', 'Control', 'Meta', 'Shift']))),
    position: tOptional(tType('Point')),
    delay: tOptional(tNumber),
    button: tOptional(tEnum(['left', 'right', 'middle'])),
    timeout: tOptional(tNumber),
    trial: tOptional(tBoolean),
  });
  scheme.ElementHandleDispatchEventParams = tObject({
    type: tString,
    eventInit: tType('SerializedArgument'),
  });
  scheme.ElementHandleFillParams = tObject({
    value: tString,
    force: tOptional(tBoolean),
    timeout: tOptional(tNumber),
    noWaitAfter: tOptional(tBoolean),
  });
  scheme.ElementHandleFocusParams = tOptional(tObject({}));
  scheme.ElementHandleGetAttributeParams = tObject({
    name: tString,
  });
  scheme.ElementHandleHoverParams = tObject({
    force: tOptional(tBoolean),
    modifiers: tOptional(tArray(tEnum(['Alt', 'Control', 'Meta', 'Shift']))),
    position: tOptional(tType('Point')),
    timeout: tOptional(tNumber),
    trial: tOptional(tBoolean),
  });
  scheme.ElementHandleInnerHTMLParams = tOptional(tObject({}));
  scheme.ElementHandleInnerTextParams = tOptional(tObject({}));
  scheme.ElementHandleInputValueParams = tOptional(tObject({}));
  scheme.ElementHandleIsCheckedParams = tOptional(tObject({}));
  scheme.ElementHandleIsDisabledParams = tOptional(tObject({}));
  scheme.ElementHandleIsEditableParams = tOptional(tObject({}));
  scheme.ElementHandleIsEnabledParams = tOptional(tObject({}));
  scheme.ElementHandleIsHiddenParams = tOptional(tObject({}));
  scheme.ElementHandleIsVisibleParams = tOptional(tObject({}));
  scheme.ElementHandleOwnerFrameParams = tOptional(tObject({}));
  scheme.ElementHandlePressParams = tObject({
    key: tString,
    delay: tOptional(tNumber),
    timeout: tOptional(tNumber),
    noWaitAfter: tOptional(tBoolean),
  });
  scheme.ElementHandleQuerySelectorParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
  });
  scheme.ElementHandleQuerySelectorAllParams = tObject({
    selector: tString,
  });
  scheme.ElementHandleScreenshotParams = tObject({
    timeout: tOptional(tNumber),
    type: tOptional(tEnum(['png', 'jpeg'])),
    quality: tOptional(tNumber),
    omitBackground: tOptional(tBoolean),
    caret: tOptional(tEnum(['hide', 'initial'])),
    animations: tOptional(tEnum(['disabled', 'allow'])),
    scale: tOptional(tEnum(['css', 'device'])),
    mask: tOptional(tArray(tObject({
      frame: tChannel('Frame'),
      selector: tString,
    }))),
  });
  scheme.ElementHandleScrollIntoViewIfNeededParams = tObject({
    timeout: tOptional(tNumber),
  });
  scheme.ElementHandleSelectOptionParams = tObject({
    elements: tOptional(tArray(tChannel('ElementHandle'))),
    options: tOptional(tArray(tObject({
      value: tOptional(tString),
      label: tOptional(tString),
      index: tOptional(tNumber),
    }))),
    force: tOptional(tBoolean),
    timeout: tOptional(tNumber),
    noWaitAfter: tOptional(tBoolean),
  });
  scheme.ElementHandleSelectTextParams = tObject({
    force: tOptional(tBoolean),
    timeout: tOptional(tNumber),
  });
  scheme.ElementHandleSetInputFilesParams = tObject({
    files: tArray(tObject({
      name: tString,
      mimeType: tOptional(tString),
      buffer: tBinary,
    })),
    timeout: tOptional(tNumber),
    noWaitAfter: tOptional(tBoolean),
  });
  scheme.ElementHandleSetInputFilePathsParams = tObject({
    localPaths: tOptional(tArray(tString)),
    streams: tOptional(tArray(tChannel('WritableStream'))),
    timeout: tOptional(tNumber),
    noWaitAfter: tOptional(tBoolean),
  });
  scheme.ElementHandleTapParams = tObject({
    force: tOptional(tBoolean),
    noWaitAfter: tOptional(tBoolean),
    modifiers: tOptional(tArray(tEnum(['Alt', 'Control', 'Meta', 'Shift']))),
    position: tOptional(tType('Point')),
    timeout: tOptional(tNumber),
    trial: tOptional(tBoolean),
  });
  scheme.ElementHandleTextContentParams = tOptional(tObject({}));
  scheme.ElementHandleTypeParams = tObject({
    text: tString,
    delay: tOptional(tNumber),
    noWaitAfter: tOptional(tBoolean),
    timeout: tOptional(tNumber),
  });
  scheme.ElementHandleUncheckParams = tObject({
    force: tOptional(tBoolean),
    noWaitAfter: tOptional(tBoolean),
    position: tOptional(tType('Point')),
    timeout: tOptional(tNumber),
    trial: tOptional(tBoolean),
  });
  scheme.ElementHandleWaitForElementStateParams = tObject({
    state: tEnum(['visible', 'hidden', 'stable', 'enabled', 'disabled', 'editable']),
    timeout: tOptional(tNumber),
  });
  scheme.ElementHandleWaitForSelectorParams = tObject({
    selector: tString,
    strict: tOptional(tBoolean),
    timeout: tOptional(tNumber),
    state: tOptional(tEnum(['attached', 'detached', 'visible', 'hidden'])),
  });
  scheme.RequestResponseParams = tOptional(tObject({}));
  scheme.RequestRawRequestHeadersParams = tOptional(tObject({}));
  scheme.RouteAbortParams = tObject({
    errorCode: tOptional(tString),
  });
  scheme.RouteContinueParams = tObject({
    url: tOptional(tString),
    method: tOptional(tString),
    headers: tOptional(tArray(tType('NameValue'))),
    postData: tOptional(tBinary),
  });
  scheme.RouteFulfillParams = tObject({
    status: tOptional(tNumber),
    headers: tOptional(tArray(tType('NameValue'))),
    body: tOptional(tString),
    isBase64: tOptional(tBoolean),
    fetchResponseUid: tOptional(tString),
  });
  scheme.ResourceTiming = tObject({
    startTime: tNumber,
    domainLookupStart: tNumber,
    domainLookupEnd: tNumber,
    connectStart: tNumber,
    secureConnectionStart: tNumber,
    connectEnd: tNumber,
    requestStart: tNumber,
    responseStart: tNumber,
  });
  scheme.ResponseBodyParams = tOptional(tObject({}));
  scheme.ResponseSecurityDetailsParams = tOptional(tObject({}));
  scheme.ResponseServerAddrParams = tOptional(tObject({}));
  scheme.ResponseRawResponseHeadersParams = tOptional(tObject({}));
  scheme.ResponseSizesParams = tOptional(tObject({}));
  scheme.SecurityDetails = tObject({
    issuer: tOptional(tString),
    protocol: tOptional(tString),
    subjectName: tOptional(tString),
    validFrom: tOptional(tNumber),
    validTo: tOptional(tNumber),
  });
  scheme.RequestSizes = tObject({
    requestBodySize: tNumber,
    requestHeadersSize: tNumber,
    responseBodySize: tNumber,
    responseHeadersSize: tNumber,
  });
  scheme.RemoteAddr = tObject({
    ipAddress: tString,
    port: tNumber,
  });
  scheme.BindingCallRejectParams = tObject({
    error: tType('SerializedError'),
  });
  scheme.BindingCallResolveParams = tObject({
    result: tType('SerializedArgument'),
  });
  scheme.DialogAcceptParams = tObject({
    promptText: tOptional(tString),
  });
  scheme.DialogDismissParams = tOptional(tObject({}));
  scheme.TracingTracingStartParams = tObject({
    name: tOptional(tString),
    snapshots: tOptional(tBoolean),
    screenshots: tOptional(tBoolean),
    sources: tOptional(tBoolean),
  });
  scheme.TracingTracingStartChunkParams = tObject({
    title: tOptional(tString),
  });
  scheme.TracingTracingStopChunkParams = tObject({
    mode: tEnum(['doNotSave', 'compressTrace', 'compressTraceAndSources']),
  });
  scheme.TracingTracingStopParams = tOptional(tObject({}));
  scheme.ArtifactPathAfterFinishedParams = tOptional(tObject({}));
  scheme.ArtifactSaveAsParams = tObject({
    path: tString,
  });
  scheme.ArtifactSaveAsStreamParams = tOptional(tObject({}));
  scheme.ArtifactFailureParams = tOptional(tObject({}));
  scheme.ArtifactStreamParams = tOptional(tObject({}));
  scheme.ArtifactCancelParams = tOptional(tObject({}));
  scheme.ArtifactDeleteParams = tOptional(tObject({}));
  scheme.StreamReadParams = tObject({
    size: tOptional(tNumber),
  });
  scheme.StreamCloseParams = tOptional(tObject({}));
  scheme.WritableStreamWriteParams = tObject({
    binary: tBinary,
  });
  scheme.WritableStreamCloseParams = tOptional(tObject({}));
  scheme.CDPSessionSendParams = tObject({
    method: tString,
    params: tOptional(tAny),
  });
  scheme.CDPSessionDetachParams = tOptional(tObject({}));
  scheme.ElectronLaunchParams = tObject({
    executablePath: tOptional(tString),
    args: tOptional(tArray(tString)),
    cwd: tOptional(tString),
    env: tOptional(tArray(tType('NameValue'))),
    timeout: tOptional(tNumber),
    acceptDownloads: tOptional(tBoolean),
    bypassCSP: tOptional(tBoolean),
    colorScheme: tOptional(tEnum(['dark', 'light', 'no-preference'])),
    extraHTTPHeaders: tOptional(tArray(tType('NameValue'))),
    geolocation: tOptional(tObject({
      longitude: tNumber,
      latitude: tNumber,
      accuracy: tOptional(tNumber),
    })),
    httpCredentials: tOptional(tObject({
      username: tString,
      password: tString,
    })),
    ignoreHTTPSErrors: tOptional(tBoolean),
    locale: tOptional(tString),
    offline: tOptional(tBoolean),
    recordHar: tOptional(tObject({
      omitContent: tOptional(tBoolean),
      path: tString,
    })),
    recordVideo: tOptional(tObject({
      dir: tString,
      size: tOptional(tObject({
        width: tNumber,
        height: tNumber,
      })),
    })),
    strictSelectors: tOptional(tBoolean),
    timezoneId: tOptional(tString),
  });
  scheme.ElectronApplicationBrowserWindowParams = tObject({
    page: tChannel('Page'),
  });
  scheme.ElectronApplicationEvaluateExpressionParams = tObject({
    expression: tString,
    isFunction: tOptional(tBoolean),
    arg: tType('SerializedArgument'),
  });
  scheme.ElectronApplicationEvaluateExpressionHandleParams = tObject({
    expression: tString,
    isFunction: tOptional(tBoolean),
    arg: tType('SerializedArgument'),
  });
  scheme.ElectronApplicationCloseParams = tOptional(tObject({}));
  scheme.AndroidDevicesParams = tObject({
    host: tOptional(tString),
    port: tOptional(tNumber),
    omitDriverInstall: tOptional(tBoolean),
  });
  scheme.AndroidSetDefaultTimeoutNoReplyParams = tObject({
    timeout: tNumber,
  });
  scheme.AndroidSocketWriteParams = tObject({
    data: tBinary,
  });
  scheme.AndroidSocketCloseParams = tOptional(tObject({}));
  scheme.AndroidDeviceWaitParams = tObject({
    selector: tType('AndroidSelector'),
    state: tOptional(tEnum(['gone'])),
    timeout: tOptional(tNumber),
  });
  scheme.AndroidDeviceFillParams = tObject({
    selector: tType('AndroidSelector'),
    text: tString,
    timeout: tOptional(tNumber),
  });
  scheme.AndroidDeviceTapParams = tObject({
    selector: tType('AndroidSelector'),
    duration: tOptional(tNumber),
    timeout: tOptional(tNumber),
  });
  scheme.AndroidDeviceDragParams = tObject({
    selector: tType('AndroidSelector'),
    dest: tType('Point'),
    speed: tOptional(tNumber),
    timeout: tOptional(tNumber),
  });
  scheme.AndroidDeviceFlingParams = tObject({
    selector: tType('AndroidSelector'),
    direction: tEnum(['up', 'down', 'left', 'right']),
    speed: tOptional(tNumber),
    timeout: tOptional(tNumber),
  });
  scheme.AndroidDeviceLongTapParams = tObject({
    selector: tType('AndroidSelector'),
    timeout: tOptional(tNumber),
  });
  scheme.AndroidDevicePinchCloseParams = tObject({
    selector: tType('AndroidSelector'),
    percent: tNumber,
    speed: tOptional(tNumber),
    timeout: tOptional(tNumber),
  });
  scheme.AndroidDevicePinchOpenParams = tObject({
    selector: tType('AndroidSelector'),
    percent: tNumber,
    speed: tOptional(tNumber),
    timeout: tOptional(tNumber),
  });
  scheme.AndroidDeviceScrollParams = tObject({
    selector: tType('AndroidSelector'),
    direction: tEnum(['up', 'down', 'left', 'right']),
    percent: tNumber,
    speed: tOptional(tNumber),
    timeout: tOptional(tNumber),
  });
  scheme.AndroidDeviceSwipeParams = tObject({
    selector: tType('AndroidSelector'),
    direction: tEnum(['up', 'down', 'left', 'right']),
    percent: tNumber,
    speed: tOptional(tNumber),
    timeout: tOptional(tNumber),
  });
  scheme.AndroidDeviceInfoParams = tObject({
    selector: tType('AndroidSelector'),
  });
  scheme.AndroidDeviceScreenshotParams = tOptional(tObject({}));
  scheme.AndroidDeviceInputTypeParams = tObject({
    text: tString,
  });
  scheme.AndroidDeviceInputPressParams = tObject({
    key: tString,
  });
  scheme.AndroidDeviceInputTapParams = tObject({
    point: tType('Point'),
  });
  scheme.AndroidDeviceInputSwipeParams = tObject({
    segments: tArray(tType('Point')),
    steps: tNumber,
  });
  scheme.AndroidDeviceInputDragParams = tObject({
    from: tType('Point'),
    to: tType('Point'),
    steps: tNumber,
  });
  scheme.AndroidDeviceLaunchBrowserParams = tObject({
    noDefaultViewport: tOptional(tBoolean),
    viewport: tOptional(tObject({
      width: tNumber,
      height: tNumber,
    })),
    screen: tOptional(tObject({
      width: tNumber,
      height: tNumber,
    })),
    ignoreHTTPSErrors: tOptional(tBoolean),
    javaScriptEnabled: tOptional(tBoolean),
    bypassCSP: tOptional(tBoolean),
    userAgent: tOptional(tString),
    locale: tOptional(tString),
    timezoneId: tOptional(tString),
    geolocation: tOptional(tObject({
      longitude: tNumber,
      latitude: tNumber,
      accuracy: tOptional(tNumber),
    })),
    permissions: tOptional(tArray(tString)),
    extraHTTPHeaders: tOptional(tArray(tType('NameValue'))),
    offline: tOptional(tBoolean),
    httpCredentials: tOptional(tObject({
      username: tString,
      password: tString,
    })),
    deviceScaleFactor: tOptional(tNumber),
    isMobile: tOptional(tBoolean),
    hasTouch: tOptional(tBoolean),
    colorScheme: tOptional(tEnum(['dark', 'light', 'no-preference'])),
    reducedMotion: tOptional(tEnum(['reduce', 'no-preference'])),
    forcedColors: tOptional(tEnum(['active', 'none'])),
    acceptDownloads: tOptional(tBoolean),
    baseURL: tOptional(tString),
    recordVideo: tOptional(tObject({
      dir: tString,
      size: tOptional(tObject({
        width: tNumber,
        height: tNumber,
      })),
    })),
    recordHar: tOptional(tObject({
      omitContent: tOptional(tBoolean),
      path: tString,
    })),
    strictSelectors: tOptional(tBoolean),
    pkg: tOptional(tString),
    proxy: tOptional(tObject({
      server: tString,
      bypass: tOptional(tString),
      username: tOptional(tString),
      password: tOptional(tString),
    })),
  });
  scheme.AndroidDeviceOpenParams = tObject({
    command: tString,
  });
  scheme.AndroidDeviceShellParams = tObject({
    command: tString,
  });
  scheme.AndroidDeviceInstallApkParams = tObject({
    file: tBinary,
    args: tOptional(tArray(tString)),
  });
  scheme.AndroidDevicePushParams = tObject({
    file: tBinary,
    path: tString,
    mode: tOptional(tNumber),
  });
  scheme.AndroidDeviceSetDefaultTimeoutNoReplyParams = tObject({
    timeout: tNumber,
  });
  scheme.AndroidDeviceConnectToWebViewParams = tObject({
    socketName: tString,
  });
  scheme.AndroidDeviceCloseParams = tOptional(tObject({}));
  scheme.AndroidWebView = tObject({
    pid: tNumber,
    pkg: tString,
    socketName: tString,
  });
  scheme.AndroidSelector = tObject({
    checkable: tOptional(tBoolean),
    checked: tOptional(tBoolean),
    clazz: tOptional(tString),
    clickable: tOptional(tBoolean),
    depth: tOptional(tNumber),
    desc: tOptional(tString),
    enabled: tOptional(tBoolean),
    focusable: tOptional(tBoolean),
    focused: tOptional(tBoolean),
    hasChild: tOptional(tObject({
      selector: tType('AndroidSelector'),
    })),
    hasDescendant: tOptional(tObject({
      selector: tType('AndroidSelector'),
      maxDepth: tOptional(tNumber),
    })),
    longClickable: tOptional(tBoolean),
    pkg: tOptional(tString),
    res: tOptional(tString),
    scrollable: tOptional(tBoolean),
    selected: tOptional(tBoolean),
    text: tOptional(tString),
  });
  scheme.AndroidElementInfo = tObject({
    children: tOptional(tArray(tType('AndroidElementInfo'))),
    clazz: tString,
    desc: tString,
    res: tString,
    pkg: tString,
    text: tString,
    bounds: tType('Rect'),
    checkable: tBoolean,
    checked: tBoolean,
    clickable: tBoolean,
    enabled: tBoolean,
    focusable: tBoolean,
    focused: tBoolean,
    longClickable: tBoolean,
    scrollable: tBoolean,
    selected: tBoolean,
  });
  scheme.JsonPipeSendParams = tObject({
    message: tAny,
  });
  scheme.JsonPipeCloseParams = tOptional(tObject({}));

  return scheme;
}
