---
id: example-apps
title: Example Apps
sidebar_label: Example Apps
slug: /example-apps
---


:::info
Some of the examples on this page are out-of-date since V10. We'll update this soon.
:::

You can clone trpc and play with local examples, or play with them in the CodeSandbox link below.

Here's some example apps:

<table width="100%">
  <thead>
    <tr>
      <th>Description</th>
      <th>URL</th>
      <th>Links</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>
        <strong>Recommended:</strong><br/>Next.js starter with Prisma, E2E testing, &amp; ESLint
        <br/><br/>
        <details>
          <summary>Quick start with <code>create-next-app</code></summary>
          <code>yarn create next-app --example https://github.com/trpc/trpc --example-path examples/next-prisma-starter trpc-prisma-starter</code>
        </details>
      </td>
      <td><a href="https://nextjs.trpc.io">nextjs.trpc.io</a></td>
      <td>
        <ul>
          <li><a href="https://github.com/trpc/examples-next-prisma-starter">Source</a></li>
        </ul>
      </td>
    </tr>
    <tr>
      <td>
        <em>zART-stack</em> example (<b>z</b>ero-<b>A</b>PI, <b>T</b>ypeScript, <b>R</b>eact).
        <br />
        Monorepo setup with <strong>React Native</strong>, Next.js, &amp; Prisma
        <br/><br/>
        <details>
          <summary>Quick start with <code>git clone</code></summary>
          <code>git clone git@github.com:KATT/zart.git</code>
        </details>
      </td>
      <td><em>n/a</em></td>
      <td>
        <ul>
          <li><a href="https://github.com/KATT/zART">Source</a></li>
        </ul>
      </td>
    </tr>
    <tr>
      <td>
        Next.js starter with Prisma, E2E testing, ESLint, Auth using next-auth, WebSockets, &amp; Subscription support
        <br/><br/>
        <details>
          <summary>Quick start with <code>create-next-app</code></summary>
          <code>yarn create next-app --example https://github.com/trpc/trpc --example-path examples/next-prisma-starter-websockets trpc-prisma-starter-websockets</code>
        </details>
      </td>
      <td><a href="http://websockets.trpc.io">websockets.trpc.io</a></td>
      <td>
        <ul>
          <li><a href="https://codesandbox.io/s/github/trpc/trpc/tree/main/examples/next-prisma-starter-websockets?file=/src/pages/index.tsx">CodeSandbox</a></li>
          <li><a href="https://github.com/trpc/examples-next-prisma-starter-websockets">Source</a></li>
        </ul>
      </td>
    </tr>
    <tr>
      <td>
        Next.js TodoMVC-example with SSG & Prisma.
        <br/><br/>
        <details>
          <summary>Quick start with <code>create-next-app</code></summary>
          <code>yarn create next-app --example https://github.com/trpc/trpc --example-path examples/next-prisma-todomvc trpc-todo</code>
        </details>
      </td>
      <td><a href="https://todomvc.trpc.io">todomvc.trpc.io</a></td>
      <td>
        <ul>
          <li><a href="https://codesandbox.io/s/github/trpc/trpc/tree/main/examples/next-prisma-todomvc?file=/pages/%5Bfilter%5D.tsx">CodeSandbox</a></li>
          <li><a href="https://github.com/trpc/examples-next-prisma-todomvc">Source</a></li>
        </ul>
      </td>
    </tr>
    <tr>
      <td>Minimal (Hello world) server and client in node.js</td>
      <td><em>n/a</em></td>
      <td>
        <ul>
          <li><a href="https://github.com/trpc/trpc/tree/main/examples/minimal">Source</a></li>
        </ul>
      </td>
    </tr>
    <tr>
      <td>Vanilla standalone server &amp; procedure calls with node.js</td>
      <td><em>n/a</em></td>
      <td>
        <ul>
          <li><a href="https://githubbox.com/trpc/trpc/tree/main/examples/standalone-server">CodeSandbox</a></li>
          <li><a href="https://github.com/trpc/trpc/tree/main/examples/standalone-server">Source</a></li>
        </ul>
      </td>
    </tr>
    <tr>
      <td>Express server &amp; procedure calls with node.js.</td>
      <td><em>n/a</em></td>
      <td>
        <ul>
          <li><a href="https://githubbox.com/trpc/trpc/tree/main/examples/express-server">CodeSandbox</a></li>
          <li><a href="https://github.com/trpc/trpc/tree/main/examples/express-server">Source</a></li>
        </ul>
      </td>
    </tr>
    <tr>
      <td>Fastify server with WebSocket &amp; procedure calls with node.js.</td>
      <td><em>n/a</em></td>
      <td>
        <ul>
          <li><a href="https://codesandbox.io/s/github/trpc/trpc/tree/main/examples/fastify-server">CodeSandbox</a></li>
          <li><a href="https://github.com/trpc/trpc/tree/main/examples/fastify-server">Source</a></li>
        </ul>
      </td>
    </tr>
    <tr>
      <td>SvelteKit Example Application with Prisma.</td>
      <td><em>n/a</em></td>
      <td>
        <ul>
          <li><a href="https://codesandbox.io/s/github/icflorescu/trpc-sveltekit-example">CodeSandbox</a></li>
          <li><a href="https://github.com/icflorescu/trpc-sveltekit-example">Source</a></li>
        </ul>
      </td>
    </tr>
    <tr>
      <td>Cloudflare Workers example</td>
      <td><em>n/a</em></td>
      <td>
        <ul>
          <li><a href="https://github.com/trpc/trpc/tree/next/examples/cloudflare-workers">Source</a></li>
        </ul>
      </td>
    </tr>
    <tr>
      <td>
        Express server with tRPC Shield + Prisma
        <br/><br/>
        <details>
          <summary>Quick start with <code>create-trpc-appx</code></summary>
          <code>npx create-trpc-appx --example https://github.com/omar-dulaimi/trpc-shield/tree/master/example</code>
        </details>
      </td>
      <td><em>n/a</em></td>      
      <td>
        <ul>
          <li><a href="https://github.com/omar-dulaimi/trpc-shield/tree/master/example">Source</a></li>
        </ul>
      </td>
    </tr>
  </tbody>
</table>
