﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace System.Windows.Forms
{
    /// <summary>
    ///  Specifies which scroll bars will be visible on a control.
    /// </summary>
    public enum ScrollBars
    {
        /// <summary>
        ///  No scroll bars are shown.
        /// </summary>
        None = 0,

        /// <summary>
        ///  Only horizontal scroll bars are shown.
        /// </summary>
        Horizontal = 1,

        /// <summary>
        ///  Only vertical scroll bars are shown.
        /// </summary>
        Vertical = 2,

        /// <summary>
        ///  Both horizontal and vertical scroll bars are shown.
        /// </summary>
        Both = 3,
    }
}
