﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace System.Windows.Forms
{
    /// <summary>
    ///  Controls where the tabs will be located in a Tab Control.
    /// </summary>
    public enum TabAlignment
    {
        /// <summary>
        ///  Tabs will be located across the top of the control.
        /// </summary>
        Top = 0,

        /// <summary>
        ///  Tabs will be located across the bottom of the control.
        /// </summary>
        Bottom = 1,

        /// <summary>
        ///  Tabs will be located along the left edge of the control.
        /// </summary>
        Left = 2,

        /// <summary>
        ///  Tabs will be located along the right edge of the control.
        /// </summary>
        Right = 3,
    }
}
