# Development process

1. Find a ticket from the top of `Ready for Dev` column on [Kanban board](https://localorbit.atlassian.net/secure/RapidBoard.jspa?rapidView=3)
1. Assign it to yourself
1. Move it to `In Progress`
1. Create a feature branch off master in the format `my-feature-branch-LO-XXXX`
1. Do the work
1. PENDING: Get tests green locally
1. Push branch to `origin`, eg. `git push -u origin my-feature-branch-LO-XXXX`
1. Check automated tests for branch pass (no conflicts, CircleCI, RuboCop??)
1. Create a PR
1. Move JIRA to `Needs Review`
1. Get PR reviewed and approved
1. Merge down to `master`
1. Discuss if it's a reasonable time to merge to staging
1. Merge to `staging`
1. Move ticket to `Ready for QA`
1. Communicate with team about test plan for new stuff on staging
1. Move tickets to `Ready to Deploy`
1. Release manager checks with team that we're good to release staging to production
1. Merge `staging` to `production`
1. Create a tag, Eg. `git tag -a v5.0.3 -m 'An annotated tag'`
1. Go into [semaphore](https://semaphoreci.com/micah/localorbit) and do a [manual deploy](#)
1. Sanity check on production that core flows work, and review features
1. Release manager moves JIRA tickets from `Ready to Deploy` to `Closed`
1. Delete feature branches once they are in the tag

### DISCUSS:
*   delete all merged branches
*   legacy unmerged branches let's move `feature/performance-20160704` to `gomi/performance-20160704`


