/* The MIT License (MIT)

Copyright (c) 2013 guillaumervls

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. */

(function() {
  // Note to future devs: this is a forked/mutated version of https://github.com/guillaumervls/react-infinite-scroll

  // The original wasn't compatibile with React >= .12, so I took a fork that made it so compatible, https://github.com/ramast/react-infinite-scroll.

  // There were much more stable and well-maintained libraries than this, but this is the only one that didn't need to be passed the height of each element in advance.


  function topPosition(domElt) {
    if (!domElt) {
      return 0;
    }
    return domElt.offsetTop + topPosition(domElt.offsetParent);
  }


  window.InfiniteScroll = React.createClass({
    displayName: 'InfiniteScroll',
    propTypes: {
      pageStart: React.PropTypes.number,
      threshold: React.PropTypes.number,
      loadMore: React.PropTypes.func.isRequired,
      hasMore: React.PropTypes.bool,
      useWindow: React.PropTypes.bool
    },
    getDefaultProps: function () {
      return {
        pageStart: 0,
        hasMore: false,
        threshold: 250,
        useWindow: true
      };
    },
    componentDidMount: function () {
      this.pageLoaded = this.props.pageStart;
      this.attachScrollListener();
    },
    componentDidUpdate: function () {
      this.attachScrollListener();
    },
    render: function () {
      var props = this.props;
      return React.DOM.div({style: {maxHeight: "100%", overflow: "auto", display: "block"}}, props.children, props.hasMore && props.loader);
    },
    scrollListener: function () {
      var el = ReactDOM.findDOMNode(this);
      var scrollEl = window;

      var offset;
      if(this.props.useWindow == true) {
        var scrollTop = (scrollEl.pageYOffset !== undefined) ? scrollEl.pageYOffset : (document.documentElement || document.body.parentNode || document.body).scrollTop;
        offset = topPosition(el) + el.offsetHeight - scrollTop - window.innerHeight;
      } else {
        offset = el.offsetHeight - el.parentNode.scrollTop - el.parentNode.clientHeight;
      }

      if (offset < 0)
          offset = Math.abs(offset)

      if (offset < Number(this.props.threshold)) {
        this.detachScrollListener();
        // call loadMore after detachScrollListener to allow
        // for non-async loadMore functions
        this.props.loadMore(this.pageLoaded += 1);
      }
    },
    attachScrollListener: function () {
      if (!this.props.hasMore) {
        return;
      }

      var scrollEl = window;
      if(this.props.useWindow == false) {
        scrollEl = ReactDOM.findDOMNode(this).parentNode;
      }

      scrollEl.addEventListener('scroll', this.scrollListener);
      scrollEl.addEventListener('resize', this.scrollListener);
      this.scrollListener();
    },
    detachScrollListener: function () {
      var scrollEl = window;
      if(this.props.useWindow == false) {
        scrollEl = ReactDOM.findDOMNode(this).parentNode;
      }

      scrollEl.removeEventListener('scroll', this.scrollListener);
      scrollEl.removeEventListener('resize', this.scrollListener);
    },
    componentWillUnmount: function () {
      this.detachScrollListener();
    }
  });
}).call(this);
