### raylib bindings

Some people ported raylib to other languages in form of bindings or wrappers to the library, here is a list with the ones I'm aware of:

|  name              | language       | repo                                                                 |
|:------------------:|:--------------:|----------------------------------------------------------------------|
| raylib             | C              | https://github.com/raysan5/raylib                                    |
| raylib-cpp         | C++            | https://github.com/robloach/raylib-cpp                               |
| Raylib-cs          | C#             | https://github.com/ChrisDill/Raylib-cs                               |
| RaylibSharp        | C#             | https://github.com/TheLumaio/RaylibSharp                             |
| RaylibFS           | F#             | https://github.com/dallinbeutler/RaylibFS                            |
| raylib_d           | D              | https://github.com/0xFireball/raylib_d                               |
| raylib-d           | D              | https://github.com/onroundit/raylib-d                                |
| raylib-go          | Go             | https://github.com/gen2brain/raylib-go                               |
| raylib-goplus      | Go             | https://github.com/Lachee/raylib-goplus                              |
| raylib-rs          | Rust           | https://github.com/deltaphc/raylib-rs                                |
| raylib-lua         | Lua            | https://github.com/raysan5/raylib-lua                                |
| raylib-lua-ffi     | Lua            | https://github.com/raysan5/raylib/issues/693                         |
| raylib-lua-sol     | Lua            | https://github.com/RobLoach/raylib-lua-sol                           |
| raylib-Nim         | Nim            | https://gitlab.com/define-private-public/raylib-Nim                  |
| raylib-nim         | Nim            | https://github.com/Skrylar/raylib-nim                                |
| raylib-haskell     | Haskell        | https://github.com/DevJac/raylib-haskell                             |
| raylib-cr          | Crystal        | https://github.com/AregevDev/raylib-cr                               |
| cray               | Crystal        | https://gitlab.com/Zatherz/cray                                      |
| cray               | Crystal        | https://github.com/tapgg/cray                                        |
| raylib-pascal      | Pascal         | https://github.com/drezgames/raylib-pascal                           |
| raylib-pas         | Pascal         | https://github.com/tazdij/raylib-pas                                 |
| Graphics-Raylib    | Perl           | https://github.com/athreef/Graphics-Raylib                           |
| raylib-ruby-ffi    | Ruby           | https://github.com/D3nX/raylib-ruby-ffi                              |
| raylib-ruby        | Ruby           | https://github.com/a0/raylib-ruby                                    |
| raylib-mruby       | mruby          | https://github.com/lihaochen910/raylib-mruby                         |
| raylib-py          | Python         | https://github.com/overdev/raylib-py                                 |
| raylib-python-cffi | Python         | https://github.com/electronstudio/raylib-python-cffi                 |
| raylib-java        | Java           | https://github.com/XoanaIO/raylib-java                               |
| node-raylib        | Node.js        | https://github.com/RobLoach/node-raylib                              |
| QuickJS-raylib     | QuickJS        | https://github.com/sntg-p/QuickJS-raylib                             |
| raylib-js          | JavaScript     | https://github.com/RobLoach/raylib-js                                |
| raylib-chaiscript  | ChaiScript     | https://github.com/RobLoach/raylib-chaiscript                        |
| raylib-squirrel    | Squirrel       | https://github.com/RobLoach/raylib-squirrel                          |
| racket-raylib-2d   | Racket         | https://github.com/arvyy/racket-raylib-2d                            |
| raylib-php         | PHP            | https://github.com/joseph-montanez/raylib-php                        |
| raylib-php-ffi     | PHP            | https://github.com/oraoto/raylib-php-ffi                             |
| raylib-phpcpp      | PHP            | https://github.com/oraoto/raylib-phpcpp                              |
| raylib-factor      | Factor         | https://github.com/Silverbeard00/raylib-factor                       |
| raylib-haxe        | Haxe           | https://github.com/ibilon/raylib-haxe                                |
| ringraylib         | Ring           | https://github.com/ringpackages/ringraylib                           |
| cl-raylib          | Common Lisp    | https://github.com/longlene/cl-raylib                                |
| raylib-scm         | Chicken Scheme | https://github.com/yashrk/raylib-scm                                 |
| Euraylib           | Euphoria       | https://github.com/gAndy50/Euraylib                                  |
| raylib-wren        | Wren           | https://github.com/TSnake41/raylib-wren                              |
| raylib-odin        | Odin           | https://github.com/kevinw/raylib-odin                                |
| ray.zig            | Zig            | https://github.com/BitPuffin/zig-raylib-experiments                  |
| raylib-Ada         | Ada            | https://github.com/mimo/raylib-Ada                                   |
| jaylib             | Janet          | https://github.com/janet-lang/jaylib                                 |
| raykit             | Kit            | https://github.com/Gamerfiend/raykit                                 |
| vraylib            | V              | https://github.com/MajorHard/vraylib                                 |
| raylib.cbl         | COBOL          | *[code examples](https://github.com/Martinfx/Cobol/tree/master/OpenCobol/Games/raylib)* |
 
Missing some language? Check the [bindings not yet in this list](https://gist.github.com/raysan5/5764cc5b885183f523fce47f098f3d9b#bindings-not-yet-in-the-official-list) or create a new binding! :)

Usually, raylib bindings follow the convention: `raylib-{language}`

Let me know if you're writing a new binding for raylib, I will list it here and I usually 
provide the icon/logo for that new language binding.
