# Rune Project Contribution Guidelines

## 1. Preamble

1.1. The terms "MUST", "MUST NOT", "REQUIRED", "SHALL", "SHALL NOT", "SHOULD", "SHOULD NOT", "RECOMMENDED", "MAY", and "OPTIONAL" are to be interpreted as described in BCP 14, RFC 2119.

## 2. Language Requirements

### 2.1 Use English

2.1.1. All contributions MUST be in English to ensure clear communication among developers from diverse backgrounds and regions.

2.1.2. If you're not confident in your English, you MAY use any large language model to assist you.

### 2.2 Precise Communication

2.2.1. All contributions SHOULD NOT using adjectives, as they can be abstract and lead to unclear expression.

2.2.2. Adjectives may cause misunderstandings because they often rely on personal feelings and judgments. Instead, contributions SHOULD:

- **Use specific data:** Support your points with concrete numbers and facts.
- **Provide clear definitions:** If adjectives must be used, first offer a clear definition.
- **Adopt objective descriptions:** Use objective language to describe observed phenomena.
- **Use standardized terminology:** In professional fields, use recognized terms and standards.

### 2.3. Prohibited Conduct

Participants MUST NOT:

2.3.1. Use offensive, derogatory, or discriminatory language

2.3.2. Engage in trolling or harassment

2.3.3. Make unfounded accusations against other participants

2.3.4. Deliberately disrupt community discussions

2.3.5. Use sexualized language or imagery or engage in sexual attention or advances

2.3.6. Make personal or political attacks

2.3.7. Publish private information without explicit permission

2.3.8. Engage in any conduct reasonably considered inappropriate in a professional setting

## 3. Feature Development and Requests

### 3.1. Eligibility and Process

3.1.1. Only paid genuine users and active code contributors COULD have the right to submit feature requests.

3.1.2. Contributors MUST contact the development team for preliminary discussion before implementing features to ensure alignment with Rune's vision.

### 3.2. Ethical Foundation

The following principles SHALL form the ethical foundation of all product decisions:

3.2.1. **User Safety:** Features MUST NOT cause harm to users or their systems

3.2.2. **Privacy:** User privacy MUST be protected, and user data MUST be handled with transparency and care

3.2.3. **Autonomy:** User autonomy MUST be respected and preserved

3.2.4. **Attention:** User attention MUST NOT be exploited for commercial or other purposes

### 3.3. User-Centered Design

All feature proposals MUST align with these core principles:

3.3.1. **Core Functionality:** Features MUST serve the primary purpose of music playback and library management

3.3.2. **User Intent:** Features MUST respect user choices and control

3.3.3. **User Experience:** Features SHOULD enhance, not impede, the music listening experience

3.3.4. **Performance:** Features MUST NOT significantly degrade system performance

### 3.4. Priority Guidelines

3.4.1. Participants MUST NOT prioritize "commercial benefit", "community influence" or "market trends" over product first principles

3.4.2. Popular feature requests that conflict with core principles SHALL be declined

3.4.3. Market competitive analysis MAY inform but SHALL NOT override ethical considerations

3.4.4. Monetization strategies MUST align with user interests and ethical principles

3.4.5. While deviations from product value principles MAY be considered, such proposals MUST NOT disrupt the normal user experience

## 4. Software Defect Reporting

### 4.1. Definitions

4.1.1. A "software defect" SHALL be defined as a verifiable deviation from documented functionality or performance specifications

4.1.2. Personal preferences SHALL be defined as subjective opinions about software features or behaviors that conform to specifications

4.1.3. Participants SHOULD distinguish between "software defects" and personal preferences

### 4.2. Report Requirements

4.2.1. All defect reports MUST include:

- Steps to reproduce
- Expected behavior
- Actual behavior
- System environment details

4.2.2. Reports SHOULD include objective evidence such as:

- Screenshots
- Log files
- Video recordings
- Performance metrics

## 5. Pull Request Standards

5.1. All commits MUST follow [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0/) specification with clear and descriptive messages.

5.2. We do not accept pull requests for translating the README or any development documentation.

## 6. Conduct and Enforcement

### 6.1. Enforcement Responsibilities

6.1.1. Community leaders are responsible for clarifying and enforcing community standards of acceptable behavior.

6.1.2. Leaders have the right and responsibility to:

- Remove, edit, or reject contributions that do not align with this Code of Conduct
- Communicate reasons for moderation decisions when appropriate

### 6.2. Scope of Conduct

6.2.1. This Code of Conduct applies within all community spaces, including:

- Official communication channels
- Public representations of the community
- Online and offline events

### 6.3. Reporting and Enforcement Guidelines

#### 6.3.1. Reporting Incidents

- Instances of abusive, harassing, or unacceptable behavior may be reported to community leaders
- All complaints will be reviewed and investigated promptly and fairly
- Reporter privacy and security will be respected

#### 6.3.2. Enforcement Levels

| Level | Community Impact | Consequence |
|-------|------------------|-------------|
| Correction | Inappropriate language or unprofessional behavior | Public written warning; Explanation of violation; Potential request for public apology |
| Warning | Violation through a single incident or series of actions | Warning with specified consequences; No interaction with involved parties; Potential temporary restriction from community spaces |
| Temporary Ban | Serious violation of community standards | Temporary ban from community interactions;  No public or private interaction with involved parties |
| Permanent Ban | Pattern of community standard violations | Permanent removal from all community interactions |

# Attribution

This Code of Conduct references the Contributor Covenant, version 2.0, which can be found at https://www.contributor-covenant.org/version/2/0/code_of_conduct.html.

The Community Impact Guidelines drew inspiration from Mozilla's code of conduct enforcement ladder.
