# Support Policy

## Our Philosophy

Rune is an open-source project built with passion and dedication. We believe in creating high-quality software that respects users and provides an exceptional experience. To ensure Rune's long-term sustainability and continued development, we've implemented a support tier system that balances open-source principles with the practical needs of ongoing development.

### Why We Need This Model

Open-source software faces unique challenges:

1. **Sustainable Development**: Without financial support, even the most promising open-source projects can stagnate or be abandoned.
2. **Resource Allocation**: Developer time is limited and must be allocated efficiently.
3. **Quality Assurance**: Different distribution methods require varying levels of quality control.
4. **Alignment of Incentives**: Those who financially support the project should have proportional influence on its direction.

Our tiered support model addresses these challenges while keeping Rune freely available to all users under the Mozilla Public License (MPL).

## Support Tiers

### 1. Paid Members ($10+)

Users who have purchased Rune through official channels (Steam, Microsoft Store, App Store) or made direct financial contributions.

**Benefits include:**

- Feature request submissions eligible for roadmap consideration
- Priority bug fixes and technical support
- Direct communication with core developers

### 2. Community Members

Users who obtain official binary packages from our CI system or contribute non-financially (code, documentation, translations).

**Benefits include:**

- Submit bug reports addressed by severity and community impact
- Participate in community-driven feature discussions

### 3. Self-Build Users

Users who compile Rune from source code for personal use.

**Benefits include:**

- Freedom to modify and customize Rune under MPL terms
- Access to cutting-edge development branches

**Limitations:**

- No official support for compilation issues or custom builds
- No guaranteed compatibility with future updates
- May not receive security patches automatically

**Note:** Due to Rune's complex build dependencies and environment requirements, we cannot troubleshoot self-built installations. Community forums may provide unofficial assistance.

## Common Questions

**Q: Why monetize an open-source project?**  

A: While Rune remains free, sustained development requires resources. This model ensures we prioritize features most valued by users while maintaining accessibility.

**Q: What happens if I compile Rune myself?**

A: You're welcome to compile and modify Rune for your own use under the terms of the MPL License. However, we can't provide official support for self-built versions due to the variability in build environments.

**Q: How are supporter funds used?**

A: Funds from supporters go directly toward:
* Developer time for implementing new features
* Infrastructure costs (servers, CI systems, etc.)
* Documentation and user experience improvements
