![ZIO Logo](./ZIO.png)

| Project Stage | CI | Release | Snapshot | Issues |
| --- | --- | --- | --- | --- |
| [![Project stage][Badge-Stage]][Badge-Stage-Page] | ![CI][Badge-CI] | [![Release Artifacts][Badge-SonatypeReleases]][Link-SonatypeReleases] | [![Snapshot Artifacts][Badge-SonatypeSnapshots]][Link-SonatypeSnapshots] | [![Average time to resolve an issue][Badge-IsItMaintained]][Link-IsItMaintained] |

| Scaladoc | Scaladex | Discord | Twitter | Gitpod |
| --- | --- | --- | --- | --- |
| [Scaladoc][Link-Scaladoc] | [![Badge-Scaladex-page]][Link-Scaladex-page] | [![Badge-Discord]][Link-Discord] | [![Badge-Twitter]][Link-Twitter] | [![Gitpod ready-to-code](https://img.shields.io/badge/Gitpod-ready--to--code-blue?logo=gitpod)](https://gitpod.io/#https://github.com/zio/zio) |

# Welcome to ZIO

ZIO is a zero-dependency Scala library for asynchronous and concurrent programming.

Powered by highly-scalable, non-blocking fibers that never waste or leak resources, ZIO lets you build scalable, resilient, and reactive applications that meet the needs of your business.

 - **High-performance**. Build scalable applications with minimal runtime overhead.
 - **Type-safe**. Use the full power of the Scala compiler to catch bugs at compile time.
 - **Concurrent**. Easily build concurrent apps without deadlocks, race conditions, or complexity.
 - **Asynchronous**. Write sequential code that looks the same whether it's asynchronous or synchronous.
 - **Resource-safe**. Build apps that never leak resources (including threads!), even when they fail.
 - **Testable**. Inject test services into your app for fast, deterministic, and type-safe testing.
 - **Resilient**. Build apps that never lose errors, and which respond to failure locally and flexibly.
 - **Functional**. Rapidly compose solutions to complex problems from simple building blocks.

To learn more about ZIO, see the following references:

 - [Homepage](https://zio.dev/)
 - [Contributor's Guide](docs/contributor-guidelines.md)
 - [License](LICENSE)
 - [Issues](https://github.com/zio/zio/issues)
 - [Pull Requests](https://github.com/zio/zio/pulls)

---

# Adopters

Following is a partial list of companies happily using ZIO in
production to craft concurrent applications.

Want to see your company here? [Submit a PR](https://github.com/zio/zio/edit/series/2.x/README.md)!

* [AdGear / Samsung Ads](https://adgear.com/en/)
* [Adidas](https://www.adidas.com/)
* [adpulse.io](https://www.adpulse.io/)
* [adsquare](https://www.adsquare.com/)
* [Amazon](https://www.amazon.com/)
* [Anduin Transactions](https://www.anduintransact.com/)
* [AnyMind Group](https://anymindgroup.com)
* [Ayolab](https://www.ayolab.com/)
* [Asana](https://asana.com/)
* [Aurinko](https://www.aurinko.io/)
* [auto.ru](https://auto.ru)
* [AutoScout24](https://www.autoscout24.de)
* [Avast](https://www.avast.com)
* [Bank of America](https://www.bofa.com)
* [Believe](https://www.believe.com)
* [Blue Insight Digital](https://www.blueinsight.digital/)
* [BlueLabs](https://www.bluelabs.eu/)
* [Bpp](https://www.bpp.it/)
* [Broad](https://broad.app)
* [Caesars Digital](https://www.caesars.com/sportsbook-and-casino)
* [CalcBank](https://www.calcbank.com.br)
* [Call Handling](https://www.callhandling.co.uk/)
* [Carvana](https://www.carvana.com)
* [Cellular](https://www.cellular.de)
* [ChannelPilot](https://channelpilot.com/de)
* [Chartboost](https://chartboost.com)
* [Cloudfarms](https://cloudfarms.com)
* [CodeComprehension](https://codecomprehension.com)
* [Codept](https://www.codept.de/)
* [Colisweb](https://www.colisweb.com/en)
* [Collibra](https://www.collibra.com/)
* [Compellon](https://www.compellon.com/)
* [Complicated Robot](https://www.complicatedrobot.com/)
* [Conduktor](https://www.conduktor.io)
* [Contramap](https://www.contramap.dev)
* [Coralogix](https://coralogix.com)
* [Credit Karma](https://creditkarma.com)
* [CurrencyCloud](https://www.currencycloud.com/)
* [D.E.Solution](https://de-solution.com/)
* [DaSCH](https://dasch.swiss/)
* [DataChef](https://datachef.co)
* [Demandbase](https://www.demandbase.com)
* [Demyst](https://demyst.com)
* [Devsisters](https://devsisters.com/)
* [DHL Parcel The Netherlands](https://www.werkenbijdhl.nl/it)
* [Disney+ Streaming](https://www.disneyplus.com/)
* [Doomoolmori](https://doomoolmori.com/)
* [Dow Jones](https://www.dowjones.com)
* [DPG recruitment](https://www.dpgrecruitment.nl)
* [Dream11](https://dream11.com)
* [Deutsche Telekom IoT GmbH](https://iot.telekom.com/en)
* [eBay](https://www.ebay.com)
* [Eaglescience](https://www.eaglescience.nl)
* [Electricité de France (EDF)](https://www.edf.fr/)
* [EnelX](https://www.enelx.com)
* [Evolution](https://evolution.engineering)
* [Evo](https://evo.company)
* [Flipp](https://flipp.com/)
* [Fugo.ai](https://www.fugo.ai)
* [Garner Distributed Workflow](https://www.garnercorp.com/)
* [Glean](https://www.gleancompany.com)
* [GrandParade](https://grandparade.co.uk)
* [greyflower.media GmbH](https://greyflower.media)
* [Hunters.AI](https://hunters.ai)
* [Hypefactors](https://hypefactors.com/)
* [iHeartRadio](https://www.iheart.com/)
* [IHS Markit](https://ihsmarkit.com/)
* [Investsuite](https://investsuite.com/)
* [Invia](https://www.invia.cz/)
* [Kaizen Solutions](https://kaizen-solutions.net/)
* [Kamon APM](https://kamon.io/)
* [Kodmagi](https://www.kodmagi.se)
* [Kensu](https://kensu.io)
* [LambdaWorks](https://www.lambdaworks.io/)
* [LeadIQ](https://leadiq.com)
* [Lernkunst](http://www.lernkunst.com/)
* [LiveIntent Inc.](https://liveintent.com)
* [Lottoland](https://lottoland.com)
* [MATECHS](https://matechs.com)
* [Megogo](https://megogo.net)
* [MOIA](https://www.moia.io)
* [Mylivn](https://www.mylivn.com/)
* [NewMotion](https://newmotion.com)
* [Nexxchange](https://www.nexxchange.com)
* [Nike](https://nike.com)
* [NsLookup](https://www.nslookup.io)
* [Ocado Technology](https://ocadotechnology.com)
* [Olyro GmbH](https://olyro.de)
* [Optrak](https://optrak.com)
* [Performance Immo](https://www.performance-immo.com/)
* [Pirum](https://www.pirum.com/)
* [PITS Global Data Recovery Services](https://www.pitsdatarecovery.net/)
* [Playtika](https://www.playtika.com)
* [PPC Samurai](https://ppcsamurai.com/)
* [Prezi](https://prezi.com/)
* [Radix Labs](https://www.radix.bio/)
* [Railroad19](https://www.railroad19.com)
* [Randstad Groep Nederland](https://www.werkenbijrandstad.nl)
* [Rapidor](https://www.rapidor.co)
* [PIM Solutions](https://pimsolutions.ru/)
* [Remember The Milk](https://www.rememberthemilk.com/)
* [REWE Digital](http://rewe-digital.com/)
* [LKWfee](https://lkwfee.de/)
* [Risk Ident](https://riskident.com/)
* [Rocker](https://rocker.com/)
* [Rudder](https://www.rudder.io/)
* [Samsung Food](https://samsungfood.com/)
* [Sanjagh](https://sanjagh.pro/)
* [Scalac](https://scalac.io/)
* [SecurityScorecard](https://www.securityscorecard.io/)
* [SentinelOne](https://www.sentinelone.com/)
* [Signicat](https://www.signicat.com/)
* [Société Générale Corporate and Investment Banking](https://info.sgmarkets.com/en/)
* [SoftwareMill](https://softwaremill.com/)
* [StreamWeaver](https://www.streamweaver.com/)
* [Stuart](https://stuart.com/)
* [Teads](https://teads.com)
* [The Pokemon Company International](https://www.pokemon.com/us/about-pokemon/)
* [TomTom](https://tomtom.com)
* [Tinka](https://www.tinka.com/)
* [Tinkoff](https://tinkoff.ru)
* [Trackabus](https://trackabus.com)
* [Trainor](https://www.trainor.no)
* [Tranzzo](https://tranzzo.com)
* [TreuTech](https://treutech.io)
* [Tweddle Group](https://tweddle.com)
* [Undo](https://www.undo.app)
* [Unit](https://unit.co)
* [Univalence](https://univalence.io)
* [Unzer](https://www.unzer.com)
* [Vakantiediscounter](https://www.vakantiediscounter.nl)
* [Verbund AG](https://www.verbund.com)
* [Waylay](https://www.waylay.io/)
* [Wehkamp](https://www.wehkamp.nl)
* [Wefunder](https://wefunder.com)
* [Wolt](https://www.wolt.com/)
* [Yandex.Classifieds](https://o.yandex.ru)
* [Audela](https://audela.ca)
* [Valamis Group](https://valamis.com)
* [Valsea](https://valsea.com)
* [VirtusLab](https://virtuslab.com/)
* [Vish](https://getvish.com)
* [Vivid Money](https://vivid.money)
* [Zalando](https://zalando.com/)
* [Zooz](https://zooz.com/)

# Sponsors

[![Ziverge][Image-Ziverge]][Link-Ziverge]

[Ziverge][Link-Ziverge] is a leading contributor to ZIO.

[![Scalac][Image-Scalac]][Link-Scalac]

[Scalac][Link-Scalac] sponsors ZIO Hackathons and contributes work to multiple projects in ZIO ecosystem.

[![Septimal Mind][Image-SeptimalMind]][Link-SeptimalMind]

[Septimal Mind][Link-SeptimalMind] sponsors work on ZIO Tracing and continuous maintenance.

[![YourKit][Image-YourKit]][Link-YourKit]

[YourKit][Link-YourKit] generously provides use of their monitoring and profiling tools to maximize the performance of ZIO applications.

---

# [Learn More on the ZIO Homepage](https://zio.dev/)

---

## Code of Conduct

See the [Code of Conduct](docs/code-of-conduct.md)

---

## Support

Come chat with us on [![Badge-Discord]][Link-Discord].

---

### Legal

Copyright 2017 - 2024 John A. De Goes and the ZIO Contributors. All rights reserved.


[Link-Codecov]: https://codecov.io/gh/zio/zio?branch=master "Codecov"
[Link-IsItMaintained]: http://isitmaintained.com/project/zio/zio "Average time to resolve an issue"
[Link-Scaladoc]: https://javadoc.io/doc/dev.zio/zio_3/latest/zio/index.html
[Link-Scaladex-page]: https://index.scala-lang.org/zio/zio/zio "Scaladex"
[Link-SonatypeReleases]: https://oss.sonatype.org/content/repositories/releases/dev/zio/zio_3/ "Sonatype Releases"
[Link-SonatypeSnapshots]: https://oss.sonatype.org/content/repositories/snapshots/dev/zio/zio_3/ "Sonatype Snapshots"
[Link-Ziverge]: https://ziverge.com "Ziverge"
[Link-Scalac]: https://scalac.io "Scalac"
[Link-SeptimalMind]: https://7mind.io "Septimal Mind"
[Link-YourKit]: https://www.yourkit.com "YourKit"
[Link-Discord]: https://discord.gg/2ccFBr4 "Discord"
[Link-Twitter]: https://twitter.com/zioscala

[Badge-CI]: https://github.com/zio/zio/workflows/CI/badge.svg
[Badge-Codecov]: https://codecov.io/gh/zio/zio/coverage.svg?branch=master "Codecov"
[Badge-IsItMaintained]: http://isitmaintained.com/badge/resolution/zio/zio.svg "Average time to resolve an issue"
[Badge-Scaladex-page]: https://index.scala-lang.org/zio/zio/zio/latest.svg "Scaladex"
[Badge-SonatypeReleases]: https://img.shields.io/nexus/r/https/oss.sonatype.org/dev.zio/zio_3.svg "Sonatype Releases"
[Badge-SonatypeSnapshots]: https://img.shields.io/nexus/s/https/oss.sonatype.org/dev.zio/zio_3.svg "Sonatype Snapshots"
[Badge-Discord]: https://img.shields.io/discord/629491597070827530?logo=discord "chat on discord"
[Badge-Twitter]: https://img.shields.io/twitter/follow/zioscala.svg?style=plastic&label=follow&logo=twitter
[Badge-Stage]: https://img.shields.io/badge/Project%20Stage-Production%20Ready-brightgreen.svg
[Badge-Stage-Page]: https://github.com/zio/zio/wiki/Project-Stages

[Image-Ziverge]: ./website/static/img/ziverge.png "Ziverge"
[Image-Scalac]: ./website/static/img/scalac.svg "Scalac"
[Image-SeptimalMind]: ./website/static/img/septimal_mind.svg "Septimal Mind"
[Image-YourKit]: ./website/static/img/yourkit.png "YourKit"
