---
id: index
title: "ZIO Ecosystem Official Libraries"
---

Official ZIO libraries are hosted in the [ZIO organization](https://github.com/zio/) on GitHub, and are generally maintained by core contributors to ZIO.

## Development Status

Each project in the ZIO organization namespace has a _Stage Badge_ which indicates the current status of that project:

* **Production Ready** — The project is stable and already used in production. We can expect reliability for the implemented use cases.
* **Development** — The project already has RC or milestone releases, but is still under active development. We should not expect full stability yet.
* **Experimental** — The project is not yet released, but an important part of the work is already done.
* **Research** — The project is at the design stage, with some sketches of work but nothing usable yet.
* **Concept** — The project is just an idea, development hasn't started yet.
* **Deprecated** — The project is not maintained anymore, and we don't recommend its usage.

## Highlights Projects

Here is the list of some of the highlighted projects that can be used in everyday ZIO development:

1. [ZIO HTTP](https://zio.dev/zio-http): A type-safe, composable, and feature-rich HTTP library built on top of ZIO.
2. [ZIO Config](https://zio.dev/zio-config): A functional type-safe configuration library for ZIO applications.
3. [ZIO Logging](https://zio.dev/zio-logging): A logging library to integrate with different logging backends.
4. [ZIO JSON](https://zio.dev/zio-json): A JSON library to work with JSON data in ZIO applications.
5. [ZIO Schema](https://zio.dev/zio-schema): A library for generating/defining type-safe schemas for custom data types in ZIO applications.
6. [ZIO Quill](https://zio.dev/zio-quill): A library to interact with databases using type-safe queries.
7. [ZIO Kafka](https://zio.dev/zio-kafka): A Kafka client for ZIO and ZIO Streams
8. [ZIO Prelude](https://zio.dev/zio-prelude): A lightweight, distinctly Scala take on functional abstractions, with tight ZIO integration

## Official Libraries

import DocCardList from '@theme/DocCardList';

 <DocCardList />
