#  ___________________________________________________________________________
#
#  Pyomo: Python Optimization Modeling Objects
#  Copyright (c) 2008-2025
#  National Technology and Engineering Solutions of Sandia, LLC
#  Under the terms of Contract DE-NA0003525 with National Technology and
#  Engineering Solutions of Sandia, LLC, the U.S. Government retains certain
#  rights in this software.
#  This software is distributed under the 3-clause BSD License.
#  ___________________________________________________________________________

import pyomo.environ as pyo
from math import pi

model = pyo.ConcreteModel()
# @init:
model.x = pyo.Var(initialize=2.1, bounds=(0, 4))
model.y = pyo.Var(initialize=2.1, bounds=(0, 4))
# @:init


def multimodal(m):
    return (2 - pyo.cos(pi * m.x) - pyo.cos(pi * m.y)) * (m.x**2) * (m.y**2)


model.obj = pyo.Objective(rule=multimodal, sense=pyo.minimize)

status = pyo.SolverFactory('ipopt').solve(model)
pyo.assert_optimal_termination(status)
print(pyo.value(model.x), pyo.value(model.y))
