package knf.kuma.videoservers;

import android.content.Context;
import android.util.Log;

import org.jsoup.Jsoup;

import androidx.annotation.Nullable;
import knf.kuma.commons.PatternUtil;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

import static knf.kuma.videoservers.VideoServer.Names.YOURUPLOAD;

public class YUServer extends Server {
    public YUServer(Context context, String baseLink) {
        super(context, baseLink);
    }

    @Override
    public boolean isValid() {
        return baseLink.contains("server=yu");
    }

    @Override
    public String getName() {
        return YOURUPLOAD;
    }

    @Nullable
    @Override
    public VideoServer getVideoServer() {
        String frame = baseLink.substring(baseLink.indexOf("'") + 1, baseLink.lastIndexOf("'"));
        String redir_link = Jsoup.parse(frame).select("iframe").first().attr("src");
        Log.e("Redir", redir_link);
        try {
            String yu_link = PatternUtil.getYULink(Jsoup.connect(redir_link).get().html());
            String video_link = PatternUtil.getYUvideoLink(Jsoup.connect(yu_link).get().html());
            OkHttpClient client = new OkHttpClient().newBuilder().followRedirects(false).build();
            Request request = new Request.Builder()
                    .url(video_link)
                    .addHeader("Referer", yu_link)
                    .build();
            Response response = client.newCall(request).execute();
            String ref_video_link = response.header("Location");
            response.close();
            Headers headers = new Headers();
            headers.addHeader("Range", "bytes=0-");
            headers.addHeader("Referer", yu_link);
            return new VideoServer(YOURUPLOAD, new Option(getName(), null, ref_video_link, headers));
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}