# Contribute

## Introduction

First, thank you for considering contributing to erxes! It's people like you that make the open source community such a great community! 😊

We welcome any type of contribution, not only code. You can help with 
- **QA**: file bug reports, the more details you can give the better (e.g. screenshots with the console open)
- **Marketing**: writing blog posts, howto's, printing stickers, ...
- **Community**: presenting the project at meetups, organizing a dedicated meetup for the local community, ...
- **Code**: take a look at the [open issues](issues). Even if you can't write code, commenting on them, showing that you care about a given issue matters. It helps us triage them.
- **Money**: we welcome financial contributions in full transparency on our [open collective](https://opencollective.com/erxes).

## Your First Contribution

Working on your first Pull Request? You can learn how from this *free* series, [How to Contribute to an Open Source Project on GitHub](https://egghead.io/series/how-to-contribute-to-an-open-source-project-on-github).

## Submitting code

Any code change should be submitted as a pull request. The description should explain what the code does and give steps to execute it. The pull request should also contain tests.

## Code review process

The bigger the pull request, the longer it will take to review and merge. Try to break down large pull requests in smaller chunks that are easier to review and merge.
It is also always helpful to have some context for your pull request. What was the purpose? Why does it matter to you?

## Financial contributions

We also welcome financial contributions in full transparency on our [open collective](https://opencollective.com/erxes).
Anyone can file an expense. If the expense makes sense for the development of the community, it will be "merged" in the ledger of our open collective by the core contributors and the person who filed the expense will be reimbursed.

## Questions

If you have any questions, create an [issue](issue) (protip: do a quick search first to see if someone else didn't ask the same question before!).
You can also reach us at hello@erxes.opencollective.com.

## Credits

### Swag for Contributions

As of March 2020, we have started **Swag for Contributions** program. To show our appreciation, we are sending everyone who contributes to erxes a special package, which includes a t-shirt and stickers. [Click here](https://erxes.io/hubspot-alternative-erxes-swag) to learn more.

<p align="center">
  <img src="https://erxes.io/static/images/swag.gif" title="erxes Swag"></p>


### Contributors

Thank you to all the people who have already contributed to erxes!
<a href="graphs/contributors"><img src="https://opencollective.com/erxes/contributors.svg?width=890" /></a>


### Backers

Thank you to all our backers! [[Become a backer](https://opencollective.com/erxes#backer)]

<a href="https://opencollective.com/erxes#backers" target="_blank"><img src="https://opencollective.com/erxes/backers.svg?width=890"></a>


### Financial Contributors

Thank you to all our sponsors! (please ask your company to also support this open source project by [becoming a sponsor](https://opencollective.com/erxes/contribute/))

<a href="https://opencollective.com/golomtbank" target="_blank"><img src="https://images.opencollective.com/golomtbank/avatar.png"></a>
<a href="https://opencollective.com/mostmoneymn" target="_blank"><img src="https://images.opencollective.com/mostmoneymn/avatar.png"></a>
<a href="https://opencollective.com/zag-group" target="_blank"><img src="https://images.opencollective.com/zag-group/avatar.png"></a>
<a href="https://opencollective.com/otmongolia" target="_blank"><img src="https://images.opencollective.com/otmongolia/avatar.png"></a>
<a href="https://opencollective.com/mandukhaikhatan" target="_blank"><img src="https://images.opencollective.com/mandukhaikhatan/avatar.png"></a>
<a href="https://opencollective.com/unreadtoday" target="_blank"><img src="https://images.opencollective.com/unreadtoday/avatar.png"></a>
<a href="https://opencollective.com/mandaldaatgal" target="_blank"><img src="https://images.opencollective.com/mandaldaatgal/avatar.png"></a>
<a href="https://opencollective.com/monnisgroup" target="_blank"><img src="https://images.opencollective.com/monnisgroup/avatar.png"></a>
<a href="https://opencollective.com/mongolnewsmn" target="_blank"><img src="https://images.opencollective.com/mongolnewsmn/avatar.png"></a>
<a href="https://opencollective.com/segsgermaa" target="_blank"><img src="https://images.opencollective.com/segsgermaa/avatar.png"></a>

<!-- This `CONTRIBUTING.md` is based on @nayafia's template https://github.com/nayafia/contributing-template -->
