---
id: general-settings
title: General Settings
---

This document details how the system configuration is, what features it includes, how to configure an account, etc.

## General Settings

- General settings include following features:

![](https://s3.us-west-2.amazonaws.com/erxes-docs/general-settings/general1.jpg)

1. Account Default
2. Team Members
3. Properties
4. Import Histories

---

## How to set account default settings:

Set up your prefered language, currency and unit measurement for the system. It will be further used in Deal feature.

- Please follow the steps for setup: General Settings -> Account Default

![](https://s3.us-west-2.amazonaws.com/erxes-docs/general2.png)

\* By choosing your unit of measurement accurately, it will be further used in Deal feature

1. Choose your Language
2. Choose your Currency
3. Choose your Unit of Measurement
4. Save your Account Default

---

## How to invite team members?

### Step 1

Team members are responsible to represent the company as well as to solve problem, engage and manage customers. Invited Team members will be used in the following features: Team Inbox, Insights, Deals, and Messenger

- Please follow the steps for setup: General Settings-> Team Members-> Invite Team Members

![](https://s3.us-west-2.amazonaws.com/erxes-docs/general-settings/general2.jpg)

1. Click Invite Team Members

---

### Step 2

Team members are responsible to represent the company as well as to solve problem, engage and manage customers. Invited Team members will be used in the following features: Team Inbox, Insights, Deals, and Messenger

- Please follow the steps for setup: General Settings-> Team Members-> Invite Team Members

![](https://s3.us-west-2.amazonaws.com/erxes-docs/general-settings/general4.jpg)
![](https://s3.us-west-2.amazonaws.com/erxes-docs/general-settings/general5.jpg)

\* Click “Save” button to invite more team members’. The Invitation will be sent to the team member’s email address

1.  Insert team member’s Email Address
2.  Choose permission group
3.  Invite team member
4.  Invited team member’s status

---

## How to setup new team member?

- Please follow the steps for setup: General Settings-> Team Members-> Edit Team Member

![](https://s3.us-west-2.amazonaws.com/erxes-docs/general6.png)

\*By filling out the team member’s information accurately, It will be further seen in the team Inbox assigned section of the system

1. Upload Team member’s photo
2. Insert Team member’s full name
3. Insert Team member’s username
4. Insert Team member’s short name
5. Team member’s position
6. Insert Team member’s email address
7. Insert location
8. Short bio description of team member
9. Link team member’s social accounts
10. Fill out the other informations
11. Click Save

## How to setup Properties?

### Step 1

![](https://s3.us-west-2.amazonaws.com/erxes-docs/general-settings/general24.png)

User may create a properties to save customers and companies information and save customers and companies database. Following actions are available : Edit, Delete,Transfer unused properties

- Please follow the steps for setup: General Settings->Properties> Customer/Company-> Add Group & Field

1. Click on Customer/Company
2. Click Add Group & Field

### Step 2 How to add Group & Field for Properties?

- Please follow the steps for setup: General Settings->Properties> Customer/Company-> Add Group & Field

![](https://s3.us-west-2.amazonaws.com/erxes-docs/general-settings/general25.png)

1. Insert Group Name
2. Insert Description for group
3. Click Save to create group

![](https://s3.us-west-2.amazonaws.com/erxes-docs/general-settings/general26.png)

1. Insert a property name
2. Insert description for the property
3. Choose group
4. Choose property type
5. Choose property validation
6. Click Save to create property

### Step 3 Created Group & Field Appearance

![](https://s3.us-west-2.amazonaws.com/erxes-docs/general-settings/general27.png)

Customer or companies will fill this property

1. Created Group
2. Created Property under Group

## Permissions

You can specify the user's actions through this permission feature

- Please follow the steps for setup: General Settings-> Permissions

![](https://s3.us-west-2.amazonaws.com/erxes-docs/general-settings/permission1.jpg)

1. Filter by module
2. Filter by action
3. Filter by permission group
4. Filter by user
5. Create new permission
6. View user groups

### Permission groups

![](https://s3.us-west-2.amazonaws.com/erxes-docs/general-settings/permission2.jpg)

1. Create new Permission group
2. Switch to permissions list

### Create Permission

![](https://s3.us-west-2.amazonaws.com/erxes-docs/general-settings/permission3.jpg)

1. Choose module
2. Choose actions
3. Choose permission groups
4. Choose users
5. Allow or decline

### Create user group

![](https://s3.us-west-2.amazonaws.com/erxes-docs/general-settings/permisiion4.jpg)

1. Fill the permission group name
2. Description of the group

# How to setup third party integrations ?

## Setup facebook integration

Integration is a way of communicating with customers who are emerging into the organizations' website, Facebook, Twitter through erxes.io platform. Integration can be created on every brands' social media page. Thence, we would be able to track the percentage of customers who are emerging into the organizations' Facebook page and website form.

- Please follow the steps for setup: General Settings->App Store > Add Facebook

  ![](https://s3-us-west-2.amazonaws.com/erxes-docs/customer-support/customer-support-2.png) 
  ![](https://s3-us-west-2.amazonaws.com/erxes-docs/customer-support/customer-support-3.png)

1. Click Add to connect Facebook
2. Click Add Account

![](https://s3-us-west-2.amazonaws.com/erxes-docs/customer-support/customer-support-4.png)
<br/>
![](https://s3-us-west-2.amazonaws.com/erxes-docs/customer-support/customer-support-5.png)

3. Link your Facebook Account
4. Select all the Pages you manage
5. Click Next

\*Link your Social Account to create Integration

---

## Link facebook account

![](https://s3-us-west-2.amazonaws.com/erxes-docs/customer-support/customer-support-6.png)

6.  Insert name for the Facebook Integration
7.  Choose the Brand for the Integration
8.  Select your Linked Account
9.  Select the Social Pages to link
10. Click Save to link the account

\*Please insert your Account Name as “FB of …”

# Email templates

---

## How to setup Marketing Team Settings

Marketing Team settings include following features:

![](https://erxes-docs.s3-us-west-2.amazonaws.com/marketing-1.PNG)


1. **Email Template**
2. **Email Appearance**

### Setup Email Template

Team members will be able to choose from email templates and send out one message to multiple recipients. You can use the email templates to send out a Mass email for leads/customers or you can send to other team members.

- Please follow the steps for setup: **General Settings** -> **Email Template** -> **New Email Template**

![](https://erxes-docs.s3-us-west-2.amazonaws.com/marketing-2.PNG)


1. Click **New Email Template**
2. **Edit & Delete** Created Email Template

### Add Email Template

- Please follow the steps for setup: **General Settings** -> **Email Template** -> **New Email Template**

![](https://erxes-docs.s3-us-west-2.amazonaws.com/marketing-3.PNG)
.

1. Insert **name** for New Email Template
2. Insert **HTML** of the email template
3. **Click Save**

_Created New Email Template will be used in further Engage feature to send mass email to customers_

### Appearance of Created Email Template

- Please follow the steps for setup: **General Settings** -> **Email Template**

![](https://erxes-docs.s3-us-west-2.amazonaws.com/marketing-4.PNG)

_Created New Email Template will be used in further Engage feature to send mass email to customers_

---

## Email Appearance

![](https://erxes-docs.s3-us-west-2.amazonaws.com/marketing-6.PNG)
![](https://erxes-docs.s3-us-west-2.amazonaws.com/marketing-7.PNG)

1. Choose your **email template type**
2. **Insert** email template HTML
3. **Click Save**

_The email template must be in HTML format_

# Sales Team settings

Sales Team settings include following features:

![](https://erxes-docs.s3-us-west-2.amazonaws.com/sale_board_settings.jpg)

1. **Board & Pipelines**
2. **Product & Service**

---

## Setup Board & Pipeline

Manage your boards and pipelines so that it's easy to manage incoming leads or requests that is adaptable to your team's needs. Add in or delete boards and pipelines to keep business development on track and in check.

- Please follow the steps for setup: **General Settings -> Board & Pipeline> Add Board -> Add Pipeline**

![](https://erxes-docs.s3-us-west-2.amazonaws.com/sale_board.jpg)

1. Click **Add** button to create **Board**
2. Click **Add** button to create **Pipeline**

The Board & Pipeline will be further used in Deal feature

---

### Add Board

- Please follow the steps for setup: **General Settings -> Board & Pipeline> Add Board**

![](https://erxes-docs.s3-us-west-2.amazonaws.com/step_new_addboard.jpg)

1. Click **Add** to create Board
2. **Insert name** for the **Board**
3. Click **Save**

The Board & Pipeline will be further used in Deal feature

---

### Add Pipeline

- Please follow the steps for setup: **General Settings -> Board & Pipeline> Add Board**

![](https://erxes-docs.s3-us-west-2.amazonaws.com/boards_and_pipelines_steps.jpg)

1. Click **Add Pipeline**
2. Insert **Name** for Pipeline
3. Click **Add Stage** for the Pipeline
4. Insert **Name** for the Stage
5. Choose **Percentage** for Stage
6. Click to **Delete** the Stage
7. Click **Save**

---

## Setup Product & Service

All information and know-how related to your business's products and services are found here. Create and add in unlimited products and services so that you and your team members can edit and share.

- Please follow the steps for setup: **General Settings -> Product & Service -> Add Product & Service**

![](https://s3-us-west-2.amazonaws.com/erxes-docs/product_and_service_steps.jpg)

1. Click **Add Product & Service**
2. Insert **Name** for the Product/Service
3. Select **Product/Service type**
4. Insert **Description** for the Product/Service
5. Insert **Stock Keeping Unit** /SKU/
6. Click **Save**

Created Product & Service will be used in Deal section /Add Product & Service/
