---
id: insights
title: Insights
sidebar_label: Insights
---

<!--Content-->

Analyze your employees productivity and usage of the system with Insights. You may export reports by each team member.

Insights include following features:

- Please follow the steps for setup: **Team Inbox -> Insights**

![](https://s3-us-west-2.amazonaws.com/erxes-docs/insights/Insights.png)

1. Volume Report
2. Response Report
3. Response Close Report
4. First Response Report

---

## Volume report

Find feedback that has been gathered from various customer engagement channels. Filter feedbacks by Integrations, Brands and Date

- Please follow the steps for setup: **Team Inbox -> Insights-> Volume Report**

![](https://s3-us-west-2.amazonaws.com/erxes-docs/insights/VolumeReport.jpg)

1. Filter feedbacks by **Integrations, Brands, and Date**
2. Volume Summary by **Days, Weeks, Months, and in Time Range**
3. See Volume Trend by Graph

- You can view your Response Report in a comprehensive way with our Volume Trend

---

- Please follow the steps for setup: **Team Inbox -> Insights-> Response Report**

![](<https://s3-us-west-2.amazonaws.com/erxes-docs/insights/Volume+Report+(2).png>)
![](<https://s3-us-west-2.amazonaws.com/erxes-docs/insights/Volume+Report+(1).png>)

1. Response Report by Time
2. Response Report by Integration

---

## Response report

A report on the total number of customer feedback responses given by team members. Filter feedbacks by Integrations, Brands and Date

- Please follow the steps for setup: **Team Inbox -> Insights-> Response Report**

![](https://s3-us-west-2.amazonaws.com/erxes-docs/insights/ResponceReport.jpg)

1. Filter Response Report by **Integrations, Brands, and by Date**
2. **Response Times** Summary
3. See **Response Trend by Graph**

---

​

- Please follow the steps for setup: **Team Inbox -> Insights-> Response Report**

![](https://s3-us-west-2.amazonaws.com/erxes-docs/insights/Screen+Shot+2019-04-27+at+16.12.29.png)

1. See Response Trend by Graph in Time

---

## Response close report

The average time of a team members solved customer’s problems based on feedback. Filter by Integrations, Brands, and by Date

- Please follow the steps for setup: **Team Inbox -> Insights-> Response Close Report**

![](https://s3-us-west-2.amazonaws.com/erxes-docs/insights/Screen+Shot+2019-04-27+at+16.15.41.png)
![](https://s3-us-west-2.amazonaws.com/erxes-docs/insights/Screen+Shot+2019-04-27+at+16.18.03.png)

1. Filter Response Close Report by **Integrations, Brands, and by Date**
2. Total **Daily Response Close Resolve Rate**
3. Response **Close Report by Team members**

---

## First response report

​
Find stats that defines the average response time by each team member. Filter by Integrations, Brands, and by Date

- Please follow the steps for setup: **Team Inbox -> Insights-> Response Close Report**

![](https://s3-us-west-2.amazonaws.com/erxes-docs/insights/Screen+Shot+2019-04-27+at+16.24.57.jpg)

1. Filter First Response Report by **Integrations, Brands, and by Date**
2. Daily First Response Resolve Report by **Date and Time**
3. View Team members **Daily First Response Resolve Rate**


    * The symbols 0-1/2 represents the time of team member responded twice in first 0 to 2 minutes

---

## Export report

Export Reports within Excel file to analyze your employees productivity and usage of the system with Insights. You can export productivity of your employees with 7 types of report.

- Please follow the steps for setup: **Team Inbox -> Insights-> Export Report**

![](https://s3-us-west-2.amazonaws.com/erxes-docs/insights/Screen+Shot+2019-04-27+at+16.37.27.png)

1. Volume Report by Date
2. Volume Report by Time
3. Operator Activity Report
4. Duration of First Response Report
5. First Response Report by Operators
6. First Response Report by Operator
7. Tag Report

---

Export Reports within Excel file to analyze your employees productivity and usage of the system with Insights. You can export productivity of your employees with 7 types of report.

- Please follow the steps for setup: **Team Inbox -> Insights-> Export Report**

![](https://s3-us-west-2.amazonaws.com/erxes-docs/insights/Screen+Shot+2019-04-27.png)

1. **Export Report**
2. Filter Export Report by **Integrations, Brands, and by Date**
3. Choose **Team Member**
4. **Export Reports**

---

### Export volume report by date

Export Volume Report by Date, feedback that has been gathered from various customer engagement channel. The following exported Volume Report by Date indicates the followings: Conversations by customer count, Customer count, Customer Count Percentage and Conversation message count by **Integration**. Resolved conversation, Average duration of total and Average duration of first response by **Brand**. And, total counts and percentage of customers

- Please follow the steps for setup: **Team Inbox -> Insights-> Export Report-> Click on Volume Report by Date**

![](https://s3-us-west-2.amazonaws.com/erxes-docs/insights/Screen+Shot+2019-04-27+at+17.05.13.png)

---

### Volume report by time

Export Volume Report by Time, feedback that has been gathered from various customer engagement channel. The following exported Volume Report by Time indicates the followings: Conversations by customer count, Customer count, Customer Count Percentage, and Conversation message count by **Integration**. Resolved conversation, Average duration of total and Average duration of first response by **Brand**.

- Please follow the steps for setup: **Team Inbox -> Insights-> Export Report-> Click on Volume Report by Time**

![](https://s3-us-west-2.amazonaws.com/erxes-docs/insights/Screen+Shot+2019-04-27+at+17.11.32.png)

---

### Operator activity report

Export Operator Activity Report. The following exported Operator Activity Report indicates the conversation by the Operators by date. The following exported Operator Activity Report indicates the followings: Conversations by customer filtered by **Integration and Brand**.

- Please follow the steps for setup: **Team Inbox -> Insights-> Export Report-> Click on Operator Activity Report**

![](https://s3-us-west-2.amazonaws.com/erxes-docs/insights/Screen+Shot+2019-04-27+at+17.17.26.png)

- Number of conversations by Operator

---

### Duration of first response report

Duration of First Response Report, feedback that has been gathered from various customer engagement channel. The following exported Duration of First Response Report by team members indicates the followings: Team members duration of first response report by **Integration and Brand**.

- Please follow the steps for setup: **Team Inbox -> Insights-> Export Report-> Click on Operator Activity Report**

![](https://s3-us-west-2.amazonaws.com/erxes-docs/insights/Screen+Shot+2019-04-27+at+17.22.02.png)

- Due to the report, the duration of team members of first response is more 5 minute

---

### First response report by operators

Duration of First Response Report by Operator, feedback that has been gathered from various customer engagement channel. The following exported Duration of First Response Report by team members indicates the followings: First Response Report by Operators by **Integration and Brand**.

- Please follow the steps for setup: **Team Inbox -> Insights-> Export Report-> Click on First Response Report by Operators**

![](https://s3-us-west-2.amazonaws.com/erxes-docs/insights/Screen+Shot+2019-04-27+at+17.27.30.png)

- Number of First Response by Operators

---

### First response report by operator

Duration of First Response Report by Operator, feedback that has been gathered from various customer engagement channel. The following exported Duration of First Response Report by each team member indicates the followings: First Response Report by Operators by **Integration and Brand**.

- Please follow the steps for setup: **Team Inbox -> Insights-> Export Report-> Click on First Response Report by Operators**

![](https://s3-us-west-2.amazonaws.com/erxes-docs/insights/Screen+Shot+2019-04-27+at+17.32.07.png)

- Number of First Response by each Operator

---

### Tag report

Tag report is identified as the number of tags made by team members.

- Please follow the steps for setup: **Team Inbox -> Insights-> Export Report-> Tag Report**

![](https://s3-us-west-2.amazonaws.com/erxes-docs/insights/Screen+Shot+2019-04-27+at+17.36.18.png)

- Number of Tags created by Team Member
