---
id: script-install
title: Script installation
sidebar_label: Script installation
---

<!--Content-->

In the case of web messenger, knowledgebase, popups, you have to install some scripts on your website's code.
In this section, we will demonstrate all the use-cases related to this topic.

---

## Quick installation

Basic steps to install scripts.

### Web messenger

#### Step 1: Copy messenger code

1. Go to Settings menu => Appstore.
2. Click on the “Appstore” menu (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/messenger/i1.png)

3. Then choose your messenger and click on the install code button from the right side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/messenger/i2.png)

4. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/messenger/i3.png)

5. If your website is single page app then you can choose a single-page app and copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/messenger/i4.png)

#### Step 2: Paste the code in your web source

6. Paste the code in bottom of the body tag (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/messenger/i5.png)

#### Step 3: Result

7. Once you have pasted the code, it will look like this in your web right bottom side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/messenger/i6.png)

### Pop-Ups

#### Step 1: Copy pop-ups code

1. Go to Pop-Ups menu from left sidebar (see the below figure).
2. Click on the install code button from the right side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/popup/i1.png)

3. Copy the code (see the below figure)

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/popup/i2.png)

- When you want to set an optional width and height of Popup scaling, it allows 2 flow types namely embedded and pop-ups. Insert code section A and B onto the top of body tag in page of your website.

- If your pop-up flow type is "Embedded", then you can choose the code included in section “A” (see the above figure).

- If your pop-up flow type is "Popup" then you can choose the code section “B” (see the above figure).

- ShoutBox, Dropdown, Slide-in Left, Slide-in Right types are, do not necessary to copy install code.

#### Step 2: Paste the code in your web source

4. Paste the code in bottom of the body tag on every page you want Erxes pop-ups to appear (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/popup/i3.png)

#### Step3: Result

5. Once you have pasted the code, it will look like this in your web (see the below figure)

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/popup/i4.png)

### Knowledgebase

#### Step 1: Copy knowledgebase code

1. Go to Knowledge Base menu from left sidebar (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/kb/i1.png)

2. Then choose the option that named "Manage Knowledgebase" from dropdown menu (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/kb/i2.png)

3. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/kb/i3.png)

- Do not miss to copy the additional source of section “B” and copy it into top of body tag of the source code.

#### Step 2: Paste the code in your web source

4. Paste the code in bottom of body tag on every page you want Erxes knowledge base to appear (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/kb/i4.png)

#### Step3: Result

5. Once you have pasted the code, it will look like this in your web (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/kb/i5.png)

## Google tag manager

Basic steps to install scripts.

### Install google tag manager

1. Log in your google tag manager account.
2. Click on the **Admin** from the dropdown menu, then choose the "Install Google Tag Manager" from the right sidebar (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/1.png)

3. Copy the code as high in the **head** , then paste it onto head tag of every page of your website (see the below figure).
4. Copy the code as high in the **body** , then paste it onto body tag of every page of your website (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/2.png)

5. Paste the code of google tag manager onto the every page of your website (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/3.png)

### Web messenger

#### Step 1: Copy messenger code

1. Go to Settings menu => Appstore.
2. Click on the “Appstore” menu (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/4.png)

3. Then choose your messenger and click on the install code button from the right side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/5.png)

4. Copy the code of Basic Javascript (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/6.png)

#### Step 2: Paste the code in google tag manager

5. Log in your google tag manager account.
6. Click the button “Add a new tag” (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/7.png)

7. Click the Tag Configuration => Custom HTML (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/8.png)

8. Paste the messenger code to Tag Configuration (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/9.png)

9. After paste the code, configure to Triggering for All Pages (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/10.png)

#### Step 3: Result

7. Once you have pasted the code, it will look like this in your web right bottom side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/33.png)

### Pop-Ups

#### Step 1: Copy pop-ups code

1. Log in your Erxes account.
2. Go to Pop-Ups menu from left sidebar (see the below figure).
3. Click the install code button which you created the Pop Ups (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/12.png)

4. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/13.png)

#### Step 2: Paste the code in google tag manager

5. Log in your google tag manager account.
6. Click the button “Add a new tag” (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/14.png)

7. Click the Tag Configuration => Custom HTML (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/15.png)

8. Paste the code of Erxes pop-up (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/16.png)

9. After paste the code, configure to Triggering for All Pages (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/17.png)

10. When you edit again the script on Google tag manager, you have to click SAVE, then SUBMIT and PUBLISH it.

11. If you want to set an optional width and height of Popup scaling, it allows 2 flow types namely embedded and pop-ups. Follow the below steps.

12. Go to Pop-Ups menu from left sidebar (see the below figure).
13. Click on the install code button from the right side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/18.png)

14. Copy the code section A or section B.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/19.png)

- If your pop-up flow type is "Embedded", then you can choose the code included in section “A” (see the above figure).

- If your pop-up flow type is "Popup" then you can choose the code section “B” (see the above figure).

- ShoutBox, Dropdown, Slide-in Left, Slide-in Right types are, do not necessary to copy install code.

15. Paste code onto the body tag of web page source (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/20.png)

#### Step3: Result

16. Once you pasted the code, it will look like this in your web (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/21.png)

If you have encountered some mistakes, please make sure following steps:

1. Verify the flow types and the additional source is right.
2. Check the form id on Google tag manager and verify the form id on the web source.
3. When you edit again the script on Google tag manager, make sure to save it and then submit and publish it.
4. Make sure to configure the trigger in Google tag manager correctly.

### Knowledgebase

#### Step 1: Copy knowledgebase code

1. Log in to your erxes account
2. Go to Knowledge Base menu from left sidebar (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/22.png)

3. Then choose the option that named "Manage Knowledgebase" from dropdown menu (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/23.png)

4. Copy the install code of knowledge base (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/24.png)

#### Step 2: Paste the code in google tag manager

5. Log in to your google tag manager account.
6. Click the button “Add a new tag” (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/25.png)

7. Click the Tag Configuration=> Custom HTML (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/26.png)

8. Paste the code of Erxes knowledge base code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/27.png)

9. After paste the code, configure to Triggering for All Pages (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/28.png)

10. When you edit again the script on Google tag manager, you have to click SAVE, then SUBMIT and PUBLISH it.

11. If you want to set an optional width and height of Knowledgebase scaling, follow the below steps.

12. Go to Knowledge Base menu from left sidebar (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/kb/i1.png)

13. Then choose the option that named "Manage Knowledgebase" from dropdown menu (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/kb/i2.png)

14. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/29.png)

15. Paste the code onto the top of body tag in web page source (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/30.png)

#### Step3: Result

16. Once you pasted the code, it will look like this in your web (see the below figure)

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/32.png)

## Erxes script manager

Basic steps to install Erxes scripts.

### Web messenger

#### Step 1: Copy Script manager code

1. Log in your erxes account.
2. Go to Settings menu => Script manager (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/16.png)

3. Create new script to click NEW SCRIPT (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/17.png)

4. Insert name and select the messenger that you created (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/18.png)

5. Click on the install code button from the list (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/19.png)

6. Copy the code that you created the messenger by clicking COPY TO CLIPBOARD (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/20.png)

#### Step 2: Paste the code onto your script manager

7. Paste the code the top of body tag on every page you want Erxes script manager to appear (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/21.png)

#### Step 3: Result

8. Once you have pasted the code, it will look like this in your web right bottom side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/22.png)

### Pop-Ups

#### Step 1: Copy code of Script manager

1. Log in your erxes account.
2. Go to Settings menu => Script manager.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/23.png)

3. Create new script to click NEW SCRIPT.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/24.png)

4. Insert name and select the POP UPS that you created.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/25.png)

5. Click on the install code button which you created POP UPS from the list (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/26.png)

6. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/27.png)

7. If you want to set an optional width and height of Popup scaling, it allows 2 flow types namely embedded and pop-ups. Go to Pop-ups feature, then select your created pop-ups and click on the install code button from the right side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/28.png)

8. Copy the code and paste it in top of body tag (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/29.png)

- If your pop-up flow type is "Embedded", then you can choose the source included in section “A” (see the above figure).

- If your pop up-flow type is "Popup" then you can choose the source section “B” (see the above figure).

- ShoutBox, Dropdown, Slide-in Left, Slide-in Right types are, do not necessary to copy install code.

#### Step 2: Paste the code onto your script manager

9. Paste the code the bottom of body tag on every page you want Erxes pop-ups to appear (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/30.png)

#### Step3: Result

10. Once you have pasted the code, it will look like this in your web (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/31.png)

### Knowledgebase

#### Step 1: Copy knowledgebase code of Script manager

1. Log in to your erxes account.

2. Go to Settings menu => Script manager.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/32.png)

3. Create new script to click NEW SCRIPT.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/33.png)

4. Insert name and select the KNOWLEDGEBASE TOPIC that you was created before (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/34.png)

5. Click on the install code button which you created KNOWLEDGEBASE TOPIC from the list (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/35.png)

6. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/27.png)

7. If you want to set an optional width and height of Knowledgebase scaling, follow the below steps.

8. Go to Knowledge Base menu from left sidebar (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/kb/i1.png)

9. Then choose the option that named "Manage Knowledgebase" from dropdown menu (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/kb/i2.png)

10. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/29.png)

11. Paste the code onto the top of body tag in web page source (see the below figure).

#### Step 2: Paste the code onto your script manager

12. Paste the script code the bottom of body tag on every page that you want Erxes script manager to appear (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/39.png)

#### Step3: Result

13. Once you have pasted the code, it will look like this in your web (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/40.png)

---

## Advanced setup

Advanced steps to install scripts. Erxes let you enable to track all possible customer fields from messenger.

### Get data from your web app (for logged-in users)

#### Step 1:Copy messenger install code.

1. Go to Settings menu => Appstore.
2. Click on the “Appstore” menu (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/1.Appstore.png)

3. Then choose your messenger and click on the install code button from the right side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/2.+List.png)

4. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/3.+Source+1.png)

5.  If your website is single page app then you can choose a single-page app and copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/4.+Source+2.png)

#### Step 2: Paste the code in the bottom of the body tag (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/5.+Source+3.png)

#### Step 3: If you want to get user information automatically, you can insert additional field under `brand_id` in your messenger script. Insert the messenger script in your web body section. :

```
<script>
  window.erxesSettings = {
    messenger: {
      brand_id: "sNbKdZ",
      email: 'email1111@yahoo.com',
      phone: '88833331111',
      data: {
        avatar: 'https://cdn1.iconfinder.com/data/icons/female-avatars-vol-1/256/female-portrait-avatar-profile-woman-sexy-afro-2-512.png',
        firstName: 'firstName1111',
        lastName: 'lastName1111',
        birthDate: new Date('2020-01-01'),
        sex: 1,
        emailValidationStatus: 'valid',
        position: 'position',
        department: 'department',
        leadStatus: 'working',
        hasAuthority: 'Yes',
        description: 'bio',
        doNotDisturb: 'Yes',
        code: 'id',
        'links.linkedIn': 'http://linkedin.com/test',
        'links.twitter': 'http://twitter.com/test',
        'links.facebook': 'http://facebook.com/test',
        'links.github': 'http://github.com/test',
        'links.youtube': 'http://youtube.com/test',
        'links.website': 'http://website.com/test',

        // custom fields ===========
       // createdAt is reserved field
        updatePlan: new Date('2020-04-25'),
        plan: 'paid',
      },
      companyData: {
        name: 'name',
        'links.website': 'http://website.com',
      },
    },
  };

(function() {
  var script = document.createElement('script');
  script.src = "http://localhost:3200/build/messengerWidget.bundle.js";
  script.async = true;
  var entry = document.getElementsByTagName('script')[0];
  entry.parentNode.insertBefore(script, entry);
})();

</script>

```

#### Step 4: As you can see the user details, all value will be automatically displayed on each field on user profile.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/trackeddata.png)

#### Step 5: Check the custom fields value, it is shown on Tracked data field on left down side.

(see the bellow figure).

```
       // custom fields ===========
       // createdAt is reserved field
        updatePlan: new Date('2020-04-25'),
        plan: 'paid',
```

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/trackeddata1.png)

#### Step 6: Check the companyData value, it is shown on Companied field on upper right side.

(see the above figure).

```
companyData: {
        name: 'name',
        'links.website': 'http://website.com',
      },
```

If you want to get any data of your Web app automatically. You can just write in your source code inside the data section. It will be shown on TRACKED DATA section.

### Manipulate your messenger function

A messenger can be launched programmatically on some user interaction, "like clicking on request for help button". Rather than attaching to document, there should be an option to attach the erxes launcher to a specific element, as it causes the problem in single-page apps since it is not ideal to display the launcher icon in every page.You are now able to manipulate your messenger functions such as change the appearance of a messenger style, a position as well as you can set up the button on your website to call the messenger on specified page.

#### Button submit

Ability to call submit from outside (parent website), which means listen for callSubmit action from outside to force submit action. For example, you can add any button to call action to open your messenger. There is a window.Erxes.showMessenger() function available on the window object. You can use this function to show messenger programmatically. Insert the following script inside your messenger script code.

```
 document.getElementById('button').onclick = () => {
    window.Erxes.showMessenger()
  }
```

First you need uncheck show launcher check to hide default handler. When you check show launcher, the widget section will invisible but you can still callSubmit action to get messenger.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/manipulate1.png)

Insert the following script inside your messenger script code.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/manipulate2.png)

Once you click submit button on your website, messenger will open.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/manipulate.png)

#### Messenger position

As part of the support system inside the web, it is always difficult to fix the position of launcher icon to the bottom, or right left position, especially on mobile, since it overlaps with other elements, especially bottom navbar.

You can manipulate the position of the messenger body like following. The messenger is show left side of your website.

```
<script>
  window.erxesSettings = {
    messenger: {
      brand_id: "AtaT4Z",
      css: `
          .erxes-messenger {
          left: 8px;
          transform-origin: 0% 100%;
          }

          .erxes-launcher {
          left: 8px;
          right: auto;
          }
          `
          },
  };

(function() {
  var script = document.createElement('script');
  script.src = "http://localhost:3200/build/messengerWidget.bundle.js";
  script.async = true;
  var entry = document.getElementsByTagName('script')[0];
  entry.parentNode.insertBefore(script, entry);
})();

</script>
```

#### CSS style

Ability to change form css from parent. In some cases, the developer wants to hide form title, button or modify some auto-generated CSS. Refer the following example of css file.

```
.erxes-embed-iframe {
margin-top: 100px !important;
margin-bottom: 100px !important;
height: 500px !important;
}

#erxes-messenger-container {
left: 0;
}

#erxes-messenger-iframe {
left: 24px;
}

#erxes-messenger-container:after {
left: -300px;
transform: scaleX(-1);
}

#erxes-messenger-container.erxes-messenger-shown:after {
left: -20px;
}

```

The messenger position is now left side.
![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/manipulate3.png)

## Advanced combination installation

In the advanced combination installation is described combination of the following features.

- Messenger + Pop-Ups (or Knowledgebase)
- Messenger + Pop-Ups + Knowledgebase (called M+P+K)
- (M+P+K) + Pop-Ups
- (M+P+K) + Knowledgebase
- (M+P+K) + Pop-Ups + Knowledgebase

### Web messenger + Pop-Ups (or Knowledgebase)

This is the script install instruction of Messenger contains Pop-Ups form or Messenger contains Knowledgebase form. Basic instruction is going through same steps and emphasized steps for difference bewteen Pop-Ups and Knowledbase form in (from 3 to 6).

#### Step 1: Copy messenger code

1. Go to Settings menu => Appstore.
2. You need to make sure the brand name that you created messenger (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/1.png)

**Web messenger + Pop-Ups**

3. Click the Add button of Pop-Ups in order to connect the messenger.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/2.png)

4. Add Pop Ups (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/3.png)

5. Make sure MESSENGER INTEGRATION brand name is same as your created messenger (see the above figure section A and below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/4.png)

6. Make sure POP UPS brand name is same as your created Pop-Ups (see the above figure section B).

**Web messenger + Knowledgebase**

3. Click the Add button of Knowledge Base in order to connect the messenger.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/10.png)

4. Add knowledge base (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/11.png)

5. Make sure MESSENGER INTEGRATION brand name is same as your created messenger (see the above figure section A and below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/12.png)

6. In this case, different brand name of Messenger and Knowledgebase can be run normal.

7. Go to Messenger and click on the install code button from the right side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/5.png)

8. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/6.png)

9. If your website is single page app then you can choose a single-page app and copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/7.png)

#### Step 2: Paste the code in your web source

10. Paste the Messenger script code in the bottom of the body tag. In this case, Messenger + Knowledgebase code is similar to Messenger + Pop-Ups. (see the below figure).

**Messenger+Pop-Ups script code.**

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/8.png)

**Messenger+Knowledgebase script code.**

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/13.png)

#### Step 3: Result

11. Once you have pasted the code, it will look like this in your web right bottom side (see the below figure).
    **Messenger+Pop-Ups**

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/9.png)

**Messenger+Knowledgebase**

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/14.png)

### Web messenger + Pop-Ups + Knowledgebase (M+P+K)

This is the install instruction of Messenger contains Pop-Ups and Knowledgebase form combination (M+P+K). Next following combinations are expanded to this combination which refers to (M+P+K) + Pop-Ups, (M+P+K)+Knowledgebase and (M+P+K)+Knowledgebase+Pop-Ups.

#### Step 1: Copy messenger code

1. Go to Settings menu => Appstore.
2. You need to make sure the brand name that you created messenger (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/1.png)

3. Click the Add button of Knowledge Base in order to connect the messenger.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/10.png)

4. Add knowledge base (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/11.png)

5. Make sure MESSENGER INTEGRATION brand name is same as your created messenger (see the above figure section A and below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/12.png)

6. Then you need to connect Pop-Ups. Click the add button of Pop Ups.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/2.png)

7. Add Pop Ups (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/3.png)

8. Make sure MESSENGER INTEGRATION brand name is same as your created messenger (see the above figure section A and below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/4.png)

9. Make sure POP UPS brand name is same as your created Pop-Ups (see the above figure section B).

10. Go to Messenger and click on the install code button from the right side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/5.png)

11. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/6.png)

12. If your website is single page app then you can choose a single-page app and copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/7.png)

#### Step 2: Paste the code in your web source

13. Paste the code in the bottom of the body tag (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/13.png)

#### Step 3: Result

11. Once you have pasted the code, it will look like this in your web right bottom side (see the below figure). Click the support button to show Pop-Up form.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/14.png)

### (M + P + K) + Pop-Ups

This is the script install instruction of Pop-Ups form with Messenger which contains Pop-Ups and Knowledgebase form.

#### Step 1: Copy messenger code

1. In this combination, first you need to follow the instruction of (M+P+K). Click to the link and check reference.

[**(M + P + K)**](https://docs.erxes.io/user/script-install#web-messenger--pop-ups--knowledgebase-mpk)

2. Go to Pop-Ups menu from left sidebar (see the below figure).
3. Click on the install code button from the right side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/15.png)

4. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/16.png)

- When you want to set an optional width and height of Popup scaling, it allows 2 flow types namely embedded and pop-ups. Insert code section A and B onto the top of body tag in page of your website.

- If your pop-up flow type is "Embedded", then you can choose the code included in section “A” (see the above figure).

- If your pop-up flow type is "Popup" then you can choose the code section “B” (see the above figure).

- ShoutBox, Dropdown, Slide-in Left, Slide-in Right types are, do not necessary to copy install code.

#### Step 2: Paste the code in your web source

5. Paste the code in the bottom of the body tag (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/17.png)

#### Step 3: Result

6. Once you have pasted the code, it will look like this in your web right bottom side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/18.png)

### (M + P + K) + Knowledgebase

This is the script install instruction of Knowledgebase form with Messenger which contains Pop-Ups and Knowledgebase form.

#### Step 1: Copy messenger code

1. In this combination, first you need to follow the instruction of (M+P+K). Click to the link and check reference.

[**(M + P + K)**](https://docs.erxes.io/user/script-install#web-messenger--pop-ups--knowledgebase-mpk)

2. Go to Knowledge Base menu from left sidebar (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/19.png)

3. Then choose the option that named "Manage Knowledgebase" from the dropdown menu (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/20.png)

4. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/21.png)

- Do not miss to copy the additional source of section “B” and copy it into top of body tag of the source code.

#### Step 2: Paste the code in your web source

5. Paste the code in the bottom of the body tag (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/22.png)

#### Step 3: Result

6. Once you have pasted the code, it will look like this in your web right bottom side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/23.png)

### (M + P + K) + Pop-Ups + Knowledgebase

This is the script install instruction of Pop-Ups, Knowledgebase form with Messenger which contains Pop-Ups and Knowledgebase form.

#### Step 1: Copy messenger code

1. In this combination, first you need to follow the instruction of (M+P+K). Click to the link and check reference.

[**(M + P + K)**](https://docs.erxes.io/user/script-install#web-messenger--pop-ups--knowledgebase-mpk)

2. Go to Pop-Ups menu from left sidebar (see the below figure).
3. Click on the install code button from the right side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/15.png)

4. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/16.png)

When you want to set an optional width and height of Popup scaling, it allows 2 flow types namely embedded and pop-ups. Insert code section A and B onto the top of body tag in page of your website.

- If your pop-up flow type is "Embedded", then you can choose the code included in section “A” (see the above figure).
- If your pop-up flow type is "Popup" then you can choose the code section “B” (see the above figure).
- ShoutBox, Dropdown, Slide-in Left, Slide-in Right types are, do not necessary to copy install code.

#### Step 2: Paste the code in your web source

5. Paste the code in the bottom of the body tag (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/17.png)

#### Step 3: Copy the code of Knowledgebase

5. Go to Knowledge Base menu from left sidebar (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/19.png)

6. Then choose the option that named "Manage Knowledgebase" from the dropdown menu (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/20.png)

7. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/21.png)

Do not miss to copy the additional source of section “B” and copy it into top of body tag of the source code.

#### Step 4: Paste the code in your web source

8. Paste the code in the bottom of the body tag (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/24.png)

#### Step 3: Result

9. Once you have pasted the code, it will look like this in your web right bottom side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/7.png)

## Advanced Google tag manager

In the advanced google tag manager installation is described combination of the following features.

- Messenger + Pop-Ups (or Knowledgebase)
- Messenger + Pop-Ups + Knowledgebase (M+P+K)
- (M+P+K) + Pop-Ups
- (M+P+K) + Knowledgebase
- (M+P+K) + Pop-Ups + Knowledgebase

### Install google tag manager

1. Log in your google tag manager account.
2. Click on the **Admin** from the dropdown menu, then choose the "Install Google Tag Manager" from the right sidebar (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/1.png)

3. Copy the code as high in the **head** , then paste it onto head tag of every page of your website (see the below figure).
4. Copy the code as high in the **body** , then paste it onto body tag of every page of your website (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/2.png)

5. Paste the code of google tag manager onto the every page of your website (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/3.png)

### Web messenger + Pop-Ups (or Knowledgebase)

This is the script install instruction of Messenger contains Pop-Ups form or Messenger contains Knowledgebase form in Google tag manager. Basic instruction is going through same steps and emphasized steps for difference bewteen Pop-Ups and Knowledbase form in (3 to 6 and 16 to 20).

#### Step 1: Copy messenger code

1. Go to Settings menu => Appstore.
2. You need to make sure the brand name that you created messenger (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/1.png)

**Web messenger + Pop-Ups**

3. Click the Add button of Pop-Ups in order to connect the messenger.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/2.png)

4. Add Pop Ups (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/3.png)

5. Make sure MESSENGER INTEGRATION brand name is same as your created messenger (see the above figure section A and below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/4.png)

6. Make sure POP UPS brand name is same as your created Pop-Ups (see the above figure section B).

**Web messenger + Knowledgebase**

3. Click the Add button of Knowledge Base in order to connect the messenger.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/10.png)

4. Add knowledge base (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/11.png)

5. Make sure MESSENGER INTEGRATION brand name is same as your created messenger (see the above figure section A and below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/12.png)

6. In this case, different brand name of Messenger and Knowledgebase can be run normal.

7. Go to Messenger and click on the install code button from the right side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/5.png)

8. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/6.png)

9. If your website is single page app then you can choose a single-page app and copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/7.png)

#### Step 2: Paste the code in google tag manager

10. Log in your google tag manager account.
11. Click the button “Add a new tag” (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/14.png)

12. Click the Tag Configuration => Custom HTML (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/15.png)

13. Paste the code of Erxes pop-up (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/16.png)

14. After paste the code, configure to Triggering for All Pages (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/17.png)

15. When you edit again the script on Google tag manager, you have to click SAVE, then SUBMIT and PUBLISH it.

**Messenger+Pop-Ups**

16. If you want to set an optional width and height of Popup scaling, it allows 2 flow types namely embedded and pop-ups. Follow the below steps.

17. Go to Pop-Ups menu from left sidebar (see the below figure).
18. Click on the install code button from the right side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/18.png)

19. Copy the code section A or section B.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/19.png)

- If your pop-up flow type is "Embedded", then you can choose the code included in section “A” (see the above figure).

- If your pop-up flow type is "Popup" then you can choose the code section “B” (see the above figure).

- ShoutBox, Dropdown, Slide-in Left, Slide-in Right types are, do not necessary to copy install code.

20. Paste code onto the body tag of web page source (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/20.png)

**Messenger+Knowledgebase**

16. If you want to set an optional width and height of Knowledgebase scaling, follow the below steps. Go to Knowledge Base menu from left sidebar (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/kb/i1.png)

17. Then choose the option that named "Manage Knowledgebase" from dropdown menu (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/kb/i2.png)

18. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/29.png)

19. Paste the code onto the top of body tag in web page source (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/gtm5.png)

#### Step 3: Result

21. Once you have pasted the code, it will look like this in your web right bottom side (see the below figure).

**Messenger+Pop-Ups**
![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/9.png)

**Messenger+Knowledgebase**

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/14.png)

### Web messenger + Pop-Ups + Knowledgebase (M+P+K)

This is the install instruction of messenger based popup and knowledgebase combination (M+P+K). Next following combinations are expanded to this combination which refers to (M+P+K) + Pop-Ups, (M+P+K)+Knowledgebase and (M+P+K)+Knowledgebase+Pop-Ups.

#### Step 1: Copy messenger code

1. Go to Settings menu => Appstore.
2. You need to make sure the brand name that you created messenger (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/1.png)

3. Click the Add button of Knowledge Base in order to connect the messenger.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/10.png)

4. Add knowledge base (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/11.png)

5. Make sure MESSENGER INTEGRATION brand name is same as your created messenger (see the above figure section A and below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/12.png)

6. Then you need to connect Pop-Ups. Click the add button of Pop Ups.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/2.png)

7. Add Pop Ups (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/3.png)

8. Make sure MESSENGER INTEGRATION brand name is same as your created messenger (see the above figure section A and below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/4.png)

9. Make sure POP UPS brand name is same as your created Pop-Ups (see the above figure section B).

10. Go to Messenger and click on the install code button from the right side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/5.png)

11. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/6.png)

12. If your website is single page app then you can choose a single-page app and copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/7.png)

#### Step 2: Paste the code in google tag manager

13. Log in to your google tag manager account.
14. Click the button “Add a new tag” (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/25.png)

15. Click the Tag Configuration=> Custom HTML (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/26.png)

16. Paste the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/27.png)

17. After paste the code, configure to Triggering for All Pages (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/28.png)

18. When you edit again the script on Google tag manager, you have to click SAVE, then SUBMIT and PUBLISH it.

19. If you want to set an optional width and height of Knowledgebase scaling, follow the below steps.

20. Go to Knowledge Base menu from left sidebar (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/kb/i1.png)

21. Then choose the option that named "Manage Knowledgebase" from dropdown menu (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/kb/i2.png)

22. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/29.png)

23. Paste the code onto the top of body tag in web page source (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/30.png)

24. If you want to set an optional width and height of Popup scaling, it allows 2 flow types namely embedded and pop-ups. Follow the below steps.

25. Go to Pop-Ups menu from left sidebar (see the below figure).
26. Click on the install code button from the right side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/18.png)

27. Copy the code section A or section B.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/19.png)

- If your pop-up flow type is "Embedded", then you can choose the code included in section “A” (see the above figure).

- If your pop-up flow type is "Popup" then you can choose the code section “B” (see the above figure).

- ShoutBox, Dropdown, Slide-in Left, Slide-in Right types are, do not necessary to copy install code.

28. Paste code onto the body tag of web page source (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/gtm4.png)

#### Step 3: Result

29. Once you have pasted the code, it will look like this in your web right bottom side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/14.png)

### (M + P + K) + Pop-Ups

#### Step 1: Copy messenger code

1. In this combination, first you need to follow the instruction of (M+P+K). Click to the link and check reference.

[**(M + P + K)**](https://docs.erxes.io/user/script-install#web-messenger--pop-ups--knowledgebase-mpk-1)

2. Go to Pop-Ups menu from left sidebar (see the below figure).
3. Click on the install code button from the right side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/15.png)

4. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/16.png)

- When you want to set an optional width and height of Popup scaling, it allows 2 flow types namely embedded and pop-ups. Insert code section A and B onto the top of body tag in page of your website.

- If your pop-up flow type is "Embedded", then you can choose the code included in section “A” (see the above figure).

- If your pop-up flow type is "Popup" then you can choose the code section “B” (see the above figure).

- ShoutBox, Dropdown, Slide-in Left, Slide-in Right types are, do not necessary to copy install code.

#### Step 2: Paste the code in google tag manager

10. Log in your google tag manager account.
11. Click the button “Add a new tag” (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/14.png)

12. Click the Tag Configuration => Custom HTML (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/15.png)

13. Paste the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/gtm1.png)

14. After paste the code, configure to Triggering for All Pages (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/17.png)

15. When you edit again the script on Google tag manager, you have to click SAVE, then SUBMIT and PUBLISH it.

16. If you want to set an optional width and height of Popup scaling, it allows 2 flow types namely embedded and pop-ups. Follow the below steps.

17. Go to Pop-Ups menu from left sidebar (see the below figure).
18. Click on the install code button from the right side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/18.png)

19. Copy the code section A or section B.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/19.png)

20. Paste code onto the body tag of web page source (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/20.png)

#### Step 3: Result

21. Once you have pasted the code, it will look like this in your web right bottom side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/18.png)

### (M + P + K) + Knowledgebase

#### Step 1: Copy messenger code

1. In this combination, first you need to follow the instruction of (M+P+K). Click to the link and check reference.

[**(M + P + K)**](https://docs.erxes.io/user/script-install#web-messenger--pop-ups--knowledgebase-mpk-1)

2. Go to Knowledge Base menu from left sidebar (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/19.png)

3. Then choose the option that named "Manage Knowledgebase" from the dropdown menu (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/20.png)

4. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/21.png)

- Do not miss to copy the additional source of section “B” and copy it into top of body tag of the source code.

5. Paste code onto the body tag of web page source (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/gtm5.png)

#### Step 2: Paste the code in google tag manager

6. Log in your google tag manager account.
7. Click the button “Add a new tag” (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/14.png)

8. Click the Tag Configuration => Custom HTML (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/15.png)

9. Paste the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/gtm2.png)

10. After paste the code, configure to Triggering for All Pages (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/17.png)

#### Step 3: Result

11. Once you have pasted the code, it will look like this in your web right bottom side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/23.png)

### (M + P + K) + Pop-Ups + Knowledgebase

#### Step 1: Copy messenger code

1. In this combination, first you need to follow the instruction of (M+P+K). Click to the link and check reference.

[**(M + P + K)**](https://docs.erxes.io/user/script-install#web-messenger--pop-ups--knowledgebase-mpk-1)

2. Go to Pop-Ups menu from left sidebar (see the below figure).
3. Click on the install code button from the right side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/15.png)

4. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/16.png)

When you want to set an optional width and height of Popup scaling, it allows 2 flow types namely embedded and pop-ups. Insert code section A and B onto the top of body tag in page of your website.

- If your pop-up flow type is "Embedded", then you can choose the code included in section “A” (see the above figure).
- If your pop-up flow type is "Popup" then you can choose the code section “B” (see the above figure).
- ShoutBox, Dropdown, Slide-in Left, Slide-in Right types are, do not necessary to copy install code.

#### Step 2: Paste the code in google tag manager

10. Log in your google tag manager account.
11. Click the button “Add a new tag” (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/14.png)

12. Click the Tag Configuration => Custom HTML (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/15.png)

13. Paste the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/gtm1.png)

14. After paste the code, configure to Triggering for All Pages (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/17.png)

15. When you edit again the script on Google tag manager, you have to click SAVE, then SUBMIT and PUBLISH it.

16. If you want to set an optional width and height of Popup scaling, it allows 2 flow types namely embedded and pop-ups. Follow the below steps.

17. Go to Pop-Ups menu from left sidebar (see the below figure).
18. Click on the install code button from the right side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/18.png)

19. Copy the code section A or section B.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/19.png)

20. Paste code onto the body tag of web page source (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/20.png)

#### Step 3: Copy the code of Knowledgebase

21. Go to Knowledge Base menu from left sidebar (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/19.png)

22. Then choose the option that named "Manage Knowledgebase" from the dropdown menu (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/20.png)

23. Copy the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/21.png)

Do not miss to copy the additional source of section “B” and copy it into top of body tag of the source code.

#### Step 4: Paste the code in google tag manager

24. Log in your google tag manager account.
25. Click the button “Add a new tag” (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/14.png)

26. Click the Tag Configuration => Custom HTML (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/15.png)

27. Paste the code (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/gtm3.png)

28. After paste the code, configure to Triggering for All Pages (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/google-tag-manager/17.png)

#### Step 5: Result

29. Once you have pasted the code, it will look like this in your web right bottom side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/25.png)

## Advanced Erxes script manager

In the advanced Erxes script manager installation instruction is described combination of the following features.

- Messenger + Pop-Ups (or Knowledgebase)
- Messenger + Pop-Ups + Knowledgebase (M+P+K)
- (M+P+K) + Pop-Ups
- (M+P+K) + Knowledgebase
- (M+P+K) + Pop-Ups + Knowledgebase

### Web messenger + Pop-Ups (or Knowledgebase)

This is the script install instruction of Messenger contains Pop-Ups form or Messenger contains Knowledgebase form in Erxes script manager.

#### Step 1: Create a messenger contains Pop-Ups or messenger contains knowledgebase.

1. Go to Advanced combination installation => Web messenger + Pop-Ups (or Knowledgebase).

[**Advanced combination installation**](https://docs.erxes.io/user/script-install#web-messenger--pop-ups-or-knowledgebase)

2. Then follow steps number from 1 to 6 of the instruction for Web messenger + Pop-Ups (or Knowledgebase).

#### Step 2: Copy script and paste the code

3. After that, follow the instruction of Erxes script manager => Web messenger. The messenger, you have to select which you created messenger.

[**Erxes script installation**](https://docs.erxes.io/user/script-install#web-messenger-2)

#### Step 3: Result

4. Once you have pasted the code, it will look like this in your web right bottom side (see the below figure).

**Messenger+Pop-Ups**

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/9.png)

**Messenger+Knowledgebase**

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/14.png)

### Web messenger + Pop-Ups + Knowledgebase (M+P+K)

This is the install instruction of messenger based popup and knowledgebase combination (M+P+K). Next following combinations are expanded to this combination which refers to (M+P+K) + Pop-Ups, (M+P+K)+Knowledgebase and (M+P+K)+Knowledgebase+Pop-Ups.

#### Step 1: Create a messenger contains both Pop-Ups and Knowledgebase.

1. Go to Advanced combination installation => Web messenger + Pop-Ups + Knowledgebase.

[**Advanced combination installation**](https://docs.erxes.io/user/script-install#web-messenger--pop-ups--knowledgebase-mpk)

2. Then follow steps number from 1 to 9 of the instruction for Web messenger + Pop-Ups + Knowledgebase.

#### Step 2: Copy script and paste the code

3. After that, follow the instruction of Erxes script manager => Web messenger. The messenger, you have to select which you created messenger.

[**Erxes script installation**](https://docs.erxes.io/user/script-install#web-messenger-2)

#### Step 3: Result

4. Once you have pasted the code, it will look like this in your web right bottom side (see the below figure). Click to FAQ to see Pop-Ups form.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/14.png)

### (M + P + K) + Pop-Ups (or Knowledgebase)

#### Step 1: Copy messenger code

1. In this combination, first you need to follow the Erxes script instruction of (M+P+K). Click to the link and check reference.

[**Erxes Script (M + P + K)**](https://docs.erxes.io/user/script-install#web-messenger--pop-ups--knowledgebase-mpk-2)

2. Go to Settings menu => Script manager (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/16.png)

3. Create new script to click NEW SCRIPT (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/17.png)

**Messenger+ Pop-Ups**

4. Insert name and select the messenger that you created, then select your created Pop-Ups (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/m2.png)

**Messenger+ Knowledgebase**

4. Insert name and select the messenger that you created, then select your created Knowledgebase (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/m4.png)

5. Click on the install code button from the list (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/19.png)

6. Copy the code that you created the messenger by clicking COPY TO CLIPBOARD (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/20.png)

#### Step 2: Paste the code in your web source

7. Paste the code in the bottom of the body tag (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/8.png)

#### Step 3: Result

8. Once you have pasted the code, it will look like this in your web right bottom side (see the below figure).

**Messenger+Pop-Ups**
![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/9.png)

**Messenger+Knowledgebase**

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/14.png)

### (M + P + K) + Pop-Ups + Knowledgebase

#### Step 1: Copy messenger code

1. In this combination, first you need to follow the Erxes script instruction of (M+P+K). Click to the link and check reference.

[**Erxes Script (M + P + K)**](https://docs.erxes.io/user/script-install#web-messenger--pop-ups--knowledgebase-mpk-2)

2. Go to Settings menu => Script manager (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/16.png)

3. Create new script to click NEW SCRIPT (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/17.png)

4. Insert name and select the Messenger, Pop-Ups and Knowledgebase that you created (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/m5.png)

5. Click on the install code button from the list (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/19.png)

6. Copy the code that you created the messenger by clicking COPY TO CLIPBOARD (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/script-manager/20.png)

When you want to set an optional width and height of Popup scaling, it allows 2 flow types namely embedded and pop-ups. Insert code section A and B onto the top of body tag in page of your website.

- If your pop-up flow type is "Embedded", then you can choose the code included in section “A” (see the above figure).
- If your pop-up flow type is "Popup" then you can choose the code section “B” (see the above figure).
- ShoutBox, Dropdown, Slide-in Left, Slide-in Right types are, do not necessary to copy install code.

7. Go to Pop-Ups menu from left sidebar (see the below figure).
8. Click on the install code button from the right side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/15.png)

9. Copy the code of Section A or B depend on Pop-Up type (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/16.png)

Do not miss to copy the additional source of section “B” of Knowledgebase and copy it into top of body tag of the source code.

10. Go to Knowledge Base menu from left sidebar (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/19.png)

11. Then choose the option that named "Manage Knowledgebase" from the dropdown menu (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/20.png)

12. Copy the code of Section B (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/21.png)

#### Step 2: Paste the code in your web source

13. Paste the code in the bottom of the body tag (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/m6.png)

#### Step 3: Result

14. Once you have pasted the code, it will look like this in your web right bottom side (see the below figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/advancedsetup/25.png)

&nbsp;
&nbsp;

## Google Tag Manager Troubleshooting guide

If you have any problems with when installing Google Tag Manager script on specified pages, there are a few troubleshooting steps you can take to check things are set up correctly.
This instruction covers the case that **all web pages contain the messenger and only some specified page contains pop-up script.** Therefore, it is possible to work on other cases, just change the erxes scripts. Following instruction shows how to arrange the erxes scripts on your web pages.

In order to install two script codes on your page, you need to set some triggers on Google tag manager html code.

### Configure trigger on Messenger script:

1. Add trigger on messenger script code in html which you have already configured in Google tag manager.
2. Configure a trigger that messenger does not contains your specified page. In this case, messenger script would be configured on another tag. It is referred to next paragraph for Configure trigger on Messenger + Pop-Up script.

- Trigger Type: **Page View**
- This trigger fires on: **Some page Views**
- Fire this trigger condition should be: **Page URL does not contain your specified page such as (index/index/category/printers** (See the following figure)

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/GMT+troubleshooting/1.png)

3. Then go to tags and selects the trigger that you configured. (See the following figure)

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/GMT+troubleshooting/2.png)

### Configure trigger on Messenger + Pop-Up script:

While messenger script does not contain specified page as above case, you need to configure messenger script with Pop-Ups script. Figure out the following steps.

1. For google tag manager code, you have to paste scripts of both Messenger and Pop-Ups code. (See the following figure)

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/GMT+troubleshooting/3.png)

2. Add trigger on the html code. The code trigger condition contains your specified page.

- Trigger Type: **Page View**
- This trigger fires on: **Some page Views**
- Fire this trigger condition should be: **Page URL contains your specified page such as (index/index/category/printers)** (See the following figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/GMT+troubleshooting/4.png)

4. Then go to tags and selects the trigger that you configured (See the following figure).

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/GMT+troubleshooting/6.png)

5. See the figure for Google tag script with trigger configuration.

![](https://erxes-docs.s3-us-west-2.amazonaws.com/script-installation/GMT+troubleshooting/5.png)
