import Button from 'modules/common/components/Button';
import { TopHeader } from 'modules/common/styles/main';
import { __ } from 'modules/common/utils';
import LeftSidebar from 'modules/layout/components/Sidebar';
import { SidebarList as List } from 'modules/layout/styles';
import React from 'react';
import { Link } from 'react-router-dom';

class Sidebar extends React.Component {
  renderListItem(url: string, text: string) {
    return (
      <li>
        <Link
          to={url}
          className={window.location.href.includes(url) ? 'active' : ''}
        >
          {__(text)}
        </Link>
      </li>
    );
  }

  renderSidebarHeader() {
    return (
      <TopHeader>
        <Link to="/settings/">
          <Button
            btnStyle="simple"
            icon="arrow-circle-left"
            block={true}
            uppercase={false}
          >
            Back to Settings
          </Button>
        </Link>
      </TopHeader>
    );
  }

  render() {
    return (
      <LeftSidebar full={true} header={this.renderSidebarHeader()}>
        <List>
          {this.renderListItem('/settings/general', 'General system config')}
          {this.renderListItem(
            '/settings/integration-configs',
            'Integrations config'
          )}
          {this.renderListItem('/settings/engage-configs', 'Engage config')}
        </List>
      </LeftSidebar>
    );
  }
}

export default Sidebar;
