// Copyright (c) Facebook, Inc. and its affiliates.
// This source code is licensed under the MIT license found in the
// LICENSE file in the root directory of this source tree.

#ifndef ESP_GFX_RENDERER_H_
#define ESP_GFX_RENDERER_H_

#include "esp/core/esp.h"
#include "esp/gfx/RenderCamera.h"
#include "esp/scene/SceneGraph.h"
#include "esp/sensor/VisualSensor.h"

namespace esp {
namespace gfx {

class Renderer {
 public:
  enum class Flag {
    NoTextures = 1 << 0,
  };

  typedef Corrade::Containers::EnumSet<Flag> Flags;
  CORRADE_ENUMSET_FRIEND_OPERATORS(Flags)

  /**
   * @brief Constructor
   */
  explicit Renderer(Flags flags = {});

  // draw the scene graph with the camera specified by user
  void draw(RenderCamera& camera,
            scene::SceneGraph& sceneGraph,
            RenderCamera::Flags flags = {RenderCamera::Flag::FrustumCulling});

  // draw the scene graph with the visual sensor provided by user
  void draw(sensor::VisualSensor& visualSensor,
            scene::SceneGraph& sceneGraph,
            RenderCamera::Flags flags = {RenderCamera::Flag::FrustumCulling});

  /**
   * @brief Binds a @ref RenderTarget to the sensor
   */
  void bindRenderTarget(sensor::VisualSensor& sensor);

  // draw the scene graph with the default camera in scene graph
  // user needs to set the default camera so that it has correct
  // modelview matrix, projection matrix to render the scene
  // See setDefaultRenderCamera(...) in SceneGraph for more details
  // void draw(scene::SceneGraph& sceneGraph);

  ESP_SMART_POINTERS_WITH_UNIQUE_PIMPL(Renderer)
};

}  // namespace gfx
}  // namespace esp

#endif  // ESP_GFX_RENDERER_H_
