// Copyright (c) Facebook, Inc. and its affiliates.
// This source code is licensed under the MIT license found in the
// LICENSE file in the root directory of this source tree.

#ifndef ESP_SCENE_SUNCGOBJECTCATEGORYMAP_H_
#define ESP_SCENE_SUNCGOBJECTCATEGORYMAP_H_

#include <map>
#include <string>
#include <utility>

namespace esp {
namespace scene {

//! map from SUNCG object model id to category set (comma separated)
// NOTE: This is the model id to category mapping from SUNCG v2.1
static const std::map<std::string, std::string> kSuncgObjectCategoryMap = {
    {"100", "hanger"},
    {"101", "kitchen_cabinet,range_oven"},
    {"102", "kitchen_appliance,refrigerator"},
    {"104", "desk"},
    {"105", "desk"},
    {"106", "chair,office_chair"},
    {"107", "desk"},
    {"108", "desk"},
    {"109", "table,coffee_table"},
    {"110", "television"},
    {"111", "television"},
    {"112", "television"},
    {"113", "television"},
    {"114", "television"},
    {"115", "tv_stand"},
    {"116", "tv_stand"},
    {"117", "tv_stand"},
    {"118", "hanger"},
    {"119", "table,coffee_table"},
    {"120", "computer,laptop"},
    {"121", "wardrobe_cabinet"},
    {"122", "door"},
    {"122_0", "door"},
    {"122_2", "door"},
    {"123", "hanger"},
    {"124", "indoor_lamp,wall_lamp"},
    {"125", "kitchen_cabinet,kitchen_sink"},
    {"126", "window"},
    {"127", "indoor_lamp,wall_lamp"},
    {"128", "stand,nightstand"},
    {"129", "dresser"},
    {"130", "plant"},
    {"131", "kitchen_appliance,refrigerator"},
    {"132", "sink"},
    {"133", "door"},
    {"133_0", "door"},
    {"133_2", "door"},
    {"134", "table_and_chair"},
    {"135", "shower"},
    {"136", "toy,fish_tank"},
    {"137", "kitchen_cabinet,kitchen_sink"},
    {"138", "kitchen_cabinet,kitchen_sink"},
    {"139", "shower"},
    {"140", "dresser"},
    {"141", "dressing_table"},
    {"142", "chair,straight_chair"},
    {"143", "music,piano"},
    {"144", "mirror"},
    {"145", "shoes_cabinet"},
    {"146", "stand,nightstand"},
    {"147", "stand,nightstand"},
    {"148", "books,book"},
    {"149", "kitchenware,cup"},
    {"150", "toilet,bidet"},
    {"151", "stairs"},
    {"152", "stairs"},
    {"153", "rug"},
    {"154", "kitchenware,pan"},
    {"155", "sofa"},
    {"156", "sofa"},
    {"157", "sofa"},
    {"166", "chair,armchair"},
    {"167", "sofa"},
    {"168", "sofa"},
    {"169", "chair,armchair,sofa_chair"},
    {"170", "sofa"},
    {"171", "table,coffee_table"},
    {"172", "table,coffee_table"},
    {"173", "table,coffee_table"},
    {"174", "table,coffee_table"},
    {"175", "indoor_lamp,wall_lamp"},
    {"176", "indoor_lamp,wall_lamp"},
    {"178", "indoor_lamp,wall_lamp"},
    {"179", "indoor_lamp,wall_lamp"},
    {"180", "indoor_lamp,wall_lamp"},
    {"181", "sink"},
    {"182", "wardrobe_cabinet"},
    {"183", "sink"},
    {"184", "wardrobe_cabinet"},
    {"185", "recreation,game_table"},
    {"186", "sink"},
    {"187", "wardrobe_cabinet"},
    {"188", "shelving"},
    {"189", "computer"},
    {"190", "bed,baby_bed"},
    {"191", "shelving,bookshelf"},
    {"192", "shelving"},
    {"193", "shelving"},
    {"194", "wardrobe_cabinet"},
    {"195", "stand,nightstand"},
    {"196", "chair,armchair"},
    {"197", "stand,nightstand"},
    {"198", "tv_stand"},
    {"199", "dressing_table"},
    {"200", "dressing_table"},
    {"201", "dressing_table"},
    {"202", "dressing_table"},
    {"203", "dressing_table"},
    {"204", "bed,double_bed"},
    {"205", "bed,double_bed"},
    {"206", "kitchen_appliance,water_dispenser"},
    {"207", "shelving,wall_shelf"},
    {"208", "hanger"},
    {"209", "window"},
    {"210", "window"},
    {"211", "window"},
    {"212", "window"},
    {"213", "window"},
    {"214", "door"},
    {"214_0", "door"},
    {"214_2", "door"},
    {"215", "television"},
    {"216", "television"},
    {"217", "hanger"},
    {"218", "music,stereo_set"},
    {"219", "kitchen_appliance,dishwasher"},
    {"220", "kitchen_appliance,food_processor"},
    {"221", "kitchen_appliance,coffee_machine"},
    {"222", "kitchen_appliance,microwave"},
    {"223", "household_appliance,vacuum_cleaner"},
    {"224", "household_appliance,iron"},
    {"225", "air_conditioner"},
    {"226", "fan,pedestal_fan"},
    {"227", "air_conditioner"},
    {"228", "television"},
    {"229", "bathroom_stuff,towel_rack"},
    {"230", "heater"},
    {"232", "kitchen_cabinet,kitchen_sink"},
    {"233", "stand,nightstand"},
    {"235", "rug"},
    {"236", "picture_frame"},
    {"237", "plant"},
    {"238", "rug"},
    {"239", "mirror"},
    {"240", "indoor_lamp,floor_lamp"},
    {"241", "kitchen_appliance,range_hood"},
    {"242", "fireplace"},
    {"243", "kitchenware,bottle,drink"},
    {"244", "kitchenware,glass"},
    {"245", "kitchenware,cutting_board,food"},
    {"246", "door"},
    {"246_0", "door"},
    {"246_2", "door"},
    {"247", "door"},
    {"247_0", "door"},
    {"247_2", "door"},
    {"248", "shelving"},
    {"249", "chair,straight_chair"},
    {"250", "hanging_kitchen_cabinet"},
    {"251", "hanging_kitchen_cabinet"},
    {"252", "table,dining_table"},
    {"253", "stairs"},
    {"254", "stairs"},
    {"255", "chair,straight_chair"},
    {"256", "indoor_lamp,table_lamp"},
    {"257", "picture_frame"},
    {"258", "vase"},
    {"259", "sofa"},
    {"260", "sofa"},
    {"261", "chair,armchair,sofa_chair"},
    {"262", "chair,armchair,sofa_chair"},
    {"263", "household_appliance,ironing_board"},
    {"264", "kitchen_appliance,range_oven"},
    {"265", "kitchenware,beer,drink"},
    {"266", "wardrobe_cabinet"},
    {"267", "wardrobe_cabinet"},
    {"268", "shelving"},
    {"269", "wardrobe_cabinet"},
    {"270", "bed,bunker_bed"},
    {"271", "wardrobe_cabinet"},
    {"272", "wardrobe_cabinet"},
    {"273", "desk"},
    {"274", "wardrobe_cabinet"},
    {"275", "curtain"},
    {"276", "curtain,blinds"},
    {"277", "chair,straight_chair"},
    {"278", "music,loudspeaker"},
    {"279", "switch"},
    {"280", "switch"},
    {"281", "kitchen_cabinet,short_kitchen_cabinet"},
    {"282", "kitchen_cabinet,short_kitchen_cabinet"},
    {"283", "kitchen_cabinet,range_oven"},
    {"284", "kitchen_cabinet,short_kitchen_cabinet"},
    {"285", "kitchen_cabinet,kitchen_sink"},
    {"286", "hanging_kitchen_cabinet"},
    {"287", "hanging_kitchen_cabinet"},
    {"288", "kitchen_cabinet,tall_kitchen_cabinet"},
    {"289", "kitchen_cabinet,tall_kitchen_cabinet"},
    {"290", "kitchen_cabinet,short_kitchen_cabinet"},
    {"291", "kitchen_cabinet,short_kitchen_cabinet"},
    {"292", "shoes_cabinet"},
    {"293", "shelving"},
    {"294", "desk"},
    {"295", "kitchen_cabinet,kitchen_sink"},
    {"311", "stand,nightstand"},
    {"312", "stand,nightstand"},
    {"313", "clock"},
    {"314", "mirror"},
    {"315", "stand,nightstand"},
    {"316", "hanging_kitchen_cabinet"},
    {"317", "hanging_kitchen_cabinet"},
    {"318", "stand,nightstand"},
    {"319", "books"},
    {"320", "books"},
    {"321", "sofa"},
    {"322", "toy"},
    {"323", "person"},
    {"324", "person"},
    {"325", "person"},
    {"326", "door"},
    {"327", "door"},
    {"328", "partition"},
    {"329", "partition"},
    {"330", "partition"},
    {"331", "door"},
    {"333", "person"},
    {"334", "fireplace"},
    {"335", "chair,office_chair"},
    {"336", "chair"},
    {"337", "gym_equipment"},
    {"338", "gym_equipment"},
    {"339", "gym_equipment"},
    {"340", "toy,chessboard"},
    {"341", "toy,fish_tank"},
    {"342", "toy,fishbowl"},
    {"343", "kitchenware,kettle"},
    {"344", "kitchenware,kettle"},
    {"345", "toy,playstation"},
    {"346", "person"},
    {"347", "chair,armchair"},
    {"348", "chair,armchair"},
    {"349", "chair,armchair"},
    {"350", "sofa"},
    {"351", "chair,armchair"},
    {"352", "chair,armchair"},
    {"353", "toy"},
    {"354", "headstone"},
    {"355", "coffin"},
    {"356", "toy"},
    {"357", "toy"},
    {"358", "toy"},
    {"359", "toy"},
    {"360", "sofa"},
    {"361", "garage_door"},
    {"361_0", "garage_door"},
    {"362", "decoration"},
    {"363", "vehicle,motorcycle"},
    {"364", "vehicle,car"},
    {"365", "column"},
    {"366", "column"},
    {"367", "column"},
    {"368", "fence"},
    {"369", "fence"},
    {"370", "fence"},
    {"371", "fence"},
    {"372", "fence"},
    {"373", "fence"},
    {"374", "fence"},
    {"375", "fence"},
    {"376", "fence"},
    {"377", "outdoor_lamp"},
    {"378", "outdoor_lamp"},
    {"379", "fence"},
    {"380", "sofa"},
    {"381", "outdoor_lamp"},
    {"382", "sofa"},
    {"383", "wardrobe_cabinet"},
    {"384", "wardrobe_cabinet"},
    {"385", "wardrobe_cabinet"},
    {"386", "wardrobe_cabinet"},
    {"387", "wardrobe_cabinet"},
    {"388", "wardrobe_cabinet"},
    {"389", "wardrobe_cabinet"},
    {"390", "shelving"},
    {"391", "wardrobe_cabinet"},
    {"392", "tv_stand"},
    {"393", "shelving"},
    {"394", "outdoor_lamp"},
    {"395", "kitchenware,trash_can"},
    {"396", "stand,nightstand"},
    {"397", "dresser"},
    {"398", "dresser"},
    {"399", "wardrobe_cabinet"},
    {"40", "table,dining_table"},
    {"403", "bed,double_bed"},
    {"404", "stand,nightstand"},
    {"405", "kitchen_cabinet,large_kitchen_cabinet"},
    {"406", "hanging_kitchen_cabinet"},
    {"407", "kitchen_cabinet,short_kitchen_cabinet"},
    {"408", "kitchen_cabinet,kitchen_island"},
    {"409", "chair,stool"},
    {"41", "table,coffee_table"},
    {"410", "recreation,basketball_hoop"},
    {"411", "outdoor_seating,porch_swing"},
    {"412", "outdoor_seating,swing"},
    {"413", "grill"},
    {"414", "chair,lounge_chair"},
    {"415", "chair,office_chair"},
    {"416", "wardrobe_cabinet"},
    {"417", "desk"},
    {"418", "toilet"},
    {"419", "indoor_lamp,table_lamp"},
    {"42", "wardrobe_cabinet"},
    {"420", "sofa"},
    {"421", "indoor_lamp,table_lamp"},
    {"422", "indoor_lamp,table_lamp"},
    {"423", "indoor_lamp,table_lamp"},
    {"424", "desk"},
    {"425", "chair,armchair"},
    {"426", "chair,armchair"},
    {"427", "chair,armchair"},
    {"428", "desk"},
    {"429", "chair,stool"},
    {"43", "household_appliance,dryer"},
    {"430", "desk"},
    {"431", "dresser"},
    {"432", "gym_equipment"},
    {"433", "bench_chair"},
    {"434", "gym_equipment"},
    {"435", "gym_equipment"},
    {"436", "gym_equipment"},
    {"437", "gym_equipment"},
    {"438", "gym_equipment"},
    {"439", "gym_equipment"},
    {"44", "household_appliance"},
    {"440", "bench_chair"},
    {"441", "chair,straight_chair"},
    {"442", "table,dining_table"},
    {"443", "toilet,urinal"},
    {"444", "toilet,urinal"},
    {"445", "shoes_cabinet"},
    {"446", "chair,straight_chair"},
    {"447", "sink"},
    {"448", "shelving"},
    {"449", "chair,armchair,sofa_chair"},
    {"45", "hanging_kitchen_cabinet"},
    {"450", "chair,straight_chair"},
    {"451", "tv_stand"},
    {"452", "table,dining_table"},
    {"453", "toilet,bidet"},
    {"454", "tv_stand"},
    {"455", "desk"},
    {"456", "shelving"},
    {"457", "shelving"},
    {"458", "shelving,wall_shelf"},
    {"459", "shelving,wall_shelf"},
    {"46", "hanging_kitchen_cabinet"},
    {"460", "toy"},
    {"461", "toy"},
    {"462", "toy"},
    {"463", "plant"},
    {"464", "dresser"},
    {"465", "bathtub"},
    {"466", "bench_chair"},
    {"467", "chair,lounge_chair"},
    {"468", "table,coffee_table"},
    {"469", "dresser"},
    {"470", "table,coffee_table"},
    {"471", "chair,armchair,sofa_chair"},
    {"472", "table,coffee_table"},
    {"473", "sofa"},
    {"474", "table"},
    {"475", "bench_chair"},
    {"476", "bench_chair"},
    {"477", "desk"},
    {"478", "bench_chair"},
    {"479", "shoes_cabinet"},
    {"480", "dresser"},
    {"481", "wardrobe_cabinet"},
    {"482", "shelving,bookshelf"},
    {"483", "stairs"},
    {"484", "workplace,double_desk"},
    {"485", "desk"},
    {"486", "desk"},
    {"487", "desk"},
    {"488", "stand"},
    {"489", "stand,nightstand"},
    {"490", "stand,nightstand"},
    {"491", "chair,armchair"},
    {"492", "shelving,wall_shelf"},
    {"493", "shelving,wall_shelf"},
    {"494", "desk"},
    {"495", "tv_stand"},
    {"496", "chair,folding_chair"},
    {"497", "partition"},
    {"498", "partition"},
    {"499", "bathroom_stuff,towel_rack"},
    {"500", "chair,straight_chair"},
    {"501", "chair,straight_chair"},
    {"502", "partition"},
    {"502_2", "partition"},
    {"503", "wardrobe_cabinet"},
    {"504", "table,dining_table"},
    {"505", "shelving,wall_shelf"},
    {"506", "desk"},
    {"507", "chair,armchair_with_ottoman"},
    {"508", "shelving"},
    {"509", "dresser"},
    {"510", "heater"},
    {"511", "chair,armchair"},
    {"512", "wardrobe_cabinet"},
    {"513", "stand,nightstand"},
    {"514", "desk"},
    {"515", "indoor_lamp,table_lamp"},
    {"516", "chair,office_chair"},
    {"517", "indoor_lamp,floor_lamp"},
    {"518", "whiteboard"},
    {"519", "fireplace"},
    {"520", "indoor_lamp,floor_lamp"},
    {"521", "indoor_lamp,floor_lamp"},
    {"522", "music,piano"},
    {"523", "indoor_lamp,floor_lamp"},
    {"524", "indoor_lamp,floor_lamp"},
    {"525", "table,dining_table"},
    {"526", "hanger"},
    {"527", "towel_hanger"},
    {"528", "kitchen_cabinet,tall_kitchen_cabinet"},
    {"529", "vase"},
    {"530", "kitchenware,plates"},
    {"531", "candle"},
    {"532", "chair,office_chair"},
    {"533", "desk"},
    {"534", "stand"},
    {"535", "chair,armchair"},
    {"536", "kitchenware,utensil_holder"},
    {"537", "kitchen_appliance,food_processor"},
    {"538", "kitchenware,knife_rack"},
    {"539", "kitchenware,coffee_kettle"},
    {"540", "toy"},
    {"541", "ottoman"},
    {"542", "table,coffee_table"},
    {"543", "table,coffee_table"},
    {"544", "ottoman"},
    {"545", "ottoman"},
    {"546", "table,coffee_table"},
    {"547", "ottoman"},
    {"548", "ottoman"},
    {"549", "table,coffee_table"},
    {"550", "table,coffee_table"},
    {"551", "table,coffee_table"},
    {"552", "table,coffee_table"},
    {"553", "ottoman"},
    {"554", "ottoman"},
    {"555", "table,coffee_table"},
    {"556", "table,coffee_table"},
    {"557", "ottoman"},
    {"558", "ottoman"},
    {"559", "ottoman"},
    {"560", "ottoman"},
    {"561", "table,coffee_table"},
    {"562", "pool"},
    {"563", "table,coffee_table"},
    {"564", "table,coffee_table"},
    {"565", "table,coffee_table"},
    {"566", "table,coffee_table"},
    {"567", "table,coffee_table"},
    {"568", "table,coffee_table"},
    {"569", "table,coffee_table"},
    {"57", "sofa"},
    {"570", "tv_stand"},
    {"577", "tv_stand"},
    {"579", "table,coffee_table"},
    {"580", "table,coffee_table"},
    {"586", "table,coffee_table"},
    {"587", "table,coffee_table"},
    {"589", "table,coffee_table"},
    {"590", "tv_stand"},
    {"591", "table,coffee_table"},
    {"592", "table,coffee_table"},
    {"593", "kitchen_cabinet,range_oven_with_hood"},
    {"594", "kitchen_cabinet,kitchen_sink_with_hanging_kitchen_cabinet"},
    {"595", "kitchen_cabinet,kitchen_sink_with_hanging_kitchen_cabinet"},
    {"596", "kitchen_cabinet,tall_kitchen_cabinet"},
    {"597", "kitchen_cabinet,tall_kitchen_cabinet"},
    {"598",
     "kitchen_cabinet,short_kitchen_cabinet_with_hanging_kitchen_cabinet"},
    {"599",
     "kitchen_cabinet,short_kitchen_cabinet_with_hanging_kitchen_cabinet"},
    {"60", "bathtub"},
    {"600",
     "kitchen_cabinet,short_kitchen_cabinet_with_hanging_kitchen_cabinet"},
    {"601",
     "kitchen_cabinet,short_kitchen_cabinet_with_hanging_kitchen_cabinet"},
    {"602",
     "kitchen_cabinet,short_kitchen_cabinet_with_hanging_kitchen_cabinet"},
    {"603",
     "kitchen_cabinet,short_kitchen_cabinet_with_hanging_kitchen_cabinet"},
    {"604",
     "kitchen_cabinet,short_kitchen_cabinet_with_hanging_kitchen_cabinet"},
    {"605", "bench_chair"},
    {"606", "wardrobe_cabinet"},
    {"607", "shelving"},
    {"608", "tv_stand"},
    {"609", "wardrobe_cabinet"},
    {"610", "wardrobe_cabinet"},
    {"611", "wardrobe_cabinet"},
    {"612", "shelving"},
    {"613", "wardrobe_cabinet"},
    {"614", "wardrobe_cabinet"},
    {"615", "dresser"},
    {"616", "tv_stand"},
    {"617", "tv_stand"},
    {"618", "tv_stand"},
    {"620", "plant"},
    {"621", "curtain"},
    {"622", "curtain"},
    {"623", "plant"},
    {"624", "plant"},
    {"625", "curtain"},
    {"626", "indoor_lamp,chandelier"},
    {"627", "indoor_lamp,chandelier"},
    {"628", "indoor_lamp,chandelier"},
    {"629", "indoor_lamp,chandelier"},
    {"63", "sofa"},
    {"630", "indoor_lamp,chandelier"},
    {"631", "indoor_lamp,chandelier"},
    {"632", "indoor_lamp,chandelier"},
    {"633", "indoor_lamp,chandelier"},
    {"634", "plant"},
    {"635", "pool"},
    {"636", "indoor_lamp,chandelier"},
    {"637", "plant"},
    {"638", "kitchen_appliance,small_refrigerator"},
    {"639", "kitchen_appliance,small_refrigerator"},
    {"64", "sofa"},
    {"640", "kitchen_appliance,small_refrigerator"},
    {"641", "ATM"},
    {"645", "sofa"},
    {"646", "chair,armchair,sofa_chair"},
    {"647", "ottoman"},
    {"648", "toy"},
    {"649", "indoor_lamp,chandelier"},
    {"650", "fan,ceiling_fan"},
    {"651", "toy,xbox"},
    {"652", "kitchen_cabinet,kitchen_island"},
    {"653", "kitchen_cabinet,kitchen_island"},
    {"654", "table,dining_table"},
    {"655", "table,dining_table"},
    {"656", "table,dining_table"},
    {"657", "kitchen_cabinet,short_kitchen_cabinet"},
    {"658", "kitchen_cabinet,tall_kitchen_cabinet_with_oven"},
    {"659", "hanging_kitchen_cabinet"},
    {"660", "hanging_kitchen_cabinet"},
    {"661", "kitchen_appliance,range_hood"},
    {"662", "kitchen_cabinet,range_oven"},
    {"663", "kitchen_cabinet,kitchen_sink"},
    {"664", "table,dining_table"},
    {"665", "kitchen_cabinet,tall_kitchen_cabinet_with_oven"},
    {"666", "kitchen_cabinet,tall_kitchen_cabinet"},
    {"667", "hanging_kitchen_cabinet"},
    {"668", "hanging_kitchen_cabinet"},
    {"669", "kitchen_cabinet,short_kitchen_cabinet"},
    {"67", "chair,armchair,sofa_chair"},
    {"670", "kitchen_cabinet,kitchen_sink"},
    {"671", "kitchen_cabinet,range_with_hood"},
    {"672", "kitchen_cabinet,short_kitchen_cabinet"},
    {"673", "kitchen_cabinet,kitchen_island_with_range_hood_and_table"},
    {"674", "shelving"},
    {"675", "table,dining_table"},
    {"676", "table,dining_table"},
    {"677", "chair,office_chair"},
    {"678", "kitchenware,fruit_bowl,food"},
    {"679", "picture_frame"},
    {"680", "picture_frame"},
    {"681", "picture_frame"},
    {"682", "bench_chair"},
    {"683", "indoor_lamp,table_lamp"},
    {"684", "indoor_lamp,table_lamp"},
    {"685", "indoor_lamp,table_lamp"},
    {"686", "recreation,goal_post"},
    {"687", "pet,cat"},
    {"688", "pet,cat"},
    {"689", "pet,cat"},
    {"69", "chair,armchair,sofa_chair"},
    {"690", "sofa"},
    {"691", "outdoor_lamp"},
    {"692", "sofa"},
    {"693", "chair,armchair,sofa_chair"},
    {"694", "workplace,double_desk_with_chairs"},
    {"695", "workplace,double_desk_with_chairs"},
    {"696", "table_and_chair"},
    {"697", "table_and_chair"},
    {"698", "table_and_chair"},
    {"699", "table_and_chair"},
    {"70", "chair,armchair_with_ottoman"},
    {"700", "sofa"},
    {"701", "table_and_chair"},
    {"702", "pool"},
    {"703", "outdoor_seating"},
    {"704", "outdoor_seating"},
    {"705", "table_and_chair"},
    {"706", "outdoor_seating,porch_swing"},
    {"707", "outdoor_seating"},
    {"708", "outdoor_seating,hammock"},
    {"709", "chair,armchair"},
    {"71", "table,coffee_table"},
    {"710", "chair,armchair"},
    {"711", "chair,folding_chair"},
    {"712", "chair,folding_chair"},
    {"713", "table,coffee_table"},
    {"714", "table,coffee_table"},
    {"715", "table,coffee_table"},
    {"716", "table,coffee_table"},
    {"717", "plant"},
    {"718", "plant"},
    {"719", "plant"},
    {"720", "plant"},
    {"721", "plant"},
    {"722", "fence"},
    {"723", "plant"},
    {"724", "plant"},
    {"725", "plant"},
    {"726", "plant"},
    {"727", "plant"},
    {"728", "plant"},
    {"729", "pool"},
    {"73", "door"},
    {"73_0", "door"},
    {"73_2", "door"},
    {"730", "pool"},
    {"731", "plant"},
    {"732", "plant"},
    {"733", "plant"},
    {"734", "plant"},
    {"735", "plant"},
    {"736", "plant"},
    {"737", "plant"},
    {"738", "plant"},
    {"739", "plant"},
    {"74", "sink"},
    {"740", "plant"},
    {"741", "plant"},
    {"742", "plant"},
    {"743", "outdoor_cover,umbrella"},
    {"744", "outdoor_cover,umbrella"},
    {"745", "sofa"},
    {"746", "outdoor_cover,umbrella"},
    {"747", "curtain,blinds"},
    {"748", "curtain,blinds"},
    {"749", "outdoor_cover,umbrella"},
    {"75", "bed,double_bed"},
    {"750", "curtain,blinds"},
    {"751", "curtain,blinds"},
    {"752", "window"},
    {"753", "window"},
    {"754", "window"},
    {"755", "window"},
    {"756", "door"},
    {"756_0", "door"},
    {"756_2", "door"},
    {"757", "door"},
    {"757_0", "door"},
    {"757_2", "door"},
    {"758", "door"},
    {"758_0", "door"},
    {"758_2", "door"},
    {"759", "door"},
    {"759_0", "door"},
    {"759_2", "door"},
    {"760", "door"},
    {"760_0", "door"},
    {"760_2", "door"},
    {"761", "door"},
    {"761_0", "door"},
    {"761_2", "door"},
    {"762", "door"},
    {"762_0", "door"},
    {"762_2", "door"},
    {"763", "door"},
    {"763_0", "door"},
    {"763_2", "door"},
    {"764", "door"},
    {"764_0", "door"},
    {"764_2", "door"},
    {"765", "garage_door"},
    {"765_0", "garage_door"},
    {"766", "window"},
    {"767", "window"},
    {"768", "door"},
    {"768_0", "door"},
    {"768_2", "door"},
    {"769", "door"},
    {"769_0", "door"},
    {"769_2", "door"},
    {"77", "bed,double_bed"},
    {"770", "door"},
    {"770_0", "door"},
    {"770_2", "door"},
    {"771", "garage_door"},
    {"771_0", "garage_door"},
    {"773", "wardrobe_cabinet"},
    {"775", "fence"},
    {"776", "fence"},
    {"777", "fence"},
    {"778", "arch"},
    {"778_0", "arch"},
    {"779", "arch"},
    {"779_0", "arch"},
    {"78", "bed,single_bed"},
    {"780", "arch"},
    {"780_0", "arch"},
    {"781", "picture_frame"},
    {"782", "stairs"},
    {"783", "stairs"},
    {"784", "stairs"},
    {"785", "stairs"},
    {"786", "plant"},
    {"79", "sink"},
    {"797", "roof"},
    {"80", "bathtub"},
    {"81", "bathtub"},
    {"82", "bathtub"},
    {"83", "toilet"},
    {"85", "household_appliance,washer"},
    {"86", "kitchen_cabinet,short_kitchen_cabinet"},
    {"87", "sink"},
    {"88", "chair,stool"},
    {"89", "chair,straight_chair"},
    {"90", "chair,straight_chair"},
    {"91", "chair,armchair"},
    {"92", "kitchen_cabinet,short_kitchen_cabinet"},
    {"93", "tv_stand"},
    {"94", "kitchen_cabinet,short_kitchen_cabinet"},
    {"95", "shelving"},
    {"97", "shelving,wall_shelf"},
    {"98", "dresser"},
    {"99", "kitchen_cabinet,short_kitchen_cabinet"},
    {"s__1000", "stand,nightstand"},
    {"s__1001", "wardrobe_cabinet"},
    {"s__1002", "dresser"},
    {"s__1003", "table,coffee_table"},
    {"s__1004", "table,coffee_table"},
    {"s__1005", "table,coffee_table"},
    {"s__1006", "table,coffee_table"},
    {"s__1007", "table,coffee_table"},
    {"s__1008", "table,coffee_table"},
    {"s__1009", "table,coffee_table"},
    {"s__1010", "table,coffee_table"},
    {"s__1011", "table,coffee_table"},
    {"s__1012", "table,coffee_table"},
    {"s__1013", "table,coffee_table"},
    {"s__1014", "table,coffee_table"},
    {"s__1015", "table,coffee_table"},
    {"s__1016", "table,coffee_table"},
    {"s__1017", "chair,straight_chair"},
    {"s__1018", "table,coffee_table"},
    {"s__1019", "chair,stool"},
    {"s__1020", "desk"},
    {"s__1021", "desk"},
    {"s__1022", "desk"},
    {"s__1023", "desk"},
    {"s__1024", "indoor_lamp,wall_lamp"},
    {"s__1025", "indoor_lamp,chandelier"},
    {"s__1026", "indoor_lamp,table_lamp"},
    {"s__1027", "indoor_lamp,chandelier"},
    {"s__1028", "indoor_lamp,wall_lamp"},
    {"s__1029", "kitchen_cabinet,tall_kitchen_cabinet_with_oven"},
    {"s__1030", "kitchen_cabinet,tall_kitchen_cabinet_with_oven"},
    {"s__1031", "kitchen_cabinet,tall_kitchen_cabinet"},
    {"s__1032", "kitchen_cabinet,tall_kitchen_cabinet"},
    {"s__1033", "kitchen_cabinet,tall_kitchen_cabinet"},
    {"s__1034", "kitchen_cabinet,tall_kitchen_cabinet"},
    {"s__1035", "kitchen_cabinet,tall_kitchen_cabinet_with_oven"},
    {"s__1036", "kitchen_cabinet,tall_kitchen_cabinet_with_oven"},
    {"s__1037", "table,coffee_table"},
    {"s__1038", "chair,armchair"},
    {"s__1039", "chair,lounge_chair"},
    {"s__1040", "chair,lounge_chair"},
    {"s__1041", "kitchen_set"},
    {"s__1042", "kitchen_set"},
    {"s__1043", "kitchen_set"},
    {"s__1044", "kitchen_set"},
    {"s__1045", "kitchen_set"},
    {"s__1046", "kitchen_set"},
    {"s__1047", "kitchen_set"},
    {"s__1048", "kitchen_set"},
    {"s__1049", "kitchen_set"},
    {"s__1050", "kitchen_set"},
    {"s__1051", "kitchen_cabinet,kitchen_set"},
    {"s__1052", "kitchen_cabinet,tall_kitchen_cabinet"},
    {"s__1053", "kitchen_cabinet,short_kitchen_cabinet"},
    {"s__1054", "kitchen_cabinet,short_kitchen_cabinet"},
    {"s__1055", "kitchen_cabinet,kitchen_cabinet_with_refrigerator"},
    {"s__1056",
     "kitchen_cabinet,short_kitchen_cabinet_with_hanging_kitchen_cabinet"},
    {"s__1057",
     "kitchen_cabinet,short_kitchen_cabinet_with_hanging_kitchen_cabinet"},
    {"s__1058", "kitchen_appliance,range_oven"},
    {"s__1059", "indoor_lamp,chandelier"},
    {"s__1060", "kitchen_appliance,range_hood"},
    {"s__1061", "shelving,wall_shelf"},
    {"s__1062", "chair,straight_chair"},
    {"s__1063", "hanging_kitchen_cabinet"},
    {"s__1064",
     "kitchen_cabinet,short_kitchen_cabinet_with_hanging_kitchen_cabinet"},
    {"s__1065", "kitchen_set"},
    {"s__1066", "kitchen_cabinet,kitchen_sink_with_dishwasher"},
    {"s__1067", "sofa"},
    {"s__1068", "shelving,bookshelf"},
    {"s__1069", "indoor_lamp,chandelier"},
    {"s__1070", "indoor_lamp,chandelier"},
    {"s__1071", "indoor_lamp,chandelier"},
    {"s__1072", "indoor_lamp,wall_lamp"},
    {"s__1073", "table,dining_table"},
    {"s__1074", "chair,straight_chair"},
    {"s__1075", "kitchen_cabinet,kitchen_island"},
    {"s__1076", "hanging_kitchen_cabinet"},
    {"s__1077", "kitchen_cabinet,kitchen_cabinet_with_refrigerator"},
    {"s__1078", "kitchen_cabinet,tall_kitchen_cabinet"},
    {"s__1079", "table,dining_table"},
    {"s__1080", "chair,armchair"},
    {"s__1081", "indoor_lamp,chandelier"},
    {"s__1082", "indoor_lamp,chandelier"},
    {"s__1083", "chair,straight_chair"},
    {"s__1084", "hanging_kitchen_cabinet,range_hood_with_cabinet"},
    {"s__1085", "hanging_kitchen_cabinet"},
    {"s__1086", "hanging_kitchen_cabinet"},
    {"s__1087", "indoor_lamp,chandelier"},
    {"s__1088", "kitchen_cabinet,kitchen_set"},
    {"s__1089", "sofa"},
    {"s__1090", "rug"},
    {"s__1091", "candle"},
    {"s__1092", "ottoman"},
    {"s__1093", "chair,armchair"},
    {"s__1094", "ottoman"},
    {"s__1095", "shelving"},
    {"s__1096", "table,dining_table"},
    {"s__1097", "sofa"},
    {"s__1098", "table,dining_table"},
    {"s__1099", "table,coffee_table"},
    {"s__1100", "table,coffee_table"},
    {"s__1101", "chair,straight_chair"},
    {"s__1102", "indoor_lamp,floor_lamp"},
    {"s__1103", "indoor_lamp,wall_lamp"},
    {"s__1104", "table,coffee_table"},
    {"s__1105", "wardrobe_cabinet"},
    {"s__1106", "table,coffee_table"},
    {"s__1107", "table,coffee_table"},
    {"s__1108", "indoor_lamp,wall_lamp"},
    {"s__1109", "indoor_lamp,table_lamp"},
    {"s__1110", "fireplace"},
    {"s__1111", "dresser"},
    {"s__1112", "sofa"},
    {"s__1113", "chair,armchair,sofa_chair"},
    {"s__1114", "indoor_lamp,chandelier"},
    {"s__1115", "indoor_lamp,table_lamp"},
    {"s__1116", "indoor_lamp,floor_lamp"},
    {"s__1117", "chair,stool"},
    {"s__1118", "table,coffee_table"},
    {"s__1119", "table,dining_table"},
    {"s__1120", "table,dining_table"},
    {"s__1121", "chair,straight_chair"},
    {"s__1122", "table,coffee_table"},
    {"s__1123", "chair,stool"},
    {"s__1124", "bench_chair"},
    {"s__1125", "chair,armchair"},
    {"s__1126", "sofa"},
    {"s__1127", "sofa"},
    {"s__1128", "candle"},
    {"s__1129", "fan,ceiling_fan"},
    {"s__1130", "table,coffee_table"},
    {"s__1131", "bathtub"},
    {"s__1132", "sink"},
    {"s__1133", "chair,stool"},
    {"s__1134", "shelving"},
    {"s__1135", "table,coffee_table"},
    {"s__1136", "toilet"},
    {"s__1137", "toy"},
    {"s__1138", "toilet,bidet"},
    {"s__1139", "indoor_lamp,wall_lamp"},
    {"s__1140", "indoor_lamp,wall_lamp"},
    {"s__1141", "kitchen_appliance,range_oven_with_hood"},
    {"s__1142", "kitchen_cabinet,tall_kitchen_cabinet"},
    {"s__1143", "kitchen_cabinet,short_kitchen_cabinet"},
    {"s__1144", "kitchen_cabinet,short_kitchen_cabinet"},
    {"s__1145", "kitchen_cabinet,kitchen_island"},
    {"s__1146", "kitchen_cabinet,dishwasher"},
    {"s__1147",
     "kitchen_cabinet,short_kitchen_cabinet_with_hanging_kitchen_cabinet"},
    {"s__1148", "kitchen_cabinet,kitchen_sink"},
    {"s__1149", "chair,straight_chair"},
    {"s__1150", "hanging_kitchen_cabinet"},
    {"s__1151", "hanging_kitchen_cabinet"},
    {"s__1152", "indoor_lamp,chandelier"},
    {"s__1153", "indoor_lamp,chandelier"},
    {"s__1154", "indoor_lamp,chandelier"},
    {"s__1155", "indoor_lamp,wall_lamp"},
    {"s__1156",
     "kitchen_cabinet,short_kitchen_cabinet_with_hanging_kitchen_cabinet"},
    {"s__1157", "kitchen_cabinet,kitchen_cabinet_with_refrigerator"},
    {"s__1158", "dresser"},
    {"s__1159", "table,coffee_table"},
    {"s__1160", "indoor_lamp,wall_lamp"},
    {"s__1161", "table,dining_table"},
    {"s__1162", "dresser"},
    {"s__1163", "chair"},
    {"s__1164", "chair,armchair"},
    {"s__1165", "mirror"},
    {"s__1166", "chair,armchair"},
    {"s__1167", "table,coffee_table"},
    {"s__1168", "mirror"},
    {"s__1169", "table,coffee_table"},
    {"s__1170", "table,dining_table"},
    {"s__1171", "sofa"},
    {"s__1172", "chair,armchair,sofa_chair"},
    {"s__1173", "chair"},
    {"s__1174", "indoor_lamp,floor_lamp"},
    {"s__1175", "chair"},
    {"s__1176", "chair,armchair"},
    {"s__1177", "sofa"},
    {"s__1178", "indoor_lamp,chandelier"},
    {"s__1179", "table,dining_table"},
    {"s__1180", "table,coffee_table"},
    {"s__1183", "wardrobe_cabinet"},
    {"s__1184", "wardrobe_cabinet"},
    {"s__1185", "shelving,bookshelf"},
    {"s__1186", "wardrobe_cabinet"},
    {"s__1187", "shelving,bookshelf"},
    {"s__1188", "wardrobe_cabinet"},
    {"s__1189", "wardrobe_cabinet"},
    {"s__1190", "wardrobe_cabinet"},
    {"s__1192", "wardrobe_cabinet"},
    {"s__1193", "wardrobe_cabinet"},
    {"s__1195", "wardrobe_cabinet"},
    {"s__1196", "wardrobe_cabinet"},
    {"s__1197", "shelving,bookshelf"},
    {"s__1198", "wardrobe_cabinet"},
    {"s__1199", "shelving,bookshelf"},
    {"s__1200", "shelving,bookshelf"},
    {"s__1201", "workplace,desk"},
    {"s__1202", "shelving,bookshelf"},
    {"s__1203", "shelving,bookshelf"},
    {"s__1204", "shelving,bookshelf"},
    {"s__1205", "shelving,bookshelf"},
    {"s__1206", "wardrobe_cabinet"},
    {"s__1207", "wardrobe_cabinet"},
    {"s__1208", "shelving,bookshelf"},
    {"s__1209", "shelving,bookshelf"},
    {"s__1210", "shelving,bookshelf"},
    {"s__1211", "shelving,wall_shelf"},
    {"s__1212", "shelving,bookshelf"},
    {"s__1213", "shelving,bookshelf"},
    {"s__1214", "wardrobe_cabinet"},
    {"s__1215", "wardrobe_cabinet"},
    {"s__1216", "wardrobe_cabinet"},
    {"s__1217", "wardrobe_cabinet"},
    {"s__1218", "wardrobe_cabinet"},
    {"s__1219", "wardrobe_cabinet"},
    {"s__1220", "wardrobe_cabinet"},
    {"s__1221", "wardrobe_cabinet"},
    {"s__1222", "desk"},
    {"s__1223", "shelving,wall_shelf"},
    {"s__1224", "shelving,wall_shelf"},
    {"s__1225", "desk"},
    {"s__1226", "shelving,wall_shelf"},
    {"s__1227", "shelving,bookshelf"},
    {"s__1228", "shelving,bookshelf"},
    {"s__1230", "wardrobe_cabinet"},
    {"s__1231", "wardrobe_cabinet"},
    {"s__1232", "wardrobe_cabinet"},
    {"s__1234", "wardrobe_cabinet"},
    {"s__1235", "wardrobe_cabinet"},
    {"s__1237", "wardrobe_cabinet"},
    {"s__1239", "shelving,bookshelf"},
    {"s__1240", "shelving,bookshelf"},
    {"s__1241", "wardrobe_cabinet"},
    {"s__1242", "stand,nightstand"},
    {"s__1243", "dressing_table"},
    {"s__1244", "wardrobe_cabinet"},
    {"s__1245", "wardrobe_cabinet"},
    {"s__1246", "bed,double_bed"},
    {"s__1247", "bed,double_bed"},
    {"s__1248", "bathtub"},
    {"s__1249", "sink"},
    {"s__1250", "toilet"},
    {"s__1251", "toilet,bidet"},
    {"s__1252", "shower"},
    {"s__1253", "wardrobe_cabinet"},
    {"s__1254", "chair,straight_chair"},
    {"s__1255", "indoor_lamp,chandelier"},
    {"s__1256", "indoor_lamp,wall_lamp"},
    {"s__1257", "indoor_lamp,wall_lamp"},
    {"s__1258", "workplace,desk_with_shelves"},
    {"s__1259", "workplace,desk_with_shelves"},
    {"s__1260", "workplace,desk_with_shelves"},
    {"s__1261", "workplace,desk_with_shelves"},
    {"s__1262", "workplace,desk_with_shelves"},
    {"s__1265", "workplace,desk_with_shelves"},
    {"s__1268", "indoor_lamp,wall_lamp"},
    {"s__1269", "mirror"},
    {"s__1270", "sink"},
    {"s__1271", "indoor_lamp,wall_lamp"},
    {"s__1272", "mirror"},
    {"s__1273", "sink"},
    {"s__1274", "indoor_lamp,wall_lamp"},
    {"s__1275", "mirror"},
    {"s__1276", "mirror"},
    {"s__1277", "sink"},
    {"s__1278", "indoor_lamp,wall_lamp"},
    {"s__1279", "sink"},
    {"s__1280", "indoor_lamp,wall_lamp"},
    {"s__1281", "dresser"},
    {"s__1282", "indoor_lamp,wall_lamp"},
    {"s__1283", "sink"},
    {"s__1284", "bathtub"},
    {"s__1285", "shower"},
    {"s__1286", "sofa"},
    {"s__1287", "table,coffee_table"},
    {"s__1288", "chair,armchair,sofa_chair"},
    {"s__1289", "ottoman"},
    {"s__1290", "sofa"},
    {"s__1291", "vase"},
    {"s__1292", "indoor_lamp,chandelier"},
    {"s__1293", "mirror"},
    {"s__1294", "dresser"},
    {"s__1295", "table,dining_table"},
    {"s__1296", "indoor_lamp,floor_lamp"},
    {"s__1297", "indoor_lamp,table_lamp"},
    {"s__1298", "table,coffee_table"},
    {"s__1299", "wardrobe_cabinet"},
    {"s__1300", "shelving"},
    {"s__1301", "vase"},
    {"s__1302", "bed,double_bed"},
    {"s__1303", "chair,armchair,sofa_chair"},
    {"s__1304", "desk"},
    {"s__1305", "chair,straight_chair"},
    {"s__1306", "indoor_lamp,table_lamp"},
    {"s__1307", "stand,nightstand"},
    {"s__1308", "ottoman"},
    {"s__1309", "fireplace_tools"},
    {"s__1310", "indoor_lamp,wall_lamp"},
    {"s__1311", "indoor_lamp,table_lamp"},
    {"s__1312", "mirror"},
    {"s__1313", "fireplace"},
    {"s__1314", "chair,stool"},
    {"s__1315", "stand"},
    {"s__1316", "table,coffee_table"},
    {"s__1317", "table,coffee_table"},
    {"s__1318", "indoor_lamp,table_lamp"},
    {"s__1319", "bathtub"},
    {"s__1320", "sink"},
    {"s__1321", "bathroom_stuff,toilet_paper"},
    {"s__1322", "shower"},
    {"s__1323", "sink"},
    {"s__1324", "ottoman"},
    {"s__1325", "indoor_lamp,wall_lamp"},
    {"s__1326", "bathroom_stuff,towel_hanger"},
    {"s__1327", "bathroom_stuff,towel_hanger"},
    {"s__1328", "mirror"},
    {"s__1329", "indoor_lamp,wall_lamp"},
    {"s__1330", "sofa"},
    {"s__1331", "ottoman"},
    {"s__1332", "table,coffee_table"},
    {"s__1333", "indoor_lamp,chandelier"},
    {"s__1334", "chair"},
    {"s__1335", "plant"},
    {"s__1336", "tv_stand"},
    {"s__1337", "chair,armchair"},
    {"s__1338", "desk"},
    {"s__1339", "mirror"},
    {"s__1340", "chair,armchair,sofa_chair"},
    {"s__1341", "indoor_lamp,table_lamp"},
    {"s__1342", "indoor_lamp,table_lamp"},
    {"s__1343", "toy"},
    {"s__1344", "toy,tricycle"},
    {"s__1345", "toy"},
    {"s__1346", "toy"},
    {"s__1347", "toy"},
    {"s__1348", "toy"},
    {"s__1349", "toy"},
    {"s__1350", "toy"},
    {"s__1351", "toy"},
    {"s__1352", "toy"},
    {"s__1353", "desk"},
    {"s__1354", "desk"},
    {"s__1355", "wardrobe_cabinet"},
    {"s__1356", "wardrobe_cabinet"},
    {"s__1357", "wardrobe_cabinet"},
    {"s__1358", "wardrobe_cabinet"},
    {"s__1359", "wardrobe_cabinet"},
    {"s__1360", "wardrobe_cabinet"},
    {"s__1361", "wardrobe_cabinet"},
    {"s__1362", "shelving"},
    {"s__1363", "desk"},
    {"s__1364", "desk"},
    {"s__1365", "desk"},
    {"s__1366", "desk"},
    {"s__1367", "desk"},
    {"s__1368", "desk"},
    {"s__1369", "wardrobe_cabinet"},
    {"s__1370", "stand"},
    {"s__1371", "wardrobe_cabinet"},
    {"s__1372", "desk"},
    {"s__1374", "desk"},
    {"s__1377", "desk"},
    {"s__1378", "wardrobe_cabinet"},
    {"s__1379", "wardrobe_cabinet"},
    {"s__1382", "wardrobe_cabinet"},
    {"s__1384", "stand"},
    {"s__1392", "desk"},
    {"s__1393", "desk"},
    {"s__1394", "desk"},
    {"s__1396", "table"},
    {"s__1398", "wardrobe_cabinet"},
    {"s__1399", "wardrobe_cabinet"},
    {"s__1400", "shelving,bookshelf"},
    {"s__1401", "shelving,bookshelf"},
    {"s__1402", "shelving,bookshelf"},
    {"s__1403", "shelving,bookshelf"},
    {"s__1404", "wardrobe_cabinet"},
    {"s__1405", "wardrobe_cabinet"},
    {"s__1406", "wardrobe_cabinet"},
    {"s__1407", "wardrobe_cabinet"},
    {"s__1408", "wardrobe_cabinet"},
    {"s__1410", "shelving"},
    {"s__1411", "shelving"},
    {"s__1412", "shelving"},
    {"s__1413", "wardrobe_cabinet"},
    {"s__1414", "wardrobe_cabinet"},
    {"s__1415", "stand"},
    {"s__1416", "stand"},
    {"s__1418", "desk"},
    {"s__1419", "desk"},
    {"s__1422", "desk"},
    {"s__1423", "desk"},
    {"s__1426", "desk"},
    {"s__1427", "desk"},
    {"s__1428", "desk"},
    {"s__1429", "desk"},
    {"s__1431", "table"},
    {"s__1432", "table"},
    {"s__1433", "table"},
    {"s__1434", "toy"},
    {"s__1435", "shelving"},
    {"s__1438", "table"},
    {"s__1439", "table"},
    {"s__1443", "stand"},
    {"s__1445", "shelving,bookshelf"},
    {"s__1446", "wardrobe_cabinet"},
    {"s__1448", "shelving,bookshelf"},
    {"s__1452", "desk"},
    {"s__1461", "desk"},
    {"s__1462", "toy"},
    {"s__1465", "wardrobe_cabinet"},
    {"s__1467", "wardrobe_cabinet"},
    {"s__1473", "desk"},
    {"s__1474", "desk"},
    {"s__1476", "desk"},
    {"s__1486", "stand"},
    {"s__1487", "desk"},
    {"s__1490", "mirror"},
    {"s__1491", "mirror"},
    {"s__1492", "hanger"},
    {"s__1493", "stand,nightstand"},
    {"s__1494", "stand,nightstand"},
    {"s__1495", "desk"},
    {"s__1496", "desk"},
    {"s__1497", "wardrobe_cabinet"},
    {"s__1498", "wardrobe_cabinet"},
    {"s__1499", "desk"},
    {"s__1500", "wood_board"},
    {"s__1501", "bed,double_bed"},
    {"s__1502", "bed,double_bed"},
    {"s__1503", "bed,single_bed"},
    {"s__1504", "chair,office_chair"},
    {"s__1505", "chair,straight_chair"},
    {"s__1506", "chair,straight_chair"},
    {"s__1507", "chair,office_chair"},
    {"s__1508", "chair,office_chair"},
    {"s__1509", "wardrobe_cabinet"},
    {"s__1510", "desk"},
    {"s__1511", "wardrobe_cabinet"},
    {"s__1512", "wardrobe_cabinet"},
    {"s__1513", "wardrobe_cabinet"},
    {"s__1514", "shelving,bookshelf"},
    {"s__1515", "stand"},
    {"s__1516", "desk"},
    {"s__1517", "tv_stand"},
    {"s__1518", "desk"},
    {"s__1519", "chair,office_chair"},
    {"s__1520", "chair,office_chair"},
    {"s__1521", "chair,office_chair"},
    {"s__1522", "chair,office_chair"},
    {"s__1523", "chair,office_chair"},
    {"s__1524", "chair,office_chair"},
    {"s__1525", "chair,office_chair"},
    {"s__1526", "chair,office_chair"},
    {"s__1527", "chair,office_chair"},
    {"s__1528", "chair,office_chair"},
    {"s__1529", "chair,office_chair"},
    {"s__1531", "chair,office_chair"},
    {"s__1532", "chair,office_chair"},
    {"s__1533", "chair,office_chair"},
    {"s__1534", "chair,office_chair"},
    {"s__1535", "chair,office_chair"},
    {"s__1536", "chair,office_chair"},
    {"s__1537", "chair,office_chair"},
    {"s__1539", "chair,office_chair"},
    {"s__1540", "toy"},
    {"s__1541", "plant"},
    {"s__1542", "outdoor_lamp"},
    {"s__1543", "plant"},
    {"s__1544", "mirror"},
    {"s__1545", "grill"},
    {"s__1546", "table,coffee_table"},
    {"s__1547", "bench_chair"},
    {"s__1548", "kitchen_cabinet,kitchen_sink_with_dishwasher"},
    {"s__1549", "clock"},
    {"s__1550", "chair,armchair"},
    {"s__1551", "stand"},
    {"s__1552", "sink"},
    {"s__1553", "bathtub"},
    {"s__1554", "trash_can"},
    {"s__1555", "shower"},
    {"s__1556", "mirror"},
    {"s__1557", "indoor_lamp,chandelier"},
    {"s__1558", "indoor_lamp,wall_lamp"},
    {"s__1559", "mirror"},
    {"s__1560", "toy"},
    {"s__1561", "ottoman"},
    {"s__1562", "bed,double_bed"},
    {"s__1563", "pet,dog"},
    {"s__1631", "pet,dog"},
    {"s__1632", "pet,dog"},
    {"s__1633", "pet,turtle"},
    {"s__1634", "pet,bird"},
    {"s__1635", "pet,cat"},
    {"s__1636", "pet,dog"},
    {"s__1637", "pet,pig"},
    {"s__1638", "pet,cat"},
    {"s__1639", "toy,fishbowl"},
    {"s__1640", "pet,bird"},
    {"s__1641", "clock"},
    {"s__1642", "clock"},
    {"s__1643", "clock"},
    {"s__1644", "toy"},
    {"s__1645", "household_appliance,gramophone"},
    {"s__1646", "toy"},
    {"s__1647", "rug"},
    {"s__1648", "household_appliance,telephone"},
    {"s__1649", "household_appliance,rifle_on_wall"},
    {"s__1650", "pillow"},
    {"s__1651", "pillow"},
    {"s__1652", "pillow"},
    {"s__1653", "pillow"},
    {"s__1654", "pillow"},
    {"s__1655", "toy"},
    {"s__1656", "toy"},
    {"s__1657", "toy"},
    {"s__1658", "toy"},
    {"s__1659", "toy"},
    {"s__1660", "kitchenware,cup,food"},
    {"s__1661", "toy"},
    {"s__1662", "toy"},
    {"s__1663", "toy"},
    {"s__1664", "dresser"},
    {"s__1665", "chair,armchair,sofa_chair"},
    {"s__1666", "chair,armchair"},
    {"s__1667", "table,dining_table"},
    {"s__1668", "chair,armchair"},
    {"s__1669", "table,coffee_table"},
    {"s__1670", "fireplace"},
    {"s__1671", "dresser"},
    {"s__1672", "sofa"},
    {"s__1673", "ottoman"},
    {"s__1674", "sofa"},
    {"s__1675", "indoor_lamp,floor_lamp"},
    {"s__1676", "indoor_lamp,chandelier"},
    {"s__1677", "indoor_lamp,table_lamp"},
    {"s__1678", "indoor_lamp,table_lamp"},
    {"s__1679", "chair,armchair"},
    {"s__1680", "toilet"},
    {"s__1681", "toilet"},
    {"s__1682", "toilet"},
    {"s__1683", "stand"},
    {"s__1684", "toilet"},
    {"s__1685", "sink"},
    {"s__1686", "sink"},
    {"s__1687", "mirror"},
    {"s__1688", "mirror"},
    {"s__1689", "sink"},
    {"s__1690", "sink"},
    {"s__1691", "sink"},
    {"s__1692", "sink"},
    {"s__1693", "bathtub"},
    {"s__1694", "bathtub"},
    {"s__1695", "bathtub"},
    {"s__1696", "bathtub"},
    {"s__1697", "bathtub"},
    {"s__1698", "indoor_lamp,table_lamp"},
    {"s__1699", "indoor_lamp,chandelier"},
    {"s__1700", "chair,armchair"},
    {"s__1701", "chair"},
    {"s__1702", "table,dining_table"},
    {"s__1703", "indoor_lamp,chandelier"},
    {"s__1704", "bed,double_bed"},
    {"s__1705", "chair,stool"},
    {"s__1706", "wardrobe_cabinet"},
    {"s__1707", "indoor_lamp,chandelier"},
    {"s__1708", "indoor_lamp,chandelier"},
    {"s__1709", "indoor_lamp,floor_lamp"},
    {"s__1710", "chair,armchair"},
    {"s__1711", "chair"},
    {"s__1712", "chair"},
    {"s__1713", "dresser"},
    {"s__1714", "bed,double_bed"},
    {"s__1715", "chair"},
    {"s__1716", "table,dining_table"},
    {"s__1717", "chair"},
    {"s__1718", "table,dining_table"},
    {"s__1719", "indoor_lamp,floor_lamp"},
    {"s__1720", "table,coffee_table"},
    {"s__1721", "indoor_lamp,table_lamp"},
    {"s__1722", "vehicle,car"},
    {"s__1723", "vehicle,car"},
    {"s__1724", "vehicle,car"},
    {"s__1725", "vehicle,car"},
    {"s__1726", "desk"},
    {"s__1727", "desk"},
    {"s__1728", "stand"},
    {"s__1730", "desk"},
    {"s__1732", "dresser"},
    {"s__1735", "desk"},
    {"s__1736", "stand"},
    {"s__1737", "desk"},
    {"s__1738", "counter"},
    {"s__1739", "desk"},
    {"s__1741", "table,dining_table"},
    {"s__1742", "desk"},
    {"s__1743", "wardrobe_cabinet"},
    {"s__1744", "wardrobe_cabinet"},
    {"s__1745", "wardrobe_cabinet"},
    {"s__1746", "chair,office_chair"},
    {"s__1747", "chair,office_chair"},
    {"s__1748", "chair,straight_chair"},
    {"s__1749", "chair,armchair,sofa_chair"},
    {"s__1750", "sofa"},
    {"s__1751", "sofa"},
    {"s__1752", "vehicle,bicycle"},
    {"s__1753", "vehicle,bicycle"},
    {"s__1760", "storage_bench"},
    {"s__1761", "chair,stool"},
    {"s__1762", "door"},
    {"s__1762_0", "door"},
    {"s__1762_2", "door"},
    {"s__1763", "door"},
    {"s__1763_0", "door"},
    {"s__1763_2", "door"},
    {"s__1764", "door"},
    {"s__1764_0", "door"},
    {"s__1764_2", "door"},
    {"s__1765", "door"},
    {"s__1765_0", "door"},
    {"s__1765_2", "door"},
    {"s__1766", "door"},
    {"s__1766_0", "door"},
    {"s__1766_2", "door"},
    {"s__1767", "door"},
    {"s__1767_0", "door"},
    {"s__1767_2", "door"},
    {"s__1768", "door"},
    {"s__1768_0", "door"},
    {"s__1768_2", "door"},
    {"s__1769", "door"},
    {"s__1769_0", "door"},
    {"s__1769_2", "door"},
    {"s__1770", "door"},
    {"s__1770_0", "door"},
    {"s__1770_2", "door"},
    {"s__1771", "door"},
    {"s__1771_0", "door"},
    {"s__1771_2", "door"},
    {"s__1772", "door"},
    {"s__1772_0", "door"},
    {"s__1772_2", "door"},
    {"s__1773", "door"},
    {"s__1773_0", "door"},
    {"s__1773_2", "door"},
    {"s__1774", "bed,double_bed"},
    {"s__1775", "bed,double_bed"},
    {"s__1776", "bed,double_bed"},
    {"s__1777", "bed,double_bed"},
    {"s__1778", "wardrobe_cabinet"},
    {"s__1779", "person"},
    {"s__1780", "person"},
    {"s__1781", "person"},
    {"s__1782", "person"},
    {"s__1783", "person"},
    {"s__1784", "person"},
    {"s__1785", "person"},
    {"s__1786", "person"},
    {"s__1787", "person"},
    {"s__1788", "person"},
    {"s__1789", "stand"},
    {"s__1790", "wardrobe_cabinet"},
    {"s__1791", "bed,double_bed"},
    {"s__1792", "bed,double_bed"},
    {"s__1793", "vase"},
    {"s__1794", "vase"},
    {"s__1795", "vase"},
    {"s__1796", "vase"},
    {"s__1797", "vase"},
    {"s__1798", "vase"},
    {"s__1799", "vase"},
    {"s__1800", "vase"},
    {"s__1801", "vase"},
    {"s__1802", "vase"},
    {"s__1803", "vase"},
    {"s__1804", "vase"},
    {"s__1805", "vase"},
    {"s__1806", "vase"},
    {"s__1807", "vase"},
    {"s__1808", "vase"},
    {"s__1809", "vase"},
    {"s__1810", "vase"},
    {"s__1811", "vase"},
    {"s__1812", "vase"},
    {"s__1813", "magazines"},
    {"s__1814", "household_appliance,cellphone"},
    {"s__1815", "household_appliance,camera"},
    {"s__1816", "household_appliance,ipad"},
    {"s__1817", "tripod"},
    {"s__1818", "toy"},
    {"s__1819", "household_appliance,telephone"},
    {"s__1820", "household_appliance,stationary_container"},
    {"s__1821", "household_appliance,headphones_on_stand"},
    {"s__1822", "household_appliance,helmet"},
    {"s__1823", "shoes"},
    {"s__1824", "kitchenware,cup,drink"},
    {"s__1825", "kitchenware,food_tray,food,drink"},
    {"s__1826", "kitchenware,jug,drink"},
    {"s__1827", "kitchenware,containers"},
    {"s__1828", "kitchenware,utensil_holder"},
    {"s__1829", "kitchenware,spoon"},
    {"s__1830", "kitchenware,knife"},
    {"s__1831", "kitchenware,fork"},
    {"s__1832", "kitchenware,teapot"},
    {"s__1833", "kitchenware,cup"},
    {"s__1834", "kitchenware,jug"},
    {"s__1835", "kitchenware,container"},
    {"s__1836", "kitchenware,fruit_bowl,food"},
    {"s__1837", "table,coffee_table"},
    {"s__1838", "indoor_lamp,table_lamp"},
    {"s__1839", "indoor_lamp,chandelier"},
    {"s__1840", "indoor_lamp,table_lamp"},
    {"s__1841", "indoor_lamp,chandelier"},
    {"s__1842", "bed,double_bed"},
    {"s__1843", "bed,double_bed"},
    {"s__1844", "kitchenware,bread,food"},
    {"s__1845", "trinket"},
    {"s__1846", "trinket"},
    {"s__1847", "trinket"},
    {"s__1848", "trinket"},
    {"s__1849", "kitchenware,mortar_and_pestle"},
    {"s__1850", "kitchenware,food"},
    {"s__1851", "kitchenware,place_setting"},
    {"s__1852", "trinket"},
    {"s__1853", "trinket"},
    {"s__1854", "chair,armchair,sofa_chair"},
    {"s__1855", "trinket"},
    {"s__1856", "trinket"},
    {"s__1857", "trinket"},
    {"s__1858", "toy"},
    {"s__1859", "toy"},
    {"s__1860", "candle"},
    {"s__1861", "candle"},
    {"s__1862", "candle"},
    {"s__1863", "candle"},
    {"s__1864", "candle"},
    {"s__1865", "trinket"},
    {"s__1866", "trinket"},
    {"s__1867", "toy"},
    {"s__1868", "toy"},
    {"s__1869", "toy"},
    {"s__1870", "toy"},
    {"s__1871", "table,dining_table"},
    {"s__1872", "table,coffee_table"},
    {"s__1873", "bench_chair"},
    {"s__1874", "table,dining_table"},
    {"s__1875", "mirror"},
    {"s__1876", "chair,armchair,sofa_chair"},
    {"s__1877", "chair,straight_chair"},
    {"s__1878", "indoor_lamp,floor_lamp"},
    {"s__1879", "sofa"},
    {"s__1880", "indoor_lamp,table_lamp"},
    {"s__1881", "indoor_lamp,chandelier"},
    {"s__1882", "sofa"},
    {"s__1883", "indoor_lamp,chandelier"},
    {"s__1884", "dresser"},
    {"s__1885", "chair,armchair"},
    {"s__1886", "chair"},
    {"s__1887", "ottoman"},
    {"s__1888", "table,coffee_table"},
    {"s__1889", "tv_stand"},
    {"s__1890", "hanger"},
    {"s__1891", "hanger"},
    {"s__1892", "table,coffee_table"},
    {"s__1893", "table,dining_table"},
    {"s__1894", "table,coffee_table"},
    {"s__1895", "curtain"},
    {"s__1895_0", "curtain"},
    {"s__1896", "curtain"},
    {"s__1896_0", "curtain"},
    {"s__1897", "curtain"},
    {"s__1897_0", "curtain"},
    {"s__1898", "curtain"},
    {"s__1898_0", "curtain"},
    {"s__1899", "curtain"},
    {"s__1899_0", "curtain"},
    {"s__1900", "curtain"},
    {"s__1900_0", "curtain"},
    {"s__1901", "curtain"},
    {"s__1902", "curtain"},
    {"s__1902_0", "curtain"},
    {"s__1903", "curtain"},
    {"s__1903_0", "curtain"},
    {"s__1904", "vehicle,motorcycle"},
    {"s__1905", "chair,armchair"},
    {"s__1906", "chair"},
    {"s__1907", "table"},
    {"s__1908", "bench_chair"},
    {"s__1909", "chair"},
    {"s__1910", "fireplace"},
    {"s__1911", "outdoor_spring"},
    {"s__1912", "table"},
    {"s__1913", "outdoor_lamp"},
    {"s__1914", "indoor_lamp,chandelier"},
    {"s__1915", "bench_chair"},
    {"s__1916", "table,coffee_table"},
    {"s__1917", "outdoor_lamp"},
    {"s__1918", "ottoman"},
    {"s__1919", "table"},
    {"s__1920", "bench_chair"},
    {"s__1921", "indoor_lamp,chandelier"},
    {"s__1922", "partition"},
    {"s__1923", "wood_board"},
    {"s__1924", "shelving,wall_shelf"},
    {"s__1925", "stand"},
    {"s__1926", "bench_chair"},
    {"s__1927", "chair,armchair"},
    {"s__1928", "table,dining_table"},
    {"s__1929", "table,dining_table"},
    {"s__1930", "hanger"},
    {"s__1931", "chair,straight_chair"},
    {"s__1932", "chair,armchair"},
    {"s__1933", "candle"},
    {"s__1934", "kitchen_cabinet,kitchen_sink"},
    {"s__1935", "indoor_lamp,chandelier"},
    {"s__1936", "household_appliance,ladder"},
    {"s__1937", "mirror"},
    {"s__1938", "ottoman"},
    {"s__1939", "bathtub"},
    {"s__1940", "desk"},
    {"s__1941", "stand"},
    {"s__1942", "sink"},
    {"s__1943", "sink"},
    {"s__1944", "indoor_lamp,wall_lamp"},
    {"s__1945", "indoor_lamp,wall_lamp"},
    {"s__1946", "sink"},
    {"s__1947", "shower,shower_faucet"},
    {"s__1948", "shower,shower_ceiling"},
    {"s__1949", "cloth"},
    {"s__1950", "drinkbar"},
    {"s__1951", "counter"},
    {"s__1952", "counter"},
    {"s__1953", "counter"},
    {"s__1954", "recreation,game_table"},
    {"s__1955", "recreation,game_table"},
    {"s__1956", "household_appliance,slot_machine"},
    {"s__1957", "person"},
    {"s__1958", "person"},
    {"s__1959", "person"},
    {"s__1960", "person"},
    {"s__1961", "person"},
    {"s__1962", "person"},
    {"s__1963", "toy"},
    {"s__1964", "toy,poker_chips"},
    {"s__1965", "household_appliance,slot_machine_and_chair"},
    {"s__1966", "kitchen_appliance,kettle"},
    {"s__1967", "kitchen_appliance,cooker"},
    {"s__1968", "kitchen_appliance,food_processor"},
    {"s__1969", "kitchen_appliance,toaster"},
    {"s__1970", "kitchen_appliance,food_processor"},
    {"s__1971", "kitchen_appliance,coffee_machine"},
    {"s__1972", "kitchen_appliance,food_processor"},
    {"s__1973", "kitchen_appliance,refrigerator"},
    {"s__1974", "fireplace"},
    {"s__1975", "stand"},
    {"s__1976", "bed,double_bed"},
    {"s__1977", "indoor_lamp,chandelier"},
    {"s__1978", "mirror"},
    {"s__1979", "ottoman"},
    {"s__1980", "table,coffee_table"},
    {"s__1981", "stand"},
    {"s__1982", "table,coffee_table"},
    {"s__1983", "indoor_lamp,table_lamp"},
    {"s__1984", "tv_stand"},
    {"s__1985", "chair,armchair,sofa_chair"},
    {"s__1986", "tv_stand"},
    {"s__1987", "table,dining_table"},
    {"s__1988", "table,coffee_table"},
    {"s__1989", "table,coffee_table"},
    {"s__1990", "chair"},
    {"s__1991", "sofa"},
    {"s__1992", "table,coffee_table"},
    {"s__1993", "sofa"},
    {"s__1994", "candle"},
    {"s__1995", "indoor_lamp,chandelier"},
    {"s__1996", "bed,single_bed"},
    {"s__1997", "stand,nightstand"},
    {"s__1998", "ottoman"},
    {"s__1999", "ottoman"},
    {"s__2000", "ottoman"},
    {"s__2001", "bed,single_bed"},
    {"s__2002", "bed,double_bed"},
    {"s__2003", "chair,lounge_chair"},
    {"s__2004", "chair,straight_chair"},
    {"s__2005", "desk"},
    {"s__2006", "stand"},
    {"s__2007", "mirror"},
    {"s__2008", "indoor_lamp,table_lamp"},
    {"s__2009", "indoor_lamp,table_lamp"},
    {"s__2010", "window"},
    {"s__2011", "window"},
    {"s__2012", "window"},
    {"s__2013", "window"},
    {"s__2014", "window"},
    {"s__2015", "window"},
    {"s__2016", "window"},
    {"s__2017", "window"},
    {"s__2019", "window"},
    {"s__2020", "stand,nightstand"},
    {"s__2021", "dresser"},
    {"s__2022", "shelving,bookshelf"},
    {"s__2023", "table,coffee_table"},
    {"s__2024", "indoor_lamp,wall_lamp"},
    {"s__2025", "mirror"},
    {"s__2026", "candle"},
    {"s__2027", "table,coffee_table"},
    {"s__2028", "indoor_lamp,table_lamp"},
    {"s__2029", "picture_frame"},
    {"s__2030", "chair,armchair"},
    {"s__2031", "music,drumset"},
    {"s__2032", "music,guitar"},
    {"s__2033", "music,amplifier"},
    {"s__2034", "music,keyboard"},
    {"s__2035", "music,microphone"},
    {"s__2036", "music,accordion"},
    {"s__2037", "music,theremin"},
    {"s__2038", "bed,double_bed"},
    {"s__2039", "stand"},
    {"s__2040", "kitchen_cabinet,tall_kitchen_cabinet"},
    {"s__2041", "curtain"},
    {"s__2042", "dresser"},
    {"s__2043", "wardrobe_cabinet"},
    {"s__2044", "wardrobe_cabinet"},
    {"s__2045", "dressing_table"},
    {"s__2046", "table,dining_table"},
    {"s__2047", "stand,nightstand"},
    {"s__2048", "bed,double_bed"},
    {"s__2049", "chair,straight_chair"},
    {"s__2050", "hanger"},
    {"s__2051", "stand,nightstand"},
    {"s__2052", "wardrobe_cabinet"},
    {"s__2053", "dresser"},
    {"s__2054", "wardrobe_cabinet"},
    {"s__2055", "bed,double_bed"},
    {"s__2056", "wardrobe_cabinet"},
    {"s__2057", "wardrobe_cabinet"},
    {"s__2058", "dresser"},
    {"s__2059", "chair,armchair,sofa_chair"},
    {"s__2060", "sofa"},
    {"s__2061", "chair,armchair,sofa_chair"},
    {"s__2062", "chair,armchair,sofa_chair"},
    {"s__2083", "toy"},
    {"s__2084", "toy"},
    {"s__2085", "toy"},
    {"s__2086", "toy"},
    {"s__2087", "toy"},
    {"s__2088", "toy"},
    {"s__2089", "bed,double_bed"},
    {"s__2090", "dresser"},
    {"s__2091", "dresser"},
    {"s__2092", "wardrobe_cabinet"},
    {"s__2093", "shelving,bookshelf"},
    {"s__2094", "shelving,bookshelf"},
    {"s__2095", "tv_stand"},
    {"s__2096", "tv_stand"},
    {"s__2097", "stand,nightstand"},
    {"s__2098", "stand,nightstand"},
    {"s__2099", "stand,nightstand"},
    {"s__2100", "stand,nightstand"},
    {"s__2101", "stand"},
    {"s__2103", "wardrobe_cabinet"},
    {"s__2104", "tv_stand"},
    {"s__2105", "wardrobe_cabinet"},
    {"s__2106", "tv_stand"},
    {"s__2107", "tv_stand"},
    {"s__2108", "shelving,wall_shelf"},
    {"s__2109", "shelving,wall_shelf"},
    {"s__2110", "table,coffee_table"},
    {"s__2111", "stand"},
    {"s__2112", "tv_stand"},
    {"s__2113", "desk"},
    {"s__2114", "workplace,desk"},
    {"s__2115", "desk"},
    {"s__2116", "desk"},
    {"s__2117", "desk"},
    {"s__2118", "desk"},
    {"s__2119", "desk"},
    {"s__2120", "table,coffee_table"},
    {"s__2121", "table,coffee_table"},
    {"s__2122", "tv_stand"},
    {"s__2123", "workplace,desk"},
    {"s__2124", "tv_stand"},
    {"s__2125", "workplace,desk_with_shelves"},
    {"s__2126", "shelving"},
    {"s__2127", "tv_stand"},
    {"s__2129", "tv_stand"},
    {"s__2130", "shelving"},
    {"s__2131", "shelving"},
    {"s__2132", "bed,double_bed"},
    {"s__2133", "workplace,desk"},
    {"s__2134", "workplace,desk_with_shelves"},
    {"s__2135", "workplace,desk_with_shelves"},
    {"s__2136", "workplace,desk_with_shelves"},
    {"s__2137", "workplace,desk_with_shelves"},
    {"s__2138", "workplace,desk_with_shelves"},
    {"s__2139", "workplace,desk"},
    {"s__2140", "workplace,desk"},
    {"s__2141", "workplace,desk_with_shelves"},
    {"s__2142", "shelving"},
    {"s__2143", "workplace,desk_with_shelves"},
    {"s__2144", "workplace,desk_with_shelves"},
    {"s__2145", "desk"},
    {"s__2146", "shelving"},
    {"s__2147", "workplace,desk_with_shelves"},
    {"s__2148", "workplace,desk"},
    {"s__2149", "workplace,desk_with_shelves"},
    {"s__2150", "workplace,desk_with_shelves"},
    {"s__2151", "workplace,desk_with_shelves"},
    {"s__2153", "desk"},
    {"s__2154", "desk"},
    {"s__2155", "desk"},
    {"s__2156", "sofa"},
    {"s__2157", "sofa"},
    {"s__2158", "sofa"},
    {"s__2159", "sofa"},
    {"s__2160", "sofa"},
    {"s__2161", "sofa"},
    {"s__2162", "sofa"},
    {"s__2163", "sofa"},
    {"s__2164", "sofa"},
    {"s__2165", "sofa"},
    {"s__2166", "sofa"},
    {"s__2167", "chair,armchair,sofa_chair"},
    {"s__2168", "chair,armchair"},
    {"s__2169", "chair"},
    {"s__2170", "chair"},
    {"s__2171", "sofa"},
    {"s__2172", "chair,armchair,sofa_chair"},
    {"s__2173", "sofa"},
    {"s__2174", "chair,armchair"},
    {"s__2175", "chair,armchair,sofa_chair"},
    {"s__2176", "sofa"},
    {"s__2177", "chair"},
    {"s__2178", "chair,armchair"},
    {"s__2179", "chair,armchair"},
    {"s__2180", "chair,armchair"},
    {"s__2181", "ottoman"},
    {"s__2182", "ottoman"},
    {"s__2183", "chair,armchair"},
    {"s__2184", "ottoman"},
    {"s__2185", "chair,armchair"},
    {"s__2186", "ottoman"},
    {"s__2187", "chair,armchair"},
    {"s__2188", "chair,straight_chair"},
    {"s__2189", "chair,straight_chair"},
    {"s__2190", "chair,armchair"},
    {"s__2191", "chair"},
    {"s__2192", "chair,straight_chair"},
    {"s__2193", "chair,armchair"},
    {"s__2194", "chair,armchair"},
    {"s__2195", "chair,lounge_chair"},
    {"s__2196", "chair,armchair,sofa_chair"},
    {"s__2197", "chair,armchair"},
    {"s__2235", "sofa"},
    {"s__2236", "ottoman"},
    {"s__2237", "bench_chair"},
    {"s__2238", "workplace,desk_with_shelves"},
    {"s__2240", "shelving,bookshelf"},
    {"s__2241", "shelving,bookshelf"},
    {"s__2244", "desk"},
    {"s__2245", "desk"},
    {"s__2254", "toy"},
    {"s__2255", "chair,armchair"},
    {"s__2256", "chair,armchair"},
    {"s__2257", "chair,stool"},
    {"s__2258", "bench_chair"},
    {"s__2259", "chair,lounge_chair"},
    {"s__2260", "bench_chair"},
    {"s__2261", "chair,straight_chair"},
    {"s__2262", "chair,armchair"},
    {"s__2263", "chair,armchair"},
    {"s__2264", "chair,lounge_chair"},
    {"s__2265", "chair,straight_chair"},
    {"s__2266", "chair,armchair"},
    {"s__2267", "ottoman"},
    {"s__2268", "sofa"},
    {"s__2269", "chair,armchair"},
    {"s__2270", "ottoman"},
    {"s__2271", "chair,armchair"},
    {"s__2272", "chair,straight_chair"},
    {"s__2273", "fireplace"},
    {"s__2274", "fireplace"},
    {"s__2275", "fireplace"},
    {"s__2276", "fireplace"},
    {"s__2277", "fireplace"},
    {"s__2278", "fireplace"},
    {"s__2279", "fireplace"},
    {"s__2280", "fireplace"},
    {"s__2281", "fireplace"},
    {"s__2282", "fireplace"},
    {"s__2283", "fireplace"},
    {"s__2284", "fireplace"},
    {"s__2285", "fireplace"},
    {"s__2286", "fireplace_tools"},
    {"s__2287", "table,coffee_table"},
    {"s__2288", "table,coffee_table"},
    {"s__2289", "table,coffee_table"},
    {"s__2290", "cart"},
    {"s__2291", "cart"},
    {"s__2292", "table,coffee_table"},
    {"s__2293", "table,coffee_table"},
    {"s__2294", "stand"},
    {"s__2295", "table,coffee_table"},
    {"s__2296", "table,coffee_table"},
    {"s__2297", "table,coffee_table"},
    {"s__2298", "table,coffee_table"},
    {"s__2299", "table,coffee_table"},
    {"s__2300", "table,coffee_table"},
    {"s__2301", "table,coffee_table"},
    {"s__2302", "shelving"},
    {"s__2303", "shelving,wall_shelf"},
    {"s__2304", "stand"},
    {"s__2305", "bathroom_stuff,soap_tray"},
    {"s__2306", "household_appliance,weight_scale"},
    {"s__2307", "bathroom_stuff,toilet_plunger"},
    {"s__2308", "bathroom_stuff,soap_dish"},
    {"s__2309", "bathroom_stuff,trash_can"},
    {"s__2310", "bathroom_stuff,soap_dispenser"},
    {"s__2311", "bathroom_stuff,soap_tray"},
    {"s__2312", "bathroom_stuff,towel_hanger"},
    {"s__2313", "bathroom_stuff,toiletries"},
    {"s__2314", "bathroom_stuff,hair_dryer"},
    {"s__2315", "toy"},
    {"s__2316", "decoration"},
    {"s__2317", "toy"},
    {"s__2318", "kitchenware,drink"},
    {"s__2319", "kitchenware,cake,food"},
    {"s__2320", "toy"},
    {"s__2321", "kitchenware,food"},
    {"s__2322", "bench_chair"},
    {"s__2323", "bench_chair"},
    {"s__2324", "bench_chair"},
    {"s__2325", "bench_chair"},
    {"s__2326", "bench_chair"},
    {"s__2327", "bench_chair"},
    {"s__2328", "bench_chair"},
    {"s__2329", "bench_chair"},
    {"s__2330", "bench_chair"},
    {"s__2331", "bench_chair"},
    {"s__2332", "bench_chair"},
    {"s__2333", "bench_chair"},
    {"s__2334", "toy"},
    {"s__2335", "household_appliance,surveillance_camera"},
    {"s__2336", "household_appliance,lawn_mower"},
    {"s__2337", "safe"},
    {"s__2338", "mailbox"},
    {"s__2339", "kitchen_cabinet,wine_rack"},
    {"s__2340", "chair,stool"},
    {"s__2341", "chair,stool"},
    {"s__2342", "partition"},
    {"s__2343", "partition"},
    {"s__2344", "dresser"},
    {"s__2345", "safe"},
    {"s__2346", "chair,stool"},
    {"s__2347", "bed,double_bed"},
    {"s__2348", "outdoor_spring"},
    {"s__2349", "outdoor_spring"},
    {"s__2350", "table,coffee_table"},
    {"s__2351", "shelving,bookshelf"},
    {"s__2352", "wardrobe_cabinet"},
    {"s__2353", "wardrobe_cabinet"},
    {"s__2354", "wardrobe_cabinet"},
    {"s__2355", "wardrobe_cabinet"},
    {"s__2356", "wardrobe_cabinet"},
    {"s__2357", "clock"},
    {"s__2358", "fence"},
    {"s__2359", "outdoor_cover"},
    {"s__2360", "grill"},
    {"s__2361", "grill"},
    {"s__2362", "fence"},
    {"s__2363", "toy"},
    {"s__2364", "clock"},
    {"s__2365", "clock"},
    {"s__2366", "clock"},
    {"s__2367", "clock"},
    {"s__2368", "indoor_lamp,chandelier"},
    {"s__2369", "indoor_lamp,chandelier"},
    {"s__2370", "indoor_lamp,chandelier"},
    {"s__2371", "indoor_lamp,chandelier"},
    {"s__2372", "indoor_lamp,chandelier"},
    {"s__2373", "indoor_lamp,table_lamp"},
    {"s__2374", "indoor_lamp,floor_lamp"},
    {"s__2375", "cart"},
    {"s__2376", "cart"},
    {"s__2377", "cart"},
    {"s__2378", "cart"},
    {"s__2379", "cart"},
    {"s__2380", "cart"},
    {"s__2381", "cart"},
    {"s__2382", "cart"},
    {"s__2383", "cart"},
    {"s__2384", "cart"},
    {"s__2385", "cart"},
    {"s__2386", "cart"},
    {"s__2387", "cart"},
    {"s__2388", "shelving"},
    {"s__2389", "shelving"},
    {"s__2390", "shelving"},
    {"s__2391", "shelving"},
    {"s__2392", "shelving"},
    {"s__2393", "shelving"},
    {"s__2394", "shelving"},
    {"s__2395", "shelving"},
    {"s__2396", "shelving"},
    {"s__2397", "shelving"},
    {"s__2398", "shelving"},
    {"s__2399", "shelving"},
    {"s__2400", "shelving"},
    {"s__2401", "shelving"},
    {"s__2402", "shelving"},
    {"s__2403", "shelving"},
    {"s__2404", "wardrobe_cabinet"},
    {"s__2405", "shelving"},
    {"s__2406", "shelving"},
    {"s__2407", "stand,nightstand"},
    {"s__2408", "sofa"},
    {"s__2409", "sofa"},
    {"s__2410", "sofa"},
    {"s__2411", "sofa"},
    {"s__2412", "sofa,chaisse_lounge"},
    {"s__2413", "chair,armchair"},
    {"s__2414", "chair,armchair"},
    {"s__2415", "chair,armchair,sofa_chair"},
    {"s__2416", "chair,armchair,sofa_chair"},
    {"s__2417", "ottoman"},
    {"s__2418", "ottoman"},
    {"s__2419", "bench_chair"},
    {"s__2420", "ottoman"},
    {"s__2421", "ottoman"},
    {"s__2422", "ottoman"},
    {"s__2423", "ottoman"},
    {"s__2424", "chair"},
    {"s__2425", "sofa,chaisse_lounge"},
    {"s__2426", "chair,lounge_chair"},
    {"s__2427", "sofa"},
    {"s__2428", "storage_bench"},
    {"s__2429", "chair,armchair"},
    {"s__2430", "chair,lounge_chair"},
    {"s__2431", "chair,lounge_chair"},
    {"s__2432", "chair,lounge_chair"},
    {"s__2433", "chair,lounge_chair"},
    {"s__2434", "chair,armchair"},
    {"s__2435", "chair"},
    {"s__2436", "chair,armchair,sofa_chair"},
    {"s__2437", "chair,armchair"},
    {"s__2438", "ottoman"},
    {"s__2439", "sofa"},
    {"s__2440", "sofa"},
    {"s__2441", "sofa"},
    {"s__2442", "chair"},
    {"s__2443", "chair"},
    {"s__2444", "gym_equipment"},
    {"s__2445", "wardrobe_cabinet"},
    {"s__2446", "wardrobe_cabinet"},
    {"s__2447", "wardrobe_cabinet"},
    {"s__2448", "wardrobe_cabinet"},
    {"s__2449", "wardrobe_cabinet"},
    {"s__2450", "stand"},
    {"s__2451", "wardrobe_cabinet"},
    {"s__2452", "wardrobe_cabinet"},
    {"s__2453", "shelving"},
    {"s__2617", "wardrobe_cabinet"},
    {"s__2619", "wardrobe_cabinet"},
    {"s__2620", "wardrobe_cabinet"},
    {"s__2622", "wardrobe_cabinet"},
    {"s__2623", "wardrobe_cabinet"},
    {"s__361", "sofa"},
    {"s__362", "sofa"},
    {"s__363", "sofa"},
    {"s__364", "sofa"},
    {"s__365", "sofa"},
    {"s__366", "sofa_and_table"},
    {"s__367", "sofa"},
    {"s__368", "sofa_and_table"},
    {"s__369", "sofa"},
    {"s__370", "sofa"},
    {"s__371", "sofa"},
    {"s__372", "sofa"},
    {"s__373", "sofa"},
    {"s__374", "sofa"},
    {"s__375", "sofa"},
    {"s__376", "sofa"},
    {"s__377", "sofa"},
    {"s__378", "sofa"},
    {"s__379", "sofa"},
    {"s__380", "sofa"},
    {"s__382", "sofa"},
    {"s__383", "sofa"},
    {"s__384", "sofa"},
    {"s__385", "sofa"},
    {"s__386", "sofa"},
    {"s__387", "desk"},
    {"s__388", "desk,desk_with_shelves"},
    {"s__389", "dresser"},
    {"s__390", "desk"},
    {"s__391", "wardrobe_cabinet"},
    {"s__392", "desk,desk_with_shelves"},
    {"s__393", "shelving"},
    {"s__394", "chair,armchair,sofa_chair"},
    {"s__395", "chair,armchair,sofa_chair"},
    {"s__396", "shelving"},
    {"s__397", "wardrobe_cabinet"},
    {"s__398", "shelving"},
    {"s__399", "chair,armchair,sofa_chair"},
    {"s__400", "bed,single_bed"},
    {"s__401", "bed,single_bed"},
    {"s__402", "sink"},
    {"s__403", "bed,single_bed"},
    {"s__404", "bed,daybed"},
    {"s__405", "sink"},
    {"s__406", "bed,single_bed"},
    {"s__407", "bed,baby_bed"},
    {"s__408", "bed,baby_bed"},
    {"s__409", "sink"},
    {"s__410", "sink"},
    {"s__411", "shelving"},
    {"s__412", "shelving"},
    {"s__413", "shelving"},
    {"s__414", "shelving"},
    {"s__415", "shelving"},
    {"s__416", "bed,double_bed"},
    {"s__417", "bed,double_bed"},
    {"s__418", "bed,double_bed"},
    {"s__419", "bed,double_bed"},
    {"s__420", "bed,daybed"},
    {"s__421", "chair"},
    {"s__422", "bed,bunker_bed"},
    {"s__423", "chair,stool"},
    {"s__424", "chair,straight_chair"},
    {"s__425", "chair,stool"},
    {"s__426", "chair,straight_chair"},
    {"s__427", "chair,straight_chair"},
    {"s__428", "bed,bunker_bed"},
    {"s__429", "wardrobe_cabinet"},
    {"s__430", "dresser"},
    {"s__431", "wardrobe_cabinet"},
    {"s__432", "wardrobe_cabinet"},
    {"s__433", "indoor_lamp,chandelier"},
    {"s__434", "table,coffee_table"},
    {"s__435", "table,dining_table"},
    {"s__436", "indoor_lamp,chandelier"},
    {"s__437", "tv_stand"},
    {"s__438", "tv_stand"},
    {"s__439", "stand,nightstand"},
    {"s__440", "stand,nightstand"},
    {"s__441", "stand,nightstand"},
    {"s__442", "stand,nightstand"},
    {"s__443", "stand"},
    {"s__444", "wardrobe_cabinet"},
    {"s__445", "shelving"},
    {"s__446", "tv_stand"},
    {"s__447", "tv_stand"},
    {"s__448", "tv_stand"},
    {"s__449", "shelving"},
    {"s__450", "shelving,bookshelf"},
    {"s__451", "indoor_lamp,chandelier"},
    {"s__452", "tv_stand"},
    {"s__453", "chair,folding_chair"},
    {"s__454", "dresser"},
    {"s__455", "dresser"},
    {"s__456", "kitchen_cabinet,short_kitchen_cabinet"},
    {"s__457", "kitchen_cabinet,tall_kitchen_cabinet"},
    {"s__458", "sofa"},
    {"s__459", "tv_stand"},
    {"s__460", "sofa"},
    {"s__461", "sofa"},
    {"s__462", "dressing_table"},
    {"s__463", "shelving"},
    {"s__464", "shelving"},
    {"s__465", "tv_stand"},
    {"s__466", "shoes_cabinet"},
    {"s__467", "shelving,bookshelf"},
    {"s__468", "sofa"},
    {"s__469", "desk"},
    {"s__470", "desk"},
    {"s__471", "desk"},
    {"s__472", "shelving,bookshelf"},
    {"s__473", "shelving"},
    {"s__474", "indoor_lamp,chandelier"},
    {"s__475", "desk"},
    {"s__476", "desk"},
    {"s__477", "sofa"},
    {"s__478", "indoor_lamp,chandelier"},
    {"s__479", "indoor_lamp,chandelier"},
    {"s__480", "desk"},
    {"s__481", "table,coffee_table"},
    {"s__482", "desk"},
    {"s__483", "desk"},
    {"s__484", "desk"},
    {"s__485", "desk"},
    {"s__486", "indoor_lamp,chandelier"},
    {"s__487", "indoor_lamp,chandelier"},
    {"s__488", "indoor_lamp,chandelier"},
    {"s__489", "desk,desk_with_shelves"},
    {"s__490", "shelving"},
    {"s__491", "wardrobe_cabinet"},
    {"s__492", "shelving,bookshelf"},
    {"s__493", "shelving"},
    {"s__494", "mirror,medicine_cabinet"},
    {"s__495", "mirror,medicine_cabinet"},
    {"s__496", "shelving,bookshelf"},
    {"s__497", "shelving"},
    {"s__498", "shelving"},
    {"s__499", "stairs"},
    {"s__500", "sofa"},
    {"s__501", "sofa"},
    {"s__502", "sofa"},
    {"s__503", "sofa"},
    {"s__504", "sofa"},
    {"s__505", "indoor_lamp,floor_lamp"},
    {"s__506", "indoor_lamp,floor_lamp"},
    {"s__507", "indoor_lamp,floor_lamp"},
    {"s__508", "indoor_lamp,floor_lamp"},
    {"s__509", "indoor_lamp,floor_lamp"},
    {"s__510", "shelving"},
    {"s__511", "stand,nightstand"},
    {"s__512", "desk"},
    {"s__513", "sofa"},
    {"s__514", "chair,armchair,sofa_chair"},
    {"s__515", "sofa"},
    {"s__516", "tv_stand"},
    {"s__517", "wardrobe_cabinet"},
    {"s__518", "sofa"},
    {"s__519", "wardrobe_cabinet"},
    {"s__520", "shelving"},
    {"s__521", "shelving,bookshelf"},
    {"s__522", "dresser"},
    {"s__523", "dresser"},
    {"s__524", "shelving,bookshelf"},
    {"s__525", "dresser"},
    {"s__526", "dresser"},
    {"s__527", "sofa"},
    {"s__528", "sofa"},
    {"s__529", "chair,armchair,sofa_chair"},
    {"s__530", "sofa"},
    {"s__531", "dresser"},
    {"s__532", "dresser"},
    {"s__533", "mirror"},
    {"s__536", "sink"},
    {"s__537", "wardrobe_cabinet"},
    {"s__538", "mirror,medicine_cabinet"},
    {"s__539", "stand"},
    {"s__540", "chair"},
    {"s__541", "sink"},
    {"s__542", "sink"},
    {"s__543", "sofa_and_table"},
    {"s__544", "mirror"},
    {"s__545", "table,dining_table"},
    {"s__546", "table,dining_table"},
    {"s__547", "table,dining_table"},
    {"s__548", "table,dining_table"},
    {"s__549", "sofa"},
    {"s__550", "wardrobe_cabinet"},
    {"s__551", "table,coffee_table"},
    {"s__552", "desk"},
    {"s__553", "tv_stand"},
    {"s__554", "table,coffee_table"},
    {"s__555", "table,coffee_table"},
    {"s__556", "shelving"},
    {"s__557", "sink"},
    {"s__558", "sink"},
    {"s__559", "wardrobe_cabinet"},
    {"s__560", "sink"},
    {"s__561", "table,coffee_table"},
    {"s__562", "wardrobe_cabinet"},
    {"s__563", "dresser"},
    {"s__564", "wardrobe_cabinet"},
    {"s__565", "wardrobe_cabinet"},
    {"s__566", "wardrobe_cabinet"},
    {"s__567", "wardrobe_cabinet"},
    {"s__568", "shelving"},
    {"s__569", "tv_stand"},
    {"s__570", "wardrobe_cabinet"},
    {"s__571", "wardrobe_cabinet"},
    {"s__572", "wardrobe_cabinet"},
    {"s__573", "wardrobe_cabinet"},
    {"s__574", "chair,office_chair"},
    {"s__575", "chair,straight_chair"},
    {"s__576", "sink"},
    {"s__577", "sink"},
    {"s__578", "mirror,medicine_cabinet"},
    {"s__579", "vase"},
    {"s__580", "indoor_lamp,table_lamp"},
    {"s__581", "wardrobe_cabinet"},
    {"s__582", "wardrobe_cabinet"},
    {"s__583", "chair,armchair"},
    {"s__584", "shoes_cabinet"},
    {"s__585", "outdoor_seating"},
    {"s__586", "outdoor_lamp"},
    {"s__587", "sofa"},
    {"s__588", "chair,armchair,sofa_chair"},
    {"s__589", "bed,bunker_bed"},
    {"s__590", "wardrobe_cabinet"},
    {"s__591", "wardrobe_cabinet"},
    {"s__592", "dresser"},
    {"s__593", "desk,desk_with_shelves"},
    {"s__594", "stand,nightstand"},
    {"s__595", "table,coffee_table"},
    {"s__596", "chair,armchair"},
    {"s__597", "table,coffee_table"},
    {"s__598", "sofa"},
    {"s__599", "table,coffee_table"},
    {"s__600", "chair,armchair"},
    {"s__601", "sofa"},
    {"s__602", "chair,armchair,sofa_chair"},
    {"s__603", "sofa"},
    {"s__604", "table,coffee_table"},
    {"s__605", "outdoor_seating,porch_swing"},
    {"s__606", "outdoor_seating,porch_swing"},
    {"s__607", "outdoor_seating,porch_swing"},
    {"s__608", "outdoor_seating,porch_swing"},
    {"s__609", "outdoor_seating,porch_swing"},
    {"s__610", "outdoor_seating,porch_swing"},
    {"s__611", "chair,armchair,sofa_chair"},
    {"s__612", "stand,nightstand"},
    {"s__613", "outdoor_seating,porch_swing"},
    {"s__614", "outdoor_seating,porch_swing"},
    {"s__615", "chair,lounge_chair"},
    {"s__616", "shelving"},
    {"s__617", "wardrobe_cabinet"},
    {"s__618", "shelving,bookshelf"},
    {"s__619", "bed,daybed"},
    {"s__620", "shelving,bookshelf"},
    {"s__621", "chair,lounge_chair"},
    {"s__622", "chair,lounge_chair"},
    {"s__623", "chair,lounge_chair"},
    {"s__624", "chair,lounge_chair"},
    {"s__625", "chair,lounge_chair"},
    {"s__626", "chair,lounge_chair"},
    {"s__627", "chair,lounge_chair"},
    {"s__628", "chair,lounge_chair"},
    {"s__629", "chair,lounge_chair"},
    {"s__630", "chair,lounge_chair"},
    {"s__631", "chair,lounge_chair"},
    {"s__632", "chair,lounge_chair"},
    {"s__633", "chair,lounge_chair"},
    {"s__634", "outdoor_seating"},
    {"s__635", "table_and_chair"},
    {"s__636", "table_and_chair"},
    {"s__637", "table_and_chair"},
    {"s__638", "sofa_and_table"},
    {"s__639", "chair,chair_set"},
    {"s__640", "table_and_chair"},
    {"s__641", "table_and_chair"},
    {"s__642", "sofa"},
    {"s__643", "chair,armchair,sofa_chair"},
    {"s__644", "sofa"},
    {"s__645", "chair,armchair,sofa_chair"},
    {"s__646", "sofa"},
    {"s__647", "chair,armchair,sofa_chair"},
    {"s__648", "sofa"},
    {"s__649", "chair,armchair,sofa_chair"},
    {"s__650", "sofa"},
    {"s__651", "chair,armchair,sofa_chair"},
    {"s__652", "sofa"},
    {"s__653", "chair,armchair,sofa_chair"},
    {"s__654", "sofa"},
    {"s__655", "sofa"},
    {"s__656", "sofa"},
    {"s__657", "chair,armchair,sofa_chair"},
    {"s__658", "sofa"},
    {"s__659", "shelving"},
    {"s__660", "sofa"},
    {"s__661", "sofa"},
    {"s__662", "stand"},
    {"s__663", "stand"},
    {"s__664", "stand"},
    {"s__665", "stand,nightstand"},
    {"s__666", "stand"},
    {"s__667", "chair,office_chair"},
    {"s__668", "chair,office_chair"},
    {"s__669", "chair,office_chair"},
    {"s__670", "chair,office_chair"},
    {"s__671", "chair,office_chair"},
    {"s__672", "chair,office_chair"},
    {"s__673", "tv_stand"},
    {"s__674", "tv_stand"},
    {"s__675", "tv_stand"},
    {"s__676", "tv_stand"},
    {"s__677", "indoor_lamp,floor_lamp"},
    {"s__678", "indoor_lamp,floor_lamp"},
    {"s__679", "indoor_lamp,floor_lamp"},
    {"s__680", "tv_stand"},
    {"s__681", "stand"},
    {"s__682", "stand"},
    {"s__683", "dresser"},
    {"s__684", "stand,nightstand"},
    {"s__685", "stand"},
    {"s__686", "stand"},
    {"s__687", "stand,nightstand"},
    {"s__688", "table,dining_table"},
    {"s__689", "table,dining_table"},
    {"s__690", "table,dining_table"},
    {"s__691", "table,dining_table"},
    {"s__692", "dresser"},
    {"s__693", "tv_stand"},
    {"s__694", "tv_stand"},
    {"s__695", "tv_stand"},
    {"s__696", "table,dining_table"},
    {"s__697", "table,dining_table"},
    {"s__698", "table,dining_table"},
    {"s__699", "table,coffee_table"},
    {"s__700", "tv_stand"},
    {"s__701", "tv_stand"},
    {"s__702", "tv_stand"},
    {"s__703", "tv_stand"},
    {"s__704", "tv_stand"},
    {"s__705", "tv_stand"},
    {"s__706", "tv_stand"},
    {"s__707", "tv_stand"},
    {"s__708", "indoor_lamp,floor_lamp"},
    {"s__709", "indoor_lamp,floor_lamp"},
    {"s__710", "indoor_lamp,floor_lamp"},
    {"s__711", "indoor_lamp,floor_lamp"},
    {"s__712", "indoor_lamp,floor_lamp"},
    {"s__713", "indoor_lamp,floor_lamp"},
    {"s__714", "desk"},
    {"s__715", "table,dining_table"},
    {"s__716", "table,dining_table"},
    {"s__717", "table,dining_table"},
    {"s__718", "stand,nightstand"},
    {"s__719", "desk"},
    {"s__720", "table,dining_table"},
    {"s__721", "desk"},
    {"s__722", "desk"},
    {"s__723", "shoes_cabinet"},
    {"s__724", "chair,stool"},
    {"s__725", "chair,stool"},
    {"s__726", "chair,stool"},
    {"s__727", "chair,stool"},
    {"s__728", "hanger"},
    {"s__729", "hanger"},
    {"s__730", "hanger"},
    {"s__731", "hanger"},
    {"s__732", "hanger"},
    {"s__733", "hanger"},
    {"s__734", "desk"},
    {"s__735", "table,dining_table"},
    {"s__736", "table,dining_table"},
    {"s__737", "table,dining_table"},
    {"s__738", "table,dining_table"},
    {"s__739", "table,dining_table"},
    {"s__740", "table,dining_table"},
    {"s__741", "table,dining_table"},
    {"s__742", "indoor_lamp,table_lamp"},
    {"s__743", "indoor_lamp,table_lamp"},
    {"s__744", "indoor_lamp,table_lamp"},
    {"s__745", "indoor_lamp,table_lamp"},
    {"s__746", "dresser"},
    {"s__747", "wardrobe_cabinet"},
    {"s__748", "dresser"},
    {"s__749", "shoes_cabinet"},
    {"s__750", "shoes_cabinet"},
    {"s__751", "shoes_cabinet"},
    {"s__752", "shoes_cabinet"},
    {"s__753", "shoes_cabinet"},
    {"s__754", "shoes_cabinet"},
    {"s__755", "shoes_cabinet"},
    {"s__756", "wardrobe_cabinet"},
    {"s__757", "shelving,bookshelf"},
    {"s__758", "shelving,bookshelf"},
    {"s__759", "indoor_lamp,wall_lamp"},
    {"s__760", "indoor_lamp,wall_lamp"},
    {"s__761", "indoor_lamp,wall_lamp"},
    {"s__762", "indoor_lamp,wall_lamp"},
    {"s__763", "indoor_lamp,wall_lamp"},
    {"s__764", "indoor_lamp,table_lamp"},
    {"s__765", "indoor_lamp,table_lamp"},
    {"s__766", "indoor_lamp,table_lamp"},
    {"s__767", "indoor_lamp,table_lamp"},
    {"s__768", "indoor_lamp,floor_lamp"},
    {"s__769", "chair,straight_chair"},
    {"s__770", "chair,straight_chair"},
    {"s__771", "chair,armchair"},
    {"s__772", "chair,armchair"},
    {"s__773", "chair"},
    {"s__774", "chair,straight_chair"},
    {"s__775", "shelving,bookshelf"},
    {"s__776", "shelving,bookshelf"},
    {"s__777", "wardrobe_cabinet"},
    {"s__778", "wardrobe_cabinet"},
    {"s__779", "dresser"},
    {"s__780", "shelving"},
    {"s__781", "tv_stand"},
    {"s__782", "shelving"},
    {"s__783", "shelving"},
    {"s__784", "shelving"},
    {"s__785", "dresser"},
    {"s__786", "stand,nightstand"},
    {"s__787", "dresser"},
    {"s__788", "dresser"},
    {"s__789", "tv_stand"},
    {"s__790", "shelving"},
    {"s__791", "shelving"},
    {"s__792", "shelving"},
    {"s__793", "shelving"},
    {"s__794", "shelving"},
    {"s__795", "shelving"},
    {"s__796", "shelving"},
    {"s__797", "indoor_lamp,table_lamp"},
    {"s__798", "indoor_lamp,table_lamp"},
    {"s__799", "indoor_lamp,table_lamp"},
    {"s__800", "indoor_lamp,table_lamp"},
    {"s__801", "indoor_lamp,table_lamp"},
    {"s__802", "chair,straight_chair"},
    {"s__803", "chair,armchair"},
    {"s__804", "chair,straight_chair"},
    {"s__805", "chair"},
    {"s__806", "desk,desk_with_shelves"},
    {"s__807", "chair,straight_chair"},
    {"s__808", "chair,straight_chair"},
    {"s__809", "chair,straight_chair"},
    {"s__810", "dresser"},
    {"s__811", "chair,armchair"},
    {"s__812", "ottoman"},
    {"s__813", "chair"},
    {"s__814", "chair"},
    {"s__815", "chair,armchair,sofa_chair"},
    {"s__816", "sofa"},
    {"s__817", "chair,armchair,sofa_chair"},
    {"s__818", "chair,armchair"},
    {"s__819", "chair,armchair"},
    {"s__820", "chair,armchair"},
    {"s__821", "chair,armchair"},
    {"s__822", "chair"},
    {"s__823", "chair,straight_chair"},
    {"s__824", "chair,straight_chair"},
    {"s__825", "chair"},
    {"s__826", "chair,stool"},
    {"s__827", "chair,armchair"},
    {"s__828", "sink"},
    {"s__829", "sink"},
    {"s__830", "sink"},
    {"s__831", "ottoman"},
    {"s__832", "ottoman"},
    {"s__833", "ottoman"},
    {"s__834", "ottoman"},
    {"s__835", "ottoman"},
    {"s__836", "ottoman"},
    {"s__837", "ottoman"},
    {"s__838", "ottoman"},
    {"s__839", "ottoman"},
    {"s__840", "ottoman"},
    {"s__841", "ottoman"},
    {"s__842", "ottoman"},
    {"s__843", "ottoman"},
    {"s__844", "ottoman"},
    {"s__845", "ottoman"},
    {"s__846", "wardrobe_cabinet"},
    {"s__847", "wardrobe_cabinet"},
    {"s__848", "wardrobe_cabinet"},
    {"s__849", "wardrobe_cabinet"},
    {"s__850", "wardrobe_cabinet"},
    {"s__851", "wardrobe_cabinet"},
    {"s__852", "stand"},
    {"s__853", "wardrobe_cabinet"},
    {"s__854", "stand"},
    {"s__855", "wardrobe_cabinet"},
    {"s__856", "wardrobe_cabinet"},
    {"s__857", "wardrobe_cabinet"},
    {"s__858", "stand"},
    {"s__859", "wardrobe_cabinet"},
    {"s__860", "wardrobe_cabinet"},
    {"s__861", "wardrobe_cabinet"},
    {"s__862", "wardrobe_cabinet"},
    {"s__863", "stand"},
    {"s__864", "stand,nightstand"},
    {"s__865", "wardrobe_cabinet"},
    {"s__866", "stand,nightstand"},
    {"s__867", "stand"},
    {"s__868", "hanging_kitchen_cabinet,range_hood_with_cabinet"},
    {"s__869", "kitchen_appliance,range_hood"},
    {"s__870", "hanging_kitchen_cabinet,range_hood_with_cabinet"},
    {"s__871", "kitchen_appliance,range_hood"},
    {"s__872", "hanging_kitchen_cabinet,range_hood_with_cabinet"},
    {"s__873", "kitchen_appliance,range_hood"},
    {"s__874", "kitchen_appliance,range_hood"},
    {"s__875", "hanging_kitchen_cabinet,dish_shelf"},
    {"s__876", "shelving,wall_shelf"},
    {"s__877", "shelving,wall_shelf"},
    {"s__878", "cart"},
    {"s__879", "kitchen_appliance,range_hood"},
    {"s__880", "kitchen_appliance,range_hood"},
    {"s__881", "bed,double_bed"},
    {"s__882", "bed,double_bed"},
    {"s__883", "bed,double_bed"},
    {"s__884", "bed,double_bed"},
    {"s__885", "bed,single_bed"},
    {"s__886", "bed,single_bed"},
    {"s__887", "bed,baby_bed"},
    {"s__888", "bed,baby_bed"},
    {"s__889", "bed,baby_bed"},
    {"s__890", "bed,baby_bed"},
    {"s__891", "bed,baby_bed"},
    {"s__892", "bed,baby_bed"},
    {"s__893", "bed,double_bed"},
    {"s__894", "bed,double_bed"},
    {"s__895", "tv_stand"},
    {"s__896", "tv_stand"},
    {"s__897", "wardrobe_cabinet"},
    {"s__898", "wardrobe_cabinet"},
    {"s__899", "wardrobe_cabinet"},
    {"s__900", "wardrobe_cabinet"},
    {"s__901", "wardrobe_cabinet"},
    {"s__902", "wardrobe_cabinet"},
    {"s__903", "wardrobe_cabinet"},
    {"s__904", "cart"},
    {"s__905", "kitchen_cabinet,short_kitchen_cabinet"},
    {"s__906", "kitchen_cabinet,short_kitchen_cabinet"},
    {"s__907", "kitchen_cabinet,short_kitchen_cabinet"},
    {"s__908", "hanging_kitchen_cabinet"},
    {"s__909", "hanging_kitchen_cabinet"},
    {"s__910", "kitchen_cabinet,kitchen_sink"},
    {"s__911", "kitchen_cabinet,kitchen_sink"},
    {"s__912", "kitchen_cabinet,short_kitchen_cabinet"},
    {"s__913", "kitchen_cabinet,short_kitchen_cabinet_with_oven"},
    {"s__914", "kitchen_cabinet,range_oven"},
    {"s__915", "kitchen_cabinet,short_kitchen_cabinet"},
    {"s__916", "kitchen_cabinet,kitchen_sink"},
    {"s__917", "stand"},
    {"s__918", "kitchen_cabinet,short_kitchen_cabinet"},
    {"s__919", "kitchen_cabinet,short_kitchen_cabinet"},
    {"s__920", "kitchen_cabinet,kitchen_sink"},
    {"s__921", "kitchen_cabinet,kitchen_sink"},
    {"s__922", "kitchen_cabinet,kitchen_sink"},
    {"s__923", "storage_bench"},
    {"s__924", "cart"},
    {"s__925", "storage_bench"},
    {"s__926", "shelving"},
    {"s__927", "shelving"},
    {"s__928", "storage_bench"},
    {"s__929", "shelving"},
    {"s__930", "shelving"},
    {"s__931", "shelving"},
    {"s__932", "shelving"},
    {"s__933", "shelving"},
    {"s__934", "wardrobe_cabinet"},
    {"s__935", "wardrobe_cabinet"},
    {"s__936", "wardrobe_cabinet"},
    {"s__937", "wardrobe_cabinet"},
    {"s__938", "wardrobe_cabinet"},
    {"s__939", "wardrobe_cabinet"},
    {"s__940", "wardrobe_cabinet"},
    {"s__941", "wardrobe_cabinet"},
    {"s__942", "wardrobe_cabinet"},
    {"s__943", "wardrobe_cabinet"},
    {"s__944", "shelving"},
    {"s__945", "shelving"},
    {"s__946", "shelving"},
    {"s__947", "shelving"},
    {"s__948", "shelving"},
    {"s__949", "shelving"},
    {"s__950",
     "hanging_kitchen_cabinet,hanging_kitchen_cabinet_with_microwave"},
    {"s__951", "hanging_kitchen_cabinet"},
    {"s__952", "hanging_kitchen_cabinet"},
    {"s__953", "hanging_kitchen_cabinet"},
    {"s__954", "hanging_kitchen_cabinet"},
    {"s__955", "hanging_kitchen_cabinet"},
    {"s__956", "hanging_kitchen_cabinet"},
    {"s__957", "hanging_kitchen_cabinet"},
    {"s__958", "kitchen_cabinet,short_kitchen_cabinet"},
    {"s__959", "kitchen_cabinet,short_kitchen_cabinet"},
    {"s__960", "kitchen_cabinet,short_kitchen_cabinet"},
    {"s__961", "kitchen_cabinet,short_kitchen_cabinet"},
    {"s__962", "kitchen_cabinet,short_kitchen_cabinet"},
    {"s__963", "kitchen_cabinet,short_kitchen_cabinet"},
    {"s__964", "kitchen_cabinet,kitchen_sink"},
    {"s__965", "chair,lounge_chair"},
    {"s__966", "chair,stool"},
    {"s__967", "chair"},
    {"s__968", "chair,armchair"},
    {"s__969", "storage_bench"},
    {"s__970", "shelving"},
    {"s__971", "kitchen_set"},
    {"s__972", "kitchen_cabinet,kitchen_island"},
    {"s__973", "kitchen_set"},
    {"s__974", "kitchen_set"},
    {"s__975", "kitchen_set"},
    {"s__976", "kitchen_set"},
    {"s__977", "kitchen_set"},
    {"s__978", "kitchen_set"},
    {"s__979", "kitchen_set"},
    {"s__980", "kitchen_set"},
    {"s__981", "kitchen_set"},
    {"s__982", "bed,double_bed"},
    {"s__983", "wardrobe_cabinet"},
    {"s__984", "wardrobe_cabinet"},
    {"s__985", "wardrobe_cabinet"},
    {"s__986", "wardrobe_cabinet"},
    {"s__987", "wardrobe_cabinet"},
    {"s__988", "wardrobe_cabinet"},
    {"s__989", "wardrobe_cabinet"},
    {"s__990", "wardrobe_cabinet"},
    {"s__991", "wardrobe_cabinet"},
    {"s__992", "stand"},
    {"s__993", "stand"},
    {"s__994", "stand,nightstand"},
    {"s__995", "stand,nightstand"},
    {"s__996", "stand,nightstand"},
    {"s__997", "stand,nightstand"},
    {"s__998", "stand,nightstand"},
    {"s__999", "stand,nightstand"}};

}  // namespace scene
}  // namespace esp

#endif  // ESP_SCENE_SUNCGOBJECTCATEGORYMAP_H_
