//
//  Resources.swift
//  PostHog
//
//  Created by Ioannis Josephides on 10/03/2025.
//

// see: https://github.com/bring-shrubbery/SVG-to-SwiftUI

// swiftlint:disable line_length
#if os(iOS)
    import SwiftUI

    struct VeryDissatisfiedEmoji: Shape {
        func path(in rect: CGRect) -> Path {
            var path = Path()
            let width = rect.size.width
            let height = rect.size.height
            path.move(to: CGPoint(x: 0.5 * width, y: -0.43438 * height))
            path.addQuadCurve(to: CGPoint(x: 0.37344 * width, y: -0.39531 * height), control: CGPoint(x: 0.43021 * width, y: -0.43438 * height))
            path.addQuadCurve(to: CGPoint(x: 0.28958 * width, y: -0.29167 * height), control: CGPoint(x: 0.31667 * width, y: -0.35625 * height))
            path.addLine(to: CGPoint(x: 0.71042 * width, y: -0.29167 * height))
            path.addQuadCurve(to: CGPoint(x: 0.62708 * width, y: -0.39583 * height), control: CGPoint(x: 0.68437 * width, y: -0.35729 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.43438 * height), control: CGPoint(x: 0.56979 * width, y: -0.43438 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.30938 * width, y: -0.50938 * height))
            path.addLine(to: CGPoint(x: 0.36146 * width, y: -0.55625 * height))
            path.addLine(to: CGPoint(x: 0.40833 * width, y: -0.50938 * height))
            path.addLine(to: CGPoint(x: 0.44062 * width, y: -0.54688 * height))
            path.addLine(to: CGPoint(x: 0.39375 * width, y: -0.59375 * height))
            path.addLine(to: CGPoint(x: 0.44062 * width, y: -0.64063 * height))
            path.addLine(to: CGPoint(x: 0.40833 * width, y: -0.67812 * height))
            path.addLine(to: CGPoint(x: 0.36146 * width, y: -0.63125 * height))
            path.addLine(to: CGPoint(x: 0.30938 * width, y: -0.67812 * height))
            path.addLine(to: CGPoint(x: 0.27708 * width, y: -0.64063 * height))
            path.addLine(to: CGPoint(x: 0.32396 * width, y: -0.59375 * height))
            path.addLine(to: CGPoint(x: 0.27708 * width, y: -0.54688 * height))
            path.addLine(to: CGPoint(x: 0.30938 * width, y: -0.50938 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.59271 * width, y: -0.50938 * height))
            path.addLine(to: CGPoint(x: 0.63854 * width, y: -0.55625 * height))
            path.addLine(to: CGPoint(x: 0.69167 * width, y: -0.50938 * height))
            path.addLine(to: CGPoint(x: 0.72396 * width, y: -0.54688 * height))
            path.addLine(to: CGPoint(x: 0.67708 * width, y: -0.59375 * height))
            path.addLine(to: CGPoint(x: 0.72396 * width, y: -0.64063 * height))
            path.addLine(to: CGPoint(x: 0.69167 * width, y: -0.67812 * height))
            path.addLine(to: CGPoint(x: 0.63854 * width, y: -0.63125 * height))
            path.addLine(to: CGPoint(x: 0.59271 * width, y: -0.67812 * height))
            path.addLine(to: CGPoint(x: 0.56042 * width, y: -0.64063 * height))
            path.addLine(to: CGPoint(x: 0.60625 * width, y: -0.59375 * height))
            path.addLine(to: CGPoint(x: 0.56042 * width, y: -0.54688 * height))
            path.addLine(to: CGPoint(x: 0.59271 * width, y: -0.50938 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.5 * width, y: -0.08333 * height))
            path.addQuadCurve(to: CGPoint(x: 0.3375 * width, y: -0.11615 * height), control: CGPoint(x: 0.41354 * width, y: -0.08333 * height))
            path.addQuadCurve(to: CGPoint(x: 0.20521 * width, y: -0.20521 * height), control: CGPoint(x: 0.26146 * width, y: -0.14896 * height))
            path.addQuadCurve(to: CGPoint(x: 0.11615 * width, y: -0.3375 * height), control: CGPoint(x: 0.14896 * width, y: -0.26146 * height))
            path.addQuadCurve(to: CGPoint(x: 0.08333 * width, y: -0.5 * height), control: CGPoint(x: 0.08333 * width, y: -0.41354 * height))
            path.addQuadCurve(to: CGPoint(x: 0.11615 * width, y: -0.6625 * height), control: CGPoint(x: 0.08333 * width, y: -0.58646 * height))
            path.addQuadCurve(to: CGPoint(x: 0.20521 * width, y: -0.79479 * height), control: CGPoint(x: 0.14896 * width, y: -0.73854 * height))
            path.addQuadCurve(to: CGPoint(x: 0.3375 * width, y: -0.88385 * height), control: CGPoint(x: 0.26146 * width, y: -0.85104 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.91667 * height), control: CGPoint(x: 0.41354 * width, y: -0.91667 * height))
            path.addQuadCurve(to: CGPoint(x: 0.6625 * width, y: -0.88385 * height), control: CGPoint(x: 0.58646 * width, y: -0.91667 * height))
            path.addQuadCurve(to: CGPoint(x: 0.79479 * width, y: -0.79479 * height), control: CGPoint(x: 0.73854 * width, y: -0.85104 * height))
            path.addQuadCurve(to: CGPoint(x: 0.88385 * width, y: -0.6625 * height), control: CGPoint(x: 0.85104 * width, y: -0.73854 * height))
            path.addQuadCurve(to: CGPoint(x: 0.91667 * width, y: -0.5 * height), control: CGPoint(x: 0.91667 * width, y: -0.58646 * height))
            path.addQuadCurve(to: CGPoint(x: 0.88385 * width, y: -0.3375 * height), control: CGPoint(x: 0.91667 * width, y: -0.41354 * height))
            path.addQuadCurve(to: CGPoint(x: 0.79479 * width, y: -0.20521 * height), control: CGPoint(x: 0.85104 * width, y: -0.26146 * height))
            path.addQuadCurve(to: CGPoint(x: 0.6625 * width, y: -0.11615 * height), control: CGPoint(x: 0.73854 * width, y: -0.14896 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.08333 * height), control: CGPoint(x: 0.58646 * width, y: -0.08333 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.5 * width, y: -0.5 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.5 * width, y: -0.14583 * height))
            path.addQuadCurve(to: CGPoint(x: 0.75104 * width, y: -0.24896 * height), control: CGPoint(x: 0.64792 * width, y: -0.14583 * height))
            path.addQuadCurve(to: CGPoint(x: 0.85417 * width, y: -0.5 * height), control: CGPoint(x: 0.85417 * width, y: -0.35208 * height))
            path.addQuadCurve(to: CGPoint(x: 0.75104 * width, y: -0.75104 * height), control: CGPoint(x: 0.85417 * width, y: -0.64792 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.85417 * height), control: CGPoint(x: 0.64792 * width, y: -0.85417 * height))
            path.addQuadCurve(to: CGPoint(x: 0.24896 * width, y: -0.75104 * height), control: CGPoint(x: 0.35208 * width, y: -0.85417 * height))
            path.addQuadCurve(to: CGPoint(x: 0.14583 * width, y: -0.5 * height), control: CGPoint(x: 0.14583 * width, y: -0.64792 * height))
            path.addQuadCurve(to: CGPoint(x: 0.24896 * width, y: -0.24896 * height), control: CGPoint(x: 0.14583 * width, y: -0.35208 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.14583 * height), control: CGPoint(x: 0.35208 * width, y: -0.14583 * height))
            path.closeSubpath()
            return path.offsetBy(dx: 0, dy: height)
        }
    }

    struct VerySatisfiedEmoji: Shape {
        func path(in rect: CGRect) -> Path {
            var path = Path()
            let width = rect.size.width
            let height = rect.size.height
            path.move(to: CGPoint(x: 0.49948 * width, y: -0.27187 * height))
            path.addQuadCurve(to: CGPoint(x: 0.6099 * width, y: -0.29896 * height), control: CGPoint(x: 0.55937 * width, y: -0.27187 * height))
            path.addQuadCurve(to: CGPoint(x: 0.69167 * width, y: -0.37437 * height), control: CGPoint(x: 0.66042 * width, y: -0.32604 * height))
            path.addQuadCurve(to: CGPoint(x: 0.69089 * width, y: -0.39792 * height), control: CGPoint(x: 0.69792 * width, y: -0.38646 * height))
            path.addQuadCurve(to: CGPoint(x: 0.66979 * width, y: -0.40937 * height), control: CGPoint(x: 0.68385 * width, y: -0.40937 * height))
            path.addLine(to: CGPoint(x: 0.33012 * width, y: -0.40937 * height))
            path.addQuadCurve(to: CGPoint(x: 0.30885 * width, y: -0.39792 * height), control: CGPoint(x: 0.31562 * width, y: -0.40937 * height))
            path.addQuadCurve(to: CGPoint(x: 0.30833 * width, y: -0.37437 * height), control: CGPoint(x: 0.30208 * width, y: -0.38646 * height))
            path.addQuadCurve(to: CGPoint(x: 0.3901 * width, y: -0.29896 * height), control: CGPoint(x: 0.33958 * width, y: -0.32604 * height))
            path.addQuadCurve(to: CGPoint(x: 0.49948 * width, y: -0.27187 * height), control: CGPoint(x: 0.44062 * width, y: -0.27187 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.36146 * width, y: -0.60208 * height))
            path.addLine(to: CGPoint(x: 0.38958 * width, y: -0.57396 * height))
            path.addQuadCurve(to: CGPoint(x: 0.40814 * width, y: -0.56563 * height), control: CGPoint(x: 0.39754 * width, y: -0.56563 * height))
            path.addQuadCurve(to: CGPoint(x: 0.42708 * width, y: -0.57396 * height), control: CGPoint(x: 0.41875 * width, y: -0.56563 * height))
            path.addQuadCurve(to: CGPoint(x: 0.43542 * width, y: -0.59271 * height), control: CGPoint(x: 0.43542 * width, y: -0.58229 * height))
            path.addQuadCurve(to: CGPoint(x: 0.42708 * width, y: -0.61146 * height), control: CGPoint(x: 0.43542 * width, y: -0.60313 * height))
            path.addLine(to: CGPoint(x: 0.38333 * width, y: -0.65521 * height))
            path.addQuadCurve(to: CGPoint(x: 0.36156 * width, y: -0.66458 * height), control: CGPoint(x: 0.37417 * width, y: -0.66458 * height))
            path.addQuadCurve(to: CGPoint(x: 0.33958 * width, y: -0.65521 * height), control: CGPoint(x: 0.34896 * width, y: -0.66458 * height))
            path.addLine(to: CGPoint(x: 0.29583 * width, y: -0.61146 * height))
            path.addQuadCurve(to: CGPoint(x: 0.2875 * width, y: -0.5929 * height), control: CGPoint(x: 0.2875 * width, y: -0.6035 * height))
            path.addQuadCurve(to: CGPoint(x: 0.29583 * width, y: -0.57396 * height), control: CGPoint(x: 0.2875 * width, y: -0.58229 * height))
            path.addQuadCurve(to: CGPoint(x: 0.31458 * width, y: -0.56563 * height), control: CGPoint(x: 0.30417 * width, y: -0.56563 * height))
            path.addQuadCurve(to: CGPoint(x: 0.33333 * width, y: -0.57396 * height), control: CGPoint(x: 0.325 * width, y: -0.56563 * height))
            path.addLine(to: CGPoint(x: 0.36146 * width, y: -0.60208 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.63958 * width, y: -0.60208 * height))
            path.addLine(to: CGPoint(x: 0.66771 * width, y: -0.57396 * height))
            path.addQuadCurve(to: CGPoint(x: 0.68646 * width, y: -0.56563 * height), control: CGPoint(x: 0.67574 * width, y: -0.56563 * height))
            path.addQuadCurve(to: CGPoint(x: 0.70521 * width, y: -0.57396 * height), control: CGPoint(x: 0.69717 * width, y: -0.56563 * height))
            path.addQuadCurve(to: CGPoint(x: 0.71354 * width, y: -0.59252 * height), control: CGPoint(x: 0.71354 * width, y: -0.58191 * height))
            path.addQuadCurve(to: CGPoint(x: 0.70521 * width, y: -0.61146 * height), control: CGPoint(x: 0.71354 * width, y: -0.60313 * height))
            path.addLine(to: CGPoint(x: 0.66146 * width, y: -0.65521 * height))
            path.addQuadCurve(to: CGPoint(x: 0.63969 * width, y: -0.66458 * height), control: CGPoint(x: 0.65229 * width, y: -0.66458 * height))
            path.addQuadCurve(to: CGPoint(x: 0.61771 * width, y: -0.65521 * height), control: CGPoint(x: 0.62708 * width, y: -0.66458 * height))
            path.addLine(to: CGPoint(x: 0.57396 * width, y: -0.61146 * height))
            path.addQuadCurve(to: CGPoint(x: 0.56563 * width, y: -0.59271 * height), control: CGPoint(x: 0.56563 * width, y: -0.60342 * height))
            path.addQuadCurve(to: CGPoint(x: 0.57396 * width, y: -0.57396 * height), control: CGPoint(x: 0.56563 * width, y: -0.58199 * height))
            path.addQuadCurve(to: CGPoint(x: 0.59252 * width, y: -0.56563 * height), control: CGPoint(x: 0.58191 * width, y: -0.56563 * height))
            path.addQuadCurve(to: CGPoint(x: 0.61146 * width, y: -0.57396 * height), control: CGPoint(x: 0.60313 * width, y: -0.56563 * height))
            path.addLine(to: CGPoint(x: 0.63958 * width, y: -0.60208 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.5 * width, y: -0.08333 * height))
            path.addQuadCurve(to: CGPoint(x: 0.3375 * width, y: -0.11615 * height), control: CGPoint(x: 0.41354 * width, y: -0.08333 * height))
            path.addQuadCurve(to: CGPoint(x: 0.20521 * width, y: -0.20521 * height), control: CGPoint(x: 0.26146 * width, y: -0.14896 * height))
            path.addQuadCurve(to: CGPoint(x: 0.11615 * width, y: -0.3375 * height), control: CGPoint(x: 0.14896 * width, y: -0.26146 * height))
            path.addQuadCurve(to: CGPoint(x: 0.08333 * width, y: -0.5 * height), control: CGPoint(x: 0.08333 * width, y: -0.41354 * height))
            path.addQuadCurve(to: CGPoint(x: 0.11615 * width, y: -0.6625 * height), control: CGPoint(x: 0.08333 * width, y: -0.58646 * height))
            path.addQuadCurve(to: CGPoint(x: 0.20521 * width, y: -0.79479 * height), control: CGPoint(x: 0.14896 * width, y: -0.73854 * height))
            path.addQuadCurve(to: CGPoint(x: 0.3375 * width, y: -0.88385 * height), control: CGPoint(x: 0.26146 * width, y: -0.85104 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.91667 * height), control: CGPoint(x: 0.41354 * width, y: -0.91667 * height))
            path.addQuadCurve(to: CGPoint(x: 0.6625 * width, y: -0.88385 * height), control: CGPoint(x: 0.58646 * width, y: -0.91667 * height))
            path.addQuadCurve(to: CGPoint(x: 0.79479 * width, y: -0.79479 * height), control: CGPoint(x: 0.73854 * width, y: -0.85104 * height))
            path.addQuadCurve(to: CGPoint(x: 0.88385 * width, y: -0.6625 * height), control: CGPoint(x: 0.85104 * width, y: -0.73854 * height))
            path.addQuadCurve(to: CGPoint(x: 0.91667 * width, y: -0.5 * height), control: CGPoint(x: 0.91667 * width, y: -0.58646 * height))
            path.addQuadCurve(to: CGPoint(x: 0.88385 * width, y: -0.3375 * height), control: CGPoint(x: 0.91667 * width, y: -0.41354 * height))
            path.addQuadCurve(to: CGPoint(x: 0.79479 * width, y: -0.20521 * height), control: CGPoint(x: 0.85104 * width, y: -0.26146 * height))
            path.addQuadCurve(to: CGPoint(x: 0.6625 * width, y: -0.11615 * height), control: CGPoint(x: 0.73854 * width, y: -0.14896 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.08333 * height), control: CGPoint(x: 0.58646 * width, y: -0.08333 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.5 * width, y: -0.5 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.5 * width, y: -0.14583 * height))
            path.addQuadCurve(to: CGPoint(x: 0.75124 * width, y: -0.24876 * height), control: CGPoint(x: 0.64831 * width, y: -0.14583 * height))
            path.addQuadCurve(to: CGPoint(x: 0.85417 * width, y: -0.5 * height), control: CGPoint(x: 0.85417 * width, y: -0.35169 * height))
            path.addQuadCurve(to: CGPoint(x: 0.75124 * width, y: -0.75124 * height), control: CGPoint(x: 0.85417 * width, y: -0.64831 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.85417 * height), control: CGPoint(x: 0.64831 * width, y: -0.85417 * height))
            path.addQuadCurve(to: CGPoint(x: 0.24876 * width, y: -0.75124 * height), control: CGPoint(x: 0.35169 * width, y: -0.85417 * height))
            path.addQuadCurve(to: CGPoint(x: 0.14583 * width, y: -0.5 * height), control: CGPoint(x: 0.14583 * width, y: -0.64831 * height))
            path.addQuadCurve(to: CGPoint(x: 0.24876 * width, y: -0.24876 * height), control: CGPoint(x: 0.14583 * width, y: -0.35169 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.14583 * height), control: CGPoint(x: 0.35169 * width, y: -0.14583 * height))
            path.closeSubpath()
            return path.offsetBy(dx: 0, dy: height)
        }
    }

    struct DissatisfiedEmoji: Shape {
        func path(in rect: CGRect) -> Path {
            var path = Path()
            let width = rect.size.width
            let height = rect.size.height
            path.move(to: CGPoint(x: 0.65208 * width, y: -0.55521 * height))
            path.addQuadCurve(to: CGPoint(x: 0.69193 * width, y: -0.57161 * height), control: CGPoint(x: 0.67552 * width, y: -0.55521 * height))
            path.addQuadCurve(to: CGPoint(x: 0.70833 * width, y: -0.61146 * height), control: CGPoint(x: 0.70833 * width, y: -0.58802 * height))
            path.addQuadCurve(to: CGPoint(x: 0.69193 * width, y: -0.6513 * height), control: CGPoint(x: 0.70833 * width, y: -0.6349 * height))
            path.addQuadCurve(to: CGPoint(x: 0.65208 * width, y: -0.66771 * height), control: CGPoint(x: 0.67552 * width, y: -0.66771 * height))
            path.addQuadCurve(to: CGPoint(x: 0.61224 * width, y: -0.6513 * height), control: CGPoint(x: 0.62865 * width, y: -0.66771 * height))
            path.addQuadCurve(to: CGPoint(x: 0.59583 * width, y: -0.61146 * height), control: CGPoint(x: 0.59583 * width, y: -0.6349 * height))
            path.addQuadCurve(to: CGPoint(x: 0.61224 * width, y: -0.57161 * height), control: CGPoint(x: 0.59583 * width, y: -0.58802 * height))
            path.addQuadCurve(to: CGPoint(x: 0.65208 * width, y: -0.55521 * height), control: CGPoint(x: 0.62865 * width, y: -0.55521 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.34792 * width, y: -0.55521 * height))
            path.addQuadCurve(to: CGPoint(x: 0.38776 * width, y: -0.57161 * height), control: CGPoint(x: 0.37135 * width, y: -0.55521 * height))
            path.addQuadCurve(to: CGPoint(x: 0.40417 * width, y: -0.61146 * height), control: CGPoint(x: 0.40417 * width, y: -0.58802 * height))
            path.addQuadCurve(to: CGPoint(x: 0.38776 * width, y: -0.6513 * height), control: CGPoint(x: 0.40417 * width, y: -0.6349 * height))
            path.addQuadCurve(to: CGPoint(x: 0.34792 * width, y: -0.66771 * height), control: CGPoint(x: 0.37135 * width, y: -0.66771 * height))
            path.addQuadCurve(to: CGPoint(x: 0.30807 * width, y: -0.6513 * height), control: CGPoint(x: 0.32448 * width, y: -0.66771 * height))
            path.addQuadCurve(to: CGPoint(x: 0.29167 * width, y: -0.61146 * height), control: CGPoint(x: 0.29167 * width, y: -0.6349 * height))
            path.addQuadCurve(to: CGPoint(x: 0.30807 * width, y: -0.57161 * height), control: CGPoint(x: 0.29167 * width, y: -0.58802 * height))
            path.addQuadCurve(to: CGPoint(x: 0.34792 * width, y: -0.55521 * height), control: CGPoint(x: 0.32448 * width, y: -0.55521 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.50018 * width, y: -0.43438 * height))
            path.addQuadCurve(to: CGPoint(x: 0.37344 * width, y: -0.39531 * height), control: CGPoint(x: 0.43021 * width, y: -0.43438 * height))
            path.addQuadCurve(to: CGPoint(x: 0.28958 * width, y: -0.29167 * height), control: CGPoint(x: 0.31667 * width, y: -0.35625 * height))
            path.addLine(to: CGPoint(x: 0.34479 * width, y: -0.29167 * height))
            path.addQuadCurve(to: CGPoint(x: 0.40956 * width, y: -0.35938 * height), control: CGPoint(x: 0.36771 * width, y: -0.33542 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5007 * width, y: -0.38333 * height), control: CGPoint(x: 0.4514 * width, y: -0.38333 * height))
            path.addQuadCurve(to: CGPoint(x: 0.59115 * width, y: -0.35885 * height), control: CGPoint(x: 0.55 * width, y: -0.38333 * height))
            path.addQuadCurve(to: CGPoint(x: 0.65625 * width, y: -0.29167 * height), control: CGPoint(x: 0.63229 * width, y: -0.33437 * height))
            path.addLine(to: CGPoint(x: 0.71042 * width, y: -0.29167 * height))
            path.addQuadCurve(to: CGPoint(x: 0.62726 * width, y: -0.39583 * height), control: CGPoint(x: 0.68437 * width, y: -0.35729 * height))
            path.addQuadCurve(to: CGPoint(x: 0.50018 * width, y: -0.43438 * height), control: CGPoint(x: 0.57015 * width, y: -0.43438 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.5 * width, y: -0.08333 * height))
            path.addQuadCurve(to: CGPoint(x: 0.3375 * width, y: -0.11615 * height), control: CGPoint(x: 0.41354 * width, y: -0.08333 * height))
            path.addQuadCurve(to: CGPoint(x: 0.20521 * width, y: -0.20521 * height), control: CGPoint(x: 0.26146 * width, y: -0.14896 * height))
            path.addQuadCurve(to: CGPoint(x: 0.11615 * width, y: -0.3375 * height), control: CGPoint(x: 0.14896 * width, y: -0.26146 * height))
            path.addQuadCurve(to: CGPoint(x: 0.08333 * width, y: -0.5 * height), control: CGPoint(x: 0.08333 * width, y: -0.41354 * height))
            path.addQuadCurve(to: CGPoint(x: 0.11615 * width, y: -0.6625 * height), control: CGPoint(x: 0.08333 * width, y: -0.58646 * height))
            path.addQuadCurve(to: CGPoint(x: 0.20521 * width, y: -0.79479 * height), control: CGPoint(x: 0.14896 * width, y: -0.73854 * height))
            path.addQuadCurve(to: CGPoint(x: 0.3375 * width, y: -0.88385 * height), control: CGPoint(x: 0.26146 * width, y: -0.85104 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.91667 * height), control: CGPoint(x: 0.41354 * width, y: -0.91667 * height))
            path.addQuadCurve(to: CGPoint(x: 0.6625 * width, y: -0.88385 * height), control: CGPoint(x: 0.58646 * width, y: -0.91667 * height))
            path.addQuadCurve(to: CGPoint(x: 0.79479 * width, y: -0.79479 * height), control: CGPoint(x: 0.73854 * width, y: -0.85104 * height))
            path.addQuadCurve(to: CGPoint(x: 0.88385 * width, y: -0.6625 * height), control: CGPoint(x: 0.85104 * width, y: -0.73854 * height))
            path.addQuadCurve(to: CGPoint(x: 0.91667 * width, y: -0.5 * height), control: CGPoint(x: 0.91667 * width, y: -0.58646 * height))
            path.addQuadCurve(to: CGPoint(x: 0.88385 * width, y: -0.3375 * height), control: CGPoint(x: 0.91667 * width, y: -0.41354 * height))
            path.addQuadCurve(to: CGPoint(x: 0.79479 * width, y: -0.20521 * height), control: CGPoint(x: 0.85104 * width, y: -0.26146 * height))
            path.addQuadCurve(to: CGPoint(x: 0.6625 * width, y: -0.11615 * height), control: CGPoint(x: 0.73854 * width, y: -0.14896 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.08333 * height), control: CGPoint(x: 0.58646 * width, y: -0.08333 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.5 * width, y: -0.5 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.5 * width, y: -0.14583 * height))
            path.addQuadCurve(to: CGPoint(x: 0.75124 * width, y: -0.24876 * height), control: CGPoint(x: 0.64831 * width, y: -0.14583 * height))
            path.addQuadCurve(to: CGPoint(x: 0.85417 * width, y: -0.5 * height), control: CGPoint(x: 0.85417 * width, y: -0.35169 * height))
            path.addQuadCurve(to: CGPoint(x: 0.75124 * width, y: -0.75124 * height), control: CGPoint(x: 0.85417 * width, y: -0.64831 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.85417 * height), control: CGPoint(x: 0.64831 * width, y: -0.85417 * height))
            path.addQuadCurve(to: CGPoint(x: 0.24876 * width, y: -0.75124 * height), control: CGPoint(x: 0.35169 * width, y: -0.85417 * height))
            path.addQuadCurve(to: CGPoint(x: 0.14583 * width, y: -0.5 * height), control: CGPoint(x: 0.14583 * width, y: -0.64831 * height))
            path.addQuadCurve(to: CGPoint(x: 0.24876 * width, y: -0.24876 * height), control: CGPoint(x: 0.14583 * width, y: -0.35169 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.14583 * height), control: CGPoint(x: 0.35169 * width, y: -0.14583 * height))
            path.closeSubpath()
            return path.offsetBy(dx: 0, dy: height)
        }
    }

    struct NeutralEmoji: Shape {
        func path(in rect: CGRect) -> Path {
            var path = Path()
            let width = rect.size.width
            let height = rect.size.height
            path.move(to: CGPoint(x: 0.65208 * width, y: -0.55521 * height))
            path.addQuadCurve(to: CGPoint(x: 0.69193 * width, y: -0.57161 * height), control: CGPoint(x: 0.67552 * width, y: -0.55521 * height))
            path.addQuadCurve(to: CGPoint(x: 0.70833 * width, y: -0.61146 * height), control: CGPoint(x: 0.70833 * width, y: -0.58802 * height))
            path.addQuadCurve(to: CGPoint(x: 0.69193 * width, y: -0.6513 * height), control: CGPoint(x: 0.70833 * width, y: -0.6349 * height))
            path.addQuadCurve(to: CGPoint(x: 0.65208 * width, y: -0.66771 * height), control: CGPoint(x: 0.67552 * width, y: -0.66771 * height))
            path.addQuadCurve(to: CGPoint(x: 0.61224 * width, y: -0.6513 * height), control: CGPoint(x: 0.62865 * width, y: -0.66771 * height))
            path.addQuadCurve(to: CGPoint(x: 0.59583 * width, y: -0.61146 * height), control: CGPoint(x: 0.59583 * width, y: -0.6349 * height))
            path.addQuadCurve(to: CGPoint(x: 0.61224 * width, y: -0.57161 * height), control: CGPoint(x: 0.59583 * width, y: -0.58802 * height))
            path.addQuadCurve(to: CGPoint(x: 0.65208 * width, y: -0.55521 * height), control: CGPoint(x: 0.62865 * width, y: -0.55521 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.34792 * width, y: -0.55521 * height))
            path.addQuadCurve(to: CGPoint(x: 0.38776 * width, y: -0.57161 * height), control: CGPoint(x: 0.37135 * width, y: -0.55521 * height))
            path.addQuadCurve(to: CGPoint(x: 0.40417 * width, y: -0.61146 * height), control: CGPoint(x: 0.40417 * width, y: -0.58802 * height))
            path.addQuadCurve(to: CGPoint(x: 0.38776 * width, y: -0.6513 * height), control: CGPoint(x: 0.40417 * width, y: -0.6349 * height))
            path.addQuadCurve(to: CGPoint(x: 0.34792 * width, y: -0.66771 * height), control: CGPoint(x: 0.37135 * width, y: -0.66771 * height))
            path.addQuadCurve(to: CGPoint(x: 0.30807 * width, y: -0.6513 * height), control: CGPoint(x: 0.32448 * width, y: -0.66771 * height))
            path.addQuadCurve(to: CGPoint(x: 0.29167 * width, y: -0.61146 * height), control: CGPoint(x: 0.29167 * width, y: -0.6349 * height))
            path.addQuadCurve(to: CGPoint(x: 0.30807 * width, y: -0.57161 * height), control: CGPoint(x: 0.29167 * width, y: -0.58802 * height))
            path.addQuadCurve(to: CGPoint(x: 0.34792 * width, y: -0.55521 * height), control: CGPoint(x: 0.32448 * width, y: -0.55521 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.36875 * width, y: -0.35313 * height))
            path.addLine(to: CGPoint(x: 0.63229 * width, y: -0.35313 * height))
            path.addLine(to: CGPoint(x: 0.63229 * width, y: -0.40417 * height))
            path.addLine(to: CGPoint(x: 0.36875 * width, y: -0.40417 * height))
            path.addLine(to: CGPoint(x: 0.36875 * width, y: -0.35313 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.5 * width, y: -0.08333 * height))
            path.addQuadCurve(to: CGPoint(x: 0.3375 * width, y: -0.11615 * height), control: CGPoint(x: 0.41354 * width, y: -0.08333 * height))
            path.addQuadCurve(to: CGPoint(x: 0.20521 * width, y: -0.20521 * height), control: CGPoint(x: 0.26146 * width, y: -0.14896 * height))
            path.addQuadCurve(to: CGPoint(x: 0.11615 * width, y: -0.3375 * height), control: CGPoint(x: 0.14896 * width, y: -0.26146 * height))
            path.addQuadCurve(to: CGPoint(x: 0.08333 * width, y: -0.5 * height), control: CGPoint(x: 0.08333 * width, y: -0.41354 * height))
            path.addQuadCurve(to: CGPoint(x: 0.11615 * width, y: -0.6625 * height), control: CGPoint(x: 0.08333 * width, y: -0.58646 * height))
            path.addQuadCurve(to: CGPoint(x: 0.20521 * width, y: -0.79479 * height), control: CGPoint(x: 0.14896 * width, y: -0.73854 * height))
            path.addQuadCurve(to: CGPoint(x: 0.3375 * width, y: -0.88385 * height), control: CGPoint(x: 0.26146 * width, y: -0.85104 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.91667 * height), control: CGPoint(x: 0.41354 * width, y: -0.91667 * height))
            path.addQuadCurve(to: CGPoint(x: 0.6625 * width, y: -0.88385 * height), control: CGPoint(x: 0.58646 * width, y: -0.91667 * height))
            path.addQuadCurve(to: CGPoint(x: 0.79479 * width, y: -0.79479 * height), control: CGPoint(x: 0.73854 * width, y: -0.85104 * height))
            path.addQuadCurve(to: CGPoint(x: 0.88385 * width, y: -0.6625 * height), control: CGPoint(x: 0.85104 * width, y: -0.73854 * height))
            path.addQuadCurve(to: CGPoint(x: 0.91667 * width, y: -0.5 * height), control: CGPoint(x: 0.91667 * width, y: -0.58646 * height))
            path.addQuadCurve(to: CGPoint(x: 0.88385 * width, y: -0.3375 * height), control: CGPoint(x: 0.91667 * width, y: -0.41354 * height))
            path.addQuadCurve(to: CGPoint(x: 0.79479 * width, y: -0.20521 * height), control: CGPoint(x: 0.85104 * width, y: -0.26146 * height))
            path.addQuadCurve(to: CGPoint(x: 0.6625 * width, y: -0.11615 * height), control: CGPoint(x: 0.73854 * width, y: -0.14896 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.08333 * height), control: CGPoint(x: 0.58646 * width, y: -0.08333 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.5 * width, y: -0.5 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.5 * width, y: -0.14583 * height))
            path.addQuadCurve(to: CGPoint(x: 0.75124 * width, y: -0.24876 * height), control: CGPoint(x: 0.64831 * width, y: -0.14583 * height))
            path.addQuadCurve(to: CGPoint(x: 0.85417 * width, y: -0.5 * height), control: CGPoint(x: 0.85417 * width, y: -0.35169 * height))
            path.addQuadCurve(to: CGPoint(x: 0.75124 * width, y: -0.75124 * height), control: CGPoint(x: 0.85417 * width, y: -0.64831 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.85417 * height), control: CGPoint(x: 0.64831 * width, y: -0.85417 * height))
            path.addQuadCurve(to: CGPoint(x: 0.24876 * width, y: -0.75124 * height), control: CGPoint(x: 0.35169 * width, y: -0.85417 * height))
            path.addQuadCurve(to: CGPoint(x: 0.14583 * width, y: -0.5 * height), control: CGPoint(x: 0.14583 * width, y: -0.64831 * height))
            path.addQuadCurve(to: CGPoint(x: 0.24876 * width, y: -0.24876 * height), control: CGPoint(x: 0.14583 * width, y: -0.35169 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.14583 * height), control: CGPoint(x: 0.35169 * width, y: -0.14583 * height))
            path.closeSubpath()
            return path.offsetBy(dx: 0, dy: height)
        }
    }

    struct SatisfiedEmoji: Shape {
        func path(in rect: CGRect) -> Path {
            var path = Path()
            let width = rect.size.width
            let height = rect.size.height
            path.move(to: CGPoint(x: 0.65208 * width, y: -0.55521 * height))
            path.addQuadCurve(to: CGPoint(x: 0.69193 * width, y: -0.57161 * height), control: CGPoint(x: 0.67552 * width, y: -0.55521 * height))
            path.addQuadCurve(to: CGPoint(x: 0.70833 * width, y: -0.61146 * height), control: CGPoint(x: 0.70833 * width, y: -0.58802 * height))
            path.addQuadCurve(to: CGPoint(x: 0.69193 * width, y: -0.6513 * height), control: CGPoint(x: 0.70833 * width, y: -0.6349 * height))
            path.addQuadCurve(to: CGPoint(x: 0.65208 * width, y: -0.66771 * height), control: CGPoint(x: 0.67552 * width, y: -0.66771 * height))
            path.addQuadCurve(to: CGPoint(x: 0.61224 * width, y: -0.6513 * height), control: CGPoint(x: 0.62865 * width, y: -0.66771 * height))
            path.addQuadCurve(to: CGPoint(x: 0.59583 * width, y: -0.61146 * height), control: CGPoint(x: 0.59583 * width, y: -0.6349 * height))
            path.addQuadCurve(to: CGPoint(x: 0.61224 * width, y: -0.57161 * height), control: CGPoint(x: 0.59583 * width, y: -0.58802 * height))
            path.addQuadCurve(to: CGPoint(x: 0.65208 * width, y: -0.55521 * height), control: CGPoint(x: 0.62865 * width, y: -0.55521 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.34792 * width, y: -0.55521 * height))
            path.addQuadCurve(to: CGPoint(x: 0.38776 * width, y: -0.57161 * height), control: CGPoint(x: 0.37135 * width, y: -0.55521 * height))
            path.addQuadCurve(to: CGPoint(x: 0.40417 * width, y: -0.61146 * height), control: CGPoint(x: 0.40417 * width, y: -0.58802 * height))
            path.addQuadCurve(to: CGPoint(x: 0.38776 * width, y: -0.6513 * height), control: CGPoint(x: 0.40417 * width, y: -0.6349 * height))
            path.addQuadCurve(to: CGPoint(x: 0.34792 * width, y: -0.66771 * height), control: CGPoint(x: 0.37135 * width, y: -0.66771 * height))
            path.addQuadCurve(to: CGPoint(x: 0.30807 * width, y: -0.6513 * height), control: CGPoint(x: 0.32448 * width, y: -0.66771 * height))
            path.addQuadCurve(to: CGPoint(x: 0.29167 * width, y: -0.61146 * height), control: CGPoint(x: 0.29167 * width, y: -0.6349 * height))
            path.addQuadCurve(to: CGPoint(x: 0.30807 * width, y: -0.57161 * height), control: CGPoint(x: 0.29167 * width, y: -0.58802 * height))
            path.addQuadCurve(to: CGPoint(x: 0.34792 * width, y: -0.55521 * height), control: CGPoint(x: 0.32448 * width, y: -0.55521 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.5 * width, y: -0.27187 * height))
            path.addQuadCurve(to: CGPoint(x: 0.62656 * width, y: -0.30885 * height), control: CGPoint(x: 0.56875 * width, y: -0.27187 * height))
            path.addQuadCurve(to: CGPoint(x: 0.71042 * width, y: -0.40937 * height), control: CGPoint(x: 0.68437 * width, y: -0.34583 * height))
            path.addLine(to: CGPoint(x: 0.65625 * width, y: -0.40937 * height))
            path.addQuadCurve(to: CGPoint(x: 0.59062 * width, y: -0.34531 * height), control: CGPoint(x: 0.63229 * width, y: -0.36771 * height))
            path.addQuadCurve(to: CGPoint(x: 0.50052 * width, y: -0.32292 * height), control: CGPoint(x: 0.54896 * width, y: -0.32292 * height))
            path.addQuadCurve(to: CGPoint(x: 0.4099 * width, y: -0.34479 * height), control: CGPoint(x: 0.45208 * width, y: -0.32292 * height))
            path.addQuadCurve(to: CGPoint(x: 0.34479 * width, y: -0.40937 * height), control: CGPoint(x: 0.36771 * width, y: -0.36667 * height))
            path.addLine(to: CGPoint(x: 0.28958 * width, y: -0.40937 * height))
            path.addQuadCurve(to: CGPoint(x: 0.37396 * width, y: -0.30885 * height), control: CGPoint(x: 0.31667 * width, y: -0.34583 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.27187 * height), control: CGPoint(x: 0.43125 * width, y: -0.27187 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.5 * width, y: -0.08333 * height))
            path.addQuadCurve(to: CGPoint(x: 0.3375 * width, y: -0.11615 * height), control: CGPoint(x: 0.41354 * width, y: -0.08333 * height))
            path.addQuadCurve(to: CGPoint(x: 0.20521 * width, y: -0.20521 * height), control: CGPoint(x: 0.26146 * width, y: -0.14896 * height))
            path.addQuadCurve(to: CGPoint(x: 0.11615 * width, y: -0.3375 * height), control: CGPoint(x: 0.14896 * width, y: -0.26146 * height))
            path.addQuadCurve(to: CGPoint(x: 0.08333 * width, y: -0.5 * height), control: CGPoint(x: 0.08333 * width, y: -0.41354 * height))
            path.addQuadCurve(to: CGPoint(x: 0.11615 * width, y: -0.6625 * height), control: CGPoint(x: 0.08333 * width, y: -0.58646 * height))
            path.addQuadCurve(to: CGPoint(x: 0.20521 * width, y: -0.79479 * height), control: CGPoint(x: 0.14896 * width, y: -0.73854 * height))
            path.addQuadCurve(to: CGPoint(x: 0.3375 * width, y: -0.88385 * height), control: CGPoint(x: 0.26146 * width, y: -0.85104 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.91667 * height), control: CGPoint(x: 0.41354 * width, y: -0.91667 * height))
            path.addQuadCurve(to: CGPoint(x: 0.6625 * width, y: -0.88385 * height), control: CGPoint(x: 0.58646 * width, y: -0.91667 * height))
            path.addQuadCurve(to: CGPoint(x: 0.79479 * width, y: -0.79479 * height), control: CGPoint(x: 0.73854 * width, y: -0.85104 * height))
            path.addQuadCurve(to: CGPoint(x: 0.88385 * width, y: -0.6625 * height), control: CGPoint(x: 0.85104 * width, y: -0.73854 * height))
            path.addQuadCurve(to: CGPoint(x: 0.91667 * width, y: -0.5 * height), control: CGPoint(x: 0.91667 * width, y: -0.58646 * height))
            path.addQuadCurve(to: CGPoint(x: 0.88385 * width, y: -0.3375 * height), control: CGPoint(x: 0.91667 * width, y: -0.41354 * height))
            path.addQuadCurve(to: CGPoint(x: 0.79479 * width, y: -0.20521 * height), control: CGPoint(x: 0.85104 * width, y: -0.26146 * height))
            path.addQuadCurve(to: CGPoint(x: 0.6625 * width, y: -0.11615 * height), control: CGPoint(x: 0.73854 * width, y: -0.14896 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.08333 * height), control: CGPoint(x: 0.58646 * width, y: -0.08333 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.5 * width, y: -0.5 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.5 * width, y: -0.14583 * height))
            path.addQuadCurve(to: CGPoint(x: 0.75124 * width, y: -0.24876 * height), control: CGPoint(x: 0.64831 * width, y: -0.14583 * height))
            path.addQuadCurve(to: CGPoint(x: 0.85417 * width, y: -0.5 * height), control: CGPoint(x: 0.85417 * width, y: -0.35169 * height))
            path.addQuadCurve(to: CGPoint(x: 0.75124 * width, y: -0.75124 * height), control: CGPoint(x: 0.85417 * width, y: -0.64831 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.85417 * height), control: CGPoint(x: 0.64831 * width, y: -0.85417 * height))
            path.addQuadCurve(to: CGPoint(x: 0.24876 * width, y: -0.75124 * height), control: CGPoint(x: 0.35169 * width, y: -0.85417 * height))
            path.addQuadCurve(to: CGPoint(x: 0.14583 * width, y: -0.5 * height), control: CGPoint(x: 0.14583 * width, y: -0.64831 * height))
            path.addQuadCurve(to: CGPoint(x: 0.24876 * width, y: -0.24876 * height), control: CGPoint(x: 0.14583 * width, y: -0.35169 * height))
            path.addQuadCurve(to: CGPoint(x: 0.5 * width, y: -0.14583 * height), control: CGPoint(x: 0.35169 * width, y: -0.14583 * height))
            path.closeSubpath()
            return path.offsetBy(dx: 0, dy: height)
        }
    }

    struct CheckIcon: Shape {
        func path(in rect: CGRect) -> Path {
            var path = Path()
            let width = rect.size.width
            let height = rect.size.height
            path.move(to: CGPoint(x: 0.33173 * width, y: 0.89102 * height))
            path.addLine(to: CGPoint(x: 0.29858 * width, y: 0.93522 * height))
            path.addCurve(to: CGPoint(x: 0.33173 * width, y: 0.95352 * height), control1: CGPoint(x: 0.30738 * width, y: 0.94694 * height), control2: CGPoint(x: 0.3193 * width, y: 0.95352 * height))
            path.addCurve(to: CGPoint(x: 0.36488 * width, y: 0.93522 * height), control1: CGPoint(x: 0.34416 * width, y: 0.95352 * height), control2: CGPoint(x: 0.35609 * width, y: 0.94694 * height))
            path.addLine(to: CGPoint(x: 0.33173 * width, y: 0.89102 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.97064 * width, y: 0.12753 * height))
            path.addCurve(to: CGPoint(x: 0.97064 * width, y: 0.03914 * height), control1: CGPoint(x: 0.98895 * width, y: 0.10312 * height), control2: CGPoint(x: 0.98895 * width, y: 0.06355 * height))
            path.addCurve(to: CGPoint(x: 0.90436 * width, y: 0.03914 * height), control1: CGPoint(x: 0.95234 * width, y: 0.01473 * height), control2: CGPoint(x: 0.92266 * width, y: 0.01473 * height))
            path.addLine(to: CGPoint(x: 0.97064 * width, y: 0.12753 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.09565 * width, y: 0.48786 * height))
            path.addCurve(to: CGPoint(x: 0.02935 * width, y: 0.48786 * height), control1: CGPoint(x: 0.07734 * width, y: 0.46345 * height), control2: CGPoint(x: 0.04766 * width, y: 0.46345 * height))
            path.addCurve(to: CGPoint(x: 0.02935 * width, y: 0.57625 * height), control1: CGPoint(x: 0.01105 * width, y: 0.51226 * height), control2: CGPoint(x: 0.01105 * width, y: 0.55184 * height))
            path.addLine(to: CGPoint(x: 0.09565 * width, y: 0.48786 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.36488 * width, y: 0.93522 * height))
            path.addLine(to: CGPoint(x: 0.97064 * width, y: 0.12753 * height))
            path.addLine(to: CGPoint(x: 0.90436 * width, y: 0.03914 * height))
            path.addLine(to: CGPoint(x: 0.29858 * width, y: 0.84683 * height))
            path.addLine(to: CGPoint(x: 0.36488 * width, y: 0.93522 * height))
            path.closeSubpath()
            path.move(to: CGPoint(x: 0.02935 * width, y: 0.57625 * height))
            path.addLine(to: CGPoint(x: 0.29858 * width, y: 0.93522 * height))
            path.addLine(to: CGPoint(x: 0.36488 * width, y: 0.84683 * height))
            path.addLine(to: CGPoint(x: 0.09565 * width, y: 0.48786 * height))
            path.addLine(to: CGPoint(x: 0.02935 * width, y: 0.57625 * height))
            path.closeSubpath()
            return path
        }
    }

    #Preview {
        VStack {
            HStack {
                VeryDissatisfiedEmoji()
                    .frame(width: 48, height: 48)
                    .foregroundColor(.blue)
                DissatisfiedEmoji().frame(width: 48, height: 48)
                NeutralEmoji().frame(width: 48, height: 48)
                SatisfiedEmoji().frame(width: 48, height: 48)
                VerySatisfiedEmoji().frame(width: 48, height: 48)
            }
            HStack {
                CheckIcon().frame(width: 16, height: 12)
            }
        }
    }
#endif
// swiftlint:enable line_length
