/**
 * Marlin 3D Printer Firmware
 * Copyright (C) 2016 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (C) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/**
 * Custom Bitmap for splashscreen
 *
 * You may use one of the following tools to generate the C++ bitmap array from
 * a black and white image:
 *
 *  - http://www.marlinfw.org/tools/u8glib/converter.html
 *  - http://www.digole.com/tools/PicturetoC_Hex_converter.php
 */
#include <avr/pgmspace.h>

#define CUSTOM_BOOTSCREEN_TIMEOUT   1000
#define CUSTOM_BOOTSCREEN_BMPWIDTH  128
#define CUSTOM_BOOTSCREEN_BMPHEIGHT 64

const unsigned char custom_start_bmp[1024] PROGMEM = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x07,0x00,0x00,0x03,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x1f,0xc0,0x00,0x0f,0xe0,0x7c,0x03,0xe0,0x78,0x1c,0x07,0x81,0xe0,0xf0,0x3e,0x0e
,0x7f,0xe0,0x00,0x3f,0xf0,0x7e,0x07,0xe0,0xfc,0x1c,0x03,0x81,0xc1,0xf8,0x3f,0x0e
,0x7f,0xf8,0x00,0x7f,0xf0,0x7e,0x07,0xe0,0xfc,0x1c,0x03,0xc3,0xc1,0xf8,0x3f,0x0e
,0x7b,0xfe,0x01,0xfe,0xf0,0x7f,0x0f,0xe1,0xfe,0x1c,0x01,0xc3,0x83,0xfc,0x3f,0x8e
,0x7c,0xff,0x87,0xf9,0xf0,0x77,0x0e,0xe1,0xfe,0x1c,0x01,0xe7,0x83,0xfc,0x3b,0x8e
,0x7f,0x7f,0xcf,0xf7,0xf0,0x77,0x9e,0xe1,0xce,0x1c,0x00,0xe7,0x03,0x9c,0x3b,0xce
,0x7f,0x9f,0xff,0xcf,0xf0,0x73,0x9c,0xe3,0xcf,0x1c,0x00,0xff,0x07,0x9e,0x39,0xce
,0x7f,0xe7,0xff,0x3f,0xf0,0x73,0xfc,0xe3,0x87,0x1c,0x00,0x7e,0x07,0x0e,0x39,0xee
,0x7f,0xfb,0xfe,0xff,0xf0,0x71,0xf8,0xe3,0x87,0x1c,0x00,0x7e,0x0f,0x0f,0x38,0xee
,0x7f,0xfc,0xf9,0xff,0xf0,0x71,0xf8,0xe7,0xff,0x9c,0x00,0x3c,0x0f,0xff,0x38,0xfe
,0x7f,0xff,0x27,0xff,0xf0,0x70,0xf0,0xe7,0xff,0x9c,0x00,0x3c,0x0f,0xff,0x38,0x7e
,0x7f,0xff,0xdf,0xff,0xf0,0x70,0xf0,0xef,0xff,0xdc,0x00,0x3c,0x1f,0xff,0xb8,0x7e
,0x7f,0xdf,0xff,0xdf,0xf0,0x70,0x60,0xef,0x03,0xdf,0xf8,0x3c,0x1e,0x07,0xb8,0x3e
,0x7f,0xc7,0xff,0x1f,0xf0,0x70,0x60,0xee,0x01,0xdf,0xf8,0x3c,0x1c,0x03,0xb8,0x3e
,0x7f,0xc3,0xfe,0x1f,0xf0,0x70,0x00,0xee,0x01,0xdf,0xf8,0x3c,0x1c,0x03,0xb8,0x1e
,0x7f,0xc3,0xfe,0x1f,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x7f,0xc3,0xde,0x1f,0xf0,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe
,0x7f,0xc3,0xde,0x1f,0xf0,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe
,0x7f,0xc3,0xde,0x1f,0xf0,0x7c,0x3f,0xfa,0xfb,0xff,0xff,0xff,0xfd,0x7a,0xbf,0xfe
,0x7f,0xc3,0xde,0x1f,0xf0,0x7d,0x9f,0xfb,0xff,0xff,0xff,0xff,0xff,0x7e,0xf7,0xfe
,0x7f,0xc3,0xde,0x1f,0xf0,0x7d,0x93,0x1a,0x8a,0x18,0xe3,0x8c,0x45,0x1a,0xa2,0xde
,0x3f,0xc3,0xde,0x0f,0xf0,0x7c,0x2d,0xca,0xca,0xd6,0xe9,0x24,0xcd,0x6a,0xb6,0xbe
,0x1f,0x83,0xde,0x07,0xe0,0x7d,0xa3,0x6a,0x9a,0xd6,0xe9,0x26,0x65,0x6a,0xb6,0x3e
,0x06,0x03,0xde,0x01,0x80,0x7d,0x91,0x0a,0x8a,0xd8,0xe3,0x8c,0x45,0x1a,0xb3,0x7e
,0x00,0x03,0xde,0x00,0x00,0x7f,0xff,0xff,0xff,0xfe,0xef,0xff,0xff,0xff,0xff,0x7e
,0x00,0x03,0xde,0x00,0x00,0x7f,0xff,0xff,0xff,0xf1,0xef,0xff,0xff,0xff,0xfe,0xfe
,0x00,0x03,0xde,0x00,0x00,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe
,0x00,0x03,0xde,0x00,0x00,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe
,0x00,0x03,0xde,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x01,0xdc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00

};
