/**
 * Marlin 3D Printer Firmware
 * Copyright (C) 2016 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (C) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

// Please update this list when adding new pins to Marlin.
// The order doesn't matter.
// Following this pattern is a must.
// If the new pin name is over 28 characters long then pinsDebug.h will need to be modified.

// Pin list updated from 18 FEB 2017 RCBugfix branch   - max length of pin name is 24

#line 0 // set __LINE__ to a known value for both passes

#if PIN_EXISTS(ADC_KEYPAD) && ADC_KEYPAD_PIN < NUM_ANALOG_INPUTS
  REPORT_NAME_ANALOG(ADC_KEYPAD_PIN, __LINE__ )
#endif
#if defined(__FD) && __FD >= 0
  REPORT_NAME_DIGITAL(__FD, __LINE__ )
#endif
#if defined(__FS) && __FS >= 0
  REPORT_NAME_DIGITAL(__FS, __LINE__ )
#endif
#if defined(__GD) && __GD >= 0
  REPORT_NAME_DIGITAL(__GD, __LINE__ )
#endif
#if defined(__GS) && __GS >= 0
  REPORT_NAME_DIGITAL(__GS, __LINE__ )
#endif
#if PIN_EXISTS(ADC_KEYPAD)
  REPORT_NAME_ANALOG(ADC_KEYPAD_PIN, __LINE__ )
#endif
#if PIN_EXISTS(AVR_MISO)
  REPORT_NAME_DIGITAL(AVR_MISO_PIN, __LINE__ )
#endif
#if PIN_EXISTS(AVR_MOSI)
  REPORT_NAME_DIGITAL(AVR_MOSI_PIN, __LINE__ )
#endif
#if PIN_EXISTS(AVR_SCK)
  REPORT_NAME_DIGITAL(AVR_SCK_PIN, __LINE__ )
#endif
#if PIN_EXISTS(AVR_SS)
  REPORT_NAME_DIGITAL(AVR_SS_PIN, __LINE__ )
#endif
#if PIN_EXISTS(BEEPER)
  REPORT_NAME_DIGITAL(BEEPER_PIN, __LINE__ )
#endif
#if defined(BTN_CENTER) && BTN_CENTER >= 0
  REPORT_NAME_DIGITAL(BTN_CENTER, __LINE__ )
#endif
#if defined(BTN_DOWN) && BTN_DOWN >= 0
  REPORT_NAME_DIGITAL(BTN_DOWN, __LINE__ )
#endif
#if defined(BTN_DWN) && BTN_DWN >= 0
  REPORT_NAME_DIGITAL(BTN_DWN, __LINE__ )
#endif
#if defined(BTN_EN1) && BTN_EN1 >= 0
  REPORT_NAME_DIGITAL(BTN_EN1, __LINE__ )
#endif
#if defined(BTN_EN2) && BTN_EN2 >= 0
  REPORT_NAME_DIGITAL(BTN_EN2, __LINE__ )
#endif
#if defined(BTN_ENC) && BTN_ENC >= 0
  REPORT_NAME_DIGITAL(BTN_ENC, __LINE__ )
#endif
#if defined(BTN_HOME) && BTN_HOME >= 0
  REPORT_NAME_DIGITAL(BTN_HOME, __LINE__ )
#endif
#if defined(BTN_LEFT) && BTN_LEFT >= 0
  REPORT_NAME_DIGITAL(BTN_LEFT, __LINE__ )
#endif
#if defined(BTN_LFT) && BTN_LFT >= 0
  REPORT_NAME_DIGITAL(BTN_LFT, __LINE__ )
#endif
#if defined(BTN_RIGHT) && BTN_RIGHT >= 0
  REPORT_NAME_DIGITAL(BTN_RIGHT, __LINE__ )
#endif
#if defined(BTN_RT) && BTN_RT >= 0
  REPORT_NAME_DIGITAL(BTN_RT, __LINE__ )
#endif
#if defined(BTN_UP) && BTN_UP >= 0
  REPORT_NAME_DIGITAL(BTN_UP, __LINE__ )
#endif
#if PIN_EXISTS(CASE_LIGHT)
  REPORT_NAME_DIGITAL(CASE_LIGHT_PIN, __LINE__ )
#endif
#if PIN_EXISTS(CONTROLLER_FAN)
  REPORT_NAME_DIGITAL(CONTROLLER_FAN_PIN, __LINE__ )
#endif
#if PIN_EXISTS(CUTOFF_RESET)
  REPORT_NAME_DIGITAL(CUTOFF_RESET_PIN, __LINE__ )
#endif
#if PIN_EXISTS(CUTOFF_TEST)
  REPORT_NAME_DIGITAL(CUTOFF_TEST_PIN, __LINE__ )
#endif
#if PIN_EXISTS(DAC_DISABLE)
  REPORT_NAME_DIGITAL(DAC_DISABLE_PIN, __LINE__ )
#endif
#if defined(DAC_STEPPER_VREF) && DAC_STEPPER_VREF >= 0
  REPORT_NAME_DIGITAL(DAC_STEPPER_VREF, __LINE__ )
#endif
#if PIN_EXISTS(DEBUG)
  REPORT_NAME_DIGITAL(DEBUG_PIN, __LINE__ )
#endif
#if defined(DIGIPOTS_I2C_SCL) && DIGIPOTS_I2C_SCL >= 0
  REPORT_NAME_DIGITAL(DIGIPOTS_I2C_SCL, __LINE__ )
#endif
#if defined(DIGIPOTS_I2C_SDA_E0) && DIGIPOTS_I2C_SDA_E0 >= 0
  REPORT_NAME_DIGITAL(DIGIPOTS_I2C_SDA_E0, __LINE__ )
#endif
#if defined(DIGIPOTS_I2C_SDA_E1) && DIGIPOTS_I2C_SDA_E1 >= 0
  REPORT_NAME_DIGITAL(DIGIPOTS_I2C_SDA_E1, __LINE__ )
#endif
#if defined(DIGIPOTS_I2C_SDA_X) && DIGIPOTS_I2C_SDA_X >= 0
  REPORT_NAME_DIGITAL(DIGIPOTS_I2C_SDA_X, __LINE__ )
#endif
#if defined(DIGIPOTS_I2C_SDA_Y) && DIGIPOTS_I2C_SDA_Y >= 0
  REPORT_NAME_DIGITAL(DIGIPOTS_I2C_SDA_Y, __LINE__ )
#endif
#if defined(DIGIPOTS_I2C_SDA_Z) && DIGIPOTS_I2C_SDA_Z >= 0
  REPORT_NAME_DIGITAL(DIGIPOTS_I2C_SDA_Z, __LINE__ )
#endif
#if PIN_EXISTS(DIGIPOTSS)
  REPORT_NAME_DIGITAL(DIGIPOTSS_PIN, __LINE__ )
#endif
#if defined(DOGLCD_A0) && DOGLCD_A0 >= 0
  REPORT_NAME_DIGITAL(DOGLCD_A0, __LINE__ )
#endif
#if defined(DOGLCD_CS) && DOGLCD_CS >= 0
  REPORT_NAME_DIGITAL(DOGLCD_CS, __LINE__ )
#endif
#if defined(DOGLCD_MOSI) && DOGLCD_MOSI >= 0
  REPORT_NAME_DIGITAL(DOGLCD_MOSI, __LINE__ )
#endif
#if defined(DOGLCD_SCK) && DOGLCD_SCK >= 0
  REPORT_NAME_DIGITAL(DOGLCD_SCK, __LINE__ )
#endif
#if PIN_EXISTS(E0_ATT)
  REPORT_NAME_DIGITAL(E0_ATT_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E0_AUTO_FAN)
  REPORT_NAME_DIGITAL(E0_AUTO_FAN_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E0_CS)
  REPORT_NAME_DIGITAL(E0_CS_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E0_DIR)
  REPORT_NAME_DIGITAL(E0_DIR_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E0_ENABLE)
  REPORT_NAME_DIGITAL(E0_ENABLE_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E0_MS1)
  REPORT_NAME_DIGITAL(E0_MS1_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E0_MS2)
  REPORT_NAME_DIGITAL(E0_MS2_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E0_STEP)
  REPORT_NAME_DIGITAL(E0_STEP_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E1_AUTO_FAN)
  REPORT_NAME_DIGITAL(E1_AUTO_FAN_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E1_CS)
  REPORT_NAME_DIGITAL(E1_CS_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E1_DIR)
  REPORT_NAME_DIGITAL(E1_DIR_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E1_ENABLE)
  REPORT_NAME_DIGITAL(E1_ENABLE_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E1_MS1)
  REPORT_NAME_DIGITAL(E1_MS1_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E1_MS2)
  REPORT_NAME_DIGITAL(E1_MS2_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E1_STEP)
  REPORT_NAME_DIGITAL(E1_STEP_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E2_AUTO_FAN)
  REPORT_NAME_DIGITAL(E2_AUTO_FAN_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E2_DIR)
  REPORT_NAME_DIGITAL(E2_DIR_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E2_ENABLE)
  REPORT_NAME_DIGITAL(E2_ENABLE_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E2_STEP)
  REPORT_NAME_DIGITAL(E2_STEP_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E3_AUTO_FAN)
  REPORT_NAME_DIGITAL(E3_AUTO_FAN_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E3_DIR)
  REPORT_NAME_DIGITAL(E3_DIR_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E3_ENABLE)
  REPORT_NAME_DIGITAL(E3_ENABLE_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E3_STEP)
  REPORT_NAME_DIGITAL(E3_STEP_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E4_AUTO_FAN)
  REPORT_NAME_DIGITAL(E4_AUTO_FAN_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E4_DIR)
  REPORT_NAME_DIGITAL(E4_DIR_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E4_ENABLE)
  REPORT_NAME_DIGITAL(E4_ENABLE_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E4_STEP)
  REPORT_NAME_DIGITAL(E4_STEP_PIN, __LINE__ )
#endif
#if defined(EXT_AUX_A0) && EXT_AUX_A0 >= 0 && EXT_AUX_A0 < NUM_ANALOG_INPUTS
  REPORT_NAME_ANALOG(EXT_AUX_A0, __LINE__ )
#endif
#if defined(EXT_AUX_A0) && EXT_AUX_A0 >= 0 && EXT_AUX_A0 >= NUM_ANALOG_INPUTS
  REPORT_NAME_DIGITAL(EXT_AUX_A0, __LINE__ )
#endif
#if defined(EXT_AUX_A0_IO) && EXT_AUX_A0_IO >= 0
  REPORT_NAME_DIGITAL(EXT_AUX_A0_IO, __LINE__ )
#endif
#if defined(EXT_AUX_A1) && EXT_AUX_A1 >= 0 && EXT_AUX_A1 < NUM_ANALOG_INPUTS
  REPORT_NAME_ANALOG(EXT_AUX_A1, __LINE__ )
#endif
#if defined(EXT_AUX_A1) && EXT_AUX_A1 >= 0 && EXT_AUX_A1 >= NUM_ANALOG_INPUTS
  REPORT_NAME_DIGITAL(EXT_AUX_A1, __LINE__ )
#endif
#if defined(EXT_AUX_A1_IO) && EXT_AUX_A1_IO >= 0
  REPORT_NAME_DIGITAL(EXT_AUX_A1_IO, __LINE__ )
#endif
#if defined(EXT_AUX_A2) && EXT_AUX_A2 >= 0 && EXT_AUX_A2 < NUM_ANALOG_INPUTS
  REPORT_NAME_ANALOG(EXT_AUX_A2, __LINE__ )
#endif
#if defined(EXT_AUX_A2) && EXT_AUX_A2 >= 0 && EXT_AUX_A2 >= NUM_ANALOG_INPUTS
  REPORT_NAME_DIGITAL(EXT_AUX_A2, __LINE__ )
#endif
#if defined(EXT_AUX_A2_IO) && EXT_AUX_A2_IO >= 0
  REPORT_NAME_DIGITAL(EXT_AUX_A2_IO, __LINE__ )
#endif
#if defined(EXT_AUX_A3) && EXT_AUX_A3 >= 0 && EXT_AUX_A3 < NUM_ANALOG_INPUTS
  REPORT_NAME_ANALOG(EXT_AUX_A3, __LINE__ )
#endif
#if defined(EXT_AUX_A3) && EXT_AUX_A3 >= 0 && EXT_AUX_A3 >= NUM_ANALOG_INPUTS
  REPORT_NAME_DIGITAL(EXT_AUX_A3, __LINE__ )
#endif
#if defined(EXT_AUX_A3_IO) && EXT_AUX_A3_IO >= 0
  REPORT_NAME_DIGITAL(EXT_AUX_A3_IO, __LINE__ )
#endif
#if defined(EXT_AUX_A4) && EXT_AUX_A4 >= 0 && EXT_AUX_A4 < NUM_ANALOG_INPUTS
  REPORT_NAME_ANALOG(EXT_AUX_A4, __LINE__ )
#endif
#if defined(EXT_AUX_A4) && EXT_AUX_A4 >= 0 && EXT_AUX_A4 >= NUM_ANALOG_INPUTS
  REPORT_NAME_DIGITAL(EXT_AUX_A4, __LINE__ )
#endif
#if defined(EXT_AUX_A4_IO) && EXT_AUX_A4_IO >= 0
  REPORT_NAME_DIGITAL(EXT_AUX_A4_IO, __LINE__ )
#endif
#if defined(EXT_AUX_PWM_D24) && EXT_AUX_PWM_D24 >= 0
  REPORT_NAME_DIGITAL(EXT_AUX_PWM_D24, __LINE__ )
#endif
#if defined(EXT_AUX_RX1_D2) && EXT_AUX_RX1_D2 >= 0
  REPORT_NAME_DIGITAL(EXT_AUX_RX1_D2, __LINE__ )
#endif
#if defined(EXT_AUX_SCL_D0) && EXT_AUX_SCL_D0 >= 0
  REPORT_NAME_DIGITAL(EXT_AUX_SCL_D0, __LINE__ )
#endif
#if defined(EXT_AUX_SDA_D1) && EXT_AUX_SDA_D1 >= 0
  REPORT_NAME_DIGITAL(EXT_AUX_SDA_D1, __LINE__ )
#endif
#if defined(EXT_AUX_TX1_D3) && EXT_AUX_TX1_D3 >= 0
  REPORT_NAME_DIGITAL(EXT_AUX_TX1_D3, __LINE__ )
#endif
#if defined(EXTRUDER_0_AUTO_FAN) && EXTRUDER_0_AUTO_FAN >= 0
  REPORT_NAME_DIGITAL(EXTRUDER_0_AUTO_FAN, __LINE__ )
#endif
#if defined(EXTRUDER_1_AUTO_FAN) && EXTRUDER_1_AUTO_FAN >= 0
  REPORT_NAME_DIGITAL(EXTRUDER_1_AUTO_FAN, __LINE__ )
#endif
#if PIN_EXISTS(FAN)
  REPORT_NAME_DIGITAL(FAN_PIN, __LINE__ )
#endif
#if PIN_EXISTS(FAN1)
  REPORT_NAME_DIGITAL(FAN1_PIN, __LINE__ )
#endif
#if PIN_EXISTS(FAN2)
  REPORT_NAME_DIGITAL(FAN2_PIN, __LINE__ )
#endif
#if PIN_EXISTS(FIL_RUNOUT)
  REPORT_NAME_DIGITAL(FIL_RUNOUT_PIN, __LINE__ )
#endif
#if PIN_EXISTS(FILWIDTH) && FILWIDTH_PIN < NUM_ANALOG_INPUTS
  REPORT_NAME_ANALOG(FILWIDTH_PIN, __LINE__ )
#endif
#if PIN_EXISTS(HEATER_0)
  REPORT_NAME_DIGITAL(HEATER_0_PIN, __LINE__ )
#endif
#if PIN_EXISTS(HEATER_1)
  REPORT_NAME_DIGITAL(HEATER_1_PIN, __LINE__ )
#endif
#if PIN_EXISTS(HEATER_2)
  REPORT_NAME_DIGITAL(HEATER_2_PIN, __LINE__ )
#endif
#if PIN_EXISTS(HEATER_3)
  REPORT_NAME_DIGITAL(HEATER_3_PIN, __LINE__ )
#endif
#if PIN_EXISTS(HEATER_4)
  REPORT_NAME_DIGITAL(HEATER_4_PIN, __LINE__ )
#endif
#if PIN_EXISTS(HEATER_5)
  REPORT_NAME_DIGITAL(HEATER_5_PIN, __LINE__ )
#endif
#if PIN_EXISTS(HEATER_6)
  REPORT_NAME_DIGITAL(HEATER_6_PIN, __LINE__ )
#endif
#if PIN_EXISTS(HEATER_7)
  REPORT_NAME_DIGITAL(HEATER_7_PIN, __LINE__ )
#endif
#if PIN_EXISTS(HEATER_BED)
  REPORT_NAME_DIGITAL(HEATER_BED_PIN, __LINE__ )
#endif
#if PIN_EXISTS(HOME)
  REPORT_NAME_DIGITAL(HOME_PIN, __LINE__ )
#endif
#if PIN_EXISTS(I2C_SCL)
  REPORT_NAME_DIGITAL(I2C_SCL_PIN, __LINE__ )
#endif
#if PIN_EXISTS(I2C_SDA)
  REPORT_NAME_DIGITAL(I2C_SDA_PIN, __LINE__ )
#endif
#if PIN_EXISTS(KILL)
  REPORT_NAME_DIGITAL(KILL_PIN, __LINE__ )
#endif
#if PIN_EXISTS(LCD_BACKLIGHT)
  REPORT_NAME_DIGITAL(LCD_BACKLIGHT_PIN, __LINE__ )
#endif
#if defined(LCD_CONTRAST) && LCD_CONTRAST >= 0
  REPORT_NAME_DIGITAL(LCD_CONTRAST, __LINE__ )
#endif
#if defined(LCD_PINS_D4) && LCD_PINS_D4 >= 0
  REPORT_NAME_DIGITAL(LCD_PINS_D4, __LINE__ )
#endif
#if defined(LCD_PINS_D5) && LCD_PINS_D5 >= 0
  REPORT_NAME_DIGITAL(LCD_PINS_D5, __LINE__ )
#endif
#if defined(LCD_PINS_D6) && LCD_PINS_D6 >= 0
  REPORT_NAME_DIGITAL(LCD_PINS_D6, __LINE__ )
#endif
#if defined(LCD_PINS_D7) && LCD_PINS_D7 >= 0
  REPORT_NAME_DIGITAL(LCD_PINS_D7, __LINE__ )
#endif
#if defined(LCD_PINS_ENABLE) && LCD_PINS_ENABLE >= 0
  REPORT_NAME_DIGITAL(LCD_PINS_ENABLE, __LINE__ )
#endif
#if defined(LCD_PINS_RS) && LCD_PINS_RS >= 0
  REPORT_NAME_DIGITAL(LCD_PINS_RS, __LINE__ )
#endif
#if defined(LCD_SDSS) && LCD_SDSS >= 0
  REPORT_NAME_DIGITAL(LCD_SDSS, __LINE__ )
#endif
#if PIN_EXISTS(LED)
  REPORT_NAME_DIGITAL(LED_PIN, __LINE__ )
#endif
#if PIN_EXISTS(MAIN_VOLTAGE_MEASURE) && MAIN_VOLTAGE_MEASURE_PIN < NUM_ANALOG_INPUTS
  REPORT_NAME_ANALOG(MAIN_VOLTAGE_MEASURE_PIN, __LINE__ )
#endif
#if defined(MAX6675_SS) && MAX6675_SS >= 0
  REPORT_NAME_DIGITAL(MAX6675_SS, __LINE__ )
#endif
#if PIN_EXISTS(MISO)
  REPORT_NAME_DIGITAL(MISO_PIN, __LINE__ )
#endif
#if PIN_EXISTS(MOSFET_A)
  REPORT_NAME_DIGITAL(MOSFET_A_PIN, __LINE__ )
#endif
#if PIN_EXISTS(MOSFET_B)
  REPORT_NAME_DIGITAL(MOSFET_B_PIN, __LINE__ )
#endif
#if PIN_EXISTS(MOSFET_C)
  REPORT_NAME_DIGITAL(MOSFET_C_PIN, __LINE__ )
#endif
#if PIN_EXISTS(MOSFET_D)
  REPORT_NAME_DIGITAL(MOSFET_D_PIN, __LINE__ )
#endif
#if PIN_EXISTS(MOSI)
  REPORT_NAME_DIGITAL(MOSI_PIN, __LINE__ )
#endif
#if PIN_EXISTS(MOTOR_CURRENT_PWM_E)
  REPORT_NAME_DIGITAL(MOTOR_CURRENT_PWM_E_PIN, __LINE__ )
#endif
#if PIN_EXISTS(MOTOR_CURRENT_PWM_XY)
  REPORT_NAME_DIGITAL(MOTOR_CURRENT_PWM_XY_PIN, __LINE__ )
#endif
#if PIN_EXISTS(MOTOR_CURRENT_PWM_Z)
  REPORT_NAME_DIGITAL(MOTOR_CURRENT_PWM_Z_PIN, __LINE__ )
#endif
#if PIN_EXISTS(ORIG_E0_AUTO_FAN)
  REPORT_NAME_DIGITAL(ORIG_E0_AUTO_FAN_PIN, __LINE__ )
#endif
#if PIN_EXISTS(ORIG_E1_AUTO_FAN)
  REPORT_NAME_DIGITAL(ORIG_E1_AUTO_FAN_PIN, __LINE__ )
#endif
#if PIN_EXISTS(ORIG_E2_AUTO_FAN)
  REPORT_NAME_DIGITAL(ORIG_E2_AUTO_FAN_PIN, __LINE__ )
#endif
#if PIN_EXISTS(ORIG_E3_AUTO_FAN)
  REPORT_NAME_DIGITAL(ORIG_E3_AUTO_FAN_PIN, __LINE__ )
#endif
#if PIN_EXISTS(ORIG_E4_AUTO_FAN)
  REPORT_NAME_DIGITAL(ORIG_E4_AUTO_FAN_PIN, __LINE__ )
#endif
#if PIN_EXISTS(PHOTOGRAPH)
  REPORT_NAME_DIGITAL(PHOTOGRAPH_PIN, __LINE__ )
#endif
#if PIN_EXISTS(PS_ON)
  REPORT_NAME_DIGITAL(PS_ON_PIN, __LINE__ )
#endif
#if PIN_EXISTS(PWM_1)
  REPORT_NAME_DIGITAL(PWM_1_PIN, __LINE__ )
#endif
#if PIN_EXISTS(PWM_2)
  REPORT_NAME_DIGITAL(PWM_2_PIN, __LINE__ )
#endif
#if PIN_EXISTS(RAMPS_D10)
  REPORT_NAME_DIGITAL(RAMPS_D10_PIN, __LINE__ )
#endif
#if PIN_EXISTS(RAMPS_D8)
  REPORT_NAME_DIGITAL(RAMPS_D8_PIN, __LINE__ )
#endif
#if PIN_EXISTS(RAMPS_D9)
  REPORT_NAME_DIGITAL(RAMPS_D9_PIN, __LINE__ )
#endif
#if PIN_EXISTS(RGB_LED_R)
  REPORT_NAME_DIGITAL(RGB_LED_R_PIN, __LINE__ )
#endif
#if PIN_EXISTS(RGB_LED_G)
  REPORT_NAME_DIGITAL(RGB_LED_G_PIN, __LINE__ )
#endif
#if PIN_EXISTS(RGB_LED_B)
  REPORT_NAME_DIGITAL(RGB_LED_B_PIN, __LINE__ )
#endif
#if PIN_EXISTS(RGB_LED_W)
  REPORT_NAME_DIGITAL(RGB_LED_W_PIN, __LINE__ )
#endif
#if PIN_EXISTS(RX_ENABLE)
  REPORT_NAME_DIGITAL(RX_ENABLE_PIN, __LINE__ )
#endif
#if PIN_EXISTS(SAFETY_TRIGGERED)
  REPORT_NAME_DIGITAL(SAFETY_TRIGGERED_PIN, __LINE__ )
#endif
#if PIN_EXISTS(SCK)
  REPORT_NAME_DIGITAL(SCK_PIN, __LINE__ )
#endif
#if defined(SCL) && SCL >= 0
  REPORT_NAME_DIGITAL(SCL, __LINE__ )
#endif
#if PIN_EXISTS(SD_DETECT)
  REPORT_NAME_DIGITAL(SD_DETECT_PIN, __LINE__ )
#endif
#if defined(SDA) && SDA >= 0
  REPORT_NAME_DIGITAL(SDA, __LINE__ )
#endif
#if defined(SDPOWER) && SDPOWER >= 0
  REPORT_NAME_DIGITAL(SDPOWER, __LINE__ )
#endif
#if defined(SDSS) && SDSS >= 0
  REPORT_NAME_DIGITAL(SDSS, __LINE__ )
#endif
#if PIN_EXISTS(SERVO0)
  REPORT_NAME_DIGITAL(SERVO0_PIN, __LINE__ )
#endif
#if PIN_EXISTS(SERVO1)
  REPORT_NAME_DIGITAL(SERVO1_PIN, __LINE__ )
#endif
#if PIN_EXISTS(SERVO2)
  REPORT_NAME_DIGITAL(SERVO2_PIN, __LINE__ )
#endif
#if PIN_EXISTS(SERVO3)
  REPORT_NAME_DIGITAL(SERVO3_PIN, __LINE__ )
#endif
#if defined(SHIFT_CLK) && SHIFT_CLK >= 0
  REPORT_NAME_DIGITAL(SHIFT_CLK, __LINE__ )
#endif
#if defined(SHIFT_EN) && SHIFT_EN >= 0
  REPORT_NAME_DIGITAL(SHIFT_EN, __LINE__ )
#endif
#if defined(SHIFT_LD) && SHIFT_LD >= 0
  REPORT_NAME_DIGITAL(SHIFT_LD, __LINE__ )
#endif
#if defined(SHIFT_OUT) && SHIFT_OUT >= 0
  REPORT_NAME_DIGITAL(SHIFT_OUT, __LINE__ )
#endif
#if PIN_EXISTS(SLED)
  REPORT_NAME_DIGITAL(SLED_PIN, __LINE__ )
#endif
#if PIN_EXISTS(SLEEP_WAKE)
  REPORT_NAME_DIGITAL(SLEEP_WAKE_PIN, __LINE__ )
#endif
#if PIN_EXISTS(SOL0)
  REPORT_NAME_DIGITAL(SOL0_PIN, __LINE__ )
#endif
#if PIN_EXISTS(SOL1)
  REPORT_NAME_DIGITAL(SOL1_PIN, __LINE__ )
#endif
#if PIN_EXISTS(SOL2)
  REPORT_NAME_DIGITAL(SOL2_PIN, __LINE__ )
#endif
#if PIN_EXISTS(SOL3)
  REPORT_NAME_DIGITAL(SOL3_PIN, __LINE__ )
#endif
#if PIN_EXISTS(SOL4)
  REPORT_NAME_DIGITAL(SOL4_PIN, __LINE__ )
#endif
#if defined(SPARE_IO) && SPARE_IO >= 0
  REPORT_NAME_DIGITAL(SPARE_IO, __LINE__ )
#endif
#if PIN_EXISTS(SPINDLE_DIR)
  REPORT_NAME_DIGITAL(SPINDLE_DIR_PIN, __LINE__ )
#endif
#if PIN_EXISTS(SPINDLE_LASER_ENABLE)
  REPORT_NAME_DIGITAL(SPINDLE_LASER_ENABLE_PIN, __LINE__ )
#endif
#if PIN_EXISTS(SPINDLE_LASER_PWM)
  REPORT_NAME_DIGITAL(SPINDLE_LASER_PWM_PIN, __LINE__ )
#endif
#if PIN_EXISTS(SR_CLK)
  REPORT_NAME_DIGITAL(SR_CLK_PIN, __LINE__ )
#endif
#if PIN_EXISTS(SR_DATA)
  REPORT_NAME_DIGITAL(SR_DATA_PIN, __LINE__ )
#endif
#if PIN_EXISTS(SR_STROBE)
  REPORT_NAME_DIGITAL(SR_STROBE_PIN, __LINE__ )
#endif
#if PIN_EXISTS(SS)
  REPORT_NAME_DIGITAL(SS_PIN, __LINE__ )
#endif
#if PIN_EXISTS(STAT_LED_BLUE)
  REPORT_NAME_DIGITAL(STAT_LED_BLUE_PIN, __LINE__ )
#endif
#if PIN_EXISTS(STAT_LED_RED)
  REPORT_NAME_DIGITAL(STAT_LED_RED_PIN, __LINE__ )
#endif
#if PIN_EXISTS(STEPPER_RESET)
  REPORT_NAME_DIGITAL(STEPPER_RESET_PIN, __LINE__ )
#endif
#if PIN_EXISTS(SUICIDE)
  REPORT_NAME_DIGITAL(SUICIDE_PIN, __LINE__ )
#endif
#if defined(TC1) && TC1 >= 0 && TC1 < NUM_ANALOG_INPUTS
  REPORT_NAME_ANALOG(TC1, __LINE__ )
#endif
#if defined(TC2) && TC2 >= 0 && TC2 < NUM_ANALOG_INPUTS
  REPORT_NAME_ANALOG(TC2, __LINE__ )
#endif
#if PIN_EXISTS(TEMP_0) && TEMP_0_PIN < NUM_ANALOG_INPUTS
  REPORT_NAME_ANALOG(TEMP_0_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TEMP_1) && TEMP_1_PIN < NUM_ANALOG_INPUTS
  REPORT_NAME_ANALOG(TEMP_1_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TEMP_2) && TEMP_2_PIN < NUM_ANALOG_INPUTS
  REPORT_NAME_ANALOG(TEMP_2_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TEMP_3) && TEMP_3_PIN < NUM_ANALOG_INPUTS
  REPORT_NAME_ANALOG(TEMP_3_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TEMP_4) && TEMP_4_PIN < NUM_ANALOG_INPUTS
  REPORT_NAME_ANALOG(TEMP_4_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TEMP_BED) && TEMP_BED_PIN < NUM_ANALOG_INPUTS
  REPORT_NAME_ANALOG(TEMP_BED_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TEMP_CHAMBER) && TEMP_CHAMBER_PIN < NUM_ANALOG_INPUTS
  REPORT_NAME_ANALOG(TEMP_CHAMBER_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TEMP_X) && TEMP_X_PIN < NUM_ANALOG_INPUTS
  REPORT_NAME_ANALOG(TEMP_X_PIN, __LINE__ )
#endif
#if PIN_EXISTS(THERMO_DO)
  REPORT_NAME_DIGITAL(THERMO_DO_PIN, __LINE__ )
#endif
#if PIN_EXISTS(THERMO_SCK)
  REPORT_NAME_DIGITAL(THERMO_SCK_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TLC_BLANK)
  REPORT_NAME_DIGITAL(TLC_BLANK_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TLC_CLOCK)
  REPORT_NAME_DIGITAL(TLC_CLOCK_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TLC_DATA)
  REPORT_NAME_DIGITAL(TLC_DATA_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TLC_XLAT)
  REPORT_NAME_DIGITAL(TLC_XLAT_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TOOL_0)
  REPORT_NAME_DIGITAL(TOOL_0_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TOOL_0_PWM)
  REPORT_NAME_DIGITAL(TOOL_0_PWM_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TOOL_1)
  REPORT_NAME_DIGITAL(TOOL_1_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TOOL_1_PWM)
  REPORT_NAME_DIGITAL(TOOL_1_PWM_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TOOL_2)
  REPORT_NAME_DIGITAL(TOOL_2_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TOOL_2_PWM)
  REPORT_NAME_DIGITAL(TOOL_2_PWM_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TOOL_3)
  REPORT_NAME_DIGITAL(TOOL_3_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TOOL_3_PWM)
  REPORT_NAME_DIGITAL(TOOL_3_PWM_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TOOL_PWM)
  REPORT_NAME_DIGITAL(TOOL_PWM_PIN, __LINE__ )
#endif
#if PIN_EXISTS(TX_ENABLE)
  REPORT_NAME_DIGITAL(TX_ENABLE_PIN, __LINE__ )
#endif
#if defined(UI1) && UI1 >= 0
  REPORT_NAME_DIGITAL(UI1, __LINE__ )
#endif
#if defined(UI2) && UI2 >= 0
  REPORT_NAME_DIGITAL(UI2, __LINE__ )
#endif
#if defined(UNUSED_PWM) && UNUSED_PWM >= 0
  REPORT_NAME_DIGITAL(UNUSED_PWM, __LINE__ )
#endif
#if PIN_EXISTS(X_ATT)
  REPORT_NAME_DIGITAL(X_ATT_PIN, __LINE__ )
#endif
#if PIN_EXISTS(X_CS)
  REPORT_NAME_DIGITAL(X_CS_PIN, __LINE__ )
#endif
#if PIN_EXISTS(X_DIR)
  REPORT_NAME_DIGITAL(X_DIR_PIN, __LINE__ )
#endif
#if PIN_EXISTS(X_ENABLE)
  REPORT_NAME_DIGITAL(X_ENABLE_PIN, __LINE__ )
#endif
#if PIN_EXISTS(X_MAX)
  REPORT_NAME_DIGITAL(X_MAX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(X_MIN)
  REPORT_NAME_DIGITAL(X_MIN_PIN, __LINE__ )
#endif
#if PIN_EXISTS(X_MS1)
  REPORT_NAME_DIGITAL(X_MS1_PIN, __LINE__ )
#endif
#if PIN_EXISTS(X_MS2)
  REPORT_NAME_DIGITAL(X_MS2_PIN, __LINE__ )
#endif
#if PIN_EXISTS(X_STEP)
  REPORT_NAME_DIGITAL(X_STEP_PIN, __LINE__ )
#endif
#if PIN_EXISTS(X_STOP)
  REPORT_NAME_DIGITAL(X_STOP_PIN, __LINE__ )
#endif
#if PIN_EXISTS(X2_DIR)
  REPORT_NAME_DIGITAL(X2_DIR_PIN, __LINE__ )
#endif
#if PIN_EXISTS(X2_ENABLE)
  REPORT_NAME_DIGITAL(X2_ENABLE_PIN, __LINE__ )
#endif
#if PIN_EXISTS(X2_STEP)
  REPORT_NAME_DIGITAL(X2_STEP_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Y_ATT)
  REPORT_NAME_DIGITAL(Y_ATT_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Y_CS)
  REPORT_NAME_DIGITAL(Y_CS_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Y_DIR)
  REPORT_NAME_DIGITAL(Y_DIR_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Y_ENABLE)
  REPORT_NAME_DIGITAL(Y_ENABLE_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Y_MAX)
  REPORT_NAME_DIGITAL(Y_MAX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Y_MIN)
  REPORT_NAME_DIGITAL(Y_MIN_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Y_MS1)
  REPORT_NAME_DIGITAL(Y_MS1_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Y_MS2)
  REPORT_NAME_DIGITAL(Y_MS2_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Y_STEP)
  REPORT_NAME_DIGITAL(Y_STEP_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Y_STOP)
  REPORT_NAME_DIGITAL(Y_STOP_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Y2_DIR)
  REPORT_NAME_DIGITAL(Y2_DIR_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Y2_ENABLE)
  REPORT_NAME_DIGITAL(Y2_ENABLE_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Y2_STEP)
  REPORT_NAME_DIGITAL(Y2_STEP_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Z_ATT)
  REPORT_NAME_DIGITAL(Z_ATT_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Z_CS)
  REPORT_NAME_DIGITAL(Z_CS_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Z_DIR)
  REPORT_NAME_DIGITAL(Z_DIR_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Z_ENABLE)
  REPORT_NAME_DIGITAL(Z_ENABLE_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Z_MAX)
  REPORT_NAME_DIGITAL(Z_MAX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Z_MIN)
  REPORT_NAME_DIGITAL(Z_MIN_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Z_MIN_PROBE)
  REPORT_NAME_DIGITAL(Z_MIN_PROBE_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Z_MS1)
  REPORT_NAME_DIGITAL(Z_MS1_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Z_MS2)
  REPORT_NAME_DIGITAL(Z_MS2_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Z_STEP)
  REPORT_NAME_DIGITAL(Z_STEP_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Z_STOP)
  REPORT_NAME_DIGITAL(Z_STOP_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Z2_DIR)
  REPORT_NAME_DIGITAL(Z2_DIR_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Z2_ENABLE)
  REPORT_NAME_DIGITAL(Z2_ENABLE_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Z2_STEP)
  REPORT_NAME_DIGITAL(Z2_STEP_PIN, __LINE__ )
#endif
#if PIN_EXISTS(X_SERIAL_TX)
  REPORT_NAME_DIGITAL(X_SERIAL_TX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(X_SERIAL_RX)
  REPORT_NAME_DIGITAL(X_SERIAL_RX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(X2_SERIAL_TX)
  REPORT_NAME_DIGITAL(X2_SERIAL_TX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(X2_SERIAL_RX)
  REPORT_NAME_DIGITAL(X2_SERIAL_RX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Y_SERIAL_TX)
  REPORT_NAME_DIGITAL(Y_SERIAL_TX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Y_SERIAL_RX)
  REPORT_NAME_DIGITAL(Y_SERIAL_RX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Y2_SERIAL_TX)
  REPORT_NAME_DIGITAL(Y2_SERIAL_TX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Y2_SERIAL_RX)
  REPORT_NAME_DIGITAL(Y2_SERIAL_RX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Z_SERIAL_TX)
  REPORT_NAME_DIGITAL(Z_SERIAL_TX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Z_SERIAL_RX)
  REPORT_NAME_DIGITAL(Z_SERIAL_RX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Z2_SERIAL_TX)
  REPORT_NAME_DIGITAL(Z2_SERIAL_TX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(Z2_SERIAL_RX)
  REPORT_NAME_DIGITAL(Z2_SERIAL_RX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E0_SERIAL_TX)
  REPORT_NAME_DIGITAL(E0_SERIAL_TX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E0_SERIAL_RX)
  REPORT_NAME_DIGITAL(E0_SERIAL_RX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E1_SERIAL_TX)
  REPORT_NAME_DIGITAL(E1_SERIAL_TX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E1_SERIAL_RX)
  REPORT_NAME_DIGITAL(E1_SERIAL_RX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E2_SERIAL_TX)
  REPORT_NAME_DIGITAL(E2_SERIAL_TX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E2_SERIAL_RX)
  REPORT_NAME_DIGITAL(E2_SERIAL_RX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E3_SERIAL_TX)
  REPORT_NAME_DIGITAL(E3_SERIAL_TX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E3_SERIAL_RX)
  REPORT_NAME_DIGITAL(E3_SERIAL_RX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E4_SERIAL_TX)
  REPORT_NAME_DIGITAL(E4_SERIAL_TX_PIN, __LINE__ )
#endif
#if PIN_EXISTS(E4_SERIAL_RX)
  REPORT_NAME_DIGITAL(E4_SERIAL_RX_PIN, __LINE__ )
#endif
