# Начало работы

В центре любого Vuex-приложения находится **хранилище**. "Хранилище" — это, упрощённо говоря, контейнер, который хранит **состояние** вашего приложения. Два момента отличают хранилище Vuex от простого глобального объекта:

1. Хранилища Vuex реактивны. Если компоненты Vue зависят от их состояния, изменения состояния хранилища спровоцирует соответствующие изменения компонентов.

2. Непосредственное изменение состояния хранилища запрещено. Единственный способ внести изменения — явно **вызвать мутацию**. Этот подход позволяет быть уверенным, что каждое изменение оставляет в системе след, и даёт возможность использовать инструменты, позволяющие лучше понять работу приложения.

### Простейшее Хранилище

> **ЗАМЕЧАНИЕ:** Мы будем использовать синтаксис ES2015 для примеров кода на всём протяжении этой документации. Если вы с ним ещё не разобрались, [сейчас самое время](https://babeljs.io/docs/learn-es2015/)!

После [установки](installation.md) Vuex, давайте создадим хранилище. Всё довольно просто: нужно лишь указать исходное состояние и мутации:

``` js
// Удостоверьтесь, что вызвали Vue.use(Vuex) в коде до этого, если используете модульный сборщик

const store = new Vuex.Store({
  state: {
    count: 0
  },
  mutations: {
    increment (state) {
      state.count++
    }
  }
})
```

Теперь мы можем получить доступ к объекту состояния `store.state`, или вызвать изменение состояния методом `store.commit`:

``` js
store.commit('increment')

console.log(store.state.count) // -> 1
```

Ещё раз заметим: мы вызываем мутацию вместо того чтобы напрямую изменить `store.state.count` потому что мы хотим явным образом отслеживать изменения. Это простое архитектурное соглашение делает наши намерения более очевидными и упрощает понимание для читателя кода того, как измененяется состояние приложения. Кроме того, этот подход позволяет реализовать инструменты для логирования каждой мутации, создания моментальных слепков состояния приложения и даже применения "машины времени" при отладке.

Поскольку хранилище реактивно, для использование его состояния в компонентах достаточно просто создать вычисляемые свойства. Изменения состояния можно вызывать, инициализируя мутации в методах компонентов.

Вот пример [простейшего приложения Vuex, реализующего счётчик](https://jsfiddle.net/yyx990803/n9jmu5v7/).

Далее мы более подробно обсудим каждую из основных концепций, начиная с [Состояния](state.md)
