# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `elftools` gem.
# Please instead update this file by running `bin/tapioca gem elftools`.

# The ELF parsing tools!
# Main entry point is {ELFTools::ELFFile}, see it
# for more information.
#
# source://elftools//lib/elftools/constants.rb#3
module ELFTools; end

# Define constants from elf.h.
# Mostly refer from https://github.com/torvalds/linux/blob/master/include/uapi/linux/elf.h
# and binutils/elfcpp/elfcpp.h.
#
# source://elftools//lib/elftools/constants.rb#7
module ELFTools::Constants
  include ::ELFTools::Constants::DF
  include ::ELFTools::Constants::DT
  include ::ELFTools::Constants::EM
  include ::ELFTools::Constants::ET
  include ::ELFTools::Constants::PF
  include ::ELFTools::Constants::PT
  include ::ELFTools::Constants::SHN
  include ::ELFTools::Constants::SHF
  include ::ELFTools::Constants::SHT
  include ::ELFTools::Constants::STB
  include ::ELFTools::Constants::STT
end

# Values of `d_un.d_val' in the DT_FLAGS and DT_FLAGS_1 entry.
#
# source://elftools//lib/elftools/constants.rb#12
module ELFTools::Constants::DF; end

# Configuration alternative created.
#
# source://elftools//lib/elftools/constants.rb#32
ELFTools::Constants::DF::DF_1_CONFALT = T.let(T.unsafe(nil), Integer)

# Direct binding enabled.
#
# source://elftools//lib/elftools/constants.rb#27
ELFTools::Constants::DF::DF_1_DIRECT = T.let(T.unsafe(nil), Integer)

# Disp reloc applied at build time.
#
# source://elftools//lib/elftools/constants.rb#34
ELFTools::Constants::DF::DF_1_DISPRELDNE = T.let(T.unsafe(nil), Integer)

# Disp reloc applied at run-time.
#
# source://elftools//lib/elftools/constants.rb#35
ELFTools::Constants::DF::DF_1_DISPRELPND = T.let(T.unsafe(nil), Integer)

# Object is modified after built.
#
# source://elftools//lib/elftools/constants.rb#40
ELFTools::Constants::DF::DF_1_EDITED = T.let(T.unsafe(nil), Integer)

# Filtee terminates filters search.
#
# source://elftools//lib/elftools/constants.rb#33
ELFTools::Constants::DF::DF_1_ENDFILTEE = T.let(T.unsafe(nil), Integer)

# Set RTLD_GLOBAL for this object.
#
# source://elftools//lib/elftools/constants.rb#20
ELFTools::Constants::DF::DF_1_GLOBAL = T.let(T.unsafe(nil), Integer)

# Global auditing required.
#
# source://elftools//lib/elftools/constants.rb#43
ELFTools::Constants::DF::DF_1_GLOBAUDIT = T.let(T.unsafe(nil), Integer)

# Set RTLD_GROUP for this object.
#
# source://elftools//lib/elftools/constants.rb#21
ELFTools::Constants::DF::DF_1_GROUP = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#37
ELFTools::Constants::DF::DF_1_IGNMULDEF = T.let(T.unsafe(nil), Integer)

# Set RTLD_INITFIRST for this object
#
# source://elftools//lib/elftools/constants.rb#24
ELFTools::Constants::DF::DF_1_INITFIRST = T.let(T.unsafe(nil), Integer)

# Object is used to interpose.
#
# source://elftools//lib/elftools/constants.rb#29
ELFTools::Constants::DF::DF_1_INTERPOSE = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#47
ELFTools::Constants::DF::DF_1_KMOD = T.let(T.unsafe(nil), Integer)

# Trigger filtee loading at runtime.
#
# source://elftools//lib/elftools/constants.rb#23
ELFTools::Constants::DF::DF_1_LOADFLTR = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#49
ELFTools::Constants::DF::DF_1_NOCOMMON = T.let(T.unsafe(nil), Integer)

# Ignore default lib search path.
#
# source://elftools//lib/elftools/constants.rb#30
ELFTools::Constants::DF::DF_1_NODEFLIB = T.let(T.unsafe(nil), Integer)

# Set RTLD_NODELETE for this object.
#
# source://elftools//lib/elftools/constants.rb#22
ELFTools::Constants::DF::DF_1_NODELETE = T.let(T.unsafe(nil), Integer)

# Object has no-direct binding.
#
# source://elftools//lib/elftools/constants.rb#36
ELFTools::Constants::DF::DF_1_NODIRECT = T.let(T.unsafe(nil), Integer)

# Object can't be dldump'ed.
#
# source://elftools//lib/elftools/constants.rb#31
ELFTools::Constants::DF::DF_1_NODUMP = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#39
ELFTools::Constants::DF::DF_1_NOHDR = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#38
ELFTools::Constants::DF::DF_1_NOKSYMS = T.let(T.unsafe(nil), Integer)

# Set RTLD_NOOPEN for this object.
#
# source://elftools//lib/elftools/constants.rb#25
ELFTools::Constants::DF::DF_1_NOOPEN = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#41
ELFTools::Constants::DF::DF_1_NORELOC = T.let(T.unsafe(nil), Integer)

# Set RTLD_NOW for this object.
#
# source://elftools//lib/elftools/constants.rb#19
ELFTools::Constants::DF::DF_1_NOW = T.let(T.unsafe(nil), Integer)

# $ORIGIN must be handled.
#
# source://elftools//lib/elftools/constants.rb#26
ELFTools::Constants::DF::DF_1_ORIGIN = T.let(T.unsafe(nil), Integer)

# Object is a position-independent executable.
#
# source://elftools//lib/elftools/constants.rb#46
ELFTools::Constants::DF::DF_1_PIE = T.let(T.unsafe(nil), Integer)

# Singleton symbols are used.
#
# source://elftools//lib/elftools/constants.rb#44
ELFTools::Constants::DF::DF_1_SINGLETON = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#45
ELFTools::Constants::DF::DF_1_STUB = T.let(T.unsafe(nil), Integer)

# Object has individual interposers.
#
# source://elftools//lib/elftools/constants.rb#42
ELFTools::Constants::DF::DF_1_SYMINTPOSE = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#28
ELFTools::Constants::DF::DF_1_TRANS = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#48
ELFTools::Constants::DF::DF_1_WEAKFILTER = T.let(T.unsafe(nil), Integer)

# No lazy binding for this object
#
# source://elftools//lib/elftools/constants.rb#16
ELFTools::Constants::DF::DF_BIND_NOW = T.let(T.unsafe(nil), Integer)

# Object may use DF_ORIGIN
#
# source://elftools//lib/elftools/constants.rb#13
ELFTools::Constants::DF::DF_ORIGIN = T.let(T.unsafe(nil), Integer)

# Module uses the static TLS model
#
# source://elftools//lib/elftools/constants.rb#17
ELFTools::Constants::DF::DF_STATIC_TLS = T.let(T.unsafe(nil), Integer)

# Symbol resolutions starts here
#
# source://elftools//lib/elftools/constants.rb#14
ELFTools::Constants::DF::DF_SYMBOLIC = T.let(T.unsafe(nil), Integer)

# Object contains text relocations
#
# source://elftools//lib/elftools/constants.rb#15
ELFTools::Constants::DF::DF_TEXTREL = T.let(T.unsafe(nil), Integer)

# Dynamic table types, records in +d_tag+.
#
# source://elftools//lib/elftools/constants.rb#54
module ELFTools::Constants::DT; end

# see {DT_ADDRRNGLO}
#
# source://elftools//lib/elftools/constants.rb#115
ELFTools::Constants::DT::DT_ADDRRNGHI = T.let(T.unsafe(nil), Integer)

# Values between {DT_ADDRRNGLO} and {DT_ADDRRNGHI} use the +d_un.d_ptr+ field of the dynamic structure.
#
# source://elftools//lib/elftools/constants.rb#103
ELFTools::Constants::DT::DT_ADDRRNGLO = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#111
ELFTools::Constants::DT::DT_AUDIT = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#187
ELFTools::Constants::DT::DT_AUXILIARY = T.let(T.unsafe(nil), Integer)

# if the loader needs to do relocate now, superseded by the DF_BIND_NOW flag
#
# source://elftools//lib/elftools/constants.rb#79
ELFTools::Constants::DT::DT_BIND_NOW = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#109
ELFTools::Constants::DT::DT_CONFIG = T.let(T.unsafe(nil), Integer)

# for debugging
#
# source://elftools//lib/elftools/constants.rb#76
ELFTools::Constants::DT::DT_DEBUG = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#110
ELFTools::Constants::DT::DT_DEPAUDIT = T.let(T.unsafe(nil), Integer)

# just a lower bound
#
# source://elftools//lib/elftools/constants.rb#86
ELFTools::Constants::DT::DT_ENCODING = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#189
ELFTools::Constants::DT::DT_FILTER = T.let(T.unsafe(nil), Integer)

# where the termination function is
#
# source://elftools//lib/elftools/constants.rb#68
ELFTools::Constants::DT::DT_FINI = T.let(T.unsafe(nil), Integer)

# address of fini array
#
# source://elftools//lib/elftools/constants.rb#81
ELFTools::Constants::DT::DT_FINI_ARRAY = T.let(T.unsafe(nil), Integer)

# total size of fini array
#
# source://elftools//lib/elftools/constants.rb#83
ELFTools::Constants::DT::DT_FINI_ARRAYSZ = T.let(T.unsafe(nil), Integer)

# flags
#
# source://elftools//lib/elftools/constants.rb#85
ELFTools::Constants::DT::DT_FLAGS = T.let(T.unsafe(nil), Integer)

# flags
#
# source://elftools//lib/elftools/constants.rb#120
ELFTools::Constants::DT::DT_FLAGS_1 = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#107
ELFTools::Constants::DT::DT_GNU_CONFLICT = T.let(T.unsafe(nil), Integer)

# the gnu hash
#
# source://elftools//lib/elftools/constants.rb#104
ELFTools::Constants::DT::DT_GNU_HASH = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#108
ELFTools::Constants::DT::DT_GNU_LIBLIST = T.let(T.unsafe(nil), Integer)

# address of symbol hash table
#
# source://elftools//lib/elftools/constants.rb#59
ELFTools::Constants::DT::DT_HASH = T.let(T.unsafe(nil), Integer)

# see {DT_LOOS}
#
# source://elftools//lib/elftools/constants.rb#96
ELFTools::Constants::DT::DT_HIOS = T.let(T.unsafe(nil), Integer)

# see {DT_LOPROC}
#
# source://elftools//lib/elftools/constants.rb#191
ELFTools::Constants::DT::DT_HIPROC = T.let(T.unsafe(nil), Integer)

# where the initialization function is
#
# source://elftools//lib/elftools/constants.rb#67
ELFTools::Constants::DT::DT_INIT = T.let(T.unsafe(nil), Integer)

# address init array
#
# source://elftools//lib/elftools/constants.rb#80
ELFTools::Constants::DT::DT_INIT_ARRAY = T.let(T.unsafe(nil), Integer)

# total size of init array
#
# source://elftools//lib/elftools/constants.rb#82
ELFTools::Constants::DT::DT_INIT_ARRAYSZ = T.let(T.unsafe(nil), Integer)

# address of relocation entries associated solely with procedure linkage table
#
# source://elftools//lib/elftools/constants.rb#78
ELFTools::Constants::DT::DT_JMPREL = T.let(T.unsafe(nil), Integer)

# Values between {DT_LOOS} and {DT_HIOS} are reserved for operating system-specific semantics.
#
# source://elftools//lib/elftools/constants.rb#95
ELFTools::Constants::DT::DT_LOOS = T.let(T.unsafe(nil), Integer)

# Values between {DT_LOPROC} and {DT_HIPROC} are reserved for processor-specific semantics.
#
# source://elftools//lib/elftools/constants.rb#127
ELFTools::Constants::DT::DT_LOPROC = T.let(T.unsafe(nil), Integer)

# address of auxiliary +.dynamic+
#
# source://elftools//lib/elftools/constants.rb#181
ELFTools::Constants::DT::DT_MIPS_AUX_DYNAMIC = T.let(T.unsafe(nil), Integer)

# base address of the segment
#
# source://elftools//lib/elftools/constants.rb#144
ELFTools::Constants::DT::DT_MIPS_BASE_ADDRESS = T.let(T.unsafe(nil), Integer)

# size of compact relocation section (O32)
#
# source://elftools//lib/elftools/constants.rb#179
ELFTools::Constants::DT::DT_MIPS_COMPACT_SIZE = T.let(T.unsafe(nil), Integer)

# address of +.conflict+ section
#
# source://elftools//lib/elftools/constants.rb#146
ELFTools::Constants::DT::DT_MIPS_CONFLICT = T.let(T.unsafe(nil), Integer)

# number of entries in the +.conflict+ section
#
# source://elftools//lib/elftools/constants.rb#149
ELFTools::Constants::DT::DT_MIPS_CONFLICTNO = T.let(T.unsafe(nil), Integer)

# flags indicating information about C++ flavor
#
# source://elftools//lib/elftools/constants.rb#166
ELFTools::Constants::DT::DT_MIPS_CXX_FLAGS = T.let(T.unsafe(nil), Integer)

# delta C++ class definition
#
# source://elftools//lib/elftools/constants.rb#156
ELFTools::Constants::DT::DT_MIPS_DELTA_CLASS = T.let(T.unsafe(nil), Integer)

# delta symbols that hold class declarations
#
# source://elftools//lib/elftools/constants.rb#164
ELFTools::Constants::DT::DT_MIPS_DELTA_CLASSSYM = T.let(T.unsafe(nil), Integer)

# number of entries in {DT_MIPS_DELTA_CLASSSYM}
#
# source://elftools//lib/elftools/constants.rb#165
ELFTools::Constants::DT::DT_MIPS_DELTA_CLASSSYM_NO = T.let(T.unsafe(nil), Integer)

# number of entries in {DT_MIPS_DELTA_CLASS}
#
# source://elftools//lib/elftools/constants.rb#157
ELFTools::Constants::DT::DT_MIPS_DELTA_CLASS_NO = T.let(T.unsafe(nil), Integer)

# delta C++ class instances
#
# source://elftools//lib/elftools/constants.rb#158
ELFTools::Constants::DT::DT_MIPS_DELTA_INSTANCE = T.let(T.unsafe(nil), Integer)

# number of entries in {DT_MIPS_DELTA_INSTANCE}
#
# source://elftools//lib/elftools/constants.rb#159
ELFTools::Constants::DT::DT_MIPS_DELTA_INSTANCE_NO = T.let(T.unsafe(nil), Integer)

# delta relocations
#
# source://elftools//lib/elftools/constants.rb#160
ELFTools::Constants::DT::DT_MIPS_DELTA_RELOC = T.let(T.unsafe(nil), Integer)

# number of entries in {DT_MIPS_DELTA_RELOC}
#
# source://elftools//lib/elftools/constants.rb#161
ELFTools::Constants::DT::DT_MIPS_DELTA_RELOC_NO = T.let(T.unsafe(nil), Integer)

# delta symbols that Delta relocations refer to
#
# source://elftools//lib/elftools/constants.rb#162
ELFTools::Constants::DT::DT_MIPS_DELTA_SYM = T.let(T.unsafe(nil), Integer)

# number of entries in {DT_MIPS_DELTA_SYM}
#
# source://elftools//lib/elftools/constants.rb#163
ELFTools::Constants::DT::DT_MIPS_DELTA_SYM_NO = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#175
ELFTools::Constants::DT::DT_MIPS_DYNSTR_ALIGN = T.let(T.unsafe(nil), Integer)

# 32 bits of flags
#
# source://elftools//lib/elftools/constants.rb#143
ELFTools::Constants::DT::DT_MIPS_FLAGS = T.let(T.unsafe(nil), Integer)

# index of first dynamic symbol in global offset table
#
# source://elftools//lib/elftools/constants.rb#153
ELFTools::Constants::DT::DT_MIPS_GOTSYM = T.let(T.unsafe(nil), Integer)

# GP value for auxiliary GOTs
#
# source://elftools//lib/elftools/constants.rb#180
ELFTools::Constants::DT::DT_MIPS_GP_VALUE = T.let(T.unsafe(nil), Integer)

# GOT index of the first PTE for a hidden symbol
#
# source://elftools//lib/elftools/constants.rb#171
ELFTools::Constants::DT::DT_MIPS_HIDDEN_GOTIDX = T.let(T.unsafe(nil), Integer)

# number of page table entries in global offset table
#
# source://elftools//lib/elftools/constants.rb#154
ELFTools::Constants::DT::DT_MIPS_HIPAGENO = T.let(T.unsafe(nil), Integer)

# checksum of external strings and common sizes
#
# source://elftools//lib/elftools/constants.rb#141
ELFTools::Constants::DT::DT_MIPS_ICHECKSUM = T.let(T.unsafe(nil), Integer)

# address of +.interface+
#
# source://elftools//lib/elftools/constants.rb#174
ELFTools::Constants::DT::DT_MIPS_INTERFACE = T.let(T.unsafe(nil), Integer)

# size of the +.interface+ section
#
# source://elftools//lib/elftools/constants.rb#176
ELFTools::Constants::DT::DT_MIPS_INTERFACE_SIZE = T.let(T.unsafe(nil), Integer)

# index of version string in string table
#
# source://elftools//lib/elftools/constants.rb#142
ELFTools::Constants::DT::DT_MIPS_IVERSION = T.let(T.unsafe(nil), Integer)

# address of +.liblist+ section
#
# source://elftools//lib/elftools/constants.rb#147
ELFTools::Constants::DT::DT_MIPS_LIBLIST = T.let(T.unsafe(nil), Integer)

# number of entries in the +.liblist+ section
#
# source://elftools//lib/elftools/constants.rb#150
ELFTools::Constants::DT::DT_MIPS_LIBLISTNO = T.let(T.unsafe(nil), Integer)

# GOT index of the first PTE for a segment
#
# source://elftools//lib/elftools/constants.rb#169
ELFTools::Constants::DT::DT_MIPS_LOCALPAGE_GOTIDX = T.let(T.unsafe(nil), Integer)

# GOT index of the first PTE for a local symbol
#
# source://elftools//lib/elftools/constants.rb#170
ELFTools::Constants::DT::DT_MIPS_LOCAL_GOTIDX = T.let(T.unsafe(nil), Integer)

# number of local global offset table entries
#
# source://elftools//lib/elftools/constants.rb#148
ELFTools::Constants::DT::DT_MIPS_LOCAL_GOTNO = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#145
ELFTools::Constants::DT::DT_MIPS_MSYM = T.let(T.unsafe(nil), Integer)

# address of +.MIPS.options+
#
# source://elftools//lib/elftools/constants.rb#173
ELFTools::Constants::DT::DT_MIPS_OPTIONS = T.let(T.unsafe(nil), Integer)

# default suffix of DSO to be added by rld on +dlopen()+ calls
#
# source://elftools//lib/elftools/constants.rb#178
ELFTools::Constants::DT::DT_MIPS_PERF_SUFFIX = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#167
ELFTools::Constants::DT::DT_MIPS_PIXIE_INIT = T.let(T.unsafe(nil), Integer)

# address of the base of the PLTGOT
#
# source://elftools//lib/elftools/constants.rb#182
ELFTools::Constants::DT::DT_MIPS_PLTGOT = T.let(T.unsafe(nil), Integer)

# GOT index of the first PTE for a protected symbol
#
# source://elftools//lib/elftools/constants.rb#172
ELFTools::Constants::DT::DT_MIPS_PROTECTED_GOTIDX = T.let(T.unsafe(nil), Integer)

# address of run time loader map, used for debugging
#
# source://elftools//lib/elftools/constants.rb#155
ELFTools::Constants::DT::DT_MIPS_RLD_MAP = T.let(T.unsafe(nil), Integer)

# relative offset of run time loader map
#
# source://elftools//lib/elftools/constants.rb#184
ELFTools::Constants::DT::DT_MIPS_RLD_MAP_REL = T.let(T.unsafe(nil), Integer)

# size of +rld_text_resolve+ function stored in the GOT
#
# source://elftools//lib/elftools/constants.rb#177
ELFTools::Constants::DT::DT_MIPS_RLD_TEXT_RESOLVE_ADDR = T.let(T.unsafe(nil), Integer)

# 32 bit version number for runtime linker interface
#
# source://elftools//lib/elftools/constants.rb#139
ELFTools::Constants::DT::DT_MIPS_RLD_VERSION = T.let(T.unsafe(nil), Integer)

# base of a writable PLT
#
# source://elftools//lib/elftools/constants.rb#183
ELFTools::Constants::DT::DT_MIPS_RWPLT = T.let(T.unsafe(nil), Integer)

# address of +.MIPS.symlib+
#
# source://elftools//lib/elftools/constants.rb#168
ELFTools::Constants::DT::DT_MIPS_SYMBOL_LIB = T.let(T.unsafe(nil), Integer)

# number of entries in the +.dynsym+ section
#
# source://elftools//lib/elftools/constants.rb#151
ELFTools::Constants::DT::DT_MIPS_SYMTABNO = T.let(T.unsafe(nil), Integer)

# time stamp
#
# source://elftools//lib/elftools/constants.rb#140
ELFTools::Constants::DT::DT_MIPS_TIME_STAMP = T.let(T.unsafe(nil), Integer)

# index of first external dynamic symbol not referenced locally
#
# source://elftools//lib/elftools/constants.rb#152
ELFTools::Constants::DT::DT_MIPS_UNREFEXTNO = T.let(T.unsafe(nil), Integer)

# GNU-style hash table with xlat
#
# source://elftools//lib/elftools/constants.rb#185
ELFTools::Constants::DT::DT_MIPS_XHASH = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#113
ELFTools::Constants::DT::DT_MOVETAB = T.let(T.unsafe(nil), Integer)

# libraries need to be linked by loader
#
# source://elftools//lib/elftools/constants.rb#56
ELFTools::Constants::DT::DT_NEEDED = T.let(T.unsafe(nil), Integer)

# marks the end of the _DYNAMIC array
#
# source://elftools//lib/elftools/constants.rb#55
ELFTools::Constants::DT::DT_NULL = T.let(T.unsafe(nil), Integer)

# address of procedure linkage table or global offset table
#
# source://elftools//lib/elftools/constants.rb#58
ELFTools::Constants::DT::DT_PLTGOT = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#112
ELFTools::Constants::DT::DT_PLTPAD = T.let(T.unsafe(nil), Integer)

# type of relocation entry, either {DT_REL} or {DT_RELA}
#
# source://elftools//lib/elftools/constants.rb#75
ELFTools::Constants::DT::DT_PLTREL = T.let(T.unsafe(nil), Integer)

# total size of relocation entries
#
# source://elftools//lib/elftools/constants.rb#57
ELFTools::Constants::DT::DT_PLTRELSZ = T.let(T.unsafe(nil), Integer)

# start of the .glink section
#
# source://elftools//lib/elftools/constants.rb#132
ELFTools::Constants::DT::DT_PPC64_GLINK = T.let(T.unsafe(nil), Integer)

# start of the .opd section
#
# source://elftools//lib/elftools/constants.rb#133
ELFTools::Constants::DT::DT_PPC64_OPD = T.let(T.unsafe(nil), Integer)

# size of the .opd section
#
# source://elftools//lib/elftools/constants.rb#134
ELFTools::Constants::DT::DT_PPC64_OPDSZ = T.let(T.unsafe(nil), Integer)

# whether various optimisations are possible
#
# source://elftools//lib/elftools/constants.rb#135
ELFTools::Constants::DT::DT_PPC64_OPT = T.let(T.unsafe(nil), Integer)

# global offset table
#
# source://elftools//lib/elftools/constants.rb#129
ELFTools::Constants::DT::DT_PPC_GOT = T.let(T.unsafe(nil), Integer)

# whether various optimisations are possible
#
# source://elftools//lib/elftools/constants.rb#130
ELFTools::Constants::DT::DT_PPC_OPT = T.let(T.unsafe(nil), Integer)

# pre-initialization functions array
#
# source://elftools//lib/elftools/constants.rb#87
ELFTools::Constants::DT::DT_PREINIT_ARRAY = T.let(T.unsafe(nil), Integer)

# pre-initialization functions array size (bytes)
#
# source://elftools//lib/elftools/constants.rb#88
ELFTools::Constants::DT::DT_PREINIT_ARRAYSZ = T.let(T.unsafe(nil), Integer)

# similar to {DT_RELA}
#
# source://elftools//lib/elftools/constants.rb#72
ELFTools::Constants::DT::DT_REL = T.let(T.unsafe(nil), Integer)

# address of a relocation table
#
# source://elftools//lib/elftools/constants.rb#62
ELFTools::Constants::DT::DT_RELA = T.let(T.unsafe(nil), Integer)

# relative relocation count
#
# source://elftools//lib/elftools/constants.rb#118
ELFTools::Constants::DT::DT_RELACOUNT = T.let(T.unsafe(nil), Integer)

# size of each entry in the {DT_RELA} table
#
# source://elftools//lib/elftools/constants.rb#64
ELFTools::Constants::DT::DT_RELAENT = T.let(T.unsafe(nil), Integer)

# total size of the {DT_RELA} table
#
# source://elftools//lib/elftools/constants.rb#63
ELFTools::Constants::DT::DT_RELASZ = T.let(T.unsafe(nil), Integer)

# relative relocation count
#
# source://elftools//lib/elftools/constants.rb#119
ELFTools::Constants::DT::DT_RELCOUNT = T.let(T.unsafe(nil), Integer)

# size of each entry in the {DT_REL} table
#
# source://elftools//lib/elftools/constants.rb#74
ELFTools::Constants::DT::DT_RELENT = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#91
ELFTools::Constants::DT::DT_RELR = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#92
ELFTools::Constants::DT::DT_RELRENT = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#90
ELFTools::Constants::DT::DT_RELRSZ = T.let(T.unsafe(nil), Integer)

# total size of the {DT_REL} table
#
# source://elftools//lib/elftools/constants.rb#73
ELFTools::Constants::DT::DT_RELSZ = T.let(T.unsafe(nil), Integer)

# has been superseded by {DT_RUNPATH}
#
# source://elftools//lib/elftools/constants.rb#70
ELFTools::Constants::DT::DT_RPATH = T.let(T.unsafe(nil), Integer)

# path of libraries for searching
#
# source://elftools//lib/elftools/constants.rb#84
ELFTools::Constants::DT::DT_RUNPATH = T.let(T.unsafe(nil), Integer)

# the shared object name
#
# source://elftools//lib/elftools/constants.rb#69
ELFTools::Constants::DT::DT_SONAME = T.let(T.unsafe(nil), Integer)

# index of an +STT_SPARC_REGISTER+ symbol within the {DT_SYMTAB} table
#
# source://elftools//lib/elftools/constants.rb#137
ELFTools::Constants::DT::DT_SPARC_REGISTER = T.let(T.unsafe(nil), Integer)

# total size of {DT_STRTAB}
#
# source://elftools//lib/elftools/constants.rb#65
ELFTools::Constants::DT::DT_STRSZ = T.let(T.unsafe(nil), Integer)

# address of string table
#
# source://elftools//lib/elftools/constants.rb#60
ELFTools::Constants::DT::DT_STRTAB = T.let(T.unsafe(nil), Integer)

# has been superseded by the DF_SYMBOLIC flag
#
# source://elftools//lib/elftools/constants.rb#71
ELFTools::Constants::DT::DT_SYMBOLIC = T.let(T.unsafe(nil), Integer)

# size of each entry in {DT_SYMTAB}
#
# source://elftools//lib/elftools/constants.rb#66
ELFTools::Constants::DT::DT_SYMENT = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#114
ELFTools::Constants::DT::DT_SYMINFO = T.let(T.unsafe(nil), Integer)

# address of symbol table
#
# source://elftools//lib/elftools/constants.rb#61
ELFTools::Constants::DT::DT_SYMTAB = T.let(T.unsafe(nil), Integer)

# address of the +SHT_SYMTAB_SHNDX+ section associated with {DT_SYMTAB} table
#
# source://elftools//lib/elftools/constants.rb#89
ELFTools::Constants::DT::DT_SYMTAB_SHNDX = T.let(T.unsafe(nil), Integer)

# has been superseded by the DF_TEXTREL flag
#
# source://elftools//lib/elftools/constants.rb#77
ELFTools::Constants::DT::DT_TEXTREL = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#106
ELFTools::Constants::DT::DT_TLSDESC_GOT = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#105
ELFTools::Constants::DT::DT_TLSDESC_PLT = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#188
ELFTools::Constants::DT::DT_USED = T.let(T.unsafe(nil), Integer)

# see {DT_VALRNGLO}
#
# source://elftools//lib/elftools/constants.rb#100
ELFTools::Constants::DT::DT_VALRNGHI = T.let(T.unsafe(nil), Integer)

# Values between {DT_VALRNGLO} and {DT_VALRNGHI} use the +d_un.d_val+ field of the dynamic structure.
#
# source://elftools//lib/elftools/constants.rb#99
ELFTools::Constants::DT::DT_VALRNGLO = T.let(T.unsafe(nil), Integer)

# address of version definition table
#
# source://elftools//lib/elftools/constants.rb#121
ELFTools::Constants::DT::DT_VERDEF = T.let(T.unsafe(nil), Integer)

# number of entries in {DT_VERDEF}
#
# source://elftools//lib/elftools/constants.rb#122
ELFTools::Constants::DT::DT_VERDEFNUM = T.let(T.unsafe(nil), Integer)

# address of version dependency table
#
# source://elftools//lib/elftools/constants.rb#123
ELFTools::Constants::DT::DT_VERNEED = T.let(T.unsafe(nil), Integer)

# number of entries in {DT_VERNEED}
#
# source://elftools//lib/elftools/constants.rb#124
ELFTools::Constants::DT::DT_VERNEEDNUM = T.let(T.unsafe(nil), Integer)

# section address of .gnu.version
#
# source://elftools//lib/elftools/constants.rb#117
ELFTools::Constants::DT::DT_VERSYM = T.let(T.unsafe(nil), Integer)

# ELF magic header
#
# source://elftools//lib/elftools/constants.rb#9
ELFTools::Constants::ELFMAG = T.let(T.unsafe(nil), String)

# These constants define the various ELF target machines.
#
# source://elftools//lib/elftools/constants.rb#196
module ELFTools::Constants::EM
  class << self
    # Return the architecture name according to +val+.
    # Used by {ELFTools::ELFFile#machine}.
    #
    # Only supports famous archs.
    #
    # @example
    #   mapping(3)
    #   #=> 'Intel 80386'
    #   mapping(6)
    #   #=> 'Intel 80386'
    #   mapping(62)
    #   #=> 'Advanced Micro Devices X86-64'
    #   mapping(1337)
    #   #=> '<unknown>: 0x539'
    # @param val [Integer] Value of +e_machine+.
    # @return [String] Name of architecture.
    #
    # source://elftools//lib/elftools/constants.rb#427
    def mapping(val); end
  end
end

# Intel 80386
#
# source://elftools//lib/elftools/constants.rb#200
ELFTools::Constants::EM::EM_386 = T.let(T.unsafe(nil), Integer)

# Intel 80486
#
# source://elftools//lib/elftools/constants.rb#203
ELFTools::Constants::EM::EM_486 = T.let(T.unsafe(nil), Integer)

# Tachyum
#
# source://elftools//lib/elftools/constants.rb#397
ELFTools::Constants::EM::EM_56800EF = T.let(T.unsafe(nil), Integer)

# Renesas 78K0R
#
# source://elftools//lib/elftools/constants.rb#358
ELFTools::Constants::EM::EM_56800EX = T.let(T.unsafe(nil), Integer)

# Kalray VLIW core of the MPPA processor family
#
# source://elftools//lib/elftools/constants.rb#392
ELFTools::Constants::EM::EM_65816 = T.let(T.unsafe(nil), Integer)

# Motorola MC68HC08 Microcontroller
#
# source://elftools//lib/elftools/constants.rb#256
ELFTools::Constants::EM::EM_68HC05 = T.let(T.unsafe(nil), Integer)

# Motorola MC68HC11 Microcontroller
#
# source://elftools//lib/elftools/constants.rb#255
ELFTools::Constants::EM::EM_68HC08 = T.let(T.unsafe(nil), Integer)

# Motorola MC68HC16 Microcontroller
#
# source://elftools//lib/elftools/constants.rb#254
ELFTools::Constants::EM::EM_68HC11 = T.let(T.unsafe(nil), Integer)

# Motorola Coldfire
#
# source://elftools//lib/elftools/constants.rb#237
ELFTools::Constants::EM::EM_68HC12 = T.let(T.unsafe(nil), Integer)

# STMicroelectronics ST7 8-bit microcontroller
#
# source://elftools//lib/elftools/constants.rb#253
ELFTools::Constants::EM::EM_68HC16 = T.let(T.unsafe(nil), Integer)

# Motorola 68000
#
# source://elftools//lib/elftools/constants.rb#201
ELFTools::Constants::EM::EM_68K = T.let(T.unsafe(nil), Integer)

# Broadcom VideoCore V processor
#
# source://elftools//lib/elftools/constants.rb#357
ELFTools::Constants::EM::EM_78K0R = T.let(T.unsafe(nil), Integer)

# QUALCOMM DSP6 Processor
#
# source://elftools//lib/elftools/constants.rb#324
ELFTools::Constants::EM::EM_8051 = T.let(T.unsafe(nil), Integer)

# Intel 80860
#
# source://elftools//lib/elftools/constants.rb#204
ELFTools::Constants::EM::EM_860 = T.let(T.unsafe(nil), Integer)

# Motorola 88000
#
# source://elftools//lib/elftools/constants.rb#202
ELFTools::Constants::EM::EM_88K = T.let(T.unsafe(nil), Integer)

# Sun's "v8plus"
#
# source://elftools//lib/elftools/constants.rb#216
ELFTools::Constants::EM::EM_960 = T.let(T.unsafe(nil), Integer)

# Intel K1OM
#
# source://elftools//lib/elftools/constants.rb#342
ELFTools::Constants::EM::EM_AARCH64 = T.let(T.unsafe(nil), Integer)

# This is an interim value that we will use until the committee comes up with a final number.
#
# source://elftools//lib/elftools/constants.rb#402
ELFTools::Constants::EM::EM_ALPHA = T.let(T.unsafe(nil), Integer)

# Icera Semiconductor Inc. Deep Execution Processor
#
# source://elftools//lib/elftools/constants.rb#297
ELFTools::Constants::EM::EM_ALTERA_NIOS2 = T.let(T.unsafe(nil), Integer)

# Moxie processor family
#
# source://elftools//lib/elftools/constants.rb#378
ELFTools::Constants::EM::EM_AMDGPU = T.let(T.unsafe(nil), Integer)

# Siemens Tricore embedded processor
#
# source://elftools//lib/elftools/constants.rb#229
ELFTools::Constants::EM::EM_ARC = T.let(T.unsafe(nil), Integer)

# Sharp embedded microprocessor
#
# source://elftools//lib/elftools/constants.rb#293
ELFTools::Constants::EM::EM_ARCA = T.let(T.unsafe(nil), Integer)

# OpenRISC 32-bit embedded processor
#
# source://elftools//lib/elftools/constants.rb#277
ELFTools::Constants::EM::EM_ARC_COMPACT = T.let(T.unsafe(nil), Integer)

# KIPO-KAIST Core-A 2nd generation processor family
#
# source://elftools//lib/elftools/constants.rb#353
ELFTools::Constants::EM::EM_ARC_COMPACT2 = T.let(T.unsafe(nil), Integer)

# MOS Technology MCS 6502 processor
#
# source://elftools//lib/elftools/constants.rb#390
ELFTools::Constants::EM::EM_ARC_COMPACT3 = T.let(T.unsafe(nil), Integer)

# C-SKY processor family
#
# source://elftools//lib/elftools/constants.rb#388
ELFTools::Constants::EM::EM_ARC_COMPACT3_64 = T.let(T.unsafe(nil), Integer)

# Motorola M*Core
#
# source://elftools//lib/elftools/constants.rb#225
ELFTools::Constants::EM::EM_ARM = T.let(T.unsafe(nil), Integer)

# SiTera Prism
#
# source://elftools//lib/elftools/constants.rb#267
ELFTools::Constants::EM::EM_AVR = T.let(T.unsafe(nil), Integer)

# ARM 64 bit
#
# source://elftools//lib/elftools/constants.rb#343
ELFTools::Constants::EM::EM_AVR32 = T.let(T.unsafe(nil), Integer)

# Freescale 56800EX Digital Signal Controller (DSC)
#
# source://elftools//lib/elftools/constants.rb#359
ELFTools::Constants::EM::EM_BA1 = T.let(T.unsafe(nil), Integer)

# Beyond BA1 CPU architecture
#
# source://elftools//lib/elftools/constants.rb#360
ELFTools::Constants::EM::EM_BA2 = T.let(T.unsafe(nil), Integer)

# TI msp430 micro controller
#
# source://elftools//lib/elftools/constants.rb#290
ELFTools::Constants::EM::EM_BLACKFIN = T.let(T.unsafe(nil), Integer)

# CEVA X2 Processor Family
#
# source://elftools//lib/elftools/constants.rb#382
ELFTools::Constants::EM::EM_BPF = T.let(T.unsafe(nil), Integer)

# Motorola XGATE embedded processor
#
# source://elftools//lib/elftools/constants.rb#300
ELFTools::Constants::EM::EM_C116 = T.let(T.unsafe(nil), Integer)

# KM211 KVARC processor
#
# source://elftools//lib/elftools/constants.rb#369
ELFTools::Constants::EM::EM_CDP = T.let(T.unsafe(nil), Integer)

# Microchip Technology dsPIC30F Digital Signal Controller
#
# source://elftools//lib/elftools/constants.rb#303
ELFTools::Constants::EM::EM_CE = T.let(T.unsafe(nil), Integer)

# Lanai 32-bit processor
#
# source://elftools//lib/elftools/constants.rb#380
ELFTools::Constants::EM::EM_CEVA = T.let(T.unsafe(nil), Integer)

# CEVA Processor Architecture Family
#
# source://elftools//lib/elftools/constants.rb#381
ELFTools::Constants::EM::EM_CEVA_X2 = T.let(T.unsafe(nil), Integer)

# Tilera TILE-Gx
#
# source://elftools//lib/elftools/constants.rb#350
ELFTools::Constants::EM::EM_CLOUDSHIELD = T.let(T.unsafe(nil), Integer)

# Paneve CDP architecture family
#
# source://elftools//lib/elftools/constants.rb#370
ELFTools::Constants::EM::EM_COGE = T.let(T.unsafe(nil), Integer)

# Stanford MIPS-X
#
# source://elftools//lib/elftools/constants.rb#236
ELFTools::Constants::EM::EM_COLDFIRE = T.let(T.unsafe(nil), Integer)

# Cognitive Smart Memory Processor
#
# source://elftools//lib/elftools/constants.rb#371
ELFTools::Constants::EM::EM_COOL = T.let(T.unsafe(nil), Integer)

# CloudShield architecture family
#
# source://elftools//lib/elftools/constants.rb#351
ELFTools::Constants::EM::EM_COREA_1ST = T.let(T.unsafe(nil), Integer)

# KIPO-KAIST Core-A 1st generation processor family
#
# source://elftools//lib/elftools/constants.rb#352
ELFTools::Constants::EM::EM_COREA_2ND = T.let(T.unsafe(nil), Integer)

# MAX Processor
#
# source://elftools//lib/elftools/constants.rb#287
ELFTools::Constants::EM::EM_CR = T.let(T.unsafe(nil), Integer)

# Cyan Technology eCOG16 family
#
# source://elftools//lib/elftools/constants.rb#337
ELFTools::Constants::EM::EM_CR16 = T.let(T.unsafe(nil), Integer)

# M2000 Reconfigurable RISC Microprocessor
#
# source://elftools//lib/elftools/constants.rb#332
ELFTools::Constants::EM::EM_CRAYNV2 = T.let(T.unsafe(nil), Integer)

# Digital VAX
#
# source://elftools//lib/elftools/constants.rb#260
ELFTools::Constants::EM::EM_CRIS = T.let(T.unsafe(nil), Integer)

# Altera Nios II soft-core processor
#
# source://elftools//lib/elftools/constants.rb#298
ELFTools::Constants::EM::EM_CRX = T.let(T.unsafe(nil), Integer)

# NEC Vector Engine
#
# source://elftools//lib/elftools/constants.rb#387
ELFTools::Constants::EM::EM_CSKY = T.let(T.unsafe(nil), Integer)

# Nanoradio Optimized RISC
#
# source://elftools//lib/elftools/constants.rb#373
ELFTools::Constants::EM::EM_CSR_KALIMBA = T.let(T.unsafe(nil), Integer)

# Xilinx MicroBlaze
#
# source://elftools//lib/elftools/constants.rb#348
ELFTools::Constants::EM::EM_CUDA = T.let(T.unsafe(nil), Integer)

# Bogus old m32r magic number, used by old tools.
#
# source://elftools//lib/elftools/constants.rb#405
ELFTools::Constants::EM::EM_CYGNUS_M32R = T.let(T.unsafe(nil), Integer)

# Also Panasonic/MEI MN10300, AM33
#
# source://elftools//lib/elftools/constants.rb#409
ELFTools::Constants::EM::EM_CYGNUS_MN10300 = T.let(T.unsafe(nil), Integer)

# STMicroelectronics 64bit VLIW Data Signal Processor
#
# source://elftools//lib/elftools/constants.rb#320
ELFTools::Constants::EM::EM_CYPRESS_M8C = T.let(T.unsafe(nil), Integer)

# Fujitsu FR30
#
# source://elftools//lib/elftools/constants.rb#269
ELFTools::Constants::EM::EM_D10V = T.let(T.unsafe(nil), Integer)

# Mitsubishi D10V
#
# source://elftools//lib/elftools/constants.rb#270
ELFTools::Constants::EM::EM_D30V = T.let(T.unsafe(nil), Integer)

# Sunplus S+core7 RISC processor
#
# source://elftools//lib/elftools/constants.rb#310
ELFTools::Constants::EM::EM_DSP24 = T.let(T.unsafe(nil), Integer)

# Renesas M16C series microprocessors
#
# source://elftools//lib/elftools/constants.rb#302
ELFTools::Constants::EM::EM_DSPIC30F = T.let(T.unsafe(nil), Integer)

# eXcess: 16/32/64-bit configurable embedded CPU
#
# source://elftools//lib/elftools/constants.rb#296
ELFTools::Constants::EM::EM_DXP = T.let(T.unsafe(nil), Integer)

# Andes Technology compact code size embedded RISC processor family
#
# source://elftools//lib/elftools/constants.rb#327
ELFTools::Constants::EM::EM_ECOG1 = T.let(T.unsafe(nil), Integer)

# MCST Elbrus general purpose hardware architecture
#
# source://elftools//lib/elftools/constants.rb#336
ELFTools::Constants::EM::EM_ECOG16 = T.let(T.unsafe(nil), Integer)

# Cyan Technology eCOG1X family
#
# source://elftools//lib/elftools/constants.rb#328
ELFTools::Constants::EM::EM_ECOG1X = T.let(T.unsafe(nil), Integer)

# Analog Devices SHARC family of 32-bit DSP processors
#
# source://elftools//lib/elftools/constants.rb#308
ELFTools::Constants::EM::EM_ECOG2 = T.let(T.unsafe(nil), Integer)

# National Semiconductor CompactRISC 16-bit processor
#
# source://elftools//lib/elftools/constants.rb#338
ELFTools::Constants::EM::EM_ETPU = T.let(T.unsafe(nil), Integer)

# Microprocessor series from PKU-Unity Ltd. and MPRC of Peking University
#
# source://elftools//lib/elftools/constants.rb#295
ELFTools::Constants::EM::EM_EXCESS = T.let(T.unsafe(nil), Integer)

# National Semiconductor CompactRISC
#
# source://elftools//lib/elftools/constants.rb#288
ELFTools::Constants::EM::EM_F2MC16 = T.let(T.unsafe(nil), Integer)

# Infineon Technologies 32-bit embedded cpu
#
# source://elftools//lib/elftools/constants.rb#262
ELFTools::Constants::EM::EM_FIREPATH = T.let(T.unsafe(nil), Integer)

# NEC V800 series
#
# source://elftools//lib/elftools/constants.rb#222
ELFTools::Constants::EM::EM_FR20 = T.let(T.unsafe(nil), Integer)

# Atmel AVR 8-bit microcontroller
#
# source://elftools//lib/elftools/constants.rb#268
ELFTools::Constants::EM::EM_FR30 = T.let(T.unsafe(nil), Integer)

# NXP 56800EF Digital Signal Controller (DSC)
#
# source://elftools//lib/elftools/constants.rb#399
ELFTools::Constants::EM::EM_FRV = T.let(T.unsafe(nil), Integer)

# Controls and Data Services VISIUMcore processor
#
# source://elftools//lib/elftools/constants.rb#376
ELFTools::Constants::EM::EM_FT32 = T.let(T.unsafe(nil), Integer)

# Digital Equipment Corp. PDP-11
#
# source://elftools//lib/elftools/constants.rb#250
ELFTools::Constants::EM::EM_FX66 = T.let(T.unsafe(nil), Integer)

# Linux BPF - in-kernel virtual machine
#
# source://elftools//lib/elftools/constants.rb#383
ELFTools::Constants::EM::EM_GRAPHCORE_IPU = T.let(T.unsafe(nil), Integer)

# Renesas H8/300H
#
# source://elftools//lib/elftools/constants.rb#232
ELFTools::Constants::EM::EM_H8S = T.let(T.unsafe(nil), Integer)

# ARC Cores
#
# source://elftools//lib/elftools/constants.rb#230
ELFTools::Constants::EM::EM_H8_300 = T.let(T.unsafe(nil), Integer)

# Renesas H8/300
#
# source://elftools//lib/elftools/constants.rb#231
ELFTools::Constants::EM::EM_H8_300H = T.let(T.unsafe(nil), Integer)

# Renesas H8S
#
# source://elftools//lib/elftools/constants.rb#233
ELFTools::Constants::EM::EM_H8_500 = T.let(T.unsafe(nil), Integer)

# Donald Knuth's educational 64-bit processor
#
# source://elftools//lib/elftools/constants.rb#265
ELFTools::Constants::EM::EM_HUANY = T.let(T.unsafe(nil), Integer)

# Renesas H8/500H
#
# source://elftools//lib/elftools/constants.rb#234
ELFTools::Constants::EM::EM_IA_64 = T.let(T.unsafe(nil), Integer)

# Graphcore Intelligent Processing Unit
#
# source://elftools//lib/elftools/constants.rb#384
ELFTools::Constants::EM::EM_IMG1 = T.let(T.unsafe(nil), Integer)

# Microchip 8-bit PIC(r) family
#
# source://elftools//lib/elftools/constants.rb#363
ELFTools::Constants::EM::EM_INTELGT = T.let(T.unsafe(nil), Integer)

# STMicroelectronics ST200 microcontroller
#
# source://elftools//lib/elftools/constants.rb#285
ELFTools::Constants::EM::EM_IP2K = T.let(T.unsafe(nil), Integer)

# Axis Communications 32-bit embedded processor
#
# source://elftools//lib/elftools/constants.rb#261
ELFTools::Constants::EM::EM_JAVELIN = T.let(T.unsafe(nil), Integer)

# Intel L1OM
#
# source://elftools//lib/elftools/constants.rb#341
ELFTools::Constants::EM::EM_K1OM = T.let(T.unsafe(nil), Integer)

# LoongArch
#
# source://elftools//lib/elftools/constants.rb#394
ELFTools::Constants::EM::EM_KF32 = T.let(T.unsafe(nil), Integer)

# Intel Graphics Technology
#
# source://elftools//lib/elftools/constants.rb#364
ELFTools::Constants::EM::EM_KM32 = T.let(T.unsafe(nil), Integer)

# KM211 KMX32 32-bit processor
#
# source://elftools//lib/elftools/constants.rb#366
ELFTools::Constants::EM::EM_KMX16 = T.let(T.unsafe(nil), Integer)

# KM211 KM32 32-bit processor
#
# source://elftools//lib/elftools/constants.rb#365
ELFTools::Constants::EM::EM_KMX32 = T.let(T.unsafe(nil), Integer)

# KM211 KMX16 16-bit processor
#
# source://elftools//lib/elftools/constants.rb#367
ELFTools::Constants::EM::EM_KMX8 = T.let(T.unsafe(nil), Integer)

# KM211 KMX8 8-bit processor
#
# source://elftools//lib/elftools/constants.rb#368
ELFTools::Constants::EM::EM_KVARC = T.let(T.unsafe(nil), Integer)

# Synopsys ARCv2.3 32-bit
#
# source://elftools//lib/elftools/constants.rb#391
ELFTools::Constants::EM::EM_KVX = T.let(T.unsafe(nil), Integer)

# Infineon Technologies SLE9X core
#
# source://elftools//lib/elftools/constants.rb#340
ELFTools::Constants::EM::EM_L1OM = T.let(T.unsafe(nil), Integer)

# AMD GPU architecture
#
# source://elftools//lib/elftools/constants.rb#379
ELFTools::Constants::EM::EM_LANAI = T.let(T.unsafe(nil), Integer)

# Broadcom VideoCore III processor
#
# source://elftools//lib/elftools/constants.rb#312
ELFTools::Constants::EM::EM_LATTICEMICO32 = T.let(T.unsafe(nil), Integer)

# WDC 65816/65C816
#
# source://elftools//lib/elftools/constants.rb#393
ELFTools::Constants::EM::EM_LOONGARCH = T.let(T.unsafe(nil), Integer)

# Infineon C16x/XC16x processor
#
# source://elftools//lib/elftools/constants.rb#301
ELFTools::Constants::EM::EM_M16C = T.let(T.unsafe(nil), Integer)

# AT&T WE 32100
#
# source://elftools//lib/elftools/constants.rb#198
ELFTools::Constants::EM::EM_M32 = T.let(T.unsafe(nil), Integer)

# Freescale Communication Engine RISC core
#
# source://elftools//lib/elftools/constants.rb#304
ELFTools::Constants::EM::EM_M32C = T.let(T.unsafe(nil), Integer)

# Renesas V850
#
# source://elftools//lib/elftools/constants.rb#272
ELFTools::Constants::EM::EM_M32R = T.let(T.unsafe(nil), Integer)

# New Japan Radio (NJR) 16-bit DSP Processor
#
# source://elftools//lib/elftools/constants.rb#331
ELFTools::Constants::EM::EM_MANIK = T.let(T.unsafe(nil), Integer)

# Ubicom IP2022 micro controller
#
# source://elftools//lib/elftools/constants.rb#286
ELFTools::Constants::EM::EM_MAX = T.let(T.unsafe(nil), Integer)

# Cyan Technology eCOG1X family
#
# source://elftools//lib/elftools/constants.rb#329
ELFTools::Constants::EM::EM_MAXQ30 = T.let(T.unsafe(nil), Integer)

# XMOS xCORE processor family
#
# source://elftools//lib/elftools/constants.rb#362
ELFTools::Constants::EM::EM_MCHP_PIC = T.let(T.unsafe(nil), Integer)

# Synopsys ARCv2.3 64-bit
#
# source://elftools//lib/elftools/constants.rb#389
ELFTools::Constants::EM::EM_MCS6502 = T.let(T.unsafe(nil), Integer)

# Imagination Technologies Meta processor architecture
#
# source://elftools//lib/elftools/constants.rb#335
ELFTools::Constants::EM::EM_MCST_ELBRUS = T.let(T.unsafe(nil), Integer)

# Motorola Star*Core processor
#
# source://elftools//lib/elftools/constants.rb#243
ELFTools::Constants::EM::EM_ME16 = T.let(T.unsafe(nil), Integer)

# Renesas RX family
#
# source://elftools//lib/elftools/constants.rb#334
ELFTools::Constants::EM::EM_METAG = T.let(T.unsafe(nil), Integer)

# Tilera TILEPro
#
# source://elftools//lib/elftools/constants.rb#347
ELFTools::Constants::EM::EM_MICROBLAZE = T.let(T.unsafe(nil), Integer)

# MIPS R3000 (officially, big-endian only)
#
# source://elftools//lib/elftools/constants.rb#205
ELFTools::Constants::EM::EM_MIPS = T.let(T.unsafe(nil), Integer)

# Next two are historical and binaries and
# modules of these types will be rejected by Linux.
#
# source://elftools//lib/elftools/constants.rb#210
ELFTools::Constants::EM::EM_MIPS_RS3_LE = T.let(T.unsafe(nil), Integer)

# MIPS R3000 little-endian
#
# source://elftools//lib/elftools/constants.rb#211
ELFTools::Constants::EM::EM_MIPS_RS4_BE = T.let(T.unsafe(nil), Integer)

# HP/Intel IA-64
#
# source://elftools//lib/elftools/constants.rb#235
ELFTools::Constants::EM::EM_MIPS_X = T.let(T.unsafe(nil), Integer)

# Motorola M68HC12
#
# source://elftools//lib/elftools/constants.rb#238
ELFTools::Constants::EM::EM_MMA = T.let(T.unsafe(nil), Integer)

# Texas Instruments Programmable Realtime Unit
#
# source://elftools//lib/elftools/constants.rb#319
ELFTools::Constants::EM::EM_MMDSP_PLUS = T.let(T.unsafe(nil), Integer)

# LSI Logic's 16-bit DSP processor
#
# source://elftools//lib/elftools/constants.rb#264
ELFTools::Constants::EM::EM_MMIX = T.let(T.unsafe(nil), Integer)

# Matsushita MN10300
#
# source://elftools//lib/elftools/constants.rb#274
ELFTools::Constants::EM::EM_MN10200 = T.let(T.unsafe(nil), Integer)

# Renesas M32R
#
# source://elftools//lib/elftools/constants.rb#273
ELFTools::Constants::EM::EM_MN10300 = T.let(T.unsafe(nil), Integer)

# FTDI Chip FT32 high performance 32-bit RISC architecture
#
# source://elftools//lib/elftools/constants.rb#377
ELFTools::Constants::EM::EM_MOXIE = T.let(T.unsafe(nil), Integer)

# Fujitsu F2MC16
#
# source://elftools//lib/elftools/constants.rb#289
ELFTools::Constants::EM::EM_MSP430 = T.let(T.unsafe(nil), Integer)

# Siemens PCP
#
# source://elftools//lib/elftools/constants.rb#240
ELFTools::Constants::EM::EM_NCPU = T.let(T.unsafe(nil), Integer)

# Sony nCPU embedded RISC processor
#
# source://elftools//lib/elftools/constants.rb#241
ELFTools::Constants::EM::EM_NDR1 = T.let(T.unsafe(nil), Integer)

# STMicroelectronics STxP7x family
#
# source://elftools//lib/elftools/constants.rb#326
ELFTools::Constants::EM::EM_NDS32 = T.let(T.unsafe(nil), Integer)

# Imagination Technologies
#
# source://elftools//lib/elftools/constants.rb#385
ELFTools::Constants::EM::EM_NFP = T.let(T.unsafe(nil), Integer)

# none
#
# source://elftools//lib/elftools/constants.rb#197
ELFTools::Constants::EM::EM_NONE = T.let(T.unsafe(nil), Integer)

# Bluechip Systems CoolEngine
#
# source://elftools//lib/elftools/constants.rb#372
ELFTools::Constants::EM::EM_NORC = T.let(T.unsafe(nil), Integer)

# Thompson Multimedia General Purpose Processor
#
# source://elftools//lib/elftools/constants.rb#281
ELFTools::Constants::EM::EM_NS32K = T.let(T.unsafe(nil), Integer)

# Synopsys ARCompact V2
#
# source://elftools//lib/elftools/constants.rb#354
ELFTools::Constants::EM::EM_OPEN8 = T.let(T.unsafe(nil), Integer)

# picoJava
#
# source://elftools//lib/elftools/constants.rb#276
ELFTools::Constants::EM::EM_OPENRISC = T.let(T.unsafe(nil), Integer)

# MIPS R4000 big-endian
#
# source://elftools//lib/elftools/constants.rb#213
ELFTools::Constants::EM::EM_PARISC = T.let(T.unsafe(nil), Integer)

# Fujitsu Multimedia Accelerator
#
# source://elftools//lib/elftools/constants.rb#239
ELFTools::Constants::EM::EM_PCP = T.let(T.unsafe(nil), Integer)

# Sony DSP Processor
#
# source://elftools//lib/elftools/constants.rb#248
ELFTools::Constants::EM::EM_PDP10 = T.let(T.unsafe(nil), Integer)

# Digital Equipment Corp. PDP-10
#
# source://elftools//lib/elftools/constants.rb#249
ELFTools::Constants::EM::EM_PDP11 = T.let(T.unsafe(nil), Integer)

# AMD x86-64
#
# source://elftools//lib/elftools/constants.rb#247
ELFTools::Constants::EM::EM_PDSP = T.let(T.unsafe(nil), Integer)

# Matsushita MN10200
#
# source://elftools//lib/elftools/constants.rb#275
ELFTools::Constants::EM::EM_PJ = T.let(T.unsafe(nil), Integer)

# Intel 80960
#
# source://elftools//lib/elftools/constants.rb#217
ELFTools::Constants::EM::EM_PPC = T.let(T.unsafe(nil), Integer)

# PowerPC
#
# source://elftools//lib/elftools/constants.rb#218
ELFTools::Constants::EM::EM_PPC64 = T.let(T.unsafe(nil), Integer)

# Harvard's machine-independent format
#
# source://elftools//lib/elftools/constants.rb#266
ELFTools::Constants::EM::EM_PRISM = T.let(T.unsafe(nil), Integer)

# NXP Semiconductors TriMedia architecture family
#
# source://elftools//lib/elftools/constants.rb#323
ELFTools::Constants::EM::EM_QDSP6 = T.let(T.unsafe(nil), Integer)

# Cypress M8C microprocessor
#
# source://elftools//lib/elftools/constants.rb#321
ELFTools::Constants::EM::EM_R32C = T.let(T.unsafe(nil), Integer)

# TRW RH32
#
# source://elftools//lib/elftools/constants.rb#224
ELFTools::Constants::EM::EM_RCE = T.let(T.unsafe(nil), Integer)

# Fujitsu FR20
#
# source://elftools//lib/elftools/constants.rb#223
ELFTools::Constants::EM::EM_RH32 = T.let(T.unsafe(nil), Integer)

# Open8 8-bit RISC soft processor core
#
# source://elftools//lib/elftools/constants.rb#355
ELFTools::Constants::EM::EM_RL78 = T.let(T.unsafe(nil), Integer)

# Altium TSK3000 core
#
# source://elftools//lib/elftools/constants.rb#306
ELFTools::Constants::EM::EM_RS08 = T.let(T.unsafe(nil), Integer)

# Cray Inc. NV2 vector architecture
#
# source://elftools//lib/elftools/constants.rb#333
ELFTools::Constants::EM::EM_RX = T.let(T.unsafe(nil), Integer)

# IBM System/370
#
# source://elftools//lib/elftools/constants.rb#206
ELFTools::Constants::EM::EM_S370 = T.let(T.unsafe(nil), Integer)

# PowerPC64
#
# source://elftools//lib/elftools/constants.rb#219
ELFTools::Constants::EM::EM_S390 = T.let(T.unsafe(nil), Integer)

# This is the old interim value for S/390 architecture
#
# source://elftools//lib/elftools/constants.rb#407
ELFTools::Constants::EM::EM_S390_OLD = T.let(T.unsafe(nil), Integer)

# Cyan Technology eCOG2 microprocessor
#
# source://elftools//lib/elftools/constants.rb#309
ELFTools::Constants::EM::EM_SCORE7 = T.let(T.unsafe(nil), Integer)

# S1C33 Family of Seiko Epson processors
#
# source://elftools//lib/elftools/constants.rb#292
ELFTools::Constants::EM::EM_SEP = T.let(T.unsafe(nil), Integer)

# RISC processor for Lattice FPGA architecture
#
# source://elftools//lib/elftools/constants.rb#313
ELFTools::Constants::EM::EM_SE_C17 = T.let(T.unsafe(nil), Integer)

# ADI Blackfin Processor
#
# source://elftools//lib/elftools/constants.rb#291
ELFTools::Constants::EM::EM_SE_C33 = T.let(T.unsafe(nil), Integer)

# ARM 32 bit
#
# source://elftools//lib/elftools/constants.rb#226
ELFTools::Constants::EM::EM_SH = T.let(T.unsafe(nil), Integer)

# Freescale RS08 embedded processor
#
# source://elftools//lib/elftools/constants.rb#307
ELFTools::Constants::EM::EM_SHARC = T.let(T.unsafe(nil), Integer)

# Freescale Extended Time Processing Unit
#
# source://elftools//lib/elftools/constants.rb#339
ELFTools::Constants::EM::EM_SLE9X = T.let(T.unsafe(nil), Integer)

# Tenor Network TPC processor
#
# source://elftools//lib/elftools/constants.rb#283
ELFTools::Constants::EM::EM_SNP1K = T.let(T.unsafe(nil), Integer)

# SPARC
#
# source://elftools//lib/elftools/constants.rb#199
ELFTools::Constants::EM::EM_SPARC = T.let(T.unsafe(nil), Integer)

# Fujitsu VPP500 (also some older versions of PowerPC)
#
# source://elftools//lib/elftools/constants.rb#215
ELFTools::Constants::EM::EM_SPARC32PLUS = T.let(T.unsafe(nil), Integer)

# SuperH
#
# source://elftools//lib/elftools/constants.rb#227
ELFTools::Constants::EM::EM_SPARCV9 = T.let(T.unsafe(nil), Integer)

# IBM S/390
#
# source://elftools//lib/elftools/constants.rb#220
ELFTools::Constants::EM::EM_SPU = T.let(T.unsafe(nil), Integer)

# Toyota ME16 processor
#
# source://elftools//lib/elftools/constants.rb#244
ELFTools::Constants::EM::EM_ST100 = T.let(T.unsafe(nil), Integer)

# Silicon Graphics SVx
#
# source://elftools//lib/elftools/constants.rb#258
ELFTools::Constants::EM::EM_ST19 = T.let(T.unsafe(nil), Integer)

# Trebia SNP 1000 processor
#
# source://elftools//lib/elftools/constants.rb#284
ELFTools::Constants::EM::EM_ST200 = T.let(T.unsafe(nil), Integer)

# STMicroelectronics ST9+ 8/16 bit microcontroller
#
# source://elftools//lib/elftools/constants.rb#252
ELFTools::Constants::EM::EM_ST7 = T.let(T.unsafe(nil), Integer)

# Siemens FX66 microcontroller
#
# source://elftools//lib/elftools/constants.rb#251
ELFTools::Constants::EM::EM_ST9PLUS = T.let(T.unsafe(nil), Integer)

# Denso NDR1 microprocessor
#
# source://elftools//lib/elftools/constants.rb#242
ELFTools::Constants::EM::EM_STARCORE = T.let(T.unsafe(nil), Integer)

# Atmel Corporation 32-bit microprocessor family
#
# source://elftools//lib/elftools/constants.rb#344
ELFTools::Constants::EM::EM_STM8 = T.let(T.unsafe(nil), Integer)

# Intel 8051 and variants
#
# source://elftools//lib/elftools/constants.rb#325
ELFTools::Constants::EM::EM_STXP7X = T.let(T.unsafe(nil), Integer)

# Motorola MC68HC05 Microcontroller
#
# source://elftools//lib/elftools/constants.rb#257
ELFTools::Constants::EM::EM_SVX = T.let(T.unsafe(nil), Integer)

# LAPIS nX-U16/U8
#
# source://elftools//lib/elftools/constants.rb#396
ELFTools::Constants::EM::EM_TACHYUM = T.let(T.unsafe(nil), Integer)

# STMicroeletronics STM8 8-bit microcontroller
#
# source://elftools//lib/elftools/constants.rb#345
ELFTools::Constants::EM::EM_TILE64 = T.let(T.unsafe(nil), Integer)

# NVIDIA CUDA architecture
#
# source://elftools//lib/elftools/constants.rb#349
ELFTools::Constants::EM::EM_TILEGX = T.let(T.unsafe(nil), Integer)

# Tilera TILE64 multicore architecture family
#
# source://elftools//lib/elftools/constants.rb#346
ELFTools::Constants::EM::EM_TILEPRO = T.let(T.unsafe(nil), Integer)

# STMicroelectronics ST100 processor
#
# source://elftools//lib/elftools/constants.rb#245
ELFTools::Constants::EM::EM_TINYJ = T.let(T.unsafe(nil), Integer)

# The Texas Instruments TMS320C55x DSP family
#
# source://elftools//lib/elftools/constants.rb#317
ELFTools::Constants::EM::EM_TI_ARP32 = T.let(T.unsafe(nil), Integer)

# The Texas Instruments TMS320C6000 DSP family
#
# source://elftools//lib/elftools/constants.rb#315
ELFTools::Constants::EM::EM_TI_C2000 = T.let(T.unsafe(nil), Integer)

# The Texas Instruments TMS320C2000 DSP family
#
# source://elftools//lib/elftools/constants.rb#316
ELFTools::Constants::EM::EM_TI_C5500 = T.let(T.unsafe(nil), Integer)

# Seiko Epson C17 family
#
# source://elftools//lib/elftools/constants.rb#314
ELFTools::Constants::EM::EM_TI_C6000 = T.let(T.unsafe(nil), Integer)

# Texas Instruments Application Specific RISC Processor, 32bit fetch
#
# source://elftools//lib/elftools/constants.rb#318
ELFTools::Constants::EM::EM_TI_PRU = T.let(T.unsafe(nil), Integer)

# Alphamosaic VideoCore processor
#
# source://elftools//lib/elftools/constants.rb#280
ELFTools::Constants::EM::EM_TMM_GPP = T.let(T.unsafe(nil), Integer)

# National Semiconductor 32000 series
#
# source://elftools//lib/elftools/constants.rb#282
ELFTools::Constants::EM::EM_TPC = T.let(T.unsafe(nil), Integer)

# SPARC v9 64-bit
#
# source://elftools//lib/elftools/constants.rb#228
ELFTools::Constants::EM::EM_TRICORE = T.let(T.unsafe(nil), Integer)

# Renesas R32C series microprocessors
#
# source://elftools//lib/elftools/constants.rb#322
ELFTools::Constants::EM::EM_TRIMEDIA = T.let(T.unsafe(nil), Integer)

# Freescale Communication Engine RISC core
#
# source://elftools//lib/elftools/constants.rb#305
ELFTools::Constants::EM::EM_TSK3000 = T.let(T.unsafe(nil), Integer)

# ChipON KungFu32
#
# source://elftools//lib/elftools/constants.rb#395
ELFTools::Constants::EM::EM_U16_U8CORE = T.let(T.unsafe(nil), Integer)

# Arca RISC Microprocessor
#
# source://elftools//lib/elftools/constants.rb#294
ELFTools::Constants::EM::EM_UNICORE = T.let(T.unsafe(nil), Integer)

# Cell BE SPU
#
# source://elftools//lib/elftools/constants.rb#221
ELFTools::Constants::EM::EM_V800 = T.let(T.unsafe(nil), Integer)

# Mitsubishi D30V
#
# source://elftools//lib/elftools/constants.rb#271
ELFTools::Constants::EM::EM_V850 = T.let(T.unsafe(nil), Integer)

# STMicroelectronics ST19 8-bit cpu
#
# source://elftools//lib/elftools/constants.rb#259
ELFTools::Constants::EM::EM_VAX = T.let(T.unsafe(nil), Integer)

# Netronome Flow Processor (NFP)
#
# source://elftools//lib/elftools/constants.rb#386
ELFTools::Constants::EM::EM_VE = T.let(T.unsafe(nil), Integer)

# Tensilica Xtensa Architecture
#
# source://elftools//lib/elftools/constants.rb#279
ELFTools::Constants::EM::EM_VIDEOCORE = T.let(T.unsafe(nil), Integer)

# New Japan Radio (NJR) 24-bit DSP Processor
#
# source://elftools//lib/elftools/constants.rb#311
ELFTools::Constants::EM::EM_VIDEOCORE3 = T.let(T.unsafe(nil), Integer)

# Renesas RL78 family
#
# source://elftools//lib/elftools/constants.rb#356
ELFTools::Constants::EM::EM_VIDEOCORE5 = T.let(T.unsafe(nil), Integer)

# Zilog Z80
#
# source://elftools//lib/elftools/constants.rb#375
ELFTools::Constants::EM::EM_VISIUM = T.let(T.unsafe(nil), Integer)

# HPPA
#
# source://elftools//lib/elftools/constants.rb#214
ELFTools::Constants::EM::EM_VPP500 = T.let(T.unsafe(nil), Integer)

# Advanced Logic Corp. TinyJ embedded processor
#
# source://elftools//lib/elftools/constants.rb#246
ELFTools::Constants::EM::EM_X86_64 = T.let(T.unsafe(nil), Integer)

# Beyond BA2 CPU architecture
#
# source://elftools//lib/elftools/constants.rb#361
ELFTools::Constants::EM::EM_XCORE = T.let(T.unsafe(nil), Integer)

# National Semiconductor CRX
#
# source://elftools//lib/elftools/constants.rb#299
ELFTools::Constants::EM::EM_XGATE = T.let(T.unsafe(nil), Integer)

# Dallas Semiconductor MAXQ30 Core Micro-controllers
#
# source://elftools//lib/elftools/constants.rb#330
ELFTools::Constants::EM::EM_XIMO16 = T.let(T.unsafe(nil), Integer)

# ARC International ARCompact processor
#
# source://elftools//lib/elftools/constants.rb#278
ELFTools::Constants::EM::EM_XTENSA = T.let(T.unsafe(nil), Integer)

# CSR Kalimba architecture family
#
# source://elftools//lib/elftools/constants.rb#374
ELFTools::Constants::EM::EM_Z80 = T.let(T.unsafe(nil), Integer)

# Element 14 64-bit DSP processor
#
# source://elftools//lib/elftools/constants.rb#263
ELFTools::Constants::EM::EM_ZSP = T.let(T.unsafe(nil), Integer)

# This module defines ELF file types.
#
# source://elftools//lib/elftools/constants.rb#446
module ELFTools::Constants::ET
  class << self
    # Return the type name according to +e_type+ in ELF file header.
    #
    # @return [String] Type in string format.
    #
    # source://elftools//lib/elftools/constants.rb#454
    def mapping(type); end
  end
end

# core file
#
# source://elftools//lib/elftools/constants.rb#451
ELFTools::Constants::ET::ET_CORE = T.let(T.unsafe(nil), Integer)

# shared object
#
# source://elftools//lib/elftools/constants.rb#450
ELFTools::Constants::ET::ET_DYN = T.let(T.unsafe(nil), Integer)

# executable file
#
# source://elftools//lib/elftools/constants.rb#449
ELFTools::Constants::ET::ET_EXEC = T.let(T.unsafe(nil), Integer)

# no file type
#
# source://elftools//lib/elftools/constants.rb#447
ELFTools::Constants::ET::ET_NONE = T.let(T.unsafe(nil), Integer)

# relocatable file
#
# source://elftools//lib/elftools/constants.rb#448
ELFTools::Constants::ET::ET_REL = T.let(T.unsafe(nil), Integer)

# Program header permission flags, records bitwise OR value in +p_flags+.
#
# source://elftools//lib/elftools/constants.rb#468
module ELFTools::Constants::PF; end

# readable
#
# source://elftools//lib/elftools/constants.rb#471
ELFTools::Constants::PF::PF_R = T.let(T.unsafe(nil), Integer)

# writable
#
# source://elftools//lib/elftools/constants.rb#470
ELFTools::Constants::PF::PF_W = T.let(T.unsafe(nil), Integer)

# executable
#
# source://elftools//lib/elftools/constants.rb#469
ELFTools::Constants::PF::PF_X = T.let(T.unsafe(nil), Integer)

# Program header types, records in +p_type+.
#
# source://elftools//lib/elftools/constants.rb#476
module ELFTools::Constants::PT; end

# platform architecture compatibility information
#
# source://elftools//lib/elftools/constants.rb#509
ELFTools::Constants::PT::PT_AARCH64_ARCHEXT = T.let(T.unsafe(nil), Integer)

# exception unwind tables
#
# source://elftools//lib/elftools/constants.rb#510
ELFTools::Constants::PT::PT_AARCH64_UNWIND = T.let(T.unsafe(nil), Integer)

# platform architecture compatibility information
#
# source://elftools//lib/elftools/constants.rb#501
ELFTools::Constants::PT::PT_ARM_ARCHEXT = T.let(T.unsafe(nil), Integer)

# exception unwind tables
#
# source://elftools//lib/elftools/constants.rb#502
ELFTools::Constants::PT::PT_ARM_EXIDX = T.let(T.unsafe(nil), Integer)

# dynamic tags
#
# source://elftools//lib/elftools/constants.rb#479
ELFTools::Constants::PT::PT_DYNAMIC = T.let(T.unsafe(nil), Integer)

# for exception handler
#
# source://elftools//lib/elftools/constants.rb#487
ELFTools::Constants::PT::PT_GNU_EH_FRAME = T.let(T.unsafe(nil), Integer)

# Mbind segments (upper bound)
#
# source://elftools//lib/elftools/constants.rb#491
ELFTools::Constants::PT::PT_GNU_MBIND_HI = T.let(T.unsafe(nil), Integer)

# Mbind segments (lower bound)
#
# source://elftools//lib/elftools/constants.rb#492
ELFTools::Constants::PT::PT_GNU_MBIND_LO = T.let(T.unsafe(nil), Integer)

# GNU property
#
# source://elftools//lib/elftools/constants.rb#490
ELFTools::Constants::PT::PT_GNU_PROPERTY = T.let(T.unsafe(nil), Integer)

# read only after relocation
#
# source://elftools//lib/elftools/constants.rb#489
ELFTools::Constants::PT::PT_GNU_RELRO = T.let(T.unsafe(nil), Integer)

# permission of stack
#
# source://elftools//lib/elftools/constants.rb#488
ELFTools::Constants::PT::PT_GNU_STACK = T.let(T.unsafe(nil), Integer)

# OS-specific
#
# source://elftools//lib/elftools/constants.rb#496
ELFTools::Constants::PT::PT_HIOS = T.let(T.unsafe(nil), Integer)

# see {PT_LOPROC}
#
# source://elftools//lib/elftools/constants.rb#514
ELFTools::Constants::PT::PT_HIPROC = T.let(T.unsafe(nil), Integer)

# interpreter, same as .interp section
#
# source://elftools//lib/elftools/constants.rb#480
ELFTools::Constants::PT::PT_INTERP = T.let(T.unsafe(nil), Integer)

# segment to be load
#
# source://elftools//lib/elftools/constants.rb#478
ELFTools::Constants::PT::PT_LOAD = T.let(T.unsafe(nil), Integer)

# OS-specific
#
# source://elftools//lib/elftools/constants.rb#486
ELFTools::Constants::PT::PT_LOOS = T.let(T.unsafe(nil), Integer)

# Values between {PT_LOPROC} and {PT_HIPROC} are reserved for processor-specific semantics.
#
# source://elftools//lib/elftools/constants.rb#499
ELFTools::Constants::PT::PT_LOPROC = T.let(T.unsafe(nil), Integer)

# +.MIPS.abiflags+ section
#
# source://elftools//lib/elftools/constants.rb#507
ELFTools::Constants::PT::PT_MIPS_ABIFLAGS = T.let(T.unsafe(nil), Integer)

# +.MIPS.options+ section
#
# source://elftools//lib/elftools/constants.rb#506
ELFTools::Constants::PT::PT_MIPS_OPTIONS = T.let(T.unsafe(nil), Integer)

# register usage information
#
# source://elftools//lib/elftools/constants.rb#504
ELFTools::Constants::PT::PT_MIPS_REGINFO = T.let(T.unsafe(nil), Integer)

# runtime procedure table
#
# source://elftools//lib/elftools/constants.rb#505
ELFTools::Constants::PT::PT_MIPS_RTPROC = T.let(T.unsafe(nil), Integer)

# same as .note* section
#
# source://elftools//lib/elftools/constants.rb#481
ELFTools::Constants::PT::PT_NOTE = T.let(T.unsafe(nil), Integer)

# null segment
#
# source://elftools//lib/elftools/constants.rb#477
ELFTools::Constants::PT::PT_NULL = T.let(T.unsafe(nil), Integer)

# Section for boot arguments
#
# source://elftools//lib/elftools/constants.rb#495
ELFTools::Constants::PT::PT_OPENBSD_BOOTDATA = T.let(T.unsafe(nil), Integer)

# Fill with random data
#
# source://elftools//lib/elftools/constants.rb#493
ELFTools::Constants::PT::PT_OPENBSD_RANDOMIZE = T.let(T.unsafe(nil), Integer)

# Program does W^X violations
#
# source://elftools//lib/elftools/constants.rb#494
ELFTools::Constants::PT::PT_OPENBSD_WXNEEDED = T.let(T.unsafe(nil), Integer)

# where program header starts
#
# source://elftools//lib/elftools/constants.rb#483
ELFTools::Constants::PT::PT_PHDR = T.let(T.unsafe(nil), Integer)

# 4k page table size
#
# source://elftools//lib/elftools/constants.rb#512
ELFTools::Constants::PT::PT_S390_PGSTE = T.let(T.unsafe(nil), Integer)

# reserved
#
# source://elftools//lib/elftools/constants.rb#482
ELFTools::Constants::PT::PT_SHLIB = T.let(T.unsafe(nil), Integer)

# thread local storage segment
#
# source://elftools//lib/elftools/constants.rb#484
ELFTools::Constants::PT::PT_TLS = T.let(T.unsafe(nil), Integer)

# Section flag mask types, records in +sh_flag+.
#
# source://elftools//lib/elftools/constants.rb#548
module ELFTools::Constants::SHF; end

# Occupies memory during execution
#
# source://elftools//lib/elftools/constants.rb#550
ELFTools::Constants::SHF::SHF_ALLOC = T.let(T.unsafe(nil), Integer)

# Section with compressed data.
#
# source://elftools//lib/elftools/constants.rb#559
ELFTools::Constants::SHF::SHF_COMPRESSED = T.let(T.unsafe(nil), Integer)

# Section is excluded unless referenced or allocated (Solaris).
#
# source://elftools//lib/elftools/constants.rb#565
ELFTools::Constants::SHF::SHF_EXCLUDE = T.let(T.unsafe(nil), Integer)

# Executable
#
# source://elftools//lib/elftools/constants.rb#551
ELFTools::Constants::SHF::SHF_EXECINSTR = T.let(T.unsafe(nil), Integer)

# Mbind section
#
# source://elftools//lib/elftools/constants.rb#563
ELFTools::Constants::SHF::SHF_GNU_MBIND = T.let(T.unsafe(nil), Integer)

# Not to be GCed by linker.
#
# source://elftools//lib/elftools/constants.rb#562
ELFTools::Constants::SHF::SHF_GNU_RETAIN = T.let(T.unsafe(nil), Integer)

# Section is member of a group.
#
# source://elftools//lib/elftools/constants.rb#557
ELFTools::Constants::SHF::SHF_GROUP = T.let(T.unsafe(nil), Integer)

# `sh_info' contains SHT index
#
# source://elftools//lib/elftools/constants.rb#554
ELFTools::Constants::SHF::SHF_INFO_LINK = T.let(T.unsafe(nil), Integer)

# Preserve order after combining
#
# source://elftools//lib/elftools/constants.rb#555
ELFTools::Constants::SHF::SHF_LINK_ORDER = T.let(T.unsafe(nil), Integer)

# OS-specific.
#
# source://elftools//lib/elftools/constants.rb#560
ELFTools::Constants::SHF::SHF_MASKOS = T.let(T.unsafe(nil), Integer)

# Processor-specific
#
# source://elftools//lib/elftools/constants.rb#561
ELFTools::Constants::SHF::SHF_MASKPROC = T.let(T.unsafe(nil), Integer)

# Might be merged
#
# source://elftools//lib/elftools/constants.rb#552
ELFTools::Constants::SHF::SHF_MERGE = T.let(T.unsafe(nil), Integer)

# Special ordering requirement
#
# source://elftools//lib/elftools/constants.rb#564
ELFTools::Constants::SHF::SHF_ORDERED = T.let(T.unsafe(nil), Integer)

# Non-standard OS specific handling required
#
# source://elftools//lib/elftools/constants.rb#556
ELFTools::Constants::SHF::SHF_OS_NONCONFORMING = T.let(T.unsafe(nil), Integer)

# Contains nul-terminated strings
#
# source://elftools//lib/elftools/constants.rb#553
ELFTools::Constants::SHF::SHF_STRINGS = T.let(T.unsafe(nil), Integer)

# Section hold thread-local data.
#
# source://elftools//lib/elftools/constants.rb#558
ELFTools::Constants::SHF::SHF_TLS = T.let(T.unsafe(nil), Integer)

# Writable
#
# source://elftools//lib/elftools/constants.rb#549
ELFTools::Constants::SHF::SHF_WRITE = T.let(T.unsafe(nil), Integer)

# Special indices to section. These are used when there is no valid index to section header.
# The meaning of these values is left upto the embedding header.
#
# source://elftools//lib/elftools/constants.rb#520
module ELFTools::Constants::SHN; end

# specifies absolute values for the corresponding reference
#
# source://elftools//lib/elftools/constants.rb#540
ELFTools::Constants::SHN::SHN_ABS = T.let(T.unsafe(nil), Integer)

# symbols defined relative to this section are common symbols
#
# source://elftools//lib/elftools/constants.rb#541
ELFTools::Constants::SHN::SHN_COMMON = T.let(T.unsafe(nil), Integer)

# see {SHN_LOOS}
#
# source://elftools//lib/elftools/constants.rb#539
ELFTools::Constants::SHN::SHN_HIOS = T.let(T.unsafe(nil), Integer)

# see {SHN_LOPROC}
#
# source://elftools//lib/elftools/constants.rb#535
ELFTools::Constants::SHN::SHN_HIPROC = T.let(T.unsafe(nil), Integer)

# end of reserved indices
#
# source://elftools//lib/elftools/constants.rb#543
ELFTools::Constants::SHN::SHN_HIRESERVE = T.let(T.unsafe(nil), Integer)

# Values between {SHN_LOOS} and {SHN_HIOS} are reserved for operating system-specific semantics.
#
# source://elftools//lib/elftools/constants.rb#538
ELFTools::Constants::SHN::SHN_LOOS = T.let(T.unsafe(nil), Integer)

# Values between {SHN_LOPROC} and {SHN_HIPROC} are reserved for processor-specific semantics.
#
# source://elftools//lib/elftools/constants.rb#525
ELFTools::Constants::SHN::SHN_LOPROC = T.let(T.unsafe(nil), Integer)

# start of reserved indices
#
# source://elftools//lib/elftools/constants.rb#522
ELFTools::Constants::SHN::SHN_LORESERVE = T.let(T.unsafe(nil), Integer)

# defined and allocated common symbol
#
# source://elftools//lib/elftools/constants.rb#527
ELFTools::Constants::SHN::SHN_MIPS_ACOMMON = T.let(T.unsafe(nil), Integer)

# defined and allocated data symbol
#
# source://elftools//lib/elftools/constants.rb#529
ELFTools::Constants::SHN::SHN_MIPS_DATA = T.let(T.unsafe(nil), Integer)

# small common symbol
#
# source://elftools//lib/elftools/constants.rb#530
ELFTools::Constants::SHN::SHN_MIPS_SCOMMON = T.let(T.unsafe(nil), Integer)

# small undefined symbol
#
# source://elftools//lib/elftools/constants.rb#531
ELFTools::Constants::SHN::SHN_MIPS_SUNDEFINED = T.let(T.unsafe(nil), Integer)

# defined and allocated text symbol
#
# source://elftools//lib/elftools/constants.rb#528
ELFTools::Constants::SHN::SHN_MIPS_TEXT = T.let(T.unsafe(nil), Integer)

# undefined section
#
# source://elftools//lib/elftools/constants.rb#521
ELFTools::Constants::SHN::SHN_UNDEF = T.let(T.unsafe(nil), Integer)

# large common symbol
#
# source://elftools//lib/elftools/constants.rb#533
ELFTools::Constants::SHN::SHN_X86_64_LCOMMON = T.let(T.unsafe(nil), Integer)

# escape value indicating that the actual section header index is too large to fit
#
# source://elftools//lib/elftools/constants.rb#542
ELFTools::Constants::SHN::SHN_XINDEX = T.let(T.unsafe(nil), Integer)

# Section header types, records in +sh_type+.
#
# source://elftools//lib/elftools/constants.rb#570
module ELFTools::Constants::SHT; end

# source://elftools//lib/elftools/constants.rb#661
ELFTools::Constants::SHT::SHT_AARCH64_ATTRIBUTES = T.let(T.unsafe(nil), Integer)

# object file compatibility attributes
#
# source://elftools//lib/elftools/constants.rb#614
ELFTools::Constants::SHT::SHT_ARM_ATTRIBUTES = T.let(T.unsafe(nil), Integer)

# support for debugging overlaid programs
#
# source://elftools//lib/elftools/constants.rb#615
ELFTools::Constants::SHT::SHT_ARM_DEBUGOVERLAY = T.let(T.unsafe(nil), Integer)

# exception index table
#
# source://elftools//lib/elftools/constants.rb#612
ELFTools::Constants::SHT::SHT_ARM_EXIDX = T.let(T.unsafe(nil), Integer)

# support for debugging overlaid programs
#
# source://elftools//lib/elftools/constants.rb#616
ELFTools::Constants::SHT::SHT_ARM_OVERLAYSECTION = T.let(T.unsafe(nil), Integer)

# BPABI DLL dynamic linking pre-emption map
#
# source://elftools//lib/elftools/constants.rb#613
ELFTools::Constants::SHT::SHT_ARM_PREEMPTMAP = T.let(T.unsafe(nil), Integer)

# object file compatibility attributes
#
# source://elftools//lib/elftools/constants.rb#663
ELFTools::Constants::SHT::SHT_CSKY_ATTRIBUTES = T.let(T.unsafe(nil), Integer)

# information of dynamic linking
#
# source://elftools//lib/elftools/constants.rb#577
ELFTools::Constants::SHT::SHT_DYNAMIC = T.let(T.unsafe(nil), Integer)

# symbols for dynamic
#
# source://elftools//lib/elftools/constants.rb#582
ELFTools::Constants::SHT::SHT_DYNSYM = T.let(T.unsafe(nil), Integer)

# array of termination functions
#
# source://elftools//lib/elftools/constants.rb#584
ELFTools::Constants::SHT::SHT_FINI_ARRAY = T.let(T.unsafe(nil), Integer)

# object attributes
#
# source://elftools//lib/elftools/constants.rb#596
ELFTools::Constants::SHT::SHT_GNU_ATTRIBUTES = T.let(T.unsafe(nil), Integer)

# GNU style symbol hash table
#
# source://elftools//lib/elftools/constants.rb#597
ELFTools::Constants::SHT::SHT_GNU_HASH = T.let(T.unsafe(nil), Integer)

# incremental build data
#
# source://elftools//lib/elftools/constants.rb#595
ELFTools::Constants::SHT::SHT_GNU_INCREMENTAL_GOT_PLT = T.let(T.unsafe(nil), Integer)

# incremental build data
#
# source://elftools//lib/elftools/constants.rb#592
ELFTools::Constants::SHT::SHT_GNU_INCREMENTAL_INPUTS = T.let(T.unsafe(nil), Integer)

# incremental build data
#
# source://elftools//lib/elftools/constants.rb#594
ELFTools::Constants::SHT::SHT_GNU_INCREMENTAL_RELOCS = T.let(T.unsafe(nil), Integer)

# incremental build data
#
# source://elftools//lib/elftools/constants.rb#593
ELFTools::Constants::SHT::SHT_GNU_INCREMENTAL_SYMTAB = T.let(T.unsafe(nil), Integer)

# list of prelink dependencies
#
# source://elftools//lib/elftools/constants.rb#598
ELFTools::Constants::SHT::SHT_GNU_LIBLIST = T.let(T.unsafe(nil), Integer)

# versions defined by file
#
# source://elftools//lib/elftools/constants.rb#600
ELFTools::Constants::SHT::SHT_GNU_verdef = T.let(T.unsafe(nil), Integer)

# versions needed by file
#
# source://elftools//lib/elftools/constants.rb#602
ELFTools::Constants::SHT::SHT_GNU_verneed = T.let(T.unsafe(nil), Integer)

# symbol versions
#
# source://elftools//lib/elftools/constants.rb#604
ELFTools::Constants::SHT::SHT_GNU_versym = T.let(T.unsafe(nil), Integer)

# section group
#
# source://elftools//lib/elftools/constants.rb#586
ELFTools::Constants::SHT::SHT_GROUP = T.let(T.unsafe(nil), Integer)

# symbol hash table
#
# source://elftools//lib/elftools/constants.rb#576
ELFTools::Constants::SHT::SHT_HASH = T.let(T.unsafe(nil), Integer)

# see {SHT_LOOS}
#
# source://elftools//lib/elftools/constants.rb#605
ELFTools::Constants::SHT::SHT_HIOS = T.let(T.unsafe(nil), Integer)

# see {SHT_LOPROC}
#
# source://elftools//lib/elftools/constants.rb#667
ELFTools::Constants::SHT::SHT_HIPROC = T.let(T.unsafe(nil), Integer)

# see {SHT_LOUSER}
#
# source://elftools//lib/elftools/constants.rb#671
ELFTools::Constants::SHT::SHT_HIUSER = T.let(T.unsafe(nil), Integer)

# array of initialization functions
#
# source://elftools//lib/elftools/constants.rb#583
ELFTools::Constants::SHT::SHT_INIT_ARRAY = T.let(T.unsafe(nil), Integer)

# Values between {SHT_LOOS} and {SHT_HIOS} are reserved for operating system-specific semantics.
#
# source://elftools//lib/elftools/constants.rb#591
ELFTools::Constants::SHT::SHT_LOOS = T.let(T.unsafe(nil), Integer)

# Values between {SHT_LOPROC} and {SHT_HIPROC} are reserved for processor-specific semantics.
#
# source://elftools//lib/elftools/constants.rb#608
ELFTools::Constants::SHT::SHT_LOPROC = T.let(T.unsafe(nil), Integer)

# Values between {SHT_LOUSER} and {SHT_HIUSER} are reserved for application programs.
#
# source://elftools//lib/elftools/constants.rb#670
ELFTools::Constants::SHT::SHT_LOUSER = T.let(T.unsafe(nil), Integer)

# ABI related flags
#
# source://elftools//lib/elftools/constants.rb#658
ELFTools::Constants::SHT::SHT_MIPS_ABIFLAGS = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#639
ELFTools::Constants::SHT::SHT_MIPS_AUXSYM = T.let(T.unsafe(nil), Integer)

# list of symbols whose definitions conflict with shared objects
#
# source://elftools//lib/elftools/constants.rb#622
ELFTools::Constants::SHT::SHT_MIPS_CONFLICT = T.let(T.unsafe(nil), Integer)

# description of contents of another section
#
# source://elftools//lib/elftools/constants.rb#631
ELFTools::Constants::SHT::SHT_MIPS_CONTENT = T.let(T.unsafe(nil), Integer)

# register usage information
#
# source://elftools//lib/elftools/constants.rb#625
ELFTools::Constants::SHT::SHT_MIPS_DEBUG = T.let(T.unsafe(nil), Integer)

# delta C++ class table
#
# source://elftools//lib/elftools/constants.rb#646
ELFTools::Constants::SHT::SHT_MIPS_DELTACLASS = T.let(T.unsafe(nil), Integer)

# delta C++ declarations
#
# source://elftools//lib/elftools/constants.rb#648
ELFTools::Constants::SHT::SHT_MIPS_DELTADECL = T.let(T.unsafe(nil), Integer)

# delta C++ instance table
#
# source://elftools//lib/elftools/constants.rb#645
ELFTools::Constants::SHT::SHT_MIPS_DELTAINST = T.let(T.unsafe(nil), Integer)

# delta C++ symbol table
#
# source://elftools//lib/elftools/constants.rb#644
ELFTools::Constants::SHT::SHT_MIPS_DELTASYM = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#636
ELFTools::Constants::SHT::SHT_MIPS_DENSE = T.let(T.unsafe(nil), Integer)

# DWARF debugging section
#
# source://elftools//lib/elftools/constants.rb#647
ELFTools::Constants::SHT::SHT_MIPS_DWARF = T.let(T.unsafe(nil), Integer)

# C++ exception handling region info
#
# source://elftools//lib/elftools/constants.rb#656
ELFTools::Constants::SHT::SHT_MIPS_EH_REGION = T.let(T.unsafe(nil), Integer)

# events section
#
# source://elftools//lib/elftools/constants.rb#650
ELFTools::Constants::SHT::SHT_MIPS_EVENTS = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#635
ELFTools::Constants::SHT::SHT_MIPS_EXTSYM = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#634
ELFTools::Constants::SHT::SHT_MIPS_FDESC = T.let(T.unsafe(nil), Integer)

# global pointer table
#
# source://elftools//lib/elftools/constants.rb#623
ELFTools::Constants::SHT::SHT_MIPS_GPTAB = T.let(T.unsafe(nil), Integer)

# interface information
#
# source://elftools//lib/elftools/constants.rb#630
ELFTools::Constants::SHT::SHT_MIPS_IFACE = T.let(T.unsafe(nil), Integer)

# set of dynamic shared objects
#
# source://elftools//lib/elftools/constants.rb#620
ELFTools::Constants::SHT::SHT_MIPS_LIBLIST = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#642
ELFTools::Constants::SHT::SHT_MIPS_LINE = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#641
ELFTools::Constants::SHT::SHT_MIPS_LOCSTR = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#638
ELFTools::Constants::SHT::SHT_MIPS_LOCSYM = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#621
ELFTools::Constants::SHT::SHT_MIPS_MSYM = T.let(T.unsafe(nil), Integer)

# miscellaneous options
#
# source://elftools//lib/elftools/constants.rb#632
ELFTools::Constants::SHT::SHT_MIPS_OPTIONS = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#640
ELFTools::Constants::SHT::SHT_MIPS_OPTSYM = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#627
ELFTools::Constants::SHT::SHT_MIPS_PACKAGE = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#628
ELFTools::Constants::SHT::SHT_MIPS_PACKSYM = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#637
ELFTools::Constants::SHT::SHT_MIPS_PDESC = T.let(T.unsafe(nil), Integer)

# runtime procedure descriptor table exception information
#
# source://elftools//lib/elftools/constants.rb#657
ELFTools::Constants::SHT::SHT_MIPS_PDR_EXCEPTION = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#652
ELFTools::Constants::SHT::SHT_MIPS_PIXIE = T.let(T.unsafe(nil), Integer)

# section contains register usage information
#
# source://elftools//lib/elftools/constants.rb#626
ELFTools::Constants::SHT::SHT_MIPS_REGINFO = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#629
ELFTools::Constants::SHT::SHT_MIPS_RELD = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#643
ELFTools::Constants::SHT::SHT_MIPS_RFDESC = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#633
ELFTools::Constants::SHT::SHT_MIPS_SHDR = T.let(T.unsafe(nil), Integer)

# list of libraries the binary depends on
#
# source://elftools//lib/elftools/constants.rb#649
ELFTools::Constants::SHT::SHT_MIPS_SYMBOL_LIB = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#651
ELFTools::Constants::SHT::SHT_MIPS_TRANSLATE = T.let(T.unsafe(nil), Integer)

# microcode information
#
# source://elftools//lib/elftools/constants.rb#624
ELFTools::Constants::SHT::SHT_MIPS_UCODE = T.let(T.unsafe(nil), Integer)

# intermediate code
#
# source://elftools//lib/elftools/constants.rb#655
ELFTools::Constants::SHT::SHT_MIPS_WHIRL = T.let(T.unsafe(nil), Integer)

# GNU style symbol hash table with xlat
#
# source://elftools//lib/elftools/constants.rb#659
ELFTools::Constants::SHT::SHT_MIPS_XHASH = T.let(T.unsafe(nil), Integer)

# address translation table
#
# source://elftools//lib/elftools/constants.rb#653
ELFTools::Constants::SHT::SHT_MIPS_XLATE = T.let(T.unsafe(nil), Integer)

# SGI internal address translation table
#
# source://elftools//lib/elftools/constants.rb#654
ELFTools::Constants::SHT::SHT_MIPS_XLATE_DEBUG = T.let(T.unsafe(nil), Integer)

# section occupies no space
#
# source://elftools//lib/elftools/constants.rb#579
ELFTools::Constants::SHT::SHT_NOBITS = T.let(T.unsafe(nil), Integer)

# section for notes
#
# source://elftools//lib/elftools/constants.rb#578
ELFTools::Constants::SHT::SHT_NOTE = T.let(T.unsafe(nil), Integer)

# null section
#
# source://elftools//lib/elftools/constants.rb#571
ELFTools::Constants::SHT::SHT_NULL = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#665
ELFTools::Constants::SHT::SHT_ORDERED = T.let(T.unsafe(nil), Integer)

# array of functions that are invoked before all other initialization functions
#
# source://elftools//lib/elftools/constants.rb#585
ELFTools::Constants::SHT::SHT_PREINIT_ARRAY = T.let(T.unsafe(nil), Integer)

# information defined by program itself
#
# source://elftools//lib/elftools/constants.rb#572
ELFTools::Constants::SHT::SHT_PROGBITS = T.let(T.unsafe(nil), Integer)

# relocation
#
# source://elftools//lib/elftools/constants.rb#580
ELFTools::Constants::SHT::SHT_REL = T.let(T.unsafe(nil), Integer)

# relocation with addends
#
# source://elftools//lib/elftools/constants.rb#575
ELFTools::Constants::SHT::SHT_RELA = T.let(T.unsafe(nil), Integer)

# RELR relative relocations
#
# source://elftools//lib/elftools/constants.rb#588
ELFTools::Constants::SHT::SHT_RELR = T.let(T.unsafe(nil), Integer)

# reserved
#
# source://elftools//lib/elftools/constants.rb#581
ELFTools::Constants::SHT::SHT_SHLIB = T.let(T.unsafe(nil), Integer)

# source://elftools//lib/elftools/constants.rb#610
ELFTools::Constants::SHT::SHT_SPARC_GOTDATA = T.let(T.unsafe(nil), Integer)

# string table section
#
# source://elftools//lib/elftools/constants.rb#574
ELFTools::Constants::SHT::SHT_STRTAB = T.let(T.unsafe(nil), Integer)

# versions defined by file
#
# source://elftools//lib/elftools/constants.rb#599
ELFTools::Constants::SHT::SHT_SUNW_verdef = T.let(T.unsafe(nil), Integer)

# versions needed by file
#
# source://elftools//lib/elftools/constants.rb#601
ELFTools::Constants::SHT::SHT_SUNW_verneed = T.let(T.unsafe(nil), Integer)

# symbol versions
#
# source://elftools//lib/elftools/constants.rb#603
ELFTools::Constants::SHT::SHT_SUNW_versym = T.let(T.unsafe(nil), Integer)

# symbol table section
#
# source://elftools//lib/elftools/constants.rb#573
ELFTools::Constants::SHT::SHT_SYMTAB = T.let(T.unsafe(nil), Integer)

# indices for SHN_XINDEX entries
#
# source://elftools//lib/elftools/constants.rb#587
ELFTools::Constants::SHT::SHT_SYMTAB_SHNDX = T.let(T.unsafe(nil), Integer)

# x86_64 unwind information
#
# source://elftools//lib/elftools/constants.rb#618
ELFTools::Constants::SHT::SHT_X86_64_UNWIND = T.let(T.unsafe(nil), Integer)

# Symbol binding from Sym st_info field.
#
# source://elftools//lib/elftools/constants.rb#676
module ELFTools::Constants::STB; end

# Global symbol
#
# source://elftools//lib/elftools/constants.rb#678
ELFTools::Constants::STB::STB_GLOBAL = T.let(T.unsafe(nil), Integer)

# Unique symbol.
#
# source://elftools//lib/elftools/constants.rb#682
ELFTools::Constants::STB::STB_GNU_UNIQUE = T.let(T.unsafe(nil), Integer)

# End of OS-specific
#
# source://elftools//lib/elftools/constants.rb#683
ELFTools::Constants::STB::STB_HIOS = T.let(T.unsafe(nil), Integer)

# End of processor-specific
#
# source://elftools//lib/elftools/constants.rb#685
ELFTools::Constants::STB::STB_HIPROC = T.let(T.unsafe(nil), Integer)

# Local symbol
#
# source://elftools//lib/elftools/constants.rb#677
ELFTools::Constants::STB::STB_LOCAL = T.let(T.unsafe(nil), Integer)

# Start of OS-specific
#
# source://elftools//lib/elftools/constants.rb#681
ELFTools::Constants::STB::STB_LOOS = T.let(T.unsafe(nil), Integer)

# Start of processor-specific
#
# source://elftools//lib/elftools/constants.rb#684
ELFTools::Constants::STB::STB_LOPROC = T.let(T.unsafe(nil), Integer)

# Number of defined types.
#
# source://elftools//lib/elftools/constants.rb#680
ELFTools::Constants::STB::STB_NUM = T.let(T.unsafe(nil), Integer)

# Weak symbol
#
# source://elftools//lib/elftools/constants.rb#679
ELFTools::Constants::STB::STB_WEAK = T.let(T.unsafe(nil), Integer)

# Symbol types from Sym st_info field.
#
# source://elftools//lib/elftools/constants.rb#690
module ELFTools::Constants::STT; end

# ARM: a THUMB label.
#
# source://elftools//lib/elftools/constants.rb#718
ELFTools::Constants::STT::STT_ARM_16BIT = T.let(T.unsafe(nil), Integer)

# ARM: a THUMB function. This is not defined in ARM ELF Specification but
# used by the GNU tool-chain.
#
# source://elftools//lib/elftools/constants.rb#717
ELFTools::Constants::STT::STT_ARM_TFUNC = T.let(T.unsafe(nil), Integer)

# Symbol is a common data object
#
# source://elftools//lib/elftools/constants.rb#696
ELFTools::Constants::STT::STT_COMMON = T.let(T.unsafe(nil), Integer)

# Symbol's name is file name
#
# source://elftools//lib/elftools/constants.rb#695
ELFTools::Constants::STT::STT_FILE = T.let(T.unsafe(nil), Integer)

# Symbol is a code object
#
# source://elftools//lib/elftools/constants.rb#693
ELFTools::Constants::STT::STT_FUNC = T.let(T.unsafe(nil), Integer)

# GNU extension: symbol value points to a function which is called
# at runtime to determine the final value of the symbol.
#
# source://elftools//lib/elftools/constants.rb#704
ELFTools::Constants::STT::STT_GNU_IFUNC = T.let(T.unsafe(nil), Integer)

# End of OS-specific
#
# source://elftools//lib/elftools/constants.rb#707
ELFTools::Constants::STT::STT_HIOS = T.let(T.unsafe(nil), Integer)

# End of processor-specific
#
# source://elftools//lib/elftools/constants.rb#709
ELFTools::Constants::STT::STT_HIPROC = T.let(T.unsafe(nil), Integer)

# Start of OS-specific
#
# source://elftools//lib/elftools/constants.rb#706
ELFTools::Constants::STT::STT_LOOS = T.let(T.unsafe(nil), Integer)

# Start of processor-specific
#
# source://elftools//lib/elftools/constants.rb#708
ELFTools::Constants::STT::STT_LOPROC = T.let(T.unsafe(nil), Integer)

# Symbol type is unspecified
#
# source://elftools//lib/elftools/constants.rb#691
ELFTools::Constants::STT::STT_NOTYPE = T.let(T.unsafe(nil), Integer)

# Deprecated.
#
# source://elftools//lib/elftools/constants.rb#698
ELFTools::Constants::STT::STT_NUM = T.let(T.unsafe(nil), Integer)

# Symbol is a data object
#
# source://elftools//lib/elftools/constants.rb#692
ELFTools::Constants::STT::STT_OBJECT = T.let(T.unsafe(nil), Integer)

# Complex relocation expression
#
# source://elftools//lib/elftools/constants.rb#699
ELFTools::Constants::STT::STT_RELC = T.let(T.unsafe(nil), Integer)

# Symbol associated with a section
#
# source://elftools//lib/elftools/constants.rb#694
ELFTools::Constants::STT::STT_SECTION = T.let(T.unsafe(nil), Integer)

# The section type that must be used for register symbols on
# Sparc. These symbols initialize a global register.
#
# source://elftools//lib/elftools/constants.rb#713
ELFTools::Constants::STT::STT_SPARC_REGISTER = T.let(T.unsafe(nil), Integer)

# Signed Complex relocation expression
#
# source://elftools//lib/elftools/constants.rb#700
ELFTools::Constants::STT::STT_SRELC = T.let(T.unsafe(nil), Integer)

# Symbol is thread-local data object
#
# source://elftools//lib/elftools/constants.rb#697
ELFTools::Constants::STT::STT_TLS = T.let(T.unsafe(nil), Integer)

# Define common methods for dynamic sections and dynamic segments.
#
# @note This module can only be included by {ELFTools::Sections::DynamicSection}
#   and {ELFTools::Segments::DynamicSegment} because methods here assume some
#   attributes exist.
#
# source://elftools//lib/elftools/dynamic.rb#10
module ELFTools::Dynamic
  # Iterate all tags.
  #
  # @note This method assume the following methods already exist:
  #   header
  #   tag_start
  # @return [Enumerator<ELFTools::Dynamic::Tag>, Array<ELFTools::Dynamic::Tag>] If block is not given, an enumerator will be returned.
  #   Otherwise, return array of tags.
  # @yieldparam tag [ELFTools::Dynamic::Tag]
  #
  # source://elftools//lib/elftools/dynamic.rb#21
  def each_tags(&block); end

  # Get the +n+-th tag.
  #
  # Tags are lazy loaded.
  #
  # @note This method assume the following methods already exist:
  #   header
  #   tag_start
  # @note We cannot do bound checking of +n+ here since the only way to get size
  #   of tags is calling +tags.size+.
  # @param n [Integer] The index.
  # @return [ELFTools::Dynamic::Tag] The desired tag.
  #
  # source://elftools//lib/elftools/dynamic.rb#93
  def tag_at(n); end

  # Get a tag of specific type.
  #
  # @example
  #   dynamic = elf.segment_by_type(:dynamic)
  #   # type as integer
  #   dynamic.tag_by_type(0) # the null tag
  #   #=>  #<ELFTools::Dynamic::Tag:0x0055b5a5ecad28 @header={:d_tag=>0, :d_val=>0}>
  #   dynamic.tag_by_type(ELFTools::Constants::DT_NULL)
  #   #=>  #<ELFTools::Dynamic::Tag:0x0055b5a5ecad28 @header={:d_tag=>0, :d_val=>0}>
  #
  #   # symbol
  #   dynamic.tag_by_type(:null)
  #   #=>  #<ELFTools::Dynamic::Tag:0x0055b5a5ecad28 @header={:d_tag=>0, :d_val=>0}>
  #   dynamic.tag_by_type(:pltgot)
  #   #=> #<ELFTools::Dynamic::Tag:0x0055d3d2d91b28 @header={:d_tag=>3, :d_val=>6295552}>
  #
  #   # string
  #   dynamic.tag_by_type('null')
  #   #=>  #<ELFTools::Dynamic::Tag:0x0055b5a5ecad28 @header={:d_tag=>0, :d_val=>0}>
  #   dynamic.tag_by_type('DT_PLTGOT')
  #   #=> #<ELFTools::Dynamic::Tag:0x0055d3d2d91b28 @header={:d_tag=>3, :d_val=>6295552}>
  # @param type [Integer, Symbol, String] Constant value, symbol, or string of type
  #   is acceptable. See examples for more information.
  # @return [ELFTools::Dynamic::Tag] The desired tag.
  #
  # source://elftools//lib/elftools/dynamic.rb#64
  def tag_by_type(type); end

  # Use {#tags} to get all tags.
  #
  # @return [Array<ELFTools::Dynamic::Tag>] Array of tags.
  #
  # source://elftools//lib/elftools/dynamic.rb#36
  def tags; end

  # Get tags of specific type.
  #
  # @param type [Integer, Symbol, String] Constant value, symbol, or string of type
  #   is acceptable. See examples for more information.
  # @return [Array<ELFTools::Dynamic::Tag>] The desired tags.
  # @see #tag_by_type
  #
  # source://elftools//lib/elftools/dynamic.rb#76
  def tags_by_type(type); end

  private

  # source://elftools//lib/elftools/dynamic.rb#108
  def endian; end

  # Get the DT_STRTAB's +d_val+ offset related to file.
  #
  # source://elftools//lib/elftools/dynamic.rb#113
  def str_offset; end
end

# A tag class.
#
# source://elftools//lib/elftools/dynamic.rb#119
class ELFTools::Dynamic::Tag
  # Instantiate a {ELFTools::Dynamic::Tag} object.
  #
  # @param header [ELF_Dyn] The dynamic tag header.
  # @param stream [#pos=, #read] Streaming object.
  # @param str_offset [Method] Call this method to get the string offset related
  #   to file.
  # @return [Tag] a new instance of Tag
  #
  # source://elftools//lib/elftools/dynamic.rb#129
  def initialize(header, stream, str_offset); end

  # @return [ELFTools::Structs::ELF_Dyn] The dynamic tag header.
  #
  # source://elftools//lib/elftools/dynamic.rb#120
  def header; end

  # Return the name of this tag.
  #
  # Only tags with name would return a name.
  # Others would return +nil+.
  #
  # @return [String, nil] The name.
  #
  # source://elftools//lib/elftools/dynamic.rb#171
  def name; end

  # Is this tag has a name?
  #
  # The criteria here is if this tag's type is in {TYPE_WITH_NAME}.
  #
  # @return [Boolean] Is this tag has a name.
  #
  # source://elftools//lib/elftools/dynamic.rb#162
  def name?; end

  # @return [#pos=, #read] Streaming object.
  #
  # source://elftools//lib/elftools/dynamic.rb#121
  def stream; end

  # Return the content of this tag records.
  #
  # For normal tags, this method just return
  # +header.d_val+. For tags with +header.d_val+
  # in meaning of string offset (e.g. DT_NEEDED), this method would
  # return the string it specified.
  # Tags with type in {TYPE_WITH_NAME} are those tags with name.
  #
  # @example
  #   dynamic = elf.segment_by_type(:dynamic)
  #   dynamic.tag_by_type(:init).value
  #   #=> 4195600 # 0x400510
  #   dynamic.tag_by_type(:needed).value
  #   #=> 'libc.so.6'
  # @return [Integer, String] The content this tag records.
  #
  # source://elftools//lib/elftools/dynamic.rb#154
  def value; end
end

# Some dynamic have name.
#
# source://elftools//lib/elftools/dynamic.rb#136
ELFTools::Dynamic::Tag::TYPE_WITH_NAME = T.let(T.unsafe(nil), Array)

# Raised on invalid ELF class (EI_CLASS).
#
# source://elftools//lib/elftools/exceptions.rb#11
class ELFTools::ELFClassError < ::ELFTools::ELFError; end

# Raised on invalid ELF data encoding (EI_DATA).
#
# source://elftools//lib/elftools/exceptions.rb#14
class ELFTools::ELFDataError < ::ELFTools::ELFError; end

# Being raised when parsing error.
#
# source://elftools//lib/elftools/exceptions.rb#5
class ELFTools::ELFError < ::StandardError; end

# The main class for using elftools.
#
# source://elftools//lib/elftools/elf_file.rb#12
class ELFTools::ELFFile
  # Instantiate an {ELFFile} object.
  #
  # @example
  #   ELFFile.new(File.open('/bin/cat'))
  #   #=> #<ELFTools::ELFFile:0x00564b106c32a0 @elf_class=64, @endian=:little, @stream=#<File:/bin/cat>>
  # @param stream [#pos=, #read] The +File+ object to be fetch information from.
  # @return [ELFFile] a new instance of ELFFile
  #
  # source://elftools//lib/elftools/elf_file.rb#24
  def initialize(stream); end

  # Return the BuildID of ELF.
  #
  # @example
  #   elf.build_id
  #   #=> '73ab62cb7bc9959ce053c2b711322158708cdc07'
  # @return [String, nil] BuildID in hex form will be returned.
  #   +nil+ is returned if the .note.gnu.build-id section
  #   is not found.
  #
  # source://elftools//lib/elftools/elf_file.rb#52
  def build_id; end

  # Iterate all sections.
  #
  # All sections are lazy loading, the section
  # only be created whenever accessing it.
  # This method is useful for {#section_by_name}
  # since not all sections need to be created.
  #
  # @return [Enumerator<ELFTools::Sections::Section>, Array<ELFTools::Sections::Section>] As +Array#each+, if block is not given, a enumerator will be returned,
  #   otherwise, the whole sections will be returned.
  # @yieldparam section [ELFTools::Sections::Section] A section.
  # @yieldreturn [void]
  #
  # source://elftools//lib/elftools/elf_file.rb#122
  def each_sections(&block); end

  # Iterate all segments.
  #
  # All segments are lazy loading, the segment
  # only be created whenever accessing it.
  # This method is useful for {#segment_by_type}
  # since not all segments need to be created.
  #
  # @return [Array<ELFTools::Segments::Segment>] Whole segments will be returned.
  # @yieldparam segment [ELFTools::Segments::Segment] A segment.
  # @yieldreturn [void]
  #
  # source://elftools//lib/elftools/elf_file.rb#195
  def each_segments(&block); end

  # @return [Integer] 32 or 64.
  #
  # source://elftools//lib/elftools/elf_file.rb#14
  def elf_class; end

  # Return the ELF type according to +e_type+.
  #
  # @example
  #   ELFFile.new(File.open('spec/files/libc.so.6')).elf_type
  #   #=> 'DYN'
  #   ELFFile.new(File.open('spec/files/amd64.elf')).elf_type
  #   #=> 'EXEC'
  # @return [String] Type in string format.
  #
  # source://elftools//lib/elftools/elf_file.rb#82
  def elf_type; end

  # @return [Symbol] +:little+ or +:big+.
  #
  # source://elftools//lib/elftools/elf_file.rb#15
  def endian; end

  # Return the file header.
  #
  # Lazy loading.
  #
  # @return [ELFTools::Structs::ELF_Ehdr] The header.
  #
  # source://elftools//lib/elftools/elf_file.rb#35
  def header; end

  # Get machine architecture.
  #
  # Mappings of architecture can be found
  # in {ELFTools::Constants::EM.mapping}.
  #
  # @example
  #   elf.machine
  #   #=> 'Advanced Micro Devices X86-64'
  # @return [String] Name of architecture.
  #
  # source://elftools//lib/elftools/elf_file.rb#71
  def machine; end

  # Number of sections in this file.
  #
  # @example
  #   elf.num_sections
  #   #=> 29
  # @return [Integer] The desired number.
  #
  # source://elftools//lib/elftools/elf_file.rb#93
  def num_sections; end

  # Number of segments in this file.
  #
  # @return [Integer] The desited number.
  #
  # source://elftools//lib/elftools/elf_file.rb#181
  def num_segments; end

  # Get the offset related to file, given virtual memory address.
  #
  # This method should work no matter ELF is a PIE or not.
  # This method refers from (actually equals to) binutils/readelf.c#offset_from_vma.
  #
  # @example
  #   elf = ELFTools::ELFFile.new(File.open('/bin/cat'))
  #   elf.offset_from_vma(0x401337)
  #   #=> 4919 # 0x1337
  # @param vma [Integer] The virtual address to be queried.
  # @return [Integer] Related file offset.
  #
  # source://elftools//lib/elftools/elf_file.rb#293
  def offset_from_vma(vma, size = T.unsafe(nil)); end

  # The patch status.
  #
  # @return [Hash{Integer => String}]
  #
  # source://elftools//lib/elftools/elf_file.rb#301
  def patches; end

  # Apply patches and save as +filename+.
  #
  # @param filename [String]
  # @return [void]
  #
  # source://elftools//lib/elftools/elf_file.rb#315
  def save(filename); end

  # Acquire the +n+-th section, 0-based.
  #
  # Sections are lazy loaded.
  #
  # @param n [Integer] The index.
  # @return [ELFTools::Sections::Section, nil] The target section.
  #   If +n+ is out of bound, +nil+ is returned.
  #
  # source://elftools//lib/elftools/elf_file.rb#144
  def section_at(n); end

  # Acquire the section named as +name+.
  #
  # @example
  #   elf.section_by_name('.note.gnu.build-id')
  #   #=> #<ELFTools::Sections::Section:0x005647b1282428>
  #   elf.section_by_name('')
  #   #=> #<ELFTools::Sections::NullSection:0x005647b11da110>
  #   elf.section_by_name('no such section')
  #   #=> nil
  # @param name [String] The desired section name.
  # @return [ELFTools::Sections::Section, nil] The target section.
  #
  # source://elftools//lib/elftools/elf_file.rb#107
  def section_by_name(name); end

  # Simply use {#sections} to get all sections.
  #
  # @return [Array<ELFTools::Sections::Section>] Whole sections.
  #
  # source://elftools//lib/elftools/elf_file.rb#133
  def sections; end

  # Fetch all sections with specific type.
  #
  # The available types are listed in {ELFTools::Constants::PT}.
  # This method accept giving block.
  #
  # @example
  #   elf = ELFTools::ELFFile.new(File.open('spec/files/amd64.elf'))
  #   elf.sections_by_type(:rela)
  #   #=> [#<ELFTools::Sections::RelocationSection:0x00563cd3219970>,
  #   #    #<ELFTools::Sections::RelocationSection:0x00563cd3b89d70>]
  # @param type [Integer, Symbol, String] The type needed, similar format as {#segment_by_type}.
  # @return [Array<ELFTools::Sections::section>] The target sections.
  # @yieldparam section [ELFTools::Sections::Section] A section in specific type.
  # @yieldreturn [void]
  #
  # source://elftools//lib/elftools/elf_file.rb#163
  def sections_by_type(type, &block); end

  # Acquire the +n+-th segment, 0-based.
  #
  # Segments are lazy loaded.
  #
  # @param n [Integer] The index.
  # @return [ELFTools::Segments::Segment, nil] The target segment.
  #   If +n+ is out of bound, +nil+ is returned.
  #
  # source://elftools//lib/elftools/elf_file.rb#278
  def segment_at(n); end

  # Get the first segment with +p_type=type+.
  # The available types are listed in {ELFTools::Constants::PT}.
  #
  # @example
  #   # type as an integer
  #   elf.segment_by_type(ELFTools::Constants::PT_NOTE)
  #   #=>  #<ELFTools::Segments::NoteSegment:0x005629dda1e4f8>
  #
  #   elf.segment_by_type(4) # PT_NOTE
  #   #=>  #<ELFTools::Segments::NoteSegment:0x005629dda1e4f8>
  #
  #   # type as a symbol
  #   elf.segment_by_type(:PT_NOTE)
  #   #=>  #<ELFTools::Segments::NoteSegment:0x005629dda1e4f8>
  #
  #   # you can do this
  #   elf.segment_by_type(:note) # will be transformed into `PT_NOTE`
  #   #=>  #<ELFTools::Segments::NoteSegment:0x005629dda1e4f8>
  #
  #   # type as a string
  #   elf.segment_by_type('PT_NOTE')
  #   #=>  #<ELFTools::Segments::NoteSegment:0x005629dda1e4f8>
  #
  #   # this is ok
  #   elf.segment_by_type('note') # will be tranformed into `PT_NOTE`
  #   #=>  #<ELFTools::Segments::NoteSegment:0x005629dda1e4f8>
  # @example
  #   elf.segment_by_type(1337)
  #   # ArgumentError: No constants in Constants::PT is 1337
  #
  #   elf.segment_by_type('oao')
  #   # ArgumentError: No constants in Constants::PT named "PT_OAO"
  # @example
  #   elf.segment_by_type(0)
  #   #=> nil # no such segment exists
  # @note This method will return the first segment found,
  #   to found all segments with specific type you can use {#segments_by_type}.
  # @param type [Integer, Symbol, String] See examples for clear usage.
  # @return [ELFTools::Segments::Segment] The target segment.
  #
  # source://elftools//lib/elftools/elf_file.rb#251
  def segment_by_type(type); end

  # Simply use {#segments} to get all segments.
  #
  # @return [Array<ELFTools::Segments::Segment>] Whole segments.
  #
  # source://elftools//lib/elftools/elf_file.rb#206
  def segments; end

  # Fetch all segments with specific type.
  #
  # If you want to find only one segment,
  # use {#segment_by_type} instead.
  # This method accept giving block.
  #
  # @param type [Integer, Symbol, String] The type needed, same format as {#segment_by_type}.
  # @return [Array<ELFTools::Segments::Segment>] The target segments.
  # @yieldparam segment [ELFTools::Segments::Segment] A segment in specific type.
  # @yieldreturn [void]
  #
  # source://elftools//lib/elftools/elf_file.rb#266
  def segments_by_type(type, &block); end

  # @return [#pos=, #read] The +File+ object.
  #
  # source://elftools//lib/elftools/elf_file.rb#13
  def stream; end

  # Get the string table section.
  #
  # This section is acquired by using the +e_shstrndx+
  # in ELF header.
  #
  # @return [ELFTools::Sections::StrTabSection] The desired section.
  #
  # source://elftools//lib/elftools/elf_file.rb#173
  def strtab_section; end

  private

  # source://elftools//lib/elftools/elf_file.rb#359
  def create_section(n); end

  # source://elftools//lib/elftools/elf_file.rb#370
  def create_segment(n); end

  # @raise [ELFMagicError]
  #
  # source://elftools//lib/elftools/elf_file.rb#339
  def identify; end

  # bad idea..
  #
  # source://elftools//lib/elftools/elf_file.rb#327
  def loaded_headers; end
end

# Raised on invalid ELF magic.
#
# source://elftools//lib/elftools/exceptions.rb#8
class ELFTools::ELFMagicError < ::ELFTools::ELFError; end

# A helper class for {ELFTools} easy to implement
# 'lazy loading' objects.
# Mainly used when loading sections, segments, and
# symbols.
#
# source://elftools//lib/elftools/lazy_array.rb#29
class ELFTools::LazyArray < ::SimpleDelegator
  # Instantiate a {LazyArray} object.
  #
  # @example
  #   arr = LazyArray.new(10) { |i| p "calc #{i}"; i * i }
  #   p arr[2]
  #   # "calc 2"
  #   # 4
  #
  #   p arr[3]
  #   # "calc 3"
  #   # 9
  #
  #   p arr[3]
  #   # 9
  # @param size [Integer] The size of array.
  # @return [LazyArray] a new instance of LazyArray
  # @yieldparam i [Integer] Needs the +i+-th element.
  # @yieldreturn [Object] Value of the +i+-th element.
  #
  # source://elftools//lib/elftools/lazy_array.rb#30
  def initialize(size, &block); end

  # To access elements like a normal array.
  #
  # Elements are lazy loaded at the first time
  # access it.
  #
  # @return [Object] The element, returned type is the
  #   return type of block given in {#initialize}.
  #
  # source://elftools//lib/elftools/lazy_array.rb#42
  def [](i); end
end

# Since both note sections and note segments refer to notes, this module
# defines common methods for {ELFTools::Sections::NoteSection} and
# {ELFTools::Segments::NoteSegment}.
#
# @note This module can only be included in {ELFTools::Sections::NoteSection} and
#   {ELFTools::Segments::NoteSegment} since some methods here assume some
#   attributes already exist.
#
# source://elftools//lib/elftools/note.rb#15
module ELFTools::Note
  # Iterate all notes in a note section or segment.
  #
  # Structure of notes are:
  #   +---------------+
  #   | Note 1 header |
  #   +---------------+
  #   |  Note 1 name  |
  #   +---------------+
  #   |  Note 1 desc  |
  #   +---------------+
  #   | Note 2 header |
  #   +---------------+
  #   |      ...      |
  #   +---------------+
  #
  # @note This method assume following methods exist:
  #   stream
  #   note_start
  #   note_total_size
  # @return [Enumerator<ELFTools::Note::Note>, Array<ELFTools::Note::Note>] If block is not given, an enumerator will be returned.
  #   Otherwise, return the array of notes.
  #
  # source://elftools//lib/elftools/note.rb#44
  def each_notes; end

  # Simply +#notes+ to get all notes.
  #
  # @return [Array<ELFTools::Note::Note>] Whole notes.
  #
  # source://elftools//lib/elftools/note.rb#67
  def notes; end

  private

  # source://elftools//lib/elftools/note.rb#81
  def create_note(cur); end

  # Get the endian.
  #
  # @note This method assume method +header+ exists.
  # @return [Symbol] +:little+ or +:big+.
  #
  # source://elftools//lib/elftools/note.rb#77
  def endian; end
end

# Class of a note.
#
# source://elftools//lib/elftools/note.rb#87
class ELFTools::Note::Note
  # Instantiate a {ELFTools::Note::Note} object.
  #
  # @param header [ELF_Nhdr] The note header.
  # @param stream [#pos=, #read] Streaming object.
  # @param offset [Integer] Start address of this note, includes the header.
  # @return [Note] a new instance of Note
  #
  # source://elftools//lib/elftools/note.rb#97
  def initialize(header, stream, offset); end

  # Description of this note.
  #
  # @return [String] The description.
  #
  # source://elftools//lib/elftools/note.rb#114
  def desc; end

  # Description of this note.
  # If someone likes to use full name.
  #
  # @return [String] The description.
  #
  # source://elftools//lib/elftools/note.rb#114
  def description; end

  # @return [ELFTools::Structs::ELF_Nhdr] Note header.
  #
  # source://elftools//lib/elftools/note.rb#88
  def header; end

  # Name of this note.
  #
  # @return [String] The name.
  #
  # source://elftools//lib/elftools/note.rb#105
  def name; end

  # @return [Integer] Address of this note start, includes note header.
  #
  # source://elftools//lib/elftools/note.rb#90
  def offset; end

  # @return [#pos=, #read] Streaming object.
  #
  # source://elftools//lib/elftools/note.rb#89
  def stream; end
end

# Since size of {ELFTools::Structs::ELF_Nhdr} will not change no matter in
# what endian and what arch, we can do this here. This value should equal
# to 12.
#
# source://elftools//lib/elftools/note.rb#19
ELFTools::Note::SIZE_OF_NHDR = T.let(T.unsafe(nil), Integer)

# A relocation entry.
#
# Can be either a REL or RELA relocation.
# XXX: move this to an independent file?
#
# source://elftools//lib/elftools/sections/relocation_section.rb#77
class ELFTools::Relocation
  # Instantiate a {Relocation} object.
  #
  # @return [Relocation] a new instance of Relocation
  #
  # source://elftools//lib/elftools/sections/relocation_section.rb#82
  def initialize(header, stream); end

  # @return [ELFTools::Structs::ELF_Rel, ELFTools::Structs::ELF_Rela] Rel(a) header.
  #
  # source://elftools//lib/elftools/sections/relocation_section.rb#78
  def header; end

  # +r_info+ contains sym and type, use two methods
  # to access them easier.
  #
  # @return [Integer] sym infor.
  #
  # source://elftools//lib/elftools/sections/relocation_section.rb#90
  def r_info_sym; end

  # +r_info+ contains sym and type, use two methods
  # to access them easier.
  #
  # @return [Integer] type infor.
  #
  # source://elftools//lib/elftools/sections/relocation_section.rb#98
  def r_info_type; end

  # @return [#pos=, #read] Streaming object.
  #
  # source://elftools//lib/elftools/sections/relocation_section.rb#79
  def stream; end

  # +r_info+ contains sym and type, use two methods
  # to access them easier.
  #
  # @return [Integer] sym infor.
  #
  # source://elftools//lib/elftools/sections/relocation_section.rb#90
  def symbol_index; end

  # +r_info+ contains sym and type, use two methods
  # to access them easier.
  #
  # @return [Integer] type infor.
  #
  # source://elftools//lib/elftools/sections/relocation_section.rb#98
  def type; end

  private

  # source://elftools//lib/elftools/sections/relocation_section.rb#105
  def mask_bit; end
end

# Defines different types of sections in this module.
#
# source://elftools//lib/elftools/sections/section.rb#5
module ELFTools::Sections; end

# Class for dynamic table section.
#
# This section should always be named .dynamic.
# This class knows how to get the list of dynamic tags.
#
# source://elftools//lib/elftools/sections/dynamic_section.rb#12
class ELFTools::Sections::DynamicSection < ::ELFTools::Sections::Section
  include ::ELFTools::Dynamic

  # Get the start address of tags.
  #
  # @return [Integer] Start address of tags.
  #
  # source://elftools//lib/elftools/sections/dynamic_section.rb#17
  def tag_start; end
end

# Class of note section.
# Note section records notes
#
# source://elftools//lib/elftools/sections/note_section.rb#11
class ELFTools::Sections::NoteSection < ::ELFTools::Sections::Section
  include ::ELFTools::Note

  # Address offset of notes start.
  #
  # @return [Integer] The offset.
  #
  # source://elftools//lib/elftools/sections/note_section.rb#16
  def note_start; end

  # The total size of notes in this section.
  #
  # @return [Integer] The size.
  #
  # source://elftools//lib/elftools/sections/note_section.rb#22
  def note_total_size; end
end

# Class of null section.
# Null section is for specific the end
# of linked list (+sh_link+) between sections.
#
# source://elftools//lib/elftools/sections/null_section.rb#12
class ELFTools::Sections::NullSection < ::ELFTools::Sections::Section
  # Is this a null section?
  #
  # @return [Boolean] Yes it is.
  #
  # source://elftools//lib/elftools/sections/null_section.rb#13
  def null?; end
end

# Class of note section.
# Note section records notes
#
# source://elftools//lib/elftools/sections/relocation_section.rb#13
class ELFTools::Sections::RelocationSection < ::ELFTools::Sections::Section
  # Iterate all relocations.
  #
  # All relocations are lazy loading, the relocation
  # only be created whenever accessing it.
  #
  # @return [Enumerator<ELFTools::Relocation>, Array<ELFTools::Relocation>] If block is not given, an enumerator will be returned.
  #   Otherwise, the whole relocations will be returned.
  # @yieldparam rel [ELFTools::Relocation] A relocation object.
  # @yieldreturn [void]
  #
  # source://elftools//lib/elftools/sections/relocation_section.rb#45
  def each_relocations(&block); end

  # Number of relocations in this section.
  #
  # @return [Integer] The number.
  #
  # source://elftools//lib/elftools/sections/relocation_section.rb#20
  def num_relocations; end

  # Is this relocation a RELA or REL type.
  #
  # @return [Boolean] If is RELA.
  #
  # source://elftools//lib/elftools/sections/relocation_section.rb#14
  def rela?; end

  # Acquire the +n+-th relocation, 0-based.
  #
  # relocations are lazy loaded.
  #
  # @param n [Integer] The index.
  # @return [ELFTools::Relocation, nil] The target relocation.
  #   If +n+ is out of bound, +nil+ is returned.
  #
  # source://elftools//lib/elftools/sections/relocation_section.rb#31
  def relocation_at(n); end

  # Simply use {#relocations} to get all relocations.
  #
  # @return [Array<ELFTools::Relocation>] Whole relocations.
  #
  # source://elftools//lib/elftools/sections/relocation_section.rb#56
  def relocations; end

  private

  # source://elftools//lib/elftools/sections/relocation_section.rb#62
  def create_relocation(n); end
end

# Base class of sections.
#
# source://elftools//lib/elftools/sections/section.rb#7
class ELFTools::Sections::Section
  # Instantiate a {Section} object.
  #
  # @param header [ELFTools::Structs::ELF_Shdr] The section header object.
  # @param stream [#pos=, #read] The streaming object for further dump.
  # @param strtab [ELFTools::Sections::StrTabSection, Proc] The string table object. For fetching section names.
  #   If +Proc+ if given, it will call at the first
  #   time access +#name+.
  # @param offset_from_vma [Method] The method to get offset of file, given virtual memory address.
  # @return [Section] a new instance of Section
  #
  # source://elftools//lib/elftools/sections/section.rb#22
  def initialize(header, stream, offset_from_vma: T.unsafe(nil), strtab: T.unsafe(nil), **_kwargs); end

  # Fetch data of this section.
  #
  # @return [String] Data.
  #
  # source://elftools//lib/elftools/sections/section.rb#44
  def data; end

  # @return [ELFTools::Structs::ELF_Shdr] Section header.
  #
  # source://elftools//lib/elftools/sections/section.rb#8
  def header; end

  # Get name of this section.
  #
  # @return [String] The name.
  #
  # source://elftools//lib/elftools/sections/section.rb#38
  def name; end

  # Is this a null section?
  #
  # @return [Boolean] No it's not.
  #
  # source://elftools//lib/elftools/sections/section.rb#51
  def null?; end

  # @return [#pos=, #read] Streaming object.
  #
  # source://elftools//lib/elftools/sections/section.rb#9
  def stream; end

  # Return +header.sh_type+ in a simplier way.
  #
  # @return [Integer] The type, meaning of types are defined in {Constants::SHT}.
  #
  # source://elftools//lib/elftools/sections/section.rb#32
  def type; end

  class << self
    # Use different class according to +header.sh_type+.
    #
    # @param header [ELFTools::Structs::ELF_Shdr] Section header.
    # @param stream [#pos=, #read] Streaming object.
    # @return [ELFTools::Sections::Section] Return object dependes on +header.sh_type+.
    #
    # source://elftools//lib/elftools/sections/sections.rb#24
    def create(header, stream, *args, **kwargs); end
  end
end

# Class of string table section.
# Usually for section .strtab and .dynstr,
# which record names.
#
# source://elftools//lib/elftools/sections/str_tab_section.rb#15
class ELFTools::Sections::StrTabSection < ::ELFTools::Sections::Section
  # Return the section or symbol name.
  #
  # @param offset [Integer] Usually from +shdr.sh_name+ or +sym.st_name+.
  # @return [String] The name without null bytes.
  #
  # source://elftools//lib/elftools/sections/str_tab_section.rb#16
  def name_at(offset); end
end

# Class of symbol table section.
# Usually for section .symtab and .dynsym,
# which will refer to symbols in ELF file.
#
# source://elftools//lib/elftools/sections/sym_tab_section.rb#20
class ELFTools::Sections::SymTabSection < ::ELFTools::Sections::Section
  # Instantiate a {SymTabSection} object.
  # There's a +section_at+ lambda for {SymTabSection}
  # to easily fetch other sections.
  #
  # @param header [ELFTools::Structs::ELF_Shdr] See {Section#initialize} for more information.
  # @param stream [#pos=, #read] See {Section#initialize} for more information.
  # @param section_at [Proc] The method for fetching other sections by index.
  #   This lambda should be {ELFTools::ELFFile#section_at}.
  # @return [SymTabSection] a new instance of SymTabSection
  #
  # source://elftools//lib/elftools/sections/sym_tab_section.rb#21
  def initialize(header, stream, section_at: T.unsafe(nil), **_kwargs); end

  # Iterate all symbols.
  #
  # All symbols are lazy loading, the symbol
  # only be created whenever accessing it.
  # This method is useful for {#symbol_by_name}
  # since not all symbols need to be created.
  #
  # @return [Enumerator<ELFTools::Sections::Symbol>, Array<ELFTools::Sections::Symbol>] If block is not given, an enumerator will be returned.
  #   Otherwise return array of symbols.
  # @yieldparam sym [ELFTools::Sections::Symbol] A symbol object.
  # @yieldreturn [void]
  #
  # source://elftools//lib/elftools/sections/sym_tab_section.rb#59
  def each_symbols(&block); end

  # Number of symbols.
  #
  # @example
  #   symtab.num_symbols
  #   #=> 75
  # @return [Integer] The number.
  #
  # source://elftools//lib/elftools/sections/sym_tab_section.rb#32
  def num_symbols; end

  # Acquire the +n+-th symbol, 0-based.
  #
  # Symbols are lazy loaded.
  #
  # @param n [Integer] The index.
  # @return [ELFTools::Sections::Symbol, nil] The target symbol.
  #   If +n+ is out of bound, +nil+ is returned.
  #
  # source://elftools//lib/elftools/sections/sym_tab_section.rb#43
  def symbol_at(n); end

  # Get symbol by its name.
  #
  # @param name [String] The name of symbol.
  # @return [ELFTools::Sections::Symbol] Desired symbol.
  #
  # source://elftools//lib/elftools/sections/sym_tab_section.rb#78
  def symbol_by_name(name); end

  # Simply use {#symbols} to get all symbols.
  #
  # @return [Array<ELFTools::Sections::Symbol>] The whole symbols.
  #
  # source://elftools//lib/elftools/sections/sym_tab_section.rb#70
  def symbols; end

  # Return the symbol string section.
  # Lazy loaded.
  #
  # @return [ELFTools::Sections::StrTabSection] The string table section.
  #
  # source://elftools//lib/elftools/sections/sym_tab_section.rb#85
  def symstr; end

  private

  # source://elftools//lib/elftools/sections/sym_tab_section.rb#91
  def create_symbol(n); end
end

# Class of symbol.
#
# XXX: Should this class be defined in an independent file?
#
# source://elftools//lib/elftools/sections/sym_tab_section.rb#102
class ELFTools::Sections::Symbol
  # Instantiate a {ELFTools::Sections::Symbol} object.
  #
  # @param header [ELFTools::Structs::ELF32_sym, ELFTools::Structs::ELF64_sym] The symbol header.
  # @param stream [#pos=, #read] The streaming object.
  # @param symstr [ELFTools::Sections::StrTabSection, Proc] The symbol string section.
  #   If +Proc+ is given, it will be called at the first time
  #   access {Symbol#name}.
  # @return [Symbol] a new instance of Symbol
  #
  # source://elftools//lib/elftools/sections/sym_tab_section.rb#114
  def initialize(header, stream, symstr: T.unsafe(nil)); end

  # @return [ELFTools::Structs::ELF32_sym, ELFTools::Structs::ELF64_sym] Section header.
  #
  # source://elftools//lib/elftools/sections/sym_tab_section.rb#103
  def header; end

  # Return the symbol name.
  #
  # @return [String] The name.
  #
  # source://elftools//lib/elftools/sections/sym_tab_section.rb#122
  def name; end

  # @return [#pos=, #read] Streaming object.
  #
  # source://elftools//lib/elftools/sections/sym_tab_section.rb#104
  def stream; end
end

# Module for defining different types of segments.
#
# source://elftools//lib/elftools/segments/segment.rb#4
module ELFTools::Segments; end

# Class for dynamic table segment.
#
# This class knows how to get the list of dynamic tags.
#
# source://elftools//lib/elftools/segments/dynamic_segment.rb#11
class ELFTools::Segments::DynamicSegment < ::ELFTools::Segments::Segment
  include ::ELFTools::Dynamic

  # Get the start address of tags.
  #
  # @return [Integer] Start address of tags.
  #
  # source://elftools//lib/elftools/segments/dynamic_segment.rb#15
  def tag_start; end
end

# For DT_INTERP segment, knows how to get path of
# ELF interpreter.
#
# source://elftools//lib/elftools/segments/interp_segment.rb#14
class ELFTools::Segments::InterpSegment < ::ELFTools::Segments::Segment
  # Get the path of interpreter.
  #
  # @example
  #   interp_segment.interp_name
  #   #=> '/lib64/ld-linux-x86-64.so.2'
  # @return [String] Path to the interpreter.
  #
  # source://elftools//lib/elftools/segments/interp_segment.rb#15
  def interp_name; end
end

# For DT_LOAD segment.
# Able to query between file offset and virtual memory address.
#
# source://elftools//lib/elftools/segments/load_segment.rb#12
class ELFTools::Segments::LoadSegment < ::ELFTools::Segments::Segment
  # Returns the start of this segment.
  #
  # @return [Integer] The file offset.
  #
  # source://elftools//lib/elftools/segments/load_segment.rb#13
  def file_head; end

  # Returns the end of this segment.
  #
  # @return [Integer] The file offset.
  #
  # source://elftools//lib/elftools/segments/load_segment.rb#27
  def file_tail; end

  # Returns the start virtual address of this segment.
  #
  # @return [Integer] The vma.
  #
  # source://elftools//lib/elftools/segments/load_segment.rb#34
  def mem_head; end

  # Returns size in memory.
  #
  # @return [Integer] The size.
  #
  # source://elftools//lib/elftools/segments/load_segment.rb#41
  def mem_size; end

  # Returns the end virtual address of this segment.
  #
  # @return [Integer] The vma.
  #
  # source://elftools//lib/elftools/segments/load_segment.rb#48
  def mem_tail; end

  # Query if the given file offset located in this segment.
  #
  # @param offset [Integer] File offset.
  # @param size [Integer] Size.
  # @return [Boolean]
  #
  # source://elftools//lib/elftools/segments/load_segment.rb#58
  def offset_in?(offset, size = T.unsafe(nil)); end

  # Convert file offset into virtual memory address.
  #
  # @param offset [Integer] File offset.
  # @return [Integer]
  #
  # source://elftools//lib/elftools/segments/load_segment.rb#66
  def offset_to_vma(offset); end

  # Returns size in file.
  #
  # @return [Integer] The size.
  #
  # source://elftools//lib/elftools/segments/load_segment.rb#20
  def size; end

  # Query if the given virtual memory address located in this segment.
  #
  # @param vma [Integer] Virtual memory address.
  # @param size [Integer] Size.
  # @return [Boolean]
  #
  # source://elftools//lib/elftools/segments/load_segment.rb#77
  def vma_in?(vma, size = T.unsafe(nil)); end

  # Convert virtual memory address into file offset.
  #
  # @param vma [Integer] Virtual memory address.
  # @return [Integer]
  #
  # source://elftools//lib/elftools/segments/load_segment.rb#86
  def vma_to_offset(vma); end
end

# Class of note segment.
#
# source://elftools//lib/elftools/segments/note_segment.rb#10
class ELFTools::Segments::NoteSegment < ::ELFTools::Segments::Segment
  include ::ELFTools::Note

  # Address offset of notes start.
  #
  # @return [Integer] The offset.
  #
  # source://elftools//lib/elftools/segments/note_segment.rb#15
  def note_start; end

  # The total size of notes in this segment.
  #
  # @return [Integer] The size.
  #
  # source://elftools//lib/elftools/segments/note_segment.rb#21
  def note_total_size; end
end

# Base class of segments.
#
# source://elftools//lib/elftools/segments/segment.rb#6
class ELFTools::Segments::Segment
  # Instantiate a {Segment} object.
  #
  # @param header [ELFTools::Structs::ELF32_Phdr, ELFTools::Structs::ELF64_Phdr] Program header.
  # @param stream [#pos=, #read] Streaming object.
  # @param offset_from_vma [Method] The method to get offset of file, given virtual memory address.
  # @return [Segment] a new instance of Segment
  #
  # source://elftools//lib/elftools/segments/segment.rb#17
  def initialize(header, stream, offset_from_vma: T.unsafe(nil)); end

  # The content in this segment.
  #
  # @return [String] The content.
  #
  # source://elftools//lib/elftools/segments/segment.rb#32
  def data; end

  # Is this segment executable?
  #
  # @return [Boolean] Ture or false.
  #
  # source://elftools//lib/elftools/segments/segment.rb#51
  def executable?; end

  # @return [ELFTools::Structs::ELF32_Phdr, ELFTools::Structs::ELF64_Phdr] Program header.
  #
  # source://elftools//lib/elftools/segments/segment.rb#7
  def header; end

  # Is this segment readable?
  #
  # @return [Boolean] Ture or false.
  #
  # source://elftools//lib/elftools/segments/segment.rb#39
  def readable?; end

  # @return [#pos=, #read] Streaming object.
  #
  # source://elftools//lib/elftools/segments/segment.rb#8
  def stream; end

  # Return +header.p_type+ in a simplier way.
  #
  # @return [Integer] The type, meaning of types are defined in {Constants::PT}.
  #
  # source://elftools//lib/elftools/segments/segment.rb#26
  def type; end

  # Is this segment writable?
  #
  # @return [Boolean] Ture or false.
  #
  # source://elftools//lib/elftools/segments/segment.rb#45
  def writable?; end

  class << self
    # Use different class according to +header.p_type+.
    #
    # @param header [ELFTools::Structs::ELF32_Phdr, ELFTools::Structs::ELF64_Phdr] Program header of a segment.
    # @param stream [#pos=, #read] Streaming object.
    # @return [ELFTools::Segments::Segment] Return object dependes on +header.p_type+.
    #
    # source://elftools//lib/elftools/segments/segments.rb#22
    def create(header, stream, *args, **kwargs); end
  end
end

# Define ELF related structures in this module.
#
# Structures are fetched from https://github.com/torvalds/linux/blob/master/include/uapi/linux/elf.h.
# Use gem +bindata+ to have these structures support 32/64 bits and little/big endian simultaneously.
#
# source://elftools//lib/elftools/structs.rb#10
module ELFTools::Structs; end

# Program header structure for 32-bit.
#
# source://elftools//lib/elftools/structs.rb#123
class ELFTools::Structs::ELF32_Phdr < ::ELFTools::Structs::ELFStruct
  class << self
    # source://bindata/2.4.15/lib/bindata/base.rb#53
    def inherited(subclass); end

    # source://bindata/2.4.15/lib/bindata/dsl.rb#279
    def new(*args); end
  end
end

# Symbol structure for 32-bit.
#
# source://elftools//lib/elftools/structs.rb#155
class ELFTools::Structs::ELF32_sym < ::ELFTools::Structs::ELFStruct
  class << self
    # source://bindata/2.4.15/lib/bindata/base.rb#53
    def inherited(subclass); end

    # source://bindata/2.4.15/lib/bindata/dsl.rb#279
    def new(*args); end
  end
end

# Program header structure for 64-bit.
#
# source://elftools//lib/elftools/structs.rb#136
class ELFTools::Structs::ELF64_Phdr < ::ELFTools::Structs::ELFStruct
  class << self
    # source://bindata/2.4.15/lib/bindata/base.rb#53
    def inherited(subclass); end

    # source://bindata/2.4.15/lib/bindata/dsl.rb#279
    def new(*args); end
  end
end

# Symbol structure for 64-bit.
#
# source://elftools//lib/elftools/structs.rb#166
class ELFTools::Structs::ELF64_sym < ::ELFTools::Structs::ELFStruct
  class << self
    # source://bindata/2.4.15/lib/bindata/base.rb#53
    def inherited(subclass); end

    # source://bindata/2.4.15/lib/bindata/dsl.rb#279
    def new(*args); end
  end
end

# The base structure to define common methods.
#
# source://elftools//lib/elftools/structs.rb#13
class ELFTools::Structs::ELFStruct < ::BinData::Record
  # @return [Integer] 32 or 64.
  #
  # source://elftools//lib/elftools/structs.rb#18
  def elf_class; end

  # @return [Integer] 32 or 64.
  #
  # source://elftools//lib/elftools/structs.rb#18
  def elf_class=(_arg0); end

  # @return [Integer] The file offset of this header.
  #
  # source://elftools//lib/elftools/structs.rb#19
  def offset; end

  # @return [Integer] The file offset of this header.
  #
  # source://elftools//lib/elftools/structs.rb#19
  def offset=(_arg0); end

  # Records which fields have been patched.
  #
  # @return [Hash{Integer => Integer}] Patches.
  #
  # source://elftools//lib/elftools/structs.rb#23
  def patches; end

  # BinData hash(Snapshot) that behaves like HashWithIndifferentAccess
  #
  # source://bindata/2.4.15/lib/bindata/struct.rb#106
  def to_h; end

  class << self
    # source://bindata/2.4.15/lib/bindata/base.rb#53
    def inherited(subclass); end

    # Hooks the constructor.
    #
    # +BinData::Record+ doesn't allow us to override +#initialize+, so we hack +new+ here.
    #
    # source://elftools//lib/elftools/structs.rb#34
    def new(*args); end

    # Packs an integer to string.
    #
    # @param val [Integer]
    # @param bytes [Integer]
    # @raise [ArgumentError]
    # @return [String]
    #
    # source://elftools//lib/elftools/structs.rb#64
    def pack(val, bytes); end

    # Gets the endianness of current class.
    #
    # @return [:little, :big] The endianness.
    #
    # source://elftools//lib/elftools/structs.rb#56
    def self_endian; end
  end
end

# DRY. Many fields have different type in different arch.
#
# source://elftools//lib/elftools/structs.rb#14
ELFTools::Structs::ELFStruct::CHOICE_SIZE_T = T.let(T.unsafe(nil), Proc)

# Dynamic tag header.
#
# source://elftools//lib/elftools/structs.rb#191
class ELFTools::Structs::ELF_Dyn < ::ELFTools::Structs::ELFStruct
  class << self
    # source://bindata/2.4.15/lib/bindata/base.rb#53
    def inherited(subclass); end

    # source://bindata/2.4.15/lib/bindata/dsl.rb#279
    def new(*args); end
  end
end

# ELF header structure.
#
# source://elftools//lib/elftools/structs.rb#80
class ELFTools::Structs::ELF_Ehdr < ::ELFTools::Structs::ELFStruct
  class << self
    # source://bindata/2.4.15/lib/bindata/base.rb#53
    def inherited(subclass); end

    # source://bindata/2.4.15/lib/bindata/dsl.rb#279
    def new(*args); end
  end
end

# Note header.
#
# source://elftools//lib/elftools/structs.rb#183
class ELFTools::Structs::ELF_Nhdr < ::ELFTools::Structs::ELFStruct
  class << self
    # source://bindata/2.4.15/lib/bindata/base.rb#53
    def inherited(subclass); end

    # source://bindata/2.4.15/lib/bindata/dsl.rb#279
    def new(*args); end
  end
end

# Gets the class of program header according to bits.
#
# source://elftools//lib/elftools/structs.rb#149
ELFTools::Structs::ELF_Phdr = T.let(T.unsafe(nil), Hash)

# Rel header in .rel section.
#
# source://elftools//lib/elftools/structs.rb#200
class ELFTools::Structs::ELF_Rel < ::ELFTools::Structs::ELFStruct
  # Compatibility with ELF_Rela, both can be used interchangeably
  #
  # source://elftools//lib/elftools/structs.rb#206
  def r_addend; end

  class << self
    # source://bindata/2.4.15/lib/bindata/base.rb#53
    def inherited(subclass); end

    # source://bindata/2.4.15/lib/bindata/dsl.rb#279
    def new(*args); end
  end
end

# Rela header in .rela section.
#
# source://elftools//lib/elftools/structs.rb#212
class ELFTools::Structs::ELF_Rela < ::ELFTools::Structs::ELFStruct
  class << self
    # source://bindata/2.4.15/lib/bindata/base.rb#53
    def inherited(subclass); end

    # source://bindata/2.4.15/lib/bindata/dsl.rb#279
    def new(*args); end
  end
end

# Section header structure.
#
# source://elftools//lib/elftools/structs.rb#108
class ELFTools::Structs::ELF_Shdr < ::ELFTools::Structs::ELFStruct
  class << self
    # source://bindata/2.4.15/lib/bindata/base.rb#53
    def inherited(subclass); end

    # source://bindata/2.4.15/lib/bindata/dsl.rb#279
    def new(*args); end
  end
end

# Get symbol header class according to bits.
#
# source://elftools//lib/elftools/structs.rb#177
ELFTools::Structs::ELF_sym = T.let(T.unsafe(nil), Hash)

# Define some util methods.
#
# source://elftools//lib/elftools/util.rb#5
module ELFTools::Util
  extend ::ELFTools::Util::ClassMethods
end

# Class methods.
#
# source://elftools//lib/elftools/util.rb#7
module ELFTools::Util::ClassMethods
  # Round up the number to be mulitple of
  # +2**bit+.
  #
  # @example
  #   align(10, 1) #=> 10
  #   align(10, 2) #=> 12
  #   align(10, 3) #=> 16
  #   align(10, 4) #=> 16
  #   align(10, 5) #=> 32
  # @param num [Integer] Number to be rounded-up.
  # @param bit [Integer] How many bit to be aligned.
  # @return [Integer] See examples.
  #
  # source://elftools//lib/elftools/util.rb#19
  def align(num, bit); end

  # Read from stream until reach a null-byte.
  #
  # @example
  #   Util.cstring(File.open('/bin/cat'), 0)
  #   #=> "\x7FELF\x02\x01\x01"
  # @param stream [#pos=, #read] Streaming object
  # @param offset [Integer] Start from here.
  # @return [String] Result string will never contain null byte.
  #
  # source://elftools//lib/elftools/util.rb#61
  def cstring(stream, offset); end

  # Select objects from enumerator with +.type+ property
  # equals to +type+.
  #
  # Different from naive +Array#select+ is this method
  # will yield block whenever find a desired object.
  #
  # This method is used to simplify the same logic in methods
  # {ELFFile#sections_by_type}, {ELFFile#segments_by_type}, etc.
  #
  # @param enum [Enumerator] An enumerator for further select.
  # @param type [Object] The type you want.
  # @return [Array<Object>] The return value will be objects in +enum+ with attribute
  #   +.type+ equals to +type+.
  #
  # source://elftools//lib/elftools/util.rb#88
  def select_by_type(enum, type); end

  # Fetch the correct value from module +mod+.
  #
  # See {ELFTools::ELFFile#segment_by_type} for how to
  # use this method.
  #
  # @param mod [Module] The module defined constant numbers.
  # @param val [Integer, Symbol, String] Desired value.
  # @raise [ArgumentError]
  # @return [Integer] Currently this method always return a value
  #   from {ELFTools::Constants}.
  #
  # source://elftools//lib/elftools/util.rb#36
  def to_constant(mod, val); end
end

# Current gem version
#
# source://elftools//lib/elftools/version.rb#5
ELFTools::VERSION = T.let(T.unsafe(nil), String)
