# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `highline` gem.
# Please instead update this file by running `bin/tapioca gem highline`.

# A HighLine object is a "high-level line oriented" shell over an input and an
# output stream.  HighLine simplifies common console interaction, effectively
# replacing {Kernel#puts} and {Kernel#gets}.  User code can simply specify the
# question to ask and any details about user interaction, then leave the rest
# of the work to HighLine.  When {HighLine#ask} returns, you'll have the answer
# you requested, even if HighLine had to ask many times, validate results,
# perform range checking, convert types, etc.
#
# @example Basic usage
#   cli = HighLine.new
#   answer = cli.ask "What do you think?"
#   puts "You have answered: #{answer}"
#
# source://highline//lib/highline/terminal.rb#14
class HighLine
  include ::HighLine::BuiltinStyles
  include ::HighLine::CustomErrors
  extend ::HighLine::BuiltinStyles::ClassMethods
  extend ::SingleForwardable

  # Create an instance of HighLine connected to the given _input_
  # and _output_ streams.
  #
  # @param input [IO] the default input stream for HighLine.
  # @param output [IO] the default output stream for HighLine.
  # @param wrap_at [Integer] all statements outputed through
  #   HighLine will be wrapped to this column size if set.
  # @param page_at [Integer] page size and paginating.
  # @param indent_size [Integer] indentation size in spaces.
  # @param indent_level [Integer] how deep is indentated.
  # @return [HighLine] a new instance of HighLine
  #
  # source://highline//lib/highline.rb#102
  def initialize(input = T.unsafe(nil), output = T.unsafe(nil), wrap_at = T.unsafe(nil), page_at = T.unsafe(nil), indent_size = T.unsafe(nil), indent_level = T.unsafe(nil)); end

  # A shortcut to HighLine.ask() a question that only accepts "yes" or "no"
  # answers ("y" and "n" are allowed) and returns +true+ or +false+
  # (+true+ for "yes").  If provided a +true+ value, _character_ will cause
  # HighLine to fetch a single character response. A block can be provided
  # to further configure the question as in HighLine.ask()
  #
  # Raises EOFError if input is exhausted.
  #
  # @param yes_or_no_question [String] a question that accepts yes and no as
  #   answers
  # @param character [Boolean, :getc] character mode to be passed to
  #   Question#character
  # @see Question#character
  #
  # source://highline//lib/highline.rb#193
  def agree(yes_or_no_question, character = T.unsafe(nil)); end

  # This method is the primary interface for user input.  Just provide a
  # _question_ to ask the user, the _answer_type_ you want returned, and
  # optionally a code block setting up details of how you want the question
  # handled.  See {#say} for details on the format of _question_, and
  # {Question} for more information about _answer_type_ and what's
  # valid in the code block.
  #
  # Raises EOFError if input is exhausted.
  #
  # @param template_or_question [String, Question] what to ask
  # @param answer_type [Class] to what class to convert the answer
  # @param details to be passed to Question.new
  # @return answer converted to the class in answer_type
  #
  # source://highline//lib/highline.rb#217
  def ask(template_or_question, answer_type = T.unsafe(nil), &details); end

  # This method is HighLine's menu handler.  For simple usage, you can just
  # pass all the menu items you wish to display.  At that point, choose() will
  # build and display a menu, walk the user through selection, and return
  # their choice among the provided items.  You might use this in a case
  # statement for quick and dirty menus.
  #
  # However, choose() is capable of much more.  If provided, a block will be
  # passed a HighLine::Menu object to configure.  Using this method, you can
  # customize all the details of menu handling from index display, to building
  # a complete shell-like menuing system.  See HighLine::Menu for all the
  # methods it responds to.
  #
  # Raises EOFError if input is exhausted.
  #
  # @param items [Array<String>]
  # @param details [Proc] to be passed to Menu.new
  # @return [String] answer
  #
  # source://highline//lib/highline.rb#245
  def choose(*items, &details); end

  # This method provides easy access to ANSI color sequences, without the user
  # needing to remember to CLEAR at the end of each sequence.  Just pass the
  # _string_ to color, followed by a list of _colors_ you would like it to be
  # affected by.  The _colors_ can be HighLine class constants, or symbols
  # (:blue for BLUE, for example).  A CLEAR will automatically be embedded to
  # the end of the returned String.
  #
  # This method returns the original _string_ unchanged if use_color?
  # is +false+.
  #
  # @example
  #   cli = HighLine.new
  #   cli.color("Sustainable", :green, :bold)
  #   # => "\e[32m\e[1mSustainable\e[0m"
  #
  #   # As class method (delegating to HighLine.default_instance)
  #   HighLine.color("Sustainable", :green, :bold)
  # @param string [String] string to be colored
  # @param colors [Array<Symbol>] array of colors like [:red, :blue]
  # @return [String] (ANSI escaped) colored string
  #
  # source://highline//lib/highline.rb#321
  def color(string, *colors); end

  # In case you just want the color code, without the embedding and
  # the CLEAR sequence.
  #
  # @example
  #   s = HighLine.Style(:red, :blue)
  #   s.code # => "\e[31m\e[34m"
  #
  #   HighLine.color_code(:red, :blue) # => "\e[31m\e[34m"
  #
  #   cli = HighLine.new
  #   cli.color_code(:red, :blue) # => "\e[31m\e[34m"
  # @param colors [Array<Symbol>]
  # @return [String] ANSI escape code for the given colors.
  #
  # source://highline//lib/highline.rb#341
  def color_code(*colors); end

  # Get response each character per turn
  #
  # @param question [Question]
  # @return [String] response
  #
  # source://highline//lib/highline.rb#607
  def get_response_character_mode(question); end

  # Get response using #getc
  #
  # @param question [Question]
  # @return [String] response
  #
  # source://highline//lib/highline.rb#597
  def get_response_getc_mode(question); end

  # Get response one line at time
  #
  # @param question [Question]
  # @return [String] response
  #
  # source://highline//lib/highline.rb#514
  def get_response_line_mode(question); end

  # Executes block or outputs statement with indentation
  #
  # @param increase [Integer] how much to increase indentation
  # @param statement [Statement, String] to be said
  # @param multiline [Boolean]
  # @return [void]
  # @see #multi_indent
  #
  # source://highline//lib/highline.rb#431
  def indent(increase = T.unsafe(nil), statement = T.unsafe(nil), multiline = T.unsafe(nil)); end

  # @return [Integer] The indentation level
  #
  # source://highline//lib/highline.rb#158
  def indent_level; end

  # @return [Integer] The indentation level
  #
  # source://highline//lib/highline.rb#158
  def indent_level=(_arg0); end

  # @return [Integer] The indentation size in characters
  #
  # source://highline//lib/highline.rb#155
  def indent_size; end

  # @return [Integer] The indentation size in characters
  #
  # source://highline//lib/highline.rb#155
  def indent_size=(_arg0); end

  # Outputs indentation with current settings
  #
  # source://highline//lib/highline.rb#419
  def indentation; end

  # @return [IO] the default input stream for a HighLine instance
  #
  # source://highline//lib/highline.rb#161
  def input; end

  # When gathering a Hash with {QuestionAsker#gather_hash},
  # it tracks the current key being asked.
  #
  # @todo We should probably move this into the HighLine::Question
  #   object.
  #
  # source://highline//lib/highline.rb#171
  def key; end

  # When gathering a Hash with {QuestionAsker#gather_hash},
  # it tracks the current key being asked.
  #
  # @todo We should probably move this into the HighLine::Question
  #   object.
  #
  # source://highline//lib/highline.rb#171
  def key=(_arg0); end

  # Renders a list of itens using a {ListRenderer}
  #
  # @param items [Array]
  # @param mode [Symbol]
  # @param option
  # @return [String]
  # @see ListRenderer#initialize ListRenderer#initialize for parameter details
  #
  # source://highline//lib/highline.rb#358
  def list(items, mode = T.unsafe(nil), option = T.unsafe(nil)); end

  # @return [Boolean] Indentation over multiple lines
  #
  # source://highline//lib/highline.rb#152
  def multi_indent; end

  # @return [Boolean] Indentation over multiple lines
  #
  # source://highline//lib/highline.rb#152
  def multi_indent=(_arg0); end

  # Creates a new HighLine instance with the same options
  #
  # source://highline//lib/highline.rb#485
  def new_scope; end

  # Outputs newline
  #
  # source://highline//lib/highline.rb#450
  def newline; end

  # @return [IO] the default output stream for a HighLine instance
  #
  # source://highline//lib/highline.rb#164
  def output; end

  # Returns the number of columns for the console, or a default it they cannot
  # be determined.
  #
  # source://highline//lib/highline.rb#458
  def output_cols; end

  # Returns the number of rows for the console, or a default if they cannot be
  # determined.
  #
  # source://highline//lib/highline.rb#469
  def output_rows; end

  # @return [Integer] The current row setting for paging output.
  #
  # source://highline//lib/highline.rb#149
  def page_at; end

  # Set to an integer value to cause HighLine to page output lines over the
  # indicated line limit.  When +nil+, the default, no paging occurs.  If
  # set to <tt>:auto</tt>, HighLine will attempt to determine the rows available
  # for the <tt>@output</tt> or use a sensible default.
  #
  # source://highline//lib/highline.rb#412
  def page_at=(setting); end

  # Call #puts on the HighLine's output stream
  #
  # @param args [String] same args for Kernel#puts
  #
  # source://highline//lib/highline.rb#478
  def puts(*args); end

  # Renders a statement using {HighLine::Statement}
  #
  # @param statement [String] any string
  # @return [Statement] rendered statement
  #
  # source://highline//lib/highline.rb#392
  def render_statement(statement); end

  # Resets the use of color.
  #
  # source://highline//lib/highline.rb#133
  def reset_use_color; end

  # The basic output method for HighLine objects.  If the provided _statement_
  # ends with a space or tab character, a newline will not be appended (output
  # will be flush()ed).  All other cases are passed straight to Kernel.puts().
  #
  # The _statement_ argument is processed as an ERb template, supporting
  # embedded Ruby code.  The template is evaluated within a HighLine
  # instance's binding for providing easy access to the ANSI color constants
  # and the HighLine#color() method.
  #
  # @param statement [Statement, String] what to be said
  #
  # source://highline//lib/highline.rb#373
  def say(statement); end

  # Convenience method to craft a lambda suitable for
  # beind used in autocompletion operations by {#choose}
  #
  # @return [lambda] lambda to be used in autocompletion operations
  #
  # source://highline//lib/highline.rb#285
  def shell_style_lambda(menu); end

  # System specific that responds to #initialize_system_extensions,
  # #terminal_size, #raw_no_echo_mode, #restore_mode, #get_character.
  # It polymorphically handles specific cases for different platforms.
  #
  # @return [HighLine::Terminal]
  #
  # source://highline//lib/highline.rb#177
  def terminal; end

  # Pass +false+ to turn off HighLine's EOF tracking.
  #
  # source://highline//lib/highline.rb#138
  def track_eof; end

  # Pass +false+ to turn off HighLine's EOF tracking.
  #
  # source://highline//lib/highline.rb#138
  def track_eof=(_arg0); end

  # Returns true if HighLine is currently tracking EOF for input.
  #
  # @return [Boolean]
  #
  # source://highline//lib/highline.rb#141
  def track_eof?; end

  # Remove color codes from a string.
  #
  # @param string [String] to be decolorized
  # @return [String] without the ANSI escape sequence (colors)
  #
  # source://highline//lib/highline.rb#348
  def uncolor(string); end

  # Set it to false to disable ANSI coloring
  #
  # source://highline//lib/highline.rb#125
  def use_color; end

  # Set it to false to disable ANSI coloring
  #
  # source://highline//lib/highline.rb#125
  def use_color=(_arg0); end

  # Returns truethy if HighLine instance is currently using color escapes.
  #
  # @return [Boolean]
  #
  # source://highline//lib/highline.rb#128
  def use_color?; end

  # @return [Integer] The current column setting for wrapping output.
  #
  # source://highline//lib/highline.rb#146
  def wrap_at; end

  # Set to an integer value to cause HighLine to wrap output lines at the
  # indicated character limit.  When +nil+, the default, no wrapping occurs.  If
  # set to <tt>:auto</tt>, HighLine will attempt to determine the columns
  # available for the <tt>@output</tt> or use a sensible default.
  #
  # source://highline//lib/highline.rb#402
  def wrap_at=(setting); end

  private

  # source://highline//lib/highline.rb#628
  def actual_length(text); end

  # Adds a layer of scope (new_scope) to ask a question inside a
  # question, without destroying instance data
  #
  # source://highline//lib/highline.rb#494
  def confirm(question); end

  # Check to see if there's already a HighLine.default_instance or if
  # this is the first time the method is called (eg: at
  # HighLine.default_instance initialization).
  # If there's already one, copy use_color settings.
  # This is here most to help migrate code from HighLine 1.7.x to 2.0.x
  #
  # @return [Boolean]
  #
  # source://highline//lib/highline.rb#639
  def default_use_color; end

  # source://highline//lib/highline.rb#620
  def erase_current_line; end

  # Read a line of input from the input stream and process whitespace as
  # requested by the Question object.
  #
  # If Question's _readline_ property is set, that library will be used to
  # fetch input.  *WARNING*:  This ignores the currently set input stream.
  #
  # Raises EOFError if input is exhausted.
  #
  # source://highline//lib/highline.rb#531
  def get_line(question); end

  # source://highline//lib/highline.rb#535
  def get_line_raw_no_echo_mode(question); end

  # source://highline//lib/highline.rb#575
  def ignore_arrow_key; end

  # source://highline//lib/highline.rb#507
  def last_answer(answers); end

  # @return [Boolean]
  #
  # source://highline//lib/highline.rb#586
  def line_overflow_for_question?(line, question); end

  # source://highline//lib/highline.rb#590
  def output_erase_char; end

  # source://highline//lib/highline.rb#581
  def say_last_char_or_echo_char(line, question); end

  # source://highline//lib/highline.rb#566
  def say_new_line_or_overwrite(question); end

  # A helper method used by HighLine::Question.verify_match
  # for finding whether a list of answers match or differ
  # from each other.
  #
  # source://highline//lib/highline.rb#503
  def unique_answers(list); end

  class << self
    # Returns a HighLine::String from any given String.
    #
    # @param s [String]
    # @return [HighLine::String] from the given string.
    #
    # source://highline//lib/highline/string_extensions.rb#7
    def String(s); end

    # Creates a style using {.find_or_create_style} or
    # {.find_or_create_style_list}
    #
    # @param args [Array<Style, Hash, String>] style properties
    # @return [Style]
    #
    # source://highline//lib/highline/style.rb#16
    def Style(*args); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def agree(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def ask(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def choose(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def color(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def color_code(*args, **_arg1, &block); end

    # Pass ColorScheme to set a HighLine color scheme.
    #
    # source://highline//lib/highline.rb#58
    def color_scheme; end

    # Pass ColorScheme to set a HighLine color scheme.
    #
    # source://highline//lib/highline.rb#58
    def color_scheme=(_arg0); end

    # Adds color support to the base String class
    #
    # source://highline//lib/highline/string_extensions.rb#127
    def colorize_strings; end

    # Returns the value of attribute default_instance.
    #
    # source://highline//lib/highline.rb#55
    def default_instance; end

    # Sets the attribute default_instance
    #
    # @param value the value to set the attribute default_instance to.
    #
    # source://highline//lib/highline.rb#55
    def default_instance=(_arg0); end

    # Search for a Style with the given properties and return it.
    # If there's no matched Style, it creates one.
    # You can pass a Style, String or a Hash.
    #
    # @param arg [Style, String, Hash] style properties
    # @return [Style] found or creted Style
    #
    # source://highline//lib/highline/style.rb#30
    def find_or_create_style(arg); end

    # Find a Style list or create a new one.
    #
    # @example Creating a Style list of the combined RED and BOLD styles.
    #   style_list = HighLine.find_or_create_style_list(:red, :bold)
    # @param args [Array<Symbol>] an Array of Symbols of each style
    #   that will be on the style list.
    # @return [Style] Style list
    #
    # source://highline//lib/highline/style.rb#62
    def find_or_create_style_list(*args); end

    # Reset HighLine to default.
    # Clears Style index and resets color_scheme and use_color settings.
    #
    # source://highline//lib/highline.rb#72
    def reset; end

    # Reset color scheme to default (+nil+)
    #
    # source://highline//lib/highline.rb#66
    def reset_color_scheme; end

    # source://forwardable/1.3.2/forwardable.rb#229
    def reset_use_color(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def say(*args, **_arg1, &block); end

    # For checking if the current version of HighLine supports RGB colors
    # Usage: HighLine.supports_rgb_color? rescue false
    #  using rescue for compatibility with older versions
    # Note: color usage also depends on HighLine.use_color being set
    # TODO: Discuss removing this method
    #
    # @return [Boolean]
    #
    # source://highline//lib/highline.rb#83
    def supports_rgb_color?; end

    # source://forwardable/1.3.2/forwardable.rb#229
    def track_eof=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def track_eof?(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def uncolor(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def use_color=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def use_color?(*args, **_arg1, &block); end

    # Returns +true+ if HighLine is currently using a color scheme.
    #
    # @return [Boolean]
    #
    # source://highline//lib/highline.rb#61
    def using_color_scheme?; end
  end
end

# Builtin Styles that are included at HighLine initialization.
# It has the basic styles like :bold and :underline.
#
# source://highline//lib/highline/builtin_styles.rb#6
module HighLine::BuiltinStyles
  mixes_in_class_methods ::HighLine::BuiltinStyles::ClassMethods

  class << self
    # Included callback
    #
    # @param base [Class, Module] base class
    #
    # source://highline//lib/highline/builtin_styles.rb#9
    def included(base); end
  end
end

# The builtin styles basic colors like black, red, green.
#
# source://highline//lib/highline/builtin_styles.rb#69
HighLine::BuiltinStyles::BASIC_COLORS = T.let(T.unsafe(nil), Array)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::BLACK = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#65
HighLine::BuiltinStyles::BLACK_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#31
HighLine::BuiltinStyles::BLINK = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#32
HighLine::BuiltinStyles::BLINK_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::BLUE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#65
HighLine::BuiltinStyles::BLUE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#31
HighLine::BuiltinStyles::BOLD = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#32
HighLine::BuiltinStyles::BOLD_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::BRIGHT_BLACK = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#77
HighLine::BuiltinStyles::BRIGHT_BLACK_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::BRIGHT_BLUE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#77
HighLine::BuiltinStyles::BRIGHT_BLUE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::BRIGHT_CYAN = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#77
HighLine::BuiltinStyles::BRIGHT_CYAN_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::BRIGHT_GRAY = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#77
HighLine::BuiltinStyles::BRIGHT_GRAY_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::BRIGHT_GREEN = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#77
HighLine::BuiltinStyles::BRIGHT_GREEN_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::BRIGHT_GREY = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#77
HighLine::BuiltinStyles::BRIGHT_GREY_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::BRIGHT_MAGENTA = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#77
HighLine::BuiltinStyles::BRIGHT_MAGENTA_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::BRIGHT_NONE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#77
HighLine::BuiltinStyles::BRIGHT_NONE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::BRIGHT_RED = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#77
HighLine::BuiltinStyles::BRIGHT_RED_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::BRIGHT_WHITE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#77
HighLine::BuiltinStyles::BRIGHT_WHITE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::BRIGHT_YELLOW = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#77
HighLine::BuiltinStyles::BRIGHT_YELLOW_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#31
HighLine::BuiltinStyles::CLEAR = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#32
HighLine::BuiltinStyles::CLEAR_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# The builtin styles' colors like LIGHT_RED and BRIGHT_BLUE.
#
# source://highline//lib/highline/builtin_styles.rb#85
HighLine::BuiltinStyles::COLORS = T.let(T.unsafe(nil), Array)

# A Hash with the basic colors an their ANSI escape codes.
#
# source://highline//lib/highline/builtin_styles.rb#41
HighLine::BuiltinStyles::COLOR_LIST = T.let(T.unsafe(nil), Hash)

# source://highline//lib/highline/builtin_styles.rb#31
HighLine::BuiltinStyles::CONCEALED = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#32
HighLine::BuiltinStyles::CONCEALED_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::CYAN = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#65
HighLine::BuiltinStyles::CYAN_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# BuiltinStyles class methods to be extended.
#
# source://highline//lib/highline/builtin_styles.rb#96
module HighLine::BuiltinStyles::ClassMethods
  # const_missing callback for automatically respond to
  # builtin constants (without explicitly defining them)
  #
  # @param name [Symbol] missing constant name
  # @raise [NameError]
  #
  # source://highline//lib/highline/builtin_styles.rb#103
  def const_missing(name); end
end

# Regexp to match against RGB style constant names.
#
# source://highline//lib/highline/builtin_styles.rb#98
HighLine::BuiltinStyles::ClassMethods::RGB_COLOR_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://highline//lib/highline/builtin_styles.rb#31
HighLine::BuiltinStyles::DARK = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#32
HighLine::BuiltinStyles::DARK_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#31
HighLine::BuiltinStyles::ERASE_CHAR = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#32
HighLine::BuiltinStyles::ERASE_CHAR_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#31
HighLine::BuiltinStyles::ERASE_LINE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#32
HighLine::BuiltinStyles::ERASE_LINE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::GRAY = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#65
HighLine::BuiltinStyles::GRAY_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::GREEN = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#65
HighLine::BuiltinStyles::GREEN_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::GREY = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#65
HighLine::BuiltinStyles::GREY_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::LIGHT_BLACK = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#81
HighLine::BuiltinStyles::LIGHT_BLACK_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::LIGHT_BLUE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#81
HighLine::BuiltinStyles::LIGHT_BLUE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::LIGHT_CYAN = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#81
HighLine::BuiltinStyles::LIGHT_CYAN_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::LIGHT_GRAY = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#81
HighLine::BuiltinStyles::LIGHT_GRAY_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::LIGHT_GREEN = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#81
HighLine::BuiltinStyles::LIGHT_GREEN_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::LIGHT_GREY = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#81
HighLine::BuiltinStyles::LIGHT_GREY_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::LIGHT_MAGENTA = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#81
HighLine::BuiltinStyles::LIGHT_MAGENTA_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::LIGHT_NONE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#81
HighLine::BuiltinStyles::LIGHT_NONE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::LIGHT_RED = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#81
HighLine::BuiltinStyles::LIGHT_RED_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::LIGHT_WHITE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#81
HighLine::BuiltinStyles::LIGHT_WHITE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::LIGHT_YELLOW = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#81
HighLine::BuiltinStyles::LIGHT_YELLOW_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::MAGENTA = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#65
HighLine::BuiltinStyles::MAGENTA_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::NONE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#65
HighLine::BuiltinStyles::NONE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_BLACK = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_BLACK_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_BLUE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_BLUE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_BRIGHT_BLACK = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_BRIGHT_BLACK_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_BRIGHT_BLUE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_BRIGHT_BLUE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_BRIGHT_CYAN = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_BRIGHT_CYAN_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_BRIGHT_GRAY = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_BRIGHT_GRAY_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_BRIGHT_GREEN = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_BRIGHT_GREEN_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_BRIGHT_GREY = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_BRIGHT_GREY_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_BRIGHT_MAGENTA = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_BRIGHT_MAGENTA_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_BRIGHT_NONE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_BRIGHT_NONE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_BRIGHT_RED = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_BRIGHT_RED_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_BRIGHT_WHITE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_BRIGHT_WHITE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_BRIGHT_YELLOW = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_BRIGHT_YELLOW_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_CYAN = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_CYAN_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_GRAY = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_GRAY_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_GREEN = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_GREEN_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_GREY = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_GREY_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_LIGHT_BLACK = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_LIGHT_BLACK_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_LIGHT_BLUE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_LIGHT_BLUE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_LIGHT_CYAN = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_LIGHT_CYAN_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_LIGHT_GRAY = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_LIGHT_GRAY_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_LIGHT_GREEN = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_LIGHT_GREEN_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_LIGHT_GREY = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_LIGHT_GREY_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_LIGHT_MAGENTA = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_LIGHT_MAGENTA_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_LIGHT_NONE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_LIGHT_NONE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_LIGHT_RED = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_LIGHT_RED_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_LIGHT_WHITE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_LIGHT_WHITE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_LIGHT_YELLOW = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_LIGHT_YELLOW_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_MAGENTA = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_MAGENTA_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_NONE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_NONE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_RED = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_RED_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_WHITE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_WHITE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#90
HighLine::BuiltinStyles::ON_YELLOW = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#89
HighLine::BuiltinStyles::ON_YELLOW_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::RED = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#65
HighLine::BuiltinStyles::RED_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#31
HighLine::BuiltinStyles::RESET = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#32
HighLine::BuiltinStyles::RESET_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#31
HighLine::BuiltinStyles::REVERSE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#32
HighLine::BuiltinStyles::REVERSE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# Basic Style names like CLEAR, BOLD, UNDERLINE
#
# source://highline//lib/highline/builtin_styles.rb#37
HighLine::BuiltinStyles::STYLES = T.let(T.unsafe(nil), Array)

# Basic styles' ANSI escape codes like :bold => "\e[1m"
#
# source://highline//lib/highline/builtin_styles.rb#14
HighLine::BuiltinStyles::STYLE_LIST = T.let(T.unsafe(nil), Hash)

# source://highline//lib/highline/builtin_styles.rb#31
HighLine::BuiltinStyles::UNDERLINE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#32
HighLine::BuiltinStyles::UNDERLINE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#31
HighLine::BuiltinStyles::UNDERSCORE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#32
HighLine::BuiltinStyles::UNDERSCORE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::WHITE = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#65
HighLine::BuiltinStyles::WHITE_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# source://highline//lib/highline/builtin_styles.rb#88
HighLine::BuiltinStyles::YELLOW = T.let(T.unsafe(nil), String)

# source://highline//lib/highline/builtin_styles.rb#65
HighLine::BuiltinStyles::YELLOW_STYLE = T.let(T.unsafe(nil), HighLine::Style)

# ColorScheme objects encapsulate a named set of colors to be used in the
# {HighLine.color} method call.  For example, by applying a ColorScheme that
# has a <tt>:warning</tt> color then the following could be used:
#
#   color("This is a warning", :warning)
#
# A ColorScheme contains named sets of HighLine color constants.
#
# @example Instantiating a color scheme, applying it to HighLine,
#   and using it:
#   ft = HighLine::ColorScheme.new do |cs|
#   cs[:headline]        = [ :bold, :yellow, :on_black ]
#   cs[:horizontal_line] = [ :bold, :white ]
#   cs[:even_row]        = [ :green ]
#   cs[:odd_row]         = [ :magenta ]
#   end
#
#   HighLine.color_scheme = ft
#   say("<%= color('Headline', :headline) %>")
#   say("<%= color('-'*20, :horizontal_line) %>")
#   i = true
#   ("A".."D").each do |row|
#   if i then
#   say("<%= color('#{row}', :even_row ) %>")
#   else
#   say("<%= color('#{row}', :odd_row) %>")
#   end
#   i = !i
#   end
#
# source://highline//lib/highline/color_scheme.rb#44
class HighLine::ColorScheme
  # Create an instance of HighLine::ColorScheme. The customization can
  # happen as a passed in Hash or via the yielded block.  Keys are
  # converted to <tt>:symbols</tt> and values are converted to HighLine
  # constants.
  #
  # @param h [Hash]
  # @return [ColorScheme] a new instance of ColorScheme
  # @yield [_self]
  # @yieldparam _self [HighLine::ColorScheme] the object that the method was called on
  #
  # source://highline//lib/highline/color_scheme.rb#52
  def initialize(h = T.unsafe(nil)); end

  # Allow the scheme to be accessed like a Hash.
  #
  # @param color_tag [#to_sym]
  # @return [Style]
  #
  # source://highline//lib/highline/color_scheme.rb#76
  def [](color_tag); end

  # Allow the scheme to be set like a Hash.
  #
  # @param color_tag [#to_sym]
  # @param constants [Array<Symbol>] Array of Style symbols
  #
  # source://highline//lib/highline/color_scheme.rb#96
  def []=(color_tag, constants); end

  # Retrieve the original form of the scheme
  #
  # @param color_tag [#to_sym]
  #
  # source://highline//lib/highline/color_scheme.rb#82
  def definition(color_tag); end

  # Does this color scheme include the given tag name?
  #
  # @param color_tag [#to_sym]
  # @return [Boolean]
  #
  # source://highline//lib/highline/color_scheme.rb#69
  def include?(color_tag); end

  # Retrieve the keys in the scheme
  #
  # @return [Array] of keys
  #
  # source://highline//lib/highline/color_scheme.rb#89
  def keys; end

  # Load multiple colors from key/value pairs.
  #
  # @param h [Hash]
  #
  # source://highline//lib/highline/color_scheme.rb#60
  def load_from_hash(h); end

  # Retrieve the color scheme hash (in original definition format)
  #
  # @return [Hash] scheme as Hash. It may be reused in a new ColorScheme.
  #
  # source://highline//lib/highline/color_scheme.rb#105
  def to_hash; end

  private

  # Return a normalized representation of a color setting.
  #
  # source://highline//lib/highline/color_scheme.rb#120
  def to_constant(v); end

  # Return a normalized representation of a color name.
  #
  # source://highline//lib/highline/color_scheme.rb#115
  def to_symbol(t); end
end

# Internal HighLine errors.
#
# source://highline//lib/highline/custom_errors.rb#5
module HighLine::CustomErrors; end

# An error that responds to :explanation_key
#
# source://highline//lib/highline/custom_errors.rb#11
class HighLine::CustomErrors::ExplainableError < ::StandardError
  # Explanation key as Symbol or nil. Used to
  # select the proper error message to be displayed.
  #
  # @return [nil, Symbol] explanation key to get the
  #   proper error message.
  #
  # source://highline//lib/highline/custom_errors.rb#12
  def explanation_key; end
end

# Unavailable auto complete error
#
# source://highline//lib/highline/custom_errors.rb#51
class HighLine::CustomErrors::NoAutoCompleteMatch < ::HighLine::CustomErrors::ExplainableError
  # Explanation key as Symbol or nil. Used to
  # select the proper error message to be displayed.
  #
  # @return [nil, Symbol] explanation key to get the
  #   proper error message.
  #
  # source://highline//lib/highline/custom_errors.rb#52
  def explanation_key; end
end

# Unconfirmed Question error
#
# source://highline//lib/highline/custom_errors.rb#43
class HighLine::CustomErrors::NoConfirmationQuestionError < ::HighLine::CustomErrors::ExplainableError
  # Explanation key as Symbol or nil. Used to
  # select the proper error message to be displayed.
  #
  # @return [nil, Symbol] explanation key to get the
  #   proper error message.
  #
  # source://highline//lib/highline/custom_errors.rb#44
  def explanation_key; end
end

# Out of Range Question error
#
# source://highline//lib/highline/custom_errors.rb#35
class HighLine::CustomErrors::NotInRangeQuestionError < ::HighLine::CustomErrors::ExplainableError
  # Explanation key as Symbol or nil. Used to
  # select the proper error message to be displayed.
  #
  # @return [nil, Symbol] explanation key to get the
  #   proper error message.
  #
  # source://highline//lib/highline/custom_errors.rb#36
  def explanation_key; end
end

# Invalid Question error
#
# source://highline//lib/highline/custom_errors.rb#27
class HighLine::CustomErrors::NotValidQuestionError < ::HighLine::CustomErrors::ExplainableError
  # Explanation key as Symbol or nil. Used to
  # select the proper error message to be displayed.
  #
  # @return [nil, Symbol] explanation key to get the
  #   proper error message.
  #
  # source://highline//lib/highline/custom_errors.rb#28
  def explanation_key; end
end

# Bare Question error
#
# source://highline//lib/highline/custom_errors.rb#19
class HighLine::CustomErrors::QuestionError < ::HighLine::CustomErrors::ExplainableError
  # Explanation key as Symbol or nil. Used to
  # select the proper error message to be displayed.
  #
  # @return [nil, Symbol] explanation key to get the
  #   proper error message.
  #
  # source://highline//lib/highline/custom_errors.rb#20
  def explanation_key; end
end

# List class with some convenience methods like {#col_down}.
#
# source://highline//lib/highline/list.rb#5
class HighLine::List
  # @option options
  # @option options
  # @option options
  # @param items [#to_a] an array of items to compose the list.
  # @param options [Hash] a hash of options to tailor the list.
  # @return [List] a new instance of List
  #
  # source://highline//lib/highline/list.rb#61
  def initialize(items, options = T.unsafe(nil)); end

  # Slice the list by rows and transpose it.
  #
  # @return [self]
  #
  # source://highline//lib/highline/list.rb#81
  def col_down; end

  # Content are distributed first by column in col down mode.
  #
  # @example A two columns array like this:
  #   [ [ "a", "b" ],
  #   [ "c", "d" ],
  #   [ "e", "f" ],
  #   [ "g", "h" ],
  #   [ "i", "j" ] ]
  # @example In col down mode will be like this:
  #   [ [ "a", "f"],
  #   [ "b", "g"],
  #   [ "c", "h"],
  #   [ "d", "i"],
  #   [ "e", "j"] ]
  # @return [Boolean]
  # @see #transpose_mode
  #
  # source://highline//lib/highline/list.rb#53
  def col_down_mode; end

  # Number of columns for each list row.
  #
  # @return [Integer]
  #
  # source://highline//lib/highline/list.rb#14
  def cols; end

  # Set the cols number.
  #
  # @return [self]
  #
  # source://highline//lib/highline/list.rb#104
  def cols=(cols); end

  # Original given *items* argument.
  # It's frozen at initialization time and
  # all later transformations will happen on {#list}.
  #
  # @return [Array]
  #
  # source://highline//lib/highline/list.rb#10
  def items; end

  # Returns an Array representation of the list
  # in its current state.
  #
  # @return [Array] @list.dup
  #
  # source://highline//lib/highline/list.rb#112
  def list; end

  # Returns the row join string size.
  # Useful for calculating the actual size of
  # rendered list.
  #
  # @return [Integer]
  #
  # source://highline//lib/highline/list.rb#148
  def row_join_str_size; end

  # The String that will be used to join each
  # cell of the list and stringfying it.
  #
  # @return [String] defaults to " " (space)
  #
  # source://highline//lib/highline/list.rb#136
  def row_join_string; end

  # Set the {#row_join_string}.
  #
  # @see #row_join_string
  #
  # source://highline//lib/highline/list.rb#142
  def row_join_string=(_arg0); end

  # Slice the list by cols based on the {#cols} param.
  #
  # @return [self]
  #
  # source://highline//lib/highline/list.rb#97
  def slice_by_cols; end

  # Slice the list by rows. The row count is calculated
  # indirectly based on the {#cols} param and the items count.
  #
  # @return [self]
  #
  # source://highline//lib/highline/list.rb#90
  def slice_by_rows; end

  # Returns an Array representation of the list
  # in its current state.
  #
  # @return [Array] @list.dup
  #
  # source://highline//lib/highline/list.rb#117
  def to_a; end

  # Stringfies the list in its current state.
  # It joins each individual _cell_ with the current
  # {#row_join_string} between them.
  # It joins each individual row with a
  # newline character. So the returned String is
  # suitable to be directly outputed
  # to the screen, preserving row/columns divisions.
  #
  # @return [String]
  #
  # source://highline//lib/highline/list.rb#129
  def to_s; end

  # Transpose the (already sliced by rows) list,
  #   turning its rows into columns.
  #
  # @return [self]
  #
  # source://highline//lib/highline/list.rb#72
  def transpose; end

  # Columns turn into rows in transpose mode.
  #
  # @example A two columns array like this:
  #   [ [ "a", "b" ],
  #   [ "c", "d" ],
  #   [ "e", "f" ],
  #   [ "g", "h" ],
  #   [ "i", "j" ] ]
  # @example When in transpose mode will be like this:
  #   [ [ "a", "c", "e", "g", "i" ],
  #   [ "b", "d", "f", "h", "j" ] ]
  # @return [Boolean]
  # @see #col_down_mode
  #
  # source://highline//lib/highline/list.rb#32
  def transpose_mode; end

  private

  # source://highline//lib/highline/list.rb#154
  def build; end

  # source://highline//lib/highline/list.rb#161
  def items_sliced_by_cols; end

  # source://highline//lib/highline/list.rb#165
  def items_sliced_by_rows; end

  # source://highline//lib/highline/list.rb#169
  def row_count; end

  # source://highline//lib/highline/list.rb#173
  def stringfy(row); end
end

# This class is a utility for quickly and easily laying out lists
# to be used by HighLine.
#
# source://highline//lib/highline/list_renderer.rb#12
class HighLine::ListRenderer
  # The only required parameters are _items_ and _highline_.
  # Recognized modes are:
  #
  # <tt>:columns_across</tt>::         _items_ will be placed in columns,
  #                                    flowing from left to right.  If given,
  #                                    _option_ is the number of columns to be
  #                                    used.  When absent, columns will be
  #                                    determined based on _wrap_at_ or a
  #                                    default of 80 characters.
  # <tt>:columns_down</tt>::           Identical to <tt>:columns_across</tt>,
  #                                    save flow goes down.
  # <tt>:uneven_columns_across</tt>::  Like <tt>:columns_across</tt> but each
  #                                    column is sized independently.
  # <tt>:uneven_columns_down</tt>::    Like <tt>:columns_down</tt> but each
  #                                    column is sized independently.
  # <tt>:inline</tt>::                 All _items_ are placed on a single
  #                                    line. The last two _items_ are
  #                                    separated by _option_ or a default of
  #                                    " or ".  All other _items_ are
  #                                    separated by ", ".
  # <tt>:rows</tt>::                   The default mode.  Each of the _items_
  #                                    is placed on its own line. The _option_
  #                                    parameter is ignored in this mode.
  #
  # Each member of the _items_ Array is passed through ERb and thus can
  # contain their own expansions. Color escape expansions do not contribute to
  # the final field width.
  #
  # @param items [Array] the Array of items to list
  # @param mode [Symbol] controls how that list is formed
  # @param option has different effects, depending on the _mode_.
  # @param highline [HighLine] a HighLine instance to direct the output to.
  # @return [ListRenderer] a new instance of ListRenderer
  #
  # source://highline//lib/highline/list_renderer.rb#62
  def initialize(items, mode = T.unsafe(nil), option = T.unsafe(nil), highline); end

  # @return [HighLine] context
  #
  # source://highline//lib/highline/list_renderer.rb#27
  def highline; end

  # Items list
  #
  # @return [Array]
  #
  # source://highline//lib/highline/list_renderer.rb#15
  def items; end

  # @return [Symbol] the current mode the List is being rendered
  # @see #initialize for more details see mode parameter of #initialize
  #
  # source://highline//lib/highline/list_renderer.rb#19
  def mode; end

  # Changes the behaviour of some modes. Example, in :inline mode
  # the option is treated as the 'end separator' (defaults to " or ")
  #
  # @return option parameter that changes the behaviour of some modes.
  #
  # source://highline//lib/highline/list_renderer.rb#24
  def option; end

  # Render the list using the appropriate mode and options.
  #
  # @return [String] rendered list as String
  #
  # source://highline//lib/highline/list_renderer.rb#71
  def render; end

  private

  # source://highline//lib/highline/list_renderer.rb#212
  def actual_length(text); end

  # source://highline//lib/highline/list_renderer.rb#195
  def actual_lengths_for(line); end

  # source://highline//lib/highline/list_renderer.rb#243
  def col_count; end

  # source://highline//lib/highline/list_renderer.rb#238
  def col_count_calculate; end

  # source://highline//lib/highline/list_renderer.rb#180
  def get_col_widths(lines); end

  # source://highline//lib/highline/list_renderer.rb#185
  def get_row_widths(lines); end

  # source://highline//lib/highline/list_renderer.rb#189
  def get_segment_widths(lines); end

  # @return [Boolean]
  #
  # source://highline//lib/highline/list_renderer.rb#207
  def inside_line_size_limit?(widths); end

  # source://highline//lib/highline/list_renderer.rb#216
  def items_max_length; end

  # source://highline//lib/highline/list_renderer.rb#224
  def line_size_limit; end

  # source://highline//lib/highline/list_renderer.rb#120
  def list_columns_across_mode; end

  # source://highline//lib/highline/list_renderer.rb#124
  def list_columns_down_mode; end

  # source://highline//lib/highline/list_renderer.rb#106
  def list_default_mode; end

  # source://highline//lib/highline/list_renderer.rb#110
  def list_inline_mode; end

  # source://highline//lib/highline/list_renderer.rb#148
  def list_uneven_columns_down_mode; end

  # source://highline//lib/highline/list_renderer.rb#132
  def list_uneven_columns_mode(list = T.unsafe(nil)); end

  # source://highline//lib/highline/list_renderer.rb#220
  def max_length(items); end

  # source://highline//lib/highline/list_renderer.rb#253
  def pad_char; end

  # source://highline//lib/highline/list_renderer.rb#153
  def pad_uneven_rows(list, widths); end

  # source://highline//lib/highline/list_renderer.rb#92
  def render_list_items(items); end

  # source://highline//lib/highline/list_renderer.rb#174
  def right_pad_field(field, width); end

  # source://highline//lib/highline/list_renderer.rb#168
  def right_pad_row(row, widths); end

  # source://highline//lib/highline/list_renderer.rb#247
  def right_padded_items; end

  # source://highline//lib/highline/list_renderer.rb#257
  def row_count; end

  # source://highline//lib/highline/list_renderer.rb#234
  def row_join_str_size; end

  # source://highline//lib/highline/list_renderer.rb#228
  def row_join_string; end

  # Sets the attribute row_join_string
  #
  # @param value the value to set the attribute row_join_string to.
  #
  # source://highline//lib/highline/list_renderer.rb#232
  def row_join_string=(_arg0); end

  # source://highline//lib/highline/list_renderer.rb#164
  def row_to_s(row); end

  # source://highline//lib/highline/list_renderer.rb#160
  def stringfy_list(list); end

  # source://highline//lib/highline/list_renderer.rb#201
  def transpose(lines); end
end

# Menu objects encapsulate all the details of a call to
# {HighLine#choose HighLine#choose}.
# Using the accessors and {Menu#choice} and {Menu#choices}, the block passed
# to {HighLine#choose} can detail all aspects of menu display and control.
#
# source://highline//lib/highline/menu/item.rb#6
class HighLine::Menu < ::HighLine::Question
  # Create an instance of HighLine::Menu.  All customization is done
  # through the passed block, which should call accessors, {#choice} and
  # {#choices} as needed to define the Menu.  Note that Menus are also
  # {HighLine::Question Questions}, so all that functionality is available
  # to the block as well.
  #
  # @example Implicit menu creation through HighLine#choose
  #   cli = HighLine.new
  #   answer = cli.choose do |menu|
  #   menu.prompt = "Please choose your favorite programming language?  "
  #   menu.choice(:ruby) { say("Good choice!") }
  #   menu.choices(:python, :perl) { say("Not from around here, are you?") }
  #   end
  # @return [Menu] a new instance of Menu
  # @yield [_self]
  # @yieldparam _self [HighLine::Menu] the object that the method was called on
  #
  # source://highline//lib/highline/menu.rb#52
  def initialize; end

  # Adds an item directly to the menu. If you want more configuration
  # or options, use this method
  #
  # @param item [Menu::Item] item containing choice fields and more
  # @return [void]
  #
  # source://highline//lib/highline/menu.rb#217
  def add_item(item); end

  # source://highline//lib/highline/menu.rb#390
  def all_items; end

  # This method helps reduce the namespaces in the original call,
  # which would look like this: HighLine::Menu::Item.new(...)
  # With #build_item, it looks like this: menu.build_item(...)
  #
  # @param *args splat args, the same args you would pass to an
  #   initialization of HighLine::Menu::Item
  # @return [HighLine::Menu::Item] the menu item
  #
  # source://highline//lib/highline/menu.rb#206
  def build_item(*args); end

  # Adds _name_ to the list of available menu items.  Menu items will be
  # displayed in the order they are added.
  #
  # An optional _action_ can be associated with this name and if provided,
  # it will be called if the item is selected.  The result of the method
  # will be returned, unless _nil_on_handled_ is set (when you would get
  # +nil+ instead).  In _shell_ mode, a provided block will be passed the
  # command chosen and any details that followed the command.  Otherwise,
  # just the command is passed.  The <tt>@highline</tt> variable is set to
  # the current HighLine context before the action code is called and can
  # thus be used for adding output and the like.
  #
  # @example Use of help string on menu items
  #   cli = HighLine.new
  #   cli.choose do |menu|
  #   menu.shell = true
  #
  #   menu.choice(:load, text: 'Load a file',
  #   help: "Load a file using your favourite editor.")
  #   menu.choice(:save, help: "Save data in file.")
  #   menu.choice(:quit, help: "Exit program.")
  #
  #   menu.help("rules", "The rules of this system are as follows...")
  #   end
  # @example Implicit menu creation through HighLine#choose
  #   cli = HighLine.new
  #   answer = cli.choose do |menu|
  #   menu.prompt = "Please choose your favorite programming language?  "
  #   menu.choice(:ruby) { say("Good choice!") }
  #   menu.choices(:python, :perl) { say("Not from around here, are you?") }
  #   end
  # @param name [#to_s] menu item title/header/name to be displayed.
  # @param action [Proc] callback action to be run when the item is selected.
  # @param help [String] help/hint string to be displayed.
  # @return [void]
  #
  # source://highline//lib/highline/menu.rb#191
  def choice(name, help = T.unsafe(nil), text = T.unsafe(nil), &action); end

  # A shortcut for multiple calls to the sister method {#choice}.  <b>Be
  # warned:</b>  An _action_ set here will apply to *all* provided
  # _names_.  This is considered to be a feature, so you can easily
  # hand-off interface processing to a different chunk of code.
  # choice has more options available to you, like longer text or help (and
  # of course, individual actions)
  #
  # @example Implicit menu creation through HighLine#choose
  #   cli = HighLine.new
  #   answer = cli.choose do |menu|
  #   menu.prompt = "Please choose your favorite programming language?  "
  #   menu.choice(:ruby) { say("Good choice!") }
  #   menu.choices(:python, :perl) { say("Not from around here, are you?") }
  #   end
  # @param names [Array<#to_s>] menu item titles/headers/names to be
  #   displayed.
  # @param action [Proc] callback action to be run when the item is selected.
  # @return [void]
  #
  # source://highline//lib/highline/menu.rb#237
  def choices(*names, &action); end

  # source://highline//lib/highline/menu.rb#495
  def decorate_index(index); end

  # source://highline//lib/highline/menu.rb#512
  def decorate_item(text, ix); end

  # source://highline//lib/highline/menu.rb#418
  def find_item_from_selection(items, selection); end

  # This attribute is passed directly on as the mode to HighLine.list() by
  # all the preset layouts.  See that method for appropriate settings.
  #
  # source://highline//lib/highline/menu.rb#116
  def flow; end

  # This attribute is passed directly on as the mode to HighLine.list() by
  # all the preset layouts.  See that method for appropriate settings.
  #
  # source://highline//lib/highline/menu.rb#116
  def flow=(_arg0); end

  # source://highline//lib/highline/menu.rb#457
  def gather_selected(highline_context, selections, details = T.unsafe(nil)); end

  # Returns the menu item referenced by its title/header/name.
  #
  # @param selection [String] menu's title/header/name
  #
  # source://highline//lib/highline/menu.rb#434
  def get_item_by_letter(items, selection); end

  # Returns the menu item referenced by its index
  #
  # @param selection [Integer] menu item's index.
  #
  # source://highline//lib/highline/menu.rb#428
  def get_item_by_number(items, selection); end

  # Used by all the preset layouts to display title and/or introductory
  # information, when set.  Defaults to +nil+.
  #
  # source://highline//lib/highline/menu.rb#127
  def header; end

  # Used by all the preset layouts to display title and/or introductory
  # information, when set.  Defaults to +nil+.
  #
  # source://highline//lib/highline/menu.rb#127
  def header=(_arg0); end

  # Used to set help for arbitrary topics.  Use the topic <tt>"help"</tt>
  # to override the default message. Mainly for internal use.
  #
  # @param topic [String] the menu item header/title/name to be associated
  #   with a help message.
  # @param help [String] the help message to be associated with the menu
  #   item/title/name.
  #
  # source://highline//lib/highline/menu.rb#317
  def help(topic, help); end

  # Identical to {#choice}, but the item will not be listed for the user.
  #
  # @param name [#to_s] menu item title/header/name to be displayed.
  # @param help [String] help/hint string to be displayed.
  # @param action [Proc] callback action to be run when the item is selected.
  # @return [void]
  # @see #choice
  #
  # source://highline//lib/highline/menu.rb#248
  def hidden(name, help = T.unsafe(nil), &action); end

  # An _index_ to append to each menu item in display.  See
  # Menu.index=() for details.
  #
  # source://highline//lib/highline/menu.rb#92
  def index; end

  # Sets the indexing style for this Menu object.  Indexes are appended to
  # menu items, when displayed in list form.  The available settings are:
  #
  # <tt>:number</tt>::   Menu items will be indexed numerically, starting
  #                      with 1.  This is the default method of indexing.
  # <tt>:letter</tt>::   Items will be indexed alphabetically, starting
  #                      with a.
  # <tt>:none</tt>::     No index will be appended to menu items.
  # <i>any String</i>::  Will be used as the literal _index_.
  #
  # Setting the _index_ to <tt>:none</tt> or a literal String also adjusts
  # _index_suffix_ to a single space and _select_by_ to <tt>:name</tt>.
  # Because of this, you should make a habit of setting the _index_ first.
  #
  # source://highline//lib/highline/menu.rb#269
  def index=(style); end

  # The color of the index when displaying the menu. See Style class for
  # available colors.
  #
  # source://highline//lib/highline/menu.rb#158
  def index_color; end

  # The color of the index when displaying the menu. See Style class for
  # available colors.
  #
  # source://highline//lib/highline/menu.rb#158
  def index_color=(_arg0); end

  # The String placed between an _index_ and a menu item.  Defaults to
  # ". ".  Switches to " ", when _index_ is set to a String (like "-").
  #
  # source://highline//lib/highline/menu.rb#97
  def index_suffix; end

  # The String placed between an _index_ and a menu item.  Defaults to
  # ". ".  Switches to " ", when _index_ is set to a String (like "-").
  #
  # source://highline//lib/highline/menu.rb#97
  def index_suffix=(_arg0); end

  # Initializes the help system by adding a <tt>:help</tt> choice, some
  # action code, and the default help listing.
  #
  # source://highline//lib/highline/menu.rb#283
  def init_help; end

  # An ERb _layout_ to use when displaying this Menu object.  See
  # Menu.layout=() for details.
  #
  # source://highline//lib/highline/menu.rb#137
  def layout; end

  # Setting a _layout_ with this method also adjusts some other attributes
  # of the Menu object, to ideal defaults for the chosen _layout_.  To
  # account for that, you probably want to set a _layout_ first in your
  # configuration block, if needed.
  #
  # Accepted settings for _layout_ are:
  #
  # <tt>:list</tt>::         The default _layout_.  The _header_ if set
  #                          will appear at the top on its own line with
  #                          a trailing colon.  Then the list of menu
  #                          items will follow.  Finally, the _prompt_
  #                          will be used as the ask()-like question.
  # <tt>:one_line</tt>::     A shorter _layout_ that fits on one line.
  #                          The _header_ comes first followed by a
  #                          colon and spaces, then the _prompt_ with menu
  #                          items between trailing parenthesis.
  # <tt>:menu_only</tt>::    Just the menu items, followed up by a likely
  #                          short _prompt_.
  # <i>any ERb String</i>::  Will be taken as the literal _layout_.  This
  #                          String can access <tt>header</tt>,
  #                          <tt>menu</tt> and <tt>prompt</tt>, but is
  #                          otherwise evaluated in the TemplateRenderer
  #                          context so each method is properly delegated.
  #
  # If set to either <tt>:one_line</tt>, or <tt>:menu_only</tt>, _index_
  # will default to <tt>:none</tt> and _flow_ will default to
  # <tt>:inline</tt>.
  #
  # source://highline//lib/highline/menu.rb#350
  def layout=(new_layout); end

  # This setting is passed on as the third parameter to HighLine.list()
  # by all the preset layouts.  See that method for details of its
  # effects.  Defaults to +nil+.
  #
  # source://highline//lib/highline/menu.rb#122
  def list_option; end

  # This setting is passed on as the third parameter to HighLine.list()
  # by all the preset layouts.  See that method for details of its
  # effects.  Defaults to +nil+.
  #
  # source://highline//lib/highline/menu.rb#122
  def list_option=(_arg0); end

  # source://highline//lib/highline/menu.rb#376
  def map_items_by_index; end

  # source://highline//lib/highline/menu.rb#386
  def map_items_by_name; end

  # source://highline//lib/highline/menu.rb#517
  def mark_for_decoration(text, ix); end

  # When +true+, any selected item handled by provided action code will
  # return +nil+, instead of the results to the action code.  This may
  # prove handy when dealing with mixed menus where only the names of
  # items without any code (and +nil+, of course) will be returned.
  # Defaults to +false+.
  #
  # source://highline//lib/highline/menu.rb#153
  def nil_on_handled; end

  # When +true+, any selected item handled by provided action code will
  # return +nil+, instead of the results to the action code.  This may
  # prove handy when dealing with mixed menus where only the names of
  # items without any code (and +nil+, of course) will be returned.
  # Defaults to +false+.
  #
  # source://highline//lib/highline/menu.rb#153
  def nil_on_handled=(_arg0); end

  # This method returns all possible options for auto-completion, based
  # on the settings of _index_ and _select_by_.
  #
  # source://highline//lib/highline/menu.rb#365
  def options; end

  # source://highline//lib/highline/menu.rb#557
  def parse_list; end

  # Used by all the preset layouts to ask the actual question to fetch a
  # menu selection from the user.  Defaults to "?  ".
  #
  # source://highline//lib/highline/menu.rb#132
  def prompt; end

  # Used by all the preset layouts to ask the actual question to fetch a
  # menu selection from the user.  Defaults to "?  ".
  #
  # source://highline//lib/highline/menu.rb#132
  def prompt=(_arg0); end

  # This method processes the auto-completed user selection, based on the
  # rules for this Menu object.  If an action was provided for the
  # selection, it will be executed as described in {#choice}.
  #
  # @param highline_context [HighLine] a HighLine instance to be used
  #   as context.
  # @param selection [String, Integer] index or title of the selected
  #   menu item.
  # @param details additional parameter to be passed when in shell mode.
  # @return [nil, Object] if @nil_on_handled is set it returns +nil+,
  #   else it returns the action return value.
  #
  # source://highline//lib/highline/menu.rb#406
  def select(highline_context, selection, details = T.unsafe(nil)); end

  # The _select_by_ attribute controls how the user is allowed to pick a
  # menu item.  The available choices are:
  #
  # <tt>:index</tt>::          The user is allowed to type the numerical
  #                            or alphabetical index for their selection.
  # <tt>:index_or_name</tt>::  Allows both methods from the
  #                            <tt>:index</tt> option and the
  #                            <tt>:name</tt> option.
  # <tt>:name</tt>::           Menu items are selected by typing a portion
  #                            of the item name that will be
  #                            auto-completed.
  #
  # source://highline//lib/highline/menu.rb#111
  def select_by; end

  # The _select_by_ attribute controls how the user is allowed to pick a
  # menu item.  The available choices are:
  #
  # <tt>:index</tt>::          The user is allowed to type the numerical
  #                            or alphabetical index for their selection.
  # <tt>:index_or_name</tt>::  Allows both methods from the
  #                            <tt>:index</tt> option and the
  #                            <tt>:name</tt> option.
  # <tt>:name</tt>::           Menu items are selected by typing a portion
  #                            of the item name that will be
  #                            auto-completed.
  #
  # source://highline//lib/highline/menu.rb#111
  def select_by=(_arg0); end

  # When set to +true+, responses are allowed to be an entire line of
  # input, including details beyond the command itself.  Only the first
  # "word" of input will be matched against the menu choices, but both the
  # command selected and the rest of the line will be passed to provided
  # action blocks.  Defaults to +false+.
  #
  # source://highline//lib/highline/menu.rb#145
  def shell; end

  # When set to +true+, responses are allowed to be an entire line of
  # input, including details beyond the command itself.  Only the first
  # "word" of input will be matched against the menu choices, but both the
  # command selected and the rest of the line will be passed to provided
  # action blocks.  Defaults to +false+.
  #
  # source://highline//lib/highline/menu.rb#145
  def shell=(_arg0); end

  # source://highline//lib/highline/menu.rb#562
  def show_default_if_any; end

  # Allows Menu objects to pass as Arrays, for use with HighLine.list().
  # This method returns all menu items to be displayed, complete with
  # indexes.
  #
  # source://highline//lib/highline/menu.rb#508
  def to_ary; end

  # Allows Menu to behave as a String, just like Question.  Returns the
  # _layout_ to be rendered, which is used by HighLine.say().
  #
  # source://highline//lib/highline/menu.rb#535
  def to_s; end

  # This method will update the intelligent responses to account for
  # Menu specific differences.  Calls the superclass' (Question's)
  # build_responses method, overriding its default arguments to specify
  # 'options' will be used to populate choice lists.
  #
  # source://highline//lib/highline/menu.rb#572
  def update_responses; end

  # source://highline//lib/highline/menu.rb#471
  def value_for_array_selections(items, selections, details); end

  # source://highline//lib/highline/menu.rb#484
  def value_for_hash_selections(items, selections, details); end

  # source://highline//lib/highline/menu.rb#444
  def value_for_selected_item(item, details); end

  class << self
    # Returns the value of attribute index_color.
    #
    # source://highline//lib/highline/menu.rb#34
    def index_color; end

    # Sets the attribute index_color
    #
    # @param value the value to set the attribute index_color to.
    #
    # source://highline//lib/highline/menu.rb#26
    def index_color=(_arg0); end
  end
end

# Represents an Item of a HighLine::Menu.
#
# source://highline//lib/highline/menu/item.rb#7
class HighLine::Menu::Item
  # @option attributes
  # @option attributes
  # @option attributes
  # @param name [String] The name that is matched against the user input
  # @param attributes [Hash] options Hash to tailor menu item to your needs
  # @return [Item] a new instance of Item
  #
  # source://highline//lib/highline/menu/item.rb#19
  def initialize(name, attributes); end

  # Returns the value of attribute action.
  #
  # source://highline//lib/highline/menu/item.rb#8
  def action; end

  # Returns the value of attribute help.
  #
  # source://highline//lib/highline/menu/item.rb#8
  def help; end

  # source://highline//lib/highline/menu/item.rb#26
  def item_help; end

  # Returns the value of attribute name.
  #
  # source://highline//lib/highline/menu/item.rb#8
  def name; end

  # Returns the value of attribute text.
  #
  # source://highline//lib/highline/menu/item.rb#8
  def text; end
end

# Take the task of paginating some piece of text given a HighLine context
#
# source://highline//lib/highline/paginator.rb#5
class HighLine::Paginator
  # Returns a HighLine::Paginator instance where you can
  # call {#page_print} on it.
  #
  # @example
  #   HighLine::Paginator.new(highline).page_print(statement)
  # @param highline [HighLine] context
  # @return [Paginator] a new instance of Paginator
  #
  # source://highline//lib/highline/paginator.rb#14
  def initialize(highline); end

  # Ask user if they wish to continue paging output. Allows them to
  # type "q" to cancel the paging process.
  #
  # @return [Boolean]
  #
  # source://highline//lib/highline/paginator.rb#45
  def continue_paging?; end

  # @return [HighLine] HighLine context
  #
  # source://highline//lib/highline/paginator.rb#7
  def highline; end

  # Page print a series of at most _page_at_ lines for _output_.  After each
  # page is printed, HighLine will pause until the user presses enter/return
  # then display the next page of data.
  #
  # Note that the final page of _output_ is *not* printed, but returned
  # instead.  This is to support any special handling for the final sequence.
  #
  # @param text [String] text to be paginated
  # @return [String] last line if paging is aborted
  #
  # source://highline//lib/highline/paginator.rb#28
  def page_print(text); end
end

# Question objects contain all the details of a single invocation of
# HighLine.ask().  The object is initialized by the parameters passed to
# HighLine.ask() and then queried to make sure each step of the input
# process is handled according to the users wishes.
#
# source://highline//lib/highline/question/answer_converter.rb#6
class HighLine::Question
  include ::HighLine::CustomErrors

  # Create an instance of HighLine::Question.  Expects a _template_ to ask
  # (can be <tt>""</tt>) and an _answer_type_ to convert the answer to.
  # The _answer_type_ parameter must be a type recognized by
  # Question.convert(). If given, a block is yielded the new Question
  # object to allow custom initialization.
  #
  # @param template [String] any String
  # @param answer_type [Class] the type the answer will be converted to it.
  # @return [Question] a new instance of Question
  # @yield [_self]
  # @yieldparam _self [HighLine::Question] the object that the method was called on
  #
  # source://highline//lib/highline/question.rb#52
  def initialize(template, answer_type); end

  # Used to control range checks for answer.
  #
  # source://highline//lib/highline/question.rb#146
  def above; end

  # Used to control range checks for answer.
  #
  # source://highline//lib/highline/question.rb#146
  def above=(_arg0); end

  # The answer, set by HighLine#ask
  #
  # source://highline//lib/highline/question.rb#80
  def answer; end

  # The answer, set by HighLine#ask
  #
  # source://highline//lib/highline/question.rb#80
  def answer=(_arg0); end

  # Returns the provided _answer_string_ or the default answer for this
  # Question if a default was set and the answer is empty.
  #
  # @param answer_string [String]
  # @return [String] the answer itself or a default message.
  #
  # source://highline//lib/highline/question.rb#240
  def answer_or_default(answer_string); end

  # The type that will be used to convert this answer.
  #
  # source://highline//lib/highline/question.rb#83
  def answer_type; end

  # The type that will be used to convert this answer.
  #
  # source://highline//lib/highline/question.rb#83
  def answer_type=(_arg0); end

  # Provides the String to be asked when at an error situation.
  # It may be just the question itself (repeat on error).
  #
  # @return [self] if :ask_on_error on responses Hash is set to :question
  # @return [String] if :ask_on_error on responses Hash is set to
  #   something else
  #
  # source://highline//lib/highline/question.rb#566
  def ask_on_error_msg; end

  # Used to control range checks for answer.
  #
  # source://highline//lib/highline/question.rb#146
  def below; end

  # Used to control range checks for answer.
  #
  # source://highline//lib/highline/question.rb#146
  def below=(_arg0); end

  # Called late in the initialization process to build intelligent
  # responses based on the details of this Question object.
  # Also used by Menu#update_responses.
  #
  # @param message_source [Class] Array or String for example.
  #   Same as {#answer_type}.
  # @return [Hash] responses Hash winner (new and old merge).
  #
  # source://highline//lib/highline/question.rb#254
  def build_responses(message_source = T.unsafe(nil)); end

  # When updating the responses hash, it generates the new one.
  #
  # @param message_source [Class] Array or String for example.
  #   Same as {#answer_type}.
  # @return [Hash] responses hash
  #
  # source://highline//lib/highline/question.rb#273
  def build_responses_new_hash(message_source); end

  # Used to control character case processing for the answer to this question.
  # See HighLine::Question.change_case() for acceptable settings.
  #
  # source://highline//lib/highline/question.rb#136
  def case; end

  # Used to control character case processing for the answer to this question.
  # See HighLine::Question.change_case() for acceptable settings.
  #
  # source://highline//lib/highline/question.rb#136
  def case=(_arg0); end

  # Returns the provided _answer_string_ after changing character case by
  # the rules of this Question.  Valid settings for whitespace are:
  #
  # +nil+::                        Do not alter character case.
  #                                (Default.)
  # <tt>:up</tt>::                 Calls upcase().
  # <tt>:upcase</tt>::             Calls upcase().
  # <tt>:down</tt>::               Calls downcase().
  # <tt>:downcase</tt>::           Calls downcase().
  # <tt>:capitalize</tt>::         Calls capitalize().
  #
  # An unrecognized choice (like <tt>:none</tt>) is treated as +nil+.
  #
  # @param answer_string [String]
  # @return [String] upcased, downcased, capitalized
  #   or unchanged answer String.
  #
  # source://highline//lib/highline/question.rb#318
  def change_case(answer_string); end

  # Can be set to +true+ to use HighLine's cross-platform character reader
  # instead of fetching an entire line of input.  (Note: HighLine's character
  # reader *ONLY* supports STDIN on Windows and Unix.)  Can also be set to
  # <tt>:getc</tt> to use that method on the input stream.
  #
  # *WARNING*:  The _echo_ and _overwrite_ attributes for a question are
  # ignored when using the <tt>:getc</tt> method.
  #
  # source://highline//lib/highline/question.rb#95
  def character; end

  # Can be set to +true+ to use HighLine's cross-platform character reader
  # instead of fetching an entire line of input.  (Note: HighLine's character
  # reader *ONLY* supports STDIN on Windows and Unix.)  Can also be set to
  # <tt>:getc</tt> to use that method on the input stream.
  #
  # *WARNING*:  The _echo_ and _overwrite_ attributes for a question are
  # ignored when using the <tt>:getc</tt> method.
  #
  # source://highline//lib/highline/question.rb#95
  def character=(_arg0); end

  # Run {#in_range?} and raise an error if not succesful
  #
  # @raise [NotInRangeQuestionError]
  #
  # source://highline//lib/highline/question.rb#364
  def check_range; end

  # Try to auto complete answer_string
  #
  # @param answer_string [String]
  # @raise [NoAutoCompleteMatch]
  # @return [String]
  #
  # source://highline//lib/highline/question.rb#371
  def choices_complete(answer_string); end

  # For Auto-completion
  #
  # source://highline//lib/highline/question.rb#85
  def completion; end

  # For Auto-completion
  #
  # source://highline//lib/highline/question.rb#85
  def completion=(_arg0); end

  # Asks a yes or no confirmation question, to ensure a user knows what
  # they have just agreed to.  The confirm attribute can be set to :
  # +true+  :     In this case the question will be, "Are you sure?".
  # Proc    :     The Proc is yielded the answer given. The Proc must
  #               output a string which is then used as the confirm
  #               question.
  # String  :     The String must use ERB syntax. The String is
  #               evaluated with access to question and answer and
  #               is then used as the confirm question.
  # When set to +false+ or +nil+ (the default), answers are not confirmed.
  #
  # source://highline//lib/highline/question.rb#160
  def confirm; end

  # Asks a yes or no confirmation question, to ensure a user knows what
  # they have just agreed to.  The confirm attribute can be set to :
  # +true+  :     In this case the question will be, "Are you sure?".
  # Proc    :     The Proc is yielded the answer given. The Proc must
  #               output a string which is then used as the confirm
  #               question.
  # String  :     The String must use ERB syntax. The String is
  #               evaluated with access to question and answer and
  #               is then used as the confirm question.
  # When set to +false+ or +nil+ (the default), answers are not confirmed.
  #
  # source://highline//lib/highline/question.rb#160
  def confirm=(_arg0); end

  # Returns the String to be shown when asking for an answer confirmation.
  #
  # @param highline [HighLine] context
  # @return [String] default "Are you sure?" if {#confirm} is +true+
  # @return [String] {#confirm} rendered as a template if it is a String
  #
  # source://highline//lib/highline/question.rb#543
  def confirm_question(highline); end

  # Transforms the given _answer_string_ into the expected type for this
  # Question.  Currently supported conversions are:
  #
  # <tt>[...]</tt>::         Answer must be a member of the passed Array.
  #                          Auto-completion is used to expand partial
  #                          answers.
  # <tt>lambda {...}</tt>::  Answer is passed to lambda for conversion.
  # Date::                   Date.parse() is called with answer.
  # DateTime::               DateTime.parse() is called with answer.
  # File::                   The entered file name is auto-completed in
  #                          terms of _directory_ + _glob_, opened, and
  #                          returned.
  # Float::                  Answer is converted with Kernel.Float().
  # Integer::                Answer is converted with Kernel.Integer().
  # +nil+::                  Answer is left in String format.  (Default.)
  # Pathname::               Same as File, save that a Pathname object is
  #                          returned.
  # String::                 Answer is converted with Kernel.String().
  # HighLine::String::       Answer is converted with HighLine::String()
  # Regexp::                 Answer is fed to Regexp.new().
  # Symbol::                 The method to_sym() is called on answer and
  #                          the result returned.
  # <i>any other Class</i>:: The answer is passed on to
  #                          <tt>Class.parse()</tt>.
  #
  # This method throws ArgumentError, if the conversion cannot be
  # completed for any reason.
  #
  # source://highline//lib/highline/question.rb#359
  def convert; end

  # Used to provide a default answer to this question.
  #
  # source://highline//lib/highline/question.rb#138
  def default; end

  # Used to provide a default answer to this question.
  #
  # source://highline//lib/highline/question.rb#138
  def default=(_arg0); end

  # source://highline//lib/highline/question.rb#263
  def default_responses_hash; end

  # The directory from which a user will be allowed to select files, when
  # File or Pathname is specified as an _answer_type_.  Initially set to
  # <tt>Pathname.new(File.expand_path(File.dirname($0)))</tt>.
  #
  # source://highline//lib/highline/question.rb#193
  def directory; end

  # The directory from which a user will be allowed to select files, when
  # File or Pathname is specified as an _answer_type_.  Initially set to
  # <tt>Pathname.new(File.expand_path(File.dirname($0)))</tt>.
  #
  # source://highline//lib/highline/question.rb#193
  def directory=(_arg0); end

  # Can be set to +true+ or +false+ to control whether or not input will
  # be echoed back to the user.  A setting of +true+ will cause echo to
  # match input, but any other true value will be treated as a String to
  # echo for each character typed.
  #
  # This requires HighLine's character reader.  See the _character_
  # attribute for details.
  #
  # *Note*:  When using HighLine to manage echo on Unix based systems, we
  # recommend installing the termios gem.  Without it, it's possible to type
  # fast enough to have letters still show up (when reading character by
  # character only).
  #
  # source://highline//lib/highline/question.rb#116
  def echo; end

  # Can be set to +true+ or +false+ to control whether or not input will
  # be echoed back to the user.  A setting of +true+ will cause echo to
  # match input, but any other true value will be treated as a String to
  # echo for each character typed.
  #
  # This requires HighLine's character reader.  See the _character_
  # attribute for details.
  #
  # *Note*:  When using HighLine to manage echo on Unix based systems, we
  # recommend installing the termios gem.  Without it, it's possible to type
  # fast enough to have letters still show up (when reading character by
  # character only).
  #
  # source://highline//lib/highline/question.rb#116
  def echo=(_arg0); end

  # Returns an English explanation of the current range settings.
  #
  # source://highline//lib/highline/question.rb#381
  def expected_range; end

  # source://highline//lib/highline/question.rb#292
  def final_response(error); end

  # This is the actual responses hash that gets used in determining output
  # Notice that we give @user_responses precedence over the responses
  # generated internally via build_response
  #
  # source://highline//lib/highline/question.rb#288
  def final_responses; end

  # Returns _first_answer_, which will be unset following this call.
  #
  # source://highline//lib/highline/question.rb#397
  def first_answer; end

  # When set to a non *nil* value, this will be tried as an answer to the
  # question.  If this answer passes validations, it will become the result
  # without the user ever being prompted.  Otherwise this value is discarded,
  # and this Question is resolved as a normal call to HighLine.ask().
  #
  # source://highline//lib/highline/question.rb#187
  def first_answer=(_arg0); end

  # Returns true if _first_answer_ is set.
  #
  # @return [Boolean]
  #
  # source://highline//lib/highline/question.rb#404
  def first_answer?; end

  # Convert to String, remove whitespace and change case
  # when necessary
  #
  # @param answer_string [String]
  # @return [String] converted String
  #
  # source://highline//lib/highline/question.rb#462
  def format_answer(answer_string); end

  # When set, the user will be prompted for multiple answers which will
  # be collected into an Array or Hash and returned as the final answer.
  #
  # You can set _gather_ to an Integer to have an Array of exactly that
  # many answers collected, or a String/Regexp to match an end input which
  # will not be returned in the Array.
  #
  # Optionally _gather_ can be set to a Hash.  In this case, the question
  # will be asked once for each key and the answers will be returned in a
  # Hash, mapped by key.  The <tt>@key</tt> variable is set before each
  # question is evaluated, so you can use it in your question.
  #
  # source://highline//lib/highline/question.rb#174
  def gather; end

  # When set, the user will be prompted for multiple answers which will
  # be collected into an Array or Hash and returned as the final answer.
  #
  # You can set _gather_ to an Integer to have an Array of exactly that
  # many answers collected, or a String/Regexp to match an end input which
  # will not be returned in the Array.
  #
  # Optionally _gather_ can be set to a Hash.  In this case, the question
  # will be asked once for each key and the answers will be returned in a
  # Hash, mapped by key.  The <tt>@key</tt> variable is set before each
  # question is evaluated, so you can use it in your question.
  #
  # source://highline//lib/highline/question.rb#174
  def gather=(_arg0); end

  # Returns an echo string that is adequate for this Question settings.
  #
  # @param response [String]
  # @return [String] the response itself if {#echo} is +true+.
  # @return [String] echo character if {#echo} is truethy. Mainly a String.
  # @return [String] empty string if {#echo} is falsy.
  #
  # source://highline//lib/highline/question.rb#590
  def get_echo_for_response(response); end

  # Return a line or character of input, as requested for this question.
  # Character input will be returned as a single character String,
  # not an Integer.
  #
  # This question's _first_answer_ will be returned instead of input, if set.
  #
  # Raises EOFError if input is exhausted.
  #
  # @param highline [HighLine] context
  # @return [String] a character or line
  #
  # source://highline//lib/highline/question.rb#515
  def get_response(highline); end

  # Uses {#get_response} but returns a default answer
  # using {#answer_or_default} in case no answers was
  # returned.
  #
  # @param highline [HighLine] context
  # @return [String]
  #
  # source://highline//lib/highline/question.rb#535
  def get_response_or_default(highline); end

  # The glob pattern used to limit file selection when File or Pathname is
  # specified as an _answer_type_.  Initially set to <tt>"*"</tt>.
  #
  # source://highline//lib/highline/question.rb#198
  def glob; end

  # The glob pattern used to limit file selection when File or Pathname is
  # specified as an _answer_type_.  Initially set to <tt>"*"</tt>.
  #
  # source://highline//lib/highline/question.rb#198
  def glob=(_arg0); end

  # If set, answer must pass an include?() check on this object.
  #
  # source://highline//lib/highline/question.rb#148
  def in; end

  # If set, answer must pass an include?() check on this object.
  #
  # source://highline//lib/highline/question.rb#148
  def in=(_arg0); end

  # Returns +true+ if the _answer_object_ is greater than the _above_
  # attribute, less than the _below_ attribute and include?()ed in the
  # _in_ attribute.  Otherwise, +false+ is returned.  Any +nil+ attributes
  # are not checked.
  #
  # @return [Boolean]
  #
  # source://highline//lib/highline/question.rb#414
  def in_range?; end

  # Allows you to set a character limit for input.
  #
  # *WARNING*:  This option forces a character by character read.
  #
  # source://highline//lib/highline/question.rb#101
  def limit; end

  # Allows you to set a character limit for input.
  #
  # *WARNING*:  This option forces a character by character read.
  #
  # source://highline//lib/highline/question.rb#101
  def limit=(_arg0); end

  # When set to +true+ the question is asked, but output does not progress to
  # the next line.  The Cursor is moved back to the beginning of the question
  # line and it is cleared so that all the contents of the line disappear from
  # the screen.
  #
  # source://highline//lib/highline/question.rb#232
  def overwrite; end

  # When set to +true+ the question is asked, but output does not progress to
  # the next line.  The Cursor is moved back to the beginning of the question
  # line and it is cleared so that all the contents of the line disappear from
  # the screen.
  #
  # source://highline//lib/highline/question.rb#232
  def overwrite=(_arg0); end

  # Use the Readline library to fetch input.  This allows input editing as
  # well as keeping a history.  In addition, tab will auto-complete
  # within an Array of choices or a file listing.
  #
  # *WARNING*:  This option is incompatible with all of HighLine's
  # character reading  modes and it causes HighLine to ignore the
  # specified _input_ stream.
  #
  # source://highline//lib/highline/question.rb#126
  def readline; end

  # Use the Readline library to fetch input.  This allows input editing as
  # well as keeping a history.  In addition, tab will auto-complete
  # within an Array of choices or a file listing.
  #
  # *WARNING*:  This option is incompatible with all of HighLine's
  # character reading  modes and it causes HighLine to ignore the
  # specified _input_ stream.
  #
  # source://highline//lib/highline/question.rb#126
  def readline=(_arg0); end

  # Returns the provided _answer_string_ after processing whitespace by
  # the rules of this Question.  Valid settings for whitespace are:
  #
  # +nil+::                        Do not alter whitespace.
  # <tt>:strip</tt>::              Calls strip().  (Default.)
  # <tt>:chomp</tt>::              Calls chomp().
  # <tt>:collapse</tt>::           Collapses all whitespace runs to a
  #                                single space.
  # <tt>:strip_and_collapse</tt>:: Calls strip(), then collapses all
  #                                whitespace runs to a single space.
  # <tt>:chomp_and_collapse</tt>:: Calls chomp(), then collapses all
  #                                whitespace runs to a single space.
  # <tt>:remove</tt>::             Removes all whitespace.
  #
  # An unrecognized choice (like <tt>:none</tt>) is treated as +nil+.
  #
  # This process is skipped for single character input.
  #
  # @param answer_string [String]
  # @return [String] answer string with whitespaces removed
  #
  # source://highline//lib/highline/question.rb#441
  def remove_whitespace(answer_string); end

  # A Hash that stores the various responses used by HighLine to notify
  # the user.  The currently used responses and their purpose are as
  # follows:
  #
  # <tt>:ambiguous_completion</tt>::  Used to notify the user of an
  #                                   ambiguous answer the auto-completion
  #                                   system cannot resolve.
  # <tt>:ask_on_error</tt>::          This is the question that will be
  #                                   redisplayed to the user in the event
  #                                   of an error.  Can be set to
  #                                   <tt>:question</tt> to repeat the
  #                                   original question.
  # <tt>:invalid_type</tt>::          The error message shown when a type
  #                                   conversion fails.
  # <tt>:no_completion</tt>::         Used to notify the user that their
  #                                   selection does not have a valid
  #                                   auto-completion match.
  # <tt>:not_in_range</tt>::          Used to notify the user that a
  #                                   provided answer did not satisfy
  #                                   the range requirement tests.
  # <tt>:not_valid</tt>::             The error message shown when
  #                                   validation checks fail.
  #
  # source://highline//lib/highline/question.rb#223
  def responses; end

  # Returns an Array of valid answers to this question.  These answers are
  # only known when _answer_type_ is set to an Array of choices, File, or
  # Pathname.  Any other time, this method will return an empty Array.
  #
  # source://highline//lib/highline/question.rb#473
  def selection; end

  # readline() needs to handle its own output, but readline only supports
  # full line reading.  Therefore if question.echo is anything but true,
  # the prompt will not be issued. And we have to account for that now.
  # Also, JRuby-1.7's ConsoleReader.readLine() needs to be passed the prompt
  # to handle line editing properly.
  #
  # @param highline [HighLine] context
  # @return [void]
  #
  # source://highline//lib/highline/question.rb#581
  def show_question(highline); end

  # The ERb template of the question to be asked.
  #
  # source://highline//lib/highline/question.rb#77
  def template; end

  # The ERb template of the question to be asked.
  #
  # source://highline//lib/highline/question.rb#77
  def template=(_arg0); end

  # Stringifies the template to be asked.
  #
  # source://highline//lib/highline/question.rb#486
  def to_s; end

  # Returns +true+ if the provided _answer_string_ is accepted by the
  # _validate_ attribute or +false+ if it's not.
  #
  # It's important to realize that an answer is validated after whitespace
  # and case handling.
  #
  # @return [Boolean]
  #
  # source://highline//lib/highline/question.rb#497
  def valid_answer?; end

  # If set to a Regexp, the answer must match (before type conversion).
  # Can also be set to a Proc which will be called with the provided
  # answer to validate with a +true+ or +false+ return.
  #
  # source://highline//lib/highline/question.rb#144
  def validate; end

  # If set to a Regexp, the answer must match (before type conversion).
  # Can also be set to a Proc which will be called with the provided
  # answer to validate with a +true+ or +false+ return.
  #
  # source://highline//lib/highline/question.rb#144
  def validate=(_arg0); end

  # When set to +true+ multiple entries will be collected according to
  # the setting for _gather_, except they will be required to match
  # each other. Multiple identical entries will return a single answer.
  #
  # source://highline//lib/highline/question.rb#180
  def verify_match; end

  # When set to +true+ multiple entries will be collected according to
  # the setting for _gather_, except they will be required to match
  # each other. Multiple identical entries will return a single answer.
  #
  # source://highline//lib/highline/question.rb#180
  def verify_match=(_arg0); end

  # Used to control whitespace processing for the answer to this question.
  # See HighLine::Question.remove_whitespace() for acceptable settings.
  #
  # source://highline//lib/highline/question.rb#131
  def whitespace; end

  # Used to control whitespace processing for the answer to this question.
  # See HighLine::Question.remove_whitespace() for acceptable settings.
  #
  # source://highline//lib/highline/question.rb#131
  def whitespace=(_arg0); end

  private

  # Adds the default choice to the end of question between <tt>|...|</tt>.
  # Trailing whitespace is preserved so the function of HighLine.say() is
  # not affected.
  #
  # source://highline//lib/highline/question.rb#610
  def append_default; end

  # source://highline//lib/highline/question.rb#622
  def choice_error_str(message_source); end

  class << self
    # If _template_or_question_ is already a Question object just return it.
    # If not, build it.
    #
    # @param template_or_question [String, Question] what to ask
    # @param answer_type [Class] to what class to convert the answer
    # @param details to be passed to Question.new
    # @return [Question]
    #
    # source://highline//lib/highline/question.rb#35
    def build(template_or_question, answer_type = T.unsafe(nil), &details); end
  end
end

# It provides all answer conversion flow.
#
# source://highline//lib/highline/question/answer_converter.rb#8
class HighLine::Question::AnswerConverter
  extend ::Forwardable

  # It should be initialized with a Question object.
  # The class will get the answer from {Question#answer}
  # and then convert it to the proper {Question#answer_type}.
  # It is mainly used by {Question#convert}
  #
  # @param question [Question]
  # @return [AnswerConverter] a new instance of AnswerConverter
  #
  # source://highline//lib/highline/question/answer_converter.rb#21
  def initialize(question); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def answer(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def answer=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def answer_type(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def check_range(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def choices_complete(*args, **_arg1, &block); end

  # Based on the given Question object's settings,
  # it makes the conversion and returns the answer.
  #
  # @return [Object] the converted answer.
  #
  # source://highline//lib/highline/question/answer_converter.rb#28
  def convert; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def directory(*args, **_arg1, &block); end

  # @return [Array] answer converted to an Array
  #
  # source://highline//lib/highline/question/answer_converter.rb#80
  def to_array; end

  # @return [File] answer converted to a File
  #
  # source://highline//lib/highline/question/answer_converter.rb#68
  def to_file; end

  # @return [Float] answer converted to a Float
  #
  # source://highline//lib/highline/question/answer_converter.rb#53
  def to_float; end

  # @return [Integer] answer converted to an Integer
  #
  # source://highline//lib/highline/question/answer_converter.rb#48
  def to_integer; end

  # @return [Pathname] answer converted to an Pathname
  #
  # source://highline//lib/highline/question/answer_converter.rb#74
  def to_pathname; end

  # @return [Proc] answer converted to an Proc
  #
  # source://highline//lib/highline/question/answer_converter.rb#86
  def to_proc; end

  # @return [Regexp] answer converted to a Regexp
  #
  # source://highline//lib/highline/question/answer_converter.rb#63
  def to_regexp; end

  # @return [HighLine::String] answer converted to a HighLine::String
  #
  # source://highline//lib/highline/question/answer_converter.rb#37
  def to_string; end

  # @return [Symbol] answer converted to an Symbol
  #
  # source://highline//lib/highline/question/answer_converter.rb#58
  def to_symbol; end

  private

  # source://highline//lib/highline/question/answer_converter.rb#92
  def convert_by_answer_type; end
end

# Deals with the task of "asking" a question
#
# source://highline//lib/highline/question_asker.rb#5
class HighLine::QuestionAsker
  include ::HighLine::CustomErrors

  # To do its work QuestionAsker needs a Question
  # to be asked and a HighLine context where to
  # direct output.
  #
  # @param question [Question] question to be asked
  # @param highline [HighLine] context
  # @return [QuestionAsker] a new instance of QuestionAsker
  #
  # source://highline//lib/highline/question_asker.rb#17
  def initialize(question, highline); end

  # Gets just one answer, as opposed to #gather_answers
  #
  # @return [String] answer
  #
  # source://highline//lib/highline/question_asker.rb#26
  def ask_once; end

  # Collects an Array/Hash full of answers as described in
  # HighLine::Question.gather().
  #
  # @return [Array, Hash] answers
  #
  # source://highline//lib/highline/question_asker.rb#68
  def gather_answers; end

  # Gather multiple values and store them on a Hash
  # with keys provided by the Hash on {Question#gather}
  #
  # @return [Hash]
  #
  # source://highline//lib/highline/question_asker.rb#106
  def gather_hash; end

  # Gather multiple integer values based on {Question#gather} count
  #
  # @return [Array] answers
  #
  # source://highline//lib/highline/question_asker.rb#87
  def gather_integer; end

  # Gather multiple values until any of them matches the
  # {Question#gather} Regexp.
  #
  # @return [Array] answers
  #
  # source://highline//lib/highline/question_asker.rb#96
  def gather_regexp; end

  # @return [Question] question to be asked
  #
  # source://highline//lib/highline/question_asker.rb#7
  def question; end

  private

  # source://highline//lib/highline/question_asker.rb#131
  def answer_matches_regex(answer); end

  # Delegate to Highline
  #
  # source://highline//lib/highline/question_asker.rb#117
  def explain_error(explanation_key); end

  # source://highline//lib/highline/question_asker.rb#139
  def gather_answers_based_on_type; end

  # source://highline//lib/highline/question_asker.rb#122
  def gather_with_array; end
end

# A sample ColorScheme.
#
# source://highline//lib/highline/color_scheme.rb#131
class HighLine::SampleColorScheme < ::HighLine::ColorScheme
  # Builds the sample scheme with settings for <tt>:critical</tt>,
  # <tt>:error</tt>, <tt>:warning</tt>, <tt>:notice</tt>, <tt>:info</tt>,
  # <tt>:debug</tt>, <tt>:row_even</tt>, and <tt>:row_odd</tt> colors.
  #
  # @return [SampleColorScheme] a new instance of SampleColorScheme
  #
  # source://highline//lib/highline/color_scheme.rb#147
  def initialize(_h = T.unsafe(nil)); end
end

# source://highline//lib/highline/color_scheme.rb#132
HighLine::SampleColorScheme::SAMPLE_SCHEME = T.let(T.unsafe(nil), Hash)

# This class handles proper formatting based
# on a HighLine context, applying wrapping,
# pagination, indentation and color rendering
# when necessary. It's used by {HighLine#render_statement}
#
# @see HighLine#render_statement
#
# source://highline//lib/highline/statement.rb#13
class HighLine::Statement
  # It needs the input String and the HighLine context
  #
  # @param source [#to_s]
  # @param highline [HighLine] context
  # @return [Statement] a new instance of Statement
  #
  # source://highline//lib/highline/statement.rb#28
  def initialize(source, highline); end

  # The HighLine context
  #
  # @return [HighLine]
  #
  # source://highline//lib/highline/statement.rb#19
  def highline; end

  # The source object to be stringfied and formatted.
  #
  # source://highline//lib/highline/statement.rb#15
  def source; end

  # Returns the formated statement.
  # Applies wrapping, pagination, indentation and color rendering
  # based on HighLine instance settings.
  #
  # @return [String] formated statement
  #
  # source://highline//lib/highline/statement.rb#38
  def statement; end

  # The stringfied source object
  #
  # @return [String]
  #
  # source://highline//lib/highline/statement.rb#23
  def template_string; end

  # Returns the formated statement.
  # Applies wrapping, pagination, indentation and color rendering
  # based on HighLine instance settings.
  # Delegates to {#statement}
  #
  # @return [String] formated statement
  #
  # source://highline//lib/highline/statement.rb#44
  def to_s; end

  private

  # source://highline//lib/highline/statement.rb#58
  def format_statement; end

  # source://highline//lib/highline/statement.rb#72
  def render_template; end

  # source://highline//lib/highline/statement.rb#54
  def stringfy(template_string); end

  # source://highline//lib/highline/statement.rb#80
  def template; end

  class << self
    # source://highline//lib/highline/statement.rb#48
    def const_missing(constant); end
  end
end

# HighLine::String is a subclass of String with convenience methods added
# for colorization.
#
# Available convenience methods include:
#   * 'color' method         e.g.  highline_string.color(:bright_blue,
#                                                        :underline)
#   * colors                 e.g.  highline_string.magenta
#   * RGB colors             e.g.  highline_string.rgb_ff6000
#                             or   highline_string.rgb(255,96,0)
#   * background colors      e.g.  highline_string.on_magenta
#   * RGB background colors  e.g.  highline_string.on_rgb_ff6000
#                             or   highline_string.on_rgb(255,96,0)
#   * styles                 e.g.  highline_string.underline
#
# Additionally, convenience methods can be chained, for instance the
# following are equivalent:
#   highline_string.bright_blue.blink.underline
#   highline_string.color(:bright_blue, :blink, :underline)
#   HighLine.color(highline_string, :bright_blue, :blink, :underline)
#
# For those less squeamish about possible conflicts, the same convenience
# methods can be added to the built-in String class, as follows:
#
#  require 'highline'
#  Highline.colorize_strings
#
# source://highline//lib/highline/string.rb#33
class HighLine::String < ::String
  include ::HighLine::StringExtensions

  def black; end
  def blink; end
  def blue; end
  def bold; end
  def bright_black; end
  def bright_blue; end
  def bright_cyan; end
  def bright_gray; end
  def bright_green; end
  def bright_grey; end
  def bright_magenta; end
  def bright_none; end
  def bright_red; end
  def bright_white; end
  def bright_yellow; end
  def clear; end

  # source://highline//lib/highline/string_extensions.rb#33
  def color(*args); end

  def concealed; end
  def cyan; end
  def dark; end

  # source://highline//lib/highline/string_extensions.rb#33
  def foreground(*args); end

  def gray; end
  def green; end
  def grey; end
  def light_black; end
  def light_blue; end
  def light_cyan; end
  def light_gray; end
  def light_green; end
  def light_grey; end
  def light_magenta; end
  def light_none; end
  def light_red; end
  def light_white; end
  def light_yellow; end
  def magenta; end

  # source://highline//lib/highline/string_extensions.rb#62
  def method_missing(method, *_args); end

  def none; end

  # source://highline//lib/highline/string_extensions.rb#39
  def on(arg); end

  def on_black; end
  def on_blue; end
  def on_bright_black; end
  def on_bright_blue; end
  def on_bright_cyan; end
  def on_bright_gray; end
  def on_bright_green; end
  def on_bright_grey; end
  def on_bright_magenta; end
  def on_bright_none; end
  def on_bright_red; end
  def on_bright_white; end
  def on_bright_yellow; end
  def on_cyan; end
  def on_gray; end
  def on_green; end
  def on_grey; end
  def on_light_black; end
  def on_light_blue; end
  def on_light_cyan; end
  def on_light_gray; end
  def on_light_green; end
  def on_light_grey; end
  def on_light_magenta; end
  def on_light_none; end
  def on_light_red; end
  def on_light_white; end
  def on_light_yellow; end
  def on_magenta; end
  def on_none; end
  def on_red; end

  # source://highline//lib/highline/string_extensions.rb#55
  def on_rgb(*colors); end

  def on_white; end
  def on_yellow; end
  def red; end
  def reset; end
  def reverse; end

  # source://highline//lib/highline/string_extensions.rb#49
  def rgb(*colors); end

  # source://highline//lib/highline/string_extensions.rb#44
  def uncolor; end

  def underline; end
  def underscore; end
  def white; end
  def yellow; end

  private

  # source://highline//lib/highline/string_extensions.rb#71
  def respond_to_missing?(method_name, include_private = T.unsafe(nil)); end

  # source://highline//lib/highline/string_extensions.rb#77
  def setup_color_code(*colors); end
end

# HighLine extensions for String class.
# Included by HighLine::String.
#
# source://highline//lib/highline/string_extensions.rb#13
module HighLine::StringExtensions
  class << self
    # At include time, it defines all basic builtin styles.
    #
    # @param base [Class, Module] base Class/Module
    #
    # source://highline//lib/highline/string_extensions.rb#96
    def define_builtin_style_methods(base); end

    # At include time, it defines all basic style
    # support method like #color, #on, #uncolor,
    # #rgb, #on_rgb and the #method_missing callback
    #
    # @param base [Class, Module] the base class/module
    # @return [void]
    #
    # source://highline//lib/highline/string_extensions.rb#29
    def define_style_support_methods(base); end

    # Included hook. Actions to take when being included.
    #
    # @param base [Class, Module] base class
    #
    # source://highline//lib/highline/string_extensions.rb#18
    def included(base); end
  end
end

# source://highline//lib/highline/string_extensions.rb#14
HighLine::StringExtensions::STYLE_METHOD_NAME_PATTERN = T.let(T.unsafe(nil), Regexp)

# ANSI styles to be used by HighLine.
#
# source://highline//lib/highline/style.rb#68
class HighLine::Style
  # Single color/styles have :name, :code, :rgb (possibly), :builtin
  # Compound styles have :name, :list, :builtin
  #
  # @param defn [Hash] options for the Style to be created.
  # @return [Style] a new instance of Style
  #
  # source://highline//lib/highline/style.rb#204
  def initialize(defn = T.unsafe(nil)); end

  # @return [Integer] the BLUE component of the rgb code
  #
  # source://highline//lib/highline/style.rb#261
  def blue; end

  # @return [Style] a brighter version of this Style
  #
  # source://highline//lib/highline/style.rb#296
  def bright; end

  # @return [Boolean] true if the Style is builtin or not.
  #
  # source://highline//lib/highline/style.rb#198
  def builtin; end

  # @return [Boolean] true if the Style is builtin or not.
  #
  # source://highline//lib/highline/style.rb#198
  def builtin=(_arg0); end

  # @return [String] all codes of the Style list joined together
  #   (if a Style list)
  # @return [String] the Style code
  #
  # source://highline//lib/highline/style.rb#242
  def code; end

  # Uses the Style definition to add ANSI color escape codes
  # to a a given String
  #
  # @param string [String] to be colored
  # @return [String] an ANSI colored string
  #
  # source://highline//lib/highline/style.rb#235
  def color(string); end

  # Duplicate current Style using the same definition used to create it.
  #
  # @return [Style] duplicated Style
  #
  # source://highline//lib/highline/style.rb#222
  def dup; end

  # @return [Integer] the GREEN component of the rgb code
  #
  # source://highline//lib/highline/style.rb#256
  def green; end

  # @return [Style] a lighter version of this Style
  #
  # source://highline//lib/highline/style.rb#301
  def light; end

  # When a compound Style, returns a list of its components.
  #
  # @return [Array<Symbol>] components of a Style list
  #
  # source://highline//lib/highline/style.rb#192
  def list; end

  # Style name
  #
  # @return [Symbol] the name of the Style
  #
  # source://highline//lib/highline/style.rb#188
  def name; end

  # Uses the color as background and return a new style.
  #
  # @return [Style]
  #
  # source://highline//lib/highline/style.rb#290
  def on; end

  # @return [Integer] the RED component of the rgb code
  #
  # source://highline//lib/highline/style.rb#251
  def red; end

  # @return [Array] the three numerical rgb codes. Ex: [10, 12, 127]
  #
  # source://highline//lib/highline/style.rb#195
  def rgb; end

  # @return [Array] the three numerical rgb codes. Ex: [10, 12, 127]
  #
  # source://highline//lib/highline/style.rb#195
  def rgb=(_arg0); end

  # @return [Hash] the definition used to create this Style
  #
  # source://highline//lib/highline/style.rb#227
  def to_hash; end

  # Duplicate Style with some minor changes
  #
  # @param new_name [Symbol]
  # @param options [Hash] Style attributes to be changed
  # @return [Style] new Style with changed attributes
  #
  # source://highline//lib/highline/style.rb#269
  def variant(new_name, options = T.unsafe(nil)); end

  private

  # source://highline//lib/highline/style.rb#307
  def create_bright_variant(variant_name); end

  # source://highline//lib/highline/style.rb#321
  def find_style(name); end

  class << self
    # From an ANSI number (color escape code), craft an 'rgb_hex' code of it
    #
    # @param ansi_number [Integer] ANSI escape code
    # @return [String] all color codes joined as {.rgb_hex}
    #
    # source://highline//lib/highline/style.rb#157
    def ansi_rgb_to_hex(ansi_number); end

    # Clear all custom Styles, restoring the Style index to
    # builtin styles only.
    #
    # @return [void]
    #
    # source://highline//lib/highline/style.rb#92
    def clear_index; end

    # @return [Hash] list of all cached Style codes
    #
    # source://highline//lib/highline/style.rb#175
    def code_index; end

    # Index the given style.
    # Uses @code_index (Hash) as repository.
    #
    # @param style [Style]
    # @return [Style] the given style
    #
    # source://highline//lib/highline/style.rb#73
    def index(style); end

    # @return [Hash] list of all cached Styles
    #
    # source://highline//lib/highline/style.rb#170
    def list; end

    # Search for or create a new Style from the colors provided.
    #
    # @example Creating a new Style based on rgb code
    #   rgb_style = HighLine::Style.rgb(9, 10, 11)
    #
    #   rgb_style.name #  => :rgb_090a0b
    #   rgb_style.code #  => "\e[38;5;16m"
    #   rgb_style.rgb  #  => [9, 10, 11]
    # @param colors [Array<Numeric, String>] color codes
    # @return [Style] a Style with the rgb colors provided.
    #
    # source://highline//lib/highline/style.rb#133
    def rgb(*colors); end

    # Converts all given color codes to hexadecimal and
    # join them in a single string. If any given color code
    # is already a String, doesn't perform any convertion.
    #
    # @example
    #   HighLine::Style.rgb_hex(9, 10, "11") # => "090a11"
    # @param colors [Array<Numeric, String>] color codes
    # @return [String] all color codes joined
    #
    # source://highline//lib/highline/style.rb#107
    def rgb_hex(*colors); end

    # Returns the rgb number to be used as escape code on ANSI terminals.
    #
    # @param parts [Array<Numeric>] three numerical codes for red, green
    #   and blue
    # @return [Numeric] to be used as escape code on ANSI terminals
    #
    # source://highline//lib/highline/style.rb#147
    def rgb_number(*parts); end

    # Split an rgb code string into its 3 numerical compounds.
    #
    # @example
    #   HighLine::Style.rgb_parts("090A0B") # => [9, 10, 11]
    # @param hex [String] rgb code string like "010F0F"
    # @return [Array<Numeric>] numerical compounds like [1, 15, 15]
    #
    # source://highline//lib/highline/style.rb#119
    def rgb_parts(hex); end

    # Remove any ANSI color escape sequence of the given String.
    #
    # @param string [String]
    # @return [String]
    #
    # source://highline//lib/highline/style.rb#182
    def uncolor(string); end
  end
end

# Renders an erb template taking a {Question} and a {HighLine} instance
# as context.
#
# source://highline//lib/highline/template_renderer.rb#8
class HighLine::TemplateRenderer
  extend ::Forwardable

  # Initializes the TemplateRenderer object with its template and
  # HighLine and Question contexts.
  #
  # @param template [ERB] ERB template.
  # @param source [Question] question object.
  # @param highline [HighLine] HighLine instance.
  # @return [TemplateRenderer] a new instance of TemplateRenderer
  #
  # source://highline//lib/highline/template_renderer.rb#30
  def initialize(template, source, highline); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def answer(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def answer_type(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def color(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def header(*args, **_arg1, &block); end

  # @return [HighLine] HighLine instance used as context
  #
  # source://highline//lib/highline/template_renderer.rb#21
  def highline; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def key(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def list(*args, **_arg1, &block); end

  # @return [Question, Menu] {#source} attribute.
  #
  # source://highline//lib/highline/template_renderer.rb#51
  def menu; end

  # Returns an error message when the called method
  # is not available.
  #
  # @return [String] error message.
  #
  # source://highline//lib/highline/template_renderer.rb#44
  def method_missing(method, *args); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def prompt(*args, **_arg1, &block); end

  # @return [String] rendered template
  #
  # source://highline//lib/highline/template_renderer.rb#37
  def render; end

  # @return [Question, Menu] Question instance used as context
  #
  # source://highline//lib/highline/template_renderer.rb#18
  def source; end

  # @return [ERB] ERB template being rendered
  #
  # source://highline//lib/highline/template_renderer.rb#15
  def template; end

  class << self
    # If some constant is missing at this TemplateRenderer instance,
    # get it from HighLine. Useful to get color and style contants.
    #
    # @param name [Symbol] automatically passed constant's name as Symbol
    #
    # source://highline//lib/highline/template_renderer.rb#58
    def const_missing(name); end
  end
end

# Basic Terminal class which HighLine will direct
# input and output to.
# The specialized Terminals all decend from this HighLine::Terminal class
#
# source://highline//lib/highline/terminal.rb#18
class HighLine::Terminal
  # Creates a terminal instance based on given input and output streams.
  #
  # @param input [IO] input stream
  # @param output [IO] output stream
  # @return [Terminal] a new instance of Terminal
  #
  # source://highline//lib/highline/terminal.rb#46
  def initialize(input, output); end

  # Returns the class name as String. Useful for debuggin.
  #
  # @return [String] class name. Ex: "HighLine::Terminal::IOConsole"
  #
  # source://highline//lib/highline/terminal.rb#162
  def character_mode; end

  # Get one character from the terminal
  #
  # @return [String] one character
  #
  # source://highline//lib/highline/terminal.rb#78
  def get_character; end

  # Get one line from the terminal and format accordling.
  # Use readline if question has readline mode set.
  #
  # @param question [HighLine::Question]
  # @param highline [HighLine]
  #
  # source://highline//lib/highline/terminal.rb#84
  def get_line(question, highline); end

  # Get one line from terminal using default #gets method.
  #
  # @param highline [HighLine]
  # @raise [EOFError]
  #
  # source://highline//lib/highline/terminal.rb#135
  def get_line_default(highline); end

  # Get one line using #readline_read
  #
  # @param question [HighLine::Question]
  # @param highline [HighLine]
  #
  # source://highline//lib/highline/terminal.rb#97
  def get_line_with_readline(question, highline); end

  # An initialization callback.
  # It is called by {.get_terminal}.
  #
  # source://highline//lib/highline/terminal.rb#53
  def initialize_system_extensions; end

  # @return [IO] input stream
  #
  # source://highline//lib/highline/terminal.rb#38
  def input; end

  # Running on JRuby?
  #
  # @return [Boolean]
  #
  # source://highline//lib/highline/terminal.rb#144
  def jruby?; end

  # @return [IO] output stream
  #
  # source://highline//lib/highline/terminal.rb#41
  def output; end

  # Enter Raw No Echo mode.
  #
  # source://highline//lib/highline/terminal.rb#62
  def raw_no_echo_mode; end

  # Yieds a block to be executed in Raw No Echo mode and
  # then restore the terminal state.
  #
  # source://highline//lib/highline/terminal.rb#66
  def raw_no_echo_mode_exec; end

  # Use readline to read one line
  #
  # @param question [HighLine::Question] question from where to get
  #   autocomplete candidate strings
  #
  # source://highline//lib/highline/terminal.rb#112
  def readline_read(question); end

  # Restore terminal to its default mode
  #
  # source://highline//lib/highline/terminal.rb#74
  def restore_mode; end

  # Running on Rubinius?
  #
  # @return [Boolean]
  #
  # source://highline//lib/highline/terminal.rb#149
  def rubinius?; end

  # @return [Array<Integer, Integer>] two value terminal
  #   size like [columns, lines]
  #
  # source://highline//lib/highline/terminal.rb#57
  def terminal_size; end

  # Running on Windows?
  #
  # @return [Boolean]
  #
  # source://highline//lib/highline/terminal.rb#154
  def windows?; end

  private

  # Restores terminal state using shell stty command.
  #
  # source://highline//lib/highline/terminal.rb#186
  def restore_stty; end

  # Yield a block using stty shell commands to preserve the terminal state.
  #
  # source://highline//lib/highline/terminal.rb#169
  def run_preserving_stty; end

  # Saves terminal state using shell stty command.
  #
  # source://highline//lib/highline/terminal.rb#177
  def save_stty; end

  class << self
    # Probe for and return a suitable Terminal instance
    #
    # @param input [IO] input stream
    # @param output [IO] output stream
    #
    # source://highline//lib/highline/terminal.rb#22
    def get_terminal(input, output); end
  end
end

# io/console option for HighLine::Terminal.
# It's the most used terminal.
# TODO: We're rescuing when not a terminal.
#       We should make a more robust implementation.
#
# source://highline//lib/highline/terminal/io_console.rb#10
class HighLine::Terminal::IOConsole < ::HighLine::Terminal
  # Get one character from the terminal
  #
  # @return [String] one character
  #
  # source://highline//lib/highline/terminal/io_console.rb#29
  def get_character; end

  # Enter Raw No Echo mode.
  #
  # source://highline//lib/highline/terminal/io_console.rb#17
  def raw_no_echo_mode; end

  # Restore terminal to its default mode
  #
  # source://highline//lib/highline/terminal/io_console.rb#23
  def restore_mode; end

  # @return [Array<Integer, Integer>] two value terminal
  #   size like [columns, lines]
  #
  # source://highline//lib/highline/terminal/io_console.rb#11
  def terminal_size; end
end

# The version of the installed library.
#
# source://highline//lib/highline/version.rb#5
HighLine::VERSION = T.let(T.unsafe(nil), String)

# A simple Wrapper module that is aware of ANSI escape codes.
# It compensates for the ANSI escape codes so it works on the
# actual (visual) line length.
#
# source://highline//lib/highline/wrapper.rb#9
module HighLine::Wrapper
  class << self
    # Returns the length of the passed +string_with_escapes+, minus and color
    # sequence escapes.
    #
    # @param string_with_escapes [String] any ANSI colored String
    # @return [Integer] length based on the visual size of the String
    #   (without the escape codes)
    #
    # source://highline//lib/highline/wrapper.rb#49
    def actual_length(string_with_escapes); end

    # Wrap a sequence of _lines_ at _wrap_at_ characters per line.  Existing
    # newlines will not be affected by this process, but additional newlines
    # may be added.
    #
    # @param text [String] text to be wrapped
    # @param wrap_at [#to_i] column count to wrap the text into
    #
    # source://highline//lib/highline/wrapper.rb#17
    def wrap(text, wrap_at); end
  end
end

# When requiring 'highline/import' HighLine adds {#or_ask} to Object so
#   it is globally available.
#
# source://highline//lib/highline/import.rb#30
class Object < ::BasicObject
  include ::ActiveSupport::ForkTracker::CoreExt
  include ::Kernel
  include ::PP::ObjectMixin

  # Tries this object as a _first_answer_ for a HighLine::Question.  See that
  # attribute for details.
  #
  # *Warning*:  This Object will be passed to String() before set.
  #
  # @param args [Array<#to_s>]
  # @param details [lambda] block to be called with the question
  #   instance as argument.
  # @return [String] answer
  #
  # source://highline//lib/highline/import.rb#41
  def or_ask(*args, &details); end
end
