# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `hpricot` gem.
# Please instead update this file by running `bin/tapioca gem hpricot`.

# source://hpricot//lib/hpricot/tag.rb#1
module Hpricot
  class << self
    # Hpricot::XML parses <i>input</i>, disregarding all the HTML rules
    # and returning a document tree.
    #
    # source://hpricot//lib/hpricot/parse.rb#20
    def XML(input = T.unsafe(nil), opts = T.unsafe(nil), &blk); end

    def buffer_size; end
    def buffer_size=(_arg0); end

    # source://hpricot//lib/hpricot/builder.rb#15
    def build(ele = T.unsafe(nil), assigns = T.unsafe(nil), &blk); end

    def css(_arg0, _arg1, _arg2); end

    # :stopdoc:
    #
    # source://hpricot//lib/hpricot/parse.rb#27
    def make(input = T.unsafe(nil), opts = T.unsafe(nil), &blk); end

    # Hpricot.parse parses <i>input</i> and return a document tree.
    # represented by Hpricot::Doc.
    #
    # source://hpricot//lib/hpricot/parse.rb#14
    def parse(input = T.unsafe(nil), opts = T.unsafe(nil), &blk); end

    def scan(*_arg0); end

    # XML unescape
    #
    # source://hpricot//lib/hpricot/builder.rb#8
    def uxs(str); end
  end
end

# Common sets of attributes.
#
# source://hpricot//lib/hpricot/tags.rb#7
Hpricot::AttrCore = T.let(T.unsafe(nil), Array)

# source://hpricot//lib/hpricot/tags.rb#9
Hpricot::AttrEvents = T.let(T.unsafe(nil), Array)

# source://hpricot//lib/hpricot/tags.rb#11
Hpricot::AttrFocus = T.let(T.unsafe(nil), Array)

# source://hpricot//lib/hpricot/tags.rb#12
Hpricot::AttrHAlign = T.let(T.unsafe(nil), Array)

# source://hpricot//lib/hpricot/tags.rb#8
Hpricot::AttrI18n = T.let(T.unsafe(nil), Array)

# source://hpricot//lib/hpricot/tags.rb#13
Hpricot::AttrVAlign = T.let(T.unsafe(nil), Array)

# source://hpricot//lib/hpricot/tag.rb#41
class Hpricot::Attributes
  # @return [Attributes] a new instance of Attributes
  #
  # source://hpricot//lib/hpricot/tag.rb#43
  def initialize(e); end

  # source://hpricot//lib/hpricot/tag.rb#46
  def [](k); end

  # source://hpricot//lib/hpricot/tag.rb#49
  def []=(k, v); end

  # Returns the value of attribute element.
  #
  # source://hpricot//lib/hpricot/tag.rb#42
  def element; end

  # Sets the attribute element
  #
  # @param value the value to set the attribute element to.
  #
  # source://hpricot//lib/hpricot/tag.rb#42
  def element=(_arg0); end

  # source://hpricot//lib/hpricot/tag.rb#65
  def inspect; end

  # source://hpricot//lib/hpricot/tag.rb#52
  def to_hash; end

  # source://hpricot//lib/hpricot/tag.rb#62
  def to_s; end
end

# source://hpricot//lib/hpricot/tags.rb#14
Hpricot::Attrs = T.let(T.unsafe(nil), Array)

# BlankSlate provides an abstract base class with no predefined
# methods (except for <tt>\_\_send__</tt> and <tt>\_\_id__</tt>).
# BlankSlate is useful as a base class when writing classes that
# depend upon <tt>method_missing</tt> (e.g. dynamic proxies).
#
# source://hpricot//lib/hpricot/blankslate.rb#17
class Hpricot::BlankSlate
  class << self
    # Hide the method named +name+ in the BlankSlate class.  Don't
    # hide +instance_eval+ or any method beginning with "__".
    #
    # source://hpricot//lib/hpricot/blankslate.rb#22
    def hide(name); end
  end
end

# source://hpricot//lib/hpricot/tag.rb#124
class Hpricot::BogusETag
  include ::Hpricot
  include ::Hpricot::Node
  include ::Hpricot::Leaf
  include ::Hpricot::Traverse
  include ::Hpricot::Leaf::Trav
  include ::Hpricot::BogusETag::Trav

  # @return [BogusETag] a new instance of BogusETag
  #
  # source://hpricot//lib/hpricot/tag.rb#125
  def initialize(name); end

  def clear_raw; end

  # source://hpricot//lib/hpricot/tag.rb#126
  def output(out, opts = T.unsafe(nil)); end

  # source://hpricot//lib/hpricot/inspect.rb#90
  def pretty_print(q); end

  def raw_string; end
end

# source://hpricot//lib/hpricot/modules.rb#36
module Hpricot::BogusETag::Trav
  include ::Hpricot::Traverse
  include ::Hpricot::Leaf::Trav
end

# source://hpricot//lib/hpricot/builder.rb#24
module Hpricot::Builder
  # Write a +string+ to the HTML stream without escaping it.
  #
  # source://hpricot//lib/hpricot/builder.rb#55
  def <<(string); end

  def a(*args, &block); end
  def abbr(*args, &block); end
  def acronym(*args, &block); end

  # source://hpricot//lib/hpricot/builder.rb#42
  def add_child(ele); end

  def address(*args, &block); end
  def applet(*args, &block); end
  def area(*args, &block); end
  def b(*args, &block); end
  def base(*args, &block); end
  def basefont(*args, &block); end
  def bdo(*args, &block); end
  def big(*args, &block); end
  def blockquote(*args, &block); end
  def body(*args, &block); end
  def br(*args, &block); end

  # source://hpricot//lib/hpricot/builder.rb#121
  def build(*a, &b); end

  def button(*args, &block); end
  def caption(*args, &block); end
  def center(*args, &block); end
  def cite(*args, &block); end
  def code(*args, &block); end
  def col(*args, &block); end
  def colgroup(*args, &block); end

  # Write a +string+ to the HTML stream without escaping it.
  #
  # source://hpricot//lib/hpricot/builder.rb#55
  def concat(string); end

  def dd(*args, &block); end
  def del(*args, &block); end
  def dfn(*args, &block); end
  def dir(*args, &block); end
  def div(*args, &block); end
  def dl(*args, &block); end

  # source://hpricot//lib/hpricot/builder.rb#149
  def doctype(target, pub, sys); end

  def dt(*args, &block); end
  def em(*args, &block); end
  def fieldset(*args, &block); end
  def font(*args, &block); end
  def form(*args, &block); end
  def h1(*args, &block); end
  def h2(*args, &block); end
  def h3(*args, &block); end
  def h4(*args, &block); end
  def h5(*args, &block); end
  def h6(*args, &block); end

  # Builds a head tag.  Adds a <tt>meta</tt> tag inside with Content-Type
  # set to <tt>text/html; charset=utf-8</tt>.
  #
  # source://hpricot//lib/hpricot/builder.rb#157
  def head(*args, &block); end

  def hr(*args, &block); end
  def html(*args, &block); end

  # Every HTML tag method goes through an html_tag call.  So, calling <tt>div</tt> is equivalent
  # to calling <tt>html_tag(:div)</tt>.  All HTML tags in Hpricot's list are given generated wrappers
  # for this method.
  #
  # If the @auto_validation setting is on, this method will check for many common mistakes which
  # could lead to invalid XHTML.
  #
  # source://hpricot//lib/hpricot/builder.rb#131
  def html_tag(sym, *args, &block); end

  def i(*args, &block); end
  def iframe(*args, &block); end
  def img(*args, &block); end
  def input(*args, &block); end
  def ins(*args, &block); end
  def isindex(*args, &block); end
  def kbd(*args, &block); end
  def label(*args, &block); end
  def legend(*args, &block); end
  def li(*args, &block); end
  def link(*args, &block); end
  def map(*args, &block); end
  def menu(*args, &block); end
  def meta(*args, &block); end
  def noframes(*args, &block); end
  def noscript(*args, &block); end
  def object(*args, &block); end
  def ol(*args, &block); end
  def optgroup(*args, &block); end
  def option(*args, &block); end
  def p(*args, &block); end
  def param(*args, &block); end
  def pre(*args, &block); end
  def q(*args, &block); end
  def s(*args, &block); end
  def samp(*args, &block); end
  def script(*args, &block); end
  def select(*args, &block); end
  def small(*args, &block); end
  def span(*args, &block); end
  def strike(*args, &block); end
  def strong(*args, &block); end
  def style(*args, &block); end
  def sub(*args, &block); end
  def sup(*args, &block); end
  def table(*args, &block); end

  # Create a tag named +tag+. Other than the first argument which is the tag name,
  # the arguments are the same as the tags implemented via method_missing.
  #
  # source://hpricot//lib/hpricot/builder.rb#64
  def tag!(tag, *args, &block); end

  def tbody(*args, &block); end
  def td(*args, &block); end

  # Write a +string+ to the HTML stream without escaping it.
  #
  # source://hpricot//lib/hpricot/builder.rb#55
  def text(string); end

  # Write a +string+ to the HTML stream, making sure to escape it.
  #
  # source://hpricot//lib/hpricot/builder.rb#50
  def text!(string); end

  def textarea(*args, &block); end
  def tfoot(*args, &block); end
  def th(*args, &block); end
  def thead(*args, &block); end
  def title(*args, &block); end
  def tr(*args, &block); end
  def tt(*args, &block); end
  def u(*args, &block); end
  def ul(*args, &block); end
  def var(*args, &block); end

  # Builds an html tag with XHTML 1.0 Strict doctype instead.
  #
  # source://hpricot//lib/hpricot/builder.rb#173
  def xhtml_strict(attrs = T.unsafe(nil), &block); end

  # Builds an html tag.  An XML 1.0 instruction and an XHTML 1.0 Transitional doctype
  # are prepended.  Also assumes <tt>:xmlns => "http://www.w3.org/1999/xhtml",
  # :lang => "en"</tt>.
  #
  # source://hpricot//lib/hpricot/builder.rb#167
  def xhtml_transitional(attrs = T.unsafe(nil), &block); end

  private

  # source://hpricot//lib/hpricot/builder.rb#180
  def xhtml_html(attrs = T.unsafe(nil), &block); end

  class << self
    # source://hpricot//lib/hpricot/builder.rb#38
    def set(option, value); end
  end
end

# source://hpricot//lib/hpricot/tag.rb#152
class Hpricot::CData
  include ::Hpricot
  include ::Hpricot::Node
  include ::Hpricot::Leaf
  include ::Hpricot::Traverse
  include ::Hpricot::Leaf::Trav
  include ::Hpricot::CData::Trav

  # @return [CData] a new instance of CData
  #
  # source://hpricot//lib/hpricot/tag.rb#153
  def initialize(content); end

  def content; end
  def content=(_arg0); end
  def inner_text; end

  # source://hpricot//lib/hpricot/tag.rb#158
  def output(out, opts = T.unsafe(nil)); end

  # source://hpricot//lib/hpricot/tag.rb#157
  def raw_string; end

  def to_plain_text; end
  def to_s; end
end

# source://hpricot//lib/hpricot/modules.rb#30
module Hpricot::CData::Trav
  include ::Hpricot::Traverse
  include ::Hpricot::Leaf::Trav
end

# source://hpricot//lib/hpricot/tag.rb#207
class Hpricot::Comment
  include ::Hpricot
  include ::Hpricot::Node
  include ::Hpricot::Leaf
  include ::Hpricot::Traverse
  include ::Hpricot::Leaf::Trav
  include ::Hpricot::Comment::Trav

  def content; end
  def content=(_arg0); end

  # source://hpricot//lib/hpricot/tag.rb#210
  def output(out, opts = T.unsafe(nil)); end

  # source://hpricot//lib/hpricot/tag.rb#208
  def pathname; end

  # source://hpricot//lib/hpricot/tag.rb#209
  def raw_string; end
end

# source://hpricot//lib/hpricot/modules.rb#35
module Hpricot::Comment::Trav
  include ::Hpricot::Traverse
  include ::Hpricot::Leaf::Trav
end

# source://hpricot//lib/hpricot/modules.rb#12
module Hpricot::Container
  include ::Hpricot
  include ::Hpricot::Node
end

# :startdoc:
#
# source://hpricot//lib/hpricot/modules.rb#26
module Hpricot::Container::Trav
  include ::Hpricot::Traverse

  # Returns a list of CSS classes to which this element belongs.
  #
  # source://hpricot//lib/hpricot/traverse.rb#518
  def classes; end

  # Return all children of this node which can contain other
  # nodes.  This is a good way to get all HTML elements which
  # aren't text, comment, doctype or processing instruction nodes.
  #
  # source://hpricot//lib/hpricot/traverse.rb#404
  def containers; end

  # +each_child+ iterates over each child.
  #
  # source://hpricot//lib/hpricot/traverse.rb#498
  def each_child(&block); end

  # +each_child_with_index+ iterates over each child.
  #
  # source://hpricot//lib/hpricot/traverse.rb#504
  def each_child_with_index(&block); end

  # +each_hyperlink+ traverses hyperlinks such as HTML href attribute
  # of A element.
  #
  # It yields Hpricot::Text.
  #
  # Note that +each_hyperlink+ yields HTML href attribute of BASE element.
  #
  # source://hpricot//lib/hpricot/traverse.rb#614
  def each_hyperlink; end

  # +each_hyperlink_uri+ traverses hyperlinks such as HTML href attribute
  # of A element.
  #
  # It yields Hpricot::Text and URI for each hyperlink.
  #
  # The URI objects are created with a base URI which is given by
  # HTML BASE element or the argument ((|base_uri|)).
  # +each_hyperlink_uri+ doesn't yields href of the BASE element.
  #
  # source://hpricot//lib/hpricot/traverse.rb#591
  def each_hyperlink_uri(base_uri = T.unsafe(nil)); end

  # +each_uri+ traverses hyperlinks such as HTML href attribute
  # of A element.
  #
  # It yields URI for each hyperlink.
  #
  # The URI objects are created with a base URI which is given by
  # HTML BASE element or the argument ((|base_uri|)).
  #
  # source://hpricot//lib/hpricot/traverse.rb#628
  def each_uri(base_uri = T.unsafe(nil)); end

  # +filter+ rebuilds the tree without some components.
  #
  #   node.filter {|descendant_node| predicate } -> node
  #   loc.filter {|descendant_loc| predicate } -> node
  #
  # +filter+ yields each node except top node.
  # If given block returns false, corresponding node is dropped.
  # If given block returns true, corresponding node is retained and
  # inner nodes are examined.
  #
  # +filter+ returns an node.
  # It doesn't return location object even if self is location object.
  #
  # source://hpricot//lib/hpricot/traverse.rb#719
  def filter(&block); end

  # +find_element+ searches an element which universal name is specified by
  # the arguments.
  # It returns nil if not found.
  #
  # source://hpricot//lib/hpricot/traverse.rb#512
  def find_element(*names); end

  # Find sibling elements which follow the current one.   Like the other "sibling" methods, this weeds
  # out text and comment nodes.
  #
  # source://hpricot//lib/hpricot/traverse.rb#435
  def following_siblings; end

  # source://hpricot//lib/hpricot/traverse.rb#522
  def get_element_by_id(id); end

  # source://hpricot//lib/hpricot/traverse.rb#531
  def get_elements_by_tag_name(*a); end

  # Insert +nodes+, an array of HTML elements or a single element,
  # after the node +ele+, a child of the current node.
  #
  # source://hpricot//lib/hpricot/traverse.rb#486
  def insert_after(nodes, ele); end

  # Insert +nodes+, an array of HTML elements or a single element,
  # before the node +ele+, a child of the current node.
  #
  # source://hpricot//lib/hpricot/traverse.rb#474
  def insert_before(nodes, ele); end

  # Returns the container node neighboring this node to the south: just below it.
  # By "container" node, I mean: this method does not find text nodes or comments or cdata or any of that.
  # See Hpricot::Traverse#next_node if you need to hunt out all kinds of nodes.
  #
  # source://hpricot//lib/hpricot/traverse.rb#411
  def next_sibling; end

  # Find all preceding sibling elements.   Like the other "sibling" methods, this weeds
  # out text and comment nodes.
  #
  # source://hpricot//lib/hpricot/traverse.rb#427
  def preceding_siblings; end

  # Returns the container node neighboring this node to the north: just above it.
  # By "container" node, I mean: this method does not find text nodes or comments or cdata or any of that.
  # See Hpricot::Traverse#previous_node if you need to hunt out all kinds of nodes.
  #
  # source://hpricot//lib/hpricot/traverse.rb#419
  def previous_sibling; end

  # Replace +old+, a child of the current node, with +new+ node.
  #
  # source://hpricot//lib/hpricot/traverse.rb#467
  def replace_child(old, new); end

  # Puts together an array of neighboring sibling elements based on their proximity
  # to this element.
  #
  # This method accepts ranges and sets of numbers.
  #
  #    ele.siblings_at(-3..-1, 1..3) # gets three elements before and three after
  #    ele.siblings_at(1, 5, 7) # gets three elements at offsets below the current element
  #    ele.siblings_at(0, 5..6) # the current element and two others
  #
  # Like the other "sibling" methods, this doesn't find text and comment nodes.
  # Use nodes_at to include those nodes.
  #
  # source://hpricot//lib/hpricot/traverse.rb#452
  def siblings_at(*pos); end

  # source://hpricot//lib/hpricot/traverse.rb#688
  def traverse_text_internal(&block); end

  private

  # source://hpricot//lib/hpricot/traverse.rb#540
  def each_hyperlink_attribute; end
end

# source://hpricot//lib/hpricot/modules.rb#3
class Hpricot::Context
  include ::Hpricot
end

# Class used by Markaby::Builder to store element options.  Methods called
# against the CssProxy object are added as element classes or IDs.
#
# See the README for examples.
#
# source://hpricot//lib/hpricot/builder.rb#192
class Hpricot::CssProxy < ::Hpricot::BlankSlate
  # Creates a CssProxy object.
  #
  # @return [CssProxy] a new instance of CssProxy
  #
  # source://hpricot//lib/hpricot/builder.rb#195
  def initialize(builder, sym); end

  # Adds attributes to an element.  Bang methods set the :id attribute.
  # Other methods add to the :class attribute.
  #
  # source://hpricot//lib/hpricot/builder.rb#201
  def method_missing(id_or_class, *args, &block); end
end

# :stopdoc:
#
# source://hpricot//lib/hpricot/tag.rb#4
class Hpricot::Doc
  include ::Hpricot
  include ::Hpricot::Node
  include ::Hpricot::Container
  include ::Hpricot::Traverse
  include ::Hpricot::Container::Trav
  include ::Hpricot::Doc::Trav

  # source://hpricot//lib/hpricot/tag.rb#14
  def altered!; end

  # source://pp/0.3.0/pp.rb#356
  def inspect; end

  # source://hpricot//lib/hpricot/tag.rb#15
  def inspect_tree; end

  # source://hpricot//lib/hpricot/tag.rb#11
  def make(input = T.unsafe(nil), &blk); end

  # source://hpricot//lib/hpricot/tag.rb#5
  def output(out, opts = T.unsafe(nil)); end

  # source://hpricot//lib/hpricot/inspect.rb#13
  def pretty_print(q); end
end

# :stopdoc:
#
# source://hpricot//lib/hpricot/modules.rb#28
module Hpricot::Doc::Trav
  include ::Hpricot::Traverse
  include ::Hpricot::Container::Trav

  # +author+ searches author and return it as a text.
  # It returns nil if not found.
  #
  # +author+ searchs following information.
  #
  # - <meta name="author" content="author-name"> in HTML
  # - <link rev="made" title="author-name"> in HTML
  # - <dc:creator>author-name</dc:creator> in RSS
  # - <dc:publisher>author-name</dc:publisher> in RSS
  #
  # source://hpricot//lib/hpricot/traverse.rb#761
  def author; end

  # source://hpricot//lib/hpricot/traverse.rb#641
  def css_path; end

  # @raise [Hpricot::Error]
  #
  # source://hpricot//lib/hpricot/traverse.rb#805
  def root; end

  # +title+ searches title and return it as a text.
  # It returns nil if not found.
  #
  # +title+ searchs following information.
  #
  # - <title>...</title> in HTML
  # - <title>...</title> in RSS
  #
  # source://hpricot//lib/hpricot/traverse.rb#744
  def title; end

  # source://hpricot//lib/hpricot/traverse.rb#635
  def traverse_all_element(&block); end

  # source://hpricot//lib/hpricot/traverse.rb#660
  def traverse_some_element(name_set, &block); end

  # source://hpricot//lib/hpricot/traverse.rb#638
  def xpath; end
end

# source://hpricot//lib/hpricot/tag.rb#179
class Hpricot::DocType
  include ::Hpricot
  include ::Hpricot::Node
  include ::Hpricot::Leaf
  include ::Hpricot::Traverse
  include ::Hpricot::Leaf::Trav
  include ::Hpricot::DocType::Trav

  # @return [DocType] a new instance of DocType
  #
  # source://hpricot//lib/hpricot/tag.rb#180
  def initialize(target, pub, sys); end

  def clear_raw; end

  # source://hpricot//lib/hpricot/tag.rb#184
  def output(out, opts = T.unsafe(nil)); end

  # source://hpricot//lib/hpricot/tag.rb#183
  def pathname; end

  def public_id; end
  def public_id=(_arg0); end
  def raw_string; end
  def system_id; end
  def system_id=(_arg0); end
  def target; end
  def target=(_arg0); end
end

# source://hpricot//lib/hpricot/modules.rb#33
module Hpricot::DocType::Trav
  include ::Hpricot::Traverse
  include ::Hpricot::Leaf::Trav
end

# source://hpricot//lib/hpricot/tag.rb#131
class Hpricot::ETag < ::Hpricot::BogusETag
  include ::Hpricot::Tag

  # source://pp/0.3.0/pp.rb#356
  def inspect; end

  # source://hpricot//lib/hpricot/tag.rb#132
  def output(out, opts = T.unsafe(nil)); end

  # source://hpricot//lib/hpricot/inspect.rb#75
  def pretty_print(q); end
end

# source://hpricot//lib/hpricot/tag.rb#70
class Hpricot::Elem
  include ::Hpricot
  include ::Hpricot::Node
  include ::Hpricot::Container
  include ::Hpricot::Traverse
  include ::Hpricot::Container::Trav
  include ::Hpricot::Elem::Trav

  # @return [Elem] a new instance of Elem
  #
  # source://hpricot//lib/hpricot/tag.rb#71
  def initialize(tag, attrs = T.unsafe(nil), children = T.unsafe(nil), etag = T.unsafe(nil)); end

  # source://hpricot//lib/hpricot/tag.rb#76
  def attributes; end

  # source://hpricot//lib/hpricot/tag.rb#110
  def attributes_as_html; end

  def clear_raw; end

  # @return [Boolean]
  #
  # source://hpricot//lib/hpricot/tag.rb#75
  def empty?; end

  # source://pp/0.3.0/pp.rb#356
  def inspect; end

  # source://hpricot//lib/hpricot/tag.rb#118
  def inspect_tree(depth = T.unsafe(nil)); end

  # source://hpricot//lib/hpricot/tag.rb#93
  def output(out, opts = T.unsafe(nil)); end

  # source://hpricot//lib/hpricot/tag.rb#92
  def pathname; end

  # source://hpricot//lib/hpricot/inspect.rb#38
  def pretty_print(q); end

  # source://hpricot//lib/hpricot/inspect.rb#55
  def pretty_print_stag(q); end

  # source://hpricot//lib/hpricot/tag.rb#79
  def to_plain_text; end
end

# source://hpricot//lib/hpricot/modules.rb#29
module Hpricot::Elem::Trav
  include ::Hpricot::Traverse
  include ::Hpricot::Container::Trav

  # source://hpricot//lib/hpricot/traverse.rb#818
  def [](name); end

  # source://hpricot//lib/hpricot/traverse.rb#824
  def []=(name, val); end

  # source://hpricot//lib/hpricot/traverse.rb#818
  def get_attribute(name); end

  # @return [Boolean]
  #
  # source://hpricot//lib/hpricot/traverse.rb#815
  def has_attribute?(name); end

  # source://hpricot//lib/hpricot/traverse.rb#830
  def remove_attribute(name); end

  # source://hpricot//lib/hpricot/traverse.rb#824
  def set_attribute(name, val); end

  # @yield [_self]
  # @yieldparam _self [Hpricot::Elem::Trav] the object that the method was called on
  #
  # source://hpricot//lib/hpricot/traverse.rb#647
  def traverse_all_element(&block); end

  # @yield [_self]
  # @yieldparam _self [Hpricot::Elem::Trav] the object that the method was called on
  #
  # source://hpricot//lib/hpricot/traverse.rb#666
  def traverse_some_element(name_set, &block); end
end

# source://hpricot//lib/hpricot/htmlinfo.rb#59
Hpricot::ElementContent = T.let(T.unsafe(nil), Hash)

# source://hpricot//lib/hpricot/htmlinfo.rb#494
Hpricot::ElementExclusions = T.let(T.unsafe(nil), Hash)

# source://hpricot//lib/hpricot/htmlinfo.rb#486
Hpricot::ElementInclusions = T.let(T.unsafe(nil), Hash)

# :stopdoc:
#
# source://hpricot//lib/hpricot/elements.rb#52
class Hpricot::Elements < ::Array
  # Searches this list for the first element (or child of these elements) matching
  # the CSS or XPath expression +expr+.  Root is assumed to be the element scanned.
  #
  # See Hpricot::Container::Trav.at for more.
  #
  # source://hpricot//lib/hpricot/elements.rb#67
  def %(expr, &blk); end

  # Searches this list for any elements (or children of these elements) matching
  # the CSS or XPath expression +expr+.  Root is assumed to be the element scanned.
  #
  # See Hpricot::Container::Trav.search for more.
  #
  # source://hpricot//lib/hpricot/elements.rb#58
  def /(*expr, &blk); end

  # Adds the class to all matched elements.
  #
  #   (doc/"p").add_class("bacon")
  #
  # Now all paragraphs will have class="bacon".
  #
  # source://hpricot//lib/hpricot/elements.rb#226
  def add_class(class_name); end

  # Just after each element in this list, add some HTML.
  # Pass in an HTML +str+, which is turned into Hpricot elements.
  #
  # source://hpricot//lib/hpricot/elements.rb#154
  def after(str = T.unsafe(nil), &blk); end

  # Add to the end of the contents inside each element in this list.
  # Pass in an HTML +str+, which is turned into Hpricot elements.
  #
  # source://hpricot//lib/hpricot/elements.rb#136
  def append(str = T.unsafe(nil), &blk); end

  # Searches this list for the first element (or child of these elements) matching
  # the CSS or XPath expression +expr+.  Root is assumed to be the element scanned.
  #
  # See Hpricot::Container::Trav.at for more.
  #
  # source://hpricot//lib/hpricot/elements.rb#67
  def at(expr, &blk); end

  # Gets and sets attributes on all matched elements.
  #
  # Pass in a +key+ on its own and this method will return the string value
  # assigned to that attribute for the first elements.  Or +nil+ if the
  # attribute isn't found.
  #
  #   doc.search("a").attr("href")
  #     #=> "http://hacketyhack.net/"
  #
  # Or, pass in a +key+ and +value+.  This will set an attribute for all
  # matched elements.
  #
  #   doc.search("p").attr("class", "basic")
  #
  # You may also use a Hash to set a series of attributes:
  #
  #   (doc/"a").attr(:class => "basic", :href => "http://hackety.org/")
  #
  # Lastly, a block can be used to rewrite an attribute based on the element
  # it belongs to.  The block will pass in an element.  Return from the block
  # the new value of the attribute.
  #
  #   records.attr("href") { |e| e['href'] + "#top" }
  #
  # This example adds a <tt>#top</tt> anchor to each link.
  #
  # source://hpricot//lib/hpricot/elements.rb#205
  def attr(key, value = T.unsafe(nil), &blk); end

  # Add some HTML just previous to each element in this list.
  # Pass in an HTML +str+, which is turned into Hpricot elements.
  #
  # source://hpricot//lib/hpricot/elements.rb#148
  def before(str = T.unsafe(nil), &blk); end

  # Empty the elements in this list, by removing their insides.
  #
  #   doc = Hpricot("<p> We have <i>so much</i> to say.</p>")
  #   doc.search("i").empty
  #   doc.to_html
  #     => "<p> We have <i></i> to say.</p>"
  #
  # source://hpricot//lib/hpricot/elements.rb#130
  def empty; end

  # source://hpricot//lib/hpricot/elements.rb#351
  def filter(expr); end

  # Returns an HTML fragment built of the contents of each element in this list.
  #
  # If a HTML +string+ is supplied, this method acts like inner_html=.
  #
  # source://hpricot//lib/hpricot/elements.rb#86
  def html(*string); end

  # Replaces the contents of each element in this list.  Supply an HTML +string+,
  # which is loaded into Hpricot objects and inserted into every element in this
  # list.
  #
  # source://hpricot//lib/hpricot/elements.rb#99
  def html=(string); end

  # Returns an HTML fragment built of the contents of each element in this list.
  #
  # If a HTML +string+ is supplied, this method acts like inner_html=.
  #
  # source://hpricot//lib/hpricot/elements.rb#86
  def innerHTML(*string); end

  # Replaces the contents of each element in this list.  Supply an HTML +string+,
  # which is loaded into Hpricot objects and inserted into every element in this
  # list.
  #
  # source://hpricot//lib/hpricot/elements.rb#99
  def innerHTML=(string); end

  # Returns an HTML fragment built of the contents of each element in this list.
  #
  # If a HTML +string+ is supplied, this method acts like inner_html=.
  #
  # source://hpricot//lib/hpricot/elements.rb#86
  def inner_html(*string); end

  # Replaces the contents of each element in this list.  Supply an HTML +string+,
  # which is loaded into Hpricot objects and inserted into every element in this
  # list.
  #
  # source://hpricot//lib/hpricot/elements.rb#99
  def inner_html=(string); end

  # Returns an string containing the text contents of each element in this list.
  # All HTML tags are removed.
  #
  # source://hpricot//lib/hpricot/elements.rb#107
  def inner_text; end

  # source://pp/0.3.0/pp.rb#356
  def inspect; end

  # source://hpricot//lib/hpricot/elements.rb#356
  def not(expr); end

  # Add to the start of the contents inside each element in this list.
  # Pass in an HTML +str+, which is turned into Hpricot elements.
  #
  # source://hpricot//lib/hpricot/elements.rb#142
  def prepend(str = T.unsafe(nil), &blk); end

  # source://hpricot//lib/hpricot/inspect.rb#6
  def pretty_print(q); end

  # Remove all elements in this list from the document which contains them.
  #
  #   doc = Hpricot("<html>Remove this: <b>here</b></html>")
  #   doc.search("b").remove
  #   doc.to_html
  #     => "<html>Remove this: </html>"
  #
  # source://hpricot//lib/hpricot/elements.rb#119
  def remove; end

  # Remove an attribute from each of the matched elements.
  #
  #   (doc/"input").remove_attr("disabled")
  #
  # source://hpricot//lib/hpricot/elements.rb#239
  def remove_attr(name); end

  # Removes a class from all matched elements.
  #
  #   (doc/"span").remove_class("lightgrey")
  #
  # Or, to remove all classes:
  #
  #   (doc/"span").remove_class
  #
  # source://hpricot//lib/hpricot/elements.rb#255
  def remove_class(name = T.unsafe(nil)); end

  # Searches this list for any elements (or children of these elements) matching
  # the CSS or XPath expression +expr+.  Root is assumed to be the element scanned.
  #
  # See Hpricot::Container::Trav.search for more.
  #
  # source://hpricot//lib/hpricot/elements.rb#58
  def search(*expr, &blk); end

  # Gets and sets attributes on all matched elements.
  #
  # Pass in a +key+ on its own and this method will return the string value
  # assigned to that attribute for the first elements.  Or +nil+ if the
  # attribute isn't found.
  #
  #   doc.search("a").attr("href")
  #     #=> "http://hacketyhack.net/"
  #
  # Or, pass in a +key+ and +value+.  This will set an attribute for all
  # matched elements.
  #
  #   doc.search("p").attr("class", "basic")
  #
  # You may also use a Hash to set a series of attributes:
  #
  #   (doc/"a").attr(:class => "basic", :href => "http://hackety.org/")
  #
  # Lastly, a block can be used to rewrite an attribute based on the element
  # it belongs to.  The block will pass in an element.  Return from the block
  # the new value of the attribute.
  #
  #   records.attr("href") { |e| e['href'] + "#top" }
  #
  # This example adds a <tt>#top</tt> anchor to each link.
  #
  # source://hpricot//lib/hpricot/elements.rb#205
  def set(key, value = T.unsafe(nil), &blk); end

  # Returns an string containing the text contents of each element in this list.
  # All HTML tags are removed.
  #
  # source://hpricot//lib/hpricot/elements.rb#107
  def text; end

  # Convert this group of elements into a complete HTML fragment, returned as a
  # string.
  #
  # source://hpricot//lib/hpricot/elements.rb#78
  def to_html; end

  # Convert this group of elements into a complete HTML fragment, returned as a
  # string.
  #
  # source://hpricot//lib/hpricot/elements.rb#78
  def to_s; end

  # Wraps each element in the list inside the element created by HTML +str+.
  # If more than one element is found in the string, Hpricot locates the
  # deepest spot inside the first element.
  #
  #  doc.search("a[@href]").
  #      wrap(%{<div class="link"><div class="link_inner"></div></div>})
  #
  # This code wraps every link on the page inside a +div.link+ and a +div.link_inner+ nest.
  #
  # source://hpricot//lib/hpricot/elements.rb#166
  def wrap(str = T.unsafe(nil), &blk); end

  private

  # source://hpricot//lib/hpricot/elements.rb#366
  def copy_node(node, l); end

  class << self
    # Given two elements, attempt to gather an Elements array of everything between
    # (and including) those two elements.
    #
    # source://hpricot//lib/hpricot/elements.rb#319
    def expand(ele1, ele2, excl = T.unsafe(nil)); end

    # source://hpricot//lib/hpricot/elements.rb#274
    def filter(nodes, expr, truth = T.unsafe(nil)); end
  end
end

# " (for emacs)
#
# source://hpricot//lib/hpricot/elements.rb#268
Hpricot::Elements::ATTR_RE = T.let(T.unsafe(nil), Regexp)

# source://hpricot//lib/hpricot/elements.rb#269
Hpricot::Elements::BRACK_RE = T.let(T.unsafe(nil), Regexp)

# source://hpricot//lib/hpricot/elements.rb#272
Hpricot::Elements::CATCH_RE = T.let(T.unsafe(nil), Regexp)

# source://hpricot//lib/hpricot/elements.rb#271
Hpricot::Elements::CUST_RE = T.let(T.unsafe(nil), Regexp)

# source://hpricot//lib/hpricot/elements.rb#270
Hpricot::Elements::FUNC_RE = T.let(T.unsafe(nil), Regexp)

# Exception class used for any errors related to deficiencies in the system when
# handling the character encodings of a document.
#
# source://hpricot//lib/hpricot/parse.rb#10
class Hpricot::EncodingError < ::StandardError; end

# source://hpricot//lib/hpricot/modules.rb#38
class Hpricot::Error < ::StandardError; end

# source://hpricot//lib/hpricot/tags.rb#3
Hpricot::FORM_TAGS = T.let(T.unsafe(nil), Array)

# source://hpricot//lib/hpricot/modules.rb#16
module Hpricot::Leaf
  include ::Hpricot
  include ::Hpricot::Node

  # source://pp/0.3.0/pp.rb#356
  def inspect; end

  # source://hpricot//lib/hpricot/inspect.rb#20
  def pretty_print(q); end
end

# source://hpricot//lib/hpricot/modules.rb#27
module Hpricot::Leaf::Trav
  include ::Hpricot::Traverse

  # @yield [_self]
  # @yieldparam _self [Hpricot::Leaf::Trav] the object that the method was called on
  #
  # source://hpricot//lib/hpricot/traverse.rb#654
  def traverse_all_element; end

  # source://hpricot//lib/hpricot/traverse.rb#673
  def traverse_some_element(name_set); end

  # source://hpricot//lib/hpricot/traverse.rb#694
  def traverse_text_internal; end
end

# source://hpricot//lib/hpricot/modules.rb#2
class Hpricot::Name
  include ::Hpricot
end

# :stopdoc:
#
# source://hpricot//lib/hpricot/htmlinfo.rb#4
Hpricot::NamedCharacters = T.let(T.unsafe(nil), Hash)

# source://hpricot//lib/hpricot/htmlinfo.rb#57
Hpricot::NamedCharactersPattern = T.let(T.unsafe(nil), Regexp)

# :startdoc:
#
# source://hpricot//lib/hpricot/tag.rb#20
module Hpricot::Node
  include ::Hpricot

  # source://hpricot//lib/hpricot/tag.rb#33
  def altered!; end

  # source://hpricot//lib/hpricot/tag.rb#24
  def clear_raw; end

  # source://hpricot//lib/hpricot/tag.rb#21
  def html_quote(str); end

  # source://hpricot//lib/hpricot/tag.rb#25
  def if_output(opts); end

  # source://hpricot//lib/hpricot/tag.rb#36
  def inspect_tree(depth = T.unsafe(nil)); end

  # source://hpricot//lib/hpricot/tag.rb#32
  def pathname; end
end

# source://hpricot//lib/hpricot/htmlinfo.rb#519
Hpricot::OmittedAttrName = T.let(T.unsafe(nil), Hash)

class Hpricot::ParseError < ::StandardError; end

# source://hpricot//lib/hpricot/tag.rb#194
class Hpricot::ProcIns
  include ::Hpricot
  include ::Hpricot::Node
  include ::Hpricot::Leaf
  include ::Hpricot::Traverse
  include ::Hpricot::Leaf::Trav
  include ::Hpricot::ProcIns::Trav

  def content; end
  def content=(_arg0); end

  # source://hpricot//lib/hpricot/tag.rb#197
  def output(out, opts = T.unsafe(nil)); end

  # source://hpricot//lib/hpricot/tag.rb#195
  def pathname; end

  # source://hpricot//lib/hpricot/tag.rb#196
  def raw_string; end

  def target; end
  def target=(_arg0); end
end

# source://hpricot//lib/hpricot/modules.rb#34
module Hpricot::ProcIns::Trav
  include ::Hpricot::Traverse
  include ::Hpricot::Leaf::Trav
end

Hpricot::ProcInsParse = T.let(T.unsafe(nil), Regexp)

# source://hpricot//lib/hpricot/tags.rb#4
Hpricot::SELF_CLOSING_TAGS = T.let(T.unsafe(nil), Array)

# :stopdoc:
#
# source://hpricot//lib/hpricot/modules.rb#6
module Hpricot::Tag
  include ::Hpricot
end

# source://hpricot//lib/hpricot/tag.rb#135
class Hpricot::Text
  include ::Hpricot
  include ::Hpricot::Node
  include ::Hpricot::Leaf
  include ::Hpricot::Traverse
  include ::Hpricot::Leaf::Trav
  include ::Hpricot::Text::Trav

  # @return [Text] a new instance of Text
  #
  # source://hpricot//lib/hpricot/tag.rb#136
  def initialize(content); end

  # source://hpricot//lib/hpricot/tag.rb#143
  def <<(str); end

  def clear_raw; end
  def content; end
  def content=(_arg0); end

  # source://hpricot//lib/hpricot/tag.rb#138
  def inner_text; end

  # source://hpricot//lib/hpricot/tag.rb#144
  def output(out, opts = T.unsafe(nil)); end

  # source://hpricot//lib/hpricot/tag.rb#137
  def pathname; end

  # source://hpricot//lib/hpricot/inspect.rb#84
  def pretty_print(q); end

  def raw_string; end

  # source://hpricot//lib/hpricot/tag.rb#138
  def to_plain_text; end

  # source://hpricot//lib/hpricot/tag.rb#138
  def to_s; end
end

# source://hpricot//lib/hpricot/modules.rb#31
module Hpricot::Text::Trav
  include ::Hpricot::Traverse
  include ::Hpricot::Leaf::Trav

  # @yield [_self]
  # @yieldparam _self [Hpricot::Text::Trav] the object that the method was called on
  #
  # source://hpricot//lib/hpricot/traverse.rb#699
  def traverse_text_internal; end
end

# :startdoc:
#
# source://hpricot//lib/hpricot/modules.rb#25
module Hpricot::Traverse
  # Find the first matching node for the CSS or XPath
  # +expr+ string.
  #
  # source://hpricot//lib/hpricot/traverse.rb#341
  def %(expr); end

  # Searches this node for all elements matching
  # the CSS or XPath +expr+.  Returns an Elements array
  # containing the matching nodes.  If +blk+ is given, it
  # is used to iterate through the matching set.
  #
  # source://hpricot//lib/hpricot/traverse.rb#254
  def /(expr, &blk); end

  # Adds elements immediately after this element, contained in the +html+ string.
  #
  # source://hpricot//lib/hpricot/traverse.rb#121
  def after(html = T.unsafe(nil), &blk); end

  # Find the first matching node for the CSS or XPath
  # +expr+ string.
  #
  # source://hpricot//lib/hpricot/traverse.rb#341
  def at(expr); end

  # Adds elements immediately before this element, contained in the +html+ string.
  #
  # source://hpricot//lib/hpricot/traverse.rb#126
  def before(html = T.unsafe(nil), &blk); end

  # Is this object a stranded end tag?
  #
  # @return [Boolean]
  #
  # source://hpricot//lib/hpricot/traverse.rb#21
  def bogusetag?; end

  # Find children of a given +tag_name+.
  #
  #   ele.children_of_type('p')
  #     #=> [...array of paragraphs...]
  #
  # source://hpricot//lib/hpricot/traverse.rb#390
  def children_of_type(tag_name); end

  # source://hpricot//lib/hpricot/traverse.rb#203
  def clean_path(path); end

  # Is this object a comment?
  #
  # @return [Boolean]
  #
  # source://hpricot//lib/hpricot/traverse.rb#19
  def comment?; end

  # Builds a unique CSS string for this node, from the
  # root of the document containing it.
  #
  # source://hpricot//lib/hpricot/traverse.rb#226
  def css_path; end

  # Is this object the enclosing HTML or XML document?
  #
  # @return [Boolean]
  #
  # source://hpricot//lib/hpricot/traverse.rb#7
  def doc?; end

  # Is this object a doctype tag?
  #
  # @return [Boolean]
  #
  # source://hpricot//lib/hpricot/traverse.rb#15
  def doctype?; end

  # Is this object an HTML or XML element?
  #
  # @return [Boolean]
  #
  # source://hpricot//lib/hpricot/traverse.rb#9
  def elem?; end

  # Find all nodes which follow the current one.
  #
  # source://hpricot//lib/hpricot/traverse.rb#114
  def following; end

  # source://hpricot//lib/hpricot/traverse.rb#138
  def get_subnode(*indexes); end

  # Builds an HTML string from the contents of this node.
  #
  # source://hpricot//lib/hpricot/traverse.rb#168
  def html(inner = T.unsafe(nil), &blk); end

  # source://hpricot//lib/hpricot/traverse.rb#47
  def index(name); end

  # Builds an HTML string from the contents of this node.
  #
  # source://hpricot//lib/hpricot/traverse.rb#168
  def innerHTML(inner = T.unsafe(nil), &blk); end

  # Inserts new contents into the current node, based on
  # the HTML contained in string +inner+.
  #
  # source://hpricot//lib/hpricot/traverse.rb#191
  def innerHTML=(inner); end

  # Builds a string from the text contained in this node.  All
  # HTML elements are removed.
  #
  # source://hpricot//lib/hpricot/traverse.rb#158
  def innerText; end

  # Builds an HTML string from the contents of this node.
  #
  # source://hpricot//lib/hpricot/traverse.rb#168
  def inner_html(inner = T.unsafe(nil), &blk); end

  # Inserts new contents into the current node, based on
  # the HTML contained in string +inner+.
  #
  # source://hpricot//lib/hpricot/traverse.rb#191
  def inner_html=(inner); end

  # Builds a string from the text contained in this node.  All
  # HTML elements are removed.
  #
  # source://hpricot//lib/hpricot/traverse.rb#158
  def inner_text; end

  # Parses an HTML string, making an HTML fragment based on
  # the options used to create the container document.
  #
  # source://hpricot//lib/hpricot/traverse.rb#25
  def make(input = T.unsafe(nil), &blk); end

  # Returns the node neighboring this node to the south: just below it.
  # This method includes text nodes and comments and such.
  #
  # source://hpricot//lib/hpricot/traverse.rb#91
  def next; end

  # Returns the node neighboring this node to the south: just below it.
  # This method includes text nodes and comments and such.
  #
  # source://hpricot//lib/hpricot/traverse.rb#91
  def next_node; end

  # source://hpricot//lib/hpricot/traverse.rb#242
  def node_position; end

  # Puts together an array of neighboring nodes based on their proximity
  # to this node.  So, for example, to get the next node, you could use
  # <tt>nodes_at(1).  Or, to get the previous node, use <tt>nodes_at(1)</tt>.
  #
  # This method also accepts ranges and sets of numbers.
  #
  #    ele.nodes_at(-3..-1, 1..3) # gets three nodes before and three after
  #    ele.nodes_at(1, 5, 7) # gets three nodes at offsets below the current node
  #    ele.nodes_at(0, 5..6) # the current node and two others
  #
  # source://hpricot//lib/hpricot/traverse.rb#67
  def nodes_at(*pos); end

  # source://hpricot//lib/hpricot/traverse.rb#246
  def position; end

  # Find all preceding nodes.
  #
  # source://hpricot//lib/hpricot/traverse.rb#107
  def preceding; end

  # Returns to node neighboring this node to the north: just above it.
  # This method includes text nodes and comments and such.
  #
  # source://hpricot//lib/hpricot/traverse.rb#99
  def previous; end

  # Returns to node neighboring this node to the north: just above it.
  # This method includes text nodes and comments and such.
  #
  # source://hpricot//lib/hpricot/traverse.rb#99
  def previous_node; end

  # Is this object an XML processing instruction?
  #
  # @return [Boolean]
  #
  # source://hpricot//lib/hpricot/traverse.rb#17
  def procins?; end

  # Searches this node for all elements matching
  # the CSS or XPath +expr+.  Returns an Elements array
  # containing the matching nodes.  If +blk+ is given, it
  # is used to iterate through the matching set.
  #
  # source://hpricot//lib/hpricot/traverse.rb#254
  def search(expr, &blk); end

  # Replace this element and its contents with the nodes contained
  # in the +html+ string.
  #
  # source://hpricot//lib/hpricot/traverse.rb#133
  def swap(html = T.unsafe(nil), &blk); end

  # Is this object an HTML text node?
  #
  # @return [Boolean]
  #
  # source://hpricot//lib/hpricot/traverse.rb#11
  def text?; end

  # Builds an HTML string from this node and its contents.
  # If you need to write to a stream, try calling <tt>output(io)</tt>
  # as a method on this object.
  #
  # source://hpricot//lib/hpricot/traverse.rb#36
  def to_html; end

  # Attempts to preserve the original HTML of the document, only
  # outputing new tags for elements which have changed.
  #
  # source://hpricot//lib/hpricot/traverse.rb#43
  def to_original_html; end

  # Builds a string from the text contained in this node.  All
  # HTML elements are removed.
  #
  # source://hpricot//lib/hpricot/traverse.rb#148
  def to_plain_text; end

  # Builds an HTML string from this node and its contents.
  # If you need to write to a stream, try calling <tt>output(io)</tt>
  # as a method on this object.
  #
  # source://hpricot//lib/hpricot/traverse.rb#36
  def to_s; end

  # +traverse_element+ traverses elements in the tree.
  # It yields elements in depth first order.
  #
  # If _names_ are empty, it yields all elements.
  # If non-empty _names_ are given, it should be list of universal names.
  #
  # A nested element is yielded in depth first order as follows.
  #
  #   t = Hpricot('<a id=0><b><a id=1 /></b><c id=2 /></a>')
  #   t.traverse_element("a", "c") {|e| p e}
  #   # =>
  #   {elem <a id="0"> {elem <b> {emptyelem <a id="1">} </b>} {emptyelem <c id="2">} </a>}
  #   {emptyelem <a id="1">}
  #   {emptyelem <c id="2">}
  #
  # Universal names are specified as follows.
  #
  #   t = Hpricot(<<'End')
  #   <html>
  #   <meta name="robots" content="index,nofollow">
  #   <meta name="author" content="Who am I?">
  #   </html>
  #   End
  #   t.traverse_element("{http://www.w3.org/1999/xhtml}meta") {|e| p e}
  #   # =>
  #   {emptyelem <{http://www.w3.org/1999/xhtml}meta name="robots" content="index,nofollow">}
  #   {emptyelem <{http://www.w3.org/1999/xhtml}meta name="author" content="Who am I?">}
  #
  # source://hpricot//lib/hpricot/traverse.rb#374
  def traverse_element(*names, &block); end

  # +traverse_text+ traverses texts in the tree
  #
  # source://hpricot//lib/hpricot/traverse.rb#680
  def traverse_text(&block); end

  # Is this object an XML declaration?
  #
  # @return [Boolean]
  #
  # source://hpricot//lib/hpricot/traverse.rb#13
  def xmldecl?; end

  # Builds a unique XPath string for this node, from the
  # root of the document containing it.
  #
  # source://hpricot//lib/hpricot/traverse.rb#209
  def xpath; end

  private

  # source://hpricot//lib/hpricot/traverse.rb#196
  def reparent(nodes); end

  class << self
    # source://hpricot//lib/hpricot/elements.rb#375
    def filter(tok, &blk); end
  end
end

# All the tags and attributes from XHTML 1.0 Strict
#
# source://hpricot//lib/hpricot/tags.rb#17
class Hpricot::XHTMLStrict
  class << self
    # Returns the value of attribute doctype.
    #
    # source://hpricot//lib/hpricot/tags.rb#19
    def doctype; end

    # Sets the attribute doctype
    #
    # @param value the value to set the attribute doctype to.
    #
    # source://hpricot//lib/hpricot/tags.rb#19
    def doctype=(_arg0); end

    # Returns the value of attribute forms.
    #
    # source://hpricot//lib/hpricot/tags.rb#19
    def forms; end

    # Sets the attribute forms
    #
    # @param value the value to set the attribute forms to.
    #
    # source://hpricot//lib/hpricot/tags.rb#19
    def forms=(_arg0); end

    # Returns the value of attribute self_closing.
    #
    # source://hpricot//lib/hpricot/tags.rb#19
    def self_closing; end

    # Sets the attribute self_closing
    #
    # @param value the value to set the attribute self_closing to.
    #
    # source://hpricot//lib/hpricot/tags.rb#19
    def self_closing=(_arg0); end

    # Returns the value of attribute tags.
    #
    # source://hpricot//lib/hpricot/tags.rb#19
    def tags; end

    # Sets the attribute tags
    #
    # @param value the value to set the attribute tags to.
    #
    # source://hpricot//lib/hpricot/tags.rb#19
    def tags=(_arg0); end

    # Returns the value of attribute tagset.
    #
    # source://hpricot//lib/hpricot/tags.rb#19
    def tagset; end

    # Sets the attribute tagset
    #
    # @param value the value to set the attribute tagset to.
    #
    # source://hpricot//lib/hpricot/tags.rb#19
    def tagset=(_arg0); end
  end
end

# Additional tags found in XHTML 1.0 Transitional
#
# source://hpricot//lib/hpricot/tags.rb#108
class Hpricot::XHTMLTransitional
  class << self
    # Returns the value of attribute doctype.
    #
    # source://hpricot//lib/hpricot/tags.rb#110
    def doctype; end

    # Sets the attribute doctype
    #
    # @param value the value to set the attribute doctype to.
    #
    # source://hpricot//lib/hpricot/tags.rb#110
    def doctype=(_arg0); end

    # Returns the value of attribute forms.
    #
    # source://hpricot//lib/hpricot/tags.rb#110
    def forms; end

    # Sets the attribute forms
    #
    # @param value the value to set the attribute forms to.
    #
    # source://hpricot//lib/hpricot/tags.rb#110
    def forms=(_arg0); end

    # Returns the value of attribute self_closing.
    #
    # source://hpricot//lib/hpricot/tags.rb#110
    def self_closing; end

    # Sets the attribute self_closing
    #
    # @param value the value to set the attribute self_closing to.
    #
    # source://hpricot//lib/hpricot/tags.rb#110
    def self_closing=(_arg0); end

    # Returns the value of attribute tags.
    #
    # source://hpricot//lib/hpricot/tags.rb#110
    def tags; end

    # Sets the attribute tags
    #
    # @param value the value to set the attribute tags to.
    #
    # source://hpricot//lib/hpricot/tags.rb#110
    def tags=(_arg0); end

    # Returns the value of attribute tagset.
    #
    # source://hpricot//lib/hpricot/tags.rb#110
    def tagset; end

    # Sets the attribute tagset
    #
    # @param value the value to set the attribute tagset to.
    #
    # source://hpricot//lib/hpricot/tags.rb#110
    def tagset=(_arg0); end
  end
end

# source://hpricot//lib/hpricot/tag.rb#166
class Hpricot::XMLDecl
  include ::Hpricot
  include ::Hpricot::Node
  include ::Hpricot::Leaf
  include ::Hpricot::Traverse
  include ::Hpricot::Leaf::Trav
  include ::Hpricot::XMLDecl::Trav

  def clear_raw; end
  def encoding; end
  def encoding=(_arg0); end

  # source://hpricot//lib/hpricot/tag.rb#168
  def output(out, opts = T.unsafe(nil)); end

  # source://hpricot//lib/hpricot/tag.rb#167
  def pathname; end

  def raw_string; end
  def standalone; end
  def standalone=(_arg0); end
  def version; end
  def version=(_arg0); end
end

# source://hpricot//lib/hpricot/modules.rb#32
module Hpricot::XMLDecl::Trav
  include ::Hpricot::Traverse
  include ::Hpricot::Leaf::Trav
end

# Since Ruby is very dynamic, methods added to the ancestors of
# BlankSlate <em>after BlankSlate is defined</em> will show up in the
# list of available BlankSlate methods.  We handle this by defining a
# hook in the Object and Kernel classes that will hide any defined
#
# source://hpricot//lib/hpricot/blankslate.rb#37
module Kernel
  include ::ActiveSupport::ForkTracker::CoreExt

  class << self
    # Detect method additions to Kernel and remove them in the
    # BlankSlate class.
    #
    # source://hpricot//lib/hpricot/blankslate.rb#43
    def method_added(name); end
  end
end

# source://hpricot//lib/hpricot/blankslate.rb#51
class Object < ::BasicObject
  include ::ActiveSupport::ForkTracker::CoreExt
  include ::Kernel
  include ::PP::ObjectMixin

  private

  # source://hpricot//lib/hpricot/parse.rb#3
  def Hpricot(input = T.unsafe(nil), opts = T.unsafe(nil), &blk); end

  class << self
    # Detect method additions to Object and remove them in the
    # BlankSlate class.
    #
    # source://hpricot//lib/hpricot/blankslate.rb#57
    def method_added(name); end
  end
end
