# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `parlour` gem.
# Please instead update this file by running `bin/tapioca gem parlour`.

# source://parlour//lib/parlour/version.rb#2
module Parlour; end

# Responsible for resolving conflicts (that is, multiple definitions with the
# same name) between objects defined in the same namespace.
#
# source://parlour//lib/parlour/conflict_resolver.rb#7
class Parlour::ConflictResolver
  # @return [ConflictResolver] a new instance of ConflictResolver
  #
  # source://parlour//lib/parlour/conflict_resolver.rb#10
  def initialize; end

  # source://parlour//lib/parlour/conflict_resolver.rb#47
  sig do
    params(
      namespace: Parlour::RbiGenerator::Namespace,
      resolver: T.proc.params(desc: ::String, choices: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T.nilable(::Parlour::RbiGenerator::RbiObject))
    ).void
  end
  def resolve_conflicts(namespace, &resolver); end

  private

  # source://parlour//lib/parlour/conflict_resolver.rb#244
  sig { params(arr: T::Array[T.untyped]).returns(T::Boolean) }
  def all_eql?(arr); end

  # source://parlour//lib/parlour/conflict_resolver.rb#255
  sig { params(namespace: Parlour::RbiGenerator::Namespace, name: T.nilable(::String)).void }
  def deduplicate_mixins_of_name(namespace, name); end

  # source://parlour//lib/parlour/conflict_resolver.rb#217
  sig { params(arr: T::Array[T.untyped]).returns(T.nilable(::Symbol)) }
  def merge_strategy(arr); end
end

# source://parlour//lib/parlour/conversion/converter.rb#5
module Parlour::Conversion; end

# An abstract class which converts between the node trees of two type
# systems.
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://parlour//lib/parlour/conversion/converter.rb#8
class Parlour::Conversion::Converter
  abstract!

  # @return [Converter] a new instance of Converter
  #
  # source://parlour//lib/parlour/conversion/converter.rb#13
  def initialize; end

  # source://parlour//lib/parlour/conversion/converter.rb#21
  sig { params(msg: ::String, node: ::Parlour::RbiGenerator::RbiObject).void }
  def add_warning(msg, node); end

  # source://parlour//lib/parlour/conversion/converter.rb#18
  sig { returns(T::Array[[::String, ::Parlour::TypedObject]]) }
  def warnings; end
end

# Converts RBI types to RBS types.
#
# source://parlour//lib/parlour/conversion/rbi_to_rbs.rb#5
class Parlour::Conversion::RbiToRbs < ::Parlour::Conversion::Converter
  # source://parlour//lib/parlour/conversion/rbi_to_rbs.rb#9
  sig { params(rbs_gen: ::Parlour::RbsGenerator).void }
  def initialize(rbs_gen); end

  # source://parlour//lib/parlour/conversion/rbi_to_rbs.rb#18
  sig { params(from: Parlour::RbiGenerator::Namespace, to: Parlour::RbsGenerator::Namespace).void }
  def convert_all(from, to); end

  # source://parlour//lib/parlour/conversion/rbi_to_rbs.rb#30
  sig { params(node: ::Parlour::RbiGenerator::RbiObject, new_parent: Parlour::RbsGenerator::Namespace).void }
  def convert_object(node, new_parent); end

  # source://parlour//lib/parlour/conversion/rbi_to_rbs.rb#15
  sig { returns(::Parlour::RbsGenerator) }
  def rbs_gen; end
end

# Contains methods to enable debugging facilities for Parlour.
#
# source://parlour//lib/parlour/debugging.rb#6
module Parlour::Debugging
  class << self
    # Set whether debug messages should be printed.
    #
    # source://parlour//lib/parlour/debugging.rb#16
    sig { params(value: T::Boolean).returns(T::Boolean) }
    def debug_mode=(value); end

    # Whether debug messages sent by {.debug_puts} should be printed.
    # Defaults to true if the PARLOUR_DEBUG environment variable is set.
    #
    # source://parlour//lib/parlour/debugging.rb#24
    sig { returns(T::Boolean) }
    def debug_mode?; end

    # Prints a message with a debugging prefix to STDOUT if {.debug_mode?} is
    # true.
    #
    # source://parlour//lib/parlour/debugging.rb#36
    sig { params(object: T.untyped, message: ::String).void }
    def debug_puts(object, message); end

    # Converts the given object into a human-readable prefix to a debug message.
    # For example, passing an instance of {ConflictResolver} returns
    # "conflict resolver". If the object type is unknown, this returns its class
    # name.
    #
    # source://parlour//lib/parlour/debugging.rb#50
    sig { params(object: T.untyped).returns(::String) }
    def name_for_debug_caller(object); end
  end
end

# A module for generating a globally-consistent, nicely-formatted tree of
# output using Unicode block characters.
#
# source://parlour//lib/parlour/debugging.rb#66
class Parlour::Debugging::Tree
  # source://parlour//lib/parlour/debugging.rb#78
  sig { params(colour: T::Boolean).void }
  def initialize(colour: T.unsafe(nil)); end

  # Returns a new heading, and then decents the tree one level into it.
  # (That is, future output will go under the new heading.)
  #
  # source://parlour//lib/parlour/debugging.rb#88
  sig { params(message: ::String).returns(::String) }
  def begin(message); end

  # Whether to colour output or not.
  #
  # source://parlour//lib/parlour/debugging.rb#75
  sig { returns(T::Boolean) }
  def colour; end

  # Prints the final tree element at the current level, then ascends one
  # level.
  #
  # source://parlour//lib/parlour/debugging.rb#108
  sig { params(message: ::String).returns(::String) }
  def end(message); end

  # Prints a new tree element at the current level.
  #
  # source://parlour//lib/parlour/debugging.rb#99
  sig { params(message: ::String).returns(::String) }
  def here(message); end

  # Modifies the current indent level by the given offset.
  #
  # source://parlour//lib/parlour/debugging.rb#130
  def indent!(offset); end

  # The prefix which should be printed before anything else on this line of
  # the tree, based on the current indent level.
  #
  # @return [String]
  #
  # source://parlour//lib/parlour/debugging.rb#117
  def line_prefix; end

  # The horizontal lines which should be printed between the beginning of
  # the current element and its text, based on the specified number of
  # spaces to use for indents.
  #
  # @return [String]
  #
  # source://parlour//lib/parlour/debugging.rb#125
  def text_prefix; end
end

# The number of spaces to indent each layer of the tree by. Should be at
# least 1.
#
# source://parlour//lib/parlour/debugging.rb#71
Parlour::Debugging::Tree::INDENT_SPACES = T.let(T.unsafe(nil), Integer)

# source://parlour//lib/parlour/detached_rbi_generator.rb#4
class Parlour::DetachedRbiGenerator < ::Parlour::RbiGenerator
  # source://parlour//lib/parlour/detached_rbi_generator.rb#16
  sig { override.returns(T.nilable(::Parlour::Plugin)) }
  def current_plugin; end

  # source://parlour//lib/parlour/detached_rbi_generator.rb#6
  sig { returns(T.untyped) }
  def detached!; end

  # source://parlour//lib/parlour/detached_rbi_generator.rb#11
  sig { override.returns(::Parlour::Options) }
  def options; end

  # source://parlour//lib/parlour/detached_rbi_generator.rb#21
  sig { override.params(strictness: ::String).returns(::String) }
  def rbi(strictness = T.unsafe(nil)); end
end

# source://parlour//lib/parlour/detached_rbs_generator.rb#4
class Parlour::DetachedRbsGenerator < ::Parlour::RbsGenerator
  # source://parlour//lib/parlour/detached_rbs_generator.rb#16
  sig { override.returns(T.nilable(::Parlour::Plugin)) }
  def current_plugin; end

  # source://parlour//lib/parlour/detached_rbs_generator.rb#6
  sig { returns(T.untyped) }
  def detached!; end

  # source://parlour//lib/parlour/detached_rbs_generator.rb#11
  sig { override.returns(::Parlour::Options) }
  def options; end

  # source://parlour//lib/parlour/detached_rbs_generator.rb#21
  sig { override.returns(::String) }
  def rbs; end
end

# source://parlour//lib/parlour/generator.rb#3
class Parlour::Generator
  # source://parlour//lib/parlour/generator.rb#15
  sig { params(break_params: ::Integer, tab_size: ::Integer, sort_namespaces: T::Boolean).void }
  def initialize(break_params: T.unsafe(nil), tab_size: T.unsafe(nil), sort_namespaces: T.unsafe(nil)); end

  # source://parlour//lib/parlour/generator.rb#32
  sig { overridable.returns(T.nilable(::Parlour::Plugin)) }
  def current_plugin; end

  # @return [Plugin, nil]
  #
  # source://parlour//lib/parlour/generator.rb#32
  def current_plugin=(_arg0); end

  # source://parlour//lib/parlour/generator.rb#26
  sig { overridable.returns(::Parlour::Options) }
  def options; end
end

# source://parlour//lib/parlour/mixin/searchable.rb#4
module Parlour::Mixin; end

# Extends a particular type system's Namespace class to provide searchable
# children.
#
# @abstract Subclasses must implement the `abstract` methods below.
#
# source://parlour//lib/parlour/mixin/searchable.rb#7
module Parlour::Mixin::Searchable
  extend T::Generic

  abstract!

  Child = type_member { { upper: Parlour::TypedObject } }

  # @abstract
  #
  # source://parlour//lib/parlour/mixin/searchable.rb#16
  sig { abstract.returns(T::Array[Child]) }
  def children; end

  # source://parlour//lib/parlour/mixin/searchable.rb#24
  sig { params(name: T.nilable(::String), type: T.nilable(::Class)).returns(Child) }
  def find(name: T.unsafe(nil), type: T.unsafe(nil)); end

  # source://parlour//lib/parlour/mixin/searchable.rb#34
  sig { params(name: T.nilable(::String), type: T.nilable(::Class)).returns(T::Array[Child]) }
  def find_all(name: T.unsafe(nil), type: T.unsafe(nil)); end

  private

  # source://parlour//lib/parlour/mixin/searchable.rb#48
  sig { params(child: Child, name: T.nilable(::String), type: T.nilable(::Class)).returns(T::Boolean) }
  def searchable_child_matches(child, name, type); end
end

# A set of immutable formatting options.
#
# source://parlour//lib/parlour/options.rb#4
class Parlour::Options
  # source://parlour//lib/parlour/options.rb#19
  sig { params(break_params: ::Integer, tab_size: ::Integer, sort_namespaces: T::Boolean).void }
  def initialize(break_params:, tab_size:, sort_namespaces:); end

  # source://parlour//lib/parlour/options.rb#43
  sig { returns(::Integer) }
  def break_params; end

  # source://parlour//lib/parlour/options.rb#67
  sig { params(level: ::Integer, str: ::String).returns(::String) }
  def indented(level, str); end

  # source://parlour//lib/parlour/options.rb#58
  sig { returns(T::Boolean) }
  def sort_namespaces; end

  # source://parlour//lib/parlour/options.rb#48
  sig { returns(::Integer) }
  def tab_size; end
end

# source://parlour//lib/parlour/parse_error.rb#4
class Parlour::ParseError < ::StandardError
  # @return [ParseError] a new instance of ParseError
  #
  # source://parlour//lib/parlour/parse_error.rb#13
  def initialize(buffer, range); end

  # source://parlour//lib/parlour/parse_error.rb#8
  sig { returns(::Parser::Source::Buffer) }
  def buffer; end

  # source://parlour//lib/parlour/parse_error.rb#11
  sig { returns(::Parser::Source::Range) }
  def range; end
end

# The base class for user-defined RBI generation plugins.
#
# @abstract
#
# source://parlour//lib/parlour/plugin.rb#5
class Parlour::Plugin
  abstract!

  # source://parlour//lib/parlour/plugin.rb#54
  sig { params(options: T::Hash[T.untyped, T.untyped]).void }
  def initialize(options); end

  # @abstract
  #
  # source://parlour//lib/parlour/plugin.rb#63
  sig { abstract.params(root: Parlour::RbiGenerator::Namespace).void }
  def generate(root); end

  # source://parlour//lib/parlour/plugin.rb#70
  sig { returns(T.nilable(::String)) }
  def strictness; end

  # @return [String, nil]
  #
  # source://parlour//lib/parlour/plugin.rb#70
  def strictness=(_arg0); end

  class << self
    # source://parlour//lib/parlour/plugin.rb#27
    sig { params(new_plugin: T.class_of(Parlour::Plugin)).void }
    def inherited(new_plugin); end

    # source://parlour//lib/parlour/plugin.rb#17
    sig { returns(T::Hash[::String, T.class_of(Parlour::Plugin)]) }
    def registered_plugins; end

    # source://parlour//lib/parlour/plugin.rb#40
    sig do
      params(
        plugins: T::Array[::Parlour::Plugin],
        generator: ::Parlour::RbiGenerator,
        allow_failure: T::Boolean
      ).void
    end
    def run_plugins(plugins, generator, allow_failure: T.unsafe(nil)); end
  end
end

# The RBI generator.
#
# source://parlour//lib/parlour/rbi_generator/parameter.rb#5
class Parlour::RbiGenerator < ::Parlour::Generator
  # @return [RbiGenerator] a new instance of RbiGenerator
  #
  # source://parlour//lib/parlour/rbi_generator.rb#9
  def initialize(**hash); end

  # source://parlour//lib/parlour/rbi_generator.rb#23
  sig { overridable.params(strictness: ::String).returns(::String) }
  def rbi(strictness = T.unsafe(nil)); end

  # source://parlour//lib/parlour/rbi_generator.rb#17
  sig { overridable.returns(Parlour::RbiGenerator::Namespace) }
  def root; end
end

# Represents miscellaneous Ruby code.
#
# source://parlour//lib/parlour/rbi_generator/arbitrary.rb#5
class Parlour::RbiGenerator::Arbitrary < ::Parlour::RbiGenerator::RbiObject
  # source://parlour//lib/parlour/rbi_generator/arbitrary.rb#17
  sig do
    params(
      generator: ::Parlour::Generator,
      code: ::String,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Arbitrary).void)
    ).void
  end
  def initialize(generator, code: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbi_generator/arbitrary.rb#33
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/rbi_generator/arbitrary.rb#25
  sig { returns(::String) }
  def code; end

  # @return [String]
  #
  # source://parlour//lib/parlour/rbi_generator/arbitrary.rb#25
  def code=(_arg0); end

  # source://parlour//lib/parlour/rbi_generator/arbitrary.rb#84
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbi_generator/arbitrary.rb#89
  sig { override.void }
  def generalize_from_rbi!; end

  # source://parlour//lib/parlour/rbi_generator/arbitrary.rb#48
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  # source://parlour//lib/parlour/rbi_generator/arbitrary.rb#79
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  # source://parlour//lib/parlour/rbi_generator/arbitrary.rb#63
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end
end

# Represents an attribute reader, writer or accessor.
#
# source://parlour//lib/parlour/rbi_generator/attribute.rb#5
class Parlour::RbiGenerator::Attribute < ::Parlour::RbiGenerator::Method
  # source://parlour//lib/parlour/rbi_generator/attribute.rb#28
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      kind: ::Symbol,
      type: T.any(::Parlour::Types::Type, ::String),
      class_attribute: T::Boolean,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Attribute).void)
    ).void
  end
  def initialize(generator, name, kind, type, class_attribute: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbi_generator/attribute.rb#68
  sig { override.params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/rbi_generator/attribute.rb#56
  sig { returns(T::Boolean) }
  def class_attribute; end

  # source://parlour//lib/parlour/rbi_generator/attribute.rb#82
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbi_generator/attribute.rb#77
  sig { override.void }
  def generalize_from_rbi!; end

  # source://parlour//lib/parlour/rbi_generator/attribute.rb#52
  sig { returns(::Symbol) }
  def kind; end

  # source://parlour//lib/parlour/rbi_generator/attribute.rb#60
  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end

  private

  # source://parlour//lib/parlour/rbi_generator/attribute.rb#103
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_definition(indent_level, options); end
end

# Represents a class definition.
#
# source://parlour//lib/parlour/rbi_generator/class_namespace.rb#5
class Parlour::RbiGenerator::ClassNamespace < ::Parlour::RbiGenerator::Namespace
  extend T::Generic

  Child = type_member { { fixed: Parlour::RbiGenerator::RbiObject } }

  # source://parlour//lib/parlour/rbi_generator/class_namespace.rb#33
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      final: T::Boolean,
      sealed: T::Boolean,
      superclass: T.nilable(::String),
      abstract: T::Boolean,
      block: T.nilable(T.proc.params(x: Parlour::RbiGenerator::ClassNamespace).void)
    ).void
  end
  def initialize(generator, name, final, sealed, superclass, abstract, &block); end

  # source://parlour//lib/parlour/rbi_generator/class_namespace.rb#70
  sig { returns(T::Boolean) }
  def abstract; end

  # source://parlour//lib/parlour/rbi_generator/class_namespace.rb#116
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbi_generator/class_namespace.rb#122
  sig { override.void }
  def generalize_from_rbi!; end

  # source://parlour//lib/parlour/rbi_generator/class_namespace.rb#50
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  # source://parlour//lib/parlour/rbi_generator/class_namespace.rb#104
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  # source://parlour//lib/parlour/rbi_generator/class_namespace.rb#84
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end

  # source://parlour//lib/parlour/rbi_generator/class_namespace.rb#65
  sig { returns(T.nilable(::String)) }
  def superclass; end
end

# Represents a constant definition.
#
# source://parlour//lib/parlour/rbi_generator/constant.rb#5
class Parlour::RbiGenerator::Constant < ::Parlour::RbiGenerator::RbiObject
  # source://parlour//lib/parlour/rbi_generator/constant.rb#21
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      value: T.any(::Parlour::Types::Type, ::String),
      eigen_constant: T::Boolean,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Constant).void)
    ).void
  end
  def initialize(generator, name: T.unsafe(nil), value: T.unsafe(nil), eigen_constant: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbi_generator/constant.rb#42
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/rbi_generator/constant.rb#99
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # @return [Boolean] Whether this constant is defined on the eigenclass
  #   of the current namespace.
  #
  # source://parlour//lib/parlour/rbi_generator/constant.rb#34
  def eigen_constant; end

  # source://parlour//lib/parlour/rbi_generator/constant.rb#104
  sig { override.void }
  def generalize_from_rbi!; end

  # source://parlour//lib/parlour/rbi_generator/constant.rb#58
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  # source://parlour//lib/parlour/rbi_generator/constant.rb#94
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  # source://parlour//lib/parlour/rbi_generator/constant.rb#77
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end

  # source://parlour//lib/parlour/rbi_generator/constant.rb#30
  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def value; end
end

# Represents an enum definition; that is, a class with an +enum+ call.
#
# source://parlour//lib/parlour/rbi_generator/enum_class_namespace.rb#5
class Parlour::RbiGenerator::EnumClassNamespace < ::Parlour::RbiGenerator::ClassNamespace
  extend T::Generic

  Child = type_member { { fixed: Parlour::RbiGenerator::RbiObject } }

  # source://parlour//lib/parlour/rbi_generator/enum_class_namespace.rb#32
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      final: T::Boolean,
      sealed: T::Boolean,
      enums: T::Array[T.any(::String, [::String, ::String])],
      abstract: T::Boolean,
      block: T.nilable(T.proc.params(x: Parlour::RbiGenerator::EnumClassNamespace).void)
    ).void
  end
  def initialize(generator, name, final, sealed, enums, abstract, &block); end

  # source://parlour//lib/parlour/rbi_generator/enum_class_namespace.rb#121
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbi_generator/enum_class_namespace.rb#40
  sig { returns(T::Array[T.any(::String, [::String, ::String])]) }
  def enums; end

  # source://parlour//lib/parlour/rbi_generator/enum_class_namespace.rb#116
  sig { override.void }
  def generalize_from_rbi!; end

  # source://parlour//lib/parlour/rbi_generator/enum_class_namespace.rb#54
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_body(indent_level, options); end

  # source://parlour//lib/parlour/rbi_generator/enum_class_namespace.rb#104
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  # source://parlour//lib/parlour/rbi_generator/enum_class_namespace.rb#86
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end
end

# Represents an +extend+ call.
#
# source://parlour//lib/parlour/rbi_generator/extend.rb#5
class Parlour::RbiGenerator::Extend < ::Parlour::RbiGenerator::RbiObject
  # source://parlour//lib/parlour/rbi_generator/extend.rb#16
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Extend).void)
    ).void
  end
  def initialize(generator, name: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbi_generator/extend.rb#27
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/rbi_generator/extend.rb#82
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbi_generator/extend.rb#79
  sig { override.void }
  def generalize_from_rbi!; end

  # source://parlour//lib/parlour/rbi_generator/extend.rb#42
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  # source://parlour//lib/parlour/rbi_generator/extend.rb#74
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  # source://parlour//lib/parlour/rbi_generator/extend.rb#57
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end
end

# Represents an +include+ call.
#
# source://parlour//lib/parlour/rbi_generator/include.rb#5
class Parlour::RbiGenerator::Include < ::Parlour::RbiGenerator::RbiObject
  # source://parlour//lib/parlour/rbi_generator/include.rb#16
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Include).void)
    ).void
  end
  def initialize(generator, name: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbi_generator/include.rb#27
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/rbi_generator/include.rb#82
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbi_generator/include.rb#79
  sig { override.void }
  def generalize_from_rbi!; end

  # source://parlour//lib/parlour/rbi_generator/include.rb#42
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  # source://parlour//lib/parlour/rbi_generator/include.rb#74
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  # source://parlour//lib/parlour/rbi_generator/include.rb#57
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end
end

# Represents a method definition.
#
# source://parlour//lib/parlour/rbi_generator/method.rb#5
class Parlour::RbiGenerator::Method < ::Parlour::RbiGenerator::RbiObject
  # source://parlour//lib/parlour/rbi_generator/method.rb#45
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      parameters: T::Array[::Parlour::RbiGenerator::Parameter],
      return_type: T.nilable(T.any(::Parlour::Types::Type, ::String)),
      abstract: T::Boolean,
      implementation: T::Boolean,
      override: T::Boolean,
      overridable: T::Boolean,
      class_method: T::Boolean,
      final: T::Boolean,
      type_parameters: T.nilable(T::Array[::Symbol]),
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Method).void)
    ).void
  end
  def initialize(generator, name, parameters, return_type = T.unsafe(nil), abstract: T.unsafe(nil), implementation: T.unsafe(nil), override: T.unsafe(nil), overridable: T.unsafe(nil), class_method: T.unsafe(nil), final: T.unsafe(nil), type_parameters: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbi_generator/method.rb#65
  sig { overridable.params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/rbi_generator/method.rb#92
  sig { returns(T::Boolean) }
  def abstract; end

  # source://parlour//lib/parlour/rbi_generator/method.rb#117
  sig { returns(T::Boolean) }
  def class_method; end

  # source://parlour//lib/parlour/rbi_generator/method.rb#217
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbi_generator/method.rb#122
  sig { returns(T::Boolean) }
  def final; end

  # source://parlour//lib/parlour/rbi_generator/method.rb#210
  sig { override.void }
  def generalize_from_rbi!; end

  # source://parlour//lib/parlour/rbi_generator/method.rb#140
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  # source://parlour//lib/parlour/rbi_generator/method.rb#100
  sig { returns(T::Boolean) }
  def implementation; end

  # source://parlour//lib/parlour/rbi_generator/method.rb#205
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  # source://parlour//lib/parlour/rbi_generator/method.rb#188
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end

  # source://parlour//lib/parlour/rbi_generator/method.rb#111
  sig { returns(T::Boolean) }
  def overridable; end

  # source://parlour//lib/parlour/rbi_generator/method.rb#106
  sig { returns(T::Boolean) }
  def override; end

  # source://parlour//lib/parlour/rbi_generator/method.rb#82
  sig { returns(T::Array[::Parlour::RbiGenerator::Parameter]) }
  def parameters; end

  # source://parlour//lib/parlour/rbi_generator/method.rb#87
  sig { returns(T.nilable(T.any(::Parlour::Types::Type, ::String))) }
  def return_type; end

  # source://parlour//lib/parlour/rbi_generator/method.rb#127
  sig { returns(T::Array[::Symbol]) }
  def type_parameters; end

  private

  # source://parlour//lib/parlour/rbi_generator/method.rb#244
  sig { overridable.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_definition(indent_level, options); end

  # source://parlour//lib/parlour/rbi_generator/method.rb#261
  sig { returns(::String) }
  def qualifiers; end
end

# Represents a module definition.
#
# source://parlour//lib/parlour/rbi_generator/module_namespace.rb#5
class Parlour::RbiGenerator::ModuleNamespace < ::Parlour::RbiGenerator::Namespace
  extend T::Generic

  Child = type_member { { fixed: Parlour::RbiGenerator::RbiObject } }

  # source://parlour//lib/parlour/rbi_generator/module_namespace.rb#33
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      final: T::Boolean,
      sealed: T::Boolean,
      interface: T::Boolean,
      abstract: T::Boolean,
      block: T.nilable(T.proc.params(x: Parlour::RbiGenerator::ClassNamespace).void)
    ).void
  end
  def initialize(generator, name, final, sealed, interface, abstract, &block); end

  # source://parlour//lib/parlour/rbi_generator/module_namespace.rb#68
  sig { returns(T::Boolean) }
  def abstract; end

  # source://parlour//lib/parlour/rbi_generator/module_namespace.rb#111
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbi_generator/module_namespace.rb#106
  sig { override.void }
  def generalize_from_rbi!; end

  # source://parlour//lib/parlour/rbi_generator/module_namespace.rb#51
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  # source://parlour//lib/parlour/rbi_generator/module_namespace.rb#63
  sig { returns(T::Boolean) }
  def interface; end

  # source://parlour//lib/parlour/rbi_generator/module_namespace.rb#101
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  # source://parlour//lib/parlour/rbi_generator/module_namespace.rb#82
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end
end

# A generic namespace. This shouldn't be used, except as the type of
# {RbiGenerator#root}.
#
# source://parlour//lib/parlour/rbi_generator/namespace.rb#6
class Parlour::RbiGenerator::Namespace < ::Parlour::RbiGenerator::RbiObject
  extend T::Generic
  include ::Parlour::Mixin::Searchable

  Child = type_member { { fixed: Parlour::RbiGenerator::RbiObject } }

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#45
  sig do
    params(
      generator: ::Parlour::Generator,
      name: T.nilable(::String),
      final: T::Boolean,
      sealed: T::Boolean,
      block: T.nilable(T.proc.params(x: Parlour::RbiGenerator::Namespace).void)
    ).void
  end
  def initialize(generator, name = T.unsafe(nil), final = T.unsafe(nil), sealed = T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#157
  sig { params(comment: T.any(::String, T::Array[::String])).void }
  def add_comment_to_next_child(comment); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#95
  sig { returns(T::Array[::Parlour::RbiGenerator::TypeAlias]) }
  def aliases; end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#67
  sig { override.returns(T::Array[::Parlour::RbiGenerator::RbiObject]) }
  def children; end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#106
  sig { returns(T::Array[::Parlour::RbiGenerator::Constant]) }
  def constants; end

  # Creates a new arbitrary code section.
  # You should rarely have to use this!
  #
  # @param code [String] The code to insert.
  # @param block A block which the new instance yields itself to.
  # @return [RbiGenerator::Arbitrary]
  #
  # source://parlour//lib/parlour/rbi_generator/namespace.rb#482
  def create_arbitrary(code:, &block); end

  # @param name [String]
  # @param kind [Symbol]
  # @param type [Types::TypeLike]
  # @param class_attribute [Boolean]
  # @param block [T.proc.params(x: Attribute).void, nil]
  # @return [Attribute]
  #
  # source://sorbet-runtime/0.5.11150/lib/types/private/methods/_methods.rb#255
  def create_attr(*args, **_arg1, &blk); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#472
  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      class_attribute: T::Boolean,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Attribute).void)
    ).returns(::Parlour::RbiGenerator::Attribute)
  end
  def create_attr_accessor(name, type:, class_attribute: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#430
  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      class_attribute: T::Boolean,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Attribute).void)
    ).returns(::Parlour::RbiGenerator::Attribute)
  end
  def create_attr_reader(name, type:, class_attribute: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#451
  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      class_attribute: T::Boolean,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Attribute).void)
    ).returns(::Parlour::RbiGenerator::Attribute)
  end
  def create_attr_writer(name, type:, class_attribute: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#398
  sig do
    params(
      name: ::String,
      kind: ::Symbol,
      type: T.any(::Parlour::Types::Type, ::String),
      class_attribute: T::Boolean,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Attribute).void)
    ).returns(::Parlour::RbiGenerator::Attribute)
  end
  def create_attribute(name, kind:, type:, class_attribute: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#193
  sig do
    params(
      name: ::String,
      final: T::Boolean,
      sealed: T::Boolean,
      superclass: T.nilable(::String),
      abstract: T::Boolean,
      block: T.nilable(T.proc.params(x: Parlour::RbiGenerator::ClassNamespace).void)
    ).returns(Parlour::RbiGenerator::ClassNamespace)
  end
  def create_class(name, final: T.unsafe(nil), sealed: T.unsafe(nil), superclass: T.unsafe(nil), abstract: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#579
  sig do
    params(
      name: ::String,
      value: ::String,
      eigen_constant: T::Boolean,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Constant).void)
    ).returns(::Parlour::RbiGenerator::Constant)
  end
  def create_constant(name, value:, eigen_constant: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#222
  sig do
    params(
      name: ::String,
      final: T::Boolean,
      sealed: T::Boolean,
      enums: T.nilable(T::Array[T.any(::String, [::String, ::String])]),
      abstract: T::Boolean,
      block: T.nilable(T.proc.params(x: Parlour::RbiGenerator::EnumClassNamespace).void)
    ).returns(Parlour::RbiGenerator::EnumClassNamespace)
  end
  def create_enum_class(name, final: T.unsafe(nil), sealed: T.unsafe(nil), enums: T.unsafe(nil), abstract: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#503
  sig do
    params(
      name: ::String,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Extend).void)
    ).returns(::Parlour::RbiGenerator::Extend)
  end
  def create_extend(name, &block); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#522
  sig { params(extendables: T::Array[::String]).returns(T::Array[::Parlour::RbiGenerator::Extend]) }
  def create_extends(extendables); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#540
  sig do
    params(
      name: ::String,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Include).void)
    ).returns(::Parlour::RbiGenerator::Include)
  end
  def create_include(name, &block); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#559
  sig { params(includables: T::Array[::String]).returns(T::Array[::Parlour::RbiGenerator::Include]) }
  def create_includes(includables); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#333
  sig do
    params(
      name: ::String,
      parameters: T.nilable(T::Array[::Parlour::RbiGenerator::Parameter]),
      return_type: T.nilable(T.any(::Parlour::Types::Type, ::String)),
      returns: T.nilable(T.any(::Parlour::Types::Type, ::String)),
      abstract: T::Boolean,
      implementation: T::Boolean,
      override: T::Boolean,
      overridable: T::Boolean,
      class_method: T::Boolean,
      final: T::Boolean,
      type_parameters: T.nilable(T::Array[::Symbol]),
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Method).void)
    ).returns(::Parlour::RbiGenerator::Method)
  end
  def create_method(name, parameters: T.unsafe(nil), return_type: T.unsafe(nil), returns: T.unsafe(nil), abstract: T.unsafe(nil), implementation: T.unsafe(nil), override: T.unsafe(nil), overridable: T.unsafe(nil), class_method: T.unsafe(nil), final: T.unsafe(nil), type_parameters: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#289
  sig do
    params(
      name: ::String,
      final: T::Boolean,
      sealed: T::Boolean,
      interface: T::Boolean,
      abstract: T::Boolean,
      block: T.nilable(T.proc.params(x: Parlour::RbiGenerator::ClassNamespace).void)
    ).returns(Parlour::RbiGenerator::ModuleNamespace)
  end
  def create_module(name, final: T.unsafe(nil), sealed: T.unsafe(nil), interface: T.unsafe(nil), abstract: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#253
  sig do
    params(
      name: ::String,
      final: T::Boolean,
      sealed: T::Boolean,
      props: T.nilable(T::Array[::Parlour::RbiGenerator::StructProp]),
      abstract: T::Boolean,
      block: T.nilable(T.proc.params(x: Parlour::RbiGenerator::StructClassNamespace).void)
    ).returns(Parlour::RbiGenerator::StructClassNamespace)
  end
  def create_struct_class(name, final: T.unsafe(nil), sealed: T.unsafe(nil), props: T.unsafe(nil), abstract: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#602
  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::TypeAlias).void)
    ).returns(::Parlour::RbiGenerator::TypeAlias)
  end
  def create_type_alias(name, type:, &block); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#660
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#75
  sig { returns(T::Array[::Parlour::RbiGenerator::Extend]) }
  def extends; end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#57
  sig { returns(T::Boolean) }
  def final; end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#655
  sig { override.void }
  def generalize_from_rbi!; end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#21
  sig { override.overridable.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#85
  sig { returns(T::Array[::Parlour::RbiGenerator::Include]) }
  def includes; end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#645
  sig { override.overridable.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#627
  sig { override.overridable.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#120
  sig { params(constant: ::Module, block: T.proc.params(x: Parlour::RbiGenerator::Namespace).void).void }
  def path(constant, &block); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#62
  sig { returns(T::Boolean) }
  def sealed; end

  # @return [Array<RbiGenerator::TypeAlias>]
  #
  # source://sorbet-runtime/0.5.11150/lib/types/private/methods/_methods.rb#255
  def type_aliases(*args, **_arg1, &blk); end

  private

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#678
  sig { overridable.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_body(indent_level, options); end

  # source://parlour//lib/parlour/rbi_generator/namespace.rb#769
  sig { params(object: ::Parlour::RbiGenerator::RbiObject).void }
  def move_next_comments(object); end
end

# For backwards compatibility.
# Before Parlour 5.0, Parlour::Options was Parlour::RbiGenerator::Options.
#
# source://parlour//lib/parlour/rbi_generator.rb#7
Parlour::RbiGenerator::Options = Parlour::Options

# Represents a method parameter with a Sorbet type signature.
#
# source://parlour//lib/parlour/rbi_generator/parameter.rb#6
class Parlour::RbiGenerator::Parameter
  # source://parlour//lib/parlour/rbi_generator/parameter.rb#37
  sig do
    params(
      name: ::String,
      type: T.nilable(T.any(::Parlour::Types::Type, ::String)),
      default: T.nilable(::String)
    ).void
  end
  def initialize(name, type: T.unsafe(nil), default: T.unsafe(nil)); end

  # source://parlour//lib/parlour/rbi_generator/parameter.rb#56
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/rbi_generator/parameter.rb#95
  sig { returns(T.nilable(::String)) }
  def default; end

  # source://parlour//lib/parlour/rbi_generator/parameter.rb#139
  sig { returns(::String) }
  def describe_in_method; end

  # source://parlour//lib/parlour/rbi_generator/parameter.rb#134
  sig { void }
  def generalize_from_rbi!; end

  # source://parlour//lib/parlour/rbi_generator/parameter.rb#101
  sig { returns(::Symbol) }
  def kind; end

  # source://parlour//lib/parlour/rbi_generator/parameter.rb#68
  sig { returns(::String) }
  def name; end

  # source://parlour//lib/parlour/rbi_generator/parameter.rb#75
  sig { returns(::String) }
  def name_without_kind; end

  # source://parlour//lib/parlour/rbi_generator/parameter.rb#107
  sig { returns(::String) }
  def to_def_param; end

  # source://parlour//lib/parlour/rbi_generator/parameter.rb#121
  sig { returns(::String) }
  def to_sig_param; end

  # source://parlour//lib/parlour/rbi_generator/parameter.rb#88
  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end
end

# A mapping of {kind} values to the characteristic prefixes each kind has.
#
# source://parlour//lib/parlour/rbi_generator/parameter.rb#126
Parlour::RbiGenerator::Parameter::PREFIXES = T.let(T.unsafe(nil), Hash)

# An abstract class which is subclassed by any classes which can generate
# entire lines of an RBI, such as {Namespace} and {Method}. (As an example,
# {Parameter} is _not_ a subclass because it does not generate lines, only
# segments of definition and signature lines.)
#
# @abstract
#
# source://parlour//lib/parlour/rbi_generator/rbi_object.rb#9
class Parlour::RbiGenerator::RbiObject < ::Parlour::TypedObject
  abstract!

  # source://parlour//lib/parlour/rbi_generator/rbi_object.rb#19
  sig { params(generator: ::Parlour::Generator, name: ::String).void }
  def initialize(generator, name); end

  # @abstract
  #
  # source://parlour//lib/parlour/rbi_generator/rbi_object.rb#79
  sig { abstract.void }
  def generalize_from_rbi!; end

  # @abstract
  #
  # source://parlour//lib/parlour/rbi_generator/rbi_object.rb#42
  sig { abstract.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  # source://parlour//lib/parlour/rbi_generator/rbi_object.rb#28
  sig { returns(::Parlour::Generator) }
  def generator; end

  # @abstract
  #
  # source://parlour//lib/parlour/rbi_generator/rbi_object.rb#70
  sig { abstract.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  # @abstract
  #
  # source://parlour//lib/parlour/rbi_generator/rbi_object.rb#56
  sig { abstract.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end
end

# Represents an struct definition; that is, a class which subclasses
# +T::Struct+ and declares `prop` members.
#
# source://parlour//lib/parlour/rbi_generator/struct_class_namespace.rb#6
class Parlour::RbiGenerator::StructClassNamespace < ::Parlour::RbiGenerator::ClassNamespace
  extend T::Generic

  Child = type_member { { fixed: Parlour::RbiGenerator::RbiObject } }

  # source://parlour//lib/parlour/rbi_generator/struct_class_namespace.rb#33
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      final: T::Boolean,
      sealed: T::Boolean,
      props: T::Array[::Parlour::RbiGenerator::StructProp],
      abstract: T::Boolean,
      block: T.nilable(T.proc.params(x: Parlour::RbiGenerator::StructClassNamespace).void)
    ).void
  end
  def initialize(generator, name, final, sealed, props, abstract, &block); end

  # source://parlour//lib/parlour/rbi_generator/struct_class_namespace.rb#114
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbi_generator/struct_class_namespace.rb#107
  sig { override.void }
  def generalize_from_rbi!; end

  # source://parlour//lib/parlour/rbi_generator/struct_class_namespace.rb#55
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_body(indent_level, options); end

  # source://parlour//lib/parlour/rbi_generator/struct_class_namespace.rb#95
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  # source://parlour//lib/parlour/rbi_generator/struct_class_namespace.rb#77
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end

  # source://parlour//lib/parlour/rbi_generator/struct_class_namespace.rb#41
  sig { returns(T::Array[::Parlour::RbiGenerator::StructProp]) }
  def props; end
end

# Represents a +T::Struct+ property.
#
# source://parlour//lib/parlour/rbi_generator/struct_prop.rb#5
class Parlour::RbiGenerator::StructProp
  # source://parlour//lib/parlour/rbi_generator/struct_prop.rb#33
  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      optional: T.nilable(T.any(::Symbol, T::Boolean)),
      enum: T.nilable(::String),
      dont_store: T.nilable(T::Boolean),
      foreign: T.nilable(::String),
      default: T.nilable(::String),
      factory: T.nilable(::String),
      immutable: T.nilable(T::Boolean),
      array: T.nilable(::String),
      override: T.nilable(T::Boolean),
      redaction: T.nilable(::String)
    ).void
  end
  def initialize(name, type, optional: T.unsafe(nil), enum: T.unsafe(nil), dont_store: T.unsafe(nil), foreign: T.unsafe(nil), default: T.unsafe(nil), factory: T.unsafe(nil), immutable: T.unsafe(nil), array: T.unsafe(nil), override: T.unsafe(nil), redaction: T.unsafe(nil)); end

  # source://parlour//lib/parlour/rbi_generator/struct_prop.rb#57
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/rbi_generator/struct_prop.rb#106
  sig { returns(T.nilable(::String)) }
  def array; end

  # source://parlour//lib/parlour/rbi_generator/struct_prop.rb#97
  sig { returns(T.nilable(::String)) }
  def default; end

  # source://parlour//lib/parlour/rbi_generator/struct_prop.rb#91
  sig { returns(T.nilable(T::Boolean)) }
  def dont_store; end

  # source://parlour//lib/parlour/rbi_generator/struct_prop.rb#88
  sig { returns(T.nilable(::String)) }
  def enum; end

  # source://parlour//lib/parlour/rbi_generator/struct_prop.rb#100
  sig { returns(T.nilable(::String)) }
  def factory; end

  # source://parlour//lib/parlour/rbi_generator/struct_prop.rb#94
  sig { returns(T.nilable(::String)) }
  def foreign; end

  # source://parlour//lib/parlour/rbi_generator/struct_prop.rb#134
  sig { void }
  def generalize_from_rbi!; end

  # source://parlour//lib/parlour/rbi_generator/struct_prop.rb#103
  sig { returns(T.nilable(T::Boolean)) }
  def immutable; end

  # source://parlour//lib/parlour/rbi_generator/struct_prop.rb#77
  sig { returns(::String) }
  def name; end

  # source://parlour//lib/parlour/rbi_generator/struct_prop.rb#85
  sig { returns(T.nilable(T.any(::Symbol, T::Boolean))) }
  def optional; end

  # source://parlour//lib/parlour/rbi_generator/struct_prop.rb#109
  sig { returns(T.nilable(T::Boolean)) }
  def override; end

  # source://parlour//lib/parlour/rbi_generator/struct_prop.rb#112
  sig { returns(T.nilable(::String)) }
  def redaction; end

  # source://parlour//lib/parlour/rbi_generator/struct_prop.rb#122
  sig { returns(::String) }
  def to_prop_call; end

  # source://parlour//lib/parlour/rbi_generator/struct_prop.rb#82
  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end
end

# The optional properties available on instances of this class.
#
# source://parlour//lib/parlour/rbi_generator/struct_prop.rb#115
Parlour::RbiGenerator::StructProp::EXTRA_PROPERTIES = T.let(T.unsafe(nil), Array)

# Represents a type alias.
#
# source://parlour//lib/parlour/rbi_generator/type_alias.rb#5
class Parlour::RbiGenerator::TypeAlias < ::Parlour::RbiGenerator::RbiObject
  # source://parlour//lib/parlour/rbi_generator/type_alias.rb#18
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::TypeAlias).void)
    ).void
  end
  def initialize(generator, name:, type:, &block); end

  # source://parlour//lib/parlour/rbi_generator/type_alias.rb#34
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/rbi_generator/type_alias.rb#93
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbi_generator/type_alias.rb#88
  sig { override.void }
  def generalize_from_rbi!; end

  # source://parlour//lib/parlour/rbi_generator/type_alias.rb#49
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  # source://parlour//lib/parlour/rbi_generator/type_alias.rb#83
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  # source://parlour//lib/parlour/rbi_generator/type_alias.rb#66
  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end

  # source://parlour//lib/parlour/rbi_generator/type_alias.rb#26
  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end
end

# The RBS generator.
#
# source://parlour//lib/parlour/rbs_generator/rbs_object.rb#8
class Parlour::RbsGenerator < ::Parlour::Generator
  # @return [RbsGenerator] a new instance of RbsGenerator
  #
  # source://parlour//lib/parlour/rbs_generator.rb#5
  def initialize(**hash); end

  # source://parlour//lib/parlour/rbs_generator.rb#19
  sig { overridable.returns(::String) }
  def rbs; end

  # source://parlour//lib/parlour/rbs_generator.rb#13
  sig { overridable.returns(Parlour::RbsGenerator::Namespace) }
  def root; end
end

# Represents miscellaneous Ruby code.
#
# source://parlour//lib/parlour/rbs_generator/arbitrary.rb#5
class Parlour::RbsGenerator::Arbitrary < ::Parlour::RbsGenerator::RbsObject
  # source://parlour//lib/parlour/rbs_generator/arbitrary.rb#17
  sig do
    params(
      generator: ::Parlour::Generator,
      code: ::String,
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Arbitrary).void)
    ).void
  end
  def initialize(generator, code: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbs_generator/arbitrary.rb#33
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/rbs_generator/arbitrary.rb#25
  sig { returns(::String) }
  def code; end

  # @return [String]
  #
  # source://parlour//lib/parlour/rbs_generator/arbitrary.rb#25
  def code=(_arg0); end

  # source://parlour//lib/parlour/rbs_generator/arbitrary.rb#84
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbs_generator/arbitrary.rb#48
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  # source://parlour//lib/parlour/rbs_generator/arbitrary.rb#79
  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).void }
  def merge_into_self(others); end

  # source://parlour//lib/parlour/rbs_generator/arbitrary.rb#63
  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).returns(T::Boolean) }
  def mergeable?(others); end
end

# Represents an attribute reader, writer or accessor.
#
# source://parlour//lib/parlour/rbs_generator/attribute.rb#5
class Parlour::RbsGenerator::Attribute < ::Parlour::RbsGenerator::Method
  # source://parlour//lib/parlour/rbs_generator/attribute.rb#27
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      kind: ::Symbol,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Attribute).void)
    ).void
  end
  def initialize(generator, name, kind, type, &block); end

  # source://parlour//lib/parlour/rbs_generator/attribute.rb#75
  sig { override.params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/rbs_generator/attribute.rb#82
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbs_generator/attribute.rb#62
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  # source://parlour//lib/parlour/rbs_generator/attribute.rb#45
  sig { returns(::Symbol) }
  def kind; end

  # source://parlour//lib/parlour/rbs_generator/attribute.rb#49
  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end
end

# Represents a block in a method signature.
# (This is not an RbsObject because it doesn't generate a full line.)
#
# source://parlour//lib/parlour/rbs_generator/block.rb#6
class Parlour::RbsGenerator::Block
  # source://parlour//lib/parlour/rbs_generator/block.rb#14
  sig { params(type: ::Parlour::Types::Proc, required: T::Boolean).void }
  def initialize(type, required); end

  # source://parlour//lib/parlour/rbs_generator/block.rb#25
  sig { overridable.params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/rbs_generator/block.rb#44
  sig { params(options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(options); end

  # source://parlour//lib/parlour/rbs_generator/block.rb#37
  sig { returns(T::Boolean) }
  def required; end

  # source://parlour//lib/parlour/rbs_generator/block.rb#32
  sig { returns(::Parlour::Types::Proc) }
  def type; end
end

# Represents a class definition.
#
# source://parlour//lib/parlour/rbs_generator/class_namespace.rb#5
class Parlour::RbsGenerator::ClassNamespace < ::Parlour::RbsGenerator::Namespace
  extend T::Generic

  Child = type_member { { fixed: Parlour::RbsGenerator::RbsObject } }

  # source://parlour//lib/parlour/rbs_generator/class_namespace.rb#27
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      superclass: T.nilable(T.any(::Parlour::Types::Type, ::String)),
      block: T.nilable(T.proc.params(x: Parlour::RbsGenerator::ClassNamespace).void)
    ).void
  end
  def initialize(generator, name, superclass, &block); end

  # source://parlour//lib/parlour/rbs_generator/class_namespace.rb#97
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbs_generator/class_namespace.rb#38
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  # source://parlour//lib/parlour/rbs_generator/class_namespace.rb#85
  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).void }
  def merge_into_self(others); end

  # source://parlour//lib/parlour/rbs_generator/class_namespace.rb#66
  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).returns(T::Boolean) }
  def mergeable?(others); end

  # source://parlour//lib/parlour/rbs_generator/class_namespace.rb#52
  sig { returns(T.nilable(T.any(::Parlour::Types::Type, ::String))) }
  def superclass; end
end

# Represents a constant definition.
#
# source://parlour//lib/parlour/rbs_generator/constant.rb#5
class Parlour::RbsGenerator::Constant < ::Parlour::RbsGenerator::RbsObject
  # source://parlour//lib/parlour/rbs_generator/constant.rb#19
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Constant).void)
    ).void
  end
  def initialize(generator, name, type:, &block); end

  # source://parlour//lib/parlour/rbs_generator/constant.rb#35
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/rbs_generator/constant.rb#87
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbs_generator/constant.rb#50
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  # source://parlour//lib/parlour/rbs_generator/constant.rb#82
  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).void }
  def merge_into_self(others); end

  # source://parlour//lib/parlour/rbs_generator/constant.rb#65
  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).returns(T::Boolean) }
  def mergeable?(others); end

  # source://parlour//lib/parlour/rbs_generator/constant.rb#27
  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end
end

# Represents an +extend+ call.
#
# source://parlour//lib/parlour/rbs_generator/extend.rb#5
class Parlour::RbsGenerator::Extend < ::Parlour::RbsGenerator::RbsObject
  # source://parlour//lib/parlour/rbs_generator/extend.rb#16
  sig do
    params(
      generator: ::Parlour::Generator,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Extend).void)
    ).void
  end
  def initialize(generator, type:, &block); end

  # source://parlour//lib/parlour/rbs_generator/extend.rb#28
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/rbs_generator/extend.rb#84
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbs_generator/extend.rb#47
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  # source://parlour//lib/parlour/rbs_generator/extend.rb#79
  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).void }
  def merge_into_self(others); end

  # source://parlour//lib/parlour/rbs_generator/extend.rb#62
  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).returns(T::Boolean) }
  def mergeable?(others); end

  # source://parlour//lib/parlour/rbs_generator/extend.rb#34
  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end
end

# Represents an +include+ call.
#
# source://parlour//lib/parlour/rbs_generator/include.rb#5
class Parlour::RbsGenerator::Include < ::Parlour::RbsGenerator::RbsObject
  # source://parlour//lib/parlour/rbs_generator/include.rb#16
  sig do
    params(
      generator: ::Parlour::Generator,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Include).void)
    ).void
  end
  def initialize(generator, type:, &block); end

  # source://parlour//lib/parlour/rbs_generator/include.rb#28
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/rbs_generator/include.rb#84
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbs_generator/include.rb#47
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  # source://parlour//lib/parlour/rbs_generator/include.rb#79
  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).void }
  def merge_into_self(others); end

  # source://parlour//lib/parlour/rbs_generator/include.rb#62
  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).returns(T::Boolean) }
  def mergeable?(others); end

  # source://parlour//lib/parlour/rbs_generator/include.rb#34
  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end
end

# Represents an interface definition.
#
# source://parlour//lib/parlour/rbs_generator/interface_namespace.rb#5
class Parlour::RbsGenerator::InterfaceNamespace < ::Parlour::RbsGenerator::Namespace
  extend T::Generic

  Child = type_member { { fixed: Parlour::RbsGenerator::RbsObject } }

  # source://parlour//lib/parlour/rbs_generator/interface_namespace.rb#29
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbs_generator/interface_namespace.rb#21
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end
end

# Represents a method definition.
#
# source://parlour//lib/parlour/rbs_generator/method.rb#5
class Parlour::RbsGenerator::Method < ::Parlour::RbsGenerator::RbsObject
  # source://parlour//lib/parlour/rbs_generator/method.rb#29
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      signatures: T::Array[::Parlour::RbsGenerator::MethodSignature],
      class_method: T::Boolean,
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Method).void)
    ).void
  end
  def initialize(generator, name, signatures, class_method: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbs_generator/method.rb#42
  sig { overridable.params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/rbs_generator/method.rb#58
  sig { returns(T::Boolean) }
  def class_method; end

  # source://parlour//lib/parlour/rbs_generator/method.rb#137
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbs_generator/method.rb#71
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  # source://parlour//lib/parlour/rbs_generator/method.rb#132
  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).void }
  def merge_into_self(others); end

  # source://parlour//lib/parlour/rbs_generator/method.rb#115
  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).returns(T::Boolean) }
  def mergeable?(others); end

  # source://parlour//lib/parlour/rbs_generator/method.rb#52
  sig { returns(T::Array[::Parlour::RbsGenerator::MethodSignature]) }
  def signatures; end
end

# Represents one signature in a method definition.
# (This is not an RbsObject because it doesn't generate a full line.)
#
# source://parlour//lib/parlour/rbs_generator/method_signature.rb#6
class Parlour::RbsGenerator::MethodSignature
  # source://parlour//lib/parlour/rbs_generator/method_signature.rb#25
  sig do
    params(
      parameters: T::Array[::Parlour::RbsGenerator::Parameter],
      return_type: T.nilable(T.any(::Parlour::Types::Type, ::String)),
      block: T.nilable(::Parlour::RbsGenerator::Block),
      type_parameters: T.nilable(T::Array[::Symbol])
    ).void
  end
  def initialize(parameters, return_type = T.unsafe(nil), block: T.unsafe(nil), type_parameters: T.unsafe(nil)); end

  # source://parlour//lib/parlour/rbs_generator/method_signature.rb#38
  sig { overridable.params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/rbs_generator/method_signature.rb#59
  sig { returns(T.nilable(::Parlour::RbsGenerator::Block)) }
  def block; end

  # source://parlour//lib/parlour/rbs_generator/method_signature.rb#104
  sig { returns(::String) }
  def describe_in_method; end

  # source://parlour//lib/parlour/rbs_generator/method_signature.rb#71
  sig { params(options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(options); end

  # source://parlour//lib/parlour/rbs_generator/method_signature.rb#49
  sig { returns(T::Array[::Parlour::RbsGenerator::Parameter]) }
  def parameters; end

  # source://parlour//lib/parlour/rbs_generator/method_signature.rb#54
  sig { returns(T.nilable(T.any(::Parlour::Types::Type, ::String))) }
  def return_type; end

  # source://parlour//lib/parlour/rbs_generator/method_signature.rb#64
  sig { returns(T::Array[::Symbol]) }
  def type_parameters; end
end

# Represents a module definition.
#
# source://parlour//lib/parlour/rbs_generator/module_namespace.rb#5
class Parlour::RbsGenerator::ModuleNamespace < ::Parlour::RbsGenerator::Namespace
  extend T::Generic

  Child = type_member { { fixed: Parlour::RbsGenerator::RbsObject } }

  # source://parlour//lib/parlour/rbs_generator/module_namespace.rb#29
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbs_generator/module_namespace.rb#21
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end
end

# A generic namespace. This shouldn't be used, except as the type of
# {RbsGenerator#root}.
#
# source://parlour//lib/parlour/rbs_generator/namespace.rb#6
class Parlour::RbsGenerator::Namespace < ::Parlour::RbsGenerator::RbsObject
  extend T::Generic
  include ::Parlour::Mixin::Searchable

  Child = type_member { { fixed: Parlour::RbsGenerator::RbsObject } }

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#42
  sig do
    params(
      generator: ::Parlour::Generator,
      name: T.nilable(::String),
      block: T.nilable(T.proc.params(x: Parlour::RbsGenerator::Namespace).void)
    ).void
  end
  def initialize(generator, name = T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#139
  sig { params(comment: T.any(::String, T::Array[::String])).void }
  def add_comment_to_next_child(comment); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#80
  sig { returns(T::Array[::Parlour::RbsGenerator::TypeAlias]) }
  def aliases; end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#52
  sig { override.returns(T::Array[::Parlour::RbsGenerator::RbsObject]) }
  def children; end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#91
  sig { returns(T::Array[::Parlour::RbsGenerator::Constant]) }
  def constants; end

  # Creates a new arbitrary code section.
  # You should rarely have to use this!
  #
  # @param code [String] The code to insert.
  # @param block A block which the new instance yields itself to.
  # @return [RbsGenerator::Arbitrary]
  #
  # source://parlour//lib/parlour/rbs_generator/namespace.rb#357
  def create_arbitrary(code:, &block); end

  # @param name [String]
  # @param kind [Symbol]
  # @param type [Types::TypeLike]
  # @param block [T.proc.params(x: Attribute).void, nil]
  # @return [Attribute]
  #
  # source://sorbet-runtime/0.5.11150/lib/types/private/methods/_methods.rb#255
  def create_attr(*args, **_arg1, &blk); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#347
  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Attribute).void)
    ).returns(::Parlour::RbsGenerator::Attribute)
  end
  def create_attr_accessor(name, type:, &block); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#309
  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Attribute).void)
    ).returns(::Parlour::RbsGenerator::Attribute)
  end
  def create_attr_reader(name, type:, &block); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#328
  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Attribute).void)
    ).returns(::Parlour::RbsGenerator::Attribute)
  end
  def create_attr_writer(name, type:, &block); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#280
  sig do
    params(
      name: ::String,
      kind: ::Symbol,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Attribute).void)
    ).returns(::Parlour::RbsGenerator::Attribute)
  end
  def create_attribute(name, kind:, type:, &block); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#169
  sig do
    params(
      name: ::String,
      superclass: T.nilable(T.any(::Parlour::Types::Type, ::String)),
      block: T.nilable(T.proc.params(x: Parlour::RbsGenerator::ClassNamespace).void)
    ).returns(Parlour::RbsGenerator::ClassNamespace)
  end
  def create_class(name, superclass: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#450
  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Constant).void)
    ).returns(::Parlour::RbsGenerator::Constant)
  end
  def create_constant(name, type:, &block); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#377
  sig do
    params(
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Extend).void)
    ).returns(::Parlour::RbsGenerator::Extend)
  end
  def create_extend(type, &block); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#396
  sig do
    params(
      extendables: T::Array[T.any(::Parlour::Types::Type, ::String)]
    ).returns(T::Array[::Parlour::RbsGenerator::Extend])
  end
  def create_extends(extendables); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#413
  sig do
    params(
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Include).void)
    ).returns(::Parlour::RbsGenerator::Include)
  end
  def create_include(type, &block); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#432
  sig do
    params(
      includables: T::Array[T.any(::Parlour::Types::Type, ::String)]
    ).returns(T::Array[::Parlour::RbsGenerator::Include])
  end
  def create_includes(includables); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#211
  sig do
    params(
      name: ::String,
      block: T.nilable(T.proc.params(x: Parlour::RbsGenerator::Namespace).void)
    ).returns(Parlour::RbsGenerator::InterfaceNamespace)
  end
  def create_interface(name, &block); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#236
  sig do
    params(
      name: ::String,
      signatures: T.nilable(T::Array[::Parlour::RbsGenerator::MethodSignature]),
      class_method: T::Boolean,
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Method).void)
    ).returns(::Parlour::RbsGenerator::Method)
  end
  def create_method(name, signatures = T.unsafe(nil), class_method: T.unsafe(nil), &block); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#190
  sig do
    params(
      name: ::String,
      block: T.nilable(T.proc.params(x: Parlour::RbsGenerator::Namespace).void)
    ).returns(Parlour::RbsGenerator::ModuleNamespace)
  end
  def create_module(name, &block); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#472
  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::TypeAlias).void)
    ).returns(::Parlour::RbsGenerator::TypeAlias)
  end
  def create_type_alias(name, type:, &block); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#525
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#60
  sig { returns(T::Array[::Parlour::RbsGenerator::Extend]) }
  def extends; end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#21
  sig { override.overridable.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#70
  sig { returns(T::Array[::Parlour::RbsGenerator::Include]) }
  def includes; end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#515
  sig { override.overridable.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).void }
  def merge_into_self(others); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#497
  sig { override.overridable.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).returns(T::Boolean) }
  def mergeable?(others); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#104
  sig { params(object: T.untyped, block: T.proc.params(x: Parlour::RbsGenerator::Namespace).void).void }
  def path(object, &block); end

  # @return [Array<RbsGenerator::TypeAlias>]
  #
  # source://sorbet-runtime/0.5.11150/lib/types/private/methods/_methods.rb#255
  def type_aliases(*args, **_arg1, &blk); end

  private

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#545
  sig { overridable.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_body(indent_level, options); end

  # source://parlour//lib/parlour/rbs_generator/namespace.rb#621
  sig { params(object: ::Parlour::RbsGenerator::RbsObject).void }
  def move_next_comments(object); end
end

# Represents a method parameter with a Sorbet type signature.
#
# source://parlour//lib/parlour/rbs_generator/parameter.rb#5
class Parlour::RbsGenerator::Parameter
  # source://parlour//lib/parlour/rbs_generator/parameter.rb#37
  sig { params(name: ::String, type: T.nilable(T.any(::Parlour::Types::Type, ::String)), required: T::Boolean).void }
  def initialize(name, type: T.unsafe(nil), required: T.unsafe(nil)); end

  # source://parlour//lib/parlour/rbs_generator/parameter.rb#56
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/rbs_generator/parameter.rb#98
  sig { returns(::Symbol) }
  def kind; end

  # source://parlour//lib/parlour/rbs_generator/parameter.rb#68
  sig { returns(::String) }
  def name; end

  # source://parlour//lib/parlour/rbs_generator/parameter.rb#75
  sig { returns(::String) }
  def name_without_kind; end

  # source://parlour//lib/parlour/rbs_generator/parameter.rb#92
  sig { returns(T::Boolean) }
  def required; end

  # source://parlour//lib/parlour/rbs_generator/parameter.rb#119
  sig { returns(::String) }
  def to_rbs_param; end

  # source://parlour//lib/parlour/rbs_generator/parameter.rb#87
  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end
end

# A mapping of {kind} values to the characteristic prefixes each kind has.
#
# source://parlour//lib/parlour/rbs_generator/parameter.rb#109
Parlour::RbsGenerator::Parameter::PREFIXES = T.let(T.unsafe(nil), Hash)

# An array of reserved keywords in RBS which may be used as parameter
# names in standard Ruby.
# TODO: probably incomplete
#
# source://parlour//lib/parlour/rbs_generator/parameter.rb#103
Parlour::RbsGenerator::Parameter::RBS_KEYWORDS = T.let(T.unsafe(nil), Array)

# An abstract class which is subclassed by any classes which can generate
# entire lines of an RBS, such as {Namespace} and {Method}. (As an example,
# {Parameter} is _not_ a subclass because it does not generate lines, only
# segments of definition lines.)
#
# @abstract
#
# source://parlour//lib/parlour/rbs_generator/rbs_object.rb#9
class Parlour::RbsGenerator::RbsObject < ::Parlour::TypedObject
  abstract!

  # source://parlour//lib/parlour/rbs_generator/rbs_object.rb#19
  sig { params(generator: ::Parlour::Generator, name: ::String).void }
  def initialize(generator, name); end

  # @abstract
  #
  # source://parlour//lib/parlour/rbs_generator/rbs_object.rb#42
  sig { abstract.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  # source://parlour//lib/parlour/rbs_generator/rbs_object.rb#28
  sig { returns(::Parlour::Generator) }
  def generator; end

  # @abstract
  #
  # source://parlour//lib/parlour/rbs_generator/rbs_object.rb#70
  sig { abstract.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).void }
  def merge_into_self(others); end

  # @abstract
  #
  # source://parlour//lib/parlour/rbs_generator/rbs_object.rb#56
  sig { abstract.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).returns(T::Boolean) }
  def mergeable?(others); end
end

# Represents a type alias.
#
# source://parlour//lib/parlour/rbs_generator/type_alias.rb#5
class Parlour::RbsGenerator::TypeAlias < ::Parlour::RbsGenerator::RbsObject
  # source://parlour//lib/parlour/rbs_generator/type_alias.rb#18
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::TypeAlias).void)
    ).void
  end
  def initialize(generator, name:, type:, &block); end

  # source://parlour//lib/parlour/rbs_generator/type_alias.rb#34
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/rbs_generator/type_alias.rb#88
  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/rbs_generator/type_alias.rb#49
  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  # source://parlour//lib/parlour/rbs_generator/type_alias.rb#83
  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).void }
  def merge_into_self(others); end

  # source://parlour//lib/parlour/rbs_generator/type_alias.rb#66
  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).returns(T::Boolean) }
  def mergeable?(others); end

  # source://parlour//lib/parlour/rbs_generator/type_alias.rb#26
  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end
end

# source://parlour//lib/parlour/type_loader.rb#7
module Parlour::TypeLoader
  class << self
    # source://parlour//lib/parlour/type_loader.rb#29
    sig do
      params(
        filename: ::String,
        generator: T.nilable(::Parlour::RbiGenerator)
      ).returns(Parlour::RbiGenerator::Namespace)
    end
    def load_file(filename, generator: T.unsafe(nil)); end

    # source://parlour//lib/parlour/type_loader.rb#54
    sig do
      params(
        root: ::String,
        inclusions: T::Array[::String],
        exclusions: T::Array[::String],
        generator: T.nilable(::Parlour::RbiGenerator)
      ).returns(Parlour::RbiGenerator::Namespace)
    end
    def load_project(root, inclusions: T.unsafe(nil), exclusions: T.unsafe(nil), generator: T.unsafe(nil)); end

    # TODO: make this into a class which stores configuration and passes it to
    # all typeparsers
    #
    # source://parlour//lib/parlour/type_loader.rb#20
    sig do
      params(
        source: ::String,
        filename: T.nilable(::String),
        generator: T.nilable(::Parlour::RbiGenerator)
      ).returns(Parlour::RbiGenerator::Namespace)
    end
    def load_source(source, filename = T.unsafe(nil), generator: T.unsafe(nil)); end
  end
end

# Parses Ruby source to find Sorbet type signatures.
#
# source://parlour//lib/parlour/type_parser.rb#17
class Parlour::TypeParser
  # source://parlour//lib/parlour/type_parser.rb#95
  sig do
    params(
      ast: ::Parser::AST::Node,
      unknown_node_errors: T::Boolean,
      generator: T.nilable(::Parlour::RbiGenerator)
    ).void
  end
  def initialize(ast, unknown_node_errors: T.unsafe(nil), generator: T.unsafe(nil)); end

  # source://parlour//lib/parlour/type_parser.rb#119
  sig { returns(::Parser::AST::Node) }
  def ast; end

  # @return [Parser::AST::Node]
  #
  # source://parlour//lib/parlour/type_parser.rb#119
  def ast=(_arg0); end

  # source://parlour//lib/parlour/type_parser.rb#128
  sig { returns(::Parlour::RbiGenerator) }
  def generator; end

  # @return [RbiGenerator]
  #
  # source://parlour//lib/parlour/type_parser.rb#128
  def generator=(_arg0); end

  # Parses the entire source file and returns the resulting root namespace.
  #
  # source://parlour//lib/parlour/type_parser.rb#134
  sig { returns(Parlour::RbiGenerator::Namespace) }
  def parse_all; end

  # source://parlour//lib/parlour/type_parser.rb#649
  sig do
    params(
      path: ::Parlour::TypeParser::NodePath,
      is_within_eigenclass: T::Boolean
    ).returns(T::Array[::Parlour::RbiGenerator::Method])
  end
  def parse_method_into_methods(path, is_within_eigenclass: T.unsafe(nil)); end

  # source://parlour//lib/parlour/type_parser.rb#754
  sig { params(node: ::Parser::AST::Node).returns(::Parlour::Types::Type) }
  def parse_node_to_type(node); end

  # Given a path to a node in the AST, parses the object definitions it
  # represents and returns it, recursing to any child namespaces and parsing
  # any methods within.
  #
  # If the node directly represents several nodes, such as being a
  # (begin ...) node, they are all returned.
  #
  # source://parlour//lib/parlour/type_parser.rb#152
  sig do
    params(
      path: ::Parlour::TypeParser::NodePath,
      is_within_eigenclass: T::Boolean
    ).returns(T::Array[::Parlour::RbiGenerator::RbiObject])
  end
  def parse_path_to_object(path, is_within_eigenclass: T.unsafe(nil)); end

  # source://parlour//lib/parlour/type_parser.rb#496
  sig do
    params(
      path: ::Parlour::TypeParser::NodePath,
      is_within_eigenclass: T::Boolean
    ).returns(T::Array[::Parlour::RbiGenerator::Method])
  end
  def parse_sig_into_methods(path, is_within_eigenclass: T.unsafe(nil)); end

  # source://parlour//lib/parlour/type_parser.rb#418
  sig { params(path: ::Parlour::TypeParser::NodePath).returns(::Parlour::TypeParser::IntermediateSig) }
  def parse_sig_into_sig(path); end

  # source://parlour//lib/parlour/type_parser.rb#124
  sig { returns(T::Boolean) }
  def unknown_node_errors; end

  protected

  # source://parlour//lib/parlour/type_parser.rb#971
  sig { params(node: T.nilable(::Parser::AST::Node), modifier: ::Symbol).returns(T::Boolean) }
  def body_has_modifier?(node, modifier); end

  # source://parlour//lib/parlour/type_parser.rb#986
  sig { params(node: ::Parser::AST::Node).returns([T::Array[::String], T::Array[::String]]) }
  def body_includes_and_extends(node); end

  # source://parlour//lib/parlour/type_parser.rb#911
  sig { params(node: T.nilable(::Parser::AST::Node)).returns(T::Array[::Symbol]) }
  def constant_names(node); end

  # source://parlour//lib/parlour/type_parser.rb#953
  sig { params(node: T.nilable(::Parser::AST::Node)).returns(T.nilable(::String)) }
  def node_to_s(node); end

  # @raise [ParseError.new(buffer, range)]
  #
  # source://parlour//lib/parlour/type_parser.rb#1010
  sig { params(desc: ::String, node: T.any(::Parlour::TypeParser::NodePath, ::Parser::AST::Node)).returns(T.noreturn) }
  def parse_err(desc, node); end

  # source://parlour//lib/parlour/type_parser.rb#936
  sig { params(path: ::Parlour::TypeParser::NodePath).returns(T::Boolean) }
  def previous_sibling_sig_node?(path); end

  # source://parlour//lib/parlour/type_parser.rb#923
  sig { params(node: ::Parser::AST::Node).returns(T::Boolean) }
  def sig_node?(node); end

  # source://parlour//lib/parlour/type_parser.rb#893
  sig { params(msg: ::String, node: ::Parser::AST::Node).void }
  def warning(msg, node); end

  # @raise [ArgumentError]
  #
  # source://parlour//lib/parlour/type_parser.rb#1043
  sig do
    type_parameters(:A, :B)
      .params(
        a: T::Array[T.type_parameter(:A)],
        fa: T.proc.params(item: T.type_parameter(:A)).returns(T.untyped),
        b: T::Array[T.type_parameter(:B)],
        fb: T.proc.params(item: T.type_parameter(:B)).returns(T.untyped)
      ).returns(T::Array[[T.type_parameter(:A), T.type_parameter(:B)]])
  end
  def zip_by(a, fa, b, fb); end

  class << self
    # source://parlour//lib/parlour/type_parser.rb#108
    sig do
      params(
        filename: ::String,
        source: ::String,
        generator: T.nilable(::Parlour::RbiGenerator)
      ).returns(::Parlour::TypeParser)
    end
    def from_source(filename, source, generator: T.unsafe(nil)); end

    # source://parlour//lib/parlour/type_parser.rb#743
    sig { params(str: ::String).returns(::Parlour::Types::Type) }
    def parse_single_type(str); end
  end
end

# A parsed sig, not associated with a method.
#
# source://parlour//lib/parlour/type_parser.rb#399
class Parlour::TypeParser::IntermediateSig < ::T::Struct
  prop :type_parameters, T.nilable(T::Array[::Symbol])
  prop :overridable, T::Boolean
  prop :override, T::Boolean
  prop :abstract, T::Boolean
  prop :final, T::Boolean
  prop :return_type, T.nilable(::String)
  prop :params, T.nilable(T::Array[::Parser::AST::Node])

  class << self
    # source://sorbet-runtime/0.5.11150/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# Represents a path of indices which can be traversed to reach a specific
# node in an AST.
#
# source://parlour//lib/parlour/type_parser.rb#20
class Parlour::TypeParser::NodePath
  # source://parlour//lib/parlour/type_parser.rb#31
  sig { params(indices: T::Array[::Integer]).void }
  def initialize(indices); end

  # source://parlour//lib/parlour/type_parser.rb#48
  sig { params(index: ::Integer).returns(::Parlour::TypeParser::NodePath) }
  def child(index); end

  # source://parlour//lib/parlour/type_parser.rb#25
  sig { returns(T::Array[::Integer]) }
  def indices; end

  # source://parlour//lib/parlour/type_parser.rb#37
  sig { returns(::Parlour::TypeParser::NodePath) }
  def parent; end

  # source://parlour//lib/parlour/type_parser.rb#57
  sig { params(offset: ::Integer).returns(::Parlour::TypeParser::NodePath) }
  def sibling(offset); end

  # source://parlour//lib/parlour/type_parser.rb#74
  sig { params(start: ::Parser::AST::Node).returns(::Parser::AST::Node) }
  def traverse(start); end
end

# A generic superclass of all objects which form part of type definitions in,
# specific formats, such as RbiObject and RbsObject.
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://parlour//lib/parlour/typed_object.rb#5
class Parlour::TypedObject
  abstract!

  # source://parlour//lib/parlour/typed_object.rb#12
  sig { params(name: ::String).void }
  def initialize(name); end

  # source://parlour//lib/parlour/typed_object.rb#50
  sig { params(comment: T.any(::String, T::Array[::String])).void }
  def add_comment(comment); end

  # @param comment [String, Array<String>]
  # @return [void]
  #
  # source://sorbet-runtime/0.5.11150/lib/types/private/methods/_methods.rb#255
  def add_comments(*args, **_arg1, &blk); end

  # source://parlour//lib/parlour/typed_object.rb#32
  sig { returns(T::Array[::String]) }
  def comments; end

  # source://parlour//lib/parlour/typed_object.rb#65
  sig { returns(::String) }
  def describe; end

  # source://parlour//lib/parlour/typed_object.rb#116
  sig { params(tree: T.nilable(::Parlour::Debugging::Tree)).returns(::String) }
  def describe_tree(tree: T.unsafe(nil)); end

  # source://parlour//lib/parlour/typed_object.rb#21
  sig { returns(T.nilable(::Parlour::Plugin)) }
  def generated_by; end

  # @return [String]
  #
  # source://sorbet-runtime/0.5.11150/lib/types/private/methods/_methods.rb#255
  def inspect(*args, **_arg1, &blk); end

  # source://parlour//lib/parlour/typed_object.rb#26
  sig { returns(::String) }
  def name; end

  # @return [String]
  #
  # source://sorbet-runtime/0.5.11150/lib/types/private/methods/_methods.rb#255
  def to_s(*args, **_arg1, &blk); end

  protected

  # @abstract
  #
  # source://parlour//lib/parlour/typed_object.rb#153
  sig { abstract.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  # source://parlour//lib/parlour/typed_object.rb#166
  sig { params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_comments(indent_level, options); end
end

# Contains structured types which can be used in type signatures.
#
# source://parlour//lib/parlour/types.rb#5
module Parlour::Types; end

# An array with known element types.
#
# source://parlour//lib/parlour/types.rb#269
class Parlour::Types::Array < ::Parlour::Types::SingleElementCollection
  # source://parlour//lib/parlour/types.rb#276
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/types.rb#271
  sig { override.returns(::String) }
  def collection_name; end
end

# Type for a boolean.
#
# source://parlour//lib/parlour/types.rb#435
class Parlour::Types::Boolean < ::Parlour::Types::Type
  # source://parlour//lib/parlour/types.rb#437
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/types.rb#452
  sig { override.returns(::String) }
  def describe; end

  # source://parlour//lib/parlour/types.rb#442
  sig { override.returns(::String) }
  def generate_rbi; end

  # source://parlour//lib/parlour/types.rb#447
  sig { override.returns(::String) }
  def generate_rbs; end
end

# A type which represents the class of a type, rather than an instance.
# For example, "String" means an instance of String, but "Class(String)"
# means the actual String class.
#
# source://parlour//lib/parlour/types.rb#404
class Parlour::Types::Class < ::Parlour::Types::Type
  # source://parlour//lib/parlour/types.rb#406
  sig { params(type: T.any(::Parlour::Types::Type, ::String)).void }
  def initialize(type); end

  # source://parlour//lib/parlour/types.rb#411
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/types.rb#429
  sig { override.returns(::String) }
  def describe; end

  # source://parlour//lib/parlour/types.rb#419
  sig { override.returns(::String) }
  def generate_rbi; end

  # source://parlour//lib/parlour/types.rb#424
  sig { override.returns(::String) }
  def generate_rbs; end

  # source://parlour//lib/parlour/types.rb#416
  sig { returns(::Parlour::Types::Type) }
  def type; end
end

# An enumerable with known element types.
#
# source://parlour//lib/parlour/types.rb#308
class Parlour::Types::Enumerable < ::Parlour::Types::SingleElementCollection
  # source://parlour//lib/parlour/types.rb#315
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/types.rb#310
  sig { override.returns(::String) }
  def collection_name; end
end

# An enumerator with known element types.
#
# source://parlour//lib/parlour/types.rb#321
class Parlour::Types::Enumerator < ::Parlour::Types::SingleElementCollection
  # source://parlour//lib/parlour/types.rb#328
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/types.rb#323
  sig { override.returns(::String) }
  def collection_name; end
end

# A user-defined generic class with an arbitrary number of type
# parameters. This class assumes at least one type_param is
# provided, otherwise output will have empty type param lists.
#
# source://parlour//lib/parlour/types.rb#202
class Parlour::Types::Generic < ::Parlour::Types::Type
  # source://parlour//lib/parlour/types.rb#204
  sig do
    params(
      type: T.any(::Parlour::Types::Type, ::String),
      type_params: T::Array[T.any(::Parlour::Types::Type, ::String)]
    ).void
  end
  def initialize(type, type_params); end

  # source://parlour//lib/parlour/types.rb#210
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/types.rb#233
  sig { override.returns(::String) }
  def describe; end

  # source://parlour//lib/parlour/types.rb#223
  sig { override.returns(::String) }
  def generate_rbi; end

  # source://parlour//lib/parlour/types.rb#228
  sig { override.returns(::String) }
  def generate_rbs; end

  # source://parlour//lib/parlour/types.rb#217
  sig { returns(::Parlour::Types::Type) }
  def type; end

  # source://parlour//lib/parlour/types.rb#220
  sig { returns(T::Array[::Parlour::Types::Type]) }
  def type_params; end
end

# A hash with known key and value types.
#
# source://parlour//lib/parlour/types.rb#334
class Parlour::Types::Hash < ::Parlour::Types::Type
  # source://parlour//lib/parlour/types.rb#336
  sig { params(key: T.any(::Parlour::Types::Type, ::String), value: T.any(::Parlour::Types::Type, ::String)).void }
  def initialize(key, value); end

  # source://parlour//lib/parlour/types.rb#342
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/types.rb#363
  sig { override.returns(::String) }
  def describe; end

  # source://parlour//lib/parlour/types.rb#353
  sig { override.returns(::String) }
  def generate_rbi; end

  # source://parlour//lib/parlour/types.rb#358
  sig { override.returns(::String) }
  def generate_rbs; end

  # source://parlour//lib/parlour/types.rb#347
  sig { returns(::Parlour::Types::Type) }
  def key; end

  # source://parlour//lib/parlour/types.rb#350
  sig { returns(::Parlour::Types::Type) }
  def value; end
end

# A type which matches all of the wrapped types.
#
# source://parlour//lib/parlour/types.rb#138
class Parlour::Types::Intersection < ::Parlour::Types::Type
  # source://parlour//lib/parlour/types.rb#140
  sig { params(types: T::Array[T.any(::Parlour::Types::Type, ::String)]).void }
  def initialize(types); end

  # source://parlour//lib/parlour/types.rb#145
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/types.rb#163
  sig { override.returns(::String) }
  def describe; end

  # source://parlour//lib/parlour/types.rb#153
  sig { override.returns(::String) }
  def generate_rbi; end

  # source://parlour//lib/parlour/types.rb#158
  sig { override.returns(::String) }
  def generate_rbs; end

  # source://parlour//lib/parlour/types.rb#150
  sig { returns(T::Array[::Parlour::Types::Type]) }
  def types; end
end

# A type which can be either the wrapped type, or nil.
#
# source://parlour//lib/parlour/types.rb#76
class Parlour::Types::Nilable < ::Parlour::Types::Type
  # source://parlour//lib/parlour/types.rb#78
  sig { params(type: T.any(::Parlour::Types::Type, ::String)).void }
  def initialize(type); end

  # source://parlour//lib/parlour/types.rb#83
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/types.rb#101
  sig { override.returns(::String) }
  def describe; end

  # source://parlour//lib/parlour/types.rb#91
  sig { override.returns(::String) }
  def generate_rbi; end

  # source://parlour//lib/parlour/types.rb#96
  sig { override.returns(::String) }
  def generate_rbs; end

  # source://parlour//lib/parlour/types.rb#88
  sig { returns(::Parlour::Types::Type) }
  def type; end
end

# A type which can be called as a function.
#
# source://parlour//lib/parlour/types.rb#505
class Parlour::Types::Proc < ::Parlour::Types::Type
  # source://parlour//lib/parlour/types.rb#533
  sig do
    params(
      parameters: T::Array[::Parlour::Types::Proc::Parameter],
      return_type: T.nilable(T.any(::Parlour::Types::Type, ::String))
    ).void
  end
  def initialize(parameters, return_type); end

  # source://parlour//lib/parlour/types.rb#539
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/types.rb#568
  sig { override.returns(::String) }
  def describe; end

  # source://parlour//lib/parlour/types.rb#550
  sig { override.returns(::String) }
  def generate_rbi; end

  # source://parlour//lib/parlour/types.rb#560
  sig { override.returns(::String) }
  def generate_rbs; end

  # source://parlour//lib/parlour/types.rb#544
  sig { returns(T::Array[::Parlour::Types::Proc::Parameter]) }
  def parameters; end

  # source://parlour//lib/parlour/types.rb#547
  sig { returns(T.nilable(::Parlour::Types::Type)) }
  def return_type; end
end

# A parameter to a proc.
#
# source://parlour//lib/parlour/types.rb#506
class Parlour::Types::Proc::Parameter
  # source://parlour//lib/parlour/types.rb#510
  sig { params(name: ::String, type: T.any(::Parlour::Types::Type, ::String), default: T.nilable(::String)).void }
  def initialize(name, type, default = T.unsafe(nil)); end

  # source://parlour//lib/parlour/types.rb#526
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/types.rb#523
  sig { returns(T.nilable(::String)) }
  def default; end

  # source://parlour//lib/parlour/types.rb#517
  sig { returns(::String) }
  def name; end

  # source://parlour//lib/parlour/types.rb#520
  sig { returns(::Parlour::Types::Type) }
  def type; end
end

# A range with known element types.
#
# source://parlour//lib/parlour/types.rb#295
class Parlour::Types::Range < ::Parlour::Types::SingleElementCollection
  # source://parlour//lib/parlour/types.rb#302
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/types.rb#297
  sig { override.returns(::String) }
  def collection_name; end
end

# A basic type as a raw string.
#
# source://parlour//lib/parlour/types.rb#45
class Parlour::Types::Raw < ::Parlour::Types::Type
  # source://parlour//lib/parlour/types.rb#47
  sig { params(str: ::String).void }
  def initialize(str); end

  # source://parlour//lib/parlour/types.rb#55
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/types.rb#70
  sig { override.returns(::String) }
  def describe; end

  # source://parlour//lib/parlour/types.rb#60
  sig { override.returns(::String) }
  def generate_rbi; end

  # source://parlour//lib/parlour/types.rb#65
  sig { override.returns(::String) }
  def generate_rbs; end

  # source://parlour//lib/parlour/types.rb#52
  sig { returns(::String) }
  def str; end
end

# A record/shape; a hash with a fixed set of keys with given types.
#
# source://parlour//lib/parlour/types.rb#369
class Parlour::Types::Record < ::Parlour::Types::Type
  # source://parlour//lib/parlour/types.rb#371
  sig { params(keys_to_types: T::Hash[::Symbol, T.any(::Parlour::Types::Type, ::String)]).void }
  def initialize(keys_to_types); end

  # source://parlour//lib/parlour/types.rb#378
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/types.rb#396
  sig { override.returns(::String) }
  def describe; end

  # source://parlour//lib/parlour/types.rb#386
  sig { override.returns(::String) }
  def generate_rbi; end

  # source://parlour//lib/parlour/types.rb#391
  sig { override.returns(::String) }
  def generate_rbs; end

  # source://parlour//lib/parlour/types.rb#383
  sig { returns(T::Hash[::Symbol, ::Parlour::Types::Type]) }
  def keys_to_types; end
end

# Type equivalent to the receiver.
#
# source://parlour//lib/parlour/types.rb#458
class Parlour::Types::Self < ::Parlour::Types::Type
  # source://parlour//lib/parlour/types.rb#460
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/types.rb#475
  sig { override.returns(::String) }
  def describe; end

  # source://parlour//lib/parlour/types.rb#465
  sig { override.returns(::String) }
  def generate_rbi; end

  # source://parlour//lib/parlour/types.rb#470
  sig { override.returns(::String) }
  def generate_rbs; end
end

# A set with known element types.
#
# source://parlour//lib/parlour/types.rb#282
class Parlour::Types::Set < ::Parlour::Types::SingleElementCollection
  # source://parlour//lib/parlour/types.rb#289
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/types.rb#284
  sig { override.returns(::String) }
  def collection_name; end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://parlour//lib/parlour/types.rb#238
class Parlour::Types::SingleElementCollection < ::Parlour::Types::Type
  abstract!

  # source://parlour//lib/parlour/types.rb#242
  sig { params(element: T.any(::Parlour::Types::Type, ::String)).void }
  def initialize(element); end

  # @abstract
  #
  # source://parlour//lib/parlour/types.rb#250
  sig { abstract.returns(::String) }
  def collection_name; end

  # source://parlour//lib/parlour/types.rb#263
  sig { override.returns(::String) }
  def describe; end

  # source://parlour//lib/parlour/types.rb#247
  sig { returns(::Parlour::Types::Type) }
  def element; end

  # source://parlour//lib/parlour/types.rb#253
  sig { override.returns(::String) }
  def generate_rbi; end

  # source://parlour//lib/parlour/types.rb#258
  sig { override.returns(::String) }
  def generate_rbs; end
end

# A fixed-length array of items, each with a known type.
#
# source://parlour//lib/parlour/types.rb#169
class Parlour::Types::Tuple < ::Parlour::Types::Type
  # source://parlour//lib/parlour/types.rb#171
  sig { params(types: T::Array[T.any(::Parlour::Types::Type, ::String)]).void }
  def initialize(types); end

  # source://parlour//lib/parlour/types.rb#176
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/types.rb#194
  sig { override.returns(::String) }
  def describe; end

  # source://parlour//lib/parlour/types.rb#184
  sig { override.returns(::String) }
  def generate_rbi; end

  # source://parlour//lib/parlour/types.rb#189
  sig { override.returns(::String) }
  def generate_rbs; end

  # source://parlour//lib/parlour/types.rb#181
  sig { returns(T::Array[::Parlour::Types::Type]) }
  def types; end
end

# The top-level, abstract class for a generalised type. All of the other
# types inherit from this. Do not instantiate.
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://parlour//lib/parlour/types.rb#10
class Parlour::Types::Type
  abstract!

  # @abstract
  #
  # source://parlour//lib/parlour/types.rb#41
  sig { abstract.returns(::String) }
  def describe; end

  # @abstract
  #
  # source://parlour//lib/parlour/types.rb#17
  sig { abstract.returns(::String) }
  def generate_rbi; end

  # @abstract
  #
  # source://parlour//lib/parlour/types.rb#20
  sig { abstract.returns(::String) }
  def generate_rbs; end

  # source://parlour//lib/parlour/types.rb#36
  def hash; end

  # source://parlour//lib/parlour/types.rb#32
  sig { params(type_like: T.any(::Parlour::Types::Type, ::String)).returns(::Parlour::Types::Type) }
  def to_type(type_like); end

  class << self
    # source://parlour//lib/parlour/types.rb#23
    sig { params(type_like: T.any(::Parlour::Types::Type, ::String)).returns(::Parlour::Types::Type) }
    def to_type(type_like); end
  end
end

# source://parlour//lib/parlour/types.rb#6
Parlour::Types::TypeLike = T.type_alias { T.any(::Parlour::Types::Type, ::String) }

# A type which is (at least) one of the wrapped types.
#
# source://parlour//lib/parlour/types.rb#107
class Parlour::Types::Union < ::Parlour::Types::Type
  # source://parlour//lib/parlour/types.rb#109
  sig { params(types: T::Array[T.any(::Parlour::Types::Type, ::String)]).void }
  def initialize(types); end

  # source://parlour//lib/parlour/types.rb#114
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/types.rb#132
  sig { override.returns(::String) }
  def describe; end

  # source://parlour//lib/parlour/types.rb#122
  sig { override.returns(::String) }
  def generate_rbi; end

  # source://parlour//lib/parlour/types.rb#127
  sig { override.returns(::String) }
  def generate_rbs; end

  # source://parlour//lib/parlour/types.rb#119
  sig { returns(T::Array[::Parlour::Types::Type]) }
  def types; end
end

# The explicit lack of a type.
#
# source://parlour//lib/parlour/types.rb#481
class Parlour::Types::Untyped < ::Parlour::Types::Type
  # source://parlour//lib/parlour/types.rb#483
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://parlour//lib/parlour/types.rb#498
  sig { override.returns(::String) }
  def describe; end

  # source://parlour//lib/parlour/types.rb#488
  sig { override.returns(::String) }
  def generate_rbi; end

  # source://parlour//lib/parlour/types.rb#493
  sig { override.returns(::String) }
  def generate_rbs; end
end

# The library version.
#
# source://parlour//lib/parlour/version.rb#4
Parlour::VERSION = T.let(T.unsafe(nil), String)
