# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `prism` gem.
# Please instead update this file by running `bin/tapioca gem prism`.

# =begin
# This file is generated by the templates/template.rb script and should not be
# modified manually. See templates/rbi/prism.rbi.erb
# if you are looking to modify the template
# =end

# The Prism Ruby parser.
#
# "Parsing Ruby is suddenly manageable!"
#   - You, hopefully
#
# source://prism//lib/prism.rb#8
module Prism
  class << self
    # Mirror the Prism.dump API by using the serialization API.
    def dump(*_arg0); end

    # Mirror the Prism.dump_file API by using the serialization API.
    def dump_file(*_arg0); end

    # Mirror the Prism.lex API by using the serialization API.
    def lex(*_arg0); end

    # :call-seq:
    #   Prism::lex_compat(source, **options) -> ParseResult
    #
    # Returns a parse result whose value is an array of tokens that closely
    # resembles the return value of Ripper::lex. The main difference is that the
    # `:on_sp` token is not emitted.
    #
    # For supported options, see Prism::parse.
    #
    # source://prism//lib/prism.rb#46
    def lex_compat(source, **options); end

    # Mirror the Prism.lex_file API by using the serialization API.
    def lex_file(*_arg0); end

    # :call-seq:
    #   Prism::lex_ripper(source) -> Array
    #
    # This lexes with the Ripper lex. It drops any space events but otherwise
    # returns the same tokens. Raises SyntaxError if the syntax in source is
    # invalid.
    #
    # source://prism//lib/prism.rb#56
    def lex_ripper(source); end

    # :call-seq:
    #   Prism::load(source, serialized) -> ParseResult
    #
    # Load the serialized AST using the source as a reference into a tree.
    #
    # source://prism//lib/prism.rb#64
    def load(source, serialized); end

    # Mirror the Prism.parse API by using the serialization API.
    def parse(*_arg0); end

    # Mirror the Prism.parse_comments API by using the serialization API.
    def parse_comments(*_arg0); end

    # :call-seq:
    #   Prism::parse_failure?(source, **options) -> bool
    #
    # Returns true if the source parses with errors.
    #
    # @return [Boolean]
    #
    # source://prism//lib/prism.rb#72
    def parse_failure?(source, **options); end

    # Mirror the Prism.parse_file API by using the serialization API. This uses
    # native strings instead of Ruby strings because it allows us to use mmap when
    # it is available.
    def parse_file(*_arg0); end

    # Mirror the Prism.parse_file_comments API by using the serialization
    # API. This uses native strings instead of Ruby strings because it allows us
    # to use mmap when it is available.
    def parse_file_comments(*_arg0); end

    # :call-seq:
    #   Prism::parse_file_failure?(filepath, **options) -> bool
    #
    # Returns true if the file at filepath parses with errors.
    #
    # @return [Boolean]
    #
    # source://prism//lib/prism.rb#80
    def parse_file_failure?(filepath, **options); end

    # Mirror the Prism.parse_file_success? API by using the serialization API.
    #
    # @return [Boolean]
    def parse_file_success?(*_arg0); end

    # Mirror the Prism.parse_lex API by using the serialization API.
    def parse_lex(*_arg0); end

    # Mirror the Prism.parse_lex_file API by using the serialization API.
    def parse_lex_file(*_arg0); end

    # Mirror the Prism.parse_success? API by using the serialization API.
    #
    # @return [Boolean]
    def parse_success?(*_arg0); end
  end
end

# Represents the use of the `alias` keyword to alias a global variable.
#
#     alias $foo $bar
#     ^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#53
class Prism::AliasGlobalVariableNode < ::Prism::Node
  # def initialize: (new_name: Node, old_name: Node, keyword_loc: Location, location: Location) -> void
  #
  # @return [AliasGlobalVariableNode] a new instance of AliasGlobalVariableNode
  #
  # source://prism//lib/prism/node.rb#63
  sig do
    params(
      new_name: Prism::Node,
      old_name: Prism::Node,
      keyword_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(new_name, old_name, keyword_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#71
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#76
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#86
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#81
  def compact_child_nodes; end

  # def copy: (**params) -> AliasGlobalVariableNode
  #
  # source://prism//lib/prism/node.rb#91
  sig { params(params: T.untyped).returns(Prism::AliasGlobalVariableNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#76
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#104
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#114
  def inspect(inspector = T.unsafe(nil)); end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#109
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#60
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # attr_reader new_name: Node
  #
  # source://prism//lib/prism/node.rb#54
  sig { returns(Prism::Node) }
  def new_name; end

  # attr_reader old_name: Node
  #
  # source://prism//lib/prism/node.rb#57
  sig { returns(Prism::Node) }
  def old_name; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#138
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#148
    def type; end
  end
end

# Represents the use of the `alias` keyword to alias a method.
#
#     alias foo bar
#     ^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#158
class Prism::AliasMethodNode < ::Prism::Node
  # def initialize: (new_name: Node, old_name: Node, keyword_loc: Location, location: Location) -> void
  #
  # @return [AliasMethodNode] a new instance of AliasMethodNode
  #
  # source://prism//lib/prism/node.rb#168
  sig do
    params(
      new_name: Prism::Node,
      old_name: Prism::Node,
      keyword_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(new_name, old_name, keyword_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#176
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#181
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#191
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#186
  def compact_child_nodes; end

  # def copy: (**params) -> AliasMethodNode
  #
  # source://prism//lib/prism/node.rb#196
  sig { params(params: T.untyped).returns(Prism::AliasMethodNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#181
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#209
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#219
  def inspect(inspector = T.unsafe(nil)); end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#214
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#165
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # attr_reader new_name: Node
  #
  # source://prism//lib/prism/node.rb#159
  sig { returns(Prism::Node) }
  def new_name; end

  # attr_reader old_name: Node
  #
  # source://prism//lib/prism/node.rb#162
  sig { returns(Prism::Node) }
  def old_name; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#243
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#253
    def type; end
  end
end

# Represents an alternation pattern in pattern matching.
#
#     foo => bar | baz
#            ^^^^^^^^^
#
# source://prism//lib/prism/node.rb#263
class Prism::AlternationPatternNode < ::Prism::Node
  # def initialize: (left: Node, right: Node, operator_loc: Location, location: Location) -> void
  #
  # @return [AlternationPatternNode] a new instance of AlternationPatternNode
  #
  # source://prism//lib/prism/node.rb#273
  sig { params(left: Prism::Node, right: Prism::Node, operator_loc: Prism::Location, location: Prism::Location).void }
  def initialize(left, right, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#281
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#286
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#296
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#291
  def compact_child_nodes; end

  # def copy: (**params) -> AlternationPatternNode
  #
  # source://prism//lib/prism/node.rb#301
  sig { params(params: T.untyped).returns(Prism::AlternationPatternNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#286
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#314
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#324
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader left: Node
  #
  # source://prism//lib/prism/node.rb#264
  sig { returns(Prism::Node) }
  def left; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#319
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#270
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader right: Node
  #
  # source://prism//lib/prism/node.rb#267
  sig { returns(Prism::Node) }
  def right; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#348
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#358
    def type; end
  end
end

# Represents the use of the `&&` operator or the `and` keyword.
#
#     left and right
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#368
class Prism::AndNode < ::Prism::Node
  # def initialize: (left: Node, right: Node, operator_loc: Location, location: Location) -> void
  #
  # @return [AndNode] a new instance of AndNode
  #
  # source://prism//lib/prism/node.rb#378
  sig { params(left: Prism::Node, right: Prism::Node, operator_loc: Prism::Location, location: Prism::Location).void }
  def initialize(left, right, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#386
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#391
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#401
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#396
  def compact_child_nodes; end

  # def copy: (**params) -> AndNode
  #
  # source://prism//lib/prism/node.rb#406
  sig { params(params: T.untyped).returns(Prism::AndNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#391
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#419
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#429
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader left: Node
  #
  # source://prism//lib/prism/node.rb#369
  sig { returns(Prism::Node) }
  def left; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#424
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#375
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader right: Node
  #
  # source://prism//lib/prism/node.rb#372
  sig { returns(Prism::Node) }
  def right; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#453
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#463
    def type; end
  end
end

# Represents a set of arguments to a method or a keyword.
#
#     return foo, bar, baz
#            ^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#473
class Prism::ArgumentsNode < ::Prism::Node
  # def initialize: (flags: Integer, arguments: Array[Node], location: Location) -> void
  #
  # @return [ArgumentsNode] a new instance of ArgumentsNode
  #
  # source://prism//lib/prism/node.rb#480
  sig { params(flags: Integer, arguments: T::Array[Prism::Node], location: Prism::Location).void }
  def initialize(flags, arguments, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#487
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader arguments: Array[Node]
  #
  # source://prism//lib/prism/node.rb#477
  sig { returns(T::Array[Prism::Node]) }
  def arguments; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#492
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#502
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#497
  def compact_child_nodes; end

  # def contains_keyword_splat?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#524
  sig { returns(T::Boolean) }
  def contains_keyword_splat?; end

  # def copy: (**params) -> ArgumentsNode
  #
  # source://prism//lib/prism/node.rb#507
  sig { params(params: T.untyped).returns(Prism::ArgumentsNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#492
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#519
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#529
  def inspect(inspector = T.unsafe(nil)); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#551
  def type; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#474
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#561
    def type; end
  end
end

# Flags for arguments nodes.
#
# source://prism//lib/prism/node.rb#17277
module Prism::ArgumentsNodeFlags; end

# if arguments contain keyword splat
#
# source://prism//lib/prism/node.rb#17279
Prism::ArgumentsNodeFlags::CONTAINS_KEYWORD_SPLAT = T.let(T.unsafe(nil), Integer)

# Represents an array literal. This can be a regular array using brackets or
# a special array using % like %w or %i.
#
#     [1, 2, 3]
#     ^^^^^^^^^
#
# source://prism//lib/prism/node.rb#572
class Prism::ArrayNode < ::Prism::Node
  # def initialize: (flags: Integer, elements: Array[Node], opening_loc: Location?, closing_loc: Location?, location: Location) -> void
  #
  # @return [ArrayNode] a new instance of ArrayNode
  #
  # source://prism//lib/prism/node.rb#585
  sig do
    params(
      flags: Integer,
      elements: T::Array[Prism::Node],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location),
      location: Prism::Location
    ).void
  end
  def initialize(flags, elements, opening_loc, closing_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#594
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#599
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#643
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#582
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#609
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#604
  def compact_child_nodes; end

  # def contains_splat?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#633
  sig { returns(T::Boolean) }
  def contains_splat?; end

  # def copy: (**params) -> ArrayNode
  #
  # source://prism//lib/prism/node.rb#614
  sig { params(params: T.untyped).returns(Prism::ArrayNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#599
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#628
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # attr_reader elements: Array[Node]
  #
  # source://prism//lib/prism/node.rb#576
  sig { returns(T::Array[Prism::Node]) }
  def elements; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#648
  def inspect(inspector = T.unsafe(nil)); end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#638
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#579
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#672
  def type; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#573
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#682
    def type; end
  end
end

# Flags for array nodes.
#
# source://prism//lib/prism/node.rb#17283
module Prism::ArrayNodeFlags; end

# if array contains splat nodes
#
# source://prism//lib/prism/node.rb#17285
Prism::ArrayNodeFlags::CONTAINS_SPLAT = T.let(T.unsafe(nil), Integer)

# Represents an array pattern in pattern matching.
#
#     foo in 1, 2
#     ^^^^^^^^^^^
#
#     foo in [1, 2]
#     ^^^^^^^^^^^^^
#
#     foo in *1
#     ^^^^^^^^^
#
#     foo in Bar[]
#     ^^^^^^^^^^^^
#
#     foo in Bar[1, 2, 3]
#     ^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#704
class Prism::ArrayPatternNode < ::Prism::Node
  # def initialize: (constant: Node?, requireds: Array[Node], rest: Node?, posts: Array[Node], opening_loc: Location?, closing_loc: Location?, location: Location) -> void
  #
  # @return [ArrayPatternNode] a new instance of ArrayPatternNode
  #
  # source://prism//lib/prism/node.rb#723
  sig do
    params(
      constant: T.nilable(Prism::Node),
      requireds: T::Array[Prism::Node],
      rest: T.nilable(Prism::Node),
      posts: T::Array[Prism::Node],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location),
      location: Prism::Location
    ).void
  end
  def initialize(constant, requireds, rest, posts, opening_loc, closing_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#734
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#739
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#785
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#720
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#754
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#744
  def compact_child_nodes; end

  # attr_reader constant: Node?
  #
  # source://prism//lib/prism/node.rb#705
  sig { returns(T.nilable(Prism::Node)) }
  def constant; end

  # def copy: (**params) -> ArrayPatternNode
  #
  # source://prism//lib/prism/node.rb#759
  sig { params(params: T.untyped).returns(Prism::ArrayPatternNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#739
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#775
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#790
  def inspect(inspector = T.unsafe(nil)); end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#780
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#717
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # attr_reader posts: Array[Node]
  #
  # source://prism//lib/prism/node.rb#714
  sig { returns(T::Array[Prism::Node]) }
  def posts; end

  # attr_reader requireds: Array[Node]
  #
  # source://prism//lib/prism/node.rb#708
  sig { returns(T::Array[Prism::Node]) }
  def requireds; end

  # attr_reader rest: Node?
  #
  # source://prism//lib/prism/node.rb#711
  sig { returns(T.nilable(Prism::Node)) }
  def rest; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#825
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#835
    def type; end
  end
end

# Represents a hash key/value pair.
#
#     { a => b }
#       ^^^^^^
#
# source://prism//lib/prism/node.rb#845
class Prism::AssocNode < ::Prism::Node
  # def initialize: (key: Node, value: Node?, operator_loc: Location?, location: Location) -> void
  #
  # @return [AssocNode] a new instance of AssocNode
  #
  # source://prism//lib/prism/node.rb#855
  sig do
    params(
      key: Prism::Node,
      value: T.nilable(Prism::Node),
      operator_loc: T.nilable(Prism::Location),
      location: Prism::Location
    ).void
  end
  def initialize(key, value, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#863
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#868
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#881
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#873
  def compact_child_nodes; end

  # def copy: (**params) -> AssocNode
  #
  # source://prism//lib/prism/node.rb#886
  sig { params(params: T.untyped).returns(Prism::AssocNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#868
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#899
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#909
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader key: Node
  #
  # source://prism//lib/prism/node.rb#846
  sig { returns(Prism::Node) }
  def key; end

  # def operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#904
  sig { returns(T.nilable(String)) }
  def operator; end

  # attr_reader operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#852
  sig { returns(T.nilable(Prism::Location)) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#937
  def type; end

  # attr_reader value: Node?
  #
  # source://prism//lib/prism/node.rb#849
  sig { returns(T.nilable(Prism::Node)) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#947
    def type; end
  end
end

# Represents a splat in a hash literal.
#
#     { **foo }
#       ^^^^^
#
# source://prism//lib/prism/node.rb#957
class Prism::AssocSplatNode < ::Prism::Node
  # def initialize: (value: Node?, operator_loc: Location, location: Location) -> void
  #
  # @return [AssocSplatNode] a new instance of AssocSplatNode
  #
  # source://prism//lib/prism/node.rb#964
  sig { params(value: T.nilable(Prism::Node), operator_loc: Prism::Location, location: Prism::Location).void }
  def initialize(value, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#971
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#976
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#988
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#981
  def compact_child_nodes; end

  # def copy: (**params) -> AssocSplatNode
  #
  # source://prism//lib/prism/node.rb#993
  sig { params(params: T.untyped).returns(Prism::AssocSplatNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#976
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#1005
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#1015
  def inspect(inspector = T.unsafe(nil)); end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#1010
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#961
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#1041
  def type; end

  # attr_reader value: Node?
  #
  # source://prism//lib/prism/node.rb#958
  sig { returns(T.nilable(Prism::Node)) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#1051
    def type; end
  end
end

Prism::BACKEND = T.let(T.unsafe(nil), Symbol)

# Represents reading a reference to a field in the previous match.
#
#     $'
#     ^^
#
# source://prism//lib/prism/node.rb#1061
class Prism::BackReferenceReadNode < ::Prism::Node
  # def initialize: (name: Symbol, location: Location) -> void
  #
  # @return [BackReferenceReadNode] a new instance of BackReferenceReadNode
  #
  # source://prism//lib/prism/node.rb#1065
  sig { params(name: Symbol, location: Prism::Location).void }
  def initialize(name, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1071
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1076
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1086
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1081
  def compact_child_nodes; end

  # def copy: (**params) -> BackReferenceReadNode
  #
  # source://prism//lib/prism/node.rb#1091
  sig { params(params: T.untyped).returns(Prism::BackReferenceReadNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1076
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#1102
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#1107
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#1062
  sig { returns(Symbol) }
  def name; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#1127
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#1137
    def type; end
  end
end

# A class that knows how to walk down the tree. None of the individual visit
# methods are implemented on this visitor, so it forces the consumer to
# implement each one that they need. For a default implementation that
# continues walking the tree, see the Visitor class.
#
# source://prism//lib/prism/visitor.rb#13
class Prism::BasicVisitor
  # Calls `accept` on the given node if it is not `nil`, which in turn should
  # call back into this visitor by calling the appropriate `visit_*` method.
  #
  # source://prism//lib/prism/visitor.rb#16
  sig { params(node: T.nilable(Prism::Node)).void }
  def visit(node); end

  # Visits each node in `nodes` by calling `accept` on each one.
  #
  # source://prism//lib/prism/visitor.rb#21
  sig { params(nodes: T::Array[T.nilable(Prism::Node)]).void }
  def visit_all(nodes); end

  # Visits the child nodes of `node` by calling `accept` on each one.
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::Node).void }
  def visit_child_nodes(node); end
end

# Represents a begin statement.
#
#     begin
#       foo
#     end
#     ^^^^^
#
# source://prism//lib/prism/node.rb#1149
class Prism::BeginNode < ::Prism::Node
  # def initialize: (begin_keyword_loc: Location?, statements: StatementsNode?, rescue_clause: RescueNode?, else_clause: ElseNode?, ensure_clause: EnsureNode?, end_keyword_loc: Location?, location: Location) -> void
  #
  # @return [BeginNode] a new instance of BeginNode
  #
  # source://prism//lib/prism/node.rb#1168
  sig do
    params(
      begin_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode),
      rescue_clause: T.nilable(Prism::RescueNode),
      else_clause: T.nilable(Prism::ElseNode),
      ensure_clause: T.nilable(Prism::EnsureNode),
      end_keyword_loc: T.nilable(Prism::Location),
      location: Prism::Location
    ).void
  end
  def initialize(begin_keyword_loc, statements, rescue_clause, else_clause, ensure_clause, end_keyword_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1179
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def begin_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#1229
  sig { returns(T.nilable(String)) }
  def begin_keyword; end

  # attr_reader begin_keyword_loc: Location?
  #
  # source://prism//lib/prism/node.rb#1150
  sig { returns(T.nilable(Prism::Location)) }
  def begin_keyword_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1188
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1203
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1193
  def compact_child_nodes; end

  # def copy: (**params) -> BeginNode
  #
  # source://prism//lib/prism/node.rb#1208
  sig { params(params: T.untyped).returns(Prism::BeginNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1188
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#1224
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # attr_reader else_clause: ElseNode?
  #
  # source://prism//lib/prism/node.rb#1159
  sig { returns(T.nilable(Prism::ElseNode)) }
  def else_clause; end

  # def end_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#1234
  sig { returns(T.nilable(String)) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location?
  #
  # source://prism//lib/prism/node.rb#1165
  sig { returns(T.nilable(Prism::Location)) }
  def end_keyword_loc; end

  # attr_reader ensure_clause: EnsureNode?
  #
  # source://prism//lib/prism/node.rb#1162
  sig { returns(T.nilable(Prism::EnsureNode)) }
  def ensure_clause; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#1239
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader rescue_clause: RescueNode?
  #
  # source://prism//lib/prism/node.rb#1156
  sig { returns(T.nilable(Prism::RescueNode)) }
  def rescue_clause; end

  # source://prism//lib/prism/node.rb#1183
  def set_newline_flag(newline_marked); end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#1153
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#1284
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#1294
    def type; end
  end
end

# Represents block method arguments.
#
#     bar(&args)
#     ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#1304
class Prism::BlockArgumentNode < ::Prism::Node
  # def initialize: (expression: Node?, operator_loc: Location, location: Location) -> void
  #
  # @return [BlockArgumentNode] a new instance of BlockArgumentNode
  #
  # source://prism//lib/prism/node.rb#1311
  sig { params(expression: T.nilable(Prism::Node), operator_loc: Prism::Location, location: Prism::Location).void }
  def initialize(expression, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1318
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1323
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1335
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1328
  def compact_child_nodes; end

  # def copy: (**params) -> BlockArgumentNode
  #
  # source://prism//lib/prism/node.rb#1340
  sig { params(params: T.untyped).returns(Prism::BlockArgumentNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1323
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#1352
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # attr_reader expression: Node?
  #
  # source://prism//lib/prism/node.rb#1305
  sig { returns(T.nilable(Prism::Node)) }
  def expression; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#1362
  def inspect(inspector = T.unsafe(nil)); end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#1357
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#1308
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#1388
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#1398
    def type; end
  end
end

# Represents a block local variable.
#
#     a { |; b| }
#            ^
#
# source://prism//lib/prism/node.rb#1408
class Prism::BlockLocalVariableNode < ::Prism::Node
  # def initialize: (name: Symbol, location: Location) -> void
  #
  # @return [BlockLocalVariableNode] a new instance of BlockLocalVariableNode
  #
  # source://prism//lib/prism/node.rb#1412
  sig { params(name: Symbol, location: Prism::Location).void }
  def initialize(name, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1418
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1423
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1433
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1428
  def compact_child_nodes; end

  # def copy: (**params) -> BlockLocalVariableNode
  #
  # source://prism//lib/prism/node.rb#1438
  sig { params(params: T.untyped).returns(Prism::BlockLocalVariableNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1423
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#1449
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#1454
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#1409
  sig { returns(Symbol) }
  def name; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#1474
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#1484
    def type; end
  end
end

# Represents a block of ruby code.
#
# [1, 2, 3].each { |i| puts x }
#                ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#1494
class Prism::BlockNode < ::Prism::Node
  # def initialize: (locals: Array[Symbol], locals_body_index: Integer, parameters: Node?, body: Node?, opening_loc: Location, closing_loc: Location, location: Location) -> void
  #
  # @return [BlockNode] a new instance of BlockNode
  #
  # source://prism//lib/prism/node.rb#1513
  sig do
    params(
      locals: T::Array[Symbol],
      locals_body_index: Integer,
      parameters: T.nilable(Prism::Node),
      body: T.nilable(Prism::Node),
      opening_loc: Prism::Location,
      closing_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(locals, locals_body_index, parameters, body, opening_loc, closing_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1524
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader body: Node?
  #
  # source://prism//lib/prism/node.rb#1504
  sig { returns(T.nilable(Prism::Node)) }
  def body; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1529
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#1573
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#1510
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1542
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1534
  def compact_child_nodes; end

  # def copy: (**params) -> BlockNode
  #
  # source://prism//lib/prism/node.rb#1547
  sig { params(params: T.untyped).returns(Prism::BlockNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1529
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#1563
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#1578
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader locals: Array[Symbol]
  #
  # source://prism//lib/prism/node.rb#1495
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # attr_reader locals_body_index: Integer
  #
  # source://prism//lib/prism/node.rb#1498
  sig { returns(Integer) }
  def locals_body_index; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#1568
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#1507
  sig { returns(Prism::Location) }
  def opening_loc; end

  # attr_reader parameters: Node?
  #
  # source://prism//lib/prism/node.rb#1501
  sig { returns(T.nilable(Prism::Node)) }
  def parameters; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#1613
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#1623
    def type; end
  end
end

# Represents a block parameter to a method, block, or lambda definition.
#
#     def a(&b)
#           ^^
#     end
#
# source://prism//lib/prism/node.rb#1634
class Prism::BlockParameterNode < ::Prism::Node
  # def initialize: (name: Symbol?, name_loc: Location?, operator_loc: Location, location: Location) -> void
  #
  # @return [BlockParameterNode] a new instance of BlockParameterNode
  #
  # source://prism//lib/prism/node.rb#1644
  sig do
    params(
      name: T.nilable(Symbol),
      name_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1652
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1657
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1667
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1662
  def compact_child_nodes; end

  # def copy: (**params) -> BlockParameterNode
  #
  # source://prism//lib/prism/node.rb#1672
  sig { params(params: T.untyped).returns(Prism::BlockParameterNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1657
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#1685
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#1695
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol?
  #
  # source://prism//lib/prism/node.rb#1635
  sig { returns(T.nilable(Symbol)) }
  def name; end

  # attr_reader name_loc: Location?
  #
  # source://prism//lib/prism/node.rb#1638
  sig { returns(T.nilable(Prism::Location)) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#1690
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#1641
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#1721
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#1731
    def type; end
  end
end

# Represents a block's parameters declaration.
#
#     -> (a, b = 1; local) { }
#        ^^^^^^^^^^^^^^^^^
#
#     foo do |a, b = 1; local|
#            ^^^^^^^^^^^^^^^^^
#     end
#
# source://prism//lib/prism/node.rb#1745
class Prism::BlockParametersNode < ::Prism::Node
  # def initialize: (parameters: ParametersNode?, locals: Array[Node], opening_loc: Location?, closing_loc: Location?, location: Location) -> void
  #
  # @return [BlockParametersNode] a new instance of BlockParametersNode
  #
  # source://prism//lib/prism/node.rb#1758
  sig do
    params(
      parameters: T.nilable(Prism::ParametersNode),
      locals: T::Array[Prism::Node],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location),
      location: Prism::Location
    ).void
  end
  def initialize(parameters, locals, opening_loc, closing_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1767
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1772
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#1814
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#1755
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1785
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1777
  def compact_child_nodes; end

  # def copy: (**params) -> BlockParametersNode
  #
  # source://prism//lib/prism/node.rb#1790
  sig { params(params: T.untyped).returns(Prism::BlockParametersNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1772
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#1804
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#1819
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader locals: Array[Node]
  #
  # source://prism//lib/prism/node.rb#1749
  sig { returns(T::Array[Prism::Node]) }
  def locals; end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#1809
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#1752
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # attr_reader parameters: ParametersNode?
  #
  # source://prism//lib/prism/node.rb#1746
  sig { returns(T.nilable(Prism::ParametersNode)) }
  def parameters; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#1847
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#1857
    def type; end
  end
end

# Represents the use of the `break` keyword.
#
#     break foo
#     ^^^^^^^^^
#
# source://prism//lib/prism/node.rb#1867
class Prism::BreakNode < ::Prism::Node
  # def initialize: (arguments: ArgumentsNode?, keyword_loc: Location, location: Location) -> void
  #
  # @return [BreakNode] a new instance of BreakNode
  #
  # source://prism//lib/prism/node.rb#1874
  sig do
    params(
      arguments: T.nilable(Prism::ArgumentsNode),
      keyword_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(arguments, keyword_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1881
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#1868
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1886
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1898
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1891
  def compact_child_nodes; end

  # def copy: (**params) -> BreakNode
  #
  # source://prism//lib/prism/node.rb#1903
  sig { params(params: T.untyped).returns(Prism::BreakNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1886
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#1915
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#1925
  def inspect(inspector = T.unsafe(nil)); end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#1920
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#1871
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#1951
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#1961
    def type; end
  end
end

# Represents the use of the `&&=` operator on a call.
#
#     foo.bar &&= value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#1971
class Prism::CallAndWriteNode < ::Prism::Node
  # def initialize: (flags: Integer, receiver: Node?, call_operator_loc: Location?, message_loc: Location?, read_name: Symbol, write_name: Symbol, operator_loc: Location, value: Node, location: Location) -> void
  #
  # @return [CallAndWriteNode] a new instance of CallAndWriteNode
  #
  # source://prism//lib/prism/node.rb#1996
  sig do
    params(
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      operator_loc: Prism::Location,
      value: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(flags, receiver, call_operator_loc, message_loc, read_name, write_name, operator_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#2009
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2065
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#2070
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # attr_reader call_operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#1978
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2014
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#2027
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#2019
  def compact_child_nodes; end

  # def copy: (**params) -> CallAndWriteNode
  #
  # source://prism//lib/prism/node.rb#2032
  sig { params(params: T.untyped).returns(Prism::CallAndWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2014
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#2050
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#2085
  def inspect(inspector = T.unsafe(nil)); end

  # def message: () -> String?
  #
  # source://prism//lib/prism/node.rb#2075
  sig { returns(T.nilable(String)) }
  def message; end

  # attr_reader message_loc: Location?
  #
  # source://prism//lib/prism/node.rb#1981
  sig { returns(T.nilable(Prism::Location)) }
  def message_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#2080
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#1990
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader read_name: Symbol
  #
  # source://prism//lib/prism/node.rb#1984
  sig { returns(Symbol) }
  def read_name; end

  # attr_reader receiver: Node?
  #
  # source://prism//lib/prism/node.rb#1975
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2055
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#2119
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#1993
  sig { returns(Prism::Node) }
  def value; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2060
  sig { returns(T::Boolean) }
  def variable_call?; end

  # attr_reader write_name: Symbol
  #
  # source://prism//lib/prism/node.rb#1987
  sig { returns(Symbol) }
  def write_name; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#1972
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#2129
    def type; end
  end
end

# Represents a method call, in all of the various forms that can take.
#
#     foo
#     ^^^
#
#     foo()
#     ^^^^^
#
#     +foo
#     ^^^^
#
#     foo + bar
#     ^^^^^^^^^
#
#     foo.bar
#     ^^^^^^^
#
#     foo&.bar
#     ^^^^^^^^
#
# source://prism//lib/prism/node.rb#2154
class Prism::CallNode < ::Prism::Node
  # def initialize: (flags: Integer, receiver: Node?, call_operator_loc: Location?, name: Symbol, message_loc: Location?, opening_loc: Location?, arguments: ArgumentsNode?, closing_loc: Location?, block: Node?, location: Location) -> void
  #
  # @return [CallNode] a new instance of CallNode
  #
  # source://prism//lib/prism/node.rb#2182
  sig do
    params(
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      name: Symbol,
      message_loc: T.nilable(Prism::Location),
      opening_loc: T.nilable(Prism::Location),
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: T.nilable(Prism::Location),
      block: T.nilable(Prism::Node),
      location: Prism::Location
    ).void
  end
  def initialize(flags, receiver, call_operator_loc, name, message_loc, opening_loc, arguments, closing_loc, block, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#2196
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#2173
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2254
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # attr_reader block: Node?
  #
  # source://prism//lib/prism/node.rb#2179
  sig { returns(T.nilable(Prism::Node)) }
  def block; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#2259
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # attr_reader call_operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#2161
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2201
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#2274
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#2176
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#2215
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#2206
  def compact_child_nodes; end

  # def copy: (**params) -> CallNode
  #
  # source://prism//lib/prism/node.rb#2220
  sig { params(params: T.untyped).returns(Prism::CallNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2201
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#2239
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#2279
  def inspect(inspector = T.unsafe(nil)); end

  # def message: () -> String?
  #
  # source://prism//lib/prism/node.rb#2264
  sig { returns(T.nilable(String)) }
  def message; end

  # attr_reader message_loc: Location?
  #
  # source://prism//lib/prism/node.rb#2167
  sig { returns(T.nilable(Prism::Location)) }
  def message_loc; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#2164
  sig { returns(Symbol) }
  def name; end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#2269
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#2170
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # attr_reader receiver: Node?
  #
  # source://prism//lib/prism/node.rb#2158
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2244
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#2323
  def type; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2249
  sig { returns(T::Boolean) }
  def variable_call?; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#2155
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#2333
    def type; end
  end
end

# Flags for call nodes.
#
# source://prism//lib/prism/node.rb#17289
module Prism::CallNodeFlags; end

# a call that is an attribute write, so the value being written should be returned
#
# source://prism//lib/prism/node.rb#17297
Prism::CallNodeFlags::ATTRIBUTE_WRITE = T.let(T.unsafe(nil), Integer)

# &. operator
#
# source://prism//lib/prism/node.rb#17291
Prism::CallNodeFlags::SAFE_NAVIGATION = T.let(T.unsafe(nil), Integer)

# a call that could have been a local variable
#
# source://prism//lib/prism/node.rb#17294
Prism::CallNodeFlags::VARIABLE_CALL = T.let(T.unsafe(nil), Integer)

# Represents the use of an assignment operator on a call.
#
#     foo.bar += baz
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#2343
class Prism::CallOperatorWriteNode < ::Prism::Node
  # def initialize: (flags: Integer, receiver: Node?, call_operator_loc: Location?, message_loc: Location?, read_name: Symbol, write_name: Symbol, operator: Symbol, operator_loc: Location, value: Node, location: Location) -> void
  #
  # @return [CallOperatorWriteNode] a new instance of CallOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#2371
  sig do
    params(
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      operator: Symbol,
      operator_loc: Prism::Location,
      value: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(flags, receiver, call_operator_loc, message_loc, read_name, write_name, operator, operator_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#2385
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2442
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#2447
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # attr_reader call_operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#2350
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2390
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#2403
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#2395
  def compact_child_nodes; end

  # def copy: (**params) -> CallOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#2408
  sig { params(params: T.untyped).returns(Prism::CallOperatorWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2390
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#2427
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#2457
  def inspect(inspector = T.unsafe(nil)); end

  # def message: () -> String?
  #
  # source://prism//lib/prism/node.rb#2452
  sig { returns(T.nilable(String)) }
  def message; end

  # attr_reader message_loc: Location?
  #
  # source://prism//lib/prism/node.rb#2353
  sig { returns(T.nilable(Prism::Location)) }
  def message_loc; end

  # attr_reader operator: Symbol
  #
  # source://prism//lib/prism/node.rb#2362
  sig { returns(Symbol) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#2365
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader read_name: Symbol
  #
  # source://prism//lib/prism/node.rb#2356
  sig { returns(Symbol) }
  def read_name; end

  # attr_reader receiver: Node?
  #
  # source://prism//lib/prism/node.rb#2347
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2432
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#2492
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#2368
  sig { returns(Prism::Node) }
  def value; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2437
  sig { returns(T::Boolean) }
  def variable_call?; end

  # attr_reader write_name: Symbol
  #
  # source://prism//lib/prism/node.rb#2359
  sig { returns(Symbol) }
  def write_name; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#2344
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#2502
    def type; end
  end
end

# Represents the use of the `||=` operator on a call.
#
#     foo.bar ||= value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#2512
class Prism::CallOrWriteNode < ::Prism::Node
  # def initialize: (flags: Integer, receiver: Node?, call_operator_loc: Location?, message_loc: Location?, read_name: Symbol, write_name: Symbol, operator_loc: Location, value: Node, location: Location) -> void
  #
  # @return [CallOrWriteNode] a new instance of CallOrWriteNode
  #
  # source://prism//lib/prism/node.rb#2537
  sig do
    params(
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      operator_loc: Prism::Location,
      value: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(flags, receiver, call_operator_loc, message_loc, read_name, write_name, operator_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#2550
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2606
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#2611
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # attr_reader call_operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#2519
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2555
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#2568
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#2560
  def compact_child_nodes; end

  # def copy: (**params) -> CallOrWriteNode
  #
  # source://prism//lib/prism/node.rb#2573
  sig { params(params: T.untyped).returns(Prism::CallOrWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2555
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#2591
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#2626
  def inspect(inspector = T.unsafe(nil)); end

  # def message: () -> String?
  #
  # source://prism//lib/prism/node.rb#2616
  sig { returns(T.nilable(String)) }
  def message; end

  # attr_reader message_loc: Location?
  #
  # source://prism//lib/prism/node.rb#2522
  sig { returns(T.nilable(Prism::Location)) }
  def message_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#2621
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#2531
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader read_name: Symbol
  #
  # source://prism//lib/prism/node.rb#2525
  sig { returns(Symbol) }
  def read_name; end

  # attr_reader receiver: Node?
  #
  # source://prism//lib/prism/node.rb#2516
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2596
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#2660
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#2534
  sig { returns(Prism::Node) }
  def value; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2601
  sig { returns(T::Boolean) }
  def variable_call?; end

  # attr_reader write_name: Symbol
  #
  # source://prism//lib/prism/node.rb#2528
  sig { returns(Symbol) }
  def write_name; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#2513
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#2670
    def type; end
  end
end

# Represents assigning to a method call.
#
#     foo.bar, = 1
#     ^^^^^^^
#
#     begin
#     rescue => foo.bar
#               ^^^^^^^
#     end
#
#     for foo.bar in baz do end
#         ^^^^^^^
#
# source://prism//lib/prism/node.rb#2688
class Prism::CallTargetNode < ::Prism::Node
  # def initialize: (flags: Integer, receiver: Node, call_operator_loc: Location, name: Symbol, message_loc: Location, location: Location) -> void
  #
  # @return [CallTargetNode] a new instance of CallTargetNode
  #
  # source://prism//lib/prism/node.rb#2704
  sig do
    params(
      flags: Integer,
      receiver: Prism::Node,
      call_operator_loc: Prism::Location,
      name: Symbol,
      message_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(flags, receiver, call_operator_loc, name, message_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#2714
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2764
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # def call_operator: () -> String
  #
  # source://prism//lib/prism/node.rb#2769
  sig { returns(String) }
  def call_operator; end

  # attr_reader call_operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#2695
  sig { returns(Prism::Location) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2719
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#2729
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#2724
  def compact_child_nodes; end

  # def copy: (**params) -> CallTargetNode
  #
  # source://prism//lib/prism/node.rb#2734
  sig { params(params: T.untyped).returns(Prism::CallTargetNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2719
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#2749
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#2779
  def inspect(inspector = T.unsafe(nil)); end

  # def message: () -> String
  #
  # source://prism//lib/prism/node.rb#2774
  sig { returns(String) }
  def message; end

  # attr_reader message_loc: Location
  #
  # source://prism//lib/prism/node.rb#2701
  sig { returns(Prism::Location) }
  def message_loc; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#2698
  sig { returns(Symbol) }
  def name; end

  # attr_reader receiver: Node
  #
  # source://prism//lib/prism/node.rb#2692
  sig { returns(Prism::Node) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2754
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#2805
  def type; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2759
  sig { returns(T::Boolean) }
  def variable_call?; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#2689
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#2815
    def type; end
  end
end

# Represents assigning to a local variable in pattern matching.
#
#     foo => [bar => baz]
#            ^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#2825
class Prism::CapturePatternNode < ::Prism::Node
  # def initialize: (value: Node, target: Node, operator_loc: Location, location: Location) -> void
  #
  # @return [CapturePatternNode] a new instance of CapturePatternNode
  #
  # source://prism//lib/prism/node.rb#2835
  sig do
    params(
      value: Prism::Node,
      target: Prism::Node,
      operator_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(value, target, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#2843
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2848
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#2858
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#2853
  def compact_child_nodes; end

  # def copy: (**params) -> CapturePatternNode
  #
  # source://prism//lib/prism/node.rb#2863
  sig { params(params: T.untyped).returns(Prism::CapturePatternNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2848
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#2876
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#2886
  def inspect(inspector = T.unsafe(nil)); end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#2881
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#2832
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader target: Node
  #
  # source://prism//lib/prism/node.rb#2829
  sig { returns(Prism::Node) }
  def target; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#2910
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#2826
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#2920
    def type; end
  end
end

# Represents the use of a case statement for pattern matching.
#
#     case true
#     in false
#     end
#     ^^^^^^^^^
#
# source://prism//lib/prism/node.rb#2932
class Prism::CaseMatchNode < ::Prism::Node
  # def initialize: (predicate: Node?, conditions: Array[Node], consequent: ElseNode?, case_keyword_loc: Location, end_keyword_loc: Location, location: Location) -> void
  #
  # @return [CaseMatchNode] a new instance of CaseMatchNode
  #
  # source://prism//lib/prism/node.rb#2948
  sig do
    params(
      predicate: T.nilable(Prism::Node),
      conditions: T::Array[Prism::Node],
      consequent: T.nilable(Prism::ElseNode),
      case_keyword_loc: Prism::Location,
      end_keyword_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(predicate, conditions, consequent, case_keyword_loc, end_keyword_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#2958
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def case_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#3002
  sig { returns(String) }
  def case_keyword; end

  # attr_reader case_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#2942
  sig { returns(Prism::Location) }
  def case_keyword_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2963
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#2977
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#2968
  def compact_child_nodes; end

  # attr_reader conditions: Array[Node]
  #
  # source://prism//lib/prism/node.rb#2936
  sig { returns(T::Array[Prism::Node]) }
  def conditions; end

  # attr_reader consequent: ElseNode?
  #
  # source://prism//lib/prism/node.rb#2939
  sig { returns(T.nilable(Prism::ElseNode)) }
  def consequent; end

  # def copy: (**params) -> CaseMatchNode
  #
  # source://prism//lib/prism/node.rb#2982
  sig { params(params: T.untyped).returns(Prism::CaseMatchNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2963
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#2997
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#3007
  sig { returns(String) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#2945
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#3012
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader predicate: Node?
  #
  # source://prism//lib/prism/node.rb#2933
  sig { returns(T.nilable(Prism::Node)) }
  def predicate; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#3046
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#3056
    def type; end
  end
end

# Represents the use of a case statement.
#
#     case true
#     when false
#     end
#     ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3068
class Prism::CaseNode < ::Prism::Node
  # def initialize: (predicate: Node?, conditions: Array[Node], consequent: ElseNode?, case_keyword_loc: Location, end_keyword_loc: Location, location: Location) -> void
  #
  # @return [CaseNode] a new instance of CaseNode
  #
  # source://prism//lib/prism/node.rb#3084
  sig do
    params(
      predicate: T.nilable(Prism::Node),
      conditions: T::Array[Prism::Node],
      consequent: T.nilable(Prism::ElseNode),
      case_keyword_loc: Prism::Location,
      end_keyword_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(predicate, conditions, consequent, case_keyword_loc, end_keyword_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3094
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def case_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#3138
  sig { returns(String) }
  def case_keyword; end

  # attr_reader case_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#3078
  sig { returns(Prism::Location) }
  def case_keyword_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3099
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3113
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3104
  def compact_child_nodes; end

  # attr_reader conditions: Array[Node]
  #
  # source://prism//lib/prism/node.rb#3072
  sig { returns(T::Array[Prism::Node]) }
  def conditions; end

  # attr_reader consequent: ElseNode?
  #
  # source://prism//lib/prism/node.rb#3075
  sig { returns(T.nilable(Prism::ElseNode)) }
  def consequent; end

  # def copy: (**params) -> CaseNode
  #
  # source://prism//lib/prism/node.rb#3118
  sig { params(params: T.untyped).returns(Prism::CaseNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3099
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#3133
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#3143
  sig { returns(String) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#3081
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#3148
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader predicate: Node?
  #
  # source://prism//lib/prism/node.rb#3069
  sig { returns(T.nilable(Prism::Node)) }
  def predicate; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#3182
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#3192
    def type; end
  end
end

# Represents a class declaration involving the `class` keyword.
#
#     class Foo end
#     ^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3202
class Prism::ClassNode < ::Prism::Node
  # def initialize: (locals: Array[Symbol], class_keyword_loc: Location, constant_path: Node, inheritance_operator_loc: Location?, superclass: Node?, body: Node?, end_keyword_loc: Location, name: Symbol, location: Location) -> void
  #
  # @return [ClassNode] a new instance of ClassNode
  #
  # source://prism//lib/prism/node.rb#3227
  sig do
    params(
      locals: T::Array[Symbol],
      class_keyword_loc: Prism::Location,
      constant_path: Prism::Node,
      inheritance_operator_loc: T.nilable(Prism::Location),
      superclass: T.nilable(Prism::Node),
      body: T.nilable(Prism::Node),
      end_keyword_loc: Prism::Location,
      name: Symbol,
      location: Prism::Location
    ).void
  end
  def initialize(locals, class_keyword_loc, constant_path, inheritance_operator_loc, superclass, body, end_keyword_loc, name, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3240
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader body: Node?
  #
  # source://prism//lib/prism/node.rb#3218
  sig { returns(T.nilable(Prism::Node)) }
  def body; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3245
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def class_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#3287
  sig { returns(String) }
  def class_keyword; end

  # attr_reader class_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#3206
  sig { returns(Prism::Location) }
  def class_keyword_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3259
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3250
  def compact_child_nodes; end

  # attr_reader constant_path: Node
  #
  # source://prism//lib/prism/node.rb#3209
  sig { returns(Prism::Node) }
  def constant_path; end

  # def copy: (**params) -> ClassNode
  #
  # source://prism//lib/prism/node.rb#3264
  sig { params(params: T.untyped).returns(Prism::ClassNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3245
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#3282
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#3297
  sig { returns(String) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#3221
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  # def inheritance_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#3292
  sig { returns(T.nilable(String)) }
  def inheritance_operator; end

  # attr_reader inheritance_operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#3212
  sig { returns(T.nilable(Prism::Location)) }
  def inheritance_operator_loc; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#3302
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader locals: Array[Symbol]
  #
  # source://prism//lib/prism/node.rb#3203
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#3224
  sig { returns(Symbol) }
  def name; end

  # attr_reader superclass: Node?
  #
  # source://prism//lib/prism/node.rb#3215
  sig { returns(T.nilable(Prism::Node)) }
  def superclass; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#3340
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#3350
    def type; end
  end
end

# Represents the use of the `&&=` operator for assignment to a class variable.
#
#     @@target &&= value
#     ^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3360
class Prism::ClassVariableAndWriteNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, operator_loc: Location, value: Node, location: Location) -> void
  #
  # @return [ClassVariableAndWriteNode] a new instance of ClassVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#3373
  sig do
    params(
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, operator_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3382
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3387
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3397
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3392
  def compact_child_nodes; end

  # def copy: (**params) -> ClassVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#3402
  sig { params(params: T.untyped).returns(Prism::ClassVariableAndWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3387
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#3416
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#3426
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#3361
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#3364
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#3421
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#3367
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#3450
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#3370
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#3460
    def type; end
  end
end

# Represents assigning to a class variable using an operator that isn't `=`.
#
#     @@target += value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3470
class Prism::ClassVariableOperatorWriteNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, operator_loc: Location, value: Node, operator: Symbol, location: Location) -> void
  #
  # @return [ClassVariableOperatorWriteNode] a new instance of ClassVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#3486
  sig do
    params(
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      operator: Symbol,
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, operator_loc, value, operator, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3496
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3501
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3511
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3506
  def compact_child_nodes; end

  # def copy: (**params) -> ClassVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#3516
  sig { params(params: T.untyped).returns(Prism::ClassVariableOperatorWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3501
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#3531
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#3536
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#3471
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#3474
  sig { returns(Prism::Location) }
  def name_loc; end

  # attr_reader operator: Symbol
  #
  # source://prism//lib/prism/node.rb#3483
  sig { returns(Symbol) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#3477
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#3561
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#3480
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#3571
    def type; end
  end
end

# Represents the use of the `||=` operator for assignment to a class variable.
#
#     @@target ||= value
#     ^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3581
class Prism::ClassVariableOrWriteNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, operator_loc: Location, value: Node, location: Location) -> void
  #
  # @return [ClassVariableOrWriteNode] a new instance of ClassVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#3594
  sig do
    params(
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, operator_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3603
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3608
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3618
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3613
  def compact_child_nodes; end

  # def copy: (**params) -> ClassVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#3623
  sig { params(params: T.untyped).returns(Prism::ClassVariableOrWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3608
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#3637
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#3647
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#3582
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#3585
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#3642
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#3588
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#3671
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#3591
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#3681
    def type; end
  end
end

# Represents referencing a class variable.
#
#     @@foo
#     ^^^^^
#
# source://prism//lib/prism/node.rb#3691
class Prism::ClassVariableReadNode < ::Prism::Node
  # def initialize: (name: Symbol, location: Location) -> void
  #
  # @return [ClassVariableReadNode] a new instance of ClassVariableReadNode
  #
  # source://prism//lib/prism/node.rb#3695
  sig { params(name: Symbol, location: Prism::Location).void }
  def initialize(name, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3701
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3706
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3716
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3711
  def compact_child_nodes; end

  # def copy: (**params) -> ClassVariableReadNode
  #
  # source://prism//lib/prism/node.rb#3721
  sig { params(params: T.untyped).returns(Prism::ClassVariableReadNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3706
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#3732
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#3737
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#3692
  sig { returns(Symbol) }
  def name; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#3757
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#3767
    def type; end
  end
end

# Represents writing to a class variable in a context that doesn't have an explicit value.
#
#     @@foo, @@bar = baz
#     ^^^^^  ^^^^^
#
# source://prism//lib/prism/node.rb#3777
class Prism::ClassVariableTargetNode < ::Prism::Node
  # def initialize: (name: Symbol, location: Location) -> void
  #
  # @return [ClassVariableTargetNode] a new instance of ClassVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#3781
  sig { params(name: Symbol, location: Prism::Location).void }
  def initialize(name, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3787
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3792
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3802
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3797
  def compact_child_nodes; end

  # def copy: (**params) -> ClassVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#3807
  sig { params(params: T.untyped).returns(Prism::ClassVariableTargetNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3792
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#3818
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#3823
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#3778
  sig { returns(Symbol) }
  def name; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#3843
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#3853
    def type; end
  end
end

# Represents writing to a class variable.
#
#     @@foo = 1
#     ^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3863
class Prism::ClassVariableWriteNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, value: Node, operator_loc: Location?, location: Location) -> void
  #
  # @return [ClassVariableWriteNode] a new instance of ClassVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#3876
  sig do
    params(
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: T.nilable(Prism::Location),
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, value, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3885
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3890
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3900
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3895
  def compact_child_nodes; end

  # def copy: (**params) -> ClassVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#3905
  sig { params(params: T.untyped).returns(Prism::ClassVariableWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3890
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#3919
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#3929
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#3864
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#3867
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#3924
  sig { returns(T.nilable(String)) }
  def operator; end

  # attr_reader operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#3873
  sig { returns(T.nilable(Prism::Location)) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#3953
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#3870
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#3963
    def type; end
  end
end

# This represents a comment that was encountered during parsing. It is the
# base class for all comment types.
#
# source://prism//lib/prism/parse_result.rb#228
class Prism::Comment
  # Create a new comment object with the given location.
  #
  # @return [Comment] a new instance of Comment
  #
  # source://prism//lib/prism/parse_result.rb#233
  def initialize(location); end

  # Implement the hash pattern matching interface for Comment.
  #
  # source://prism//lib/prism/parse_result.rb#238
  def deconstruct_keys(keys); end

  # The location of this comment in the source.
  #
  # source://prism//lib/prism/parse_result.rb#230
  sig { returns(Prism::Location) }
  def location; end

  sig { returns(T::Boolean) }
  def trailing?; end
end

# A compiler is a visitor that returns the value of each node as it visits.
# This is as opposed to a visitor which will only walk the tree. This can be
# useful when you are trying to compile a tree into a different format.
#
# For example, to build a representation of the tree as s-expressions, you
# could write:
#
#     class SExpressions < Prism::Compiler
#       def visit_arguments_node(node) = [:arguments, super]
#       def visit_call_node(node) = [:call, super]
#       def visit_integer_node(node) = [:integer]
#       def visit_program_node(node) = [:program, super]
#     end
#
#     Prism.parse("1 + 2").value.accept(SExpressions.new)
#     # => [:program, [[[:call, [[:integer], [:arguments, [[:integer]]]]]]]]
#
# source://prism//lib/prism/compiler.rb#26
class Prism::Compiler
  # Visit an individual node.
  #
  # source://prism//lib/prism/compiler.rb#28
  def visit(node); end

  # Visit the child nodes of the given node.
  # Compile a AliasGlobalVariableNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_alias_global_variable_node(node); end

  # Visit the child nodes of the given node.
  # Compile a AliasMethodNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_alias_method_node(node); end

  # Visit a list of nodes.
  #
  # source://prism//lib/prism/compiler.rb#33
  def visit_all(nodes); end

  # Visit the child nodes of the given node.
  # Compile a AlternationPatternNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_alternation_pattern_node(node); end

  # Visit the child nodes of the given node.
  # Compile a AndNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_and_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ArgumentsNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_arguments_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ArrayNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_array_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ArrayPatternNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_array_pattern_node(node); end

  # Visit the child nodes of the given node.
  # Compile a AssocNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_assoc_node(node); end

  # Visit the child nodes of the given node.
  # Compile a AssocSplatNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_assoc_splat_node(node); end

  # Visit the child nodes of the given node.
  # Compile a BackReferenceReadNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_back_reference_read_node(node); end

  # Visit the child nodes of the given node.
  # Compile a BeginNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_begin_node(node); end

  # Visit the child nodes of the given node.
  # Compile a BlockArgumentNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_block_argument_node(node); end

  # Visit the child nodes of the given node.
  # Compile a BlockLocalVariableNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_block_local_variable_node(node); end

  # Visit the child nodes of the given node.
  # Compile a BlockNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_block_node(node); end

  # Visit the child nodes of the given node.
  # Compile a BlockParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_block_parameter_node(node); end

  # Visit the child nodes of the given node.
  # Compile a BlockParametersNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_block_parameters_node(node); end

  # Visit the child nodes of the given node.
  # Compile a BreakNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_break_node(node); end

  # Visit the child nodes of the given node.
  # Compile a CallAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_call_and_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a CallNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_call_node(node); end

  # Visit the child nodes of the given node.
  # Compile a CallOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_call_operator_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a CallOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_call_or_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a CallTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_call_target_node(node); end

  # Visit the child nodes of the given node.
  # Compile a CapturePatternNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_capture_pattern_node(node); end

  # Visit the child nodes of the given node.
  # Compile a CaseMatchNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_case_match_node(node); end

  # Visit the child nodes of the given node.
  # Compile a CaseNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_case_node(node); end

  # Visit the child nodes of the given node.
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_child_nodes(node); end

  # Visit the child nodes of the given node.
  # Compile a ClassNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_class_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ClassVariableAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_class_variable_and_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ClassVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_class_variable_operator_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ClassVariableOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_class_variable_or_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ClassVariableReadNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_class_variable_read_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ClassVariableTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_class_variable_target_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ClassVariableWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_class_variable_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_constant_and_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_constant_operator_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_constant_or_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantPathAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_constant_path_and_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantPathNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_constant_path_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantPathOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_constant_path_operator_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantPathOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_constant_path_or_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantPathTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_constant_path_target_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantPathWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_constant_path_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantReadNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_constant_read_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_constant_target_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_constant_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a DefNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_def_node(node); end

  # Visit the child nodes of the given node.
  # Compile a DefinedNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_defined_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ElseNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_else_node(node); end

  # Visit the child nodes of the given node.
  # Compile a EmbeddedStatementsNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_embedded_statements_node(node); end

  # Visit the child nodes of the given node.
  # Compile a EmbeddedVariableNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_embedded_variable_node(node); end

  # Visit the child nodes of the given node.
  # Compile a EnsureNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_ensure_node(node); end

  # Visit the child nodes of the given node.
  # Compile a FalseNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_false_node(node); end

  # Visit the child nodes of the given node.
  # Compile a FindPatternNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_find_pattern_node(node); end

  # Visit the child nodes of the given node.
  # Compile a FlipFlopNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_flip_flop_node(node); end

  # Visit the child nodes of the given node.
  # Compile a FloatNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_float_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ForNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_for_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ForwardingArgumentsNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_forwarding_arguments_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ForwardingParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_forwarding_parameter_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ForwardingSuperNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_forwarding_super_node(node); end

  # Visit the child nodes of the given node.
  # Compile a GlobalVariableAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_global_variable_and_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a GlobalVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_global_variable_operator_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a GlobalVariableOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_global_variable_or_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a GlobalVariableReadNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_global_variable_read_node(node); end

  # Visit the child nodes of the given node.
  # Compile a GlobalVariableTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_global_variable_target_node(node); end

  # Visit the child nodes of the given node.
  # Compile a GlobalVariableWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_global_variable_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a HashNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_hash_node(node); end

  # Visit the child nodes of the given node.
  # Compile a HashPatternNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_hash_pattern_node(node); end

  # Visit the child nodes of the given node.
  # Compile a IfNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_if_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ImaginaryNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_imaginary_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ImplicitNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_implicit_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ImplicitRestNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_implicit_rest_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_in_node(node); end

  # Visit the child nodes of the given node.
  # Compile a IndexAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_index_and_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a IndexOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_index_operator_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a IndexOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_index_or_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a IndexTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_index_target_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InstanceVariableAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_instance_variable_and_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InstanceVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_instance_variable_operator_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InstanceVariableOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_instance_variable_or_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InstanceVariableReadNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_instance_variable_read_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InstanceVariableTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_instance_variable_target_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InstanceVariableWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_instance_variable_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a IntegerNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_integer_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InterpolatedMatchLastLineNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_interpolated_match_last_line_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InterpolatedRegularExpressionNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_interpolated_regular_expression_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InterpolatedStringNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_interpolated_string_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InterpolatedSymbolNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_interpolated_symbol_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InterpolatedXStringNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_interpolated_x_string_node(node); end

  # Visit the child nodes of the given node.
  # Compile a KeywordHashNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_keyword_hash_node(node); end

  # Visit the child nodes of the given node.
  # Compile a KeywordRestParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_keyword_rest_parameter_node(node); end

  # Visit the child nodes of the given node.
  # Compile a LambdaNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_lambda_node(node); end

  # Visit the child nodes of the given node.
  # Compile a LocalVariableAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_local_variable_and_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a LocalVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_local_variable_operator_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a LocalVariableOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_local_variable_or_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a LocalVariableReadNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_local_variable_read_node(node); end

  # Visit the child nodes of the given node.
  # Compile a LocalVariableTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_local_variable_target_node(node); end

  # Visit the child nodes of the given node.
  # Compile a LocalVariableWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_local_variable_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a MatchLastLineNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_match_last_line_node(node); end

  # Visit the child nodes of the given node.
  # Compile a MatchPredicateNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_match_predicate_node(node); end

  # Visit the child nodes of the given node.
  # Compile a MatchRequiredNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_match_required_node(node); end

  # Visit the child nodes of the given node.
  # Compile a MatchWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_match_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a MissingNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_missing_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ModuleNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_module_node(node); end

  # Visit the child nodes of the given node.
  # Compile a MultiTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_multi_target_node(node); end

  # Visit the child nodes of the given node.
  # Compile a MultiWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_multi_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a NextNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_next_node(node); end

  # Visit the child nodes of the given node.
  # Compile a NilNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_nil_node(node); end

  # Visit the child nodes of the given node.
  # Compile a NoKeywordsParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_no_keywords_parameter_node(node); end

  # Visit the child nodes of the given node.
  # Compile a NumberedParametersNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_numbered_parameters_node(node); end

  # Visit the child nodes of the given node.
  # Compile a NumberedReferenceReadNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_numbered_reference_read_node(node); end

  # Visit the child nodes of the given node.
  # Compile a OptionalKeywordParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_optional_keyword_parameter_node(node); end

  # Visit the child nodes of the given node.
  # Compile a OptionalParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_optional_parameter_node(node); end

  # Visit the child nodes of the given node.
  # Compile a OrNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_or_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ParametersNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_parameters_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ParenthesesNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_parentheses_node(node); end

  # Visit the child nodes of the given node.
  # Compile a PinnedExpressionNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_pinned_expression_node(node); end

  # Visit the child nodes of the given node.
  # Compile a PinnedVariableNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_pinned_variable_node(node); end

  # Visit the child nodes of the given node.
  # Compile a PostExecutionNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_post_execution_node(node); end

  # Visit the child nodes of the given node.
  # Compile a PreExecutionNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_pre_execution_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ProgramNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_program_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RangeNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_range_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RationalNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_rational_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RedoNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_redo_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RegularExpressionNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_regular_expression_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RequiredKeywordParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_required_keyword_parameter_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RequiredParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_required_parameter_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RescueModifierNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_rescue_modifier_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RescueNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_rescue_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RestParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_rest_parameter_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RetryNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_retry_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ReturnNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_return_node(node); end

  # Visit the child nodes of the given node.
  # Compile a SelfNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_self_node(node); end

  # Visit the child nodes of the given node.
  # Compile a SingletonClassNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_singleton_class_node(node); end

  # Visit the child nodes of the given node.
  # Compile a SourceEncodingNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_source_encoding_node(node); end

  # Visit the child nodes of the given node.
  # Compile a SourceFileNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_source_file_node(node); end

  # Visit the child nodes of the given node.
  # Compile a SourceLineNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_source_line_node(node); end

  # Visit the child nodes of the given node.
  # Compile a SplatNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_splat_node(node); end

  # Visit the child nodes of the given node.
  # Compile a StatementsNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_statements_node(node); end

  # Visit the child nodes of the given node.
  # Compile a StringNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_string_node(node); end

  # Visit the child nodes of the given node.
  # Compile a SuperNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_super_node(node); end

  # Visit the child nodes of the given node.
  # Compile a SymbolNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_symbol_node(node); end

  # Visit the child nodes of the given node.
  # Compile a TrueNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_true_node(node); end

  # Visit the child nodes of the given node.
  # Compile a UndefNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_undef_node(node); end

  # Visit the child nodes of the given node.
  # Compile a UnlessNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_unless_node(node); end

  # Visit the child nodes of the given node.
  # Compile a UntilNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_until_node(node); end

  # Visit the child nodes of the given node.
  # Compile a WhenNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_when_node(node); end

  # Visit the child nodes of the given node.
  # Compile a WhileNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_while_node(node); end

  # Visit the child nodes of the given node.
  # Compile a XStringNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_x_string_node(node); end

  # Visit the child nodes of the given node.
  # Compile a YieldNode node
  #
  # source://prism//lib/prism/compiler.rb#38
  def visit_yield_node(node); end
end

# Represents the use of the `&&=` operator for assignment to a constant.
#
#     Target &&= value
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3973
class Prism::ConstantAndWriteNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, operator_loc: Location, value: Node, location: Location) -> void
  #
  # @return [ConstantAndWriteNode] a new instance of ConstantAndWriteNode
  #
  # source://prism//lib/prism/node.rb#3986
  sig do
    params(
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, operator_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3995
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4000
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4010
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4005
  def compact_child_nodes; end

  # def copy: (**params) -> ConstantAndWriteNode
  #
  # source://prism//lib/prism/node.rb#4015
  sig { params(params: T.untyped).returns(Prism::ConstantAndWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4000
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#4029
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#4039
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#3974
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#3977
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#4034
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#3980
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#4063
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#3983
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#4073
    def type; end
  end
end

# Represents assigning to a constant using an operator that isn't `=`.
#
#     Target += value
#     ^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#4083
class Prism::ConstantOperatorWriteNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, operator_loc: Location, value: Node, operator: Symbol, location: Location) -> void
  #
  # @return [ConstantOperatorWriteNode] a new instance of ConstantOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#4099
  sig do
    params(
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      operator: Symbol,
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, operator_loc, value, operator, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4109
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4114
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4124
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4119
  def compact_child_nodes; end

  # def copy: (**params) -> ConstantOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#4129
  sig { params(params: T.untyped).returns(Prism::ConstantOperatorWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4114
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#4144
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#4149
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#4084
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#4087
  sig { returns(Prism::Location) }
  def name_loc; end

  # attr_reader operator: Symbol
  #
  # source://prism//lib/prism/node.rb#4096
  sig { returns(Symbol) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#4090
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#4174
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#4093
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#4184
    def type; end
  end
end

# Represents the use of the `||=` operator for assignment to a constant.
#
#     Target ||= value
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#4194
class Prism::ConstantOrWriteNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, operator_loc: Location, value: Node, location: Location) -> void
  #
  # @return [ConstantOrWriteNode] a new instance of ConstantOrWriteNode
  #
  # source://prism//lib/prism/node.rb#4207
  sig do
    params(
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, operator_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4216
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4221
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4231
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4226
  def compact_child_nodes; end

  # def copy: (**params) -> ConstantOrWriteNode
  #
  # source://prism//lib/prism/node.rb#4236
  sig { params(params: T.untyped).returns(Prism::ConstantOrWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4221
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#4250
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#4260
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#4195
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#4198
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#4255
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#4201
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#4284
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#4204
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#4294
    def type; end
  end
end

# Represents the use of the `&&=` operator for assignment to a constant path.
#
#     Parent::Child &&= value
#     ^^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#4304
class Prism::ConstantPathAndWriteNode < ::Prism::Node
  # def initialize: (target: ConstantPathNode, operator_loc: Location, value: Node, location: Location) -> void
  #
  # @return [ConstantPathAndWriteNode] a new instance of ConstantPathAndWriteNode
  #
  # source://prism//lib/prism/node.rb#4314
  sig do
    params(
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(target, operator_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4322
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4327
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4337
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4332
  def compact_child_nodes; end

  # def copy: (**params) -> ConstantPathAndWriteNode
  #
  # source://prism//lib/prism/node.rb#4342
  sig { params(params: T.untyped).returns(Prism::ConstantPathAndWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4327
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#4355
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#4365
  def inspect(inspector = T.unsafe(nil)); end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#4360
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#4308
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader target: ConstantPathNode
  #
  # source://prism//lib/prism/node.rb#4305
  sig { returns(Prism::ConstantPathNode) }
  def target; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#4389
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#4311
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#4399
    def type; end
  end
end

# Represents accessing a constant through a path of `::` operators.
#
#     Foo::Bar
#     ^^^^^^^^
#
# source://prism//lib/prism/node.rb#4409
class Prism::ConstantPathNode < ::Prism::Node
  # def initialize: (parent: Node?, child: Node, delimiter_loc: Location, location: Location) -> void
  #
  # @return [ConstantPathNode] a new instance of ConstantPathNode
  #
  # source://prism//lib/prism/node.rb#4419
  sig do
    params(
      parent: T.nilable(Prism::Node),
      child: Prism::Node,
      delimiter_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(parent, child, delimiter_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4427
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader child: Node
  #
  # source://prism//lib/prism/node.rb#4413
  sig { returns(Prism::Node) }
  def child; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4432
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4445
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4437
  def compact_child_nodes; end

  # def copy: (**params) -> ConstantPathNode
  #
  # source://prism//lib/prism/node.rb#4450
  sig { params(params: T.untyped).returns(Prism::ConstantPathNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4432
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#4463
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def delimiter: () -> String
  #
  # source://prism//lib/prism/node.rb#4468
  sig { returns(String) }
  def delimiter; end

  # attr_reader delimiter_loc: Location
  #
  # source://prism//lib/prism/node.rb#4416
  sig { returns(Prism::Location) }
  def delimiter_loc; end

  # Returns the full name of this constant path. For example: "Foo::Bar"
  #
  # source://prism//lib/prism/node_ext.rb#129
  def full_name; end

  # Returns the list of parts for the full name of this constant path.
  # For example: [:Foo, :Bar]
  #
  # source://prism//lib/prism/node_ext.rb#112
  def full_name_parts; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#4473
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader parent: Node?
  #
  # source://prism//lib/prism/node.rb#4410
  sig { returns(T.nilable(Prism::Node)) }
  def parent; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#4501
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#4511
    def type; end
  end
end

# An error class raised when dynamic parts are found while computing a
# constant path's full name. For example:
# Foo::Bar::Baz -> does not raise because all parts of the constant path are
# simple constants
# var::Bar::Baz -> raises because the first part of the constant path is a
# local variable
#
# source://prism//lib/prism/node_ext.rb#108
class Prism::ConstantPathNode::DynamicPartsInConstantPathError < ::StandardError; end

# Represents assigning to a constant path using an operator that isn't `=`.
#
#     Parent::Child += value
#     ^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#4521
class Prism::ConstantPathOperatorWriteNode < ::Prism::Node
  # def initialize: (target: ConstantPathNode, operator_loc: Location, value: Node, operator: Symbol, location: Location) -> void
  #
  # @return [ConstantPathOperatorWriteNode] a new instance of ConstantPathOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#4534
  sig do
    params(
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node,
      operator: Symbol,
      location: Prism::Location
    ).void
  end
  def initialize(target, operator_loc, value, operator, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4543
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4548
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4558
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4553
  def compact_child_nodes; end

  # def copy: (**params) -> ConstantPathOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#4563
  sig { params(params: T.untyped).returns(Prism::ConstantPathOperatorWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4548
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#4577
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#4582
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader operator: Symbol
  #
  # source://prism//lib/prism/node.rb#4531
  sig { returns(Symbol) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#4525
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader target: ConstantPathNode
  #
  # source://prism//lib/prism/node.rb#4522
  sig { returns(Prism::ConstantPathNode) }
  def target; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#4607
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#4528
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#4617
    def type; end
  end
end

# Represents the use of the `||=` operator for assignment to a constant path.
#
#     Parent::Child ||= value
#     ^^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#4627
class Prism::ConstantPathOrWriteNode < ::Prism::Node
  # def initialize: (target: ConstantPathNode, operator_loc: Location, value: Node, location: Location) -> void
  #
  # @return [ConstantPathOrWriteNode] a new instance of ConstantPathOrWriteNode
  #
  # source://prism//lib/prism/node.rb#4637
  sig do
    params(
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(target, operator_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4645
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4650
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4660
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4655
  def compact_child_nodes; end

  # def copy: (**params) -> ConstantPathOrWriteNode
  #
  # source://prism//lib/prism/node.rb#4665
  sig { params(params: T.untyped).returns(Prism::ConstantPathOrWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4650
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#4678
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#4688
  def inspect(inspector = T.unsafe(nil)); end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#4683
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#4631
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader target: ConstantPathNode
  #
  # source://prism//lib/prism/node.rb#4628
  sig { returns(Prism::ConstantPathNode) }
  def target; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#4712
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#4634
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#4722
    def type; end
  end
end

# Represents writing to a constant path in a context that doesn't have an explicit value.
#
#     Foo::Foo, Bar::Bar = baz
#     ^^^^^^^^  ^^^^^^^^
#
# source://prism//lib/prism/node.rb#4732
class Prism::ConstantPathTargetNode < ::Prism::Node
  # def initialize: (parent: Node?, child: Node, delimiter_loc: Location, location: Location) -> void
  #
  # @return [ConstantPathTargetNode] a new instance of ConstantPathTargetNode
  #
  # source://prism//lib/prism/node.rb#4742
  sig do
    params(
      parent: T.nilable(Prism::Node),
      child: Prism::Node,
      delimiter_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(parent, child, delimiter_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4750
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader child: Node
  #
  # source://prism//lib/prism/node.rb#4736
  sig { returns(Prism::Node) }
  def child; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4755
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4768
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4760
  def compact_child_nodes; end

  # def copy: (**params) -> ConstantPathTargetNode
  #
  # source://prism//lib/prism/node.rb#4773
  sig { params(params: T.untyped).returns(Prism::ConstantPathTargetNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4755
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#4786
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def delimiter: () -> String
  #
  # source://prism//lib/prism/node.rb#4791
  sig { returns(String) }
  def delimiter; end

  # attr_reader delimiter_loc: Location
  #
  # source://prism//lib/prism/node.rb#4739
  sig { returns(Prism::Location) }
  def delimiter_loc; end

  # Returns the full name of this constant path. For example: "Foo::Bar"
  #
  # source://prism//lib/prism/node_ext.rb#142
  def full_name; end

  # Returns the list of parts for the full name of this constant path.
  # For example: [:Foo, :Bar]
  #
  # source://prism//lib/prism/node_ext.rb#137
  def full_name_parts; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#4796
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader parent: Node?
  #
  # source://prism//lib/prism/node.rb#4733
  sig { returns(T.nilable(Prism::Node)) }
  def parent; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#4824
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#4834
    def type; end
  end
end

# Represents writing to a constant path.
#
#     ::Foo = 1
#     ^^^^^^^^^
#
#     Foo::Bar = 1
#     ^^^^^^^^^^^^
#
#     ::Foo::Bar = 1
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#4850
class Prism::ConstantPathWriteNode < ::Prism::Node
  # def initialize: (target: ConstantPathNode, operator_loc: Location, value: Node, location: Location) -> void
  #
  # @return [ConstantPathWriteNode] a new instance of ConstantPathWriteNode
  #
  # source://prism//lib/prism/node.rb#4860
  sig do
    params(
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(target, operator_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4868
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4873
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4883
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4878
  def compact_child_nodes; end

  # def copy: (**params) -> ConstantPathWriteNode
  #
  # source://prism//lib/prism/node.rb#4888
  sig { params(params: T.untyped).returns(Prism::ConstantPathWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4873
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#4901
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#4911
  def inspect(inspector = T.unsafe(nil)); end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#4906
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#4854
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader target: ConstantPathNode
  #
  # source://prism//lib/prism/node.rb#4851
  sig { returns(Prism::ConstantPathNode) }
  def target; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#4935
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#4857
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#4945
    def type; end
  end
end

# Represents referencing a constant.
#
#     Foo
#     ^^^
#
# source://prism//lib/prism/node.rb#4955
class Prism::ConstantReadNode < ::Prism::Node
  # def initialize: (name: Symbol, location: Location) -> void
  #
  # @return [ConstantReadNode] a new instance of ConstantReadNode
  #
  # source://prism//lib/prism/node.rb#4959
  sig { params(name: Symbol, location: Prism::Location).void }
  def initialize(name, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4965
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4970
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4980
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4975
  def compact_child_nodes; end

  # def copy: (**params) -> ConstantReadNode
  #
  # source://prism//lib/prism/node.rb#4985
  sig { params(params: T.untyped).returns(Prism::ConstantReadNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4970
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#4996
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # Returns the full name of this constant. For example: "Foo"
  #
  # source://prism//lib/prism/node_ext.rb#96
  def full_name; end

  # Returns the list of parts for the full name of this constant.
  # For example: [:Foo]
  #
  # source://prism//lib/prism/node_ext.rb#91
  def full_name_parts; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#5001
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#4956
  sig { returns(Symbol) }
  def name; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#5021
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#5031
    def type; end
  end
end

# Represents writing to a constant in a context that doesn't have an explicit value.
#
#     Foo, Bar = baz
#     ^^^  ^^^
#
# source://prism//lib/prism/node.rb#5041
class Prism::ConstantTargetNode < ::Prism::Node
  # def initialize: (name: Symbol, location: Location) -> void
  #
  # @return [ConstantTargetNode] a new instance of ConstantTargetNode
  #
  # source://prism//lib/prism/node.rb#5045
  sig { params(name: Symbol, location: Prism::Location).void }
  def initialize(name, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5051
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5056
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5066
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5061
  def compact_child_nodes; end

  # def copy: (**params) -> ConstantTargetNode
  #
  # source://prism//lib/prism/node.rb#5071
  sig { params(params: T.untyped).returns(Prism::ConstantTargetNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5056
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#5082
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#5087
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#5042
  sig { returns(Symbol) }
  def name; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#5107
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#5117
    def type; end
  end
end

# Represents writing to a constant.
#
#     Foo = 1
#     ^^^^^^^
#
# source://prism//lib/prism/node.rb#5127
class Prism::ConstantWriteNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, value: Node, operator_loc: Location, location: Location) -> void
  #
  # @return [ConstantWriteNode] a new instance of ConstantWriteNode
  #
  # source://prism//lib/prism/node.rb#5140
  sig do
    params(
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, value, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5149
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5154
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5164
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5159
  def compact_child_nodes; end

  # def copy: (**params) -> ConstantWriteNode
  #
  # source://prism//lib/prism/node.rb#5169
  sig { params(params: T.untyped).returns(Prism::ConstantWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5154
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#5183
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#5193
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#5128
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#5131
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#5188
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#5137
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#5217
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#5134
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#5227
    def type; end
  end
end

class Prism::DATAComment < Prism::Comment; end

# The DSL module provides a set of methods that can be used to create prism
# nodes in a more concise manner. For example, instead of writing:
#
#     source = Prism::Source.new("[1]")
#
#     Prism::ArrayNode.new(
#       [
#         Prism::IntegerNode.new(
#           Prism::IntegerBaseFlags::DECIMAL,
#           Prism::Location.new(source, 1, 1),
#         )
#       ],
#       Prism::Location.new(source, 0, 1),
#       Prism::Location.new(source, 2, 1)
#     )
#
# you could instead write:
#
#     source = Prism::Source.new("[1]")
#
#     ArrayNode(
#       IntegerNode(Prism::IntegerBaseFlags::DECIMAL, Location(source, 1, 1))),
#       Location(source, 0, 1),
#       Location(source, 2, 1)
#     )
#
# This is mostly helpful in the context of writing tests, but can also be used
# to generate trees programmatically.
#
# source://prism//lib/prism/dsl.rb#37
module Prism::DSL
  private

  # Create a new AliasGlobalVariableNode node
  #
  # source://prism//lib/prism/dsl.rb#46
  def AliasGlobalVariableNode(new_name, old_name, keyword_loc, location = T.unsafe(nil)); end

  # Create a new AliasMethodNode node
  #
  # source://prism//lib/prism/dsl.rb#51
  def AliasMethodNode(new_name, old_name, keyword_loc, location = T.unsafe(nil)); end

  # Create a new AlternationPatternNode node
  #
  # source://prism//lib/prism/dsl.rb#56
  def AlternationPatternNode(left, right, operator_loc, location = T.unsafe(nil)); end

  # Create a new AndNode node
  #
  # source://prism//lib/prism/dsl.rb#61
  def AndNode(left, right, operator_loc, location = T.unsafe(nil)); end

  # Create a new ArgumentsNode node
  #
  # source://prism//lib/prism/dsl.rb#66
  def ArgumentsNode(flags, arguments, location = T.unsafe(nil)); end

  # Create a new ArrayNode node
  #
  # source://prism//lib/prism/dsl.rb#71
  def ArrayNode(flags, elements, opening_loc, closing_loc, location = T.unsafe(nil)); end

  # Create a new ArrayPatternNode node
  #
  # source://prism//lib/prism/dsl.rb#76
  def ArrayPatternNode(constant, requireds, rest, posts, opening_loc, closing_loc, location = T.unsafe(nil)); end

  # Create a new AssocNode node
  #
  # source://prism//lib/prism/dsl.rb#81
  def AssocNode(key, value, operator_loc, location = T.unsafe(nil)); end

  # Create a new AssocSplatNode node
  #
  # source://prism//lib/prism/dsl.rb#86
  def AssocSplatNode(value, operator_loc, location = T.unsafe(nil)); end

  # Create a new BackReferenceReadNode node
  #
  # source://prism//lib/prism/dsl.rb#91
  def BackReferenceReadNode(name, location = T.unsafe(nil)); end

  # Create a new BeginNode node
  #
  # source://prism//lib/prism/dsl.rb#96
  def BeginNode(begin_keyword_loc, statements, rescue_clause, else_clause, ensure_clause, end_keyword_loc, location = T.unsafe(nil)); end

  # Create a new BlockArgumentNode node
  #
  # source://prism//lib/prism/dsl.rb#101
  def BlockArgumentNode(expression, operator_loc, location = T.unsafe(nil)); end

  # Create a new BlockLocalVariableNode node
  #
  # source://prism//lib/prism/dsl.rb#106
  def BlockLocalVariableNode(name, location = T.unsafe(nil)); end

  # Create a new BlockNode node
  #
  # source://prism//lib/prism/dsl.rb#111
  def BlockNode(locals, locals_body_index, parameters, body, opening_loc, closing_loc, location = T.unsafe(nil)); end

  # Create a new BlockParameterNode node
  #
  # source://prism//lib/prism/dsl.rb#116
  def BlockParameterNode(name, name_loc, operator_loc, location = T.unsafe(nil)); end

  # Create a new BlockParametersNode node
  #
  # source://prism//lib/prism/dsl.rb#121
  def BlockParametersNode(parameters, locals, opening_loc, closing_loc, location = T.unsafe(nil)); end

  # Create a new BreakNode node
  #
  # source://prism//lib/prism/dsl.rb#126
  def BreakNode(arguments, keyword_loc, location = T.unsafe(nil)); end

  # Create a new CallAndWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#131
  def CallAndWriteNode(flags, receiver, call_operator_loc, message_loc, read_name, write_name, operator_loc, value, location = T.unsafe(nil)); end

  # Create a new CallNode node
  #
  # source://prism//lib/prism/dsl.rb#136
  def CallNode(flags, receiver, call_operator_loc, name, message_loc, opening_loc, arguments, closing_loc, block, location = T.unsafe(nil)); end

  # Create a new CallOperatorWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#141
  def CallOperatorWriteNode(flags, receiver, call_operator_loc, message_loc, read_name, write_name, operator, operator_loc, value, location = T.unsafe(nil)); end

  # Create a new CallOrWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#146
  def CallOrWriteNode(flags, receiver, call_operator_loc, message_loc, read_name, write_name, operator_loc, value, location = T.unsafe(nil)); end

  # Create a new CallTargetNode node
  #
  # source://prism//lib/prism/dsl.rb#151
  def CallTargetNode(flags, receiver, call_operator_loc, name, message_loc, location = T.unsafe(nil)); end

  # Create a new CapturePatternNode node
  #
  # source://prism//lib/prism/dsl.rb#156
  def CapturePatternNode(value, target, operator_loc, location = T.unsafe(nil)); end

  # Create a new CaseMatchNode node
  #
  # source://prism//lib/prism/dsl.rb#161
  def CaseMatchNode(predicate, conditions, consequent, case_keyword_loc, end_keyword_loc, location = T.unsafe(nil)); end

  # Create a new CaseNode node
  #
  # source://prism//lib/prism/dsl.rb#166
  def CaseNode(predicate, conditions, consequent, case_keyword_loc, end_keyword_loc, location = T.unsafe(nil)); end

  # Create a new ClassNode node
  #
  # source://prism//lib/prism/dsl.rb#171
  def ClassNode(locals, class_keyword_loc, constant_path, inheritance_operator_loc, superclass, body, end_keyword_loc, name, location = T.unsafe(nil)); end

  # Create a new ClassVariableAndWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#176
  def ClassVariableAndWriteNode(name, name_loc, operator_loc, value, location = T.unsafe(nil)); end

  # Create a new ClassVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#181
  def ClassVariableOperatorWriteNode(name, name_loc, operator_loc, value, operator, location = T.unsafe(nil)); end

  # Create a new ClassVariableOrWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#186
  def ClassVariableOrWriteNode(name, name_loc, operator_loc, value, location = T.unsafe(nil)); end

  # Create a new ClassVariableReadNode node
  #
  # source://prism//lib/prism/dsl.rb#191
  def ClassVariableReadNode(name, location = T.unsafe(nil)); end

  # Create a new ClassVariableTargetNode node
  #
  # source://prism//lib/prism/dsl.rb#196
  def ClassVariableTargetNode(name, location = T.unsafe(nil)); end

  # Create a new ClassVariableWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#201
  def ClassVariableWriteNode(name, name_loc, value, operator_loc, location = T.unsafe(nil)); end

  # Create a new ConstantAndWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#206
  def ConstantAndWriteNode(name, name_loc, operator_loc, value, location = T.unsafe(nil)); end

  # Create a new ConstantOperatorWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#211
  def ConstantOperatorWriteNode(name, name_loc, operator_loc, value, operator, location = T.unsafe(nil)); end

  # Create a new ConstantOrWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#216
  def ConstantOrWriteNode(name, name_loc, operator_loc, value, location = T.unsafe(nil)); end

  # Create a new ConstantPathAndWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#221
  def ConstantPathAndWriteNode(target, operator_loc, value, location = T.unsafe(nil)); end

  # Create a new ConstantPathNode node
  #
  # source://prism//lib/prism/dsl.rb#226
  def ConstantPathNode(parent, child, delimiter_loc, location = T.unsafe(nil)); end

  # Create a new ConstantPathOperatorWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#231
  def ConstantPathOperatorWriteNode(target, operator_loc, value, operator, location = T.unsafe(nil)); end

  # Create a new ConstantPathOrWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#236
  def ConstantPathOrWriteNode(target, operator_loc, value, location = T.unsafe(nil)); end

  # Create a new ConstantPathTargetNode node
  #
  # source://prism//lib/prism/dsl.rb#241
  def ConstantPathTargetNode(parent, child, delimiter_loc, location = T.unsafe(nil)); end

  # Create a new ConstantPathWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#246
  def ConstantPathWriteNode(target, operator_loc, value, location = T.unsafe(nil)); end

  # Create a new ConstantReadNode node
  #
  # source://prism//lib/prism/dsl.rb#251
  def ConstantReadNode(name, location = T.unsafe(nil)); end

  # Create a new ConstantTargetNode node
  #
  # source://prism//lib/prism/dsl.rb#256
  def ConstantTargetNode(name, location = T.unsafe(nil)); end

  # Create a new ConstantWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#261
  def ConstantWriteNode(name, name_loc, value, operator_loc, location = T.unsafe(nil)); end

  # Create a new DefNode node
  #
  # source://prism//lib/prism/dsl.rb#266
  def DefNode(name, name_loc, receiver, parameters, body, locals, locals_body_index, def_keyword_loc, operator_loc, lparen_loc, rparen_loc, equal_loc, end_keyword_loc, location = T.unsafe(nil)); end

  # Create a new DefinedNode node
  #
  # source://prism//lib/prism/dsl.rb#271
  def DefinedNode(lparen_loc, value, rparen_loc, keyword_loc, location = T.unsafe(nil)); end

  # Create a new ElseNode node
  #
  # source://prism//lib/prism/dsl.rb#276
  def ElseNode(else_keyword_loc, statements, end_keyword_loc, location = T.unsafe(nil)); end

  # Create a new EmbeddedStatementsNode node
  #
  # source://prism//lib/prism/dsl.rb#281
  def EmbeddedStatementsNode(opening_loc, statements, closing_loc, location = T.unsafe(nil)); end

  # Create a new EmbeddedVariableNode node
  #
  # source://prism//lib/prism/dsl.rb#286
  def EmbeddedVariableNode(operator_loc, variable, location = T.unsafe(nil)); end

  # Create a new EnsureNode node
  #
  # source://prism//lib/prism/dsl.rb#291
  def EnsureNode(ensure_keyword_loc, statements, end_keyword_loc, location = T.unsafe(nil)); end

  # Create a new FalseNode node
  #
  # source://prism//lib/prism/dsl.rb#296
  def FalseNode(location = T.unsafe(nil)); end

  # Create a new FindPatternNode node
  #
  # source://prism//lib/prism/dsl.rb#301
  def FindPatternNode(constant, left, requireds, right, opening_loc, closing_loc, location = T.unsafe(nil)); end

  # Create a new FlipFlopNode node
  #
  # source://prism//lib/prism/dsl.rb#306
  def FlipFlopNode(flags, left, right, operator_loc, location = T.unsafe(nil)); end

  # Create a new FloatNode node
  #
  # source://prism//lib/prism/dsl.rb#311
  def FloatNode(location = T.unsafe(nil)); end

  # Create a new ForNode node
  #
  # source://prism//lib/prism/dsl.rb#316
  def ForNode(index, collection, statements, for_keyword_loc, in_keyword_loc, do_keyword_loc, end_keyword_loc, location = T.unsafe(nil)); end

  # Create a new ForwardingArgumentsNode node
  #
  # source://prism//lib/prism/dsl.rb#321
  def ForwardingArgumentsNode(location = T.unsafe(nil)); end

  # Create a new ForwardingParameterNode node
  #
  # source://prism//lib/prism/dsl.rb#326
  def ForwardingParameterNode(location = T.unsafe(nil)); end

  # Create a new ForwardingSuperNode node
  #
  # source://prism//lib/prism/dsl.rb#331
  def ForwardingSuperNode(block, location = T.unsafe(nil)); end

  # Create a new GlobalVariableAndWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#336
  def GlobalVariableAndWriteNode(name, name_loc, operator_loc, value, location = T.unsafe(nil)); end

  # Create a new GlobalVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#341
  def GlobalVariableOperatorWriteNode(name, name_loc, operator_loc, value, operator, location = T.unsafe(nil)); end

  # Create a new GlobalVariableOrWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#346
  def GlobalVariableOrWriteNode(name, name_loc, operator_loc, value, location = T.unsafe(nil)); end

  # Create a new GlobalVariableReadNode node
  #
  # source://prism//lib/prism/dsl.rb#351
  def GlobalVariableReadNode(name, location = T.unsafe(nil)); end

  # Create a new GlobalVariableTargetNode node
  #
  # source://prism//lib/prism/dsl.rb#356
  def GlobalVariableTargetNode(name, location = T.unsafe(nil)); end

  # Create a new GlobalVariableWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#361
  def GlobalVariableWriteNode(name, name_loc, value, operator_loc, location = T.unsafe(nil)); end

  # Create a new HashNode node
  #
  # source://prism//lib/prism/dsl.rb#366
  def HashNode(opening_loc, elements, closing_loc, location = T.unsafe(nil)); end

  # Create a new HashPatternNode node
  #
  # source://prism//lib/prism/dsl.rb#371
  def HashPatternNode(constant, elements, rest, opening_loc, closing_loc, location = T.unsafe(nil)); end

  # Create a new IfNode node
  #
  # source://prism//lib/prism/dsl.rb#376
  def IfNode(if_keyword_loc, predicate, then_keyword_loc, statements, consequent, end_keyword_loc, location = T.unsafe(nil)); end

  # Create a new ImaginaryNode node
  #
  # source://prism//lib/prism/dsl.rb#381
  def ImaginaryNode(numeric, location = T.unsafe(nil)); end

  # Create a new ImplicitNode node
  #
  # source://prism//lib/prism/dsl.rb#386
  def ImplicitNode(value, location = T.unsafe(nil)); end

  # Create a new ImplicitRestNode node
  #
  # source://prism//lib/prism/dsl.rb#391
  def ImplicitRestNode(location = T.unsafe(nil)); end

  # Create a new InNode node
  #
  # source://prism//lib/prism/dsl.rb#396
  def InNode(pattern, statements, in_loc, then_loc, location = T.unsafe(nil)); end

  # Create a new IndexAndWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#401
  def IndexAndWriteNode(flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, operator_loc, value, location = T.unsafe(nil)); end

  # Create a new IndexOperatorWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#406
  def IndexOperatorWriteNode(flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, operator, operator_loc, value, location = T.unsafe(nil)); end

  # Create a new IndexOrWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#411
  def IndexOrWriteNode(flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, operator_loc, value, location = T.unsafe(nil)); end

  # Create a new IndexTargetNode node
  #
  # source://prism//lib/prism/dsl.rb#416
  def IndexTargetNode(flags, receiver, opening_loc, arguments, closing_loc, block, location = T.unsafe(nil)); end

  # Create a new InstanceVariableAndWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#421
  def InstanceVariableAndWriteNode(name, name_loc, operator_loc, value, location = T.unsafe(nil)); end

  # Create a new InstanceVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#426
  def InstanceVariableOperatorWriteNode(name, name_loc, operator_loc, value, operator, location = T.unsafe(nil)); end

  # Create a new InstanceVariableOrWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#431
  def InstanceVariableOrWriteNode(name, name_loc, operator_loc, value, location = T.unsafe(nil)); end

  # Create a new InstanceVariableReadNode node
  #
  # source://prism//lib/prism/dsl.rb#436
  def InstanceVariableReadNode(name, location = T.unsafe(nil)); end

  # Create a new InstanceVariableTargetNode node
  #
  # source://prism//lib/prism/dsl.rb#441
  def InstanceVariableTargetNode(name, location = T.unsafe(nil)); end

  # Create a new InstanceVariableWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#446
  def InstanceVariableWriteNode(name, name_loc, value, operator_loc, location = T.unsafe(nil)); end

  # Create a new IntegerNode node
  #
  # source://prism//lib/prism/dsl.rb#451
  def IntegerNode(flags, location = T.unsafe(nil)); end

  # Create a new InterpolatedMatchLastLineNode node
  #
  # source://prism//lib/prism/dsl.rb#456
  def InterpolatedMatchLastLineNode(flags, opening_loc, parts, closing_loc, location = T.unsafe(nil)); end

  # Create a new InterpolatedRegularExpressionNode node
  #
  # source://prism//lib/prism/dsl.rb#461
  def InterpolatedRegularExpressionNode(flags, opening_loc, parts, closing_loc, location = T.unsafe(nil)); end

  # Create a new InterpolatedStringNode node
  #
  # source://prism//lib/prism/dsl.rb#466
  def InterpolatedStringNode(opening_loc, parts, closing_loc, location = T.unsafe(nil)); end

  # Create a new InterpolatedSymbolNode node
  #
  # source://prism//lib/prism/dsl.rb#471
  def InterpolatedSymbolNode(opening_loc, parts, closing_loc, location = T.unsafe(nil)); end

  # Create a new InterpolatedXStringNode node
  #
  # source://prism//lib/prism/dsl.rb#476
  def InterpolatedXStringNode(opening_loc, parts, closing_loc, location = T.unsafe(nil)); end

  # Create a new KeywordHashNode node
  #
  # source://prism//lib/prism/dsl.rb#481
  def KeywordHashNode(flags, elements, location = T.unsafe(nil)); end

  # Create a new KeywordRestParameterNode node
  #
  # source://prism//lib/prism/dsl.rb#486
  def KeywordRestParameterNode(name, name_loc, operator_loc, location = T.unsafe(nil)); end

  # Create a new LambdaNode node
  #
  # source://prism//lib/prism/dsl.rb#491
  def LambdaNode(locals, locals_body_index, operator_loc, opening_loc, closing_loc, parameters, body, location = T.unsafe(nil)); end

  # Create a new LocalVariableAndWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#496
  def LocalVariableAndWriteNode(name_loc, operator_loc, value, name, depth, location = T.unsafe(nil)); end

  # Create a new LocalVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#501
  def LocalVariableOperatorWriteNode(name_loc, operator_loc, value, name, operator, depth, location = T.unsafe(nil)); end

  # Create a new LocalVariableOrWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#506
  def LocalVariableOrWriteNode(name_loc, operator_loc, value, name, depth, location = T.unsafe(nil)); end

  # Create a new LocalVariableReadNode node
  #
  # source://prism//lib/prism/dsl.rb#511
  def LocalVariableReadNode(name, depth, location = T.unsafe(nil)); end

  # Create a new LocalVariableTargetNode node
  #
  # source://prism//lib/prism/dsl.rb#516
  def LocalVariableTargetNode(name, depth, location = T.unsafe(nil)); end

  # Create a new LocalVariableWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#521
  def LocalVariableWriteNode(name, depth, name_loc, value, operator_loc, location = T.unsafe(nil)); end

  # Create a new Location object
  #
  # source://prism//lib/prism/dsl.rb#41
  def Location(source = T.unsafe(nil), start_offset = T.unsafe(nil), length = T.unsafe(nil)); end

  # Create a new MatchLastLineNode node
  #
  # source://prism//lib/prism/dsl.rb#526
  def MatchLastLineNode(flags, opening_loc, content_loc, closing_loc, unescaped, location = T.unsafe(nil)); end

  # Create a new MatchPredicateNode node
  #
  # source://prism//lib/prism/dsl.rb#531
  def MatchPredicateNode(value, pattern, operator_loc, location = T.unsafe(nil)); end

  # Create a new MatchRequiredNode node
  #
  # source://prism//lib/prism/dsl.rb#536
  def MatchRequiredNode(value, pattern, operator_loc, location = T.unsafe(nil)); end

  # Create a new MatchWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#541
  def MatchWriteNode(call, targets, location = T.unsafe(nil)); end

  # Create a new MissingNode node
  #
  # source://prism//lib/prism/dsl.rb#546
  def MissingNode(location = T.unsafe(nil)); end

  # Create a new ModuleNode node
  #
  # source://prism//lib/prism/dsl.rb#551
  def ModuleNode(locals, module_keyword_loc, constant_path, body, end_keyword_loc, name, location = T.unsafe(nil)); end

  # Create a new MultiTargetNode node
  #
  # source://prism//lib/prism/dsl.rb#556
  def MultiTargetNode(lefts, rest, rights, lparen_loc, rparen_loc, location = T.unsafe(nil)); end

  # Create a new MultiWriteNode node
  #
  # source://prism//lib/prism/dsl.rb#561
  def MultiWriteNode(lefts, rest, rights, lparen_loc, rparen_loc, operator_loc, value, location = T.unsafe(nil)); end

  # Create a new NextNode node
  #
  # source://prism//lib/prism/dsl.rb#566
  def NextNode(arguments, keyword_loc, location = T.unsafe(nil)); end

  # Create a new NilNode node
  #
  # source://prism//lib/prism/dsl.rb#571
  def NilNode(location = T.unsafe(nil)); end

  # Create a new NoKeywordsParameterNode node
  #
  # source://prism//lib/prism/dsl.rb#576
  def NoKeywordsParameterNode(operator_loc, keyword_loc, location = T.unsafe(nil)); end

  # Create a new NumberedParametersNode node
  #
  # source://prism//lib/prism/dsl.rb#581
  def NumberedParametersNode(maximum, location = T.unsafe(nil)); end

  # Create a new NumberedReferenceReadNode node
  #
  # source://prism//lib/prism/dsl.rb#586
  def NumberedReferenceReadNode(number, location = T.unsafe(nil)); end

  # Create a new OptionalKeywordParameterNode node
  #
  # source://prism//lib/prism/dsl.rb#591
  def OptionalKeywordParameterNode(name, name_loc, value, location = T.unsafe(nil)); end

  # Create a new OptionalParameterNode node
  #
  # source://prism//lib/prism/dsl.rb#596
  def OptionalParameterNode(name, name_loc, operator_loc, value, location = T.unsafe(nil)); end

  # Create a new OrNode node
  #
  # source://prism//lib/prism/dsl.rb#601
  def OrNode(left, right, operator_loc, location = T.unsafe(nil)); end

  # Create a new ParametersNode node
  #
  # source://prism//lib/prism/dsl.rb#606
  def ParametersNode(requireds, optionals, rest, posts, keywords, keyword_rest, block, location = T.unsafe(nil)); end

  # Create a new ParenthesesNode node
  #
  # source://prism//lib/prism/dsl.rb#611
  def ParenthesesNode(body, opening_loc, closing_loc, location = T.unsafe(nil)); end

  # Create a new PinnedExpressionNode node
  #
  # source://prism//lib/prism/dsl.rb#616
  def PinnedExpressionNode(expression, operator_loc, lparen_loc, rparen_loc, location = T.unsafe(nil)); end

  # Create a new PinnedVariableNode node
  #
  # source://prism//lib/prism/dsl.rb#621
  def PinnedVariableNode(variable, operator_loc, location = T.unsafe(nil)); end

  # Create a new PostExecutionNode node
  #
  # source://prism//lib/prism/dsl.rb#626
  def PostExecutionNode(statements, keyword_loc, opening_loc, closing_loc, location = T.unsafe(nil)); end

  # Create a new PreExecutionNode node
  #
  # source://prism//lib/prism/dsl.rb#631
  def PreExecutionNode(statements, keyword_loc, opening_loc, closing_loc, location = T.unsafe(nil)); end

  # Create a new ProgramNode node
  #
  # source://prism//lib/prism/dsl.rb#636
  def ProgramNode(locals, statements, location = T.unsafe(nil)); end

  # Create a new RangeNode node
  #
  # source://prism//lib/prism/dsl.rb#641
  def RangeNode(flags, left, right, operator_loc, location = T.unsafe(nil)); end

  # Create a new RationalNode node
  #
  # source://prism//lib/prism/dsl.rb#646
  def RationalNode(numeric, location = T.unsafe(nil)); end

  # Create a new RedoNode node
  #
  # source://prism//lib/prism/dsl.rb#651
  def RedoNode(location = T.unsafe(nil)); end

  # Create a new RegularExpressionNode node
  #
  # source://prism//lib/prism/dsl.rb#656
  def RegularExpressionNode(flags, opening_loc, content_loc, closing_loc, unescaped, location = T.unsafe(nil)); end

  # Create a new RequiredKeywordParameterNode node
  #
  # source://prism//lib/prism/dsl.rb#661
  def RequiredKeywordParameterNode(name, name_loc, location = T.unsafe(nil)); end

  # Create a new RequiredParameterNode node
  #
  # source://prism//lib/prism/dsl.rb#666
  def RequiredParameterNode(name, location = T.unsafe(nil)); end

  # Create a new RescueModifierNode node
  #
  # source://prism//lib/prism/dsl.rb#671
  def RescueModifierNode(expression, keyword_loc, rescue_expression, location = T.unsafe(nil)); end

  # Create a new RescueNode node
  #
  # source://prism//lib/prism/dsl.rb#676
  def RescueNode(keyword_loc, exceptions, operator_loc, reference, statements, consequent, location = T.unsafe(nil)); end

  # Create a new RestParameterNode node
  #
  # source://prism//lib/prism/dsl.rb#681
  def RestParameterNode(name, name_loc, operator_loc, location = T.unsafe(nil)); end

  # Create a new RetryNode node
  #
  # source://prism//lib/prism/dsl.rb#686
  def RetryNode(location = T.unsafe(nil)); end

  # Create a new ReturnNode node
  #
  # source://prism//lib/prism/dsl.rb#691
  def ReturnNode(keyword_loc, arguments, location = T.unsafe(nil)); end

  # Create a new SelfNode node
  #
  # source://prism//lib/prism/dsl.rb#696
  def SelfNode(location = T.unsafe(nil)); end

  # Create a new SingletonClassNode node
  #
  # source://prism//lib/prism/dsl.rb#701
  def SingletonClassNode(locals, class_keyword_loc, operator_loc, expression, body, end_keyword_loc, location = T.unsafe(nil)); end

  # Create a new SourceEncodingNode node
  #
  # source://prism//lib/prism/dsl.rb#706
  def SourceEncodingNode(location = T.unsafe(nil)); end

  # Create a new SourceFileNode node
  #
  # source://prism//lib/prism/dsl.rb#711
  def SourceFileNode(filepath, location = T.unsafe(nil)); end

  # Create a new SourceLineNode node
  #
  # source://prism//lib/prism/dsl.rb#716
  def SourceLineNode(location = T.unsafe(nil)); end

  # Create a new SplatNode node
  #
  # source://prism//lib/prism/dsl.rb#721
  def SplatNode(operator_loc, expression, location = T.unsafe(nil)); end

  # Create a new StatementsNode node
  #
  # source://prism//lib/prism/dsl.rb#726
  def StatementsNode(body, location = T.unsafe(nil)); end

  # Create a new StringNode node
  #
  # source://prism//lib/prism/dsl.rb#731
  def StringNode(flags, opening_loc, content_loc, closing_loc, unescaped, location = T.unsafe(nil)); end

  # Create a new SuperNode node
  #
  # source://prism//lib/prism/dsl.rb#736
  def SuperNode(keyword_loc, lparen_loc, arguments, rparen_loc, block, location = T.unsafe(nil)); end

  # Create a new SymbolNode node
  #
  # source://prism//lib/prism/dsl.rb#741
  def SymbolNode(flags, opening_loc, value_loc, closing_loc, unescaped, location = T.unsafe(nil)); end

  # Create a new TrueNode node
  #
  # source://prism//lib/prism/dsl.rb#746
  def TrueNode(location = T.unsafe(nil)); end

  # Create a new UndefNode node
  #
  # source://prism//lib/prism/dsl.rb#751
  def UndefNode(names, keyword_loc, location = T.unsafe(nil)); end

  # Create a new UnlessNode node
  #
  # source://prism//lib/prism/dsl.rb#756
  def UnlessNode(keyword_loc, predicate, then_keyword_loc, statements, consequent, end_keyword_loc, location = T.unsafe(nil)); end

  # Create a new UntilNode node
  #
  # source://prism//lib/prism/dsl.rb#761
  def UntilNode(flags, keyword_loc, closing_loc, predicate, statements, location = T.unsafe(nil)); end

  # Create a new WhenNode node
  #
  # source://prism//lib/prism/dsl.rb#766
  def WhenNode(keyword_loc, conditions, statements, location = T.unsafe(nil)); end

  # Create a new WhileNode node
  #
  # source://prism//lib/prism/dsl.rb#771
  def WhileNode(flags, keyword_loc, closing_loc, predicate, statements, location = T.unsafe(nil)); end

  # Create a new XStringNode node
  #
  # source://prism//lib/prism/dsl.rb#776
  def XStringNode(flags, opening_loc, content_loc, closing_loc, unescaped, location = T.unsafe(nil)); end

  # Create a new YieldNode node
  #
  # source://prism//lib/prism/dsl.rb#781
  def YieldNode(keyword_loc, lparen_loc, arguments, rparen_loc, location = T.unsafe(nil)); end
end

# This module is used for testing and debugging and is not meant to be used by
# consumers of this library.
#
# source://prism//lib/prism/debug.rb#6
module Prism::Debug
  class << self
    # :call-seq:
    #   Debug::cruby_locals(source) -> Array
    #
    # For the given source, compiles with CRuby and returns a list of all of the
    # sets of local variables that were encountered.
    #
    # source://prism//lib/prism/debug.rb#54
    def cruby_locals(source); end

    def inspect_node(_arg0); end
    def memsize(_arg0); end
    def named_captures(_arg0); end

    # :call-seq:
    #   Debug::newlines(source) -> Array
    #
    # For the given source string, return the byte offsets of every newline in
    # the source.
    #
    # source://prism//lib/prism/debug.rb#196
    def newlines(source); end

    # :call-seq:
    #   Debug::prism_locals(source) -> Array
    #
    # For the given source, parses with prism and returns a list of all of the
    # sets of local variables that were encountered.
    #
    # source://prism//lib/prism/debug.rb#98
    def prism_locals(source); end

    def profile_file(_arg0); end
  end
end

# Used to hold the place of a local that will be in the local table but
# cannot be accessed directly from the source code. For example, the
# iteration variable in a for loop or the positional parameter on a method
# definition that is destructured.
#
# source://prism//lib/prism/debug.rb#90
Prism::Debug::AnonymousLocal = T.let(T.unsafe(nil), Object)

# A wrapper around a RubyVM::InstructionSequence that provides a more
# convenient interface for accessing parts of the iseq.
#
# source://prism//lib/prism/debug.rb#9
class Prism::Debug::ISeq
  # @return [ISeq] a new instance of ISeq
  #
  # source://prism//lib/prism/debug.rb#12
  def initialize(parts); end

  # source://prism//lib/prism/debug.rb#28
  def each_child; end

  # source://prism//lib/prism/debug.rb#24
  def instructions; end

  # source://prism//lib/prism/debug.rb#20
  def local_table; end

  # source://prism//lib/prism/debug.rb#10
  def parts; end

  # source://prism//lib/prism/debug.rb#16
  def type; end
end

# Represents a method definition.
#
#     def method
#     end
#     ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#5238
class Prism::DefNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, receiver: Node?, parameters: ParametersNode?, body: Node?, locals: Array[Symbol], locals_body_index: Integer, def_keyword_loc: Location, operator_loc: Location?, lparen_loc: Location?, rparen_loc: Location?, equal_loc: Location?, end_keyword_loc: Location?, location: Location) -> void
  #
  # @return [DefNode] a new instance of DefNode
  #
  # source://prism//lib/prism/node.rb#5278
  sig do
    params(
      name: Symbol,
      name_loc: Prism::Location,
      receiver: T.nilable(Prism::Node),
      parameters: T.nilable(Prism::ParametersNode),
      body: T.nilable(Prism::Node),
      locals: T::Array[Symbol],
      locals_body_index: Integer,
      def_keyword_loc: Prism::Location,
      operator_loc: T.nilable(Prism::Location),
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location),
      equal_loc: T.nilable(Prism::Location),
      end_keyword_loc: T.nilable(Prism::Location),
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, receiver, parameters, body, locals, locals_body_index, def_keyword_loc, operator_loc, lparen_loc, rparen_loc, equal_loc, end_keyword_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5296
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader body: Node?
  #
  # source://prism//lib/prism/node.rb#5251
  sig { returns(T.nilable(Prism::Node)) }
  def body; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5301
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5315
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5306
  def compact_child_nodes; end

  # def copy: (**params) -> DefNode
  #
  # source://prism//lib/prism/node.rb#5320
  sig { params(params: T.untyped).returns(Prism::DefNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5301
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#5343
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def def_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#5348
  sig { returns(String) }
  def def_keyword; end

  # attr_reader def_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#5260
  sig { returns(Prism::Location) }
  def def_keyword_loc; end

  # def end_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#5373
  sig { returns(T.nilable(String)) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location?
  #
  # source://prism//lib/prism/node.rb#5275
  sig { returns(T.nilable(Prism::Location)) }
  def end_keyword_loc; end

  # def equal: () -> String?
  #
  # source://prism//lib/prism/node.rb#5368
  sig { returns(T.nilable(String)) }
  def equal; end

  # attr_reader equal_loc: Location?
  #
  # source://prism//lib/prism/node.rb#5272
  sig { returns(T.nilable(Prism::Location)) }
  def equal_loc; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#5378
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader locals: Array[Symbol]
  #
  # source://prism//lib/prism/node.rb#5254
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # attr_reader locals_body_index: Integer
  #
  # source://prism//lib/prism/node.rb#5257
  sig { returns(Integer) }
  def locals_body_index; end

  # def lparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#5358
  sig { returns(T.nilable(String)) }
  def lparen; end

  # attr_reader lparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#5266
  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#5239
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#5242
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#5353
  sig { returns(T.nilable(String)) }
  def operator; end

  # attr_reader operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#5263
  sig { returns(T.nilable(Prism::Location)) }
  def operator_loc; end

  # attr_reader parameters: ParametersNode?
  #
  # source://prism//lib/prism/node.rb#5248
  sig { returns(T.nilable(Prism::ParametersNode)) }
  def parameters; end

  # attr_reader receiver: Node?
  #
  # source://prism//lib/prism/node.rb#5245
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def rparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#5363
  sig { returns(T.nilable(String)) }
  def rparen; end

  # attr_reader rparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#5269
  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#5425
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#5435
    def type; end
  end
end

# Represents the use of the `defined?` keyword.
#
#     defined?(a)
#     ^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#5445
class Prism::DefinedNode < ::Prism::Node
  # def initialize: (lparen_loc: Location?, value: Node, rparen_loc: Location?, keyword_loc: Location, location: Location) -> void
  #
  # @return [DefinedNode] a new instance of DefinedNode
  #
  # source://prism//lib/prism/node.rb#5458
  sig do
    params(
      lparen_loc: T.nilable(Prism::Location),
      value: Prism::Node,
      rparen_loc: T.nilable(Prism::Location),
      keyword_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(lparen_loc, value, rparen_loc, keyword_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5467
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5472
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5482
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5477
  def compact_child_nodes; end

  # def copy: (**params) -> DefinedNode
  #
  # source://prism//lib/prism/node.rb#5487
  sig { params(params: T.untyped).returns(Prism::DefinedNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5472
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#5501
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#5521
  def inspect(inspector = T.unsafe(nil)); end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#5516
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#5455
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # def lparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#5506
  sig { returns(T.nilable(String)) }
  def lparen; end

  # attr_reader lparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#5446
  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  # def rparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#5511
  sig { returns(T.nilable(String)) }
  def rparen; end

  # attr_reader rparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#5452
  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#5545
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#5449
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#5555
    def type; end
  end
end

# DesugarCompiler is a compiler that desugars Ruby code into a more primitive
# form. This is useful for consumers that want to deal with fewer node types.
#
# source://prism//lib/prism/desugar_compiler.rb#11
class Prism::DesugarCompiler < ::Prism::MutationCompiler
  # @@foo &&= bar
  #
  # becomes
  #
  # @@foo && @@foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#12
  def visit_class_variable_and_write_node(node); end

  # @@foo += bar
  #
  # becomes
  #
  # @@foo = @@foo + bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#30
  def visit_class_variable_operator_write_node(node); end

  # @@foo ||= bar
  #
  # becomes
  #
  # defined?(@@foo) ? @@foo : @@foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#21
  def visit_class_variable_or_write_node(node); end

  # Foo &&= bar
  #
  # becomes
  #
  # Foo && Foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#39
  def visit_constant_and_write_node(node); end

  # Foo += bar
  #
  # becomes
  #
  # Foo = Foo + bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#57
  def visit_constant_operator_write_node(node); end

  # Foo ||= bar
  #
  # becomes
  #
  # defined?(Foo) ? Foo : Foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#48
  def visit_constant_or_write_node(node); end

  # $foo &&= bar
  #
  # becomes
  #
  # $foo && $foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#66
  def visit_global_variable_and_write_node(node); end

  # $foo += bar
  #
  # becomes
  #
  # $foo = $foo + bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#84
  def visit_global_variable_operator_write_node(node); end

  # $foo ||= bar
  #
  # becomes
  #
  # defined?($foo) ? $foo : $foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#75
  def visit_global_variable_or_write_node(node); end

  # becomes
  #
  # source://prism//lib/prism/desugar_compiler.rb#93
  def visit_instance_variable_and_write_node(node); end

  # becomes
  #
  # source://prism//lib/prism/desugar_compiler.rb#111
  def visit_instance_variable_operator_write_node(node); end

  # becomes
  #
  # source://prism//lib/prism/desugar_compiler.rb#102
  def visit_instance_variable_or_write_node(node); end

  # foo &&= bar
  #
  # becomes
  #
  # foo && foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#120
  def visit_local_variable_and_write_node(node); end

  # foo += bar
  #
  # becomes
  #
  # foo = foo + bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#138
  def visit_local_variable_operator_write_node(node); end

  # foo ||= bar
  #
  # becomes
  #
  # foo || foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#129
  def visit_local_variable_or_write_node(node); end

  private

  # Desugar `x &&= y` to `x && x = y`
  #
  # source://prism//lib/prism/desugar_compiler.rb#145
  def desugar_and_write_node(node, read_class, write_class, *arguments); end

  # Desugar `x += y` to `x = x + y`
  #
  # source://prism//lib/prism/desugar_compiler.rb#155
  def desugar_operator_write_node(node, read_class, write_class, *arguments); end

  # Desugar `x ||= y` to `defined?(x) ? x : x = y`
  #
  # source://prism//lib/prism/desugar_compiler.rb#187
  def desugar_or_write_defined_node(node, read_class, write_class, *arguments); end

  # Desugar `x ||= y` to `x || x = y`
  #
  # source://prism//lib/prism/desugar_compiler.rb#177
  def desugar_or_write_node(node, read_class, write_class, *arguments); end
end

# The dispatcher class fires events for nodes that are found while walking an
# AST to all registered listeners. It's useful for performing different types
# of analysis on the AST while only having to walk the tree once.
#
# To use the dispatcher, you would first instantiate it and register listeners
# for the events you're interested in:
#
#     class OctalListener
#       def on_integer_node_enter(node)
#         if node.octal? && !node.slice.start_with?("0o")
#           warn("Octal integers should be written with the 0o prefix")
#         end
#       end
#     end
#
#     dispatcher = Dispatcher.new
#     dispatcher.register(listener, :on_integer_node_enter)
#
# Then, you can walk any number of trees and dispatch events to the listeners:
#
#     result = Prism.parse("001 + 002 + 003")
#     dispatcher.dispatch(result.value)
#
# Optionally, you can also use `#dispatch_once` to dispatch enter and leave
# events for a single node without recursing further down the tree. This can
# be useful in circumstances where you want to reuse the listeners you already
# have registers but want to stop walking the tree at a certain point.
#
#     integer = result.value.statements.body.first.receiver.receiver
#     dispatcher.dispatch_once(integer)
#
# source://prism//lib/prism/dispatcher.rb#41
class Prism::Dispatcher < ::Prism::Visitor
  # Initialize a new dispatcher.
  #
  # @return [Dispatcher] a new instance of Dispatcher
  #
  # source://prism//lib/prism/dispatcher.rb#45
  def initialize; end

  # Walks `root` dispatching events to all registered listeners.
  #
  # def dispatch: (Node) -> void
  #
  # source://prism//lib/prism/visitor.rb#16
  def dispatch(node); end

  # Dispatches a single event for `node` to all registered listeners.
  #
  # def dispatch_once: (Node) -> void
  #
  # source://prism//lib/prism/dispatcher.rb#64
  def dispatch_once(node); end

  # attr_reader listeners: Hash[Symbol, Array[Listener]]
  #
  # source://prism//lib/prism/dispatcher.rb#42
  def listeners; end

  # Register a listener for one or more events.
  #
  # def register: (Listener, *Symbol) -> void
  #
  # source://prism//lib/prism/dispatcher.rb#52
  def register(listener, *events); end

  # Dispatch enter and leave events for AliasGlobalVariableNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#70
  def visit_alias_global_variable_node(node); end

  # Dispatch enter and leave events for AliasMethodNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#78
  def visit_alias_method_node(node); end

  # Dispatch enter and leave events for AlternationPatternNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#86
  def visit_alternation_pattern_node(node); end

  # Dispatch enter and leave events for AndNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#94
  def visit_and_node(node); end

  # Dispatch enter and leave events for ArgumentsNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#102
  def visit_arguments_node(node); end

  # Dispatch enter and leave events for ArrayNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#110
  def visit_array_node(node); end

  # Dispatch enter and leave events for ArrayPatternNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#118
  def visit_array_pattern_node(node); end

  # Dispatch enter and leave events for AssocNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#126
  def visit_assoc_node(node); end

  # Dispatch enter and leave events for AssocSplatNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#134
  def visit_assoc_splat_node(node); end

  # Dispatch enter and leave events for BackReferenceReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#142
  def visit_back_reference_read_node(node); end

  # Dispatch enter and leave events for BeginNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#150
  def visit_begin_node(node); end

  # Dispatch enter and leave events for BlockArgumentNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#158
  def visit_block_argument_node(node); end

  # Dispatch enter and leave events for BlockLocalVariableNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#166
  def visit_block_local_variable_node(node); end

  # Dispatch enter and leave events for BlockNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#174
  def visit_block_node(node); end

  # Dispatch enter and leave events for BlockParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#182
  def visit_block_parameter_node(node); end

  # Dispatch enter and leave events for BlockParametersNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#190
  def visit_block_parameters_node(node); end

  # Dispatch enter and leave events for BreakNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#198
  def visit_break_node(node); end

  # Dispatch enter and leave events for CallAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#206
  def visit_call_and_write_node(node); end

  # Dispatch enter and leave events for CallNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#214
  def visit_call_node(node); end

  # Dispatch enter and leave events for CallOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#222
  def visit_call_operator_write_node(node); end

  # Dispatch enter and leave events for CallOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#230
  def visit_call_or_write_node(node); end

  # Dispatch enter and leave events for CallTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#238
  def visit_call_target_node(node); end

  # Dispatch enter and leave events for CapturePatternNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#246
  def visit_capture_pattern_node(node); end

  # Dispatch enter and leave events for CaseMatchNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#254
  def visit_case_match_node(node); end

  # Dispatch enter and leave events for CaseNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#262
  def visit_case_node(node); end

  # Dispatch enter and leave events for ClassNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#270
  def visit_class_node(node); end

  # Dispatch enter and leave events for ClassVariableAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#278
  def visit_class_variable_and_write_node(node); end

  # Dispatch enter and leave events for ClassVariableOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#286
  def visit_class_variable_operator_write_node(node); end

  # Dispatch enter and leave events for ClassVariableOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#294
  def visit_class_variable_or_write_node(node); end

  # Dispatch enter and leave events for ClassVariableReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#302
  def visit_class_variable_read_node(node); end

  # Dispatch enter and leave events for ClassVariableTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#310
  def visit_class_variable_target_node(node); end

  # Dispatch enter and leave events for ClassVariableWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#318
  def visit_class_variable_write_node(node); end

  # Dispatch enter and leave events for ConstantAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#326
  def visit_constant_and_write_node(node); end

  # Dispatch enter and leave events for ConstantOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#334
  def visit_constant_operator_write_node(node); end

  # Dispatch enter and leave events for ConstantOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#342
  def visit_constant_or_write_node(node); end

  # Dispatch enter and leave events for ConstantPathAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#350
  def visit_constant_path_and_write_node(node); end

  # Dispatch enter and leave events for ConstantPathNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#358
  def visit_constant_path_node(node); end

  # Dispatch enter and leave events for ConstantPathOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#366
  def visit_constant_path_operator_write_node(node); end

  # Dispatch enter and leave events for ConstantPathOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#374
  def visit_constant_path_or_write_node(node); end

  # Dispatch enter and leave events for ConstantPathTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#382
  def visit_constant_path_target_node(node); end

  # Dispatch enter and leave events for ConstantPathWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#390
  def visit_constant_path_write_node(node); end

  # Dispatch enter and leave events for ConstantReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#398
  def visit_constant_read_node(node); end

  # Dispatch enter and leave events for ConstantTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#406
  def visit_constant_target_node(node); end

  # Dispatch enter and leave events for ConstantWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#414
  def visit_constant_write_node(node); end

  # Dispatch enter and leave events for DefNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#422
  def visit_def_node(node); end

  # Dispatch enter and leave events for DefinedNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#430
  def visit_defined_node(node); end

  # Dispatch enter and leave events for ElseNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#438
  def visit_else_node(node); end

  # Dispatch enter and leave events for EmbeddedStatementsNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#446
  def visit_embedded_statements_node(node); end

  # Dispatch enter and leave events for EmbeddedVariableNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#454
  def visit_embedded_variable_node(node); end

  # Dispatch enter and leave events for EnsureNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#462
  def visit_ensure_node(node); end

  # Dispatch enter and leave events for FalseNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#470
  def visit_false_node(node); end

  # Dispatch enter and leave events for FindPatternNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#478
  def visit_find_pattern_node(node); end

  # Dispatch enter and leave events for FlipFlopNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#486
  def visit_flip_flop_node(node); end

  # Dispatch enter and leave events for FloatNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#494
  def visit_float_node(node); end

  # Dispatch enter and leave events for ForNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#502
  def visit_for_node(node); end

  # Dispatch enter and leave events for ForwardingArgumentsNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#510
  def visit_forwarding_arguments_node(node); end

  # Dispatch enter and leave events for ForwardingParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#518
  def visit_forwarding_parameter_node(node); end

  # Dispatch enter and leave events for ForwardingSuperNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#526
  def visit_forwarding_super_node(node); end

  # Dispatch enter and leave events for GlobalVariableAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#534
  def visit_global_variable_and_write_node(node); end

  # Dispatch enter and leave events for GlobalVariableOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#542
  def visit_global_variable_operator_write_node(node); end

  # Dispatch enter and leave events for GlobalVariableOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#550
  def visit_global_variable_or_write_node(node); end

  # Dispatch enter and leave events for GlobalVariableReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#558
  def visit_global_variable_read_node(node); end

  # Dispatch enter and leave events for GlobalVariableTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#566
  def visit_global_variable_target_node(node); end

  # Dispatch enter and leave events for GlobalVariableWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#574
  def visit_global_variable_write_node(node); end

  # Dispatch enter and leave events for HashNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#582
  def visit_hash_node(node); end

  # Dispatch enter and leave events for HashPatternNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#590
  def visit_hash_pattern_node(node); end

  # Dispatch enter and leave events for IfNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#598
  def visit_if_node(node); end

  # Dispatch enter and leave events for ImaginaryNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#606
  def visit_imaginary_node(node); end

  # Dispatch enter and leave events for ImplicitNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#614
  def visit_implicit_node(node); end

  # Dispatch enter and leave events for ImplicitRestNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#622
  def visit_implicit_rest_node(node); end

  # Dispatch enter and leave events for InNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#630
  def visit_in_node(node); end

  # Dispatch enter and leave events for IndexAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#638
  def visit_index_and_write_node(node); end

  # Dispatch enter and leave events for IndexOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#646
  def visit_index_operator_write_node(node); end

  # Dispatch enter and leave events for IndexOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#654
  def visit_index_or_write_node(node); end

  # Dispatch enter and leave events for IndexTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#662
  def visit_index_target_node(node); end

  # Dispatch enter and leave events for InstanceVariableAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#670
  def visit_instance_variable_and_write_node(node); end

  # Dispatch enter and leave events for InstanceVariableOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#678
  def visit_instance_variable_operator_write_node(node); end

  # Dispatch enter and leave events for InstanceVariableOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#686
  def visit_instance_variable_or_write_node(node); end

  # Dispatch enter and leave events for InstanceVariableReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#694
  def visit_instance_variable_read_node(node); end

  # Dispatch enter and leave events for InstanceVariableTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#702
  def visit_instance_variable_target_node(node); end

  # Dispatch enter and leave events for InstanceVariableWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#710
  def visit_instance_variable_write_node(node); end

  # Dispatch enter and leave events for IntegerNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#718
  def visit_integer_node(node); end

  # Dispatch enter and leave events for InterpolatedMatchLastLineNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#726
  def visit_interpolated_match_last_line_node(node); end

  # Dispatch enter and leave events for InterpolatedRegularExpressionNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#734
  def visit_interpolated_regular_expression_node(node); end

  # Dispatch enter and leave events for InterpolatedStringNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#742
  def visit_interpolated_string_node(node); end

  # Dispatch enter and leave events for InterpolatedSymbolNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#750
  def visit_interpolated_symbol_node(node); end

  # Dispatch enter and leave events for InterpolatedXStringNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#758
  def visit_interpolated_x_string_node(node); end

  # Dispatch enter and leave events for KeywordHashNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#766
  def visit_keyword_hash_node(node); end

  # Dispatch enter and leave events for KeywordRestParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#774
  def visit_keyword_rest_parameter_node(node); end

  # Dispatch enter and leave events for LambdaNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#782
  def visit_lambda_node(node); end

  # Dispatch enter and leave events for LocalVariableAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#790
  def visit_local_variable_and_write_node(node); end

  # Dispatch enter and leave events for LocalVariableOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#798
  def visit_local_variable_operator_write_node(node); end

  # Dispatch enter and leave events for LocalVariableOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#806
  def visit_local_variable_or_write_node(node); end

  # Dispatch enter and leave events for LocalVariableReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#814
  def visit_local_variable_read_node(node); end

  # Dispatch enter and leave events for LocalVariableTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#822
  def visit_local_variable_target_node(node); end

  # Dispatch enter and leave events for LocalVariableWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#830
  def visit_local_variable_write_node(node); end

  # Dispatch enter and leave events for MatchLastLineNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#838
  def visit_match_last_line_node(node); end

  # Dispatch enter and leave events for MatchPredicateNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#846
  def visit_match_predicate_node(node); end

  # Dispatch enter and leave events for MatchRequiredNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#854
  def visit_match_required_node(node); end

  # Dispatch enter and leave events for MatchWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#862
  def visit_match_write_node(node); end

  # Dispatch enter and leave events for MissingNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#870
  def visit_missing_node(node); end

  # Dispatch enter and leave events for ModuleNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#878
  def visit_module_node(node); end

  # Dispatch enter and leave events for MultiTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#886
  def visit_multi_target_node(node); end

  # Dispatch enter and leave events for MultiWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#894
  def visit_multi_write_node(node); end

  # Dispatch enter and leave events for NextNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#902
  def visit_next_node(node); end

  # Dispatch enter and leave events for NilNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#910
  def visit_nil_node(node); end

  # Dispatch enter and leave events for NoKeywordsParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#918
  def visit_no_keywords_parameter_node(node); end

  # Dispatch enter and leave events for NumberedParametersNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#926
  def visit_numbered_parameters_node(node); end

  # Dispatch enter and leave events for NumberedReferenceReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#934
  def visit_numbered_reference_read_node(node); end

  # Dispatch enter and leave events for OptionalKeywordParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#942
  def visit_optional_keyword_parameter_node(node); end

  # Dispatch enter and leave events for OptionalParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#950
  def visit_optional_parameter_node(node); end

  # Dispatch enter and leave events for OrNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#958
  def visit_or_node(node); end

  # Dispatch enter and leave events for ParametersNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#966
  def visit_parameters_node(node); end

  # Dispatch enter and leave events for ParenthesesNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#974
  def visit_parentheses_node(node); end

  # Dispatch enter and leave events for PinnedExpressionNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#982
  def visit_pinned_expression_node(node); end

  # Dispatch enter and leave events for PinnedVariableNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#990
  def visit_pinned_variable_node(node); end

  # Dispatch enter and leave events for PostExecutionNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#998
  def visit_post_execution_node(node); end

  # Dispatch enter and leave events for PreExecutionNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1006
  def visit_pre_execution_node(node); end

  # Dispatch enter and leave events for ProgramNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1014
  def visit_program_node(node); end

  # Dispatch enter and leave events for RangeNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1022
  def visit_range_node(node); end

  # Dispatch enter and leave events for RationalNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1030
  def visit_rational_node(node); end

  # Dispatch enter and leave events for RedoNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1038
  def visit_redo_node(node); end

  # Dispatch enter and leave events for RegularExpressionNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1046
  def visit_regular_expression_node(node); end

  # Dispatch enter and leave events for RequiredKeywordParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1054
  def visit_required_keyword_parameter_node(node); end

  # Dispatch enter and leave events for RequiredParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1062
  def visit_required_parameter_node(node); end

  # Dispatch enter and leave events for RescueModifierNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1070
  def visit_rescue_modifier_node(node); end

  # Dispatch enter and leave events for RescueNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1078
  def visit_rescue_node(node); end

  # Dispatch enter and leave events for RestParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1086
  def visit_rest_parameter_node(node); end

  # Dispatch enter and leave events for RetryNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1094
  def visit_retry_node(node); end

  # Dispatch enter and leave events for ReturnNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1102
  def visit_return_node(node); end

  # Dispatch enter and leave events for SelfNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1110
  def visit_self_node(node); end

  # Dispatch enter and leave events for SingletonClassNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1118
  def visit_singleton_class_node(node); end

  # Dispatch enter and leave events for SourceEncodingNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1126
  def visit_source_encoding_node(node); end

  # Dispatch enter and leave events for SourceFileNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1134
  def visit_source_file_node(node); end

  # Dispatch enter and leave events for SourceLineNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1142
  def visit_source_line_node(node); end

  # Dispatch enter and leave events for SplatNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1150
  def visit_splat_node(node); end

  # Dispatch enter and leave events for StatementsNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1158
  def visit_statements_node(node); end

  # Dispatch enter and leave events for StringNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1166
  def visit_string_node(node); end

  # Dispatch enter and leave events for SuperNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1174
  def visit_super_node(node); end

  # Dispatch enter and leave events for SymbolNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1182
  def visit_symbol_node(node); end

  # Dispatch enter and leave events for TrueNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1190
  def visit_true_node(node); end

  # Dispatch enter and leave events for UndefNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1198
  def visit_undef_node(node); end

  # Dispatch enter and leave events for UnlessNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1206
  def visit_unless_node(node); end

  # Dispatch enter and leave events for UntilNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1214
  def visit_until_node(node); end

  # Dispatch enter and leave events for WhenNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1222
  def visit_when_node(node); end

  # Dispatch enter and leave events for WhileNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1230
  def visit_while_node(node); end

  # Dispatch enter and leave events for XStringNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1238
  def visit_x_string_node(node); end

  # Dispatch enter and leave events for YieldNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1246
  def visit_yield_node(node); end
end

# source://prism//lib/prism/dispatcher.rb#1252
class Prism::Dispatcher::DispatchOnce < ::Prism::Visitor
  # @return [DispatchOnce] a new instance of DispatchOnce
  #
  # source://prism//lib/prism/dispatcher.rb#1255
  def initialize(listeners); end

  # Returns the value of attribute listeners.
  #
  # source://prism//lib/prism/dispatcher.rb#1253
  def listeners; end

  # Dispatch enter and leave events for AliasGlobalVariableNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1260
  def visit_alias_global_variable_node(node); end

  # Dispatch enter and leave events for AliasMethodNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1266
  def visit_alias_method_node(node); end

  # Dispatch enter and leave events for AlternationPatternNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1272
  def visit_alternation_pattern_node(node); end

  # Dispatch enter and leave events for AndNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1278
  def visit_and_node(node); end

  # Dispatch enter and leave events for ArgumentsNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1284
  def visit_arguments_node(node); end

  # Dispatch enter and leave events for ArrayNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1290
  def visit_array_node(node); end

  # Dispatch enter and leave events for ArrayPatternNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1296
  def visit_array_pattern_node(node); end

  # Dispatch enter and leave events for AssocNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1302
  def visit_assoc_node(node); end

  # Dispatch enter and leave events for AssocSplatNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1308
  def visit_assoc_splat_node(node); end

  # Dispatch enter and leave events for BackReferenceReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1314
  def visit_back_reference_read_node(node); end

  # Dispatch enter and leave events for BeginNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1320
  def visit_begin_node(node); end

  # Dispatch enter and leave events for BlockArgumentNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1326
  def visit_block_argument_node(node); end

  # Dispatch enter and leave events for BlockLocalVariableNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1332
  def visit_block_local_variable_node(node); end

  # Dispatch enter and leave events for BlockNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1338
  def visit_block_node(node); end

  # Dispatch enter and leave events for BlockParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1344
  def visit_block_parameter_node(node); end

  # Dispatch enter and leave events for BlockParametersNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1350
  def visit_block_parameters_node(node); end

  # Dispatch enter and leave events for BreakNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1356
  def visit_break_node(node); end

  # Dispatch enter and leave events for CallAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1362
  def visit_call_and_write_node(node); end

  # Dispatch enter and leave events for CallNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1368
  def visit_call_node(node); end

  # Dispatch enter and leave events for CallOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1374
  def visit_call_operator_write_node(node); end

  # Dispatch enter and leave events for CallOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1380
  def visit_call_or_write_node(node); end

  # Dispatch enter and leave events for CallTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1386
  def visit_call_target_node(node); end

  # Dispatch enter and leave events for CapturePatternNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1392
  def visit_capture_pattern_node(node); end

  # Dispatch enter and leave events for CaseMatchNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1398
  def visit_case_match_node(node); end

  # Dispatch enter and leave events for CaseNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1404
  def visit_case_node(node); end

  # Dispatch enter and leave events for ClassNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1410
  def visit_class_node(node); end

  # Dispatch enter and leave events for ClassVariableAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1416
  def visit_class_variable_and_write_node(node); end

  # Dispatch enter and leave events for ClassVariableOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1422
  def visit_class_variable_operator_write_node(node); end

  # Dispatch enter and leave events for ClassVariableOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1428
  def visit_class_variable_or_write_node(node); end

  # Dispatch enter and leave events for ClassVariableReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1434
  def visit_class_variable_read_node(node); end

  # Dispatch enter and leave events for ClassVariableTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1440
  def visit_class_variable_target_node(node); end

  # Dispatch enter and leave events for ClassVariableWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1446
  def visit_class_variable_write_node(node); end

  # Dispatch enter and leave events for ConstantAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1452
  def visit_constant_and_write_node(node); end

  # Dispatch enter and leave events for ConstantOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1458
  def visit_constant_operator_write_node(node); end

  # Dispatch enter and leave events for ConstantOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1464
  def visit_constant_or_write_node(node); end

  # Dispatch enter and leave events for ConstantPathAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1470
  def visit_constant_path_and_write_node(node); end

  # Dispatch enter and leave events for ConstantPathNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1476
  def visit_constant_path_node(node); end

  # Dispatch enter and leave events for ConstantPathOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1482
  def visit_constant_path_operator_write_node(node); end

  # Dispatch enter and leave events for ConstantPathOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1488
  def visit_constant_path_or_write_node(node); end

  # Dispatch enter and leave events for ConstantPathTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1494
  def visit_constant_path_target_node(node); end

  # Dispatch enter and leave events for ConstantPathWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1500
  def visit_constant_path_write_node(node); end

  # Dispatch enter and leave events for ConstantReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1506
  def visit_constant_read_node(node); end

  # Dispatch enter and leave events for ConstantTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1512
  def visit_constant_target_node(node); end

  # Dispatch enter and leave events for ConstantWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1518
  def visit_constant_write_node(node); end

  # Dispatch enter and leave events for DefNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1524
  def visit_def_node(node); end

  # Dispatch enter and leave events for DefinedNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1530
  def visit_defined_node(node); end

  # Dispatch enter and leave events for ElseNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1536
  def visit_else_node(node); end

  # Dispatch enter and leave events for EmbeddedStatementsNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1542
  def visit_embedded_statements_node(node); end

  # Dispatch enter and leave events for EmbeddedVariableNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1548
  def visit_embedded_variable_node(node); end

  # Dispatch enter and leave events for EnsureNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1554
  def visit_ensure_node(node); end

  # Dispatch enter and leave events for FalseNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1560
  def visit_false_node(node); end

  # Dispatch enter and leave events for FindPatternNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1566
  def visit_find_pattern_node(node); end

  # Dispatch enter and leave events for FlipFlopNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1572
  def visit_flip_flop_node(node); end

  # Dispatch enter and leave events for FloatNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1578
  def visit_float_node(node); end

  # Dispatch enter and leave events for ForNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1584
  def visit_for_node(node); end

  # Dispatch enter and leave events for ForwardingArgumentsNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1590
  def visit_forwarding_arguments_node(node); end

  # Dispatch enter and leave events for ForwardingParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1596
  def visit_forwarding_parameter_node(node); end

  # Dispatch enter and leave events for ForwardingSuperNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1602
  def visit_forwarding_super_node(node); end

  # Dispatch enter and leave events for GlobalVariableAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1608
  def visit_global_variable_and_write_node(node); end

  # Dispatch enter and leave events for GlobalVariableOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1614
  def visit_global_variable_operator_write_node(node); end

  # Dispatch enter and leave events for GlobalVariableOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1620
  def visit_global_variable_or_write_node(node); end

  # Dispatch enter and leave events for GlobalVariableReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1626
  def visit_global_variable_read_node(node); end

  # Dispatch enter and leave events for GlobalVariableTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1632
  def visit_global_variable_target_node(node); end

  # Dispatch enter and leave events for GlobalVariableWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1638
  def visit_global_variable_write_node(node); end

  # Dispatch enter and leave events for HashNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1644
  def visit_hash_node(node); end

  # Dispatch enter and leave events for HashPatternNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1650
  def visit_hash_pattern_node(node); end

  # Dispatch enter and leave events for IfNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1656
  def visit_if_node(node); end

  # Dispatch enter and leave events for ImaginaryNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1662
  def visit_imaginary_node(node); end

  # Dispatch enter and leave events for ImplicitNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1668
  def visit_implicit_node(node); end

  # Dispatch enter and leave events for ImplicitRestNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1674
  def visit_implicit_rest_node(node); end

  # Dispatch enter and leave events for InNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1680
  def visit_in_node(node); end

  # Dispatch enter and leave events for IndexAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1686
  def visit_index_and_write_node(node); end

  # Dispatch enter and leave events for IndexOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1692
  def visit_index_operator_write_node(node); end

  # Dispatch enter and leave events for IndexOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1698
  def visit_index_or_write_node(node); end

  # Dispatch enter and leave events for IndexTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1704
  def visit_index_target_node(node); end

  # Dispatch enter and leave events for InstanceVariableAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1710
  def visit_instance_variable_and_write_node(node); end

  # Dispatch enter and leave events for InstanceVariableOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1716
  def visit_instance_variable_operator_write_node(node); end

  # Dispatch enter and leave events for InstanceVariableOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1722
  def visit_instance_variable_or_write_node(node); end

  # Dispatch enter and leave events for InstanceVariableReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1728
  def visit_instance_variable_read_node(node); end

  # Dispatch enter and leave events for InstanceVariableTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1734
  def visit_instance_variable_target_node(node); end

  # Dispatch enter and leave events for InstanceVariableWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1740
  def visit_instance_variable_write_node(node); end

  # Dispatch enter and leave events for IntegerNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1746
  def visit_integer_node(node); end

  # Dispatch enter and leave events for InterpolatedMatchLastLineNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1752
  def visit_interpolated_match_last_line_node(node); end

  # Dispatch enter and leave events for InterpolatedRegularExpressionNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1758
  def visit_interpolated_regular_expression_node(node); end

  # Dispatch enter and leave events for InterpolatedStringNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1764
  def visit_interpolated_string_node(node); end

  # Dispatch enter and leave events for InterpolatedSymbolNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1770
  def visit_interpolated_symbol_node(node); end

  # Dispatch enter and leave events for InterpolatedXStringNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1776
  def visit_interpolated_x_string_node(node); end

  # Dispatch enter and leave events for KeywordHashNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1782
  def visit_keyword_hash_node(node); end

  # Dispatch enter and leave events for KeywordRestParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1788
  def visit_keyword_rest_parameter_node(node); end

  # Dispatch enter and leave events for LambdaNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1794
  def visit_lambda_node(node); end

  # Dispatch enter and leave events for LocalVariableAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1800
  def visit_local_variable_and_write_node(node); end

  # Dispatch enter and leave events for LocalVariableOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1806
  def visit_local_variable_operator_write_node(node); end

  # Dispatch enter and leave events for LocalVariableOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1812
  def visit_local_variable_or_write_node(node); end

  # Dispatch enter and leave events for LocalVariableReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1818
  def visit_local_variable_read_node(node); end

  # Dispatch enter and leave events for LocalVariableTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1824
  def visit_local_variable_target_node(node); end

  # Dispatch enter and leave events for LocalVariableWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1830
  def visit_local_variable_write_node(node); end

  # Dispatch enter and leave events for MatchLastLineNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1836
  def visit_match_last_line_node(node); end

  # Dispatch enter and leave events for MatchPredicateNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1842
  def visit_match_predicate_node(node); end

  # Dispatch enter and leave events for MatchRequiredNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1848
  def visit_match_required_node(node); end

  # Dispatch enter and leave events for MatchWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1854
  def visit_match_write_node(node); end

  # Dispatch enter and leave events for MissingNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1860
  def visit_missing_node(node); end

  # Dispatch enter and leave events for ModuleNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1866
  def visit_module_node(node); end

  # Dispatch enter and leave events for MultiTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1872
  def visit_multi_target_node(node); end

  # Dispatch enter and leave events for MultiWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1878
  def visit_multi_write_node(node); end

  # Dispatch enter and leave events for NextNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1884
  def visit_next_node(node); end

  # Dispatch enter and leave events for NilNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1890
  def visit_nil_node(node); end

  # Dispatch enter and leave events for NoKeywordsParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1896
  def visit_no_keywords_parameter_node(node); end

  # Dispatch enter and leave events for NumberedParametersNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1902
  def visit_numbered_parameters_node(node); end

  # Dispatch enter and leave events for NumberedReferenceReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1908
  def visit_numbered_reference_read_node(node); end

  # Dispatch enter and leave events for OptionalKeywordParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1914
  def visit_optional_keyword_parameter_node(node); end

  # Dispatch enter and leave events for OptionalParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1920
  def visit_optional_parameter_node(node); end

  # Dispatch enter and leave events for OrNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1926
  def visit_or_node(node); end

  # Dispatch enter and leave events for ParametersNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1932
  def visit_parameters_node(node); end

  # Dispatch enter and leave events for ParenthesesNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1938
  def visit_parentheses_node(node); end

  # Dispatch enter and leave events for PinnedExpressionNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1944
  def visit_pinned_expression_node(node); end

  # Dispatch enter and leave events for PinnedVariableNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1950
  def visit_pinned_variable_node(node); end

  # Dispatch enter and leave events for PostExecutionNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1956
  def visit_post_execution_node(node); end

  # Dispatch enter and leave events for PreExecutionNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1962
  def visit_pre_execution_node(node); end

  # Dispatch enter and leave events for ProgramNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1968
  def visit_program_node(node); end

  # Dispatch enter and leave events for RangeNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1974
  def visit_range_node(node); end

  # Dispatch enter and leave events for RationalNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1980
  def visit_rational_node(node); end

  # Dispatch enter and leave events for RedoNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1986
  def visit_redo_node(node); end

  # Dispatch enter and leave events for RegularExpressionNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1992
  def visit_regular_expression_node(node); end

  # Dispatch enter and leave events for RequiredKeywordParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1998
  def visit_required_keyword_parameter_node(node); end

  # Dispatch enter and leave events for RequiredParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2004
  def visit_required_parameter_node(node); end

  # Dispatch enter and leave events for RescueModifierNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2010
  def visit_rescue_modifier_node(node); end

  # Dispatch enter and leave events for RescueNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2016
  def visit_rescue_node(node); end

  # Dispatch enter and leave events for RestParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2022
  def visit_rest_parameter_node(node); end

  # Dispatch enter and leave events for RetryNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2028
  def visit_retry_node(node); end

  # Dispatch enter and leave events for ReturnNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2034
  def visit_return_node(node); end

  # Dispatch enter and leave events for SelfNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2040
  def visit_self_node(node); end

  # Dispatch enter and leave events for SingletonClassNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2046
  def visit_singleton_class_node(node); end

  # Dispatch enter and leave events for SourceEncodingNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2052
  def visit_source_encoding_node(node); end

  # Dispatch enter and leave events for SourceFileNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2058
  def visit_source_file_node(node); end

  # Dispatch enter and leave events for SourceLineNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2064
  def visit_source_line_node(node); end

  # Dispatch enter and leave events for SplatNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2070
  def visit_splat_node(node); end

  # Dispatch enter and leave events for StatementsNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2076
  def visit_statements_node(node); end

  # Dispatch enter and leave events for StringNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2082
  def visit_string_node(node); end

  # Dispatch enter and leave events for SuperNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2088
  def visit_super_node(node); end

  # Dispatch enter and leave events for SymbolNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2094
  def visit_symbol_node(node); end

  # Dispatch enter and leave events for TrueNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2100
  def visit_true_node(node); end

  # Dispatch enter and leave events for UndefNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2106
  def visit_undef_node(node); end

  # Dispatch enter and leave events for UnlessNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2112
  def visit_unless_node(node); end

  # Dispatch enter and leave events for UntilNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2118
  def visit_until_node(node); end

  # Dispatch enter and leave events for WhenNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2124
  def visit_when_node(node); end

  # Dispatch enter and leave events for WhileNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2130
  def visit_while_node(node); end

  # Dispatch enter and leave events for XStringNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2136
  def visit_x_string_node(node); end

  # Dispatch enter and leave events for YieldNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2142
  def visit_yield_node(node); end
end

# This visitor provides the ability to call Node#to_dot, which converts a
# subtree into a graphviz dot graph.
#
# source://prism//lib/prism/dot_visitor.rb#13
class Prism::DotVisitor < ::Prism::Visitor
  # Initialize a new dot visitor.
  #
  # @return [DotVisitor] a new instance of DotVisitor
  #
  # source://prism//lib/prism/dot_visitor.rb#105
  def initialize; end

  # The digraph that is being built.
  #
  # source://prism//lib/prism/dot_visitor.rb#102
  def digraph; end

  # Convert this visitor into a graphviz dot graph string.
  #
  # source://prism//lib/prism/dot_visitor.rb#110
  def to_dot; end

  # Visit a AliasGlobalVariableNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#115
  def visit_alias_global_variable_node(node); end

  # Visit a AliasMethodNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#140
  def visit_alias_method_node(node); end

  # Visit a AlternationPatternNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#165
  def visit_alternation_pattern_node(node); end

  # Visit a AndNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#190
  def visit_and_node(node); end

  # Visit a ArgumentsNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#215
  def visit_arguments_node(node); end

  # Visit a ArrayNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#245
  def visit_array_node(node); end

  # Visit a ArrayPatternNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#285
  def visit_array_pattern_node(node); end

  # Visit a AssocNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#347
  def visit_assoc_node(node); end

  # Visit a AssocSplatNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#376
  def visit_assoc_splat_node(node); end

  # Visit a BackReferenceReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#399
  def visit_back_reference_read_node(node); end

  # Visit a BeginNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#416
  def visit_begin_node(node); end

  # Visit a BlockArgumentNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#464
  def visit_block_argument_node(node); end

  # Visit a BlockLocalVariableNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#487
  def visit_block_local_variable_node(node); end

  # Visit a BlockNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#504
  def visit_block_node(node); end

  # Visit a BlockParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#542
  def visit_block_parameter_node(node); end

  # Visit a BlockParametersNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#567
  def visit_block_parameters_node(node); end

  # Visit a BreakNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#610
  def visit_break_node(node); end

  # Visit a CallAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#633
  def visit_call_and_write_node(node); end

  # Visit a CallNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#679
  def visit_call_node(node); end

  # Visit a CallOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#737
  def visit_call_operator_write_node(node); end

  # Visit a CallOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#786
  def visit_call_or_write_node(node); end

  # Visit a CallTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#832
  def visit_call_target_node(node); end

  # Visit a CapturePatternNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#862
  def visit_capture_pattern_node(node); end

  # Visit a CaseMatchNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#887
  def visit_case_match_node(node); end

  # Visit a CaseNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#932
  def visit_case_node(node); end

  # Visit a ClassNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#977
  def visit_class_node(node); end

  # Visit a ClassVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1024
  def visit_class_variable_and_write_node(node); end

  # Visit a ClassVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1051
  def visit_class_variable_operator_write_node(node); end

  # Visit a ClassVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1081
  def visit_class_variable_or_write_node(node); end

  # Visit a ClassVariableReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1108
  def visit_class_variable_read_node(node); end

  # Visit a ClassVariableTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1125
  def visit_class_variable_target_node(node); end

  # Visit a ClassVariableWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1142
  def visit_class_variable_write_node(node); end

  # Visit a ConstantAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1171
  def visit_constant_and_write_node(node); end

  # Visit a ConstantOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1198
  def visit_constant_operator_write_node(node); end

  # Visit a ConstantOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1228
  def visit_constant_or_write_node(node); end

  # Visit a ConstantPathAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1255
  def visit_constant_path_and_write_node(node); end

  # Visit a ConstantPathNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1280
  def visit_constant_path_node(node); end

  # Visit a ConstantPathOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1307
  def visit_constant_path_operator_write_node(node); end

  # Visit a ConstantPathOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1335
  def visit_constant_path_or_write_node(node); end

  # Visit a ConstantPathTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1360
  def visit_constant_path_target_node(node); end

  # Visit a ConstantPathWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1387
  def visit_constant_path_write_node(node); end

  # Visit a ConstantReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1412
  def visit_constant_read_node(node); end

  # Visit a ConstantTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1429
  def visit_constant_target_node(node); end

  # Visit a ConstantWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1446
  def visit_constant_write_node(node); end

  # Visit a DefNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1473
  def visit_def_node(node); end

  # Visit a DefinedNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1545
  def visit_defined_node(node); end

  # Visit a ElseNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1576
  def visit_else_node(node); end

  # Visit a EmbeddedStatementsNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1604
  def visit_embedded_statements_node(node); end

  # Visit a EmbeddedVariableNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1630
  def visit_embedded_variable_node(node); end

  # Visit a EnsureNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1651
  def visit_ensure_node(node); end

  # Visit a FalseNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1677
  def visit_false_node(node); end

  # Visit a FindPatternNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1691
  def visit_find_pattern_node(node); end

  # Visit a FlipFlopNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1742
  def visit_flip_flop_node(node); end

  # Visit a FloatNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1774
  def visit_float_node(node); end

  # Visit a ForNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1788
  def visit_for_node(node); end

  # Visit a ForwardingArgumentsNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1830
  def visit_forwarding_arguments_node(node); end

  # Visit a ForwardingParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1844
  def visit_forwarding_parameter_node(node); end

  # Visit a ForwardingSuperNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1858
  def visit_forwarding_super_node(node); end

  # Visit a GlobalVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1878
  def visit_global_variable_and_write_node(node); end

  # Visit a GlobalVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1905
  def visit_global_variable_operator_write_node(node); end

  # Visit a GlobalVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1935
  def visit_global_variable_or_write_node(node); end

  # Visit a GlobalVariableReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1962
  def visit_global_variable_read_node(node); end

  # Visit a GlobalVariableTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1979
  def visit_global_variable_target_node(node); end

  # Visit a GlobalVariableWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1996
  def visit_global_variable_write_node(node); end

  # Visit a HashNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2023
  def visit_hash_node(node); end

  # Visit a HashPatternNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2056
  def visit_hash_pattern_node(node); end

  # Visit a IfNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2105
  def visit_if_node(node); end

  # Visit a ImaginaryNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2150
  def visit_imaginary_node(node); end

  # Visit a ImplicitNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2168
  def visit_implicit_node(node); end

  # Visit a ImplicitRestNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2186
  def visit_implicit_rest_node(node); end

  # Visit a InNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2200
  def visit_in_node(node); end

  # Visit a IndexAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2232
  def visit_index_and_write_node(node); end

  # Visit a IndexOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2285
  def visit_index_operator_write_node(node); end

  # Visit a IndexOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2341
  def visit_index_or_write_node(node); end

  # Visit a IndexTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2394
  def visit_index_target_node(node); end

  # Visit a InstanceVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2433
  def visit_instance_variable_and_write_node(node); end

  # Visit a InstanceVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2460
  def visit_instance_variable_operator_write_node(node); end

  # Visit a InstanceVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2490
  def visit_instance_variable_or_write_node(node); end

  # Visit a InstanceVariableReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2517
  def visit_instance_variable_read_node(node); end

  # Visit a InstanceVariableTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2534
  def visit_instance_variable_target_node(node); end

  # Visit a InstanceVariableWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2551
  def visit_instance_variable_write_node(node); end

  # Visit a IntegerNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2578
  def visit_integer_node(node); end

  # Visit a InterpolatedMatchLastLineNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2595
  def visit_interpolated_match_last_line_node(node); end

  # Visit a InterpolatedRegularExpressionNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2631
  def visit_interpolated_regular_expression_node(node); end

  # Visit a InterpolatedStringNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2667
  def visit_interpolated_string_node(node); end

  # Visit a InterpolatedSymbolNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2704
  def visit_interpolated_symbol_node(node); end

  # Visit a InterpolatedXStringNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2741
  def visit_interpolated_x_string_node(node); end

  # Visit a KeywordHashNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2774
  def visit_keyword_hash_node(node); end

  # Visit a KeywordRestParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2804
  def visit_keyword_rest_parameter_node(node); end

  # Visit a LambdaNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2829
  def visit_lambda_node(node); end

  # Visit a LocalVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2870
  def visit_local_variable_and_write_node(node); end

  # Visit a LocalVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2900
  def visit_local_variable_operator_write_node(node); end

  # Visit a LocalVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2933
  def visit_local_variable_or_write_node(node); end

  # Visit a LocalVariableReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2963
  def visit_local_variable_read_node(node); end

  # Visit a LocalVariableTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2983
  def visit_local_variable_target_node(node); end

  # Visit a LocalVariableWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3003
  def visit_local_variable_write_node(node); end

  # Visit a MatchLastLineNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3033
  def visit_match_last_line_node(node); end

  # Visit a MatchPredicateNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3062
  def visit_match_predicate_node(node); end

  # Visit a MatchRequiredNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3087
  def visit_match_required_node(node); end

  # Visit a MatchWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3112
  def visit_match_write_node(node); end

  # Visit a MissingNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3143
  def visit_missing_node(node); end

  # Visit a ModuleNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3157
  def visit_module_node(node); end

  # Visit a MultiTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3193
  def visit_multi_target_node(node); end

  # Visit a MultiWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3249
  def visit_multi_write_node(node); end

  # Visit a NextNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3312
  def visit_next_node(node); end

  # Visit a NilNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3335
  def visit_nil_node(node); end

  # Visit a NoKeywordsParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3349
  def visit_no_keywords_parameter_node(node); end

  # Visit a NumberedParametersNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3369
  def visit_numbered_parameters_node(node); end

  # Visit a NumberedReferenceReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3386
  def visit_numbered_reference_read_node(node); end

  # Visit a OptionalKeywordParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3403
  def visit_optional_keyword_parameter_node(node); end

  # Visit a OptionalParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3427
  def visit_optional_parameter_node(node); end

  # Visit a OrNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3454
  def visit_or_node(node); end

  # Visit a ParametersNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3479
  def visit_parameters_node(node); end

  # Visit a ParenthesesNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3563
  def visit_parentheses_node(node); end

  # Visit a PinnedExpressionNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3589
  def visit_pinned_expression_node(node); end

  # Visit a PinnedVariableNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3616
  def visit_pinned_variable_node(node); end

  # Visit a PostExecutionNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3637
  def visit_post_execution_node(node); end

  # Visit a PreExecutionNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3666
  def visit_pre_execution_node(node); end

  # Visit a ProgramNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3695
  def visit_program_node(node); end

  # Visit a RangeNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3716
  def visit_range_node(node); end

  # Visit a RationalNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3748
  def visit_rational_node(node); end

  # Visit a RedoNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3766
  def visit_redo_node(node); end

  # Visit a RegularExpressionNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3780
  def visit_regular_expression_node(node); end

  # Visit a RequiredKeywordParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3809
  def visit_required_keyword_parameter_node(node); end

  # Visit a RequiredParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3829
  def visit_required_parameter_node(node); end

  # Visit a RescueModifierNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3846
  def visit_rescue_modifier_node(node); end

  # Visit a RescueNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3871
  def visit_rescue_node(node); end

  # Visit a RestParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3924
  def visit_rest_parameter_node(node); end

  # Visit a RetryNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3949
  def visit_retry_node(node); end

  # Visit a ReturnNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3963
  def visit_return_node(node); end

  # Visit a SelfNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3986
  def visit_self_node(node); end

  # Visit a SingletonClassNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4000
  def visit_singleton_class_node(node); end

  # Visit a SourceEncodingNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4036
  def visit_source_encoding_node(node); end

  # Visit a SourceFileNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4050
  def visit_source_file_node(node); end

  # Visit a SourceLineNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4067
  def visit_source_line_node(node); end

  # Visit a SplatNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4081
  def visit_splat_node(node); end

  # Visit a StatementsNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4104
  def visit_statements_node(node); end

  # Visit a StringNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4131
  def visit_string_node(node); end

  # Visit a SuperNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4164
  def visit_super_node(node); end

  # Visit a SymbolNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4203
  def visit_symbol_node(node); end

  # Visit a TrueNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4238
  def visit_true_node(node); end

  # Visit a UndefNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4252
  def visit_undef_node(node); end

  # Visit a UnlessNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4282
  def visit_unless_node(node); end

  # Visit a UntilNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4325
  def visit_until_node(node); end

  # Visit a WhenNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4360
  def visit_when_node(node); end

  # Visit a WhileNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4396
  def visit_while_node(node); end

  # Visit a XStringNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4431
  def visit_x_string_node(node); end

  # Visit a YieldNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4460
  def visit_yield_node(node); end

  private

  # Inspect a node that has arguments_node_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4506
  def arguments_node_flags_inspect(node); end

  # Inspect a node that has array_node_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4514
  def array_node_flags_inspect(node); end

  # Inspect a node that has call_node_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4522
  def call_node_flags_inspect(node); end

  # Inspect a node that has encoding_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4532
  def encoding_flags_inspect(node); end

  # Inspect a node that has integer_base_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4541
  def integer_base_flags_inspect(node); end

  # Inspect a node that has keyword_hash_node_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4552
  def keyword_hash_node_flags_inspect(node); end

  # Inspect a location to display the start and end line and column numbers.
  #
  # source://prism//lib/prism/dot_visitor.rb#4500
  def location_inspect(location); end

  # Inspect a node that has loop_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4560
  def loop_flags_inspect(node); end

  # Generate a unique node ID for a node throughout the digraph.
  #
  # source://prism//lib/prism/dot_visitor.rb#4495
  def node_id(node); end

  # Inspect a node that has range_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4568
  def range_flags_inspect(node); end

  # Inspect a node that has regular_expression_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4576
  def regular_expression_flags_inspect(node); end

  # Inspect a node that has string_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4594
  def string_flags_inspect(node); end

  # Inspect a node that has symbol_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4604
  def symbol_flags_inspect(node); end
end

# source://prism//lib/prism/dot_visitor.rb#58
class Prism::DotVisitor::Digraph
  # @return [Digraph] a new instance of Digraph
  #
  # source://prism//lib/prism/dot_visitor.rb#61
  def initialize; end

  # source://prism//lib/prism/dot_visitor.rb#75
  def edge(value); end

  # Returns the value of attribute edges.
  #
  # source://prism//lib/prism/dot_visitor.rb#59
  def edges; end

  # source://prism//lib/prism/dot_visitor.rb#67
  def node(value); end

  # Returns the value of attribute nodes.
  #
  # source://prism//lib/prism/dot_visitor.rb#59
  def nodes; end

  # source://prism//lib/prism/dot_visitor.rb#79
  def to_dot; end

  # source://prism//lib/prism/dot_visitor.rb#71
  def waypoint(value); end

  # Returns the value of attribute waypoints.
  #
  # source://prism//lib/prism/dot_visitor.rb#59
  def waypoints; end
end

# source://prism//lib/prism/dot_visitor.rb#14
class Prism::DotVisitor::Field
  # @return [Field] a new instance of Field
  #
  # source://prism//lib/prism/dot_visitor.rb#17
  def initialize(name, value, port); end

  # Returns the value of attribute name.
  #
  # source://prism//lib/prism/dot_visitor.rb#15
  def name; end

  # Returns the value of attribute port.
  #
  # source://prism//lib/prism/dot_visitor.rb#15
  def port; end

  # source://prism//lib/prism/dot_visitor.rb#23
  def to_dot; end

  # Returns the value of attribute value.
  #
  # source://prism//lib/prism/dot_visitor.rb#15
  def value; end
end

# source://prism//lib/prism/dot_visitor.rb#32
class Prism::DotVisitor::Table
  # @return [Table] a new instance of Table
  #
  # source://prism//lib/prism/dot_visitor.rb#35
  def initialize(name); end

  # source://prism//lib/prism/dot_visitor.rb#40
  def field(name, value = T.unsafe(nil), port: T.unsafe(nil)); end

  # Returns the value of attribute fields.
  #
  # source://prism//lib/prism/dot_visitor.rb#33
  def fields; end

  # Returns the value of attribute name.
  #
  # source://prism//lib/prism/dot_visitor.rb#33
  def name; end

  # source://prism//lib/prism/dot_visitor.rb#44
  def to_dot; end
end

# Represents an `else` clause in a `case`, `if`, or `unless` statement.
#
#     if a then b else c end
#                 ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#5565
class Prism::ElseNode < ::Prism::Node
  # def initialize: (else_keyword_loc: Location, statements: StatementsNode?, end_keyword_loc: Location?, location: Location) -> void
  #
  # @return [ElseNode] a new instance of ElseNode
  #
  # source://prism//lib/prism/node.rb#5575
  sig do
    params(
      else_keyword_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      end_keyword_loc: T.nilable(Prism::Location),
      location: Prism::Location
    ).void
  end
  def initialize(else_keyword_loc, statements, end_keyword_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5583
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5588
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5600
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5593
  def compact_child_nodes; end

  # def copy: (**params) -> ElseNode
  #
  # source://prism//lib/prism/node.rb#5605
  sig { params(params: T.untyped).returns(Prism::ElseNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5588
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#5618
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def else_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#5623
  sig { returns(String) }
  def else_keyword; end

  # attr_reader else_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#5566
  sig { returns(Prism::Location) }
  def else_keyword_loc; end

  # def end_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#5628
  sig { returns(T.nilable(String)) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location?
  #
  # source://prism//lib/prism/node.rb#5572
  sig { returns(T.nilable(Prism::Location)) }
  def end_keyword_loc; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#5633
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#5569
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#5660
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#5670
    def type; end
  end
end

# EmbDocComment objects correspond to comments that are surrounded by =begin
# and =end.
#
# source://prism//lib/prism/parse_result.rb#261
class Prism::EmbDocComment < ::Prism::Comment
  # Returns a string representation of this comment.
  #
  # source://prism//lib/prism/parse_result.rb#267
  def inspect; end

  # This can only be true for inline comments.
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/parse_result.rb#262
  def trailing?; end
end

# Represents an interpolated set of statements.
#
#     "foo #{bar}"
#          ^^^^^^
#
# source://prism//lib/prism/node.rb#5680
class Prism::EmbeddedStatementsNode < ::Prism::Node
  # def initialize: (opening_loc: Location, statements: StatementsNode?, closing_loc: Location, location: Location) -> void
  #
  # @return [EmbeddedStatementsNode] a new instance of EmbeddedStatementsNode
  #
  # source://prism//lib/prism/node.rb#5690
  sig do
    params(
      opening_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      closing_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(opening_loc, statements, closing_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5698
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5703
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#5743
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#5687
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5715
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5708
  def compact_child_nodes; end

  # def copy: (**params) -> EmbeddedStatementsNode
  #
  # source://prism//lib/prism/node.rb#5720
  sig { params(params: T.untyped).returns(Prism::EmbeddedStatementsNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5703
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#5733
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#5748
  def inspect(inspector = T.unsafe(nil)); end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#5738
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#5681
  sig { returns(Prism::Location) }
  def opening_loc; end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#5684
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#5775
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#5785
    def type; end
  end
end

# Represents an interpolated variable.
#
#     "foo #@bar"
#          ^^^^^
#
# source://prism//lib/prism/node.rb#5795
class Prism::EmbeddedVariableNode < ::Prism::Node
  # def initialize: (operator_loc: Location, variable: Node, location: Location) -> void
  #
  # @return [EmbeddedVariableNode] a new instance of EmbeddedVariableNode
  #
  # source://prism//lib/prism/node.rb#5802
  sig { params(operator_loc: Prism::Location, variable: Prism::Node, location: Prism::Location).void }
  def initialize(operator_loc, variable, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5809
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5814
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5824
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5819
  def compact_child_nodes; end

  # def copy: (**params) -> EmbeddedVariableNode
  #
  # source://prism//lib/prism/node.rb#5829
  sig { params(params: T.untyped).returns(Prism::EmbeddedVariableNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5814
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#5841
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#5851
  def inspect(inspector = T.unsafe(nil)); end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#5846
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#5796
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#5873
  def type; end

  # attr_reader variable: Node
  #
  # source://prism//lib/prism/node.rb#5799
  sig { returns(Prism::Node) }
  def variable; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#5883
    def type; end
  end
end

# Flags for nodes that have unescaped content.
#
# source://prism//lib/prism/node.rb#17301
module Prism::EncodingFlags; end

# internal bytes forced the encoding to binary
#
# source://prism//lib/prism/node.rb#17306
Prism::EncodingFlags::FORCED_BINARY_ENCODING = T.let(T.unsafe(nil), Integer)

# internal bytes forced the encoding to UTF-8
#
# source://prism//lib/prism/node.rb#17303
Prism::EncodingFlags::FORCED_UTF8_ENCODING = T.let(T.unsafe(nil), Integer)

# Represents an `ensure` clause in a `begin` statement.
#
#     begin
#       foo
#     ensure
#     ^^^^^^
#       bar
#     end
#
# source://prism//lib/prism/node.rb#5897
class Prism::EnsureNode < ::Prism::Node
  # def initialize: (ensure_keyword_loc: Location, statements: StatementsNode?, end_keyword_loc: Location, location: Location) -> void
  #
  # @return [EnsureNode] a new instance of EnsureNode
  #
  # source://prism//lib/prism/node.rb#5907
  sig do
    params(
      ensure_keyword_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      end_keyword_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(ensure_keyword_loc, statements, end_keyword_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5915
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5920
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5932
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5925
  def compact_child_nodes; end

  # def copy: (**params) -> EnsureNode
  #
  # source://prism//lib/prism/node.rb#5937
  sig { params(params: T.untyped).returns(Prism::EnsureNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5920
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#5950
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#5960
  sig { returns(String) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#5904
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  # def ensure_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#5955
  sig { returns(String) }
  def ensure_keyword; end

  # attr_reader ensure_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#5898
  sig { returns(Prism::Location) }
  def ensure_keyword_loc; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#5965
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#5901
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#5992
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#6002
    def type; end
  end
end

# Represents the use of the literal `false` keyword.
#
#     false
#     ^^^^^
#
# source://prism//lib/prism/node.rb#6012
class Prism::FalseNode < ::Prism::Node
  # def initialize: (location: Location) -> void
  #
  # @return [FalseNode] a new instance of FalseNode
  #
  # source://prism//lib/prism/node.rb#6013
  sig { params(location: Prism::Location).void }
  def initialize(location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6018
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6023
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6033
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6028
  def compact_child_nodes; end

  # def copy: (**params) -> FalseNode
  #
  # source://prism//lib/prism/node.rb#6038
  sig { params(params: T.untyped).returns(Prism::FalseNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6023
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#6048
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#6053
  def inspect(inspector = T.unsafe(nil)); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#6072
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#6082
    def type; end
  end
end

# Represents a find pattern in pattern matching.
#
#     foo in *bar, baz, *qux
#            ^^^^^^^^^^^^^^^
#
#     foo in [*bar, baz, *qux]
#            ^^^^^^^^^^^^^^^^^
#
#     foo in Foo(*bar, baz, *qux)
#            ^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#6098
class Prism::FindPatternNode < ::Prism::Node
  # def initialize: (constant: Node?, left: Node, requireds: Array[Node], right: Node, opening_loc: Location?, closing_loc: Location?, location: Location) -> void
  #
  # @return [FindPatternNode] a new instance of FindPatternNode
  #
  # source://prism//lib/prism/node.rb#6117
  sig do
    params(
      constant: T.nilable(Prism::Node),
      left: Prism::Node,
      requireds: T::Array[Prism::Node],
      right: Prism::Node,
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location),
      location: Prism::Location
    ).void
  end
  def initialize(constant, left, requireds, right, opening_loc, closing_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6128
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6133
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#6179
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#6114
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6148
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6138
  def compact_child_nodes; end

  # attr_reader constant: Node?
  #
  # source://prism//lib/prism/node.rb#6099
  sig { returns(T.nilable(Prism::Node)) }
  def constant; end

  # def copy: (**params) -> FindPatternNode
  #
  # source://prism//lib/prism/node.rb#6153
  sig { params(params: T.untyped).returns(Prism::FindPatternNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6133
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#6169
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#6184
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader left: Node
  #
  # source://prism//lib/prism/node.rb#6102
  sig { returns(Prism::Node) }
  def left; end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#6174
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#6111
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # attr_reader requireds: Array[Node]
  #
  # source://prism//lib/prism/node.rb#6105
  sig { returns(T::Array[Prism::Node]) }
  def requireds; end

  # attr_reader right: Node
  #
  # source://prism//lib/prism/node.rb#6108
  sig { returns(Prism::Node) }
  def right; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#6216
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#6226
    def type; end
  end
end

# Represents the use of the `..` or `...` operators to create flip flops.
#
#     baz if foo .. bar
#            ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#6236
class Prism::FlipFlopNode < ::Prism::Node
  # def initialize: (flags: Integer, left: Node?, right: Node?, operator_loc: Location, location: Location) -> void
  #
  # @return [FlipFlopNode] a new instance of FlipFlopNode
  #
  # source://prism//lib/prism/node.rb#6249
  sig do
    params(
      flags: Integer,
      left: T.nilable(Prism::Node),
      right: T.nilable(Prism::Node),
      operator_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(flags, left, right, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6258
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6263
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6276
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6268
  def compact_child_nodes; end

  # def copy: (**params) -> FlipFlopNode
  #
  # source://prism//lib/prism/node.rb#6281
  sig { params(params: T.untyped).returns(Prism::FlipFlopNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6263
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#6295
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def exclude_end?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#6300
  sig { returns(T::Boolean) }
  def exclude_end?; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#6310
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader left: Node?
  #
  # source://prism//lib/prism/node.rb#6240
  sig { returns(T.nilable(Prism::Node)) }
  def left; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#6305
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#6246
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader right: Node?
  #
  # source://prism//lib/prism/node.rb#6243
  sig { returns(T.nilable(Prism::Node)) }
  def right; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#6344
  def type; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#6237
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#6354
    def type; end
  end
end

# Represents a floating point number literal.
#
#     1.0
#     ^^^
#
# source://prism//lib/prism/node.rb#6364
class Prism::FloatNode < ::Prism::Node
  # def initialize: (location: Location) -> void
  #
  # @return [FloatNode] a new instance of FloatNode
  #
  # source://prism//lib/prism/node.rb#6365
  sig { params(location: Prism::Location).void }
  def initialize(location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6370
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6375
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6385
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6380
  def compact_child_nodes; end

  # def copy: (**params) -> FloatNode
  #
  # source://prism//lib/prism/node.rb#6390
  sig { params(params: T.untyped).returns(Prism::FloatNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6375
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#6400
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#6405
  def inspect(inspector = T.unsafe(nil)); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#6424
  def type; end

  # Returns the value of the node as a Ruby Float.
  #
  # source://prism//lib/prism/node_ext.rb#62
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#6434
    def type; end
  end
end

# Represents the use of the `for` keyword.
#
#     for i in a end
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#6444
class Prism::ForNode < ::Prism::Node
  # def initialize: (index: Node, collection: Node, statements: StatementsNode?, for_keyword_loc: Location, in_keyword_loc: Location, do_keyword_loc: Location?, end_keyword_loc: Location, location: Location) -> void
  #
  # @return [ForNode] a new instance of ForNode
  #
  # source://prism//lib/prism/node.rb#6466
  sig do
    params(
      index: Prism::Node,
      collection: Prism::Node,
      statements: T.nilable(Prism::StatementsNode),
      for_keyword_loc: Prism::Location,
      in_keyword_loc: Prism::Location,
      do_keyword_loc: T.nilable(Prism::Location),
      end_keyword_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(index, collection, statements, for_keyword_loc, in_keyword_loc, do_keyword_loc, end_keyword_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6478
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6483
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # attr_reader collection: Node
  #
  # source://prism//lib/prism/node.rb#6448
  sig { returns(Prism::Node) }
  def collection; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6497
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6488
  def compact_child_nodes; end

  # def copy: (**params) -> ForNode
  #
  # source://prism//lib/prism/node.rb#6502
  sig { params(params: T.untyped).returns(Prism::ForNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6483
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#6519
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def do_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#6534
  sig { returns(T.nilable(String)) }
  def do_keyword; end

  # attr_reader do_keyword_loc: Location?
  #
  # source://prism//lib/prism/node.rb#6460
  sig { returns(T.nilable(Prism::Location)) }
  def do_keyword_loc; end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#6539
  sig { returns(String) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#6463
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  # def for_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#6524
  sig { returns(String) }
  def for_keyword; end

  # attr_reader for_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#6454
  sig { returns(Prism::Location) }
  def for_keyword_loc; end

  # def in_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#6529
  sig { returns(String) }
  def in_keyword; end

  # attr_reader in_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#6457
  sig { returns(Prism::Location) }
  def in_keyword_loc; end

  # attr_reader index: Node
  #
  # source://prism//lib/prism/node.rb#6445
  sig { returns(Prism::Node) }
  def index; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#6544
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#6451
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#6577
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#6587
    def type; end
  end
end

# Represents forwarding all arguments to this method to another method.
#
#     def foo(...)
#       bar(...)
#           ^^^
#     end
#
# source://prism//lib/prism/node.rb#6599
class Prism::ForwardingArgumentsNode < ::Prism::Node
  # def initialize: (location: Location) -> void
  #
  # @return [ForwardingArgumentsNode] a new instance of ForwardingArgumentsNode
  #
  # source://prism//lib/prism/node.rb#6600
  sig { params(location: Prism::Location).void }
  def initialize(location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6605
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6610
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6620
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6615
  def compact_child_nodes; end

  # def copy: (**params) -> ForwardingArgumentsNode
  #
  # source://prism//lib/prism/node.rb#6625
  sig { params(params: T.untyped).returns(Prism::ForwardingArgumentsNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6610
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#6635
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#6640
  def inspect(inspector = T.unsafe(nil)); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#6659
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#6669
    def type; end
  end
end

# Represents the use of the forwarding parameter in a method, block, or lambda declaration.
#
#     def foo(...)
#             ^^^
#     end
#
# source://prism//lib/prism/node.rb#6680
class Prism::ForwardingParameterNode < ::Prism::Node
  # def initialize: (location: Location) -> void
  #
  # @return [ForwardingParameterNode] a new instance of ForwardingParameterNode
  #
  # source://prism//lib/prism/node.rb#6681
  sig { params(location: Prism::Location).void }
  def initialize(location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6686
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6691
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6701
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6696
  def compact_child_nodes; end

  # def copy: (**params) -> ForwardingParameterNode
  #
  # source://prism//lib/prism/node.rb#6706
  sig { params(params: T.untyped).returns(Prism::ForwardingParameterNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6691
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#6716
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#6721
  def inspect(inspector = T.unsafe(nil)); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#6740
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#6750
    def type; end
  end
end

# Represents the use of the `super` keyword without parentheses or arguments.
#
#     super
#     ^^^^^
#
# source://prism//lib/prism/node.rb#6760
class Prism::ForwardingSuperNode < ::Prism::Node
  # def initialize: (block: BlockNode?, location: Location) -> void
  #
  # @return [ForwardingSuperNode] a new instance of ForwardingSuperNode
  #
  # source://prism//lib/prism/node.rb#6764
  sig { params(block: T.nilable(Prism::BlockNode), location: Prism::Location).void }
  def initialize(block, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6770
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader block: BlockNode?
  #
  # source://prism//lib/prism/node.rb#6761
  sig { returns(T.nilable(Prism::BlockNode)) }
  def block; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6775
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6787
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6780
  def compact_child_nodes; end

  # def copy: (**params) -> ForwardingSuperNode
  #
  # source://prism//lib/prism/node.rb#6792
  sig { params(params: T.untyped).returns(Prism::ForwardingSuperNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6775
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#6803
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#6808
  def inspect(inspector = T.unsafe(nil)); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#6833
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#6843
    def type; end
  end
end

# Represents the use of the `&&=` operator for assignment to a global variable.
#
#     $target &&= value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#6853
class Prism::GlobalVariableAndWriteNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, operator_loc: Location, value: Node, location: Location) -> void
  #
  # @return [GlobalVariableAndWriteNode] a new instance of GlobalVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#6866
  sig do
    params(
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, operator_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6875
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6880
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6890
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6885
  def compact_child_nodes; end

  # def copy: (**params) -> GlobalVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#6895
  sig { params(params: T.untyped).returns(Prism::GlobalVariableAndWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6880
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#6909
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#6919
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#6854
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#6857
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#6914
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#6860
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#6943
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#6863
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#6953
    def type; end
  end
end

# Represents assigning to a global variable using an operator that isn't `=`.
#
#     $target += value
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#6963
class Prism::GlobalVariableOperatorWriteNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, operator_loc: Location, value: Node, operator: Symbol, location: Location) -> void
  #
  # @return [GlobalVariableOperatorWriteNode] a new instance of GlobalVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#6979
  sig do
    params(
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      operator: Symbol,
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, operator_loc, value, operator, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6989
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6994
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7004
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6999
  def compact_child_nodes; end

  # def copy: (**params) -> GlobalVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#7009
  sig { params(params: T.untyped).returns(Prism::GlobalVariableOperatorWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6994
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#7024
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#7029
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#6964
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#6967
  sig { returns(Prism::Location) }
  def name_loc; end

  # attr_reader operator: Symbol
  #
  # source://prism//lib/prism/node.rb#6976
  sig { returns(Symbol) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#6970
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#7054
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#6973
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#7064
    def type; end
  end
end

# Represents the use of the `||=` operator for assignment to a global variable.
#
#     $target ||= value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#7074
class Prism::GlobalVariableOrWriteNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, operator_loc: Location, value: Node, location: Location) -> void
  #
  # @return [GlobalVariableOrWriteNode] a new instance of GlobalVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#7087
  sig do
    params(
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, operator_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7096
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7101
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7111
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7106
  def compact_child_nodes; end

  # def copy: (**params) -> GlobalVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#7116
  sig { params(params: T.untyped).returns(Prism::GlobalVariableOrWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7101
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#7130
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#7140
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#7075
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#7078
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#7135
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#7081
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#7164
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#7084
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#7174
    def type; end
  end
end

# Represents referencing a global variable.
#
#     $foo
#     ^^^^
#
# source://prism//lib/prism/node.rb#7184
class Prism::GlobalVariableReadNode < ::Prism::Node
  # def initialize: (name: Symbol, location: Location) -> void
  #
  # @return [GlobalVariableReadNode] a new instance of GlobalVariableReadNode
  #
  # source://prism//lib/prism/node.rb#7188
  sig { params(name: Symbol, location: Prism::Location).void }
  def initialize(name, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7194
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7199
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7209
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7204
  def compact_child_nodes; end

  # def copy: (**params) -> GlobalVariableReadNode
  #
  # source://prism//lib/prism/node.rb#7214
  sig { params(params: T.untyped).returns(Prism::GlobalVariableReadNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7199
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#7225
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#7230
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#7185
  sig { returns(Symbol) }
  def name; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#7250
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#7260
    def type; end
  end
end

# Represents writing to a global variable in a context that doesn't have an explicit value.
#
#     $foo, $bar = baz
#     ^^^^  ^^^^
#
# source://prism//lib/prism/node.rb#7270
class Prism::GlobalVariableTargetNode < ::Prism::Node
  # def initialize: (name: Symbol, location: Location) -> void
  #
  # @return [GlobalVariableTargetNode] a new instance of GlobalVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#7274
  sig { params(name: Symbol, location: Prism::Location).void }
  def initialize(name, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7280
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7285
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7295
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7290
  def compact_child_nodes; end

  # def copy: (**params) -> GlobalVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#7300
  sig { params(params: T.untyped).returns(Prism::GlobalVariableTargetNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7285
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#7311
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#7316
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#7271
  sig { returns(Symbol) }
  def name; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#7336
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#7346
    def type; end
  end
end

# Represents writing to a global variable.
#
#     $foo = 1
#     ^^^^^^^^
#
# source://prism//lib/prism/node.rb#7356
class Prism::GlobalVariableWriteNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, value: Node, operator_loc: Location, location: Location) -> void
  #
  # @return [GlobalVariableWriteNode] a new instance of GlobalVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#7369
  sig do
    params(
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, value, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7378
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7383
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7393
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7388
  def compact_child_nodes; end

  # def copy: (**params) -> GlobalVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#7398
  sig { params(params: T.untyped).returns(Prism::GlobalVariableWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7383
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#7412
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#7422
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#7357
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#7360
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#7417
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#7366
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#7446
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#7363
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#7456
    def type; end
  end
end

# Represents a hash literal.
#
#     { a => b }
#     ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#7466
class Prism::HashNode < ::Prism::Node
  # def initialize: (opening_loc: Location, elements: Array[Node], closing_loc: Location, location: Location) -> void
  #
  # @return [HashNode] a new instance of HashNode
  #
  # source://prism//lib/prism/node.rb#7476
  sig do
    params(
      opening_loc: Prism::Location,
      elements: T::Array[Prism::Node],
      closing_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(opening_loc, elements, closing_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7484
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7489
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#7527
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#7473
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7499
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7494
  def compact_child_nodes; end

  # def copy: (**params) -> HashNode
  #
  # source://prism//lib/prism/node.rb#7504
  sig { params(params: T.untyped).returns(Prism::HashNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7489
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#7517
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # attr_reader elements: Array[Node]
  #
  # source://prism//lib/prism/node.rb#7470
  sig { returns(T::Array[Prism::Node]) }
  def elements; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#7532
  def inspect(inspector = T.unsafe(nil)); end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#7522
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#7467
  sig { returns(Prism::Location) }
  def opening_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#7554
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#7564
    def type; end
  end
end

# Represents a hash pattern in pattern matching.
#
#     foo => { a: 1, b: 2 }
#            ^^^^^^^^^^^^^^
#
#     foo => { a: 1, b: 2, **c }
#            ^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#7577
class Prism::HashPatternNode < ::Prism::Node
  # def initialize: (constant: Node?, elements: Array[Node], rest: Node?, opening_loc: Location?, closing_loc: Location?, location: Location) -> void
  #
  # @return [HashPatternNode] a new instance of HashPatternNode
  #
  # source://prism//lib/prism/node.rb#7593
  sig do
    params(
      constant: T.nilable(Prism::Node),
      elements: T::Array[Prism::Node],
      rest: T.nilable(Prism::Node),
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location),
      location: Prism::Location
    ).void
  end
  def initialize(constant, elements, rest, opening_loc, closing_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7603
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7608
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#7652
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#7590
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7622
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7613
  def compact_child_nodes; end

  # attr_reader constant: Node?
  #
  # source://prism//lib/prism/node.rb#7578
  sig { returns(T.nilable(Prism::Node)) }
  def constant; end

  # def copy: (**params) -> HashPatternNode
  #
  # source://prism//lib/prism/node.rb#7627
  sig { params(params: T.untyped).returns(Prism::HashPatternNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7608
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#7642
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # attr_reader elements: Array[Node]
  #
  # source://prism//lib/prism/node.rb#7581
  sig { returns(T::Array[Prism::Node]) }
  def elements; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#7657
  def inspect(inspector = T.unsafe(nil)); end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#7647
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#7587
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # attr_reader rest: Node?
  #
  # source://prism//lib/prism/node.rb#7584
  sig { returns(T.nilable(Prism::Node)) }
  def rest; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#7691
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#7701
    def type; end
  end
end

# source://prism//lib/prism/node_ext.rb#35
module Prism::HeredocQuery
  # Returns true if this node was represented as a heredoc in the source code.
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node_ext.rb#37
  def heredoc?; end
end

# Represents the use of the `if` keyword, either in the block form or the modifier form.
#
#     bar if foo
#     ^^^^^^^^^^
#
#     if foo then bar end
#     ^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#7714
class Prism::IfNode < ::Prism::Node
  # def initialize: (if_keyword_loc: Location?, predicate: Node, then_keyword_loc: Location?, statements: StatementsNode?, consequent: Node?, end_keyword_loc: Location?, location: Location) -> void
  #
  # @return [IfNode] a new instance of IfNode
  #
  # source://prism//lib/prism/node.rb#7733
  sig do
    params(
      if_keyword_loc: T.nilable(Prism::Location),
      predicate: Prism::Node,
      then_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode),
      consequent: T.nilable(Prism::Node),
      end_keyword_loc: T.nilable(Prism::Location),
      location: Prism::Location
    ).void
  end
  def initialize(if_keyword_loc, predicate, then_keyword_loc, statements, consequent, end_keyword_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7744
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7753
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7767
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7758
  def compact_child_nodes; end

  # attr_reader consequent: Node?
  #
  # source://prism//lib/prism/node.rb#7727
  sig { returns(T.nilable(Prism::Node)) }
  def consequent; end

  # def copy: (**params) -> IfNode
  #
  # source://prism//lib/prism/node.rb#7772
  sig { params(params: T.untyped).returns(Prism::IfNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7753
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#7788
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def end_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#7803
  sig { returns(T.nilable(String)) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location?
  #
  # source://prism//lib/prism/node.rb#7730
  sig { returns(T.nilable(Prism::Location)) }
  def end_keyword_loc; end

  # def if_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#7793
  sig { returns(T.nilable(String)) }
  def if_keyword; end

  # attr_reader if_keyword_loc: Location?
  #
  # source://prism//lib/prism/node.rb#7715
  sig { returns(T.nilable(Prism::Location)) }
  def if_keyword_loc; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#7808
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader predicate: Node
  #
  # source://prism//lib/prism/node.rb#7718
  sig { returns(Prism::Node) }
  def predicate; end

  # source://prism//lib/prism/node.rb#7748
  def set_newline_flag(newline_marked); end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#7724
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # def then_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#7798
  sig { returns(T.nilable(String)) }
  def then_keyword; end

  # attr_reader then_keyword_loc: Location?
  #
  # source://prism//lib/prism/node.rb#7721
  sig { returns(T.nilable(Prism::Location)) }
  def then_keyword_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#7844
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#7854
    def type; end
  end
end

# Represents an imaginary number literal.
#
#     1.0i
#     ^^^^
#
# source://prism//lib/prism/node.rb#7864
class Prism::ImaginaryNode < ::Prism::Node
  # def initialize: (numeric: Node, location: Location) -> void
  #
  # @return [ImaginaryNode] a new instance of ImaginaryNode
  #
  # source://prism//lib/prism/node.rb#7868
  sig { params(numeric: Prism::Node, location: Prism::Location).void }
  def initialize(numeric, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7874
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7879
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7889
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7884
  def compact_child_nodes; end

  # def copy: (**params) -> ImaginaryNode
  #
  # source://prism//lib/prism/node.rb#7894
  sig { params(params: T.untyped).returns(Prism::ImaginaryNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7879
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#7905
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#7910
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader numeric: Node
  #
  # source://prism//lib/prism/node.rb#7865
  sig { returns(Prism::Node) }
  def numeric; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#7931
  def type; end

  # Returns the value of the node as a Ruby Complex.
  #
  # source://prism//lib/prism/node_ext.rb#69
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#7941
    def type; end
  end
end

# Represents a node that is implicitly being added to the tree but doesn't
# correspond directly to a node in the source.
#
#     { foo: }
#       ^^^^
#
#     { Foo: }
#       ^^^^
#
# source://prism//lib/prism/node.rb#7955
class Prism::ImplicitNode < ::Prism::Node
  # def initialize: (value: Node, location: Location) -> void
  #
  # @return [ImplicitNode] a new instance of ImplicitNode
  #
  # source://prism//lib/prism/node.rb#7959
  sig { params(value: Prism::Node, location: Prism::Location).void }
  def initialize(value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7965
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7970
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7980
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7975
  def compact_child_nodes; end

  # def copy: (**params) -> ImplicitNode
  #
  # source://prism//lib/prism/node.rb#7985
  sig { params(params: T.untyped).returns(Prism::ImplicitNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7970
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#7996
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#8001
  def inspect(inspector = T.unsafe(nil)); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#8022
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#7956
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#8032
    def type; end
  end
end

# Represents using a trailing comma to indicate an implicit rest parameter.
#
#     foo { |bar,| }
#               ^
#
#     foo in [bar,]
#                ^
#
#     for foo, in bar do end
#            ^
#
#     foo, = bar
#        ^
#
# source://prism//lib/prism/node.rb#8051
class Prism::ImplicitRestNode < ::Prism::Node
  # def initialize: (location: Location) -> void
  #
  # @return [ImplicitRestNode] a new instance of ImplicitRestNode
  #
  # source://prism//lib/prism/node.rb#8052
  sig { params(location: Prism::Location).void }
  def initialize(location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8057
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8062
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8072
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8067
  def compact_child_nodes; end

  # def copy: (**params) -> ImplicitRestNode
  #
  # source://prism//lib/prism/node.rb#8077
  sig { params(params: T.untyped).returns(Prism::ImplicitRestNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8062
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#8087
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#8092
  def inspect(inspector = T.unsafe(nil)); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#8111
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#8121
    def type; end
  end
end

# Represents the use of the `in` keyword in a case statement.
#
#     case a; in b then c end
#             ^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#8131
class Prism::InNode < ::Prism::Node
  # def initialize: (pattern: Node, statements: StatementsNode?, in_loc: Location, then_loc: Location?, location: Location) -> void
  #
  # @return [InNode] a new instance of InNode
  #
  # source://prism//lib/prism/node.rb#8144
  sig do
    params(
      pattern: Prism::Node,
      statements: T.nilable(Prism::StatementsNode),
      in_loc: Prism::Location,
      then_loc: T.nilable(Prism::Location),
      location: Prism::Location
    ).void
  end
  def initialize(pattern, statements, in_loc, then_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8153
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8158
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8171
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8163
  def compact_child_nodes; end

  # def copy: (**params) -> InNode
  #
  # source://prism//lib/prism/node.rb#8176
  sig { params(params: T.untyped).returns(Prism::InNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8158
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#8190
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def in: () -> String
  #
  # source://prism//lib/prism/node.rb#8195
  sig { returns(String) }
  def in; end

  # attr_reader in_loc: Location
  #
  # source://prism//lib/prism/node.rb#8138
  sig { returns(Prism::Location) }
  def in_loc; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#8205
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader pattern: Node
  #
  # source://prism//lib/prism/node.rb#8132
  sig { returns(Prism::Node) }
  def pattern; end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#8135
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # def then: () -> String?
  #
  # source://prism//lib/prism/node.rb#8200
  sig { returns(T.nilable(String)) }
  def then; end

  # attr_reader then_loc: Location?
  #
  # source://prism//lib/prism/node.rb#8141
  sig { returns(T.nilable(Prism::Location)) }
  def then_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#8234
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#8244
    def type; end
  end
end

# Represents the use of the `&&=` operator on a call to the `[]` method.
#
#     foo.bar[baz] &&= value
#     ^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#8254
class Prism::IndexAndWriteNode < ::Prism::Node
  # def initialize: (flags: Integer, receiver: Node?, call_operator_loc: Location?, opening_loc: Location, arguments: ArgumentsNode?, closing_loc: Location, block: Node?, operator_loc: Location, value: Node, location: Location) -> void
  #
  # @return [IndexAndWriteNode] a new instance of IndexAndWriteNode
  #
  # source://prism//lib/prism/node.rb#8282
  sig do
    params(
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::Node),
      operator_loc: Prism::Location,
      value: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, operator_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8296
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#8267
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8355
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # attr_reader block: Node?
  #
  # source://prism//lib/prism/node.rb#8273
  sig { returns(T.nilable(Prism::Node)) }
  def block; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#8360
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # attr_reader call_operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#8261
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8301
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#8370
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#8270
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8316
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8306
  def compact_child_nodes; end

  # def copy: (**params) -> IndexAndWriteNode
  #
  # source://prism//lib/prism/node.rb#8321
  sig { params(params: T.untyped).returns(Prism::IndexAndWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8301
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#8340
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#8380
  def inspect(inspector = T.unsafe(nil)); end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#8365
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#8264
  sig { returns(Prism::Location) }
  def opening_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#8375
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#8276
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader receiver: Node?
  #
  # source://prism//lib/prism/node.rb#8258
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8345
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#8425
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#8279
  sig { returns(Prism::Node) }
  def value; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8350
  sig { returns(T::Boolean) }
  def variable_call?; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#8255
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#8435
    def type; end
  end
end

# Represents the use of an assignment operator on a call to `[]`.
#
#     foo.bar[baz] += value
#     ^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#8445
class Prism::IndexOperatorWriteNode < ::Prism::Node
  # def initialize: (flags: Integer, receiver: Node?, call_operator_loc: Location?, opening_loc: Location, arguments: ArgumentsNode?, closing_loc: Location, block: Node?, operator: Symbol, operator_loc: Location, value: Node, location: Location) -> void
  #
  # @return [IndexOperatorWriteNode] a new instance of IndexOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#8476
  sig do
    params(
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::Node),
      operator: Symbol,
      operator_loc: Prism::Location,
      value: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, operator, operator_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8491
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#8458
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8551
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # attr_reader block: Node?
  #
  # source://prism//lib/prism/node.rb#8464
  sig { returns(T.nilable(Prism::Node)) }
  def block; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#8556
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # attr_reader call_operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#8452
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8496
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#8566
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#8461
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8511
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8501
  def compact_child_nodes; end

  # def copy: (**params) -> IndexOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#8516
  sig { params(params: T.untyped).returns(Prism::IndexOperatorWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8496
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#8536
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#8571
  def inspect(inspector = T.unsafe(nil)); end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#8561
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#8455
  sig { returns(Prism::Location) }
  def opening_loc; end

  # attr_reader operator: Symbol
  #
  # source://prism//lib/prism/node.rb#8467
  sig { returns(Symbol) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#8470
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader receiver: Node?
  #
  # source://prism//lib/prism/node.rb#8449
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8541
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#8617
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#8473
  sig { returns(Prism::Node) }
  def value; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8546
  sig { returns(T::Boolean) }
  def variable_call?; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#8446
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#8627
    def type; end
  end
end

# Represents the use of the `||=` operator on a call to `[]`.
#
#     foo.bar[baz] ||= value
#     ^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#8637
class Prism::IndexOrWriteNode < ::Prism::Node
  # def initialize: (flags: Integer, receiver: Node?, call_operator_loc: Location?, opening_loc: Location, arguments: ArgumentsNode?, closing_loc: Location, block: Node?, operator_loc: Location, value: Node, location: Location) -> void
  #
  # @return [IndexOrWriteNode] a new instance of IndexOrWriteNode
  #
  # source://prism//lib/prism/node.rb#8665
  sig do
    params(
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::Node),
      operator_loc: Prism::Location,
      value: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, operator_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8679
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#8650
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8738
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # attr_reader block: Node?
  #
  # source://prism//lib/prism/node.rb#8656
  sig { returns(T.nilable(Prism::Node)) }
  def block; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#8743
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # attr_reader call_operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#8644
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8684
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#8753
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#8653
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8699
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8689
  def compact_child_nodes; end

  # def copy: (**params) -> IndexOrWriteNode
  #
  # source://prism//lib/prism/node.rb#8704
  sig { params(params: T.untyped).returns(Prism::IndexOrWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8684
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#8723
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#8763
  def inspect(inspector = T.unsafe(nil)); end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#8748
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#8647
  sig { returns(Prism::Location) }
  def opening_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#8758
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#8659
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader receiver: Node?
  #
  # source://prism//lib/prism/node.rb#8641
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8728
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#8808
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#8662
  sig { returns(Prism::Node) }
  def value; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8733
  sig { returns(T::Boolean) }
  def variable_call?; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#8638
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#8818
    def type; end
  end
end

# Represents assigning to an index.
#
#     foo[bar], = 1
#     ^^^^^^^^
#
#     begin
#     rescue => foo[bar]
#               ^^^^^^^^
#     end
#
#     for foo[bar] in baz do end
#         ^^^^^^^^
#
# source://prism//lib/prism/node.rb#8836
class Prism::IndexTargetNode < ::Prism::Node
  # def initialize: (flags: Integer, receiver: Node, opening_loc: Location, arguments: ArgumentsNode?, closing_loc: Location, block: Node?, location: Location) -> void
  #
  # @return [IndexTargetNode] a new instance of IndexTargetNode
  #
  # source://prism//lib/prism/node.rb#8855
  sig do
    params(
      flags: Integer,
      receiver: Prism::Node,
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::Node),
      location: Prism::Location
    ).void
  end
  def initialize(flags, receiver, opening_loc, arguments, closing_loc, block, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8866
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#8846
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8921
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # attr_reader block: Node?
  #
  # source://prism//lib/prism/node.rb#8852
  sig { returns(T.nilable(Prism::Node)) }
  def block; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8871
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#8931
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#8849
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8885
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8876
  def compact_child_nodes; end

  # def copy: (**params) -> IndexTargetNode
  #
  # source://prism//lib/prism/node.rb#8890
  sig { params(params: T.untyped).returns(Prism::IndexTargetNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8871
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#8906
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#8936
  def inspect(inspector = T.unsafe(nil)); end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#8926
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#8843
  sig { returns(Prism::Location) }
  def opening_loc; end

  # attr_reader receiver: Node
  #
  # source://prism//lib/prism/node.rb#8840
  sig { returns(Prism::Node) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8911
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#8973
  def type; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8916
  sig { returns(T::Boolean) }
  def variable_call?; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#8837
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#8983
    def type; end
  end
end

# InlineComment objects are the most common. They correspond to comments in
# the source file like this one that start with #.
#
# source://prism//lib/prism/parse_result.rb#247
class Prism::InlineComment < ::Prism::Comment
  # Returns a string representation of this comment.
  #
  # source://prism//lib/prism/parse_result.rb#253
  def inspect; end

  # Returns true if this comment happens on the same line as other code and
  # false if the comment is by itself.
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/parse_result.rb#248
  sig { override.returns(T::Boolean) }
  def trailing?; end
end

# Represents the use of the `&&=` operator for assignment to an instance variable.
#
#     @target &&= value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#8993
class Prism::InstanceVariableAndWriteNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, operator_loc: Location, value: Node, location: Location) -> void
  #
  # @return [InstanceVariableAndWriteNode] a new instance of InstanceVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#9006
  sig do
    params(
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, operator_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9015
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9020
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9030
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9025
  def compact_child_nodes; end

  # def copy: (**params) -> InstanceVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#9035
  sig { params(params: T.untyped).returns(Prism::InstanceVariableAndWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9020
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#9049
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#9059
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#8994
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#8997
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#9054
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#9000
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#9083
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#9003
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#9093
    def type; end
  end
end

# Represents assigning to an instance variable using an operator that isn't `=`.
#
#     @target += value
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#9103
class Prism::InstanceVariableOperatorWriteNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, operator_loc: Location, value: Node, operator: Symbol, location: Location) -> void
  #
  # @return [InstanceVariableOperatorWriteNode] a new instance of InstanceVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#9119
  sig do
    params(
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      operator: Symbol,
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, operator_loc, value, operator, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9129
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9134
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9144
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9139
  def compact_child_nodes; end

  # def copy: (**params) -> InstanceVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#9149
  sig { params(params: T.untyped).returns(Prism::InstanceVariableOperatorWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9134
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#9164
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#9169
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#9104
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#9107
  sig { returns(Prism::Location) }
  def name_loc; end

  # attr_reader operator: Symbol
  #
  # source://prism//lib/prism/node.rb#9116
  sig { returns(Symbol) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#9110
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#9194
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#9113
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#9204
    def type; end
  end
end

# Represents the use of the `||=` operator for assignment to an instance variable.
#
#     @target ||= value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#9214
class Prism::InstanceVariableOrWriteNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, operator_loc: Location, value: Node, location: Location) -> void
  #
  # @return [InstanceVariableOrWriteNode] a new instance of InstanceVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#9227
  sig do
    params(
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, operator_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9236
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9241
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9251
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9246
  def compact_child_nodes; end

  # def copy: (**params) -> InstanceVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#9256
  sig { params(params: T.untyped).returns(Prism::InstanceVariableOrWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9241
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#9270
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#9280
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#9215
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#9218
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#9275
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#9221
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#9304
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#9224
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#9314
    def type; end
  end
end

# Represents referencing an instance variable.
#
#     @foo
#     ^^^^
#
# source://prism//lib/prism/node.rb#9324
class Prism::InstanceVariableReadNode < ::Prism::Node
  # def initialize: (name: Symbol, location: Location) -> void
  #
  # @return [InstanceVariableReadNode] a new instance of InstanceVariableReadNode
  #
  # source://prism//lib/prism/node.rb#9328
  sig { params(name: Symbol, location: Prism::Location).void }
  def initialize(name, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9334
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9339
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9349
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9344
  def compact_child_nodes; end

  # def copy: (**params) -> InstanceVariableReadNode
  #
  # source://prism//lib/prism/node.rb#9354
  sig { params(params: T.untyped).returns(Prism::InstanceVariableReadNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9339
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#9365
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#9370
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#9325
  sig { returns(Symbol) }
  def name; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#9390
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#9400
    def type; end
  end
end

# Represents writing to an instance variable in a context that doesn't have an explicit value.
#
#     @foo, @bar = baz
#     ^^^^  ^^^^
#
# source://prism//lib/prism/node.rb#9410
class Prism::InstanceVariableTargetNode < ::Prism::Node
  # def initialize: (name: Symbol, location: Location) -> void
  #
  # @return [InstanceVariableTargetNode] a new instance of InstanceVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#9414
  sig { params(name: Symbol, location: Prism::Location).void }
  def initialize(name, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9420
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9425
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9435
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9430
  def compact_child_nodes; end

  # def copy: (**params) -> InstanceVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#9440
  sig { params(params: T.untyped).returns(Prism::InstanceVariableTargetNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9425
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#9451
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#9456
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#9411
  sig { returns(Symbol) }
  def name; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#9476
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#9486
    def type; end
  end
end

# Represents writing to an instance variable.
#
#     @foo = 1
#     ^^^^^^^^
#
# source://prism//lib/prism/node.rb#9496
class Prism::InstanceVariableWriteNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, value: Node, operator_loc: Location, location: Location) -> void
  #
  # @return [InstanceVariableWriteNode] a new instance of InstanceVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#9509
  sig do
    params(
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, value, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9518
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9523
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9533
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9528
  def compact_child_nodes; end

  # def copy: (**params) -> InstanceVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#9538
  sig { params(params: T.untyped).returns(Prism::InstanceVariableWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9523
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#9552
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#9562
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#9497
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#9500
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#9557
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#9506
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#9586
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#9503
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#9596
    def type; end
  end
end

# Flags for integer nodes that correspond to the base of the integer.
#
# source://prism//lib/prism/node.rb#17310
module Prism::IntegerBaseFlags; end

# 0b prefix
#
# source://prism//lib/prism/node.rb#17312
Prism::IntegerBaseFlags::BINARY = T.let(T.unsafe(nil), Integer)

# 0d or no prefix
#
# source://prism//lib/prism/node.rb#17315
Prism::IntegerBaseFlags::DECIMAL = T.let(T.unsafe(nil), Integer)

# 0x prefix
#
# source://prism//lib/prism/node.rb#17321
Prism::IntegerBaseFlags::HEXADECIMAL = T.let(T.unsafe(nil), Integer)

# 0o or 0 prefix
#
# source://prism//lib/prism/node.rb#17318
Prism::IntegerBaseFlags::OCTAL = T.let(T.unsafe(nil), Integer)

# Represents an integer number literal.
#
#     1
#     ^
#
# source://prism//lib/prism/node.rb#9606
class Prism::IntegerNode < ::Prism::Node
  # def initialize: (flags: Integer, location: Location) -> void
  #
  # @return [IntegerNode] a new instance of IntegerNode
  #
  # source://prism//lib/prism/node.rb#9610
  sig { params(flags: Integer, location: Prism::Location).void }
  def initialize(flags, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9616
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def binary?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9652
  sig { returns(T::Boolean) }
  def binary?; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9621
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9631
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9626
  def compact_child_nodes; end

  # def copy: (**params) -> IntegerNode
  #
  # source://prism//lib/prism/node.rb#9636
  sig { params(params: T.untyped).returns(Prism::IntegerNode) }
  def copy(**params); end

  # def decimal?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9657
  sig { returns(T::Boolean) }
  def decimal?; end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9621
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#9647
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def hexadecimal?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9667
  sig { returns(T::Boolean) }
  def hexadecimal?; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#9672
  def inspect(inspector = T.unsafe(nil)); end

  # def octal?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9662
  sig { returns(T::Boolean) }
  def octal?; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#9693
  def type; end

  # Returns the value of the node as a Ruby Integer.
  #
  # source://prism//lib/prism/node_ext.rb#76
  def value; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#9607
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#9703
    def type; end
  end
end

# Represents a regular expression literal that contains interpolation that
# is being used in the predicate of a conditional to implicitly match
# against the last line read by an IO object.
#
#     if /foo #{bar} baz/ then end
#        ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#9715
class Prism::InterpolatedMatchLastLineNode < ::Prism::Node
  include ::Prism::RegularExpressionOptions

  # def initialize: (flags: Integer, opening_loc: Location, parts: Array[Node], closing_loc: Location, location: Location) -> void
  #
  # @return [InterpolatedMatchLastLineNode] a new instance of InterpolatedMatchLastLineNode
  #
  # source://prism//lib/prism/node.rb#9728
  sig do
    params(
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[Prism::Node],
      closing_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(flags, opening_loc, parts, closing_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9737
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def ascii_8bit?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9806
  sig { returns(T::Boolean) }
  def ascii_8bit?; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9747
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#9841
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#9725
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9757
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9752
  def compact_child_nodes; end

  # def copy: (**params) -> InterpolatedMatchLastLineNode
  #
  # source://prism//lib/prism/node.rb#9762
  sig { params(params: T.untyped).returns(Prism::InterpolatedMatchLastLineNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9747
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#9776
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def euc_jp?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9801
  sig { returns(T::Boolean) }
  def euc_jp?; end

  # def extended?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9786
  sig { returns(T::Boolean) }
  def extended?; end

  # def forced_binary_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9826
  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  # def forced_us_ascii_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9831
  sig { returns(T::Boolean) }
  def forced_us_ascii_encoding?; end

  # def forced_utf8_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9821
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  # def ignore_case?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9781
  sig { returns(T::Boolean) }
  def ignore_case?; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#9846
  def inspect(inspector = T.unsafe(nil)); end

  # def multi_line?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9791
  sig { returns(T::Boolean) }
  def multi_line?; end

  # def once?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9796
  sig { returns(T::Boolean) }
  def once?; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#9836
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#9719
  sig { returns(Prism::Location) }
  def opening_loc; end

  # attr_reader parts: Array[Node]
  #
  # source://prism//lib/prism/node.rb#9722
  sig { returns(T::Array[Prism::Node]) }
  def parts; end

  # source://prism//lib/prism/node.rb#9741
  def set_newline_flag(newline_marked); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#9870
  def type; end

  # def utf_8?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9816
  sig { returns(T::Boolean) }
  def utf_8?; end

  # def windows_31j?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9811
  sig { returns(T::Boolean) }
  def windows_31j?; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#9716
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#9880
    def type; end
  end
end

# Represents a regular expression literal that contains interpolation.
#
#     /foo #{bar} baz/
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#9890
class Prism::InterpolatedRegularExpressionNode < ::Prism::Node
  include ::Prism::RegularExpressionOptions

  # def initialize: (flags: Integer, opening_loc: Location, parts: Array[Node], closing_loc: Location, location: Location) -> void
  #
  # @return [InterpolatedRegularExpressionNode] a new instance of InterpolatedRegularExpressionNode
  #
  # source://prism//lib/prism/node.rb#9903
  sig do
    params(
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[Prism::Node],
      closing_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(flags, opening_loc, parts, closing_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9912
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def ascii_8bit?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9981
  sig { returns(T::Boolean) }
  def ascii_8bit?; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9922
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#10016
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#9900
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9932
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9927
  def compact_child_nodes; end

  # def copy: (**params) -> InterpolatedRegularExpressionNode
  #
  # source://prism//lib/prism/node.rb#9937
  sig { params(params: T.untyped).returns(Prism::InterpolatedRegularExpressionNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9922
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#9951
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def euc_jp?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9976
  sig { returns(T::Boolean) }
  def euc_jp?; end

  # def extended?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9961
  sig { returns(T::Boolean) }
  def extended?; end

  # def forced_binary_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#10001
  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  # def forced_us_ascii_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#10006
  sig { returns(T::Boolean) }
  def forced_us_ascii_encoding?; end

  # def forced_utf8_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9996
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  # def ignore_case?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9956
  sig { returns(T::Boolean) }
  def ignore_case?; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#10021
  def inspect(inspector = T.unsafe(nil)); end

  # def multi_line?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9966
  sig { returns(T::Boolean) }
  def multi_line?; end

  # def once?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9971
  sig { returns(T::Boolean) }
  def once?; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#10011
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#9894
  sig { returns(Prism::Location) }
  def opening_loc; end

  # attr_reader parts: Array[Node]
  #
  # source://prism//lib/prism/node.rb#9897
  sig { returns(T::Array[Prism::Node]) }
  def parts; end

  # source://prism//lib/prism/node.rb#9916
  def set_newline_flag(newline_marked); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#10045
  def type; end

  # def utf_8?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9991
  sig { returns(T::Boolean) }
  def utf_8?; end

  # def windows_31j?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9986
  sig { returns(T::Boolean) }
  def windows_31j?; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#9891
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#10055
    def type; end
  end
end

# Represents a string literal that contains interpolation.
#
#     "foo #{bar} baz"
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#10065
class Prism::InterpolatedStringNode < ::Prism::Node
  include ::Prism::HeredocQuery

  # def initialize: (opening_loc: Location?, parts: Array[Node], closing_loc: Location?, location: Location) -> void
  #
  # @return [InterpolatedStringNode] a new instance of InterpolatedStringNode
  #
  # source://prism//lib/prism/node.rb#10075
  sig do
    params(
      opening_loc: T.nilable(Prism::Location),
      parts: T::Array[Prism::Node],
      closing_loc: T.nilable(Prism::Location),
      location: Prism::Location
    ).void
  end
  def initialize(opening_loc, parts, closing_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10083
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10093
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#10131
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#10072
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10103
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10098
  def compact_child_nodes; end

  # def copy: (**params) -> InterpolatedStringNode
  #
  # source://prism//lib/prism/node.rb#10108
  sig { params(params: T.untyped).returns(Prism::InterpolatedStringNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10093
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#10121
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#10136
  def inspect(inspector = T.unsafe(nil)); end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#10126
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#10066
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # attr_reader parts: Array[Node]
  #
  # source://prism//lib/prism/node.rb#10069
  sig { returns(T::Array[Prism::Node]) }
  def parts; end

  # source://prism//lib/prism/node.rb#10087
  def set_newline_flag(newline_marked); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#10158
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#10168
    def type; end
  end
end

# Represents a symbol literal that contains interpolation.
#
#     :"foo #{bar} baz"
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#10178
class Prism::InterpolatedSymbolNode < ::Prism::Node
  # def initialize: (opening_loc: Location?, parts: Array[Node], closing_loc: Location?, location: Location) -> void
  #
  # @return [InterpolatedSymbolNode] a new instance of InterpolatedSymbolNode
  #
  # source://prism//lib/prism/node.rb#10188
  sig do
    params(
      opening_loc: T.nilable(Prism::Location),
      parts: T::Array[Prism::Node],
      closing_loc: T.nilable(Prism::Location),
      location: Prism::Location
    ).void
  end
  def initialize(opening_loc, parts, closing_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10196
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10206
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#10244
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#10185
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10216
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10211
  def compact_child_nodes; end

  # def copy: (**params) -> InterpolatedSymbolNode
  #
  # source://prism//lib/prism/node.rb#10221
  sig { params(params: T.untyped).returns(Prism::InterpolatedSymbolNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10206
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#10234
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#10249
  def inspect(inspector = T.unsafe(nil)); end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#10239
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#10179
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # attr_reader parts: Array[Node]
  #
  # source://prism//lib/prism/node.rb#10182
  sig { returns(T::Array[Prism::Node]) }
  def parts; end

  # source://prism//lib/prism/node.rb#10200
  def set_newline_flag(newline_marked); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#10271
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#10281
    def type; end
  end
end

# Represents an xstring literal that contains interpolation.
#
#     `foo #{bar} baz`
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#10291
class Prism::InterpolatedXStringNode < ::Prism::Node
  include ::Prism::HeredocQuery

  # def initialize: (opening_loc: Location, parts: Array[Node], closing_loc: Location, location: Location) -> void
  #
  # @return [InterpolatedXStringNode] a new instance of InterpolatedXStringNode
  #
  # source://prism//lib/prism/node.rb#10301
  sig do
    params(
      opening_loc: Prism::Location,
      parts: T::Array[Prism::Node],
      closing_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(opening_loc, parts, closing_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10309
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10319
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#10357
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#10298
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10329
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10324
  def compact_child_nodes; end

  # def copy: (**params) -> InterpolatedXStringNode
  #
  # source://prism//lib/prism/node.rb#10334
  sig { params(params: T.untyped).returns(Prism::InterpolatedXStringNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10319
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#10347
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#10362
  def inspect(inspector = T.unsafe(nil)); end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#10352
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#10292
  sig { returns(Prism::Location) }
  def opening_loc; end

  # attr_reader parts: Array[Node]
  #
  # source://prism//lib/prism/node.rb#10295
  sig { returns(T::Array[Prism::Node]) }
  def parts; end

  # source://prism//lib/prism/node.rb#10313
  def set_newline_flag(newline_marked); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#10384
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#10394
    def type; end
  end
end

# Represents a hash literal without opening and closing braces.
#
#     foo(a: b)
#         ^^^^
#
# source://prism//lib/prism/node.rb#10404
class Prism::KeywordHashNode < ::Prism::Node
  # def initialize: (flags: Integer, elements: Array[Node], location: Location) -> void
  #
  # @return [KeywordHashNode] a new instance of KeywordHashNode
  #
  # source://prism//lib/prism/node.rb#10411
  sig { params(flags: Integer, elements: T::Array[Prism::Node], location: Prism::Location).void }
  def initialize(flags, elements, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10418
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10423
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10433
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10428
  def compact_child_nodes; end

  # def copy: (**params) -> KeywordHashNode
  #
  # source://prism//lib/prism/node.rb#10438
  sig { params(params: T.untyped).returns(Prism::KeywordHashNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10423
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#10450
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # attr_reader elements: Array[Node]
  #
  # source://prism//lib/prism/node.rb#10408
  sig { returns(T::Array[Prism::Node]) }
  def elements; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#10460
  def inspect(inspector = T.unsafe(nil)); end

  # def static_keys?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#10455
  sig { returns(T::Boolean) }
  def static_keys?; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#10482
  def type; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#10405
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#10492
    def type; end
  end
end

# Flags for keyword hash nodes.
#
# source://prism//lib/prism/node.rb#17325
module Prism::KeywordHashNodeFlags; end

# a keyword hash which only has `AssocNode` elements all with static literal keys, which means the elements can be treated as keyword arguments
#
# source://prism//lib/prism/node.rb#17327
Prism::KeywordHashNodeFlags::STATIC_KEYS = T.let(T.unsafe(nil), Integer)

# Represents a keyword rest parameter to a method, block, or lambda definition.
#
#     def a(**b)
#           ^^^
#     end
#
# source://prism//lib/prism/node.rb#10503
class Prism::KeywordRestParameterNode < ::Prism::Node
  # def initialize: (name: Symbol?, name_loc: Location?, operator_loc: Location, location: Location) -> void
  #
  # @return [KeywordRestParameterNode] a new instance of KeywordRestParameterNode
  #
  # source://prism//lib/prism/node.rb#10513
  sig do
    params(
      name: T.nilable(Symbol),
      name_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10521
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10526
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10536
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10531
  def compact_child_nodes; end

  # def copy: (**params) -> KeywordRestParameterNode
  #
  # source://prism//lib/prism/node.rb#10541
  sig { params(params: T.untyped).returns(Prism::KeywordRestParameterNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10526
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#10554
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#10564
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol?
  #
  # source://prism//lib/prism/node.rb#10504
  sig { returns(T.nilable(Symbol)) }
  def name; end

  # attr_reader name_loc: Location?
  #
  # source://prism//lib/prism/node.rb#10507
  sig { returns(T.nilable(Prism::Location)) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#10559
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#10510
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#10590
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#10600
    def type; end
  end
end

# Represents using a lambda literal (not the lambda method call).
#
#     ->(value) { value * 2 }
#     ^^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#10610
class Prism::LambdaNode < ::Prism::Node
  # def initialize: (locals: Array[Symbol], locals_body_index: Integer, operator_loc: Location, opening_loc: Location, closing_loc: Location, parameters: Node?, body: Node?, location: Location) -> void
  #
  # @return [LambdaNode] a new instance of LambdaNode
  #
  # source://prism//lib/prism/node.rb#10632
  sig do
    params(
      locals: T::Array[Symbol],
      locals_body_index: Integer,
      operator_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location,
      parameters: T.nilable(Prism::Node),
      body: T.nilable(Prism::Node),
      location: Prism::Location
    ).void
  end
  def initialize(locals, locals_body_index, operator_loc, opening_loc, closing_loc, parameters, body, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10644
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader body: Node?
  #
  # source://prism//lib/prism/node.rb#10629
  sig { returns(T.nilable(Prism::Node)) }
  def body; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10649
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#10699
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#10623
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10662
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10654
  def compact_child_nodes; end

  # def copy: (**params) -> LambdaNode
  #
  # source://prism//lib/prism/node.rb#10667
  sig { params(params: T.untyped).returns(Prism::LambdaNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10649
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#10684
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#10704
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader locals: Array[Symbol]
  #
  # source://prism//lib/prism/node.rb#10611
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # attr_reader locals_body_index: Integer
  #
  # source://prism//lib/prism/node.rb#10614
  sig { returns(Integer) }
  def locals_body_index; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#10694
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#10620
  sig { returns(Prism::Location) }
  def opening_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#10689
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#10617
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader parameters: Node?
  #
  # source://prism//lib/prism/node.rb#10626
  sig { returns(T.nilable(Prism::Node)) }
  def parameters; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#10740
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#10750
    def type; end
  end
end

# This class is responsible for lexing the source using prism and then
# converting those tokens to be compatible with Ripper. In the vast majority
# of cases, this is a one-to-one mapping of the token type. Everything else
# generally lines up. However, there are a few cases that require special
# handling.
#
# source://prism//lib/prism/lex_compat.rb#11
class Prism::LexCompat
  # @return [LexCompat] a new instance of LexCompat
  #
  # source://prism//lib/prism/lex_compat.rb#599
  def initialize(source, **options); end

  # Returns the value of attribute options.
  #
  # source://prism//lib/prism/lex_compat.rb#597
  def options; end

  # source://prism//lib/prism/lex_compat.rb#604
  def result; end

  # Returns the value of attribute source.
  #
  # source://prism//lib/prism/lex_compat.rb#597
  def source; end
end

# Ripper doesn't include the rest of the token in the event, so we need to
# trim it down to just the content on the first line when comparing.
#
# source://prism//lib/prism/lex_compat.rb#210
class Prism::LexCompat::EndContentToken < ::Prism::LexCompat::Token
  # source://prism//lib/prism/lex_compat.rb#211
  def ==(other); end
end

# A heredoc in this case is a list of tokens that belong to the body of the
# heredoc that should be appended onto the list of tokens when the heredoc
# closes.
#
# source://prism//lib/prism/lex_compat.rb#271
module Prism::LexCompat::Heredoc
  class << self
    # Here we will split between the two types of heredocs and return the
    # object that will store their tokens.
    #
    # source://prism//lib/prism/lex_compat.rb#583
    def build(opening); end
  end
end

# Dash heredocs are a little more complicated. They are a list of tokens
# that need to be split on "\\\n" to mimic Ripper's behavior. We also need
# to keep track of the state that the heredoc was opened in.
#
# source://prism//lib/prism/lex_compat.rb#295
class Prism::LexCompat::Heredoc::DashHeredoc
  # @return [DashHeredoc] a new instance of DashHeredoc
  #
  # source://prism//lib/prism/lex_compat.rb#298
  def initialize(split); end

  # source://prism//lib/prism/lex_compat.rb#303
  def <<(token); end

  # source://prism//lib/prism/lex_compat.rb#296
  def split; end

  # source://prism//lib/prism/lex_compat.rb#307
  def to_a; end

  # source://prism//lib/prism/lex_compat.rb#296
  def tokens; end
end

# Heredocs that are dedenting heredocs are a little more complicated.
# Ripper outputs on_ignored_sp tokens for the whitespace that is being
# removed from the output. prism only modifies the node itself and keeps
# the token the same. This simplifies prism, but makes comparing against
# Ripper much harder because there is a length mismatch.
#
# Fortunately, we already have to pull out the heredoc tokens in order to
# insert them into the stream in the correct order. As such, we can do
# some extra manipulation on the tokens to make them match Ripper's
# output by mirroring the dedent logic that Ripper uses.
#
# source://prism//lib/prism/lex_compat.rb#354
class Prism::LexCompat::Heredoc::DedentingHeredoc
  # @return [DedentingHeredoc] a new instance of DedentingHeredoc
  #
  # source://prism//lib/prism/lex_compat.rb#359
  def initialize; end

  # As tokens are coming in, we track the minimum amount of common leading
  # whitespace on plain string content tokens. This allows us to later
  # remove that amount of whitespace from the beginning of each line.
  #
  # source://prism//lib/prism/lex_compat.rb#370
  def <<(token); end

  # Returns the value of attribute dedent.
  #
  # source://prism//lib/prism/lex_compat.rb#357
  def dedent; end

  # Returns the value of attribute dedent_next.
  #
  # source://prism//lib/prism/lex_compat.rb#357
  def dedent_next; end

  # Returns the value of attribute embexpr_balance.
  #
  # source://prism//lib/prism/lex_compat.rb#357
  def embexpr_balance; end

  # source://prism//lib/prism/lex_compat.rb#407
  def to_a; end

  # Returns the value of attribute tokens.
  #
  # source://prism//lib/prism/lex_compat.rb#357
  def tokens; end
end

# source://prism//lib/prism/lex_compat.rb#355
Prism::LexCompat::Heredoc::DedentingHeredoc::TAB_WIDTH = T.let(T.unsafe(nil), Integer)

# Heredocs that are no dash or tilde heredocs are just a list of tokens.
# We need to keep them around so that we can insert them in the correct
# order back into the token stream and set the state of the last token to
# the state that the heredoc was opened in.
#
# source://prism//lib/prism/lex_compat.rb#276
class Prism::LexCompat::Heredoc::PlainHeredoc
  # @return [PlainHeredoc] a new instance of PlainHeredoc
  #
  # source://prism//lib/prism/lex_compat.rb#279
  def initialize; end

  # source://prism//lib/prism/lex_compat.rb#283
  def <<(token); end

  # source://prism//lib/prism/lex_compat.rb#287
  def to_a; end

  # source://prism//lib/prism/lex_compat.rb#277
  def tokens; end
end

# Ident tokens for the most part are exactly the same, except sometimes we
# know an ident is a local when ripper doesn't (when they are introduced
# through named captures in regular expressions). In that case we don't
# compare the state.
#
# source://prism//lib/prism/lex_compat.rb#228
class Prism::LexCompat::IdentToken < ::Prism::LexCompat::Token
  # source://prism//lib/prism/lex_compat.rb#229
  def ==(other); end
end

# Tokens where state should be ignored
# used for :on_comment, :on_heredoc_end, :on_embexpr_end
#
# source://prism//lib/prism/lex_compat.rb#218
class Prism::LexCompat::IgnoreStateToken < ::Prism::LexCompat::Token
  # source://prism//lib/prism/lex_compat.rb#219
  def ==(other); end
end

# Ignored newlines can occasionally have a LABEL state attached to them, so
# we compare the state differently here.
#
# source://prism//lib/prism/lex_compat.rb#239
class Prism::LexCompat::IgnoredNewlineToken < ::Prism::LexCompat::Token
  # source://prism//lib/prism/lex_compat.rb#240
  def ==(other); end
end

# If we have an identifier that follows a method name like:
#
#     def foo bar
#
# then Ripper will mark bar as END|LABEL if there is a local in a parent
# scope named bar because it hasn't pushed the local table yet. We do this
# more accurately, so we need to allow comparing against both END and
# END|LABEL.
#
# source://prism//lib/prism/lex_compat.rb#259
class Prism::LexCompat::ParamToken < ::Prism::LexCompat::Token
  # source://prism//lib/prism/lex_compat.rb#260
  def ==(other); end
end

# This is a mapping of prism token types to Ripper token types. This is a
# many-to-one mapping because we split up our token types, whereas Ripper
# tends to group them.
#
# source://prism//lib/prism/lex_compat.rb#15
Prism::LexCompat::RIPPER = T.let(T.unsafe(nil), Hash)

# When we produce tokens, we produce the same arrays that Ripper does.
# However, we add a couple of convenience methods onto them to make them a
# little easier to work with. We delegate all other methods to the array.
#
# source://prism//lib/prism/lex_compat.rb#187
class Prism::LexCompat::Token < ::SimpleDelegator
  # The type of the token.
  #
  # source://prism//lib/prism/lex_compat.rb#193
  def event; end

  # The location of the token in the source.
  #
  # source://prism//lib/prism/lex_compat.rb#188
  def location; end

  # The state of the lexer when this token was produced.
  #
  # source://prism//lib/prism/lex_compat.rb#203
  def state; end

  # The slice of the source that this token represents.
  #
  # source://prism//lib/prism/lex_compat.rb#198
  def value; end
end

# This is a class that wraps the Ripper lexer to produce almost exactly the
# same tokens.
#
# source://prism//lib/prism/lex_compat.rb#852
class Prism::LexRipper
  # @return [LexRipper] a new instance of LexRipper
  #
  # source://prism//lib/prism/lex_compat.rb#855
  def initialize(source); end

  # source://prism//lib/prism/lex_compat.rb#859
  def result; end

  # source://prism//lib/prism/lex_compat.rb#853
  def source; end
end

# Represents the use of the `&&=` operator for assignment to a local variable.
#
#     target &&= value
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#10760
class Prism::LocalVariableAndWriteNode < ::Prism::Node
  # def initialize: (name_loc: Location, operator_loc: Location, value: Node, name: Symbol, depth: Integer, location: Location) -> void
  #
  # @return [LocalVariableAndWriteNode] a new instance of LocalVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#10776
  sig do
    params(
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      depth: Integer,
      location: Prism::Location
    ).void
  end
  def initialize(name_loc, operator_loc, value, name, depth, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10786
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10791
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10801
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10796
  def compact_child_nodes; end

  # def copy: (**params) -> LocalVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#10806
  sig { params(params: T.untyped).returns(Prism::LocalVariableAndWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10791
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#10821
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # attr_reader depth: Integer
  #
  # source://prism//lib/prism/node.rb#10773
  sig { returns(Integer) }
  def depth; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#10831
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#10770
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#10761
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#10826
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#10764
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#10856
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#10767
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#10866
    def type; end
  end
end

# Represents assigning to a local variable using an operator that isn't `=`.
#
#     target += value
#     ^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#10876
class Prism::LocalVariableOperatorWriteNode < ::Prism::Node
  # def initialize: (name_loc: Location, operator_loc: Location, value: Node, name: Symbol, operator: Symbol, depth: Integer, location: Location) -> void
  #
  # @return [LocalVariableOperatorWriteNode] a new instance of LocalVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#10895
  sig do
    params(
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      operator: Symbol,
      depth: Integer,
      location: Prism::Location
    ).void
  end
  def initialize(name_loc, operator_loc, value, name, operator, depth, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10906
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10911
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10921
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10916
  def compact_child_nodes; end

  # def copy: (**params) -> LocalVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#10926
  sig { params(params: T.untyped).returns(Prism::LocalVariableOperatorWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10911
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#10942
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # attr_reader depth: Integer
  #
  # source://prism//lib/prism/node.rb#10892
  sig { returns(Integer) }
  def depth; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#10947
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#10886
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#10877
  sig { returns(Prism::Location) }
  def name_loc; end

  # attr_reader operator: Symbol
  #
  # source://prism//lib/prism/node.rb#10889
  sig { returns(Symbol) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#10880
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#10973
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#10883
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#10983
    def type; end
  end
end

# Represents the use of the `||=` operator for assignment to a local variable.
#
#     target ||= value
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#10993
class Prism::LocalVariableOrWriteNode < ::Prism::Node
  # def initialize: (name_loc: Location, operator_loc: Location, value: Node, name: Symbol, depth: Integer, location: Location) -> void
  #
  # @return [LocalVariableOrWriteNode] a new instance of LocalVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#11009
  sig do
    params(
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      depth: Integer,
      location: Prism::Location
    ).void
  end
  def initialize(name_loc, operator_loc, value, name, depth, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11019
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11024
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11034
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11029
  def compact_child_nodes; end

  # def copy: (**params) -> LocalVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#11039
  sig { params(params: T.untyped).returns(Prism::LocalVariableOrWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11024
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#11054
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # attr_reader depth: Integer
  #
  # source://prism//lib/prism/node.rb#11006
  sig { returns(Integer) }
  def depth; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#11064
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#11003
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#10994
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#11059
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#10997
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#11089
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#11000
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#11099
    def type; end
  end
end

# Represents reading a local variable. Note that this requires that a local
# variable of the same name has already been written to in the same scope,
# otherwise it is parsed as a method call.
#
#     foo
#     ^^^
#
# source://prism//lib/prism/node.rb#11111
class Prism::LocalVariableReadNode < ::Prism::Node
  # def initialize: (name: Symbol, depth: Integer, location: Location) -> void
  #
  # @return [LocalVariableReadNode] a new instance of LocalVariableReadNode
  #
  # source://prism//lib/prism/node.rb#11118
  sig { params(name: Symbol, depth: Integer, location: Prism::Location).void }
  def initialize(name, depth, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11125
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11130
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11140
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11135
  def compact_child_nodes; end

  # def copy: (**params) -> LocalVariableReadNode
  #
  # source://prism//lib/prism/node.rb#11145
  sig { params(params: T.untyped).returns(Prism::LocalVariableReadNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11130
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#11157
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # attr_reader depth: Integer
  #
  # source://prism//lib/prism/node.rb#11115
  sig { returns(Integer) }
  def depth; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#11162
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#11112
  sig { returns(Symbol) }
  def name; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#11183
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#11193
    def type; end
  end
end

# Represents writing to a local variable in a context that doesn't have an explicit value.
#
#     foo, bar = baz
#     ^^^  ^^^
#
# source://prism//lib/prism/node.rb#11203
class Prism::LocalVariableTargetNode < ::Prism::Node
  # def initialize: (name: Symbol, depth: Integer, location: Location) -> void
  #
  # @return [LocalVariableTargetNode] a new instance of LocalVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#11210
  sig { params(name: Symbol, depth: Integer, location: Prism::Location).void }
  def initialize(name, depth, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11217
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11222
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11232
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11227
  def compact_child_nodes; end

  # def copy: (**params) -> LocalVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#11237
  sig { params(params: T.untyped).returns(Prism::LocalVariableTargetNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11222
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#11249
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # attr_reader depth: Integer
  #
  # source://prism//lib/prism/node.rb#11207
  sig { returns(Integer) }
  def depth; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#11254
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#11204
  sig { returns(Symbol) }
  def name; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#11275
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#11285
    def type; end
  end
end

# Represents writing to a local variable.
#
#     foo = 1
#     ^^^^^^^
#
# source://prism//lib/prism/node.rb#11295
class Prism::LocalVariableWriteNode < ::Prism::Node
  # def initialize: (name: Symbol, depth: Integer, name_loc: Location, value: Node, operator_loc: Location, location: Location) -> void
  #
  # @return [LocalVariableWriteNode] a new instance of LocalVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#11311
  sig do
    params(
      name: Symbol,
      depth: Integer,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(name, depth, name_loc, value, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11321
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11326
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11336
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11331
  def compact_child_nodes; end

  # def copy: (**params) -> LocalVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#11341
  sig { params(params: T.untyped).returns(Prism::LocalVariableWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11326
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#11356
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # attr_reader depth: Integer
  #
  # source://prism//lib/prism/node.rb#11299
  sig { returns(Integer) }
  def depth; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#11366
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#11296
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#11302
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#11361
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#11308
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#11391
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#11305
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#11401
    def type; end
  end
end

# This represents a location in the source.
#
# source://prism//lib/prism/parse_result.rb#91
class Prism::Location
  # Create a new location object with the given source, start byte offset, and
  # byte length.
  #
  # @return [Location] a new instance of Location
  #
  # source://prism//lib/prism/parse_result.rb#108
  sig { params(source: Prism::Source, start_offset: Integer, length: Integer).void }
  def initialize(source, start_offset, length); end

  # Returns true if the given other location is equal to this location.
  #
  # source://prism//lib/prism/parse_result.rb#202
  def ==(other); end

  # The list of comments attached to this location
  #
  # source://prism//lib/prism/parse_result.rb#104
  sig { returns(T::Array[Prism::Comment]) }
  def comments; end

  # Create a new location object with the given options.
  #
  # source://prism//lib/prism/parse_result.rb#116
  sig { params(options: T.untyped).returns(Prism::Location) }
  def copy(**options); end

  # Implement the hash pattern matching interface for Location.
  #
  # source://prism//lib/prism/parse_result.rb#192
  def deconstruct_keys(keys); end

  # The column number in characters where this location ends from the start of
  # the line.
  #
  # source://prism//lib/prism/parse_result.rb#187
  def end_character_column; end

  # The character offset from the beginning of the source where this location
  # ends.
  #
  # source://prism//lib/prism/parse_result.rb#147
  def end_character_offset; end

  # The column number in bytes where this location ends from the start of the
  # line.
  #
  # source://prism//lib/prism/parse_result.rb#181
  sig { returns(Integer) }
  def end_column; end

  # The line number where this location ends.
  #
  # source://prism//lib/prism/parse_result.rb#163
  sig { returns(Integer) }
  def end_line; end

  # The byte offset from the beginning of the source where this location ends.
  #
  # source://prism//lib/prism/parse_result.rb#141
  sig { returns(Integer) }
  def end_offset; end

  # Returns a string representation of this location.
  #
  # source://prism//lib/prism/parse_result.rb#125
  def inspect; end

  # Returns a new location that stretches from this location to the given
  # other location. Raises an error if this location is not before the other
  # location or if they don't share the same source.
  #
  # source://prism//lib/prism/parse_result.rb#211
  def join(other); end

  # The length of this location in bytes.
  #
  # source://prism//lib/prism/parse_result.rb#101
  def length; end

  # Implement the pretty print interface for Location.
  #
  # source://prism//lib/prism/parse_result.rb#197
  def pretty_print(q); end

  # The source code that this location represents.
  #
  # source://prism//lib/prism/parse_result.rb#130
  sig { returns(String) }
  def slice; end

  # The column number in characters where this location ends from the start of
  # the line.
  #
  # source://prism//lib/prism/parse_result.rb#175
  def start_character_column; end

  # The character offset from the beginning of the source where this location
  # starts.
  #
  # source://prism//lib/prism/parse_result.rb#136
  def start_character_offset; end

  # The column number in bytes where this location starts from the start of
  # the line.
  #
  # source://prism//lib/prism/parse_result.rb#169
  sig { returns(Integer) }
  def start_column; end

  # The line number where this location starts.
  #
  # source://prism//lib/prism/parse_result.rb#152
  sig { returns(Integer) }
  def start_line; end

  # The content of the line where this location starts before this location.
  #
  # source://prism//lib/prism/parse_result.rb#157
  def start_line_slice; end

  # The byte offset from the beginning of the source where this location
  # starts.
  #
  # source://prism//lib/prism/parse_result.rb#98
  sig { returns(Integer) }
  def start_offset; end

  protected

  # Returns the value of attribute source.
  #
  # source://prism//lib/prism/parse_result.rb#94
  def source; end

  class << self
    # Returns a null location that does not correspond to a source and points to
    # the beginning of the file. Useful for when you want a location object but
    # do not care where it points.
    #
    # source://prism//lib/prism/parse_result.rb#221
    def null; end
  end
end

# Flags for while and until loop nodes.
#
# source://prism//lib/prism/node.rb#17331
module Prism::LoopFlags; end

# a loop after a begin statement, so the body is executed first before the condition
#
# source://prism//lib/prism/node.rb#17333
Prism::LoopFlags::BEGIN_MODIFIER = T.let(T.unsafe(nil), Integer)

# This represents a magic comment that was encountered during parsing.
#
# source://prism//lib/prism/parse_result.rb#273
class Prism::MagicComment
  # Create a new magic comment object with the given key and value locations.
  #
  # @return [MagicComment] a new instance of MagicComment
  #
  # source://prism//lib/prism/parse_result.rb#281
  def initialize(key_loc, value_loc); end

  # Implement the hash pattern matching interface for MagicComment.
  #
  # source://prism//lib/prism/parse_result.rb#297
  def deconstruct_keys(keys); end

  # Returns a string representation of this magic comment.
  #
  # source://prism//lib/prism/parse_result.rb#302
  def inspect; end

  # Returns the key of the magic comment by slicing it from the source code.
  #
  # source://prism//lib/prism/parse_result.rb#287
  def key; end

  # A Location object representing the location of the key in the source.
  #
  # source://prism//lib/prism/parse_result.rb#275
  def key_loc; end

  # Returns the value of the magic comment by slicing it from the source code.
  #
  # source://prism//lib/prism/parse_result.rb#292
  def value; end

  # A Location object representing the location of the value in the source.
  #
  # source://prism//lib/prism/parse_result.rb#278
  def value_loc; end
end

# Represents a regular expression literal used in the predicate of a
# conditional to implicitly match against the last line read by an IO
# object.
#
#     if /foo/i then end
#        ^^^^^^
#
# source://prism//lib/prism/node.rb#11413
class Prism::MatchLastLineNode < ::Prism::Node
  include ::Prism::RegularExpressionOptions

  # def initialize: (flags: Integer, opening_loc: Location, content_loc: Location, closing_loc: Location, unescaped: String, location: Location) -> void
  #
  # @return [MatchLastLineNode] a new instance of MatchLastLineNode
  #
  # source://prism//lib/prism/node.rb#11429
  sig do
    params(
      flags: Integer,
      opening_loc: Prism::Location,
      content_loc: Prism::Location,
      closing_loc: Prism::Location,
      unescaped: String,
      location: Prism::Location
    ).void
  end
  def initialize(flags, opening_loc, content_loc, closing_loc, unescaped, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11439
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def ascii_8bit?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11504
  sig { returns(T::Boolean) }
  def ascii_8bit?; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11444
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#11544
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#11423
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11454
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11449
  def compact_child_nodes; end

  # def content: () -> String
  #
  # source://prism//lib/prism/node.rb#11539
  sig { returns(String) }
  def content; end

  # attr_reader content_loc: Location
  #
  # source://prism//lib/prism/node.rb#11420
  sig { returns(Prism::Location) }
  def content_loc; end

  # def copy: (**params) -> MatchLastLineNode
  #
  # source://prism//lib/prism/node.rb#11459
  sig { params(params: T.untyped).returns(Prism::MatchLastLineNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11444
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#11474
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def euc_jp?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11499
  sig { returns(T::Boolean) }
  def euc_jp?; end

  # def extended?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11484
  sig { returns(T::Boolean) }
  def extended?; end

  # def forced_binary_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11524
  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  # def forced_us_ascii_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11529
  sig { returns(T::Boolean) }
  def forced_us_ascii_encoding?; end

  # def forced_utf8_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11519
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  # def ignore_case?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11479
  sig { returns(T::Boolean) }
  def ignore_case?; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#11549
  def inspect(inspector = T.unsafe(nil)); end

  # def multi_line?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11489
  sig { returns(T::Boolean) }
  def multi_line?; end

  # def once?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11494
  sig { returns(T::Boolean) }
  def once?; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#11534
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#11417
  sig { returns(Prism::Location) }
  def opening_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#11574
  def type; end

  # attr_reader unescaped: String
  #
  # source://prism//lib/prism/node.rb#11426
  sig { returns(String) }
  def unescaped; end

  # def utf_8?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11514
  sig { returns(T::Boolean) }
  def utf_8?; end

  # def windows_31j?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11509
  sig { returns(T::Boolean) }
  def windows_31j?; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#11414
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#11584
    def type; end
  end
end

# Represents the use of the modifier `in` operator.
#
#     foo in bar
#     ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#11594
class Prism::MatchPredicateNode < ::Prism::Node
  # def initialize: (value: Node, pattern: Node, operator_loc: Location, location: Location) -> void
  #
  # @return [MatchPredicateNode] a new instance of MatchPredicateNode
  #
  # source://prism//lib/prism/node.rb#11604
  sig do
    params(
      value: Prism::Node,
      pattern: Prism::Node,
      operator_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(value, pattern, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11612
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11617
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11627
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11622
  def compact_child_nodes; end

  # def copy: (**params) -> MatchPredicateNode
  #
  # source://prism//lib/prism/node.rb#11632
  sig { params(params: T.untyped).returns(Prism::MatchPredicateNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11617
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#11645
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#11655
  def inspect(inspector = T.unsafe(nil)); end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#11650
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#11601
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader pattern: Node
  #
  # source://prism//lib/prism/node.rb#11598
  sig { returns(Prism::Node) }
  def pattern; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#11679
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#11595
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#11689
    def type; end
  end
end

# Represents the use of the `=>` operator.
#
#     foo => bar
#     ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#11699
class Prism::MatchRequiredNode < ::Prism::Node
  # def initialize: (value: Node, pattern: Node, operator_loc: Location, location: Location) -> void
  #
  # @return [MatchRequiredNode] a new instance of MatchRequiredNode
  #
  # source://prism//lib/prism/node.rb#11709
  sig do
    params(
      value: Prism::Node,
      pattern: Prism::Node,
      operator_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(value, pattern, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11717
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11722
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11732
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11727
  def compact_child_nodes; end

  # def copy: (**params) -> MatchRequiredNode
  #
  # source://prism//lib/prism/node.rb#11737
  sig { params(params: T.untyped).returns(Prism::MatchRequiredNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11722
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#11750
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#11760
  def inspect(inspector = T.unsafe(nil)); end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#11755
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#11706
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader pattern: Node
  #
  # source://prism//lib/prism/node.rb#11703
  sig { returns(Prism::Node) }
  def pattern; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#11784
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#11700
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#11794
    def type; end
  end
end

# Represents writing local variables using a regular expression match with
# named capture groups.
#
#     /(?<foo>bar)/ =~ baz
#     ^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#11805
class Prism::MatchWriteNode < ::Prism::Node
  # def initialize: (call: CallNode, targets: Array[Node], location: Location) -> void
  #
  # @return [MatchWriteNode] a new instance of MatchWriteNode
  #
  # source://prism//lib/prism/node.rb#11812
  sig { params(call: Prism::CallNode, targets: T::Array[Prism::Node], location: Prism::Location).void }
  def initialize(call, targets, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11819
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader call: CallNode
  #
  # source://prism//lib/prism/node.rb#11806
  sig { returns(Prism::CallNode) }
  def call; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11824
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11834
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11829
  def compact_child_nodes; end

  # def copy: (**params) -> MatchWriteNode
  #
  # source://prism//lib/prism/node.rb#11839
  sig { params(params: T.untyped).returns(Prism::MatchWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11824
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#11851
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#11856
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader targets: Array[Node]
  #
  # source://prism//lib/prism/node.rb#11809
  sig { returns(T::Array[Prism::Node]) }
  def targets; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#11878
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#11888
    def type; end
  end
end

# Represents a node that is missing from the source and results in a syntax
# error.
#
# source://prism//lib/prism/node.rb#11896
class Prism::MissingNode < ::Prism::Node
  # def initialize: (location: Location) -> void
  #
  # @return [MissingNode] a new instance of MissingNode
  #
  # source://prism//lib/prism/node.rb#11897
  sig { params(location: Prism::Location).void }
  def initialize(location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11902
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11907
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11917
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11912
  def compact_child_nodes; end

  # def copy: (**params) -> MissingNode
  #
  # source://prism//lib/prism/node.rb#11922
  sig { params(params: T.untyped).returns(Prism::MissingNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11907
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#11932
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#11937
  def inspect(inspector = T.unsafe(nil)); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#11956
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#11966
    def type; end
  end
end

# Represents a module declaration involving the `module` keyword.
#
#     module Foo end
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#11976
class Prism::ModuleNode < ::Prism::Node
  # def initialize: (locals: Array[Symbol], module_keyword_loc: Location, constant_path: Node, body: Node?, end_keyword_loc: Location, name: Symbol, location: Location) -> void
  #
  # @return [ModuleNode] a new instance of ModuleNode
  #
  # source://prism//lib/prism/node.rb#11995
  sig do
    params(
      locals: T::Array[Symbol],
      module_keyword_loc: Prism::Location,
      constant_path: Prism::Node,
      body: T.nilable(Prism::Node),
      end_keyword_loc: Prism::Location,
      name: Symbol,
      location: Prism::Location
    ).void
  end
  def initialize(locals, module_keyword_loc, constant_path, body, end_keyword_loc, name, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12006
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader body: Node?
  #
  # source://prism//lib/prism/node.rb#11986
  sig { returns(T.nilable(Prism::Node)) }
  def body; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12011
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12024
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12016
  def compact_child_nodes; end

  # attr_reader constant_path: Node
  #
  # source://prism//lib/prism/node.rb#11983
  sig { returns(Prism::Node) }
  def constant_path; end

  # def copy: (**params) -> ModuleNode
  #
  # source://prism//lib/prism/node.rb#12029
  sig { params(params: T.untyped).returns(Prism::ModuleNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12011
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#12045
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#12055
  sig { returns(String) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#11989
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#12060
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader locals: Array[Symbol]
  #
  # source://prism//lib/prism/node.rb#11977
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # def module_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#12050
  sig { returns(String) }
  def module_keyword; end

  # attr_reader module_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#11980
  sig { returns(Prism::Location) }
  def module_keyword_loc; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#11992
  sig { returns(Symbol) }
  def name; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#12091
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#12101
    def type; end
  end
end

# Represents a multi-target expression.
#
#     a, (b, c) = 1, 2, 3
#        ^^^^^^
#
# source://prism//lib/prism/node.rb#12111
class Prism::MultiTargetNode < ::Prism::Node
  # def initialize: (lefts: Array[Node], rest: Node?, rights: Array[Node], lparen_loc: Location?, rparen_loc: Location?, location: Location) -> void
  #
  # @return [MultiTargetNode] a new instance of MultiTargetNode
  #
  # source://prism//lib/prism/node.rb#12127
  sig do
    params(
      lefts: T::Array[Prism::Node],
      rest: T.nilable(Prism::Node),
      rights: T::Array[Prism::Node],
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location),
      location: Prism::Location
    ).void
  end
  def initialize(lefts, rest, rights, lparen_loc, rparen_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12137
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12142
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12156
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12147
  def compact_child_nodes; end

  # def copy: (**params) -> MultiTargetNode
  #
  # source://prism//lib/prism/node.rb#12161
  sig { params(params: T.untyped).returns(Prism::MultiTargetNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12142
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#12176
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#12191
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader lefts: Array[Node]
  #
  # source://prism//lib/prism/node.rb#12112
  sig { returns(T::Array[Prism::Node]) }
  def lefts; end

  # def lparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#12181
  sig { returns(T.nilable(String)) }
  def lparen; end

  # attr_reader lparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#12121
  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  # attr_reader rest: Node?
  #
  # source://prism//lib/prism/node.rb#12115
  sig { returns(T.nilable(Prism::Node)) }
  def rest; end

  # attr_reader rights: Array[Node]
  #
  # source://prism//lib/prism/node.rb#12118
  sig { returns(T::Array[Prism::Node]) }
  def rights; end

  # def rparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#12186
  sig { returns(T.nilable(String)) }
  def rparen; end

  # attr_reader rparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#12124
  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#12220
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#12230
    def type; end
  end
end

# Represents a write to a multi-target expression.
#
#     a, b, c = 1, 2, 3
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#12240
class Prism::MultiWriteNode < ::Prism::Node
  # def initialize: (lefts: Array[Node], rest: Node?, rights: Array[Node], lparen_loc: Location?, rparen_loc: Location?, operator_loc: Location, value: Node, location: Location) -> void
  #
  # @return [MultiWriteNode] a new instance of MultiWriteNode
  #
  # source://prism//lib/prism/node.rb#12262
  sig do
    params(
      lefts: T::Array[Prism::Node],
      rest: T.nilable(Prism::Node),
      rights: T::Array[Prism::Node],
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location,
      value: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(lefts, rest, rights, lparen_loc, rparen_loc, operator_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12274
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12279
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12294
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12284
  def compact_child_nodes; end

  # def copy: (**params) -> MultiWriteNode
  #
  # source://prism//lib/prism/node.rb#12299
  sig { params(params: T.untyped).returns(Prism::MultiWriteNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12279
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#12316
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#12336
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader lefts: Array[Node]
  #
  # source://prism//lib/prism/node.rb#12241
  sig { returns(T::Array[Prism::Node]) }
  def lefts; end

  # def lparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#12321
  sig { returns(T.nilable(String)) }
  def lparen; end

  # attr_reader lparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#12250
  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#12331
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#12256
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader rest: Node?
  #
  # source://prism//lib/prism/node.rb#12244
  sig { returns(T.nilable(Prism::Node)) }
  def rest; end

  # attr_reader rights: Array[Node]
  #
  # source://prism//lib/prism/node.rb#12247
  sig { returns(T::Array[Prism::Node]) }
  def rights; end

  # def rparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#12326
  sig { returns(T.nilable(String)) }
  def rparen; end

  # attr_reader rparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#12253
  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#12368
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#12259
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#12378
    def type; end
  end
end

# This visitor walks through the tree and copies each node as it is being
# visited. This is useful for consumers that want to mutate the tree, as you
# can change subtrees in place without effecting the rest of the tree.
#
# source://prism//lib/prism/mutation_compiler.rb#13
class Prism::MutationCompiler < ::Prism::Compiler
  # Copy a AliasGlobalVariableNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#14
  def visit_alias_global_variable_node(node); end

  # Copy a AliasMethodNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#19
  def visit_alias_method_node(node); end

  # Copy a AlternationPatternNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#24
  def visit_alternation_pattern_node(node); end

  # Copy a AndNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#29
  def visit_and_node(node); end

  # Copy a ArgumentsNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#34
  def visit_arguments_node(node); end

  # Copy a ArrayNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#39
  def visit_array_node(node); end

  # Copy a ArrayPatternNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#44
  def visit_array_pattern_node(node); end

  # Copy a AssocNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#49
  def visit_assoc_node(node); end

  # Copy a AssocSplatNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#54
  def visit_assoc_splat_node(node); end

  # Copy a BackReferenceReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#59
  def visit_back_reference_read_node(node); end

  # Copy a BeginNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#64
  def visit_begin_node(node); end

  # Copy a BlockArgumentNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#69
  def visit_block_argument_node(node); end

  # Copy a BlockLocalVariableNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#74
  def visit_block_local_variable_node(node); end

  # Copy a BlockNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#79
  def visit_block_node(node); end

  # Copy a BlockParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#84
  def visit_block_parameter_node(node); end

  # Copy a BlockParametersNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#89
  def visit_block_parameters_node(node); end

  # Copy a BreakNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#94
  def visit_break_node(node); end

  # Copy a CallAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#99
  def visit_call_and_write_node(node); end

  # Copy a CallNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#104
  def visit_call_node(node); end

  # Copy a CallOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#109
  def visit_call_operator_write_node(node); end

  # Copy a CallOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#114
  def visit_call_or_write_node(node); end

  # Copy a CallTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#119
  def visit_call_target_node(node); end

  # Copy a CapturePatternNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#124
  def visit_capture_pattern_node(node); end

  # Copy a CaseMatchNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#129
  def visit_case_match_node(node); end

  # Copy a CaseNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#134
  def visit_case_node(node); end

  # Copy a ClassNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#139
  def visit_class_node(node); end

  # Copy a ClassVariableAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#144
  def visit_class_variable_and_write_node(node); end

  # Copy a ClassVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#149
  def visit_class_variable_operator_write_node(node); end

  # Copy a ClassVariableOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#154
  def visit_class_variable_or_write_node(node); end

  # Copy a ClassVariableReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#159
  def visit_class_variable_read_node(node); end

  # Copy a ClassVariableTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#164
  def visit_class_variable_target_node(node); end

  # Copy a ClassVariableWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#169
  def visit_class_variable_write_node(node); end

  # Copy a ConstantAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#174
  def visit_constant_and_write_node(node); end

  # Copy a ConstantOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#179
  def visit_constant_operator_write_node(node); end

  # Copy a ConstantOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#184
  def visit_constant_or_write_node(node); end

  # Copy a ConstantPathAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#189
  def visit_constant_path_and_write_node(node); end

  # Copy a ConstantPathNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#194
  def visit_constant_path_node(node); end

  # Copy a ConstantPathOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#199
  def visit_constant_path_operator_write_node(node); end

  # Copy a ConstantPathOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#204
  def visit_constant_path_or_write_node(node); end

  # Copy a ConstantPathTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#209
  def visit_constant_path_target_node(node); end

  # Copy a ConstantPathWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#214
  def visit_constant_path_write_node(node); end

  # Copy a ConstantReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#219
  def visit_constant_read_node(node); end

  # Copy a ConstantTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#224
  def visit_constant_target_node(node); end

  # Copy a ConstantWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#229
  def visit_constant_write_node(node); end

  # Copy a DefNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#234
  def visit_def_node(node); end

  # Copy a DefinedNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#239
  def visit_defined_node(node); end

  # Copy a ElseNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#244
  def visit_else_node(node); end

  # Copy a EmbeddedStatementsNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#249
  def visit_embedded_statements_node(node); end

  # Copy a EmbeddedVariableNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#254
  def visit_embedded_variable_node(node); end

  # Copy a EnsureNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#259
  def visit_ensure_node(node); end

  # Copy a FalseNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#264
  def visit_false_node(node); end

  # Copy a FindPatternNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#269
  def visit_find_pattern_node(node); end

  # Copy a FlipFlopNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#274
  def visit_flip_flop_node(node); end

  # Copy a FloatNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#279
  def visit_float_node(node); end

  # Copy a ForNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#284
  def visit_for_node(node); end

  # Copy a ForwardingArgumentsNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#289
  def visit_forwarding_arguments_node(node); end

  # Copy a ForwardingParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#294
  def visit_forwarding_parameter_node(node); end

  # Copy a ForwardingSuperNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#299
  def visit_forwarding_super_node(node); end

  # Copy a GlobalVariableAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#304
  def visit_global_variable_and_write_node(node); end

  # Copy a GlobalVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#309
  def visit_global_variable_operator_write_node(node); end

  # Copy a GlobalVariableOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#314
  def visit_global_variable_or_write_node(node); end

  # Copy a GlobalVariableReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#319
  def visit_global_variable_read_node(node); end

  # Copy a GlobalVariableTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#324
  def visit_global_variable_target_node(node); end

  # Copy a GlobalVariableWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#329
  def visit_global_variable_write_node(node); end

  # Copy a HashNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#334
  def visit_hash_node(node); end

  # Copy a HashPatternNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#339
  def visit_hash_pattern_node(node); end

  # Copy a IfNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#344
  def visit_if_node(node); end

  # Copy a ImaginaryNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#349
  def visit_imaginary_node(node); end

  # Copy a ImplicitNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#354
  def visit_implicit_node(node); end

  # Copy a ImplicitRestNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#359
  def visit_implicit_rest_node(node); end

  # Copy a InNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#364
  def visit_in_node(node); end

  # Copy a IndexAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#369
  def visit_index_and_write_node(node); end

  # Copy a IndexOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#374
  def visit_index_operator_write_node(node); end

  # Copy a IndexOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#379
  def visit_index_or_write_node(node); end

  # Copy a IndexTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#384
  def visit_index_target_node(node); end

  # Copy a InstanceVariableAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#389
  def visit_instance_variable_and_write_node(node); end

  # Copy a InstanceVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#394
  def visit_instance_variable_operator_write_node(node); end

  # Copy a InstanceVariableOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#399
  def visit_instance_variable_or_write_node(node); end

  # Copy a InstanceVariableReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#404
  def visit_instance_variable_read_node(node); end

  # Copy a InstanceVariableTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#409
  def visit_instance_variable_target_node(node); end

  # Copy a InstanceVariableWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#414
  def visit_instance_variable_write_node(node); end

  # Copy a IntegerNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#419
  def visit_integer_node(node); end

  # Copy a InterpolatedMatchLastLineNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#424
  def visit_interpolated_match_last_line_node(node); end

  # Copy a InterpolatedRegularExpressionNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#429
  def visit_interpolated_regular_expression_node(node); end

  # Copy a InterpolatedStringNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#434
  def visit_interpolated_string_node(node); end

  # Copy a InterpolatedSymbolNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#439
  def visit_interpolated_symbol_node(node); end

  # Copy a InterpolatedXStringNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#444
  def visit_interpolated_x_string_node(node); end

  # Copy a KeywordHashNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#449
  def visit_keyword_hash_node(node); end

  # Copy a KeywordRestParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#454
  def visit_keyword_rest_parameter_node(node); end

  # Copy a LambdaNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#459
  def visit_lambda_node(node); end

  # Copy a LocalVariableAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#464
  def visit_local_variable_and_write_node(node); end

  # Copy a LocalVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#469
  def visit_local_variable_operator_write_node(node); end

  # Copy a LocalVariableOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#474
  def visit_local_variable_or_write_node(node); end

  # Copy a LocalVariableReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#479
  def visit_local_variable_read_node(node); end

  # Copy a LocalVariableTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#484
  def visit_local_variable_target_node(node); end

  # Copy a LocalVariableWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#489
  def visit_local_variable_write_node(node); end

  # Copy a MatchLastLineNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#494
  def visit_match_last_line_node(node); end

  # Copy a MatchPredicateNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#499
  def visit_match_predicate_node(node); end

  # Copy a MatchRequiredNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#504
  def visit_match_required_node(node); end

  # Copy a MatchWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#509
  def visit_match_write_node(node); end

  # Copy a MissingNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#514
  def visit_missing_node(node); end

  # Copy a ModuleNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#519
  def visit_module_node(node); end

  # Copy a MultiTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#524
  def visit_multi_target_node(node); end

  # Copy a MultiWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#529
  def visit_multi_write_node(node); end

  # Copy a NextNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#534
  def visit_next_node(node); end

  # Copy a NilNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#539
  def visit_nil_node(node); end

  # Copy a NoKeywordsParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#544
  def visit_no_keywords_parameter_node(node); end

  # Copy a NumberedParametersNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#549
  def visit_numbered_parameters_node(node); end

  # Copy a NumberedReferenceReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#554
  def visit_numbered_reference_read_node(node); end

  # Copy a OptionalKeywordParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#559
  def visit_optional_keyword_parameter_node(node); end

  # Copy a OptionalParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#564
  def visit_optional_parameter_node(node); end

  # Copy a OrNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#569
  def visit_or_node(node); end

  # Copy a ParametersNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#574
  def visit_parameters_node(node); end

  # Copy a ParenthesesNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#579
  def visit_parentheses_node(node); end

  # Copy a PinnedExpressionNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#584
  def visit_pinned_expression_node(node); end

  # Copy a PinnedVariableNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#589
  def visit_pinned_variable_node(node); end

  # Copy a PostExecutionNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#594
  def visit_post_execution_node(node); end

  # Copy a PreExecutionNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#599
  def visit_pre_execution_node(node); end

  # Copy a ProgramNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#604
  def visit_program_node(node); end

  # Copy a RangeNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#609
  def visit_range_node(node); end

  # Copy a RationalNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#614
  def visit_rational_node(node); end

  # Copy a RedoNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#619
  def visit_redo_node(node); end

  # Copy a RegularExpressionNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#624
  def visit_regular_expression_node(node); end

  # Copy a RequiredKeywordParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#629
  def visit_required_keyword_parameter_node(node); end

  # Copy a RequiredParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#634
  def visit_required_parameter_node(node); end

  # Copy a RescueModifierNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#639
  def visit_rescue_modifier_node(node); end

  # Copy a RescueNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#644
  def visit_rescue_node(node); end

  # Copy a RestParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#649
  def visit_rest_parameter_node(node); end

  # Copy a RetryNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#654
  def visit_retry_node(node); end

  # Copy a ReturnNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#659
  def visit_return_node(node); end

  # Copy a SelfNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#664
  def visit_self_node(node); end

  # Copy a SingletonClassNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#669
  def visit_singleton_class_node(node); end

  # Copy a SourceEncodingNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#674
  def visit_source_encoding_node(node); end

  # Copy a SourceFileNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#679
  def visit_source_file_node(node); end

  # Copy a SourceLineNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#684
  def visit_source_line_node(node); end

  # Copy a SplatNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#689
  def visit_splat_node(node); end

  # Copy a StatementsNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#694
  def visit_statements_node(node); end

  # Copy a StringNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#699
  def visit_string_node(node); end

  # Copy a SuperNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#704
  def visit_super_node(node); end

  # Copy a SymbolNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#709
  def visit_symbol_node(node); end

  # Copy a TrueNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#714
  def visit_true_node(node); end

  # Copy a UndefNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#719
  def visit_undef_node(node); end

  # Copy a UnlessNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#724
  def visit_unless_node(node); end

  # Copy a UntilNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#729
  def visit_until_node(node); end

  # Copy a WhenNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#734
  def visit_when_node(node); end

  # Copy a WhileNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#739
  def visit_while_node(node); end

  # Copy a XStringNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#744
  def visit_x_string_node(node); end

  # Copy a YieldNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#749
  def visit_yield_node(node); end
end

# Represents the use of the `next` keyword.
#
#     next 1
#     ^^^^^^
#
# source://prism//lib/prism/node.rb#12388
class Prism::NextNode < ::Prism::Node
  # def initialize: (arguments: ArgumentsNode?, keyword_loc: Location, location: Location) -> void
  #
  # @return [NextNode] a new instance of NextNode
  #
  # source://prism//lib/prism/node.rb#12395
  sig do
    params(
      arguments: T.nilable(Prism::ArgumentsNode),
      keyword_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(arguments, keyword_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12402
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#12389
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12407
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12419
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12412
  def compact_child_nodes; end

  # def copy: (**params) -> NextNode
  #
  # source://prism//lib/prism/node.rb#12424
  sig { params(params: T.untyped).returns(Prism::NextNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12407
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#12436
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#12446
  def inspect(inspector = T.unsafe(nil)); end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#12441
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#12392
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#12472
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#12482
    def type; end
  end
end

# Represents the use of the `nil` keyword.
#
#     nil
#     ^^^
#
# source://prism//lib/prism/node.rb#12492
class Prism::NilNode < ::Prism::Node
  # def initialize: (location: Location) -> void
  #
  # @return [NilNode] a new instance of NilNode
  #
  # source://prism//lib/prism/node.rb#12493
  sig { params(location: Prism::Location).void }
  def initialize(location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12498
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12503
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12513
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12508
  def compact_child_nodes; end

  # def copy: (**params) -> NilNode
  #
  # source://prism//lib/prism/node.rb#12518
  sig { params(params: T.untyped).returns(Prism::NilNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12503
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#12528
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#12533
  def inspect(inspector = T.unsafe(nil)); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#12552
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#12562
    def type; end
  end
end

# Represents the use of `**nil` inside method arguments.
#
#     def a(**nil)
#           ^^^^^
#     end
#
# source://prism//lib/prism/node.rb#12573
class Prism::NoKeywordsParameterNode < ::Prism::Node
  # def initialize: (operator_loc: Location, keyword_loc: Location, location: Location) -> void
  #
  # @return [NoKeywordsParameterNode] a new instance of NoKeywordsParameterNode
  #
  # source://prism//lib/prism/node.rb#12580
  sig { params(operator_loc: Prism::Location, keyword_loc: Prism::Location, location: Prism::Location).void }
  def initialize(operator_loc, keyword_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12587
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12592
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12602
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12597
  def compact_child_nodes; end

  # def copy: (**params) -> NoKeywordsParameterNode
  #
  # source://prism//lib/prism/node.rb#12607
  sig { params(params: T.untyped).returns(Prism::NoKeywordsParameterNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12592
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#12619
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#12634
  def inspect(inspector = T.unsafe(nil)); end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#12629
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#12577
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#12624
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#12574
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#12655
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#12665
    def type; end
  end
end

# This represents a node in the tree. It is the parent class of all of the
# various node types.
#
# source://prism//lib/prism/node.rb#11
class Prism::Node
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # A Location instance that represents the location of this node in the
  # source.
  #
  # source://prism//lib/prism/node.rb#14
  sig { returns(Prism::Location) }
  def location; end

  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16
  def newline?; end

  # Similar to inspect, but respects the current level of indentation given by
  # the pretty print object.
  #
  # source://prism//lib/prism/node.rb#35
  def pretty_print(q); end

  # source://prism//lib/prism/node.rb#20
  def set_newline_flag(newline_marked); end

  # Slice the location of the node from the source.
  #
  # source://prism//lib/prism/node.rb#29
  sig { returns(String) }
  def slice; end

  # Convert this node into a graphviz dot graph string.
  #
  # source://prism//lib/prism/node.rb#43
  sig { returns(String) }
  def to_dot; end
end

# This object is responsible for generating the output for the inspect method
# implementations of child nodes.
#
# source://prism//lib/prism/node_inspector.rb#6
class Prism::NodeInspector
  # @return [NodeInspector] a new instance of NodeInspector
  #
  # source://prism//lib/prism/node_inspector.rb#9
  def initialize(prefix = T.unsafe(nil)); end

  # Appends a line to the output with the current prefix.
  #
  # source://prism//lib/prism/node_inspector.rb#15
  sig { params(line: String).void }
  def <<(line); end

  # Returns a new inspector that can be used to inspect a child node.
  #
  # source://prism//lib/prism/node_inspector.rb#59
  sig { params(append: String).returns(Prism::NodeInspector) }
  def child_inspector(append); end

  # Generates a string that represents a child node.
  #
  # source://prism//lib/prism/node_inspector.rb#54
  sig { params(node: Prism::Node, append: String).returns(String) }
  def child_node(node, append); end

  # This generates a string that is used as the header of the inspect output
  # for any given node.
  #
  # source://prism//lib/prism/node_inspector.rb#21
  # This generates a string that is used as the header of the inspect output
  sig { params(node: Prism::Node).returns(String) }
  def header(node); end

  # Generates a string that represents a list of nodes. It handles properly
  # using the box drawing characters to make the output look nice.
  #
  # source://prism//lib/prism/node_inspector.rb#31
  # Generates a string that represents a list of nodes. It handles properly
  sig { params(prefix: String, nodes: T::Array[Prism::Node]).returns(String) }
  def list(prefix, nodes); end

  # Generates a string that represents a location field on a node.
  #
  # source://prism//lib/prism/node_inspector.rb#45
  sig { params(value: Prism::Location).returns(String) }
  def location(value); end

  # source://prism//lib/prism/node_inspector.rb#7
  sig { returns(String) }
  def output; end

  # source://prism//lib/prism/node_inspector.rb#7
  sig { returns(String) }
  def prefix; end

  # Returns the output as a string.
  #
  # source://prism//lib/prism/node_inspector.rb#64
  sig { returns(String) }
  def to_str; end
end

# Represents an implicit set of parameters through the use of numbered
# parameters within a block or lambda.
#
#     -> { _1 + _2 }
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#12676
class Prism::NumberedParametersNode < ::Prism::Node
  # def initialize: (maximum: Integer, location: Location) -> void
  #
  # @return [NumberedParametersNode] a new instance of NumberedParametersNode
  #
  # source://prism//lib/prism/node.rb#12680
  sig { params(maximum: Integer, location: Prism::Location).void }
  def initialize(maximum, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12686
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12691
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12701
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12696
  def compact_child_nodes; end

  # def copy: (**params) -> NumberedParametersNode
  #
  # source://prism//lib/prism/node.rb#12706
  sig { params(params: T.untyped).returns(Prism::NumberedParametersNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12691
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#12717
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#12722
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader maximum: Integer
  #
  # source://prism//lib/prism/node.rb#12677
  sig { returns(Integer) }
  def maximum; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#12742
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#12752
    def type; end
  end
end

# Represents reading a numbered reference to a capture in the previous match.
#
#     $1
#     ^^
#
# source://prism//lib/prism/node.rb#12762
class Prism::NumberedReferenceReadNode < ::Prism::Node
  # def initialize: (number: Integer, location: Location) -> void
  #
  # @return [NumberedReferenceReadNode] a new instance of NumberedReferenceReadNode
  #
  # source://prism//lib/prism/node.rb#12766
  sig { params(number: Integer, location: Prism::Location).void }
  def initialize(number, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12772
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12777
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12787
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12782
  def compact_child_nodes; end

  # def copy: (**params) -> NumberedReferenceReadNode
  #
  # source://prism//lib/prism/node.rb#12792
  sig { params(params: T.untyped).returns(Prism::NumberedReferenceReadNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12777
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#12803
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#12808
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader number: Integer
  #
  # source://prism//lib/prism/node.rb#12763
  sig { returns(Integer) }
  def number; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#12828
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#12838
    def type; end
  end
end

# Represents an optional keyword parameter to a method, block, or lambda definition.
#
#     def a(b: 1)
#           ^^^^
#     end
#
# source://prism//lib/prism/node.rb#12849
class Prism::OptionalKeywordParameterNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, value: Node, location: Location) -> void
  #
  # @return [OptionalKeywordParameterNode] a new instance of OptionalKeywordParameterNode
  #
  # source://prism//lib/prism/node.rb#12859
  sig { params(name: Symbol, name_loc: Prism::Location, value: Prism::Node, location: Prism::Location).void }
  def initialize(name, name_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12867
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12872
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12882
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12877
  def compact_child_nodes; end

  # def copy: (**params) -> OptionalKeywordParameterNode
  #
  # source://prism//lib/prism/node.rb#12887
  sig { params(params: T.untyped).returns(Prism::OptionalKeywordParameterNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12872
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#12900
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#12905
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#12850
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#12853
  sig { returns(Prism::Location) }
  def name_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#12928
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#12856
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#12938
    def type; end
  end
end

# Represents an optional parameter to a method, block, or lambda definition.
#
#     def a(b = 1)
#           ^^^^^
#     end
#
# source://prism//lib/prism/node.rb#12949
class Prism::OptionalParameterNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, operator_loc: Location, value: Node, location: Location) -> void
  #
  # @return [OptionalParameterNode] a new instance of OptionalParameterNode
  #
  # source://prism//lib/prism/node.rb#12962
  sig do
    params(
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, operator_loc, value, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12971
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12976
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12986
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12981
  def compact_child_nodes; end

  # def copy: (**params) -> OptionalParameterNode
  #
  # source://prism//lib/prism/node.rb#12991
  sig { params(params: T.untyped).returns(Prism::OptionalParameterNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12976
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#13005
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#13015
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#12950
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#12953
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#13010
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#12956
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#13039
  def type; end

  # attr_reader value: Node
  #
  # source://prism//lib/prism/node.rb#12959
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#13049
    def type; end
  end
end

# Represents the use of the `||` operator or the `or` keyword.
#
#     left or right
#     ^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#13059
class Prism::OrNode < ::Prism::Node
  # def initialize: (left: Node, right: Node, operator_loc: Location, location: Location) -> void
  #
  # @return [OrNode] a new instance of OrNode
  #
  # source://prism//lib/prism/node.rb#13069
  sig { params(left: Prism::Node, right: Prism::Node, operator_loc: Prism::Location, location: Prism::Location).void }
  def initialize(left, right, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13077
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13082
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13092
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13087
  def compact_child_nodes; end

  # def copy: (**params) -> OrNode
  #
  # source://prism//lib/prism/node.rb#13097
  sig { params(params: T.untyped).returns(Prism::OrNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13082
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#13110
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#13120
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader left: Node
  #
  # source://prism//lib/prism/node.rb#13060
  sig { returns(Prism::Node) }
  def left; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#13115
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#13066
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader right: Node
  #
  # source://prism//lib/prism/node.rb#13063
  sig { returns(Prism::Node) }
  def right; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#13144
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#13154
    def type; end
  end
end

# A parser for the pack template language.
#
# source://prism//lib/prism/pack.rb#5
module Prism::Pack
  class << self
    def parse(_arg0, _arg1, _arg2); end
  end
end

# source://prism//lib/prism/pack.rb#55
Prism::Pack::AGNOSTIC_ENDIAN = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::BACK = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::BER = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::BIG_ENDIAN = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::COMMENT = T.let(T.unsafe(nil), Symbol)

# A directive in the pack template language.
#
# source://prism//lib/prism/pack.rb#59
class Prism::Pack::Directive
  # Initialize a new directive with the given values.
  #
  # @return [Directive] a new instance of Directive
  #
  # source://prism//lib/prism/pack.rb#88
  def initialize(version, variant, source, type, signed, endian, size, length_type, length); end

  # Provide a human-readable description of the directive.
  #
  # source://prism//lib/prism/pack.rb#130
  def describe; end

  # The type of endianness of the directive.
  #
  # source://prism//lib/prism/pack.rb#76
  def endian; end

  # The length of this directive (used for integers).
  #
  # source://prism//lib/prism/pack.rb#85
  def length; end

  # The length type of this directive (used for integers).
  #
  # source://prism//lib/prism/pack.rb#82
  def length_type; end

  # The type of signedness of the directive.
  #
  # source://prism//lib/prism/pack.rb#73
  def signed; end

  # The size of the directive.
  #
  # source://prism//lib/prism/pack.rb#79
  def size; end

  # A byteslice of the source string that this directive represents.
  #
  # source://prism//lib/prism/pack.rb#67
  def source; end

  # The type of the directive.
  #
  # source://prism//lib/prism/pack.rb#70
  def type; end

  # A symbol representing whether or not we are packing or unpacking.
  #
  # source://prism//lib/prism/pack.rb#64
  def variant; end

  # A symbol representing the version of Ruby.
  #
  # source://prism//lib/prism/pack.rb#61
  def version; end
end

# The descriptions of the various types of endianness.
#
# source://prism//lib/prism/pack.rb#101
Prism::Pack::Directive::ENDIAN_DESCRIPTIONS = T.let(T.unsafe(nil), Hash)

# The descriptions of the various types of signedness.
#
# source://prism//lib/prism/pack.rb#110
Prism::Pack::Directive::SIGNED_DESCRIPTIONS = T.let(T.unsafe(nil), Hash)

# The descriptions of the various types of sizes.
#
# source://prism//lib/prism/pack.rb#117
Prism::Pack::Directive::SIZE_DESCRIPTIONS = T.let(T.unsafe(nil), Hash)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::ENDIAN_NA = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::FLOAT = T.let(T.unsafe(nil), Symbol)

# The result of parsing a pack template.
#
# source://prism//lib/prism/pack.rb#195
class Prism::Pack::Format
  # Create a new Format with the given directives and encoding.
  #
  # @return [Format] a new instance of Format
  #
  # source://prism//lib/prism/pack.rb#203
  def initialize(directives, encoding); end

  # Provide a human-readable description of the format.
  #
  # source://prism//lib/prism/pack.rb#209
  def describe; end

  # A list of the directives in the template.
  #
  # source://prism//lib/prism/pack.rb#197
  def directives; end

  # The encoding of the template.
  #
  # source://prism//lib/prism/pack.rb#200
  def encoding; end
end

# source://prism//lib/prism/pack.rb#55
Prism::Pack::INTEGER = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::LENGTH_FIXED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::LENGTH_MAX = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::LENGTH_NA = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::LENGTH_RELATIVE = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::LITTLE_ENDIAN = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::MOVE = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::NATIVE_ENDIAN = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::NULL = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::SIGNED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::SIGNED_NA = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::SIZE_16 = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::SIZE_32 = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::SIZE_64 = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::SIZE_8 = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::SIZE_INT = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::SIZE_LONG = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::SIZE_LONG_LONG = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::SIZE_NA = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::SIZE_P = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::SIZE_SHORT = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::SPACE = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::STRING_BASE64 = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::STRING_FIXED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::STRING_HEX_HIGH = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::STRING_HEX_LOW = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::STRING_LSB = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::STRING_MIME = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::STRING_MSB = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::STRING_NULL_PADDED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::STRING_NULL_TERMINATED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::STRING_POINTER = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::STRING_SPACE_PADDED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::STRING_UU = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::UNSIGNED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#55
Prism::Pack::UTF8 = T.let(T.unsafe(nil), Symbol)

# Represents the list of parameters on a method, block, or lambda definition.
#
#     def a(b, c, d)
#           ^^^^^^^
#     end
#
# source://prism//lib/prism/node.rb#13165
class Prism::ParametersNode < ::Prism::Node
  # def initialize: (requireds: Array[Node], optionals: Array[Node], rest: Node?, posts: Array[Node], keywords: Array[Node], keyword_rest: Node?, block: BlockParameterNode?, location: Location) -> void
  #
  # @return [ParametersNode] a new instance of ParametersNode
  #
  # source://prism//lib/prism/node.rb#13187
  sig do
    params(
      requireds: T::Array[Prism::Node],
      optionals: T::Array[Prism::Node],
      rest: T.nilable(Prism::Node),
      posts: T::Array[Prism::Node],
      keywords: T::Array[Prism::Node],
      keyword_rest: T.nilable(Prism::Node),
      block: T.nilable(Prism::BlockParameterNode),
      location: Prism::Location
    ).void
  end
  def initialize(requireds, optionals, rest, posts, keywords, keyword_rest, block, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13199
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader block: BlockParameterNode?
  #
  # source://prism//lib/prism/node.rb#13184
  sig { returns(T.nilable(Prism::BlockParameterNode)) }
  def block; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13204
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13222
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13209
  def compact_child_nodes; end

  # def copy: (**params) -> ParametersNode
  #
  # source://prism//lib/prism/node.rb#13227
  sig { params(params: T.untyped).returns(Prism::ParametersNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13204
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#13244
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#13249
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader keyword_rest: Node?
  #
  # source://prism//lib/prism/node.rb#13181
  sig { returns(T.nilable(Prism::Node)) }
  def keyword_rest; end

  # attr_reader keywords: Array[Node]
  #
  # source://prism//lib/prism/node.rb#13178
  sig { returns(T::Array[Prism::Node]) }
  def keywords; end

  # attr_reader optionals: Array[Node]
  #
  # source://prism//lib/prism/node.rb#13169
  sig { returns(T::Array[Prism::Node]) }
  def optionals; end

  # attr_reader posts: Array[Node]
  #
  # source://prism//lib/prism/node.rb#13175
  sig { returns(T::Array[Prism::Node]) }
  def posts; end

  # attr_reader requireds: Array[Node]
  #
  # source://prism//lib/prism/node.rb#13166
  sig { returns(T::Array[Prism::Node]) }
  def requireds; end

  # attr_reader rest: Node?
  #
  # source://prism//lib/prism/node.rb#13172
  sig { returns(T.nilable(Prism::Node)) }
  def rest; end

  # Mirrors the Method#parameters method.
  #
  # source://prism//lib/prism/node_ext.rb#149
  def signature; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#13290
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#13300
    def type; end
  end
end

# Represents a parenthesized expression
#
#     (10 + 34)
#     ^^^^^^^^^
#
# source://prism//lib/prism/node.rb#13310
class Prism::ParenthesesNode < ::Prism::Node
  # def initialize: (body: Node?, opening_loc: Location, closing_loc: Location, location: Location) -> void
  #
  # @return [ParenthesesNode] a new instance of ParenthesesNode
  #
  # source://prism//lib/prism/node.rb#13320
  sig do
    params(
      body: T.nilable(Prism::Node),
      opening_loc: Prism::Location,
      closing_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(body, opening_loc, closing_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13328
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader body: Node?
  #
  # source://prism//lib/prism/node.rb#13311
  sig { returns(T.nilable(Prism::Node)) }
  def body; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13337
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#13377
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#13317
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13349
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13342
  def compact_child_nodes; end

  # def copy: (**params) -> ParenthesesNode
  #
  # source://prism//lib/prism/node.rb#13354
  sig { params(params: T.untyped).returns(Prism::ParenthesesNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13337
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#13367
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#13382
  def inspect(inspector = T.unsafe(nil)); end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#13372
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#13314
  sig { returns(Prism::Location) }
  def opening_loc; end

  # source://prism//lib/prism/node.rb#13332
  def set_newline_flag(newline_marked); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#13409
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#13419
    def type; end
  end
end

# This represents an error that was encountered during parsing.
#
# source://prism//lib/prism/parse_result.rb#308
class Prism::ParseError
  # Create a new error object with the given message and location.
  #
  # @return [ParseError] a new instance of ParseError
  #
  # source://prism//lib/prism/parse_result.rb#316
  def initialize(message, location); end

  # Implement the hash pattern matching interface for ParseError.
  #
  # source://prism//lib/prism/parse_result.rb#322
  def deconstruct_keys(keys); end

  # Returns a string representation of this error.
  #
  # source://prism//lib/prism/parse_result.rb#327
  def inspect; end

  # A Location object representing the location of this error in the source.
  #
  # source://prism//lib/prism/parse_result.rb#313
  sig { returns(Prism::Location) }
  def location; end

  # The message associated with this error.
  #
  # source://prism//lib/prism/parse_result.rb#310
  sig { returns(String) }
  def message; end
end

# This represents the result of a call to ::parse or ::parse_file. It contains
# the AST, any comments that were encounters, and any errors that were
# encountered.
#
# source://prism//lib/prism/parse_result.rb#360
class Prism::ParseResult
  # Create a new parse result object with the given values.
  #
  # @return [ParseResult] a new instance of ParseResult
  #
  # source://prism//lib/prism/parse_result.rb#387
  def initialize(value, comments, magic_comments, data_loc, errors, warnings, source); end

  # Attach the list of comments to their respective locations in the tree.
  #
  # source://prism//lib/prism/parse_result/comments.rb#173
  def attach_comments!; end

  # The list of comments that were encountered during parsing.
  #
  # source://prism//lib/prism/parse_result.rb#367
  sig { returns(T::Array[Prism::Comment]) }
  def comments; end

  # An optional location that represents the location of the content after the
  # __END__ marker. This content is loaded into the DATA constant when the
  # file being parsed is the main file being executed.
  #
  # source://prism//lib/prism/parse_result.rb#375
  def data_loc; end

  # Implement the hash pattern matching interface for ParseResult.
  #
  # source://prism//lib/prism/parse_result.rb#398
  def deconstruct_keys(keys); end

  # The list of errors that were generated during parsing.
  #
  # source://prism//lib/prism/parse_result.rb#378
  sig { returns(T::Array[Prism::ParseError]) }
  def errors; end

  # Returns true if there were errors during parsing and false if there were
  # not.
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/parse_result.rb#410
  def failure?; end

  # The list of magic comments that were encountered during parsing.
  #
  # source://prism//lib/prism/parse_result.rb#370
  def magic_comments; end

  # Walk the tree and mark nodes that are on a new line.
  #
  # source://prism//lib/prism/parse_result/newlines.rb#60
  def mark_newlines!; end

  # A Source instance that represents the source code that was parsed.
  #
  # source://prism//lib/prism/parse_result.rb#384
  sig { returns(Prism::Source) }
  def source; end

  # Returns true if there were no errors during parsing and false if there
  # were.
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/parse_result.rb#404
  def success?; end

  # The value that was generated by parsing. Normally this holds the AST, but
  # it can sometimes how a list of tokens or other results passed back from
  # the parser.
  #
  # source://prism//lib/prism/parse_result.rb#364
  sig { returns(Prism::ProgramNode) }
  def value; end

  # The list of warnings that were generated during parsing.
  #
  # source://prism//lib/prism/parse_result.rb#381
  sig { returns(T::Array[Prism::ParseWarning]) }
  def warnings; end
end

# When we've parsed the source, we have both the syntax tree and the list of
# comments that we found in the source. This class is responsible for
# walking the tree and finding the nearest location to attach each comment.
#
# It does this by first finding the nearest locations to each comment.
# Locations can either come from nodes directly or from location fields on
# nodes. For example, a `ClassNode` has an overall location encompassing the
# entire class, but it also has a location for the `class` keyword.
#
# Once the nearest locations are found, it determines which one to attach
# to. If it's a trailing comment (a comment on the same line as other source
# code), it will favor attaching to the nearest location that occurs before
# the comment. Otherwise it will favor attaching to the nearest location
# that is after the comment.
#
# source://prism//lib/prism/parse_result/comments.rb#19
class Prism::ParseResult::Comments
  # Create a new Comments object that will attach comments to the given
  # parse result.
  #
  # @return [Comments] a new instance of Comments
  #
  # source://prism//lib/prism/parse_result/comments.rb#78
  def initialize(parse_result); end

  # Attach the comments to their respective locations in the tree by
  # mutating the parse result.
  #
  # source://prism//lib/prism/parse_result/comments.rb#84
  def attach!; end

  # The parse result that we are attaching comments to.
  #
  # source://prism//lib/prism/parse_result/comments.rb#74
  def parse_result; end

  private

  # Responsible for finding the nearest targets to the given comment within
  # the context of the given encapsulating node.
  #
  # source://prism//lib/prism/parse_result/comments.rb#103
  def nearest_targets(node, comment); end
end

# A target for attaching comments that is based on a location field on a
# node. For example, the `end` token of a ClassNode.
#
# source://prism//lib/prism/parse_result/comments.rb#49
class Prism::ParseResult::Comments::LocationTarget
  # @return [LocationTarget] a new instance of LocationTarget
  #
  # source://prism//lib/prism/parse_result/comments.rb#52
  def initialize(location); end

  # source://prism//lib/prism/parse_result/comments.rb#68
  def <<(comment); end

  # @return [Boolean]
  #
  # source://prism//lib/prism/parse_result/comments.rb#64
  def encloses?(comment); end

  # source://prism//lib/prism/parse_result/comments.rb#60
  def end_offset; end

  # source://prism//lib/prism/parse_result/comments.rb#50
  def location; end

  # source://prism//lib/prism/parse_result/comments.rb#56
  def start_offset; end
end

# A target for attaching comments that is based on a specific node's
# location.
#
# source://prism//lib/prism/parse_result/comments.rb#22
class Prism::ParseResult::Comments::NodeTarget
  # @return [NodeTarget] a new instance of NodeTarget
  #
  # source://prism//lib/prism/parse_result/comments.rb#25
  def initialize(node); end

  # source://prism//lib/prism/parse_result/comments.rb#42
  def <<(comment); end

  # @return [Boolean]
  #
  # source://prism//lib/prism/parse_result/comments.rb#37
  def encloses?(comment); end

  # source://prism//lib/prism/parse_result/comments.rb#33
  def end_offset; end

  # source://prism//lib/prism/parse_result/comments.rb#23
  def node; end

  # source://prism//lib/prism/parse_result/comments.rb#29
  def start_offset; end
end

# The :line tracepoint event gets fired whenever the Ruby VM encounters an
# expression on a new line. The types of expressions that can trigger this
# event are:
#
# * if statements
# * unless statements
# * nodes that are children of statements lists
#
# In order to keep track of the newlines, we have a list of offsets that
# come back from the parser. We assign these offsets to the first nodes that
# we find in the tree that are on those lines.
#
# Note that the logic in this file should be kept in sync with the Java
# MarkNewlinesVisitor, since that visitor is responsible for marking the
# newlines for JRuby/TruffleRuby.
#
# source://prism//lib/prism/parse_result/newlines.rb#21
class Prism::ParseResult::Newlines < ::Prism::Visitor
  # Create a new Newlines visitor with the given newline offsets.
  #
  # @return [Newlines] a new instance of Newlines
  #
  # source://prism//lib/prism/parse_result/newlines.rb#22
  def initialize(newline_marked); end

  # Permit block/lambda nodes to mark newlines within themselves.
  #
  # source://prism//lib/prism/parse_result/newlines.rb#27
  def visit_block_node(node); end

  # Mark if/unless nodes as newlines.
  #
  # source://prism//lib/prism/parse_result/newlines.rb#41
  def visit_if_node(node); end

  # Permit block/lambda nodes to mark newlines within themselves.
  #
  # source://prism//lib/prism/parse_result/newlines.rb#27
  def visit_lambda_node(node); end

  # Permit statements lists to mark newlines within themselves.
  #
  # source://prism//lib/prism/parse_result/newlines.rb#49
  def visit_statements_node(node); end

  # Mark if/unless nodes as newlines.
  #
  # source://prism//lib/prism/parse_result/newlines.rb#41
  def visit_unless_node(node); end
end

# This represents a warning that was encountered during parsing.
#
# source://prism//lib/prism/parse_result.rb#333
class Prism::ParseWarning
  # Create a new warning object with the given message and location.
  #
  # @return [ParseWarning] a new instance of ParseWarning
  #
  # source://prism//lib/prism/parse_result.rb#341
  def initialize(message, location); end

  # Implement the hash pattern matching interface for ParseWarning.
  #
  # source://prism//lib/prism/parse_result.rb#347
  def deconstruct_keys(keys); end

  # Returns a string representation of this warning.
  #
  # source://prism//lib/prism/parse_result.rb#352
  def inspect; end

  # A Location object representing the location of this warning in the source.
  #
  # source://prism//lib/prism/parse_result.rb#338
  sig { returns(Prism::Location) }
  def location; end

  # The message associated with this warning.
  #
  # source://prism//lib/prism/parse_result.rb#335
  sig { returns(String) }
  def message; end
end

# A pattern is an object that wraps a Ruby pattern matching expression. The
# expression would normally be passed to an `in` clause within a `case`
# expression or a rightward assignment expression. For example, in the
# following snippet:
#
#     case node
#     in ConstantPathNode[ConstantReadNode[name: :Prism], ConstantReadNode[name: :Pattern]]
#     end
#
# the pattern is the <tt>ConstantPathNode[...]</tt> expression.
#
# The pattern gets compiled into an object that responds to #call by running
# the #compile method. This method itself will run back through Prism to
# parse the expression into a tree, then walk the tree to generate the
# necessary callable objects. For example, if you wanted to compile the
# expression above into a callable, you would:
#
#     callable = Prism::Pattern.new("ConstantPathNode[ConstantReadNode[name: :Prism], ConstantReadNode[name: :Pattern]]").compile
#     callable.call(node)
#
# The callable object returned by #compile is guaranteed to respond to #call
# with a single argument, which is the node to match against. It also is
# guaranteed to respond to #===, which means it itself can be used in a `case`
# expression, as in:
#
#     case node
#     when callable
#     end
#
# If the query given to the initializer cannot be compiled into a valid
# matcher (either because of a syntax error or because it is using syntax we
# do not yet support) then a Prism::Pattern::CompilationError will be
# raised.
#
# source://prism//lib/prism/pattern.rb#37
class Prism::Pattern
  # Create a new pattern with the given query. The query should be a string
  # containing a Ruby pattern matching expression.
  #
  # @return [Pattern] a new instance of Pattern
  #
  # source://prism//lib/prism/pattern.rb#63
  def initialize(query); end

  # Compile the query into a callable object that can be used to match against
  # nodes.
  #
  # source://prism//lib/prism/pattern.rb#70
  def compile; end

  # The query that this pattern was initialized with.
  #
  # source://prism//lib/prism/pattern.rb#59
  def query; end

  # Scan the given node and all of its children for nodes that match the
  # pattern. If a block is given, it will be called with each node that
  # matches the pattern. If no block is given, an enumerator will be returned
  # that will yield each node that matches the pattern.
  #
  # source://prism//lib/prism/pattern.rb#79
  def scan(root); end

  private

  # Shortcut for combining two procs into one that returns true if both return
  # true.
  #
  # source://prism//lib/prism/pattern.rb#95
  def combine_and(left, right); end

  # Shortcut for combining two procs into one that returns true if either
  # returns true.
  #
  # source://prism//lib/prism/pattern.rb#101
  def combine_or(left, right); end

  # in foo | bar
  #
  # source://prism//lib/prism/pattern.rb#136
  def compile_alternation_pattern_node(node); end

  # in [foo, bar, baz]
  #
  # source://prism//lib/prism/pattern.rb#111
  def compile_array_pattern_node(node); end

  # in Prism::ConstantReadNode
  #
  # source://prism//lib/prism/pattern.rb#141
  def compile_constant_path_node(node); end

  # in ConstantReadNode
  # in String
  #
  # source://prism//lib/prism/pattern.rb#153
  def compile_constant_read_node(node); end

  # Raise an error because the given node is not supported.
  #
  # @raise [CompilationError]
  #
  # source://prism//lib/prism/pattern.rb#106
  def compile_error(node); end

  # in InstanceVariableReadNode[name: Symbol]
  # in { name: Symbol }
  #
  # source://prism//lib/prism/pattern.rb#171
  def compile_hash_pattern_node(node); end

  # in nil
  #
  # source://prism//lib/prism/pattern.rb#196
  def compile_nil_node(node); end

  # Compile any kind of node. Dispatch out to the individual compilation
  # methods based on the type of node.
  #
  # source://prism//lib/prism/pattern.rb#225
  def compile_node(node); end

  # in /foo/
  #
  # source://prism//lib/prism/pattern.rb#201
  def compile_regular_expression_node(node); end

  # in ""
  # in "foo"
  #
  # source://prism//lib/prism/pattern.rb#209
  def compile_string_node(node); end

  # in :+
  # in :foo
  #
  # source://prism//lib/prism/pattern.rb#217
  def compile_symbol_node(node); end
end

# Raised when the query given to a pattern is either invalid Ruby syntax or
# is using syntax that we don't yet support.
#
# source://prism//lib/prism/pattern.rb#42
class Prism::Pattern::CompilationError < ::StandardError
  # Create a new CompilationError with the given representation of the node
  # that caused the error.
  #
  # @return [CompilationError] a new instance of CompilationError
  #
  # source://prism//lib/prism/pattern.rb#43
  def initialize(repr); end
end

# Represents the use of the `^` operator for pinning an expression in a
# pattern matching expression.
#
#     foo in ^(bar)
#            ^^^^^^
#
# source://prism//lib/prism/node.rb#13430
class Prism::PinnedExpressionNode < ::Prism::Node
  # def initialize: (expression: Node, operator_loc: Location, lparen_loc: Location, rparen_loc: Location, location: Location) -> void
  #
  # @return [PinnedExpressionNode] a new instance of PinnedExpressionNode
  #
  # source://prism//lib/prism/node.rb#13443
  sig do
    params(
      expression: Prism::Node,
      operator_loc: Prism::Location,
      lparen_loc: Prism::Location,
      rparen_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(expression, operator_loc, lparen_loc, rparen_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13452
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13457
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13467
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13462
  def compact_child_nodes; end

  # def copy: (**params) -> PinnedExpressionNode
  #
  # source://prism//lib/prism/node.rb#13472
  sig { params(params: T.untyped).returns(Prism::PinnedExpressionNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13457
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#13486
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # attr_reader expression: Node
  #
  # source://prism//lib/prism/node.rb#13431
  sig { returns(Prism::Node) }
  def expression; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#13506
  def inspect(inspector = T.unsafe(nil)); end

  # def lparen: () -> String
  #
  # source://prism//lib/prism/node.rb#13496
  sig { returns(String) }
  def lparen; end

  # attr_reader lparen_loc: Location
  #
  # source://prism//lib/prism/node.rb#13437
  sig { returns(Prism::Location) }
  def lparen_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#13491
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#13434
  sig { returns(Prism::Location) }
  def operator_loc; end

  # def rparen: () -> String
  #
  # source://prism//lib/prism/node.rb#13501
  sig { returns(String) }
  def rparen; end

  # attr_reader rparen_loc: Location
  #
  # source://prism//lib/prism/node.rb#13440
  sig { returns(Prism::Location) }
  def rparen_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#13530
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#13540
    def type; end
  end
end

# Represents the use of the `^` operator for pinning a variable in a pattern
# matching expression.
#
#     foo in ^bar
#            ^^^^
#
# source://prism//lib/prism/node.rb#13551
class Prism::PinnedVariableNode < ::Prism::Node
  # def initialize: (variable: Node, operator_loc: Location, location: Location) -> void
  #
  # @return [PinnedVariableNode] a new instance of PinnedVariableNode
  #
  # source://prism//lib/prism/node.rb#13558
  sig { params(variable: Prism::Node, operator_loc: Prism::Location, location: Prism::Location).void }
  def initialize(variable, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13565
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13570
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13580
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13575
  def compact_child_nodes; end

  # def copy: (**params) -> PinnedVariableNode
  #
  # source://prism//lib/prism/node.rb#13585
  sig { params(params: T.untyped).returns(Prism::PinnedVariableNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13570
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#13597
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#13607
  def inspect(inspector = T.unsafe(nil)); end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#13602
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#13555
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#13629
  def type; end

  # attr_reader variable: Node
  #
  # source://prism//lib/prism/node.rb#13552
  sig { returns(Prism::Node) }
  def variable; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#13639
    def type; end
  end
end

# Represents the use of the `END` keyword.
#
#     END { foo }
#     ^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#13649
class Prism::PostExecutionNode < ::Prism::Node
  # def initialize: (statements: StatementsNode?, keyword_loc: Location, opening_loc: Location, closing_loc: Location, location: Location) -> void
  #
  # @return [PostExecutionNode] a new instance of PostExecutionNode
  #
  # source://prism//lib/prism/node.rb#13662
  sig do
    params(
      statements: T.nilable(Prism::StatementsNode),
      keyword_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(statements, keyword_loc, opening_loc, closing_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13671
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13676
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#13722
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#13659
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13688
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13681
  def compact_child_nodes; end

  # def copy: (**params) -> PostExecutionNode
  #
  # source://prism//lib/prism/node.rb#13693
  sig { params(params: T.untyped).returns(Prism::PostExecutionNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13676
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#13707
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#13727
  def inspect(inspector = T.unsafe(nil)); end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#13712
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#13653
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#13717
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#13656
  sig { returns(Prism::Location) }
  def opening_loc; end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#13650
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#13755
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#13765
    def type; end
  end
end

# Represents the use of the `BEGIN` keyword.
#
#     BEGIN { foo }
#     ^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#13775
class Prism::PreExecutionNode < ::Prism::Node
  # def initialize: (statements: StatementsNode?, keyword_loc: Location, opening_loc: Location, closing_loc: Location, location: Location) -> void
  #
  # @return [PreExecutionNode] a new instance of PreExecutionNode
  #
  # source://prism//lib/prism/node.rb#13788
  sig do
    params(
      statements: T.nilable(Prism::StatementsNode),
      keyword_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(statements, keyword_loc, opening_loc, closing_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13797
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13802
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#13848
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#13785
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13814
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13807
  def compact_child_nodes; end

  # def copy: (**params) -> PreExecutionNode
  #
  # source://prism//lib/prism/node.rb#13819
  sig { params(params: T.untyped).returns(Prism::PreExecutionNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13802
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#13833
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#13853
  def inspect(inspector = T.unsafe(nil)); end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#13838
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#13779
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#13843
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#13782
  sig { returns(Prism::Location) }
  def opening_loc; end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#13776
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#13881
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#13891
    def type; end
  end
end

# The top level node of any parse tree.
#
# source://prism//lib/prism/node.rb#13898
class Prism::ProgramNode < ::Prism::Node
  # def initialize: (locals: Array[Symbol], statements: StatementsNode, location: Location) -> void
  #
  # @return [ProgramNode] a new instance of ProgramNode
  #
  # source://prism//lib/prism/node.rb#13905
  sig { params(locals: T::Array[Symbol], statements: Prism::StatementsNode, location: Prism::Location).void }
  def initialize(locals, statements, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13912
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13917
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13927
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13922
  def compact_child_nodes; end

  # def copy: (**params) -> ProgramNode
  #
  # source://prism//lib/prism/node.rb#13932
  sig { params(params: T.untyped).returns(Prism::ProgramNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13917
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#13944
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#13949
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader locals: Array[Symbol]
  #
  # source://prism//lib/prism/node.rb#13899
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # attr_reader statements: StatementsNode
  #
  # source://prism//lib/prism/node.rb#13902
  sig { returns(Prism::StatementsNode) }
  def statements; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#13971
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#13981
    def type; end
  end
end

# Flags for range and flip-flop nodes.
#
# source://prism//lib/prism/node.rb#17337
module Prism::RangeFlags; end

# ... operator
#
# source://prism//lib/prism/node.rb#17339
Prism::RangeFlags::EXCLUDE_END = T.let(T.unsafe(nil), Integer)

# Represents the use of the `..` or `...` operators.
#
#     1..2
#     ^^^^
#
#     c if a =~ /left/ ... b =~ /right/
#          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#13994
class Prism::RangeNode < ::Prism::Node
  # def initialize: (flags: Integer, left: Node?, right: Node?, operator_loc: Location, location: Location) -> void
  #
  # @return [RangeNode] a new instance of RangeNode
  #
  # source://prism//lib/prism/node.rb#14007
  sig do
    params(
      flags: Integer,
      left: T.nilable(Prism::Node),
      right: T.nilable(Prism::Node),
      operator_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(flags, left, right, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14016
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14021
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14034
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14026
  def compact_child_nodes; end

  # def copy: (**params) -> RangeNode
  #
  # source://prism//lib/prism/node.rb#14039
  sig { params(params: T.untyped).returns(Prism::RangeNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14021
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#14053
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def exclude_end?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14058
  sig { returns(T::Boolean) }
  def exclude_end?; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#14068
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader left: Node?
  #
  # source://prism//lib/prism/node.rb#13998
  sig { returns(T.nilable(Prism::Node)) }
  def left; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#14063
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#14004
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader right: Node?
  #
  # source://prism//lib/prism/node.rb#14001
  sig { returns(T.nilable(Prism::Node)) }
  def right; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#14102
  def type; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#13995
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#14112
    def type; end
  end
end

# Represents a rational number literal.
#
#     1.0r
#     ^^^^
#
# source://prism//lib/prism/node.rb#14122
class Prism::RationalNode < ::Prism::Node
  # def initialize: (numeric: Node, location: Location) -> void
  #
  # @return [RationalNode] a new instance of RationalNode
  #
  # source://prism//lib/prism/node.rb#14126
  sig { params(numeric: Prism::Node, location: Prism::Location).void }
  def initialize(numeric, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14132
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14137
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14147
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14142
  def compact_child_nodes; end

  # def copy: (**params) -> RationalNode
  #
  # source://prism//lib/prism/node.rb#14152
  sig { params(params: T.untyped).returns(Prism::RationalNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14137
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#14163
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#14168
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader numeric: Node
  #
  # source://prism//lib/prism/node.rb#14123
  sig { returns(Prism::Node) }
  def numeric; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#14189
  def type; end

  # Returns the value of the node as a Ruby Rational.
  #
  # source://prism//lib/prism/node_ext.rb#83
  def value; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#14199
    def type; end
  end
end

# Represents the use of the `redo` keyword.
#
#     redo
#     ^^^^
#
# source://prism//lib/prism/node.rb#14209
class Prism::RedoNode < ::Prism::Node
  # def initialize: (location: Location) -> void
  #
  # @return [RedoNode] a new instance of RedoNode
  #
  # source://prism//lib/prism/node.rb#14210
  sig { params(location: Prism::Location).void }
  def initialize(location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14215
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14220
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14230
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14225
  def compact_child_nodes; end

  # def copy: (**params) -> RedoNode
  #
  # source://prism//lib/prism/node.rb#14235
  sig { params(params: T.untyped).returns(Prism::RedoNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14220
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#14245
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#14250
  def inspect(inspector = T.unsafe(nil)); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#14269
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#14279
    def type; end
  end
end

# Flags for regular expression and match last line nodes.
#
# source://prism//lib/prism/node.rb#17343
module Prism::RegularExpressionFlags; end

# n - forces the ASCII-8BIT encoding
#
# source://prism//lib/prism/node.rb#17360
Prism::RegularExpressionFlags::ASCII_8BIT = T.let(T.unsafe(nil), Integer)

# e - forces the EUC-JP encoding
#
# source://prism//lib/prism/node.rb#17357
Prism::RegularExpressionFlags::EUC_JP = T.let(T.unsafe(nil), Integer)

# x - ignores whitespace and allows comments in regular expressions
#
# source://prism//lib/prism/node.rb#17348
Prism::RegularExpressionFlags::EXTENDED = T.let(T.unsafe(nil), Integer)

# internal bytes forced the encoding to binary
#
# source://prism//lib/prism/node.rb#17372
Prism::RegularExpressionFlags::FORCED_BINARY_ENCODING = T.let(T.unsafe(nil), Integer)

# internal bytes forced the encoding to US-ASCII
#
# source://prism//lib/prism/node.rb#17375
Prism::RegularExpressionFlags::FORCED_US_ASCII_ENCODING = T.let(T.unsafe(nil), Integer)

# internal bytes forced the encoding to UTF-8
#
# source://prism//lib/prism/node.rb#17369
Prism::RegularExpressionFlags::FORCED_UTF8_ENCODING = T.let(T.unsafe(nil), Integer)

# i - ignores the case of characters when matching
#
# source://prism//lib/prism/node.rb#17345
Prism::RegularExpressionFlags::IGNORE_CASE = T.let(T.unsafe(nil), Integer)

# m - allows $ to match the end of lines within strings
#
# source://prism//lib/prism/node.rb#17351
Prism::RegularExpressionFlags::MULTI_LINE = T.let(T.unsafe(nil), Integer)

# o - only interpolates values into the regular expression once
#
# source://prism//lib/prism/node.rb#17354
Prism::RegularExpressionFlags::ONCE = T.let(T.unsafe(nil), Integer)

# u - forces the UTF-8 encoding
#
# source://prism//lib/prism/node.rb#17366
Prism::RegularExpressionFlags::UTF_8 = T.let(T.unsafe(nil), Integer)

# s - forces the Windows-31J encoding
#
# source://prism//lib/prism/node.rb#17363
Prism::RegularExpressionFlags::WINDOWS_31J = T.let(T.unsafe(nil), Integer)

# Represents a regular expression literal with no interpolation.
#
#     /foo/i
#     ^^^^^^
#
# source://prism//lib/prism/node.rb#14289
class Prism::RegularExpressionNode < ::Prism::Node
  include ::Prism::RegularExpressionOptions

  # def initialize: (flags: Integer, opening_loc: Location, content_loc: Location, closing_loc: Location, unescaped: String, location: Location) -> void
  #
  # @return [RegularExpressionNode] a new instance of RegularExpressionNode
  #
  # source://prism//lib/prism/node.rb#14305
  sig do
    params(
      flags: Integer,
      opening_loc: Prism::Location,
      content_loc: Prism::Location,
      closing_loc: Prism::Location,
      unescaped: String,
      location: Prism::Location
    ).void
  end
  def initialize(flags, opening_loc, content_loc, closing_loc, unescaped, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14315
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def ascii_8bit?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14380
  sig { returns(T::Boolean) }
  def ascii_8bit?; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14320
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#14420
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#14299
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14330
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14325
  def compact_child_nodes; end

  # def content: () -> String
  #
  # source://prism//lib/prism/node.rb#14415
  sig { returns(String) }
  def content; end

  # attr_reader content_loc: Location
  #
  # source://prism//lib/prism/node.rb#14296
  sig { returns(Prism::Location) }
  def content_loc; end

  # def copy: (**params) -> RegularExpressionNode
  #
  # source://prism//lib/prism/node.rb#14335
  sig { params(params: T.untyped).returns(Prism::RegularExpressionNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14320
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#14350
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def euc_jp?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14375
  sig { returns(T::Boolean) }
  def euc_jp?; end

  # def extended?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14360
  sig { returns(T::Boolean) }
  def extended?; end

  # def forced_binary_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14400
  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  # def forced_us_ascii_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14405
  sig { returns(T::Boolean) }
  def forced_us_ascii_encoding?; end

  # def forced_utf8_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14395
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  # def ignore_case?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14355
  sig { returns(T::Boolean) }
  def ignore_case?; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#14425
  def inspect(inspector = T.unsafe(nil)); end

  # def multi_line?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14365
  sig { returns(T::Boolean) }
  def multi_line?; end

  # def once?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14370
  sig { returns(T::Boolean) }
  def once?; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#14410
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#14293
  sig { returns(Prism::Location) }
  def opening_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#14450
  def type; end

  # attr_reader unescaped: String
  #
  # source://prism//lib/prism/node.rb#14302
  sig { returns(String) }
  def unescaped; end

  # def utf_8?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14390
  sig { returns(T::Boolean) }
  def utf_8?; end

  # def windows_31j?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14385
  sig { returns(T::Boolean) }
  def windows_31j?; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#14290
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#14460
    def type; end
  end
end

# source://prism//lib/prism/node_ext.rb#6
module Prism::RegularExpressionOptions
  # Returns a numeric value that represents the flags that were used to create
  # the regular expression.
  #
  # source://prism//lib/prism/node_ext.rb#9
  def options; end
end

# Represents a required keyword parameter to a method, block, or lambda definition.
#
#     def a(b: )
#           ^^
#     end
#
# source://prism//lib/prism/node.rb#14471
class Prism::RequiredKeywordParameterNode < ::Prism::Node
  # def initialize: (name: Symbol, name_loc: Location, location: Location) -> void
  #
  # @return [RequiredKeywordParameterNode] a new instance of RequiredKeywordParameterNode
  #
  # source://prism//lib/prism/node.rb#14478
  sig { params(name: Symbol, name_loc: Prism::Location, location: Prism::Location).void }
  def initialize(name, name_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14485
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14490
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14500
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14495
  def compact_child_nodes; end

  # def copy: (**params) -> RequiredKeywordParameterNode
  #
  # source://prism//lib/prism/node.rb#14505
  sig { params(params: T.untyped).returns(Prism::RequiredKeywordParameterNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14490
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#14517
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#14522
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#14472
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#14475
  sig { returns(Prism::Location) }
  def name_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#14543
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#14553
    def type; end
  end
end

# Represents a required parameter to a method, block, or lambda definition.
#
#     def a(b)
#           ^
#     end
#
# source://prism//lib/prism/node.rb#14564
class Prism::RequiredParameterNode < ::Prism::Node
  # def initialize: (name: Symbol, location: Location) -> void
  #
  # @return [RequiredParameterNode] a new instance of RequiredParameterNode
  #
  # source://prism//lib/prism/node.rb#14568
  sig { params(name: Symbol, location: Prism::Location).void }
  def initialize(name, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14574
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14579
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14589
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14584
  def compact_child_nodes; end

  # def copy: (**params) -> RequiredParameterNode
  #
  # source://prism//lib/prism/node.rb#14594
  sig { params(params: T.untyped).returns(Prism::RequiredParameterNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14579
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#14605
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#14610
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#14565
  sig { returns(Symbol) }
  def name; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#14630
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#14640
    def type; end
  end
end

# Represents an expression modified with a rescue.
#
#     foo rescue nil
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#14650
class Prism::RescueModifierNode < ::Prism::Node
  # def initialize: (expression: Node, keyword_loc: Location, rescue_expression: Node, location: Location) -> void
  #
  # @return [RescueModifierNode] a new instance of RescueModifierNode
  #
  # source://prism//lib/prism/node.rb#14660
  sig do
    params(
      expression: Prism::Node,
      keyword_loc: Prism::Location,
      rescue_expression: Prism::Node,
      location: Prism::Location
    ).void
  end
  def initialize(expression, keyword_loc, rescue_expression, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14668
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14677
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14687
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14682
  def compact_child_nodes; end

  # def copy: (**params) -> RescueModifierNode
  #
  # source://prism//lib/prism/node.rb#14692
  sig { params(params: T.untyped).returns(Prism::RescueModifierNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14677
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#14705
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # attr_reader expression: Node
  #
  # source://prism//lib/prism/node.rb#14651
  sig { returns(Prism::Node) }
  def expression; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#14715
  def inspect(inspector = T.unsafe(nil)); end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#14710
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#14654
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # attr_reader rescue_expression: Node
  #
  # source://prism//lib/prism/node.rb#14657
  sig { returns(Prism::Node) }
  def rescue_expression; end

  # source://prism//lib/prism/node.rb#14672
  def set_newline_flag(newline_marked); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#14739
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#14749
    def type; end
  end
end

# Represents a rescue statement.
#
#     begin
#     rescue Foo, *splat, Bar => ex
#       foo
#     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
#     end
#
# `Foo, *splat, Bar` are in the `exceptions` field.
# `ex` is in the `exception` field.
#
# source://prism//lib/prism/node.rb#14765
class Prism::RescueNode < ::Prism::Node
  # def initialize: (keyword_loc: Location, exceptions: Array[Node], operator_loc: Location?, reference: Node?, statements: StatementsNode?, consequent: RescueNode?, location: Location) -> void
  #
  # @return [RescueNode] a new instance of RescueNode
  #
  # source://prism//lib/prism/node.rb#14784
  sig do
    params(
      keyword_loc: Prism::Location,
      exceptions: T::Array[Prism::Node],
      operator_loc: T.nilable(Prism::Location),
      reference: T.nilable(Prism::Node),
      statements: T.nilable(Prism::StatementsNode),
      consequent: T.nilable(Prism::RescueNode),
      location: Prism::Location
    ).void
  end
  def initialize(keyword_loc, exceptions, operator_loc, reference, statements, consequent, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14795
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14800
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14815
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14805
  def compact_child_nodes; end

  # attr_reader consequent: RescueNode?
  #
  # source://prism//lib/prism/node.rb#14781
  sig { returns(T.nilable(Prism::RescueNode)) }
  def consequent; end

  # def copy: (**params) -> RescueNode
  #
  # source://prism//lib/prism/node.rb#14820
  sig { params(params: T.untyped).returns(Prism::RescueNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14800
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#14836
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # attr_reader exceptions: Array[Node]
  #
  # source://prism//lib/prism/node.rb#14769
  sig { returns(T::Array[Prism::Node]) }
  def exceptions; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#14851
  def inspect(inspector = T.unsafe(nil)); end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#14841
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#14766
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # def operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#14846
  sig { returns(T.nilable(String)) }
  def operator; end

  # attr_reader operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#14772
  sig { returns(T.nilable(Prism::Location)) }
  def operator_loc; end

  # attr_reader reference: Node?
  #
  # source://prism//lib/prism/node.rb#14775
  sig { returns(T.nilable(Prism::Node)) }
  def reference; end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#14778
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#14891
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#14901
    def type; end
  end
end

# Represents a rest parameter to a method, block, or lambda definition.
#
#     def a(*b)
#           ^^
#     end
#
# source://prism//lib/prism/node.rb#14912
class Prism::RestParameterNode < ::Prism::Node
  # def initialize: (name: Symbol?, name_loc: Location?, operator_loc: Location, location: Location) -> void
  #
  # @return [RestParameterNode] a new instance of RestParameterNode
  #
  # source://prism//lib/prism/node.rb#14922
  sig do
    params(
      name: T.nilable(Symbol),
      name_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(name, name_loc, operator_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14930
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14935
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14945
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14940
  def compact_child_nodes; end

  # def copy: (**params) -> RestParameterNode
  #
  # source://prism//lib/prism/node.rb#14950
  sig { params(params: T.untyped).returns(Prism::RestParameterNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14935
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#14963
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#14973
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader name: Symbol?
  #
  # source://prism//lib/prism/node.rb#14913
  sig { returns(T.nilable(Symbol)) }
  def name; end

  # attr_reader name_loc: Location?
  #
  # source://prism//lib/prism/node.rb#14916
  sig { returns(T.nilable(Prism::Location)) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#14968
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#14919
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#14999
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#15009
    def type; end
  end
end

# Represents the use of the `retry` keyword.
#
#     retry
#     ^^^^^
#
# source://prism//lib/prism/node.rb#15019
class Prism::RetryNode < ::Prism::Node
  # def initialize: (location: Location) -> void
  #
  # @return [RetryNode] a new instance of RetryNode
  #
  # source://prism//lib/prism/node.rb#15020
  sig { params(location: Prism::Location).void }
  def initialize(location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15025
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15030
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15040
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15035
  def compact_child_nodes; end

  # def copy: (**params) -> RetryNode
  #
  # source://prism//lib/prism/node.rb#15045
  sig { params(params: T.untyped).returns(Prism::RetryNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15030
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#15055
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#15060
  def inspect(inspector = T.unsafe(nil)); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#15079
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#15089
    def type; end
  end
end

# Represents the use of the `return` keyword.
#
#     return 1
#     ^^^^^^^^
#
# source://prism//lib/prism/node.rb#15099
class Prism::ReturnNode < ::Prism::Node
  # def initialize: (keyword_loc: Location, arguments: ArgumentsNode?, location: Location) -> void
  #
  # @return [ReturnNode] a new instance of ReturnNode
  #
  # source://prism//lib/prism/node.rb#15106
  sig do
    params(
      keyword_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      location: Prism::Location
    ).void
  end
  def initialize(keyword_loc, arguments, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15113
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#15103
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15118
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15130
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15123
  def compact_child_nodes; end

  # def copy: (**params) -> ReturnNode
  #
  # source://prism//lib/prism/node.rb#15135
  sig { params(params: T.untyped).returns(Prism::ReturnNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15118
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#15147
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#15157
  def inspect(inspector = T.unsafe(nil)); end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#15152
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#15100
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#15183
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#15193
    def type; end
  end
end

# Note: This integration is not finished, and therefore still has many
# inconsistencies with Ripper. If you'd like to help out, pull requests would
# be greatly appreciated!
#
# This class is meant to provide a compatibility layer between prism and
# Ripper. It functions by parsing the entire tree first and then walking it
# and executing each of the Ripper callbacks as it goes.
#
# This class is going to necessarily be slower than the native Ripper API. It
# is meant as a stopgap until developers migrate to using prism. It is also
# meant as a test harness for the prism parser.
#
# To use this class, you treat `Prism::RipperCompat` effectively as you would
# treat the `Ripper` class.
#
# source://prism//lib/prism/ripper_compat.rb#22
class Prism::RipperCompat < ::Prism::Visitor
  # Create a new RipperCompat object with the given source.
  #
  # @return [RipperCompat] a new instance of RipperCompat
  #
  # source://prism//lib/prism/ripper_compat.rb#74
  def initialize(source); end

  # The current column number of the parser.
  #
  # source://prism//lib/prism/ripper_compat.rb#71
  def column; end

  # True if the parser encountered an error during parsing.
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/ripper_compat.rb#86
  def error?; end

  # The current line number of the parser.
  #
  # source://prism//lib/prism/ripper_compat.rb#68
  def lineno; end

  # Parse the source and return the result.
  #
  # source://prism//lib/prism/ripper_compat.rb#91
  def parse; end

  # The source that is being parsed.
  #
  # source://prism//lib/prism/ripper_compat.rb#65
  def source; end

  # Visit a CallNode node.
  #
  # source://prism//lib/prism/ripper_compat.rb#110
  def visit_call_node(node); end

  # Visit a FloatNode node.
  #
  # source://prism//lib/prism/ripper_compat.rb#123
  def visit_float_node(node); end

  # Visit a ImaginaryNode node.
  #
  # source://prism//lib/prism/ripper_compat.rb#129
  def visit_imaginary_node(node); end

  # Visit an IntegerNode node.
  #
  # source://prism//lib/prism/ripper_compat.rb#135
  def visit_integer_node(node); end

  # Visit a ProgramNode node.
  #
  # source://prism//lib/prism/ripper_compat.rb#155
  def visit_program_node(node); end

  # Visit a RationalNode node.
  #
  # source://prism//lib/prism/ripper_compat.rb#141
  def visit_rational_node(node); end

  # Visit a StatementsNode node.
  #
  # source://prism//lib/prism/ripper_compat.rb#147
  def visit_statements_node(node); end

  private

  # source://prism//lib/prism/ripper_compat.rb#192
  def _dispatch0; end

  # source://prism//lib/prism/ripper_compat.rb#193
  def _dispatch1(_); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def _dispatch2(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#195
  def _dispatch3(_, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#196
  def _dispatch4(_, _, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#197
  def _dispatch5(_, _, _, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#198
  def _dispatch7(_, _, _, _, _, _, _); end

  # This method is responsible for updating lineno and column information
  # to reflect the current node.
  #
  # This method could be drastically improved with some caching on the start
  # of every line, but for now it's good enough.
  #
  # source://prism//lib/prism/ripper_compat.rb#182
  def bounds(location); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_BEGIN(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_CHAR(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_END(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on___end__(_); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_alias(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_alias_error(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_aref(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_aref_field(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_arg_ambiguous(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_arg_paren(_); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_args_add(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_args_add_block(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_args_add_star(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_args_forward; end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_args_new; end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_array(_); end

  # source://prism//lib/prism/ripper_compat.rb#196
  def on_aryptn(_, _, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_assign(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_assign_error(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_assoc_new(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_assoc_splat(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_assoclist_from_args(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_backref(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_backtick(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_bare_assoc_hash(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_begin(_); end

  # source://prism//lib/prism/ripper_compat.rb#195
  def on_binary(_, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_block_var(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_blockarg(_); end

  # source://prism//lib/prism/ripper_compat.rb#196
  def on_bodystmt(_, _, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_brace_block(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_break(_); end

  # source://prism//lib/prism/ripper_compat.rb#195
  def on_call(_, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_case(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#195
  def on_class(_, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_class_name_error(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_comma(_); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_command(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#196
  def on_command_call(_, _, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_comment(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_const(_); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_const_path_field(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_const_path_ref(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_const_ref(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_cvar(_); end

  # source://prism//lib/prism/ripper_compat.rb#195
  def on_def(_, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_defined(_); end

  # source://prism//lib/prism/ripper_compat.rb#197
  def on_defs(_, _, _, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_do_block(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_dot2(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_dot3(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_dyna_symbol(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_else(_); end

  # source://prism//lib/prism/ripper_compat.rb#195
  def on_elsif(_, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_embdoc(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_embdoc_beg(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_embdoc_end(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_embexpr_beg(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_embexpr_end(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_embvar(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_ensure(_); end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_excessed_comma; end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_fcall(_); end

  # source://prism//lib/prism/ripper_compat.rb#195
  def on_field(_, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_float(_); end

  # source://prism//lib/prism/ripper_compat.rb#196
  def on_fndptn(_, _, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#195
  def on_for(_, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_gvar(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_hash(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_heredoc_beg(_); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_heredoc_dedent(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_heredoc_end(_); end

  # source://prism//lib/prism/ripper_compat.rb#195
  def on_hshptn(_, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_ident(_); end

  # source://prism//lib/prism/ripper_compat.rb#195
  def on_if(_, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_if_mod(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#195
  def on_ifop(_, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_ignored_nl(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_ignored_sp(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_imaginary(_); end

  # source://prism//lib/prism/ripper_compat.rb#195
  def on_in(_, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_int(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_ivar(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_kw(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_kwrest_param(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_label(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_label_end(_); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_lambda(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_lbrace(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_lbracket(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_lparen(_); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_magic_comment(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_massign(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_method_add_arg(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_method_add_block(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_mlhs_add(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_mlhs_add_post(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_mlhs_add_star(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_mlhs_new; end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_mlhs_paren(_); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_module(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_mrhs_add(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_mrhs_add_star(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_mrhs_new; end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_mrhs_new_from_args(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_next(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_nl(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_nokw_param(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_op(_); end

  # source://prism//lib/prism/ripper_compat.rb#195
  def on_opassign(_, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_operator_ambiguous(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_param_error(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#198
  def on_params(_, _, _, _, _, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_paren(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_parse_error(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_period(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_program(_); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_qsymbols_add(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_qsymbols_beg(_); end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_qsymbols_new; end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_qwords_add(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_qwords_beg(_); end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_qwords_new; end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_rational(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_rbrace(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_rbracket(_); end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_redo; end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_regexp_add(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_regexp_beg(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_regexp_end(_); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_regexp_literal(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_regexp_new; end

  # source://prism//lib/prism/ripper_compat.rb#196
  def on_rescue(_, _, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_rescue_mod(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_rest_param(_); end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_retry; end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_return(_); end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_return0; end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_rparen(_); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_sclass(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_semicolon(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_sp(_); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_stmts_add(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_stmts_new; end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_string_add(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_string_concat(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_string_content; end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_string_dvar(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_string_embexpr(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_string_literal(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_super(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_symbeg(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_symbol(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_symbol_literal(_); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_symbols_add(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_symbols_beg(_); end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_symbols_new; end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_tlambda(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_tlambeg(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_top_const_field(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_top_const_ref(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_tstring_beg(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_tstring_content(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_tstring_end(_); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_unary(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_undef(_); end

  # source://prism//lib/prism/ripper_compat.rb#195
  def on_unless(_, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_unless_mod(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_until(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_until_mod(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_var_alias(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_var_field(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_var_ref(_); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_vcall(_); end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_void_stmt; end

  # source://prism//lib/prism/ripper_compat.rb#195
  def on_when(_, _, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_while(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_while_mod(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_word_add(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_word_new; end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_words_add(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_words_beg(_); end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_words_new; end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_words_sep(_); end

  # source://prism//lib/prism/ripper_compat.rb#194
  def on_xstring_add(_, _); end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_xstring_literal(_); end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_xstring_new; end

  # source://prism//lib/prism/ripper_compat.rb#193
  def on_yield(_); end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_yield0; end

  # source://prism//lib/prism/ripper_compat.rb#192
  def on_zsuper; end

  # Lazily initialize the parse result.
  #
  # source://prism//lib/prism/ripper_compat.rb#188
  def result; end

  class << self
    # This is a convenience method that runs the SexpBuilderPP subclass parser.
    #
    # source://prism//lib/prism/ripper_compat.rb#171
    def sexp(source); end

    # This is a convenience method that runs the SexpBuilder subclass parser.
    #
    # source://prism//lib/prism/ripper_compat.rb#166
    def sexp_raw(source); end
  end
end

# This class mirrors the ::Ripper::SexpBuilder subclass of ::Ripper that
# returns the arrays of [type, *children].
#
# source://prism//lib/prism/ripper_compat.rb#23
class Prism::RipperCompat::SexpBuilder < ::Prism::RipperCompat
  private

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_BEGIN(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_CHAR(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_END(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on___end__(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_alias(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_alias_error(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_aref(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_aref_field(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_arg_ambiguous(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_arg_paren(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_args_add(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_args_add_block(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_args_add_star(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_args_forward(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_args_new(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_array(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_aryptn(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_assign(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_assign_error(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_assoc_new(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_assoc_splat(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_assoclist_from_args(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_backref(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_backtick(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_bare_assoc_hash(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_begin(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_binary(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_block_var(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_blockarg(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_bodystmt(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_brace_block(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_break(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_call(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_case(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_class(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_class_name_error(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_comma(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_command(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_command_call(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_comment(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_const(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_const_path_field(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_const_path_ref(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_const_ref(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_cvar(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_def(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_defined(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_defs(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_do_block(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_dot2(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_dot3(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_dyna_symbol(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_else(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_elsif(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_embdoc(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_embdoc_beg(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_embdoc_end(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_embexpr_beg(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_embexpr_end(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_embvar(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_ensure(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_excessed_comma(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_fcall(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_field(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_float(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_fndptn(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_for(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_gvar(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_hash(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_heredoc_beg(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_heredoc_dedent(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_heredoc_end(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_hshptn(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_ident(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_if(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_if_mod(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_ifop(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_ignored_nl(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_ignored_sp(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_imaginary(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_in(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_int(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_ivar(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_kw(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_kwrest_param(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_label(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_label_end(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_lambda(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_lbrace(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_lbracket(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_lparen(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_magic_comment(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_massign(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_method_add_arg(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_method_add_block(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_mlhs_add(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_mlhs_add_post(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_mlhs_add_star(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_mlhs_new(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_mlhs_paren(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_module(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_mrhs_add(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_mrhs_add_star(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_mrhs_new(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_mrhs_new_from_args(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_next(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_nl(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_nokw_param(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_op(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_opassign(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_operator_ambiguous(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_param_error(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_params(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_paren(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_parse_error(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_period(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_program(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_qsymbols_add(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_qsymbols_beg(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_qsymbols_new(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_qwords_add(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_qwords_beg(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_qwords_new(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_rational(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_rbrace(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_rbracket(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_redo(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_regexp_add(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_regexp_beg(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_regexp_end(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_regexp_literal(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_regexp_new(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_rescue(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_rescue_mod(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_rest_param(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_retry(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_return(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_return0(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_rparen(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_sclass(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_semicolon(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_sp(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_stmts_add(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_stmts_new(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_string_add(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_string_concat(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_string_content(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_string_dvar(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_string_embexpr(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_string_literal(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_super(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_symbeg(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_symbol(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_symbol_literal(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_symbols_add(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_symbols_beg(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_symbols_new(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_tlambda(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_tlambeg(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_top_const_field(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_top_const_ref(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_tstring_beg(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_tstring_content(value); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_tstring_end(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_unary(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_undef(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_unless(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_unless_mod(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_until(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_until_mod(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_var_alias(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_var_field(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_var_ref(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_vcall(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_void_stmt(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_when(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_while(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_while_mod(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_word_add(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_word_new(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_words_add(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_words_beg(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_words_new(*args); end

  # source://prism//lib/prism/ripper_compat.rb#33
  def on_words_sep(value); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_xstring_add(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_xstring_literal(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_xstring_new(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_yield(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_yield0(*args); end

  # source://prism//lib/prism/ripper_compat.rb#27
  def on_zsuper(*args); end
end

# This class mirrors the ::Ripper::SexpBuilderPP subclass of ::Ripper that
# returns the same values as ::Ripper::SexpBuilder except with a couple of
# niceties that flatten linked lists into arrays.
#
# source://prism//lib/prism/ripper_compat.rb#42
class Prism::RipperCompat::SexpBuilderPP < ::Prism::RipperCompat::SexpBuilder
  private

  # source://prism//lib/prism/ripper_compat.rb#45
  def _dispatch_event_new; end

  # source://prism//lib/prism/ripper_compat.rb#49
  def _dispatch_event_push(list, item); end

  # source://prism//lib/prism/ripper_compat.rb#49
  def on_args_add(list, item); end

  # source://prism//lib/prism/ripper_compat.rb#45
  def on_args_new; end

  # source://prism//lib/prism/ripper_compat.rb#49
  def on_mlhs_add(list, item); end

  # source://prism//lib/prism/ripper_compat.rb#45
  def on_mlhs_new; end

  # source://prism//lib/prism/ripper_compat.rb#49
  def on_mrhs_add(list, item); end

  # source://prism//lib/prism/ripper_compat.rb#45
  def on_mrhs_new; end

  # source://prism//lib/prism/ripper_compat.rb#49
  def on_qsymbols_add(list, item); end

  # source://prism//lib/prism/ripper_compat.rb#45
  def on_qsymbols_new; end

  # source://prism//lib/prism/ripper_compat.rb#49
  def on_qwords_add(list, item); end

  # source://prism//lib/prism/ripper_compat.rb#45
  def on_qwords_new; end

  # source://prism//lib/prism/ripper_compat.rb#49
  def on_regexp_add(list, item); end

  # source://prism//lib/prism/ripper_compat.rb#45
  def on_regexp_new; end

  # source://prism//lib/prism/ripper_compat.rb#49
  def on_stmts_add(list, item); end

  # source://prism//lib/prism/ripper_compat.rb#45
  def on_stmts_new; end

  # source://prism//lib/prism/ripper_compat.rb#49
  def on_string_add(list, item); end

  # source://prism//lib/prism/ripper_compat.rb#49
  def on_symbols_add(list, item); end

  # source://prism//lib/prism/ripper_compat.rb#45
  def on_symbols_new; end

  # source://prism//lib/prism/ripper_compat.rb#49
  def on_word_add(list, item); end

  # source://prism//lib/prism/ripper_compat.rb#45
  def on_word_new; end

  # source://prism//lib/prism/ripper_compat.rb#49
  def on_words_add(list, item); end

  # source://prism//lib/prism/ripper_compat.rb#45
  def on_words_new; end

  # source://prism//lib/prism/ripper_compat.rb#49
  def on_xstring_add(list, item); end

  # source://prism//lib/prism/ripper_compat.rb#45
  def on_xstring_new; end
end

# Represents the `self` keyword.
#
#     self
#     ^^^^
#
# source://prism//lib/prism/node.rb#15203
class Prism::SelfNode < ::Prism::Node
  # def initialize: (location: Location) -> void
  #
  # @return [SelfNode] a new instance of SelfNode
  #
  # source://prism//lib/prism/node.rb#15204
  sig { params(location: Prism::Location).void }
  def initialize(location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15209
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15214
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15224
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15219
  def compact_child_nodes; end

  # def copy: (**params) -> SelfNode
  #
  # source://prism//lib/prism/node.rb#15229
  sig { params(params: T.untyped).returns(Prism::SelfNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15214
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#15239
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#15244
  def inspect(inspector = T.unsafe(nil)); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#15263
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#15273
    def type; end
  end
end

# A module responsible for deserializing parse results.
#
# source://prism//lib/prism/serialize.rb#23
module Prism::Serialize
  class << self
    # Deserialize the AST represented by the given string into a parse result.
    #
    # source://prism//lib/prism/serialize.rb#37
    def load(input, serialized); end

    # Deserialize the tokens represented by the given string into a parse
    # result.
    #
    # source://prism//lib/prism/serialize.rb#49
    def load_tokens(source, serialized); end
  end
end

# source://prism//lib/prism/serialize.rb#53
class Prism::Serialize::Loader
  # @return [Loader] a new instance of Loader
  #
  # source://prism//lib/prism/serialize.rb#58
  def initialize(source, serialized); end

  # Returns the value of attribute constant_pool.
  #
  # source://prism//lib/prism/serialize.rb#55
  def constant_pool; end

  # Returns the value of attribute constant_pool_offset.
  #
  # source://prism//lib/prism/serialize.rb#55
  def constant_pool_offset; end

  # Returns the value of attribute encoding.
  #
  # source://prism//lib/prism/serialize.rb#54
  def encoding; end

  # Returns the value of attribute input.
  #
  # source://prism//lib/prism/serialize.rb#54
  def input; end

  # Returns the value of attribute io.
  #
  # source://prism//lib/prism/serialize.rb#54
  def io; end

  # source://prism//lib/prism/serialize.rb#92
  def load_comments; end

  # source://prism//lib/prism/serialize.rb#82
  def load_encoding; end

  # source://prism//lib/prism/serialize.rb#73
  def load_header; end

  # source://prism//lib/prism/serialize.rb#102
  def load_metadata; end

  # source://prism//lib/prism/serialize.rb#135
  def load_nodes; end

  # source://prism//lib/prism/serialize.rb#148
  def load_result; end

  # source://prism//lib/prism/serialize.rb#88
  def load_start_line; end

  # source://prism//lib/prism/serialize.rb#111
  def load_tokens; end

  # source://prism//lib/prism/serialize.rb#124
  def load_tokens_result; end

  # Returns the value of attribute serialized.
  #
  # source://prism//lib/prism/serialize.rb#54
  def serialized; end

  # Returns the value of attribute source.
  #
  # source://prism//lib/prism/serialize.rb#55
  def source; end

  # Returns the value of attribute start_line.
  #
  # source://prism//lib/prism/serialize.rb#56
  def start_line; end

  private

  # source://prism//lib/prism/serialize.rb#211
  def load_constant(index); end

  # source://prism//lib/prism/serialize.rb#187
  def load_embedded_string; end

  # source://prism//lib/prism/serialize.rb#203
  def load_location; end

  # source://prism//lib/prism/serialize.rb#242
  def load_node; end

  # source://prism//lib/prism/serialize.rb#236
  def load_optional_constant; end

  # source://prism//lib/prism/serialize.rb#207
  def load_optional_location; end

  # source://prism//lib/prism/serialize.rb#180
  def load_optional_node; end

  # source://prism//lib/prism/serialize.rb#232
  def load_required_constant; end

  # source://prism//lib/prism/serialize.rb#176
  def load_serialized_length; end

  # source://prism//lib/prism/serialize.rb#191
  def load_string; end

  # source://prism//lib/prism/serialize.rb#171
  def load_varsint; end

  # variable-length integer using https://en.wikipedia.org/wiki/LEB128
  # This is also what protobuf uses: https://protobuf.dev/programming-guides/encoding/#varints
  #
  # source://prism//lib/prism/serialize.rb#157
  def load_varuint; end
end

# The major version of prism that we are expecting to find in the serialized
# strings.
#
# source://prism//lib/prism/serialize.rb#26
Prism::Serialize::MAJOR_VERSION = T.let(T.unsafe(nil), Integer)

# The minor version of prism that we are expecting to find in the serialized
# strings.
#
# source://prism//lib/prism/serialize.rb#30
Prism::Serialize::MINOR_VERSION = T.let(T.unsafe(nil), Integer)

# The patch version of prism that we are expecting to find in the serialized
# strings.
#
# source://prism//lib/prism/serialize.rb#34
Prism::Serialize::PATCH_VERSION = T.let(T.unsafe(nil), Integer)

# The token types that can be indexed by their enum values.
#
# source://prism//lib/prism/serialize.rb#1154
Prism::Serialize::TOKEN_TYPES = T.let(T.unsafe(nil), Array)

# Represents a singleton class declaration involving the `class` keyword.
#
#     class << self end
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#15283
class Prism::SingletonClassNode < ::Prism::Node
  # def initialize: (locals: Array[Symbol], class_keyword_loc: Location, operator_loc: Location, expression: Node, body: Node?, end_keyword_loc: Location, location: Location) -> void
  #
  # @return [SingletonClassNode] a new instance of SingletonClassNode
  #
  # source://prism//lib/prism/node.rb#15302
  sig do
    params(
      locals: T::Array[Symbol],
      class_keyword_loc: Prism::Location,
      operator_loc: Prism::Location,
      expression: Prism::Node,
      body: T.nilable(Prism::Node),
      end_keyword_loc: Prism::Location,
      location: Prism::Location
    ).void
  end
  def initialize(locals, class_keyword_loc, operator_loc, expression, body, end_keyword_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15313
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader body: Node?
  #
  # source://prism//lib/prism/node.rb#15296
  sig { returns(T.nilable(Prism::Node)) }
  def body; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15318
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def class_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#15357
  sig { returns(String) }
  def class_keyword; end

  # attr_reader class_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#15287
  sig { returns(Prism::Location) }
  def class_keyword_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15331
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15323
  def compact_child_nodes; end

  # def copy: (**params) -> SingletonClassNode
  #
  # source://prism//lib/prism/node.rb#15336
  sig { params(params: T.untyped).returns(Prism::SingletonClassNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15318
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#15352
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#15367
  sig { returns(String) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#15299
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  # attr_reader expression: Node
  #
  # source://prism//lib/prism/node.rb#15293
  sig { returns(Prism::Node) }
  def expression; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#15372
  def inspect(inspector = T.unsafe(nil)); end

  # attr_reader locals: Array[Symbol]
  #
  # source://prism//lib/prism/node.rb#15284
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#15362
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#15290
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#15403
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#15413
    def type; end
  end
end

# This represents a source of Ruby code that has been parsed. It is used in
# conjunction with locations to allow them to resolve line numbers and source
# ranges.
#
# source://prism//lib/prism/parse_result.rb#7
class Prism::Source
  # Create a new source object with the given source code and newline byte
  # offsets. If no newline byte offsets are given, they will be computed from
  # the source code.
  #
  # @return [Source] a new instance of Source
  #
  # source://prism//lib/prism/parse_result.rb#20
  def initialize(source, start_line = T.unsafe(nil), offsets = T.unsafe(nil)); end

  # Return the column number in characters for the given byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#55
  def character_column(byte_offset); end

  # Return the character offset for the given byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#50
  def character_offset(byte_offset); end

  # Return the column number for the given byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#45
  def column(byte_offset); end

  # Binary search through the offsets to find the line number for the given
  # byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#34
  def line(byte_offset); end

  sig { params(value: Integer).returns(Integer) }
  def line_offset(value); end

  # Return the byte offset of the start of the line corresponding to the given
  # byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#40
  def line_start(byte_offset); end

  # The list of newline byte offsets in the source code.
  #
  # source://prism//lib/prism/parse_result.rb#15
  sig { returns(T::Array[Integer]) }
  def offsets; end

  # Perform a byteslice on the source code using the given byte offset and
  # byte length.
  #
  # source://prism//lib/prism/parse_result.rb#28
  def slice(byte_offset, length); end

  # The source code that this source object represents.
  #
  # source://prism//lib/prism/parse_result.rb#9
  sig { returns(String) }
  def source; end

  # The line number where this source starts.
  #
  # source://prism//lib/prism/parse_result.rb#12
  def start_line; end

  # The line number where this source starts.
  #
  # source://prism//lib/prism/parse_result.rb#12
  def start_line=(_arg0); end

  private

  # Find all of the newlines in the source code and return their byte offsets
  # from the start of the string an array.
  #
  # source://prism//lib/prism/parse_result.rb#83
  def compute_offsets(code); end

  # Binary search through the offsets to find the line number for the given
  # byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#63
  def find_line(byte_offset); end
end

# Represents the use of the `__ENCODING__` keyword.
#
#     __ENCODING__
#     ^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#15423
class Prism::SourceEncodingNode < ::Prism::Node
  # def initialize: (location: Location) -> void
  #
  # @return [SourceEncodingNode] a new instance of SourceEncodingNode
  #
  # source://prism//lib/prism/node.rb#15424
  sig { params(location: Prism::Location).void }
  def initialize(location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15429
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15434
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15444
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15439
  def compact_child_nodes; end

  # def copy: (**params) -> SourceEncodingNode
  #
  # source://prism//lib/prism/node.rb#15449
  sig { params(params: T.untyped).returns(Prism::SourceEncodingNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15434
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#15459
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#15464
  def inspect(inspector = T.unsafe(nil)); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#15483
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#15493
    def type; end
  end
end

# Represents the use of the `__FILE__` keyword.
#
#     __FILE__
#     ^^^^^^^^
#
# source://prism//lib/prism/node.rb#15503
class Prism::SourceFileNode < ::Prism::Node
  # def initialize: (filepath: String, location: Location) -> void
  #
  # @return [SourceFileNode] a new instance of SourceFileNode
  #
  # source://prism//lib/prism/node.rb#15507
  sig { params(filepath: String, location: Prism::Location).void }
  def initialize(filepath, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15513
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15518
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15528
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15523
  def compact_child_nodes; end

  # def copy: (**params) -> SourceFileNode
  #
  # source://prism//lib/prism/node.rb#15533
  sig { params(params: T.untyped).returns(Prism::SourceFileNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15518
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#15544
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # attr_reader filepath: String
  #
  # source://prism//lib/prism/node.rb#15504
  sig { returns(String) }
  def filepath; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#15549
  def inspect(inspector = T.unsafe(nil)); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#15569
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#15579
    def type; end
  end
end

# Represents the use of the `__LINE__` keyword.
#
#     __LINE__
#     ^^^^^^^^
#
# source://prism//lib/prism/node.rb#15589
class Prism::SourceLineNode < ::Prism::Node
  # def initialize: (location: Location) -> void
  #
  # @return [SourceLineNode] a new instance of SourceLineNode
  #
  # source://prism//lib/prism/node.rb#15590
  sig { params(location: Prism::Location).void }
  def initialize(location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15595
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15600
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15610
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15605
  def compact_child_nodes; end

  # def copy: (**params) -> SourceLineNode
  #
  # source://prism//lib/prism/node.rb#15615
  sig { params(params: T.untyped).returns(Prism::SourceLineNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15600
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#15625
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#15630
  def inspect(inspector = T.unsafe(nil)); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#15649
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#15659
    def type; end
  end
end

# Represents the use of the splat operator.
#
#     [*a]
#      ^^
#
# source://prism//lib/prism/node.rb#15669
class Prism::SplatNode < ::Prism::Node
  # def initialize: (operator_loc: Location, expression: Node?, location: Location) -> void
  #
  # @return [SplatNode] a new instance of SplatNode
  #
  # source://prism//lib/prism/node.rb#15676
  sig { params(operator_loc: Prism::Location, expression: T.nilable(Prism::Node), location: Prism::Location).void }
  def initialize(operator_loc, expression, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15683
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15688
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15700
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15693
  def compact_child_nodes; end

  # def copy: (**params) -> SplatNode
  #
  # source://prism//lib/prism/node.rb#15705
  sig { params(params: T.untyped).returns(Prism::SplatNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15688
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#15717
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # attr_reader expression: Node?
  #
  # source://prism//lib/prism/node.rb#15673
  sig { returns(T.nilable(Prism::Node)) }
  def expression; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#15727
  def inspect(inspector = T.unsafe(nil)); end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#15722
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#15670
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#15753
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#15763
    def type; end
  end
end

# Represents a set of statements contained within some scope.
#
#     foo; bar; baz
#     ^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#15773
class Prism::StatementsNode < ::Prism::Node
  # def initialize: (body: Array[Node], location: Location) -> void
  #
  # @return [StatementsNode] a new instance of StatementsNode
  #
  # source://prism//lib/prism/node.rb#15777
  sig { params(body: T::Array[Prism::Node], location: Prism::Location).void }
  def initialize(body, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15783
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader body: Array[Node]
  #
  # source://prism//lib/prism/node.rb#15774
  sig { returns(T::Array[Prism::Node]) }
  def body; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15788
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15798
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15793
  def compact_child_nodes; end

  # def copy: (**params) -> StatementsNode
  #
  # source://prism//lib/prism/node.rb#15803
  sig { params(params: T.untyped).returns(Prism::StatementsNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15788
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#15814
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#15819
  def inspect(inspector = T.unsafe(nil)); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#15839
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#15849
    def type; end
  end
end

# Flags for string nodes.
#
# source://prism//lib/prism/node.rb#17379
module Prism::StringFlags; end

# internal bytes forced the encoding to binary
#
# source://prism//lib/prism/node.rb#17384
Prism::StringFlags::FORCED_BINARY_ENCODING = T.let(T.unsafe(nil), Integer)

# internal bytes forced the encoding to UTF-8
#
# source://prism//lib/prism/node.rb#17381
Prism::StringFlags::FORCED_UTF8_ENCODING = T.let(T.unsafe(nil), Integer)

# frozen by virtue of a `frozen_string_literal` comment
#
# source://prism//lib/prism/node.rb#17387
Prism::StringFlags::FROZEN = T.let(T.unsafe(nil), Integer)

# Represents a string literal, a string contained within a `%w` list, or
# plain string content within an interpolated string.
#
#     "foo"
#     ^^^^^
#
#     %w[foo]
#        ^^^
#
#     "foo #{bar} baz"
#      ^^^^      ^^^^
#
# source://prism//lib/prism/node.rb#15866
class Prism::StringNode < ::Prism::Node
  include ::Prism::HeredocQuery

  # def initialize: (flags: Integer, opening_loc: Location?, content_loc: Location, closing_loc: Location?, unescaped: String, location: Location) -> void
  #
  # @return [StringNode] a new instance of StringNode
  #
  # source://prism//lib/prism/node.rb#15882
  sig do
    params(
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      content_loc: Prism::Location,
      closing_loc: T.nilable(Prism::Location),
      unescaped: String,
      location: Prism::Location
    ).void
  end
  def initialize(flags, opening_loc, content_loc, closing_loc, unescaped, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15892
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15897
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#15957
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#15876
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15907
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15902
  def compact_child_nodes; end

  # def content: () -> String
  #
  # source://prism//lib/prism/node.rb#15952
  sig { returns(String) }
  def content; end

  # attr_reader content_loc: Location
  #
  # source://prism//lib/prism/node.rb#15873
  sig { returns(Prism::Location) }
  def content_loc; end

  # def copy: (**params) -> StringNode
  #
  # source://prism//lib/prism/node.rb#15912
  sig { params(params: T.untyped).returns(Prism::StringNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15897
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#15927
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def forced_binary_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#15937
  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  # def forced_utf8_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#15932
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  # def frozen?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#15942
  sig { returns(T::Boolean) }
  def frozen?; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#15962
  def inspect(inspector = T.unsafe(nil)); end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#15947
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#15870
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#15987
  def type; end

  # attr_reader unescaped: String
  #
  # source://prism//lib/prism/node.rb#15879
  sig { returns(String) }
  def unescaped; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#15867
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#15997
    def type; end
  end
end

# Represents the use of the `super` keyword with parentheses or arguments.
#
#     super()
#     ^^^^^^^
#
#     super foo, bar
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#16010
class Prism::SuperNode < ::Prism::Node
  # def initialize: (keyword_loc: Location, lparen_loc: Location?, arguments: ArgumentsNode?, rparen_loc: Location?, block: Node?, location: Location) -> void
  #
  # @return [SuperNode] a new instance of SuperNode
  #
  # source://prism//lib/prism/node.rb#16026
  sig do
    params(
      keyword_loc: Prism::Location,
      lparen_loc: T.nilable(Prism::Location),
      arguments: T.nilable(Prism::ArgumentsNode),
      rparen_loc: T.nilable(Prism::Location),
      block: T.nilable(Prism::Node),
      location: Prism::Location
    ).void
  end
  def initialize(keyword_loc, lparen_loc, arguments, rparen_loc, block, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#16036
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#16017
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # attr_reader block: Node?
  #
  # source://prism//lib/prism/node.rb#16023
  sig { returns(T.nilable(Prism::Node)) }
  def block; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#16041
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#16054
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#16046
  def compact_child_nodes; end

  # def copy: (**params) -> SuperNode
  #
  # source://prism//lib/prism/node.rb#16059
  sig { params(params: T.untyped).returns(Prism::SuperNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#16041
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#16074
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#16094
  def inspect(inspector = T.unsafe(nil)); end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#16079
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#16011
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # def lparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#16084
  sig { returns(T.nilable(String)) }
  def lparen; end

  # attr_reader lparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#16014
  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  # def rparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#16089
  sig { returns(T.nilable(String)) }
  def rparen; end

  # attr_reader rparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#16020
  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#16128
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#16138
    def type; end
  end
end

# Flags for symbol nodes.
#
# source://prism//lib/prism/node.rb#17391
module Prism::SymbolFlags; end

# internal bytes forced the encoding to binary
#
# source://prism//lib/prism/node.rb#17396
Prism::SymbolFlags::FORCED_BINARY_ENCODING = T.let(T.unsafe(nil), Integer)

# internal bytes forced the encoding to US-ASCII
#
# source://prism//lib/prism/node.rb#17399
Prism::SymbolFlags::FORCED_US_ASCII_ENCODING = T.let(T.unsafe(nil), Integer)

# internal bytes forced the encoding to UTF-8
#
# source://prism//lib/prism/node.rb#17393
Prism::SymbolFlags::FORCED_UTF8_ENCODING = T.let(T.unsafe(nil), Integer)

# Represents a symbol literal or a symbol contained within a `%i` list.
#
#     :foo
#     ^^^^
#
#     %i[foo]
#        ^^^
#
# source://prism//lib/prism/node.rb#16151
class Prism::SymbolNode < ::Prism::Node
  # def initialize: (flags: Integer, opening_loc: Location?, value_loc: Location?, closing_loc: Location?, unescaped: String, location: Location) -> void
  #
  # @return [SymbolNode] a new instance of SymbolNode
  #
  # source://prism//lib/prism/node.rb#16167
  sig do
    params(
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      value_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location),
      unescaped: String,
      location: Prism::Location
    ).void
  end
  def initialize(flags, opening_loc, value_loc, closing_loc, unescaped, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#16177
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#16182
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#16242
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#16161
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#16192
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#16187
  def compact_child_nodes; end

  # def copy: (**params) -> SymbolNode
  #
  # source://prism//lib/prism/node.rb#16197
  sig { params(params: T.untyped).returns(Prism::SymbolNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#16182
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#16212
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def forced_binary_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16222
  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  # def forced_us_ascii_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16227
  sig { returns(T::Boolean) }
  def forced_us_ascii_encoding?; end

  # def forced_utf8_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16217
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#16247
  def inspect(inspector = T.unsafe(nil)); end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#16232
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#16155
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#16272
  def type; end

  # attr_reader unescaped: String
  #
  # source://prism//lib/prism/node.rb#16164
  sig { returns(String) }
  def unescaped; end

  # def value: () -> String?
  #
  # source://prism//lib/prism/node.rb#16237
  sig { returns(T.nilable(String)) }
  def value; end

  # attr_reader value_loc: Location?
  #
  # source://prism//lib/prism/node.rb#16158
  sig { returns(T.nilable(Prism::Location)) }
  def value_loc; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#16152
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#16282
    def type; end
  end
end

# This represents a token from the Ruby source.
#
# source://prism//lib/prism/parse_result.rb#416
class Prism::Token
  # Create a new token object with the given type, value, and location.
  #
  # @return [Token] a new instance of Token
  #
  # source://prism//lib/prism/parse_result.rb#427
  sig { params(type: T.untyped, value: String, location: Prism::Location).void }
  def initialize(type, value, location); end

  # Returns true if the given other token is equal to this token.
  #
  # source://prism//lib/prism/parse_result.rb#454
  sig { params(other: T.untyped).returns(T::Boolean) }
  def ==(other); end

  # Implement the hash pattern matching interface for Token.
  #
  # source://prism//lib/prism/parse_result.rb#434
  sig { params(keys: T.untyped).returns(T.untyped) }
  def deconstruct_keys(keys); end

  # A Location object representing the location of this token in the source.
  #
  # source://prism//lib/prism/parse_result.rb#424
  sig { returns(Prism::Location) }
  def location; end

  # Implement the pretty print interface for Token.
  #
  # source://prism//lib/prism/parse_result.rb#439
  sig { params(q: T.untyped).returns(T.untyped) }
  def pretty_print(q); end

  # The type of token that this token is.
  #
  # source://prism//lib/prism/parse_result.rb#418
  sig { returns(T.untyped) }
  def type; end

  # A byteslice of the source that this token represents.
  #
  # source://prism//lib/prism/parse_result.rb#421
  sig { returns(String) }
  def value; end
end

# Represents the use of the literal `true` keyword.
#
#     true
#     ^^^^
#
# source://prism//lib/prism/node.rb#16292
class Prism::TrueNode < ::Prism::Node
  # def initialize: (location: Location) -> void
  #
  # @return [TrueNode] a new instance of TrueNode
  #
  # source://prism//lib/prism/node.rb#16293
  sig { params(location: Prism::Location).void }
  def initialize(location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#16298
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#16303
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#16313
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#16308
  def compact_child_nodes; end

  # def copy: (**params) -> TrueNode
  #
  # source://prism//lib/prism/node.rb#16318
  sig { params(params: T.untyped).returns(Prism::TrueNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#16303
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#16328
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#16333
  def inspect(inspector = T.unsafe(nil)); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#16352
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#16362
    def type; end
  end
end

# Represents the use of the `undef` keyword.
#
#     undef :foo, :bar, :baz
#     ^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#16372
class Prism::UndefNode < ::Prism::Node
  # def initialize: (names: Array[Node], keyword_loc: Location, location: Location) -> void
  #
  # @return [UndefNode] a new instance of UndefNode
  #
  # source://prism//lib/prism/node.rb#16379
  sig { params(names: T::Array[Prism::Node], keyword_loc: Prism::Location, location: Prism::Location).void }
  def initialize(names, keyword_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#16386
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#16391
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#16401
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#16396
  def compact_child_nodes; end

  # def copy: (**params) -> UndefNode
  #
  # source://prism//lib/prism/node.rb#16406
  sig { params(params: T.untyped).returns(Prism::UndefNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#16391
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#16418
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#16428
  def inspect(inspector = T.unsafe(nil)); end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#16423
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#16376
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # attr_reader names: Array[Node]
  #
  # source://prism//lib/prism/node.rb#16373
  sig { returns(T::Array[Prism::Node]) }
  def names; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#16449
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#16459
    def type; end
  end
end

# Represents the use of the `unless` keyword, either in the block form or the modifier form.
#
#     bar unless foo
#     ^^^^^^^^^^^^^^
#
#     unless foo then bar end
#     ^^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#16472
class Prism::UnlessNode < ::Prism::Node
  # def initialize: (keyword_loc: Location, predicate: Node, then_keyword_loc: Location?, statements: StatementsNode?, consequent: ElseNode?, end_keyword_loc: Location?, location: Location) -> void
  #
  # @return [UnlessNode] a new instance of UnlessNode
  #
  # source://prism//lib/prism/node.rb#16491
  sig do
    params(
      keyword_loc: Prism::Location,
      predicate: Prism::Node,
      then_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode),
      consequent: T.nilable(Prism::ElseNode),
      end_keyword_loc: T.nilable(Prism::Location),
      location: Prism::Location
    ).void
  end
  def initialize(keyword_loc, predicate, then_keyword_loc, statements, consequent, end_keyword_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#16502
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#16511
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#16525
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#16516
  def compact_child_nodes; end

  # attr_reader consequent: ElseNode?
  #
  # source://prism//lib/prism/node.rb#16485
  sig { returns(T.nilable(Prism::ElseNode)) }
  def consequent; end

  # def copy: (**params) -> UnlessNode
  #
  # source://prism//lib/prism/node.rb#16530
  sig { params(params: T.untyped).returns(Prism::UnlessNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#16511
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#16546
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def end_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#16561
  sig { returns(T.nilable(String)) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location?
  #
  # source://prism//lib/prism/node.rb#16488
  sig { returns(T.nilable(Prism::Location)) }
  def end_keyword_loc; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#16566
  def inspect(inspector = T.unsafe(nil)); end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#16551
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#16473
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # attr_reader predicate: Node
  #
  # source://prism//lib/prism/node.rb#16476
  sig { returns(Prism::Node) }
  def predicate; end

  # source://prism//lib/prism/node.rb#16506
  def set_newline_flag(newline_marked); end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#16482
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # def then_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#16556
  sig { returns(T.nilable(String)) }
  def then_keyword; end

  # attr_reader then_keyword_loc: Location?
  #
  # source://prism//lib/prism/node.rb#16479
  sig { returns(T.nilable(Prism::Location)) }
  def then_keyword_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#16602
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#16612
    def type; end
  end
end

# Represents the use of the `until` keyword, either in the block form or the modifier form.
#
#     bar until foo
#     ^^^^^^^^^^^^^
#
#     until foo do bar end
#     ^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#16625
class Prism::UntilNode < ::Prism::Node
  # def initialize: (flags: Integer, keyword_loc: Location, closing_loc: Location?, predicate: Node, statements: StatementsNode?, location: Location) -> void
  #
  # @return [UntilNode] a new instance of UntilNode
  #
  # source://prism//lib/prism/node.rb#16641
  sig do
    params(
      flags: Integer,
      keyword_loc: Prism::Location,
      closing_loc: T.nilable(Prism::Location),
      predicate: Prism::Node,
      statements: T.nilable(Prism::StatementsNode),
      location: Prism::Location
    ).void
  end
  def initialize(flags, keyword_loc, closing_loc, predicate, statements, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#16651
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def begin_modifier?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16698
  sig { returns(T::Boolean) }
  def begin_modifier?; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#16660
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#16708
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#16632
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#16673
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#16665
  def compact_child_nodes; end

  # def copy: (**params) -> UntilNode
  #
  # source://prism//lib/prism/node.rb#16678
  sig { params(params: T.untyped).returns(Prism::UntilNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#16660
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#16693
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#16713
  def inspect(inspector = T.unsafe(nil)); end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#16703
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#16629
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # attr_reader predicate: Node
  #
  # source://prism//lib/prism/node.rb#16635
  sig { returns(Prism::Node) }
  def predicate; end

  # source://prism//lib/prism/node.rb#16655
  def set_newline_flag(newline_marked); end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#16638
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#16744
  def type; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#16626
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#16754
    def type; end
  end
end

# The version constant is set by reading the result of calling pm_version.
Prism::VERSION = T.let(T.unsafe(nil), String)

# A visitor is a class that provides a default implementation for every accept
# method defined on the nodes. This means it can walk a tree without the
# caller needing to define any special handling. This allows you to handle a
# subset of the tree, while still walking the whole tree.
#
# For example, to find all of the method calls that call the `foo` method, you
# could write:
#
#     class FooCalls < Prism::Visitor
#       def visit_call_node(node)
#         if node.name == "foo"
#           # Do something with the node
#         end
#
#         # Call super so that the visitor continues walking the tree
#         super
#       end
#     end
#
# source://prism//lib/prism/visitor.rb#51
class Prism::Visitor < ::Prism::BasicVisitor
  # Visit a AliasGlobalVariableNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::AliasGlobalVariableNode).void }
  def visit_alias_global_variable_node(node); end

  # Visit a AliasMethodNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::AliasMethodNode).void }
  def visit_alias_method_node(node); end

  # Visit a AlternationPatternNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::AlternationPatternNode).void }
  def visit_alternation_pattern_node(node); end

  # Visit a AndNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::AndNode).void }
  def visit_and_node(node); end

  # Visit a ArgumentsNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ArgumentsNode).void }
  def visit_arguments_node(node); end

  # Visit a ArrayNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ArrayNode).void }
  def visit_array_node(node); end

  # Visit a ArrayPatternNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ArrayPatternNode).void }
  def visit_array_pattern_node(node); end

  # Visit a AssocNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::AssocNode).void }
  def visit_assoc_node(node); end

  # Visit a AssocSplatNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::AssocSplatNode).void }
  def visit_assoc_splat_node(node); end

  # Visit a BackReferenceReadNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::BackReferenceReadNode).void }
  def visit_back_reference_read_node(node); end

  # Visit a BeginNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::BeginNode).void }
  def visit_begin_node(node); end

  # Visit a BlockArgumentNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::BlockArgumentNode).void }
  def visit_block_argument_node(node); end

  # Visit a BlockLocalVariableNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::BlockLocalVariableNode).void }
  def visit_block_local_variable_node(node); end

  # Visit a BlockNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::BlockNode).void }
  def visit_block_node(node); end

  # Visit a BlockParameterNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::BlockParameterNode).void }
  def visit_block_parameter_node(node); end

  # Visit a BlockParametersNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::BlockParametersNode).void }
  def visit_block_parameters_node(node); end

  # Visit a BreakNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::BreakNode).void }
  def visit_break_node(node); end

  # Visit a CallAndWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::CallAndWriteNode).void }
  def visit_call_and_write_node(node); end

  # Visit a CallNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::CallNode).void }
  def visit_call_node(node); end

  # Visit a CallOperatorWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::CallOperatorWriteNode).void }
  def visit_call_operator_write_node(node); end

  # Visit a CallOrWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::CallOrWriteNode).void }
  def visit_call_or_write_node(node); end

  # Visit a CallTargetNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::CallTargetNode).void }
  def visit_call_target_node(node); end

  # Visit a CapturePatternNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::CapturePatternNode).void }
  def visit_capture_pattern_node(node); end

  # Visit a CaseMatchNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::CaseMatchNode).void }
  def visit_case_match_node(node); end

  # Visit a CaseNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::CaseNode).void }
  def visit_case_node(node); end

  # Visit a ClassNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ClassNode).void }
  def visit_class_node(node); end

  # Visit a ClassVariableAndWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ClassVariableAndWriteNode).void }
  def visit_class_variable_and_write_node(node); end

  # Visit a ClassVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ClassVariableOperatorWriteNode).void }
  def visit_class_variable_operator_write_node(node); end

  # Visit a ClassVariableOrWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ClassVariableOrWriteNode).void }
  def visit_class_variable_or_write_node(node); end

  # Visit a ClassVariableReadNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ClassVariableReadNode).void }
  def visit_class_variable_read_node(node); end

  # Visit a ClassVariableTargetNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ClassVariableTargetNode).void }
  def visit_class_variable_target_node(node); end

  # Visit a ClassVariableWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ClassVariableWriteNode).void }
  def visit_class_variable_write_node(node); end

  # Visit a ConstantAndWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ConstantAndWriteNode).void }
  def visit_constant_and_write_node(node); end

  # Visit a ConstantOperatorWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ConstantOperatorWriteNode).void }
  def visit_constant_operator_write_node(node); end

  # Visit a ConstantOrWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ConstantOrWriteNode).void }
  def visit_constant_or_write_node(node); end

  # Visit a ConstantPathAndWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ConstantPathAndWriteNode).void }
  def visit_constant_path_and_write_node(node); end

  # Visit a ConstantPathNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ConstantPathNode).void }
  def visit_constant_path_node(node); end

  # Visit a ConstantPathOperatorWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ConstantPathOperatorWriteNode).void }
  def visit_constant_path_operator_write_node(node); end

  # Visit a ConstantPathOrWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ConstantPathOrWriteNode).void }
  def visit_constant_path_or_write_node(node); end

  # Visit a ConstantPathTargetNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ConstantPathTargetNode).void }
  def visit_constant_path_target_node(node); end

  # Visit a ConstantPathWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ConstantPathWriteNode).void }
  def visit_constant_path_write_node(node); end

  # Visit a ConstantReadNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ConstantReadNode).void }
  def visit_constant_read_node(node); end

  # Visit a ConstantTargetNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ConstantTargetNode).void }
  def visit_constant_target_node(node); end

  # Visit a ConstantWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ConstantWriteNode).void }
  def visit_constant_write_node(node); end

  # Visit a DefNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::DefNode).void }
  def visit_def_node(node); end

  # Visit a DefinedNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::DefinedNode).void }
  def visit_defined_node(node); end

  # Visit a ElseNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ElseNode).void }
  def visit_else_node(node); end

  # Visit a EmbeddedStatementsNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::EmbeddedStatementsNode).void }
  def visit_embedded_statements_node(node); end

  # Visit a EmbeddedVariableNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::EmbeddedVariableNode).void }
  def visit_embedded_variable_node(node); end

  # Visit a EnsureNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::EnsureNode).void }
  def visit_ensure_node(node); end

  # Visit a FalseNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::FalseNode).void }
  def visit_false_node(node); end

  # Visit a FindPatternNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::FindPatternNode).void }
  def visit_find_pattern_node(node); end

  # Visit a FlipFlopNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::FlipFlopNode).void }
  def visit_flip_flop_node(node); end

  # Visit a FloatNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::FloatNode).void }
  def visit_float_node(node); end

  # Visit a ForNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ForNode).void }
  def visit_for_node(node); end

  # Visit a ForwardingArgumentsNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ForwardingArgumentsNode).void }
  def visit_forwarding_arguments_node(node); end

  # Visit a ForwardingParameterNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ForwardingParameterNode).void }
  def visit_forwarding_parameter_node(node); end

  # Visit a ForwardingSuperNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ForwardingSuperNode).void }
  def visit_forwarding_super_node(node); end

  # Visit a GlobalVariableAndWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::GlobalVariableAndWriteNode).void }
  def visit_global_variable_and_write_node(node); end

  # Visit a GlobalVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::GlobalVariableOperatorWriteNode).void }
  def visit_global_variable_operator_write_node(node); end

  # Visit a GlobalVariableOrWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::GlobalVariableOrWriteNode).void }
  def visit_global_variable_or_write_node(node); end

  # Visit a GlobalVariableReadNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::GlobalVariableReadNode).void }
  def visit_global_variable_read_node(node); end

  # Visit a GlobalVariableTargetNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::GlobalVariableTargetNode).void }
  def visit_global_variable_target_node(node); end

  # Visit a GlobalVariableWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::GlobalVariableWriteNode).void }
  def visit_global_variable_write_node(node); end

  # Visit a HashNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::HashNode).void }
  def visit_hash_node(node); end

  # Visit a HashPatternNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::HashPatternNode).void }
  def visit_hash_pattern_node(node); end

  # Visit a IfNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::IfNode).void }
  def visit_if_node(node); end

  # Visit a ImaginaryNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ImaginaryNode).void }
  def visit_imaginary_node(node); end

  # Visit a ImplicitNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ImplicitNode).void }
  def visit_implicit_node(node); end

  # Visit a ImplicitRestNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ImplicitRestNode).void }
  def visit_implicit_rest_node(node); end

  # Visit a InNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::InNode).void }
  def visit_in_node(node); end

  # Visit a IndexAndWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::IndexAndWriteNode).void }
  def visit_index_and_write_node(node); end

  # Visit a IndexOperatorWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::IndexOperatorWriteNode).void }
  def visit_index_operator_write_node(node); end

  # Visit a IndexOrWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::IndexOrWriteNode).void }
  def visit_index_or_write_node(node); end

  # Visit a IndexTargetNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::IndexTargetNode).void }
  def visit_index_target_node(node); end

  # Visit a InstanceVariableAndWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::InstanceVariableAndWriteNode).void }
  def visit_instance_variable_and_write_node(node); end

  # Visit a InstanceVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::InstanceVariableOperatorWriteNode).void }
  def visit_instance_variable_operator_write_node(node); end

  # Visit a InstanceVariableOrWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::InstanceVariableOrWriteNode).void }
  def visit_instance_variable_or_write_node(node); end

  # Visit a InstanceVariableReadNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::InstanceVariableReadNode).void }
  def visit_instance_variable_read_node(node); end

  # Visit a InstanceVariableTargetNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::InstanceVariableTargetNode).void }
  def visit_instance_variable_target_node(node); end

  # Visit a InstanceVariableWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::InstanceVariableWriteNode).void }
  def visit_instance_variable_write_node(node); end

  # Visit a IntegerNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::IntegerNode).void }
  def visit_integer_node(node); end

  # Visit a InterpolatedMatchLastLineNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::InterpolatedMatchLastLineNode).void }
  def visit_interpolated_match_last_line_node(node); end

  # Visit a InterpolatedRegularExpressionNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::InterpolatedRegularExpressionNode).void }
  def visit_interpolated_regular_expression_node(node); end

  # Visit a InterpolatedStringNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::InterpolatedStringNode).void }
  def visit_interpolated_string_node(node); end

  # Visit a InterpolatedSymbolNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::InterpolatedSymbolNode).void }
  def visit_interpolated_symbol_node(node); end

  # Visit a InterpolatedXStringNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::InterpolatedXStringNode).void }
  def visit_interpolated_x_string_node(node); end

  # Visit a KeywordHashNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::KeywordHashNode).void }
  def visit_keyword_hash_node(node); end

  # Visit a KeywordRestParameterNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::KeywordRestParameterNode).void }
  def visit_keyword_rest_parameter_node(node); end

  # Visit a LambdaNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::LambdaNode).void }
  def visit_lambda_node(node); end

  # Visit a LocalVariableAndWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::LocalVariableAndWriteNode).void }
  def visit_local_variable_and_write_node(node); end

  # Visit a LocalVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::LocalVariableOperatorWriteNode).void }
  def visit_local_variable_operator_write_node(node); end

  # Visit a LocalVariableOrWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::LocalVariableOrWriteNode).void }
  def visit_local_variable_or_write_node(node); end

  # Visit a LocalVariableReadNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::LocalVariableReadNode).void }
  def visit_local_variable_read_node(node); end

  # Visit a LocalVariableTargetNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::LocalVariableTargetNode).void }
  def visit_local_variable_target_node(node); end

  # Visit a LocalVariableWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::LocalVariableWriteNode).void }
  def visit_local_variable_write_node(node); end

  # Visit a MatchLastLineNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::MatchLastLineNode).void }
  def visit_match_last_line_node(node); end

  # Visit a MatchPredicateNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::MatchPredicateNode).void }
  def visit_match_predicate_node(node); end

  # Visit a MatchRequiredNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::MatchRequiredNode).void }
  def visit_match_required_node(node); end

  # Visit a MatchWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::MatchWriteNode).void }
  def visit_match_write_node(node); end

  # Visit a MissingNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::MissingNode).void }
  def visit_missing_node(node); end

  # Visit a ModuleNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ModuleNode).void }
  def visit_module_node(node); end

  # Visit a MultiTargetNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::MultiTargetNode).void }
  def visit_multi_target_node(node); end

  # Visit a MultiWriteNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::MultiWriteNode).void }
  def visit_multi_write_node(node); end

  # Visit a NextNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::NextNode).void }
  def visit_next_node(node); end

  # Visit a NilNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::NilNode).void }
  def visit_nil_node(node); end

  # Visit a NoKeywordsParameterNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::NoKeywordsParameterNode).void }
  def visit_no_keywords_parameter_node(node); end

  # Visit a NumberedParametersNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::NumberedParametersNode).void }
  def visit_numbered_parameters_node(node); end

  # Visit a NumberedReferenceReadNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::NumberedReferenceReadNode).void }
  def visit_numbered_reference_read_node(node); end

  # Visit a OptionalKeywordParameterNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::OptionalKeywordParameterNode).void }
  def visit_optional_keyword_parameter_node(node); end

  # Visit a OptionalParameterNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::OptionalParameterNode).void }
  def visit_optional_parameter_node(node); end

  # Visit a OrNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::OrNode).void }
  def visit_or_node(node); end

  # Visit a ParametersNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ParametersNode).void }
  def visit_parameters_node(node); end

  # Visit a ParenthesesNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ParenthesesNode).void }
  def visit_parentheses_node(node); end

  # Visit a PinnedExpressionNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::PinnedExpressionNode).void }
  def visit_pinned_expression_node(node); end

  # Visit a PinnedVariableNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::PinnedVariableNode).void }
  def visit_pinned_variable_node(node); end

  # Visit a PostExecutionNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::PostExecutionNode).void }
  def visit_post_execution_node(node); end

  # Visit a PreExecutionNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::PreExecutionNode).void }
  def visit_pre_execution_node(node); end

  # Visit a ProgramNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ProgramNode).void }
  def visit_program_node(node); end

  # Visit a RangeNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::RangeNode).void }
  def visit_range_node(node); end

  # Visit a RationalNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::RationalNode).void }
  def visit_rational_node(node); end

  # Visit a RedoNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::RedoNode).void }
  def visit_redo_node(node); end

  # Visit a RegularExpressionNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::RegularExpressionNode).void }
  def visit_regular_expression_node(node); end

  # Visit a RequiredKeywordParameterNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::RequiredKeywordParameterNode).void }
  def visit_required_keyword_parameter_node(node); end

  # Visit a RequiredParameterNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::RequiredParameterNode).void }
  def visit_required_parameter_node(node); end

  # Visit a RescueModifierNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::RescueModifierNode).void }
  def visit_rescue_modifier_node(node); end

  # Visit a RescueNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::RescueNode).void }
  def visit_rescue_node(node); end

  # Visit a RestParameterNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::RestParameterNode).void }
  def visit_rest_parameter_node(node); end

  # Visit a RetryNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::RetryNode).void }
  def visit_retry_node(node); end

  # Visit a ReturnNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::ReturnNode).void }
  def visit_return_node(node); end

  # Visit a SelfNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::SelfNode).void }
  def visit_self_node(node); end

  # Visit a SingletonClassNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::SingletonClassNode).void }
  def visit_singleton_class_node(node); end

  # Visit a SourceEncodingNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::SourceEncodingNode).void }
  def visit_source_encoding_node(node); end

  # Visit a SourceFileNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::SourceFileNode).void }
  def visit_source_file_node(node); end

  # Visit a SourceLineNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::SourceLineNode).void }
  def visit_source_line_node(node); end

  # Visit a SplatNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::SplatNode).void }
  def visit_splat_node(node); end

  # Visit a StatementsNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::StatementsNode).void }
  def visit_statements_node(node); end

  # Visit a StringNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::StringNode).void }
  def visit_string_node(node); end

  # Visit a SuperNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::SuperNode).void }
  def visit_super_node(node); end

  # Visit a SymbolNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::SymbolNode).void }
  def visit_symbol_node(node); end

  # Visit a TrueNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::TrueNode).void }
  def visit_true_node(node); end

  # Visit a UndefNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::UndefNode).void }
  def visit_undef_node(node); end

  # Visit a UnlessNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::UnlessNode).void }
  def visit_unless_node(node); end

  # Visit a UntilNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::UntilNode).void }
  def visit_until_node(node); end

  # Visit a WhenNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::WhenNode).void }
  def visit_when_node(node); end

  # Visit a WhileNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::WhileNode).void }
  def visit_while_node(node); end

  # Visit a XStringNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::XStringNode).void }
  def visit_x_string_node(node); end

  # Visit a YieldNode node
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(node: Prism::YieldNode).void }
  def visit_yield_node(node); end
end

# Represents the use of the `when` keyword within a case statement.
#
#     case true
#     when true
#     ^^^^^^^^^
#     end
#
# source://prism//lib/prism/node.rb#16766
class Prism::WhenNode < ::Prism::Node
  # def initialize: (keyword_loc: Location, conditions: Array[Node], statements: StatementsNode?, location: Location) -> void
  #
  # @return [WhenNode] a new instance of WhenNode
  #
  # source://prism//lib/prism/node.rb#16776
  sig do
    params(
      keyword_loc: Prism::Location,
      conditions: T::Array[Prism::Node],
      statements: T.nilable(Prism::StatementsNode),
      location: Prism::Location
    ).void
  end
  def initialize(keyword_loc, conditions, statements, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#16784
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#16789
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#16802
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#16794
  def compact_child_nodes; end

  # attr_reader conditions: Array[Node]
  #
  # source://prism//lib/prism/node.rb#16770
  sig { returns(T::Array[Prism::Node]) }
  def conditions; end

  # def copy: (**params) -> WhenNode
  #
  # source://prism//lib/prism/node.rb#16807
  sig { params(params: T.untyped).returns(Prism::WhenNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#16789
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#16820
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#16830
  def inspect(inspector = T.unsafe(nil)); end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#16825
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#16767
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#16773
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#16857
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#16867
    def type; end
  end
end

# Represents the use of the `while` keyword, either in the block form or the modifier form.
#
#     bar while foo
#     ^^^^^^^^^^^^^
#
#     while foo do bar end
#     ^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#16880
class Prism::WhileNode < ::Prism::Node
  # def initialize: (flags: Integer, keyword_loc: Location, closing_loc: Location?, predicate: Node, statements: StatementsNode?, location: Location) -> void
  #
  # @return [WhileNode] a new instance of WhileNode
  #
  # source://prism//lib/prism/node.rb#16896
  sig do
    params(
      flags: Integer,
      keyword_loc: Prism::Location,
      closing_loc: T.nilable(Prism::Location),
      predicate: Prism::Node,
      statements: T.nilable(Prism::StatementsNode),
      location: Prism::Location
    ).void
  end
  def initialize(flags, keyword_loc, closing_loc, predicate, statements, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#16906
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def begin_modifier?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16953
  sig { returns(T::Boolean) }
  def begin_modifier?; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#16915
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#16963
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#16887
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#16928
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#16920
  def compact_child_nodes; end

  # def copy: (**params) -> WhileNode
  #
  # source://prism//lib/prism/node.rb#16933
  sig { params(params: T.untyped).returns(Prism::WhileNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#16915
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#16948
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#16968
  def inspect(inspector = T.unsafe(nil)); end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#16958
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#16884
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # attr_reader predicate: Node
  #
  # source://prism//lib/prism/node.rb#16890
  sig { returns(Prism::Node) }
  def predicate; end

  # source://prism//lib/prism/node.rb#16910
  def set_newline_flag(newline_marked); end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#16893
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#16999
  def type; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#16881
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#17009
    def type; end
  end
end

# Represents an xstring literal with no interpolation.
#
#     `foo`
#     ^^^^^
#
# source://prism//lib/prism/node.rb#17019
class Prism::XStringNode < ::Prism::Node
  include ::Prism::HeredocQuery

  # def initialize: (flags: Integer, opening_loc: Location, content_loc: Location, closing_loc: Location, unescaped: String, location: Location) -> void
  #
  # @return [XStringNode] a new instance of XStringNode
  #
  # source://prism//lib/prism/node.rb#17035
  sig do
    params(
      flags: Integer,
      opening_loc: Prism::Location,
      content_loc: Prism::Location,
      closing_loc: Prism::Location,
      unescaped: String,
      location: Prism::Location
    ).void
  end
  def initialize(flags, opening_loc, content_loc, closing_loc, unescaped, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#17045
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#17050
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#17105
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#17029
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#17060
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#17055
  def compact_child_nodes; end

  # def content: () -> String
  #
  # source://prism//lib/prism/node.rb#17100
  sig { returns(String) }
  def content; end

  # attr_reader content_loc: Location
  #
  # source://prism//lib/prism/node.rb#17026
  sig { returns(Prism::Location) }
  def content_loc; end

  # def copy: (**params) -> XStringNode
  #
  # source://prism//lib/prism/node.rb#17065
  sig { params(params: T.untyped).returns(Prism::XStringNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#17050
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#17080
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def forced_binary_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#17090
  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  # def forced_utf8_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#17085
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#17110
  def inspect(inspector = T.unsafe(nil)); end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#17095
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#17023
  sig { returns(Prism::Location) }
  def opening_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#17135
  def type; end

  # attr_reader unescaped: String
  #
  # source://prism//lib/prism/node.rb#17032
  sig { returns(String) }
  def unescaped; end

  private

  # Returns the value of attribute flags.
  #
  # source://prism//lib/prism/node.rb#17020
  sig { returns(Integer) }
  def flags; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#17145
    def type; end
  end
end

# Represents the use of the `yield` keyword.
#
#     yield 1
#     ^^^^^^^
#
# source://prism//lib/prism/node.rb#17155
class Prism::YieldNode < ::Prism::Node
  # def initialize: (keyword_loc: Location, lparen_loc: Location?, arguments: ArgumentsNode?, rparen_loc: Location?, location: Location) -> void
  #
  # @return [YieldNode] a new instance of YieldNode
  #
  # source://prism//lib/prism/node.rb#17168
  sig do
    params(
      keyword_loc: Prism::Location,
      lparen_loc: T.nilable(Prism::Location),
      arguments: T.nilable(Prism::ArgumentsNode),
      rparen_loc: T.nilable(Prism::Location),
      location: Prism::Location
    ).void
  end
  def initialize(keyword_loc, lparen_loc, arguments, rparen_loc, location); end

  # def accept: (visitor: Visitor) -> void
  #
  # source://prism//lib/prism/node.rb#17177
  sig { params(visitor: Prism::Visitor).void }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#17162
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#17182
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#17194
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#17187
  def compact_child_nodes; end

  # def copy: (**params) -> YieldNode
  #
  # source://prism//lib/prism/node.rb#17199
  sig { params(params: T.untyped).returns(Prism::YieldNode) }
  def copy(**params); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#17182
  sig { returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (keys: Array[Symbol]) -> Hash[Symbol, nil | Node | Array[Node] | String | Token | Array[Token] | Location]
  #
  # source://prism//lib/prism/node.rb#17213
  sig do
    params(
      keys: T::Array[Symbol]
    ).returns(T::Hash[Symbol, T.nilable(T.any(Prism::Node, T::Array[Prism::Node], String, Prism::Token, T::Array[Prism::Token], Prism::Location))])
  end
  def deconstruct_keys(keys); end

  # def inspect(inspector: NodeInspector) -> String
  #
  # source://prism//lib/prism/node.rb#17233
  def inspect(inspector = T.unsafe(nil)); end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#17218
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#17156
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # def lparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#17223
  sig { returns(T.nilable(String)) }
  def lparen; end

  # attr_reader lparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#17159
  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  # def rparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#17228
  sig { returns(T.nilable(String)) }
  def rparen; end

  # attr_reader rparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#17165
  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # def type: () -> Symbol
  #
  # source://prism//lib/prism/node.rb#17261
  def type; end

  class << self
    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # def self.type: () -> Symbol
    #
    # source://prism//lib/prism/node.rb#17271
    def type; end
  end
end
