# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rbi` gem.
# Please instead update this file by running `bin/tapioca gem rbi`.

# source://rbi//lib/rbi/loc.rb#4
module RBI; end

# source://rbi//lib/rbi/model.rb#968
class RBI::Arg < ::RBI::Node
  # source://rbi//lib/rbi/model.rb#980
  sig { params(value: ::String, loc: T.nilable(::RBI::Loc)).void }
  def initialize(value, loc: T.unsafe(nil)); end

  # source://rbi//lib/rbi/model.rb#986
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#613
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/model.rb#991
  sig { returns(::String) }
  def to_s; end

  # source://rbi//lib/rbi/model.rb#972
  sig { returns(::String) }
  def value; end
end

# Attributes
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#349
class RBI::Attr < ::RBI::NodeWithComments
  include ::RBI::Indexable

  abstract!

  # source://rbi//lib/rbi/model.rb#374
  sig do
    params(
      name: ::Symbol,
      names: T::Array[::Symbol],
      visibility: ::RBI::Visibility,
      sigs: T::Array[::RBI::Sig],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment]
    ).void
  end
  def initialize(name, names, visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#348
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#412
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # @abstract
  #
  # source://rbi//lib/rbi/model.rb#382
  sig { abstract.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/index.rb#113
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#420
  sig { override.params(other: ::RBI::Node).void }
  def merge_with(other); end

  # source://rbi//lib/rbi/model.rb#356
  sig { returns(T::Array[::Symbol]) }
  def names; end

  # source://rbi//lib/rbi/printer.rb#375
  sig { override.returns(T::Boolean) }
  def oneline?; end

  # source://rbi//lib/rbi/model.rb#362
  sig { returns(T::Array[::RBI::Sig]) }
  def sigs; end

  # source://rbi//lib/rbi/model.rb#359
  sig { returns(::RBI::Visibility) }
  def visibility; end

  # @return [Visibility]
  #
  # source://rbi//lib/rbi/model.rb#359
  def visibility=(_arg0); end
end

# source://rbi//lib/rbi/model.rb#385
class RBI::AttrAccessor < ::RBI::Attr
  # source://rbi//lib/rbi/model.rb#399
  sig do
    params(
      name: ::Symbol,
      names: ::Symbol,
      visibility: ::RBI::Visibility,
      sigs: T::Array[::RBI::Sig],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::AttrAccessor).void)
    ).void
  end
  def initialize(name, *names, visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#452
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#405
  sig { override.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/model.rb#411
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#417
class RBI::AttrReader < ::RBI::Attr
  # source://rbi//lib/rbi/model.rb#431
  sig do
    params(
      name: ::Symbol,
      names: ::Symbol,
      visibility: ::RBI::Visibility,
      sigs: T::Array[::RBI::Sig],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::AttrReader).void)
    ).void
  end
  def initialize(name, *names, visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#434
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#437
  sig { override.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/model.rb#443
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#449
class RBI::AttrWriter < ::RBI::Attr
  # source://rbi//lib/rbi/model.rb#463
  sig do
    params(
      name: ::Symbol,
      names: ::Symbol,
      visibility: ::RBI::Visibility,
      sigs: T::Array[::RBI::Sig],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::AttrWriter).void)
    ).void
  end
  def initialize(name, *names, visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#443
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#469
  sig { override.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/model.rb#475
  sig { override.returns(::String) }
  def to_s; end
end

# An arbitrary blank line that can be added both in trees and comments
#
# source://rbi//lib/rbi/model.rb#74
class RBI::BlankLine < ::RBI::Comment
  # source://rbi//lib/rbi/model.rb#78
  sig { params(loc: T.nilable(::RBI::Loc)).void }
  def initialize(loc: T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#217
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end
end

# source://rbi//lib/rbi/model.rb#741
class RBI::BlockParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#752
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::BlockParam).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#763
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#543
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/printer.rb#548
  sig { override.params(v: ::RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  # source://rbi//lib/rbi/model.rb#758
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#218
class RBI::Class < ::RBI::Scope
  # source://rbi//lib/rbi/model.rb#236
  sig do
    params(
      name: ::String,
      superclass_name: T.nilable(::String),
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Class).void)
    ).void
  end
  def initialize(name, superclass_name: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#376
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#244
  sig { override.returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/model.rb#222
  sig { returns(::String) }
  def name; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#222
  def name=(_arg0); end

  # source://rbi//lib/rbi/printer.rb#284
  sig { override.params(v: ::RBI::Printer).void }
  def print_header(v); end

  # source://rbi//lib/rbi/model.rb#225
  sig { returns(T.nilable(::String)) }
  def superclass_name; end

  # @return [String, nil]
  #
  # source://rbi//lib/rbi/model.rb#225
  def superclass_name=(_arg0); end
end

# source://rbi//lib/rbi/model.rb#53
class RBI::Comment < ::RBI::Node
  # source://rbi//lib/rbi/model.rb#60
  sig { params(text: ::String, loc: T.nilable(::RBI::Loc)).void }
  def initialize(text, loc: T.unsafe(nil)); end

  # source://rbi//lib/rbi/model.rb#66
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#197
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/model.rb#57
  sig { returns(::String) }
  def text; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#57
  def text=(_arg0); end
end

# A tree showing incompatibles nodes
#
# Is rendered as a merge conflict between `left` and` right`:
# ~~~rb
# class Foo
#   <<<<<<< left
#   def m1; end
#   def m2(a); end
#   =======
#   def m1(a); end
#   def m2; end
#   >>>>>>> right
# end
# ~~~
#
# source://rbi//lib/rbi/rewriters/merge_trees.rb#589
class RBI::ConflictTree < ::RBI::Tree
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#596
  sig { params(left_name: ::String, right_name: ::String).void }
  def initialize(left_name: T.unsafe(nil), right_name: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#607
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#593
  sig { returns(::RBI::Tree) }
  def left; end

  # @return [Tree]
  #
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#593
  def right; end
end

# Consts
#
# source://rbi//lib/rbi/model.rb#312
class RBI::Const < ::RBI::NodeWithComments
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#327
  sig do
    params(
      name: ::String,
      value: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Const).void)
    ).void
  end
  def initialize(name, value, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/printer.rb#335
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#403
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#335
  sig { returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/index.rb#103
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#316
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/model.rb#342
  sig { override.returns(::String) }
  def to_s; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#316
  def value; end
end

# source://rbi//lib/rbi/model.rb#816
class RBI::Extend < ::RBI::Mixin
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#828
  sig do
    params(
      name: ::String,
      names: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Extend).void)
    ).void
  end
  def initialize(name, *names, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#502
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/index.rb#143
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#834
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#137
class RBI::File
  # source://rbi//lib/rbi/model.rb#156
  sig do
    params(
      strictness: T.nilable(::String),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(file: ::RBI::File).void)
    ).void
  end
  def initialize(strictness: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#164
  sig { params(node: ::RBI::Node).void }
  def <<(node); end

  # source://rbi//lib/rbi/printer.rb#105
  sig { params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/model.rb#147
  sig { returns(T::Array[::RBI::Comment]) }
  def comments; end

  # @return [Array<Comment>]
  #
  # source://rbi//lib/rbi/model.rb#147
  def comments=(_arg0); end

  # source://rbi//lib/rbi/model.rb#169
  sig { returns(T::Boolean) }
  def empty?; end

  # source://rbi//lib/rbi/printer.rb#129
  sig do
    params(
      out: T.any(::IO, ::StringIO),
      indent: ::Integer,
      print_locs: T::Boolean,
      max_line_length: T.nilable(::Integer)
    ).void
  end
  def print(out: T.unsafe(nil), indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end

  # source://rbi//lib/rbi/model.rb#141
  sig { returns(::RBI::Tree) }
  def root; end

  # @return [Tree]
  #
  # source://rbi//lib/rbi/model.rb#141
  def root=(_arg0); end

  # source://rbi//lib/rbi/model.rb#144
  sig { returns(T.nilable(::String)) }
  def strictness; end

  # @return [String, nil]
  #
  # source://rbi//lib/rbi/model.rb#144
  def strictness=(_arg0); end

  # source://rbi//lib/rbi/printer.rb#135
  sig { params(indent: ::Integer, print_locs: T::Boolean, max_line_length: T.nilable(::Integer)).returns(::String) }
  def string(indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end
end

# source://rbi//lib/rbi/formatter.rb#5
class RBI::Formatter
  # source://rbi//lib/rbi/formatter.rb#36
  sig do
    params(
      add_sig_templates: T::Boolean,
      group_nodes: T::Boolean,
      max_line_length: T.nilable(::Integer),
      nest_singleton_methods: T::Boolean,
      nest_non_public_methods: T::Boolean,
      sort_nodes: T::Boolean
    ).void
  end
  def initialize(add_sig_templates: T.unsafe(nil), group_nodes: T.unsafe(nil), max_line_length: T.unsafe(nil), nest_singleton_methods: T.unsafe(nil), nest_non_public_methods: T.unsafe(nil), sort_nodes: T.unsafe(nil)); end

  # source://rbi//lib/rbi/formatter.rb#15
  sig { params(add_sig_templates: T::Boolean).returns(T::Boolean) }
  def add_sig_templates=(add_sig_templates); end

  # source://rbi//lib/rbi/formatter.rb#59
  sig { params(file: ::RBI::File).void }
  def format_file(file); end

  # source://rbi//lib/rbi/formatter.rb#64
  sig { params(tree: ::RBI::Tree).void }
  def format_tree(tree); end

  # source://rbi//lib/rbi/formatter.rb#18
  sig { params(group_nodes: T::Boolean).returns(T::Boolean) }
  def group_nodes=(group_nodes); end

  # source://rbi//lib/rbi/formatter.rb#24
  sig { returns(T.nilable(::Integer)) }
  def max_line_length; end

  # @return [Integer, nil]
  #
  # source://rbi//lib/rbi/formatter.rb#24
  def max_line_length=(_arg0); end

  # source://rbi//lib/rbi/formatter.rb#21
  sig { params(nest_non_public_methods: T::Boolean).returns(T::Boolean) }
  def nest_non_public_methods=(nest_non_public_methods); end

  # source://rbi//lib/rbi/formatter.rb#12
  sig { params(nest_singleton_methods: T::Boolean).returns(T::Boolean) }
  def nest_singleton_methods=(nest_singleton_methods); end

  # source://rbi//lib/rbi/formatter.rb#53
  sig { params(file: ::RBI::File).returns(::String) }
  def print_file(file); end

  # source://rbi//lib/rbi/formatter.rb#9
  sig { params(sort_nodes: T::Boolean).returns(T::Boolean) }
  def sort_nodes=(sort_nodes); end
end

# source://rbi//lib/rbi/rewriters/group_nodes.rb#88
class RBI::Group < ::RBI::Tree
  # source://rbi//lib/rbi/rewriters/group_nodes.rb#95
  sig { params(kind: ::RBI::Group::Kind).void }
  def initialize(kind); end

  # source://rbi//lib/rbi/printer.rb#838
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/group_nodes.rb#92
  sig { returns(::RBI::Group::Kind) }
  def kind; end
end

# source://rbi//lib/rbi/rewriters/group_nodes.rb#100
class RBI::Group::Kind < ::T::Enum
  enums do
    Mixins = new
    RequiredAncestors = new
    Helpers = new
    TypeMembers = new
    MixesInClassMethods = new
    Sends = new
    Attrs = new
    TStructFields = new
    TEnums = new
    Inits = new
    Methods = new
    SingletonClasses = new
    Consts = new
  end
end

# Sorbet's misc.
#
# source://rbi//lib/rbi/model.rb#1294
class RBI::Helper < ::RBI::NodeWithComments
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1308
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Helper).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/printer.rb#825
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#520
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/index.rb#173
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#1298
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/model.rb#1315
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#793
class RBI::Include < ::RBI::Mixin
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#805
  sig do
    params(
      name: ::String,
      names: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Include).void)
    ).void
  end
  def initialize(name, *names, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#493
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/index.rb#133
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#811
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/index.rb#5
class RBI::Index < ::RBI::Visitor
  # source://rbi//lib/rbi/index.rb#21
  sig { void }
  def initialize; end

  # source://rbi//lib/rbi/index.rb#32
  sig { params(id: ::String).returns(T::Array[::RBI::Node]) }
  def [](id); end

  # source://rbi//lib/rbi/index.rb#37
  sig { params(nodes: ::RBI::Node).void }
  def index(*nodes); end

  # source://rbi//lib/rbi/index.rb#27
  sig { returns(T::Array[::String]) }
  def keys; end

  # source://rbi//lib/rbi/index.rb#42
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/index.rb#59
  sig { params(node: T.all(::RBI::Indexable, ::RBI::Node)).void }
  def index_node(node); end

  class << self
    # source://rbi//lib/rbi/index.rb#13
    sig { params(node: ::RBI::Node).returns(::RBI::Index) }
    def index(*node); end
  end
end

# A Node that can be refered to by a unique ID inside an index
#
# @abstract Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/index.rb#74
module RBI::Indexable
  interface!

  # Unique IDs that refer to this node.
  #
  # Some nodes can have multiple ids, for example an attribute accessor matches the ID of the
  # getter and the setter.
  #
  # @abstract
  #
  # source://rbi//lib/rbi/index.rb#85
  sig { abstract.returns(T::Array[::String]) }
  def index_ids; end
end

# source://rbi//lib/rbi/model.rb#996
class RBI::KwArg < ::RBI::Arg
  # source://rbi//lib/rbi/model.rb#1009
  sig { params(keyword: ::String, value: ::String, loc: T.nilable(::RBI::Loc)).void }
  def initialize(keyword, value, loc: T.unsafe(nil)); end

  # source://rbi//lib/rbi/model.rb#1015
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#622
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/model.rb#1000
  sig { returns(::String) }
  def keyword; end

  # source://rbi//lib/rbi/model.rb#1020
  sig { returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#682
class RBI::KwOptParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#697
  sig do
    params(
      name: ::String,
      value: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::KwOptParam).void)
    ).void
  end
  def initialize(name, value, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#709
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#513
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/printer.rb#518
  sig { override.params(v: ::RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  # source://rbi//lib/rbi/model.rb#704
  sig { override.returns(::String) }
  def to_s; end

  # source://rbi//lib/rbi/model.rb#686
  sig { returns(::String) }
  def value; end
end

# source://rbi//lib/rbi/model.rb#655
class RBI::KwParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#666
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::KwParam).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#677
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#498
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/printer.rb#503
  sig { override.params(v: ::RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  # source://rbi//lib/rbi/model.rb#672
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#714
class RBI::KwRestParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#725
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::KwRestParam).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#736
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#528
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/printer.rb#533
  sig { override.params(v: ::RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  # source://rbi//lib/rbi/model.rb#731
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/loc.rb#5
class RBI::Loc
  # source://rbi//lib/rbi/loc.rb#38
  sig do
    params(
      file: T.nilable(::String),
      begin_line: T.nilable(::Integer),
      end_line: T.nilable(::Integer),
      begin_column: T.nilable(::Integer),
      end_column: T.nilable(::Integer)
    ).void
  end
  def initialize(file: T.unsafe(nil), begin_line: T.unsafe(nil), end_line: T.unsafe(nil), begin_column: T.unsafe(nil), end_column: T.unsafe(nil)); end

  # @return [Integer, nil]
  #
  # source://rbi//lib/rbi/loc.rb#27
  def begin_column; end

  # source://rbi//lib/rbi/loc.rb#27
  sig { returns(T.nilable(::Integer)) }
  def begin_line; end

  # @return [Integer, nil]
  #
  # source://rbi//lib/rbi/loc.rb#27
  def end_column; end

  # @return [Integer, nil]
  #
  # source://rbi//lib/rbi/loc.rb#27
  def end_line; end

  # source://rbi//lib/rbi/loc.rb#24
  sig { returns(T.nilable(::String)) }
  def file; end

  # source://rbi//lib/rbi/loc.rb#56
  sig { returns(T.nilable(::String)) }
  def source; end

  # source://rbi//lib/rbi/loc.rb#47
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://rbi//lib/rbi/loc.rb#12
    sig { params(file: ::String, prism_location: ::Prism::Location).returns(::RBI::Loc) }
    def from_prism(file, prism_location); end
  end
end

# A tree that _might_ contain conflicts
#
# source://rbi//lib/rbi/rewriters/merge_trees.rb#330
class RBI::MergeTree < ::RBI::Tree
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#344
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      conflicts: T::Array[::RBI::Rewriters::Merge::Conflict],
      block: T.nilable(T.proc.params(node: ::RBI::Tree).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), conflicts: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#334
  sig { returns(T::Array[::RBI::Rewriters::Merge::Conflict]) }
  def conflicts; end
end

# Methods and args
#
# source://rbi//lib/rbi/model.rb#483
class RBI::Method < ::RBI::NodeWithComments
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#513
  sig do
    params(
      name: ::String,
      params: T::Array[::RBI::Param],
      is_singleton: T::Boolean,
      visibility: ::RBI::Visibility,
      sigs: T::Array[::RBI::Sig],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Method).void)
    ).void
  end
  def initialize(name, params: T.unsafe(nil), is_singleton: T.unsafe(nil), visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#533
  sig { params(param: ::RBI::Param).void }
  def <<(param); end

  # source://rbi//lib/rbi/printer.rb#384
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#461
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#538
  sig { returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/index.rb#123
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/printer.rb#437
  sig { returns(T::Boolean) }
  def inline_params?; end

  # source://rbi//lib/rbi/model.rb#493
  sig { returns(T::Boolean) }
  def is_singleton; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#493
  def is_singleton=(_arg0); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#470
  sig { override.params(other: ::RBI::Node).void }
  def merge_with(other); end

  # source://rbi//lib/rbi/model.rb#487
  sig { returns(::String) }
  def name; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#487
  def name=(_arg0); end

  # source://rbi//lib/rbi/printer.rb#432
  sig { override.returns(T::Boolean) }
  def oneline?; end

  # source://rbi//lib/rbi/model.rb#490
  sig { returns(T::Array[::RBI::Param]) }
  def params; end

  # source://rbi//lib/rbi/model.rb#499
  sig { returns(T::Array[::RBI::Sig]) }
  def sigs; end

  # @return [Array<Sig>]
  #
  # source://rbi//lib/rbi/model.rb#499
  def sigs=(_arg0); end

  # source://rbi//lib/rbi/model.rb#547
  sig { override.returns(::String) }
  def to_s; end

  # source://rbi//lib/rbi/model.rb#496
  sig { returns(::RBI::Visibility) }
  def visibility; end

  # @return [Visibility]
  #
  # source://rbi//lib/rbi/model.rb#496
  def visibility=(_arg0); end
end

# source://rbi//lib/rbi/model.rb#1355
class RBI::MixesInClassMethods < ::RBI::Mixin
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1367
  sig do
    params(
      name: ::String,
      names: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::MixesInClassMethods).void)
    ).void
  end
  def initialize(name, *names, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#511
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/index.rb#153
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#1373
  sig { override.returns(::String) }
  def to_s; end
end

# Mixins
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#770
class RBI::Mixin < ::RBI::NodeWithComments
  abstract!

  # source://rbi//lib/rbi/model.rb#787
  sig do
    params(
      name: ::String,
      names: T::Array[::String],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment]
    ).void
  end
  def initialize(name, names, loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#558
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#484
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#777
  sig { returns(T::Array[::String]) }
  def names; end
end

# source://rbi//lib/rbi/model.rb#190
class RBI::Module < ::RBI::Scope
  # source://rbi//lib/rbi/model.rb#204
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Module).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#385
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#211
  sig { override.returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/model.rb#194
  sig { returns(::String) }
  def name; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#194
  def name=(_arg0); end

  # source://rbi//lib/rbi/printer.rb#270
  sig { override.params(v: ::RBI::Printer).void }
  def print_header(v); end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#5
class RBI::Node
  abstract!

  # source://rbi//lib/rbi/model.rb#18
  sig { params(loc: T.nilable(::RBI::Loc)).void }
  def initialize(loc: T.unsafe(nil)); end

  # @abstract
  #
  # source://rbi//lib/rbi/printer.rb#146
  sig { abstract.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # Can `self` and `_other` be merged into a single definition?
  #
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#287
  sig { params(_other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(_other); end

  # source://rbi//lib/rbi/model.rb#24
  sig { void }
  def detach; end

  # source://rbi//lib/rbi/rewriters/group_nodes.rb#48
  sig { returns(::RBI::Group::Kind) }
  def group_kind; end

  # source://rbi//lib/rbi/model.rb#15
  sig { returns(T.nilable(::RBI::Loc)) }
  def loc; end

  # @return [Loc, nil]
  #
  # source://rbi//lib/rbi/model.rb#15
  def loc=(_arg0); end

  # Merge `self` and `other` into a single definition
  #
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#293
  sig { params(other: ::RBI::Node).void }
  def merge_with(other); end

  # source://rbi//lib/rbi/printer.rb#179
  sig { returns(T::Boolean) }
  def oneline?; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#296
  sig { returns(T.nilable(::RBI::ConflictTree)) }
  def parent_conflict_tree; end

  # source://rbi//lib/rbi/model.rb#46
  sig { returns(T.nilable(::RBI::Scope)) }
  def parent_scope; end

  # source://rbi//lib/rbi/model.rb#12
  sig { returns(T.nilable(::RBI::Tree)) }
  def parent_tree; end

  # @return [Tree, nil]
  #
  # source://rbi//lib/rbi/model.rb#12
  def parent_tree=(_arg0); end

  # source://rbi//lib/rbi/printer.rb#156
  sig do
    params(
      out: T.any(::IO, ::StringIO),
      indent: ::Integer,
      print_locs: T::Boolean,
      max_line_length: T.nilable(::Integer)
    ).void
  end
  def print(out: T.unsafe(nil), indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#169
  sig { params(v: ::RBI::Printer).void }
  def print_blank_line_before(v); end

  # source://rbi//lib/rbi/model.rb#33
  sig { params(node: ::RBI::Node).void }
  def replace(node); end

  # source://rbi//lib/rbi/printer.rb#162
  sig { params(indent: ::Integer, print_locs: T::Boolean, max_line_length: T.nilable(::Integer)).returns(::String) }
  def string(indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#83
class RBI::NodeWithComments < ::RBI::Node
  abstract!

  # source://rbi//lib/rbi/model.rb#93
  sig { params(loc: T.nilable(::RBI::Loc), comments: T::Array[::RBI::Comment]).void }
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/model.rb#99
  sig { returns(T::Array[::String]) }
  def annotations; end

  # source://rbi//lib/rbi/model.rb#90
  sig { returns(T::Array[::RBI::Comment]) }
  def comments; end

  # @return [Array<Comment>]
  #
  # source://rbi//lib/rbi/model.rb#90
  def comments=(_arg0); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#311
  sig { override.params(other: ::RBI::Node).void }
  def merge_with(other); end

  # source://rbi//lib/rbi/printer.rb#188
  sig { override.returns(T::Boolean) }
  def oneline?; end
end

# source://rbi//lib/rbi/model.rb#601
class RBI::OptParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#616
  sig do
    params(
      name: ::String,
      value: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::OptParam).void)
    ).void
  end
  def initialize(name, value, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#623
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#468
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/printer.rb#473
  sig { override.params(v: ::RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  # source://rbi//lib/rbi/model.rb#605
  sig { returns(::String) }
  def value; end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#552
class RBI::Param < ::RBI::NodeWithComments
  abstract!

  # source://rbi//lib/rbi/model.rb#568
  sig { params(name: ::String, loc: T.nilable(::RBI::Loc), comments: T::Array[::RBI::Comment]).void }
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#446
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/printer.rb#459
  sig { returns(T::Array[::String]) }
  def comments_lines; end

  # source://rbi//lib/rbi/model.rb#559
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/printer.rb#451
  sig { params(v: ::RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  # source://rbi//lib/rbi/model.rb#574
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/parser.rb#7
class RBI::ParseError < ::StandardError
  # source://rbi//lib/rbi/parser.rb#14
  sig { params(message: ::String, location: ::RBI::Loc).void }
  def initialize(message, location); end

  # source://rbi//lib/rbi/parser.rb#11
  sig { returns(::RBI::Loc) }
  def location; end
end

# source://rbi//lib/rbi/parser.rb#53
class RBI::Parser
  # source://rbi//lib/rbi/parser.rb#88
  sig { params(path: ::String).returns(::RBI::Tree) }
  def parse_file(path); end

  # source://rbi//lib/rbi/parser.rb#83
  sig { params(string: ::String).returns(::RBI::Tree) }
  def parse_string(string); end

  private

  # source://rbi//lib/rbi/parser.rb#95
  sig { params(source: ::String, file: ::String).returns(::RBI::Tree) }
  def parse(source, file:); end

  class << self
    # source://rbi//lib/rbi/parser.rb#65
    sig { params(path: ::String).returns(::RBI::Tree) }
    def parse_file(path); end

    # source://rbi//lib/rbi/parser.rb#70
    sig { params(paths: T::Array[::String]).returns(T::Array[::RBI::Tree]) }
    def parse_files(paths); end

    # source://rbi//lib/rbi/parser.rb#60
    sig { params(string: ::String).returns(::RBI::Tree) }
    def parse_string(string); end

    # source://rbi//lib/rbi/parser.rb#76
    sig { params(strings: T::Array[::String]).returns(T::Array[::RBI::Tree]) }
    def parse_strings(strings); end
  end
end

# source://rbi//lib/rbi/parser.rb#791
class RBI::Parser::SigBuilder < ::RBI::Parser::Visitor
  # source://rbi//lib/rbi/parser.rb#798
  sig { params(content: ::String, file: ::String).void }
  def initialize(content, file:); end

  # source://rbi//lib/rbi/parser.rb#795
  sig { returns(::RBI::Sig) }
  def current; end

  # source://rbi//lib/rbi/parser.rb#850
  sig { override.params(node: ::Prism::AssocNode).void }
  def visit_assoc_node(node); end

  # source://rbi//lib/rbi/parser.rb#805
  sig { override.params(node: ::Prism::CallNode).void }
  def visit_call_node(node); end
end

# source://rbi//lib/rbi/parser.rb#153
class RBI::Parser::TreeBuilder < ::RBI::Parser::Visitor
  # source://rbi//lib/rbi/parser.rb#163
  sig { params(source: ::String, comments: T::Array[::Prism::Comment], file: ::String).void }
  def initialize(source, comments:, file:); end

  # source://rbi//lib/rbi/parser.rb#160
  sig { returns(T.nilable(::Prism::Node)) }
  def last_node; end

  # source://rbi//lib/rbi/parser.rb#157
  sig { returns(::RBI::Tree) }
  def tree; end

  # source://rbi//lib/rbi/parser.rb#299
  sig { params(node: ::Prism::CallNode).void }
  def visit_call_node(node); end

  # source://rbi//lib/rbi/parser.rb#176
  sig { override.params(node: ::Prism::ClassNode).void }
  def visit_class_node(node); end

  # source://rbi//lib/rbi/parser.rb#208
  sig { params(node: T.any(::Prism::ConstantPathWriteNode, ::Prism::ConstantWriteNode)).void }
  def visit_constant_assign(node); end

  # source://rbi//lib/rbi/parser.rb#201
  sig { override.params(node: ::Prism::ConstantPathWriteNode).void }
  def visit_constant_path_write_node(node); end

  # source://rbi//lib/rbi/parser.rb#194
  sig { override.params(node: ::Prism::ConstantWriteNode).void }
  def visit_constant_write_node(node); end

  # source://rbi//lib/rbi/parser.rb#241
  sig { override.params(node: ::Prism::DefNode).void }
  def visit_def_node(node); end

  # source://rbi//lib/rbi/parser.rb#255
  sig { override.params(node: ::Prism::ModuleNode).void }
  def visit_module_node(node); end

  # source://rbi//lib/rbi/parser.rb#272
  sig { override.params(node: ::Prism::ProgramNode).void }
  def visit_program_node(node); end

  # source://rbi//lib/rbi/parser.rb#283
  sig { override.params(node: ::Prism::SingletonClassNode).void }
  def visit_singleton_class_node(node); end

  private

  # Collect all the remaining comments within a node
  #
  # source://rbi//lib/rbi/parser.rb#467
  sig { params(node: ::Prism::Node).void }
  def collect_dangling_comments(node); end

  # Collect all the remaining comments after visiting the tree
  #
  # source://rbi//lib/rbi/parser.rb#485
  sig { void }
  def collect_orphan_comments; end

  # source://rbi//lib/rbi/parser.rb#508
  sig { returns(::RBI::Tree) }
  def current_scope; end

  # source://rbi//lib/rbi/parser.rb#513
  sig { returns(T::Array[::RBI::Sig]) }
  def current_sigs; end

  # source://rbi//lib/rbi/parser.rb#520
  sig { returns(T::Array[::RBI::Comment]) }
  def current_sigs_comments; end

  # source://rbi//lib/rbi/parser.rb#527
  sig { params(node: ::Prism::Node).returns(T::Array[::RBI::Comment]) }
  def node_comments(node); end

  # source://rbi//lib/rbi/parser.rb#545
  sig { params(node: ::Prism::Comment).returns(::RBI::Comment) }
  def parse_comment(node); end

  # source://rbi//lib/rbi/parser.rb#574
  sig { params(node: T.nilable(::Prism::Node)).returns(T::Array[::RBI::Param]) }
  def parse_params(node); end

  # source://rbi//lib/rbi/parser.rb#550
  sig { params(node: T.nilable(::Prism::Node)).returns(T::Array[::RBI::Arg]) }
  def parse_send_args(node); end

  # source://rbi//lib/rbi/parser.rb#648
  sig { params(node: ::Prism::CallNode).returns(::RBI::Sig) }
  def parse_sig(node); end

  # source://rbi//lib/rbi/parser.rb#658
  sig do
    params(
      node: T.any(::Prism::ConstantPathWriteNode, ::Prism::ConstantWriteNode)
    ).returns(T.nilable(::RBI::Struct))
  end
  def parse_struct(node); end

  # source://rbi//lib/rbi/parser.rb#708
  sig { params(send: ::Prism::CallNode).void }
  def parse_tstruct_field(send); end

  # source://rbi//lib/rbi/parser.rb#745
  sig { params(name: ::String, node: ::Prism::Node).returns(::RBI::Visibility) }
  def parse_visibility(name, node); end

  # source://rbi//lib/rbi/parser.rb#759
  sig { void }
  def separate_header_comments; end

  # source://rbi//lib/rbi/parser.rb#769
  sig { void }
  def set_root_tree_loc; end

  # source://rbi//lib/rbi/parser.rb#783
  sig { params(node: T.nilable(::Prism::Node)).returns(T::Boolean) }
  def type_variable_definition?(node); end
end

# source://rbi//lib/rbi/parser.rb#122
class RBI::Parser::Visitor < ::Prism::Visitor
  # source://rbi//lib/rbi/parser.rb#126
  sig { params(source: ::String, file: ::String).void }
  def initialize(source, file:); end

  private

  # source://rbi//lib/rbi/parser.rb#136
  sig { params(node: ::Prism::Node).returns(::RBI::Loc) }
  def node_loc(node); end

  # source://rbi//lib/rbi/parser.rb#141
  sig { params(node: T.nilable(::Prism::Node)).returns(T.nilable(::String)) }
  def node_string(node); end

  # source://rbi//lib/rbi/parser.rb#148
  sig { params(node: ::Prism::Node).returns(::String) }
  def node_string!(node); end
end

# source://rbi//lib/rbi/printer.rb#5
class RBI::Printer < ::RBI::Visitor
  # source://rbi//lib/rbi/printer.rb#28
  sig do
    params(
      out: T.any(::IO, ::StringIO),
      indent: ::Integer,
      print_locs: T::Boolean,
      max_line_length: T.nilable(::Integer)
    ).void
  end
  def initialize(out: T.unsafe(nil), indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#15
  sig { returns(::Integer) }
  def current_indent; end

  # source://rbi//lib/rbi/printer.rb#46
  sig { void }
  def dedent; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/printer.rb#9
  def in_visibility_group; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/printer.rb#9
  def in_visibility_group=(_arg0); end

  # Printing
  #
  # source://rbi//lib/rbi/printer.rb#41
  sig { void }
  def indent; end

  # source://rbi//lib/rbi/printer.rb#18
  sig { returns(T.nilable(::Integer)) }
  def max_line_length; end

  # source://rbi//lib/rbi/printer.rb#12
  sig { returns(T.nilable(::RBI::Node)) }
  def previous_node; end

  # Print a string without indentation nor `\n` at the end.
  #
  # source://rbi//lib/rbi/printer.rb#52
  sig { params(string: ::String).void }
  def print(string); end

  # source://rbi//lib/rbi/printer.rb#9
  sig { returns(T::Boolean) }
  def print_locs; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/printer.rb#9
  def print_locs=(_arg0); end

  # Print a string with indentation and `\n` at the end.
  #
  # source://rbi//lib/rbi/printer.rb#72
  sig { params(string: ::String).void }
  def printl(string); end

  # Print a string without indentation but with a `\n` at the end.
  #
  # source://rbi//lib/rbi/printer.rb#58
  sig { params(string: T.nilable(::String)).void }
  def printn(string = T.unsafe(nil)); end

  # Print a string with indentation but without a `\n` at the end.
  #
  # source://rbi//lib/rbi/printer.rb#65
  sig { params(string: T.nilable(::String)).void }
  def printt(string = T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#83
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  # source://rbi//lib/rbi/printer.rb#90
  sig { override.params(nodes: T::Array[::RBI::Node]).void }
  def visit_all(nodes); end

  # source://rbi//lib/rbi/printer.rb#78
  sig { params(file: ::RBI::File).void }
  def visit_file(file); end
end

# source://rbi//lib/rbi/model.rb#909
class RBI::Private < ::RBI::Visibility
  # source://rbi//lib/rbi/model.rb#919
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Private).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

# source://rbi//lib/rbi/model.rb#893
class RBI::Protected < ::RBI::Visibility
  # source://rbi//lib/rbi/model.rb#903
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Protected).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

# source://rbi//lib/rbi/model.rb#877
class RBI::Public < ::RBI::Visibility
  # source://rbi//lib/rbi/model.rb#887
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Public).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

# source://rbi//lib/rbi/model.rb#579
class RBI::ReqParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#590
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::ReqParam).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#596
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end
end

# source://rbi//lib/rbi/model.rb#1378
class RBI::RequiresAncestor < ::RBI::NodeWithComments
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1391
  sig { params(name: ::String, loc: T.nilable(::RBI::Loc), comments: T::Array[::RBI::Comment]).void }
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#870
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/index.rb#163
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#1382
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/model.rb#1397
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#628
class RBI::RestParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#639
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::RestParam).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#650
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#483
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/printer.rb#488
  sig { override.params(v: ::RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  # source://rbi//lib/rbi/model.rb#645
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/rewriters/add_sig_templates.rb#5
module RBI::Rewriters; end

# source://rbi//lib/rbi/rewriters/add_sig_templates.rb#6
class RBI::Rewriters::AddSigTemplates < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/add_sig_templates.rb#10
  sig { params(with_todo_comment: T::Boolean).void }
  def initialize(with_todo_comment: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/add_sig_templates.rb#16
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/rewriters/add_sig_templates.rb#30
  sig { params(attr: ::RBI::Attr).void }
  def add_attr_sig(attr); end

  # source://rbi//lib/rbi/rewriters/add_sig_templates.rb#45
  sig { params(method: ::RBI::Method).void }
  def add_method_sig(method); end

  # source://rbi//lib/rbi/rewriters/add_sig_templates.rb#56
  sig { params(node: ::RBI::NodeWithComments).void }
  def add_todo_comment(node); end
end

# source://rbi//lib/rbi/rewriters/annotate.rb#6
class RBI::Rewriters::Annotate < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/annotate.rb#10
  sig { params(annotation: ::String, annotate_scopes: T::Boolean, annotate_properties: T::Boolean).void }
  def initialize(annotation, annotate_scopes: T.unsafe(nil), annotate_properties: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/annotate.rb#18
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/rewriters/annotate.rb#31
  sig { params(node: ::RBI::NodeWithComments).void }
  def annotate_node(node); end

  # source://rbi//lib/rbi/rewriters/annotate.rb#38
  sig { params(node: ::RBI::Node).returns(T::Boolean) }
  def root?(node); end
end

# source://rbi//lib/rbi/rewriters/deannotate.rb#6
class RBI::Rewriters::Deannotate < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/deannotate.rb#10
  sig { params(annotation: ::String).void }
  def initialize(annotation); end

  # source://rbi//lib/rbi/rewriters/deannotate.rb#16
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/rewriters/deannotate.rb#27
  sig { params(node: ::RBI::NodeWithComments).void }
  def deannotate_node(node); end
end

# source://rbi//lib/rbi/rewriters/group_nodes.rb#6
class RBI::Rewriters::GroupNodes < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/group_nodes.rb#10
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end
end

# Merge two RBI trees together
#
# Be this `Tree`:
# ~~~rb
# class Foo
#   attr_accessor :a
#   def m; end
#   C = 10
# end
# ~~~
#
# Merged with this one:
# ~~~rb
# class Foo
#   attr_reader :a
#   def m(x); end
#   C = 10
# end
# ~~~
#
# Compatible definitions are merged together while incompatible definitions are moved into a `ConflictTree`:
# ~~~rb
# class Foo
#   <<<<<<< left
#   attr_accessor :a
#   def m; end
#   =======
#   attr_reader :a
#   def m(x); end
#   >>>>>>> right
#   C = 10
# end
# ~~~
#
# source://rbi//lib/rbi/rewriters/merge_trees.rb#39
class RBI::Rewriters::Merge
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#70
  sig { params(left_name: ::String, right_name: ::String, keep: ::RBI::Rewriters::Merge::Keep).void }
  def initialize(left_name: T.unsafe(nil), right_name: T.unsafe(nil), keep: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#79
  sig { params(tree: ::RBI::Tree).void }
  def merge(tree); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#67
  sig { returns(::RBI::MergeTree) }
  def tree; end

  class << self
    # source://rbi//lib/rbi/rewriters/merge_trees.rb#54
    sig do
      params(
        left: ::RBI::Tree,
        right: ::RBI::Tree,
        left_name: ::String,
        right_name: ::String,
        keep: ::RBI::Rewriters::Merge::Keep
      ).returns(::RBI::MergeTree)
    end
    def merge_trees(left, right, left_name: T.unsafe(nil), right_name: T.unsafe(nil), keep: T.unsafe(nil)); end
  end
end

# Used for logging / error displaying purpose
#
# source://rbi//lib/rbi/rewriters/merge_trees.rb#86
class RBI::Rewriters::Merge::Conflict < ::T::Struct
  const :left, ::RBI::Node
  const :right, ::RBI::Node
  const :left_name, ::String
  const :right_name, ::String

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#95
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://sorbet-runtime/0.5.11155/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# Merge adjacent conflict trees
#
# Transform this:
# ~~~rb
# class Foo
#   <<<<<<< left
#   def m1; end
#   =======
#   def m1(a); end
#   >>>>>>> right
#   <<<<<<< left
#   def m2(a); end
#   =======
#   def m2; end
#   >>>>>>> right
# end
# ~~~
#
# Into this:
# ~~~rb
# class Foo
#   <<<<<<< left
#   def m1; end
#   def m2(a); end
#   =======
#   def m1(a); end
#   def m2; end
#   >>>>>>> right
# end
# ~~~
#
# source://rbi//lib/rbi/rewriters/merge_trees.rb#245
class RBI::Rewriters::Merge::ConflictTreeMerger < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#247
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#252
  sig { override.params(nodes: T::Array[::RBI::Node]).void }
  def visit_all(nodes); end

  private

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#273
  sig { params(left: ::RBI::Tree, right: ::RBI::Tree).void }
  def merge_conflict_trees(left, right); end
end

# source://rbi//lib/rbi/rewriters/merge_trees.rb#42
class RBI::Rewriters::Merge::Keep < ::T::Enum
  enums do
    NONE = new
    LEFT = new
    RIGHT = new
  end
end

# source://rbi//lib/rbi/rewriters/merge_trees.rb#100
class RBI::Rewriters::Merge::TreeMerger < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#107
  sig do
    params(
      output: ::RBI::Tree,
      left_name: ::String,
      right_name: ::String,
      keep: ::RBI::Rewriters::Merge::Keep
    ).void
  end
  def initialize(output, left_name: T.unsafe(nil), right_name: T.unsafe(nil), keep: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#104
  sig { returns(T::Array[::RBI::Rewriters::Merge::Conflict]) }
  def conflicts; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#119
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#168
  sig { returns(::RBI::Tree) }
  def current_scope; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#185
  sig { params(left: ::RBI::Scope, right: ::RBI::Scope).void }
  def make_conflict_scope(left, right); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#192
  sig { params(left: ::RBI::Node, right: ::RBI::Node).void }
  def make_conflict_tree(left, right); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#173
  sig { params(node: ::RBI::Node).returns(T.nilable(::RBI::Node)) }
  def previous_definition(node); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#204
  sig { params(left: ::RBI::Scope, right: ::RBI::Scope).returns(::RBI::Scope) }
  def replace_scope_header(left, right); end
end

# source://rbi//lib/rbi/rewriters/nest_non_public_methods.rb#6
class RBI::Rewriters::NestNonPublicMethods < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/nest_non_public_methods.rb#10
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end
end

# source://rbi//lib/rbi/rewriters/nest_singleton_methods.rb#6
class RBI::Rewriters::NestSingletonMethods < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/nest_singleton_methods.rb#10
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end
end

# Remove all definitions existing in the index from the current tree
#
# Let's create an `Index` from two different `Tree`s:
# ~~~rb
# tree1 = Parse.parse_string(<<~RBI)
#   class Foo
#     def foo; end
#   end
# RBI
#
# tree2 = Parse.parse_string(<<~RBI)
#   FOO = 10
# RBI
#
# index = Index.index(tree1, tree2)
# ~~~
#
# We can use `RemoveKnownDefinitions` to remove the definitions found in the `index` from the `Tree` to clean:
# ~~~rb
# tree_to_clean = Parser.parse_string(<<~RBI)
#   class Foo
#     def foo; end
#     def bar; end
#   end
#   FOO = 10
#   BAR = 42
# RBI
#
# cleaned_tree, operations = RemoveKnownDefinitions.remove(tree_to_clean, index)
#
# assert_equal(<<~RBI, cleaned_tree)
#   class Foo
#     def bar; end
#   end
#   BAR = 42
# RBI
#
# assert_equal(<<~OPERATIONS, operations.join("\n"))
#   Deleted ::Foo#foo at -:2:2-2-16 (duplicate from -:2:2-2:16)
#   Deleted ::FOO at -:5:0-5:8 (duplicate from -:1:0-1:8)
# OPERATIONS
# ~~~
#
# source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#48
class RBI::Rewriters::RemoveKnownDefinitions < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#55
  sig { params(index: ::RBI::Index).void }
  def initialize(index); end

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#52
  sig { returns(T::Array[::RBI::Rewriters::RemoveKnownDefinitions::Operation]) }
  def operations; end

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#83
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#78
  sig { params(nodes: T::Array[::RBI::Node]).void }
  def visit_all(nodes); end

  private

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#111
  sig { params(node: ::RBI::Node, previous: ::RBI::Node).returns(T::Boolean) }
  def can_delete_node?(node, previous); end

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#129
  sig { params(node: ::RBI::Node, previous: ::RBI::Node).void }
  def delete_node(node, previous); end

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#102
  sig { params(node: ::RBI::Indexable).returns(T.nilable(::RBI::Node)) }
  def previous_definition_for(node); end

  class << self
    # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#70
    sig do
      params(
        tree: ::RBI::Tree,
        index: ::RBI::Index
      ).returns([::RBI::Tree, T::Array[::RBI::Rewriters::RemoveKnownDefinitions::Operation]])
    end
    def remove(tree, index); end
  end
end

# source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#134
class RBI::Rewriters::RemoveKnownDefinitions::Operation < ::T::Struct
  const :deleted_node, ::RBI::Node
  const :duplicate_of, ::RBI::Node

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#141
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://sorbet-runtime/0.5.11155/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# source://rbi//lib/rbi/rewriters/sort_nodes.rb#6
class RBI::Rewriters::SortNodes < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/sort_nodes.rb#10
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/rewriters/sort_nodes.rb#73
  sig { params(kind: ::RBI::Group::Kind).returns(::Integer) }
  def group_rank(kind); end

  # source://rbi//lib/rbi/rewriters/sort_nodes.rb#94
  sig { params(node: ::RBI::Node).returns(T.nilable(::String)) }
  def node_name(node); end

  # source://rbi//lib/rbi/rewriters/sort_nodes.rb#45
  sig { params(node: ::RBI::Node).returns(::Integer) }
  def node_rank(node); end

  # source://rbi//lib/rbi/rewriters/sort_nodes.rb#106
  sig { params(node: ::RBI::Node).void }
  def sort_node_names!(node); end
end

# Scopes
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#176
class RBI::Scope < ::RBI::Tree
  include ::RBI::Indexable

  abstract!

  # source://rbi//lib/rbi/printer.rb#242
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # Duplicate `self` scope without its body
  #
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#356
  sig { returns(T.self_type) }
  def dup_empty; end

  # @abstract
  #
  # source://rbi//lib/rbi/model.rb#182
  sig { abstract.returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/index.rb#93
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/printer.rb#256
  sig { params(v: ::RBI::Printer).void }
  def print_body(v); end

  # @abstract
  #
  # source://rbi//lib/rbi/printer.rb#253
  sig { abstract.params(v: ::RBI::Printer).void }
  def print_header(v); end

  # source://rbi//lib/rbi/model.rb#185
  sig { override.returns(::String) }
  def to_s; end
end

# A conflict between two scope headers
#
# Is rendered as a merge conflict between `left` and` right` for scope definitions:
# ~~~rb
# <<<<<<< left
# class Foo
# =======
# module Foo
# >>>>>>> right
#   def m1; end
# end
# ~~~
#
# source://rbi//lib/rbi/rewriters/merge_trees.rb#628
class RBI::ScopeConflict < ::RBI::Tree
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#642
  sig { params(left: ::RBI::Scope, right: ::RBI::Scope, left_name: ::String, right_name: ::String).void }
  def initialize(left:, right:, left_name: T.unsafe(nil), right_name: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#651
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#632
  sig { returns(::RBI::Scope) }
  def left; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#667
  sig { override.returns(T::Boolean) }
  def oneline?; end

  # @return [Scope]
  #
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#632
  def right; end
end

# Sends
#
# source://rbi//lib/rbi/model.rb#927
class RBI::Send < ::RBI::NodeWithComments
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#945
  sig do
    params(
      method: ::String,
      args: T::Array[::RBI::Arg],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Send).void)
    ).void
  end
  def initialize(method, args = T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#953
  sig { params(arg: ::RBI::Arg).void }
  def <<(arg); end

  # source://rbi//lib/rbi/model.rb#958
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#592
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/model.rb#934
  sig { returns(T::Array[::RBI::Arg]) }
  def args; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#529
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/index.rb#193
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#931
  sig { returns(::String) }
  def method; end

  # source://rbi//lib/rbi/model.rb#963
  sig { returns(::String) }
  def to_s; end
end

# Sorbet's sigs
#
# source://rbi//lib/rbi/model.rb#1027
class RBI::Sig < ::RBI::Node
  # source://rbi//lib/rbi/model.rb#1059
  sig do
    params(
      params: T::Array[::RBI::SigParam],
      return_type: T.nilable(::String),
      is_abstract: T::Boolean,
      is_override: T::Boolean,
      is_overridable: T::Boolean,
      is_final: T::Boolean,
      type_params: T::Array[::String],
      checked: T.nilable(::Symbol),
      loc: T.nilable(::RBI::Loc),
      block: T.nilable(T.proc.params(node: ::RBI::Sig).void)
    ).void
  end
  def initialize(params: T.unsafe(nil), return_type: T.unsafe(nil), is_abstract: T.unsafe(nil), is_override: T.unsafe(nil), is_overridable: T.unsafe(nil), is_final: T.unsafe(nil), type_params: T.unsafe(nil), checked: T.unsafe(nil), loc: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#1084
  sig { params(param: ::RBI::SigParam).void }
  def <<(param); end

  # source://rbi//lib/rbi/model.rb#1089
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#633
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/model.rb#1043
  sig { returns(T.nilable(::Symbol)) }
  def checked; end

  # @return [Symbol, nil]
  #
  # source://rbi//lib/rbi/model.rb#1043
  def checked=(_arg0); end

  # source://rbi//lib/rbi/printer.rb#656
  sig { returns(T::Boolean) }
  def inline_params?; end

  # source://rbi//lib/rbi/model.rb#1037
  sig { returns(T::Boolean) }
  def is_abstract; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1037
  def is_abstract=(_arg0); end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1037
  def is_final; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1037
  def is_final=(_arg0); end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1037
  def is_overridable; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1037
  def is_overridable=(_arg0); end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1037
  def is_override; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1037
  def is_override=(_arg0); end

  # source://rbi//lib/rbi/printer.rb#651
  sig { override.returns(T::Boolean) }
  def oneline?; end

  # source://rbi//lib/rbi/model.rb#1031
  sig { returns(T::Array[::RBI::SigParam]) }
  def params; end

  # source://rbi//lib/rbi/model.rb#1034
  sig { returns(T.nilable(::String)) }
  def return_type; end

  # @return [String, nil]
  #
  # source://rbi//lib/rbi/model.rb#1034
  def return_type=(_arg0); end

  # source://rbi//lib/rbi/model.rb#1040
  sig { returns(T::Array[::String]) }
  def type_params; end

  private

  # source://rbi//lib/rbi/printer.rb#698
  sig { params(v: ::RBI::Printer).void }
  def print_as_block(v); end

  # source://rbi//lib/rbi/printer.rb#674
  sig { params(v: ::RBI::Printer).void }
  def print_as_line(v); end

  # source://rbi//lib/rbi/printer.rb#663
  sig { returns(T::Array[::String]) }
  def sig_modifiers; end
end

# source://rbi//lib/rbi/model.rb#1098
class RBI::SigParam < ::RBI::NodeWithComments
  # source://rbi//lib/rbi/model.rb#1113
  sig do
    params(
      name: ::String,
      type: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::SigParam).void)
    ).void
  end
  def initialize(name, type, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#1121
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#751
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/printer.rb#764
  sig { returns(T::Array[::String]) }
  def comments_lines; end

  # source://rbi//lib/rbi/model.rb#1102
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/printer.rb#756
  sig { params(v: ::RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#1102
  def type; end
end

# source://rbi//lib/rbi/model.rb#251
class RBI::SingletonClass < ::RBI::Scope
  # source://rbi//lib/rbi/model.rb#261
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::SingletonClass).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#267
  sig { override.returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/printer.rb#321
  sig { override.params(v: ::RBI::Printer).void }
  def print_header(v); end
end

# source://rbi//lib/rbi/model.rb#272
class RBI::Struct < ::RBI::Scope
  # source://rbi//lib/rbi/model.rb#294
  sig do
    params(
      name: ::String,
      members: T::Array[::Symbol],
      keyword_init: T::Boolean,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(struct: ::RBI::Struct).void)
    ).void
  end
  def initialize(name, members: T.unsafe(nil), keyword_init: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#394
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#303
  sig { override.returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/model.rb#282
  sig { returns(T::Boolean) }
  def keyword_init; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#282
  def keyword_init=(_arg0); end

  # source://rbi//lib/rbi/model.rb#279
  sig { returns(T::Array[::Symbol]) }
  def members; end

  # @return [Array<Symbol>]
  #
  # source://rbi//lib/rbi/model.rb#279
  def members=(_arg0); end

  # source://rbi//lib/rbi/model.rb#276
  sig { returns(::String) }
  def name; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#276
  def name=(_arg0); end

  # source://rbi//lib/rbi/printer.rb#300
  sig { override.params(v: ::RBI::Printer).void }
  def print_header(v); end
end

# Sorbet's T::Enum
#
# source://rbi//lib/rbi/model.rb#1239
class RBI::TEnum < ::RBI::Class
  # source://rbi//lib/rbi/model.rb#1250
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(klass: ::RBI::TEnum).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

# source://rbi//lib/rbi/model.rb#1256
class RBI::TEnumBlock < ::RBI::NodeWithComments
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1270
  sig do
    params(
      names: T::Array[::String],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::TEnumBlock).void)
    ).void
  end
  def initialize(names = T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#1282
  sig { params(name: ::String).void }
  def <<(name); end

  # source://rbi//lib/rbi/printer.rb#795
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/model.rb#1277
  sig { returns(T::Boolean) }
  def empty?; end

  # source://rbi//lib/rbi/index.rb#223
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#556
  sig { override.params(other: ::RBI::Node).void }
  def merge_with(other); end

  # source://rbi//lib/rbi/model.rb#1260
  sig { returns(T::Array[::String]) }
  def names; end

  # source://rbi//lib/rbi/model.rb#1287
  sig { override.returns(::String) }
  def to_s; end
end

# Sorbet's T::Struct
#
# source://rbi//lib/rbi/model.rb#1128
class RBI::TStruct < ::RBI::Class
  # source://rbi//lib/rbi/model.rb#1139
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(klass: ::RBI::TStruct).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

# source://rbi//lib/rbi/model.rb#1177
class RBI::TStructConst < ::RBI::TStructField
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1190
  sig do
    params(
      name: ::String,
      type: ::String,
      default: T.nilable(::String),
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::TStructConst).void)
    ).void
  end
  def initialize(name, type, default: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#547
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#1196
  sig { override.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/index.rb#203
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#1202
  sig { override.returns(::String) }
  def to_s; end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#1145
class RBI::TStructField < ::RBI::NodeWithComments
  abstract!

  # source://rbi//lib/rbi/model.rb#1166
  sig do
    params(
      name: ::String,
      type: ::String,
      default: T.nilable(::String),
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment]
    ).void
  end
  def initialize(name, type, default: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#773
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#538
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#1155
  sig { returns(T.nilable(::String)) }
  def default; end

  # @return [String, nil]
  #
  # source://rbi//lib/rbi/model.rb#1155
  def default=(_arg0); end

  # @abstract
  #
  # source://rbi//lib/rbi/model.rb#1174
  sig { abstract.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/model.rb#1152
  sig { returns(::String) }
  def name; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#1152
  def name=(_arg0); end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#1152
  def type; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#1152
  def type=(_arg0); end
end

# source://rbi//lib/rbi/model.rb#1207
class RBI::TStructProp < ::RBI::TStructField
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1220
  sig do
    params(
      name: ::String,
      type: ::String,
      default: T.nilable(::String),
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::TStructProp).void)
    ).void
  end
  def initialize(name, type, default: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#570
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#1226
  sig { override.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/index.rb#213
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#1232
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#106
class RBI::Tree < ::RBI::NodeWithComments
  # source://rbi//lib/rbi/model.rb#119
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Tree).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#126
  sig { params(node: ::RBI::Node).void }
  def <<(node); end

  # source://rbi//lib/rbi/printer.rb#226
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/add_sig_templates.rb#66
  sig { params(with_todo_comment: T::Boolean).void }
  def add_sig_templates!(with_todo_comment: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/annotate.rb#49
  sig { params(annotation: ::String, annotate_scopes: T::Boolean, annotate_properties: T::Boolean).void }
  def annotate!(annotation, annotate_scopes: T.unsafe(nil), annotate_properties: T.unsafe(nil)); end

  # source://tapioca/0.11.13/lib/tapioca/rbi_ext/model.rb#38
  sig do
    params(
      name: ::String,
      superclass_name: T.nilable(::String),
      block: T.nilable(T.proc.params(scope: ::RBI::Scope).void)
    ).returns(::RBI::Scope)
  end
  def create_class(name, superclass_name: T.unsafe(nil), &block); end

  # source://tapioca/0.11.13/lib/tapioca/rbi_ext/model.rb#45
  sig { params(name: ::String, value: ::String).void }
  def create_constant(name, value:); end

  # source://tapioca/0.11.13/lib/tapioca/rbi_ext/model.rb#55
  sig { params(name: ::String).void }
  def create_extend(name); end

  # source://tapioca/0.11.13/lib/tapioca/rbi_ext/model.rb#50
  sig { params(name: ::String).void }
  def create_include(name); end

  # source://tapioca/0.11.13/lib/tapioca/rbi_ext/model.rb#89
  sig do
    params(
      name: ::String,
      parameters: T::Array[::RBI::TypedParam],
      return_type: ::String,
      class_method: T::Boolean,
      visibility: ::RBI::Visibility,
      comments: T::Array[::RBI::Comment]
    ).void
  end
  def create_method(name, parameters: T.unsafe(nil), return_type: T.unsafe(nil), class_method: T.unsafe(nil), visibility: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://tapioca/0.11.13/lib/tapioca/rbi_ext/model.rb#60
  sig { params(name: ::String).void }
  def create_mixes_in_class_methods(name); end

  # source://tapioca/0.11.13/lib/tapioca/rbi_ext/model.rb#25
  sig { params(name: ::String, block: T.nilable(T.proc.params(scope: ::RBI::Scope).void)).returns(::RBI::Scope) }
  def create_module(name, &block); end

  # source://tapioca/0.11.13/lib/tapioca/rbi_ext/model.rb#9
  sig { params(constant: ::Module, block: T.nilable(T.proc.params(scope: ::RBI::Scope).void)).returns(::RBI::Scope) }
  def create_path(constant, &block); end

  # source://tapioca/0.11.13/lib/tapioca/rbi_ext/model.rb#74
  sig do
    params(
      name: ::String,
      type: ::String,
      variance: ::Symbol,
      fixed: T.nilable(::String),
      upper: T.nilable(::String),
      lower: T.nilable(::String)
    ).void
  end
  def create_type_variable(name, type:, variance: T.unsafe(nil), fixed: T.unsafe(nil), upper: T.unsafe(nil), lower: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/deannotate.rb#41
  sig { params(annotation: ::String).void }
  def deannotate!(annotation); end

  # source://rbi//lib/rbi/model.rb#132
  sig { returns(T::Boolean) }
  def empty?; end

  # source://rbi//lib/rbi/rewriters/group_nodes.rb#38
  sig { void }
  def group_nodes!; end

  # source://rbi//lib/rbi/index.rb#68
  sig { returns(::RBI::Index) }
  def index; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#324
  sig do
    params(
      other: ::RBI::Tree,
      left_name: ::String,
      right_name: ::String,
      keep: ::RBI::Rewriters::Merge::Keep
    ).returns(::RBI::MergeTree)
  end
  def merge(other, left_name: T.unsafe(nil), right_name: T.unsafe(nil), keep: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/nest_non_public_methods.rb#46
  sig { void }
  def nest_non_public_methods!; end

  # source://rbi//lib/rbi/rewriters/nest_singleton_methods.rb#36
  sig { void }
  def nest_singleton_methods!; end

  # source://rbi//lib/rbi/model.rb#110
  sig { returns(T::Array[::RBI::Node]) }
  def nodes; end

  # source://rbi//lib/rbi/printer.rb#233
  sig { override.returns(T::Boolean) }
  def oneline?; end

  # source://rbi//lib/rbi/rewriters/sort_nodes.rb#119
  sig { void }
  def sort_nodes!; end

  private

  # source://tapioca/0.11.13/lib/tapioca/rbi_ext/model.rb#116
  sig { params(node: ::RBI::Node).returns(::RBI::Node) }
  def create_node(node); end

  # source://tapioca/0.11.13/lib/tapioca/rbi_ext/model.rb#111
  sig { returns(T::Hash[::String, ::RBI::Node]) }
  def nodes_cache; end
end

# source://rbi//lib/rbi/model.rb#1320
class RBI::TypeMember < ::RBI::NodeWithComments
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1335
  sig do
    params(
      name: ::String,
      value: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::TypeMember).void)
    ).void
  end
  def initialize(name, value, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/printer.rb#812
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/model.rb#1343
  sig { returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/index.rb#183
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#1324
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/model.rb#1350
  sig { override.returns(::String) }
  def to_s; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#1324
  def value; end
end

# source://rbi//lib/rbi/parser.rb#20
class RBI::UnexpectedParserError < ::StandardError
  # source://rbi//lib/rbi/parser.rb#27
  sig { params(parent_exception: ::Exception, last_location: ::RBI::Loc).void }
  def initialize(parent_exception, last_location); end

  # source://rbi//lib/rbi/parser.rb#24
  sig { returns(::RBI::Loc) }
  def last_location; end

  # source://rbi//lib/rbi/parser.rb#34
  sig { params(io: T.any(::IO, ::StringIO)).void }
  def print_debug(io: T.unsafe(nil)); end
end

# source://rbi//lib/rbi/version.rb#5
RBI::VERSION = T.let(T.unsafe(nil), String)

# Visibility
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#841
class RBI::Visibility < ::RBI::NodeWithComments
  abstract!

  # source://rbi//lib/rbi/model.rb#851
  sig { params(visibility: ::Symbol, loc: T.nilable(::RBI::Loc), comments: T::Array[::RBI::Comment]).void }
  def initialize(visibility, loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/model.rb#857
  sig { params(other: ::RBI::Visibility).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#579
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/model.rb#872
  sig { returns(T::Boolean) }
  def private?; end

  # source://rbi//lib/rbi/model.rb#867
  sig { returns(T::Boolean) }
  def protected?; end

  # source://rbi//lib/rbi/model.rb#862
  sig { returns(T::Boolean) }
  def public?; end

  # source://rbi//lib/rbi/model.rb#848
  sig { returns(::Symbol) }
  def visibility; end
end

# source://rbi//lib/rbi/rewriters/nest_non_public_methods.rb#52
class RBI::VisibilityGroup < ::RBI::Tree
  # source://rbi//lib/rbi/rewriters/nest_non_public_methods.rb#59
  sig { params(visibility: ::RBI::Visibility).void }
  def initialize(visibility); end

  # source://rbi//lib/rbi/printer.rb#848
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/printer.rb#861
  sig { override.returns(T::Boolean) }
  def oneline?; end

  # source://rbi//lib/rbi/rewriters/nest_non_public_methods.rb#56
  sig { returns(::RBI::Visibility) }
  def visibility; end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/visitor.rb#5
class RBI::Visitor
  abstract!

  # @abstract
  #
  # source://rbi//lib/rbi/visitor.rb#12
  sig { abstract.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  # source://rbi//lib/rbi/visitor.rb#15
  sig { params(nodes: T::Array[::RBI::Node]).void }
  def visit_all(nodes); end
end
