# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rdiscount` gem.
# Please instead update this file by running `bin/tapioca gem rdiscount`.

# source://rdiscount//lib/rdiscount.rb#117
Markdown = RDiscount

# Discount is an implementation of John Gruber's Markdown markup
# language in C. It implements all of the language as described in
# {Markdown Syntax}[http://daringfireball.net/projects/markdown/syntax]
# and passes the Markdown 1.0 test suite. The RDiscount extension makes
# the Discount processor available via a Ruby C Extension library.
#
# == Usage
#
# RDiscount implements the basic protocol popularized by RedCloth and adopted
# by BlueCloth:
#   require 'rdiscount'
#   markdown = RDiscount.new("Hello World!")
#   puts markdown.to_html
#
# == Replacing BlueCloth
#
# Inject RDiscount into your BlueCloth-using code by replacing your bluecloth
# require statements with the following:
#   begin
#     require 'rdiscount'
#     BlueCloth = RDiscount
#   rescue LoadError
#     require 'bluecloth'
#   end
#
# source://rdiscount//lib/rdiscount.rb#26
class RDiscount
  # Create a RDiscount Markdown processor. The +text+ argument
  # should be a string containing Markdown text. Additional arguments may be
  # supplied to set various processing options:
  #
  # * <tt>:smart</tt> - Enable SmartyPants processing.
  # * <tt>:filter_styles</tt> - Do not output <tt><style></tt> tags.
  # * <tt>:filter_html</tt> - Do not output any raw HTML tags included in
  #   the source text.
  # * <tt>:fold_lines</tt> - RedCloth compatible line folding (not used).
  # * <tt>:footnotes</tt> - PHP markdown extra-style footnotes.
  # * <tt>:generate_toc</tt> - Enable Table Of Contents generation
  # * <tt>:no_image</tt> - Do not output any <tt><img></tt> tags.
  # * <tt>:no_links</tt> - Do not output any <tt><a></tt> tags.
  # * <tt>:no_tables</tt> - Do not output any tables.
  # * <tt>:strict</tt> - Disable superscript and relaxed emphasis processing.
  # * <tt>:autolink</tt> - Greedily urlify links.
  # * <tt>:safelink</tt> - Do not make links for unknown URL types.
  # * <tt>:no_pseudo_protocols</tt> - Do not process pseudo-protocols.
  # * <tt>:no_superscript</tt> - Disable superscript processing.
  # * <tt>:no_strikethrough</tt> - Disable strikethrough processing.
  # * <tt>:latex</tt> - Keep LaTeX inside $$ intact.
  # * <tt>:explicitlist</tt> - Don't merge adjacent list into a single list.
  #
  # @return [RDiscount] a new instance of RDiscount
  #
  # source://rdiscount//lib/rdiscount.rb#110
  def initialize(text, *extensions); end

  # Convert URL in links, even if they aren't encased in <tt><></tt>
  #
  # source://rdiscount//lib/rdiscount.rb#64
  def autolink; end

  # Convert URL in links, even if they aren't encased in <tt><></tt>
  #
  # source://rdiscount//lib/rdiscount.rb#64
  def autolink=(_arg0); end

  # Don't merge adjacent list into a single list.
  #
  # source://rdiscount//lib/rdiscount.rb#82
  def explicitlist; end

  # Don't merge adjacent list into a single list.
  #
  # source://rdiscount//lib/rdiscount.rb#82
  def explicitlist=(_arg0); end

  # Do not output any raw HTML included in the source text.
  #
  # source://rdiscount//lib/rdiscount.rb#39
  def filter_html; end

  # Do not output any raw HTML included in the source text.
  #
  # source://rdiscount//lib/rdiscount.rb#39
  def filter_html=(_arg0); end

  # Do not output <tt><style></tt> tags included in the source text.
  #
  # source://rdiscount//lib/rdiscount.rb#36
  def filter_styles; end

  # Do not output <tt><style></tt> tags included in the source text.
  #
  # source://rdiscount//lib/rdiscount.rb#36
  def filter_styles=(_arg0); end

  # RedCloth compatible line folding -- not used for Markdown but
  # included for compatibility.
  #
  # source://rdiscount//lib/rdiscount.rb#43
  def fold_lines; end

  # RedCloth compatible line folding -- not used for Markdown but
  # included for compatibility.
  #
  # source://rdiscount//lib/rdiscount.rb#43
  def fold_lines=(_arg0); end

  # Enable php markdown extra-style footnotes
  #
  # source://rdiscount//lib/rdiscount.rb#46
  def footnotes; end

  # Enable php markdown extra-style footnotes
  #
  # source://rdiscount//lib/rdiscount.rb#46
  def footnotes=(_arg0); end

  # Enable Table Of Contents generation
  #
  # source://rdiscount//lib/rdiscount.rb#49
  def generate_toc; end

  # Enable Table Of Contents generation
  #
  # source://rdiscount//lib/rdiscount.rb#49
  def generate_toc=(_arg0); end

  # Keep LaTeX inside $$ intact.
  #
  # source://rdiscount//lib/rdiscount.rb#79
  def latex; end

  # Keep LaTeX inside $$ intact.
  #
  # source://rdiscount//lib/rdiscount.rb#79
  def latex=(_arg0); end

  # Not documented: run in markdown 1 compat mode (only used for MarkdownTest1.0)
  #
  # source://rdiscount//lib/rdiscount.rb#85
  def md1compat; end

  # Not documented: run in markdown 1 compat mode (only used for MarkdownTest1.0)
  #
  # source://rdiscount//lib/rdiscount.rb#85
  def md1compat=(_arg0); end

  # Do not process <tt>![]</tt> and remove <tt><img></tt> tags from the output.
  #
  # source://rdiscount//lib/rdiscount.rb#52
  def no_image; end

  # Do not process <tt>![]</tt> and remove <tt><img></tt> tags from the output.
  #
  # source://rdiscount//lib/rdiscount.rb#52
  def no_image=(_arg0); end

  # Do not process <tt>[]</tt> and remove <tt><a></tt> tags from the output.
  #
  # source://rdiscount//lib/rdiscount.rb#55
  def no_links; end

  # Do not process <tt>[]</tt> and remove <tt><a></tt> tags from the output.
  #
  # source://rdiscount//lib/rdiscount.rb#55
  def no_links=(_arg0); end

  # Do not process pseudo-protocols like <tt>[](id:name)</tt>
  #
  # source://rdiscount//lib/rdiscount.rb#70
  def no_pseudo_protocols; end

  # Do not process pseudo-protocols like <tt>[](id:name)</tt>
  #
  # source://rdiscount//lib/rdiscount.rb#70
  def no_pseudo_protocols=(_arg0); end

  # Disable strikethrough processing.
  #
  # source://rdiscount//lib/rdiscount.rb#76
  def no_strikethrough; end

  # Disable strikethrough processing.
  #
  # source://rdiscount//lib/rdiscount.rb#76
  def no_strikethrough=(_arg0); end

  # Disable superscript processing.
  #
  # source://rdiscount//lib/rdiscount.rb#73
  def no_superscript; end

  # Disable superscript processing.
  #
  # source://rdiscount//lib/rdiscount.rb#73
  def no_superscript=(_arg0); end

  # Do not process tables
  #
  # source://rdiscount//lib/rdiscount.rb#58
  def no_tables; end

  # Do not process tables
  #
  # source://rdiscount//lib/rdiscount.rb#58
  def no_tables=(_arg0); end

  # Don't make hyperlinks from <tt>[][]</tt> links that have unknown URL types.
  #
  # source://rdiscount//lib/rdiscount.rb#67
  def safelink; end

  # Don't make hyperlinks from <tt>[][]</tt> links that have unknown URL types.
  #
  # source://rdiscount//lib/rdiscount.rb#67
  def safelink=(_arg0); end

  # Set true to have smarty-like quote translation performed.
  #
  # source://rdiscount//lib/rdiscount.rb#33
  def smart; end

  # Set true to have smarty-like quote translation performed.
  #
  # source://rdiscount//lib/rdiscount.rb#33
  def smart=(_arg0); end

  # Disable superscript and relaxed emphasis processing.
  #
  # source://rdiscount//lib/rdiscount.rb#61
  def strict; end

  # Disable superscript and relaxed emphasis processing.
  #
  # source://rdiscount//lib/rdiscount.rb#61
  def strict=(_arg0); end

  # Original Markdown formatted text.
  #
  # source://rdiscount//lib/rdiscount.rb#30
  def text; end

  def to_html(*_arg0); end
  def toc_content(*_arg0); end
end

# source://rdiscount//lib/rdiscount.rb#27
RDiscount::VERSION = T.let(T.unsafe(nil), String)
