# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `ronn` gem.
# Please instead update this file by running `bin/tapioca gem ronn`.

# Ronn is a humane text format and toolchain for authoring manpages (and
# things that appear as manpages from a distance). Use it to build /
# install standard UNIX roff(7) formatted manpages or to generate
# beautiful HTML manpages.
#
# source://ronn//lib/ronn.rb#5
module Ronn
  class << self
    # Create a new Ronn::Document for the given ronn file. See
    # Ronn::Document.new for usage information.
    #
    # source://ronn//lib/ronn.rb#14
    def new(filename, attributes = T.unsafe(nil), &block); end

    # truthy when this a release (\d.\d.\d) version.
    #
    # @return [Boolean]
    #
    # source://ronn//lib/ronn.rb#19
    def release?; end

    # revision: 0.6.6-5-gdacd74b
    # revision: 0.6.25
    #
    # The string revision as reported by: git-describe --tags. This is just the
    # tag name when a tag references the HEAD commit (0.6.25). When the HEAD
    # commit is not tagged, this is a "<tag>-<offset>-<sha1>" string:
    #   <tag>    - closest tag name
    #   <offset> - number of commits ahead of <tag>
    #   <sha1>   - 7c short SHA1 for HEAD
    #
    # source://ronn//lib/ronn.rb#43
    def revision; end

    # version: 0.6.11
    #
    # A semantic version number based on the git revision. The third element
    # of the version is incremented by the commit offset, such that version
    # 0.6.6-5-gdacd74b => 0.6.11
    #
    # source://ronn//lib/ronn.rb#28
    def version; end
  end
end

# The Document class can be used to load and inspect a ronn document
# and to convert a ronn document into other formats, like roff or
# HTML.
#
# Ronn files may optionally follow the naming convention:
# "<name>.<section>.ronn". The <name> and <section> are used in
# generated documentation unless overridden by the information
# extracted from the document's name section.
#
# source://ronn//lib/ronn/document.rb#18
class Ronn::Document
  include ::Ronn::Utils

  # Create a Ronn::Document given a path or with the data returned by
  # calling the block. The document is loaded and preprocessed before
  # the intialize method returns. The attributes hash may contain values
  # for any writeable attributes defined on this class.
  #
  # @return [Document] a new instance of Document
  #
  # source://ronn//lib/ronn/document.rb#64
  def initialize(path = T.unsafe(nil), attributes = T.unsafe(nil), &block); end

  # Generate a file basename of the form "<name>.<section>.<type>"
  # for the given file extension. Uses the name and section from
  # the source file path but falls back on the name and section
  # defined in the document.
  #
  # source://ronn//lib/ronn/document.rb#91
  def basename(type = T.unsafe(nil)); end

  # Convert the document to :roff, :html, or :html_fragment and
  # return the result as a string.
  #
  # source://ronn//lib/ronn/document.rb#220
  def convert(format); end

  # The raw input data, read from path or stream and unmodified.
  #
  # source://ronn//lib/ronn/document.rb#26
  def data; end

  # The date the man page was published. If not set explicitly,
  # this is the file's modified time or, if no file is given,
  # the current time.
  #
  # source://ronn//lib/ronn/document.rb#166
  def date; end

  # The date the document was published; center displayed in
  # the document footer.
  #
  # source://ronn//lib/ronn/document.rb#55
  def date=(_arg0); end

  # A Hpricot::Document for the manual content fragment.
  #
  # source://ronn//lib/ronn/document.rb#214
  def html; end

  # The index used to resolve man and file references.
  #
  # source://ronn//lib/ronn/document.rb#29
  def index; end

  # The index used to resolve man and file references.
  #
  # source://ronn//lib/ronn/document.rb#29
  def index=(_arg0); end

  # The manual this document belongs to; center displayed in
  # the header.
  #
  # source://ronn//lib/ronn/document.rb#47
  def manual; end

  # The manual this document belongs to; center displayed in
  # the header.
  #
  # source://ronn//lib/ronn/document.rb#47
  def manual=(_arg0); end

  # Preprocessed markdown input text.
  #
  # source://ronn//lib/ronn/document.rb#209
  def markdown; end

  # Returns the manual page name based first on the document's
  # contents and then on the path name.
  #
  # source://ronn//lib/ronn/document.rb#123
  def name; end

  # The man pages name: usually a single word name of
  # a program or filename; displayed along with the section in
  # the left and right portions of the header as well as the bottom
  # right section of the footer.
  #
  # source://ronn//lib/ronn/document.rb#35
  def name=(_arg0); end

  # Truthful when the name was extracted from the name section
  # of the document.
  #
  # @return [Boolean]
  #
  # source://ronn//lib/ronn/document.rb#129
  def name?; end

  # The name of the group, organization, or individual responsible
  # for this document; displayed in the left portion of the footer.
  #
  # source://ronn//lib/ronn/document.rb#51
  def organization; end

  # The name of the group, organization, or individual responsible
  # for this document; displayed in the left portion of the footer.
  #
  # source://ronn//lib/ronn/document.rb#51
  def organization=(_arg0); end

  # Path to the Ronn document. This may be '-' or nil when the Ronn::Document
  # object is created with a stream.
  #
  # source://ronn//lib/ronn/document.rb#23
  def path; end

  # Construct a path for a file near the source file. Uses the
  # Document#basename method to generate the basename part and
  # appends it to the dirname of the source document.
  #
  # source://ronn//lib/ronn/document.rb#100
  def path_for(type = T.unsafe(nil)); end

  # Returns the <name> part of the path, or nil when no path is
  # available. This is used as the manual page name when the
  # file contents do not include a name section.
  #
  # source://ronn//lib/ronn/document.rb#111
  def path_name; end

  # Returns the <section> part of the path, or nil when
  # no path is available.
  #
  # source://ronn//lib/ronn/document.rb#117
  def path_section; end

  # The name used to reference this manual.
  #
  # source://ronn//lib/ronn/document.rb#146
  def reference_name; end

  # Returns the manual page section based first on the document's
  # contents and then on the path name.
  #
  # source://ronn//lib/ronn/document.rb#135
  def section; end

  # The man page's section: a string whose first character
  # is numeric; displayed in parenthesis along with the name.
  #
  # source://ronn//lib/ronn/document.rb#39
  def section=(_arg0); end

  # True when the section number was extracted from the name
  # section of the document.
  #
  # @return [Boolean]
  #
  # source://ronn//lib/ronn/document.rb#141
  def section?; end

  # Retrieve a list of top-level section headings in the document and return
  # as an array of +[id, text]+ tuples, where +id+ is the element's generated
  # id and +text+ is the inner text of the heading element.
  #
  # source://ronn//lib/ronn/document.rb#175
  def section_heads; end

  # Sniff the document header and extract basic document metadata. Return a
  # tuple of the form: [name, section, description], where missing information
  # is represented by nil and any element may be missing.
  #
  # source://ronn//lib/ronn/document.rb#190
  def sniff; end

  # Array of style modules to apply to the document.
  #
  # source://ronn//lib/ronn/document.rb#58
  def styles; end

  # Styles to insert in the generated HTML output. This is a simple Array of
  # string module names or file paths.
  #
  # source://ronn//lib/ronn/document.rb#183
  def styles=(styles); end

  # Single sentence description of the thing being described
  # by this man page; displayed in the NAME section.
  #
  # source://ronn//lib/ronn/document.rb#43
  def tagline; end

  # Single sentence description of the thing being described
  # by this man page; displayed in the NAME section.
  #
  # source://ronn//lib/ronn/document.rb#43
  def tagline=(_arg0); end

  # The document's title when no name section was defined. When a name section
  # exists, this value is nil.
  #
  # source://ronn//lib/ronn/document.rb#159
  def title; end

  # Truthful when the document started with an h1 but did not follow
  # the "<name>(<sect>) -- <tagline>" convention. We assume this is some kind
  # of custom title.
  #
  # @return [Boolean]
  #
  # source://ronn//lib/ronn/document.rb#153
  def title?; end

  # source://ronn//lib/ronn/document.rb#263
  def to_h; end

  # Convert the document to HTML and return the result as a string.
  #
  # source://ronn//lib/ronn/document.rb#234
  def to_html; end

  # Convert the document to HTML and return the result
  # as a string. The HTML does not include <html>, <head>,
  # or <style> tags.
  #
  # source://ronn//lib/ronn/document.rb#250
  def to_html_fragment(wrap_class = T.unsafe(nil)); end

  # source://ronn//lib/ronn/document.rb#273
  def to_json; end

  # source://ronn//lib/ronn/document.rb#259
  def to_markdown; end

  # Convert the document to roff and return the result as a string.
  #
  # source://ronn//lib/ronn/document.rb#225
  def to_roff; end

  # source://ronn//lib/ronn/document.rb#268
  def to_yaml; end

  # Retrieve a list of top-level section headings in the document and return
  # as an array of +[id, text]+ tuples, where +id+ is the element's generated
  # id and +text+ is the inner text of the heading element.
  #
  # source://ronn//lib/ronn/document.rb#175
  def toc; end

  protected

  # Perform angle quote (<THESE>) post filtering.
  #
  # source://ronn//lib/ronn/document.rb#355
  def html_filter_angle_quotes; end

  # Add a 'data-bare-link' attribute to hyperlinks
  # whose text labels are the same as their href URLs.
  #
  # source://ronn//lib/ronn/document.rb#423
  def html_filter_annotate_bare_links; end

  # Convert special format unordered lists to definition lists.
  #
  # source://ronn//lib/ronn/document.rb#369
  def html_filter_definition_lists; end

  # Add URL anchors to all HTML heading elements.
  #
  # source://ronn//lib/ronn/document.rb#415
  def html_filter_heading_anchors; end

  # source://ronn//lib/ronn/document.rb#395
  def html_filter_inject_name_section; end

  # Convert text of the form "name(section)" to a hyperlink. The URL is
  # obtaiend from the index.
  #
  # source://ronn//lib/ronn/document.rb#439
  def html_filter_manual_reference_links; end

  # source://ronn//lib/ronn/document.rb#289
  def input_html; end

  # Convert <WORD> to <var>WORD</var> but only if WORD isn't an HTML tag.
  #
  # source://ronn//lib/ronn/document.rb#341
  def markdown_filter_angle_quotes(markdown); end

  # Add [id]: #ANCHOR elements to the markdown source text for all sections.
  # This lets us use the [SECTION-REF][] syntax
  #
  # source://ronn//lib/ronn/document.rb#328
  def markdown_filter_heading_anchors(markdown); end

  # Appends all index links to the end of the document as Markdown reference
  # links. This lets us use [foo(3)][] syntax to link to index entries.
  #
  # source://ronn//lib/ronn/document.rb#320
  def markdown_filter_link_index(markdown); end

  # Parse the document and extract the name, section, and tagline from its
  # contents. This is called while the object is being initialized.
  #
  # source://ronn//lib/ronn/document.rb#284
  def preprocess!; end

  # source://ronn//lib/ronn/document.rb#304
  def process_html!; end

  # source://ronn//lib/ronn/document.rb#298
  def process_markdown!; end

  # source://ronn//lib/ronn/document.rb#293
  def strip_heading(html); end
end

# Maintains a list of links / references to manuals and other resources.
#
# source://ronn//lib/ronn/index.rb#6
class Ronn::Index
  include ::Enumerable

  # @return [Index] a new instance of Index
  #
  # source://ronn//lib/ronn/index.rb#30
  def initialize(path, &bk); end

  # @raise [ArgumentError]
  #
  # source://ronn//lib/ronn/index.rb#89
  def <<(path); end

  # source://ronn//lib/ronn/index.rb#81
  def [](name); end

  # source://ronn//lib/ronn/index.rb#102
  def add_manual(manual); end

  # Enumerable and friends
  #
  # source://ronn//lib/ronn/index.rb#61
  def each(&bk); end

  # @return [Boolean]
  #
  # source://ronn//lib/ronn/index.rb#77
  def empty?; end

  # Determine whether the index file exists.
  #
  # @return [Boolean]
  #
  # source://ronn//lib/ronn/index.rb#43
  def exist?; end

  # source://ronn//lib/ronn/index.rb#69
  def first; end

  # source://ronn//lib/ronn/index.rb#73
  def last; end

  # source://ronn//lib/ronn/index.rb#107
  def manual(path); end

  # source://ronn//lib/ronn/index.rb#111
  def manuals; end

  # Returns the value of attribute path.
  #
  # source://ronn//lib/ronn/index.rb#9
  def path; end

  # Load index data from a string.
  #
  # source://ronn//lib/ronn/index.rb#48
  def read!(data); end

  # source://ronn//lib/ronn/index.rb#85
  def reference(name, path); end

  # Returns the value of attribute references.
  #
  # source://ronn//lib/ronn/index.rb#10
  def references; end

  # source://ronn//lib/ronn/index.rb#131
  def relative_to_index(path); end

  # source://ronn//lib/ronn/index.rb#65
  def size; end

  # source://ronn//lib/ronn/index.rb#123
  def to_a; end

  # source://ronn//lib/ronn/index.rb#127
  def to_h; end

  # Converting
  #
  # source://ronn//lib/ronn/index.rb#119
  def to_text; end

  class << self
    # Retrieve an Index for <path>, where <path> is a directory or normal
    # file. The index is loaded from the corresponding index.txt file if
    # one exists.
    #
    # source://ronn//lib/ronn/index.rb#15
    def [](path); end

    # source://ronn//lib/ronn/index.rb#20
    def index_path_for_file(file); end
  end
end

# value generated by: rake rev
#
# source://ronn//lib/ronn.rb#48
Ronn::REV = T.let(T.unsafe(nil), String)

# An individual index reference. A reference can point to one of a few types
# of locations:
#
#   - URLs: "http://man.cx/crontab(5)"
#   - Relative paths to ronn manuals: "crontab.5.ronn"
#
# The #url method should be used to obtain the href value for HTML.
#
# source://ronn//lib/ronn/index.rb#145
class Ronn::Reference
  # @return [Reference] a new instance of Reference
  #
  # source://ronn//lib/ronn/index.rb#149
  def initialize(index, name, location); end

  # Returns the value of attribute location.
  #
  # source://ronn//lib/ronn/index.rb#147
  def location; end

  # @return [Boolean]
  #
  # source://ronn//lib/ronn/index.rb#155
  def manual?; end

  # Returns the value of attribute name.
  #
  # source://ronn//lib/ronn/index.rb#146
  def name; end

  # source://ronn//lib/ronn/index.rb#179
  def path; end

  # @return [Boolean]
  #
  # source://ronn//lib/ronn/index.rb#167
  def relative?; end

  # @return [Boolean]
  #
  # source://ronn//lib/ronn/index.rb#163
  def remote?; end

  # @return [Boolean]
  #
  # source://ronn//lib/ronn/index.rb#159
  def ronn?; end

  # source://ronn//lib/ronn/index.rb#171
  def url; end
end

# source://ronn//lib/ronn/roff.rb#5
class Ronn::RoffFilter
  include ::Ronn::Utils

  # Convert Ronn HTML to roff.
  #
  # @return [RoffFilter] a new instance of RoffFilter
  #
  # source://ronn//lib/ronn/roff.rb#9
  def initialize(html, name, section, tagline, manual = T.unsafe(nil), version = T.unsafe(nil), date = T.unsafe(nil)); end

  # source://ronn//lib/ronn/roff.rb#19
  def to_s; end

  protected

  # source://ronn//lib/ronn/roff.rb#80
  def block_filter(node); end

  # source://ronn//lib/ronn/roff.rb#276
  def comment(text); end

  # source://ronn//lib/ronn/roff.rb#241
  def escape(text); end

  # source://ronn//lib/ronn/roff.rb#162
  def inline_filter(node); end

  # source://ronn//lib/ronn/roff.rb#221
  def macro(name, value = T.unsafe(nil)); end

  # source://ronn//lib/ronn/roff.rb#47
  def normalize_whitespace!(node); end

  # source://ronn//lib/ronn/roff.rb#24
  def previous(node); end

  # source://ronn//lib/ronn/roff.rb#254
  def quote(text); end

  # source://ronn//lib/ronn/roff.rb#39
  def remove_extraneous_elements!(doc); end

  # source://ronn//lib/ronn/roff.rb#32
  def title_heading(name, section, tagline, manual, version, date); end

  # source://ronn//lib/ronn/roff.rb#280
  def warn(text, *args); end

  # write text to output buffer
  #
  # source://ronn//lib/ronn/roff.rb#259
  def write(text); end

  # write text to output buffer on a new line.
  #
  # source://ronn//lib/ronn/roff.rb#270
  def writeln(text); end
end

# source://ronn//lib/ronn/roff.rb#225
Ronn::RoffFilter::HTML_ROFF_ENTITIES = T.let(T.unsafe(nil), Hash)

# source://ronn//lib/ronn/template.rb#4
class Ronn::Template < ::Mustache
  # @return [Template] a new instance of Template
  #
  # source://ronn//lib/ronn/template.rb#8
  def initialize(document, style_path = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://ronn//lib/ronn/template.rb#45
  def custom_title?; end

  # source://ronn//lib/ronn/template.rb#69
  def date; end

  # source://ronn//lib/ronn/template.rb#57
  def generator; end

  # TEMPLATE CSS LOADING
  #
  # source://ronn//lib/ronn/template.rb#144
  def inline_stylesheet(path, media = T.unsafe(nil)); end

  # source://ronn//lib/ronn/template.rb#61
  def manual; end

  # Array of style names for which no file could be found.
  #
  # source://ronn//lib/ronn/template.rb#134
  def missing_styles; end

  # Basic document attributes
  #
  # source://ronn//lib/ronn/template.rb#20
  def name; end

  # @return [Boolean]
  #
  # source://ronn//lib/ronn/template.rb#33
  def name_and_section?; end

  # source://ronn//lib/ronn/template.rb#65
  def organization; end

  # source://ronn//lib/ronn/template.rb#49
  def page_name; end

  # source://ronn//lib/ronn/template.rb#162
  def remote_stylesheet(name, media = T.unsafe(nil)); end

  # source://ronn//lib/ronn/template.rb#13
  def render(template = T.unsafe(nil)); end

  # source://ronn//lib/ronn/template.rb#24
  def section; end

  # Section TOCs
  #
  # source://ronn//lib/ronn/template.rb#80
  def section_heads; end

  # Array of expanded stylesheet file names. If a file cannot be found, the
  # resulting array will include nil elements in positions corresponding to
  # the stylesheets array.
  #
  # source://ronn//lib/ronn/template.rb#123
  def style_files; end

  # Returns the value of attribute style_path.
  #
  # source://ronn//lib/ronn/template.rb#118
  def style_path; end

  # Sets the attribute style_path
  #
  # @param value the value to set the attribute style_path to.
  #
  # source://ronn//lib/ronn/template.rb#118
  def style_path=(_arg0); end

  # Array of style module names as given on the command line.
  #
  # source://ronn//lib/ronn/template.rb#93
  def styles; end

  # source://ronn//lib/ronn/template.rb#167
  def stylesheet(path, media = T.unsafe(nil)); end

  # All embedded stylesheets.
  #
  # source://ronn//lib/ronn/template.rb#112
  def stylesheet_tags; end

  # Array of stylesheet info hashes.
  #
  # source://ronn//lib/ronn/template.rb#98
  def stylesheets; end

  # source://ronn//lib/ronn/template.rb#28
  def tagline; end

  # source://ronn//lib/ronn/template.rb#28
  def tagline?; end

  # source://ronn//lib/ronn/template.rb#37
  def title; end

  # source://ronn//lib/ronn/template.rb#73
  def wrap_class_name; end
end

# source://ronn//lib/ronn/utils.rb#5
module Ronn::Utils
  # @return [Boolean]
  #
  # source://ronn//lib/ronn/utils.rb#31
  def block_element?(name); end

  # @return [Boolean]
  #
  # source://ronn//lib/ronn/utils.rb#47
  def child_of?(node, tag); end

  # @return [Boolean]
  #
  # source://ronn//lib/ronn/utils.rb#39
  def empty_element?(name); end

  # @return [Boolean]
  #
  # source://ronn//lib/ronn/utils.rb#43
  def html_element?(name); end

  # @return [Boolean]
  #
  # source://ronn//lib/ronn/utils.rb#35
  def inline_element?(name); end
end

# All HTML 4 elements and some that are in common use.
#
# source://ronn//lib/ronn/utils.rb#8
Ronn::Utils::HTML = T.let(T.unsafe(nil), Set)

# Block elements.
#
# source://ronn//lib/ronn/utils.rb#18
Ronn::Utils::HTML_BLOCK = T.let(T.unsafe(nil), Set)

# Elements that don't have a closing tag.
#
# source://ronn//lib/ronn/utils.rb#29
Ronn::Utils::HTML_EMPTY = T.let(T.unsafe(nil), Set)

# Inline elements
#
# source://ronn//lib/ronn/utils.rb#26
Ronn::Utils::HTML_INLINE = T.let(T.unsafe(nil), Set)

# source://ronn//lib/ronn.rb#49
Ronn::VERSION = T.let(T.unsafe(nil), String)
