# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rubocop-rails` gem.
# Please instead update this file by running `bin/tapioca gem rubocop-rails`.

# source://rubocop-rails//lib/rubocop/rails.rb#3
module RuboCop; end

# source://rubocop-rails//lib/rubocop/cop/mixin/active_record_helper.rb#4
module RuboCop::Cop; end

# A mixin to extend cops for Active Record features
#
# source://rubocop-rails//lib/rubocop/cop/mixin/active_record_helper.rb#6
module RuboCop::Cop::ActiveRecordHelper
  extend ::RuboCop::AST::NodePattern::Macros

  # source://rubocop-rails//lib/rubocop/cop/mixin/active_record_helper.rb#11
  def active_record?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/active_record_helper.rb#30
  def external_dependency_checksum; end

  # source://rubocop-rails//lib/rubocop/cop/mixin/active_record_helper.rb#22
  def find_belongs_to(param0); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/active_record_helper.rb#18
  def find_set_table_name(param0); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/active_record_helper.rb#79
  def foreign_key_of(belongs_to); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/mixin/active_record_helper.rb#100
  def in_where?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/mixin/active_record_helper.rb#26
  def inherit_active_record_base?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/mixin/active_record_helper.rb#91
  def polymorphic?(belongs_to); end

  # Resolve relation into column name.
  # It just returns column_name if the column exists.
  # Or it tries to resolve column_name as a relation.
  # Returns an array of column names if the relation is polymorphic.
  # It returns `nil` if it can't resolve.
  #
  # @param name [String]
  # @param class_node [RuboCop::AST::Node]
  # @param table [RuboCop::Rails::SchemaLoader::Table]
  # @return [Array, String, nil]
  #
  # source://rubocop-rails//lib/rubocop/cop/mixin/active_record_helper.rb#64
  def resolve_relation_into_column(name:, class_node:, table:); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/active_record_helper.rb#41
  def schema; end

  # source://rubocop-rails//lib/rubocop/cop/mixin/active_record_helper.rb#45
  def table_name(class_node); end
end

# source://rubocop-rails//lib/rubocop/cop/mixin/active_record_helper.rb#9
RuboCop::Cop::ActiveRecordHelper::WHERE_METHODS = T.let(T.unsafe(nil), Array)

# A mixin to extend cops for Active Record features
#
# source://rubocop-rails//lib/rubocop/cop/mixin/active_record_migrations_helper.rb#6
module RuboCop::Cop::ActiveRecordMigrationsHelper
  extend ::RuboCop::AST::NodePattern::Macros

  # source://rubocop-rails//lib/rubocop/cop/mixin/active_record_migrations_helper.rb#24
  def create_table_with_block?(param0 = T.unsafe(nil)); end
end

# source://rubocop-rails//lib/rubocop/cop/mixin/active_record_migrations_helper.rb#19
RuboCop::Cop::ActiveRecordMigrationsHelper::MYSQL_SCHEMA_DEFINITIONS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/mixin/active_record_migrations_helper.rb#14
RuboCop::Cop::ActiveRecordMigrationsHelper::POSTGRES_SCHEMA_DEFINITIONS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/mixin/active_record_migrations_helper.rb#9
RuboCop::Cop::ActiveRecordMigrationsHelper::RAILS_ABSTRACT_SCHEMA_DEFINITIONS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/mixin/active_record_migrations_helper.rb#13
RuboCop::Cop::ActiveRecordMigrationsHelper::RAILS_ABSTRACT_SCHEMA_DEFINITIONS_HELPERS = T.let(T.unsafe(nil), Array)

# A mixin to return all of the class send nodes.
#
# source://rubocop-rails//lib/rubocop/cop/mixin/class_send_node_helper.rb#6
module RuboCop::Cop::ClassSendNodeHelper
  # source://rubocop-rails//lib/rubocop/cop/mixin/class_send_node_helper.rb#7
  def class_send_nodes(class_node); end
end

# A mixin to extend cops in order to determine the database type.
#
# This module automatically detect an adapter from `development` environment
# in `config/database.yml` or the environment variable `DATABASE_URL`
# when the `Database` option is not set.
#
# source://rubocop-rails//lib/rubocop/cop/mixin/database_type_resolvable.rb#10
module RuboCop::Cop::DatabaseTypeResolvable
  # source://rubocop-rails//lib/rubocop/cop/mixin/database_type_resolvable.rb#14
  def database; end

  private

  # source://rubocop-rails//lib/rubocop/cop/mixin/database_type_resolvable.rb#61
  def database_adapter; end

  # source://rubocop-rails//lib/rubocop/cop/mixin/database_type_resolvable.rb#31
  def database_from_env; end

  # source://rubocop-rails//lib/rubocop/cop/mixin/database_type_resolvable.rb#20
  def database_from_yaml; end

  # source://rubocop-rails//lib/rubocop/cop/mixin/database_type_resolvable.rb#43
  def database_yaml; end
end

# source://rubocop-rails//lib/rubocop/cop/mixin/database_type_resolvable.rb#11
RuboCop::Cop::DatabaseTypeResolvable::MYSQL = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/mixin/database_type_resolvable.rb#12
RuboCop::Cop::DatabaseTypeResolvable::POSTGRESQL = T.let(T.unsafe(nil), String)

# Common functionality for enforcing a specific superclass.
#
# source://rubocop-rails//lib/rubocop/cop/mixin/enforce_superclass.rb#6
module RuboCop::Cop::EnforceSuperclass
  # source://rubocop-rails//lib/rubocop/cop/mixin/enforce_superclass.rb#19
  def on_class(node); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/enforce_superclass.rb#25
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/mixin/enforce_superclass.rb#33
  def register_offense(offense_node); end

  class << self
    # @private
    #
    # source://rubocop-rails//lib/rubocop/cop/mixin/enforce_superclass.rb#7
    def included(base); end
  end
end

# Common functionality for Rails/IndexBy and Rails/IndexWith
#
# source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#6
module RuboCop::Cop::IndexMethod
  # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#9
  def on_block(node); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#31
  def on_csend(node); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#21
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#95
  def execute_correction(corrector, node, correction); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#72
  def extract_captures(match); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#59
  def handle_possible_offense(node, match, match_desc); end

  # @raise [NotImplementedError]
  #
  # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#77
  def new_method_name; end

  # @abstract Implemented with `def_node_matcher`
  # @raise [NotImplementedError]
  #
  # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#40
  def on_bad_each_with_object(_node); end

  # @abstract Implemented with `def_node_matcher`
  # @raise [NotImplementedError]
  #
  # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#55
  def on_bad_hash_brackets_map(_node); end

  # @abstract Implemented with `def_node_matcher`
  # @raise [NotImplementedError]
  #
  # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#50
  def on_bad_map_to_h(_node); end

  # @abstract Implemented with `def_node_matcher`
  # @raise [NotImplementedError]
  #
  # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#45
  def on_bad_to_h(_node); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#81
  def prepare_correction(node); end
end

# Internal helper class to hold autocorrect data
#
# source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#115
class RuboCop::Cop::IndexMethod::Autocorrection < ::Struct
  # Returns the value of attribute block_node
  #
  # @return [Object] the current value of block_node
  def block_node; end

  # Sets the attribute block_node
  #
  # @param value [Object] the value to set the attribute block_node to.
  # @return [Object] the newly set value
  def block_node=(_); end

  # Returns the value of attribute leading
  #
  # @return [Object] the current value of leading
  def leading; end

  # Sets the attribute leading
  #
  # @param value [Object] the value to set the attribute leading to.
  # @return [Object] the newly set value
  def leading=(_); end

  # Returns the value of attribute match
  #
  # @return [Object] the current value of match
  def match; end

  # Sets the attribute match
  #
  # @param value [Object] the value to set the attribute match to.
  # @return [Object] the newly set value
  def match=(_); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#155
  def set_new_arg_name(transformed_argname, corrector); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#159
  def set_new_body_expression(transforming_body_expr, corrector); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#146
  def set_new_method_name(new_method_name, corrector); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#140
  def strip_prefix_and_suffix(node, corrector); end

  # Returns the value of attribute trailing
  #
  # @return [Object] the current value of trailing
  def trailing; end

  # Sets the attribute trailing
  #
  # @param value [Object] the value to set the attribute trailing to.
  # @return [Object] the newly set value
  def trailing=(_); end

  class << self
    def [](*_arg0); end

    # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#116
    def from_each_with_object(node, match); end

    # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#136
    def from_hash_brackets_map(node, match); end

    # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#124
    def from_map_to_h(node, match); end

    # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#120
    def from_to_h(node, match); end

    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Internal helper class to hold match data
#
# source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#105
class RuboCop::Cop::IndexMethod::Captures < ::Struct
  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#109
  def noop_transformation?; end

  # Returns the value of attribute transformed_argname
  #
  # @return [Object] the current value of transformed_argname
  def transformed_argname; end

  # Sets the attribute transformed_argname
  #
  # @param value [Object] the value to set the attribute transformed_argname to.
  # @return [Object] the newly set value
  def transformed_argname=(_); end

  # Returns the value of attribute transforming_body_expr
  #
  # @return [Object] the current value of transforming_body_expr
  def transforming_body_expr; end

  # Sets the attribute transforming_body_expr
  #
  # @param value [Object] the value to set the attribute transforming_body_expr to.
  # @return [Object] the newly set value
  def transforming_body_expr=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://rubocop-rails//lib/rubocop/cop/mixin/index_method.rb#7
RuboCop::Cop::IndexMethod::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Common functionality for cops working with migrations
#
# source://rubocop-rails//lib/rubocop/cop/mixin/migrations_helper.rb#6
module RuboCop::Cop::MigrationsHelper
  extend ::RuboCop::AST::NodePattern::Macros

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/mixin/migrations_helper.rb#19
  def in_migration?(node); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/migrations_helper.rb#9
  def migration_class?(param0 = T.unsafe(nil)); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/action_controller_flash_before_render.rb#5
module RuboCop::Cop::Rails; end

# Using `flash` assignment before `render` in Rails controllers will persist the message for too long.
# Check https://guides.rubyonrails.org/action_controller_overview.html#flash-now
#
# @example
#
#   # bad
#   class HomeController < ApplicationController
#   def create
#   flash[:alert] = "msg"
#   render :index
#   end
#   end
#
#   # good
#   class HomeController < ApplicationController
#   def create
#   flash.now[:alert] = "msg"
#   render :index
#   end
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/action_controller_flash_before_render.rb#31
class RuboCop::Cop::Rails::ActionControllerFlashBeforeRender < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/action_controller_flash_before_render.rb#44
  def action_controller?(param0); end

  # source://rubocop-rails//lib/rubocop/cop/rails/action_controller_flash_before_render.rb#36
  def flash_assignment?(param0); end

  # source://rubocop-rails//lib/rubocop/cop/rails/action_controller_flash_before_render.rb#53
  def on_send(flash_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/action_controller_flash_before_render.rb#40
  def render?(param0); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/action_controller_flash_before_render.rb#106
  def find_ancestor(node, type:); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/action_controller_flash_before_render.rb#69
  def followed_by_render?(flash_node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/action_controller_flash_before_render.rb#86
  def inherit_action_controller_base?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/action_controller_flash_before_render.rb#93
  def instance_method_or_block?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/action_controller_flash_before_render.rb#100
  def use_redirect_to?(context); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/action_controller_flash_before_render.rb#34
RuboCop::Cop::Rails::ActionControllerFlashBeforeRender::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/action_controller_flash_before_render.rb#51
RuboCop::Cop::Rails::ActionControllerFlashBeforeRender::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Using `ActionController::TestCase` is discouraged and should be replaced by
# `ActionDispatch::IntegrationTest`. Controller tests are too close to the
# internals of a controller whereas integration tests mimic the browser/user.
#
# @example
#   # bad
#   class MyControllerTest < ActionController::TestCase
#   end
#
#   # good
#   class MyControllerTest < ActionDispatch::IntegrationTest
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/action_controller_test_case.rb#23
class RuboCop::Cop::Rails::ActionControllerTestCase < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/action_controller_test_case.rb#31
  def action_controller_test_case?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/action_controller_test_case.rb#37
  def on_class(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/action_controller_test_case.rb#27
RuboCop::Cop::Rails::ActionControllerTestCase::MSG = T.let(T.unsafe(nil), String)

# Enforces the consistent use of action filter methods.
#
# The cop is configurable and can enforce the use of the older
# something_filter methods or the newer something_action methods.
#
# IMPORTANT: This cop is deprecated. Because the `*_filter` methods were removed in Rails 4.2,
# and that Rails version is no longer supported by RuboCop Rails. This cop will be removed in RuboCop Rails 3.0.
#
# @example EnforcedStyle: action (default)
#   # bad
#   after_filter :do_stuff
#   append_around_filter :do_stuff
#   skip_after_filter :do_stuff
#
#   # good
#   after_action :do_stuff
#   append_around_action :do_stuff
#   skip_after_action :do_stuff
# @example EnforcedStyle: filter
#   # bad
#   after_action :do_stuff
#   append_around_action :do_stuff
#   skip_after_action :do_stuff
#
#   # good
#   after_filter :do_stuff
#   append_around_filter :do_stuff
#   skip_after_filter :do_stuff
#
# source://rubocop-rails//lib/rubocop/cop/rails/action_filter.rb#35
class RuboCop::Cop::Rails::ActionFilter < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/action_filter.rb#75
  def on_block(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/action_filter.rb#79
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/action_filter.rb#96
  def bad_methods; end

  # source://rubocop-rails//lib/rubocop/cop/rails/action_filter.rb#85
  def check_method_node(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/action_filter.rb#100
  def good_methods; end

  # source://rubocop-rails//lib/rubocop/cop/rails/action_filter.rb#104
  def preferred_method(method); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/action_filter.rb#57
RuboCop::Cop::Rails::ActionFilter::ACTION_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/action_filter.rb#41
RuboCop::Cop::Rails::ActionFilter::FILTER_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/action_filter.rb#39
RuboCop::Cop::Rails::ActionFilter::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/action_filter.rb#73
RuboCop::Cop::Rails::ActionFilter::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces consistent ordering of the standard Rails RESTful controller actions.
#
# The cop is configurable and can enforce any ordering of the standard actions.
# All other methods are ignored. So, the actions specified in `ExpectedOrder` should be
# defined before actions not specified.
#
# [source,yaml]
# ----
#  Rails/ActionOrder:
#    ExpectedOrder:
#      - index
#      - show
#      - new
#      - edit
#      - create
#      - update
#      - destroy
# ----
#
# @example
#   # bad
#   def index; end
#   def destroy; end
#   def show; end
#
#   # good
#   def index; end
#   def show; end
#   def destroy; end
#
# source://rubocop-rails//lib/rubocop/cop/rails/action_order.rb#35
class RuboCop::Cop::Rails::ActionOrder < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::DefNode
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/action_order.rb#43
  def action_declarations(param0, param1); end

  # source://rubocop-rails//lib/rubocop/cop/rails/action_order.rb#45
  def on_class(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/action_order.rb#60
  def actions; end

  # source://rubocop-rails//lib/rubocop/cop/rails/action_order.rb#87
  def add_range(range1, range2); end

  # source://rubocop-rails//lib/rubocop/cop/rails/action_order.rb#83
  def correction_target(def_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/action_order.rb#56
  def expected_order; end

  # source://rubocop-rails//lib/rubocop/cop/rails/action_order.rb#64
  def find_index(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/action_order.rb#94
  def range_with_comments(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/action_order.rb#105
  def range_with_comments_and_lines(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/action_order.rb#68
  def register_offense(previous, current); end

  # source://rubocop-rails//lib/rubocop/cop/rails/action_order.rb#109
  def swap_range(corrector, range1, range2); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/action_order.rb#41
RuboCop::Cop::Rails::ActionOrder::MSG = T.let(T.unsafe(nil), String)

# Checks that ActiveRecord aliases are not used. The direct method names
# are more clear and easier to read.
#
# @example
#   # bad
#   book.update_attributes!(author: 'Alice')
#
#   # good
#   book.update!(author: 'Alice')
#
# source://rubocop-rails//lib/rubocop/cop/rails/active_record_aliases.rb#19
class RuboCop::Cop::Rails::ActiveRecordAliases < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/active_record_aliases.rb#28
  def on_csend(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/active_record_aliases.rb#28
  def on_send(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/active_record_aliases.rb#24
RuboCop::Cop::Rails::ActiveRecordAliases::ALIASES = T.let(T.unsafe(nil), Hash)

# source://rubocop-rails//lib/rubocop/cop/rails/active_record_aliases.rb#22
RuboCop::Cop::Rails::ActiveRecordAliases::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/active_record_aliases.rb#26
RuboCop::Cop::Rails::ActiveRecordAliases::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks that Active Record callbacks are declared
# in the order in which they will be executed.
#
# @example
#   # bad
#   class Person < ApplicationRecord
#   after_commit :after_commit_callback
#   before_validation :before_validation_callback
#   end
#
#   # good
#   class Person < ApplicationRecord
#   before_validation :before_validation_callback
#   after_commit :after_commit_callback
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/active_record_callbacks_order.rb#22
class RuboCop::Cop::Rails::ActiveRecordCallbacksOrder < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/active_record_callbacks_order.rb#51
  def on_class(class_node); end

  private

  # Autocorrect by swapping between two nodes autocorrecting them
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/active_record_callbacks_order.rb#73
  def autocorrect(corrector, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/active_record_callbacks_order.rb#111
  def begin_pos_with_comment(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/active_record_callbacks_order.rb#137
  def buffer; end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/active_record_callbacks_order.rb#95
  def callback?(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/active_record_callbacks_order.rb#85
  def defined_callbacks(class_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/active_record_callbacks_order.rb#106
  def end_position_for(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/active_record_callbacks_order.rb#125
  def inline_comment?(comment); end

  # source://rubocop-rails//lib/rubocop/cop/rails/active_record_callbacks_order.rb#99
  def source_range_with_comment(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/active_record_callbacks_order.rb#133
  def start_line_position(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/active_record_callbacks_order.rb#27
RuboCop::Cop::Rails::ActiveRecordCallbacksOrder::CALLBACKS_IN_ORDER = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/active_record_callbacks_order.rb#49
RuboCop::Cop::Rails::ActiveRecordCallbacksOrder::CALLBACKS_ORDER_MAP = T.let(T.unsafe(nil), Hash)

# source://rubocop-rails//lib/rubocop/cop/rails/active_record_callbacks_order.rb#25
RuboCop::Cop::Rails::ActiveRecordCallbacksOrder::MSG = T.let(T.unsafe(nil), String)

# Checks for overriding built-in Active Record methods instead of using
# callbacks.
#
# @example
#   # bad
#   class Book < ApplicationRecord
#   def save
#   self.title = title.upcase!
#   super
#   end
#   end
#
#   # good
#   class Book < ApplicationRecord
#   before_save :upcase_title
#
#   def upcase_title
#   self.title = title.upcase!
#   end
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/active_record_override.rb#27
class RuboCop::Cop::Rails::ActiveRecordOverride < ::RuboCop::Cop::Base
  # source://rubocop-rails//lib/rubocop/cop/rails/active_record_override.rb#32
  def on_def(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/active_record_override.rb#45
  def active_model?(parent_class_name); end

  # source://rubocop-rails//lib/rubocop/cop/rails/active_record_override.rb#49
  def callback_names(method_name); end

  # source://rubocop-rails//lib/rubocop/cop/rails/active_record_override.rb#63
  def find_parent_class_name(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/active_record_override.rb#59
  def message(method_name); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/active_record_override.rb#30
RuboCop::Cop::Rails::ActiveRecordOverride::ACTIVE_RECORD_CLASSES = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/active_record_override.rb#29
RuboCop::Cop::Rails::ActiveRecordOverride::BAD_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/active_record_override.rb#28
RuboCop::Cop::Rails::ActiveRecordOverride::MSG = T.let(T.unsafe(nil), String)

# Checks that ActiveSupport aliases to core ruby methods
# are not used.
#
# @example
#   # good
#   'some_string'.start_with?('prefix')
#   'some_string'.end_with?('suffix')
#   [1, 2, 'a'] << 'b'
#   [1, 2, 'a'].unshift('b')
#
#   # bad
#   'some_string'.starts_with?('prefix')
#   'some_string'.ends_with?('suffix')
#   [1, 2, 'a'].append('b')
#   [1, 2, 'a'].prepend('b')
#
# source://rubocop-rails//lib/rubocop/cop/rails/active_support_aliases.rb#22
class RuboCop::Cop::Rails::ActiveSupportAliases < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/active_support_aliases.rb#40
  def append(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/active_support_aliases.rb#40
  def ends_with?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/active_support_aliases.rb#43
  def on_csend(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/active_support_aliases.rb#43
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/active_support_aliases.rb#40
  def prepend(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/active_support_aliases.rb#40
  def starts_with?(param0 = T.unsafe(nil)); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/active_support_aliases.rb#28
RuboCop::Cop::Rails::ActiveSupportAliases::ALIASES = T.let(T.unsafe(nil), Hash)

# source://rubocop-rails//lib/rubocop/cop/rails/active_support_aliases.rb#25
RuboCop::Cop::Rails::ActiveSupportAliases::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/active_support_aliases.rb#26
RuboCop::Cop::Rails::ActiveSupportAliases::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for Rails framework classes that are patched directly instead of using Active Support load hooks. Direct
# patching forcibly loads the framework referenced, using hooks defers loading until it's actually needed.
#
# @example
#
#   # bad
#   ActiveRecord::Base.include(MyClass)
#
#   # good
#   ActiveSupport.on_load(:active_record) { include MyClass }
#
# source://rubocop-rails//lib/rubocop/cop/rails/active_support_on_load.rb#20
class RuboCop::Cop::Rails::ActiveSupportOnLoad < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/active_support_on_load.rb#58
  def on_send(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/active_support_on_load.rb#25
RuboCop::Cop::Rails::ActiveSupportOnLoad::LOAD_HOOKS = T.let(T.unsafe(nil), Hash)

# source://rubocop-rails//lib/rubocop/cop/rails/active_support_on_load.rb#23
RuboCop::Cop::Rails::ActiveSupportOnLoad::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/active_support_on_load.rb#24
RuboCop::Cop::Rails::ActiveSupportOnLoad::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for migrations using `add_column` that have an `index`
# key. `add_column` does not accept `index`, but also does not raise an
# error for extra keys, so it is possible to mistakenly add the key without
# realizing it will not actually add an index.
#
# @example
#   # bad (will not add an index)
#   add_column :table, :column, :integer, index: true
#
#   # good
#   add_column :table, :column, :integer
#   add_index :table, :column
#
# source://rubocop-rails//lib/rubocop/cop/rails/add_column_index.rb#19
class RuboCop::Cop::Rails::AddColumnIndex < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/add_column_index.rb#27
  def add_column_with_index(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/add_column_index.rb#34
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/add_column_index.rb#55
  def index_range(pair_node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/add_column_index.rb#23
RuboCop::Cop::Rails::AddColumnIndex::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/add_column_index.rb#24
RuboCop::Cop::Rails::AddColumnIndex::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces that there is only one call to `after_commit`
# (and its aliases - `after_create_commit`, `after_update_commit`,
# and `after_destroy_commit`) with the same callback name per model.
#
# @example
#   # bad
#   # This won't be triggered.
#   after_create_commit :log_action
#
#   # This will override the callback added by
#   # after_create_commit.
#   after_update_commit :log_action
#
#   # bad
#   # This won't be triggered.
#   after_commit :log_action, on: :create
#   # This won't be triggered.
#   after_update_commit :log_action
#   # This will override both previous callbacks.
#   after_commit :log_action, on: :destroy
#
#   # good
#   after_save_commit :log_action
#
#   # good
#   after_create_commit :log_create_action
#   after_update_commit :log_update_action
#
# source://rubocop-rails//lib/rubocop/cop/rails/after_commit_override.rb#34
class RuboCop::Cop::Rails::AfterCommitOverride < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ClassSendNodeHelper

  # source://rubocop-rails//lib/rubocop/cop/rails/after_commit_override.rb#47
  def on_class(class_node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/after_commit_override.rb#68
  def after_commit_callback?(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/after_commit_override.rb#62
  def each_after_commit_callback(class_node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/after_commit_override.rb#72
  def named_callback?(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/after_commit_override.rb#39
RuboCop::Cop::Rails::AfterCommitOverride::AFTER_COMMIT_CALLBACKS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/after_commit_override.rb#37
RuboCop::Cop::Rails::AfterCommitOverride::MSG = T.let(T.unsafe(nil), String)

# TODO: In the future, please support only RuboCop 1.52+ and use `RuboCop::Cop::AllowedReceivers`:
#       https://github.com/rubocop/rubocop/blob/v1.52.0/lib/rubocop/cop/mixin/allowed_receivers.rb
#       At that time, this duplicated module implementation can be removed.
#
# source://rubocop-rails//lib/rubocop/cop/rails/redundant_active_record_all_method.rb#9
module RuboCop::Cop::Rails::AllowedReceivers
  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_active_record_all_method.rb#10
  def allowed_receiver?(receiver); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_active_record_all_method.rb#30
  def allowed_receivers; end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_active_record_all_method.rb#16
  def receiver_name(receiver); end
end

# Checks that controllers subclass `ApplicationController`.
#
# @example
#
#   # good
#   class MyController < ApplicationController
#   # ...
#   end
#
#   # bad
#   class MyController < ActionController::Base
#   # ...
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/application_controller.rb#23
class RuboCop::Cop::Rails::ApplicationController < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::EnforceSuperclass
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/mixin/enforce_superclass.rb#8
  def class_definition(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/enforce_superclass.rb#12
  def class_new_definition(param0 = T.unsafe(nil)); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/application_controller.rb#28
RuboCop::Cop::Rails::ApplicationController::BASE_PATTERN = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/application_controller.rb#26
RuboCop::Cop::Rails::ApplicationController::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/application_controller.rb#27
RuboCop::Cop::Rails::ApplicationController::SUPERCLASS = T.let(T.unsafe(nil), String)

# Checks that jobs subclass `ApplicationJob` with Rails 5.0.
#
# @example
#
#   # good
#   class Rails5Job < ApplicationJob
#   # ...
#   end
#
#   # bad
#   class Rails4Job < ActiveJob::Base
#   # ...
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/application_job.rb#23
class RuboCop::Cop::Rails::ApplicationJob < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::EnforceSuperclass
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/application_job.rb#37
  def autocorrect(node); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/enforce_superclass.rb#8
  def class_definition(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/enforce_superclass.rb#12
  def class_new_definition(param0 = T.unsafe(nil)); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/application_job.rb#31
RuboCop::Cop::Rails::ApplicationJob::BASE_PATTERN = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/application_job.rb#29
RuboCop::Cop::Rails::ApplicationJob::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/application_job.rb#30
RuboCop::Cop::Rails::ApplicationJob::SUPERCLASS = T.let(T.unsafe(nil), String)

# Checks that mailers subclass `ApplicationMailer` with Rails 5.0.
#
# @example
#
#   # good
#   class MyMailer < ApplicationMailer
#   # ...
#   end
#
#   # bad
#   class MyMailer < ActionMailer::Base
#   # ...
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/application_mailer.rb#23
class RuboCop::Cop::Rails::ApplicationMailer < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::EnforceSuperclass
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/mixin/enforce_superclass.rb#8
  def class_definition(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/enforce_superclass.rb#12
  def class_new_definition(param0 = T.unsafe(nil)); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/application_mailer.rb#31
RuboCop::Cop::Rails::ApplicationMailer::BASE_PATTERN = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/application_mailer.rb#29
RuboCop::Cop::Rails::ApplicationMailer::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/application_mailer.rb#30
RuboCop::Cop::Rails::ApplicationMailer::SUPERCLASS = T.let(T.unsafe(nil), String)

# Checks that models subclass `ApplicationRecord` with Rails 5.0.
#
# @example
#
#   # good
#   class Rails5Model < ApplicationRecord
#   # ...
#   end
#
#   # bad
#   class Rails4Model < ActiveRecord::Base
#   # ...
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/application_record.rb#24
class RuboCop::Cop::Rails::ApplicationRecord < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::EnforceSuperclass
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/mixin/enforce_superclass.rb#8
  def class_definition(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/mixin/enforce_superclass.rb#12
  def class_new_definition(param0 = T.unsafe(nil)); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/application_record.rb#32
RuboCop::Cop::Rails::ApplicationRecord::BASE_PATTERN = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/application_record.rb#30
RuboCop::Cop::Rails::ApplicationRecord::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/application_record.rb#31
RuboCop::Cop::Rails::ApplicationRecord::SUPERCLASS = T.let(T.unsafe(nil), String)

# Prevents usage of `"*"` on an Arel::Table column reference.
#
# Using `arel_table["*"]` causes the outputted string to be a literal
# quoted asterisk (e.g. <tt>`my_model`.`*`</tt>). This causes the
# database to look for a column named <tt>`*`</tt> (or `"*"`) as opposed
# to expanding the column list as one would likely expect.
#
# @example
#   # bad
#   MyTable.arel_table["*"]
#
#   # good
#   MyTable.arel_table[Arel.star]
#
# source://rubocop-rails//lib/rubocop/cop/rails/arel_star.rb#26
class RuboCop::Cop::Rails::ArelStar < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/arel_star.rb#37
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/arel_star.rb#33
  def star_bracket?(param0 = T.unsafe(nil)); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/arel_star.rb#29
RuboCop::Cop::Rails::ArelStar::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/arel_star.rb#31
RuboCop::Cop::Rails::ArelStar::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Use `assert_not` instead of `assert !`.
#
# @example
#   # bad
#   assert !x
#
#   # good
#   assert_not x
#
# source://rubocop-rails//lib/rubocop/cop/rails/assert_not.rb#15
class RuboCop::Cop::Rails::AssertNot < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/assert_not.rb#21
  def offensive?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/assert_not.rb#23
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/assert_not.rb#35
  def corrected_source(source); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/assert_not.rb#18
RuboCop::Cop::Rails::AssertNot::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/assert_not.rb#19
RuboCop::Cop::Rails::AssertNot::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Looks for `attribute` class methods that specify a `:default` option
# which value is an array, string literal or method call without a block.
# It will accept all other values, such as string, symbol, integer and float literals
# as well as constants.
#
# @example
#   # bad
#   class User < ApplicationRecord
#   attribute :confirmed_at, :datetime, default: Time.zone.now
#   end
#
#   # good
#   class User < ApplicationRecord
#   attribute :confirmed_at, :datetime, default: -> { Time.zone.now }
#   end
#
#   # bad
#   class User < ApplicationRecord
#   attribute :roles, :string, array: true, default: []
#   end
#
#   # good
#   class User < ApplicationRecord
#   attribute :roles, :string, array: true, default: -> { [] }
#   end
#
#   # bad
#   class User < ApplicationRecord
#   attribute :configuration, default: {}
#   end
#
#   # good
#   class User < ApplicationRecord
#   attribute :configuration, default: -> { {} }
#   end
#
#   # good
#   class User < ApplicationRecord
#   attribute :role, :string, default: :customer
#   end
#
#   # good
#   class User < ApplicationRecord
#   attribute :activated, :boolean, default: false
#   end
#
#   # good
#   class User < ApplicationRecord
#   attribute :login_count, :integer, default: 0
#   end
#
#   # good
#   class User < ApplicationRecord
#   FOO = 123
#   attribute :custom_attribute, :integer, default: FOO
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/attribute_default_block_value.rb#62
class RuboCop::Cop::Rails::AttributeDefaultBlockValue < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/attribute_default_block_value.rb#73
  def attribute(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/attribute_default_block_value.rb#69
  def default_attribute(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/attribute_default_block_value.rb#75
  def on_send(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/attribute_default_block_value.rb#65
RuboCop::Cop::Rails::AttributeDefaultBlockValue::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/attribute_default_block_value.rb#66
RuboCop::Cop::Rails::AttributeDefaultBlockValue::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/attribute_default_block_value.rb#67
RuboCop::Cop::Rails::AttributeDefaultBlockValue::TYPE_OFFENDERS = T.let(T.unsafe(nil), Array)

# Looks for belongs_to associations where we control whether the
# association is required via the deprecated `required` option instead.
#
# Since Rails 5, belongs_to associations are required by default and this
# can be controlled through the use of `optional: true`.
#
# From the release notes:
#
#     belongs_to will now trigger a validation error by default if the
#     association is not present. You can turn this off on a
#     per-association basis with optional: true. Also deprecate required
#     option in favor of optional for belongs_to. (Pull Request)
#
# In the case that the developer is doing `required: false`, we
# definitely want to autocorrect to `optional: true`.
#
# However, without knowing whether they've set overridden the default
# value of `config.active_record.belongs_to_required_by_default`, we
# can't say whether it's safe to remove `required: true` or whether we
# should replace it with `optional: false` (or, similarly, remove a
# superfluous `optional: false`). Therefore, in the cases we're using
# `required: true`, we'll simply invert it to `optional: false` and the
# user can remove depending on their defaults.
#
# @example
#   # bad
#   class Post < ApplicationRecord
#   belongs_to :blog, required: false
#   end
#
#   # good
#   class Post < ApplicationRecord
#   belongs_to :blog, optional: true
#   end
#
#   # bad
#   class Post < ApplicationRecord
#   belongs_to :blog, required: true
#   end
#
#   # good
#   class Post < ApplicationRecord
#   belongs_to :blog, optional: false
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/belongs_to.rb#50
class RuboCop::Cop::Rails::BelongsTo < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/belongs_to.rb#67
  def match_belongs_to_with_options(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/belongs_to.rb#73
  def on_send(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/belongs_to.rb#65
RuboCop::Cop::Rails::BelongsTo::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/belongs_to.rb#56
RuboCop::Cop::Rails::BelongsTo::SUPERFLOUS_REQUIRE_FALSE_MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/belongs_to.rb#60
RuboCop::Cop::Rails::BelongsTo::SUPERFLOUS_REQUIRE_TRUE_MSG = T.let(T.unsafe(nil), String)

# Checks for code that can be written with simpler conditionals
# using `Object#blank?` defined by Active Support.
#
# Interaction with `Style/UnlessElse`:
# The configuration of `NotPresent` will not produce an offense in the
# context of `unless else` if `Style/UnlessElse` is enabled. This is
# to prevent interference between the autocorrection of the two cops.
#
# @example NilOrEmpty: true (default)
#   # Converts usages of `nil? || empty?` to `blank?`
#
#   # bad
#   foo.nil? || foo.empty?
#   foo == nil || foo.empty?
#
#   # good
#   foo.blank?
# @example NotPresent: true (default)
#   # Converts usages of `!present?` to `blank?`
#
#   # bad
#   !foo.present?
#
#   # good
#   foo.blank?
# @example UnlessPresent: true (default)
#   # Converts usages of `unless present?` to `if blank?`
#
#   # bad
#   something unless foo.present?
#
#   # good
#   something if foo.blank?
#
#   # bad
#   unless foo.present?
#   something
#   end
#
#   # good
#   if foo.blank?
#   something
#   end
#
#   # good
#   def blank?
#   !present?
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/blank.rb#61
class RuboCop::Cop::Rails::Blank < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/blank.rb#90
  def defining_blank?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/blank.rb#73
  def nil_or_empty?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/blank.rb#88
  def not_present?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/blank.rb#123
  def on_if(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/blank.rb#110
  def on_or(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/blank.rb#96
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/blank.rb#92
  def unless_present?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/blank.rb#140
  def autocorrect(corrector, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/blank.rb#162
  def replacement(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/blank.rb#154
  def unless_condition(node, method_call); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/blank.rb#64
RuboCop::Cop::Rails::Blank::MSG_NIL_OR_EMPTY = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/blank.rb#65
RuboCop::Cop::Rails::Blank::MSG_NOT_PRESENT = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/blank.rb#66
RuboCop::Cop::Rails::Blank::MSG_UNLESS_PRESENT = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/blank.rb#67
RuboCop::Cop::Rails::Blank::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks whether alter queries are combinable.
# If combinable queries are detected, it suggests to you
# to use `change_table` with `bulk: true` instead.
# This option causes the migration to generate a single
# ALTER TABLE statement combining multiple column alterations.
#
# The `bulk` option is only supported on the MySQL and
# the PostgreSQL (5.2 later) adapter; thus it will
# automatically detect an adapter from `development` environment
# in `config/database.yml` or the environment variable `DATABASE_URL`
# when the `Database` option is not set.
# If the adapter is not `mysql2`, `trilogy`, `postgresql`, or `postgis`,
# this Cop ignores offenses.
#
# @example
#   # bad
#   def change
#   add_column :users, :name, :string, null: false
#   add_column :users, :nickname, :string
#
#   # ALTER TABLE `users` ADD `name` varchar(255) NOT NULL
#   # ALTER TABLE `users` ADD `nickname` varchar(255)
#   end
#
#   # good
#   def change
#   change_table :users, bulk: true do |t|
#   t.string :name, null: false
#   t.string :nickname
#   end
#
#   # ALTER TABLE `users` ADD `name` varchar(255) NOT NULL,
#   #                     ADD `nickname` varchar(255)
#   end
# @example
#   # bad
#   def change
#   change_table :users do |t|
#   t.string :name, null: false
#   t.string :nickname
#   end
#   end
#
#   # good
#   def change
#   change_table :users, bulk: true do |t|
#   t.string :name, null: false
#   t.string :nickname
#   end
#   end
#
#   # good
#   # When you don't want to combine alter queries.
#   def change
#   change_table :users, bulk: false do |t|
#   t.string :name, null: false
#   t.string :nickname
#   end
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#66
class RuboCop::Cop::Rails::BulkChangeTable < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::DatabaseTypeResolvable

  # source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#119
  def on_def(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#137
  def on_send(node); end

  private

  # @param node [RuboCop::AST::SendNode]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#213
  def add_offense_for_alter_methods(node); end

  # @param node [RuboCop::AST::SendNode]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#223
  def add_offense_for_change_table(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#190
  def call_to_combinable_alter_method?(child_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#194
  def combinable_alter_methods; end

  # source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#203
  def combinable_transformations; end

  # source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#158
  def count_transformations(send_nodes); end

  # @param node [RuboCop::AST::SendNode] (send nil? :change_table ...)
  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#169
  def include_bulk_options?(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#150
  def send_nodes_from_change_table_block(body); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#177
  def support_bulk_alter?; end
end

# Record combinable alter methods and register offensive nodes.
#
# source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#228
class RuboCop::Cop::Rails::BulkChangeTable::AlterMethodsRecorder
  # @return [AlterMethodsRecorder] a new instance of AlterMethodsRecorder
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#229
  def initialize; end

  # source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#248
  def flush; end

  # source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#253
  def offensive_nodes; end

  # @param new_node [RuboCop::AST::SendNode]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#235
  def process(new_node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#102
RuboCop::Cop::Rails::BulkChangeTable::COMBINABLE_ALTER_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#78
RuboCop::Cop::Rails::BulkChangeTable::COMBINABLE_TRANSFORMATIONS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#76
RuboCop::Cop::Rails::BulkChangeTable::MIGRATION_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#72
RuboCop::Cop::Rails::BulkChangeTable::MSG_FOR_ALTER_METHODS = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#69
RuboCop::Cop::Rails::BulkChangeTable::MSG_FOR_CHANGE_TABLE = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#113
RuboCop::Cop::Rails::BulkChangeTable::MYSQL_COMBINABLE_ALTER_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#111
RuboCop::Cop::Rails::BulkChangeTable::MYSQL_COMBINABLE_TRANSFORMATIONS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#117
RuboCop::Cop::Rails::BulkChangeTable::POSTGRESQL_COMBINABLE_ALTER_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/bulk_change_table.rb#115
RuboCop::Cop::Rails::BulkChangeTable::POSTGRESQL_COMBINABLE_TRANSFORMATIONS = T.let(T.unsafe(nil), Array)

# Checks if collection can be blank-compacted with `compact_blank`.
#
# @example
#
#   # bad
#   collection.reject(&:blank?)
#   collection.reject { |_k, v| v.blank? }
#
#   # good
#   collection.compact_blank
#
#   # bad
#   collection.delete_if(&:blank?)            # Same behavior as `Array#compact_blank!` and `Hash#compact_blank!`
#   collection.delete_if { |_k, v| v.blank? } # Same behavior as `Array#compact_blank!` and `Hash#compact_blank!`
#   collection.reject!(&:blank?)              # Same behavior as `ActionController::Parameters#compact_blank!`
#   collection.reject! { |_k, v| v.blank? }   # Same behavior as `ActionController::Parameters#compact_blank!`
#
#   # good
#   collection.compact_blank!
#
# source://rubocop-rails//lib/rubocop/cop/rails/compact_blank.rb#40
class RuboCop::Cop::Rails::CompactBlank < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/compact_blank.rb#64
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/compact_blank.rb#50
  def reject_with_block?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/compact_blank.rb#58
  def reject_with_block_pass?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/compact_blank.rb#76
  def bad_method?(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/compact_blank.rb#95
  def offense_range(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/compact_blank.rb#105
  def preferred_method(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/compact_blank.rb#91
  def use_hash_value_block_argument?(arguments, receiver_in_block); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/compact_blank.rb#87
  def use_single_value_block_argument?(arguments, receiver_in_block); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/compact_blank.rb#45
RuboCop::Cop::Rails::CompactBlank::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/compact_blank.rb#46
RuboCop::Cop::Rails::CompactBlank::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks legacy syntax usage of `tag`
#
# NOTE: Allow `tag` when the first argument is a variable because
# `tag(name)` is simpler rather than `tag.public_send(name)`.
# And this cop will be renamed to something like `LegacyTag` in the future. (e.g. RuboCop Rails 2.0)
#
# @example
#   # bad
#   tag(:p)
#   tag(:br, class: 'classname')
#
#   # good
#   tag.p
#   tag.br(class: 'classname')
#   tag(name, class: 'classname')
#
# source://rubocop-rails//lib/rubocop/cop/rails/content_tag.rb#21
class RuboCop::Cop::Rails::ContentTag < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/content_tag.rb#31
  def on_new_investigation; end

  # source://rubocop-rails//lib/rubocop/cop/rails/content_tag.rb#35
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/content_tag.rb#54
  def allowed_argument?(argument); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/content_tag.rb#81
  def allowed_name?(argument); end

  # source://rubocop-rails//lib/rubocop/cop/rails/content_tag.rb#72
  def autocorrect(corrector, node, preferred_method); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/content_tag.rb#50
  def corrected_ancestor?(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/content_tag.rb#87
  def correction_range(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/content_tag.rb#63
  def register_offense(node, message, preferred_method); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/content_tag.rb#28
RuboCop::Cop::Rails::ContentTag::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/content_tag.rb#29
RuboCop::Cop::Rails::ContentTag::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks the migration for which timestamps are not included when creating a new table.
# In many cases, timestamps are useful information and should be added.
#
# NOTE: Allow `timestamps` not written when `id: false` because this emphasizes respecting
# user's editing intentions.
#
# @example
#   # bad
#   create_table :users
#
#   # bad
#   create_table :users do |t|
#   t.string :name
#   t.string :email
#   end
#
#   # good
#   create_table :users do |t|
#   t.string :name
#   t.string :email
#
#   t.timestamps
#   end
#
#   # good
#   create_table :users do |t|
#   t.string :name
#   t.string :email
#
#   t.datetime :created_at, default: -> { 'CURRENT_TIMESTAMP' }
#   end
#
#   # good
#   create_table :users do |t|
#   t.string :name
#   t.string :email
#
#   t.datetime :updated_at, default: -> { 'CURRENT_TIMESTAMP' }
#   end
#
#   # good
#   create_table :users, articles, id: false do |t|
#   t.integer :user_id
#   t.integer :article_id
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/create_table_with_timestamps.rb#52
class RuboCop::Cop::Rails::CreateTableWithTimestamps < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ActiveRecordMigrationsHelper

  # source://rubocop-rails//lib/rubocop/cop/rails/create_table_with_timestamps.rb#62
  def create_table_with_timestamps_proc?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/create_table_with_timestamps.rb#70
  def created_at_or_updated_at_included?(param0); end

  # source://rubocop-rails//lib/rubocop/cop/rails/create_table_with_timestamps.rb#76
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/create_table_with_timestamps.rb#66
  def timestamps_included?(param0); end

  # source://rubocop-rails//lib/rubocop/cop/rails/create_table_with_timestamps.rb#58
  def use_id_false_option?(param0); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/create_table_with_timestamps.rb#92
  def time_columns_included?(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/create_table_with_timestamps.rb#55
RuboCop::Cop::Rails::CreateTableWithTimestamps::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/create_table_with_timestamps.rb#56
RuboCop::Cop::Rails::CreateTableWithTimestamps::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Avoid dangerous column names.
#
# Some column names are considered dangerous because they would overwrite methods already defined.
#
# @example
#   # bad
#   add_column :users, :save
#
#   # good
#   add_column :users, :saved
#
# source://rubocop-rails//lib/rubocop/cop/rails/dangerous_column_names.rb#16
class RuboCop::Cop::Rails::DangerousColumnNames < ::RuboCop::Cop::Base
  # source://rubocop-rails//lib/rubocop/cop/rails/dangerous_column_names.rb#414
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/dangerous_column_names.rb#424
  def column_name_node_from(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/dangerous_column_names.rb#441
  def dangerous_column_name?(column_name); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/dangerous_column_names.rb#435
  def dangerous_column_name_node?(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/dangerous_column_names.rb#17
RuboCop::Cop::Rails::DangerousColumnNames::COLUMN_TYPE_METHOD_NAMES = T.let(T.unsafe(nil), Set)

# Generated from `ActiveRecord::AttributeMethods.dangerous_attribute_methods` on activerecord 7.1.0.
#
# source://rubocop-rails//lib/rubocop/cop/rails/dangerous_column_names.rb#36
RuboCop::Cop::Rails::DangerousColumnNames::DANGEROUS_COLUMN_NAMES = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/dangerous_column_names.rb#410
RuboCop::Cop::Rails::DangerousColumnNames::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/dangerous_column_names.rb#412
RuboCop::Cop::Rails::DangerousColumnNames::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the correct use of Date methods,
# such as Date.today, Date.current etc.
#
# Using `Date.today` is dangerous, because it doesn't know anything about
# Rails time zone. You must use `Time.zone.today` instead.
#
# The cop also reports warnings when you are using `to_time` method,
# because it doesn't know about Rails time zone either.
#
# Two styles are supported for this cop. When `EnforcedStyle` is 'strict'
# then the Date methods `today`, `current`, `yesterday`, and `tomorrow`
# are prohibited and the usage of both `to_time`
# and 'to_time_in_current_zone' are reported as warning.
#
# When `EnforcedStyle` is `flexible` then only `Date.today` is prohibited.
#
# And you can set a warning for `to_time` with `AllowToTime: false`.
# `AllowToTime` is `true` by default to prevent false positive on `DateTime` object.
#
# @example EnforcedStyle: flexible (default)
#   # bad
#   Date.today
#
#   # good
#   Time.zone.today
#   Time.zone.today - 1.day
#   Date.current
#   Date.yesterday
#   date.in_time_zone
# @example EnforcedStyle: strict
#   # bad
#   Date.current
#   Date.yesterday
#   Date.today
#
#   # good
#   Time.zone.today
#   Time.zone.today - 1.day
# @example AllowToTime: true (default)
#   # good
#   date.to_time
# @example AllowToTime: false
#   # bad
#   date.to_time
#
# source://rubocop-rails//lib/rubocop/cop/rails/date.rb#56
class RuboCop::Cop::Rails::Date < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/date.rb#73
  def on_const(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/date.rb#81
  def on_csend(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/date.rb#81
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/date.rb#153
  def allow_to_time?; end

  # source://rubocop-rails//lib/rubocop/cop/rails/date.rb#161
  def bad_days; end

  # source://rubocop-rails//lib/rubocop/cop/rails/date.rb#165
  def bad_methods; end

  # source://rubocop-rails//lib/rubocop/cop/rails/date.rb#106
  def check_date_node(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/date.rb#94
  def check_deprecated_methods(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/date.rb#123
  def extract_method_chain(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/date.rb#157
  def good_days; end

  # source://rubocop-rails//lib/rubocop/cop/rails/date.rb#169
  def good_methods; end

  # checks that parent node of send_type
  # and receiver is the given node
  #
  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/date.rb#129
  def method_send?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/date.rb#135
  def safe_chain?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/date.rb#141
  def safe_to_time?(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/date.rb#67
RuboCop::Cop::Rails::Date::BAD_DAYS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/date.rb#69
RuboCop::Cop::Rails::Date::DEPRECATED_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/date.rb#71
RuboCop::Cop::Rails::Date::DEPRECATED_MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/date.rb#61
RuboCop::Cop::Rails::Date::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/date.rb#63
RuboCop::Cop::Rails::Date::MSG_SEND = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/date.rb#65
RuboCop::Cop::Rails::Date::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Looks for uses of `default_scope`.
#
# @example
#   # bad
#   default_scope -> { where(hidden: false) }
#
#   # good
#   scope :published, -> { where(hidden: false) }
#
#   # bad
#   def self.default_scope
#   where(hidden: false)
#   end
#
#   # good
#   def self.published
#   where(hidden: false)
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/default_scope.rb#25
class RuboCop::Cop::Rails::DefaultScope < ::RuboCop::Cop::Base
  # source://rubocop-rails//lib/rubocop/cop/rails/default_scope.rb#33
  def class_method_definition?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/default_scope.rb#37
  def eigenclass_method_definition?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/default_scope.rb#29
  def method_call?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/default_scope.rb#47
  def on_defs(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/default_scope.rb#53
  def on_sclass(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/default_scope.rb#41
  def on_send(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/default_scope.rb#26
RuboCop::Cop::Rails::DefaultScope::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/default_scope.rb#27
RuboCop::Cop::Rails::DefaultScope::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Looks for delegations that could have been created
# automatically with the `delegate` method.
#
# Safe navigation `&.` is ignored because Rails' `allow_nil`
# option checks not just for nil but also delegates if nil
# responds to the delegated method.
#
# The `EnforceForPrefixed` option (defaulted to `true`) means that
# using the target object as a prefix of the method name
# without using the `delegate` method will be a violation.
# When set to `false`, this case is legal.
#
# @example
#   # bad
#   def bar
#   foo.bar
#   end
#
#   # good
#   delegate :bar, to: :foo
#
#   # bad
#   def bar
#   self.bar
#   end
#
#   # good
#   delegate :bar, to: :self
#
#   # good
#   def bar
#   foo&.bar
#   end
#
#   # good
#   private
#   def bar
#   foo.bar
#   end
# @example EnforceForPrefixed: true (default)
#   # bad
#   def foo_bar
#   foo.bar
#   end
#
#   # good
#   delegate :bar, to: :foo, prefix: true
# @example EnforceForPrefixed: false
#   # good
#   def foo_bar
#   foo.bar
#   end
#
#   # good
#   delegate :bar, to: :foo, prefix: true
#
# source://rubocop-rails//lib/rubocop/cop/rails/delegate.rb#63
class RuboCop::Cop::Rails::Delegate < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/delegate.rb#69
  def delegate?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/delegate.rb#74
  def on_def(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/delegate.rb#102
  def arguments_match?(arg_array, body); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/delegate.rb#116
  def include_prefix_case?; end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/delegate.rb#112
  def method_name_matches?(method_name, body); end

  # source://rubocop-rails//lib/rubocop/cop/rails/delegate.rb#120
  def prefixed_method_name(body); end

  # source://rubocop-rails//lib/rubocop/cop/rails/delegate.rb#126
  def private_or_protected_delegation(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/delegate.rb#130
  def private_or_protected_inline(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/delegate.rb#83
  def register_offense(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/delegate.rb#96
  def trivial_delegate?(def_node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/delegate.rb#67
RuboCop::Cop::Rails::Delegate::MSG = T.let(T.unsafe(nil), String)

# Looks for delegations that pass :allow_blank as an option
# instead of :allow_nil. :allow_blank is not a valid option to pass
# to ActiveSupport#delegate.
#
# @example
#   # bad
#   delegate :foo, to: :bar, allow_blank: true
#
#   # good
#   delegate :foo, to: :bar, allow_nil: true
#
# source://rubocop-rails//lib/rubocop/cop/rails/delegate_allow_blank.rb#16
class RuboCop::Cop::Rails::DelegateAllowBlank < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/delegate_allow_blank.rb#22
  def allow_blank_option(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/delegate_allow_blank.rb#26
  def on_send(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/delegate_allow_blank.rb#19
RuboCop::Cop::Rails::DelegateAllowBlank::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/delegate_allow_blank.rb#20
RuboCop::Cop::Rails::DelegateAllowBlank::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks direct manipulation of ActiveModel#errors as hash.
# These operations are deprecated in Rails 6.1 and will not work in Rails 7.
#
# @example
#   # bad
#   user.errors[:name] << 'msg'
#   user.errors.messages[:name] << 'msg'
#
#   # good
#   user.errors.add(:name, 'msg')
#
#   # bad
#   user.errors[:name].clear
#   user.errors.messages[:name].clear
#
#   # good
#   user.errors.delete(:name)
#
#   # bad
#   user.errors.keys.include?(:attr)
#
#   # good
#   user.errors.attribute_names.include?(:attr)
#
# source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#35
class RuboCop::Cop::Rails::DeprecatedActiveModelErrorsMethods < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#55
  def any_manipulation?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#81
  def errors_deprecated?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#99
  def messages_details_assignment?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#87
  def messages_details_manipulation?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#108
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#53
  def receiver_matcher_inside_model(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#52
  def receiver_matcher_outside_model(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#74
  def root_assignment?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#65
  def root_manipulation?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#129
  def autocorrect(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#162
  def model_file?; end

  # source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#138
  def offense_range(node, receiver); end

  # source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#158
  def receiver_matcher(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#143
  def replacement(node, receiver); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#122
  def skip_autocorrect?(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#40
RuboCop::Cop::Rails::DeprecatedActiveModelErrorsMethods::AUTOCORRECTABLE_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#41
RuboCop::Cop::Rails::DeprecatedActiveModelErrorsMethods::INCOMPATIBLE_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#43
RuboCop::Cop::Rails::DeprecatedActiveModelErrorsMethods::MANIPULATIVE_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-rails//lib/rubocop/cop/rails/deprecated_active_model_errors_methods.rb#39
RuboCop::Cop::Rails::DeprecatedActiveModelErrorsMethods::MSG = T.let(T.unsafe(nil), String)

# Enforces the use of dot-separated locale keys instead of specifying the `:scope` option
# with an array or a single symbol in `I18n` translation methods.
# Dot-separated notation is easier to read and trace the hierarchy.
#
# @example
#   # bad
#   I18n.t :record_invalid, scope: [:activerecord, :errors, :messages]
#   I18n.t :title, scope: :invitation
#
#   # good
#   I18n.t 'activerecord.errors.messages.record_invalid'
#   I18n.t :record_invalid, scope: 'activerecord.errors.messages'
#
# source://rubocop-rails//lib/rubocop/cop/rails/dot_separated_keys.rb#19
class RuboCop::Cop::Rails::DotSeparatedKeys < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/dot_separated_keys.rb#32
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/dot_separated_keys.rb#26
  def translate_with_scope?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/dot_separated_keys.rb#55
  def new_key(key_node, scope_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/dot_separated_keys.rb#59
  def scopes(scope_node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/dot_separated_keys.rb#51
  def should_convert_scope?(scope_node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/dot_separated_keys.rb#23
RuboCop::Cop::Rails::DotSeparatedKeys::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/dot_separated_keys.rb#24
RuboCop::Cop::Rails::DotSeparatedKeys::TRANSLATE_METHODS = T.let(T.unsafe(nil), Array)

# Looks for associations that have been defined multiple times in the same file.
#
# When an association is defined multiple times on a model, Active Record overrides the
# previously defined association with the new one. Because of this, this cop's autocorrection
# simply keeps the last of any duplicates and discards the rest.
#
# @example
#
#   # bad
#   belongs_to :foo
#   belongs_to :bar
#   has_one :foo
#
#   # good
#   belongs_to :bar
#   has_one :foo
#
#   # bad
#   has_many :foo, class_name: 'Foo'
#   has_many :bar, class_name: 'Foo'
#   has_one :baz
#
#   # good
#   has_many :bar, class_name: 'Foo'
#   has_one :foo
#
# source://rubocop-rails//lib/rubocop/cop/rails/duplicate_association.rb#32
class RuboCop::Cop::Rails::DuplicateAssociation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ClassSendNodeHelper
  include ::RuboCop::Cop::ActiveRecordHelper
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/duplicate_association.rb#41
  def association(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/duplicate_association.rb#45
  def class_name(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/duplicate_association.rb#49
  def on_class(class_node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/duplicate_association.rb#75
  def association_nodes(class_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/duplicate_association.rb#81
  def duplicated_association_name_nodes(association_nodes); end

  # source://rubocop-rails//lib/rubocop/cop/rails/duplicate_association.rb#89
  def duplicated_class_name_nodes(association_nodes); end

  # source://rubocop-rails//lib/rubocop/cop/rails/duplicate_association.rb#105
  def leave_duplicated_association(grouped_associations); end

  # source://rubocop-rails//lib/rubocop/cop/rails/duplicate_association.rb#65
  def register_offense(name, nodes, message_template); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/duplicate_association.rb#38
RuboCop::Cop::Rails::DuplicateAssociation::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/duplicate_association.rb#39
RuboCop::Cop::Rails::DuplicateAssociation::MSG_CLASS_NAME = T.let(T.unsafe(nil), String)

# Checks for multiple scopes in a model that have the same `where` clause. This
# often means you copy/pasted a scope, updated the name, and forgot to change the condition.
#
# @example
#
#   # bad
#   scope :visible, -> { where(visible: true) }
#   scope :hidden, -> { where(visible: true) }
#
#   # good
#   scope :visible, -> { where(visible: true) }
#   scope :hidden, -> { where(visible: false) }
#
# source://rubocop-rails//lib/rubocop/cop/rails/duplicate_scope.rb#19
class RuboCop::Cop::Rails::DuplicateScope < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ClassSendNodeHelper

  # source://rubocop-rails//lib/rubocop/cop/rails/duplicate_scope.rb#28
  def on_class(class_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/duplicate_scope.rb#24
  def scope(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/duplicate_scope.rb#36
  def offenses(class_node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/duplicate_scope.rb#22
RuboCop::Cop::Rails::DuplicateScope::MSG = T.let(T.unsafe(nil), String)

# Checks if a duration is added to or subtracted from `Time.current`.
#
# @example
#   # bad
#   Time.current - 1.minute
#   Time.current + 2.days
#
#   # good - using relative would make it harder to express and read
#   Date.yesterday + 3.days
#   created_at - 1.minute
#   3.days - 1.hour
#
#   # good
#   1.minute.ago
#   2.days.from_now
#
# source://rubocop-rails//lib/rubocop/cop/rails/duration_arithmetic.rb#21
class RuboCop::Cop::Rails::DurationArithmetic < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # Match a literal Duration
  #
  # @example source that matches
  #   1.hour
  # @example source that matches
  #   9.5.weeks
  # @param node [RuboCop::AST::Node]
  # @return [Boolean] true if matches
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/duration_arithmetic.rb#58
  def duration?(param0 = T.unsafe(nil)); end

  # Match duration subtraction or addition with current time.
  #
  # @example source that matches
  #   Time.current - 1.hour
  # @example source that matches
  #   ::Time.zone.now + 1.hour
  # @param node [RuboCop::AST::Node]
  # @yield operator and duration
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/duration_arithmetic.rb#43
  def duration_arithmetic_argument?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/duration_arithmetic.rb#78
  def on_send(node); end

  # Match Time.current
  #
  # @example source that matches
  #   Time.current
  # @example source that matches
  #   ::Time.zone.now
  # @param node [RuboCop::AST::Node]
  # @return [Boolean] true if matches
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/duration_arithmetic.rb#71
  def time_current?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/duration_arithmetic.rb#88
  def corrected_source(operator, duration); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/duration_arithmetic.rb#28
RuboCop::Cop::Rails::DurationArithmetic::DURATIONS = T.let(T.unsafe(nil), Set)

# source://rubocop-rails//lib/rubocop/cop/rails/duration_arithmetic.rb#24
RuboCop::Cop::Rails::DurationArithmetic::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/duration_arithmetic.rb#26
RuboCop::Cop::Rails::DurationArithmetic::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks dynamic `find_by_*` methods.
# Use `find_by` instead of dynamic method.
# See. https://rails.rubystyle.guide#find_by
#
# @example
#   # bad
#   User.find_by_name(name)
#   User.find_by_name_and_email(name)
#   User.find_by_email!(name)
#
#   # good
#   User.find_by(name: name)
#   User.find_by(name: name, email: email)
#   User.find_by!(email: email)
# @example AllowedMethods: ['find_by_sql', 'find_by_token_for'] (default)
#   # bad
#   User.find_by_query(users_query)
#   User.find_by_token_for(:password_reset, token)
#
#   # good
#   User.find_by_sql(users_sql)
#   User.find_by_token_for(:password_reset, token)
# @example AllowedReceivers: ['Gem::Specification', 'page'] (default)
#   # bad
#   Specification.find_by_name('backend').gem_dir
#   page.find_by_id('a_dom_id').click
#
#   # good
#   Gem::Specification.find_by_name('backend').gem_dir
#   page.find_by_id('a_dom_id').click
#
# source://rubocop-rails//lib/rubocop/cop/rails/dynamic_find_by.rb#42
class RuboCop::Cop::Rails::DynamicFindBy < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ActiveRecordHelper
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/dynamic_find_by.rb#50
  def on_csend(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/dynamic_find_by.rb#50
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/dynamic_find_by.rb#72
  def allowed_invocation?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/dynamic_find_by.rb#76
  def allowed_method?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/dynamic_find_by.rb#82
  def allowed_receiver?(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/dynamic_find_by.rb#67
  def autocorrect(corrector, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/dynamic_find_by.rb#100
  def autocorrect_argument_keywords(corrector, node, keywords); end

  # source://rubocop-rails//lib/rubocop/cop/rails/dynamic_find_by.rb#96
  def autocorrect_method_name(corrector, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/dynamic_find_by.rb#106
  def column_keywords(method); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/dynamic_find_by.rb#120
  def dynamic_find_by_arguments?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/dynamic_find_by.rb#124
  def dynamic_find_by_arguments_count?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/dynamic_find_by.rb#128
  def dynamic_find_by_arguments_type?(node); end

  # Returns static method name.
  # If code isn't wrong, returns nil
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/dynamic_find_by.rb#113
  def static_method_name(method_name); end

  # config option `WhiteList` will be deprecated soon
  #
  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/dynamic_find_by.rb#89
  def whitelisted?(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/dynamic_find_by.rb#48
RuboCop::Cop::Rails::DynamicFindBy::IGNORED_ARGUMENT_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/dynamic_find_by.rb#47
RuboCop::Cop::Rails::DynamicFindBy::METHOD_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://rubocop-rails//lib/rubocop/cop/rails/dynamic_find_by.rb#46
RuboCop::Cop::Rails::DynamicFindBy::MSG = T.let(T.unsafe(nil), String)

# Checks that blocks are used for interpolated strings passed to
# `Rails.logger.debug`.
#
# By default, Rails production environments use the `:info` log level.
# At the `:info` log level, `Rails.logger.debug` statements do not result
# in log output. However, Ruby must eagerly evaluate interpolated string
# arguments passed as method arguments. Passing a block to
# `Rails.logger.debug` prevents costly evaluation of interpolated strings
# when no output would be produced anyway.
#
# @example
#   # bad
#   Rails.logger.debug "The time is #{Time.zone.now}."
#
#   # good
#   Rails.logger.debug { "The time is #{Time.zone.now}." }
#
# source://rubocop-rails//lib/rubocop/cop/rails/eager_evaluation_log_message.rb#23
class RuboCop::Cop::Rails::EagerEvaluationLogMessage < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/eager_evaluation_log_message.rb#29
  def interpolated_string_passed_to_debug(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/eager_evaluation_log_message.rb#44
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/eager_evaluation_log_message.rb#61
  def replacement_range(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/eager_evaluation_log_message.rb#72
  def replacement_source(node, arguments); end

  class << self
    # source://rubocop-rails//lib/rubocop/cop/rails/eager_evaluation_log_message.rb#40
    def autocorrect_incompatible_with; end
  end
end

# source://rubocop-rails//lib/rubocop/cop/rails/eager_evaluation_log_message.rb#26
RuboCop::Cop::Rails::EagerEvaluationLogMessage::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/eager_evaluation_log_message.rb#27
RuboCop::Cop::Rails::EagerEvaluationLogMessage::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Looks for enums written with array syntax.
#
# When using array syntax, adding an element in a
# position other than the last causes all previous
# definitions to shift. Explicitly specifying the
# value for each key prevents this from happening.
#
# @example
#   # bad
#   enum status: [:active, :archived]
#
#   # good
#   enum status: { active: 0, archived: 1 }
#
# source://rubocop-rails//lib/rubocop/cop/rails/enum_hash.rb#20
class RuboCop::Cop::Rails::EnumHash < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/enum_hash.rb#30
  def array_pair?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/enum_hash.rb#26
  def enum?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/enum_hash.rb#34
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/enum_hash.rb#53
  def enum_name(key); end

  # source://rubocop-rails//lib/rubocop/cop/rails/enum_hash.rb#62
  def source(elem); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/enum_hash.rb#23
RuboCop::Cop::Rails::EnumHash::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/enum_hash.rb#24
RuboCop::Cop::Rails::EnumHash::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Looks for duplicate values in enum declarations.
#
# @example
#   # bad
#   enum status: { active: 0, archived: 0 }
#
#   # good
#   enum status: { active: 0, archived: 1 }
#
#   # bad
#   enum status: [:active, :archived, :active]
#
#   # good
#   enum status: [:active, :archived]
#
# source://rubocop-rails//lib/rubocop/cop/rails/enum_uniqueness.rb#20
class RuboCop::Cop::Rails::EnumUniqueness < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Duplication

  # source://rubocop-rails//lib/rubocop/cop/rails/enum_uniqueness.rb#26
  def enum?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/enum_uniqueness.rb#30
  def enum_values(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/enum_uniqueness.rb#34
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/enum_uniqueness.rb#52
  def enum_name(key); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/enum_uniqueness.rb#23
RuboCop::Cop::Rails::EnumUniqueness::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/enum_uniqueness.rb#24
RuboCop::Cop::Rails::EnumUniqueness::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for usage of `Rails.env.development? || Rails.env.test?` which
# can be replaced with `Rails.env.local?`, introduced in Rails 7.1.
#
# @example
#
#   # bad
#   Rails.env.development? || Rails.env.test?
#
#   # good
#   Rails.env.local?
#
# source://rubocop-rails//lib/rubocop/cop/rails/env_local.rb#17
class RuboCop::Cop::Rails::EnvLocal < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/env_local.rb#34
  def on_or(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/env_local.rb#27
  def rails_env_local_candidate?(param0 = T.unsafe(nil)); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/env_local.rb#22
RuboCop::Cop::Rails::EnvLocal::LOCAL_ENVIRONMENTS = T.let(T.unsafe(nil), Set)

# source://rubocop-rails//lib/rubocop/cop/rails/env_local.rb#21
RuboCop::Cop::Rails::EnvLocal::MSG = T.let(T.unsafe(nil), String)

# Checks that Rails.env is compared using `.production?`-like
# methods instead of equality against a string or symbol.
#
# @example
#   # bad
#   Rails.env == 'production'
#
#   # bad, always returns false
#   Rails.env == :test
#
#   # good
#   Rails.env.production?
#
# source://rubocop-rails//lib/rubocop/cop/rails/environment_comparison.rb#18
class RuboCop::Cop::Rails::EnvironmentComparison < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/environment_comparison.rb#27
  def comparing_str_env_with_rails_env_on_lhs?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/environment_comparison.rb#35
  def comparing_str_env_with_rails_env_on_rhs?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/environment_comparison.rb#43
  def comparing_sym_env_with_rails_env_on_lhs?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/environment_comparison.rb#51
  def comparing_sym_env_with_rails_env_on_rhs?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/environment_comparison.rb#59
  def content(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/environment_comparison.rb#63
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/environment_comparison.rb#84
  def autocorrect(corrector, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/environment_comparison.rb#90
  def build_predicate_method(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/environment_comparison.rb#102
  def build_predicate_method_for_rails_env_on_lhs(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/environment_comparison.rb#108
  def build_predicate_method_for_rails_env_on_rhs(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/environment_comparison.rb#98
  def rails_env_on_lhs?(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/environment_comparison.rb#21
RuboCop::Cop::Rails::EnvironmentComparison::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/environment_comparison.rb#25
RuboCop::Cop::Rails::EnvironmentComparison::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/environment_comparison.rb#23
RuboCop::Cop::Rails::EnvironmentComparison::SYM_MSG = T.let(T.unsafe(nil), String)

# Looks for direct access to environment variables through the
# `ENV` variable within the application code. This can lead to runtime
# errors due to misconfiguration that could have been discovered at boot
# time if the environment variables were loaded as part of initialization
# and copied into the application's configuration or secrets. The cop can
# be configured to allow either reads or writes if required.
#
# @example
#   # good
#   Rails.application.config.foo
#   Rails.application.config.x.foo.bar
#   Rails.application.secrets.foo
#   Rails.application.config.foo = "bar"
# @example AllowReads: false (default)
#   # bad
#   ENV["FOO"]
#   ENV.fetch("FOO")
# @example AllowReads: true
#   # good
#   ENV["FOO"]
#   ENV.fetch("FOO")
# @example AllowWrites: false (default)
#   # bad
#   ENV["FOO"] = "bar"
# @example AllowWrites: true
#   # good
#   ENV["FOO"] = "bar"
#
# source://rubocop-rails//lib/rubocop/cop/rails/environment_variable_access.rb#37
class RuboCop::Cop::Rails::EnvironmentVariableAccess < ::RuboCop::Cop::Base
  # source://rubocop-rails//lib/rubocop/cop/rails/environment_variable_access.rb#46
  def env_read?(param0); end

  # source://rubocop-rails//lib/rubocop/cop/rails/environment_variable_access.rb#50
  def env_write?(param0); end

  # source://rubocop-rails//lib/rubocop/cop/rails/environment_variable_access.rb#41
  def on_const(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/environment_variable_access.rb#57
  def allow_reads?; end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/environment_variable_access.rb#61
  def allow_writes?; end
end

# source://rubocop-rails//lib/rubocop/cop/rails/environment_variable_access.rb#38
RuboCop::Cop::Rails::EnvironmentVariableAccess::READ_MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/environment_variable_access.rb#39
RuboCop::Cop::Rails::EnvironmentVariableAccess::WRITE_MSG = T.let(T.unsafe(nil), String)

# Enforces that `exit` calls are not used within a rails app.
# Valid options are instead to raise an error, break, return, or some
# other form of stopping execution of current request.
#
# There are two obvious cases where `exit` is particularly harmful:
#
# * Usage in library code for your application. Even though Rails will
# rescue from a `SystemExit` and continue on, unit testing that library
# code will result in specs exiting (potentially silently if `exit(0)`
# is used.)
# * Usage in application code outside of the web process could result in
# the program exiting, which could result in the code failing to run and
# do its job.
#
# @example
#   # bad
#   exit(0)
#
#   # good
#   raise 'a bad error has happened'
#
# source://rubocop-rails//lib/rubocop/cop/rails/exit.rb#26
class RuboCop::Cop::Rails::Exit < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle

  # source://rubocop-rails//lib/rubocop/cop/rails/exit.rb#33
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/exit.rb#39
  def offending_node?(node); end

  # More than 1 argument likely means it is a different
  # `exit` implementation than the one we are preventing.
  #
  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/exit.rb#45
  def right_argument_count?(arg_nodes); end

  # Only register if exit is being called explicitly on `Kernel`,
  # `Process`, or if receiver node is nil for plain `exit` calls.
  #
  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/exit.rb#51
  def right_receiver?(receiver_node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/exit.rb#31
RuboCop::Cop::Rails::Exit::EXPLICIT_RECEIVERS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/exit.rb#29
RuboCop::Cop::Rails::Exit::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/exit.rb#30
RuboCop::Cop::Rails::Exit::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for expanded date range. It only compatible `..` range is targeted.
# Incompatible `...` range is ignored.
#
# @example
#   # bad
#   date.beginning_of_day..date.end_of_day
#   date.beginning_of_week..date.end_of_week
#   date.beginning_of_month..date.end_of_month
#   date.beginning_of_quarter..date.end_of_quarter
#   date.beginning_of_year..date.end_of_year
#
#   # good
#   date.all_day
#   date.all_week
#   date.all_month
#   date.all_quarter
#   date.all_year
#
# source://rubocop-rails//lib/rubocop/cop/rails/expanded_date_range.rb#24
class RuboCop::Cop::Rails::ExpandedDateRange < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/expanded_date_range.rb#48
  def on_irange(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/expanded_date_range.rb#67
  def allow?(begin_node, end_node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/expanded_date_range.rb#88
  def any_arguments?(begin_node, end_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/expanded_date_range.rb#84
  def preferred_method(begin_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/expanded_date_range.rb#74
  def receiver_source(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/expanded_date_range.rb#92
  def register_offense(node, preferred_method); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/expanded_date_range.rb#80
  def same_argument?(begin_node, end_node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/expanded_date_range.rb#40
RuboCop::Cop::Rails::ExpandedDateRange::MAPPED_DATE_RANGE_METHODS = T.let(T.unsafe(nil), Hash)

# source://rubocop-rails//lib/rubocop/cop/rails/expanded_date_range.rb#28
RuboCop::Cop::Rails::ExpandedDateRange::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/expanded_date_range.rb#32
RuboCop::Cop::Rails::ExpandedDateRange::PREFERRED_METHODS = T.let(T.unsafe(nil), Hash)

# Identifies usages of file path joining process to use `Rails.root.join` clause.
# It is used to add uniformity when joining paths.
#
# @example EnforcedStyle: slashes (default)
#   # bad
#   Rails.root.join('app', 'models', 'goober')
#
#   # good
#   Rails.root.join('app/models/goober')
#
#   # bad
#   File.join(Rails.root, 'app/models/goober')
#   "#{Rails.root}/app/models/goober"
#
#   # good
#   Rails.root.join('app/models/goober').to_s
# @example EnforcedStyle: arguments
#   # bad
#   Rails.root.join('app/models/goober')
#
#   # good
#   Rails.root.join('app', 'models', 'goober')
#
#   # bad
#   File.join(Rails.root, 'app/models/goober')
#   "#{Rails.root}/app/models/goober"
#
#   # good
#   Rails.root.join('app', 'models', 'goober').to_s
#
# source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#37
class RuboCop::Cop::Rails::FilePath < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#47
  def file_join_nodes?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#59
  def on_dstr(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#67
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#55
  def rails_root_join_nodes?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#51
  def rails_root_nodes?(param0); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#223
  def append_argument(corrector, node, argument_source); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#164
  def autocorrect_extension_after_rails_root_join_in_dstr(corrector, node, rails_root_index, extension_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#172
  def autocorrect_file_join(corrector, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#204
  def autocorrect_rails_root_join_with_slash_separated_path(corrector, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#189
  def autocorrect_rails_root_join_with_string_arguments(corrector, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#153
  def autocorrect_slash_after_rails_root_in_dstr(corrector, node, rails_root_index); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#140
  def build_message(require_to_s); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#85
  def check_for_extension_after_rails_root_join_in_dstr(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#95
  def check_for_file_join_with_rails_root(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#116
  def check_for_rails_root_join_with_slash_separated_path(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#104
  def check_for_rails_root_join_with_string_arguments(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#75
  def check_for_slash_after_rails_root_in_dstr(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#147
  def dstr_separated_by_colon?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#235
  def extension_node?(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#231
  def extract_rails_root_join_argument_source(node, rails_root_index); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#219
  def find_rails_root_index(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#215
  def inner_range_of(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#131
  def register_offense(node, require_to_s:, &block); end

  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#227
  def replace_with_rails_root_join(corrector, node, argument_source); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#127
  def string_with_slash?(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#44
RuboCop::Cop::Rails::FilePath::MSG_ARGUMENTS = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#43
RuboCop::Cop::Rails::FilePath::MSG_SLASHES = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/file_path.rb#45
RuboCop::Cop::Rails::FilePath::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies usages of `where.take` and change them to use `find_by` instead.
#
# And `where(...).first` can return different results from `find_by`.
# (They order records differently, so the "first" record can be different.)
#
# If you also want to detect `where.first`, you can set `IgnoreWhereFirst` to false.
#
# @example
#   # bad
#   User.where(name: 'Bruce').take
#
#   # good
#   User.find_by(name: 'Bruce')
# @example IgnoreWhereFirst: true (default)
#   # good
#   User.where(name: 'Bruce').first
# @example IgnoreWhereFirst: false
#   # bad
#   User.where(name: 'Bruce').first
#
# source://rubocop-rails//lib/rubocop/cop/rails/find_by.rb#27
class RuboCop::Cop::Rails::FindBy < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/find_by.rb#34
  def on_csend(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/find_by.rb#34
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/find_by.rb#58
  def autocorrect(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/find_by.rb#68
  def ignore_where_first?; end

  # source://rubocop-rails//lib/rubocop/cop/rails/find_by.rb#54
  def offense_range(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/find_by.rb#48
  def where_method?(receiver); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/find_by.rb#31
RuboCop::Cop::Rails::FindBy::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/find_by.rb#32
RuboCop::Cop::Rails::FindBy::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces that `ActiveRecord#find` is used instead of
# `where.take!`, `find_by!`, and `find_by_id!` to retrieve a single record
# by primary key when you expect it to be found.
#
# @example
#   # bad
#   User.where(id: id).take!
#   User.find_by_id!(id)
#   User.find_by!(id: id)
#
#   # good
#   User.find(id)
#
# source://rubocop-rails//lib/rubocop/cop/rails/find_by_id.rb#19
class RuboCop::Cop::Rails::FindById < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/find_by_id.rb#33
  def find_by?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/find_by_id.rb#40
  def on_csend(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/find_by_id.rb#40
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/find_by_id.rb#26
  def where_take?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/find_by_id.rb#74
  def build_good_method(id_value); end

  # source://rubocop-rails//lib/rubocop/cop/rails/find_by_id.rb#70
  def find_by_offense_range(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/find_by_id.rb#57
  def register_offense(range, id_value); end

  # source://rubocop-rails//lib/rubocop/cop/rails/find_by_id.rb#66
  def where_take_offense_range(node, where); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/find_by_id.rb#23
RuboCop::Cop::Rails::FindById::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/find_by_id.rb#24
RuboCop::Cop::Rails::FindById::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies usages of `all.each` and change them to use `all.find_each` instead.
#
# @example
#   # bad
#   User.all.each
#
#   # good
#   User.all.find_each
# @example AllowedMethods: ['order']
#   # good
#   User.order(:foo).each
# @example AllowedPattern: ['order']
#   # good
#   User.order(:foo).each
#
# source://rubocop-rails//lib/rubocop/cop/rails/find_each.rb#27
class RuboCop::Cop::Rails::FindEach < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ActiveRecordHelper
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/find_each.rb#41
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/find_each.rb#67
  def active_model_error?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/find_each.rb#63
  def active_model_error_where?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/find_each.rb#55
  def ignored?(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/find_each.rb#33
RuboCop::Cop::Rails::FindEach::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/find_each.rb#34
RuboCop::Cop::Rails::FindEach::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/find_each.rb#36
RuboCop::Cop::Rails::FindEach::SCOPE_METHODS = T.let(T.unsafe(nil), Array)

# Identifies usages of `travel_to` with an argument of the current time and
# change them to use `freeze_time` instead.
#
# @example
#   # bad
#   travel_to(Time.now)
#   travel_to(Time.new)
#   travel_to(DateTime.now)
#   travel_to(Time.current)
#   travel_to(Time.zone.now)
#   travel_to(Time.now.in_time_zone)
#   travel_to(Time.current.to_time)
#
#   # good
#   freeze_time
#
# source://rubocop-rails//lib/rubocop/cop/rails/freeze_time.rb#27
class RuboCop::Cop::Rails::FreezeTime < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/freeze_time.rb#48
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/freeze_time.rb#39
  def time_now?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/freeze_time.rb#44
  def zoned_time_now?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/freeze_time.rb#62
  def current_time?(node, method_name); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/freeze_time.rb#68
  def current_time_with_convert?(node, method_name); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/freeze_time.rb#35
RuboCop::Cop::Rails::FreezeTime::CONVERT_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/freeze_time.rb#33
RuboCop::Cop::Rails::FreezeTime::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/freeze_time.rb#34
RuboCop::Cop::Rails::FreezeTime::NOW_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/freeze_time.rb#36
RuboCop::Cop::Rails::FreezeTime::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the use of the has_and_belongs_to_many macro.
#
# @example
#   # bad
#   # has_and_belongs_to_many :ingredients
#
#   # good
#   # has_many :ingredients, through: :recipe_ingredients
#
# source://rubocop-rails//lib/rubocop/cop/rails/has_and_belongs_to_many.rb#14
class RuboCop::Cop::Rails::HasAndBelongsToMany < ::RuboCop::Cop::Base
  # source://rubocop-rails//lib/rubocop/cop/rails/has_and_belongs_to_many.rb#18
  def on_send(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/has_and_belongs_to_many.rb#15
RuboCop::Cop::Rails::HasAndBelongsToMany::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/has_and_belongs_to_many.rb#16
RuboCop::Cop::Rails::HasAndBelongsToMany::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Looks for `has_many` or `has_one` associations that don't
# specify a `:dependent` option.
#
# It doesn't register an offense if `:through` or `dependent: nil`
# is specified, or if the model is read-only.
#
# @example
#   # bad
#   class User < ActiveRecord::Base
#   has_many :comments
#   has_one :avatar
#   end
#
#   # good
#   class User < ActiveRecord::Base
#   has_many :comments, dependent: :restrict_with_exception
#   has_one :avatar, dependent: :destroy
#   has_many :articles, dependent: nil
#   has_many :patients, through: :appointments
#   end
#
#   class User < ActiveRecord::Base
#   has_many :comments
#   has_one :avatar
#
#   def readonly?
#   true
#   end
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/has_many_or_has_one_dependent.rb#35
class RuboCop::Cop::Rails::HasManyOrHasOneDependent < ::RuboCop::Cop::Base
  # source://rubocop-rails//lib/rubocop/cop/rails/has_many_or_has_one_dependent.rb#39
  def active_resource_class?(param0); end

  # source://rubocop-rails//lib/rubocop/cop/rails/has_many_or_has_one_dependent.rb#66
  def association_extension_block?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/has_many_or_has_one_dependent.rb#47
  def association_with_options?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/has_many_or_has_one_dependent.rb#43
  def association_without_options?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/has_many_or_has_one_dependent.rb#51
  def dependent_option?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/has_many_or_has_one_dependent.rb#78
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/has_many_or_has_one_dependent.rb#55
  def present_option?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/has_many_or_has_one_dependent.rb#72
  def readonly?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/has_many_or_has_one_dependent.rb#59
  def with_options_block(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/has_many_or_has_one_dependent.rb#135
  def active_resource?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/has_many_or_has_one_dependent.rb#102
  def contain_valid_options_in_with_options_block?(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/has_many_or_has_one_dependent.rb#127
  def extract_option_if_kwsplat(options); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/has_many_or_has_one_dependent.rb#88
  def readonly_model?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/has_many_or_has_one_dependent.rb#114
  def valid_options?(options); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/has_many_or_has_one_dependent.rb#94
  def valid_options_in_with_options_block?(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/has_many_or_has_one_dependent.rb#36
RuboCop::Cop::Rails::HasManyOrHasOneDependent::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/has_many_or_has_one_dependent.rb#37
RuboCop::Cop::Rails::HasManyOrHasOneDependent::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for use of the helper methods which reference
# instance variables.
#
# Relying on instance variables makes it difficult to reuse helper
# methods.
#
# If it seems awkward to explicitly pass in each dependent
# variable, consider moving the behavior elsewhere, for
# example to a model, decorator or presenter.
#
# Provided that a class inherits `ActionView::Helpers::FormBuilder`,
# an offense will not be registered.
#
# @example
#   # bad
#   def welcome_message
#   "Hello #{@user.name}"
#   end
#
#   # good
#   def welcome_message(user)
#   "Hello #{user.name}"
#   end
#
#   # good
#   class MyFormBuilder < ActionView::Helpers::FormBuilder
#   @template.do_something
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/helper_instance_variable.rb#34
class RuboCop::Cop::Rails::HelperInstanceVariable < ::RuboCop::Cop::Base
  # source://rubocop-rails//lib/rubocop/cop/rails/helper_instance_variable.rb#37
  def form_builder_class?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/helper_instance_variable.rb#43
  def on_ivar(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/helper_instance_variable.rb#49
  def on_ivasgn(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/helper_instance_variable.rb#57
  def inherit_form_builder?(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/helper_instance_variable.rb#35
RuboCop::Cop::Rails::HelperInstanceVariable::MSG = T.let(T.unsafe(nil), String)

# Identifies usages of http methods like `get`, `post`,
# `put`, `patch` without the usage of keyword arguments in your tests and
# change them to use keyword args. This cop only applies to Rails >= 5.
# If you are running Rails < 5 you should disable the
# Rails/HttpPositionalArguments cop or set your TargetRailsVersion in your
# .rubocop.yml file to 4.2.
#
# NOTE: It does not detect any cases where `include Rack::Test::Methods` is used
# which makes the http methods incompatible behavior.
#
# @example
#   # bad
#   get :new, { user_id: 1}
#
#   # good
#   get :new, params: { user_id: 1 }
#   get :new, **options
#
# source://rubocop-rails//lib/rubocop/cop/rails/http_positional_arguments.rb#23
class RuboCop::Cop::Rails::HttpPositionalArguments < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/http_positional_arguments.rb#35
  def http_request?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/http_positional_arguments.rb#43
  def include_rack_test_methods?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/http_positional_arguments.rb#39
  def kwsplat_hash?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/http_positional_arguments.rb#50
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/http_positional_arguments.rb#109
  def convert_hash_data(data, type); end

  # source://rubocop-rails//lib/rubocop/cop/rails/http_positional_arguments.rb#123
  def correction(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/http_positional_arguments.rb#136
  def correction_template(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/http_positional_arguments.rb#99
  def format_arg?(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/http_positional_arguments.rb#103
  def highlight_range(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/http_positional_arguments.rb#76
  def in_routing_block?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/http_positional_arguments.rb#86
  def needs_conversion?(data); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/http_positional_arguments.rb#95
  def special_keyword_arg?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/http_positional_arguments.rb#80
  def use_rack_test_methods?; end
end

# source://rubocop-rails//lib/rubocop/cop/rails/http_positional_arguments.rb#29
RuboCop::Cop::Rails::HttpPositionalArguments::KEYWORD_ARGS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/http_positional_arguments.rb#28
RuboCop::Cop::Rails::HttpPositionalArguments::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/http_positional_arguments.rb#31
RuboCop::Cop::Rails::HttpPositionalArguments::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/http_positional_arguments.rb#30
RuboCop::Cop::Rails::HttpPositionalArguments::ROUTING_METHODS = T.let(T.unsafe(nil), Array)

# Enforces use of symbolic or numeric value to define HTTP status.
#
# @example EnforcedStyle: symbolic (default)
#   # bad
#   render :foo, status: 200
#   render :foo, status: '200'
#   render json: { foo: 'bar' }, status: 200
#   render plain: 'foo/bar', status: 304
#   redirect_to root_url, status: 301
#   head 200
#
#   # good
#   render :foo, status: :ok
#   render json: { foo: 'bar' }, status: :ok
#   render plain: 'foo/bar', status: :not_modified
#   redirect_to root_url, status: :moved_permanently
#   head :ok
# @example EnforcedStyle: numeric
#   # bad
#   render :foo, status: :ok
#   render json: { foo: 'bar' }, status: :not_found
#   render plain: 'foo/bar', status: :not_modified
#   redirect_to root_url, status: :moved_permanently
#   head :ok
#
#   # good
#   render :foo, status: 200
#   render json: { foo: 'bar' }, status: 404
#   render plain: 'foo/bar', status: 304
#   redirect_to root_url, status: 301
#   head 200
#
# source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#39
class RuboCop::Cop::Rails::HttpStatus < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#45
  def http_status(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#57
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#53
  def status_code(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#77
  def checker_class; end
end

# source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#125
class RuboCop::Cop::Rails::HttpStatus::NumericStyleChecker
  # @return [NumericStyleChecker] a new instance of NumericStyleChecker
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#132
  def initialize(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#140
  def message; end

  # Returns the value of attribute node.
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#130
  def node; end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#136
  def offensive?; end

  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#144
  def preferred_style; end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#150
  def number; end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#158
  def permitted_symbol?; end

  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#154
  def symbol; end
end

# source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#127
RuboCop::Cop::Rails::HttpStatus::NumericStyleChecker::DEFAULT_MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#126
RuboCop::Cop::Rails::HttpStatus::NumericStyleChecker::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#128
RuboCop::Cop::Rails::HttpStatus::NumericStyleChecker::PERMITTED_STATUS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#43
RuboCop::Cop::Rails::HttpStatus::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#87
class RuboCop::Cop::Rails::HttpStatus::SymbolicStyleChecker
  # @return [SymbolicStyleChecker] a new instance of SymbolicStyleChecker
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#93
  def initialize(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#101
  def message; end

  # Returns the value of attribute node.
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#91
  def node; end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#97
  def offensive?; end

  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#105
  def preferred_style; end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#119
  def custom_http_status_code?; end

  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#115
  def number; end

  # source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#111
  def symbol; end
end

# source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#89
RuboCop::Cop::Rails::HttpStatus::SymbolicStyleChecker::DEFAULT_MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/http_status.rb#88
RuboCop::Cop::Rails::HttpStatus::SymbolicStyleChecker::MSG = T.let(T.unsafe(nil), String)

# Checks for places where I18n "lazy" lookup can be used.
#
# This cop has two different enforcement modes. When the EnforcedStyle
# is `lazy` (the default), explicit lookups are added as offenses.
#
# When the EnforcedStyle is `explicit` then lazy lookups are added as
# offenses.
#
# @example EnforcedStyle: lazy (default)
#   # en.yml
#   # en:
#   #   books:
#   #     create:
#   #       success: Book created!
#
#   # bad
#   class BooksController < ApplicationController
#   def create
#   # ...
#   redirect_to books_url, notice: t('books.create.success')
#   end
#   end
#
#   # good
#   class BooksController < ApplicationController
#   def create
#   # ...
#   redirect_to books_url, notice: t('.success')
#   end
#   end
# @example EnforcedStyle: explicit
#   # bad
#   class BooksController < ApplicationController
#   def create
#   # ...
#   redirect_to books_url, notice: t('.success')
#   end
#   end
#
#   # good
#   class BooksController < ApplicationController
#   def create
#   # ...
#   redirect_to books_url, notice: t('books.create.success')
#   end
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/i18n_lazy_lookup.rb#54
class RuboCop::Cop::Rails::I18nLazyLookup < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::VisibilityHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/i18n_lazy_lookup.rb#67
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/i18n_lazy_lookup.rb#63
  def translate_call?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/i18n_lazy_lookup.rb#109
  def controller_and_action(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/i18n_lazy_lookup.rb#127
  def controller_path(controller); end

  # source://rubocop-rails//lib/rubocop/cop/rails/i18n_lazy_lookup.rb#119
  def get_scoped_key(key_node, controller, action); end

  # source://rubocop-rails//lib/rubocop/cop/rails/i18n_lazy_lookup.rb#96
  def handle_explicit_style(node, key_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/i18n_lazy_lookup.rb#80
  def handle_lazy_style(node, key_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/i18n_lazy_lookup.rb#140
  def message(_range); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/i18n_lazy_lookup.rb#59
RuboCop::Cop::Rails::I18nLazyLookup::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/i18n_lazy_lookup.rb#61
RuboCop::Cop::Rails::I18nLazyLookup::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the use of `I18n.locale=` method.
#
# The `locale` attribute persists for the rest of the Ruby runtime, potentially causing
# unexpected behavior at a later time.
# Using `I18n.with_locale` ensures the code passed in the block is the only place `I18n.locale` is affected.
# It eliminates the possibility of a `locale` sticking around longer than intended.
#
# @example
#   # bad
#   I18n.locale = :fr
#
#   # good
#   I18n.with_locale(:fr) do
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/i18n_locale_assignment.rb#21
class RuboCop::Cop::Rails::I18nLocaleAssignment < ::RuboCop::Cop::Base
  # source://rubocop-rails//lib/rubocop/cop/rails/i18n_locale_assignment.rb#25
  def i18n_locale_assignment?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/i18n_locale_assignment.rb#29
  def on_send(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/i18n_locale_assignment.rb#22
RuboCop::Cop::Rails::I18nLocaleAssignment::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/i18n_locale_assignment.rb#23
RuboCop::Cop::Rails::I18nLocaleAssignment::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces use of I18n and locale files instead of locale specific strings.
#
# @example
#   # bad
#   class User < ApplicationRecord
#   validates :email, presence: { message: "must be present" }
#   end
#
#   # good
#   # config/locales/en.yml
#   # en:
#   #   activerecord:
#   #     errors:
#   #       models:
#   #         user:
#   #           blank: "must be present"
#
#   class User < ApplicationRecord
#   validates :email, presence: true
#   end
#
#   # bad
#   class PostsController < ApplicationController
#   def create
#   # ...
#   redirect_to root_path, notice: "Post created!"
#   end
#   end
#
#   # good
#   # config/locales/en.yml
#   # en:
#   #   posts:
#   #     create:
#   #       success: "Post created!"
#
#   class PostsController < ApplicationController
#   def create
#   # ...
#   redirect_to root_path, notice: t(".success")
#   end
#   end
#
#   # bad
#   class UserMailer < ApplicationMailer
#   def welcome(user)
#   mail(to: user.email, subject: "Welcome to My Awesome Site")
#   end
#   end
#
#   # good
#   # config/locales/en.yml
#   # en:
#   #   user_mailer:
#   #     welcome:
#   #       subject: "Welcome to My Awesome Site"
#
#   class UserMailer < ApplicationMailer
#   def welcome(user)
#   mail(to: user.email)
#   end
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/i18n_locale_texts.rb#69
class RuboCop::Cop::Rails::I18nLocaleTexts < ::RuboCop::Cop::Base
  # source://rubocop-rails//lib/rubocop/cop/rails/i18n_locale_texts.rb#82
  def flash_assignment?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/i18n_locale_texts.rb#90
  def mail_subject(param0); end

  # source://rubocop-rails//lib/rubocop/cop/rails/i18n_locale_texts.rb#94
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/i18n_locale_texts.rb#78
  def redirect_to_flash(param0); end

  # source://rubocop-rails//lib/rubocop/cop/rails/i18n_locale_texts.rb#74
  def validation_message(param0); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/i18n_locale_texts.rb#70
RuboCop::Cop::Rails::I18nLocaleTexts::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/i18n_locale_texts.rb#72
RuboCop::Cop::Rails::I18nLocaleTexts::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Looks for assignments of `ignored_columns` that may override previous
# assignments.
#
# Overwriting previous assignments is usually a mistake, since it will
# un-ignore the first set of columns. Since duplicate column names is not
# a problem, it is better to simply append to the list.
#
# @example
#
#   # bad
#   class User < ActiveRecord::Base
#   self.ignored_columns = [:one]
#   end
#
#   # bad
#   class User < ActiveRecord::Base
#   self.ignored_columns = [:one, :two]
#   end
#
#   # good
#   class User < ActiveRecord::Base
#   self.ignored_columns += [:one, :two]
#   end
#
#   # good
#   class User < ActiveRecord::Base
#   self.ignored_columns += [:one]
#   self.ignored_columns += [:two]
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/ignored_columns_assignment.rb#36
class RuboCop::Cop::Rails::IgnoredColumnsAssignment < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/ignored_columns_assignment.rb#42
  def on_send(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/ignored_columns_assignment.rb#39
RuboCop::Cop::Rails::IgnoredColumnsAssignment::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/ignored_columns_assignment.rb#40
RuboCop::Cop::Rails::IgnoredColumnsAssignment::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks that `if` and `only` (or `except`) are not used together
# as options of `skip_*` action filter.
#
# The `if` option will be ignored when `if` and `only` are used together.
# Similarly, the `except` option will be ignored when `if` and `except`
# are used together.
#
# @example
#   # bad
#   class MyPageController < ApplicationController
#   skip_before_action :login_required,
#   only: :show, if: :trusted_origin?
#   end
#
#   # good
#   class MyPageController < ApplicationController
#   skip_before_action :login_required,
#   if: -> { trusted_origin? && action_name == "show" }
#   end
# @example
#   # bad
#   class MyPageController < ApplicationController
#   skip_before_action :login_required,
#   except: :admin, if: :trusted_origin?
#   end
#
#   # good
#   class MyPageController < ApplicationController
#   skip_before_action :login_required,
#   if: -> { trusted_origin? && action_name != "admin" }
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/ignored_skip_action_filter_option.rb#38
class RuboCop::Cop::Rails::IgnoredSkipActionFilterOption < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/ignored_skip_action_filter_option.rb#51
  def filter_options(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/ignored_skip_action_filter_option.rb#59
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/ignored_skip_action_filter_option.rb#89
  def if_and_except?(options); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/ignored_skip_action_filter_option.rb#85
  def if_and_only?(options); end

  # source://rubocop-rails//lib/rubocop/cop/rails/ignored_skip_action_filter_option.rb#79
  def options_hash(options); end

  # source://rubocop-rails//lib/rubocop/cop/rails/ignored_skip_action_filter_option.rb#93
  def remove_node_with_left_space_and_comma(corrector, node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/ignored_skip_action_filter_option.rb#49
RuboCop::Cop::Rails::IgnoredSkipActionFilterOption::FILTERS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/ignored_skip_action_filter_option.rb#43
RuboCop::Cop::Rails::IgnoredSkipActionFilterOption::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/ignored_skip_action_filter_option.rb#47
RuboCop::Cop::Rails::IgnoredSkipActionFilterOption::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Looks for uses of `each_with_object({}) { ... }`,
# `map { ... }.to_h`, and `Hash[map { ... }]` that are transforming
# an enumerable into a hash where the values are the original elements.
# Rails provides the `index_by` method for this purpose.
#
# @example
#   # bad
#   [1, 2, 3].each_with_object({}) { |el, h| h[foo(el)] = el }
#   [1, 2, 3].to_h { |el| [foo(el), el] }
#   [1, 2, 3].map { |el| [foo(el), el] }.to_h
#   Hash[[1, 2, 3].collect { |el| [foo(el), el] }]
#
#   # good
#   [1, 2, 3].index_by { |el| foo(el) }
#
# source://rubocop-rails//lib/rubocop/cop/rails/index_by.rb#20
class RuboCop::Cop::Rails::IndexBy < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::IndexMethod
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/index_by.rb#24
  def on_bad_each_with_object(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/index_by.rb#47
  def on_bad_hash_brackets_map(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/index_by.rb#38
  def on_bad_map_to_h(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/index_by.rb#31
  def on_bad_to_h(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/index_by.rb#59
  def new_method_name; end
end

# Looks for uses of `each_with_object({}) { ... }`,
# `map { ... }.to_h`, and `Hash[map { ... }]` that are transforming
# an enumerable into a hash where the keys are the original elements.
# Rails provides the `index_with` method for this purpose.
#
# @example
#   # bad
#   [1, 2, 3].each_with_object({}) { |el, h| h[el] = foo(el) }
#   [1, 2, 3].to_h { |el| [el, foo(el)] }
#   [1, 2, 3].map { |el| [el, foo(el)] }.to_h
#   Hash[[1, 2, 3].collect { |el| [el, foo(el)] }]
#
#   # good
#   [1, 2, 3].index_with { |el| foo(el) }
#
# source://rubocop-rails//lib/rubocop/cop/rails/index_with.rb#20
class RuboCop::Cop::Rails::IndexWith < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::IndexMethod
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/index_with.rb#27
  def on_bad_each_with_object(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/index_with.rb#50
  def on_bad_hash_brackets_map(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/index_with.rb#41
  def on_bad_map_to_h(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/index_with.rb#34
  def on_bad_to_h(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/index_with.rb#62
  def new_method_name; end
end

# Checks that Active Support's `inquiry` method is not used.
#
# @example
#   # bad - String#inquiry
#   ruby = 'two'.inquiry
#   ruby.two?
#
#   # good
#   ruby = 'two'
#   ruby == 'two'
#
#   # bad - Array#inquiry
#   pets = %w(cat dog).inquiry
#   pets.gopher?
#
#   # good
#   pets = %w(cat dog)
#   pets.include? 'cat'
#
# source://rubocop-rails//lib/rubocop/cop/rails/inquiry.rb#25
class RuboCop::Cop::Rails::Inquiry < ::RuboCop::Cop::Base
  # source://rubocop-rails//lib/rubocop/cop/rails/inquiry.rb#29
  def on_csend(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/inquiry.rb#29
  def on_send(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/inquiry.rb#26
RuboCop::Cop::Rails::Inquiry::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/inquiry.rb#27
RuboCop::Cop::Rails::Inquiry::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Looks for has_(one|many) and belongs_to associations where
# Active Record can't automatically determine the inverse association
# because of a scope or the options used. Using the blog with order scope
# example below, traversing the a Blog's association in both directions
# with `blog.posts.first.blog` would cause the `blog` to be loaded from
# the database twice.
#
# `:inverse_of` must be manually specified for Active Record to use the
# associated object in memory, or set to `false` to opt-out. Note that
# setting `nil` does not stop Active Record from trying to determine the
# inverse automatically, and is not considered a valid value for this.
#
# @example
#   # good
#   class Blog < ApplicationRecord
#   has_many :posts
#   end
#
#   class Post < ApplicationRecord
#   belongs_to :blog
#   end
# @example
#   # bad
#   class Blog < ApplicationRecord
#   has_many :posts, -> { order(published_at: :desc) }
#   end
#
#   class Post < ApplicationRecord
#   belongs_to :blog
#   end
#
#   # good
#   class Blog < ApplicationRecord
#   has_many(:posts,
#   -> { order(published_at: :desc) },
#   inverse_of: :blog)
#   end
#
#   class Post < ApplicationRecord
#   belongs_to :blog
#   end
#
#   # good
#   class Blog < ApplicationRecord
#   with_options inverse_of: :blog do
#   has_many :posts, -> { order(published_at: :desc) }
#   end
#   end
#
#   class Post < ApplicationRecord
#   belongs_to :blog
#   end
#
#   # good
#   # When you don't want to use the inverse association.
#   class Blog < ApplicationRecord
#   has_many(:posts,
#   -> { order(published_at: :desc) },
#   inverse_of: false)
#   end
# @example
#   # bad
#   class Picture < ApplicationRecord
#   belongs_to :imageable, polymorphic: true
#   end
#
#   class Employee < ApplicationRecord
#   has_many :pictures, as: :imageable
#   end
#
#   class Product < ApplicationRecord
#   has_many :pictures, as: :imageable
#   end
#
#   # good
#   class Picture < ApplicationRecord
#   belongs_to :imageable, polymorphic: true
#   end
#
#   class Employee < ApplicationRecord
#   has_many :pictures, as: :imageable, inverse_of: :imageable
#   end
#
#   class Product < ApplicationRecord
#   has_many :pictures, as: :imageable, inverse_of: :imageable
#   end
# @example
#   # bad
#   # However, RuboCop can not detect this pattern...
#   class Physician < ApplicationRecord
#   has_many :appointments
#   has_many :patients, through: :appointments
#   end
#
#   class Appointment < ApplicationRecord
#   belongs_to :physician
#   belongs_to :patient
#   end
#
#   class Patient < ApplicationRecord
#   has_many :appointments
#   has_many :physicians, through: :appointments
#   end
#
#   # good
#   class Physician < ApplicationRecord
#   has_many :appointments
#   has_many :patients, through: :appointments
#   end
#
#   class Appointment < ApplicationRecord
#   belongs_to :physician, inverse_of: :appointments
#   belongs_to :patient, inverse_of: :appointments
#   end
#
#   class Patient < ApplicationRecord
#   has_many :appointments
#   has_many :physicians, through: :appointments
#   end
# @example IgnoreScopes: false (default)
#   # bad
#   class Blog < ApplicationRecord
#   has_many :posts, -> { order(published_at: :desc) }
#   end
# @example IgnoreScopes: true
#   # good
#   class Blog < ApplicationRecord
#   has_many :posts, -> { order(published_at: :desc) }
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#140
class RuboCop::Cop::Rails::InverseOf < ::RuboCop::Cop::Base
  # source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#165
  def as_option?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#145
  def association_recv_arguments(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#153
  def conditions_option?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#169
  def foreign_key_option?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#177
  def inverse_of_nil_option?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#173
  def inverse_of_option?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#181
  def on_send(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#219
  def options_contain_inverse_of?(options); end

  # source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#149
  def options_from_argument(param0 = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#213
  def options_ignoring_inverse_of?(options); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#203
  def options_requiring_inverse_of?(options); end

  # source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#161
  def polymorphic_option?(param0 = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#230
  def same_context_in_with_options?(arg, recv); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#199
  def scope?(arguments); end

  # source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#157
  def through_option?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#223
  def with_options_arguments(recv, node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#246
  def ignore_scopes?; end

  # source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#238
  def message(options); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#142
RuboCop::Cop::Rails::InverseOf::NIL_MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#143
RuboCop::Cop::Rails::InverseOf::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/inverse_of.rb#141
RuboCop::Cop::Rails::InverseOf::SPECIFY_MSG = T.let(T.unsafe(nil), String)

# Checks that methods specified in the filter's `only` or
# `except` options are defined within the same class or module.
#
# @example
#   # bad
#   class LoginController < ApplicationController
#   before_action :require_login, only: %i[index settings logout]
#
#   def index
#   end
#   end
#
#   # good
#   class LoginController < ApplicationController
#   before_action :require_login, only: %i[index settings logout]
#
#   def index
#   end
#
#   def settings
#   end
#
#   def logout
#   end
#   end
# @example
#   # bad
#   module FooMixin
#   extend ActiveSupport::Concern
#
#   included do
#   before_action proc { authenticate }, only: :foo
#   end
#   end
#
#   # good
#   module FooMixin
#   extend ActiveSupport::Concern
#
#   included do
#   before_action proc { authenticate }, only: :foo
#   end
#
#   def foo
#   # something
#   end
#   end
# @example
#   class ContentController < ApplicationController
#   def update
#   @content.update(content_attributes)
#   end
#   end
#
#   class ArticlesController < ContentController
#   before_action :load_article, only: [:update]
#
#   # the cop requires this method, but it relies on behavior defined
#   # in the superclass, so needs to invoke `super`
#   def update
#   super
#   end
#
#   private
#
#   def load_article
#   @content = Article.find(params[:article_id])
#   end
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/lexically_scoped_action_filter.rb#86
class RuboCop::Cop::Rails::LexicallyScopedActionFilter < ::RuboCop::Cop::Base
  # source://rubocop-rails//lib/rubocop/cop/rails/lexically_scoped_action_filter.rb#118
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/lexically_scoped_action_filter.rb#107
  def only_or_except_filter_methods(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/lexically_scoped_action_filter.rb#154
  def alias_methods(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/lexically_scoped_action_filter.rb#145
  def aliased_action_methods(node, defined_methods); end

  # @param node [RuboCop::AST::Node]
  # @return [Array<Symbol>]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/lexically_scoped_action_filter.rb#171
  def array_values(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/lexically_scoped_action_filter.rb#138
  def defined_action_methods(block); end

  # @param methods [Array<String>]
  # @param parent [RuboCop::AST::Node]
  # @return [String]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/lexically_scoped_action_filter.rb#194
  def message(methods, parent); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/lexically_scoped_action_filter.rb#105
RuboCop::Cop::Rails::LexicallyScopedActionFilter::FILTERS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/lexically_scoped_action_filter.rb#87
RuboCop::Cop::Rails::LexicallyScopedActionFilter::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/lexically_scoped_action_filter.rb#89
RuboCop::Cop::Rails::LexicallyScopedActionFilter::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for calls to `link_to` that contain a
# `target: '_blank'` but no `rel: 'noopener'`. This can be a security
# risk as the loaded page will have control over the previous page
# and could change its location for phishing purposes.
#
# The option `rel: 'noreferrer'` also blocks this behavior
# and removes the http-referrer header.
#
# @example
#   # bad
#   link_to 'Click here', url, target: '_blank'
#
#   # good
#   link_to 'Click here', url, target: '_blank', rel: 'noopener'
#
#   # good
#   link_to 'Click here', url, target: '_blank', rel: 'noreferrer'
#
# source://rubocop-rails//lib/rubocop/cop/rails/link_to_blank.rb#23
class RuboCop::Cop::Rails::LinkToBlank < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/link_to_blank.rb#29
  def blank_target?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/link_to_blank.rb#33
  def includes_noopener?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/link_to_blank.rb#41
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/link_to_blank.rb#37
  def rel_node?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/link_to_blank.rb#75
  def add_rel(send_node, offense_node, corrector); end

  # source://rubocop-rails//lib/rubocop/cop/rails/link_to_blank.rb#69
  def append_to_rel(rel_node, corrector); end

  # source://rubocop-rails//lib/rubocop/cop/rails/link_to_blank.rb#56
  def autocorrect(corrector, send_node, node, option_nodes); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/link_to_blank.rb#88
  def contains_noopener?(value); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/link_to_blank.rb#26
RuboCop::Cop::Rails::LinkToBlank::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/link_to_blank.rb#27
RuboCop::Cop::Rails::LinkToBlank::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces that mailer names end with `Mailer` suffix.
#
# Without the `Mailer` suffix it isn't immediately apparent what's a mailer
# and which views are related to the mailer.
#
# @example
#   # bad
#   class User < ActionMailer::Base
#   end
#
#   class User < ApplicationMailer
#   end
#
#   # good
#   class UserMailer < ActionMailer::Base
#   end
#
#   class UserMailer < ApplicationMailer
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/mailer_name.rb#30
class RuboCop::Cop::Rails::MailerName < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/mailer_name.rb#42
  def class_definition?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/mailer_name.rb#46
  def class_new_definition?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/mailer_name.rb#35
  def mailer_base_class?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/mailer_name.rb#50
  def on_class(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/mailer_name.rb#58
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/mailer_name.rb#74
  def autocorrect(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/mailer_name.rb#84
  def mailer_suffix?(mailer_name); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/mailer_name.rb#33
RuboCop::Cop::Rails::MailerName::MSG = T.let(T.unsafe(nil), String)

# Identifies places where defining routes with `match`
# can be replaced with a specific HTTP method.
#
# Don't use `match` to define any routes unless there is a need to map multiple request types
# among [:get, :post, :patch, :put, :delete] to a single action using the `:via` option.
#
# @example
#   # bad
#   match ':controller/:action/:id'
#   match 'photos/:id', to: 'photos#show', via: :get
#
#   # good
#   get ':controller/:action/:id'
#   get 'photos/:id', to: 'photos#show'
#   match 'photos/:id', to: 'photos#show', via: [:get, :post]
#   match 'photos/:id', to: 'photos#show', via: :all
#
# source://rubocop-rails//lib/rubocop/cop/rails/match_route.rb#23
class RuboCop::Cop::Rails::MatchRoute < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/match_route.rb#30
  def match_method_call?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/match_route.rb#34
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/match_route.rb#63
  def routes_draw?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/match_route.rb#71
  def extract_via(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/match_route.rb#90
  def http_method?(method); end

  # source://rubocop-rails//lib/rubocop/cop/rails/match_route.rb#111
  def http_method_and_options(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/match_route.rb#53
  def register_offense(node, http_method); end

  # source://rubocop-rails//lib/rubocop/cop/rails/match_route.rb#94
  def replacement(path_node, options_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/match_route.rb#86
  def via_pair(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/match_route.rb#67
  def within_routes?(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/match_route.rb#28
RuboCop::Cop::Rails::MatchRoute::HTTP_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/match_route.rb#26
RuboCop::Cop::Rails::MatchRoute::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/match_route.rb#27
RuboCop::Cop::Rails::MatchRoute::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Makes sure that each migration file defines a migration class
# whose name matches the file name.
# (e.g. `20220224111111_create_users.rb` should define `CreateUsers` class.)
#
# @example
#   # db/migrate/20220224111111_create_users.rb
#
#   # bad
#   class SellBooks < ActiveRecord::Migration[7.0]
#   end
#
#   # good
#   class CreateUsers < ActiveRecord::Migration[7.0]
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/migration_class_name.rb#21
class RuboCop::Cop::Rails::MigrationClassName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::MigrationsHelper
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/migration_class_name.rb#27
  def on_class(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/migration_class_name.rb#45
  def basename_without_timestamp_and_suffix(filepath); end

  # source://rubocop-rails//lib/rubocop/cop/rails/migration_class_name.rb#57
  def camelize(word); end

  # e.g.: from `add_blobs.active_storage` to `add_blobs`.
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/migration_class_name.rb#53
  def remove_gem_suffix(file_name); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/migration_class_name.rb#25
RuboCop::Cop::Rails::MigrationClassName::MSG = T.let(T.unsafe(nil), String)

# Enforces the use of `collection.exclude?(obj)`
# over `!collection.include?(obj)`.
#
# @example
#   # bad
#   !array.include?(2)
#   !hash.include?(:key)
#
#   # good
#   array.exclude?(2)
#   hash.exclude?(:key)
#
# source://rubocop-rails//lib/rubocop/cop/rails/negate_include.rb#22
class RuboCop::Cop::Rails::NegateInclude < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/negate_include.rb#28
  def negate_include_call?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/negate_include.rb#32
  def on_send(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/negate_include.rb#25
RuboCop::Cop::Rails::NegateInclude::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/negate_include.rb#26
RuboCop::Cop::Rails::NegateInclude::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for add_column call with NOT NULL constraint in migration file.
#
# `TEXT` can have default values in PostgreSQL, but not in MySQL.
# It will automatically detect an adapter from `development` environment
# in `config/database.yml` or the environment variable `DATABASE_URL`
# when the `Database` option is not set. If the database is MySQL,
# this cop ignores offenses for the `TEXT`.
#
# @example
#   # bad
#   add_column :users, :name, :string, null: false
#   add_reference :products, :category, null: false
#
#   # good
#   add_column :users, :name, :string, null: true
#   add_column :users, :name, :string, null: false, default: ''
#   add_reference :products, :category
#   add_reference :products, :category, null: false, default: 1
#
# source://rubocop-rails//lib/rubocop/cop/rails/not_null_column.rb#24
class RuboCop::Cop::Rails::NotNullColumn < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::DatabaseTypeResolvable

  # source://rubocop-rails//lib/rubocop/cop/rails/not_null_column.rb#30
  def add_not_null_column?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/not_null_column.rb#34
  def add_not_null_reference?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/not_null_column.rb#42
  def default_option?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/not_null_column.rb#38
  def null_false?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/not_null_column.rb#46
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/not_null_column.rb#53
  def check_add_column(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/not_null_column.rb#64
  def check_add_reference(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/not_null_column.rb#70
  def check_pairs(pairs); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/not_null_column.rb#27
RuboCop::Cop::Rails::NotNullColumn::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/not_null_column.rb#28
RuboCop::Cop::Rails::NotNullColumn::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for places where ordering by `id` column is used.
#
# Don't use the `id` column for ordering. The sequence of ids is not guaranteed
# to be in any particular order, despite often (incidentally) being chronological.
# Use a timestamp column to order chronologically. As a bonus the intent is clearer.
#
# NOTE: Make sure the changed order column does not introduce performance
# bottlenecks and appropriate database indexes are added.
#
# @example
#   # bad
#   scope :chronological, -> { order(id: :asc) }
#   scope :chronological, -> { order(primary_key => :asc) }
#
#   # good
#   scope :chronological, -> { order(created_at: :asc) }
#
# source://rubocop-rails//lib/rubocop/cop/rails/order_by_id.rb#23
class RuboCop::Cop::Rails::OrderById < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop-rails//lib/rubocop/cop/rails/order_by_id.rb#39
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/order_by_id.rb#29
  def order_by_id?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/order_by_id.rb#45
  def offense_range(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/order_by_id.rb#26
RuboCop::Cop::Rails::OrderById::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/order_by_id.rb#27
RuboCop::Cop::Rails::OrderById::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the use of output calls like puts and print
#
# @example
#   # bad
#   puts 'A debug message'
#   pp 'A debug message'
#   print 'A debug message'
#
#   # good
#   Rails.logger.debug 'A debug message'
#
# source://rubocop-rails//lib/rubocop/cop/rails/output.rb#20
class RuboCop::Cop::Rails::Output < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/output.rb#32
  def io_output?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/output.rb#42
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/output.rb#28
  def output?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/output.rb#55
  def match_gvar?(sym); end

  # source://rubocop-rails//lib/rubocop/cop/rails/output.rb#59
  def offense_range(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/output.rb#26
RuboCop::Cop::Rails::Output::ALLOWED_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/output.rb#24
RuboCop::Cop::Rails::Output::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/output.rb#25
RuboCop::Cop::Rails::Output::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the use of output safety calls like `html_safe`,
# `raw`, and `safe_concat`. These methods do not escape content. They
# simply return a SafeBuffer containing the content as is. Instead,
# use `safe_join` to join content and escape it and concat to
# concatenate content and escape it, ensuring its safety.
#
# @example
#   user_content = "<b>hi</b>"
#
#   # bad
#   "<p>#{user_content}</p>".html_safe
#   # => ActiveSupport::SafeBuffer "<p><b>hi</b></p>"
#
#   # good
#   content_tag(:p, user_content)
#   # => ActiveSupport::SafeBuffer "<p>&lt;b&gt;hi&lt;/b&gt;</p>"
#
#   # bad
#   out = ""
#   out << "<li>#{user_content}</li>"
#   out << "<li>#{user_content}</li>"
#   out.html_safe
#   # => ActiveSupport::SafeBuffer "<li><b>hi</b></li><li><b>hi</b></li>"
#
#   # good
#   out = []
#   out << content_tag(:li, user_content)
#   out << content_tag(:li, user_content)
#   safe_join(out)
#   # => ActiveSupport::SafeBuffer
#   #    "<li>&lt;b&gt;hi&lt;/b&gt;</li><li>&lt;b&gt;hi&lt;/b&gt;</li>"
#
#   # bad
#   out = "<h1>trusted content</h1>".html_safe
#   out.safe_concat(user_content)
#   # => ActiveSupport::SafeBuffer "<h1>trusted_content</h1><b>hi</b>"
#
#   # good
#   out = "<h1>trusted content</h1>".html_safe
#   out.concat(user_content)
#   # => ActiveSupport::SafeBuffer
#   #    "<h1>trusted_content</h1>&lt;b&gt;hi&lt;/b&gt;"
#
#   # safe, though maybe not good style
#   out = "trusted content"
#   result = out.concat(user_content)
#   # => String "trusted content<b>hi</b>"
#   # because when rendered in ERB the String will be escaped:
#   # <%= result %>
#   # => trusted content&lt;b&gt;hi&lt;/b&gt;
#
#   # bad
#   (user_content + " " + content_tag(:span, user_content)).html_safe
#   # => ActiveSupport::SafeBuffer "<b>hi</b> <span><b>hi</b></span>"
#
#   # good
#   safe_join([user_content, " ", content_tag(:span, user_content)])
#   # => ActiveSupport::SafeBuffer
#   #    "&lt;b&gt;hi&lt;/b&gt; <span>&lt;b&gt;hi&lt;/b&gt;</span>"
#
# source://rubocop-rails//lib/rubocop/cop/rails/output_safety.rb#65
class RuboCop::Cop::Rails::OutputSafety < ::RuboCop::Cop::Base
  # source://rubocop-rails//lib/rubocop/cop/rails/output_safety.rb#69
  def i18n_method?(param0); end

  # source://rubocop-rails//lib/rubocop/cop/rails/output_safety.rb#73
  def on_csend(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/output_safety.rb#73
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/output_safety.rb#90
  def looks_like_rails_html_safe?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/output_safety.rb#94
  def looks_like_rails_raw?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/output_safety.rb#98
  def looks_like_rails_safe_concat?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/output_safety.rb#86
  def non_interpolated_string?(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/output_safety.rb#66
RuboCop::Cop::Rails::OutputSafety::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/output_safety.rb#67
RuboCop::Cop::Rails::OutputSafety::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of `pick` over `pluck(...).first`.
#
# Using `pluck` followed by `first` creates an intermediate array, which
# `pick` avoids. When called on an Active Record relation, `pick` adds a
# limit to the query so that only one value is fetched from the database.
#
# @example
#   # bad
#   Model.pluck(:a).first
#   [{ a: :b, c: :d }].pluck(:a, :b).first
#
#   # good
#   Model.pick(:a)
#   [{ a: :b, c: :d }].pick(:a, :b)
#
# source://rubocop-rails//lib/rubocop/cop/rails/pick.rb#27
class RuboCop::Cop::Rails::Pick < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/pick.rb#40
  def on_csend(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/pick.rb#40
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/pick.rb#36
  def pick_candidate?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/pick.rb#59
  def message(receiver, current); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/pick.rb#31
RuboCop::Cop::Rails::Pick::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/pick.rb#32
RuboCop::Cop::Rails::Pick::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of `pluck` over `map`.
#
# `pluck` can be used instead of `map` to extract a single key from each
# element in an enumerable. When called on an Active Record relation, it
# results in a more efficient query that only selects the necessary key.
#
# @example
#   # bad
#   Post.published.map { |post| post[:title] }
#   [{ a: :b, c: :d }].collect { |el| el[:a] }
#
#   # good
#   Post.published.pluck(:title)
#   [{ a: :b, c: :d }].pluck(:a)
#
# source://rubocop-rails//lib/rubocop/cop/rails/pluck.rb#32
class RuboCop::Cop::Rails::Pluck < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/pluck.rb#44
  def on_block(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/pluck.rb#44
  def on_numblock(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/pluck.rb#40
  def pluck_candidate?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/pluck.rb#88
  def message(replacement, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/pluck.rb#75
  def offense_range(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/pluck.rb#79
  def register_offense(node, key); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/pluck.rb#69
  def use_block_argument_in_key?(block_argument, key); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/pluck.rb#63
  def use_one_block_argument?(argument); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/pluck.rb#36
RuboCop::Cop::Rails::Pluck::MSG = T.let(T.unsafe(nil), String)

# Enforces the use of `ids` over `pluck(:id)` and `pluck(primary_key)`.
#
# @example
#   # bad
#   User.pluck(:id)
#   user.posts.pluck(:id)
#
#   def self.user_ids
#   pluck(primary_key)
#   end
#
#   # good
#   User.ids
#   user.posts.ids
#
#   def self.user_ids
#   ids
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/pluck_id.rb#28
class RuboCop::Cop::Rails::PluckId < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ActiveRecordHelper
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/pluck_id.rb#40
  def on_csend(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/pluck_id.rb#40
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/pluck_id.rb#36
  def pluck_id_call?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/pluck_id.rb#54
  def offense_range(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/pluck_id.rb#33
RuboCop::Cop::Rails::PluckId::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/pluck_id.rb#34
RuboCop::Cop::Rails::PluckId::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies places where `pluck` is used in `where` query methods
# and can be replaced with `select`.
#
# Since `pluck` is an eager method and hits the database immediately,
# using `select` helps to avoid additional database queries.
#
# This cop has two different enforcement modes. When the `EnforcedStyle`
# is `conservative` (the default) then only calls to `pluck` on a constant
# (i.e. a model class) in the `where` is used as offenses.
#
# @example
#   # bad
#   Post.where(user_id: User.active.pluck(:id))
#   Post.where(user_id: User.active.ids)
#   Post.where.not(user_id: User.active.pluck(:id))
#
#   # good
#   Post.where(user_id: User.active.select(:id))
#   Post.where(user_id: active_users.select(:id))
#   Post.where.not(user_id: active_users.select(:id))
# @example EnforcedStyle: conservative (default)
#   # good
#   Post.where(user_id: active_users.pluck(:id))
# @example EnforcedStyle: aggressive
#   # bad
#   Post.where(user_id: active_users.pluck(:id))
#
# source://rubocop-rails//lib/rubocop/cop/rails/pluck_in_where.rb#41
class RuboCop::Cop::Rails::PluckInWhere < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ActiveRecordHelper
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/pluck_in_where.rb#50
  def on_csend(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/pluck_in_where.rb#50
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/pluck_in_where.rb#72
  def root_receiver(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/pluck_in_where.rb#47
RuboCop::Cop::Rails::PluckInWhere::MSG_IDS = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/pluck_in_where.rb#46
RuboCop::Cop::Rails::PluckInWhere::MSG_SELECT = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/pluck_in_where.rb#48
RuboCop::Cop::Rails::PluckInWhere::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for correct grammar when using ActiveSupport's
# core extensions to the numeric classes.
#
# @example
#   # bad
#   3.day.ago
#   1.months.ago
#
#   # good
#   3.days.ago
#   1.month.ago
#
# source://rubocop-rails//lib/rubocop/cop/rails/pluralization_grammar.rb#17
class RuboCop::Cop::Rails::PluralizationGrammar < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/pluralization_grammar.rb#35
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/pluralization_grammar.rb#53
  def correct_method(method_name); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/pluralization_grammar.rb#96
  def duration_method?(method_name); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/pluralization_grammar.rb#84
  def literal_number?(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/pluralization_grammar.rb#49
  def message(number, method_name); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/pluralization_grammar.rb#61
  def offense?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/pluralization_grammar.rb#68
  def plural_method?(method_name); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/pluralization_grammar.rb#80
  def plural_receiver?(number); end

  # source://rubocop-rails//lib/rubocop/cop/rails/pluralization_grammar.rb#88
  def pluralize(method_name); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/pluralization_grammar.rb#72
  def singular_method?(method_name); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/pluralization_grammar.rb#76
  def singular_receiver?(number); end

  # source://rubocop-rails//lib/rubocop/cop/rails/pluralization_grammar.rb#92
  def singularize(method_name); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/pluralization_grammar.rb#33
RuboCop::Cop::Rails::PluralizationGrammar::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/pluralization_grammar.rb#31
RuboCop::Cop::Rails::PluralizationGrammar::PLURAL_DURATION_METHODS = T.let(T.unsafe(nil), Hash)

# source://rubocop-rails//lib/rubocop/cop/rails/pluralization_grammar.rb#29
RuboCop::Cop::Rails::PluralizationGrammar::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/pluralization_grammar.rb#20
RuboCop::Cop::Rails::PluralizationGrammar::SINGULAR_DURATION_METHODS = T.let(T.unsafe(nil), Hash)

# Checks code that can be written more easily using
# `Object#presence` defined by Active Support.
#
# @example
#   # bad
#   a.present? ? a : nil
#
#   # bad
#   !a.present? ? nil : a
#
#   # bad
#   a.blank? ? nil : a
#
#   # bad
#   !a.blank? ? a : nil
#
#   # good
#   a.presence
# @example
#   # bad
#   a.present? ? a : b
#
#   # bad
#   !a.present? ? b : a
#
#   # bad
#   a.blank? ? b : a
#
#   # bad
#   !a.blank? ? a : b
#
#   # good
#   a.presence || b
#
# source://rubocop-rails//lib/rubocop/cop/rails/presence.rb#40
class RuboCop::Cop::Rails::Presence < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/presence.rb#76
  def on_if(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/presence.rb#61
  def redundant_negative_receiver_and_other(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/presence.rb#46
  def redundant_receiver_and_other(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/presence.rb#135
  def build_source_for_or_method(other); end

  # source://rubocop-rails//lib/rubocop/cop/rails/presence.rb#114
  def current(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/presence.rb#100
  def ignore_if_node?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/presence.rb#104
  def ignore_other_node?(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/presence.rb#108
  def message(node, receiver, other); end

  # source://rubocop-rails//lib/rubocop/cop/rails/presence.rb#146
  def method_range(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/presence.rb#94
  def register_offense(node, receiver, other); end

  # source://rubocop-rails//lib/rubocop/cop/rails/presence.rb#122
  def replacement(receiver, other, left_sibling); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/presence.rb#44
RuboCop::Cop::Rails::Presence::MSG = T.let(T.unsafe(nil), String)

# Checks for code that can be written with simpler conditionals
# using `Object#present?` defined by Active Support.
#
# Interaction with `Style/UnlessElse`:
# The configuration of `NotBlank` will not produce an offense in the
# context of `unless else` if `Style/UnlessElse` is enabled. This is
# to prevent interference between the autocorrection of the two cops.
#
# @example NotNilAndNotEmpty: true (default)
#   # Converts usages of `!nil? && !empty?` to `present?`
#
#   # bad
#   !foo.nil? && !foo.empty?
#
#   # bad
#   foo != nil && !foo.empty?
#
#   # good
#   foo.present?
# @example NotBlank: true (default)
#   # Converts usages of `!blank?` to `present?`
#
#   # bad
#   !foo.blank?
#
#   # bad
#   not foo.blank?
#
#   # good
#   foo.present?
# @example UnlessBlank: true (default)
#   # Converts usages of `unless blank?` to `if present?`
#
#   # bad
#   something unless foo.blank?
#
#   # good
#   something if foo.present?
#
# source://rubocop-rails//lib/rubocop/cop/rails/present.rb#46
class RuboCop::Cop::Rails::Present < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/present.rb#126
  def autocorrect(corrector, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/present.rb#54
  def exists_and_not_empty?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/present.rb#68
  def not_blank?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/present.rb#86
  def on_and(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/present.rb#112
  def on_if(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/present.rb#100
  def on_or(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/present.rb#74
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/present.rb#70
  def unless_blank?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/present.rb#150
  def replacement(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/present.rb#142
  def unless_condition(node, method_call); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/present.rb#50
RuboCop::Cop::Rails::Present::MSG_EXISTS_AND_NOT_EMPTY = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/present.rb#49
RuboCop::Cop::Rails::Present::MSG_NOT_BLANK = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/present.rb#51
RuboCop::Cop::Rails::Present::MSG_UNLESS_BLANK = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/present.rb#52
RuboCop::Cop::Rails::Present::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for Rake tasks without the `:environment` task
# dependency. The `:environment` task loads application code for other
# Rake tasks. Without it, tasks cannot make use of application code like
# models.
#
# You can ignore the offense if the task satisfies at least one of the
# following conditions:
#
# * The task does not need application code.
# * The task invokes the `:environment` task.
#
# @example
#   # bad
#   task :foo do
#   do_something
#   end
#
#   # good
#   task foo: :environment do
#   do_something
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/rake_environment.rb#33
class RuboCop::Cop::Rails::RakeEnvironment < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/rake_environment.rb#42
  def on_block(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/rake_environment.rb#38
  def task_definition?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/rake_environment.rb#62
  def correct_task_arguments_dependency(task_method); end

  # source://rubocop-rails//lib/rubocop/cop/rails/rake_environment.rb#66
  def correct_task_dependency(task_name); end

  # source://rubocop-rails//lib/rubocop/cop/rails/rake_environment.rb#91
  def task_arguments(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/rake_environment.rb#74
  def task_name(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/rake_environment.rb#95
  def with_arguments?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/rake_environment.rb#99
  def with_dependencies?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/rake_environment.rb#114
  def with_hash_style_dependencies?(hash_node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/rake_environment.rb#36
RuboCop::Cop::Rails::RakeEnvironment::MSG = T.let(T.unsafe(nil), String)

# Checks for the use of the `read_attribute` or `write_attribute`
# methods and recommends square brackets instead.
#
# If an attribute is missing from the instance (for example, when
# initialized by a partial `select`) then `read_attribute`
# will return nil, but square brackets will raise
# an `ActiveModel::MissingAttributeError`.
#
# Explicitly raising an error in this situation is preferable, and that
# is why rubocop recommends using square brackets.
#
# When called from within a method with the same name as the attribute,
# `read_attribute` and `write_attribute` must be used to prevent an
# infinite loop:
#
# @example
#
#   # bad
#   x = read_attribute(:attr)
#   write_attribute(:attr, val)
#
#   # good
#   x = self[:attr]
#   self[:attr] = val
# @example
#
#   # good
#   def foo
#   bar || read_attribute(:foo)
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/read_write_attribute.rb#37
class RuboCop::Cop::Rails::ReadWriteAttribute < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/read_write_attribute.rb#50
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/read_write_attribute.rb#43
  def read_write_attribute?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/read_write_attribute.rb#73
  def build_message(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/read_write_attribute.rb#85
  def multi_line_message(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/read_write_attribute.rb#93
  def node_replacement(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/read_write_attribute.rb#102
  def read_attribute_replacement(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/read_write_attribute.rb#81
  def single_line_message(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/read_write_attribute.rb#61
  def within_shadowing_method?(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/read_write_attribute.rb#106
  def write_attribute_replacement(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/read_write_attribute.rb#40
RuboCop::Cop::Rails::ReadWriteAttribute::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/read_write_attribute.rb#41
RuboCop::Cop::Rails::ReadWriteAttribute::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Detect redundant `all` used as a receiver for Active Record query methods.
#
# For the methods `delete_all` and `destroy_all`, this cop will only check cases where the receiver is a model.
# It will ignore cases where the receiver is an association (e.g., `user.articles.all.delete_all`).
# This is because omitting `all` from an association changes the methods
# from `ActiveRecord::Relation` to `ActiveRecord::Associations::CollectionProxy`,
# which can affect their behavior.
#
# @example
#   # bad
#   User.all.find(id)
#   User.all.order(:created_at)
#   users.all.where(id: ids)
#   user.articles.all.order(:created_at)
#
#   # good
#   User.find(id)
#   User.order(:created_at)
#   users.where(id: ids)
#   user.articles.order(:created_at)
# @example AllowedReceivers: ['ActionMailer::Preview', 'ActiveSupport::TimeZone'] (default)
#   # good
#   ActionMailer::Preview.all.first
#   ActiveSupport::TimeZone.all.first
#
# source://rubocop-rails//lib/rubocop/cop/rails/redundant_active_record_all_method.rb#63
class RuboCop::Cop::Rails::RedundantActiveRecordAllMethod < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ActiveRecordHelper
  include ::RuboCop::Cop::Rails::AllowedReceivers
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_active_record_all_method.rb#184
  def followed_by_query_method?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_active_record_all_method.rb#188
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_active_record_all_method.rb#213
  def offense_range(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_active_record_all_method.rb#202
  def possible_enumerable_block_method?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_active_record_all_method.rb#209
  def sensitive_association_method?(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/redundant_active_record_all_method.rb#69
RuboCop::Cop::Rails::RedundantActiveRecordAllMethod::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/redundant_active_record_all_method.rb#181
RuboCop::Cop::Rails::RedundantActiveRecordAllMethod::POSSIBLE_ENUMERABLE_BLOCK_METHODS = T.let(T.unsafe(nil), Array)

# Defined methods in `ActiveRecord::Querying::QUERYING_METHODS` on activerecord 7.1.0.
#
# source://rubocop-rails//lib/rubocop/cop/rails/redundant_active_record_all_method.rb#74
RuboCop::Cop::Rails::RedundantActiveRecordAllMethod::QUERYING_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-rails//lib/rubocop/cop/rails/redundant_active_record_all_method.rb#71
RuboCop::Cop::Rails::RedundantActiveRecordAllMethod::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/redundant_active_record_all_method.rb#182
RuboCop::Cop::Rails::RedundantActiveRecordAllMethod::SENSITIVE_METHODS_ON_ASSOCIATION = T.let(T.unsafe(nil), Array)

# Checks Rails model validations for a redundant `allow_nil` when
# `allow_blank` is present.
#
# @example
#   # bad
#   validates :x, length: { is: 5 }, allow_nil: true, allow_blank: true
#
#   # bad
#   validates :x, length: { is: 5 }, allow_nil: false, allow_blank: true
#
#   # bad
#   validates :x, length: { is: 5 }, allow_nil: false, allow_blank: false
#
#   # good
#   validates :x, length: { is: 5 }, allow_blank: true
#
#   # good
#   validates :x, length: { is: 5 }, allow_blank: false
#
#   # good
#   # Here, `nil` is valid but `''` is not
#   validates :x, length: { is: 5 }, allow_nil: true, allow_blank: false
#
# source://rubocop-rails//lib/rubocop/cop/rails/redundant_allow_nil.rb#29
class RuboCop::Cop::Rails::RedundantAllowNil < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_allow_nil.rb#39
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_allow_nil.rb#70
  def find_allow_nil_and_allow_blank(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_allow_nil.rb#89
  def node_beg(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_allow_nil.rb#93
  def node_end(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_allow_nil.rb#55
  def register_offense(allow_nil, message); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/redundant_allow_nil.rb#35
RuboCop::Cop::Rails::RedundantAllowNil::MSG_ALLOW_NIL_FALSE = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/redundant_allow_nil.rb#33
RuboCop::Cop::Rails::RedundantAllowNil::MSG_SAME = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/redundant_allow_nil.rb#37
RuboCop::Cop::Rails::RedundantAllowNil::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Detects cases where the `:foreign_key` option on associations
# is redundant.
#
# @example
#   # bad
#   class Post
#   has_many :comments, foreign_key: 'post_id'
#   end
#
#   class Comment
#   belongs_to :post, foreign_key: 'post_id'
#   end
#
#   # good
#   class Post
#   has_many :comments
#   end
#
#   class Comment
#   belongs_to :author, foreign_key: 'user_id'
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/redundant_foreign_key.rb#27
class RuboCop::Cop::Rails::RedundantForeignKey < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_foreign_key.rb#34
  def association_with_foreign_key(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_foreign_key.rb#40
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_foreign_key.rb#59
  def default_foreign_key(node, association_type, association_name, options); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_foreign_key.rb#69
  def find_as_option(options); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_foreign_key.rb#55
  def redundant?(node, association_type, association_name, options, foreign_key); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/redundant_foreign_key.rb#31
RuboCop::Cop::Rails::RedundantForeignKey::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/redundant_foreign_key.rb#32
RuboCop::Cop::Rails::RedundantForeignKey::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Since Rails 5.0 the default for `belongs_to` is `optional: false`
# unless `config.active_record.belongs_to_required_by_default` is
# explicitly set to `false`. The presence validator is added
# automatically, and explicit presence validation is redundant.
#
# @example
#   # bad
#   belongs_to :user
#   validates :user, presence: true
#
#   # bad
#   belongs_to :user
#   validates :user_id, presence: true
#
#   # bad
#   belongs_to :author, foreign_key: :user_id
#   validates :user_id, presence: true
#
#   # good
#   belongs_to :user
#
#   # good
#   belongs_to :author, foreign_key: :user_id
#
# source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#34
class RuboCop::Cop::Rails::RedundantPresenceValidationOnBelongsTo < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # Match a class with `belongs_to` with no regard to `foreign_key` option
  #
  # @example source that matches
  #   belongs_to :user
  # @example source that matches - regardless of `foreign_key`
  #   belongs_to :author, foreign_key: :user_id
  # @param node [RuboCop::AST::Node]
  # @param association [Symbol]
  # @return [Array<RuboCop::AST::Node>, nil] matching node
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#106
  def any_belongs_to?(param0 = T.unsafe(nil), association:); end

  # Match a class with a matching association, either by name or an explicit
  # `foreign_key` option
  #
  # @example source that matches - fk matches `foreign_key` option
  #   belongs_to :author, foreign_key: :user_id
  # @example source that matches - key matches association name
  #   belongs_to :user
  # @example source that does not match - explicit `foreign_key` does not match
  #   belongs_to :user, foreign_key: :account_id
  # @param node [RuboCop::AST::Node]
  # @param key [Symbol] e.g. `:user`
  # @param fk [Symbol] e.g. `:user_id`
  # @return [Array<RuboCop::AST::Node>] matching nodes
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#132
  def belongs_to?(param0 = T.unsafe(nil), key:, fk:); end

  # Match a matching `belongs_to` association with a matching explicit `foreign_key` option
  #
  # @example source that matches
  #   belongs_to :author, foreign_key: :user_id
  # @param node [RuboCop::AST::Node]
  # @param fk [Symbol] e.g. `:user_id`
  # @return [Array<RuboCop::AST::Node>] matching nodes
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#167
  def belongs_to_with_a_matching_fk?(param0 = T.unsafe(nil), param1); end

  # Match a matching `belongs_to` association, without an explicit `foreign_key` option
  #
  # @param node [RuboCop::AST::Node]
  # @param key [Symbol] e.g. `:user`
  # @return [Array<RuboCop::AST::Node>] matching nodes
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#150
  def belongs_to_without_fk?(param0 = T.unsafe(nil), param1); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#171
  def on_send(node); end

  # Match a `belongs_to` association with an optional option in a hash
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#81
  def optional?(param0 = T.unsafe(nil)); end

  # Match an optional option in a hash
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#87
  def optional_option?(param0 = T.unsafe(nil)); end

  # Match a `validates` statement with a presence check
  #
  # @example source that matches - by association
  #   validates :user, presence: true
  # @example source that matches - by association
  #   validates :name, :user, presence: true
  # @example source that matches - by a foreign key
  #   validates :user_id, presence: true
  # @example source that DOES NOT match - if condition
  #   validates :user_id, presence: true, if: condition
  # @example source that DOES NOT match - unless condition
  #   validates :user_id, presence: true, unless: condition
  # @example source that DOES NOT match - strict validation
  #   validates :user_id, presence: true, strict: true
  # @example source that DOES NOT match - custom strict validation
  #   validates :user_id, presence: true, strict: MissingUserError
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#67
  def presence_validation?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#182
  def add_offense_and_correct(node, all_keys, keys, options, presence); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#210
  def belongs_to_for(model_class_node, key); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#242
  def extract_validation_for_keys(corrector, node, keys, options); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#198
  def message_for(keys); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#203
  def non_optional_belongs_to(node, keys); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#223
  def remove_keys_from_validation(corrector, node, keys); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#234
  def remove_presence_option(corrector, presence); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#219
  def remove_validation(corrector, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#258
  def validation_range(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#39
RuboCop::Cop::Rails::RedundantPresenceValidationOnBelongsTo::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/redundant_presence_validation_on_belongs_to.rb#40
RuboCop::Cop::Rails::RedundantPresenceValidationOnBelongsTo::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for redundant receiver in `with_options`.
# Receiver is implicit from Rails 4.2 or higher.
#
# @example
#   # bad
#   class Account < ApplicationRecord
#   with_options dependent: :destroy do |assoc|
#   assoc.has_many :customers
#   assoc.has_many :products
#   assoc.has_many :invoices
#   assoc.has_many :expenses
#   end
#   end
#
#   # good
#   class Account < ApplicationRecord
#   with_options dependent: :destroy do
#   has_many :customers
#   has_many :products
#   has_many :invoices
#   has_many :expenses
#   end
#   end
# @example
#   # bad
#   with_options options: false do |merger|
#   merger.invoke(merger.something)
#   end
#
#   # good
#   with_options options: false do
#   invoke(something)
#   end
#
#   # good
#   client = Client.new
#   with_options options: false do |merger|
#   client.invoke(merger.something, something)
#   end
#
#   # ok
#   # When `with_options` includes a block, all scoping scenarios
#   # cannot be evaluated. Thus, it is ok to include the explicit
#   # receiver.
#   with_options options: false do |merger|
#   merger.invoke
#   with_another_method do |another_receiver|
#   merger.invoke(another_receiver)
#   end
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/redundant_receiver_in_with_options.rb#57
class RuboCop::Cop::Rails::RedundantReceiverInWithOptions < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_receiver_in_with_options.rb#63
  def all_block_nodes_in(param0); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_receiver_in_with_options.rb#67
  def all_send_nodes_in(param0); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_receiver_in_with_options.rb#71
  def on_block(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_receiver_in_with_options.rb#71
  def on_numblock(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_receiver_in_with_options.rb#91
  def autocorrect(corrector, send_node, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_receiver_in_with_options.rb#110
  def block_argument_range(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_receiver_in_with_options.rb#97
  def redundant_receiver?(send_nodes, node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_receiver_in_with_options.rb#132
  def same_value?(arg_node, recv_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_receiver_in_with_options.rb#122
  def search_begin_pos_of_space_before_block_argument(begin_pos); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/redundant_receiver_in_with_options.rb#61
RuboCop::Cop::Rails::RedundantReceiverInWithOptions::MSG = T.let(T.unsafe(nil), String)

# Checks for redundant `travel_back` calls.
# Since Rails 5.2, `travel_back` is automatically called at the end of the test.
#
# @example
#
#   # bad
#   def teardown
#   do_something
#   travel_back
#   end
#
#   # good
#   def teardown
#   do_something
#   end
#
#   # bad
#   after do
#   do_something
#   travel_back
#   end
#
#   # good
#   after do
#   do_something
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/redundant_travel_back.rb#33
class RuboCop::Cop::Rails::RedundantTravelBack < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/redundant_travel_back.rb#43
  def on_send(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/redundant_travel_back.rb#40
RuboCop::Cop::Rails::RedundantTravelBack::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/redundant_travel_back.rb#41
RuboCop::Cop::Rails::RedundantTravelBack::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks if the value of the option `class_name`, in
# the definition of a reflection is a string.
#
# @example
#   # bad
#   has_many :accounts, class_name: Account
#   has_many :accounts, class_name: Account.name
#
#   # good
#   has_many :accounts, class_name: 'Account'
#
# source://rubocop-rails//lib/rubocop/cop/rails/reflection_class_name.rb#20
class RuboCop::Cop::Rails::ReflectionClassName < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/reflection_class_name.rb#27
  def association_with_reflection(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reflection_class_name.rb#37
  def const_or_string(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reflection_class_name.rb#41
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reflection_class_name.rb#33
  def reflection_class_name(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/reflection_class_name.rb#76
  def autocorrect(corrector, class_config); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/reflection_class_name.rb#68
  def reflection_class_value?(class_value); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/reflection_class_name.rb#54
  def str_assigned?(reflection_class_name); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/reflection_class_name.rb#25
RuboCop::Cop::Rails::ReflectionClassName::ALLOWED_REFLECTION_CLASS_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/reflection_class_name.rb#23
RuboCop::Cop::Rails::ReflectionClassName::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/reflection_class_name.rb#24
RuboCop::Cop::Rails::ReflectionClassName::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Use `assert_not` methods instead of `refute` methods.
#
# @example EnforcedStyle: assert_not (default)
#   # bad
#   refute false
#   refute_empty [1, 2, 3]
#   refute_equal true, false
#
#   # good
#   assert_not false
#   assert_not_empty [1, 2, 3]
#   assert_not_equal true, false
# @example EnforcedStyle: refute
#   # bad
#   assert_not false
#   assert_not_empty [1, 2, 3]
#   assert_not_equal true, false
#
#   # good
#   refute false
#   refute_empty [1, 2, 3]
#   refute_equal true, false
#
# source://rubocop-rails//lib/rubocop/cop/rails/refute_methods.rb#30
class RuboCop::Cop::Rails::RefuteMethods < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/refute_methods.rb#58
  def offensive?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/refute_methods.rb#60
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/refute_methods.rb#74
  def bad_method?(method_name); end

  # source://rubocop-rails//lib/rubocop/cop/rails/refute_methods.rb#86
  def convert_good_method(bad_method); end

  # source://rubocop-rails//lib/rubocop/cop/rails/refute_methods.rb#82
  def offense_message(method_name); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/refute_methods.rb#54
RuboCop::Cop::Rails::RefuteMethods::ASSERT_NOT_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/refute_methods.rb#36
RuboCop::Cop::Rails::RefuteMethods::CORRECTIONS = T.let(T.unsafe(nil), Hash)

# source://rubocop-rails//lib/rubocop/cop/rails/refute_methods.rb#34
RuboCop::Cop::Rails::RefuteMethods::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/refute_methods.rb#53
RuboCop::Cop::Rails::RefuteMethods::REFUTE_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/refute_methods.rb#56
RuboCop::Cop::Rails::RefuteMethods::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks whether constant value isn't relative date.
# Because the relative date will be evaluated only once.
#
# @example
#   # bad
#   class SomeClass
#   EXPIRED_AT = 1.week.since
#   end
#
#   # good
#   class SomeClass
#   EXPIRES = 1.week
#
#   def self.expired_at
#   EXPIRES.since
#   end
#   end
#
#   # good
#   class SomeClass
#   def self.expired_at
#   1.week.since
#   end
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/relative_date_constant.rb#33
class RuboCop::Cop::Rails::RelativeDateConstant < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/relative_date_constant.rb#40
  def on_casgn(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/relative_date_constant.rb#48
  def on_masgn(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/relative_date_constant.rb#64
  def on_or_asgn(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/relative_date_constant.rb#106
  def relative_date(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/relative_date_constant.rb#102
  def relative_date_or_assignment(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/relative_date_constant.rb#72
  def autocorrect(corrector, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/relative_date_constant.rb#84
  def message(method_name); end

  # source://rubocop-rails//lib/rubocop/cop/rails/relative_date_constant.rb#92
  def nested_relative_date(node, &callback); end

  # source://rubocop-rails//lib/rubocop/cop/rails/relative_date_constant.rb#88
  def offense_range(name, value); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/relative_date_constant.rb#37
RuboCop::Cop::Rails::RelativeDateConstant::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/relative_date_constant.rb#38
RuboCop::Cop::Rails::RelativeDateConstant::RELATIVE_DATE_METHODS = T.let(T.unsafe(nil), Set)

# Looks for inline rendering within controller actions.
#
# @example
#   # bad
#   class ProductsController < ApplicationController
#   def index
#   render inline: "<% products.each do |p| %><p><%= p.name %></p><% end %>", type: :erb
#   end
#   end
#
#   # good
#   # app/views/products/index.html.erb
#   # <% products.each do |p| %>
#   #   <p><%= p.name %></p>
#   # <% end %>
#
#   class ProductsController < ApplicationController
#   def index
#   end
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/render_inline.rb#27
class RuboCop::Cop::Rails::RenderInline < ::RuboCop::Cop::Base
  # source://rubocop-rails//lib/rubocop/cop/rails/render_inline.rb#35
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/render_inline.rb#31
  def render_with_inline_option?(param0 = T.unsafe(nil)); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/render_inline.rb#28
RuboCop::Cop::Rails::RenderInline::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/render_inline.rb#29
RuboCop::Cop::Rails::RenderInline::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies places where `render text:` can be
# replaced with `render plain:`.
#
# @example
#   # bad - explicit MIME type to `text/plain`
#   render text: 'Ruby!', content_type: 'text/plain'
#
#   # good - short and precise
#   render plain: 'Ruby!'
#
#   # good - explicit MIME type not to `text/plain`
#   render text: 'Ruby!', content_type: 'text/html'
# @example ContentTypeCompatibility: true (default)
#   # good - sets MIME type to `text/html`
#   render text: 'Ruby!'
# @example ContentTypeCompatibility: false
#   # bad - sets MIME type to `text/html`
#   render text: 'Ruby!'
#
# source://rubocop-rails//lib/rubocop/cop/rails/render_plain_text.rb#27
class RuboCop::Cop::Rails::RenderPlainText < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/render_plain_text.rb#37
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/render_plain_text.rb#33
  def render_plain_text?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/render_plain_text.rb#56
  def compatible_content_type?(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/render_plain_text.rb#52
  def find_content_type(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/render_plain_text.rb#61
  def replacement(rest_options, option_value); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/render_plain_text.rb#30
RuboCop::Cop::Rails::RenderPlainText::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/render_plain_text.rb#31
RuboCop::Cop::Rails::RenderPlainText::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for consistent uses of `request.referer` or
# `request.referrer`, depending on the cop's configuration.
#
# @example EnforcedStyle: referer (default)
#   # bad
#   request.referrer
#
#   # good
#   request.referer
# @example EnforcedStyle: referrer
#   # bad
#   request.referer
#
#   # good
#   request.referrer
#
# source://rubocop-rails//lib/rubocop/cop/rails/request_referer.rb#22
class RuboCop::Cop::Rails::RequestReferer < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/request_referer.rb#33
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/request_referer.rb#29
  def referer?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/request_referer.rb#45
  def message(_range); end

  # source://rubocop-rails//lib/rubocop/cop/rails/request_referer.rb#49
  def wrong_method_name; end
end

# source://rubocop-rails//lib/rubocop/cop/rails/request_referer.rb#26
RuboCop::Cop::Rails::RequestReferer::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/request_referer.rb#27
RuboCop::Cop::Rails::RequestReferer::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the usage of `require_dependency`.
#
# `require_dependency` is an obsolete method for Rails applications running in Zeitwerk mode.
# In Zeitwerk mode, the semantics should match Ruby's and no need to be defensive with load order,
# just refer to classes and modules normally.
# If the constant name is dynamic, camelize if needed, and constantize.
#
# Applications running in Zeitwerk mode should not use `require_dependency`.
#
# NOTE: This cop is disabled by default. Please enable it if you are using Zeitwerk mode.
#
# @example
#   # bad
#   require_dependency 'some_lib'
#
# source://rubocop-rails//lib/rubocop/cop/rails/require_dependency.rb#20
class RuboCop::Cop::Rails::RequireDependency < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/require_dependency.rb#32
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/require_dependency.rb#28
  def require_dependency_call?(param0 = T.unsafe(nil)); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/require_dependency.rb#25
RuboCop::Cop::Rails::RequireDependency::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/require_dependency.rb#26
RuboCop::Cop::Rails::RequireDependency::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Prefer `response.parsed_body` to custom parsing logic for `response.body`.
#
# @example
#   # bad
#   JSON.parse(response.body)
#
#   # bad
#   Nokogiri::HTML.parse(response.body)
#
#   # bad
#   Nokogiri::HTML5.parse(response.body)
#
#   # good
#   response.parsed_body
#
# source://rubocop-rails//lib/rubocop/cop/rails/response_parsed_body.rb#26
class RuboCop::Cop::Rails::ResponseParsedBody < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/response_parsed_body.rb#35
  def json_parse_response_body?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/response_parsed_body.rb#47
  def nokogiri_html_parse_response_body(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/response_parsed_body.rb#61
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/response_parsed_body.rb#71
  def autocorrect(corrector, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/response_parsed_body.rb#75
  def check_json_parse_response_body(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/response_parsed_body.rb#86
  def check_nokogiri_html_parse_response_body(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/response_parsed_body.rb#30
RuboCop::Cop::Rails::ResponseParsedBody::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks whether the change method of the migration file is
# reversible.
#
# @example
#   # remove_index
#
#   # bad
#   def change
#   remove_index :users, name: :index_users_on_email
#   end
#
#   # good
#   def change
#   remove_index :users, :email
#   end
#
#   # good
#   def change
#   remove_index :users, column: :email
#   end
# @example
#   # drop_table
#
#   # bad
#   def change
#   drop_table :users
#   end
#
#   # good
#   def change
#   drop_table :users do |t|
#   t.string :name
#   end
#   end
# @example
#   # change_column_default
#
#   # bad
#   def change
#   change_column_default(:suppliers, :qualification, 'new')
#   end
#
#   # good
#   def change
#   change_column_default(:posts, :state, from: nil, to: "draft")
#   end
# @example
#   # remove_column
#
#   # bad
#   def change
#   remove_column(:suppliers, :qualification)
#   end
#
#   # good
#   def change
#   remove_column(:suppliers, :qualification, :string)
#   end
# @example
#   # remove_foreign_key
#
#   # bad
#   def change
#   remove_foreign_key :accounts, column: :owner_id
#   end
#
#   # good
#   def change
#   remove_foreign_key :accounts, :branches
#   end
#
#   # good
#   def change
#   remove_foreign_key :accounts, to_table: :branches
#   end
# @example
#   # change_table
#
#   # bad
#   def change
#   change_table :users do |t|
#   t.remove :name
#   t.change_default :authorized, 1
#   t.change :price, :string
#   end
#   end
#
#   # good
#   def change
#   change_table :users do |t|
#   t.string :name
#   end
#   end
# @example
#   # remove_columns
#
#   # bad
#   def change
#   remove_columns :users, :name, :email
#   end
#
#   # good
#   def change
#   reversible do |dir|
#   dir.up do
#   remove_columns :users, :name, :email
#   end
#
#   dir.down do
#   add_column :users, :name, :string
#   add_column :users, :email, :string
#   end
#   end
#   end
#
#   # good (Rails >= 6.1, see https://github.com/rails/rails/pull/36589)
#   def change
#   remove_columns :users, :name, :email, type: :string
#   end
# @example
#   # bad
#   def change
#   change_table :users do |t|
#   t.remove :name
#   end
#   end
#
#   # good
#   def change
#   change_table :users do |t|
#   t.remove :name, :string
#   end
#   end
#
#   # good
#   def change
#   create_table :users do |t|
#   t.string :name
#   end
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#153
class RuboCop::Cop::Rails::ReversibleMigration < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::MigrationsHelper

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#174
  def change_table_call(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#162
  def drop_table_call(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#158
  def irreversible_schema_statement_call(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#199
  def on_block(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#199
  def on_numblock(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#186
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#166
  def remove_column_call(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#178
  def remove_columns_call(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#170
  def remove_foreign_key_call(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#182
  def remove_index_call(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#314
  def all_hash_key?(args, *keys); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#245
  def check_change_table_node(node, block); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#275
  def check_change_table_offense(receiver, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#217
  def check_drop_table_node(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#211
  def check_irreversible_schema_statement_node(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#231
  def check_remove_column_node(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#257
  def check_remove_columns_node(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#237
  def check_remove_foreign_key_node(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#267
  def check_remove_index_node(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#225
  def check_reversible_hash_node(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#288
  def reversible_change_table_call?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#302
  def within_change_method?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#308
  def within_reversible_or_up_only_block?(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration.rb#156
RuboCop::Cop::Rails::ReversibleMigration::MSG = T.let(T.unsafe(nil), String)

# Checks whether the migration implements
# either a `change` method or both an `up` and a `down`
# method.
#
# @example
#   # bad
#   class SomeMigration < ActiveRecord::Migration[6.0]
#   def up
#   # up migration
#   end
#
#   # <----- missing down method
#   end
#
#   class SomeMigration < ActiveRecord::Migration[6.0]
#   # <----- missing up method
#
#   def down
#   # down migration
#   end
#   end
#
#   # good
#   class SomeMigration < ActiveRecord::Migration[6.0]
#   def change
#   # reversible migration
#   end
#   end
#
#   # good
#   class SomeMigration < ActiveRecord::Migration[6.0]
#   def up
#   # up migration
#   end
#
#   def down
#   # down migration
#   end
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration_method_definition.rb#45
class RuboCop::Cop::Rails::ReversibleMigrationMethodDefinition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::MigrationsHelper

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration_method_definition.rb#50
  def change_method?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration_method_definition.rb#58
  def on_class(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration_method_definition.rb#54
  def up_and_down_methods?(param0 = T.unsafe(nil)); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/reversible_migration_method_definition.rb#48
RuboCop::Cop::Rails::ReversibleMigrationMethodDefinition::MSG = T.let(T.unsafe(nil), String)

# Use a single `#join` instead of chaining on `Rails.root` or `Rails.public_path`.
#
# @example
#   # bad
#   Rails.root.join('db').join('schema.rb')
#   Rails.root.join('db').join(migrate).join('migration.rb')
#   Rails.public_path.join('path').join('file.pdf')
#   Rails.public_path.join('path').join(to).join('file.pdf')
#
#   # good
#   Rails.root.join('db', 'schema.rb')
#   Rails.root.join('db', migrate, 'migration.rb')
#   Rails.public_path.join('path', 'file.pdf')
#   Rails.public_path.join('path', to, 'file.pdf')
#
# source://rubocop-rails//lib/rubocop/cop/rails/root_join_chain.rb#21
class RuboCop::Cop::Rails::RootJoinChain < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/root_join_chain.rb#35
  def join?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/root_join_chain.rb#39
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/root_join_chain.rb#30
  def rails_root?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/root_join_chain.rb#52
  def evidence(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/root_join_chain.rb#25
RuboCop::Cop::Rails::RootJoinChain::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/root_join_chain.rb#27
RuboCop::Cop::Rails::RootJoinChain::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Set)

# Use `Rails.root` IO methods instead of passing it to `File`.
#
# `Rails.root` is an instance of `Pathname`
# so we can apply many IO methods directly.
#
# This cop works best when used together with
# `Style/FileRead`, `Style/FileWrite` and `Rails/RootJoinChain`.
#
# @example
#   # bad
#   File.open(Rails.root.join('db', 'schema.rb'))
#   File.open(Rails.root.join('db', 'schema.rb'), 'w')
#   File.read(Rails.root.join('db', 'schema.rb'))
#   File.binread(Rails.root.join('db', 'schema.rb'))
#   File.write(Rails.root.join('db', 'schema.rb'), content)
#   File.binwrite(Rails.root.join('db', 'schema.rb'), content)
#
#   # good
#   Rails.root.join('db', 'schema.rb').open
#   Rails.root.join('db', 'schema.rb').open('w')
#   Rails.root.join('db', 'schema.rb').read
#   Rails.root.join('db', 'schema.rb').binread
#   Rails.root.join('db', 'schema.rb').write(content)
#   Rails.root.join('db', 'schema.rb').binwrite(content)
#
# source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#35
class RuboCop::Cop::Rails::RootPathnameMethods < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#172
  def dir_glob?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#189
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#163
  def pathname_method_for_ruby_2_4_or_lower(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#153
  def pathname_method_for_ruby_2_5_or_higher(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#185
  def rails_root?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#177
  def rails_root_pathname?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#220
  def build_path_glob_replacement(path, method); end

  # source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#228
  def build_path_replacement(path, method, args); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#262
  def enforce_double_quotes?; end

  # @yield [method, path, args, rails_root]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#205
  def evidence(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#240
  def include_interpolation?(arguments); end

  # source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#246
  def join_arguments(arguments); end

  # source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#212
  def pathname_method(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#266
  def string_literals_config; end
end

# source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#41
RuboCop::Cop::Rails::RootPathnameMethods::DIR_GLOB_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#56
RuboCop::Cop::Rails::RootPathnameMethods::DIR_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#43
RuboCop::Cop::Rails::RootPathnameMethods::DIR_NON_GLOB_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#58
RuboCop::Cop::Rails::RootPathnameMethods::FILE_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#120
RuboCop::Cop::Rails::RootPathnameMethods::FILE_TEST_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#148
RuboCop::Cop::Rails::RootPathnameMethods::FILE_UTILS_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#39
RuboCop::Cop::Rails::RootPathnameMethods::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/root_pathname_methods.rb#150
RuboCop::Cop::Rails::RootPathnameMethods::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Set)

# Favor `Rails.public_path` over `Rails.root` with `'public'`
#
# @example
#   # bad
#   Rails.root.join('public')
#   Rails.root.join('public/file.pdf')
#   Rails.root.join('public', 'file.pdf')
#
#   # good
#   Rails.public_path
#   Rails.public_path.join('file.pdf')
#   Rails.public_path.join('file.pdf')
#
# source://rubocop-rails//lib/rubocop/cop/rails/root_public_path.rb#19
class RuboCop::Cop::Rails::RootPublicPath < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/root_public_path.rb#35
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/root_public_path.rb#28
  def rails_root_public(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/root_public_path.rb#53
  def public_path?(string); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/root_public_path.rb#22
RuboCop::Cop::Rails::RootPublicPath::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/root_public_path.rb#26
RuboCop::Cop::Rails::RootPublicPath::PATTERN = T.let(T.unsafe(nil), Regexp)

# source://rubocop-rails//lib/rubocop/cop/rails/root_public_path.rb#24
RuboCop::Cop::Rails::RootPublicPath::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Set)

# Converts usages of `try!` to `&.`. It can also be configured
# to convert `try`. It will convert code to use safe navigation
# if the target Ruby version is set to 2.3+
#
# @example ConvertTry: false (default)
#   # bad
#   foo.try!(:bar)
#   foo.try!(:bar, baz)
#   foo.try!(:bar) { |e| e.baz }
#
#   foo.try!(:[], 0)
#
#   # good
#   foo.try(:bar)
#   foo.try(:bar, baz)
#   foo.try(:bar) { |e| e.baz }
#
#   foo&.bar
#   foo&.bar(baz)
#   foo&.bar { |e| e.baz }
# @example ConvertTry: true
#   # bad
#   foo.try!(:bar)
#   foo.try!(:bar, baz)
#   foo.try!(:bar) { |e| e.baz }
#   foo.try(:bar)
#   foo.try(:bar, baz)
#   foo.try(:bar) { |e| e.baz }
#
#   # good
#   foo&.bar
#   foo&.bar(baz)
#   foo&.bar { |e| e.baz }
#
# source://rubocop-rails//lib/rubocop/cop/rails/safe_navigation.rb#40
class RuboCop::Cop::Rails::SafeNavigation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/safe_navigation.rb#58
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/safe_navigation.rb#50
  def try_call(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/safe_navigation.rb#71
  def autocorrect(corrector, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/safe_navigation.rb#85
  def replacement(method, params); end

  class << self
    # source://rubocop-rails//lib/rubocop/cop/rails/safe_navigation.rb#54
    def autocorrect_incompatible_with; end
  end
end

# source://rubocop-rails//lib/rubocop/cop/rails/safe_navigation.rb#47
RuboCop::Cop::Rails::SafeNavigation::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/safe_navigation.rb#48
RuboCop::Cop::Rails::SafeNavigation::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks to make sure safe navigation isn't used with `blank?` in
# a conditional.
#
# @example
#   # bad
#   do_something if foo&.blank?
#   do_something unless foo&.blank?
#
#   # good
#   do_something if foo.blank?
#   do_something unless foo.blank?
#
# source://rubocop-rails//lib/rubocop/cop/rails/safe_navigation_with_blank.rb#31
class RuboCop::Cop::Rails::SafeNavigationWithBlank < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/safe_navigation_with_blank.rb#40
  def on_if(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/safe_navigation_with_blank.rb#36
  def safe_navigation_blank_in_conditional?(param0 = T.unsafe(nil)); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/safe_navigation_with_blank.rb#34
RuboCop::Cop::Rails::SafeNavigationWithBlank::MSG = T.let(T.unsafe(nil), String)

# Identifies possible cases where Active Record save! or related
# should be used instead of save because the model might have failed to
# save and an exception is better than unhandled failure.
#
# This will allow:
#
# * update or save calls, assigned to a variable,
#   or used as a condition in an if/unless/case statement.
# * create calls, assigned to a variable that then has a
#   call to `persisted?`, or whose return value is checked by
#   `persisted?` immediately
# * calls if the result is explicitly returned from methods and blocks,
#   or provided as arguments.
# * calls whose signature doesn't look like an ActiveRecord
#   persistence method.
#
# By default it will also allow implicit returns from methods and blocks.
# that behavior can be turned off with `AllowImplicitReturn: false`.
#
# You can permit receivers that are giving false positives with
# `AllowedReceivers: []`
#
# @example
#
#   # bad
#   user.save
#   user.update(name: 'Joe')
#   user.find_or_create_by(name: 'Joe')
#   user.destroy
#
#   # good
#   unless user.save
#   # ...
#   end
#   user.save!
#   user.update!(name: 'Joe')
#   user.find_or_create_by!(name: 'Joe')
#   user.destroy!
#
#   user = User.find_or_create_by(name: 'Joe')
#   unless user.persisted?
#   # ...
#   end
#
#   def save_user
#   return user.save
#   end
# @example AllowImplicitReturn: true (default)
#
#   # good
#   users.each { |u| u.save }
#
#   def save_user
#   user.save
#   end
# @example AllowImplicitReturn: false
#
#   # bad
#   users.each { |u| u.save }
#   def save_user
#   user.save
#   end
#
#   # good
#   users.each { |u| u.save! }
#
#   def save_user
#   user.save!
#   end
#
#   def save_user
#   return user.save
#   end
# @example AllowedReceivers: ['merchant.customers', 'Service::Mailer']
#
#   # bad
#   merchant.create
#   customers.builder.save
#   Mailer.create
#
#   module Service::Mailer
#   self.create
#   end
#
#   # good
#   merchant.customers.create
#   MerchantService.merchant.customers.destroy
#   Service::Mailer.update(message: 'Message')
#   ::Service::Mailer.update
#   Services::Service::Mailer.update(message: 'Message')
#   Service::Mailer::update
#
# source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#120
class RuboCop::Cop::Rails::SaveBang < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::NegativeConditional
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#136
  def after_leaving_scope(scope, _variable_table); end

  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#144
  def check_assignment(assignment); end

  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#155
  def on_csend(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#155
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#261
  def allowed_receiver?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#319
  def argument?(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#221
  def array_parent(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#202
  def assignable_node(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#198
  def call_to_persisted?(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#228
  def check_used_in_condition_or_compound_boolean(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#257
  def checked_immediately?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#248
  def conditional?(parent); end

  # Const == Const
  # ::Const == ::Const
  # ::Const == Const
  # Const == ::Const
  # NameSpace::Const == Const
  # NameSpace::Const == NameSpace::Const
  # NameSpace::Const != ::Const
  # Const != NameSpace::Const
  #
  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#294
  def const_matches?(const, allowed_const); end

  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#252
  def deparenthesize(node); end

  # Check argument signature as no arguments or one hash
  #
  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#338
  def expected_signature?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#323
  def explicit_return?(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#311
  def find_method_with_sibling_index(node, sibling_index = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#211
  def hash_parent(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#301
  def implicit_return?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#236
  def in_condition_or_compound_boolean?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#244
  def operator_or_single_negative?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#333
  def persist_method?(node, methods = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#190
  def persisted_referenced?(assignment); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#271
  def receiver_chain_matches?(node, allowed_receiver); end

  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#171
  def register_offense(node, msg); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#328
  def return_value_assigned?(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#182
  def right_assignment_node(assignment); end

  class << self
    # source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#132
    def joining_forces; end
  end
end

# source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#126
RuboCop::Cop::Rails::SaveBang::CREATE_CONDITIONAL_MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#125
RuboCop::Cop::Rails::SaveBang::CREATE_MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#128
RuboCop::Cop::Rails::SaveBang::CREATE_PERSIST_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#129
RuboCop::Cop::Rails::SaveBang::MODIFY_PERSIST_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#124
RuboCop::Cop::Rails::SaveBang::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/save_bang.rb#130
RuboCop::Cop::Rails::SaveBang::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of the `comment` option when adding a new table or column
# to the database during a migration.
#
# @example
#   # bad (no comment for a new column or table)
#   add_column :table, :column, :integer
#
#   create_table :table do |t|
#   t.type :column
#   end
#
#   # good
#   add_column :table, :column, :integer, comment: 'Number of offenses'
#
#   create_table :table, comment: 'Table of offenses data' do |t|
#   t.type :column, comment: 'Number of offenses'
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/schema_comment.rb#24
class RuboCop::Cop::Rails::SchemaComment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ActiveRecordMigrationsHelper

  # source://rubocop-rails//lib/rubocop/cop/rails/schema_comment.rb#45
  def add_column?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/schema_comment.rb#50
  def add_column_with_comment?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/schema_comment.rb#40
  def comment_present?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/schema_comment.rb#55
  def create_table?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/schema_comment.rb#60
  def create_table_with_comment?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/schema_comment.rb#74
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/schema_comment.rb#65
  def t_column?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/schema_comment.rb#70
  def t_column_with_comment?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/schema_comment.rb#96
  def add_column_without_comment?(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/schema_comment.rb#86
  def check_column_within_create_table_block(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/schema_comment.rb#100
  def create_table_without_comment?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/schema_comment.rb#104
  def t_column_without_comment?(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/schema_comment.rb#27
RuboCop::Cop::Rails::SchemaComment::COLUMN_MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/schema_comment.rb#30
RuboCop::Cop::Rails::SchemaComment::CREATE_TABLE_COLUMN_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-rails//lib/rubocop/cop/rails/schema_comment.rb#29
RuboCop::Cop::Rails::SchemaComment::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/schema_comment.rb#28
RuboCop::Cop::Rails::SchemaComment::TABLE_MSG = T.let(T.unsafe(nil), String)

# Checks for scope calls where it was passed
# a method (usually a scope) instead of a lambda/proc.
#
# @example
#
#   # bad
#   scope :something, where(something: true)
#
#   # good
#   scope :something, -> { where(something: true) }
#
# source://rubocop-rails//lib/rubocop/cop/rails/scope_args.rb#16
class RuboCop::Cop::Rails::ScopeArgs < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/scope_args.rb#24
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/scope_args.rb#22
  def scope?(param0 = T.unsafe(nil)); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/scope_args.rb#19
RuboCop::Cop::Rails::ScopeArgs::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/scope_args.rb#20
RuboCop::Cop::Rails::ScopeArgs::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for uses of `select(:column_name)` with `map(&:column_name)`.
# These can be replaced with `pluck(:column_name)`.
#
# There also should be some performance improvement since it skips instantiating the model class for matches.
#
# @example
#   # bad
#   Model.select(:column_name).map(&:column_name)
#
#   # good
#   Model.pluck(:column_name)
#
# source://rubocop-rails//lib/rubocop/cop/rails/select_map.rb#22
class RuboCop::Cop::Rails::SelectMap < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/select_map.rb#29
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/select_map.rb#55
  def autocorrect(corrector, select_node, node, preferred_method); end

  # source://rubocop-rails//lib/rubocop/cop/rails/select_map.rb#46
  def find_select_node(node, column_name); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/select_map.rb#62
  def match_column_name?(select_candidate, column_name); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/select_map.rb#25
RuboCop::Cop::Rails::SelectMap::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/select_map.rb#27
RuboCop::Cop::Rails::SelectMap::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces that short forms of `I18n` methods are used:
# `t` instead of `translate` and `l` instead of `localize`.
#
# This cop has two different enforcement modes. When the EnforcedStyle
# is conservative (the default) then only `I18n.translate` and `I18n.localize`
# calls are added as offenses.
#
# When the EnforcedStyle is aggressive then all `translate` and `localize` calls
# without a receiver are added as offenses.
#
# @example
#   # bad
#   I18n.translate :key
#   I18n.localize Time.now
#
#   # good
#   I18n.t :key
#   I18n.l Time.now
# @example EnforcedStyle: conservative (default)
#   # good
#   translate :key
#   localize Time.now
#   t :key
#   l Time.now
# @example EnforcedStyle: aggressive
#   # bad
#   translate :key
#   localize Time.now
#
#   # good
#   t :key
#   l Time.now
#
# source://rubocop-rails//lib/rubocop/cop/rails/short_i18n.rb#41
class RuboCop::Cop::Rails::ShortI18n < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/short_i18n.rb#51
  def long_i18n?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/short_i18n.rb#55
  def on_send(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/short_i18n.rb#45
RuboCop::Cop::Rails::ShortI18n::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/short_i18n.rb#47
RuboCop::Cop::Rails::ShortI18n::PREFERRED_METHODS = T.let(T.unsafe(nil), Hash)

# source://rubocop-rails//lib/rubocop/cop/rails/short_i18n.rb#49
RuboCop::Cop::Rails::ShortI18n::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the use of methods which skip
# validations which are listed in
# https://guides.rubyonrails.org/active_record_validations.html#skipping-validations
#
# Methods may be ignored from this rule by configuring a `AllowedMethods`.
#
# @example
#   # bad
#   Article.first.decrement!(:view_count)
#   DiscussionBoard.decrement_counter(:post_count, 5)
#   Article.first.increment!(:view_count)
#   DiscussionBoard.increment_counter(:post_count, 5)
#   person.toggle :active
#   product.touch
#   Billing.update_all("category = 'authorized', author = 'David'")
#   user.update_attribute(:website, 'example.com')
#   user.update_columns(last_request_at: Time.current)
#   Post.update_counters 5, comment_count: -1, action_count: 1
#
#   # good
#   user.update(website: 'example.com')
#   FileUtils.touch('file')
# @example AllowedMethods: ["touch"]
#   # bad
#   DiscussionBoard.decrement_counter(:post_count, 5)
#   DiscussionBoard.increment_counter(:post_count, 5)
#   person.toggle :active
#
#   # good
#   user.touch
#
# source://rubocop-rails//lib/rubocop/cop/rails/skips_model_validations.rb#38
class RuboCop::Cop::Rails::SkipsModelValidations < ::RuboCop::Cop::Base
  # @return [SkipsModelValidations] a new instance of SkipsModelValidations
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/skips_model_validations.rb#83
  def initialize(*_arg0); end

  # source://rubocop-rails//lib/rubocop/cop/rails/skips_model_validations.rb#65
  def good_insert?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/skips_model_validations.rb#58
  def good_touch?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/skips_model_validations.rb#72
  def on_csend(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/skips_model_validations.rb#72
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/skips_model_validations.rb#95
  def allowed_method?(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/skips_model_validations.rb#110
  def allowed_methods; end

  # source://rubocop-rails//lib/rubocop/cop/rails/skips_model_validations.rb#99
  def forbidden_methods; end

  # source://rubocop-rails//lib/rubocop/cop/rails/skips_model_validations.rb#91
  def message(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/skips_model_validations.rb#41
RuboCop::Cop::Rails::SkipsModelValidations::METHODS_WITH_ARGUMENTS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/skips_model_validations.rb#39
RuboCop::Cop::Rails::SkipsModelValidations::MSG = T.let(T.unsafe(nil), String)

# Checks SQL heredocs to use `.squish`.
#
# @example
#   # bad
#   <<-SQL
#   SELECT * FROM posts;
#   SQL
#
#   <<-SQL
#   SELECT * FROM posts
#   WHERE id = 1
#   SQL
#
#   execute(<<~SQL, "Post Load")
#   SELECT * FROM posts
#   WHERE post_id = 1
#   SQL
#
#   # good
#   <<-SQL.squish
#   SELECT * FROM posts;
#   SQL
#
#   <<~SQL.squish
#   SELECT * FROM table
#   WHERE id = 1
#   SQL
#
#   execute(<<~SQL.squish, "Post Load")
#   SELECT * FROM posts
#   WHERE post_id = 1
#   SQL
#
# source://rubocop-rails//lib/rubocop/cop/rails/squished_sql_heredocs.rb#43
class RuboCop::Cop::Rails::SquishedSQLHeredocs < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Heredoc
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/squished_sql_heredocs.rb#52
  def on_heredoc(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/squished_sql_heredocs.rb#80
  def message(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/squished_sql_heredocs.rb#62
  def offense_detected?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/squished_sql_heredocs.rb#74
  def singleline_comments_present?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/squished_sql_heredocs.rb#66
  def sql_heredoc?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/squished_sql_heredocs.rb#70
  def using_squish?(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/squished_sql_heredocs.rb#49
RuboCop::Cop::Rails::SquishedSQLHeredocs::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/squished_sql_heredocs.rb#47
RuboCop::Cop::Rails::SquishedSQLHeredocs::SQL = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/squished_sql_heredocs.rb#50
RuboCop::Cop::Rails::SquishedSQLHeredocs::SQL_IDENTIFIER_MARKERS = T.let(T.unsafe(nil), Regexp)

# source://rubocop-rails//lib/rubocop/cop/rails/squished_sql_heredocs.rb#48
RuboCop::Cop::Rails::SquishedSQLHeredocs::SQUISH = T.let(T.unsafe(nil), String)

# Enforces the use of squiggly heredoc over `strip_heredoc`.
#
# @example
#
#   # bad
#   <<EOS.strip_heredoc
#   some text
#   EOS
#
#   # bad
#   <<-EOS.strip_heredoc
#   some text
#   EOS
#
#   # good
#   <<~EOS
#   some text
#   EOS
#
# source://rubocop-rails//lib/rubocop/cop/rails/strip_heredoc.rb#25
class RuboCop::Cop::Rails::StripHeredoc < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/strip_heredoc.rb#34
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/strip_heredoc.rb#44
  def register_offense(node, heredoc); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/strip_heredoc.rb#29
RuboCop::Cop::Rails::StripHeredoc::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/strip_heredoc.rb#30
RuboCop::Cop::Rails::StripHeredoc::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the absence of explicit table name assignment.
#
# `self.table_name=` should only be used for very good reasons,
# such as not having control over the database, or working
# on a legacy project.
#
# If you need to change how your model's name is translated to
# a table name, you may want to look at Inflections:
# https://api.rubyonrails.org/classes/ActiveSupport/Inflector/Inflections.html
#
# If you wish to add a prefix in front of your model, or wish to change
# the default prefix, `self.table_name_prefix` might better suit your needs:
# https://api.rubyonrails.org/classes/ActiveRecord/ModelSchema.html#method-c-table_name_prefix-3D
#
# STI base classes named `Base` are ignored by this cop.
# For more information: https://api.rubyonrails.org/classes/ActiveRecord/Inheritance.html
#
# @example
#   # bad
#   self.table_name = 'some_table_name'
#   self.table_name = :some_other_name
#
# source://rubocop-rails//lib/rubocop/cop/rails/table_name_assignment.rb#27
class RuboCop::Cop::Rails::TableNameAssignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ActiveRecordHelper

  # source://rubocop-rails//lib/rubocop/cop/rails/table_name_assignment.rb#32
  def base_class?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/table_name_assignment.rb#36
  def on_class(class_node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/table_name_assignment.rb#30
RuboCop::Cop::Rails::TableNameAssignment::MSG = T.let(T.unsafe(nil), String)

# Enforces that boolean columns are created with default values (`false` or `true`) and
# `NOT NULL` constraint.
#
# @example
#   # bad
#   add_column :users, :active, :boolean
#   t.column :active, :boolean
#   t.boolean :active
#
#   # good
#   add_column :users, :active, :boolean, default: true, null: false
#   t.column :active, :boolean, default: true, null: false
#   t.boolean :active, default: true, null: false
#
# source://rubocop-rails//lib/rubocop/cop/rails/three_state_boolean_column.rb#20
class RuboCop::Cop::Rails::ThreeStateBooleanColumn < ::RuboCop::Cop::Base
  # source://rubocop-rails//lib/rubocop/cop/rails/three_state_boolean_column.rb#37
  def change_column_null?(param0, param1, param2); end

  # source://rubocop-rails//lib/rubocop/cop/rails/three_state_boolean_column.rb#41
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/three_state_boolean_column.rb#33
  def required_options?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/three_state_boolean_column.rb#25
  def three_state_boolean?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/three_state_boolean_column.rb#57
  def table_node(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/three_state_boolean_column.rb#21
RuboCop::Cop::Rails::ThreeStateBooleanColumn::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/three_state_boolean_column.rb#23
RuboCop::Cop::Rails::ThreeStateBooleanColumn::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the use of Time methods without zone.
#
# Built on top of Ruby on Rails style guide (https://rails.rubystyle.guide#time)
# and the article http://danilenko.org/2012/7/6/rails_timezones/
#
# Two styles are supported for this cop. When `EnforcedStyle` is 'strict'
# then only use of `Time.zone` is allowed.
#
# When EnforcedStyle is 'flexible' then it's also allowed
# to use `Time#in_time_zone`.
#
# @example
#   # bad
#   Time.now
#   Time.parse('2015-03-02T19:05:37')
#   '2015-03-02T19:05:37'.to_time
#
#   # good
#   Time.current
#   Time.zone.now
#   Time.zone.parse('2015-03-02T19:05:37')
#   Time.zone.parse('2015-03-02T19:05:37Z') # Respect ISO 8601 format with timezone specifier.
# @example EnforcedStyle: flexible (default)
#   # `flexible` allows usage of `in_time_zone` instead of `zone`.
#
#   # good
#   Time.at(timestamp).in_time_zone
# @example EnforcedStyle: strict
#   # `strict` means that `Time` should be used with `zone`.
#
#   # bad
#   Time.at(timestamp).in_time_zone
#
# source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#43
class RuboCop::Cop::Rails::TimeZone < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#59
  def on_const(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#68
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#228
  def acceptable_methods(klass, method_name, node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#135
  def attach_timezone_specifier?(date); end

  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#78
  def autocorrect(corrector, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#95
  def autocorrect_time_new(node, corrector); end

  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#139
  def build_message(klass, method_name, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#188
  def check_localtime(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#117
  def check_time_node(klass, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#152
  def extract_method_chain(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#212
  def flexible?; end

  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#220
  def good_methods; end

  # Only add the method to the chain if the method being
  # called is part of the time class.
  #
  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#163
  def method_from_time_class?(node); end

  # checks that parent node of send_type
  # and receiver is the given node
  #
  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#174
  def method_send?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#208
  def need_check_localtime?(chain); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#204
  def not_danger_chain?(chain); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#251
  def offset_option_provided?(node); end

  # Time.new, Time.at, and Time.now can be called with a time zone offset
  # When it is, that should be considered safe
  # Example:
  # Time.new(1988, 3, 15, 3, 0, 0, "-05:00")
  #
  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#242
  def offset_provided?(node); end

  # remove redundant `.in_time_zone` from `Time.zone.now.in_time_zone`
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#104
  def remove_redundant_in_time_zone(corrector, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#180
  def safe_method(method_name, node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#216
  def strict?; end
end

# source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#54
RuboCop::Cop::Rails::TimeZone::ACCEPTED_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#53
RuboCop::Cop::Rails::TimeZone::DANGEROUS_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#52
RuboCop::Cop::Rails::TimeZone::GOOD_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#47
RuboCop::Cop::Rails::TimeZone::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#48
RuboCop::Cop::Rails::TimeZone::MSG_ACCEPTABLE = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#49
RuboCop::Cop::Rails::TimeZone::MSG_LOCALTIME = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#50
RuboCop::Cop::Rails::TimeZone::MSG_STRING_TO_TIME = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#57
RuboCop::Cop::Rails::TimeZone::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/time_zone.rb#55
RuboCop::Cop::Rails::TimeZone::TIMEZONE_SPECIFIER = T.let(T.unsafe(nil), Regexp)

# Checks for the use of `Time.zone=` method.
#
# The `zone` attribute persists for the rest of the Ruby runtime, potentially causing
# unexpected behavior at a later time.
# Using `Time.use_zone` ensures the code passed in the block is the only place Time.zone is affected.
# It eliminates the possibility of a `zone` sticking around longer than intended.
#
# @example
#   # bad
#   Time.zone = 'EST'
#
#   # good
#   Time.use_zone('EST') do
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/time_zone_assignment.rb#21
class RuboCop::Cop::Rails::TimeZoneAssignment < ::RuboCop::Cop::Base
  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone_assignment.rb#29
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/time_zone_assignment.rb#25
  def time_zone_assignment?(param0 = T.unsafe(nil)); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/time_zone_assignment.rb#22
RuboCop::Cop::Rails::TimeZoneAssignment::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/time_zone_assignment.rb#23
RuboCop::Cop::Rails::TimeZoneAssignment::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for consistent uses of `to_fs` or `to_formatted_s`,
# depending on the cop's configuration.
#
# @example EnforcedStyle: to_fs (default)
#
#   # bad
#   time.to_formatted_s(:db)
#
#   # good
#   time.to_fs(:db)
# @example EnforcedStyle: to_formatted_s
#
#   # bad
#   time.to_fs(:db)
#
#   # good
#   time.to_formatted_s(:db)
#
# source://rubocop-rails//lib/rubocop/cop/rails/to_formatted_s.rb#25
class RuboCop::Cop::Rails::ToFormattedS < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/to_formatted_s.rb#35
  def on_csend(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/to_formatted_s.rb#35
  def on_send(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/to_formatted_s.rb#32
RuboCop::Cop::Rails::ToFormattedS::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/to_formatted_s.rb#33
RuboCop::Cop::Rails::ToFormattedS::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies passing any argument to `#to_s`.
#
# @example
#
#   # bad
#   obj.to_s(:delimited)
#
#   # good
#   obj.to_formatted_s(:delimited)
#
# source://rubocop-rails//lib/rubocop/cop/rails/to_s_with_argument.rb#20
class RuboCop::Cop::Rails::ToSWithArgument < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/to_s_with_argument.rb#61
  def on_csend(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/to_s_with_argument.rb#61
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/to_s_with_argument.rb#72
  def rails_extended_to_s?(node); end
end

# These types are defined by the following files in ActiveSupport:
#   lib/active_support/core_ext/array/conversions.rb
#   lib/active_support/core_ext/date/conversions.rb
#   lib/active_support/core_ext/date_time/conversions.rb
#   lib/active_support/core_ext/numeric/conversions.rb
#   lib/active_support/core_ext/range/conversions.rb
#   lib/active_support/core_ext/time/conversions.rb
#   lib/active_support/time_with_zone.rb
#
# source://rubocop-rails//lib/rubocop/cop/rails/to_s_with_argument.rb#32
RuboCop::Cop::Rails::ToSWithArgument::EXTENDED_FORMAT_TYPES = T.let(T.unsafe(nil), Set)

# source://rubocop-rails//lib/rubocop/cop/rails/to_s_with_argument.rb#55
RuboCop::Cop::Rails::ToSWithArgument::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/to_s_with_argument.rb#57
RuboCop::Cop::Rails::ToSWithArgument::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies top-level `HashWithIndifferentAccess`.
# This has been soft-deprecated since Rails 5.1.
#
# @example
#   # bad
#   HashWithIndifferentAccess.new(foo: 'bar')
#
#   # good
#   ActiveSupport::HashWithIndifferentAccess.new(foo: 'bar')
#
# source://rubocop-rails//lib/rubocop/cop/rails/top_level_hash_with_indifferent_access.rb#16
class RuboCop::Cop::Rails::TopLevelHashWithIndifferentAccess < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # @param node [RuboCop::AST::ConstNode]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/top_level_hash_with_indifferent_access.rb#32
  def on_const(node); end

  # @param node [RuboCop::AST::ConstNode]
  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/top_level_hash_with_indifferent_access.rb#27
  def top_level_hash_with_indifferent_access?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/top_level_hash_with_indifferent_access.rb#43
  def autocorrect(corrector, node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/top_level_hash_with_indifferent_access.rb#22
RuboCop::Cop::Rails::TopLevelHashWithIndifferentAccess::MSG = T.let(T.unsafe(nil), String)

# Checks for the use of exit statements (namely `return`,
# `break` and `throw`) in transactions. This is due to the eventual
# unexpected behavior when using ActiveRecord >= 7, where transactions
# exited using these statements are being rollbacked rather than
# committed (pre ActiveRecord 7 behavior).
#
# As alternatives, it would be more intuitive to explicitly raise an
# error when rollback is desired, and to use `next` when commit is
# desired.
#
# If you are defining custom transaction methods, you can configure it with `TransactionMethods`.
#
# @example
#   # bad
#   ApplicationRecord.transaction do
#   return if user.active?
#   end
#
#   # bad
#   ApplicationRecord.transaction do
#   break if user.active?
#   end
#
#   # bad
#   ApplicationRecord.transaction do
#   throw if user.active?
#   end
#
#   # bad, as `with_lock` implicitly opens a transaction too
#   user.with_lock do
#   throw if user.active?
#   end
#
#   # bad, as `with_lock` implicitly opens a transaction too
#   ApplicationRecord.with_lock do
#   break if user.active?
#   end
#
#   # good
#   ApplicationRecord.transaction do
#   # Rollback
#   raise "User is active" if user.active?
#   end
#
#   # good
#   ApplicationRecord.transaction do
#   # Commit
#   next if user.active?
#   end
# @example TransactionMethods: ["custom_transaction"]
#   # bad
#   CustomModel.custom_transaction do
#   return if user.active?
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/transaction_exit_statement.rb#62
class RuboCop::Cop::Rails::TransactionExitStatement < ::RuboCop::Cop::Base
  # source://rubocop-rails//lib/rubocop/cop/rails/transaction_exit_statement.rb#66
  def exit_statements(param0); end

  # source://rubocop-rails//lib/rubocop/cop/rails/transaction_exit_statement.rb#78
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/transaction_exit_statement.rb#70
  def rescue_body_return_node?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/transaction_exit_statement.rb#93
  def in_transaction_block?(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/transaction_exit_statement.rb#110
  def nested_block?(statement_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/transaction_exit_statement.rb#100
  def statement(statement_node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/transaction_exit_statement.rb#119
  def transaction_method?(method_name); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/transaction_exit_statement.rb#115
  def transaction_method_name?(method_name); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/transaction_exit_statement.rb#64
RuboCop::Cop::Rails::TransactionExitStatement::BUILT_IN_TRANSACTION_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/transaction_exit_statement.rb#63
RuboCop::Cop::Rails::TransactionExitStatement::MSG = T.let(T.unsafe(nil), String)

# Prefer using `distinct` before `pluck` instead of `uniq` after `pluck`.
#
# The use of distinct before pluck is preferred because it executes by
# the database.
#
# This cop has two different enforcement modes. When the EnforcedStyle
# is `conservative` (the default), then only calls to `pluck` on a constant
# (i.e. a model class) before `uniq` are added as offenses.
#
# When the EnforcedStyle is `aggressive` then all calls to `pluck` before
# distinct are added as offenses. This may lead to false positives
# as the cop cannot distinguish between calls to `pluck` on an
# ActiveRecord::Relation vs a call to pluck on an
# ActiveRecord::Associations::CollectionProxy.
#
# @example EnforcedStyle: conservative (default)
#   # bad - redundantly fetches duplicate values
#   Album.pluck(:band_name).uniq
#
#   # good
#   Album.distinct.pluck(:band_name)
# @example EnforcedStyle: aggressive
#   # bad - redundantly fetches duplicate values
#   Album.pluck(:band_name).uniq
#
#   # bad - redundantly fetches duplicate values
#   Album.where(year: 1985).pluck(:band_name).uniq
#
#   # bad - redundantly fetches duplicate values
#   customer.favourites.pluck(:color).uniq
#
#   # good
#   Album.distinct.pluck(:band_name)
#   Album.distinct.where(year: 1985).pluck(:band_name)
#   customer.favourites.distinct.pluck(:color)
#
# source://rubocop-rails//lib/rubocop/cop/rails/uniq_before_pluck.rb#47
class RuboCop::Cop::Rails::UniqBeforePluck < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/uniq_before_pluck.rb#59
  def aggressive_node_match(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/uniq_before_pluck.rb#57
  def conservative_node_match(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/uniq_before_pluck.rb#61
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/uniq_before_pluck.rb#84
  def dot_method_begin_pos(method, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/uniq_before_pluck.rb#80
  def dot_method_with_whitespace(method, node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/uniq_before_pluck.rb#52
RuboCop::Cop::Rails::UniqBeforePluck::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/uniq_before_pluck.rb#54
RuboCop::Cop::Rails::UniqBeforePluck::NEWLINE = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/uniq_before_pluck.rb#55
RuboCop::Cop::Rails::UniqBeforePluck::PATTERN = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/uniq_before_pluck.rb#53
RuboCop::Cop::Rails::UniqBeforePluck::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# When you define a uniqueness validation in Active Record model,
# you also should add a unique index for the column. There are two reasons.
# First, duplicated records may occur even if Active Record's validation
# is defined.
# Second, it will cause slow queries. The validation executes a `SELECT`
# statement with the target column when inserting/updating a record.
# If the column does not have an index and the table is large,
# the query will be heavy.
#
# Note that the cop does nothing if db/schema.rb does not exist.
#
# @example
#   # bad - if the schema does not have a unique index
#   validates :account, uniqueness: true
#
#   # good - if the schema has a unique index
#   validates :account, uniqueness: true
#
#   # good - even if the schema does not have a unique index
#   validates :account, length: { minimum: MIN_LENGTH }
#
# source://rubocop-rails//lib/rubocop/cop/rails/unique_validation_without_index.rb#27
class RuboCop::Cop::Rails::UniqueValidationWithoutIndex < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ActiveRecordHelper

  # source://rubocop-rails//lib/rubocop/cop/rails/unique_validation_without_index.rb#33
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/unique_validation_without_index.rb#155
  def array_node_to_array(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/unique_validation_without_index.rb#122
  def class_node(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/unique_validation_without_index.rb#74
  def column_names(node, uniqueness_part); end

  # source://rubocop-rails//lib/rubocop/cop/rails/unique_validation_without_index.rb#93
  def column_names_from_scope(uniqueness_part); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/unique_validation_without_index.rb#146
  def condition_hash_part?(pairs, keys:); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/unique_validation_without_index.rb#137
  def condition_part?(node, uniqueness_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/unique_validation_without_index.rb#47
  def find_schema_information(node, uniqueness_part); end

  # source://rubocop-rails//lib/rubocop/cop/rails/unique_validation_without_index.rb#109
  def find_scope(pairs); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/unique_validation_without_index.rb#66
  def include_column_names_in_expression_index?(index, column_names); end

  # source://rubocop-rails//lib/rubocop/cop/rails/unique_validation_without_index.rb#118
  def unfreeze_scope(scope); end

  # source://rubocop-rails//lib/rubocop/cop/rails/unique_validation_without_index.rb#126
  def uniqueness_part(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/unique_validation_without_index.rb#57
  def with_index?(klass, table, names); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/unique_validation_without_index.rb#30
RuboCop::Cop::Rails::UniqueValidationWithoutIndex::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/unique_validation_without_index.rb#31
RuboCop::Cop::Rails::UniqueValidationWithoutIndex::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks that environments called with `Rails.env` predicates
# exist.
# By default the cop allows three environments which Rails ships with:
# `development`, `test`, and `production`.
# More can be added to the `Environments` config parameter.
#
# @example
#   # bad
#   Rails.env.proudction?
#   Rails.env == 'proudction'
#
#   # good
#   Rails.env.production?
#   Rails.env == 'production'
#
# source://rubocop-rails//lib/rubocop/cop/rails/unknown_env.rb#20
class RuboCop::Cop::Rails::UnknownEnv < ::RuboCop::Cop::Base
  # source://rubocop-rails//lib/rubocop/cop/rails/unknown_env.rb#41
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/unknown_env.rb#24
  def rails_env?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/unknown_env.rb#34
  def unknown_environment_equal?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/unknown_env.rb#30
  def unknown_environment_predicate?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/unknown_env.rb#54
  def collect_variable_like_names(_scope); end

  # source://rubocop-rails//lib/rubocop/cop/rails/unknown_env.rb#88
  def environments; end

  # source://rubocop-rails//lib/rubocop/cop/rails/unknown_env.rb#58
  def message(name); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/unknown_env.rb#84
  def unknown_env_name?(name); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/unknown_env.rb#79
  def unknown_env_predicate?(name); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/unknown_env.rb#21
RuboCop::Cop::Rails::UnknownEnv::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/unknown_env.rb#22
RuboCop::Cop::Rails::UnknownEnv::MSG_SIMILAR = T.let(T.unsafe(nil), String)

# Suggests you remove a column that does not exist in the schema from `ignored_columns`.
# `ignored_columns` is necessary to drop a column from RDBMS, but you don't need it after the migration
# to drop the column. You avoid forgetting to remove `ignored_columns` by this cop.
#
# @example
#   # bad
#   class User < ApplicationRecord
#   self.ignored_columns = [:already_removed_column]
#   end
#
#   # good
#   class User < ApplicationRecord
#   self.ignored_columns = [:still_existing_column]
#   end
#
# source://rubocop-rails//lib/rubocop/cop/rails/unused_ignored_columns.rb#21
class RuboCop::Cop::Rails::UnusedIgnoredColumns < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ActiveRecordHelper

  # source://rubocop-rails//lib/rubocop/cop/rails/unused_ignored_columns.rb#31
  def appended_ignored_columns(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/unused_ignored_columns.rb#35
  def column_name(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/unused_ignored_columns.rb#27
  def ignored_columns(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/unused_ignored_columns.rb#39
  def on_op_asgn(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/unused_ignored_columns.rb#39
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/unused_ignored_columns.rb#54
  def check_column_existence(column_node, table); end

  # source://rubocop-rails//lib/rubocop/cop/rails/unused_ignored_columns.rb#63
  def class_node(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/unused_ignored_columns.rb#67
  def table(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/unused_ignored_columns.rb#24
RuboCop::Cop::Rails::UnusedIgnoredColumns::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/unused_ignored_columns.rb#25
RuboCop::Cop::Rails::UnusedIgnoredColumns::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# If you try to render content along with a non-content status code (100-199, 204, 205, or 304),
# it will be dropped from the response.
#
# This cop checks for uses of `render` which specify both body content and a non-content status.
#
# @example
#   # bad
#   render 'foo', status: :continue
#   render status: 100, plain: 'Ruby!'
#
#   # good
#   head :continue
#   head 100
#
# source://rubocop-rails//lib/rubocop/cop/rails/unused_render_content.rb#19
class RuboCop::Cop::Rails::UnusedRenderContent < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop-rails//lib/rubocop/cop/rails/unused_render_content.rb#45
  def non_content_status?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/unused_render_content.rb#59
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/unused_render_content.rb#52
  def unused_render_content?(param0 = T.unsafe(nil)); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/unused_render_content.rb#28
RuboCop::Cop::Rails::UnusedRenderContent::BODY_OPTIONS = T.let(T.unsafe(nil), Set)

# source://rubocop-rails//lib/rubocop/cop/rails/unused_render_content.rb#22
RuboCop::Cop::Rails::UnusedRenderContent::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/unused_render_content.rb#25
RuboCop::Cop::Rails::UnusedRenderContent::NON_CONTENT_STATUSES = T.let(T.unsafe(nil), Set)

# source://rubocop-rails//lib/rubocop/cop/rails/unused_render_content.rb#24
RuboCop::Cop::Rails::UnusedRenderContent::NON_CONTENT_STATUS_CODES = T.let(T.unsafe(nil), Set)

# source://rubocop-rails//lib/rubocop/cop/rails/unused_render_content.rb#23
RuboCop::Cop::Rails::UnusedRenderContent::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the use of old-style attribute validation macros.
#
# @example
#   # bad
#   validates_acceptance_of :foo
#   validates_confirmation_of :foo
#   validates_exclusion_of :foo
#   validates_format_of :foo
#   validates_inclusion_of :foo
#   validates_length_of :foo
#   validates_numericality_of :foo
#   validates_presence_of :foo
#   validates_absence_of :foo
#   validates_size_of :foo
#   validates_uniqueness_of :foo
#
#   # good
#   validates :foo, acceptance: true
#   validates :foo, confirmation: true
#   validates :foo, exclusion: true
#   validates :foo, format: true
#   validates :foo, inclusion: true
#   validates :foo, length: true
#   validates :foo, numericality: true
#   validates :foo, presence: true
#   validates :foo, absence: true
#   validates :foo, size: true
#   validates :foo, uniqueness: true
#
# source://rubocop-rails//lib/rubocop/cop/rails/validation.rb#35
class RuboCop::Cop::Rails::Validation < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/validation.rb#57
  def on_send(node); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/validation.rb#130
  def braced_options(options); end

  # source://rubocop-rails//lib/rubocop/cop/rails/validation.rb#83
  def correct_validate_type(corrector, node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/validation.rb#108
  def correct_validate_type_for_array(corrector, node, arguments, loc); end

  # source://rubocop-rails//lib/rubocop/cop/rails/validation.rb#104
  def correct_validate_type_for_hash(corrector, node, arguments); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/validation.rb#126
  def frozen_array_argument?(argument); end

  # source://rubocop-rails//lib/rubocop/cop/rails/validation.rb#73
  def message(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/validation.rb#79
  def preferred_method(method); end

  # source://rubocop-rails//lib/rubocop/cop/rails/validation.rb#122
  def validate_type(node); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/validation.rb#55
RuboCop::Cop::Rails::Validation::ALLOWLIST = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/validation.rb#38
RuboCop::Cop::Rails::Validation::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/validation.rb#54
RuboCop::Cop::Rails::Validation::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop-rails//lib/rubocop/cop/rails/validation.rb#40
RuboCop::Cop::Rails::Validation::TYPES = T.let(T.unsafe(nil), Array)

# Identifies places where manually constructed SQL
# in `where` can be replaced with `where(attribute: value)`.
#
# @example
#   # bad
#   User.where('name = ?', 'Gabe')
#   User.where('name = :name', name: 'Gabe')
#   User.where('name IS NULL')
#   User.where('name IN (?)', ['john', 'jane'])
#   User.where('name IN (:names)', names: ['john', 'jane'])
#   User.where('users.name = :name', name: 'Gabe')
#
#   # good
#   User.where(name: 'Gabe')
#   User.where(name: nil)
#   User.where(name: ['john', 'jane'])
#   User.where(users: { name: 'Gabe' })
#
# source://rubocop-rails//lib/rubocop/cop/rails/where_equals.rb#27
class RuboCop::Cop::Rails::WhereEquals < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/where_equals.rb#41
  def on_csend(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_equals.rb#41
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_equals.rb#34
  def where_method_call?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/where_equals.rb#91
  def build_good_method(column, value); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_equals.rb#72
  def extract_column_and_value(template_node, value_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_equals.rb#68
  def offense_range(node); end
end

# column = ?
#
# source://rubocop-rails//lib/rubocop/cop/rails/where_equals.rb#60
RuboCop::Cop::Rails::WhereEquals::EQ_ANONYMOUS_RE = T.let(T.unsafe(nil), Regexp)

# column = :column
#
# source://rubocop-rails//lib/rubocop/cop/rails/where_equals.rb#62
RuboCop::Cop::Rails::WhereEquals::EQ_NAMED_RE = T.let(T.unsafe(nil), Regexp)

# column IN (?)
#
# source://rubocop-rails//lib/rubocop/cop/rails/where_equals.rb#61
RuboCop::Cop::Rails::WhereEquals::IN_ANONYMOUS_RE = T.let(T.unsafe(nil), Regexp)

# column IN (:column)
#
# source://rubocop-rails//lib/rubocop/cop/rails/where_equals.rb#63
RuboCop::Cop::Rails::WhereEquals::IN_NAMED_RE = T.let(T.unsafe(nil), Regexp)

# column IS NULL
#
# source://rubocop-rails//lib/rubocop/cop/rails/where_equals.rb#64
RuboCop::Cop::Rails::WhereEquals::IS_NULL_RE = T.let(T.unsafe(nil), Regexp)

# source://rubocop-rails//lib/rubocop/cop/rails/where_equals.rb#31
RuboCop::Cop::Rails::WhereEquals::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/where_equals.rb#32
RuboCop::Cop::Rails::WhereEquals::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces consistent style when using `exists?`.
#
# Two styles are supported for this cop. When EnforcedStyle is 'exists'
# then the cop enforces `exists?(...)` over `where(...).exists?`.
#
# When EnforcedStyle is 'where' then the cop enforces
# `where(...).exists?` over `exists?(...)`.
#
# @example EnforcedStyle: exists (default)
#   # bad
#   User.where(name: 'john').exists?
#   User.where(['name = ?', 'john']).exists?
#   User.where('name = ?', 'john').exists?
#   user.posts.where(published: true).exists?
#
#   # good
#   User.exists?(name: 'john')
#   User.where('length(name) > 10').exists?
#   user.posts.exists?(published: true)
# @example EnforcedStyle: where
#   # bad
#   User.exists?(name: 'john')
#   User.exists?(['name = ?', 'john'])
#   user.posts.exists?(published: true)
#
#   # good
#   User.where(name: 'john').exists?
#   User.where(['name = ?', 'john']).exists?
#   User.where('name = ?', 'john').exists?
#   user.posts.where(published: true).exists?
#   User.where('length(name) > 10').exists?
#
# source://rubocop-rails//lib/rubocop/cop/rails/where_exists.rb#50
class RuboCop::Cop::Rails::WhereExists < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/where_exists.rb#61
  def exists_with_args?(param0 = T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_exists.rb#65
  def on_csend(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_exists.rb#65
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_exists.rb#57
  def where_exists_call?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/where_exists.rb#112
  def build_good_method(args, dot_source: T.unsafe(nil)); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_exists.rb#120
  def build_good_method_exists(args); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_exists.rb#128
  def build_good_method_where(args, dot_source); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/where_exists.rb#98
  def convertable_args?(args); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_exists.rb#104
  def correction_range(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/where_exists.rb#86
  def exists_style?; end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_exists.rb#90
  def find_offenses(node, &block); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/where_exists.rb#82
  def where_style?; end
end

# source://rubocop-rails//lib/rubocop/cop/rails/where_exists.rb#54
RuboCop::Cop::Rails::WhereExists::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/where_exists.rb#55
RuboCop::Cop::Rails::WhereExists::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Use `where.missing(...)` to find missing relationship records.
#
# This cop is enabled in Rails 6.1 or higher.
#
# @example
#   # bad
#   Post.left_joins(:author).where(authors: { id: nil })
#
#   # good
#   Post.where.missing(:author)
#
# source://rubocop-rails//lib/rubocop/cop/rails/where_missing.rb#17
class RuboCop::Cop::Rails::WhereMissing < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRailsVersion

  # source://rubocop-rails//lib/rubocop/cop/rails/where_missing.rb#34
  def missing_relationship(param0); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_missing.rb#38
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_missing.rb#29
  def where_node_and_argument(param0); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/where_missing.rb#111
  def message(node, where_argument); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/where_missing.rb#107
  def multi_condition?(where_arg); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_missing.rb#67
  def register_offense(node, where_node, where_argument, range); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_missing.rb#92
  def remove_where_method(corrector, node, where_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_missing.rb#84
  def replace_range(child); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_missing.rb#78
  def replace_where_method(corrector, where_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_missing.rb#54
  def root_receiver(node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/where_missing.rb#103
  def same_line?(left_joins_node, where_node); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/where_missing.rb#63
  def same_relationship?(where, left_joins); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/where_missing.rb#22
RuboCop::Cop::Rails::WhereMissing::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/where_missing.rb#24
RuboCop::Cop::Rails::WhereMissing::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies places where manually constructed SQL
# in `where` can be replaced with `where.not(...)`.
#
# @example
#   # bad
#   User.where('name != ?', 'Gabe')
#   User.where('name != :name', name: 'Gabe')
#   User.where('name <> ?', 'Gabe')
#   User.where('name <> :name', name: 'Gabe')
#   User.where('name IS NOT NULL')
#   User.where('name NOT IN (?)', ['john', 'jane'])
#   User.where('name NOT IN (:names)', names: ['john', 'jane'])
#   User.where('users.name != :name', name: 'Gabe')
#
#   # good
#   User.where.not(name: 'Gabe')
#   User.where.not(name: nil)
#   User.where.not(name: ['john', 'jane'])
#   User.where.not(users: { name: 'Gabe' })
#
# source://rubocop-rails//lib/rubocop/cop/rails/where_not.rb#26
class RuboCop::Cop::Rails::WhereNot < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-rails//lib/rubocop/cop/rails/where_not.rb#40
  def on_csend(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_not.rb#40
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_not.rb#33
  def where_method_call?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-rails//lib/rubocop/cop/rails/where_not.rb#90
  def build_good_method(dot, column, value); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_not.rb#71
  def extract_column_and_value(template_node, value_node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_not.rb#67
  def offense_range(node); end
end

# column IS NOT NULL
#
# source://rubocop-rails//lib/rubocop/cop/rails/where_not.rb#63
RuboCop::Cop::Rails::WhereNot::IS_NOT_NULL_RE = T.let(T.unsafe(nil), Regexp)

# source://rubocop-rails//lib/rubocop/cop/rails/where_not.rb#30
RuboCop::Cop::Rails::WhereNot::MSG = T.let(T.unsafe(nil), String)

# column != ?, column <> ?
#
# source://rubocop-rails//lib/rubocop/cop/rails/where_not.rb#59
RuboCop::Cop::Rails::WhereNot::NOT_EQ_ANONYMOUS_RE = T.let(T.unsafe(nil), Regexp)

# column != :column, column <> :column
#
# source://rubocop-rails//lib/rubocop/cop/rails/where_not.rb#61
RuboCop::Cop::Rails::WhereNot::NOT_EQ_NAMED_RE = T.let(T.unsafe(nil), Regexp)

# column NOT IN (?)
#
# source://rubocop-rails//lib/rubocop/cop/rails/where_not.rb#60
RuboCop::Cop::Rails::WhereNot::NOT_IN_ANONYMOUS_RE = T.let(T.unsafe(nil), Regexp)

# column NOT IN (:column)
#
# source://rubocop-rails//lib/rubocop/cop/rails/where_not.rb#62
RuboCop::Cop::Rails::WhereNot::NOT_IN_NAMED_RE = T.let(T.unsafe(nil), Regexp)

# source://rubocop-rails//lib/rubocop/cop/rails/where_not.rb#31
RuboCop::Cop::Rails::WhereNot::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies calls to `where.not` with multiple hash arguments.
#
# The behavior of `where.not` changed in Rails 6.1. Prior to the change,
# `.where.not(trashed: true, role: 'admin')` evaluated to
# `WHERE trashed != TRUE AND role != 'admin'`.
# From Rails 6.1 onwards, this executes the query
# `WHERE NOT (trashed == TRUE AND roles == 'admin')`.
#
# @example
#   # bad
#   User.where.not(trashed: true, role: 'admin')
#   User.where.not(trashed: true, role: ['moderator', 'admin'])
#   User.joins(:posts).where.not(posts: { trashed: true, title: 'Rails' })
#
#   # good
#   User.where.not(trashed: true)
#   User.where.not(role: ['moderator', 'admin'])
#   User.where.not(trashed: true).where.not(role: ['moderator', 'admin'])
#   User.where.not('trashed = ? OR role = ?', true, 'admin')
#
# source://rubocop-rails//lib/rubocop/cop/rails/where_not_with_multiple_conditions.rb#25
class RuboCop::Cop::Rails::WhereNotWithMultipleConditions < ::RuboCop::Cop::Base
  # source://rubocop-rails//lib/rubocop/cop/rails/where_not_with_multiple_conditions.rb#33
  def on_send(node); end

  # source://rubocop-rails//lib/rubocop/cop/rails/where_not_with_multiple_conditions.rb#29
  def where_not_call?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/rails/where_not_with_multiple_conditions.rb#46
  def multiple_arguments_hash?(hash); end
end

# source://rubocop-rails//lib/rubocop/cop/rails/where_not_with_multiple_conditions.rb#26
RuboCop::Cop::Rails::WhereNotWithMultipleConditions::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-rails//lib/rubocop/cop/rails/where_not_with_multiple_conditions.rb#27
RuboCop::Cop::Rails::WhereNotWithMultipleConditions::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

module RuboCop::Cop::Style; end

class RuboCop::Cop::Style::InverseMethods < ::RuboCop::Cop::Base
  # source://rubocop/1.59.0/lib/rubocop/cop/style/inverse_methods.rb#70
  def inverse_block?(param0 = T.unsafe(nil)); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/inverse_methods.rb#61
  def inverse_candidate?(param0 = T.unsafe(nil)); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/inverse_methods.rb#92
  def on_block(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/inverse_methods.rb#78
  def on_csend(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/inverse_methods.rb#92
  def on_numblock(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/inverse_methods.rb#78
  def on_send(node); end

  private

  # source://rubocop/1.59.0/lib/rubocop/cop/style/inverse_methods.rb#177
  def camel_case_constant?(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/inverse_methods.rb#121
  def correct_inverse_block(corrector, node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/inverse_methods.rb#112
  def correct_inverse_method(corrector, node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/inverse_methods.rb#128
  def correct_inverse_selector(block, corrector); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/inverse_methods.rb#181
  def dot_range(loc); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/inverse_methods.rb#164
  def end_parentheses(node, method_call); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/inverse_methods.rb#150
  def inverse_blocks; end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/inverse_methods.rb#145
  def inverse_methods; end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/inverse_methods.rb#191
  def message(method, inverse); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/inverse_methods.rb#154
  def negated?(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/inverse_methods.rb#158
  def not_to_receiver(node, method_call); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/inverse_methods.rb#172
  def possible_class_hierarchy_check?(lhs, rhs, method); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/inverse_methods.rb#185
  def remove_end_parenthesis(corrector, node, method, method_call); end

  class << self
    # source://rubocop-rails//lib/rubocop-rails.rb#22
    def autocorrect_incompatible_with; end
  end
end

class RuboCop::Cop::Style::MethodCallWithArgsParentheses < ::RuboCop::Cop::Base
  # source://rubocop/1.59.0/lib/rubocop/cop/style/method_call_with_args_parentheses.rb#217
  def on_csend(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/method_call_with_args_parentheses.rb#217
  def on_send(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/method_call_with_args_parentheses.rb#217
  def on_super(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/method_call_with_args_parentheses.rb#217
  def on_yield(node); end

  private

  # source://rubocop/1.59.0/lib/rubocop/cop/style/method_call_with_args_parentheses.rb#226
  def args_begin(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/method_call_with_args_parentheses.rb#235
  def args_end(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/method_call_with_args_parentheses.rb#239
  def args_parenthesized?(node); end

  class << self
    # source://rubocop-rails//lib/rubocop-rails.rb#30
    def autocorrect_incompatible_with; end
  end
end

class RuboCop::Cop::Style::RedundantSelf < ::RuboCop::Cop::Base
  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#60
  def initialize(config = T.unsafe(nil), options = T.unsafe(nil)); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#68
  def on_and_asgn(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#86
  def on_args(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#120
  def on_block(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#90
  def on_blockarg(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#81
  def on_def(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#81
  def on_defs(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#126
  def on_if(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#104
  def on_in_pattern(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#99
  def on_lvasgn(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#94
  def on_masgn(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#120
  def on_numblock(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#74
  def on_op_asgn(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#68
  def on_or_asgn(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#108
  def on_send(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#126
  def on_until(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#126
  def on_while(node); end

  private

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#196
  def add_lhs_to_local_variables_scopes(rhs, lhs); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#204
  def add_masgn_lhs_variables(rhs, lhs); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#210
  def add_match_var_scopes(in_pattern_node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#144
  def add_scope(node, local_variables = T.unsafe(nil)); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#190
  def allow_self(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#150
  def allowed_send_node?(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#165
  def it_method_in_block?(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#181
  def on_argument(node); end

  # source://rubocop/1.59.0/lib/rubocop/cop/style/redundant_self.rb#173
  def regular_method_call?(node); end

  class << self
    # source://rubocop-rails//lib/rubocop-rails.rb#38
    def autocorrect_incompatible_with; end
  end
end

# Common functionality for checking target rails version.
#
# source://rubocop-rails//lib/rubocop/cop/mixin/target_rails_version.rb#6
module RuboCop::Cop::TargetRailsVersion
  # source://rubocop-rails//lib/rubocop/cop/mixin/target_rails_version.rb#7
  def minimum_target_rails_version(version); end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/cop/mixin/target_rails_version.rb#11
  def support_target_rails_version?(version); end
end

# RuboCop Rails project namespace
#
# source://rubocop-rails//lib/rubocop/rails.rb#5
module RuboCop::Rails; end

# source://rubocop-rails//lib/rubocop/rails.rb#8
RuboCop::Rails::CONFIG = T.let(T.unsafe(nil), Hash)

# source://rubocop-rails//lib/rubocop/rails.rb#7
RuboCop::Rails::CONFIG_DEFAULT = T.let(T.unsafe(nil), Pathname)

# Because RuboCop doesn't yet support plugins, we have to monkey patch in a
# bit of our configuration.
#
# source://rubocop-rails//lib/rubocop/rails/inject.rb#7
module RuboCop::Rails::Inject
  class << self
    # source://rubocop-rails//lib/rubocop/rails/inject.rb#8
    def defaults!; end
  end
end

# source://rubocop-rails//lib/rubocop/rails.rb#6
RuboCop::Rails::PROJECT_ROOT = T.let(T.unsafe(nil), Pathname)

# It loads db/schema.rb and return Schema object.
# Cops refers database schema information with this module.
#
# source://rubocop-rails//lib/rubocop/rails/schema_loader.rb#7
module RuboCop::Rails::SchemaLoader
  extend ::RuboCop::Rails::SchemaLoader

  # source://rubocop-rails//lib/rubocop/rails/schema_loader.rb#27
  def db_schema_path; end

  # It parses `db/schema.rb` and return it.
  # It returns `nil` if it can't find `db/schema.rb`.
  # So a cop that uses the loader should handle `nil` properly.
  #
  # @return [Schema, nil]
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader.rb#15
  def load(target_ruby_version); end

  # source://rubocop-rails//lib/rubocop/rails/schema_loader.rb#21
  def reset!; end

  private

  # source://rubocop-rails//lib/rubocop/rails/schema_loader.rb#41
  def load!(target_ruby_version); end

  # source://rubocop-rails//lib/rubocop/rails/schema_loader.rb#49
  def parse(path, target_ruby_version); end
end

# Represent an `add_index`
#
# source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#176
class RuboCop::Rails::SchemaLoader::AddIndex < ::RuboCop::Rails::SchemaLoader::Index
  # @return [AddIndex] a new instance of AddIndex
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#179
  def initialize(node); end

  # Returns the value of attribute table_name.
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#177
  def table_name; end
end

# Represent a column
#
# source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#116
class RuboCop::Rails::SchemaLoader::Column
  # @return [Column] a new instance of Column
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#119
  def initialize(node); end

  # Returns the value of attribute name.
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#117
  def name; end

  # Returns the value of attribute not_null.
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#117
  def not_null; end

  # Returns the value of attribute type.
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#117
  def type; end

  private

  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#129
  def analyze_keywords!(node); end
end

# Represent an index
#
# source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#140
class RuboCop::Rails::SchemaLoader::Index
  # @return [Index] a new instance of Index
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#143
  def initialize(node); end

  # Returns the value of attribute columns.
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#141
  def columns; end

  # Returns the value of attribute expression.
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#141
  def expression; end

  # Returns the value of attribute name.
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#141
  def name; end

  # Returns the value of attribute unique.
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#141
  def unique; end

  private

  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#160
  def analyze_keywords!(node); end

  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#152
  def build_columns_or_expr(columns); end
end

# Represent db/schema.rb
#
# source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#7
class RuboCop::Rails::SchemaLoader::Schema
  # @return [Schema] a new instance of Schema
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#10
  def initialize(ast); end

  # Returns the value of attribute add_indices.
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#8
  def add_indices; end

  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#23
  def add_indices_by(table_name:); end

  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#17
  def table_by(name:); end

  # Returns the value of attribute tables.
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#8
  def tables; end

  private

  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#31
  def build!(ast); end

  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#59
  def each_add_index(ast); end

  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#46
  def each_table(ast); end
end

# Represent a table
#
# source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#70
class RuboCop::Rails::SchemaLoader::Table
  # @return [Table] a new instance of Table
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#73
  def initialize(node); end

  # Returns the value of attribute columns.
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#71
  def columns; end

  # Returns the value of attribute indices.
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#71
  def indices; end

  # Returns the value of attribute name.
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#71
  def name; end

  # @return [Boolean]
  #
  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#79
  def with_column?(name:); end

  private

  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#85
  def build_columns(node); end

  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#94
  def build_indices(node); end

  # source://rubocop-rails//lib/rubocop/rails/schema_loader/schema.rb#103
  def each_content(node, &block); end
end

# This module holds the RuboCop Rails version information.
#
# source://rubocop-rails//lib/rubocop/rails/version.rb#6
module RuboCop::Rails::Version
  class << self
    # source://rubocop-rails//lib/rubocop/rails/version.rb#9
    def document_version; end
  end
end

# source://rubocop-rails//lib/rubocop/rails/version.rb#7
RuboCop::Rails::Version::STRING = T.let(T.unsafe(nil), String)
