# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rubocop-sorbet` gem.
# Please instead update this file by running `bin/tapioca gem rubocop-sorbet`.

# source://rubocop-sorbet//lib/rubocop/sorbet/version.rb#3
module RuboCop; end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/mixin/target_sorbet_version.rb#4
module RuboCop::Cop; end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/mixin/target_sorbet_version.rb#5
module RuboCop::Cop::Sorbet; end

# Disallows using `.override(allow_incompatible: true)`.
# Using `allow_incompatible` suggests a violation of the Liskov
# Substitution Principle, meaning that a subclass is not a valid
# subtype of its superclass. This Cop prevents these design smells
# from occurring.
#
# @example
#
#   # bad
#   sig.override(allow_incompatible: true)
#
#   # good
#   sig.override
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/allow_incompatible_override.rb#21
class RuboCop::Cop::Sorbet::AllowIncompatibleOverride < ::RuboCop::Cop::Base
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/allow_incompatible_override.rb#55
  def on_block(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/allow_incompatible_override.rb#55
  def on_numblock(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/allow_incompatible_override.rb#49
  def on_send(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/allow_incompatible_override.rb#41
  def override?(param0 = T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/allow_incompatible_override.rb#36
  def sig?(param0); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/allow_incompatible_override.rb#27
  def sig_dot_override?(param0 = T.unsafe(nil)); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/allow_incompatible_override.rb#22
RuboCop::Cop::Sorbet::AllowIncompatibleOverride::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/allow_incompatible_override.rb#24
RuboCop::Cop::Sorbet::AllowIncompatibleOverride::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Disallows binding the return value of `T.any`, `T.all`, `T.enum`
# to a constant directly. To bind the value, one must use `T.type_alias`.
#
# @example
#
#   # bad
#   FooOrBar = T.any(Foo, Bar)
#
#   # good
#   FooOrBar = T.type_alias { T.any(Foo, Bar) }
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/binding_constant_without_type_alias.rb#18
class RuboCop::Cop::Sorbet::BindingConstantWithoutTypeAlias < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/binding_constant_without_type_alias.rb#65
  def on_casgn(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/binding_constant_without_type_alias.rb#48
  def requires_type_alias?(param0 = T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/binding_constant_without_type_alias.rb#38
  def type_alias_with_block?(param0 = T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/binding_constant_without_type_alias.rb#29
  def type_alias_without_block(param0 = T.unsafe(nil)); end

  private

  # Given nested send nodes, returns the leaf with explicit receiver.
  #
  # i.e. in Ruby
  #
  #     a.b.c.d.e.f
  #     ^^^
  #
  # i.e. in AST
  #
  #     (send (send (send (send (send (send nil :a) :b) :c) :d) :e) :f)
  #                             ^^^^^^^^^^^^^^^^^^^^^^^
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/binding_constant_without_type_alias.rb#98
  def send_leaf(node); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/binding_constant_without_type_alias.rb#21
RuboCop::Cop::Sorbet::BindingConstantWithoutTypeAlias::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/binding_constant_without_type_alias.rb#23
RuboCop::Cop::Sorbet::BindingConstantWithoutTypeAlias::WITHOUT_BLOCK_MSG = T.let(T.unsafe(nil), String)

# Checks for the a mistaken variant of the "obsolete memoization pattern" that used to be required
# on every call, causing the memoized value to be discarded and recomputed on every call.
#
# This cop will correct it to read from the ivar instead of `nil`, which will memoize it correctly.
#
# The result of this correction will be the "obsolete memoization pattern", which can further be corrected by
# the `Sorbet/ObsoleteStrictMemoization` cop.
#
# See `Sorbet/ObsoleteStrictMemoization` for more details.
#
# @example
#   # bad
#   sig { returns(Foo) }
#   def foo
#   # This `nil` is likely a mistake, causing the memoized value to be discarded and recomputed on every call.
#   @foo = T.let(nil, T.nilable(Foo))
#   @foo ||= some_computation
#   end
#
#   # good
#   sig { returns(Foo) }
#   def foo
#   # This will now memoize the value as was likely intended, so `some_computation` is only ever called once.
#   # ⚠️If `some_computation` has side effects, this might be a breaking change!
#   @foo = T.let(@foo, T.nilable(Foo))
#   @foo ||= some_computation
#   end
# @see Sorbet/ObsoleteStrictMemoization
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/buggy_obsolete_strict_memoization.rb#42
class RuboCop::Cop::Sorbet::BuggyObsoleteStrictMemoization < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::MatchRange
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::LineLengthHelp
  include ::RuboCop::Cop::Sorbet::TargetSorbetVersion
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::Sorbet::TargetSorbetVersion::ClassMethods

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/buggy_obsolete_strict_memoization.rb#55
  def buggy_legacy_memoization_pattern?(param0 = T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/buggy_obsolete_strict_memoization.rb#66
  def on_begin(node); end

  # @return [Boolean]
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/buggy_obsolete_strict_memoization.rb#77
  def relevant_file?(file); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/buggy_obsolete_strict_memoization.rb#51
RuboCop::Cop::Sorbet::BuggyObsoleteStrictMemoization::MSG = T.let(T.unsafe(nil), String)

# Ensures that callback conditionals are bound to the right type
# so that they are type checked properly.
#
# Auto-correction is unsafe because other libraries define similar style callbacks as Rails, but don't always need
# binding to the attached class. Auto-correcting those usages can lead to false positives and auto-correction
# introduces new typing errors.
#
# @example
#
#   # bad
#   class Post < ApplicationRecord
#   before_create :do_it, if: -> { should_do_it? }
#
#   def should_do_it?
#   true
#   end
#   end
#
#   # good
#   class Post < ApplicationRecord
#   before_create :do_it, if: -> {
#   T.bind(self, Post)
#   should_do_it?
#   }
#
#   def should_do_it?
#   true
#   end
#   end
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/callback_conditionals_binding.rb#35
class RuboCop::Cop::Sorbet::CallbackConditionalsBinding < ::RuboCop::Cop::Cop
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/callback_conditionals_binding.rb#75
  def autocorrect(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/callback_conditionals_binding.rb#127
  def on_send(node); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/callback_conditionals_binding.rb#36
RuboCop::Cop::Sorbet::CallbackConditionalsBinding::CALLBACKS = T.let(T.unsafe(nil), Array)

# Disallows the usage of `checked(true)`. This usage could cause
# confusion; it could lead some people to believe that a method would be checked
# even if runtime checks have not been enabled on the class or globally.
# Additionally, in the event where checks are enabled, `checked(true)` would
# be redundant; only `checked(false)` or `soft` would change the behaviour.
#
# @example
#
#   # bad
#   sig { void.checked(true) }
#
#   # good
#   sig { void }
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/checked_true_in_signature.rb#19
class RuboCop::Cop::Sorbet::CheckedTrueInSignature < ::RuboCop::Cop::Cop
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::Sorbet::SignatureHelp

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/checked_true_in_signature.rb#24
  def offending_node(param0); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/checked_true_in_signature.rb#35
  def on_signature(node); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/checked_true_in_signature.rb#28
RuboCop::Cop::Sorbet::CheckedTrueInSignature::MESSAGE = T.let(T.unsafe(nil), String)

# Disallows the calls that are used to get constants fom Strings
# such as +constantize+, +const_get+, and +constants+.
#
# The goal of this cop is to make the code easier to statically analyze,
# more IDE-friendly, and more predictable. It leads to code that clearly
# expresses which values the constant can have.
#
# @example
#
#   # bad
#   class_name.constantize
#
#   # bad
#   constants.detect { |c| c.name == "User" }
#
#   # bad
#   const_get(class_name)
#
#   # good
#   case class_name
#   when "User"
#   User
#   else
#   raise ArgumentError
#   end
#
#   # good
#   { "User" => User }.fetch(class_name)
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/constants_from_strings.rb#37
class RuboCop::Cop::Sorbet::ConstantsFromStrings < ::RuboCop::Cop::Cop
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/constants_from_strings.rb#38
  def constant_from_string?(param0 = T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/constants_from_strings.rb#42
  def on_send(node); end
end

# Checks for blank lines after signatures.
#
# @example
#   # bad
#   sig { void }
#
#   def foo; end
#
#   # good
#   sig { void }
#   def foo; end
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/empty_line_after_sig.rb#17
class RuboCop::Cop::Sorbet::EmptyLineAfterSig < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::Sorbet::SignatureHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/empty_line_after_sig.rb#34
  def on_signature(sig); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/empty_line_after_sig.rb#25
  def sig_or_signable_method_definition?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/empty_line_after_sig.rb#57
  def lines_between(node1, node2, buffer: T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/empty_line_after_sig.rb#53
  def next_sibling(node); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/empty_line_after_sig.rb#22
RuboCop::Cop::Sorbet::EmptyLineAfterSig::MSG = T.let(T.unsafe(nil), String)

# Checks that the Sorbet sigil comes as the first magic comment in the file.
#
# The expected order for magic comments is: (en)?coding, typed, warn_indent then frozen_string_literal.
#
# For example, the following bad ordering:
#
# ```ruby
# class Foo; end
# ```
#
# Will be corrected as:
#
# ```ruby
# class Foo; end
# ```
#
# Only `(en)?coding`, `typed`, `warn_indent` and `frozen_string_literal` magic comments are considered,
# other comments or magic comments are left in the same place.
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/enforce_sigil_order.rb#30
class RuboCop::Cop::Sorbet::EnforceSigilOrder < ::RuboCop::Cop::Sorbet::ValidSigil
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/enforce_sigil_order.rb#42
  def autocorrect(_node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/enforce_sigil_order.rb#33
  def investigate(processed_source); end

  protected

  # checks
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/enforce_sigil_order.rb#92
  def check_magic_comments_order(tokens); end

  # Get all the tokens in `processed_source` that match `MAGIC_REGEX`
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/enforce_sigil_order.rb#84
  def extract_magic_comments(processed_source); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/enforce_sigil_order.rb#68
RuboCop::Cop::Sorbet::EnforceSigilOrder::CODING_REGEX = T.let(T.unsafe(nil), Regexp)

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/enforce_sigil_order.rb#70
RuboCop::Cop::Sorbet::EnforceSigilOrder::FROZEN_REGEX = T.let(T.unsafe(nil), Regexp)

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/enforce_sigil_order.rb#69
RuboCop::Cop::Sorbet::EnforceSigilOrder::INDENT_REGEX = T.let(T.unsafe(nil), Regexp)

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/enforce_sigil_order.rb#79
RuboCop::Cop::Sorbet::EnforceSigilOrder::MAGIC_REGEX = T.let(T.unsafe(nil), Regexp)

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/enforce_sigil_order.rb#72
RuboCop::Cop::Sorbet::EnforceSigilOrder::PREFERRED_ORDER = T.let(T.unsafe(nil), Hash)

# Checks that every method definition and attribute accessor has a Sorbet signature.
#
# It also suggest an autocorrect with placeholders so the following code:
#
# ```
# def foo(a, b, c); end
# ```
#
# Will be corrected as:
#
# ```
# sig { params(a: T.untyped, b: T.untyped, c: T.untyped).returns(T.untyped)
# def foo(a, b, c); end
# ```
#
# You can configure the placeholders used by changing the following options:
#
# * `ParameterTypePlaceholder`: placeholders used for parameter types (default: 'T.untyped')
# * `ReturnTypePlaceholder`: placeholders used for return types (default: 'T.untyped')
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#27
class RuboCop::Cop::Sorbet::EnforceSignatures < ::RuboCop::Cop::Cop
  include ::RuboCop::Cop::Sorbet::SignatureHelp

  # @return [EnforceSignatures] a new instance of EnforceSignatures
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#30
  def initialize(config = T.unsafe(nil), options = T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#36
  def accessor?(param0 = T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#56
  def autocorrect(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#40
  def on_def(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#44
  def on_defs(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#48
  def on_send(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#52
  def on_signature(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#75
  def scope(node); end

  private

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#84
  def check_node(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#95
  def param_type_placeholder; end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#99
  def return_type_placeholder; end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#103
class RuboCop::Cop::Sorbet::EnforceSignatures::SigSuggestion
  # @return [SigSuggestion] a new instance of SigSuggestion
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#106
  def initialize(indent, param_placeholder, return_placeholder); end

  # Returns the value of attribute params.
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#104
  def params; end

  # Sets the attribute params
  #
  # @param value the value to set the attribute params to.
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#104
  def params=(_arg0); end

  # Returns the value of attribute returns.
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#104
  def returns; end

  # Sets the attribute returns
  #
  # @param value the value to set the attribute returns to.
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#104
  def returns=(_arg0); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#114
  def to_autocorrect; end

  private

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#126
  def generate_params; end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/enforce_signatures.rb#138
  def generate_return; end
end

# Checks that there is only one Sorbet sigil in a given file
#
# For example, the following class with two sigils
#
# ```ruby
# class Foo; end
# ```
#
# Will be corrected as:
#
# ```ruby
# class Foo; end
# ```
#
# Other comments or magic comments are left in place.
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/enforce_single_sigil.rb#26
class RuboCop::Cop::Sorbet::EnforceSingleSigil < ::RuboCop::Cop::Sorbet::ValidSigil
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/enforce_single_sigil.rb#40
  def autocorrect(_node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/enforce_single_sigil.rb#29
  def investigate(processed_source); end

  protected

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/enforce_single_sigil.rb#56
  def extract_all_sigils(processed_source); end
end

# Makes the Sorbet `false` sigil mandatory in all files.
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/false_sigil.rb#10
class RuboCop::Cop::Sorbet::FalseSigil < ::RuboCop::Cop::Sorbet::HasSigil
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/false_sigil.rb#11
  def minimum_strictness; end
end

# Ensures RBI shims do not include a call to extend T::Sig
# or to extend T::Helpers
#
# @example
#
#   # bad
#   module SomeModule
#   extend T::Sig
#   extend T::Helpers
#
#   sig { returns(String) }
#   def foo; end
#   end
#
#   # good
#   module SomeModule
#   sig { returns(String) }
#   def foo; end
#   end
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/rbi/forbid_extend_t_sig_helpers_in_shims.rb#25
class RuboCop::Cop::Sorbet::ForbidExtendTSigHelpersInShims < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/rbi/forbid_extend_t_sig_helpers_in_shims.rb#33
  def extend_t_sig_or_helpers?(param0 = T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/rbi/forbid_extend_t_sig_helpers_in_shims.rb#37
  def on_send(node); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/rbi/forbid_extend_t_sig_helpers_in_shims.rb#29
RuboCop::Cop::Sorbet::ForbidExtendTSigHelpersInShims::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/rbi/forbid_extend_t_sig_helpers_in_shims.rb#30
RuboCop::Cop::Sorbet::ForbidExtendTSigHelpersInShims::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Correct `send` expressions in include statements by constant literals.
#
# Sorbet, the static checker, is not (yet) able to support constructs on the
# following form:
#
# ```ruby
# class MyClass
#   include send_expr
# end
# ```
#
# Multiple occurences of this can be found in Shopify's code base like:
#
# ```ruby
# include Rails.application.routes.url_helpers
# ```
# or
# ```ruby
# include Polaris::Engine.helpers
# ```
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_include_const_literal.rb#29
class RuboCop::Cop::Sorbet::ForbidIncludeConstLiteral < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_include_const_literal.rb#36
  def dynamic_inclusion?(param0 = T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_include_const_literal.rb#40
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_include_const_literal.rb#52
  def neither_const_nor_self?(node); end

  # Returns true if the node is within a module declaration that is not anonymous.
  #
  # @return [Boolean]
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_include_const_literal.rb#57
  def within_onymous_module?(node); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_include_const_literal.rb#32
RuboCop::Cop::Sorbet::ForbidIncludeConstLiteral::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_include_const_literal.rb#33
RuboCop::Cop::Sorbet::ForbidIncludeConstLiteral::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Makes sure that RBI files are always located under the defined allowed paths.
#
# Options:
#
# * `AllowedPaths`: A list of the paths where RBI files are allowed (default: ["rbi/**", "sorbet/rbi/**"])
#
# @example
#   # bad
#   # lib/some_file.rbi
#   # other_file.rbi
#
#   # good
#   # rbi/external_interface.rbi
#   # sorbet/rbi/some_file.rbi
#   # sorbet/rbi/any/path/for/file.rbi
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/rbi/forbid_rbi_outside_of_allowed_paths.rb#23
class RuboCop::Cop::Sorbet::ForbidRBIOutsideOfAllowedPaths < ::RuboCop::Cop::Cop
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/rbi/forbid_rbi_outside_of_allowed_paths.rb#26
  def investigate(processed_source); end

  private

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/rbi/forbid_rbi_outside_of_allowed_paths.rb#58
  def allowed_paths; end
end

# Correct superclass `send` expressions by constant literals.
#
# Sorbet, the static checker, is not (yet) able to support constructs on the
# following form:
#
# ```ruby
# class Foo < send_expr; end
# ```
#
# Multiple occurences of this can be found in Shopify's code base like:
#
# ```ruby
# class ShopScope < Component::TrustedIdScope[ShopIdentity::ShopId]
# ```
# or
# ```ruby
# class ApiClientEligibility < Struct.new(:api_client, :match_results, :shop)
# ```
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_superclass_const_literal.rb#28
class RuboCop::Cop::Sorbet::ForbidSuperclassConstLiteral < ::RuboCop::Cop::Base
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_superclass_const_literal.rb#32
  def dynamic_superclass?(param0 = T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_superclass_const_literal.rb#36
  def on_class(node); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_superclass_const_literal.rb#29
RuboCop::Cop::Sorbet::ForbidSuperclassConstLiteral::MSG = T.let(T.unsafe(nil), String)

# Disallow using `T::Struct` and `T::Props`.
#
# @example
#
#   # bad
#   class MyStruct < T::Struct
#   const :foo, String
#   prop :bar, Integer, default: 0
#
#   def some_method; end
#   end
#
#   # good
#   class MyStruct
#   extend T::Sig
#
#   sig { returns(String) }
#   attr_reader :foo
#
#   sig { returns(Integer) }
#   attr_accessor :bar
#
#   sig { params(foo: String, bar: Integer) }
#   def initialize(foo:, bar: 0)
#   @foo = foo
#   @bar = bar
#   end
#
#   def some_method; end
#   end
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#38
class RuboCop::Cop::Sorbet::ForbidTStruct < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::CommentsHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#164
  def on_class(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#205
  def on_send(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#162
  def t_props?(param0 = T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#157
  def t_struct?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#213
  def initialize_method(indent, props); end

  # @return [Boolean]
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#226
  def previous_line_blank?(node); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#47
RuboCop::Cop::Sorbet::ForbidTStruct::MSG_PROPS = T.let(T.unsafe(nil), String)

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#46
RuboCop::Cop::Sorbet::ForbidTStruct::MSG_STRUCT = T.let(T.unsafe(nil), String)

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#104
class RuboCop::Cop::Sorbet::ForbidTStruct::Property
  # @return [Property] a new instance of Property
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#107
  def initialize(node, kind, name, type, default:, factory:); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#123
  def attr_accessor; end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#119
  def attr_sig; end

  # Returns the value of attribute default.
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#105
  def default; end

  # Returns the value of attribute factory.
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#105
  def factory; end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#144
  def initialize_assign; end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#131
  def initialize_param; end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#127
  def initialize_sig_param; end

  # Returns the value of attribute kind.
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#105
  def kind; end

  # Returns the value of attribute name.
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#105
  def name; end

  # @return [Boolean]
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#151
  def nilable?; end

  # Returns the value of attribute node.
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#105
  def node; end

  # Returns the value of attribute type.
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#105
  def type; end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#44
RuboCop::Cop::Sorbet::ForbidTStruct::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# This class walks down the class body of a T::Struct and collects all the properties that will need to be
# translated into `attr_reader` and `attr_accessor` methods.
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#51
class RuboCop::Cop::Sorbet::ForbidTStruct::TStructWalker
  include ::RuboCop::AST::Traversal
  extend ::RuboCop::AST::NodePattern::Macros

  # @return [TStructWalker] a new instance of TStructWalker
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#57
  def initialize; end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#63
  def extend_t_sig?(param0 = T.unsafe(nil)); end

  # Returns the value of attribute has_extend_t_sig.
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#55
  def has_extend_t_sig; end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#72
  def on_send(node); end

  # Returns the value of attribute props.
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#55
  def props; end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_struct.rb#68
  def t_struct_prop?(param0 = T.unsafe(nil)); end
end

# Disallows using `T.unsafe` anywhere.
#
# @example
#
#   # bad
#   T.unsafe(foo)
#
#   # good
#   foo
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_unsafe.rb#17
class RuboCop::Cop::Sorbet::ForbidTUnsafe < ::RuboCop::Cop::Base
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_unsafe.rb#24
  def on_send(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_unsafe.rb#22
  def t_unsafe?(param0 = T.unsafe(nil)); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_unsafe.rb#18
RuboCop::Cop::Sorbet::ForbidTUnsafe::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_unsafe.rb#19
RuboCop::Cop::Sorbet::ForbidTUnsafe::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Disallows using `T.untyped` anywhere.
#
# @example
#
#   # bad
#   sig { params(my_argument: T.untyped).void }
#   def foo(my_argument); end
#
#   # good
#   sig { params(my_argument: String).void }
#   def foo(my_argument); end
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_untyped.rb#20
class RuboCop::Cop::Sorbet::ForbidTUntyped < ::RuboCop::Cop::Base
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_untyped.rb#27
  def on_send(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_untyped.rb#25
  def t_untyped?(param0 = T.unsafe(nil)); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_untyped.rb#21
RuboCop::Cop::Sorbet::ForbidTUntyped::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_t_untyped.rb#22
RuboCop::Cop::Sorbet::ForbidTUntyped::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Disallows defining type aliases that contain shapes
#
# @example
#
#   # bad
#   Foo = T.type_alias { { foo: Integer } }
#
#   # good
#   class Foo
#   extend T::Sig
#
#   sig { params(foo: Integer).void }
#   def initialize(foo)
#   @foo = foo
#   end
#   end
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_type_aliased_shapes.rb#24
class RuboCop::Cop::Sorbet::ForbidTypeAliasedShapes < ::RuboCop::Cop::Base
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_type_aliased_shapes.rb#36
  def on_block(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_type_aliased_shapes.rb#36
  def on_numblock(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_type_aliased_shapes.rb#28
  def shape_type_alias?(param0 = T.unsafe(nil)); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_type_aliased_shapes.rb#25
RuboCop::Cop::Sorbet::ForbidTypeAliasedShapes::MSG = T.let(T.unsafe(nil), String)

# Disallows use of `T.untyped` or `T.nilable(T.untyped)`
# as a prop type for `T::Struct` or `T::ImmutableStruct`.
#
# @example
#
#   # bad
#   class SomeClass < T::Struct
#   const :foo, T.untyped
#   prop :bar, T.nilable(T.untyped)
#   end
#
#   # good
#   class SomeClass < T::Struct
#   const :foo, Integer
#   prop :bar, T.nilable(String)
#   end
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_untyped_struct_props.rb#25
class RuboCop::Cop::Sorbet::ForbidUntypedStructProps < ::RuboCop::Cop::Base
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_untyped_struct_props.rb#54
  def on_class(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_untyped_struct_props.rb#44
  def subclass_of_t_struct?(param0 = T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_untyped_struct_props.rb#39
  def t_nilable_untyped(param0 = T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_untyped_struct_props.rb#29
  def t_struct(param0 = T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_untyped_struct_props.rb#34
  def t_untyped(param0 = T.unsafe(nil)); end

  # Search for untyped prop/const declarations and capture their types
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_untyped_struct_props.rb#50
  def untyped_props(param0); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/forbid_untyped_struct_props.rb#26
RuboCop::Cop::Sorbet::ForbidUntypedStructProps::MSG = T.let(T.unsafe(nil), String)

# Makes the Sorbet typed sigil mandatory in all files.
#
# Options:
#
# * `SuggestedStrictness`: Sorbet strictness level suggested in offense messages (default: 'false')
# * `MinimumStrictness`: If set, make offense if the strictness level in the file is below this one
#
# If a `MinimumStrictness` level is specified, it will be used in offense messages and autocorrect.
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/has_sigil.rb#17
class RuboCop::Cop::Sorbet::HasSigil < ::RuboCop::Cop::Sorbet::ValidSigil
  # @return [Boolean]
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/has_sigil.rb#20
  def require_sigil_on_all_files?; end
end

# Makes the Sorbet `ignore` sigil mandatory in all files.
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/ignore_sigil.rb#10
class RuboCop::Cop::Sorbet::IgnoreSigil < ::RuboCop::Cop::Sorbet::HasSigil
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/ignore_sigil.rb#11
  def minimum_strictness; end
end

# Disallows declaring implicit conversion methods.
# Since Sorbet is a nominal (not structural) type system,
# implicit conversion is currently unsupported.
#
# @example
#
#   # bad
#   def to_str; end
#
#   # good
#   def to_str(x); end
#
#   # bad
#   def self.to_str; end
#
#   # good
#   def self.to_str(x); end
#
#   # bad
#   alias to_str to_s
# @note Since the arity of aliased methods is not checked, false positives may result.
# @see https://docs.ruby-lang.org/en/master/implicit_conversion_rdoc.html
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/implicit_conversion_method.rb#31
class RuboCop::Cop::Sorbet::ImplicitConversionMethod < ::RuboCop::Cop::Base
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/implicit_conversion_method.rb#37
  def on_alias(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/implicit_conversion_method.rb#42
  def on_def(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/implicit_conversion_method.rb#42
  def on_defs(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/implicit_conversion_method.rb#50
  def on_send(node); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/implicit_conversion_method.rb#32
RuboCop::Cop::Sorbet::ImplicitConversionMethod::IMPLICIT_CONVERSION_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/implicit_conversion_method.rb#33
RuboCop::Cop::Sorbet::ImplicitConversionMethod::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/implicit_conversion_method.rb#35
RuboCop::Cop::Sorbet::ImplicitConversionMethod::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the ordering of keyword arguments required by
# sorbet-runtime. The ordering requires that all keyword arguments
# are at the end of the parameters list, and all keyword arguments
# with a default value must be after those without default values.
#
# @example
#
#   # bad
#   sig { params(a: Integer, b: String).void }
#   def foo(a: 1, b:); end
#
#   # good
#   sig { params(b: String, a: Integer).void }
#   def foo(b:, a: 1); end
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/keyword_argument_ordering.rb#20
class RuboCop::Cop::Sorbet::KeywordArgumentOrdering < ::RuboCop::Cop::Cop
  include ::RuboCop::Cop::Sorbet::SignatureHelp

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/keyword_argument_ordering.rb#23
  def on_signature(node); end

  private

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/keyword_argument_ordering.rb#34
  def check_order_for_kwoptargs(parameters); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/mutable_constant_sorbet_aware_behaviour.rb#8
module RuboCop::Cop::Sorbet::MutableConstantSorbetAwareBehaviour
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/mutable_constant_sorbet_aware_behaviour.rb#18
  def on_assignment(value); end

  class << self
    # source://rubocop-sorbet//lib/rubocop/cop/sorbet/mutable_constant_sorbet_aware_behaviour.rb#10
    def prepended(base); end
  end
end

# Checks for the obsolete pattern for initializing instance variables that was required for older Sorbet
#
# It's no longer required, as of Sorbet 0.5.10210
# See https://sorbet.org/docs/type-assertions#put-type-assertions-behind-memoization
#
# @example
#
#   # bad
#   sig { returns(Foo) }
#   def foo
#   @foo = T.let(@foo, T.nilable(Foo))
#   @foo ||= Foo.new
#   end
#
#   # bad
#   sig { returns(Foo) }
#   def foo
#   # This would have been a mistake, causing the memoized value to be discarded and recomputed on every call.
#   @foo = T.let(nil, T.nilable(Foo))
#   @foo ||= Foo.new
#   end
#
#   # good
#   sig { returns(Foo) }
#   def foo
#   @foo ||= T.let(Foo.new, T.nilable(Foo))
#   end
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/obsolete_strict_memoization.rb#37
class RuboCop::Cop::Sorbet::ObsoleteStrictMemoization < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::MatchRange
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::LineLengthHelp
  include ::RuboCop::Cop::Sorbet::TargetSorbetVersion
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::Sorbet::TargetSorbetVersion::ClassMethods

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/obsolete_strict_memoization.rb#51
  def legacy_memoization_pattern?(param0 = T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/obsolete_strict_memoization.rb#62
  def on_begin(node); end

  # @return [Boolean]
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/obsolete_strict_memoization.rb#86
  def relevant_file?(file); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/obsolete_strict_memoization.rb#47
RuboCop::Cop::Sorbet::ObsoleteStrictMemoization::MSG = T.let(T.unsafe(nil), String)

# Ensures one ancestor per requires_ancestor line
# rather than chaining them as a comma-separated list.
#
# @example
#
#   # bad
#   module SomeModule
#   requires_ancestor Kernel, Minitest::Assertions
#   end
#
#   # good
#   module SomeModule
#   requires_ancestor Kernel
#   requires_ancestor Minitest::Assertions
#   end
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/one_ancestor_per_line.rb#24
class RuboCop::Cop::Sorbet::OneAncestorPerLine < ::RuboCop::Cop::Cop
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/one_ancestor_per_line.rb#38
  def abstract?(param0); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/one_ancestor_per_line.rb#56
  def autocorrect(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/one_ancestor_per_line.rb#33
  def more_than_one_ancestor(param0 = T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/one_ancestor_per_line.rb#49
  def on_class(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/one_ancestor_per_line.rb#42
  def on_module(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/one_ancestor_per_line.rb#28
  def requires_ancestors(param0); end

  private

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/one_ancestor_per_line.rb#72
  def new_ra_line(indent_count); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/one_ancestor_per_line.rb#66
  def process_node(node); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/one_ancestor_per_line.rb#25
RuboCop::Cop::Sorbet::OneAncestorPerLine::MSG = T.let(T.unsafe(nil), String)

# Forbids the use of redundant `extend T::Sig`. Only for use in
# applications that monkey patch `Module.include(T::Sig)` globally,
# which would make it redundant.
#
# @example
#   # bad
#   class Example
#   extend T::Sig
#   sig { void }
#   def no_op; end
#   end
#
#   # good
#   class Example
#   sig { void }
#   def no_op; end
#   end
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/redundant_extend_t_sig.rb#28
class RuboCop::Cop::Sorbet::RedundantExtendTSig < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/redundant_extend_t_sig.rb#36
  def extend_t_sig?(param0 = T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/redundant_extend_t_sig.rb#40
  def on_send(node); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/redundant_extend_t_sig.rb#32
RuboCop::Cop::Sorbet::RedundantExtendTSig::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/redundant_extend_t_sig.rb#33
RuboCop::Cop::Sorbet::RedundantExtendTSig::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the correct order of sig builder methods:
# - abstract, override, or overridable
# - type_parameters
# - params
# - returns, or void
# - soft, checked, or on_failure
#
#  # bad
#  sig { returns(Integer).params(x: Integer) }
#
#  # good
#  sig { params(x: Integer).returns(Integer) }
#
# @example
#   # bad
#   sig { void.abstract }
#
#   # good
#   sig { abstract.void }
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/signature_build_order.rb#31
class RuboCop::Cop::Sorbet::SignatureBuildOrder < ::RuboCop::Cop::Cop
  include ::RuboCop::Cop::Sorbet::SignatureHelp

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/signature_build_order.rb#77
  def autocorrect(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/signature_build_order.rb#53
  def on_signature(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/signature_build_order.rb#49
  def root_call(param0); end

  private

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/signature_build_order.rb#119
  def call_chain(sig_child_node); end

  # @return [Boolean]
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/signature_build_order.rb#115
  def can_autocorrect?; end

  # This method exists to reparse the current node with modern features enabled.
  # Modern features include "index send" emitting, which is necessary to unparse
  # "index sends" (i.e. `[]` calls) back to index accessors (i.e. as `foo[bar]``).
  # Otherwise, we would get the unparsed node as `foo.[](bar)`.
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/signature_build_order.rb#106
  def node_reparsed_with_modern_features(node); end
end

# Create a subclass of AST Builder that has modern features turned on
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/signature_build_order.rb#95
class RuboCop::Cop::Sorbet::SignatureBuildOrder::ModernBuilder < ::RuboCop::AST::Builder; end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/signatures/signature_build_order.rb#34
RuboCop::Cop::Sorbet::SignatureBuildOrder::ORDER = T.let(T.unsafe(nil), Hash)

# Mixin for writing cops for signatures, providing a `signature?` node matcher and an `on_signature` trigger.
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/mixin/signature_help.rb#7
module RuboCop::Cop::Sorbet::SignatureHelp
  extend ::RuboCop::AST::NodePattern::Macros

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/mixin/signature_help.rb#29
  def on_block(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/mixin/signature_help.rb#29
  def on_numblock(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/mixin/signature_help.rb#35
  def on_signature(_node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/mixin/signature_help.rb#11
  def signature?(param0 = T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/mixin/signature_help.rb#20
  def with_runtime?(param0 = T.unsafe(nil)); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/mixin/signature_help.rb#25
  def without_runtime?(param0 = T.unsafe(nil)); end
end

# Ensures empty class/module definitions in RBI files are
# done on a single line rather than being split across multiple lines.
#
# @example
#
#   # bad
#   module SomeModule
#   end
#
#   # good
#   module SomeModule; end
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/rbi/single_line_rbi_class_module_definitions.rb#17
class RuboCop::Cop::Sorbet::SingleLineRbiClassModuleDefinitions < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/rbi/single_line_rbi_class_module_definitions.rb#22
  def on_class(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/rbi/single_line_rbi_class_module_definitions.rb#22
  def on_module(node); end

  private

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/rbi/single_line_rbi_class_module_definitions.rb#34
  def convert_newlines_to_semicolons(source); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/rbi/single_line_rbi_class_module_definitions.rb#20
RuboCop::Cop::Sorbet::SingleLineRbiClassModuleDefinitions::MSG = T.let(T.unsafe(nil), String)

# Makes the Sorbet `strict` sigil mandatory in all files.
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/strict_sigil.rb#10
class RuboCop::Cop::Sorbet::StrictSigil < ::RuboCop::Cop::Sorbet::HasSigil
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/strict_sigil.rb#11
  def minimum_strictness; end
end

# Makes the Sorbet `strong` sigil mandatory in all files.
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/strong_sigil.rb#10
class RuboCop::Cop::Sorbet::StrongSigil < ::RuboCop::Cop::Sorbet::HasSigil
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/strong_sigil.rb#11
  def minimum_strictness; end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/mixin/target_sorbet_version.rb#6
module RuboCop::Cop::Sorbet::TargetSorbetVersion
  mixes_in_class_methods ::RuboCop::Cop::Sorbet::TargetSorbetVersion::ClassMethods

  # @return [Boolean]
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/mixin/target_sorbet_version.rb#28
  def enabled_for_sorbet_static_version?; end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/mixin/target_sorbet_version.rb#44
  def read_sorbet_static_version_from_bundler_lock_file; end

  # @return [Boolean]
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/mixin/target_sorbet_version.rb#24
  def sorbet_enabled?; end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/mixin/target_sorbet_version.rb#35
  def target_sorbet_static_version_from_bundler_lock_file; end

  class << self
    # @private
    #
    # source://rubocop-sorbet//lib/rubocop/cop/sorbet/mixin/target_sorbet_version.rb#8
    def included(target); end
  end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/mixin/target_sorbet_version.rb#13
module RuboCop::Cop::Sorbet::TargetSorbetVersion::ClassMethods
  # Sets the version of the Sorbet static type checker required by this cop
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/mixin/target_sorbet_version.rb#15
  def minimum_target_sorbet_static_version(version); end

  # @return [Boolean]
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/mixin/target_sorbet_version.rb#19
  def supports_target_sorbet_static_version?(version); end
end

# Makes the Sorbet `true` sigil mandatory in all files.
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/true_sigil.rb#10
class RuboCop::Cop::Sorbet::TrueSigil < ::RuboCop::Cop::Sorbet::HasSigil
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/true_sigil.rb#11
  def minimum_strictness; end
end

# Ensures all constants used as `T.type_alias` are using CamelCase.
#
# @example
#
#   # bad
#   FOO_OR_BAR = T.type_alias { T.any(Foo, Bar) }
#
#   # good
#   FooOrBar = T.type_alias { T.any(Foo, Bar) }
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/type_alias_name.rb#17
class RuboCop::Cop::Sorbet::TypeAliasName < ::RuboCop::Cop::Base
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/type_alias_name.rb#32
  def on_casgn(node); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/type_alias_name.rb#21
  def underscored_type_alias?(param0 = T.unsafe(nil)); end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/type_alias_name.rb#18
RuboCop::Cop::Sorbet::TypeAliasName::MSG = T.let(T.unsafe(nil), String)

# Checks that every Ruby file contains a valid Sorbet sigil.
# Adapted from: https://gist.github.com/clarkdave/85aca4e16f33fd52aceb6a0a29936e52
#
# Options:
#
# * `RequireSigilOnAllFiles`: make offense if the Sorbet typed is not found in the file (default: false)
# * `SuggestedStrictness`: Sorbet strictness level suggested in offense messages (default: 'false')
# * `MinimumStrictness`: If set, make offense if the strictness level in the file is below this one
# * `ExactStrictness`: If set, make offense if the strictness level in the file is different than this one
#
# If an `ExactStrictness` level is specified, it will be used in offense messages and autocorrect.
# Otherwise, if a `MinimumStrictness` level is specified, it will be used in offense messages and autocorrect.
#
# source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/valid_sigil.rb#20
class RuboCop::Cop::Sorbet::ValidSigil < ::RuboCop::Cop::Cop
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/valid_sigil.rb#35
  def autocorrect(_node); end

  # So we can properly subclass this cop
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/valid_sigil.rb#23
  def investigate(processed_source); end

  protected

  # checks
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/valid_sigil.rb#70
  def check_sigil_present(sigil); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/valid_sigil.rb#130
  def check_strictness_level(sigil, strictness); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/valid_sigil.rb#108
  def check_strictness_not_empty(sigil, strictness); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/valid_sigil.rb#119
  def check_strictness_valid(sigil, strictness); end

  # Default is `nil`
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/valid_sigil.rb#180
  def exact_strictness; end

  # extraction
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/valid_sigil.rb#58
  def extract_sigil(processed_source); end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/valid_sigil.rb#64
  def extract_strictness(sigil); end

  # Default is `nil`
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/valid_sigil.rb#174
  def minimum_strictness; end

  # Default is `false`
  #
  # @return [Boolean]
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/valid_sigil.rb#163
  def require_sigil_on_all_files?; end

  # Default is `'false'`
  #
  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/valid_sigil.rb#168
  def suggested_strictness; end

  # source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/valid_sigil.rb#86
  def suggested_strictness_level; end
end

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/valid_sigil.rb#54
RuboCop::Cop::Sorbet::ValidSigil::SIGIL_REGEX = T.let(T.unsafe(nil), Regexp)

# source://rubocop-sorbet//lib/rubocop/cop/sorbet/sigils/valid_sigil.rb#53
RuboCop::Cop::Sorbet::ValidSigil::STRICTNESS_LEVELS = T.let(T.unsafe(nil), Array)

module RuboCop::Cop::Style; end

class RuboCop::Cop::Style::MutableConstant < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Sorbet::MutableConstantSorbetAwareBehaviour
end

# source://rubocop-sorbet//lib/rubocop/sorbet/version.rb#4
module RuboCop::Sorbet; end

# source://rubocop-sorbet//lib/rubocop/sorbet.rb#12
RuboCop::Sorbet::CONFIG = T.let(T.unsafe(nil), Hash)

# source://rubocop-sorbet//lib/rubocop/sorbet.rb#11
RuboCop::Sorbet::CONFIG_DEFAULT = T.let(T.unsafe(nil), Pathname)

# source://rubocop-sorbet//lib/rubocop/sorbet.rb#8
class RuboCop::Sorbet::Error < ::StandardError; end

# Because RuboCop doesn't yet support plugins, we have to monkey patch in a
# bit of our configuration.
#
# source://rubocop-sorbet//lib/rubocop/sorbet/inject.rb#9
module RuboCop::Sorbet::Inject
  class << self
    # source://rubocop-sorbet//lib/rubocop/sorbet/inject.rb#11
    def defaults!; end
  end
end

# source://rubocop-sorbet//lib/rubocop/sorbet.rb#10
RuboCop::Sorbet::PROJECT_ROOT = T.let(T.unsafe(nil), Pathname)

# source://rubocop-sorbet//lib/rubocop/sorbet/version.rb#5
RuboCop::Sorbet::VERSION = T.let(T.unsafe(nil), String)
