# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `ruby-macho` gem.
# Please instead update this file by running `bin/tapioca gem ruby-macho`.

# The primary namespace for ruby-macho.
#
# source://ruby-macho//lib/macho/utils.rb#3
module MachO
  class << self
    # Signs the dylib using an ad-hoc identity.
    # Necessary after making any changes to a dylib, since otherwise
    # changing a signed file invalidates its signature.
    #
    # @param filename [String] the file being opened
    # @raise [ModificationError] if the operation fails
    # @return [void]
    #
    # source://ruby-macho//lib/macho.rb#51
    def codesign!(filename); end

    # Opens the given filename as a MachOFile or FatFile, depending on its magic.
    #
    # @param filename [String] the file being opened
    # @raise [ArgumentError] if the given file does not exist
    # @raise [TruncatedFileError] if the file is too small to have a valid header
    # @raise [MagicError] if the file's magic is not valid Mach-O magic
    # @return [MachOFile] if the file is a Mach-O
    # @return [FatFile] if the file is a Fat file
    #
    # source://ruby-macho//lib/macho.rb#28
    def open(filename); end
  end
end

# Raised when the CPU type/sub-type pair is unknown.
#
# source://ruby-macho//lib/macho/exceptions.rb#106
class MachO::CPUSubtypeError < ::MachO::MachOError
  # @param cputype [Integer] the CPU type of the unknown pair
  # @param cpusubtype [Integer] the CPU sub-type of the unknown pair
  # @return [CPUSubtypeError] a new instance of CPUSubtypeError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#107
  def initialize(cputype, cpusubtype); end
end

# Raised when the CPU type is unknown.
#
# source://ruby-macho//lib/macho/exceptions.rb#97
class MachO::CPUTypeError < ::MachO::MachOError
  # @param cputype [Integer] the unknown CPU type
  # @return [CPUTypeError] a new instance of CPUTypeError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#98
  def initialize(cputype); end
end

# Raised when there is a mismatch between the fat arch
# and internal slice cputype or cpusubtype.
#
# source://ruby-macho//lib/macho/exceptions.rb#68
class MachO::CPUTypeMismatchError < ::MachO::NotAMachOError
  # @return [CPUTypeMismatchError] a new instance of CPUTypeMismatchError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#69
  def initialize(fat_cputype, fat_cpusubtype, macho_cputype, macho_cpusubtype); end
end

# Raised when codesigning fails. Certain environments
# may want to rescue this to treat it as non-fatal.
#
# source://ruby-macho//lib/macho/exceptions.rb#14
class MachO::CodeSigningError < ::MachO::MachOError; end

# Raised when attempting to parse a compressed Mach-O without explicitly
# requesting decompression.
#
# source://ruby-macho//lib/macho/exceptions.rb#235
class MachO::CompressedMachOError < ::MachO::MachOError; end

# Raised when attempting to decompress a compressed Mach-O without adequate
# dependencies, or on other decompression errors.
#
# source://ruby-macho//lib/macho/exceptions.rb#240
class MachO::DecompressionError < ::MachO::MachOError; end

# Raised when a dylib is missing an ID
#
# source://ruby-macho//lib/macho/exceptions.rb#193
class MachO::DylibIdMissingError < ::MachO::RecoverableModificationError
  # @return [DylibIdMissingError] a new instance of DylibIdMissingError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#194
  def initialize; end
end

# Raised when attempting to change a dylib name that doesn't exist.
#
# source://ruby-macho//lib/macho/exceptions.rb#186
class MachO::DylibUnknownError < ::MachO::RecoverableModificationError
  # @param dylib [String] the unknown shared library name
  # @return [DylibUnknownError] a new instance of DylibUnknownError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#187
  def initialize(dylib); end
end

# Raised when attempting to create a {FatFile} from one or more {MachOFile}s
#  whose offsets will not fit within the resulting 32-bit {Headers::FatArch#offset} fields.
#
# source://ruby-macho//lib/macho/exceptions.rb#226
class MachO::FatArchOffsetOverflowError < ::MachO::MachOError
  # @param offset [Integer] the offending offset
  # @return [FatArchOffsetOverflowError] a new instance of FatArchOffsetOverflowError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#227
  def initialize(offset); end
end

# Raised when a fat binary is loaded with MachOFile.
#
# source://ruby-macho//lib/macho/exceptions.rb#82
class MachO::FatBinaryError < ::MachO::MachOError
  # @return [FatBinaryError] a new instance of FatBinaryError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#83
  def initialize; end
end

# Represents a "Fat" file, which contains a header, a listing of available
# architectures, and one or more Mach-O binaries.
#
# @see https://en.wikipedia.org/wiki/Mach-O#Multi-architecture_binaries
# @see MachOFile
#
# source://ruby-macho//lib/macho/fat_file.rb#10
class MachO::FatFile
  extend ::Forwardable

  # Creates a new FatFile from the given filename.
  #
  # @note see {MachOFile#initialize} for currently valid options
  # @param filename [String] the fat file to load from
  # @param opts [Hash] options to control the parser with
  # @raise [ArgumentError] if the given file does not exist
  # @return [FatFile] a new instance of FatFile
  #
  # source://ruby-macho//lib/macho/fat_file.rb#94
  def initialize(filename, **opts); end

  # Add the given runtime path to the file's Mach-Os.
  #
  # @option options
  # @param path [String] the new runtime path
  # @param options [Hash]
  # @return [void]
  # @see MachOFile#add_rpath
  #
  # source://ruby-macho//lib/macho/fat_file.rb#260
  def add_rpath(path, options = T.unsafe(nil)); end

  # @return [Boolean] whether or not the file is of type `MH_BUNDLE`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def bundle?(*args, **_arg1, &block); end

  # Changes all dependent shared library install names from `old_name` to
  # `new_name`. In a fat file, this changes install names in all internal
  # Mach-Os.
  #
  # @example
  #   file.change_install_name('/usr/lib/libFoo.dylib', '/usr/lib/libBar.dylib')
  # @option options
  # @param old_name [String] the shared library name being changed
  # @param new_name [String] the new name
  # @param options [Hash]
  # @return [void]
  # @see MachOFile#change_install_name
  #
  # source://ruby-macho//lib/macho/fat_file.rb#217
  def change_dylib(old_name, new_name, options = T.unsafe(nil)); end

  # Changes the file's dylib ID to `new_id`. If the file is not a dylib,
  #  does nothing.
  #
  # @example
  #   file.change_dylib_id('libFoo.dylib')
  # @option options
  # @param new_id [String] the new dylib ID
  # @param options [Hash]
  # @raise [ArgumentError] if `new_id` is not a String
  # @return [void]
  # @see MachOFile#linked_dylibs
  #
  # source://ruby-macho//lib/macho/fat_file.rb#182
  def change_dylib_id(new_id, options = T.unsafe(nil)); end

  # Changes all dependent shared library install names from `old_name` to
  # `new_name`. In a fat file, this changes install names in all internal
  # Mach-Os.
  #
  # @example
  #   file.change_install_name('/usr/lib/libFoo.dylib', '/usr/lib/libBar.dylib')
  # @option options
  # @param old_name [String] the shared library name being changed
  # @param new_name [String] the new name
  # @param options [Hash]
  # @return [void]
  # @see MachOFile#change_install_name
  #
  # source://ruby-macho//lib/macho/fat_file.rb#217
  def change_install_name(old_name, new_name, options = T.unsafe(nil)); end

  # Change the runtime path `old_path` to `new_path` in the file's Mach-Os.
  #
  # @option options
  # @option options
  # @param old_path [String] the old runtime path
  # @param new_path [String] the new runtime path
  # @param options [Hash]
  # @return [void]
  # @see MachOFile#change_rpath
  #
  # source://ruby-macho//lib/macho/fat_file.rb#245
  def change_rpath(old_path, new_path, options = T.unsafe(nil)); end

  # @return [Boolean] whether or not the file is of type `MH_CORE`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def core?(*args, **_arg1, &block); end

  # Delete the given runtime path from the file's Mach-Os.
  #
  # @option options
  # @option options
  # @param path [String] the runtime path to delete
  # @param options [Hash]
  # @return void
  # @see MachOFile#delete_rpath
  #
  # source://ruby-macho//lib/macho/fat_file.rb#278
  def delete_rpath(path, options = T.unsafe(nil)); end

  # @return [Boolean] whether or not the file is of type `MH_DSYM`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def dsym?(*args, **_arg1, &block); end

  # @return [Boolean] whether or not the file is of type `MH_DYLIB`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def dylib?(*args, **_arg1, &block); end

  # @return [String, nil] the Mach-O's dylib ID
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def dylib_id(*args, **_arg1, &block); end

  # Changes the file's dylib ID to `new_id`. If the file is not a dylib,
  #  does nothing.
  #
  # @example
  #   file.change_dylib_id('libFoo.dylib')
  # @option options
  # @param new_id [String] the new dylib ID
  # @param options [Hash]
  # @raise [ArgumentError] if `new_id` is not a String
  # @return [void]
  # @see MachOFile#linked_dylibs
  #
  # source://ruby-macho//lib/macho/fat_file.rb#182
  def dylib_id=(new_id, options = T.unsafe(nil)); end

  # All load commands responsible for loading dylibs in the file's Mach-O's.
  #
  # @return [Array<LoadCommands::DylibCommand>] an array of DylibCommands
  #
  # source://ruby-macho//lib/macho/fat_file.rb#167
  def dylib_load_commands; end

  # @return [Boolean] whether or not the file is of type `MH_DYLINKER`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def dylinker?(*args, **_arg1, &block); end

  # @return [Boolean] whether or not the file is of type `MH_EXECUTE`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def executable?(*args, **_arg1, &block); end

  # Extract a Mach-O with the given CPU type from the file.
  #
  # @example
  #   file.extract(:i386) # => MachO::MachOFile
  # @param cputype [Symbol] the CPU type of the Mach-O being extracted
  # @return [MachOFile, nil] the extracted Mach-O or nil if no Mach-O has the given CPU type
  #
  # source://ruby-macho//lib/macho/fat_file.rb#291
  def extract(cputype); end

  # @return [Array<Headers::FatArch>, Array<Headers::FatArch64] an array of fat architectures] Array<Headers::FatArch>, Array<Headers::FatArch64] an array of fat architectures
  #
  # source://ruby-macho//lib/macho/fat_file.rb#24
  def fat_archs; end

  # @return [String] the filename loaded from, or nil if loaded from a binary string
  #
  # source://ruby-macho//lib/macho/fat_file.rb#14
  def filename; end

  # @return [String] the filename loaded from, or nil if loaded from a binary string
  #
  # source://ruby-macho//lib/macho/fat_file.rb#14
  def filename=(_arg0); end

  # @return [Symbol] a string representation of the Mach-O's filetype
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def filetype(*args, **_arg1, &block); end

  # @return [Boolean] whether or not the file is of type `MH_FVMLIB`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def fvmlib?(*args, **_arg1, &block); end

  # @return [Headers::FatHeader] the file's header
  #
  # source://ruby-macho//lib/macho/fat_file.rb#21
  def header; end

  # Initializes a new FatFile instance from a binary string with the given options.
  #
  # @api private
  # @see new_from_bin
  #
  # source://ruby-macho//lib/macho/fat_file.rb#106
  def initialize_from_bin(bin, opts); end

  # @return [Boolean] whether or not the file is of type `MH_KEXT_BUNDLE`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def kext?(*args, **_arg1, &block); end

  # All shared libraries linked to the file's Mach-Os.
  #
  # @return [Array<String>] an array of all shared libraries
  # @see MachOFile#linked_dylibs
  #
  # source://ruby-macho//lib/macho/fat_file.rb#198
  def linked_dylibs; end

  # @return [Array<MachOFile>] an array of Mach-O binaries
  #
  # source://ruby-macho//lib/macho/fat_file.rb#27
  def machos; end

  # @return [Integer] the magic number of the header (and file)
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def magic(*args, **_arg1, &block); end

  # @return [String] a string representation of the file's magic number
  #
  # source://ruby-macho//lib/macho/fat_file.rb#152
  def magic_string; end

  # @return [Boolean] whether or not the file is of type `MH_OBJECT`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def object?(*args, **_arg1, &block); end

  # @note Options specified in a {FatFile} trickle down into the internal {MachOFile}s.
  # @return [Hash] any parser options that the instance was created with
  #
  # source://ruby-macho//lib/macho/fat_file.rb#18
  def options; end

  # Populate the instance's fields with the raw Fat Mach-O data.
  #
  # @note This method is public, but should (almost) never need to be called.
  # @return [void]
  #
  # source://ruby-macho//lib/macho/fat_file.rb#159
  def populate_fields; end

  # @return [Boolean] whether or not the file is of type `MH_PRELOAD`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def preload?(*args, **_arg1, &block); end

  # All runtime paths associated with the file's Mach-Os.
  #
  # @return [Array<String>] an array of all runtime paths
  # @see MachOFile#rpaths
  #
  # source://ruby-macho//lib/macho/fat_file.rb#230
  def rpaths; end

  # The file's raw fat data.
  #
  # @return [String] the raw fat data
  #
  # source://ruby-macho//lib/macho/fat_file.rb#115
  def serialize; end

  # @return [Hash] a hash representation of this {FatFile}
  #
  # source://ruby-macho//lib/macho/fat_file.rb#313
  def to_h; end

  # Write all (fat) data to the given filename.
  #
  # @param filename [String] the file to write to
  # @return [void]
  #
  # source://ruby-macho//lib/macho/fat_file.rb#298
  def write(filename); end

  # Write all (fat) data to the file used to initialize the instance.
  #
  # @note Overwrites all data in the file!
  # @raise [MachOError] if the instance was initialized without a file
  # @return [void]
  #
  # source://ruby-macho//lib/macho/fat_file.rb#306
  def write!; end

  private

  # Return a single-arch Mach-O that represents this fat Mach-O for purposes
  #  of delegation.
  #
  # @api private
  # @return [MachOFile] the Mach-O file
  #
  # source://ruby-macho//lib/macho/fat_file.rb#436
  def canonical_macho; end

  # Yield each Mach-O object in the file, rescuing and accumulating errors.
  #
  # @api private
  # @option options
  # @param options [Hash]
  # @raise [RecoverableModificationError] under the conditions of
  #   the `:strict` option above.
  #
  # source://ruby-macho//lib/macho/fat_file.rb#413
  def each_macho(options = T.unsafe(nil)); end

  # Obtain an array of fat architectures from raw file data.
  #
  # @api private
  # @return [Array<Headers::FatArch>] an array of fat architectures
  #
  # source://ruby-macho//lib/macho/fat_file.rb#360
  def populate_fat_archs; end

  # Obtain the fat header from raw file data.
  #
  # @api private
  # @raise [TruncatedFileError] if the file is too small to have a
  #   valid header
  # @raise [MagicError] if the magic is not valid Mach-O magic
  # @raise [MachOBinaryError] if the magic is for a non-fat Mach-O file
  # @raise [JavaClassFileError] if the file is a Java classfile
  # @raise [ZeroArchitectureError] if the file has no internal slices
  #   (i.e., nfat_arch == 0) and the permissive option is not set
  # @return [Headers::FatHeader] the fat header
  #
  # source://ruby-macho//lib/macho/fat_file.rb#333
  def populate_fat_header; end

  # Obtain an array of Mach-O blobs from raw file data.
  #
  # @api private
  # @return [Array<MachOFile>] an array of Mach-Os
  #
  # source://ruby-macho//lib/macho/fat_file.rb#377
  def populate_machos; end

  # Repopulate the raw Mach-O data with each internal Mach-O object.
  #
  # @api private
  # @return [void]
  #
  # source://ruby-macho//lib/macho/fat_file.rb#397
  def repopulate_raw_machos; end

  class << self
    # Creates a new FatFile instance from a binary string.
    #
    # @note see {MachOFile#initialize} for currently valid options
    # @param bin [String] a binary string containing raw Mach-O data
    # @param opts [Hash] options to control the parser with
    # @return [FatFile] a new FatFile
    #
    # source://ruby-macho//lib/macho/fat_file.rb#82
    def new_from_bin(bin, **opts); end

    # Creates a new FatFile from the given (single-arch) Mach-Os
    #
    # @param machos [Array<MachOFile>] the machos to combine
    # @param fat64 [Boolean] whether to use {Headers::FatArch64}s to represent each slice
    # @raise [ArgumentError] if less than one Mach-O is given
    # @raise [FatArchOffsetOverflowError] if the Mach-Os are too big to be represented
    #   in a 32-bit {Headers::FatArch} and `fat64` is `false`.
    # @return [FatFile] a new FatFile containing the give machos
    #
    # source://ruby-macho//lib/macho/fat_file.rb#36
    def new_from_machos(*machos, fat64: T.unsafe(nil)); end
  end
end

# Raised when a mach-o file's filetype field is unknown.
#
# source://ruby-macho//lib/macho/exceptions.rb#115
class MachO::FiletypeError < ::MachO::MachOError
  # @param num [Integer] the unknown number
  # @return [FiletypeError] a new instance of FiletypeError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#116
  def initialize(num); end
end

# Raised when load commands are too large to fit in the current file.
#
# source://ruby-macho//lib/macho/exceptions.rb#176
class MachO::HeaderPadError < ::MachO::ModificationError
  # @param filename [String] the filename
  # @return [HeaderPadError] a new instance of HeaderPadError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#177
  def initialize(filename); end
end

# Classes and constants for parsing the headers of Mach-O binaries.
#
# source://ruby-macho//lib/macho/headers.rb#5
module MachO::Headers; end

# compressed mach-o magic
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#42
MachO::Headers::COMPRESSED_MAGIC = T.let(T.unsafe(nil), Integer)

# a compressed mach-o slice, using LZVN ("FastLib") for compression
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#50
MachO::Headers::COMP_TYPE_FASTLIB = T.let(T.unsafe(nil), Integer)

# a compressed mach-o slice, using LZSS for compression
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#46
MachO::Headers::COMP_TYPE_LZSS = T.let(T.unsafe(nil), Integer)

# mask for CPUs with 64-bit architectures (when running a 32-bit ABI?)
#
# @api private
# @see https://github.com/Homebrew/ruby-macho/issues/113
#
# source://ruby-macho//lib/macho/headers.rb#70
MachO::Headers::CPU_ARCH_ABI32 = T.let(T.unsafe(nil), Integer)

# mask for CPUs with 64-bit architectures (when running a 64-bit ABI?)
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#65
MachO::Headers::CPU_ARCH_ABI64 = T.let(T.unsafe(nil), Integer)

# association of CPU types/subtype pairs to symbol representations in
# (very) roughly descending order of commonness
#
# @api private
# @see https://opensource.apple.com/source/cctools/cctools-877.8/libstuff/arch.c
#
# source://ruby-macho//lib/macho/headers.rb#338
MachO::Headers::CPU_SUBTYPES = T.let(T.unsafe(nil), Hash)

# the i486 sub-type for `CPU_TYPE_I386`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#140
MachO::Headers::CPU_SUBTYPE_486 = T.let(T.unsafe(nil), Integer)

# the i486SX sub-type for `CPU_TYPE_I386`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#144
MachO::Headers::CPU_SUBTYPE_486SX = T.let(T.unsafe(nil), Integer)

# the i586 (P5, Pentium) sub-type for `CPU_TYPE_I386`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#148
MachO::Headers::CPU_SUBTYPE_586 = T.let(T.unsafe(nil), Integer)

# the e (A12) sub-type for `CPU_TYPE_ARM64`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#260
MachO::Headers::CPU_SUBTYPE_ARM64E = T.let(T.unsafe(nil), Integer)

# the v8 sub-type for `CPU_TYPE_ARM64_32`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#256
MachO::Headers::CPU_SUBTYPE_ARM64_32_V8 = T.let(T.unsafe(nil), Integer)

# the lowest common sub-type for `CPU_TYPE_ARM64`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#248
MachO::Headers::CPU_SUBTYPE_ARM64_ALL = T.let(T.unsafe(nil), Integer)

# the v8 sub-type for `CPU_TYPE_ARM64`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#252
MachO::Headers::CPU_SUBTYPE_ARM64_V8 = T.let(T.unsafe(nil), Integer)

# the lowest common sub-type for `CPU_TYPE_ARM`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#196
MachO::Headers::CPU_SUBTYPE_ARM_ALL = T.let(T.unsafe(nil), Integer)

# the v4t sub-type for `CPU_TYPE_ARM`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#200
MachO::Headers::CPU_SUBTYPE_ARM_V4T = T.let(T.unsafe(nil), Integer)

# the v5 sub-type for `CPU_TYPE_ARM`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#208
MachO::Headers::CPU_SUBTYPE_ARM_V5TEJ = T.let(T.unsafe(nil), Integer)

# the v6 sub-type for `CPU_TYPE_ARM`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#204
MachO::Headers::CPU_SUBTYPE_ARM_V6 = T.let(T.unsafe(nil), Integer)

# the v6m sub-type for `CPU_TYPE_ARM`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#232
MachO::Headers::CPU_SUBTYPE_ARM_V6M = T.let(T.unsafe(nil), Integer)

# the v7 sub-type for `CPU_TYPE_ARM`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#216
MachO::Headers::CPU_SUBTYPE_ARM_V7 = T.let(T.unsafe(nil), Integer)

# the v7em sub-type for `CPU_TYPE_ARM`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#240
MachO::Headers::CPU_SUBTYPE_ARM_V7EM = T.let(T.unsafe(nil), Integer)

# the v7f (Cortex A9) sub-type for `CPU_TYPE_ARM`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#220
MachO::Headers::CPU_SUBTYPE_ARM_V7F = T.let(T.unsafe(nil), Integer)

# the v7k ("Kirkwood40") sub-type for `CPU_TYPE_ARM`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#228
MachO::Headers::CPU_SUBTYPE_ARM_V7K = T.let(T.unsafe(nil), Integer)

# the v7m sub-type for `CPU_TYPE_ARM`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#236
MachO::Headers::CPU_SUBTYPE_ARM_V7M = T.let(T.unsafe(nil), Integer)

# the v7s ("Swift") sub-type for `CPU_TYPE_ARM`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#224
MachO::Headers::CPU_SUBTYPE_ARM_V7S = T.let(T.unsafe(nil), Integer)

# the v8 sub-type for `CPU_TYPE_ARM`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#244
MachO::Headers::CPU_SUBTYPE_ARM_V8 = T.let(T.unsafe(nil), Integer)

# the xscale (v5 family) sub-type for `CPU_TYPE_ARM`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#212
MachO::Headers::CPU_SUBTYPE_ARM_XSCALE = T.let(T.unsafe(nil), Integer)

# the lowest common sub-type for `CPU_TYPE_I386`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#136
MachO::Headers::CPU_SUBTYPE_I386 = T.let(T.unsafe(nil), Integer)

# 64-bit libraries (undocumented!)
#
# @api private
# @see http://llvm.org/docs/doxygen/html/Support_2MachO_8h_source.html
#
# source://ruby-macho//lib/macho/headers.rb#132
MachO::Headers::CPU_SUBTYPE_LIB64 = T.let(T.unsafe(nil), Integer)

# mask for CPU subtype capabilities
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#127
MachO::Headers::CPU_SUBTYPE_MASK = T.let(T.unsafe(nil), Integer)

# @api private
# @see CPU_SUBTYPE_MC680X0_ALL
#
# source://ruby-macho//lib/macho/headers.rb#176
MachO::Headers::CPU_SUBTYPE_MC68030 = T.let(T.unsafe(nil), Integer)

# the 030 subtype for `CPU_TYPE_MC680X0`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#184
MachO::Headers::CPU_SUBTYPE_MC68030_ONLY = T.let(T.unsafe(nil), Integer)

# the 040 subtype for `CPU_TYPE_MC680X0`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#180
MachO::Headers::CPU_SUBTYPE_MC68040 = T.let(T.unsafe(nil), Integer)

# the lowest common sub-type for `CPU_TYPE_MC680X0`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#172
MachO::Headers::CPU_SUBTYPE_MC680X0_ALL = T.let(T.unsafe(nil), Integer)

# the lowest common sub-type for `CPU_TYPE_MC88000`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#264
MachO::Headers::CPU_SUBTYPE_MC88000_ALL = T.let(T.unsafe(nil), Integer)

# the 100 sub-type for `CPU_TYPE_MC88000`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#272
MachO::Headers::CPU_SUBTYPE_MC88100 = T.let(T.unsafe(nil), Integer)

# the 110 sub-type for `CPU_TYPE_MC88000`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#276
MachO::Headers::CPU_SUBTYPE_MC88110 = T.let(T.unsafe(nil), Integer)

# @api private
# @see CPU_SUBTYPE_MC88000_ALL
#
# source://ruby-macho//lib/macho/headers.rb#268
MachO::Headers::CPU_SUBTYPE_MMAX_JPC = T.let(T.unsafe(nil), Integer)

# @api private
# @see CPU_SUBTYPE_586
#
# source://ruby-macho//lib/macho/headers.rb#152
MachO::Headers::CPU_SUBTYPE_PENT = T.let(T.unsafe(nil), Integer)

# the Pentium II (P6, M3?) sub-type for `CPU_TYPE_I386`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#160
MachO::Headers::CPU_SUBTYPE_PENTII_M3 = T.let(T.unsafe(nil), Integer)

# the Pentium II (P6, M5?) sub-type for `CPU_TYPE_I386`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#164
MachO::Headers::CPU_SUBTYPE_PENTII_M5 = T.let(T.unsafe(nil), Integer)

# the Pentium 4 (Netburst) sub-type for `CPU_TYPE_I386`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#168
MachO::Headers::CPU_SUBTYPE_PENTIUM_4 = T.let(T.unsafe(nil), Integer)

# the Pentium Pro (P6) sub-type for `CPU_TYPE_I386`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#156
MachO::Headers::CPU_SUBTYPE_PENTPRO = T.let(T.unsafe(nil), Integer)

# any CPU sub-type for CPU type `CPU_TYPE_POWERPC64`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#332
MachO::Headers::CPU_SUBTYPE_POWERPC64_ALL = T.let(T.unsafe(nil), Integer)

# the 601 sub-type for `CPU_TYPE_POWERPC`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#284
MachO::Headers::CPU_SUBTYPE_POWERPC_601 = T.let(T.unsafe(nil), Integer)

# the 602 sub-type for `CPU_TYPE_POWERPC`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#288
MachO::Headers::CPU_SUBTYPE_POWERPC_602 = T.let(T.unsafe(nil), Integer)

# the 603 sub-type for `CPU_TYPE_POWERPC`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#292
MachO::Headers::CPU_SUBTYPE_POWERPC_603 = T.let(T.unsafe(nil), Integer)

# the 603e (G2) sub-type for `CPU_TYPE_POWERPC`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#296
MachO::Headers::CPU_SUBTYPE_POWERPC_603E = T.let(T.unsafe(nil), Integer)

# the 603ev sub-type for `CPU_TYPE_POWERPC`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#300
MachO::Headers::CPU_SUBTYPE_POWERPC_603EV = T.let(T.unsafe(nil), Integer)

# the 604 sub-type for `CPU_TYPE_POWERPC`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#304
MachO::Headers::CPU_SUBTYPE_POWERPC_604 = T.let(T.unsafe(nil), Integer)

# the 604e sub-type for `CPU_TYPE_POWERPC`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#308
MachO::Headers::CPU_SUBTYPE_POWERPC_604E = T.let(T.unsafe(nil), Integer)

# the 620 sub-type for `CPU_TYPE_POWERPC`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#312
MachO::Headers::CPU_SUBTYPE_POWERPC_620 = T.let(T.unsafe(nil), Integer)

# the 7400 (G4) sub-type for `CPU_TYPE_POWERPC`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#320
MachO::Headers::CPU_SUBTYPE_POWERPC_7400 = T.let(T.unsafe(nil), Integer)

# the 7450 (G4 "Voyager") sub-type for `CPU_TYPE_POWERPC`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#324
MachO::Headers::CPU_SUBTYPE_POWERPC_7450 = T.let(T.unsafe(nil), Integer)

# the 750 (G3) sub-type for `CPU_TYPE_POWERPC`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#316
MachO::Headers::CPU_SUBTYPE_POWERPC_750 = T.let(T.unsafe(nil), Integer)

# the 970 (G5) sub-type for `CPU_TYPE_POWERPC`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#328
MachO::Headers::CPU_SUBTYPE_POWERPC_970 = T.let(T.unsafe(nil), Integer)

# the lowest common sub-type for `CPU_TYPE_POWERPC`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#280
MachO::Headers::CPU_SUBTYPE_POWERPC_ALL = T.let(T.unsafe(nil), Integer)

# the lowest common sub-type for `CPU_TYPE_X86_64`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#188
MachO::Headers::CPU_SUBTYPE_X86_64_ALL = T.let(T.unsafe(nil), Integer)

# the Haskell sub-type for `CPU_TYPE_X86_64`
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#192
MachO::Headers::CPU_SUBTYPE_X86_64_H = T.let(T.unsafe(nil), Integer)

# association of cpu types to symbol representations
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#114
MachO::Headers::CPU_TYPES = T.let(T.unsafe(nil), Hash)

# any CPU (unused?)
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#74
MachO::Headers::CPU_TYPE_ANY = T.let(T.unsafe(nil), Integer)

# 32-bit ARM compatible CPUs
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#90
MachO::Headers::CPU_TYPE_ARM = T.let(T.unsafe(nil), Integer)

# 64-bit ARM compatible CPUs
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#98
MachO::Headers::CPU_TYPE_ARM64 = T.let(T.unsafe(nil), Integer)

# 64-bit ARM compatible CPUs (running in 32-bit mode?)
#
# @see https://github.com/Homebrew/ruby-macho/issues/113
#
# source://ruby-macho//lib/macho/headers.rb#102
MachO::Headers::CPU_TYPE_ARM64_32 = T.let(T.unsafe(nil), Integer)

# i386 and later compatible CPUs
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#82
MachO::Headers::CPU_TYPE_I386 = T.let(T.unsafe(nil), Integer)

# m68k compatible CPUs
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#78
MachO::Headers::CPU_TYPE_MC680X0 = T.let(T.unsafe(nil), Integer)

# m88k compatible CPUs
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#94
MachO::Headers::CPU_TYPE_MC88000 = T.let(T.unsafe(nil), Integer)

# PowerPC compatible CPUs
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#106
MachO::Headers::CPU_TYPE_POWERPC = T.let(T.unsafe(nil), Integer)

# PowerPC64 compatible CPUs
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#110
MachO::Headers::CPU_TYPE_POWERPC64 = T.let(T.unsafe(nil), Integer)

# x86_64 (AMD64) compatible CPUs
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#86
MachO::Headers::CPU_TYPE_X86_64 = T.let(T.unsafe(nil), Integer)

# little-endian fat magic
#
# @api private
# @note This is defined for completeness, but should never appear in ruby-macho code,
#   since fat headers are always big-endian.
#
# source://ruby-macho//lib/macho/headers.rb#14
MachO::Headers::FAT_CIGAM = T.let(T.unsafe(nil), Integer)

# 64-bit little-endian fat magic
#
# @note This is defined for completeness, but should never appear in ruby-macho code,
#   since fat headers are always big-endian.
#
# source://ruby-macho//lib/macho/headers.rb#22
MachO::Headers::FAT_CIGAM_64 = T.let(T.unsafe(nil), Integer)

# big-endian fat magic
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#8
MachO::Headers::FAT_MAGIC = T.let(T.unsafe(nil), Integer)

# 64-bit big-endian fat magic
#
# source://ruby-macho//lib/macho/headers.rb#17
MachO::Headers::FAT_MAGIC_64 = T.let(T.unsafe(nil), Integer)

# 32-bit fat binary header architecture structure. A 32-bit fat Mach-O has one or more of
#  these, indicating one or more internal Mach-O blobs.
#
# @note "32-bit" indicates the fact that this structure stores 32-bit offsets, not that the
#   Mach-Os that it points to necessarily *are* 32-bit.
# @see MachO::Headers::FatHeader
#
# source://ruby-macho//lib/macho/headers.rb#534
class MachO::Headers::FatArch < ::MachO::MachOStructure
  # @return [Integer] the alignment, as a power of 2
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def align; end

  # @return [Integer] the CPU subtype of the Mach-O
  #
  # source://ruby-macho//lib/macho/structure.rb#228
  def cpusubtype; end

  # @return [Integer] the CPU type of the Mach-O
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def cputype; end

  # @return [Integer] the file offset to the beginning of the Mach-O data
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def offset; end

  # @return [String] the serialized fields of the fat arch
  #
  # source://ruby-macho//lib/macho/headers.rb#550
  def serialize; end

  # @return [Integer] the size, in bytes, of the Mach-O data
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def size; end

  # @return [Hash] a hash representation of this {FatArch}
  #
  # source://ruby-macho//lib/macho/headers.rb#555
  def to_h; end
end

# 64-bit fat binary header architecture structure. A 64-bit fat Mach-O has one or more of
#  these, indicating one or more internal Mach-O blobs.
#
# @note "64-bit" indicates the fact that this structure stores 64-bit offsets, not that the
#   Mach-Os that it points to necessarily *are* 64-bit.
# @see MachO::Headers::FatHeader
#
# source://ruby-macho//lib/macho/headers.rb#574
class MachO::Headers::FatArch64 < ::MachO::Headers::FatArch
  # @return [Integer] the file offset to the beginning of the Mach-O data
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def offset; end

  # @return [void]
  #
  # source://ruby-macho//lib/macho/structure.rb#256
  def reserved; end

  # @return [String] the serialized fields of the fat arch
  #
  # source://ruby-macho//lib/macho/headers.rb#584
  def serialize; end

  # @return [Integer] the size, in bytes, of the Mach-O data
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def size; end

  # @return [Hash] a hash representation of this {FatArch64}
  #
  # source://ruby-macho//lib/macho/headers.rb#589
  def to_h; end
end

# Fat binary header structure
#
# @see MachO::FatArch
#
# source://ruby-macho//lib/macho/headers.rb#507
class MachO::Headers::FatHeader < ::MachO::MachOStructure
  # @return [Integer] the magic number of the header (and file)
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def magic; end

  # @return [Integer] the number of fat architecture structures following the header
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def nfat_arch; end

  # @return [String] the serialized fields of the fat header
  #
  # source://ruby-macho//lib/macho/headers.rb#514
  def serialize; end

  # @return [Hash] a hash representation of this {FatHeader}
  #
  # source://ruby-macho//lib/macho/headers.rb#519
  def to_h; end
end

# dynamically bound bundle file
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#434
MachO::Headers::MH_BUNDLE = T.let(T.unsafe(nil), Integer)

# 32-bit little-endian magic
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#30
MachO::Headers::MH_CIGAM = T.let(T.unsafe(nil), Integer)

# 64-bit little-endian magic
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#38
MachO::Headers::MH_CIGAM_64 = T.let(T.unsafe(nil), Integer)

# core dump file
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#418
MachO::Headers::MH_CORE = T.let(T.unsafe(nil), Integer)

# companion file with only debug sections
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#442
MachO::Headers::MH_DSYM = T.let(T.unsafe(nil), Integer)

# dynamically bound shared library
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#426
MachO::Headers::MH_DYLIB = T.let(T.unsafe(nil), Integer)

# shared library stub for static linking only, no section contents
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#438
MachO::Headers::MH_DYLIB_STUB = T.let(T.unsafe(nil), Integer)

# dynamic link editor
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#430
MachO::Headers::MH_DYLINKER = T.let(T.unsafe(nil), Integer)

# demand paged executable file
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#410
MachO::Headers::MH_EXECUTE = T.let(T.unsafe(nil), Integer)

# a set of Mach-Os, running in the same userspace, sharing a linkedit.  The kext collection files are an example
# of this object type
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#451
MachO::Headers::MH_FILESET = T.let(T.unsafe(nil), Integer)

# association of filetypes to Symbol representations
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#455
MachO::Headers::MH_FILETYPES = T.let(T.unsafe(nil), Hash)

# association of mach header flag symbols to values
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#472
MachO::Headers::MH_FLAGS = T.let(T.unsafe(nil), Hash)

# fixed VM shared library file
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#414
MachO::Headers::MH_FVMLIB = T.let(T.unsafe(nil), Integer)

# x86_64 kexts
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#446
MachO::Headers::MH_KEXT_BUNDLE = T.let(T.unsafe(nil), Integer)

# 32-bit big-endian magic
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#26
MachO::Headers::MH_MAGIC = T.let(T.unsafe(nil), Integer)

# association of magic numbers to string representations
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#54
MachO::Headers::MH_MAGICS = T.let(T.unsafe(nil), Hash)

# 64-bit big-endian magic
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#34
MachO::Headers::MH_MAGIC_64 = T.let(T.unsafe(nil), Integer)

# relocatable object file
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#406
MachO::Headers::MH_OBJECT = T.let(T.unsafe(nil), Integer)

# preloaded executable file
#
# @api private
#
# source://ruby-macho//lib/macho/headers.rb#422
MachO::Headers::MH_PRELOAD = T.let(T.unsafe(nil), Integer)

# 32-bit Mach-O file header structure
#
# source://ruby-macho//lib/macho/headers.rb#598
class MachO::Headers::MachHeader < ::MachO::MachOStructure
  # @return [Integer] the file's internal alignment
  #
  # source://ruby-macho//lib/macho/headers.rb#697
  def alignment; end

  # @return [Boolean] whether or not the file is of type `MH_BUNDLE`
  #
  # source://ruby-macho//lib/macho/headers.rb#667
  def bundle?; end

  # @return [Boolean] whether or not the file is of type `MH_CORE`
  #
  # source://ruby-macho//lib/macho/headers.rb#647
  def core?; end

  # @return [Integer] the CPU subtype of the Mach-O
  #
  # source://ruby-macho//lib/macho/structure.rb#228
  def cpusubtype; end

  # @return [Integer] the CPU type of the Mach-O
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def cputype; end

  # @return [Boolean] whether or not the file is of type `MH_DSYM`
  #
  # source://ruby-macho//lib/macho/headers.rb#672
  def dsym?; end

  # @return [Boolean] whether or not the file is of type `MH_DYLIB`
  #
  # source://ruby-macho//lib/macho/headers.rb#657
  def dylib?; end

  # @return [Boolean] whether or not the file is of type `MH_DYLINKER`
  #
  # source://ruby-macho//lib/macho/headers.rb#662
  def dylinker?; end

  # @return [Boolean] whether or not the file is of type `MH_EXECUTE`
  #
  # source://ruby-macho//lib/macho/headers.rb#637
  def executable?; end

  # @return [Boolean] whether or not the file is of type `MH_FILESET`
  #
  # source://ruby-macho//lib/macho/headers.rb#682
  def fileset?; end

  # @return [Integer] the file type of the Mach-O
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def filetype; end

  # @example
  #   puts "this mach-o has position-independent execution" if header.flag?(:MH_PIE)
  # @param flag [Symbol] a mach header flag symbol
  # @return [Boolean] true if `flag` is present in the header's flag section
  #
  # source://ruby-macho//lib/macho/headers.rb#623
  def flag?(flag); end

  # @return [Integer] the header flags associated with the Mach-O
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def flags; end

  # @return [Boolean] whether or not the file is of type `MH_FVMLIB`
  #
  # source://ruby-macho//lib/macho/headers.rb#642
  def fvmlib?; end

  # @return [Boolean] whether or not the file is of type `MH_KEXT_BUNDLE`
  #
  # source://ruby-macho//lib/macho/headers.rb#677
  def kext?; end

  # @return [Integer] the magic number
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def magic; end

  # @return [Boolean] true if the Mach-O has 32-bit magic, false otherwise
  #
  # source://ruby-macho//lib/macho/headers.rb#687
  def magic32?; end

  # @return [Boolean] true if the Mach-O has 64-bit magic, false otherwise
  #
  # source://ruby-macho//lib/macho/headers.rb#692
  def magic64?; end

  # @return [Integer] the number of load commands in the Mach-O
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def ncmds; end

  # @return [Boolean] whether or not the file is of type `MH_OBJECT`
  #
  # source://ruby-macho//lib/macho/headers.rb#632
  def object?; end

  # @return [Boolean] whether or not the file is of type `MH_PRELOAD`
  #
  # source://ruby-macho//lib/macho/headers.rb#652
  def preload?; end

  # @return [Integer] the size of all load commands, in bytes, in the Mach-O
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def sizeofcmds; end

  # @return [Hash] a hash representation of this {MachHeader}
  #
  # source://ruby-macho//lib/macho/headers.rb#702
  def to_h; end
end

# 64-bit Mach-O file header structure
#
# source://ruby-macho//lib/macho/headers.rb#722
class MachO::Headers::MachHeader64 < ::MachO::Headers::MachHeader
  # @return [void]
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def reserved; end

  # @return [Hash] a hash representation of this {MachHeader64}
  #
  # source://ruby-macho//lib/macho/headers.rb#726
  def to_h; end
end

# Prelinked kernel/"kernelcache" header structure
#
# source://ruby-macho//lib/macho/headers.rb#735
class MachO::Headers::PrelinkedKernelHeader < ::MachO::MachOStructure
  # @return [Integer] a checksum for the uncompressed data
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def adler32; end

  # @return [Integer] the type of compression used
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def compress_type; end

  # @return [Integer] the size of the compressed data, in bytes
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def compressed_size; end

  # @return [Boolean] whether this prelinked kernel supports KASLR
  #
  # source://ruby-macho//lib/macho/headers.rb#763
  def kaslr?; end

  # @return [Boolean] whether this prelinked kernel is compressed with LZSS
  #
  # source://ruby-macho//lib/macho/headers.rb#768
  def lzss?; end

  # @return [Boolean] whether this prelinked kernel is compressed with LZVN
  #
  # source://ruby-macho//lib/macho/headers.rb#773
  def lzvn?; end

  # @return [void]
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def platform_name; end

  # @return [Integer] the version of the prelink format
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def prelink_version; end

  # @return [void]
  #
  # source://ruby-macho//lib/macho/structure.rb#242
  def reserved; end

  # @return [void]
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def root_path; end

  # @return [Integer] the magic number for a compressed header ({COMPRESSED_MAGIC})
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def signature; end

  # @return [Hash] a hash representation of this {PrelinkedKernelHeader}
  #
  # source://ruby-macho//lib/macho/headers.rb#778
  def to_h; end

  # @return [Integer] the size of the uncompressed data, in bytes
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def uncompressed_size; end
end

# Raised when a file is a Java classfile instead of a fat Mach-O.
#
# source://ruby-macho//lib/macho/exceptions.rb#53
class MachO::JavaClassFileError < ::MachO::NotAMachOError
  # @return [JavaClassFileError] a new instance of JavaClassFileError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#54
  def initialize; end
end

# Raised when a load command string is malformed in some way.
#
# source://ruby-macho//lib/macho/exceptions.rb#159
class MachO::LCStrMalformedError < ::MachO::MachOError
  # @param lc [MachO::LoadCommand] the load command containing the string
  # @return [LCStrMalformedError] a new instance of LCStrMalformedError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#160
  def initialize(lc); end
end

# Raised when the number of arguments used to create a load command manually
# is wrong.
#
# source://ruby-macho//lib/macho/exceptions.rb#142
class MachO::LoadCommandCreationArityError < ::MachO::MachOError
  # @param cmd_sym [Symbol] the load command's symbol
  # @param expected_arity [Integer] the number of arguments expected
  # @param actual_arity [Integer] the number of arguments received
  # @return [LoadCommandCreationArityError] a new instance of LoadCommandCreationArityError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#143
  def initialize(cmd_sym, expected_arity, actual_arity); end
end

# Raised when an unknown load command is encountered.
#
# source://ruby-macho//lib/macho/exceptions.rb#123
class MachO::LoadCommandError < ::MachO::MachOError
  # @param num [Integer] the unknown number
  # @return [LoadCommandError] a new instance of LoadCommandError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#124
  def initialize(num); end
end

# Raised when a load command can't be created manually.
#
# source://ruby-macho//lib/macho/exceptions.rb#131
class MachO::LoadCommandNotCreatableError < ::MachO::MachOError
  # @param cmd_sym [Symbol] the uncreatable load command's symbol
  # @return [LoadCommandNotCreatableError] a new instance of LoadCommandNotCreatableError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#132
  def initialize(cmd_sym); end
end

# Raised when a load command can't be serialized.
#
# source://ruby-macho//lib/macho/exceptions.rb#151
class MachO::LoadCommandNotSerializableError < ::MachO::MachOError
  # @param cmd_sym [Symbol] the load command's symbol
  # @return [LoadCommandNotSerializableError] a new instance of LoadCommandNotSerializableError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#152
  def initialize(cmd_sym); end
end

# Classes and constants for parsing load commands in Mach-O binaries.
#
# source://ruby-macho//lib/macho/load_commands.rb#5
module MachO::LoadCommands; end

# A load command containing the minimum OS version on which
# the binary was built for its platform.
# Corresponds to LC_BUILD_VERSION.
#
# source://ruby-macho//lib/macho/load_commands.rb#1061
class MachO::LoadCommands::BuildVersionCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Integer] the minimum OS version X.Y.Z packed as x16.y8.z8
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def minos; end

  # A string representation of the binary's minimum OS version.
  #
  # @return [String] a string representing the minimum OS version.
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1075
  def minos_string; end

  # @return [Integer]
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def platform; end

  # @return [Integer] the SDK version X.Y.Z packed as x16.y8.z8
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def sdk; end

  # A string representation of the binary's SDK version.
  #
  # @return [String] a string representing the SDK version.
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1086
  def sdk_string; end

  # @return [Hash] a hash representation of this {BuildVersionCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1096
  def to_h; end

  # @return [ToolEntries] tool entries
  #
  # source://ruby-macho//lib/macho/structure.rb#213
  def tool_entries; end
end

# A representation of the tool versions exposed
# by a {BuildVersionCommand} (`LC_BUILD_VERSION`).
#
# source://ruby-macho//lib/macho/load_commands.rb#1109
class MachO::LoadCommands::BuildVersionCommand::ToolEntries
  # @api private
  # @param view [MachO::MachOView] the view into the current Mach-O
  # @param ntools [Integer] the number of tools
  # @return [ToolEntries] a new instance of ToolEntries
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1116
  def initialize(view, ntools); end

  # @return [Array<Tool>] all tools
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1111
  def tools; end
end

# An individual tool.
#
# source://ruby-macho//lib/macho/load_commands.rb#1125
class MachO::LoadCommands::BuildVersionCommand::ToolEntries::Tool
  # @api private
  # @param tool [Integer] 32-bit integer
  # @param version [Integer] 32-bit integer
  # @return [Tool] a new instance of Tool
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1135
  def initialize(tool, version); end

  # @return [Hash] a hash representation of this {Tool}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1141
  def to_h; end

  # @return [Integer] the enum for the tool
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1127
  def tool; end

  # @return [Integer] the tool's version number
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1130
  def version; end
end

# load commands that can be created manually via {LoadCommand.create}
#
# @api private
#
# source://ruby-macho//lib/macho/load_commands.rb#86
MachO::LoadCommands::CREATABLE_LOAD_COMMANDS = T.let(T.unsafe(nil), Array)

# load commands responsible for loading dylibs
#
# @api private
#
# source://ruby-macho//lib/macho/load_commands.rb#76
MachO::LoadCommands::DYLIB_LOAD_COMMANDS = T.let(T.unsafe(nil), Array)

# A load command containing the file offsets and sizes of the new
# compressed form of the information dyld needs to load the image.
# Corresponds to LC_DYLD_INFO and LC_DYLD_INFO_ONLY.
#
# source://ruby-macho//lib/macho/load_commands.rb#1155
class MachO::LoadCommands::DyldInfoCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Integer] the file offset to the binding information
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def bind_off; end

  # @return [Integer] the size of the binding information
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def bind_size; end

  # @return [Integer] the file offset to the export information
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def export_off; end

  # @return [Integer] the size of the export information
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def export_size; end

  # @return [Integer] the file offset to the lazy binding information
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def lazy_bind_off; end

  # @return [Integer] the size of the lazy binding information
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def lazy_bind_size; end

  # @return [Integer] the file offset to the rebase information
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def rebase_off; end

  # @return [Integer] the size of the rebase information
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def rebase_size; end

  # @return [Hash] a hash representation of this {DyldInfoCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1186
  def to_h; end

  # @return [Integer] the file offset to the weak binding information
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def weak_bind_off; end

  # @return [Integer] the size of the weak binding information
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def weak_bind_size; end
end

# A load command representing some aspect of shared libraries, depending
# on filetype. Corresponds to LC_ID_DYLIB, LC_LOAD_DYLIB,
# LC_LOAD_WEAK_DYLIB, and LC_REEXPORT_DYLIB.
#
# source://ruby-macho//lib/macho/load_commands.rb#517
class MachO::LoadCommands::DylibCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Integer] the library's compatibility version number
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def compatibility_version; end

  # @return [Integer] the library's current version number
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def current_version; end

  # @return [LCStr] the library's path
  #   name as an LCStr
  #
  # source://ruby-macho//lib/macho/structure.rb#199
  def name; end

  # @api private
  # @param context [SerializationContext] the context
  # @return [String] the serialized fields of the load command
  #
  # source://ruby-macho//lib/macho/load_commands.rb#533
  def serialize(context); end

  # @return [Integer] the library's build time stamp
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def timestamp; end

  # @return [Hash] a hash representation of this {DylibCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#544
  def to_h; end

  # source://ruby-macho//lib/macho/structure.rb#278
  def to_s; end
end

# A load command representing some aspect of the dynamic linker, depending
# on filetype. Corresponds to LC_ID_DYLINKER, LC_LOAD_DYLINKER, and
# LC_DYLD_ENVIRONMENT.
#
# source://ruby-macho//lib/macho/load_commands.rb#559
class MachO::LoadCommands::DylinkerCommand < ::MachO::LoadCommands::LoadCommand
  # @return [LCStr] the dynamic linker's
  #   path name as an LCStr
  #
  # source://ruby-macho//lib/macho/structure.rb#199
  def name; end

  # @api private
  # @param context [SerializationContext] the context
  # @return [String] the serialized fields of the load command
  #
  # source://ruby-macho//lib/macho/load_commands.rb#566
  def serialize(context); end

  # @return [Hash] a hash representation of this {DylinkerCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#576
  def to_h; end

  # source://ruby-macho//lib/macho/structure.rb#278
  def to_s; end
end

# A load command containing symbolic information needed to support data
# structures used by the dynamic link editor. Corresponds to LC_DYSYMTAB.
#
# source://ruby-macho//lib/macho/load_commands.rb#771
class MachO::LoadCommands::DysymtabCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Integer] the file offset to the referenced symbol table
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def extrefsymoff; end

  # @return [Integer] the file offset to the external relocation entries
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def extreloff; end

  # @return [Integer] the index to externally defined symbols
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def iextdefsym; end

  # @return [Integer] the index to local symbols
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def ilocalsym; end

  # @return [Integer] the file offset to the indirect symbol table
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def indirectsymoff; end

  # @return [Integer] the index to undefined symbols
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def iundefsym; end

  # @return [Integer] the file offset to the local relocation entries
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def locreloff; end

  # @return [Integer] the file offset to the module table
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def modtaboff; end

  # @return [Integer] the number of externally defined symbols
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def nextdefsym; end

  # @return [Integer] the number of entries in the referenced symbol table
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def nextrefsyms; end

  # @return [Integer] the number of external relocation entries
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def nextrel; end

  # @return [Integer] the number of entries in the indirect symbol table
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def nindirectsyms; end

  # @return [Integer] the number of local symbols
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def nlocalsym; end

  # @return [Integer] the number of local relocation entries
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def nlocrel; end

  # @return [Integer] the number of entries in the module table
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def nmodtab; end

  # @return [Integer] the number of entries in the table of contents
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def ntoc; end

  # @return [Integer] the number of undefined symbols
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def nundefsym; end

  # @return [Hash] a hash representation of this {DysymtabCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#826
  def to_h; end

  # @return [Integer] the file offset to the table of contents
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def tocoff; end
end

# A load command representing the offset to and size of an encrypted
# segment. Corresponds to LC_ENCRYPTION_INFO.
#
# source://ruby-macho//lib/macho/load_commands.rb#981
class MachO::LoadCommands::EncryptionInfoCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Integer] the encryption system, or 0 if not encrypted yet
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def cryptid; end

  # @return [Integer] the offset to the encrypted segment
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def cryptoff; end

  # @return [Integer] the size of the encrypted segment
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def cryptsize; end

  # @return [Hash] a hash representation of this {EncryptionInfoCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#991
  def to_h; end
end

# A load command representing the offset to and size of an encrypted
# segment. Corresponds to LC_ENCRYPTION_INFO_64.
#
# source://ruby-macho//lib/macho/load_commands.rb#1003
class MachO::LoadCommands::EncryptionInfoCommand64 < ::MachO::LoadCommands::EncryptionInfoCommand
  # @return [Integer] 64-bit padding value
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def pad; end

  # @return [Hash] a hash representation of this {EncryptionInfoCommand64}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1007
  def to_h; end
end

# A load command specifying the offset of main(). Corresponds to LC_MAIN.
#
# source://ruby-macho//lib/macho/load_commands.rb#1218
class MachO::LoadCommands::EntryPointCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Integer] the file (__TEXT) offset of main()
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def entryoff; end

  # @return [Integer] if not 0, the initial stack size.
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def stacksize; end

  # @return [Hash] a hash representation of this {EntryPointCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1225
  def to_h; end
end

# A load command containing a description of a Mach-O that is a constituent of a fileset.
# Each entry is further described by its own Mach header.
# Corresponds to LC_FILESET_ENTRY.
#
# source://ruby-macho//lib/macho/load_commands.rb#1350
class MachO::LoadCommands::FilesetEntryCommand < ::MachO::LoadCommands::LoadCommand
  # @return [LCStr] the entry's ID
  #
  # source://ruby-macho//lib/macho/structure.rb#199
  def entry_id; end

  # @return [Integer] the file offset of the entry
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def fileoff; end

  # @return [void]
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def reserved; end

  # @return [SegmentCommand64, nil] the matching segment command or nil if nothing matches
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1373
  def segment; end

  # @return [Hash] a hash representation of this {FilesetEntryCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1363
  def to_h; end

  # source://ruby-macho//lib/macho/structure.rb#278
  def to_s; end

  # @return [Integer] the virtual memory address of the entry
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def vmaddr; end
end

# An obsolete load command containing the path to a file to be loaded into
# memory. Corresponds to LC_FVMFILE.
#
# source://ruby-macho//lib/macho/load_commands.rb#1287
class MachO::LoadCommands::FvmfileCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Integer] the virtual address being loaded at
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def header_addr; end

  # @return [LCStr] the pathname of the file being loaded
  #
  # source://ruby-macho//lib/macho/structure.rb#199
  def name; end

  # @return [Hash] a hash representation of this {FvmfileCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1294
  def to_h; end

  # source://ruby-macho//lib/macho/structure.rb#278
  def to_s; end
end

# An obsolete load command containing the path to a library to be loaded
# into memory. Corresponds to LC_LOADFVMLIB and LC_IDFVMLIB.
#
# source://ruby-macho//lib/macho/load_commands.rb#1305
class MachO::LoadCommands::FvmlibCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Integer] the library's header address
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def header_addr; end

  # @return [Integer] the library's minor version number
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def minor_version; end

  # @return [LCStr] the library's target pathname
  #
  # source://ruby-macho//lib/macho/structure.rb#199
  def name; end

  # @return [Hash] a hash representation of this {FvmlibCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1315
  def to_h; end

  # source://ruby-macho//lib/macho/structure.rb#278
  def to_s; end
end

# An obsolete load command containing a free format string table. Each
# string is null-terminated and the command is zero-padded to a multiple of
# 4. Corresponds to LC_IDENT.
#
# source://ruby-macho//lib/macho/load_commands.rb#1281
class MachO::LoadCommands::IdentCommand < ::MachO::LoadCommands::LoadCommand; end

# load commands added after OS X 10.1 need to be bitwise ORed with
# LC_REQ_DYLD to be recognized by the dynamic linker (dyld)
#
# @api private
#
# source://ruby-macho//lib/macho/load_commands.rb#9
MachO::LoadCommands::LC_REQ_DYLD = T.let(T.unsafe(nil), Integer)

# association of load command symbols to string representations of classes
#
# @api private
#
# source://ruby-macho//lib/macho/load_commands.rb#94
MachO::LoadCommands::LC_STRUCTURES = T.let(T.unsafe(nil), Hash)

# association of load commands to symbol representations
#
# @api private
#
# source://ruby-macho//lib/macho/load_commands.rb#13
MachO::LoadCommands::LOAD_COMMANDS = T.let(T.unsafe(nil), Hash)

# association of symbol representations to load command constants
#
# @api private
#
# source://ruby-macho//lib/macho/load_commands.rb#72
MachO::LoadCommands::LOAD_COMMAND_CONSTANTS = T.let(T.unsafe(nil), Hash)

# A load command representing the offsets and sizes of a blob of data in
# the __LINKEDIT segment. Corresponds to LC_CODE_SIGNATURE,
# LC_SEGMENT_SPLIT_INFO, LC_FUNCTION_STARTS, LC_DATA_IN_CODE,
# LC_DYLIB_CODE_SIGN_DRS, LC_LINKER_OPTIMIZATION_HINT, LC_DYLD_EXPORTS_TRIE,
# or LC_DYLD_CHAINED_FIXUPS.
#
# source://ruby-macho//lib/macho/load_commands.rb#963
class MachO::LoadCommands::LinkeditDataCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Integer] offset to the data in the __LINKEDIT segment
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def dataoff; end

  # @return [Integer] size of the data in the __LINKEDIT segment
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def datasize; end

  # @return [Hash] a hash representation of this {LinkeditDataCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#970
  def to_h; end
end

# A load command containing linker options embedded in object files.
# Corresponds to LC_LINKER_OPTION.
#
# source://ruby-macho//lib/macho/load_commands.rb#1205
class MachO::LoadCommands::LinkerOptionCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Integer] the number of strings
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def count; end

  # @return [Hash] a hash representation of this {LinkerOptionCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1209
  def to_h; end
end

# The top-level Mach-O load command structure.
#
# This is the most generic load command -- only the type ID and size are
# represented. Used when a more specific class isn't available or isn't implemented.
#
# source://ruby-macho//lib/macho/load_commands.rb#202
class MachO::LoadCommands::LoadCommand < ::MachO::MachOStructure
  # @return [Integer] the load command's type ID
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def cmd; end

  # @return [Integer] the size of the load command, in bytes
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def cmdsize; end

  # @deprecated use {#view} instead
  # @return [Integer] the load command's offset in the source file
  #
  # source://ruby-macho//lib/macho/load_commands.rb#258
  def offset; end

  # @return [Boolean] whether the load command can be serialized
  #
  # source://ruby-macho//lib/macho/load_commands.rb#240
  def serializable?; end

  # @api private
  # @param context [SerializationContext] the context
  #   to serialize into
  # @raise [LoadCommandNotSerializableError]
  # @return [String, nil] the serialized fields of the load command, or nil
  #   if the load command can't be serialized
  #
  # source://ruby-macho//lib/macho/load_commands.rb#249
  def serialize(context); end

  # @note Children should override this to include additional information.
  # @return [Hash] a hash representation of this load command
  #
  # source://ruby-macho//lib/macho/load_commands.rb#278
  def to_h; end

  # @return [String] a string representation of the load command's
  #   identifying number
  #
  # source://ruby-macho//lib/macho/load_commands.rb#272
  def to_s; end

  # @return [Symbol, nil] a symbol representation of the load command's
  #   type ID, or nil if the ID doesn't correspond to a known load command class
  #
  # source://ruby-macho//lib/macho/load_commands.rb#264
  def to_sym; end

  # @return [Symbol, nil] a symbol representation of the load command's
  #   type ID, or nil if the ID doesn't correspond to a known load command class
  #
  # source://ruby-macho//lib/macho/load_commands.rb#264
  def type; end

  # @return [MachO::MachOView, nil] the raw view associated with the load command,
  #   or nil if the load command was created via {create}.
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def view; end

  class << self
    # Creates a new (viewless) command corresponding to the symbol provided
    #
    # @param cmd_sym [Symbol] the symbol of the load command being created
    # @param args [Array] the arguments for the load command being created
    # @raise [LoadCommandNotCreatableError]
    #
    # source://ruby-macho//lib/macho/load_commands.rb#225
    def create(cmd_sym, *args); end

    # Instantiates a new LoadCommand given a view into its origin Mach-O
    #
    # @api private
    # @param view [MachO::MachOView] the load command's raw view
    # @return [LoadCommand] the new load command
    #
    # source://ruby-macho//lib/macho/load_commands.rb#215
    def new_from_bin(view); end
  end
end

# Represents a Load Command string. A rough analogue to the lc_str
# struct used internally by OS X. This class allows ruby-macho to
# pretend that strings stored in LCs are immediately available without
# explicit operations on the raw Mach-O data.
#
# source://ruby-macho//lib/macho/load_commands.rb#291
class MachO::LoadCommands::LoadCommand::LCStr
  # @api private
  # @param lc [LoadCommand] the load command
  # @param lc_str [Integer, String] the offset to the beginning of the
  #   string, or the string itself if not being initialized with a view.
  # @raise [MachO::LCStrMalformedError] if the string is malformed
  # @return [LCStr] a new instance of LCStr
  # @todo devise a solution such that the `lc_str` parameter is not
  #   interpreted differently depending on `lc.view`. The current behavior
  #   is a hack to allow viewless load command creation.
  #
  # source://ruby-macho//lib/macho/load_commands.rb#300
  def initialize(lc, lc_str); end

  # @return [Hash] a hash representation of this {LCStr}.
  #
  # source://ruby-macho//lib/macho/load_commands.rb#330
  def to_h; end

  # @return [Integer] the offset to the beginning of the string in the
  #   load command
  #
  # source://ruby-macho//lib/macho/load_commands.rb#325
  def to_i; end

  # @return [String] a string representation of the LCStr
  #
  # source://ruby-macho//lib/macho/load_commands.rb#319
  def to_s; end
end

# Represents the contextual information needed by a load command to
# serialize itself correctly into a binary string.
#
# source://ruby-macho//lib/macho/load_commands.rb#340
class MachO::LoadCommands::LoadCommand::SerializationContext
  # @api private
  # @param endianness [Symbol] the endianness of the context
  # @param alignment [Integer] the alignment of the context
  # @return [SerializationContext] a new instance of SerializationContext
  #
  # source://ruby-macho//lib/macho/load_commands.rb#358
  def initialize(endianness, alignment); end

  # @return [Integer] the constant alignment value used to pad the
  #   serialized load command
  #
  # source://ruby-macho//lib/macho/load_commands.rb#346
  def alignment; end

  # @return [Symbol] the endianness of the serialized load command
  #
  # source://ruby-macho//lib/macho/load_commands.rb#342
  def endianness; end

  class << self
    # @param macho [MachO::MachOFile] the file to contextualize
    # @return [SerializationContext] the
    #   resulting context
    #
    # source://ruby-macho//lib/macho/load_commands.rb#351
    def context_for(macho); end
  end
end

# A load command containing an owner name and offset/size for an arbitrary data region.
# Corresponds to LC_NOTE.
#
# source://ruby-macho//lib/macho/load_commands.rb#1327
class MachO::LoadCommands::NoteCommand < ::MachO::LoadCommands::LoadCommand
  # @return [String] the name of the owner for this note
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def data_owner; end

  # @return [Integer] the offset, within the file, of the note
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def offset; end

  # @return [Integer] the size, in bytes, of the note
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def size; end

  # @return [Hash] a hash representation of this {NoteCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1337
  def to_h; end

  # source://ruby-macho//lib/macho/structure.rb#278
  def to_s; end
end

# A load command containing the value of the original checksum for prebound
# files, or zero. Corresponds to LC_PREBIND_CKSUM.
#
# source://ruby-macho//lib/macho/load_commands.rb#919
class MachO::LoadCommands::PrebindCksumCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Integer] the checksum or 0
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def cksum; end

  # @return [Hash] a hash representation of this {PrebindCksumCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#923
  def to_h; end
end

# A load command used to indicate dynamic libraries used in prebinding.
# Corresponds to LC_PREBOUND_DYLIB.
#
# source://ruby-macho//lib/macho/load_commands.rb#587
class MachO::LoadCommands::PreboundDylibCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Integer] a bit vector of linked modules
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def linked_modules; end

  # @return [LCStr] the library's path
  #   name as an LCStr
  #
  # source://ruby-macho//lib/macho/structure.rb#199
  def name; end

  # @return [Integer] the number of modules in the library
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def nmodules; end

  # @return [Hash] a hash representation of this {PreboundDylibCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#597
  def to_h; end

  # source://ruby-macho//lib/macho/structure.rb#278
  def to_s; end
end

# A load command containing the address of the dynamic shared library
# initialization routine and an index into the module table for the module
# that defines the routine. Corresponds to LC_ROUTINES.
#
# source://ruby-macho//lib/macho/load_commands.rb#616
class MachO::LoadCommands::RoutinesCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Integer] the address of the initialization routine
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def init_address; end

  # @return [Integer] the index into the module table that the init routine
  #   is defined in
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def init_module; end

  # @return [void]
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def reserved1; end

  # @return [void]
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def reserved2; end

  # @return [void]
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def reserved3; end

  # @return [void]
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def reserved4; end

  # @return [void]
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def reserved5; end

  # @return [void]
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def reserved6; end

  # @return [Hash] a hash representation of this {RoutinesCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#642
  def to_h; end
end

# A load command containing the address of the dynamic shared library
# initialization routine and an index into the module table for the module
# that defines the routine. Corresponds to LC_ROUTINES_64.
#
# source://ruby-macho//lib/macho/load_commands.rb#660
class MachO::LoadCommands::RoutinesCommand64 < ::MachO::LoadCommands::RoutinesCommand
  # @return [Integer] the address of the initialization routine
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def init_address; end

  # @return [Integer] the index into the module table that the init routine
  #   is defined in
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def init_module; end

  # @return [void]
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def reserved1; end

  # @return [void]
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def reserved2; end

  # @return [void]
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def reserved3; end

  # @return [void]
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def reserved4; end

  # @return [void]
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def reserved5; end

  # @return [void]
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def reserved6; end
end

# A load command representing an rpath, which specifies a path that should
# be added to the current run path used to find @rpath prefixed dylibs.
# Corresponds to LC_RPATH.
#
# source://ruby-macho//lib/macho/load_commands.rb#934
class MachO::LoadCommands::RpathCommand < ::MachO::LoadCommands::LoadCommand
  # @return [LCStr] the path to add to the run path as an LCStr
  #
  # source://ruby-macho//lib/macho/structure.rb#199
  def path; end

  # @api private
  # @param context [SerializationContext] the context
  # @return [String] the serialized fields of the load command
  #
  # source://ruby-macho//lib/macho/load_commands.rb#940
  def serialize(context); end

  # @return [Hash] a hash representation of this {RpathCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#950
  def to_h; end

  # source://ruby-macho//lib/macho/structure.rb#278
  def to_s; end
end

# association of segment flag symbols to values
#
# @api private
#
# source://ruby-macho//lib/macho/load_commands.rb#188
MachO::LoadCommands::SEGMENT_FLAGS = T.let(T.unsafe(nil), Hash)

# association of segment name symbols to names
#
# @api private
#
# source://ruby-macho//lib/macho/load_commands.rb#160
MachO::LoadCommands::SEGMENT_NAMES = T.let(T.unsafe(nil), Hash)

# A load command indicating that part of this file is to be mapped into
# the task's address space. Corresponds to LC_SEGMENT.
#
# source://ruby-macho//lib/macho/load_commands.rb#400
class MachO::LoadCommands::SegmentCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Integer] the file offset of the segment
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def fileoff; end

  # @return [Integer] the amount to map from the file
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def filesize; end

  # @example
  #   puts "this segment relocated in/to it" if sect.flag?(:SG_NORELOC)
  # @param flag [Symbol] a segment flag symbol
  # @return [Boolean] true if `flag` is present in the segment's flag field
  #
  # source://ruby-macho//lib/macho/load_commands.rb#451
  def flag?(flag); end

  # @return [Integer] any flags associated with the segment
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def flags; end

  # Guesses the alignment of the segment.
  #
  # @note See `guess_align` in `cctools/misc/lipo.c`
  # @return [Integer] the guessed alignment, as a power of 2
  #
  # source://ruby-macho//lib/macho/load_commands.rb#462
  def guess_align; end

  # @return [Integer] the initial VM protection
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def initprot; end

  # @return [Integer] the maximum VM protection
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def maxprot; end

  # @return [Integer] the number of sections in the segment
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def nsects; end

  # All sections referenced within this segment.
  #
  # @return [Array<MachO::Sections::Section>] if the Mach-O is 32-bit
  # @return [Array<MachO::Sections::Section64>] if the Mach-O is 64-bit
  #
  # source://ruby-macho//lib/macho/load_commands.rb#430
  def sections; end

  # @return [String] the name of the segment
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def segname; end

  # @return [Hash] a hash representation of this {SegmentCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#480
  def to_h; end

  # source://ruby-macho//lib/macho/structure.rb#278
  def to_s; end

  # @return [Integer] the memory address of the segment
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def vmaddr; end

  # @return [Integer] the memory size of the segment
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def vmsize; end
end

# A load command indicating that part of this file is to be mapped into
# the task's address space. Corresponds to LC_SEGMENT_64.
#
# source://ruby-macho//lib/macho/load_commands.rb#499
class MachO::LoadCommands::SegmentCommand64 < ::MachO::LoadCommands::SegmentCommand
  # @return [Integer] the file offset of the segment
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def fileoff; end

  # @return [Integer] the amount to map from the file
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def filesize; end

  # @return [Integer] the memory address of the segment
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def vmaddr; end

  # @return [Integer] the memory size of the segment
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def vmsize; end
end

# A load command specifying the version of the sources used to build the
# binary. Corresponds to LC_SOURCE_VERSION.
#
# source://ruby-macho//lib/macho/load_commands.rb#1236
class MachO::LoadCommands::SourceVersionCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Hash] a hash representation of this {SourceVersionCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1252
  def to_h; end

  # @return [Integer] the version packed as a24.b10.c10.d10.e10
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def version; end

  # A string representation of the sources used to build the binary.
  #
  # @return [String] a string representation of the version
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1241
  def version_string; end
end

# A load command signifying a shared library that is a subframework of
# an umbrella framework. Corresponds to LC_SUB_CLIENT.
#
# source://ruby-macho//lib/macho/load_commands.rb#731
class MachO::LoadCommands::SubClientCommand < ::MachO::LoadCommands::LoadCommand
  # @return [LCStr] the subclient name as an LCStr
  #
  # source://ruby-macho//lib/macho/structure.rb#199
  def sub_client; end

  # @return [Hash] a hash representation of this {SubClientCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#735
  def to_h; end

  # source://ruby-macho//lib/macho/structure.rb#278
  def to_s; end
end

# A load command signifying membership of a subframework containing the name
# of an umbrella framework. Corresponds to LC_SUB_FRAMEWORK.
#
# source://ruby-macho//lib/macho/load_commands.rb#689
class MachO::LoadCommands::SubFrameworkCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Hash] a hash representation of this {SubFrameworkCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#693
  def to_h; end

  # source://ruby-macho//lib/macho/structure.rb#278
  def to_s; end

  # @return [LCStr] the umbrella framework name as an LCStr
  #
  # source://ruby-macho//lib/macho/structure.rb#199
  def umbrella; end
end

# A load command signifying a sublibrary of a shared library. Corresponds
# to LC_SUB_LIBRARY.
#
# source://ruby-macho//lib/macho/load_commands.rb#717
class MachO::LoadCommands::SubLibraryCommand < ::MachO::LoadCommands::LoadCommand
  # @return [LCStr] the sublibrary name as an LCStr
  #
  # source://ruby-macho//lib/macho/structure.rb#199
  def sub_library; end

  # @return [Hash] a hash representation of this {SubLibraryCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#721
  def to_h; end

  # source://ruby-macho//lib/macho/structure.rb#278
  def to_s; end
end

# A load command signifying membership of a subumbrella containing the name
# of an umbrella framework. Corresponds to LC_SUB_UMBRELLA.
#
# source://ruby-macho//lib/macho/load_commands.rb#703
class MachO::LoadCommands::SubUmbrellaCommand < ::MachO::LoadCommands::LoadCommand
  # @return [LCStr] the subumbrella framework name as an LCStr
  #
  # source://ruby-macho//lib/macho/structure.rb#199
  def sub_umbrella; end

  # @return [Hash] a hash representation of this {SubUmbrellaCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#707
  def to_h; end

  # source://ruby-macho//lib/macho/structure.rb#278
  def to_s; end
end

# An obsolete load command containing the offset and size of the (GNU style)
# symbol table information. Corresponds to LC_SYMSEG.
#
# source://ruby-macho//lib/macho/load_commands.rb#1263
class MachO::LoadCommands::SymsegCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Integer] the offset to the symbol segment
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def offset; end

  # @return [Integer] the size of the symbol segment in bytes
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def size; end

  # @return [Hash] a hash representation of this {SymsegCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1270
  def to_h; end
end

# A load command containing the offsets and sizes of the link-edit 4.3BSD
# "stab" style symbol table information. Corresponds to LC_SYMTAB.
#
# source://ruby-macho//lib/macho/load_commands.rb#745
class MachO::LoadCommands::SymtabCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Integer] the number of symbol table entries
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def nsyms; end

  # @return [Integer] the string table's offset
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def stroff; end

  # @return [Integer] the string table size in bytes
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def strsize; end

  # @return [Integer] the symbol table's offset
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def symoff; end

  # @return [Hash] a hash representation of this {SymtabCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#758
  def to_h; end
end

# A load command used to represent threads.
# out except the common ones (cmd, cmdsize)
#
# @note cctools-870 and onwards have all fields of thread_command commented
#
# source://ruby-macho//lib/macho/load_commands.rb#609
class MachO::LoadCommands::ThreadCommand < ::MachO::LoadCommands::LoadCommand; end

# A load command containing the offset and number of hints in the two-level
# namespace lookup hints table. Corresponds to LC_TWOLEVEL_HINTS.
#
# source://ruby-macho//lib/macho/load_commands.rb#853
class MachO::LoadCommands::TwolevelHintsCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Integer] the offset to the hint table
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def htoffset; end

  # @return [Integer] the number of hints in the hint table
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def nhints; end

  # @return [TwolevelHintsTable] the hint table
  #
  # source://ruby-macho//lib/macho/structure.rb#206
  def table; end

  # @return [Hash] a hash representation of this {TwolevelHintsCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#864
  def to_h; end
end

# A representation of the two-level namespace lookup hints table exposed
# by a {TwolevelHintsCommand} (`LC_TWOLEVEL_HINTS`).
#
# source://ruby-macho//lib/macho/load_commands.rb#874
class MachO::LoadCommands::TwolevelHintsCommand::TwolevelHintsTable
  # @api private
  # @param view [MachO::MachOView] the view into the current Mach-O
  # @param htoffset [Integer] the offset of the hints table
  # @param nhints [Integer] the number of two-level hints in the table
  # @return [TwolevelHintsTable] a new instance of TwolevelHintsTable
  #
  # source://ruby-macho//lib/macho/load_commands.rb#882
  def initialize(view, htoffset, nhints); end

  # @return [Array<TwolevelHint>] all hints in the table
  #
  # source://ruby-macho//lib/macho/load_commands.rb#876
  def hints; end
end

# An individual two-level namespace lookup hint.
#
# source://ruby-macho//lib/macho/load_commands.rb#891
class MachO::LoadCommands::TwolevelHintsCommand::TwolevelHintsTable::TwolevelHint
  # @api private
  # @param blob [Integer] the 32-bit number containing the lookup hint
  # @return [TwolevelHint] a new instance of TwolevelHint
  #
  # source://ruby-macho//lib/macho/load_commands.rb#900
  def initialize(blob); end

  # @return [Integer] the index into the sub-images
  #
  # source://ruby-macho//lib/macho/load_commands.rb#893
  def isub_image; end

  # @return [Integer] the index into the table of contents
  #
  # source://ruby-macho//lib/macho/load_commands.rb#896
  def itoc; end

  # @return [Hash] a hash representation of this {TwolevelHint}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#906
  def to_h; end
end

# A load command containing a single 128-bit unique random number
# identifying an object produced by static link editor. Corresponds to
# LC_UUID.
#
# source://ruby-macho//lib/macho/load_commands.rb#369
class MachO::LoadCommands::UUIDCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Hash] returns a hash representation of this {UUIDCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#389
  def to_h; end

  # @return [String] an alias for uuid_string
  #
  # source://ruby-macho//lib/macho/load_commands.rb#384
  def to_s; end

  # @return [Array<Integer>] the UUID
  #
  # source://ruby-macho//lib/macho/structure.rb#242
  def uuid; end

  # @return [String] a string representation of the UUID
  #
  # source://ruby-macho//lib/macho/load_commands.rb#373
  def uuid_string; end
end

# A load command containing the minimum OS version on which the binary
# was built to run. Corresponds to LC_VERSION_MIN_MACOSX and
# LC_VERSION_MIN_IPHONEOS.
#
# source://ruby-macho//lib/macho/load_commands.rb#1018
class MachO::LoadCommands::VersionMinCommand < ::MachO::LoadCommands::LoadCommand
  # @return [Integer] the SDK version X.Y.Z packed as x16.y8.z8
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def sdk; end

  # A string representation of the binary's SDK version.
  #
  # @return [String] a string representing the SDK version.
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1037
  def sdk_string; end

  # @return [Hash] a hash representation of this {VersionMinCommand}
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1047
  def to_h; end

  # @return [Integer] the version X.Y.Z packed as x16.y8.z8
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def version; end

  # A string representation of the binary's minimum OS version.
  #
  # @return [String] a string representing the minimum OS version.
  #
  # source://ruby-macho//lib/macho/load_commands.rb#1026
  def version_string; end
end

# Raised when a Mach-O is loaded with FatFile.
#
# source://ruby-macho//lib/macho/exceptions.rb#89
class MachO::MachOBinaryError < ::MachO::MachOError
  # @return [MachOBinaryError] a new instance of MachOBinaryError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#90
  def initialize; end
end

# A generic Mach-O error in execution.
#
# source://ruby-macho//lib/macho/exceptions.rb#5
class MachO::MachOError < ::RuntimeError; end

# Represents a Mach-O file, which contains a header and load commands
# as well as binary executable instructions. Mach-O binaries are
# architecture specific.
#
# @see https://en.wikipedia.org/wiki/Mach-O
# @see FatFile
#
# source://ruby-macho//lib/macho/macho_file.rb#11
class MachO::MachOFile
  extend ::Forwardable

  # Creates a new instance from data read from the given filename.
  #
  # @note The `:decompress` option relies on non-default dependencies. Compression
  #   is only used in niche Mach-Os, so leaving this disabled is a reasonable default for
  #   virtually all normal uses.
  # @option opts
  # @option opts
  # @param filename [String] the Mach-O file to load from
  # @param opts [Hash] options to control the parser with
  # @raise [ArgumentError] if the given file does not exist
  # @return [MachOFile] a new instance of MachOFile
  #
  # source://ruby-macho//lib/macho/macho_file.rb#58
  def initialize(filename, **opts); end

  # All load commands of a given name.
  #
  # @example
  #   file.command("LC_LOAD_DYLIB")
  #   file[:LC_LOAD_DYLIB]
  # @param name [String, Symbol] the load command ID
  # @return [Array<LoadCommands::LoadCommand>] an array of load commands
  #   corresponding to `name`
  #
  # source://ruby-macho//lib/macho/macho_file.rb#149
  def [](name); end

  # Appends a new load command to the Mach-O.
  #
  # @note This is public, but methods like {#add_rpath} should be preferred.
  #   Setting `repopulate` to false **will leave the instance in an
  #   inconsistent state** unless {#populate_fields} is called **immediately**
  #   afterwards.
  # @option f
  # @param lc [LoadCommands::LoadCommand] the load command being added
  # @param options [Hash]
  # @param f [Hash] a customizable set of options
  # @return [void]
  # @see #insert_command
  #
  # source://ruby-macho//lib/macho/macho_file.rb#215
  def add_command(lc, options = T.unsafe(nil)); end

  # Add the given runtime path to the Mach-O.
  #
  # @example
  #   file.rpaths # => ["/lib"]
  #   file.add_rpath("/usr/lib")
  #   file.rpaths # => ["/lib", "/usr/lib"]
  # @note `_options` is currently unused and is provided for signature
  #   compatibility with {MachO::FatFile#add_rpath}
  # @param path [String] the new runtime path
  # @param _options [Hash]
  # @raise [RpathExistsError] if the runtime path already exists
  # @return [void]
  #
  # source://ruby-macho//lib/macho/macho_file.rb#405
  def add_rpath(path, _options = T.unsafe(nil)); end

  # @return [Integer] the file's internal alignment
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def alignment(*args, **_arg1, &block); end

  # @return [Boolean] whether or not the file is of type `MH_BUNDLE`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def bundle?(*args, **_arg1, &block); end

  # Changes the shared library `old_name` to `new_name`
  #
  # @example
  #   file.change_install_name("abc.dylib", "def.dylib")
  # @note `_options` is currently unused and is provided for signature
  #   compatibility with {MachO::FatFile#change_install_name}
  # @param old_name [String] the shared library's old name
  # @param new_name [String] the shared library's new name
  # @param _options [Hash]
  # @raise [DylibUnknownError] if no shared library has the old name
  # @return [void]
  #
  # source://ruby-macho//lib/macho/macho_file.rb#354
  def change_dylib(old_name, new_name, _options = T.unsafe(nil)); end

  # Changes the Mach-O's dylib ID to `new_id`. Does nothing if not a dylib.
  #
  # @example
  #   file.change_dylib_id("libFoo.dylib")
  # @note `_options` is currently unused and is provided for signature
  #   compatibility with {MachO::FatFile#change_dylib_id}
  # @param new_id [String] the dylib's new ID
  # @param _options [Hash]
  # @raise [ArgumentError] if `new_id` is not a String
  # @return [void]
  #
  # source://ruby-macho//lib/macho/macho_file.rb#317
  def change_dylib_id(new_id, _options = T.unsafe(nil)); end

  # Changes the shared library `old_name` to `new_name`
  #
  # @example
  #   file.change_install_name("abc.dylib", "def.dylib")
  # @note `_options` is currently unused and is provided for signature
  #   compatibility with {MachO::FatFile#change_install_name}
  # @param old_name [String] the shared library's old name
  # @param new_name [String] the shared library's new name
  # @param _options [Hash]
  # @raise [DylibUnknownError] if no shared library has the old name
  # @return [void]
  #
  # source://ruby-macho//lib/macho/macho_file.rb#354
  def change_install_name(old_name, new_name, _options = T.unsafe(nil)); end

  # Changes the runtime path `old_path` to `new_path`
  #
  # @example
  #   file.change_rpath("/usr/lib", "/usr/local/lib")
  # @option options
  # @param old_path [String] the old runtime path
  # @param new_path [String] the new runtime path
  # @param options [Hash]
  # @raise [RpathUnknownError] if no such old runtime path exists
  # @return [void]
  #
  # source://ruby-macho//lib/macho/macho_file.rb#384
  def change_rpath(old_path, new_path, options = T.unsafe(nil)); end

  # All load commands of a given name.
  #
  # @example
  #   file.command("LC_LOAD_DYLIB")
  #   file[:LC_LOAD_DYLIB]
  # @param name [String, Symbol] the load command ID
  # @return [Array<LoadCommands::LoadCommand>] an array of load commands
  #   corresponding to `name`
  #
  # source://ruby-macho//lib/macho/macho_file.rb#149
  def command(name); end

  # @return [Boolean] whether or not the file is of type `MH_CORE`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def core?(*args, **_arg1, &block); end

  # @return [Symbol] a symbol representation of the Mach-O's CPU subtype
  #
  # source://ruby-macho//lib/macho/macho_file.rb#138
  def cpusubtype; end

  # @return [Symbol] a symbol representation of the Mach-O's CPU type
  #
  # source://ruby-macho//lib/macho/macho_file.rb#133
  def cputype; end

  # Delete a load command from the Mach-O.
  #
  # @note This is public, but methods like {#delete_rpath} should be preferred.
  #   Setting `repopulate` to false **will leave the instance in an
  #   inconsistent state** unless {#populate_fields} is called **immediately**
  #   afterwards.
  # @option options
  # @param lc [LoadCommands::LoadCommand] the load command being deleted
  # @param options [Hash]
  # @return [void]
  #
  # source://ruby-macho//lib/macho/macho_file.rb#229
  def delete_command(lc, options = T.unsafe(nil)); end

  # Delete the given runtime path from the Mach-O.
  # instance (by offset) of the requested path. Incompatible with :uniq.
  #
  # @example
  #   file.rpaths # => ["/lib"]
  #   file.delete_rpath("/lib")
  #   file.rpaths # => []
  # @option options
  # @option options
  # @param options [Hash]
  # @param path [String] the runtime path to delete
  # @raise [RpathUnknownError] if no such runtime path exists
  # @raise [ArgumentError] if both :uniq and :last are true
  # @return void
  #
  # source://ruby-macho//lib/macho/macho_file.rb#428
  def delete_rpath(path, options = T.unsafe(nil)); end

  # @return [Boolean] whether or not the file is of type `MH_DSYM`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def dsym?(*args, **_arg1, &block); end

  # @return [Boolean] whether or not the file is of type `MH_DYLIB`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def dylib?(*args, **_arg1, &block); end

  # The Mach-O's dylib ID, or `nil` if not a dylib.
  #
  # @example
  #   file.dylib_id # => 'libBar.dylib'
  # @return [String, nil] the Mach-O's dylib ID
  #
  # source://ruby-macho//lib/macho/macho_file.rb#300
  def dylib_id; end

  # Changes the Mach-O's dylib ID to `new_id`. Does nothing if not a dylib.
  #
  # @example
  #   file.change_dylib_id("libFoo.dylib")
  # @note `_options` is currently unused and is provided for signature
  #   compatibility with {MachO::FatFile#change_dylib_id}
  # @param new_id [String] the dylib's new ID
  # @param _options [Hash]
  # @raise [ArgumentError] if `new_id` is not a String
  # @return [void]
  #
  # source://ruby-macho//lib/macho/macho_file.rb#317
  def dylib_id=(new_id, _options = T.unsafe(nil)); end

  # All load commands responsible for loading dylibs.
  #
  # @return [Array<LoadCommands::DylibCommand>] an array of DylibCommands
  #
  # source://ruby-macho//lib/macho/macho_file.rb#254
  def dylib_load_commands; end

  # @return [Boolean] whether or not the file is of type `MH_DYLINKER`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def dylinker?(*args, **_arg1, &block); end

  # @return [Symbol] the endianness of the file, :big or :little
  #
  # source://ruby-macho//lib/macho/macho_file.rb#22
  def endianness; end

  # @return [Boolean] whether or not the file is of type `MH_EXECUTE`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def executable?(*args, **_arg1, &block); end

  # @return [String, nil] the filename loaded from, or nil if loaded from a binary
  #   string
  #
  # source://ruby-macho//lib/macho/macho_file.rb#16
  def filename; end

  # @return [String, nil] the filename loaded from, or nil if loaded from a binary
  #   string
  #
  # source://ruby-macho//lib/macho/macho_file.rb#16
  def filename=(_arg0); end

  # @return [Symbol] a string representation of the Mach-O's filetype
  #
  # source://ruby-macho//lib/macho/macho_file.rb#128
  def filetype; end

  # @return [Integer] the header flags associated with the Mach-O
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def flags(*args, **_arg1, &block); end

  # @return [Boolean] whether or not the file is of type `MH_FVMLIB`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def fvmlib?(*args, **_arg1, &block); end

  # @return [Headers::MachHeader] if the Mach-O is 32-bit
  # @return [Headers::MachHeader64] if the Mach-O is 64-bit
  #
  # source://ruby-macho//lib/macho/macho_file.rb#26
  def header; end

  # Initializes a new MachOFile instance from a binary string with the given options.
  #
  # @api private
  # @see MachO::MachOFile.new_from_bin
  #
  # source://ruby-macho//lib/macho/macho_file.rb#70
  def initialize_from_bin(bin, opts); end

  # Inserts a load command at the given offset.
  # **will leave the object in an inconsistent state**.
  #
  # @note Calling this method with an arbitrary offset in the load command region
  # @option options
  # @param offset [Integer] the offset to insert at
  # @param lc [LoadCommands::LoadCommand] the load command to insert
  # @param options [Hash]
  # @raise [OffsetInsertionError] if the offset is not in the load command region
  # @raise [HeaderPadError] if the new command exceeds the header pad buffer
  #
  # source://ruby-macho//lib/macho/macho_file.rb#165
  def insert_command(offset, lc, options = T.unsafe(nil)); end

  # @return [Boolean] whether or not the file is of type `MH_KEXT_BUNDLE`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def kext?(*args, **_arg1, &block); end

  # All shared libraries linked to the Mach-O.
  #
  # @return [Array<String>] an array of all shared libraries
  #
  # source://ruby-macho//lib/macho/macho_file.rb#336
  def linked_dylibs; end

  # @note load commands are provided in order of ascending offset.
  # @return [Array<LoadCommands::LoadCommand>] an array of the file's load
  #   commands
  #
  # source://ruby-macho//lib/macho/macho_file.rb#31
  def load_commands; end

  # @return [Integer] the magic number
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def magic(*args, **_arg1, &block); end

  # @return [Boolean] true if the Mach-O has 32-bit magic, false otherwise
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def magic32?(*args, **_arg1, &block); end

  # @return [Boolean] true if the Mach-O has 64-bit magic, false otherwise
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def magic64?(*args, **_arg1, &block); end

  # @return [String] a string representation of the file's magic number
  #
  # source://ruby-macho//lib/macho/macho_file.rb#123
  def magic_string; end

  # @return [Integer] the number of load commands in the Mach-O
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def ncmds(*args, **_arg1, &block); end

  # @return [Boolean] whether or not the file is of type `MH_OBJECT`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def object?(*args, **_arg1, &block); end

  # @return [Hash] any parser options that the instance was created with
  #
  # source://ruby-macho//lib/macho/macho_file.rb#19
  def options; end

  # Populate the instance's fields with the raw Mach-O data.
  #
  # @note This method is public, but should (almost) never need to be called.
  #   The exception to this rule is when methods like {#add_command} and
  #   {#delete_command} have been called with `repopulate = false`.
  # @return [void]
  #
  # source://ruby-macho//lib/macho/macho_file.rb#247
  def populate_fields; end

  # @return [Boolean] whether or not the file is of type `MH_PRELOAD`
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def preload?(*args, **_arg1, &block); end

  # Replace a load command with another command in the Mach-O, preserving location.
  #
  # @note This is public, but methods like {#dylib_id=} should be preferred.
  # @param old_lc [LoadCommands::LoadCommand] the load command being replaced
  # @param new_lc [LoadCommands::LoadCommand] the load command being added
  # @raise [HeaderPadError] if the new command exceeds the header pad buffer
  # @return [void]
  # @see #insert_command
  #
  # source://ruby-macho//lib/macho/macho_file.rb#193
  def replace_command(old_lc, new_lc); end

  # All runtime paths searched by the dynamic linker for the Mach-O.
  #
  # @return [Array<String>] an array of all runtime paths
  #
  # source://ruby-macho//lib/macho/macho_file.rb#370
  def rpaths; end

  # The segment alignment for the Mach-O. Guesses conservatively.
  #
  # @note This is **not** the same as {#alignment}!
  # @note See `get_align` and `get_align_64` in `cctools/misc/lipo.c`
  # @return [Integer] the alignment, as a power of 2
  #
  # source://ruby-macho//lib/macho/macho_file.rb#273
  def segment_alignment; end

  # All segment load commands in the Mach-O.
  #
  # @return [Array<LoadCommands::SegmentCommand>] if the Mach-O is 32-bit
  # @return [Array<LoadCommands::SegmentCommand64>] if the Mach-O is 64-bit
  #
  # source://ruby-macho//lib/macho/macho_file.rb#261
  def segments; end

  # The file's raw Mach-O data.
  #
  # @return [String] the raw Mach-O data
  #
  # source://ruby-macho//lib/macho/macho_file.rb#79
  def serialize; end

  # @return [Integer] the size of all load commands, in bytes, in the Mach-O
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def sizeofcmds(*args, **_arg1, &block); end

  # @return [Hash] a hash representation of this {MachOFile}
  #
  # source://ruby-macho//lib/macho/macho_file.rb#463
  def to_h; end

  # Write all Mach-O data to the given filename.
  #
  # @param filename [String] the file to write to
  # @return [void]
  #
  # source://ruby-macho//lib/macho/macho_file.rb#448
  def write(filename); end

  # Write all Mach-O data to the file used to initialize the instance.
  #
  # @note Overwrites all data in the file!
  # @raise [MachOError] if the instance was initialized without a file
  # @return [void]
  #
  # source://ruby-macho//lib/macho/macho_file.rb#456
  def write!; end

  private

  # Check the file's CPU type/subtype pair.
  #
  # @api private
  # @param cpusubtype [Integer] the CPU subtype
  # @raise [CPUSubtypeError] if the CPU sub-type is unknown
  #
  # source://ruby-macho//lib/macho/macho_file.rb#565
  def check_cpusubtype(cputype, cpusubtype); end

  # Check the file's CPU type.
  #
  # @api private
  # @param cputype [Integer] the CPU type
  # @raise [CPUTypeError] if the CPU type is unknown
  #
  # source://ruby-macho//lib/macho/macho_file.rb#557
  def check_cputype(cputype); end

  # Check the file's type.
  #
  # @api private
  # @param filetype [Integer] the file type
  # @raise [FiletypeError] if the file type is unknown
  #
  # source://ruby-macho//lib/macho/macho_file.rb#574
  def check_filetype(filetype); end

  # Attempt to decompress a Mach-O file from the data specified in a prelinked kernel header.
  #
  # @api private
  # @note This method rewrites the internal state of {MachOFile} to pretend as if it was never
  #   compressed to begin with, allowing all other APIs to transparently act on compressed Mach-Os.
  # @raise [DecompressionError] if decompression is impossible or fails
  # @return [void]
  #
  # source://ruby-macho//lib/macho/macho_file.rb#518
  def decompress_macho_lzvn; end

  # The low file offset (offset to first section data).
  #
  # @api private
  # @return [Integer] the offset
  #
  # source://ruby-macho//lib/macho/macho_file.rb#615
  def low_fileoff; end

  # Read just the file's magic number and check its validity.
  #
  # @api private
  # @raise [MagicError] if the magic is not valid Mach-O magic
  # @raise [FatBinaryError] if the magic is for a Fat file
  # @return [Integer] the magic
  #
  # source://ruby-macho//lib/macho/macho_file.rb#542
  def populate_and_check_magic; end

  # All load commands in the file.
  #
  # @api private
  # @raise [LoadCommandError] if an unknown load command is encountered
  # @return [Array<LoadCommands::LoadCommand>] an array of load commands
  #
  # source://ruby-macho//lib/macho/macho_file.rb#582
  def populate_load_commands; end

  # The file's Mach-O header structure.
  #
  # @api private
  # @raise [TruncatedFileError] if the file is too small to have a valid header
  # @return [Headers::MachHeader] if the Mach-O is 32-bit
  # @return [Headers::MachHeader64] if the Mach-O is 64-bit
  #
  # source://ruby-macho//lib/macho/macho_file.rb#477
  def populate_mach_header; end

  # Read a compressed Mach-O header and check its validity, as well as whether we're able
  # to parse it.
  #
  # @api private
  # @raise [CompressedMachOError] if we weren't asked to perform decompression
  # @raise [DecompressionError] if decompression is impossible or fails
  # @return [void]
  #
  # source://ruby-macho//lib/macho/macho_file.rb#501
  def populate_prelinked_kernel_header; end

  # Updates the number of load commands in the raw data.
  #
  # @api private
  # @param ncmds [Integer] the new number of commands
  # @return [void]
  #
  # source://ruby-macho//lib/macho/macho_file.rb#636
  def update_ncmds(ncmds); end

  # Updates the size of all load commands in the raw data.
  #
  # @api private
  # @param size [Integer] the new size, in bytes
  # @return [void]
  #
  # source://ruby-macho//lib/macho/macho_file.rb#646
  def update_sizeofcmds(size); end

  class << self
    # Creates a new instance from a binary string.
    #
    # @note The `:decompress` option relies on non-default dependencies. Compression
    #   is only used in niche Mach-Os, so leaving this disabled is a reasonable default for
    #   virtually all normal uses.
    # @option opts
    # @option opts
    # @param bin [String] a binary string containing raw Mach-O data
    # @param opts [Hash] options to control the parser with
    # @return [MachOFile] a new MachOFile
    #
    # source://ruby-macho//lib/macho/macho_file.rb#42
    def new_from_bin(bin, **opts); end
  end
end

# A general purpose pseudo-structure. Described in detail in docs/machostructure-dsl.md.
#
# @abstract
#
# source://ruby-macho//lib/macho/structure.rb#6
class MachO::MachOStructure
  # @param args [Array[Value]] list of field parameters
  # @raise [ArgumentError]
  # @return [MachOStructure] a new instance of MachOStructure
  #
  # source://ruby-macho//lib/macho/structure.rb#75
  def initialize(*args); end

  # @return [Hash] a hash representation of this {MachOStructure}.
  #
  # source://ruby-macho//lib/macho/structure.rb#82
  def to_h; end

  class << self
    # source://ruby-macho//lib/macho/structure.rb#108
    def bytesize; end

    # source://ruby-macho//lib/macho/structure.rb#104
    def format; end

    # Returns the value of attribute min_args.
    #
    # source://ruby-macho//lib/macho/structure.rb#92
    def min_args; end

    # @api private
    # @param endianness [Symbol] either `:big` or `:little`
    # @param bin [String] the string to be unpacked into the new structure
    # @return [MachO::MachOStructure] the resulting structure
    #
    # source://ruby-macho//lib/macho/structure.rb#98
    def new_from_bin(endianness, bin); end

    private

    # Generates a reader method for classes that need to be initialized.
    # These classes are defined in the Fields::CLASSES_TO_INIT array.
    #
    # @api private
    # @param name [Symbol] name of internal field
    # @param type [Symbol] type of field in terms of binary size
    # @param idx [Integer] the index of the field value in the @values array
    #
    # source://ruby-macho//lib/macho/structure.rb#196
    def def_class_reader(name, type, idx); end

    # Generates a reader method for fields that have default values.
    #
    # @api private
    # @param name [Symbol] name of internal field
    # @param idx [Integer] the index of the field value in the @values array
    # @param default [Value] the default value
    #
    # source://ruby-macho//lib/macho/structure.rb#255
    def def_default_reader(name, idx, default); end

    # Generates a reader method for fields that need to be bitmasked.
    #
    # @api private
    # @param name [Symbol] name of internal field
    # @param idx [Integer] the index of the field value in the @values array
    # @param mask [Integer] the bitmask
    #
    # source://ruby-macho//lib/macho/structure.rb#227
    def def_mask_reader(name, idx, mask); end

    # Generates an attr_reader like method for a field.
    #
    # @api private
    # @param name [Symbol] name of internal field
    # @param idx [Integer] the index of the field value in the @values array
    #
    # source://ruby-macho//lib/macho/structure.rb#268
    def def_reader(name, idx); end

    # Generates the to_s method based on the named field.
    #
    # @api private
    # @param name [Symbol] name of the field
    #
    # source://ruby-macho//lib/macho/structure.rb#277
    def def_to_s(name); end

    # Generates a reader method for fields that need further unpacking.
    #
    # @api private
    # @param name [Symbol] name of internal field
    # @param idx [Integer] the index of the field value in the @values array
    # @param unpack [String] the format code used for futher binary unpacking
    #
    # source://ruby-macho//lib/macho/structure.rb#241
    def def_unpack_reader(name, idx, unpack); end

    # Expected options
    #   :size [Integer] size in bytes
    #   :mask [Integer] bitmask
    #   :unpack [String] string format
    #   :default [Value] default value
    #   :to_s [Boolean] flag for generating #to_s
    #   :endian [Symbol] optionally specify :big or :little endian
    #   :padding [Symbol] optionally specify :null padding
    #
    # @api private
    # @param name [Symbol] name of internal field
    # @param type [Symbol] type of field in terms of binary size
    # @param options [Hash] set of additonal options
    # @raise [ArgumentError]
    #
    # source://ruby-macho//lib/macho/structure.rb#144
    def field(name, type, **options); end

    # @api private
    # @param subclass [Class] subclass type
    #
    # source://ruby-macho//lib/macho/structure.rb#116
    def inherited(subclass); end
  end
end

# Constants used for parsing MachOStructure fields
#
# source://ruby-macho//lib/macho/structure.rb#8
module MachO::MachOStructure::Fields; end

# association of field types to byte size
#
# @api private
#
# source://ruby-macho//lib/macho/structure.rb#16
MachO::MachOStructure::Fields::BYTE_SIZE = T.let(T.unsafe(nil), Hash)

# A list of classes that must get initialized
# To add a new class append it here and add the init method to the def_class_reader method
#
# @api private
#
# source://ruby-macho//lib/macho/structure.rb#54
MachO::MachOStructure::Fields::CLASSES_TO_INIT = T.let(T.unsafe(nil), Array)

# association of field types with ruby format codes
# Binary format codes can be found here:
# https://docs.ruby-lang.org/en/2.6.0/String.html#method-i-unpack
#
# The equals sign is used to manually change endianness using
# the Utils#specialize_format() method.
#
# @api private
#
# source://ruby-macho//lib/macho/structure.rb#37
MachO::MachOStructure::Fields::FORMAT_CODE = T.let(T.unsafe(nil), Hash)

# A list of fields that don't require arguments in the initializer
# Used to calculate MachOStructure#min_args
#
# @api private
#
# source://ruby-macho//lib/macho/structure.rb#59
MachO::MachOStructure::Fields::NO_ARG_REQUIRED = T.let(T.unsafe(nil), Array)

# A representation of some unspecified Mach-O data.
#
# source://ruby-macho//lib/macho/view.rb#5
class MachO::MachOView
  # Creates a new MachOView.
  #
  # @param macho_file [MachOFile] the file this view slice is from
  # @param raw_data [String] the raw Mach-O data
  # @param endianness [Symbol] the endianness of the data
  # @param offset [Integer] the offset of the relevant data
  # @return [MachOView] a new instance of MachOView
  #
  # source://ruby-macho//lib/macho/view.rb#23
  def initialize(macho_file, raw_data, endianness, offset); end

  # @return [Symbol] the endianness of the data (`:big` or `:little`)
  #
  # source://ruby-macho//lib/macho/view.rb#13
  def endianness; end

  # source://ruby-macho//lib/macho/view.rb#38
  def inspect; end

  # @return [MachOFile] that this view belongs to
  #
  # source://ruby-macho//lib/macho/view.rb#7
  def macho_file; end

  # @return [Integer] the offset of the relevant data (in {#raw_data})
  #
  # source://ruby-macho//lib/macho/view.rb#16
  def offset; end

  # @return [String] the raw Mach-O data
  #
  # source://ruby-macho//lib/macho/view.rb#10
  def raw_data; end

  # @return [Hash] a hash representation of this {MachOView}.
  #
  # source://ruby-macho//lib/macho/view.rb#31
  def to_h; end
end

# Raised when a file's magic bytes are not valid Mach-O magic.
#
# source://ruby-macho//lib/macho/exceptions.rb#46
class MachO::MagicError < ::MachO::NotAMachOError
  # @param num [Integer] the unknown number
  # @return [MagicError] a new instance of MagicError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#47
  def initialize(magic); end
end

# Raised when a Mach-O file modification fails.
#
# source://ruby-macho//lib/macho/exceptions.rb#9
class MachO::ModificationError < ::MachO::MachOError; end

# Raised when a file is not a Mach-O.
#
# source://ruby-macho//lib/macho/exceptions.rb#34
class MachO::NotAMachOError < ::MachO::MachOError; end

# Raised when a change at an offset is not valid.
#
# source://ruby-macho//lib/macho/exceptions.rb#168
class MachO::OffsetInsertionError < ::MachO::ModificationError
  # @param offset [Integer] the invalid offset
  # @return [OffsetInsertionError] a new instance of OffsetInsertionError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#169
  def initialize(offset); end
end

# Raised when a Mach-O file modification fails but can be recovered when
# operating on multiple Mach-O slices of a fat binary in non-strict mode.
#
# source://ruby-macho//lib/macho/exceptions.rb#22
class MachO::RecoverableModificationError < ::MachO::ModificationError
  # @return [Integer, nil] The index of the Mach-O slice of a fat binary for
  #   which modification failed or `nil` if not a fat binary. This is used to
  #   make the error message more useful.
  #
  # source://ruby-macho//lib/macho/exceptions.rb#23
  def macho_slice; end

  # @return [Integer, nil] The index of the Mach-O slice of a fat binary for
  #   which modification failed or `nil` if not a fat binary. This is used to
  #   make the error message more useful.
  #
  # source://ruby-macho//lib/macho/exceptions.rb#23
  def macho_slice=(_arg0); end

  # @return [String] The exception message.
  #
  # source://ruby-macho//lib/macho/exceptions.rb#26
  def to_s; end
end

# Raised when attempting to add an rpath that already exists.
#
# source://ruby-macho//lib/macho/exceptions.rb#209
class MachO::RpathExistsError < ::MachO::RecoverableModificationError
  # @param path [String] the extant path
  # @return [RpathExistsError] a new instance of RpathExistsError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#210
  def initialize(path); end
end

# Raised when attempting to change an rpath that doesn't exist.
#
# source://ruby-macho//lib/macho/exceptions.rb#201
class MachO::RpathUnknownError < ::MachO::RecoverableModificationError
  # @param path [String] the unknown runtime path
  # @return [RpathUnknownError] a new instance of RpathUnknownError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#202
  def initialize(path); end
end

# Classes and constants for parsing sections in Mach-O binaries.
#
# source://ruby-macho//lib/macho/sections.rb#5
module MachO::Sections; end

# maximum specifiable section alignment, as a power of 2
#
# @note see `MAXSECTALIGN` macro in `cctools/misc/lipo.c`
#
# source://ruby-macho//lib/macho/sections.rb#20
MachO::Sections::MAX_SECT_ALIGN = T.let(T.unsafe(nil), Integer)

# association of section attribute symbols to values
#
# @api private
#
# source://ruby-macho//lib/macho/sections.rb#52
MachO::Sections::SECTION_ATTRIBUTES = T.let(T.unsafe(nil), Hash)

# attributes mask
#
# source://ruby-macho//lib/macho/sections.rb#10
MachO::Sections::SECTION_ATTRIBUTES_MASK = T.let(T.unsafe(nil), Integer)

# system settable attributes mask
#
# source://ruby-macho//lib/macho/sections.rb#16
MachO::Sections::SECTION_ATTRIBUTES_SYS_MASK = T.let(T.unsafe(nil), Integer)

# user settable attributes mask
#
# source://ruby-macho//lib/macho/sections.rb#13
MachO::Sections::SECTION_ATTRIBUTES_USR_MASK = T.let(T.unsafe(nil), Integer)

# association of section flag symbols to values
#
# @api private
#
# source://ruby-macho//lib/macho/sections.rb#67
MachO::Sections::SECTION_FLAGS = T.let(T.unsafe(nil), Hash)

# association of section name symbols to names
#
# @api private
#
# source://ruby-macho//lib/macho/sections.rb#74
MachO::Sections::SECTION_NAMES = T.let(T.unsafe(nil), Hash)

# association of section type symbols to values
#
# @api private
#
# source://ruby-macho//lib/macho/sections.rb#24
MachO::Sections::SECTION_TYPES = T.let(T.unsafe(nil), Hash)

# type mask
#
# source://ruby-macho//lib/macho/sections.rb#7
MachO::Sections::SECTION_TYPE_MASK = T.let(T.unsafe(nil), Integer)

# Represents a section of a segment for 32-bit architectures.
#
# source://ruby-macho//lib/macho/sections.rb#91
class MachO::Sections::Section < ::MachO::MachOStructure
  # @return [Integer] the memory address of the section
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def addr; end

  # @return [Integer] the section alignment (power of 2) of the section
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def align; end

  # @example
  #   puts "pure instructions" if sect.attribute?(:S_ATTR_PURE_INSTRUCTIONS)
  # @param attr_sym [Symbol] a section attribute symbol
  # @return [Boolean] whether this section is of the given type
  #
  # source://ruby-macho//lib/macho/sections.rb#162
  def attribute?(attr_sym); end

  # @return [Integer] the raw numeric attributes of this section
  #
  # source://ruby-macho//lib/macho/sections.rb#154
  def attributes; end

  # @return [Boolean] whether the section is empty (i.e, {size} is 0)
  #
  # source://ruby-macho//lib/macho/sections.rb#136
  def empty?; end

  # @deprecated Use {#type?} or {#attribute?} instead.
  # @example
  #   puts "this section is regular" if sect.flag?(:S_REGULAR)
  # @param flag [Symbol] a section flag symbol
  # @return [Boolean] whether the flag is present in the section's {flags}
  #
  # source://ruby-macho//lib/macho/sections.rb#171
  def flag?(flag); end

  # @return [Integer] flags for type and attributes of the section
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def flags; end

  # @return [Integer] the number of relocation entries
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def nreloc; end

  # @return [Integer] the file offset of the section
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def offset; end

  # @return [Integer] the file offset of the section's relocation entries
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def reloff; end

  # @return [void] reserved (for offset or index)
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def reserved1; end

  # @return [void] reserved (for count or sizeof)
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def reserved2; end

  # @return [String] the section's name
  #
  # source://ruby-macho//lib/macho/sections.rb#126
  def section_name; end

  # @return [String] the name of the section, including null pad bytes
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def sectname; end

  # @return [String] the parent segment's name
  #
  # source://ruby-macho//lib/macho/sections.rb#131
  def segment_name; end

  # @return [String] the name of the segment's section, including null
  #   pad bytes
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def segname; end

  # @return [Integer] the size, in bytes, of the section
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def size; end

  # @return [Hash] a hash representation of this {Section}
  #
  # source://ruby-macho//lib/macho/sections.rb#180
  def to_h; end

  # @return [Integer] the raw numeric type of this section
  #
  # source://ruby-macho//lib/macho/sections.rb#141
  def type; end

  # @example
  #   puts "this section is regular" if sect.type?(:S_REGULAR)
  # @param type_sym [Symbol] a section type symbol
  # @return [Boolean] whether this section is of the given type
  #
  # source://ruby-macho//lib/macho/sections.rb#149
  def type?(type_sym); end
end

# Represents a section of a segment for 64-bit architectures.
#
# source://ruby-macho//lib/macho/sections.rb#199
class MachO::Sections::Section64 < ::MachO::Sections::Section
  # @return [Integer] the memory address of the section
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def addr; end

  # @return [void] reserved
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def reserved3; end

  # @return [Integer] the size, in bytes, of the section
  #
  # source://ruby-macho//lib/macho/structure.rb#269
  def size; end

  # @return [Hash] a hash representation of this {Section64}
  #
  # source://ruby-macho//lib/macho/sections.rb#209
  def to_h; end
end

# A collection of convenient methods for common operations on Mach-O and Fat
# binaries.
#
# source://ruby-macho//lib/macho/tools.rb#6
module MachO::Tools
  class << self
    # Add a runtime path to a Mach-O or Fat binary, overwriting the source file.
    #
    # @option options
    # @param filename [String] the Mach-O or Fat binary being modified
    # @param new_path [String] the new runtime path
    # @param options [Hash]
    # @return [void]
    #
    # source://ruby-macho//lib/macho/tools.rb#71
    def add_rpath(filename, new_path, options = T.unsafe(nil)); end

    # Changes the dylib ID of a Mach-O or Fat binary, overwriting the source
    #  file.
    #
    # @option options
    # @param filename [String] the Mach-O or Fat binary being modified
    # @param new_id [String] the new dylib ID for the binary
    # @param options [Hash]
    # @return [void]
    #
    # source://ruby-macho//lib/macho/tools.rb#23
    def change_dylib_id(filename, new_id, options = T.unsafe(nil)); end

    # Changes a shared library install name in a Mach-O or Fat binary,
    #  overwriting the source file.
    #
    # @option options
    # @param filename [String] the Mach-O or Fat binary being modified
    # @param old_name [String] the old shared library name
    # @param new_name [String] the new shared library name
    # @param options [Hash]
    # @return [void]
    #
    # source://ruby-macho//lib/macho/tools.rb#39
    def change_install_name(filename, old_name, new_name, options = T.unsafe(nil)); end

    # Changes a runtime path in a Mach-O or Fat binary, overwriting the source
    #  file.
    #
    # @option options
    # @option options
    # @param filename [String] the Mach-O or Fat binary being modified
    # @param old_path [String] the old runtime path
    # @param new_path [String] the new runtime path
    # @param options [Hash]
    # @return [void]
    #
    # source://ruby-macho//lib/macho/tools.rb#57
    def change_rpath(filename, old_path, new_path, options = T.unsafe(nil)); end

    # Delete a runtime path from a Mach-O or Fat binary, overwriting the source
    #  file.
    #
    # @option options
    # @option options
    # @param filename [String] the Mach-O or Fat binary being modified
    # @param old_path [String] the old runtime path
    # @param options [Hash]
    # @return [void]
    #
    # source://ruby-macho//lib/macho/tools.rb#88
    def delete_rpath(filename, old_path, options = T.unsafe(nil)); end

    # @param filename [String] the Mach-O or Fat binary being read
    # @return [Array<String>] an array of all dylibs linked to the binary
    #
    # source://ruby-macho//lib/macho/tools.rb#9
    def dylibs(filename); end

    # Merge multiple Mach-Os into one universal (Fat) binary.
    #
    # @param filename [String] the fat binary to create
    # @param files [Array<String>] the files to merge
    # @param fat64 [Boolean] whether to use {Headers::FatArch64}s to represent each slice
    # @return [void]
    #
    # source://ruby-macho//lib/macho/tools.rb#100
    def merge_machos(filename, *files, fat64: T.unsafe(nil)); end
  end
end

# Raised when a file is too short to be a valid Mach-O file.
#
# source://ruby-macho//lib/macho/exceptions.rb#38
class MachO::TruncatedFileError < ::MachO::NotAMachOError
  # @return [TruncatedFileError] a new instance of TruncatedFileError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#39
  def initialize; end
end

# Raised whenever unfinished code is called.
#
# source://ruby-macho//lib/macho/exceptions.rb#217
class MachO::UnimplementedError < ::MachO::MachOError
  # @param thing [String] the thing that is unimplemented
  # @return [UnimplementedError] a new instance of UnimplementedError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#218
  def initialize(thing); end
end

# A collection of utility functions used throughout ruby-macho.
#
# source://ruby-macho//lib/macho/utils.rb#5
module MachO::Utils
  class << self
    # Compares the given number to valid big-endian magic numbers.
    #
    # @param num [Integer] the number being checked
    # @return [Boolean] whether `num` is a valid big-endian magic number
    #
    # source://ruby-macho//lib/macho/utils.rb#121
    def big_magic?(num); end

    # Compares the given number to the known magic number for a compressed Mach-O slice.
    #
    # @param num [Integer] the number being checked
    # @return [Boolean] whether `num` is a valid compressed header magic number
    #
    # source://ruby-macho//lib/macho/utils.rb#128
    def compressed_magic?(num); end

    # Compares the given number to valid 32-bit Fat magic numbers.
    #
    # @param num [Integer] the number being checked
    # @return [Boolean] whether `num` is a valid 32-bit fat magic number
    #
    # source://ruby-macho//lib/macho/utils.rb#86
    def fat_magic32?(num); end

    # Compares the given number to valid 64-bit Fat magic numbers.
    #
    # @param num [Integer] the number being checked
    # @return [Boolean] whether `num` is a valid 64-bit fat magic number
    #
    # source://ruby-macho//lib/macho/utils.rb#93
    def fat_magic64?(num); end

    # Compares the given number to valid Fat magic numbers.
    #
    # @param num [Integer] the number being checked
    # @return [Boolean] whether `num` is a valid Fat magic number
    #
    # source://ruby-macho//lib/macho/utils.rb#79
    def fat_magic?(num); end

    # Compares the given number to valid little-endian magic numbers.
    #
    # @param num [Integer] the number being checked
    # @return [Boolean] whether `num` is a valid little-endian magic number
    #
    # source://ruby-macho//lib/macho/utils.rb#114
    def little_magic?(num); end

    # Compares the given number to valid 32-bit Mach-O magic numbers.
    #
    # @param num [Integer] the number being checked
    # @return [Boolean] whether `num` is a valid 32-bit magic number
    #
    # source://ruby-macho//lib/macho/utils.rb#100
    def magic32?(num); end

    # Compares the given number to valid 64-bit Mach-O magic numbers.
    #
    # @param num [Integer] the number being checked
    # @return [Boolean] whether `num` is a valid 64-bit magic number
    #
    # source://ruby-macho//lib/macho/utils.rb#107
    def magic64?(num); end

    # Compares the given number to valid Mach-O magic numbers.
    #
    # @param num [Integer] the number being checked
    # @return [Boolean] whether `num` is a valid Mach-O magic number
    #
    # source://ruby-macho//lib/macho/utils.rb#72
    def magic?(num); end

    # Returns a string of null bytes of the requested (non-negative) size
    #
    # @param size [Integer] the size of the nullpad
    # @raise [ArgumentError] if a non-positive nullpad is requested
    # @return [String] the null string (or empty string, for `size = 0`)
    #
    # source://ruby-macho//lib/macho/utils.rb#31
    def nullpad(size); end

    # Packs tagged strings into an aligned payload.
    #
    # @param fixed_offset [Integer] the baseline offset for the first packed
    #   string
    # @param alignment [Integer] the alignment value to use for packing
    # @param strings [Hash] the labeled strings to pack
    # @return [Array<String, Hash>] the packed string and labeled offsets
    #
    # source://ruby-macho//lib/macho/utils.rb#53
    def pack_strings(fixed_offset, alignment, strings = T.unsafe(nil)); end

    # Returns the number of bytes needed to pad the given size to the given
    #  alignment.
    #
    # @param size [Integer] the unpadded size
    # @param alignment [Integer] the number to alignment the size with
    # @return [Integer] the number of pad bytes required
    #
    # source://ruby-macho//lib/macho/utils.rb#23
    def padding_for(size, alignment); end

    # Rounds a value to the next multiple of the given round.
    #
    # @param value [Integer] the number being rounded
    # @param round [Integer] the number being rounded with
    # @return [Integer] the rounded value
    # @see http://www.opensource.apple.com/source/cctools/cctools-870/libstuff/rnd.c
    #
    # source://ruby-macho//lib/macho/utils.rb#11
    def round(value, round); end

    # Converts an abstract (native-endian) String#unpack format to big or
    #  little.
    #
    # @param format [String] the format string being converted
    # @param endianness [Symbol] either `:big` or `:little`
    # @return [String] the converted string
    #
    # source://ruby-macho//lib/macho/utils.rb#42
    def specialize_format(format, endianness); end
  end
end

# release version
#
# source://ruby-macho//lib/macho.rb#19
MachO::VERSION = T.let(T.unsafe(nil), String)

# Raised when a a fat Mach-O file has zero architectures
#
# source://ruby-macho//lib/macho/exceptions.rb#60
class MachO::ZeroArchitectureError < ::MachO::NotAMachOError
  # @return [ZeroArchitectureError] a new instance of ZeroArchitectureError
  #
  # source://ruby-macho//lib/macho/exceptions.rb#61
  def initialize; end
end
