# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `simplecov` gem.
# Please instead update this file by running `bin/tapioca gem simplecov`.

# Code coverage for ruby. Please check out README for a full introduction.
#
# source://simplecov//lib/simplecov.rb#22
module SimpleCov
  extend ::SimpleCov::Configuration

  class << self
    # source://simplecov//lib/simplecov.rb#174
    def at_exit_behavior; end

    # Clear out the previously cached .result. Primarily useful in testing
    #
    # source://simplecov//lib/simplecov.rb#170
    def clear_result; end

    # Collate a series of SimpleCov result files into a single SimpleCov output.
    #
    # You can optionally specify configuration with a block:
    #   SimpleCov.collate Dir["simplecov-resultset-*/.resultset.json"]
    #    OR
    #   SimpleCov.collate Dir["simplecov-resultset-*/.resultset.json"], 'rails' # using rails profile
    #    OR
    #   SimpleCov.collate Dir["simplecov-resultset-*/.resultset.json"] do
    #     add_filter 'test'
    #   end
    #    OR
    #   SimpleCov.collate Dir["simplecov-resultset-*/.resultset.json"], 'rails' do
    #     add_filter 'test'
    #   end
    #
    # Please check out the RDoc for SimpleCov::Configuration to find about
    # available config options, or checkout the README for more in-depth
    # information about coverage collation
    #
    # By default `collate` ignores the merge_timeout so all results of all files specified will be
    # merged together. If you want to honor the merge_timeout then provide the keyword argument
    # `ignore_timeout: false`.
    #
    # source://simplecov//lib/simplecov.rb#86
    def collate(result_filenames, profile = T.unsafe(nil), ignore_timeout: T.unsafe(nil), &block); end

    # Thinking: Move this behavior earlier so if there was an error we do nothing?
    #
    # @api private
    #
    # source://simplecov//lib/simplecov.rb#223
    def exit_and_report_previous_error(exit_status); end

    # Returns the exit status from the exit exception
    #
    # @api private
    #
    # source://simplecov//lib/simplecov.rb#200
    def exit_status_from_exception; end

    # Basically, should we take care of at_exit behavior or something else?
    # Used by the minitest plugin. See lib/minitest/simplecov_plugin.rb
    #
    # source://simplecov//lib/simplecov.rb#28
    def external_at_exit; end

    # Basically, should we take care of at_exit behavior or something else?
    # Used by the minitest plugin. See lib/minitest/simplecov_plugin.rb
    #
    # source://simplecov//lib/simplecov.rb#28
    def external_at_exit=(_arg0); end

    # Basically, should we take care of at_exit behavior or something else?
    # Used by the minitest plugin. See lib/minitest/simplecov_plugin.rb
    #
    # source://simplecov//lib/simplecov.rb#28
    def external_at_exit?; end

    # Applies the configured filters to the given array of SimpleCov::SourceFile items
    #
    # source://simplecov//lib/simplecov.rb#131
    def filtered(files); end

    # @api private
    # @return [Boolean]
    #
    # source://simplecov//lib/simplecov.rb#268
    def final_result_process?; end

    # Applies the configured groups to the given array of SimpleCov::SourceFile items
    #
    # source://simplecov//lib/simplecov.rb#142
    def grouped(files); end

    # source://simplecov//lib/simplecov.rb#162
    def load_adapter(name); end

    # Applies the profile of given name on SimpleCov configuration
    #
    # source://simplecov//lib/simplecov.rb#158
    def load_profile(name); end

    # Returns the value of attribute pid.
    #
    # source://simplecov//lib/simplecov.rb#24
    def pid; end

    # Sets the attribute pid
    #
    # @param value the value to set the attribute pid to.
    #
    # source://simplecov//lib/simplecov.rb#24
    def pid=(_arg0); end

    # @api private
    # @return [Boolean]
    #
    # source://simplecov//lib/simplecov.rb#213
    def previous_error?(error_exit_status); end

    # Usage:
    #   exit_status = SimpleCov.process_result(SimpleCov.result, exit_status)
    #
    # @api private
    #
    # source://simplecov//lib/simplecov.rb#248
    def process_result(result); end

    # source://simplecov//lib/simplecov.rb#233
    def process_results_and_report_error; end

    # @api private
    # @return [Boolean]
    #
    # source://simplecov//lib/simplecov.rb#229
    def ready_to_process_results?; end

    # Returns the result for the current coverage run, merging it across test suites
    # from cache using SimpleCov::ResultMerger if use_merging is activated (default)
    #
    # source://simplecov//lib/simplecov.rb#101
    def result; end

    # Returns nil if the result has not been computed
    # Otherwise, returns the result
    #
    # @return [Boolean]
    #
    # source://simplecov//lib/simplecov.rb#124
    def result?; end

    # source://simplecov//lib/simplecov.rb#256
    def result_exit_status(result); end

    # Rounding down to be extra strict, see #679
    #
    # @api private
    #
    # source://simplecov//lib/simplecov.rb#296
    def round_coverage(coverage); end

    # Called from at_exit block
    #
    # @api private
    #
    # source://simplecov//lib/simplecov.rb#186
    def run_exit_tasks!; end

    # Returns the value of attribute running.
    #
    # source://simplecov//lib/simplecov.rb#24
    def running; end

    # Sets the attribute running
    #
    # @param value the value to set the attribute running to.
    #
    # source://simplecov//lib/simplecov.rb#24
    def running=(_arg0); end

    # Sets up SimpleCov to run against your project.
    # You can optionally specify a profile to use as well as configuration with a block:
    #   SimpleCov.start
    #    OR
    #   SimpleCov.start 'rails' # using rails profile
    #    OR
    #   SimpleCov.start do
    #     add_filter 'test'
    #   end
    #     OR
    #   SimpleCov.start 'rails' do
    #     add_filter 'test'
    #   end
    #
    # Please check out the RDoc for SimpleCov::Configuration to find about available config options
    #
    # source://simplecov//lib/simplecov.rb#48
    def start(profile = T.unsafe(nil), &block); end

    # @api private
    #
    # source://simplecov//lib/simplecov.rb#276
    def wait_for_other_processes; end

    # @api private
    #
    # source://simplecov//lib/simplecov.rb#285
    def write_last_run(result); end

    private

    # Unite the result so it wouldn't matter what coverage type was called
    #
    # @return [Hash]
    #
    # source://simplecov//lib/simplecov.rb#399
    def adapt_coverage_result; end

    # Finds files that were to be tracked but were not loaded and initializes
    # the line-by-line coverage to zero (if relevant) or nil (comments / whitespace etc).
    #
    # source://simplecov//lib/simplecov.rb#371
    def add_not_loaded_files(result); end

    # source://simplecov//lib/simplecov.rb#302
    def initial_setup(profile, &block); end

    # source://simplecov//lib/simplecov.rb#363
    def lookup_corresponding_ruby_coverage_name(criterion); end

    # parallel_tests isn't always available, see: https://github.com/grosser/parallel_tests/issues/772
    #
    # source://simplecov//lib/simplecov.rb#425
    def make_parallel_tests_available; end

    # @return [Boolean]
    #
    # source://simplecov//lib/simplecov.rb#434
    def probably_running_parallel_tests?; end

    # Call steps that handle process coverage result
    #
    # @return [Hash]
    #
    # source://simplecov//lib/simplecov.rb#388
    def process_coverage_result; end

    # Filter coverage result
    # The result before filter also has result of coverage for files
    # are not related to the project like loaded gems coverage.
    #
    # @return [Hash]
    #
    # source://simplecov//lib/simplecov.rb#410
    def remove_useless_results; end

    # Initialize result with files that are not included by coverage
    # and added inside the config block
    #
    # @return [Hash]
    #
    # source://simplecov//lib/simplecov.rb#420
    def result_with_not_loaded_files; end

    # Trigger Coverage.start depends on given config coverage_criterion
    #
    # With Positive branch it supports all coverage measurement types
    # With Negative branch it supports only line coverage measurement type
    #
    # source://simplecov//lib/simplecov.rb#314
    def start_coverage_measurement; end

    # source://simplecov//lib/simplecov.rb#349
    def start_coverage_with_criteria; end
  end
end

# source://simplecov//lib/simplecov/filter.rb#77
class SimpleCov::ArrayFilter < ::SimpleCov::Filter
  # @return [ArrayFilter] a new instance of ArrayFilter
  #
  # source://simplecov//lib/simplecov/filter.rb#78
  def initialize(filter_argument); end

  # Returns true if any of the filters in the array match the given source file.
  # Configure this Filter like StringFilter.new(['some/path', /^some_regex/, Proc.new {|src_file| ... }])
  #
  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/filter.rb#88
  def matches?(source_files_list); end
end

# source://simplecov//lib/simplecov/filter.rb#71
class SimpleCov::BlockFilter < ::SimpleCov::Filter
  # Returns true if the block given when initializing this filter with BlockFilter.new {|src_file| ... }
  # returns true for the given source file.
  #
  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/filter.rb#72
  def matches?(source_file); end
end

# Functionally for combining coverage results
#
# source://simplecov//lib/simplecov/combine.rb#6
module SimpleCov::Combine
  private

  # Combine two coverage based on the given combiner_module.
  #
  # Combiners should always be called through this interface,
  # as it takes care of short-circuiting of one of the coverages is nil.
  #
  # @return [Hash]
  #
  # source://simplecov//lib/simplecov/combine.rb#16
  def combine(combiner_module, coverage_a, coverage_b); end

  # source://simplecov//lib/simplecov/combine.rb#22
  def empty_coverage?(coverage_a, coverage_b); end

  # source://simplecov//lib/simplecov/combine.rb#26
  def existing_coverage(coverage_a, coverage_b); end

  class << self
    # Combine two coverage based on the given combiner_module.
    #
    # Combiners should always be called through this interface,
    # as it takes care of short-circuiting of one of the coverages is nil.
    #
    # @return [Hash]
    #
    # source://simplecov//lib/simplecov/combine.rb#16
    def combine(combiner_module, coverage_a, coverage_b); end

    # @return [Boolean]
    #
    # source://simplecov//lib/simplecov/combine.rb#22
    def empty_coverage?(coverage_a, coverage_b); end

    # source://simplecov//lib/simplecov/combine.rb#26
    def existing_coverage(coverage_a, coverage_b); end
  end
end

# Combine different branch coverage results on single file.
#
# Should be called through `SimpleCov.combine`.
#
# source://simplecov//lib/simplecov/combine/branches_combiner.rb#9
module SimpleCov::Combine::BranchesCombiner
  private

  # Return merged branches or the existed brach if other is missing.
  #
  # Branches inside files are always same if they exist, the difference only in coverage count.
  # Branch coverage report for any conditional case is built from hash, it's key is a condition and
  # it's body is a hash << keys from condition and value is coverage rate >>.
  # ex: branches =>{ [:if, 3, 8, 6, 8, 36] => {[:then, 4, 8, 6, 8, 12] => 1, [:else, 5, 8, 6, 8, 36]=>2}, other conditions...}
  # We create copy of result and update it values depending on the combined branches coverage values.
  #
  # @return [Hash]
  #
  # source://simplecov//lib/simplecov/combine/branches_combiner.rb#23
  def combine(coverage_a, coverage_b); end

  class << self
    # Return merged branches or the existed brach if other is missing.
    #
    # Branches inside files are always same if they exist, the difference only in coverage count.
    # Branch coverage report for any conditional case is built from hash, it's key is a condition and
    # it's body is a hash << keys from condition and value is coverage rate >>.
    # ex: branches =>{ [:if, 3, 8, 6, 8, 36] => {[:then, 4, 8, 6, 8, 12] => 1, [:else, 5, 8, 6, 8, 36]=>2}, other conditions...}
    # We create copy of result and update it values depending on the combined branches coverage values.
    #
    # @return [Hash]
    #
    # source://simplecov//lib/simplecov/combine/branches_combiner.rb#23
    def combine(coverage_a, coverage_b); end
  end
end

# Handle combining two coverage results for same file
#
# Should be called through `SimpleCov.combine`.
#
# source://simplecov//lib/simplecov/combine/files_combiner.rb#9
module SimpleCov::Combine::FilesCombiner
  private

  # Combines the results for 2 coverages of a file.
  #
  # @return [Hash]
  #
  # source://simplecov//lib/simplecov/combine/files_combiner.rb#17
  def combine(coverage_a, coverage_b); end

  class << self
    # Combines the results for 2 coverages of a file.
    #
    # @return [Hash]
    #
    # source://simplecov//lib/simplecov/combine/files_combiner.rb#17
    def combine(coverage_a, coverage_b); end
  end
end

# Combine two different lines coverage results on same file
#
# Should be called through `SimpleCov.combine`.
#
# source://simplecov//lib/simplecov/combine/lines_combiner.rb#9
module SimpleCov::Combine::LinesCombiner
  private

  # source://simplecov//lib/simplecov/combine/lines_combiner.rb#12
  def combine(coverage_a, coverage_b); end

  # Return depends on coverage in a specific line
  #
  # Logic:
  #
  # => nil + 0 = nil
  # => nil + nil = nil
  # => int + int = int
  #
  # @param first_val [Integer || nil]
  # @param second_val [Integer || nil]
  # @return [Integer || nil]
  #
  # source://simplecov//lib/simplecov/combine/lines_combiner.rb#32
  def merge_line_coverage(first_val, second_val); end

  class << self
    # source://simplecov//lib/simplecov/combine/lines_combiner.rb#12
    def combine(coverage_a, coverage_b); end

    # Return depends on coverage in a specific line
    #
    # Logic:
    #
    # => nil + 0 = nil
    # => nil + nil = nil
    # => int + int = int
    #
    # @param first_val [Integer || nil]
    # @param second_val [Integer || nil]
    # @return [Integer || nil]
    #
    # source://simplecov//lib/simplecov/combine/lines_combiner.rb#32
    def merge_line_coverage(first_val, second_val); end
  end
end

# There might be reports from different kinds of tests,
# e.g. RSpec and Cucumber. We need to combine their results
# into unified one. This class does that.
# To unite the results on file basis, it leverages
# the combine of lines and branches inside each file within given results.
#
# source://simplecov//lib/simplecov/combine/results_combiner.rb#10
module SimpleCov::Combine::ResultsCombiner
  private

  # Combine process explanation
  # => ResultCombiner: define all present files between results and start combine on file level.
  # ==> FileCombiner: collect result of next combine levels lines and branches.
  # ===> LinesCombiner: combine lines results.
  # ===> BranchesCombiner: combine branches results.
  #
  # @return [Hash]
  #
  # source://simplecov//lib/simplecov/combine/results_combiner.rb#22
  def combine(*results); end

  # Combine two files coverage results
  #
  # @param coverage_a [Hash]
  # @param coverage_b [Hash]
  # @return [Hash]
  #
  # source://simplecov//lib/simplecov/combine/results_combiner.rb#55
  def combine_file_coverage(coverage_a, coverage_b); end

  # Manage combining results on files level
  #
  # @param combined_results [Hash]
  # @param result [Hash]
  # @return [Hash]
  #
  # source://simplecov//lib/simplecov/combine/results_combiner.rb#36
  def combine_result_sets(combined_results, result); end

  class << self
    # Combine process explanation
    # => ResultCombiner: define all present files between results and start combine on file level.
    # ==> FileCombiner: collect result of next combine levels lines and branches.
    # ===> LinesCombiner: combine lines results.
    # ===> BranchesCombiner: combine branches results.
    #
    # @return [Hash]
    #
    # source://simplecov//lib/simplecov/combine/results_combiner.rb#22
    def combine(*results); end

    # Combine two files coverage results
    #
    # @param coverage_a [Hash]
    # @param coverage_b [Hash]
    # @return [Hash]
    #
    # source://simplecov//lib/simplecov/combine/results_combiner.rb#55
    def combine_file_coverage(coverage_a, coverage_b); end

    # Manage combining results on files level
    #
    # @param combined_results [Hash]
    # @param result [Hash]
    # @return [Hash]
    #
    # source://simplecov//lib/simplecov/combine/results_combiner.rb#36
    def combine_result_sets(combined_results, result); end
  end
end

# Helper that tries to find out what test suite is running (for SimpleCov.command_name)
#
# source://simplecov//lib/simplecov/command_guesser.rb#7
module SimpleCov::CommandGuesser
  class << self
    # source://simplecov//lib/simplecov/command_guesser.rb#16
    def guess; end

    # Storage for the original command line call that invoked the test suite.
    # This has got to be stored as early as possible because i.e. rake and test/unit 2
    # have a habit of tampering with ARGV, which makes i.e. the automatic distinction
    # between rails unit/functional/integration tests impossible without this cached
    # item.
    #
    # source://simplecov//lib/simplecov/command_guesser.rb#14
    def original_run_command; end

    # Storage for the original command line call that invoked the test suite.
    # This has got to be stored as early as possible because i.e. rake and test/unit 2
    # have a habit of tampering with ARGV, which makes i.e. the automatic distinction
    # between rails unit/functional/integration tests impossible without this cached
    # item.
    #
    # source://simplecov//lib/simplecov/command_guesser.rb#14
    def original_run_command=(_arg0); end

    private

    # source://simplecov//lib/simplecov/command_guesser.rb#31
    def from_command_line_options; end

    # source://simplecov//lib/simplecov/command_guesser.rb#46
    def from_defined_constants; end

    # source://simplecov//lib/simplecov/command_guesser.rb#22
    def from_env; end
  end
end

# Bundles the configuration options used for SimpleCov. All methods
# defined here are usable from SimpleCov directly. Please check out
# SimpleCov documentation for further info.
#
# source://simplecov//lib/simplecov/configuration.rb#13
module SimpleCov::Configuration
  # source://simplecov//lib/simplecov/configuration.rb#161
  def adapters; end

  # Add a filter to the processing chain.
  # There are four ways to define a filter:
  #
  # * as a String that will then be matched against all source files' file paths,
  #     SimpleCov.add_filter 'app/models' # will reject all your models
  # * as a block which will be passed the source file in question and should either
  #   return a true or false value, depending on whether the file should be removed
  #     SimpleCov.add_filter do |src_file|
  #       File.basename(src_file.filename) == 'environment.rb'
  #     end # Will exclude environment.rb files from the results
  # * as an array of strings that are matched against all sorce files' file
  #   paths and then ignored (basically string filter multiple times)
  #     SimpleCov.add_filter ['app/models', 'app/helpers'] # ignores both dirs
  # * as an instance of a subclass of SimpleCov::Filter. See the documentation there
  #   on how to define your own filter classes
  #
  # source://simplecov//lib/simplecov/configuration.rb#367
  def add_filter(filter_argument = T.unsafe(nil), &filter_proc); end

  # Define a group for files. Works similar to add_filter, only that the first
  # argument is the desired group name and files PASSING the filter end up in the group
  # (while filters exclude when the filter is applicable).
  #
  # source://simplecov//lib/simplecov/configuration.rb#376
  def add_group(group_name, filter_argument = T.unsafe(nil), &filter_proc); end

  # Gets or sets the behavior to process coverage results.
  #
  # By default, it will call SimpleCov.result.format!
  #
  # Configure with:
  #
  #     SimpleCov.at_exit do
  #       puts "Coverage done"
  #       SimpleCov.result.format!
  #     end
  #
  # source://simplecov//lib/simplecov/configuration.rb#193
  def at_exit(&block); end

  # Gets or sets the behavior to start a new forked Process.
  #
  # By default, it will add " (Process #{pid})" to the command_name, and start SimpleCov in quiet mode
  #
  # Configure with:
  #
  #     SimpleCov.at_fork do |pid|
  #       SimpleCov.start do
  #         # This needs a unique name so it won't be ovewritten
  #         SimpleCov.command_name "#{SimpleCov.command_name} (subprocess: #{pid})"
  #         # be quiet, the parent process will be in charge of using the regular formatter and checking coverage totals
  #         SimpleCov.print_error_status = false
  #         SimpleCov.formatter SimpleCov::Formatter::SimpleFormatter
  #         SimpleCov.minimum_coverage 0
  #         # start
  #         SimpleCov.start
  #       end
  #     end
  #
  # source://simplecov//lib/simplecov/configuration.rb#233
  def at_fork(&block); end

  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/configuration.rb#428
  def branch_coverage?; end

  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/configuration.rb#443
  def branch_coverage_supported?; end

  # source://simplecov//lib/simplecov/configuration.rb#424
  def clear_coverage_criteria; end

  # The name of the command (a.k.a. Test Suite) currently running. Used for result
  # merging and caching. It first tries to make a guess based upon the command line
  # arguments the current test suite is running on and should automatically detect
  # unit tests, functional tests, integration tests, rpsec and cucumber and label
  # them properly. If it fails to recognize the current command, the command name
  # is set to the shell command that the current suite is running on.
  #
  # You can specify it manually with SimpleCov.command_name("test:units") - please
  # also check out the corresponding section in README.rdoc
  #
  # source://simplecov//lib/simplecov/configuration.rb#87
  def command_name(name = T.unsafe(nil)); end

  # Allows you to configure simplecov in a block instead of prepending SimpleCov to all config methods
  # you're calling.
  #
  #     SimpleCov.configure do
  #       add_filter 'foobar'
  #     end
  #
  # This is equivalent to SimpleCov.add_filter 'foobar' and thus makes it easier to set a bunch of configure
  # options at once.
  #
  # source://simplecov//lib/simplecov/configuration.rb#177
  def configure(&block); end

  # source://simplecov//lib/simplecov/configuration.rb#416
  def coverage_criteria; end

  # Define which coverage criterion should be evaluated.
  #
  # Possible coverage criteria:
  # * :line - coverage based on lines aka has this line been executed?
  # * :branch - coverage based on branches aka has this branch (think conditions) been executed?
  #
  # If not set the default is `:line`
  #
  # @param criterion [Symbol]
  #
  # source://simplecov//lib/simplecov/configuration.rb#393
  def coverage_criterion(criterion = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/configuration.rb#420
  def coverage_criterion_enabled?(criterion); end

  # The name of the output and cache directory. Defaults to 'coverage'
  #
  # Configure with SimpleCov.coverage_dir('cov')
  #
  # source://simplecov//lib/simplecov/configuration.rb#34
  def coverage_dir(dir = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/configuration.rb#452
  def coverage_for_eval_enabled?; end

  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/configuration.rb#447
  def coverage_for_eval_supported?; end

  # Returns the full path to the output directory using SimpleCov.root
  # and SimpleCov.coverage_dir, so you can adjust this by configuring those
  # values. Will create the directory if it's missing
  #
  # source://simplecov//lib/simplecov/configuration.rb#46
  def coverage_path; end

  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/configuration.rb#432
  def coverage_start_arguments_supported?; end

  # source://simplecov//lib/simplecov/configuration.rb#401
  def enable_coverage(criterion); end

  # source://simplecov//lib/simplecov/configuration.rb#456
  def enable_coverage_for_eval; end

  # gets or sets the enabled_for_subprocess configuration
  # when true, this will inject SimpleCov code into Process.fork
  #
  # source://simplecov//lib/simplecov/configuration.rb#202
  def enable_for_subprocesses(value = T.unsafe(nil)); end

  # gets the enabled_for_subprocess configuration
  #
  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/configuration.rb#209
  def enabled_for_subprocesses?; end

  # Returns the list of configured filters. Add filters using SimpleCov.add_filter.
  #
  # source://simplecov//lib/simplecov/configuration.rb#74
  def filters; end

  # Sets the attribute filters
  #
  # @param value the value to set the attribute filters to.
  #
  # source://simplecov//lib/simplecov/configuration.rb#14
  def filters=(_arg0); end

  # Gets or sets the configured formatter.
  #
  # Configure with: SimpleCov.formatter(SimpleCov::Formatter::SimpleFormatter)
  #
  # source://simplecov//lib/simplecov/configuration.rb#98
  def formatter(formatter = T.unsafe(nil)); end

  # Sets the attribute formatter
  #
  # @param value the value to set the attribute formatter to.
  #
  # source://simplecov//lib/simplecov/configuration.rb#14
  def formatter=(_arg0); end

  # Gets the configured formatters.
  #
  # source://simplecov//lib/simplecov/configuration.rb#117
  def formatters; end

  # Sets the configured formatters.
  #
  # source://simplecov//lib/simplecov/configuration.rb#110
  def formatters=(formatters); end

  # Returns the configured groups. Add groups using SimpleCov.add_group
  #
  # source://simplecov//lib/simplecov/configuration.rb#150
  def groups; end

  # Sets the attribute groups
  #
  # @param value the value to set the attribute groups to.
  #
  # source://simplecov//lib/simplecov/configuration.rb#14
  def groups=(_arg0); end

  # Defines the maximum coverage drop at once allowed for the testsuite to pass.
  # SimpleCov will return non-zero if the coverage decreases by more than this threshold.
  #
  # Default is 100% (disabled)
  #
  # source://simplecov//lib/simplecov/configuration.rb#313
  def maximum_coverage_drop(coverage_drop = T.unsafe(nil)); end

  # Defines the maximum age (in seconds) of a resultset to still be included in merged results.
  # i.e. If you run cucumber features, then later rake test, if the stored cucumber resultset is
  # more seconds ago than specified here, it won't be taken into account when merging (and is also
  # purged from the resultset cache)
  #
  # Of course, this only applies when merging is active (e.g. SimpleCov.use_merging is not false!)
  #
  # Default is 600 seconds (10 minutes)
  #
  # Configure with SimpleCov.merge_timeout(3600) # 1hr
  #
  # source://simplecov//lib/simplecov/configuration.rb#279
  def merge_timeout(seconds = T.unsafe(nil)); end

  # Defines the minimum overall coverage required for the testsuite to pass.
  # SimpleCov will return non-zero if the current coverage is below this threshold.
  #
  # Default is 0% (disabled)
  #
  # source://simplecov//lib/simplecov/configuration.rb#290
  def minimum_coverage(coverage = T.unsafe(nil)); end

  # Defines the minimum coverage per file required for the testsuite to pass.
  # SimpleCov will return non-zero if the current coverage of the least covered file
  # is below this threshold.
  #
  # Default is 0% (disabled)
  #
  # source://simplecov//lib/simplecov/configuration.rb#330
  def minimum_coverage_by_file(coverage = T.unsafe(nil)); end

  # Certain code blocks (i.e. Ruby-implementation specific code) can be excluded from
  # the coverage metrics by wrapping it inside # :nocov: comment blocks. The nocov token
  # can be configured to be any other string using this.
  #
  # Configure with SimpleCov.nocov_token('skip') or it's alias SimpleCov.skip_token('skip')
  #
  # source://simplecov//lib/simplecov/configuration.rb#140
  def nocov_token(nocov_token = T.unsafe(nil)); end

  # source://simplecov//lib/simplecov/configuration.rb#407
  def primary_coverage(criterion = T.unsafe(nil)); end

  # Whether we should print non-success status codes. This can be
  # configured with the #print_error_status= method.
  #
  # source://simplecov//lib/simplecov/configuration.rb#129
  def print_error_status; end

  # Sets the attribute print_error_status
  #
  # @param value the value to set the attribute print_error_status to.
  #
  # source://simplecov//lib/simplecov/configuration.rb#14
  def print_error_status=(_arg0); end

  # Returns the hash of available profiles
  #
  # source://simplecov//lib/simplecov/configuration.rb#157
  def profiles; end

  # Returns the project name - currently assuming the last dirname in
  # the SimpleCov.root is this.
  #
  # source://simplecov//lib/simplecov/configuration.rb#251
  def project_name(new_name = T.unsafe(nil)); end

  # source://simplecov//lib/simplecov/configuration.rb#300
  def raise_on_invalid_coverage(coverage, coverage_setting); end

  # Refuses any coverage drop. That is, coverage is only allowed to increase.
  # SimpleCov will return non-zero if the coverage decreases.
  #
  # source://simplecov//lib/simplecov/configuration.rb#344
  def refuse_coverage_drop(*criteria); end

  # The root for the project. This defaults to the
  # current working directory.
  #
  # Configure with SimpleCov.root('/my/project/path')
  #
  # source://simplecov//lib/simplecov/configuration.rb#22
  def root(root = T.unsafe(nil)); end

  # Certain code blocks (i.e. Ruby-implementation specific code) can be excluded from
  # the coverage metrics by wrapping it inside # :nocov: comment blocks. The nocov token
  # can be configured to be any other string using this.
  #
  # Configure with SimpleCov.nocov_token('skip') or it's alias SimpleCov.skip_token('skip')
  #
  # source://simplecov//lib/simplecov/configuration.rb#140
  def skip_token(nocov_token = T.unsafe(nil)); end

  # Coverage results will always include files matched by this glob, whether
  # or not they were explicitly required. Without this, un-required files
  # will not be present in the final report.
  #
  # source://simplecov//lib/simplecov/configuration.rb#59
  def track_files(glob); end

  # Returns the glob that will be used to include files that were not
  # explicitly required.
  #
  # source://simplecov//lib/simplecov/configuration.rb#67
  def tracked_files; end

  # Defines whether to use result merging so all your test suites (test:units, test:functionals, cucumber, ...)
  # are joined and combined into a single coverage report
  #
  # source://simplecov//lib/simplecov/configuration.rb#262
  def use_merging(use = T.unsafe(nil)); end

  private

  # source://simplecov//lib/simplecov/configuration.rb#483
  def minimum_possible_coverage_exceeded(coverage_option); end

  # The actual filter processor. Not meant for direct use
  #
  # source://simplecov//lib/simplecov/configuration.rb#490
  def parse_filter(filter_argument = T.unsafe(nil), &filter_proc); end

  # source://simplecov//lib/simplecov/configuration.rb#466
  def raise_if_criterion_disabled(criterion); end

  # source://simplecov//lib/simplecov/configuration.rb#475
  def raise_if_criterion_unsupported(criterion); end
end

# source://simplecov//lib/simplecov/configuration.rb#381
SimpleCov::Configuration::DEFAULT_COVERAGE_CRITERION = T.let(T.unsafe(nil), Symbol)

# source://simplecov//lib/simplecov/configuration.rb#380
SimpleCov::Configuration::SUPPORTED_COVERAGE_CRITERIA = T.let(T.unsafe(nil), Array)

# Holds the individual data of a coverage result.
#
# This is uniform across coverage criteria as they all have:
#
# * total - how many things to cover there are (total relevant loc/branches)
# * covered - how many of the coverables are hit
# * missed - how many of the coverables are missed
# * percent - percentage as covered/missed
# * strength - average hits per/coverable (will not exist for one shot lines format)
#
# source://simplecov//lib/simplecov/coverage_statistics.rb#13
class SimpleCov::CoverageStatistics
  # Requires only covered, missed and strength to be initialized.
  #
  # Other values are computed by this class.
  #
  # @return [CoverageStatistics] a new instance of CoverageStatistics
  #
  # source://simplecov//lib/simplecov/coverage_statistics.rb#34
  def initialize(covered:, missed:, total_strength: T.unsafe(nil)); end

  # Returns the value of attribute covered.
  #
  # source://simplecov//lib/simplecov/coverage_statistics.rb#14
  def covered; end

  # Returns the value of attribute missed.
  #
  # source://simplecov//lib/simplecov/coverage_statistics.rb#14
  def missed; end

  # Returns the value of attribute percent.
  #
  # source://simplecov//lib/simplecov/coverage_statistics.rb#14
  def percent; end

  # Returns the value of attribute strength.
  #
  # source://simplecov//lib/simplecov/coverage_statistics.rb#14
  def strength; end

  # Returns the value of attribute total.
  #
  # source://simplecov//lib/simplecov/coverage_statistics.rb#14
  def total; end

  private

  # source://simplecov//lib/simplecov/coverage_statistics.rb#44
  def compute_percent(covered, missed, total); end

  # source://simplecov//lib/simplecov/coverage_statistics.rb#50
  def compute_strength(total_strength, total); end

  class << self
    # source://simplecov//lib/simplecov/coverage_statistics.rb#16
    def from(coverage_statistics); end
  end
end

# source://simplecov//lib/simplecov/exit_codes.rb#4
module SimpleCov::ExitCodes; end

# source://simplecov//lib/simplecov/exit_codes.rb#6
SimpleCov::ExitCodes::EXCEPTION = T.let(T.unsafe(nil), Integer)

# source://simplecov//lib/simplecov/exit_codes/exit_code_handling.rb#5
module SimpleCov::ExitCodes::ExitCodeHandling
  private

  # source://simplecov//lib/simplecov/exit_codes/exit_code_handling.rb#8
  def call(result, coverage_limits:); end

  # source://simplecov//lib/simplecov/exit_codes/exit_code_handling.rb#20
  def coverage_checks(result, coverage_limits); end

  class << self
    # source://simplecov//lib/simplecov/exit_codes/exit_code_handling.rb#8
    def call(result, coverage_limits:); end

    # source://simplecov//lib/simplecov/exit_codes/exit_code_handling.rb#20
    def coverage_checks(result, coverage_limits); end
  end
end

# source://simplecov//lib/simplecov/exit_codes.rb#8
SimpleCov::ExitCodes::MAXIMUM_COVERAGE_DROP = T.let(T.unsafe(nil), Integer)

# source://simplecov//lib/simplecov/exit_codes.rb#7
SimpleCov::ExitCodes::MINIMUM_COVERAGE = T.let(T.unsafe(nil), Integer)

# source://simplecov//lib/simplecov/exit_codes/maximum_coverage_drop_check.rb#5
class SimpleCov::ExitCodes::MaximumCoverageDropCheck
  # @return [MaximumCoverageDropCheck] a new instance of MaximumCoverageDropCheck
  #
  # source://simplecov//lib/simplecov/exit_codes/maximum_coverage_drop_check.rb#6
  def initialize(result, maximum_coverage_drop); end

  # source://simplecov//lib/simplecov/exit_codes/maximum_coverage_drop_check.rb#28
  def exit_code; end

  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/exit_codes/maximum_coverage_drop_check.rb#11
  def failing?; end

  # source://simplecov//lib/simplecov/exit_codes/maximum_coverage_drop_check.rb#17
  def report; end

  private

  # source://simplecov//lib/simplecov/exit_codes/maximum_coverage_drop_check.rb#49
  def compute_coverage_drop_data; end

  # source://simplecov//lib/simplecov/exit_codes/maximum_coverage_drop_check.rb#42
  def coverage_drop_violations; end

  # source://simplecov//lib/simplecov/exit_codes/maximum_coverage_drop_check.rb#61
  def drop_percent(criterion); end

  # source://simplecov//lib/simplecov/exit_codes/maximum_coverage_drop_check.rb#73
  def last_coverage(criterion); end

  # source://simplecov//lib/simplecov/exit_codes/maximum_coverage_drop_check.rb#36
  def last_run; end

  # Returns the value of attribute maximum_coverage_drop.
  #
  # source://simplecov//lib/simplecov/exit_codes/maximum_coverage_drop_check.rb#34
  def maximum_coverage_drop; end

  # Returns the value of attribute result.
  #
  # source://simplecov//lib/simplecov/exit_codes/maximum_coverage_drop_check.rb#34
  def result; end
end

# if anyone says "max_coverage_drop 0.000000000000000001" I appologize. Please don't.
#
# source://simplecov//lib/simplecov/exit_codes/maximum_coverage_drop_check.rb#60
SimpleCov::ExitCodes::MaximumCoverageDropCheck::MAX_DROP_ACCURACY = T.let(T.unsafe(nil), Integer)

# source://simplecov//lib/simplecov/exit_codes/minimum_coverage_by_file_check.rb#5
class SimpleCov::ExitCodes::MinimumCoverageByFileCheck
  # @return [MinimumCoverageByFileCheck] a new instance of MinimumCoverageByFileCheck
  #
  # source://simplecov//lib/simplecov/exit_codes/minimum_coverage_by_file_check.rb#6
  def initialize(result, minimum_coverage_by_file); end

  # source://simplecov//lib/simplecov/exit_codes/minimum_coverage_by_file_check.rb#26
  def exit_code; end

  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/exit_codes/minimum_coverage_by_file_check.rb#11
  def failing?; end

  # source://simplecov//lib/simplecov/exit_codes/minimum_coverage_by_file_check.rb#15
  def report; end

  private

  # source://simplecov//lib/simplecov/exit_codes/minimum_coverage_by_file_check.rb#41
  def compute_minimum_coverage_data; end

  # Returns the value of attribute minimum_coverage_by_file.
  #
  # source://simplecov//lib/simplecov/exit_codes/minimum_coverage_by_file_check.rb#32
  def minimum_coverage_by_file; end

  # source://simplecov//lib/simplecov/exit_codes/minimum_coverage_by_file_check.rb#34
  def minimum_violations; end

  # Returns the value of attribute result.
  #
  # source://simplecov//lib/simplecov/exit_codes/minimum_coverage_by_file_check.rb#32
  def result; end
end

# source://simplecov//lib/simplecov/exit_codes/minimum_overall_coverage_check.rb#5
class SimpleCov::ExitCodes::MinimumOverallCoverageCheck
  # @return [MinimumOverallCoverageCheck] a new instance of MinimumOverallCoverageCheck
  #
  # source://simplecov//lib/simplecov/exit_codes/minimum_overall_coverage_check.rb#6
  def initialize(result, minimum_coverage); end

  # source://simplecov//lib/simplecov/exit_codes/minimum_overall_coverage_check.rb#26
  def exit_code; end

  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/exit_codes/minimum_overall_coverage_check.rb#11
  def failing?; end

  # source://simplecov//lib/simplecov/exit_codes/minimum_overall_coverage_check.rb#15
  def report; end

  private

  # source://simplecov//lib/simplecov/exit_codes/minimum_overall_coverage_check.rb#38
  def calculate_minimum_violations; end

  # Returns the value of attribute minimum_coverage.
  #
  # source://simplecov//lib/simplecov/exit_codes/minimum_overall_coverage_check.rb#32
  def minimum_coverage; end

  # source://simplecov//lib/simplecov/exit_codes/minimum_overall_coverage_check.rb#34
  def minimum_violations; end

  # Returns the value of attribute result.
  #
  # source://simplecov//lib/simplecov/exit_codes/minimum_overall_coverage_check.rb#32
  def result; end
end

# source://simplecov//lib/simplecov/exit_codes.rb#5
SimpleCov::ExitCodes::SUCCESS = T.let(T.unsafe(nil), Integer)

# An array of SimpleCov SourceFile instances with additional collection helper
# methods for calculating coverage across them etc.
#
# source://simplecov//lib/simplecov/file_list.rb#6
class SimpleCov::FileList
  include ::Enumerable
  extend ::Forwardable

  # @return [FileList] a new instance of FileList
  #
  # source://simplecov//lib/simplecov/file_list.rb#22
  def initialize(files); end

  # source://simplecov//lib/simplecov/file_list.rb#101
  def branch_covered_percent; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def count(*args, **_arg1, &block); end

  # source://simplecov//lib/simplecov/file_list.rb#26
  def coverage_statistics; end

  # source://simplecov//lib/simplecov/file_list.rb#30
  def coverage_statistics_by_file; end

  # Return total count of covered branches
  #
  # source://simplecov//lib/simplecov/file_list.rb#92
  def covered_branches; end

  # Returns the count of lines that have coverage
  #
  # source://simplecov//lib/simplecov/file_list.rb#35
  def covered_lines; end

  # Computes the coverage based upon lines covered and lines missed
  #
  # @return [Float]
  #
  # source://simplecov//lib/simplecov/file_list.rb#76
  def covered_percent; end

  # Computes the coverage based upon lines covered and lines missed for each file
  # Returns an array with all coverage percentages
  #
  # source://simplecov//lib/simplecov/file_list.rb#60
  def covered_percentages; end

  # Computes the strength (hits / line) based upon lines covered and lines missed
  #
  # @return [Float]
  #
  # source://simplecov//lib/simplecov/file_list.rb#82
  def covered_strength; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def each(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def empty?(*args, **_arg1, &block); end

  # Finds the least covered file and returns that file's name
  #
  # source://simplecov//lib/simplecov/file_list.rb#65
  def least_covered_file; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def length(*args, **_arg1, &block); end

  # Returns the overall amount of relevant lines of code across all files in this list
  #
  # source://simplecov//lib/simplecov/file_list.rb#70
  def lines_of_code; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def map(*args, **_arg1, &block); end

  # Return total count of covered branches
  #
  # source://simplecov//lib/simplecov/file_list.rb#97
  def missed_branches; end

  # Returns the count of lines that have been missed
  #
  # source://simplecov//lib/simplecov/file_list.rb#40
  def missed_lines; end

  # Returns the count of lines that are not relevant for coverage
  #
  # source://simplecov//lib/simplecov/file_list.rb#45
  def never_lines; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def size(*args, **_arg1, &block); end

  # Returns the count of skipped lines
  #
  # source://simplecov//lib/simplecov/file_list.rb#52
  def skipped_lines; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def to_a(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def to_ary(*args, **_arg1, &block); end

  # Return total count of branches in all files
  #
  # source://simplecov//lib/simplecov/file_list.rb#87
  def total_branches; end

  private

  # source://simplecov//lib/simplecov/file_list.rb#114
  def compute_coverage_statistics; end

  # source://simplecov//lib/simplecov/file_list.rb#107
  def compute_coverage_statistics_by_file; end
end

# Base filter class. Inherit from this to create custom filters,
# and overwrite the passes?(source_file) instance method
#
# # A sample class that rejects all source files.
# class StupidFilter < SimpleCov::Filter
#   def passes?(source_file)
#     false
#   end
# end
#
# source://simplecov//lib/simplecov/filter.rb#15
class SimpleCov::Filter
  # @return [Filter] a new instance of Filter
  #
  # source://simplecov//lib/simplecov/filter.rb#18
  def initialize(filter_argument); end

  # Returns the value of attribute filter_argument.
  #
  # source://simplecov//lib/simplecov/filter.rb#16
  def filter_argument; end

  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/filter.rb#22
  def matches?(_source_file); end

  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/filter.rb#26
  def passes?(source_file); end

  class << self
    # source://simplecov//lib/simplecov/filter.rb#31
    def build_filter(filter_argument); end

    # source://simplecov//lib/simplecov/filter.rb#37
    def class_for_argument(filter_argument); end
  end
end

# TODO: Documentation on how to build your own formatters
#
# source://simplecov//lib/simplecov/formatter/multi_formatter.rb#4
module SimpleCov::Formatter; end

# source://simplecov//lib/simplecov/formatter/multi_formatter.rb#5
class SimpleCov::Formatter::MultiFormatter
  class << self
    # source://simplecov//lib/simplecov/formatter/multi_formatter.rb#26
    def [](*args); end

    # source://simplecov//lib/simplecov/formatter/multi_formatter.rb#17
    def new(formatters = T.unsafe(nil)); end
  end
end

# source://simplecov//lib/simplecov/formatter/multi_formatter.rb#6
module SimpleCov::Formatter::MultiFormatter::InstanceMethods
  # source://simplecov//lib/simplecov/formatter/multi_formatter.rb#7
  def format(result); end
end

# A ridiculously simple formatter for SimpleCov results.
#
# source://simplecov//lib/simplecov/formatter/simple_formatter.rb#8
class SimpleCov::Formatter::SimpleFormatter
  # Takes a SimpleCov::Result and generates a string out of it
  #
  # source://simplecov//lib/simplecov/formatter/simple_formatter.rb#10
  def format(result); end
end

# source://simplecov//lib/simplecov/last_run.rb#6
module SimpleCov::LastRun
  class << self
    # source://simplecov//lib/simplecov/last_run.rb#8
    def last_run_path; end

    # source://simplecov//lib/simplecov/last_run.rb#12
    def read; end

    # source://simplecov//lib/simplecov/last_run.rb#21
    def write(json); end
  end
end

# Classifies whether lines are relevant for code coverage analysis.
# Comments & whitespace lines, and :nocov: token blocks, are considered not relevant.
#
# source://simplecov//lib/simplecov/lines_classifier.rb#7
class SimpleCov::LinesClassifier
  # source://simplecov//lib/simplecov/lines_classifier.rb#33
  def classify(lines); end

  class << self
    # source://simplecov//lib/simplecov/lines_classifier.rb#15
    def no_cov_line; end

    # @return [Boolean]
    #
    # source://simplecov//lib/simplecov/lines_classifier.rb#19
    def no_cov_line?(line); end

    # @return [Boolean]
    #
    # source://simplecov//lib/simplecov/lines_classifier.rb#26
    def whitespace_line?(line); end
  end
end

# source://simplecov//lib/simplecov/lines_classifier.rb#12
SimpleCov::LinesClassifier::COMMENT_LINE = T.let(T.unsafe(nil), Regexp)

# source://simplecov//lib/simplecov/lines_classifier.rb#9
SimpleCov::LinesClassifier::NOT_RELEVANT = T.let(T.unsafe(nil), T.untyped)

# source://simplecov//lib/simplecov/lines_classifier.rb#8
SimpleCov::LinesClassifier::RELEVANT = T.let(T.unsafe(nil), Integer)

# source://simplecov//lib/simplecov/lines_classifier.rb#11
SimpleCov::LinesClassifier::WHITESPACE_LINE = T.let(T.unsafe(nil), Regexp)

# source://simplecov//lib/simplecov/lines_classifier.rb#13
SimpleCov::LinesClassifier::WHITESPACE_OR_COMMENT_LINE = T.let(T.unsafe(nil), Regexp)

# Profiles are SimpleCov configuration procs that can be easily
# loaded using SimpleCov.start :rails and defined using
#   SimpleCov.profiles.define :foo do
#     # SimpleCov configuration here, same as in  SimpleCov.configure
#   end
#
# source://simplecov//lib/simplecov/profiles.rb#17
class SimpleCov::Profiles < ::Hash
  # Define a SimpleCov profile:
  #   SimpleCov.profiles.define 'rails' do
  #     # Same as SimpleCov.configure do .. here
  #   end
  #
  # source://simplecov//lib/simplecov/profiles.rb#18
  def define(name, &blk); end

  # Applies the profile of given name on SimpleCov.configure
  #
  # source://simplecov//lib/simplecov/profiles.rb#28
  def load(name); end
end

# source://simplecov//lib/simplecov/filter.rb#63
class SimpleCov::RegexFilter < ::SimpleCov::Filter
  # Returns true when the given source file's filename matches the
  # regex configured when initializing this Filter with RegexFilter.new(/someregex/)
  #
  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/filter.rb#64
  def matches?(source_file); end
end

# A simplecov code coverage result, initialized from the Hash Ruby's built-in coverage
# library generates (Coverage.result).
#
# source://simplecov//lib/simplecov/result.rb#11
class SimpleCov::Result
  extend ::Forwardable

  # Initialize a new SimpleCov::Result from given Coverage.result (a Hash of filenames each containing an array of
  # coverage data)
  #
  # @return [Result] a new instance of Result
  #
  # source://simplecov//lib/simplecov/result.rb#28
  def initialize(original_result, command_name: T.unsafe(nil), created_at: T.unsafe(nil)); end

  # The command name that launched this result.
  # Delegated to SimpleCov.command_name if not set manually
  #
  # source://simplecov//lib/simplecov/result.rb#61
  def command_name; end

  # Explicitly set the command name that was used for this coverage result. Defaults to SimpleCov.command_name
  #
  # source://simplecov//lib/simplecov/result.rb#21
  def command_name=(_arg0); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def coverage_statistics(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def coverage_statistics_by_file(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def covered_branches(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def covered_lines(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def covered_percent(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def covered_percentages(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def covered_strength(*args, **_arg1, &block); end

  # Defines when this result has been created. Defaults to Time.now
  #
  # source://simplecov//lib/simplecov/result.rb#55
  def created_at; end

  # Explicitly set the Time this result has been created
  #
  # source://simplecov//lib/simplecov/result.rb#19
  def created_at=(_arg0); end

  # Returns all filenames for source files contained in this result
  #
  # source://simplecov//lib/simplecov/result.rb#40
  def filenames; end

  # Returns all files that are applicable to this result (sans filters!) as instances of SimpleCov::SourceFile. Aliased as :source_files
  #
  # source://simplecov//lib/simplecov/result.rb#16
  def files; end

  # Applies the configured SimpleCov.formatter on this result
  #
  # source://simplecov//lib/simplecov/result.rb#50
  def format!; end

  # Returns a Hash of groups for this result. Define groups using SimpleCov.add_group 'Models', 'app/models'
  #
  # source://simplecov//lib/simplecov/result.rb#45
  def groups; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def least_covered_file(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def missed_branches(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def missed_lines(*args, **_arg1, &block); end

  # Returns the original Coverage.result used for this instance of SimpleCov::Result
  #
  # source://simplecov//lib/simplecov/result.rb#14
  def original_result; end

  # Returns all files that are applicable to this result (sans filters!) as instances of SimpleCov::SourceFile. Aliased as :source_files
  #
  # source://simplecov//lib/simplecov/result.rb#16
  def source_files; end

  # Returns a hash representation of this Result that can be used for marshalling it into JSON
  #
  # source://simplecov//lib/simplecov/result.rb#66
  def to_hash; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def total_branches(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def total_lines(*args, **_arg1, &block); end

  private

  # source://simplecov//lib/simplecov/result.rb#84
  def coverage; end

  # Applies all configured SimpleCov filters on this result's source files
  #
  # source://simplecov//lib/simplecov/result.rb#90
  def filter!; end

  class << self
    # Loads a SimpleCov::Result#to_hash dump
    #
    # source://simplecov//lib/simplecov/result.rb#76
    def from_hash(hash); end
  end
end

# Responsible for adapting the format of the coverage result whether it's default or with statistics
#
# source://simplecov//lib/simplecov/result_adapter.rb#7
class SimpleCov::ResultAdapter
  # @return [ResultAdapter] a new instance of ResultAdapter
  #
  # source://simplecov//lib/simplecov/result_adapter.rb#10
  def initialize(result); end

  # source://simplecov//lib/simplecov/result_adapter.rb#18
  def adapt; end

  # Returns the value of attribute result.
  #
  # source://simplecov//lib/simplecov/result_adapter.rb#8
  def result; end

  class << self
    # source://simplecov//lib/simplecov/result_adapter.rb#14
    def call(*args); end
  end
end

# Singleton that is responsible for caching, loading and merging
# SimpleCov::Results into a single result for coverage analysis based
# upon multiple test suites.
#
# source://simplecov//lib/simplecov/result_merger.rb#11
module SimpleCov::ResultMerger
  class << self
    # source://simplecov//lib/simplecov/result_merger.rb#187
    def adapt_pre_simplecov_0_18_result(result); end

    # We changed the format of the raw result data in simplecov, as people are likely
    # to have "old" resultsets lying around (but not too old so that they're still
    # considered we can adapt them).
    # See https://github.com/simplecov-ruby/simplecov/pull/824#issuecomment-576049747
    #
    # source://simplecov//lib/simplecov/result_merger.rb#172
    def adapt_result(result); end

    # source://simplecov//lib/simplecov/result_merger.rb#93
    def create_result(command_names, coverage); end

    # source://simplecov//lib/simplecov/result_merger.rb#22
    def merge_and_store(*file_paths, ignore_timeout: T.unsafe(nil)); end

    # source://simplecov//lib/simplecov/result_merger.rb#100
    def merge_coverage(*results); end

    # source://simplecov//lib/simplecov/result_merger.rb#28
    def merge_results(*file_paths, ignore_timeout: T.unsafe(nil)); end

    # source://simplecov//lib/simplecov/result_merger.rb#74
    def merge_valid_results(results, ignore_timeout: T.unsafe(nil)); end

    # Gets all SimpleCov::Results stored in resultset, merges them and produces a new
    # SimpleCov::Result with merged coverage data and the command_name
    # for the result consisting of a join on all source result's names
    #
    # source://simplecov//lib/simplecov/result_merger.rb#117
    def merged_result; end

    # source://simplecov//lib/simplecov/result_merger.rb#51
    def parse_file(path); end

    # source://simplecov//lib/simplecov/result_merger.rb#65
    def parse_json(content); end

    # pre 0.18 coverage data pointed from file directly to an array of line coverage
    #
    # @return [Boolean]
    #
    # source://simplecov//lib/simplecov/result_merger.rb#181
    def pre_simplecov_0_18_result?(result); end

    # source://simplecov//lib/simplecov/result_merger.rb#56
    def read_file(path); end

    # source://simplecov//lib/simplecov/result_merger.rb#126
    def read_resultset; end

    # The path to the .resultset.json cache file
    #
    # source://simplecov//lib/simplecov/result_merger.rb#14
    def resultset_path; end

    # source://simplecov//lib/simplecov/result_merger.rb#18
    def resultset_writelock; end

    # Saves the given SimpleCov::Result in the resultset cache
    #
    # source://simplecov//lib/simplecov/result_merger.rb#136
    def store_result(result); end

    # Ensure only one process is reading or writing the resultset at any
    # given time
    #
    # source://simplecov//lib/simplecov/result_merger.rb#153
    def synchronize_resultset; end

    # source://simplecov//lib/simplecov/result_merger.rb#89
    def time_since_result_creation(data); end

    # source://simplecov//lib/simplecov/result_merger.rb#46
    def valid_results(file_path, ignore_timeout: T.unsafe(nil)); end

    # @return [Boolean]
    #
    # source://simplecov//lib/simplecov/result_merger.rb#85
    def within_merge_timeout?(data); end
  end
end

# Responsible for producing file coverage metrics.
#
# source://simplecov//lib/simplecov/simulate_coverage.rb#7
module SimpleCov::SimulateCoverage
  private

  # Simulate normal file coverage report on
  # ruby 2.5 and return similar hash with lines and branches keys
  #
  # Happens when a file wasn't required but still tracked.
  #
  # @return [Hash]
  #
  # source://simplecov//lib/simplecov/simulate_coverage.rb#18
  def call(absolute_path); end

  class << self
    # Simulate normal file coverage report on
    # ruby 2.5 and return similar hash with lines and branches keys
    #
    # Happens when a file wasn't required but still tracked.
    #
    # @return [Hash]
    #
    # source://simplecov//lib/simplecov/simulate_coverage.rb#18
    def call(absolute_path); end
  end
end

# Representation of a source file including it's coverage data, source code,
# source lines and featuring helpers to interpret that data.
#
# source://simplecov//lib/simplecov/source_file/line.rb#4
class SimpleCov::SourceFile
  # @return [SourceFile] a new instance of SourceFile
  #
  # source://simplecov//lib/simplecov/source_file.rb#14
  def initialize(filename, coverage_data); end

  # Return all the branches inside current source file
  #
  # source://simplecov//lib/simplecov/source_file.rb#98
  def branches; end

  # source://simplecov//lib/simplecov/source_file.rb#106
  def branches_coverage_percent; end

  # source://simplecov//lib/simplecov/source_file.rb#142
  def branches_for_line(line_number); end

  # Return hash with key of line number and branch coverage count as value
  #
  # source://simplecov//lib/simplecov/source_file.rb#118
  def branches_report; end

  # The array of coverage data received from the Coverage.result
  #
  # source://simplecov//lib/simplecov/source_file.rb#12
  def coverage_data; end

  # source://simplecov//lib/simplecov/source_file.rb#32
  def coverage_statistics; end

  # Select the covered branches
  # Here we user tree schema because some conditions like case may have additional
  # else that is not in declared inside the code but given by default by coverage report
  #
  # @return [Array]
  #
  # source://simplecov//lib/simplecov/source_file.rb#129
  def covered_branches; end

  # Returns all covered lines as SimpleCov::SourceFile::Line
  #
  # source://simplecov//lib/simplecov/source_file.rb#48
  def covered_lines; end

  # The coverage for this file in percent. 0 if the file has no coverage lines
  #
  # source://simplecov//lib/simplecov/source_file.rb#80
  def covered_percent; end

  # source://simplecov//lib/simplecov/source_file.rb#84
  def covered_strength; end

  # The full path to this source file (e.g. /User/colszowka/projects/simplecov/lib/simplecov/source_file.rb)
  #
  # source://simplecov//lib/simplecov/source_file.rb#10
  def filename; end

  # Access SimpleCov::SourceFile::Line source lines by line number
  #
  # source://simplecov//lib/simplecov/source_file.rb#75
  def line(number); end

  # Check if any branches missing on given line number
  #
  # @param line_number [Integer]
  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/source_file.rb#153
  def line_with_missed_branch?(line_number); end

  # Returns all source lines for this file as instances of SimpleCov::SourceFile::Line,
  # and thus including coverage data. Aliased as :source_lines
  #
  # source://simplecov//lib/simplecov/source_file.rb#42
  def lines; end

  # Returns the number of relevant lines (covered + missed)
  #
  # source://simplecov//lib/simplecov/source_file.rb#70
  def lines_of_code; end

  # Select the missed branches with coverage equal to zero
  #
  # @return [Array]
  #
  # source://simplecov//lib/simplecov/source_file.rb#138
  def missed_branches; end

  # Returns all lines that should have been, but were not covered
  # as instances of SimpleCov::SourceFile::Line
  #
  # source://simplecov//lib/simplecov/source_file.rb#54
  def missed_lines; end

  # Returns all lines that are not relevant for coverage as
  # SimpleCov::SourceFile::Line instances
  #
  # source://simplecov//lib/simplecov/source_file.rb#60
  def never_lines; end

  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/source_file.rb#102
  def no_branches?; end

  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/source_file.rb#88
  def no_lines?; end

  # The path to this source file relative to the projects directory
  #
  # source://simplecov//lib/simplecov/source_file.rb#20
  def project_filename; end

  # source://simplecov//lib/simplecov/source_file.rb#92
  def relevant_lines; end

  # Returns all lines that were skipped as SimpleCov::SourceFile::Line instances
  #
  # source://simplecov//lib/simplecov/source_file.rb#65
  def skipped_lines; end

  # The source code for this file. Aliased as :source
  #
  # source://simplecov//lib/simplecov/source_file.rb#25
  def source; end

  # Returns all source lines for this file as instances of SimpleCov::SourceFile::Line,
  # and thus including coverage data. Aliased as :source_lines
  #
  # source://simplecov//lib/simplecov/source_file.rb#42
  def source_lines; end

  # The source code for this file. Aliased as :source
  #
  # source://simplecov//lib/simplecov/source_file.rb#25
  def src; end

  # Return the relevant branches to source file
  #
  # source://simplecov//lib/simplecov/source_file.rb#112
  def total_branches; end

  private

  # source://simplecov//lib/simplecov/source_file.rb#346
  def branch_coverage_statistics; end

  # source://simplecov//lib/simplecov/source_file.rb#324
  def build_branch(branch_data, hit_count, condition_start_line); end

  # Call recursive method that transform our static hash to array of objects
  #
  # @return [Array]
  #
  # source://simplecov//lib/simplecov/source_file.rb#273
  def build_branches; end

  # source://simplecov//lib/simplecov/source_file.rb#310
  def build_branches_from(condition, branches); end

  # Build full branches report
  # Root branches represent the wrapper of all condition state that
  # have inside the branches
  #
  # @return [Hash]
  #
  # source://simplecov//lib/simplecov/source_file.rb#262
  def build_branches_report; end

  # source://simplecov//lib/simplecov/source_file.rb#229
  def build_lines; end

  # source://simplecov//lib/simplecov/source_file.rb#164
  def build_no_cov_chunks; end

  # Warning to identify condition from Issue #56
  #
  # source://simplecov//lib/simplecov/source_file.rb#251
  def coverage_exceeding_source_warn; end

  # source://simplecov//lib/simplecov/source_file.rb#214
  def ensure_remove_undefs(file_lines); end

  # source://simplecov//lib/simplecov/source_file.rb#336
  def line_coverage_statistics; end

  # source://simplecov//lib/simplecov/source_file.rb#246
  def lines_strength; end

  # source://simplecov//lib/simplecov/source_file.rb#178
  def load_source; end

  # no_cov_chunks is zero indexed to work directly with the array holding the lines
  #
  # source://simplecov//lib/simplecov/source_file.rb#160
  def no_cov_chunks; end

  # source://simplecov//lib/simplecov/source_file.rb#282
  def process_skipped_branches(branches); end

  # source://simplecov//lib/simplecov/source_file.rb#237
  def process_skipped_lines(lines); end

  # source://simplecov//lib/simplecov/source_file.rb#198
  def read_lines(file, lines, current_line); end

  # Since we are dumping to and loading from JSON, and we have arrays as keys those
  # don't make their way back to us intact e.g. just as a string
  #
  # We should probably do something different here, but as it stands these are
  # our data structures that we write so eval isn't _too_ bad.
  #
  # See #801
  #
  # source://simplecov//lib/simplecov/source_file.rb#300
  def restore_ruby_data_structure(structure); end

  # source://simplecov//lib/simplecov/source_file.rb#206
  def set_encoding_based_on_magic_comment(file, line); end

  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/source_file.rb#194
  def shebang?(line); end
end

# Representing single branch that has been detected in coverage report.
# Give us support methods that handle needed calculations.
#
# source://simplecov//lib/simplecov/source_file/branch.rb#8
class SimpleCov::SourceFile::Branch
  # @return [Branch] a new instance of Branch
  #
  # source://simplecov//lib/simplecov/source_file/branch.rb#12
  def initialize(start_line:, end_line:, coverage:, inline:, type:); end

  # Returns the value of attribute coverage.
  #
  # source://simplecov//lib/simplecov/source_file/branch.rb#9
  def coverage; end

  # Return true if there is relevant count defined > 0
  #
  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/source_file/branch.rb#31
  def covered?; end

  # Returns the value of attribute end_line.
  #
  # source://simplecov//lib/simplecov/source_file/branch.rb#9
  def end_line; end

  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/source_file/branch.rb#22
  def inline?; end

  # Check if branche missed or not
  #
  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/source_file/branch.rb#40
  def missed?; end

  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/source_file/branch.rb#70
  def overlaps_with?(line_range); end

  # Return array with coverage count and badge
  #
  # @return [Array]
  #
  # source://simplecov//lib/simplecov/source_file/branch.rb#79
  def report; end

  # The line on which we want to report the coverage
  #
  # Usually we choose the line above the start of the branch (so that it shows up
  # at if/else) because that
  # * highlights the condition
  # * makes it distinguishable if the first line of the branch is an inline branch
  #   (see the nested_branches fixture)
  #
  # source://simplecov//lib/simplecov/source_file/branch.rb#52
  def report_line; end

  # Flags the branch as skipped
  #
  # source://simplecov//lib/simplecov/source_file/branch.rb#61
  def skipped!; end

  # Returns true if the branch was marked skipped by virtue of nocov comments.
  #
  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/source_file/branch.rb#66
  def skipped?; end

  # Returns the value of attribute start_line.
  #
  # source://simplecov//lib/simplecov/source_file/branch.rb#9
  def start_line; end

  # Returns the value of attribute type.
  #
  # source://simplecov//lib/simplecov/source_file/branch.rb#9
  def type; end
end

# Representation of a single line in a source file including
# this specific line's source code, line_number and code coverage,
# with the coverage being either nil (coverage not applicable, e.g. comment
# line), 0 (line not covered) or >1 (the amount of times the line was
# executed)
#
# source://simplecov//lib/simplecov/source_file/line.rb#10
class SimpleCov::SourceFile::Line
  # @raise [ArgumentError]
  # @return [Line] a new instance of Line
  #
  # source://simplecov//lib/simplecov/source_file/line.rb#25
  def initialize(src, line_number, coverage); end

  # The coverage data for this line: either nil (never), 0 (missed) or >=1 (times covered)
  #
  # source://simplecov//lib/simplecov/source_file/line.rb#16
  def coverage; end

  # Returns true if this is a line that has been covered
  #
  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/source_file/line.rb#42
  def covered?; end

  # The line number in the source file. Aliased as :line, :number
  #
  # source://simplecov//lib/simplecov/source_file/line.rb#14
  def line; end

  # The line number in the source file. Aliased as :line, :number
  #
  # source://simplecov//lib/simplecov/source_file/line.rb#14
  def line_number; end

  # Returns true if this is a line that should have been covered, but was not
  #
  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/source_file/line.rb#37
  def missed?; end

  # Returns true if this line is not relevant for coverage
  #
  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/source_file/line.rb#47
  def never?; end

  # The line number in the source file. Aliased as :line, :number
  #
  # source://simplecov//lib/simplecov/source_file/line.rb#14
  def number; end

  # Whether this line was skipped
  #
  # source://simplecov//lib/simplecov/source_file/line.rb#18
  def skipped; end

  # Flags this line as skipped
  #
  # source://simplecov//lib/simplecov/source_file/line.rb#52
  def skipped!; end

  # Returns true if this line was skipped, false otherwise. Lines are skipped if they are wrapped with
  # # :nocov: comment lines.
  #
  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/source_file/line.rb#58
  def skipped?; end

  # The source code for this line. Aliased as :source
  # Lets grab some fancy aliases, shall we?
  #
  # source://simplecov//lib/simplecov/source_file/line.rb#12
  def source; end

  # The source code for this line. Aliased as :source
  #
  # source://simplecov//lib/simplecov/source_file/line.rb#12
  def src; end

  # The status of this line - either covered, missed, skipped or never. Useful i.e. for direct use
  # as a css class in report generation
  #
  # source://simplecov//lib/simplecov/source_file/line.rb#64
  def status; end
end

# source://simplecov//lib/simplecov/source_file.rb#205
SimpleCov::SourceFile::RUBY_FILE_ENCODING_MAGIC_COMMENT_REGEX = T.let(T.unsafe(nil), Regexp)

# source://simplecov//lib/simplecov/source_file.rb#193
SimpleCov::SourceFile::SHEBANG_REGEX = T.let(T.unsafe(nil), Regexp)

# source://simplecov//lib/simplecov/filter.rb#55
class SimpleCov::StringFilter < ::SimpleCov::Filter
  # Returns true when the given source file's filename matches the
  # string configured when initializing this Filter with StringFilter.new('somestring')
  #
  # @return [Boolean]
  #
  # source://simplecov//lib/simplecov/filter.rb#56
  def matches?(source_file); end
end

# Select the files that related to working scope directory of SimpleCov
#
# source://simplecov//lib/simplecov/useless_results_remover.rb#7
module SimpleCov::UselessResultsRemover
  class << self
    # source://simplecov//lib/simplecov/useless_results_remover.rb#8
    def call(coverage_result); end

    # source://simplecov//lib/simplecov/useless_results_remover.rb#14
    def root_regx; end
  end
end

# source://simplecov//lib/simplecov/version.rb#4
SimpleCov::VERSION = T.let(T.unsafe(nil), String)
